/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOST_MPLAYFITYPES_HEADER
#define MOST_MPLAYFITYPES_HEADER


class most_mplayfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MOST_MPlay_FI message types

fi_tclMessageBase* most_mplayfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class most_mplayfi_tclMsgBaseMessage : public most_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   most_mplayfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

// base class for all most_mplayfi standard error messages

class most_mplayfi_tclMsgDefaultError: public most_mplayfi_tclMsgBaseMessage
{
public:
   // member variables
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   
   most_mplayfi_tclMsgDefaultError() : e8ErrorCode(), oErrorInfo() {};
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDefaultError(const most_mplayfi_tclMsgDefaultError& coRef);
   most_mplayfi_tclMsgDefaultError& operator=(const most_mplayfi_tclMsgDefaultError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
};

//=============================================================================

class most_mplayfi_tclMsgStoreFavoriteMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgStoreFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgStoreFavoriteMethodStart& operator=(const most_mplayfi_tclMsgStoreFavoriteMethodStart& coRef);
   most_mplayfi_tclMsgStoreFavoriteMethodStart(const most_mplayfi_tclMsgStoreFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ObjectID;
   virtual ~most_mplayfi_tclMsgStoreFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgStoreFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgStoreFavoriteError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgStoreFavoriteError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgStoreFavoriteError& operator=(const most_mplayfi_tclMsgStoreFavoriteError& coRef);
   most_mplayfi_tclMsgStoreFavoriteError(const most_mplayfi_tclMsgStoreFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgStoreFavoriteError();

   tBool operator==(const most_mplayfi_tclMsgStoreFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgStoreFavoriteMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgStoreFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgStoreFavoriteMethodResult& operator=(const most_mplayfi_tclMsgStoreFavoriteMethodResult& coRef);
   most_mplayfi_tclMsgStoreFavoriteMethodResult(const most_mplayfi_tclMsgStoreFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_mplayfi_tclMsgStoreFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgStoreFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActivateFavoriteMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActivateFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActivateFavoriteMethodStart& operator=(const most_mplayfi_tclMsgActivateFavoriteMethodStart& coRef);
   most_mplayfi_tclMsgActivateFavoriteMethodStart(const most_mplayfi_tclMsgActivateFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   most_fi_tcl_e8_FavPrvAudioChannel e8AudioChannel;
   most_fi_tcl_e8_FavPrvVideoChannel e8VideoChannel;
   virtual ~most_mplayfi_tclMsgActivateFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgActivateFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActivateFavoriteError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgActivateFavoriteError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActivateFavoriteError& operator=(const most_mplayfi_tclMsgActivateFavoriteError& coRef);
   most_mplayfi_tclMsgActivateFavoriteError(const most_mplayfi_tclMsgActivateFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgActivateFavoriteError();

   tBool operator==(const most_mplayfi_tclMsgActivateFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActivateFavoriteMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActivateFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActivateFavoriteMethodResult& operator=(const most_mplayfi_tclMsgActivateFavoriteMethodResult& coRef);
   most_mplayfi_tclMsgActivateFavoriteMethodResult(const most_mplayfi_tclMsgActivateFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   tU32 u32ActivationHandle;
   virtual ~most_mplayfi_tclMsgActivateFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgActivateFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeleteFavoriteMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgDeleteFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeleteFavoriteMethodStart& operator=(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& coRef);
   most_mplayfi_tclMsgDeleteFavoriteMethodStart(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_mplayfi_tclMsgDeleteFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeleteFavoriteError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgDeleteFavoriteError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeleteFavoriteError& operator=(const most_mplayfi_tclMsgDeleteFavoriteError& coRef);
   most_mplayfi_tclMsgDeleteFavoriteError(const most_mplayfi_tclMsgDeleteFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgDeleteFavoriteError();

   tBool operator==(const most_mplayfi_tclMsgDeleteFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeleteFavoriteMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgDeleteFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeleteFavoriteMethodResult& operator=(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& coRef);
   most_mplayfi_tclMsgDeleteFavoriteMethodResult(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_mplayfi_tclMsgDeleteFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetFavoriteInfoMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetFavoriteInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetFavoriteInfoMethodStart& operator=(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& coRef);
   most_mplayfi_tclMsgGetFavoriteInfoMethodStart(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_mplayfi_tclMsgGetFavoriteInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetFavoriteInfoError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgGetFavoriteInfoError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetFavoriteInfoError& operator=(const most_mplayfi_tclMsgGetFavoriteInfoError& coRef);
   most_mplayfi_tclMsgGetFavoriteInfoError(const most_mplayfi_tclMsgGetFavoriteInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgGetFavoriteInfoError();

   tBool operator==(const most_mplayfi_tclMsgGetFavoriteInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetFavoriteInfoMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetFavoriteInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetFavoriteInfoMethodResult& operator=(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& coRef);
   most_mplayfi_tclMsgGetFavoriteInfoMethodResult(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumItems;
   most_fi_tcl_FavPrvFavoriteInfo oFavoriteInfo;
   virtual ~most_mplayfi_tclMsgGetFavoriteInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgResetFavoritesMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgResetFavoritesMethodStart();

   virtual ~most_mplayfi_tclMsgResetFavoritesMethodStart();

   inline tBool operator==(const most_mplayfi_tclMsgResetFavoritesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgResetFavoritesError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgResetFavoritesError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgResetFavoritesError& operator=(const most_mplayfi_tclMsgResetFavoritesError& coRef);
   most_mplayfi_tclMsgResetFavoritesError(const most_mplayfi_tclMsgResetFavoritesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgResetFavoritesError();

   tBool operator==(const most_mplayfi_tclMsgResetFavoritesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgResetFavoritesMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgResetFavoritesMethodResult();

   virtual ~most_mplayfi_tclMsgResetFavoritesMethodResult();

   inline tBool operator==(const most_mplayfi_tclMsgResetFavoritesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgAllocateMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgAllocateMethodStart& operator=(const most_mplayfi_tclMsgAllocateMethodStart& coRef);
   most_mplayfi_tclMsgAllocateMethodStart(const most_mplayfi_tclMsgAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_mplayfi_tclMsgAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgAllocateError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgAllocateError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgAllocateError& operator=(const most_mplayfi_tclMsgAllocateError& coRef);
   most_mplayfi_tclMsgAllocateError(const most_mplayfi_tclMsgAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgAllocateError();

   tBool operator==(const most_mplayfi_tclMsgAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgAllocateMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgAllocateMethodResult& operator=(const most_mplayfi_tclMsgAllocateMethodResult& coRef);
   most_mplayfi_tclMsgAllocateMethodResult(const most_mplayfi_tclMsgAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   virtual ~most_mplayfi_tclMsgAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeAllocateMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgDeAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeAllocateMethodStart& operator=(const most_mplayfi_tclMsgDeAllocateMethodStart& coRef);
   most_mplayfi_tclMsgDeAllocateMethodStart(const most_mplayfi_tclMsgDeAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_mplayfi_tclMsgDeAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgDeAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeAllocateError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgDeAllocateError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeAllocateError& operator=(const most_mplayfi_tclMsgDeAllocateError& coRef);
   most_mplayfi_tclMsgDeAllocateError(const most_mplayfi_tclMsgDeAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgDeAllocateError();

   tBool operator==(const most_mplayfi_tclMsgDeAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgDeAllocateMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgDeAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgDeAllocateMethodResult& operator=(const most_mplayfi_tclMsgDeAllocateMethodResult& coRef);
   most_mplayfi_tclMsgDeAllocateMethodResult(const most_mplayfi_tclMsgDeAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_mplayfi_tclMsgDeAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgDeAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceActivityMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceActivityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceActivityMethodStart& operator=(const most_mplayfi_tclMsgSourceActivityMethodStart& coRef);
   most_mplayfi_tclMsgSourceActivityMethodStart(const most_mplayfi_tclMsgSourceActivityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_mplayfi_tclMsgSourceActivityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSourceActivityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceActivityError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgSourceActivityError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceActivityError& operator=(const most_mplayfi_tclMsgSourceActivityError& coRef);
   most_mplayfi_tclMsgSourceActivityError(const most_mplayfi_tclMsgSourceActivityError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgSourceActivityError();

   tBool operator==(const most_mplayfi_tclMsgSourceActivityError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceActivityMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceActivityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceActivityMethodResult& operator=(const most_mplayfi_tclMsgSourceActivityMethodResult& coRef);
   most_mplayfi_tclMsgSourceActivityMethodResult(const most_mplayfi_tclMsgSourceActivityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_mplayfi_tclMsgSourceActivityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSourceActivityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU32 u32FilterTag4;
   tBool bAutoPlay;
   tU8 u8DeviceTag;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError();

   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU8 u8DeviceTag;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerIndexedListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerIndexedListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListError(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgCreateMediaPlayerIndexedListError();

   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError();

   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayMediaObjects oMediaObjects;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& operator=(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& coRef);
   most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgReleaseMediaPlayerListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgReleaseMediaPlayerListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgReleaseMediaPlayerListError& operator=(const most_mplayfi_tclMsgReleaseMediaPlayerListError& coRef);
   most_mplayfi_tclMsgReleaseMediaPlayerListError(const most_mplayfi_tclMsgReleaseMediaPlayerListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgReleaseMediaPlayerListError();

   tBool operator==(const most_mplayfi_tclMsgReleaseMediaPlayerListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestPlaybackActionMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestPlaybackActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestPlaybackActionMethodStart& operator=(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& coRef);
   most_mplayfi_tclMsgRequestPlaybackActionMethodStart(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayAction e8Action;
   tU8 u8NextPrevSkipCount;
   virtual ~most_mplayfi_tclMsgRequestPlaybackActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestPlaybackActionError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestPlaybackActionError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestPlaybackActionError& operator=(const most_mplayfi_tclMsgRequestPlaybackActionError& coRef);
   most_mplayfi_tclMsgRequestPlaybackActionError(const most_mplayfi_tclMsgRequestPlaybackActionError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestPlaybackActionError();

   tBool operator==(const most_mplayfi_tclMsgRequestPlaybackActionError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSeekToMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSeekToMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSeekToMethodStart& operator=(const most_mplayfi_tclMsgSeekToMethodStart& coRef);
   most_mplayfi_tclMsgSeekToMethodStart(const most_mplayfi_tclMsgSeekToMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32PlaypointPosition;
   most_fi_tcl_e8_MPlayPlaypointFormat e8PlaypointFormat;
   virtual ~most_mplayfi_tclMsgSeekToMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSeekToMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSeekToError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgSeekToError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSeekToError& operator=(const most_mplayfi_tclMsgSeekToError& coRef);
   most_mplayfi_tclMsgSeekToError(const most_mplayfi_tclMsgSeekToError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgSeekToError();

   tBool operator==(const most_mplayfi_tclMsgSeekToError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sAlbumArt;
   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtError& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtError(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtError();

   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayImageData oImageData;
   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef);
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& coRef);
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError();

   tBool operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef);
   most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   most_fi_tcl_MPlaySearchKeyboardList oSearchKeyboardList;
   virtual ~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectMethodStart& operator=(const most_mplayfi_tclMsgGetMediaObjectMethodStart& coRef);
   most_mplayfi_tclMsgGetMediaObjectMethodStart(const most_mplayfi_tclMsgGetMediaObjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Tag;
   most_fi_tcl_e8_MPlayCategoryType e8CategoryType;
   virtual ~most_mplayfi_tclMsgGetMediaObjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgGetMediaObjectError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectError& operator=(const most_mplayfi_tclMsgGetMediaObjectError& coRef);
   most_mplayfi_tclMsgGetMediaObjectError(const most_mplayfi_tclMsgGetMediaObjectError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgGetMediaObjectError();

   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectMethodResult& operator=(const most_mplayfi_tclMsgGetMediaObjectMethodResult& coRef);
   most_mplayfi_tclMsgGetMediaObjectMethodResult(const most_mplayfi_tclMsgGetMediaObjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayMediaObject oMediaObject;
   virtual ~most_mplayfi_tclMsgGetMediaObjectMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sPath;
   tU8 u8DeviceTag;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerFileListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerFileListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerFileListError& operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerFileListError(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgCreateMediaPlayerFileListError();

   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   tU32 u32TotalNumFiles;
   tU32 u32TotalNumFolders;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError();

   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayFileList oFileList;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sFilename;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError();

   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef);
   most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError();

   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayFileList oFileList;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError();

   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef);
   most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayMediaObjects oMediaObjects;
   virtual ~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sAlbumArt;
   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError();

   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef);
   most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sMIMEImageSubtype;
   tU32 u32PhotoSize;
   virtual ~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgTransferTagsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsMethodStart& operator=(const most_mplayfi_tclMsgTransferTagsMethodStart& coRef);
   most_mplayfi_tclMsgTransferTagsMethodStart(const most_mplayfi_tclMsgTransferTagsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   most_fi_tcl_MPlayTagTransfer_1 oTagTransfer;
   virtual ~most_mplayfi_tclMsgTransferTagsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgTransferTagsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgTransferTagsError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsError& operator=(const most_mplayfi_tclMsgTransferTagsError& coRef);
   most_mplayfi_tclMsgTransferTagsError(const most_mplayfi_tclMsgTransferTagsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgTransferTagsError();

   tBool operator==(const most_mplayfi_tclMsgTransferTagsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgTransferTagsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsMethodResult& operator=(const most_mplayfi_tclMsgTransferTagsMethodResult& coRef);
   most_mplayfi_tclMsgTransferTagsMethodResult(const most_mplayfi_tclMsgTransferTagsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   most_fi_tcl_e8_MPlayTagTransferStatus e8TagTransferStatus;
   most_fi_tcl_MPlayUntransferredTagStream oUntransferredTagStream;
   virtual ~most_mplayfi_tclMsgTransferTagsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgTransferTagsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef);
   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Tag;
   tBool bAutoPlay;
   virtual ~most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayMediaPlayerObjectError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlayMediaPlayerObjectError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayMediaPlayerObjectError& operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& coRef);
   most_mplayfi_tclMsgPlayMediaPlayerObjectError(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlayMediaPlayerObjectError();

   tBool operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef);
   most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayItemFromListMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlayItemFromListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayItemFromListMethodStart& operator=(const most_mplayfi_tclMsgPlayItemFromListMethodStart& coRef);
   most_mplayfi_tclMsgPlayItemFromListMethodStart(const most_mplayfi_tclMsgPlayItemFromListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32StartIndex;
   tU32 u32StartOffset;
   virtual ~most_mplayfi_tclMsgPlayItemFromListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlayItemFromListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayItemFromListError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlayItemFromListError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayItemFromListError& operator=(const most_mplayfi_tclMsgPlayItemFromListError& coRef);
   most_mplayfi_tclMsgPlayItemFromListError(const most_mplayfi_tclMsgPlayItemFromListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlayItemFromListError();

   tBool operator==(const most_mplayfi_tclMsgPlayItemFromListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayItemFromListMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlayItemFromListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayItemFromListMethodResult& operator=(const most_mplayfi_tclMsgPlayItemFromListMethodResult& coRef);
   most_mplayfi_tclMsgPlayItemFromListMethodResult(const most_mplayfi_tclMsgPlayItemFromListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~most_mplayfi_tclMsgPlayItemFromListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlayItemFromListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgClearMediaPlayerDataMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgClearMediaPlayerDataMethodStart();

   virtual ~most_mplayfi_tclMsgClearMediaPlayerDataMethodStart();

   inline tBool operator==(const most_mplayfi_tclMsgClearMediaPlayerDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgClearMediaPlayerDataError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgClearMediaPlayerDataError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgClearMediaPlayerDataError& operator=(const most_mplayfi_tclMsgClearMediaPlayerDataError& coRef);
   most_mplayfi_tclMsgClearMediaPlayerDataError(const most_mplayfi_tclMsgClearMediaPlayerDataError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgClearMediaPlayerDataError();

   tBool operator==(const most_mplayfi_tclMsgClearMediaPlayerDataError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListDetailsMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestListDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListDetailsMethodStart& operator=(const most_mplayfi_tclMsgRequestListDetailsMethodStart& coRef);
   most_mplayfi_tclMsgRequestListDetailsMethodStart(const most_mplayfi_tclMsgRequestListDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~most_mplayfi_tclMsgRequestListDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestListDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListDetailsError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestListDetailsError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListDetailsError& operator=(const most_mplayfi_tclMsgRequestListDetailsError& coRef);
   most_mplayfi_tclMsgRequestListDetailsError(const most_mplayfi_tclMsgRequestListDetailsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestListDetailsError();

   tBool operator==(const most_mplayfi_tclMsgRequestListDetailsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListDetailsMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestListDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListDetailsMethodResult& operator=(const most_mplayfi_tclMsgRequestListDetailsMethodResult& coRef);
   most_mplayfi_tclMsgRequestListDetailsMethodResult(const most_mplayfi_tclMsgRequestListDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32ParentListHandle;
   tU8 u8DeviceTag;
   tU32 u32Position;
   virtual ~most_mplayfi_tclMsgRequestListDetailsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestListDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListInformationMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestListInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListInformationMethodStart& operator=(const most_mplayfi_tclMsgRequestListInformationMethodStart& coRef);
   most_mplayfi_tclMsgRequestListInformationMethodStart(const most_mplayfi_tclMsgRequestListInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~most_mplayfi_tclMsgRequestListInformationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestListInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListInformationError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRequestListInformationError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListInformationError& operator=(const most_mplayfi_tclMsgRequestListInformationError& coRef);
   most_mplayfi_tclMsgRequestListInformationError(const most_mplayfi_tclMsgRequestListInformationError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRequestListInformationError();

   tBool operator==(const most_mplayfi_tclMsgRequestListInformationError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRequestListInformationMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRequestListInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRequestListInformationMethodResult& operator=(const most_mplayfi_tclMsgRequestListInformationMethodResult& coRef);
   most_mplayfi_tclMsgRequestListInformationMethodResult(const most_mplayfi_tclMsgRequestListInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32ParentListHandle;
   tU8 u8DeviceTag;
   tU32 u32Position;
   tU32 u32ListSize;
   virtual ~most_mplayfi_tclMsgRequestListInformationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRequestListInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsToDeviceMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgTransferTagsToDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& operator=(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& coRef);
   most_mplayfi_tclMsgTransferTagsToDeviceMethodStart(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   most_fi_tcl_MPlayTagTransfer_2 oTagTransfer;
   virtual ~most_mplayfi_tclMsgTransferTagsToDeviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsToDeviceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgTransferTagsToDeviceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsToDeviceError& operator=(const most_mplayfi_tclMsgTransferTagsToDeviceError& coRef);
   most_mplayfi_tclMsgTransferTagsToDeviceError(const most_mplayfi_tclMsgTransferTagsToDeviceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgTransferTagsToDeviceError();

   tBool operator==(const most_mplayfi_tclMsgTransferTagsToDeviceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgTransferTagsToDeviceMethodResult : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgTransferTagsToDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& operator=(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& coRef);
   most_mplayfi_tclMsgTransferTagsToDeviceMethodResult(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   most_fi_tcl_e8_MPlayTagTransferStatus e8TagTransferStatus;
   most_fi_tcl_MPlayUntransferredTagStream oUntransferredTagStream;
   virtual ~most_mplayfi_tclMsgTransferTagsToDeviceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayItemFromListByTagMethodStart : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlayItemFromListByTagMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& operator=(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& coRef);
   most_mplayfi_tclMsgPlayItemFromListByTagMethodStart(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32Tag;
   virtual ~most_mplayfi_tclMsgPlayItemFromListByTagMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlayItemFromListByTagError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlayItemFromListByTagError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlayItemFromListByTagError& operator=(const most_mplayfi_tclMsgPlayItemFromListByTagError& coRef);
   most_mplayfi_tclMsgPlayItemFromListByTagError(const most_mplayfi_tclMsgPlayItemFromListByTagError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlayItemFromListByTagError();

   tBool operator==(const most_mplayfi_tclMsgPlayItemFromListByTagError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgFavoritesChangedUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgFavoritesChangedUpReg();

   virtual ~most_mplayfi_tclMsgFavoritesChangedUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgFavoritesChangedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgFavoritesChangedRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgFavoritesChangedRelUpReg();

   virtual ~most_mplayfi_tclMsgFavoritesChangedRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgFavoritesChangedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgFavoritesChangedStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgFavoritesChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgFavoritesChangedStatus& operator=(const most_mplayfi_tclMsgFavoritesChangedStatus& coRef);
   most_mplayfi_tclMsgFavoritesChangedStatus(const most_mplayfi_tclMsgFavoritesChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_FavPrvListChangeType e8ListChangeType;
   tU32 u32ListSize;
   tU32 u32NumItems;
   most_fi_tcl_FavPrvChangedFavorites oChangedFavorites;
   virtual ~most_mplayfi_tclMsgFavoritesChangedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgFavoritesChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceInfoGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceInfoGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceInfoGet& operator=(const most_mplayfi_tclMsgSourceInfoGet& coRef);
   most_mplayfi_tclMsgSourceInfoGet(const most_mplayfi_tclMsgSourceInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_mplayfi_tclMsgSourceInfoGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSourceInfoGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceInfoError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgSourceInfoError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceInfoError& operator=(const most_mplayfi_tclMsgSourceInfoError& coRef);
   most_mplayfi_tclMsgSourceInfoError(const most_mplayfi_tclMsgSourceInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgSourceInfoError();

   tBool operator==(const most_mplayfi_tclMsgSourceInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceInfoStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceInfoStatus& operator=(const most_mplayfi_tclMsgSourceInfoStatus& coRef);
   most_mplayfi_tclMsgSourceInfoStatus(const most_mplayfi_tclMsgSourceInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   most_fi_tcl_e8_SrcTransmissionClass e8TransmissionClass;
   most_fi_tcl_e8_SrcContentProtection e8ContentProtection;
   most_fi_tcl_e8_SrcContentType e8ContentType;
   most_fi_tcl_SrcContentDescription oContentDescription;
   most_fi_tcl_TrailingStream oTransmissionParameter;
   virtual ~most_mplayfi_tclMsgSourceInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSourceInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceAvailableUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceAvailableUpReg();

   virtual ~most_mplayfi_tclMsgSourceAvailableUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgSourceAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceAvailableRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceAvailableRelUpReg();

   virtual ~most_mplayfi_tclMsgSourceAvailableRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgSourceAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceAvailableGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceAvailableGet();

   virtual ~most_mplayfi_tclMsgSourceAvailableGet();

   inline tBool operator==(const most_mplayfi_tclMsgSourceAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceAvailableError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgSourceAvailableError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceAvailableError& operator=(const most_mplayfi_tclMsgSourceAvailableError& coRef);
   most_mplayfi_tclMsgSourceAvailableError(const most_mplayfi_tclMsgSourceAvailableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgSourceAvailableError();

   tBool operator==(const most_mplayfi_tclMsgSourceAvailableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgSourceAvailableStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgSourceAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgSourceAvailableStatus& operator=(const most_mplayfi_tclMsgSourceAvailableStatus& coRef);
   most_mplayfi_tclMsgSourceAvailableStatus(const most_mplayfi_tclMsgSourceAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSourceAvailable;
   virtual ~most_mplayfi_tclMsgSourceAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgSourceAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerListChangeUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerListChangeUpReg();

   virtual ~most_mplayfi_tclMsgMediaPlayerListChangeUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgMediaPlayerListChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg();

   virtual ~most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerListChangeError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgMediaPlayerListChangeError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMediaPlayerListChangeError& operator=(const most_mplayfi_tclMsgMediaPlayerListChangeError& coRef);
   most_mplayfi_tclMsgMediaPlayerListChangeError(const most_mplayfi_tclMsgMediaPlayerListChangeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgMediaPlayerListChangeError();

   tBool operator==(const most_mplayfi_tclMsgMediaPlayerListChangeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerListChangeStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerListChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMediaPlayerListChangeStatus& operator=(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& coRef);
   most_mplayfi_tclMsgMediaPlayerListChangeStatus(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   most_fi_tcl_e8_MPlayChange e8Change;
   tU32 u32ListSize;
   tU8 u8NumItems;
   most_fi_tcl_MPlayItems oItems;
   virtual ~most_mplayfi_tclMsgMediaPlayerListChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgNowPlayingUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgNowPlayingUpReg();

   virtual ~most_mplayfi_tclMsgNowPlayingUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgNowPlayingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgNowPlayingRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgNowPlayingRelUpReg();

   virtual ~most_mplayfi_tclMsgNowPlayingRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgNowPlayingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgNowPlayingGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgNowPlayingGet();

   virtual ~most_mplayfi_tclMsgNowPlayingGet();

   inline tBool operator==(const most_mplayfi_tclMsgNowPlayingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgNowPlayingError : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgNowPlayingError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgNowPlayingError& operator=(const most_mplayfi_tclMsgNowPlayingError& coRef);
   most_mplayfi_tclMsgNowPlayingError(const most_mplayfi_tclMsgNowPlayingError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_mplayfi_tclMsgNowPlayingError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgNowPlayingError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgNowPlayingStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgNowPlayingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgNowPlayingStatus& operator=(const most_mplayfi_tclMsgNowPlayingStatus& coRef);
   most_mplayfi_tclMsgNowPlayingStatus(const most_mplayfi_tclMsgNowPlayingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   most_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState;
   tU32 u32Position;
   tU32 u32Tag;
   most_fi_tcl_MPlayMediaObject oMediaObject;
   virtual ~most_mplayfi_tclMsgNowPlayingStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgNowPlayingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaytimeUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaytimeUpReg();

   virtual ~most_mplayfi_tclMsgPlaytimeUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaytimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaytimeRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaytimeRelUpReg();

   virtual ~most_mplayfi_tclMsgPlaytimeRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaytimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaytimeGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaytimeGet();

   virtual ~most_mplayfi_tclMsgPlaytimeGet();

   inline tBool operator==(const most_mplayfi_tclMsgPlaytimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaytimeError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlaytimeError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaytimeError& operator=(const most_mplayfi_tclMsgPlaytimeError& coRef);
   most_mplayfi_tclMsgPlaytimeError(const most_mplayfi_tclMsgPlaytimeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlaytimeError();

   tBool operator==(const most_mplayfi_tclMsgPlaytimeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaytimeStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaytimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaytimeStatus& operator=(const most_mplayfi_tclMsgPlaytimeStatus& coRef);
   most_mplayfi_tclMsgPlaytimeStatus(const most_mplayfi_tclMsgPlaytimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ElapsedPlaytime;
   tU32 u32TotalPlaytime;
   virtual ~most_mplayfi_tclMsgPlaytimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlaytimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackStateUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackStateUpReg();

   virtual ~most_mplayfi_tclMsgPlaybackStateUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackStateRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackStateRelUpReg();

   virtual ~most_mplayfi_tclMsgPlaybackStateRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackStateGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackStateGet();

   virtual ~most_mplayfi_tclMsgPlaybackStateGet();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackStateError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlaybackStateError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaybackStateError& operator=(const most_mplayfi_tclMsgPlaybackStateError& coRef);
   most_mplayfi_tclMsgPlaybackStateError(const most_mplayfi_tclMsgPlaybackStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlaybackStateError();

   tBool operator==(const most_mplayfi_tclMsgPlaybackStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackStateStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaybackStateStatus& operator=(const most_mplayfi_tclMsgPlaybackStateStatus& coRef);
   most_mplayfi_tclMsgPlaybackStateStatus(const most_mplayfi_tclMsgPlaybackStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayState e8State;
   virtual ~most_mplayfi_tclMsgPlaybackStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlaybackStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModeUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackModeUpReg();

   virtual ~most_mplayfi_tclMsgPlaybackModeUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModeRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackModeRelUpReg();

   virtual ~most_mplayfi_tclMsgPlaybackModeRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModeGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackModeGet();

   virtual ~most_mplayfi_tclMsgPlaybackModeGet();

   inline tBool operator==(const most_mplayfi_tclMsgPlaybackModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModePureSet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackModePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaybackModePureSet& operator=(const most_mplayfi_tclMsgPlaybackModePureSet& coRef);
   most_mplayfi_tclMsgPlaybackModePureSet(const most_mplayfi_tclMsgPlaybackModePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayMode e8Mode;
   virtual ~most_mplayfi_tclMsgPlaybackModePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlaybackModePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModeError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgPlaybackModeError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaybackModeError& operator=(const most_mplayfi_tclMsgPlaybackModeError& coRef);
   most_mplayfi_tclMsgPlaybackModeError(const most_mplayfi_tclMsgPlaybackModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgPlaybackModeError();

   tBool operator==(const most_mplayfi_tclMsgPlaybackModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgPlaybackModeStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgPlaybackModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgPlaybackModeStatus& operator=(const most_mplayfi_tclMsgPlaybackModeStatus& coRef);
   most_mplayfi_tclMsgPlaybackModeStatus(const most_mplayfi_tclMsgPlaybackModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayMode e8Mode;
   virtual ~most_mplayfi_tclMsgPlaybackModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgPlaybackModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModeUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRepeatModeUpReg();

   virtual ~most_mplayfi_tclMsgRepeatModeUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgRepeatModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModeRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRepeatModeRelUpReg();

   virtual ~most_mplayfi_tclMsgRepeatModeRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgRepeatModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModeGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRepeatModeGet();

   virtual ~most_mplayfi_tclMsgRepeatModeGet();

   inline tBool operator==(const most_mplayfi_tclMsgRepeatModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModePureSet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRepeatModePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRepeatModePureSet& operator=(const most_mplayfi_tclMsgRepeatModePureSet& coRef);
   most_mplayfi_tclMsgRepeatModePureSet(const most_mplayfi_tclMsgRepeatModePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~most_mplayfi_tclMsgRepeatModePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRepeatModePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModeError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgRepeatModeError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRepeatModeError& operator=(const most_mplayfi_tclMsgRepeatModeError& coRef);
   most_mplayfi_tclMsgRepeatModeError(const most_mplayfi_tclMsgRepeatModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgRepeatModeError();

   tBool operator==(const most_mplayfi_tclMsgRepeatModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgRepeatModeStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgRepeatModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgRepeatModeStatus& operator=(const most_mplayfi_tclMsgRepeatModeStatus& coRef);
   most_mplayfi_tclMsgRepeatModeStatus(const most_mplayfi_tclMsgRepeatModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~most_mplayfi_tclMsgRepeatModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgRepeatModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgIndexingStateUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgIndexingStateUpReg();

   virtual ~most_mplayfi_tclMsgIndexingStateUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgIndexingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgIndexingStateRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgIndexingStateRelUpReg();

   virtual ~most_mplayfi_tclMsgIndexingStateRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgIndexingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgIndexingStateGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgIndexingStateGet();

   virtual ~most_mplayfi_tclMsgIndexingStateGet();

   inline tBool operator==(const most_mplayfi_tclMsgIndexingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgIndexingStateError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgIndexingStateError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgIndexingStateError& operator=(const most_mplayfi_tclMsgIndexingStateError& coRef);
   most_mplayfi_tclMsgIndexingStateError(const most_mplayfi_tclMsgIndexingStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgIndexingStateError();

   tBool operator==(const most_mplayfi_tclMsgIndexingStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgIndexingStateStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgIndexingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgIndexingStateStatus& operator=(const most_mplayfi_tclMsgIndexingStateStatus& coRef);
   most_mplayfi_tclMsgIndexingStateStatus(const most_mplayfi_tclMsgIndexingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayIndexingStateResult oIndexingStateResult;
   virtual ~most_mplayfi_tclMsgIndexingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgIndexingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg();

   virtual ~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg();

   virtual ~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet();

   virtual ~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet();

   inline tBool operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& operator=(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& coRef);
   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError();

   tBool operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& operator=(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef);
   most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumDevices;
   most_fi_tcl_MPlayDeviceInfo oDeviceInfo;
   virtual ~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDeviceUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActiveMediaDeviceUpReg();

   virtual ~most_mplayfi_tclMsgActiveMediaDeviceUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgActiveMediaDeviceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDeviceRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActiveMediaDeviceRelUpReg();

   virtual ~most_mplayfi_tclMsgActiveMediaDeviceRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgActiveMediaDeviceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDeviceGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActiveMediaDeviceGet();

   virtual ~most_mplayfi_tclMsgActiveMediaDeviceGet();

   inline tBool operator==(const most_mplayfi_tclMsgActiveMediaDeviceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDevicePureSet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActiveMediaDevicePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActiveMediaDevicePureSet& operator=(const most_mplayfi_tclMsgActiveMediaDevicePureSet& coRef);
   most_mplayfi_tclMsgActiveMediaDevicePureSet(const most_mplayfi_tclMsgActiveMediaDevicePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   tBool bDeviceActiveSource;
   virtual ~most_mplayfi_tclMsgActiveMediaDevicePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgActiveMediaDevicePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDeviceError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgActiveMediaDeviceError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActiveMediaDeviceError& operator=(const most_mplayfi_tclMsgActiveMediaDeviceError& coRef);
   most_mplayfi_tclMsgActiveMediaDeviceError(const most_mplayfi_tclMsgActiveMediaDeviceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgActiveMediaDeviceError();

   tBool operator==(const most_mplayfi_tclMsgActiveMediaDeviceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgActiveMediaDeviceStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgActiveMediaDeviceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgActiveMediaDeviceStatus& operator=(const most_mplayfi_tclMsgActiveMediaDeviceStatus& coRef);
   most_mplayfi_tclMsgActiveMediaDeviceStatus(const most_mplayfi_tclMsgActiveMediaDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MPlayDeviceInfo oDeviceInfo;
   virtual ~most_mplayfi_tclMsgActiveMediaDeviceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgActiveMediaDeviceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMyMediaSupportedGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMyMediaSupportedGet();

   virtual ~most_mplayfi_tclMsgMyMediaSupportedGet();

   inline tBool operator==(const most_mplayfi_tclMsgMyMediaSupportedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMyMediaSupportedError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgMyMediaSupportedError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMyMediaSupportedError& operator=(const most_mplayfi_tclMsgMyMediaSupportedError& coRef);
   most_mplayfi_tclMsgMyMediaSupportedError(const most_mplayfi_tclMsgMyMediaSupportedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgMyMediaSupportedError();

   tBool operator==(const most_mplayfi_tclMsgMyMediaSupportedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgMyMediaSupportedStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgMyMediaSupportedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgMyMediaSupportedStatus& operator=(const most_mplayfi_tclMsgMyMediaSupportedStatus& coRef);
   most_mplayfi_tclMsgMyMediaSupportedStatus(const most_mplayfi_tclMsgMyMediaSupportedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMyMediaSupportedFlag;
   virtual ~most_mplayfi_tclMsgMyMediaSupportedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgMyMediaSupportedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCurrentFolderPathUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCurrentFolderPathUpReg();

   virtual ~most_mplayfi_tclMsgCurrentFolderPathUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgCurrentFolderPathUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCurrentFolderPathRelUpReg : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCurrentFolderPathRelUpReg();

   virtual ~most_mplayfi_tclMsgCurrentFolderPathRelUpReg();

   inline tBool operator==(const most_mplayfi_tclMsgCurrentFolderPathRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCurrentFolderPathGet : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCurrentFolderPathGet();

   virtual ~most_mplayfi_tclMsgCurrentFolderPathGet();

   inline tBool operator==(const most_mplayfi_tclMsgCurrentFolderPathGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCurrentFolderPathError : public most_mplayfi_tclMsgDefaultError
{
public:

   most_mplayfi_tclMsgCurrentFolderPathError() : most_mplayfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCurrentFolderPathError& operator=(const most_mplayfi_tclMsgCurrentFolderPathError& coRef);
   most_mplayfi_tclMsgCurrentFolderPathError(const most_mplayfi_tclMsgCurrentFolderPathError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_mplayfi_tclMsgCurrentFolderPathError();

   tBool operator==(const most_mplayfi_tclMsgCurrentFolderPathError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_mplayfi_tclMsgCurrentFolderPathStatus : public most_mplayfi_tclMsgBaseMessage
{
public:

   most_mplayfi_tclMsgCurrentFolderPathStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_mplayfi_tclMsgCurrentFolderPathStatus& operator=(const most_mplayfi_tclMsgCurrentFolderPathStatus& coRef);
   most_mplayfi_tclMsgCurrentFolderPathStatus(const most_mplayfi_tclMsgCurrentFolderPathStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sCurrentFolderPath;
   tU32 u32ListHandle;
   virtual ~most_mplayfi_tclMsgCurrentFolderPathStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_mplayfi_tclMsgCurrentFolderPathStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
