/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_MOST_MPLAYFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MPLAYFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MPLAYFI_SERVICEINFO
#include "most_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MOST_MPlay_FI message types

fi_tclMessageBase* most_mplayfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case most_mplayfi_tclToken::EN_MSG_StoreFavoriteMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgStoreFavoriteMethodStart;

      case most_mplayfi_tclToken::EN_MSG_StoreFavoriteMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgStoreFavoriteMethodResult;

      case most_mplayfi_tclToken::EN_MSG_ActivateFavoriteMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgActivateFavoriteMethodStart;

      case most_mplayfi_tclToken::EN_MSG_ActivateFavoriteMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgActivateFavoriteMethodResult;

      case most_mplayfi_tclToken::EN_MSG_DeleteFavoriteMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgDeleteFavoriteMethodStart;

      case most_mplayfi_tclToken::EN_MSG_DeleteFavoriteMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgDeleteFavoriteMethodResult;

      case most_mplayfi_tclToken::EN_MSG_GetFavoriteInfoMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgGetFavoriteInfoMethodStart;

      case most_mplayfi_tclToken::EN_MSG_GetFavoriteInfoMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgGetFavoriteInfoMethodResult;

      case most_mplayfi_tclToken::EN_MSG_ResetFavoritesMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgResetFavoritesMethodStart;

      case most_mplayfi_tclToken::EN_MSG_ResetFavoritesMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgResetFavoritesMethodResult;

      case most_mplayfi_tclToken::EN_MSG_AllocateMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgAllocateMethodStart;

      case most_mplayfi_tclToken::EN_MSG_AllocateMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgAllocateMethodResult;

      case most_mplayfi_tclToken::EN_MSG_DeAllocateMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgDeAllocateMethodStart;

      case most_mplayfi_tclToken::EN_MSG_DeAllocateMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgDeAllocateMethodResult;

      case most_mplayfi_tclToken::EN_MSG_SourceActivityMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgSourceActivityMethodStart;

      case most_mplayfi_tclToken::EN_MSG_SourceActivityMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgSourceActivityMethodResult;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerQuickPlayListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerQuickPlayListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerIndexedListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerIndexedListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerIndexedListSliceMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerIndexedListSliceMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult;

      case most_mplayfi_tclToken::EN_MSG_ReleaseMediaPlayerListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestPlaybackActionMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestPlaybackActionMethodStart;

      case most_mplayfi_tclToken::EN_MSG_SeekToMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgSeekToMethodStart;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult;

      case most_mplayfi_tclToken::EN_MSG_SearchKeyboardMediaPlayerListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_SearchKeyboardMediaPlayerListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectMethodStart;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectMethodResult;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerFileListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerFileListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerFileListSliceMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerFileListSliceMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerPlaylistListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerPlaylistListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerPlaylistListSliceMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerPlaylistListSliceMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerQuickPlayListSliceMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerQuickPlayListSliceMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtInfoMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart;

      case most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtInfoMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult;

      case most_mplayfi_tclToken::EN_MSG_TransferTagsMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgTransferTagsMethodStart;

      case most_mplayfi_tclToken::EN_MSG_TransferTagsMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgTransferTagsMethodResult;

      case most_mplayfi_tclToken::EN_MSG_PlayMediaPlayerObjectMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart;

      case most_mplayfi_tclToken::EN_MSG_PlayMediaPlayerObjectMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult;

      case most_mplayfi_tclToken::EN_MSG_PlayItemFromListMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgPlayItemFromListMethodStart;

      case most_mplayfi_tclToken::EN_MSG_PlayItemFromListMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgPlayItemFromListMethodResult;

      case most_mplayfi_tclToken::EN_MSG_ClearMediaPlayerDataMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgClearMediaPlayerDataMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestListDetailsMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestListDetailsMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestListDetailsMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestListDetailsMethodResult;

      case most_mplayfi_tclToken::EN_MSG_RequestListInformationMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgRequestListInformationMethodStart;

      case most_mplayfi_tclToken::EN_MSG_RequestListInformationMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgRequestListInformationMethodResult;

      case most_mplayfi_tclToken::EN_MSG_TransferTagsToDeviceMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgTransferTagsToDeviceMethodStart;

      case most_mplayfi_tclToken::EN_MSG_TransferTagsToDeviceMethodResult:
         return OSAL_NEW most_mplayfi_tclMsgTransferTagsToDeviceMethodResult;

      case most_mplayfi_tclToken::EN_MSG_PlayItemFromListByTagMethodStart:
         return OSAL_NEW most_mplayfi_tclMsgPlayItemFromListByTagMethodStart;

      case most_mplayfi_tclToken::EN_MSG_FavoritesChangedUpReg:
         return OSAL_NEW most_mplayfi_tclMsgFavoritesChangedUpReg;

      case most_mplayfi_tclToken::EN_MSG_FavoritesChangedRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgFavoritesChangedRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_FavoritesChangedStatus:
         return OSAL_NEW most_mplayfi_tclMsgFavoritesChangedStatus;

      case most_mplayfi_tclToken::EN_MSG_SourceInfoGet:
         return OSAL_NEW most_mplayfi_tclMsgSourceInfoGet;

      case most_mplayfi_tclToken::EN_MSG_SourceInfoStatus:
         return OSAL_NEW most_mplayfi_tclMsgSourceInfoStatus;

      case most_mplayfi_tclToken::EN_MSG_SourceAvailableUpReg:
         return OSAL_NEW most_mplayfi_tclMsgSourceAvailableUpReg;

      case most_mplayfi_tclToken::EN_MSG_SourceAvailableRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgSourceAvailableRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_SourceAvailableGet:
         return OSAL_NEW most_mplayfi_tclMsgSourceAvailableGet;

      case most_mplayfi_tclToken::EN_MSG_SourceAvailableStatus:
         return OSAL_NEW most_mplayfi_tclMsgSourceAvailableStatus;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeUpReg:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerListChangeUpReg;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeStatus:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerListChangeStatus;

      case most_mplayfi_tclToken::EN_MSG_NowPlayingUpReg:
         return OSAL_NEW most_mplayfi_tclMsgNowPlayingUpReg;

      case most_mplayfi_tclToken::EN_MSG_NowPlayingRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgNowPlayingRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_NowPlayingGet:
         return OSAL_NEW most_mplayfi_tclMsgNowPlayingGet;

      case most_mplayfi_tclToken::EN_MSG_NowPlayingStatus:
         return OSAL_NEW most_mplayfi_tclMsgNowPlayingStatus;

      case most_mplayfi_tclToken::EN_MSG_PlaytimeUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaytimeUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaytimeRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaytimeRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaytimeGet:
         return OSAL_NEW most_mplayfi_tclMsgPlaytimeGet;

      case most_mplayfi_tclToken::EN_MSG_PlaytimeStatus:
         return OSAL_NEW most_mplayfi_tclMsgPlaytimeStatus;

      case most_mplayfi_tclToken::EN_MSG_PlaybackStateUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackStateUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaybackStateRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackStateRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaybackStateGet:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackStateGet;

      case most_mplayfi_tclToken::EN_MSG_PlaybackStateStatus:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackStateStatus;

      case most_mplayfi_tclToken::EN_MSG_PlaybackModeUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackModeUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaybackModeRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackModeRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_PlaybackModeGet:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackModeGet;

      case most_mplayfi_tclToken::EN_MSG_PlaybackModePureSet:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackModePureSet;

      case most_mplayfi_tclToken::EN_MSG_PlaybackModeStatus:
         return OSAL_NEW most_mplayfi_tclMsgPlaybackModeStatus;

      case most_mplayfi_tclToken::EN_MSG_RepeatModeUpReg:
         return OSAL_NEW most_mplayfi_tclMsgRepeatModeUpReg;

      case most_mplayfi_tclToken::EN_MSG_RepeatModeRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgRepeatModeRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_RepeatModeGet:
         return OSAL_NEW most_mplayfi_tclMsgRepeatModeGet;

      case most_mplayfi_tclToken::EN_MSG_RepeatModePureSet:
         return OSAL_NEW most_mplayfi_tclMsgRepeatModePureSet;

      case most_mplayfi_tclToken::EN_MSG_RepeatModeStatus:
         return OSAL_NEW most_mplayfi_tclMsgRepeatModeStatus;

      case most_mplayfi_tclToken::EN_MSG_IndexingStateUpReg:
         return OSAL_NEW most_mplayfi_tclMsgIndexingStateUpReg;

      case most_mplayfi_tclToken::EN_MSG_IndexingStateRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgIndexingStateRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_IndexingStateGet:
         return OSAL_NEW most_mplayfi_tclMsgIndexingStateGet;

      case most_mplayfi_tclToken::EN_MSG_IndexingStateStatus:
         return OSAL_NEW most_mplayfi_tclMsgIndexingStateStatus;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsUpReg:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsGet:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet;

      case most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsStatus:
         return OSAL_NEW most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus;

      case most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceUpReg:
         return OSAL_NEW most_mplayfi_tclMsgActiveMediaDeviceUpReg;

      case most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgActiveMediaDeviceRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceGet:
         return OSAL_NEW most_mplayfi_tclMsgActiveMediaDeviceGet;

      case most_mplayfi_tclToken::EN_MSG_ActiveMediaDevicePureSet:
         return OSAL_NEW most_mplayfi_tclMsgActiveMediaDevicePureSet;

      case most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceStatus:
         return OSAL_NEW most_mplayfi_tclMsgActiveMediaDeviceStatus;

      case most_mplayfi_tclToken::EN_MSG_MyMediaSupportedGet:
         return OSAL_NEW most_mplayfi_tclMsgMyMediaSupportedGet;

      case most_mplayfi_tclToken::EN_MSG_MyMediaSupportedStatus:
         return OSAL_NEW most_mplayfi_tclMsgMyMediaSupportedStatus;

      case most_mplayfi_tclToken::EN_MSG_CurrentFolderPathUpReg:
         return OSAL_NEW most_mplayfi_tclMsgCurrentFolderPathUpReg;

      case most_mplayfi_tclToken::EN_MSG_CurrentFolderPathRelUpReg:
         return OSAL_NEW most_mplayfi_tclMsgCurrentFolderPathRelUpReg;

      case most_mplayfi_tclToken::EN_MSG_CurrentFolderPathGet:
         return OSAL_NEW most_mplayfi_tclMsgCurrentFolderPathGet;

      case most_mplayfi_tclToken::EN_MSG_CurrentFolderPathStatus:
         return OSAL_NEW most_mplayfi_tclMsgCurrentFolderPathStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all most_mplayfifi messages

// common functions

tU16 most_mplayfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MOST_MPLAYFI_C_U16_SERVICE_ID;
}

tU16 most_mplayfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 most_mplayfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& most_mplayfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& most_mplayfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 most_mplayfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& most_mplayfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& most_mplayfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

// base class for all most_mplayfi standard error messages

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDefaultError::most_mplayfi_tclMsgDefaultError(const most_mplayfi_tclMsgDefaultError& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   *this = coRef;
}
most_mplayfi_tclMsgDefaultError& most_mplayfi_tclMsgDefaultError::operator=(const most_mplayfi_tclMsgDefaultError& coRef)
{
   if (this != &coRef)
   {
      e8ErrorCode = coRef.e8ErrorCode;
      oErrorInfo = coRef.oErrorInfo;
   }

   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgDefaultError::vDestroy()
{
   oErrorInfo.vDestroy();
}

tU32 most_mplayfi_tclMsgDefaultError::u32GetSize(tU16 u16MajorVersion) const
{
   return 3 + oErrorInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& most_mplayfi_tclMsgDefaultError::oRead(fi_tclInContext& oIn)
{
   tU16 u16CCA_Error = CCA_C_U16_ERROR_UNSPECIFIED;
   (tVoid) (oIn >> u16CCA_Error);
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgDefaultError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU16)CCA_C_U16_ERROR_UNSPECIFIED);
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgStoreFavoriteMethodStart::most_mplayfi_tclMsgStoreFavoriteMethodStart(const most_mplayfi_tclMsgStoreFavoriteMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ObjectID = coRef.u32ObjectID;
}
most_mplayfi_tclMsgStoreFavoriteMethodStart& most_mplayfi_tclMsgStoreFavoriteMethodStart::operator=(const most_mplayfi_tclMsgStoreFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ObjectID = coRef.u32ObjectID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgStoreFavoriteMethodStart::most_mplayfi_tclMsgStoreFavoriteMethodStart()
:u32ObjectID(0)
 {}

tS32 most_mplayfi_tclMsgStoreFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_StoreFavoriteMethodStart;
}


most_mplayfi_tclMsgStoreFavoriteMethodStart::~most_mplayfi_tclMsgStoreFavoriteMethodStart()
{}

tU32 most_mplayfi_tclMsgStoreFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgStoreFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ObjectID);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgStoreFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ObjectID);
   return oOut;
}

tBool most_mplayfi_tclMsgStoreFavoriteMethodStart::operator==(const most_mplayfi_tclMsgStoreFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ObjectID == roRef.u32ObjectID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgStoreFavoriteError::most_mplayfi_tclMsgStoreFavoriteError(const most_mplayfi_tclMsgStoreFavoriteError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgStoreFavoriteError& most_mplayfi_tclMsgStoreFavoriteError::operator=(const most_mplayfi_tclMsgStoreFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgStoreFavoriteError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_StoreFavoriteError;
}


most_mplayfi_tclMsgStoreFavoriteError::~most_mplayfi_tclMsgStoreFavoriteError()
{}

tBool most_mplayfi_tclMsgStoreFavoriteError::operator==(const most_mplayfi_tclMsgStoreFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgStoreFavoriteMethodResult::most_mplayfi_tclMsgStoreFavoriteMethodResult(const most_mplayfi_tclMsgStoreFavoriteMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_mplayfi_tclMsgStoreFavoriteMethodResult& most_mplayfi_tclMsgStoreFavoriteMethodResult::operator=(const most_mplayfi_tclMsgStoreFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgStoreFavoriteMethodResult::most_mplayfi_tclMsgStoreFavoriteMethodResult()
:u16FavoriteID(0)
 {}

tS32 most_mplayfi_tclMsgStoreFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_StoreFavoriteMethodResult;
}


most_mplayfi_tclMsgStoreFavoriteMethodResult::~most_mplayfi_tclMsgStoreFavoriteMethodResult()
{}

tU32 most_mplayfi_tclMsgStoreFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgStoreFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgStoreFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_mplayfi_tclMsgStoreFavoriteMethodResult::operator==(const most_mplayfi_tclMsgStoreFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActivateFavoriteMethodStart::most_mplayfi_tclMsgActivateFavoriteMethodStart(const most_mplayfi_tclMsgActivateFavoriteMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
   e8AudioChannel = coRef.e8AudioChannel;
   e8VideoChannel = coRef.e8VideoChannel;
}
most_mplayfi_tclMsgActivateFavoriteMethodStart& most_mplayfi_tclMsgActivateFavoriteMethodStart::operator=(const most_mplayfi_tclMsgActivateFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   e8AudioChannel = coRef.e8AudioChannel;
   e8VideoChannel = coRef.e8VideoChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgActivateFavoriteMethodStart::most_mplayfi_tclMsgActivateFavoriteMethodStart()
:u16FavoriteID(0)
,e8AudioChannel()
,e8VideoChannel()
 {}

tS32 most_mplayfi_tclMsgActivateFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActivateFavoriteMethodStart;
}


most_mplayfi_tclMsgActivateFavoriteMethodStart::~most_mplayfi_tclMsgActivateFavoriteMethodStart()
{}

tU32 most_mplayfi_tclMsgActivateFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgActivateFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   (tVoid) (oIn >> e8AudioChannel);
   (tVoid) (oIn >> e8VideoChannel);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgActivateFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   (tVoid) (oOut << e8AudioChannel);
   (tVoid) (oOut << e8VideoChannel);
   return oOut;
}

tBool most_mplayfi_tclMsgActivateFavoriteMethodStart::operator==(const most_mplayfi_tclMsgActivateFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   bResult = bResult && (e8AudioChannel == roRef.e8AudioChannel);
   bResult = bResult && (e8VideoChannel == roRef.e8VideoChannel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActivateFavoriteError::most_mplayfi_tclMsgActivateFavoriteError(const most_mplayfi_tclMsgActivateFavoriteError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgActivateFavoriteError& most_mplayfi_tclMsgActivateFavoriteError::operator=(const most_mplayfi_tclMsgActivateFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgActivateFavoriteError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActivateFavoriteError;
}


most_mplayfi_tclMsgActivateFavoriteError::~most_mplayfi_tclMsgActivateFavoriteError()
{}

tBool most_mplayfi_tclMsgActivateFavoriteError::operator==(const most_mplayfi_tclMsgActivateFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActivateFavoriteMethodResult::most_mplayfi_tclMsgActivateFavoriteMethodResult(const most_mplayfi_tclMsgActivateFavoriteMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
   u32ActivationHandle = coRef.u32ActivationHandle;
}
most_mplayfi_tclMsgActivateFavoriteMethodResult& most_mplayfi_tclMsgActivateFavoriteMethodResult::operator=(const most_mplayfi_tclMsgActivateFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   u32ActivationHandle = coRef.u32ActivationHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgActivateFavoriteMethodResult::most_mplayfi_tclMsgActivateFavoriteMethodResult()
:u16FavoriteID(0)
,u32ActivationHandle(0)
 {}

tS32 most_mplayfi_tclMsgActivateFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActivateFavoriteMethodResult;
}


most_mplayfi_tclMsgActivateFavoriteMethodResult::~most_mplayfi_tclMsgActivateFavoriteMethodResult()
{}

tU32 most_mplayfi_tclMsgActivateFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 6;
}

fi_tclInContext& most_mplayfi_tclMsgActivateFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   (tVoid) (oIn >> u32ActivationHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgActivateFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   (tVoid) (oOut << u32ActivationHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgActivateFavoriteMethodResult::operator==(const most_mplayfi_tclMsgActivateFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   bResult = bResult && (u32ActivationHandle == roRef.u32ActivationHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeleteFavoriteMethodStart::most_mplayfi_tclMsgDeleteFavoriteMethodStart(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_mplayfi_tclMsgDeleteFavoriteMethodStart& most_mplayfi_tclMsgDeleteFavoriteMethodStart::operator=(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgDeleteFavoriteMethodStart::most_mplayfi_tclMsgDeleteFavoriteMethodStart()
:u16FavoriteID(0)
 {}

tS32 most_mplayfi_tclMsgDeleteFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeleteFavoriteMethodStart;
}


most_mplayfi_tclMsgDeleteFavoriteMethodStart::~most_mplayfi_tclMsgDeleteFavoriteMethodStart()
{}

tU32 most_mplayfi_tclMsgDeleteFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgDeleteFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgDeleteFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_mplayfi_tclMsgDeleteFavoriteMethodStart::operator==(const most_mplayfi_tclMsgDeleteFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeleteFavoriteError::most_mplayfi_tclMsgDeleteFavoriteError(const most_mplayfi_tclMsgDeleteFavoriteError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgDeleteFavoriteError& most_mplayfi_tclMsgDeleteFavoriteError::operator=(const most_mplayfi_tclMsgDeleteFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgDeleteFavoriteError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeleteFavoriteError;
}


most_mplayfi_tclMsgDeleteFavoriteError::~most_mplayfi_tclMsgDeleteFavoriteError()
{}

tBool most_mplayfi_tclMsgDeleteFavoriteError::operator==(const most_mplayfi_tclMsgDeleteFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeleteFavoriteMethodResult::most_mplayfi_tclMsgDeleteFavoriteMethodResult(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_mplayfi_tclMsgDeleteFavoriteMethodResult& most_mplayfi_tclMsgDeleteFavoriteMethodResult::operator=(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgDeleteFavoriteMethodResult::most_mplayfi_tclMsgDeleteFavoriteMethodResult()
:u16FavoriteID(0)
 {}

tS32 most_mplayfi_tclMsgDeleteFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeleteFavoriteMethodResult;
}


most_mplayfi_tclMsgDeleteFavoriteMethodResult::~most_mplayfi_tclMsgDeleteFavoriteMethodResult()
{}

tU32 most_mplayfi_tclMsgDeleteFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgDeleteFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgDeleteFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_mplayfi_tclMsgDeleteFavoriteMethodResult::operator==(const most_mplayfi_tclMsgDeleteFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetFavoriteInfoMethodStart::most_mplayfi_tclMsgGetFavoriteInfoMethodStart(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_mplayfi_tclMsgGetFavoriteInfoMethodStart& most_mplayfi_tclMsgGetFavoriteInfoMethodStart::operator=(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgGetFavoriteInfoMethodStart::most_mplayfi_tclMsgGetFavoriteInfoMethodStart()
:u16FavoriteID(0)
 {}

tS32 most_mplayfi_tclMsgGetFavoriteInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetFavoriteInfoMethodStart;
}


most_mplayfi_tclMsgGetFavoriteInfoMethodStart::~most_mplayfi_tclMsgGetFavoriteInfoMethodStart()
{}

tU32 most_mplayfi_tclMsgGetFavoriteInfoMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgGetFavoriteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetFavoriteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_mplayfi_tclMsgGetFavoriteInfoMethodStart::operator==(const most_mplayfi_tclMsgGetFavoriteInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetFavoriteInfoError::most_mplayfi_tclMsgGetFavoriteInfoError(const most_mplayfi_tclMsgGetFavoriteInfoError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgGetFavoriteInfoError& most_mplayfi_tclMsgGetFavoriteInfoError::operator=(const most_mplayfi_tclMsgGetFavoriteInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgGetFavoriteInfoError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetFavoriteInfoError;
}


most_mplayfi_tclMsgGetFavoriteInfoError::~most_mplayfi_tclMsgGetFavoriteInfoError()
{}

tBool most_mplayfi_tclMsgGetFavoriteInfoError::operator==(const most_mplayfi_tclMsgGetFavoriteInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetFavoriteInfoMethodResult::most_mplayfi_tclMsgGetFavoriteInfoMethodResult(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32NumItems = coRef.u32NumItems;
   oFavoriteInfo = coRef.oFavoriteInfo;
}
most_mplayfi_tclMsgGetFavoriteInfoMethodResult& most_mplayfi_tclMsgGetFavoriteInfoMethodResult::operator=(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumItems = coRef.u32NumItems;
   oFavoriteInfo = coRef.oFavoriteInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgGetFavoriteInfoMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgGetFavoriteInfoMethodResult::most_mplayfi_tclMsgGetFavoriteInfoMethodResult()
:u32NumItems(0)
,oFavoriteInfo()
 {}

tS32 most_mplayfi_tclMsgGetFavoriteInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetFavoriteInfoMethodResult;
}


most_mplayfi_tclMsgGetFavoriteInfoMethodResult::~most_mplayfi_tclMsgGetFavoriteInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgGetFavoriteInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oFavoriteInfo.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetFavoriteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oFavoriteInfo);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetFavoriteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oFavoriteInfo);
   return oOut;
}

tBool most_mplayfi_tclMsgGetFavoriteInfoMethodResult::operator==(const most_mplayfi_tclMsgGetFavoriteInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oFavoriteInfo == roRef.oFavoriteInfo);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgResetFavoritesMethodStart::most_mplayfi_tclMsgResetFavoritesMethodStart()
 {}

tS32 most_mplayfi_tclMsgResetFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ResetFavoritesMethodStart;
}


most_mplayfi_tclMsgResetFavoritesMethodStart::~most_mplayfi_tclMsgResetFavoritesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgResetFavoritesError::most_mplayfi_tclMsgResetFavoritesError(const most_mplayfi_tclMsgResetFavoritesError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgResetFavoritesError& most_mplayfi_tclMsgResetFavoritesError::operator=(const most_mplayfi_tclMsgResetFavoritesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgResetFavoritesError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ResetFavoritesError;
}


most_mplayfi_tclMsgResetFavoritesError::~most_mplayfi_tclMsgResetFavoritesError()
{}

tBool most_mplayfi_tclMsgResetFavoritesError::operator==(const most_mplayfi_tclMsgResetFavoritesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgResetFavoritesMethodResult::most_mplayfi_tclMsgResetFavoritesMethodResult()
 {}

tS32 most_mplayfi_tclMsgResetFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ResetFavoritesMethodResult;
}


most_mplayfi_tclMsgResetFavoritesMethodResult::~most_mplayfi_tclMsgResetFavoritesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgAllocateMethodStart::most_mplayfi_tclMsgAllocateMethodStart(const most_mplayfi_tclMsgAllocateMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_mplayfi_tclMsgAllocateMethodStart& most_mplayfi_tclMsgAllocateMethodStart::operator=(const most_mplayfi_tclMsgAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgAllocateMethodStart::most_mplayfi_tclMsgAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_mplayfi_tclMsgAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_AllocateMethodStart;
}


most_mplayfi_tclMsgAllocateMethodStart::~most_mplayfi_tclMsgAllocateMethodStart()
{}

tU32 most_mplayfi_tclMsgAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_mplayfi_tclMsgAllocateMethodStart::operator==(const most_mplayfi_tclMsgAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgAllocateError::most_mplayfi_tclMsgAllocateError(const most_mplayfi_tclMsgAllocateError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgAllocateError& most_mplayfi_tclMsgAllocateError::operator=(const most_mplayfi_tclMsgAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgAllocateError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_AllocateError;
}


most_mplayfi_tclMsgAllocateError::~most_mplayfi_tclMsgAllocateError()
{}

tBool most_mplayfi_tclMsgAllocateError::operator==(const most_mplayfi_tclMsgAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgAllocateMethodResult::most_mplayfi_tclMsgAllocateMethodResult(const most_mplayfi_tclMsgAllocateMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
}
most_mplayfi_tclMsgAllocateMethodResult& most_mplayfi_tclMsgAllocateMethodResult::operator=(const most_mplayfi_tclMsgAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgAllocateMethodResult::most_mplayfi_tclMsgAllocateMethodResult()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
 {}

tS32 most_mplayfi_tclMsgAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_AllocateMethodResult;
}


most_mplayfi_tclMsgAllocateMethodResult::~most_mplayfi_tclMsgAllocateMethodResult()
{}

tU32 most_mplayfi_tclMsgAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_mplayfi_tclMsgAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   return oOut;
}

tBool most_mplayfi_tclMsgAllocateMethodResult::operator==(const most_mplayfi_tclMsgAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeAllocateMethodStart::most_mplayfi_tclMsgDeAllocateMethodStart(const most_mplayfi_tclMsgDeAllocateMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_mplayfi_tclMsgDeAllocateMethodStart& most_mplayfi_tclMsgDeAllocateMethodStart::operator=(const most_mplayfi_tclMsgDeAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgDeAllocateMethodStart::most_mplayfi_tclMsgDeAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_mplayfi_tclMsgDeAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeAllocateMethodStart;
}


most_mplayfi_tclMsgDeAllocateMethodStart::~most_mplayfi_tclMsgDeAllocateMethodStart()
{}

tU32 most_mplayfi_tclMsgDeAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgDeAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgDeAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_mplayfi_tclMsgDeAllocateMethodStart::operator==(const most_mplayfi_tclMsgDeAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeAllocateError::most_mplayfi_tclMsgDeAllocateError(const most_mplayfi_tclMsgDeAllocateError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgDeAllocateError& most_mplayfi_tclMsgDeAllocateError::operator=(const most_mplayfi_tclMsgDeAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgDeAllocateError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeAllocateError;
}


most_mplayfi_tclMsgDeAllocateError::~most_mplayfi_tclMsgDeAllocateError()
{}

tBool most_mplayfi_tclMsgDeAllocateError::operator==(const most_mplayfi_tclMsgDeAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgDeAllocateMethodResult::most_mplayfi_tclMsgDeAllocateMethodResult(const most_mplayfi_tclMsgDeAllocateMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_mplayfi_tclMsgDeAllocateMethodResult& most_mplayfi_tclMsgDeAllocateMethodResult::operator=(const most_mplayfi_tclMsgDeAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgDeAllocateMethodResult::most_mplayfi_tclMsgDeAllocateMethodResult()
:u8SourceNr(0)
 {}

tS32 most_mplayfi_tclMsgDeAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_DeAllocateMethodResult;
}


most_mplayfi_tclMsgDeAllocateMethodResult::~most_mplayfi_tclMsgDeAllocateMethodResult()
{}

tU32 most_mplayfi_tclMsgDeAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgDeAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgDeAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_mplayfi_tclMsgDeAllocateMethodResult::operator==(const most_mplayfi_tclMsgDeAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceActivityMethodStart::most_mplayfi_tclMsgSourceActivityMethodStart(const most_mplayfi_tclMsgSourceActivityMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_mplayfi_tclMsgSourceActivityMethodStart& most_mplayfi_tclMsgSourceActivityMethodStart::operator=(const most_mplayfi_tclMsgSourceActivityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSourceActivityMethodStart::most_mplayfi_tclMsgSourceActivityMethodStart()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_mplayfi_tclMsgSourceActivityMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceActivityMethodStart;
}


most_mplayfi_tclMsgSourceActivityMethodStart::~most_mplayfi_tclMsgSourceActivityMethodStart()
{}

tU32 most_mplayfi_tclMsgSourceActivityMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgSourceActivityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSourceActivityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_mplayfi_tclMsgSourceActivityMethodStart::operator==(const most_mplayfi_tclMsgSourceActivityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceActivityError::most_mplayfi_tclMsgSourceActivityError(const most_mplayfi_tclMsgSourceActivityError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgSourceActivityError& most_mplayfi_tclMsgSourceActivityError::operator=(const most_mplayfi_tclMsgSourceActivityError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgSourceActivityError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceActivityError;
}


most_mplayfi_tclMsgSourceActivityError::~most_mplayfi_tclMsgSourceActivityError()
{}

tBool most_mplayfi_tclMsgSourceActivityError::operator==(const most_mplayfi_tclMsgSourceActivityError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceActivityMethodResult::most_mplayfi_tclMsgSourceActivityMethodResult(const most_mplayfi_tclMsgSourceActivityMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_mplayfi_tclMsgSourceActivityMethodResult& most_mplayfi_tclMsgSourceActivityMethodResult::operator=(const most_mplayfi_tclMsgSourceActivityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSourceActivityMethodResult::most_mplayfi_tclMsgSourceActivityMethodResult()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_mplayfi_tclMsgSourceActivityMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceActivityMethodResult;
}


most_mplayfi_tclMsgSourceActivityMethodResult::~most_mplayfi_tclMsgSourceActivityMethodResult()
{}

tU32 most_mplayfi_tclMsgSourceActivityMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgSourceActivityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSourceActivityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_mplayfi_tclMsgSourceActivityMethodResult::operator==(const most_mplayfi_tclMsgSourceActivityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u32FilterTag4 = coRef.u32FilterTag4;
   bAutoPlay = coRef.bAutoPlay;
   u8DeviceTag = coRef.u8DeviceTag;
}
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u32FilterTag4 = coRef.u32FilterTag4;
   bAutoPlay = coRef.bAutoPlay;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart()
:e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u32FilterTag4(0)
,bAutoPlay(0)
,u8DeviceTag(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerQuickPlayListMethodStart;
}


most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 19;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u32FilterTag4);
   (tVoid) (oIn >> bAutoPlay);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u32FilterTag4);
   (tVoid) (oOut << bAutoPlay);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u32FilterTag4 == roRef.u32FilterTag4);
   bResult = bResult && (bAutoPlay == roRef.bAutoPlay);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError::most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError::operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerQuickPlayListError;
}


most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError::~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError()
{}

tBool most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError::operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::operator=(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerQuickPlayListMethodResult;
}


most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::~most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 9;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::operator==(const most_mplayfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
}
most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart()
:e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u8DeviceTag(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerIndexedListMethodStart;
}


most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::~most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 14;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart::operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerIndexedListError::most_mplayfi_tclMsgCreateMediaPlayerIndexedListError(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& most_mplayfi_tclMsgCreateMediaPlayerIndexedListError::operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgCreateMediaPlayerIndexedListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerIndexedListError;
}


most_mplayfi_tclMsgCreateMediaPlayerIndexedListError::~most_mplayfi_tclMsgCreateMediaPlayerIndexedListError()
{}

tBool most_mplayfi_tclMsgCreateMediaPlayerIndexedListError::operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::operator=(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerIndexedListMethodResult;
}


most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::~most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 9;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult::operator==(const most_mplayfi_tclMsgCreateMediaPlayerIndexedListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerIndexedListSliceMethodStart;
}


most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError::most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError::operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerIndexedListSliceError;
}


most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError::~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError()
{}

tBool most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError::operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oMediaObjects = coRef.oMediaObjects;
}
most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::operator=(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjects = coRef.oMediaObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult()
:oMediaObjects()
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerIndexedListSliceMethodResult;
}


most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::~most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMediaObjects.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjects);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjects);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::operator==(const most_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjects == roRef.oMediaObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::operator=(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart()
:u32ListHandle(0)
 {}

tS32 most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ReleaseMediaPlayerListMethodStart;
}


most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::~most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart()
{}

tU32 most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart::operator==(const most_mplayfi_tclMsgReleaseMediaPlayerListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgReleaseMediaPlayerListError::most_mplayfi_tclMsgReleaseMediaPlayerListError(const most_mplayfi_tclMsgReleaseMediaPlayerListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgReleaseMediaPlayerListError& most_mplayfi_tclMsgReleaseMediaPlayerListError::operator=(const most_mplayfi_tclMsgReleaseMediaPlayerListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgReleaseMediaPlayerListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ReleaseMediaPlayerListError;
}


most_mplayfi_tclMsgReleaseMediaPlayerListError::~most_mplayfi_tclMsgReleaseMediaPlayerListError()
{}

tBool most_mplayfi_tclMsgReleaseMediaPlayerListError::operator==(const most_mplayfi_tclMsgReleaseMediaPlayerListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestPlaybackActionMethodStart::most_mplayfi_tclMsgRequestPlaybackActionMethodStart(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
}
most_mplayfi_tclMsgRequestPlaybackActionMethodStart& most_mplayfi_tclMsgRequestPlaybackActionMethodStart::operator=(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestPlaybackActionMethodStart::most_mplayfi_tclMsgRequestPlaybackActionMethodStart()
:e8Action()
,u8NextPrevSkipCount(0)
 {}

tS32 most_mplayfi_tclMsgRequestPlaybackActionMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestPlaybackActionMethodStart;
}


most_mplayfi_tclMsgRequestPlaybackActionMethodStart::~most_mplayfi_tclMsgRequestPlaybackActionMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestPlaybackActionMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgRequestPlaybackActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8NextPrevSkipCount);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestPlaybackActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8NextPrevSkipCount);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestPlaybackActionMethodStart::operator==(const most_mplayfi_tclMsgRequestPlaybackActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8NextPrevSkipCount == roRef.u8NextPrevSkipCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestPlaybackActionError::most_mplayfi_tclMsgRequestPlaybackActionError(const most_mplayfi_tclMsgRequestPlaybackActionError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestPlaybackActionError& most_mplayfi_tclMsgRequestPlaybackActionError::operator=(const most_mplayfi_tclMsgRequestPlaybackActionError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestPlaybackActionError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestPlaybackActionError;
}


most_mplayfi_tclMsgRequestPlaybackActionError::~most_mplayfi_tclMsgRequestPlaybackActionError()
{}

tBool most_mplayfi_tclMsgRequestPlaybackActionError::operator==(const most_mplayfi_tclMsgRequestPlaybackActionError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSeekToMethodStart::most_mplayfi_tclMsgSeekToMethodStart(const most_mplayfi_tclMsgSeekToMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32PlaypointPosition = coRef.u32PlaypointPosition;
   e8PlaypointFormat = coRef.e8PlaypointFormat;
}
most_mplayfi_tclMsgSeekToMethodStart& most_mplayfi_tclMsgSeekToMethodStart::operator=(const most_mplayfi_tclMsgSeekToMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32PlaypointPosition = coRef.u32PlaypointPosition;
   e8PlaypointFormat = coRef.e8PlaypointFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSeekToMethodStart::most_mplayfi_tclMsgSeekToMethodStart()
:u32PlaypointPosition(0)
,e8PlaypointFormat()
 {}

tS32 most_mplayfi_tclMsgSeekToMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SeekToMethodStart;
}


most_mplayfi_tclMsgSeekToMethodStart::~most_mplayfi_tclMsgSeekToMethodStart()
{}

tU32 most_mplayfi_tclMsgSeekToMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_mplayfi_tclMsgSeekToMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32PlaypointPosition);
   (tVoid) (oIn >> e8PlaypointFormat);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSeekToMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32PlaypointPosition);
   (tVoid) (oOut << e8PlaypointFormat);
   return oOut;
}

tBool most_mplayfi_tclMsgSeekToMethodStart::operator==(const most_mplayfi_tclMsgSeekToMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32PlaypointPosition == roRef.u32PlaypointPosition);
   bResult = bResult && (e8PlaypointFormat == roRef.e8PlaypointFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSeekToError::most_mplayfi_tclMsgSeekToError(const most_mplayfi_tclMsgSeekToError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgSeekToError& most_mplayfi_tclMsgSeekToError::operator=(const most_mplayfi_tclMsgSeekToError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgSeekToError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SeekToError;
}


most_mplayfi_tclMsgSeekToError::~most_mplayfi_tclMsgSeekToError()
{}

tBool most_mplayfi_tclMsgSeekToError::operator==(const most_mplayfi_tclMsgSeekToError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::vDestroy()
{
   sAlbumArt.vDestroy(); 
}

most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart()
:sAlbumArt()
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtMethodStart;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::~most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sAlbumArt.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtError::most_mplayfi_tclMsgGetMediaObjectAlbumArtError(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtError& most_mplayfi_tclMsgGetMediaObjectAlbumArtError::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtError;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtError::~most_mplayfi_tclMsgGetMediaObjectAlbumArtError()
{}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtError::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oImageData = coRef.oImageData;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oImageData = coRef.oImageData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult()
:oImageData()
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtMethodResult;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::~most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult()
{}

tU32 most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oImageData.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oImageData);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oImageData);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oImageData == roRef.oImageData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart()
:u32ListHandle(0)
 {}

tS32 most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SearchKeyboardMediaPlayerListMethodStart;
}


most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart()
{}

tU32 most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError::most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError::operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SearchKeyboardMediaPlayerListError;
}


most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError::~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError()
{}

tBool most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError::operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
}
most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::operator=(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult()
:u32ListHandle(0)
,oSearchKeyboardList()
 {}

tS32 most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SearchKeyboardMediaPlayerListMethodResult;
}


most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::~most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSearchKeyboardList.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> oSearchKeyboardList);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << oSearchKeyboardList);
   return oOut;
}

tBool most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::operator==(const most_mplayfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (oSearchKeyboardList == roRef.oSearchKeyboardList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectMethodStart::most_mplayfi_tclMsgGetMediaObjectMethodStart(const most_mplayfi_tclMsgGetMediaObjectMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32Tag = coRef.u32Tag;
   e8CategoryType = coRef.e8CategoryType;
}
most_mplayfi_tclMsgGetMediaObjectMethodStart& most_mplayfi_tclMsgGetMediaObjectMethodStart::operator=(const most_mplayfi_tclMsgGetMediaObjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Tag = coRef.u32Tag;
   e8CategoryType = coRef.e8CategoryType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgGetMediaObjectMethodStart::most_mplayfi_tclMsgGetMediaObjectMethodStart()
:u32Tag(0)
,e8CategoryType()
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectMethodStart;
}


most_mplayfi_tclMsgGetMediaObjectMethodStart::~most_mplayfi_tclMsgGetMediaObjectMethodStart()
{}

tU32 most_mplayfi_tclMsgGetMediaObjectMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> e8CategoryType);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << e8CategoryType);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectMethodStart::operator==(const most_mplayfi_tclMsgGetMediaObjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (e8CategoryType == roRef.e8CategoryType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectError::most_mplayfi_tclMsgGetMediaObjectError(const most_mplayfi_tclMsgGetMediaObjectError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgGetMediaObjectError& most_mplayfi_tclMsgGetMediaObjectError::operator=(const most_mplayfi_tclMsgGetMediaObjectError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgGetMediaObjectError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectError;
}


most_mplayfi_tclMsgGetMediaObjectError::~most_mplayfi_tclMsgGetMediaObjectError()
{}

tBool most_mplayfi_tclMsgGetMediaObjectError::operator==(const most_mplayfi_tclMsgGetMediaObjectError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectMethodResult::most_mplayfi_tclMsgGetMediaObjectMethodResult(const most_mplayfi_tclMsgGetMediaObjectMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oMediaObject = coRef.oMediaObject;
}
most_mplayfi_tclMsgGetMediaObjectMethodResult& most_mplayfi_tclMsgGetMediaObjectMethodResult::operator=(const most_mplayfi_tclMsgGetMediaObjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObject = coRef.oMediaObject;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgGetMediaObjectMethodResult::vDestroy()
{
   oMediaObject.vDestroy(); 
}

most_mplayfi_tclMsgGetMediaObjectMethodResult::most_mplayfi_tclMsgGetMediaObjectMethodResult()
:oMediaObject()
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectMethodResult;
}


most_mplayfi_tclMsgGetMediaObjectMethodResult::~most_mplayfi_tclMsgGetMediaObjectMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgGetMediaObjectMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMediaObject.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObject);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObject);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectMethodResult::operator==(const most_mplayfi_tclMsgGetMediaObjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObject == roRef.oMediaObject);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
}
most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::vDestroy()
{
   sPath.vDestroy(); 
}

most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart()
:sPath()
,u8DeviceTag(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerFileListMethodStart;
}


most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::~most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPath.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart::operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerFileListError::most_mplayfi_tclMsgCreateMediaPlayerFileListError(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgCreateMediaPlayerFileListError& most_mplayfi_tclMsgCreateMediaPlayerFileListError::operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgCreateMediaPlayerFileListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerFileListError;
}


most_mplayfi_tclMsgCreateMediaPlayerFileListError::~most_mplayfi_tclMsgCreateMediaPlayerFileListError()
{}

tBool most_mplayfi_tclMsgCreateMediaPlayerFileListError::operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
}
most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::operator=(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
,u32TotalNumFiles(0)
,u32TotalNumFolders(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerFileListMethodResult;
}


most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::~most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 17;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32TotalNumFiles);
   (tVoid) (oIn >> u32TotalNumFolders);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32TotalNumFiles);
   (tVoid) (oOut << u32TotalNumFolders);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult::operator==(const most_mplayfi_tclMsgCreateMediaPlayerFileListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32TotalNumFiles == roRef.u32TotalNumFiles);
   bResult = bResult && (u32TotalNumFolders == roRef.u32TotalNumFolders);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerFileListSliceMethodStart;
}


most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError::most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError::operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerFileListSliceError;
}


most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError::~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError()
{}

tBool most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError::operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oFileList = coRef.oFileList;
}
most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::operator=(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oFileList = coRef.oFileList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult()
:oFileList()
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerFileListSliceMethodResult;
}


most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::~most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oFileList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFileList);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFileList);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::operator==(const most_mplayfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFileList == roRef.oFileList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sFilename = coRef.sFilename;
}
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilename = coRef.sFilename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::vDestroy()
{
   sFilename.vDestroy(); 
}

most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart()
:sFilename()
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerPlaylistListMethodStart;
}


most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sFilename.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilename);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilename);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilename == roRef.sFilename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError::most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError::operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerPlaylistListError;
}


most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError::~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError()
{}

tBool most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError::operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::operator=(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CreateMediaPlayerPlaylistListMethodResult;
}


most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::~most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult()
{}

tU32 most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::operator==(const most_mplayfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerPlaylistListSliceMethodStart;
}


most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError::most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError::operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerPlaylistListSliceError;
}


most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError::~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError()
{}

tBool most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError::operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oFileList = coRef.oFileList;
}
most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::operator=(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oFileList = coRef.oFileList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult()
:oFileList()
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerPlaylistListSliceMethodResult;
}


most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::~most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oFileList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFileList);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFileList);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::operator==(const most_mplayfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFileList == roRef.oFileList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerQuickPlayListSliceMethodStart;
}


most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError::most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError::operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerQuickPlayListSliceError;
}


most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError::~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError()
{}

tBool most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError::operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oMediaObjects = coRef.oMediaObjects;
}
most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::operator=(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjects = coRef.oMediaObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult()
:oMediaObjects()
 {}

tS32 most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestMediaPlayerQuickPlayListSliceMethodResult;
}


most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::~most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMediaObjects.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjects);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjects);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::operator==(const most_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjects == roRef.oMediaObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::vDestroy()
{
   sAlbumArt.vDestroy(); 
}

most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart()
:sAlbumArt()
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtInfoMethodStart;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sAlbumArt.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError::most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtInfoError;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError::~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError()
{}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
}
most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::operator=(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::vDestroy()
{
   sMIMEImageSubtype.vDestroy(); 
}

most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult()
:sMIMEImageSubtype()
,u32PhotoSize(0)
 {}

tS32 most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_GetMediaObjectAlbumArtInfoMethodResult;
}


most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::~most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sMIMEImageSubtype.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMIMEImageSubtype);
   (tVoid) (oIn >> u32PhotoSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMIMEImageSubtype);
   (tVoid) (oOut << u32PhotoSize);
   return oOut;
}

tBool most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::operator==(const most_mplayfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMIMEImageSubtype == roRef.sMIMEImageSubtype);
   bResult = bResult && (u32PhotoSize == roRef.u32PhotoSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsMethodStart::most_mplayfi_tclMsgTransferTagsMethodStart(const most_mplayfi_tclMsgTransferTagsMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
}
most_mplayfi_tclMsgTransferTagsMethodStart& most_mplayfi_tclMsgTransferTagsMethodStart::operator=(const most_mplayfi_tclMsgTransferTagsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgTransferTagsMethodStart::vDestroy()
{
}

most_mplayfi_tclMsgTransferTagsMethodStart::most_mplayfi_tclMsgTransferTagsMethodStart()
:u8DeviceTag(0)
,oTagTransfer()
 {}

tS32 most_mplayfi_tclMsgTransferTagsMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsMethodStart;
}


most_mplayfi_tclMsgTransferTagsMethodStart::~most_mplayfi_tclMsgTransferTagsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgTransferTagsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oTagTransfer.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgTransferTagsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> oTagTransfer);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgTransferTagsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << oTagTransfer);
   return oOut;
}

tBool most_mplayfi_tclMsgTransferTagsMethodStart::operator==(const most_mplayfi_tclMsgTransferTagsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (oTagTransfer == roRef.oTagTransfer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsError::most_mplayfi_tclMsgTransferTagsError(const most_mplayfi_tclMsgTransferTagsError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgTransferTagsError& most_mplayfi_tclMsgTransferTagsError::operator=(const most_mplayfi_tclMsgTransferTagsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgTransferTagsError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsError;
}


most_mplayfi_tclMsgTransferTagsError::~most_mplayfi_tclMsgTransferTagsError()
{}

tBool most_mplayfi_tclMsgTransferTagsError::operator==(const most_mplayfi_tclMsgTransferTagsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsMethodResult::most_mplayfi_tclMsgTransferTagsMethodResult(const most_mplayfi_tclMsgTransferTagsMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
}
most_mplayfi_tclMsgTransferTagsMethodResult& most_mplayfi_tclMsgTransferTagsMethodResult::operator=(const most_mplayfi_tclMsgTransferTagsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgTransferTagsMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgTransferTagsMethodResult::most_mplayfi_tclMsgTransferTagsMethodResult()
:u8DeviceTag(0)
,e8TagTransferStatus()
,oUntransferredTagStream()
 {}

tS32 most_mplayfi_tclMsgTransferTagsMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsMethodResult;
}


most_mplayfi_tclMsgTransferTagsMethodResult::~most_mplayfi_tclMsgTransferTagsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgTransferTagsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oUntransferredTagStream.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgTransferTagsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8TagTransferStatus);
   (tVoid) (oIn >> oUntransferredTagStream);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgTransferTagsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8TagTransferStatus);
   (tVoid) (oOut << oUntransferredTagStream);
   return oOut;
}

tBool most_mplayfi_tclMsgTransferTagsMethodResult::operator==(const most_mplayfi_tclMsgTransferTagsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8TagTransferStatus == roRef.e8TagTransferStatus);
   bResult = bResult && (oUntransferredTagStream == roRef.oUntransferredTagStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32Tag = coRef.u32Tag;
   bAutoPlay = coRef.bAutoPlay;
}
most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Tag = coRef.u32Tag;
   bAutoPlay = coRef.bAutoPlay;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart()
:u32Tag(0)
,bAutoPlay(0)
 {}

tS32 most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayMediaPlayerObjectMethodStart;
}


most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::~most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart()
{}

tU32 most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> bAutoPlay);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << bAutoPlay);
   return oOut;
}

tBool most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart::operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (bAutoPlay == roRef.bAutoPlay);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayMediaPlayerObjectError::most_mplayfi_tclMsgPlayMediaPlayerObjectError(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlayMediaPlayerObjectError& most_mplayfi_tclMsgPlayMediaPlayerObjectError::operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlayMediaPlayerObjectError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayMediaPlayerObjectError;
}


most_mplayfi_tclMsgPlayMediaPlayerObjectError::~most_mplayfi_tclMsgPlayMediaPlayerObjectError()
{}

tBool most_mplayfi_tclMsgPlayMediaPlayerObjectError::operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::operator=(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayMediaPlayerObjectMethodResult;
}


most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::~most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult()
{}

tU32 most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult::operator==(const most_mplayfi_tclMsgPlayMediaPlayerObjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayItemFromListMethodStart::most_mplayfi_tclMsgPlayItemFromListMethodStart(const most_mplayfi_tclMsgPlayItemFromListMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32StartIndex = coRef.u32StartIndex;
   u32StartOffset = coRef.u32StartOffset;
}
most_mplayfi_tclMsgPlayItemFromListMethodStart& most_mplayfi_tclMsgPlayItemFromListMethodStart::operator=(const most_mplayfi_tclMsgPlayItemFromListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32StartIndex = coRef.u32StartIndex;
   u32StartOffset = coRef.u32StartOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlayItemFromListMethodStart::most_mplayfi_tclMsgPlayItemFromListMethodStart()
:u32ListHandle(0)
,u32StartIndex(0)
,u32StartOffset(0)
 {}

tS32 most_mplayfi_tclMsgPlayItemFromListMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayItemFromListMethodStart;
}


most_mplayfi_tclMsgPlayItemFromListMethodStart::~most_mplayfi_tclMsgPlayItemFromListMethodStart()
{}

tU32 most_mplayfi_tclMsgPlayItemFromListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 12;
}

fi_tclInContext& most_mplayfi_tclMsgPlayItemFromListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32StartIndex);
   (tVoid) (oIn >> u32StartOffset);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlayItemFromListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32StartIndex);
   (tVoid) (oOut << u32StartOffset);
   return oOut;
}

tBool most_mplayfi_tclMsgPlayItemFromListMethodStart::operator==(const most_mplayfi_tclMsgPlayItemFromListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32StartIndex == roRef.u32StartIndex);
   bResult = bResult && (u32StartOffset == roRef.u32StartOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayItemFromListError::most_mplayfi_tclMsgPlayItemFromListError(const most_mplayfi_tclMsgPlayItemFromListError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlayItemFromListError& most_mplayfi_tclMsgPlayItemFromListError::operator=(const most_mplayfi_tclMsgPlayItemFromListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlayItemFromListError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayItemFromListError;
}


most_mplayfi_tclMsgPlayItemFromListError::~most_mplayfi_tclMsgPlayItemFromListError()
{}

tBool most_mplayfi_tclMsgPlayItemFromListError::operator==(const most_mplayfi_tclMsgPlayItemFromListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayItemFromListMethodResult::most_mplayfi_tclMsgPlayItemFromListMethodResult(const most_mplayfi_tclMsgPlayItemFromListMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
most_mplayfi_tclMsgPlayItemFromListMethodResult& most_mplayfi_tclMsgPlayItemFromListMethodResult::operator=(const most_mplayfi_tclMsgPlayItemFromListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlayItemFromListMethodResult::most_mplayfi_tclMsgPlayItemFromListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 most_mplayfi_tclMsgPlayItemFromListMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayItemFromListMethodResult;
}


most_mplayfi_tclMsgPlayItemFromListMethodResult::~most_mplayfi_tclMsgPlayItemFromListMethodResult()
{}

tU32 most_mplayfi_tclMsgPlayItemFromListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_mplayfi_tclMsgPlayItemFromListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlayItemFromListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool most_mplayfi_tclMsgPlayItemFromListMethodResult::operator==(const most_mplayfi_tclMsgPlayItemFromListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgClearMediaPlayerDataMethodStart::most_mplayfi_tclMsgClearMediaPlayerDataMethodStart()
 {}

tS32 most_mplayfi_tclMsgClearMediaPlayerDataMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ClearMediaPlayerDataMethodStart;
}


most_mplayfi_tclMsgClearMediaPlayerDataMethodStart::~most_mplayfi_tclMsgClearMediaPlayerDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgClearMediaPlayerDataError::most_mplayfi_tclMsgClearMediaPlayerDataError(const most_mplayfi_tclMsgClearMediaPlayerDataError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgClearMediaPlayerDataError& most_mplayfi_tclMsgClearMediaPlayerDataError::operator=(const most_mplayfi_tclMsgClearMediaPlayerDataError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgClearMediaPlayerDataError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ClearMediaPlayerDataError;
}


most_mplayfi_tclMsgClearMediaPlayerDataError::~most_mplayfi_tclMsgClearMediaPlayerDataError()
{}

tBool most_mplayfi_tclMsgClearMediaPlayerDataError::operator==(const most_mplayfi_tclMsgClearMediaPlayerDataError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListDetailsMethodStart::most_mplayfi_tclMsgRequestListDetailsMethodStart(const most_mplayfi_tclMsgRequestListDetailsMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
most_mplayfi_tclMsgRequestListDetailsMethodStart& most_mplayfi_tclMsgRequestListDetailsMethodStart::operator=(const most_mplayfi_tclMsgRequestListDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestListDetailsMethodStart::most_mplayfi_tclMsgRequestListDetailsMethodStart()
:u32ListHandle(0)
 {}

tS32 most_mplayfi_tclMsgRequestListDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListDetailsMethodStart;
}


most_mplayfi_tclMsgRequestListDetailsMethodStart::~most_mplayfi_tclMsgRequestListDetailsMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestListDetailsMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgRequestListDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestListDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestListDetailsMethodStart::operator==(const most_mplayfi_tclMsgRequestListDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListDetailsError::most_mplayfi_tclMsgRequestListDetailsError(const most_mplayfi_tclMsgRequestListDetailsError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestListDetailsError& most_mplayfi_tclMsgRequestListDetailsError::operator=(const most_mplayfi_tclMsgRequestListDetailsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestListDetailsError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListDetailsError;
}


most_mplayfi_tclMsgRequestListDetailsError::~most_mplayfi_tclMsgRequestListDetailsError()
{}

tBool most_mplayfi_tclMsgRequestListDetailsError::operator==(const most_mplayfi_tclMsgRequestListDetailsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListDetailsMethodResult::most_mplayfi_tclMsgRequestListDetailsMethodResult(const most_mplayfi_tclMsgRequestListDetailsMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
}
most_mplayfi_tclMsgRequestListDetailsMethodResult& most_mplayfi_tclMsgRequestListDetailsMethodResult::operator=(const most_mplayfi_tclMsgRequestListDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestListDetailsMethodResult::most_mplayfi_tclMsgRequestListDetailsMethodResult()
:e8ListType()
,u32ParentListHandle(0)
,u8DeviceTag(0)
,u32Position(0)
 {}

tS32 most_mplayfi_tclMsgRequestListDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListDetailsMethodResult;
}


most_mplayfi_tclMsgRequestListDetailsMethodResult::~most_mplayfi_tclMsgRequestListDetailsMethodResult()
{}

tU32 most_mplayfi_tclMsgRequestListDetailsMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_mplayfi_tclMsgRequestListDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32ParentListHandle);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32Position);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestListDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32ParentListHandle);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32Position);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestListDetailsMethodResult::operator==(const most_mplayfi_tclMsgRequestListDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32ParentListHandle == roRef.u32ParentListHandle);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32Position == roRef.u32Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListInformationMethodStart::most_mplayfi_tclMsgRequestListInformationMethodStart(const most_mplayfi_tclMsgRequestListInformationMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
most_mplayfi_tclMsgRequestListInformationMethodStart& most_mplayfi_tclMsgRequestListInformationMethodStart::operator=(const most_mplayfi_tclMsgRequestListInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestListInformationMethodStart::most_mplayfi_tclMsgRequestListInformationMethodStart()
:u32ListHandle(0)
 {}

tS32 most_mplayfi_tclMsgRequestListInformationMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListInformationMethodStart;
}


most_mplayfi_tclMsgRequestListInformationMethodStart::~most_mplayfi_tclMsgRequestListInformationMethodStart()
{}

tU32 most_mplayfi_tclMsgRequestListInformationMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_mplayfi_tclMsgRequestListInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestListInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestListInformationMethodStart::operator==(const most_mplayfi_tclMsgRequestListInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListInformationError::most_mplayfi_tclMsgRequestListInformationError(const most_mplayfi_tclMsgRequestListInformationError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRequestListInformationError& most_mplayfi_tclMsgRequestListInformationError::operator=(const most_mplayfi_tclMsgRequestListInformationError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRequestListInformationError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListInformationError;
}


most_mplayfi_tclMsgRequestListInformationError::~most_mplayfi_tclMsgRequestListInformationError()
{}

tBool most_mplayfi_tclMsgRequestListInformationError::operator==(const most_mplayfi_tclMsgRequestListInformationError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRequestListInformationMethodResult::most_mplayfi_tclMsgRequestListInformationMethodResult(const most_mplayfi_tclMsgRequestListInformationMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   u32ListSize = coRef.u32ListSize;
}
most_mplayfi_tclMsgRequestListInformationMethodResult& most_mplayfi_tclMsgRequestListInformationMethodResult::operator=(const most_mplayfi_tclMsgRequestListInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRequestListInformationMethodResult::most_mplayfi_tclMsgRequestListInformationMethodResult()
:e8ListType()
,u32ParentListHandle(0)
,u8DeviceTag(0)
,u32Position(0)
,u32ListSize(0)
 {}

tS32 most_mplayfi_tclMsgRequestListInformationMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RequestListInformationMethodResult;
}


most_mplayfi_tclMsgRequestListInformationMethodResult::~most_mplayfi_tclMsgRequestListInformationMethodResult()
{}

tU32 most_mplayfi_tclMsgRequestListInformationMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 14;
}

fi_tclInContext& most_mplayfi_tclMsgRequestListInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32ParentListHandle);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRequestListInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32ParentListHandle);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool most_mplayfi_tclMsgRequestListInformationMethodResult::operator==(const most_mplayfi_tclMsgRequestListInformationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32ParentListHandle == roRef.u32ParentListHandle);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::most_mplayfi_tclMsgTransferTagsToDeviceMethodStart(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
}
most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::operator=(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::vDestroy()
{
}

most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::most_mplayfi_tclMsgTransferTagsToDeviceMethodStart()
:u8DeviceTag(0)
,oTagTransfer()
 {}

tS32 most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsToDeviceMethodStart;
}


most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::~most_mplayfi_tclMsgTransferTagsToDeviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oTagTransfer.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> oTagTransfer);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << oTagTransfer);
   return oOut;
}

tBool most_mplayfi_tclMsgTransferTagsToDeviceMethodStart::operator==(const most_mplayfi_tclMsgTransferTagsToDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (oTagTransfer == roRef.oTagTransfer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsToDeviceError::most_mplayfi_tclMsgTransferTagsToDeviceError(const most_mplayfi_tclMsgTransferTagsToDeviceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgTransferTagsToDeviceError& most_mplayfi_tclMsgTransferTagsToDeviceError::operator=(const most_mplayfi_tclMsgTransferTagsToDeviceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgTransferTagsToDeviceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsToDeviceError;
}


most_mplayfi_tclMsgTransferTagsToDeviceError::~most_mplayfi_tclMsgTransferTagsToDeviceError()
{}

tBool most_mplayfi_tclMsgTransferTagsToDeviceError::operator==(const most_mplayfi_tclMsgTransferTagsToDeviceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::most_mplayfi_tclMsgTransferTagsToDeviceMethodResult(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
}
most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::operator=(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::vDestroy()
{
}

most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::most_mplayfi_tclMsgTransferTagsToDeviceMethodResult()
:u8DeviceTag(0)
,e8TagTransferStatus()
,oUntransferredTagStream()
 {}

tS32 most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_TransferTagsToDeviceMethodResult;
}


most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::~most_mplayfi_tclMsgTransferTagsToDeviceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oUntransferredTagStream.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8TagTransferStatus);
   (tVoid) (oIn >> oUntransferredTagStream);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8TagTransferStatus);
   (tVoid) (oOut << oUntransferredTagStream);
   return oOut;
}

tBool most_mplayfi_tclMsgTransferTagsToDeviceMethodResult::operator==(const most_mplayfi_tclMsgTransferTagsToDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8TagTransferStatus == roRef.e8TagTransferStatus);
   bResult = bResult && (oUntransferredTagStream == roRef.oUntransferredTagStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::most_mplayfi_tclMsgPlayItemFromListByTagMethodStart(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
}
most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::operator=(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::most_mplayfi_tclMsgPlayItemFromListByTagMethodStart()
:u32ListHandle(0)
,u32Tag(0)
 {}

tS32 most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayItemFromListByTagMethodStart;
}


most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::~most_mplayfi_tclMsgPlayItemFromListByTagMethodStart()
{}

tU32 most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32Tag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32Tag);
   return oOut;
}

tBool most_mplayfi_tclMsgPlayItemFromListByTagMethodStart::operator==(const most_mplayfi_tclMsgPlayItemFromListByTagMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlayItemFromListByTagError::most_mplayfi_tclMsgPlayItemFromListByTagError(const most_mplayfi_tclMsgPlayItemFromListByTagError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlayItemFromListByTagError& most_mplayfi_tclMsgPlayItemFromListByTagError::operator=(const most_mplayfi_tclMsgPlayItemFromListByTagError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlayItemFromListByTagError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlayItemFromListByTagError;
}


most_mplayfi_tclMsgPlayItemFromListByTagError::~most_mplayfi_tclMsgPlayItemFromListByTagError()
{}

tBool most_mplayfi_tclMsgPlayItemFromListByTagError::operator==(const most_mplayfi_tclMsgPlayItemFromListByTagError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgFavoritesChangedUpReg::most_mplayfi_tclMsgFavoritesChangedUpReg()
 {}

tS32 most_mplayfi_tclMsgFavoritesChangedUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_FavoritesChangedUpReg;
}


most_mplayfi_tclMsgFavoritesChangedUpReg::~most_mplayfi_tclMsgFavoritesChangedUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgFavoritesChangedRelUpReg::most_mplayfi_tclMsgFavoritesChangedRelUpReg()
 {}

tS32 most_mplayfi_tclMsgFavoritesChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_FavoritesChangedRelUpReg;
}


most_mplayfi_tclMsgFavoritesChangedRelUpReg::~most_mplayfi_tclMsgFavoritesChangedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgFavoritesChangedStatus::most_mplayfi_tclMsgFavoritesChangedStatus(const most_mplayfi_tclMsgFavoritesChangedStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
}
most_mplayfi_tclMsgFavoritesChangedStatus& most_mplayfi_tclMsgFavoritesChangedStatus::operator=(const most_mplayfi_tclMsgFavoritesChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgFavoritesChangedStatus::most_mplayfi_tclMsgFavoritesChangedStatus()
:e8ListChangeType()
,u32ListSize(0)
,u32NumItems(0)
,oChangedFavorites()
 {}

tS32 most_mplayfi_tclMsgFavoritesChangedStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_FavoritesChangedStatus;
}


most_mplayfi_tclMsgFavoritesChangedStatus::~most_mplayfi_tclMsgFavoritesChangedStatus()
{}

tU32 most_mplayfi_tclMsgFavoritesChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oChangedFavorites.u32GetSize(u16MajorVersion);
   return 9 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgFavoritesChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListChangeType);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oChangedFavorites);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgFavoritesChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListChangeType);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oChangedFavorites);
   return oOut;
}

tBool most_mplayfi_tclMsgFavoritesChangedStatus::operator==(const most_mplayfi_tclMsgFavoritesChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListChangeType == roRef.e8ListChangeType);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oChangedFavorites == roRef.oChangedFavorites);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceInfoGet::most_mplayfi_tclMsgSourceInfoGet(const most_mplayfi_tclMsgSourceInfoGet& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_mplayfi_tclMsgSourceInfoGet& most_mplayfi_tclMsgSourceInfoGet::operator=(const most_mplayfi_tclMsgSourceInfoGet& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSourceInfoGet::most_mplayfi_tclMsgSourceInfoGet()
:u8SourceNr(0)
 {}

tS32 most_mplayfi_tclMsgSourceInfoGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceInfoGet;
}


most_mplayfi_tclMsgSourceInfoGet::~most_mplayfi_tclMsgSourceInfoGet()
{}

tU32 most_mplayfi_tclMsgSourceInfoGet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgSourceInfoGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSourceInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_mplayfi_tclMsgSourceInfoGet::operator==(const most_mplayfi_tclMsgSourceInfoGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceInfoError::most_mplayfi_tclMsgSourceInfoError(const most_mplayfi_tclMsgSourceInfoError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgSourceInfoError& most_mplayfi_tclMsgSourceInfoError::operator=(const most_mplayfi_tclMsgSourceInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgSourceInfoError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceInfoError;
}


most_mplayfi_tclMsgSourceInfoError::~most_mplayfi_tclMsgSourceInfoError()
{}

tBool most_mplayfi_tclMsgSourceInfoError::operator==(const most_mplayfi_tclMsgSourceInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceInfoStatus::most_mplayfi_tclMsgSourceInfoStatus(const most_mplayfi_tclMsgSourceInfoStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
}
most_mplayfi_tclMsgSourceInfoStatus& most_mplayfi_tclMsgSourceInfoStatus::operator=(const most_mplayfi_tclMsgSourceInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSourceInfoStatus::most_mplayfi_tclMsgSourceInfoStatus()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
,e8TransmissionClass()
,e8ContentProtection()
,e8ContentType()
,oContentDescription()
,oTransmissionParameter()
 {}

tS32 most_mplayfi_tclMsgSourceInfoStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceInfoStatus;
}


most_mplayfi_tclMsgSourceInfoStatus::~most_mplayfi_tclMsgSourceInfoStatus()
{}

tU32 most_mplayfi_tclMsgSourceInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContentDescription.u32GetSize(u16MajorVersion);
   u32DynamicSize += oTransmissionParameter.u32GetSize(u16MajorVersion);
   return 8 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgSourceInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   (tVoid) (oIn >> e8TransmissionClass);
   (tVoid) (oIn >> e8ContentProtection);
   (tVoid) (oIn >> e8ContentType);
   (tVoid) (oIn >> oContentDescription);
   (tVoid) (oIn >> oTransmissionParameter);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSourceInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   (tVoid) (oOut << e8TransmissionClass);
   (tVoid) (oOut << e8ContentProtection);
   (tVoid) (oOut << e8ContentType);
   (tVoid) (oOut << oContentDescription);
   (tVoid) (oOut << oTransmissionParameter);
   return oOut;
}

tBool most_mplayfi_tclMsgSourceInfoStatus::operator==(const most_mplayfi_tclMsgSourceInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   bResult = bResult && (e8TransmissionClass == roRef.e8TransmissionClass);
   bResult = bResult && (e8ContentProtection == roRef.e8ContentProtection);
   bResult = bResult && (e8ContentType == roRef.e8ContentType);
   bResult = bResult && (oContentDescription == roRef.oContentDescription);
   bResult = bResult && (oTransmissionParameter == roRef.oTransmissionParameter);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgSourceAvailableUpReg::most_mplayfi_tclMsgSourceAvailableUpReg()
 {}

tS32 most_mplayfi_tclMsgSourceAvailableUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceAvailableUpReg;
}


most_mplayfi_tclMsgSourceAvailableUpReg::~most_mplayfi_tclMsgSourceAvailableUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgSourceAvailableRelUpReg::most_mplayfi_tclMsgSourceAvailableRelUpReg()
 {}

tS32 most_mplayfi_tclMsgSourceAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceAvailableRelUpReg;
}


most_mplayfi_tclMsgSourceAvailableRelUpReg::~most_mplayfi_tclMsgSourceAvailableRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgSourceAvailableGet::most_mplayfi_tclMsgSourceAvailableGet()
 {}

tS32 most_mplayfi_tclMsgSourceAvailableGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceAvailableGet;
}


most_mplayfi_tclMsgSourceAvailableGet::~most_mplayfi_tclMsgSourceAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceAvailableError::most_mplayfi_tclMsgSourceAvailableError(const most_mplayfi_tclMsgSourceAvailableError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgSourceAvailableError& most_mplayfi_tclMsgSourceAvailableError::operator=(const most_mplayfi_tclMsgSourceAvailableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgSourceAvailableError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceAvailableError;
}


most_mplayfi_tclMsgSourceAvailableError::~most_mplayfi_tclMsgSourceAvailableError()
{}

tBool most_mplayfi_tclMsgSourceAvailableError::operator==(const most_mplayfi_tclMsgSourceAvailableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgSourceAvailableStatus::most_mplayfi_tclMsgSourceAvailableStatus(const most_mplayfi_tclMsgSourceAvailableStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   bSourceAvailable = coRef.bSourceAvailable;
}
most_mplayfi_tclMsgSourceAvailableStatus& most_mplayfi_tclMsgSourceAvailableStatus::operator=(const most_mplayfi_tclMsgSourceAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   bSourceAvailable = coRef.bSourceAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgSourceAvailableStatus::most_mplayfi_tclMsgSourceAvailableStatus()
:bSourceAvailable(0)
 {}

tS32 most_mplayfi_tclMsgSourceAvailableStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_SourceAvailableStatus;
}


most_mplayfi_tclMsgSourceAvailableStatus::~most_mplayfi_tclMsgSourceAvailableStatus()
{}

tU32 most_mplayfi_tclMsgSourceAvailableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgSourceAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSourceAvailable);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgSourceAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSourceAvailable);
   return oOut;
}

tBool most_mplayfi_tclMsgSourceAvailableStatus::operator==(const most_mplayfi_tclMsgSourceAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSourceAvailable == roRef.bSourceAvailable);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgMediaPlayerListChangeUpReg::most_mplayfi_tclMsgMediaPlayerListChangeUpReg()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerListChangeUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeUpReg;
}


most_mplayfi_tclMsgMediaPlayerListChangeUpReg::~most_mplayfi_tclMsgMediaPlayerListChangeUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg::most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeRelUpReg;
}


most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg::~most_mplayfi_tclMsgMediaPlayerListChangeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMediaPlayerListChangeError::most_mplayfi_tclMsgMediaPlayerListChangeError(const most_mplayfi_tclMsgMediaPlayerListChangeError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgMediaPlayerListChangeError& most_mplayfi_tclMsgMediaPlayerListChangeError::operator=(const most_mplayfi_tclMsgMediaPlayerListChangeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgMediaPlayerListChangeError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeError;
}


most_mplayfi_tclMsgMediaPlayerListChangeError::~most_mplayfi_tclMsgMediaPlayerListChangeError()
{}

tBool most_mplayfi_tclMsgMediaPlayerListChangeError::operator==(const most_mplayfi_tclMsgMediaPlayerListChangeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMediaPlayerListChangeStatus::most_mplayfi_tclMsgMediaPlayerListChangeStatus(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   e8Change = coRef.e8Change;
   u32ListSize = coRef.u32ListSize;
   u8NumItems = coRef.u8NumItems;
   oItems = coRef.oItems;
}
most_mplayfi_tclMsgMediaPlayerListChangeStatus& most_mplayfi_tclMsgMediaPlayerListChangeStatus::operator=(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   e8Change = coRef.e8Change;
   u32ListSize = coRef.u32ListSize;
   u8NumItems = coRef.u8NumItems;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgMediaPlayerListChangeStatus::most_mplayfi_tclMsgMediaPlayerListChangeStatus()
:u32ListHandle(0)
,e8Change()
,u32ListSize(0)
,u8NumItems(0)
,oItems()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerListChangeStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerListChangeStatus;
}


most_mplayfi_tclMsgMediaPlayerListChangeStatus::~most_mplayfi_tclMsgMediaPlayerListChangeStatus()
{}

tU32 most_mplayfi_tclMsgMediaPlayerListChangeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oItems.u32GetSize(u16MajorVersion);
   return 10 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgMediaPlayerListChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> e8Change);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8NumItems);
   (tVoid) (oIn >> oItems);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgMediaPlayerListChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << e8Change);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8NumItems);
   (tVoid) (oOut << oItems);
   return oOut;
}

tBool most_mplayfi_tclMsgMediaPlayerListChangeStatus::operator==(const most_mplayfi_tclMsgMediaPlayerListChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (e8Change == roRef.e8Change);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8NumItems == roRef.u8NumItems);
   bResult = bResult && (oItems == roRef.oItems);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgNowPlayingUpReg::most_mplayfi_tclMsgNowPlayingUpReg()
 {}

tS32 most_mplayfi_tclMsgNowPlayingUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_NowPlayingUpReg;
}


most_mplayfi_tclMsgNowPlayingUpReg::~most_mplayfi_tclMsgNowPlayingUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgNowPlayingRelUpReg::most_mplayfi_tclMsgNowPlayingRelUpReg()
 {}

tS32 most_mplayfi_tclMsgNowPlayingRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_NowPlayingRelUpReg;
}


most_mplayfi_tclMsgNowPlayingRelUpReg::~most_mplayfi_tclMsgNowPlayingRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgNowPlayingGet::most_mplayfi_tclMsgNowPlayingGet()
 {}

tS32 most_mplayfi_tclMsgNowPlayingGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_NowPlayingGet;
}


most_mplayfi_tclMsgNowPlayingGet::~most_mplayfi_tclMsgNowPlayingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgNowPlayingError::most_mplayfi_tclMsgNowPlayingError(const most_mplayfi_tclMsgNowPlayingError& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_mplayfi_tclMsgNowPlayingError& most_mplayfi_tclMsgNowPlayingError::operator=(const most_mplayfi_tclMsgNowPlayingError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgNowPlayingError::most_mplayfi_tclMsgNowPlayingError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_mplayfi_tclMsgNowPlayingError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_NowPlayingError;
}


most_mplayfi_tclMsgNowPlayingError::~most_mplayfi_tclMsgNowPlayingError()
{}

tU32 most_mplayfi_tclMsgNowPlayingError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgNowPlayingError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgNowPlayingError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_mplayfi_tclMsgNowPlayingError::operator==(const most_mplayfi_tclMsgNowPlayingError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgNowPlayingStatus::most_mplayfi_tclMsgNowPlayingStatus(const most_mplayfi_tclMsgNowPlayingStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
}
most_mplayfi_tclMsgNowPlayingStatus& most_mplayfi_tclMsgNowPlayingStatus::operator=(const most_mplayfi_tclMsgNowPlayingStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgNowPlayingStatus::vDestroy()
{
   oMediaObject.vDestroy(); 
}

most_mplayfi_tclMsgNowPlayingStatus::most_mplayfi_tclMsgNowPlayingStatus()
:u32ListHandle(0)
,e8NowPlayingState()
,u32Position(0)
,u32Tag(0)
,oMediaObject()
 {}

tS32 most_mplayfi_tclMsgNowPlayingStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_NowPlayingStatus;
}


most_mplayfi_tclMsgNowPlayingStatus::~most_mplayfi_tclMsgNowPlayingStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgNowPlayingStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMediaObject.u32GetSize(u16MajorVersion);
   return 13 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgNowPlayingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> e8NowPlayingState);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> oMediaObject);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgNowPlayingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << e8NowPlayingState);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << oMediaObject);
   return oOut;
}

tBool most_mplayfi_tclMsgNowPlayingStatus::operator==(const most_mplayfi_tclMsgNowPlayingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (e8NowPlayingState == roRef.e8NowPlayingState);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (oMediaObject == roRef.oMediaObject);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgPlaytimeUpReg::most_mplayfi_tclMsgPlaytimeUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaytimeUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaytimeUpReg;
}


most_mplayfi_tclMsgPlaytimeUpReg::~most_mplayfi_tclMsgPlaytimeUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaytimeRelUpReg::most_mplayfi_tclMsgPlaytimeRelUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaytimeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaytimeRelUpReg;
}


most_mplayfi_tclMsgPlaytimeRelUpReg::~most_mplayfi_tclMsgPlaytimeRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaytimeGet::most_mplayfi_tclMsgPlaytimeGet()
 {}

tS32 most_mplayfi_tclMsgPlaytimeGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaytimeGet;
}


most_mplayfi_tclMsgPlaytimeGet::~most_mplayfi_tclMsgPlaytimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaytimeError::most_mplayfi_tclMsgPlaytimeError(const most_mplayfi_tclMsgPlaytimeError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlaytimeError& most_mplayfi_tclMsgPlaytimeError::operator=(const most_mplayfi_tclMsgPlaytimeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlaytimeError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaytimeError;
}


most_mplayfi_tclMsgPlaytimeError::~most_mplayfi_tclMsgPlaytimeError()
{}

tBool most_mplayfi_tclMsgPlaytimeError::operator==(const most_mplayfi_tclMsgPlaytimeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaytimeStatus::most_mplayfi_tclMsgPlaytimeStatus(const most_mplayfi_tclMsgPlaytimeStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
}
most_mplayfi_tclMsgPlaytimeStatus& most_mplayfi_tclMsgPlaytimeStatus::operator=(const most_mplayfi_tclMsgPlaytimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlaytimeStatus::most_mplayfi_tclMsgPlaytimeStatus()
:u32ElapsedPlaytime(0)
,u32TotalPlaytime(0)
 {}

tS32 most_mplayfi_tclMsgPlaytimeStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaytimeStatus;
}


most_mplayfi_tclMsgPlaytimeStatus::~most_mplayfi_tclMsgPlaytimeStatus()
{}

tU32 most_mplayfi_tclMsgPlaytimeStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_mplayfi_tclMsgPlaytimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ElapsedPlaytime);
   (tVoid) (oIn >> u32TotalPlaytime);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlaytimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ElapsedPlaytime);
   (tVoid) (oOut << u32TotalPlaytime);
   return oOut;
}

tBool most_mplayfi_tclMsgPlaytimeStatus::operator==(const most_mplayfi_tclMsgPlaytimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ElapsedPlaytime == roRef.u32ElapsedPlaytime);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgPlaybackStateUpReg::most_mplayfi_tclMsgPlaybackStateUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaybackStateUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackStateUpReg;
}


most_mplayfi_tclMsgPlaybackStateUpReg::~most_mplayfi_tclMsgPlaybackStateUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaybackStateRelUpReg::most_mplayfi_tclMsgPlaybackStateRelUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaybackStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackStateRelUpReg;
}


most_mplayfi_tclMsgPlaybackStateRelUpReg::~most_mplayfi_tclMsgPlaybackStateRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaybackStateGet::most_mplayfi_tclMsgPlaybackStateGet()
 {}

tS32 most_mplayfi_tclMsgPlaybackStateGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackStateGet;
}


most_mplayfi_tclMsgPlaybackStateGet::~most_mplayfi_tclMsgPlaybackStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaybackStateError::most_mplayfi_tclMsgPlaybackStateError(const most_mplayfi_tclMsgPlaybackStateError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlaybackStateError& most_mplayfi_tclMsgPlaybackStateError::operator=(const most_mplayfi_tclMsgPlaybackStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlaybackStateError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackStateError;
}


most_mplayfi_tclMsgPlaybackStateError::~most_mplayfi_tclMsgPlaybackStateError()
{}

tBool most_mplayfi_tclMsgPlaybackStateError::operator==(const most_mplayfi_tclMsgPlaybackStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaybackStateStatus::most_mplayfi_tclMsgPlaybackStateStatus(const most_mplayfi_tclMsgPlaybackStateStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
most_mplayfi_tclMsgPlaybackStateStatus& most_mplayfi_tclMsgPlaybackStateStatus::operator=(const most_mplayfi_tclMsgPlaybackStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlaybackStateStatus::most_mplayfi_tclMsgPlaybackStateStatus()
:e8State()
 {}

tS32 most_mplayfi_tclMsgPlaybackStateStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackStateStatus;
}


most_mplayfi_tclMsgPlaybackStateStatus::~most_mplayfi_tclMsgPlaybackStateStatus()
{}

tU32 most_mplayfi_tclMsgPlaybackStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgPlaybackStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlaybackStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool most_mplayfi_tclMsgPlaybackStateStatus::operator==(const most_mplayfi_tclMsgPlaybackStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgPlaybackModeUpReg::most_mplayfi_tclMsgPlaybackModeUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaybackModeUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModeUpReg;
}


most_mplayfi_tclMsgPlaybackModeUpReg::~most_mplayfi_tclMsgPlaybackModeUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaybackModeRelUpReg::most_mplayfi_tclMsgPlaybackModeRelUpReg()
 {}

tS32 most_mplayfi_tclMsgPlaybackModeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModeRelUpReg;
}


most_mplayfi_tclMsgPlaybackModeRelUpReg::~most_mplayfi_tclMsgPlaybackModeRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgPlaybackModeGet::most_mplayfi_tclMsgPlaybackModeGet()
 {}

tS32 most_mplayfi_tclMsgPlaybackModeGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModeGet;
}


most_mplayfi_tclMsgPlaybackModeGet::~most_mplayfi_tclMsgPlaybackModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaybackModePureSet::most_mplayfi_tclMsgPlaybackModePureSet(const most_mplayfi_tclMsgPlaybackModePureSet& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
most_mplayfi_tclMsgPlaybackModePureSet& most_mplayfi_tclMsgPlaybackModePureSet::operator=(const most_mplayfi_tclMsgPlaybackModePureSet& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlaybackModePureSet::most_mplayfi_tclMsgPlaybackModePureSet()
:e8Mode()
 {}

tS32 most_mplayfi_tclMsgPlaybackModePureSet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModePureSet;
}


most_mplayfi_tclMsgPlaybackModePureSet::~most_mplayfi_tclMsgPlaybackModePureSet()
{}

tU32 most_mplayfi_tclMsgPlaybackModePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgPlaybackModePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlaybackModePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool most_mplayfi_tclMsgPlaybackModePureSet::operator==(const most_mplayfi_tclMsgPlaybackModePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaybackModeError::most_mplayfi_tclMsgPlaybackModeError(const most_mplayfi_tclMsgPlaybackModeError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgPlaybackModeError& most_mplayfi_tclMsgPlaybackModeError::operator=(const most_mplayfi_tclMsgPlaybackModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgPlaybackModeError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModeError;
}


most_mplayfi_tclMsgPlaybackModeError::~most_mplayfi_tclMsgPlaybackModeError()
{}

tBool most_mplayfi_tclMsgPlaybackModeError::operator==(const most_mplayfi_tclMsgPlaybackModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgPlaybackModeStatus::most_mplayfi_tclMsgPlaybackModeStatus(const most_mplayfi_tclMsgPlaybackModeStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
most_mplayfi_tclMsgPlaybackModeStatus& most_mplayfi_tclMsgPlaybackModeStatus::operator=(const most_mplayfi_tclMsgPlaybackModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgPlaybackModeStatus::most_mplayfi_tclMsgPlaybackModeStatus()
:e8Mode()
 {}

tS32 most_mplayfi_tclMsgPlaybackModeStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_PlaybackModeStatus;
}


most_mplayfi_tclMsgPlaybackModeStatus::~most_mplayfi_tclMsgPlaybackModeStatus()
{}

tU32 most_mplayfi_tclMsgPlaybackModeStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgPlaybackModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgPlaybackModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool most_mplayfi_tclMsgPlaybackModeStatus::operator==(const most_mplayfi_tclMsgPlaybackModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgRepeatModeUpReg::most_mplayfi_tclMsgRepeatModeUpReg()
 {}

tS32 most_mplayfi_tclMsgRepeatModeUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModeUpReg;
}


most_mplayfi_tclMsgRepeatModeUpReg::~most_mplayfi_tclMsgRepeatModeUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgRepeatModeRelUpReg::most_mplayfi_tclMsgRepeatModeRelUpReg()
 {}

tS32 most_mplayfi_tclMsgRepeatModeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModeRelUpReg;
}


most_mplayfi_tclMsgRepeatModeRelUpReg::~most_mplayfi_tclMsgRepeatModeRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgRepeatModeGet::most_mplayfi_tclMsgRepeatModeGet()
 {}

tS32 most_mplayfi_tclMsgRepeatModeGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModeGet;
}


most_mplayfi_tclMsgRepeatModeGet::~most_mplayfi_tclMsgRepeatModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRepeatModePureSet::most_mplayfi_tclMsgRepeatModePureSet(const most_mplayfi_tclMsgRepeatModePureSet& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8Repeat = coRef.e8Repeat;
}
most_mplayfi_tclMsgRepeatModePureSet& most_mplayfi_tclMsgRepeatModePureSet::operator=(const most_mplayfi_tclMsgRepeatModePureSet& coRef)
{
   if (this == &coRef) return *this;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRepeatModePureSet::most_mplayfi_tclMsgRepeatModePureSet()
:e8Repeat()
 {}

tS32 most_mplayfi_tclMsgRepeatModePureSet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModePureSet;
}


most_mplayfi_tclMsgRepeatModePureSet::~most_mplayfi_tclMsgRepeatModePureSet()
{}

tU32 most_mplayfi_tclMsgRepeatModePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgRepeatModePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRepeatModePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool most_mplayfi_tclMsgRepeatModePureSet::operator==(const most_mplayfi_tclMsgRepeatModePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRepeatModeError::most_mplayfi_tclMsgRepeatModeError(const most_mplayfi_tclMsgRepeatModeError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgRepeatModeError& most_mplayfi_tclMsgRepeatModeError::operator=(const most_mplayfi_tclMsgRepeatModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgRepeatModeError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModeError;
}


most_mplayfi_tclMsgRepeatModeError::~most_mplayfi_tclMsgRepeatModeError()
{}

tBool most_mplayfi_tclMsgRepeatModeError::operator==(const most_mplayfi_tclMsgRepeatModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgRepeatModeStatus::most_mplayfi_tclMsgRepeatModeStatus(const most_mplayfi_tclMsgRepeatModeStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   e8Repeat = coRef.e8Repeat;
}
most_mplayfi_tclMsgRepeatModeStatus& most_mplayfi_tclMsgRepeatModeStatus::operator=(const most_mplayfi_tclMsgRepeatModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgRepeatModeStatus::most_mplayfi_tclMsgRepeatModeStatus()
:e8Repeat()
 {}

tS32 most_mplayfi_tclMsgRepeatModeStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_RepeatModeStatus;
}


most_mplayfi_tclMsgRepeatModeStatus::~most_mplayfi_tclMsgRepeatModeStatus()
{}

tU32 most_mplayfi_tclMsgRepeatModeStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgRepeatModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgRepeatModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool most_mplayfi_tclMsgRepeatModeStatus::operator==(const most_mplayfi_tclMsgRepeatModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgIndexingStateUpReg::most_mplayfi_tclMsgIndexingStateUpReg()
 {}

tS32 most_mplayfi_tclMsgIndexingStateUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_IndexingStateUpReg;
}


most_mplayfi_tclMsgIndexingStateUpReg::~most_mplayfi_tclMsgIndexingStateUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgIndexingStateRelUpReg::most_mplayfi_tclMsgIndexingStateRelUpReg()
 {}

tS32 most_mplayfi_tclMsgIndexingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_IndexingStateRelUpReg;
}


most_mplayfi_tclMsgIndexingStateRelUpReg::~most_mplayfi_tclMsgIndexingStateRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgIndexingStateGet::most_mplayfi_tclMsgIndexingStateGet()
 {}

tS32 most_mplayfi_tclMsgIndexingStateGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_IndexingStateGet;
}


most_mplayfi_tclMsgIndexingStateGet::~most_mplayfi_tclMsgIndexingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgIndexingStateError::most_mplayfi_tclMsgIndexingStateError(const most_mplayfi_tclMsgIndexingStateError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgIndexingStateError& most_mplayfi_tclMsgIndexingStateError::operator=(const most_mplayfi_tclMsgIndexingStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgIndexingStateError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_IndexingStateError;
}


most_mplayfi_tclMsgIndexingStateError::~most_mplayfi_tclMsgIndexingStateError()
{}

tBool most_mplayfi_tclMsgIndexingStateError::operator==(const most_mplayfi_tclMsgIndexingStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgIndexingStateStatus::most_mplayfi_tclMsgIndexingStateStatus(const most_mplayfi_tclMsgIndexingStateStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oIndexingStateResult = coRef.oIndexingStateResult;
}
most_mplayfi_tclMsgIndexingStateStatus& most_mplayfi_tclMsgIndexingStateStatus::operator=(const most_mplayfi_tclMsgIndexingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   oIndexingStateResult = coRef.oIndexingStateResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgIndexingStateStatus::most_mplayfi_tclMsgIndexingStateStatus()
:oIndexingStateResult()
 {}

tS32 most_mplayfi_tclMsgIndexingStateStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_IndexingStateStatus;
}


most_mplayfi_tclMsgIndexingStateStatus::~most_mplayfi_tclMsgIndexingStateStatus()
{}

tU32 most_mplayfi_tclMsgIndexingStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oIndexingStateResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgIndexingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oIndexingStateResult);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgIndexingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oIndexingStateResult);
   return oOut;
}

tBool most_mplayfi_tclMsgIndexingStateStatus::operator==(const most_mplayfi_tclMsgIndexingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oIndexingStateResult == roRef.oIndexingStateResult);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsUpReg;
}


most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg::~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsRelUpReg;
}


most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsGet;
}


most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet::~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError::operator=(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsError;
}


most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError::~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError()
{}

tBool most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError::operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8NumDevices = coRef.u8NumDevices;
   oDeviceInfo = coRef.oDeviceInfo;
}
most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::operator=(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NumDevices = coRef.u8NumDevices;
   oDeviceInfo = coRef.oDeviceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::vDestroy()
{
}

most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus()
:u8NumDevices(0)
,oDeviceInfo()
 {}

tS32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MediaPlayerDeviceConnectionsStatus;
}


most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::~most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumDevices);
   (tVoid) (oIn >> oDeviceInfo);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumDevices);
   (tVoid) (oOut << oDeviceInfo);
   return oOut;
}

tBool most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus::operator==(const most_mplayfi_tclMsgMediaPlayerDeviceConnectionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumDevices == roRef.u8NumDevices);
   bResult = bResult && (oDeviceInfo == roRef.oDeviceInfo);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgActiveMediaDeviceUpReg::most_mplayfi_tclMsgActiveMediaDeviceUpReg()
 {}

tS32 most_mplayfi_tclMsgActiveMediaDeviceUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceUpReg;
}


most_mplayfi_tclMsgActiveMediaDeviceUpReg::~most_mplayfi_tclMsgActiveMediaDeviceUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgActiveMediaDeviceRelUpReg::most_mplayfi_tclMsgActiveMediaDeviceRelUpReg()
 {}

tS32 most_mplayfi_tclMsgActiveMediaDeviceRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceRelUpReg;
}


most_mplayfi_tclMsgActiveMediaDeviceRelUpReg::~most_mplayfi_tclMsgActiveMediaDeviceRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgActiveMediaDeviceGet::most_mplayfi_tclMsgActiveMediaDeviceGet()
 {}

tS32 most_mplayfi_tclMsgActiveMediaDeviceGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceGet;
}


most_mplayfi_tclMsgActiveMediaDeviceGet::~most_mplayfi_tclMsgActiveMediaDeviceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActiveMediaDevicePureSet::most_mplayfi_tclMsgActiveMediaDevicePureSet(const most_mplayfi_tclMsgActiveMediaDevicePureSet& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
}
most_mplayfi_tclMsgActiveMediaDevicePureSet& most_mplayfi_tclMsgActiveMediaDevicePureSet::operator=(const most_mplayfi_tclMsgActiveMediaDevicePureSet& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgActiveMediaDevicePureSet::most_mplayfi_tclMsgActiveMediaDevicePureSet()
:u8DeviceTag(0)
,bDeviceActiveSource(0)
 {}

tS32 most_mplayfi_tclMsgActiveMediaDevicePureSet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDevicePureSet;
}


most_mplayfi_tclMsgActiveMediaDevicePureSet::~most_mplayfi_tclMsgActiveMediaDevicePureSet()
{}

tU32 most_mplayfi_tclMsgActiveMediaDevicePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_mplayfi_tclMsgActiveMediaDevicePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> bDeviceActiveSource);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgActiveMediaDevicePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << bDeviceActiveSource);
   return oOut;
}

tBool most_mplayfi_tclMsgActiveMediaDevicePureSet::operator==(const most_mplayfi_tclMsgActiveMediaDevicePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (bDeviceActiveSource == roRef.bDeviceActiveSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActiveMediaDeviceError::most_mplayfi_tclMsgActiveMediaDeviceError(const most_mplayfi_tclMsgActiveMediaDeviceError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgActiveMediaDeviceError& most_mplayfi_tclMsgActiveMediaDeviceError::operator=(const most_mplayfi_tclMsgActiveMediaDeviceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgActiveMediaDeviceError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceError;
}


most_mplayfi_tclMsgActiveMediaDeviceError::~most_mplayfi_tclMsgActiveMediaDeviceError()
{}

tBool most_mplayfi_tclMsgActiveMediaDeviceError::operator==(const most_mplayfi_tclMsgActiveMediaDeviceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgActiveMediaDeviceStatus::most_mplayfi_tclMsgActiveMediaDeviceStatus(const most_mplayfi_tclMsgActiveMediaDeviceStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   oDeviceInfo = coRef.oDeviceInfo;
}
most_mplayfi_tclMsgActiveMediaDeviceStatus& most_mplayfi_tclMsgActiveMediaDeviceStatus::operator=(const most_mplayfi_tclMsgActiveMediaDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   oDeviceInfo = coRef.oDeviceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgActiveMediaDeviceStatus::vDestroy()
{
}

most_mplayfi_tclMsgActiveMediaDeviceStatus::most_mplayfi_tclMsgActiveMediaDeviceStatus()
:oDeviceInfo()
 {}

tS32 most_mplayfi_tclMsgActiveMediaDeviceStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_ActiveMediaDeviceStatus;
}


most_mplayfi_tclMsgActiveMediaDeviceStatus::~most_mplayfi_tclMsgActiveMediaDeviceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgActiveMediaDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceInfo.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgActiveMediaDeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceInfo);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgActiveMediaDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceInfo);
   return oOut;
}

tBool most_mplayfi_tclMsgActiveMediaDeviceStatus::operator==(const most_mplayfi_tclMsgActiveMediaDeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceInfo == roRef.oDeviceInfo);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgMyMediaSupportedGet::most_mplayfi_tclMsgMyMediaSupportedGet()
 {}

tS32 most_mplayfi_tclMsgMyMediaSupportedGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MyMediaSupportedGet;
}


most_mplayfi_tclMsgMyMediaSupportedGet::~most_mplayfi_tclMsgMyMediaSupportedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMyMediaSupportedError::most_mplayfi_tclMsgMyMediaSupportedError(const most_mplayfi_tclMsgMyMediaSupportedError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgMyMediaSupportedError& most_mplayfi_tclMsgMyMediaSupportedError::operator=(const most_mplayfi_tclMsgMyMediaSupportedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgMyMediaSupportedError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MyMediaSupportedError;
}


most_mplayfi_tclMsgMyMediaSupportedError::~most_mplayfi_tclMsgMyMediaSupportedError()
{}

tBool most_mplayfi_tclMsgMyMediaSupportedError::operator==(const most_mplayfi_tclMsgMyMediaSupportedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgMyMediaSupportedStatus::most_mplayfi_tclMsgMyMediaSupportedStatus(const most_mplayfi_tclMsgMyMediaSupportedStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   bMyMediaSupportedFlag = coRef.bMyMediaSupportedFlag;
}
most_mplayfi_tclMsgMyMediaSupportedStatus& most_mplayfi_tclMsgMyMediaSupportedStatus::operator=(const most_mplayfi_tclMsgMyMediaSupportedStatus& coRef)
{
   if (this == &coRef) return *this;
   bMyMediaSupportedFlag = coRef.bMyMediaSupportedFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_mplayfi_tclMsgMyMediaSupportedStatus::most_mplayfi_tclMsgMyMediaSupportedStatus()
:bMyMediaSupportedFlag(0)
 {}

tS32 most_mplayfi_tclMsgMyMediaSupportedStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_MyMediaSupportedStatus;
}


most_mplayfi_tclMsgMyMediaSupportedStatus::~most_mplayfi_tclMsgMyMediaSupportedStatus()
{}

tU32 most_mplayfi_tclMsgMyMediaSupportedStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_mplayfi_tclMsgMyMediaSupportedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMyMediaSupportedFlag);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgMyMediaSupportedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMyMediaSupportedFlag);
   return oOut;
}

tBool most_mplayfi_tclMsgMyMediaSupportedStatus::operator==(const most_mplayfi_tclMsgMyMediaSupportedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMyMediaSupportedFlag == roRef.bMyMediaSupportedFlag);
   return bResult;
}

//=============================================================================

most_mplayfi_tclMsgCurrentFolderPathUpReg::most_mplayfi_tclMsgCurrentFolderPathUpReg()
 {}

tS32 most_mplayfi_tclMsgCurrentFolderPathUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CurrentFolderPathUpReg;
}


most_mplayfi_tclMsgCurrentFolderPathUpReg::~most_mplayfi_tclMsgCurrentFolderPathUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgCurrentFolderPathRelUpReg::most_mplayfi_tclMsgCurrentFolderPathRelUpReg()
 {}

tS32 most_mplayfi_tclMsgCurrentFolderPathRelUpReg::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CurrentFolderPathRelUpReg;
}


most_mplayfi_tclMsgCurrentFolderPathRelUpReg::~most_mplayfi_tclMsgCurrentFolderPathRelUpReg()
{}

//=============================================================================

most_mplayfi_tclMsgCurrentFolderPathGet::most_mplayfi_tclMsgCurrentFolderPathGet()
 {}

tS32 most_mplayfi_tclMsgCurrentFolderPathGet::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CurrentFolderPathGet;
}


most_mplayfi_tclMsgCurrentFolderPathGet::~most_mplayfi_tclMsgCurrentFolderPathGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCurrentFolderPathError::most_mplayfi_tclMsgCurrentFolderPathError(const most_mplayfi_tclMsgCurrentFolderPathError& coRef)
   : most_mplayfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_mplayfi_tclMsgCurrentFolderPathError& most_mplayfi_tclMsgCurrentFolderPathError::operator=(const most_mplayfi_tclMsgCurrentFolderPathError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_mplayfi_tclMsgCurrentFolderPathError::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CurrentFolderPathError;
}


most_mplayfi_tclMsgCurrentFolderPathError::~most_mplayfi_tclMsgCurrentFolderPathError()
{}

tBool most_mplayfi_tclMsgCurrentFolderPathError::operator==(const most_mplayfi_tclMsgCurrentFolderPathError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_mplayfi_tclMsgCurrentFolderPathStatus::most_mplayfi_tclMsgCurrentFolderPathStatus(const most_mplayfi_tclMsgCurrentFolderPathStatus& coRef)
   : most_mplayfi_tclMsgBaseMessage(coRef)
{
   sCurrentFolderPath = coRef.sCurrentFolderPath;
   u32ListHandle = coRef.u32ListHandle;
}
most_mplayfi_tclMsgCurrentFolderPathStatus& most_mplayfi_tclMsgCurrentFolderPathStatus::operator=(const most_mplayfi_tclMsgCurrentFolderPathStatus& coRef)
{
   if (this == &coRef) return *this;
   sCurrentFolderPath = coRef.sCurrentFolderPath;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_mplayfi_tclMsgCurrentFolderPathStatus::vDestroy()
{
   sCurrentFolderPath.vDestroy(); 
}

most_mplayfi_tclMsgCurrentFolderPathStatus::most_mplayfi_tclMsgCurrentFolderPathStatus()
:sCurrentFolderPath()
,u32ListHandle(0)
 {}

tS32 most_mplayfi_tclMsgCurrentFolderPathStatus::s32GetTypeId() const
{
   return (tS32) most_mplayfi_tclToken::EN_MSG_CurrentFolderPathStatus;
}


most_mplayfi_tclMsgCurrentFolderPathStatus::~most_mplayfi_tclMsgCurrentFolderPathStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_mplayfi_tclMsgCurrentFolderPathStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sCurrentFolderPath.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_mplayfi_tclMsgCurrentFolderPathStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCurrentFolderPath);
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& most_mplayfi_tclMsgCurrentFolderPathStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCurrentFolderPath);
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool most_mplayfi_tclMsgCurrentFolderPathStatus::operator==(const most_mplayfi_tclMsgCurrentFolderPathStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCurrentFolderPath == roRef.sCurrentFolderPath);
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

