/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "midw_fi_gen_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 midw_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 midw_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 midw_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 midw_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 midw_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 midw_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 midw_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 midw_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 midw_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 midw_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 midw_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& midw_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 midw_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& midw_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 midw_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid midw_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tclString::~midw_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

midw_fi_tclString& midw_fi_tclString::operator=(const midw_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

midw_fi_tclString::midw_fi_tclString(const midw_fi_tclString& coRef):midw_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& midw_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool midw_fi_tclString::operator==(const midw_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 midw_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
midw_fi_tclString& midw_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
midw_fi_tclString::midw_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool midw_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

midw_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

midw_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool midw_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar midw_FI_C_U8_NULLCHAR = '\0';

tChar* midw_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* midw_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* midw_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& midw_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}

tChar& midw_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}

tChar& midw_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool midw_fi_tclString::bSet(const midw_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool midw_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString midw_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& midw_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool midw_fi_tclList::operator==(const midw_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 midw_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& midw_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid midw_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tclMultiLanguageString::~midw_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

midw_fi_tclMultiLanguageString& midw_fi_tclMultiLanguageString::operator=(const midw_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

midw_fi_tclMultiLanguageString::midw_fi_tclMultiLanguageString(const midw_fi_tclMultiLanguageString& coRef):midw_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& midw_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool midw_fi_tclMultiLanguageString::operator==(const midw_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 midw_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
midw_fi_tclMultiLanguageString& midw_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
midw_fi_tclMultiLanguageString::midw_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool midw_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

midw_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

midw_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool midw_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* midw_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* midw_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* midw_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& midw_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}

tChar& midw_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}

tChar& midw_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return midw_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool midw_fi_tclMultiLanguageString::bSet(const midw_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool midw_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString midw_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_BinContainer::midw_fi_tcl_BinContainer(const midw_fi_tcl_BinContainer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
midw_fi_tcl_BinContainer& midw_fi_tcl_BinContainer::operator=(const midw_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

midw_fi_tcl_BinContainer::midw_fi_tcl_BinContainer()

 {}

tS32 midw_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_BINCONTAINER;
}


midw_fi_tcl_BinContainer::~midw_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& midw_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_BinContainer::operator==(const midw_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_fi_tcl_Reserved::midw_fi_tcl_Reserved()
 {}

tS32 midw_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_RESERVED;
}


midw_fi_tcl_Reserved::~midw_fi_tcl_Reserved()
{}

tU32 midw_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& midw_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u8_Percent::midw_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8_PERCENT;
}


midw_fi_tcl_u8_Percent::~midw_fi_tcl_u8_Percent()
{}

tU32 midw_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_PerThousand::midw_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


midw_fi_tcl_s16_PerThousand::~midw_fi_tcl_s16_PerThousand()
{}

tU32 midw_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16_IndexInReferenceList::midw_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


midw_fi_tcl_u16_IndexInReferenceList::~midw_fi_tcl_u16_IndexInReferenceList()
{}

tU32 midw_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16_ErrorCode::midw_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16_ERRORCODE;
}


midw_fi_tcl_u16_ErrorCode::~midw_fi_tcl_u16_ErrorCode()
{}

tU32 midw_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16_RPM::midw_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16_RPM;
}


midw_fi_tcl_u16_RPM::~midw_fi_tcl_u16_RPM()
{}

tU32 midw_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Kilogram::midw_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_KILOGRAM;
}


midw_fi_tcl_s32_Kilogram::~midw_fi_tcl_s32_Kilogram()
{}

tU32 midw_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Pound::midw_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_POUND;
}


midw_fi_tcl_s32_Pound::~midw_fi_tcl_s32_Pound()
{}

tU32 midw_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_Meter::midw_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_METER;
}


midw_fi_tcl_s16_Meter::~midw_fi_tcl_s16_Meter()
{}

tU32 midw_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Meter::midw_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_METER;
}


midw_fi_tcl_s32_Meter::~midw_fi_tcl_s32_Meter()
{}

tU32 midw_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Yards::midw_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_YARDS;
}


midw_fi_tcl_s32_Yards::~midw_fi_tcl_s32_Yards()
{}

tU32 midw_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Foot::midw_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_FOOT;
}


midw_fi_tcl_s32_Foot::~midw_fi_tcl_s32_Foot()
{}

tU32 midw_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Centimeter::midw_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_CENTIMETER;
}


midw_fi_tcl_s32_Centimeter::~midw_fi_tcl_s32_Centimeter()
{}

tU32 midw_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Inch::midw_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_INCH;
}


midw_fi_tcl_s32_Inch::~midw_fi_tcl_s32_Inch()
{}

tU32 midw_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Millimeter::midw_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_MILLIMETER;
}


midw_fi_tcl_s32_Millimeter::~midw_fi_tcl_s32_Millimeter()
{}

tU32 midw_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Microliter::midw_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_MICROLITER;
}


midw_fi_tcl_s32_Microliter::~midw_fi_tcl_s32_Microliter()
{}

tU32 midw_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Second::midw_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_SECOND;
}


midw_fi_tcl_s32_Second::~midw_fi_tcl_s32_Second()
{}

tU32 midw_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16_MilliSecond::midw_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16_MILLISECOND;
}


midw_fi_tcl_u16_MilliSecond::~midw_fi_tcl_u16_MilliSecond()
{}

tU32 midw_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_MilliSecond::midw_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_MILLISECOND;
}


midw_fi_tcl_s32_MilliSecond::~midw_fi_tcl_s32_MilliSecond()
{}

tU32 midw_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_POSIXTime::midw_fi_tcl_POSIXTime(const midw_fi_tcl_POSIXTime& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
midw_fi_tcl_POSIXTime& midw_fi_tcl_POSIXTime::operator=(const midw_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_POSIXTime::midw_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 midw_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_POSIXTIME;
}


midw_fi_tcl_POSIXTime::~midw_fi_tcl_POSIXTime()
{}

tU32 midw_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool midw_fi_tcl_POSIXTime::operator==(const midw_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DST_State::midw_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 midw_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DST_STATE;
}


midw_fi_tcl_e8_DST_State::~midw_fi_tcl_e8_DST_State()
{}

tU32 midw_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TimeZoneElement::midw_fi_tcl_TimeZoneElement(const midw_fi_tcl_TimeZoneElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
midw_fi_tcl_TimeZoneElement& midw_fi_tcl_TimeZoneElement::operator=(const midw_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

midw_fi_tcl_TimeZoneElement::midw_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 midw_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


midw_fi_tcl_TimeZoneElement::~midw_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& midw_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TimeZoneElement::operator==(const midw_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_KmPerHour::midw_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_KMPERHOUR;
}


midw_fi_tcl_s16_KmPerHour::~midw_fi_tcl_s16_KmPerHour()
{}

tU32 midw_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_MilesPerHour::midw_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


midw_fi_tcl_s16_MilesPerHour::~midw_fi_tcl_s16_MilesPerHour()
{}

tU32 midw_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_Knot::midw_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_KNOT;
}


midw_fi_tcl_s16_Knot::~midw_fi_tcl_s16_Knot()
{}

tU32 midw_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_CentimeterSecond::midw_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


midw_fi_tcl_s16_CentimeterSecond::~midw_fi_tcl_s16_CentimeterSecond()
{}

tU32 midw_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_Kelvin::midw_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_KELVIN;
}


midw_fi_tcl_s16_Kelvin::~midw_fi_tcl_s16_Kelvin()
{}

tU32 midw_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_Fahrenheit::midw_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


midw_fi_tcl_s16_Fahrenheit::~midw_fi_tcl_s16_Fahrenheit()
{}

tU32 midw_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Pascal::midw_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_PASCAL;
}


midw_fi_tcl_s32_Pascal::~midw_fi_tcl_s32_Pascal()
{}

tU32 midw_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Watt::midw_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_WATT;
}


midw_fi_tcl_s32_Watt::~midw_fi_tcl_s32_Watt()
{}

tU32 midw_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_FIVersion::midw_fi_tcl_FIVersion(const midw_fi_tcl_FIVersion& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
midw_fi_tcl_FIVersion& midw_fi_tcl_FIVersion::operator=(const midw_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_FIVersion::midw_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 midw_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_FIVERSION;
}


midw_fi_tcl_FIVersion::~midw_fi_tcl_FIVersion()
{}

tU32 midw_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool midw_fi_tcl_FIVersion::operator==(const midw_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Longitude::midw_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_LONGITUDE;
}


midw_fi_tcl_s32_Longitude::~midw_fi_tcl_s32_Longitude()
{}

tU32 midw_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s32_Latitude::midw_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 midw_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S32_LATITUDE;
}


midw_fi_tcl_s32_Latitude::~midw_fi_tcl_s32_Latitude()
{}

tU32 midw_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& midw_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_PositionWGS84::midw_fi_tcl_PositionWGS84(const midw_fi_tcl_PositionWGS84& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
midw_fi_tcl_PositionWGS84& midw_fi_tcl_PositionWGS84::operator=(const midw_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_PositionWGS84::midw_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 midw_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_POSITIONWGS84;
}


midw_fi_tcl_PositionWGS84::~midw_fi_tcl_PositionWGS84()
{}

tU32 midw_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool midw_fi_tcl_PositionWGS84::operator==(const midw_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_RectangleWGS84::midw_fi_tcl_RectangleWGS84(const midw_fi_tcl_RectangleWGS84& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
midw_fi_tcl_RectangleWGS84& midw_fi_tcl_RectangleWGS84::operator=(const midw_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_RectangleWGS84::midw_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 midw_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_RECTANGLEWGS84;
}


midw_fi_tcl_RectangleWGS84::~midw_fi_tcl_RectangleWGS84()
{}

tU32 midw_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool midw_fi_tcl_RectangleWGS84::operator==(const midw_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_ISOCountryCode::midw_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 midw_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


midw_fi_tcl_e16_ISOCountryCode::~midw_fi_tcl_e16_ISOCountryCode()
{}

tU32 midw_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_ISOLanguageCode::midw_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 midw_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


midw_fi_tcl_e16_ISOLanguageCode::~midw_fi_tcl_e16_ISOLanguageCode()
{}

tU32 midw_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_LanguageID::midw_fi_tcl_LanguageID(const midw_fi_tcl_LanguageID& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
midw_fi_tcl_LanguageID& midw_fi_tcl_LanguageID::operator=(const midw_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_LanguageID::midw_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 midw_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_LANGUAGEID;
}


midw_fi_tcl_LanguageID::~midw_fi_tcl_LanguageID()
{}

tU32 midw_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool midw_fi_tcl_LanguageID::operator==(const midw_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u8_DirectionAbsolute::midw_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


midw_fi_tcl_u8_DirectionAbsolute::~midw_fi_tcl_u8_DirectionAbsolute()
{}

tU32 midw_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u8_DirectionRelative::midw_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 midw_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


midw_fi_tcl_u8_DirectionRelative::~midw_fi_tcl_u8_DirectionRelative()
{}

tU32 midw_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_CentiDegree::midw_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


midw_fi_tcl_s16_CentiDegree::~midw_fi_tcl_s16_CentiDegree()
{}

tU32 midw_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_Degree::midw_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_DEGREE;
}


midw_fi_tcl_s16_Degree::~midw_fi_tcl_s16_Degree()
{}

tU32 midw_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::midw_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::~midw_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_s16_DirectionRelative_CentiDegree::midw_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 midw_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


midw_fi_tcl_s16_DirectionRelative_CentiDegree::~midw_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 midw_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& midw_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_FuelType::midw_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 midw_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_FUELTYPE;
}


midw_fi_tcl_e8_FuelType::~midw_fi_tcl_e8_FuelType()
{}

tU32 midw_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DistTimeFuel::midw_fi_tcl_DistTimeFuel(const midw_fi_tcl_DistTimeFuel& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
midw_fi_tcl_DistTimeFuel& midw_fi_tcl_DistTimeFuel::operator=(const midw_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_DistTimeFuel::midw_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 midw_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISTTIMEFUEL;
}


midw_fi_tcl_DistTimeFuel::~midw_fi_tcl_DistTimeFuel()
{}

tU32 midw_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool midw_fi_tcl_DistTimeFuel::operator==(const midw_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u8TstSrvATestResult::midw_fi_tcl_u8TstSrvATestResult():enType(FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_FAILURE) {}

tS32 midw_fi_tcl_u8TstSrvATestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8TSTSRVATESTRESULT;
}


midw_fi_tcl_u8TstSrvATestResult::~midw_fi_tcl_u8TstSrvATestResult()
{}

tU32 midw_fi_tcl_u8TstSrvATestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_u8TstSrvATestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u8TstSrvATestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16TstSrvAEnumeration2::midw_fi_tcl_u16TstSrvAEnumeration2():enType(FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000) {}

tS32 midw_fi_tcl_u16TstSrvAEnumeration2::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16TSTSRVAENUMERATION2;
}


midw_fi_tcl_u16TstSrvAEnumeration2::~midw_fi_tcl_u16TstSrvAEnumeration2()
{}

tU32 midw_fi_tcl_u16TstSrvAEnumeration2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16TstSrvAEnumeration2::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u16TstSrvAEnumeration2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TstSrvB_u8Enumeration1::midw_fi_tcl_TstSrvB_u8Enumeration1():enType(FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X00) {}

tS32 midw_fi_tcl_TstSrvB_u8Enumeration1::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TSTSRVB_U8ENUMERATION1;
}


midw_fi_tcl_TstSrvB_u8Enumeration1::~midw_fi_tcl_TstSrvB_u8Enumeration1()
{}

tU32 midw_fi_tcl_TstSrvB_u8Enumeration1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_TstSrvB_u8Enumeration1::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TstSrvB_u8Enumeration1::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TstSrvB_u16Enumeration2::midw_fi_tcl_TstSrvB_u16Enumeration2():enType(FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000) {}

tS32 midw_fi_tcl_TstSrvB_u16Enumeration2::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TSTSRVB_U16ENUMERATION2;
}


midw_fi_tcl_TstSrvB_u16Enumeration2::~midw_fi_tcl_TstSrvB_u16Enumeration2()
{}

tU32 midw_fi_tcl_TstSrvB_u16Enumeration2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TstSrvB_u16Enumeration2::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TstSrvB_u16Enumeration2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u8TstSrvCTestResult::midw_fi_tcl_u8TstSrvCTestResult():enType(FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_FAILURE) {}

tS32 midw_fi_tcl_u8TstSrvCTestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8TSTSRVCTESTRESULT;
}


midw_fi_tcl_u8TstSrvCTestResult::~midw_fi_tcl_u8TstSrvCTestResult()
{}

tU32 midw_fi_tcl_u8TstSrvCTestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_u8TstSrvCTestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u8TstSrvCTestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_u16TstSrvCEnumeration2::midw_fi_tcl_u16TstSrvCEnumeration2():enType(FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000) {}

tS32 midw_fi_tcl_u16TstSrvCEnumeration2::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16TSTSRVCENUMERATION2;
}


midw_fi_tcl_u16TstSrvCEnumeration2::~midw_fi_tcl_u16TstSrvCEnumeration2()
{}

tU32 midw_fi_tcl_u16TstSrvCEnumeration2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_u16TstSrvCEnumeration2::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u16TstSrvCEnumeration2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TstSrvD_u8Enumeration1::midw_fi_tcl_TstSrvD_u8Enumeration1():enType(FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X00) {}

tS32 midw_fi_tcl_TstSrvD_u8Enumeration1::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TSTSRVD_U8ENUMERATION1;
}


midw_fi_tcl_TstSrvD_u8Enumeration1::~midw_fi_tcl_TstSrvD_u8Enumeration1()
{}

tU32 midw_fi_tcl_TstSrvD_u8Enumeration1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_TstSrvD_u8Enumeration1::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TstSrvD_u8Enumeration1::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TstSrvD_u16Enumeration2::midw_fi_tcl_TstSrvD_u16Enumeration2():enType(FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000) {}

tS32 midw_fi_tcl_TstSrvD_u16Enumeration2::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TSTSRVD_U16ENUMERATION2;
}


midw_fi_tcl_TstSrvD_u16Enumeration2::~midw_fi_tcl_TstSrvD_u16Enumeration2()
{}

tU32 midw_fi_tcl_TstSrvD_u16Enumeration2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TstSrvD_u16Enumeration2::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TstSrvD_u16Enumeration2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_iPodAuthSelfTestResult::midw_fi_tcl_e16_iPodAuthSelfTestResult():enType(FI_EN_IPODAUTHPASSED) {}

tS32 midw_fi_tcl_e16_iPodAuthSelfTestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_IPODAUTHSELFTESTRESULT;
}


midw_fi_tcl_e16_iPodAuthSelfTestResult::~midw_fi_tcl_e16_iPodAuthSelfTestResult()
{}

tU32 midw_fi_tcl_e16_iPodAuthSelfTestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_iPodAuthSelfTestResult::oRead(fi_tclInContext& oIn)
{
   tS16 s16Value;
   (tVoid) (oIn >> s16Value);
   enType = (tenType)s16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_iPodAuthSelfTestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tS16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_SubCommand::midw_fi_tcl_e8_Tun_SubCommand():enType(FI_EN_TUN_CHANGE_TO_FG) {}

tS32 midw_fi_tcl_e8_Tun_SubCommand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SUBCOMMAND;
}


midw_fi_tcl_e8_Tun_SubCommand::~midw_fi_tcl_e8_Tun_SubCommand()
{}

tU32 midw_fi_tcl_e8_Tun_SubCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_SubCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_SubCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AudioSink::midw_fi_tcl_e8_Tun_AudioSink():enType(FI_EN_TUN_USR1_CHANGE_TO_FG_BG) {}

tS32 midw_fi_tcl_e8_Tun_AudioSink::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_AUDIOSINK;
}


midw_fi_tcl_e8_Tun_AudioSink::~midw_fi_tcl_e8_Tun_AudioSink()
{}

tU32 midw_fi_tcl_e8_Tun_AudioSink::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AudioSink::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AudioSink::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_MTCAudioSource::midw_fi_tcl_e8_Tun_MTCAudioSource():enType(FI_EN_TUN_LASTAUDIOSOURCE) {}

tS32 midw_fi_tcl_e8_Tun_MTCAudioSource::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MTCAUDIOSOURCE;
}


midw_fi_tcl_e8_Tun_MTCAudioSource::~midw_fi_tcl_e8_Tun_MTCAudioSource()
{}

tU32 midw_fi_tcl_e8_Tun_MTCAudioSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_MTCAudioSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_MTCAudioSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_UserProfileAction::midw_fi_tcl_Tun_UserProfileAction():enType(FI_EN_TUN_PROFILE_CHANGE) {}

tS32 midw_fi_tcl_Tun_UserProfileAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_USERPROFILEACTION;
}


midw_fi_tcl_Tun_UserProfileAction::~midw_fi_tcl_Tun_UserProfileAction()
{}

tU32 midw_fi_tcl_Tun_UserProfileAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_Tun_UserProfileAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_UserProfileAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_AFSwitch::midw_fi_tcl_b8_Tun_AFSwitch():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_AFSwitch::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_AFSWITCH;
}


midw_fi_tcl_b8_Tun_AFSwitch::~midw_fi_tcl_b8_Tun_AFSwitch()
{}

tU32 midw_fi_tcl_b8_Tun_AFSwitch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_AFSwitch::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_AFSwitch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_AudioSink::midw_fi_tcl_b8_Tun_AudioSink():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_AudioSink::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_AUDIOSINK;
}


midw_fi_tcl_b8_Tun_AudioSink::~midw_fi_tcl_b8_Tun_AudioSink()
{}

tU32 midw_fi_tcl_b8_Tun_AudioSink::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_AudioSink::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_AudioSink::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_AtStationInfoBits::midw_fi_tcl_b8_Tun_AtStationInfoBits():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_AtStationInfoBits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_ATSTATIONINFOBITS;
}


midw_fi_tcl_b8_Tun_AtStationInfoBits::~midw_fi_tcl_b8_Tun_AtStationInfoBits()
{}

tU32 midw_fi_tcl_b8_Tun_AtStationInfoBits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_AtStationInfoBits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_AtStationInfoBits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_Tunerbandbits::midw_fi_tcl_b8_Tun_Tunerbandbits():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_Tunerbandbits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_TUNERBANDBITS;
}


midw_fi_tcl_b8_Tun_Tunerbandbits::~midw_fi_tcl_b8_Tun_Tunerbandbits()
{}

tU32 midw_fi_tcl_b8_Tun_Tunerbandbits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_Tunerbandbits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_Tunerbandbits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Audio_FG_BG::midw_fi_tcl_Audio_FG_BG(const midw_fi_tcl_Audio_FG_BG& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8SubCommand = coRef.u8SubCommand;
   u8AudioSink = coRef.u8AudioSink;
}
midw_fi_tcl_Audio_FG_BG& midw_fi_tcl_Audio_FG_BG::operator=(const midw_fi_tcl_Audio_FG_BG& coRef)
{
   if (this == &coRef) return *this;
   u8SubCommand = coRef.u8SubCommand;
   u8AudioSink = coRef.u8AudioSink;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Audio_FG_BG::midw_fi_tcl_Audio_FG_BG()
:u8SubCommand()
,u8AudioSink()
 {}

tS32 midw_fi_tcl_Audio_FG_BG::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUDIO_FG_BG;
}


midw_fi_tcl_Audio_FG_BG::~midw_fi_tcl_Audio_FG_BG()
{}

tU32 midw_fi_tcl_Audio_FG_BG::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_Audio_FG_BG::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SubCommand);
   (tVoid) (oIn >> u8AudioSink);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Audio_FG_BG::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SubCommand);
   (tVoid) (oOut << u8AudioSink);
   return oOut;
}

tBool midw_fi_tcl_Audio_FG_BG::operator==(const midw_fi_tcl_Audio_FG_BG& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SubCommand == roRef.u8SubCommand);
   bResult = bResult && (u8AudioSink == roRef.u8AudioSink);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Client::midw_fi_tcl_e8_Tun_Client():enType(FI_EN_DAB) {}

tS32 midw_fi_tcl_e8_Tun_Client::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_CLIENT;
}


midw_fi_tcl_e8_Tun_Client::~midw_fi_tcl_e8_Tun_Client()
{}

tU32 midw_fi_tcl_e8_Tun_Client::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Client::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Client::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_u16CalibrationData::midw_fi_tcl_u16CalibrationData(const midw_fi_tcl_u16CalibrationData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8DataLength = coRef.u8DataLength;
   CalibrationValues = coRef.CalibrationValues;
}
midw_fi_tcl_u16CalibrationData& midw_fi_tcl_u16CalibrationData::operator=(const midw_fi_tcl_u16CalibrationData& coRef)
{
   if (this == &coRef) return *this;
   u8DataLength = coRef.u8DataLength;
   CalibrationValues = coRef.CalibrationValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_u16CalibrationData::vDestroy()
{
   {
   CalibrationValues.clear();
   }
}

midw_fi_tcl_u16CalibrationData::midw_fi_tcl_u16CalibrationData()
:u8DataLength(0)

 {}

tS32 midw_fi_tcl_u16CalibrationData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U16CALIBRATIONDATA;
}


midw_fi_tcl_u16CalibrationData::~midw_fi_tcl_u16CalibrationData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_u16CalibrationData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(CalibrationValues.size()*2);
}

fi_tclInContext& midw_fi_tcl_u16CalibrationData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataLength);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      CalibrationValues.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CalibrationValues[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u16CalibrationData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataLength);
   (tVoid) (oOut << (tU32)CalibrationValues.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CalibrationValues.size(); ++u32Idx)
         (tVoid) (oOut << CalibrationValues[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_u16CalibrationData::operator==(const midw_fi_tcl_u16CalibrationData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataLength == roRef.u8DataLength);
      bResult = bResult && (CalibrationValues.size() == roRef.CalibrationValues.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CalibrationValues.size()); ++u32Idx)
            bResult = bResult && (CalibrationValues[u32Idx] == roRef.CalibrationValues[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerHeader::midw_fi_tcl_e8_Tun_TunerHeader():enType(FI_EN_TUN_FOREGROUND) {}

tS32 midw_fi_tcl_e8_Tun_TunerHeader::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERHEADER;
}


midw_fi_tcl_e8_Tun_TunerHeader::~midw_fi_tcl_e8_Tun_TunerHeader()
{}

tU32 midw_fi_tcl_e8_Tun_TunerHeader::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerHeader::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerHeader::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AudFGBGStatus::midw_fi_tcl_AudFGBGStatus(const midw_fi_tcl_AudFGBGStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8_TunerHeader = coRef.u8_TunerHeader;
   u8AudioSink = coRef.u8AudioSink;
   e8MTCAudioSource = coRef.e8MTCAudioSource;
}
midw_fi_tcl_AudFGBGStatus& midw_fi_tcl_AudFGBGStatus::operator=(const midw_fi_tcl_AudFGBGStatus& coRef)
{
   if (this == &coRef) return *this;
   u8_TunerHeader = coRef.u8_TunerHeader;
   u8AudioSink = coRef.u8AudioSink;
   e8MTCAudioSource = coRef.e8MTCAudioSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AudFGBGStatus::midw_fi_tcl_AudFGBGStatus()
:u8_TunerHeader()
,u8AudioSink()
,e8MTCAudioSource()
 {}

tS32 midw_fi_tcl_AudFGBGStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUDFGBGSTATUS;
}


midw_fi_tcl_AudFGBGStatus::~midw_fi_tcl_AudFGBGStatus()
{}

tU32 midw_fi_tcl_AudFGBGStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_AudFGBGStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8_TunerHeader);
   (tVoid) (oIn >> u8AudioSink);
   (tVoid) (oIn >> e8MTCAudioSource);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AudFGBGStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8_TunerHeader);
   (tVoid) (oOut << u8AudioSink);
   (tVoid) (oOut << e8MTCAudioSource);
   return oOut;
}

tBool midw_fi_tcl_AudFGBGStatus::operator==(const midw_fi_tcl_AudFGBGStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8_TunerHeader == roRef.u8_TunerHeader);
   bResult = bResult && (u8AudioSink == roRef.u8AudioSink);
   bResult = bResult && (e8MTCAudioSource == roRef.e8MTCAudioSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ResponseStatus::midw_fi_tcl_e8_Tun_ResponseStatus():enType(FI_EN_TUN_RES_REQ_SUCCEED) {}

tS32 midw_fi_tcl_e8_Tun_ResponseStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_RESPONSESTATUS;
}


midw_fi_tcl_e8_Tun_ResponseStatus::~midw_fi_tcl_e8_Tun_ResponseStatus()
{}

tU32 midw_fi_tcl_e8_Tun_ResponseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ResponseStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ResponseStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ResponseState::midw_fi_tcl_e8_Tun_ResponseState():enType(FI_EN_TUN_TUN_STATE_NORMAL) {}

tS32 midw_fi_tcl_e8_Tun_ResponseState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_RESPONSESTATE;
}


midw_fi_tcl_e8_Tun_ResponseState::~midw_fi_tcl_e8_Tun_ResponseState()
{}

tU32 midw_fi_tcl_e8_Tun_ResponseState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ResponseState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ResponseState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerServer_StatusResponse::midw_fi_tcl_TunerServer_StatusResponse(const midw_fi_tcl_TunerServer_StatusResponse& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerStatus = coRef.u8TunerStatus;
   u8TunerState = coRef.u8TunerState;
}
midw_fi_tcl_TunerServer_StatusResponse& midw_fi_tcl_TunerServer_StatusResponse::operator=(const midw_fi_tcl_TunerServer_StatusResponse& coRef)
{
   if (this == &coRef) return *this;
   u8TunerStatus = coRef.u8TunerStatus;
   u8TunerState = coRef.u8TunerState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerServer_StatusResponse::midw_fi_tcl_TunerServer_StatusResponse()
:u8TunerStatus()
,u8TunerState()
 {}

tS32 midw_fi_tcl_TunerServer_StatusResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERSERVER_STATUSRESPONSE;
}


midw_fi_tcl_TunerServer_StatusResponse::~midw_fi_tcl_TunerServer_StatusResponse()
{}

tU32 midw_fi_tcl_TunerServer_StatusResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TunerServer_StatusResponse::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerStatus);
   (tVoid) (oIn >> u8TunerState);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerServer_StatusResponse::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerStatus);
   (tVoid) (oOut << u8TunerState);
   return oOut;
}

tBool midw_fi_tcl_TunerServer_StatusResponse::operator==(const midw_fi_tcl_TunerServer_StatusResponse& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerStatus == roRef.u8TunerStatus);
   bResult = bResult && (u8TunerState == roRef.u8TunerState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerSeek::midw_fi_tcl_e8_Tun_TunerSeek():enType(FI_EN_TUN_SEEKTYPE_OFF) {}

tS32 midw_fi_tcl_e8_Tun_TunerSeek::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERSEEK;
}


midw_fi_tcl_e8_Tun_TunerSeek::~midw_fi_tcl_e8_Tun_TunerSeek()
{}

tU32 midw_fi_tcl_e8_Tun_TunerSeek::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerSeek::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerSeek::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_PhysicalTuner::midw_fi_tcl_e8_Tun_PhysicalTuner():enType(FI_EN_TUNER_0) {}

tS32 midw_fi_tcl_e8_Tun_PhysicalTuner::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_PHYSICALTUNER;
}


midw_fi_tcl_e8_Tun_PhysicalTuner::~midw_fi_tcl_e8_Tun_PhysicalTuner()
{}

tU32 midw_fi_tcl_e8_Tun_PhysicalTuner::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_PhysicalTuner::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_PhysicalTuner::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerBand::midw_fi_tcl_e8_Tun_TunerBand():enType(FI_EN_TUN_BAND_FM) {}

tS32 midw_fi_tcl_e8_Tun_TunerBand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERBAND;
}


midw_fi_tcl_e8_Tun_TunerBand::~midw_fi_tcl_e8_Tun_TunerBand()
{}

tU32 midw_fi_tcl_e8_Tun_TunerBand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerBand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerBand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_FGBG_New::midw_fi_tcl_Aud_FGBG_New(const midw_fi_tcl_Aud_FGBG_New& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8_TunerHeader = coRef.u8_TunerHeader;
   u8SubCommand = coRef.u8SubCommand;
   u8AudioSink = coRef.u8AudioSink;
   bTunerState = coRef.bTunerState;
   u8_PhysicalTuner = coRef.u8_PhysicalTuner;
   e8Band = coRef.e8Band;
   e8MTCAudioSource = coRef.e8MTCAudioSource;
}
midw_fi_tcl_Aud_FGBG_New& midw_fi_tcl_Aud_FGBG_New::operator=(const midw_fi_tcl_Aud_FGBG_New& coRef)
{
   if (this == &coRef) return *this;
   u8_TunerHeader = coRef.u8_TunerHeader;
   u8SubCommand = coRef.u8SubCommand;
   u8AudioSink = coRef.u8AudioSink;
   bTunerState = coRef.bTunerState;
   u8_PhysicalTuner = coRef.u8_PhysicalTuner;
   e8Band = coRef.e8Band;
   e8MTCAudioSource = coRef.e8MTCAudioSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_FGBG_New::midw_fi_tcl_Aud_FGBG_New()
:u8_TunerHeader()
,u8SubCommand()
,u8AudioSink()
,bTunerState(0)
,u8_PhysicalTuner()
,e8Band()
,e8MTCAudioSource()
 {}

tS32 midw_fi_tcl_Aud_FGBG_New::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_FGBG_NEW;
}


midw_fi_tcl_Aud_FGBG_New::~midw_fi_tcl_Aud_FGBG_New()
{}

tU32 midw_fi_tcl_Aud_FGBG_New::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_fi_tcl_Aud_FGBG_New::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8_TunerHeader);
   (tVoid) (oIn >> u8SubCommand);
   (tVoid) (oIn >> u8AudioSink);
   (tVoid) (oIn >> bTunerState);
   (tVoid) (oIn >> u8_PhysicalTuner);
   (tVoid) (oIn >> e8Band);
   (tVoid) (oIn >> e8MTCAudioSource);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_FGBG_New::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8_TunerHeader);
   (tVoid) (oOut << u8SubCommand);
   (tVoid) (oOut << u8AudioSink);
   (tVoid) (oOut << bTunerState);
   (tVoid) (oOut << u8_PhysicalTuner);
   (tVoid) (oOut << e8Band);
   (tVoid) (oOut << e8MTCAudioSource);
   return oOut;
}

tBool midw_fi_tcl_Aud_FGBG_New::operator==(const midw_fi_tcl_Aud_FGBG_New& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8_TunerHeader == roRef.u8_TunerHeader);
   bResult = bResult && (u8SubCommand == roRef.u8SubCommand);
   bResult = bResult && (u8AudioSink == roRef.u8AudioSink);
   bResult = bResult && (bTunerState == roRef.bTunerState);
   bResult = bResult && (u8_PhysicalTuner == roRef.u8_PhysicalTuner);
   bResult = bResult && (e8Band == roRef.e8Band);
   bResult = bResult && (e8MTCAudioSource == roRef.e8MTCAudioSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Testmode_TunerBand::midw_fi_tcl_e8_Tun_Testmode_TunerBand():enType(FI_EN_TUN_BAND_FM) {}

tS32 midw_fi_tcl_e8_Tun_Testmode_TunerBand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TESTMODE_TUNERBAND;
}


midw_fi_tcl_e8_Tun_Testmode_TunerBand::~midw_fi_tcl_e8_Tun_Testmode_TunerBand()
{}

tU32 midw_fi_tcl_e8_Tun_Testmode_TunerBand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Testmode_TunerBand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Testmode_TunerBand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerAutostore::midw_fi_tcl_e8_Tun_TunerAutostore():enType(FI_EN_TUN_AUTOSTORE_NO) {}

tS32 midw_fi_tcl_e8_Tun_TunerAutostore::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERAUTOSTORE;
}


midw_fi_tcl_e8_Tun_TunerAutostore::~midw_fi_tcl_e8_Tun_TunerAutostore()
{}

tU32 midw_fi_tcl_e8_Tun_TunerAutostore::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerAutostore::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerAutostore::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerMode::midw_fi_tcl_e8_Tun_TunerMode():enType(FI_EN_TUN_MODE_NORM) {}

tS32 midw_fi_tcl_e8_Tun_TunerMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERMODE;
}


midw_fi_tcl_e8_Tun_TunerMode::~midw_fi_tcl_e8_Tun_TunerMode()
{}

tU32 midw_fi_tcl_e8_Tun_TunerMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerState::midw_fi_tcl_e8_Tun_TunerState():enType(FI_EN_TUN_STATE_PLAY) {}

tS32 midw_fi_tcl_e8_Tun_TunerState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERSTATE;
}


midw_fi_tcl_e8_Tun_TunerState::~midw_fi_tcl_e8_Tun_TunerState()
{}

tU32 midw_fi_tcl_e8_Tun_TunerState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Announcement::midw_fi_tcl_e8_Tun_Announcement():enType(FI_EN_TUN_NO_ANNOUNCEMENT) {}

tS32 midw_fi_tcl_e8_Tun_Announcement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ANNOUNCEMENT;
}


midw_fi_tcl_e8_Tun_Announcement::~midw_fi_tcl_e8_Tun_Announcement()
{}

tU32 midw_fi_tcl_e8_Tun_Announcement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Announcement::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Announcement::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_Tun_AvailFlags::midw_fi_tcl_b32_Tun_AvailFlags():u32Value(0)
{}

tS32 midw_fi_tcl_b32_Tun_AvailFlags::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_TUN_AVAILFLAGS;
}


midw_fi_tcl_b32_Tun_AvailFlags::~midw_fi_tcl_b32_Tun_AvailFlags()
{}

tU32 midw_fi_tcl_b32_Tun_AvailFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_Tun_AvailFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_Tun_AvailFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_StaticListID::midw_fi_tcl_e8_Tun_StaticListID():enType(FI_EN_TUN_TUN_STATIC_LIST_FM1) {}

tS32 midw_fi_tcl_e8_Tun_StaticListID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_STATICLISTID;
}


midw_fi_tcl_e8_Tun_StaticListID::~midw_fi_tcl_e8_Tun_StaticListID()
{}

tU32 midw_fi_tcl_e8_Tun_StaticListID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_StaticListID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_StaticListID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_MixedpresetListID::midw_fi_tcl_e8_Tun_MixedpresetListID():enType(FI_EN_TUN_TUN_MIXEDPRESET_LIST_FMAM) {}

tS32 midw_fi_tcl_e8_Tun_MixedpresetListID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MIXEDPRESETLISTID;
}


midw_fi_tcl_e8_Tun_MixedpresetListID::~midw_fi_tcl_e8_Tun_MixedpresetListID()
{}

tU32 midw_fi_tcl_e8_Tun_MixedpresetListID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_MixedpresetListID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_MixedpresetListID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_Tun_Features::midw_fi_tcl_b32_Tun_Features():u32Value(0)
{}

tS32 midw_fi_tcl_b32_Tun_Features::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_TUN_FEATURES;
}


midw_fi_tcl_b32_Tun_Features::~midw_fi_tcl_b32_Tun_Features()
{}

tU32 midw_fi_tcl_b32_Tun_Features::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_Tun_Features::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_Tun_Features::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_Antenna::midw_fi_tcl_b8_Tun_Antenna():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_Antenna::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_ANTENNA;
}


midw_fi_tcl_b8_Tun_Antenna::~midw_fi_tcl_b8_Tun_Antenna()
{}

tU32 midw_fi_tcl_b8_Tun_Antenna::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_Antenna::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_Antenna::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerStationData::midw_fi_tcl_TunerStationData(const midw_fi_tcl_TunerStationData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u8PTY = coRef.u8PTY;
   u16PackedInfo = coRef.u16PackedInfo;
   u32AvailFlags = coRef.u32AvailFlags;
   u32Frequency = coRef.u32Frequency;
   u32PI = coRef.u32PI;
   u8PSName1 = coRef.u8PSName1;
   u8PSName2 = coRef.u8PSName2;
   u8PSName3 = coRef.u8PSName3;
   u8PSName4 = coRef.u8PSName4;
   u8PSName5 = coRef.u8PSName5;
   u8PSName6 = coRef.u8PSName6;
   u8PSName7 = coRef.u8PSName7;
   u8PSName8 = coRef.u8PSName8;
   sPSName = coRef.sPSName;
}
midw_fi_tcl_TunerStationData& midw_fi_tcl_TunerStationData::operator=(const midw_fi_tcl_TunerStationData& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u8PTY = coRef.u8PTY;
   u16PackedInfo = coRef.u16PackedInfo;
   u32AvailFlags = coRef.u32AvailFlags;
   u32Frequency = coRef.u32Frequency;
   u32PI = coRef.u32PI;
   u8PSName1 = coRef.u8PSName1;
   u8PSName2 = coRef.u8PSName2;
   u8PSName3 = coRef.u8PSName3;
   u8PSName4 = coRef.u8PSName4;
   u8PSName5 = coRef.u8PSName5;
   u8PSName6 = coRef.u8PSName6;
   u8PSName7 = coRef.u8PSName7;
   u8PSName8 = coRef.u8PSName8;
   sPSName = coRef.sPSName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerStationData::vDestroy()
{
   sPSName.vDestroy();
}

midw_fi_tcl_TunerStationData::midw_fi_tcl_TunerStationData()
:u8TunerHeader()
,u8PTY(0)
,u16PackedInfo(0)
,u32AvailFlags()
,u32Frequency(0)
,u32PI(0)
,u8PSName1(0)
,u8PSName2(0)
,u8PSName3(0)
,u8PSName4(0)
,u8PSName5(0)
,u8PSName6(0)
,u8PSName7(0)
,u8PSName8(0)
,sPSName()
 {}

tS32 midw_fi_tcl_TunerStationData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERSTATIONDATA;
}


midw_fi_tcl_TunerStationData::~midw_fi_tcl_TunerStationData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerStationData::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+sPSName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerStationData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u8PTY);
   (tVoid) (oIn >> u16PackedInfo);
   (tVoid) (oIn >> u32AvailFlags);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u32PI);
   (tVoid) (oIn >> u8PSName1);
   (tVoid) (oIn >> u8PSName2);
   (tVoid) (oIn >> u8PSName3);
   (tVoid) (oIn >> u8PSName4);
   (tVoid) (oIn >> u8PSName5);
   (tVoid) (oIn >> u8PSName6);
   (tVoid) (oIn >> u8PSName7);
   (tVoid) (oIn >> u8PSName8);
   (tVoid) (oIn >> sPSName);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerStationData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u8PTY);
   (tVoid) (oOut << u16PackedInfo);
   (tVoid) (oOut << u32AvailFlags);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u32PI);
   (tVoid) (oOut << u8PSName1);
   (tVoid) (oOut << u8PSName2);
   (tVoid) (oOut << u8PSName3);
   (tVoid) (oOut << u8PSName4);
   (tVoid) (oOut << u8PSName5);
   (tVoid) (oOut << u8PSName6);
   (tVoid) (oOut << u8PSName7);
   (tVoid) (oOut << u8PSName8);
   (tVoid) (oOut << sPSName);
   return oOut;
}

tBool midw_fi_tcl_TunerStationData::operator==(const midw_fi_tcl_TunerStationData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u8PTY == roRef.u8PTY);
   bResult = bResult && (u16PackedInfo == roRef.u16PackedInfo);
   bResult = bResult && (u32AvailFlags == roRef.u32AvailFlags);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u32PI == roRef.u32PI);
   bResult = bResult && (u8PSName1 == roRef.u8PSName1);
   bResult = bResult && (u8PSName2 == roRef.u8PSName2);
   bResult = bResult && (u8PSName3 == roRef.u8PSName3);
   bResult = bResult && (u8PSName4 == roRef.u8PSName4);
   bResult = bResult && (u8PSName5 == roRef.u8PSName5);
   bResult = bResult && (u8PSName6 == roRef.u8PSName6);
   bResult = bResult && (u8PSName7 == roRef.u8PSName7);
   bResult = bResult && (u8PSName8 == roRef.u8PSName8);
   bResult = bResult && (sPSName == roRef.sPSName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerFeature::midw_fi_tcl_TunerFeature(const midw_fi_tcl_TunerFeature& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   b32Features = coRef.b32Features;
   b32MaskFeatures = coRef.b32MaskFeatures;
}
midw_fi_tcl_TunerFeature& midw_fi_tcl_TunerFeature::operator=(const midw_fi_tcl_TunerFeature& coRef)
{
   if (this == &coRef) return *this;
   b32Features = coRef.b32Features;
   b32MaskFeatures = coRef.b32MaskFeatures;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerFeature::midw_fi_tcl_TunerFeature()
:b32Features()
,b32MaskFeatures()
 {}

tS32 midw_fi_tcl_TunerFeature::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERFEATURE;
}


midw_fi_tcl_TunerFeature::~midw_fi_tcl_TunerFeature()
{}

tU32 midw_fi_tcl_TunerFeature::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_TunerFeature::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32Features);
   (tVoid) (oIn >> b32MaskFeatures);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerFeature::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32Features);
   (tVoid) (oOut << b32MaskFeatures);
   return oOut;
}

tBool midw_fi_tcl_TunerFeature::operator==(const midw_fi_tcl_TunerFeature& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32Features == roRef.b32Features);
   bResult = bResult && (b32MaskFeatures == roRef.b32MaskFeatures);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_Tun_AvailableFlags::midw_fi_tcl_b32_Tun_AvailableFlags():u32Value(0)
{}

tS32 midw_fi_tcl_b32_Tun_AvailableFlags::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_TUN_AVAILABLEFLAGS;
}


midw_fi_tcl_b32_Tun_AvailableFlags::~midw_fi_tcl_b32_Tun_AvailableFlags()
{}

tU32 midw_fi_tcl_b32_Tun_AvailableFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_Tun_AvailableFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_Tun_AvailableFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ManualFreqAdjustment::midw_fi_tcl_e8_Tun_ManualFreqAdjustment():enType(FI_EN_TUN_SEEK_DIRECTION_UP) {}

tS32 midw_fi_tcl_e8_Tun_ManualFreqAdjustment::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MANUALFREQADJUSTMENT;
}


midw_fi_tcl_e8_Tun_ManualFreqAdjustment::~midw_fi_tcl_e8_Tun_ManualFreqAdjustment()
{}

tU32 midw_fi_tcl_e8_Tun_ManualFreqAdjustment::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ManualFreqAdjustment::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ManualFreqAdjustment::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AcceptAF::midw_fi_tcl_e8_Tun_AcceptAF():enType(FI_EN_TUN_NOT_ACCEPT_AF) {}

tS32 midw_fi_tcl_e8_Tun_AcceptAF::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ACCEPTAF;
}


midw_fi_tcl_e8_Tun_AcceptAF::~midw_fi_tcl_e8_Tun_AcceptAF()
{}

tU32 midw_fi_tcl_e8_Tun_AcceptAF::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AcceptAF::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AcceptAF::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerManualSingleStep::midw_fi_tcl_TunerManualSingleStep(const midw_fi_tcl_TunerManualSingleStep& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ManualFreqAdjustment = coRef.ManualFreqAdjustment;
   u8NumberOfTicks = coRef.u8NumberOfTicks;
}
midw_fi_tcl_TunerManualSingleStep& midw_fi_tcl_TunerManualSingleStep::operator=(const midw_fi_tcl_TunerManualSingleStep& coRef)
{
   if (this == &coRef) return *this;
   ManualFreqAdjustment = coRef.ManualFreqAdjustment;
   u8NumberOfTicks = coRef.u8NumberOfTicks;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerManualSingleStep::midw_fi_tcl_TunerManualSingleStep()
:ManualFreqAdjustment()
,u8NumberOfTicks(0)
 {}

tS32 midw_fi_tcl_TunerManualSingleStep::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERMANUALSINGLESTEP;
}


midw_fi_tcl_TunerManualSingleStep::~midw_fi_tcl_TunerManualSingleStep()
{}

tU32 midw_fi_tcl_TunerManualSingleStep::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TunerManualSingleStep::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ManualFreqAdjustment);
   (tVoid) (oIn >> u8NumberOfTicks);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerManualSingleStep::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ManualFreqAdjustment);
   (tVoid) (oOut << u8NumberOfTicks);
   return oOut;
}

tBool midw_fi_tcl_TunerManualSingleStep::operator==(const midw_fi_tcl_TunerManualSingleStep& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ManualFreqAdjustment == roRef.ManualFreqAdjustment);
   bResult = bResult && (u8NumberOfTicks == roRef.u8NumberOfTicks);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerStaticList::midw_fi_tcl_e8_Tun_TunerStaticList():enType(FI_EN_TUN_TUN_STATIC_LIST_FM1) {}

tS32 midw_fi_tcl_e8_Tun_TunerStaticList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERSTATICLIST;
}


midw_fi_tcl_e8_Tun_TunerStaticList::~midw_fi_tcl_e8_Tun_TunerStaticList()
{}

tU32 midw_fi_tcl_e8_Tun_TunerStaticList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerStaticList::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerStaticList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TunerMixedpresetList::midw_fi_tcl_e8_Tun_TunerMixedpresetList():enType(FI_EN_TUN_TUN_MIXEDPRESET_LIST_FM1) {}

tS32 midw_fi_tcl_e8_Tun_TunerMixedpresetList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TUNERMIXEDPRESETLIST;
}


midw_fi_tcl_e8_Tun_TunerMixedpresetList::~midw_fi_tcl_e8_Tun_TunerMixedpresetList()
{}

tU32 midw_fi_tcl_e8_Tun_TunerMixedpresetList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TunerMixedpresetList::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TunerMixedpresetList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_EnableOrDisable::midw_fi_tcl_e8_Tun_EnableOrDisable():enType(FI_EN_DISABLE) {}

tS32 midw_fi_tcl_e8_Tun_EnableOrDisable::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ENABLEORDISABLE;
}


midw_fi_tcl_e8_Tun_EnableOrDisable::~midw_fi_tcl_e8_Tun_EnableOrDisable()
{}

tU32 midw_fi_tcl_e8_Tun_EnableOrDisable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_EnableOrDisable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_EnableOrDisable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_OperationFlags::midw_fi_tcl_e8_Tun_OperationFlags():enType(FI_EN_TUN_OPERATION_AFBEST) {}

tS32 midw_fi_tcl_e8_Tun_OperationFlags::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_OPERATIONFLAGS;
}


midw_fi_tcl_e8_Tun_OperationFlags::~midw_fi_tcl_e8_Tun_OperationFlags()
{}

tU32 midw_fi_tcl_e8_Tun_OperationFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_OperationFlags::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_OperationFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_OperationFlags::midw_fi_tcl_b8_Tun_OperationFlags():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_OperationFlags::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_OPERATIONFLAGS;
}


midw_fi_tcl_b8_Tun_OperationFlags::~midw_fi_tcl_b8_Tun_OperationFlags()
{}

tU32 midw_fi_tcl_b8_Tun_OperationFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_OperationFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_OperationFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerOperation::midw_fi_tcl_TunerOperation(const midw_fi_tcl_TunerOperation& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8EnableOrDisable = coRef.u8EnableOrDisable;
   u8OperationFlags = coRef.u8OperationFlags;
}
midw_fi_tcl_TunerOperation& midw_fi_tcl_TunerOperation::operator=(const midw_fi_tcl_TunerOperation& coRef)
{
   if (this == &coRef) return *this;
   u8EnableOrDisable = coRef.u8EnableOrDisable;
   u8OperationFlags = coRef.u8OperationFlags;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerOperation::midw_fi_tcl_TunerOperation()
:u8EnableOrDisable()
,u8OperationFlags()
 {}

tS32 midw_fi_tcl_TunerOperation::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNEROPERATION;
}


midw_fi_tcl_TunerOperation::~midw_fi_tcl_TunerOperation()
{}

tU32 midw_fi_tcl_TunerOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TunerOperation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8EnableOrDisable);
   (tVoid) (oIn >> u8OperationFlags);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerOperation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8EnableOrDisable);
   (tVoid) (oOut << u8OperationFlags);
   return oOut;
}

tBool midw_fi_tcl_TunerOperation::operator==(const midw_fi_tcl_TunerOperation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8EnableOrDisable == roRef.u8EnableOrDisable);
   bResult = bResult && (u8OperationFlags == roRef.u8OperationFlags);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AFInformation::midw_fi_tcl_e8_Tun_AFInformation():enType(FI_EN_TUN_AF_UNKNOWN) {}

tS32 midw_fi_tcl_e8_Tun_AFInformation::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_AFINFORMATION;
}


midw_fi_tcl_e8_Tun_AFInformation::~midw_fi_tcl_e8_Tun_AFInformation()
{}

tU32 midw_fi_tcl_e8_Tun_AFInformation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AFInformation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AFInformation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Notification::midw_fi_tcl_e8_Tun_Notification():enType(FI_EN_TUN_NOTIFICATION_OFF) {}

tS32 midw_fi_tcl_e8_Tun_Notification::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_NOTIFICATION;
}


midw_fi_tcl_e8_Tun_Notification::~midw_fi_tcl_e8_Tun_Notification()
{}

tU32 midw_fi_tcl_e8_Tun_Notification::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Notification::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Notification::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerAFList::midw_fi_tcl_TunerAFList(const midw_fi_tcl_TunerAFList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u8AFListElementID = coRef.u8AFListElementID;
   u32AFFrequency = coRef.u32AFFrequency;
   u8AFQualityLevel = coRef.u8AFQualityLevel;
   u8AFFieldStrength = coRef.u8AFFieldStrength;
   u8AFBitErrorRate = coRef.u8AFBitErrorRate;
   u8AFInfo = coRef.u8AFInfo;
   u16AFPI = coRef.u16AFPI;
}
midw_fi_tcl_TunerAFList& midw_fi_tcl_TunerAFList::operator=(const midw_fi_tcl_TunerAFList& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u8AFListElementID = coRef.u8AFListElementID;
   u32AFFrequency = coRef.u32AFFrequency;
   u8AFQualityLevel = coRef.u8AFQualityLevel;
   u8AFFieldStrength = coRef.u8AFFieldStrength;
   u8AFBitErrorRate = coRef.u8AFBitErrorRate;
   u8AFInfo = coRef.u8AFInfo;
   u16AFPI = coRef.u16AFPI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerAFList::midw_fi_tcl_TunerAFList()
:u8TunerHeader()
,u8AFListElementID(0)
,u32AFFrequency(0)
,u8AFQualityLevel(0)
,u8AFFieldStrength(0)
,u8AFBitErrorRate(0)
,u8AFInfo()
,u16AFPI(0)
 {}

tS32 midw_fi_tcl_TunerAFList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERAFLIST;
}


midw_fi_tcl_TunerAFList::~midw_fi_tcl_TunerAFList()
{}

tU32 midw_fi_tcl_TunerAFList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_fi_tcl_TunerAFList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u8AFListElementID);
   (tVoid) (oIn >> u32AFFrequency);
   (tVoid) (oIn >> u8AFQualityLevel);
   (tVoid) (oIn >> u8AFFieldStrength);
   (tVoid) (oIn >> u8AFBitErrorRate);
   (tVoid) (oIn >> u8AFInfo);
   (tVoid) (oIn >> u16AFPI);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerAFList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u8AFListElementID);
   (tVoid) (oOut << u32AFFrequency);
   (tVoid) (oOut << u8AFQualityLevel);
   (tVoid) (oOut << u8AFFieldStrength);
   (tVoid) (oOut << u8AFBitErrorRate);
   (tVoid) (oOut << u8AFInfo);
   (tVoid) (oOut << u16AFPI);
   return oOut;
}

tBool midw_fi_tcl_TunerAFList::operator==(const midw_fi_tcl_TunerAFList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u8AFListElementID == roRef.u8AFListElementID);
   bResult = bResult && (u32AFFrequency == roRef.u32AFFrequency);
   bResult = bResult && (u8AFQualityLevel == roRef.u8AFQualityLevel);
   bResult = bResult && (u8AFFieldStrength == roRef.u8AFFieldStrength);
   bResult = bResult && (u8AFBitErrorRate == roRef.u8AFBitErrorRate);
   bResult = bResult && (u8AFInfo == roRef.u8AFInfo);
   bResult = bResult && (u16AFPI == roRef.u16AFPI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AdditionalInfo::midw_fi_tcl_e8_Tun_AdditionalInfo():enType(FI_EN_TUN_RDS_SYNC) {}

tS32 midw_fi_tcl_e8_Tun_AdditionalInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ADDITIONALINFO;
}


midw_fi_tcl_e8_Tun_AdditionalInfo::~midw_fi_tcl_e8_Tun_AdditionalInfo()
{}

tU32 midw_fi_tcl_e8_Tun_AdditionalInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AdditionalInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AdditionalInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_TestmodeBits::midw_fi_tcl_b8_Tun_TestmodeBits():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_TestmodeBits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_TESTMODEBITS;
}


midw_fi_tcl_b8_Tun_TestmodeBits::~midw_fi_tcl_b8_Tun_TestmodeBits()
{}

tU32 midw_fi_tcl_b8_Tun_TestmodeBits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_TestmodeBits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_TestmodeBits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tuner_Mode::midw_fi_tcl_e8_Tuner_Mode():enType(FI_EN_TUN_CAL) {}

tS32 midw_fi_tcl_e8_Tuner_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNER_MODE;
}


midw_fi_tcl_e8_Tuner_Mode::~midw_fi_tcl_e8_Tuner_Mode()
{}

tU32 midw_fi_tcl_e8_Tuner_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tuner_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tuner_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DDADDS_Mode::midw_fi_tcl_e8_DDADDS_Mode():enType(FI_EN_TUN_DDA) {}

tS32 midw_fi_tcl_e8_DDADDS_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DDADDS_MODE;
}


midw_fi_tcl_e8_DDADDS_Mode::~midw_fi_tcl_e8_DDADDS_Mode()
{}

tU32 midw_fi_tcl_e8_DDADDS_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DDADDS_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DDADDS_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TMCGroupState::midw_fi_tcl_e8_Tun_TMCGroupState():enType(FI_EN_TUN_NO_DATA_AVAILABLE) {}

tS32 midw_fi_tcl_e8_Tun_TMCGroupState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TMCGROUPSTATE;
}


midw_fi_tcl_e8_Tun_TMCGroupState::~midw_fi_tcl_e8_Tun_TMCGroupState()
{}

tU32 midw_fi_tcl_e8_Tun_TMCGroupState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TMCGroupState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TMCGroupState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AntennaState::midw_fi_tcl_e8_Tun_AntennaState():enType(FI_EN_TUN_PHANTOM_SUPPLY_OFF) {}

tS32 midw_fi_tcl_e8_Tun_AntennaState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ANTENNASTATE;
}


midw_fi_tcl_e8_Tun_AntennaState::~midw_fi_tcl_e8_Tun_AntennaState()
{}

tU32 midw_fi_tcl_e8_Tun_AntennaState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AntennaState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AntennaState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_IfState::midw_fi_tcl_e8_Tun_IfState():enType(FI_EN_TUN_OFF) {}

tS32 midw_fi_tcl_e8_Tun_IfState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_IFSTATE;
}


midw_fi_tcl_e8_Tun_IfState::~midw_fi_tcl_e8_Tun_IfState()
{}

tU32 midw_fi_tcl_e8_Tun_IfState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_IfState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_IfState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerTestModeData::midw_fi_tcl_TunerTestModeData(const midw_fi_tcl_TunerTestModeData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u8AdditionalInfo = coRef.u8AdditionalInfo;
   u32AFFrequency = coRef.u32AFFrequency;
   u32PI = coRef.u32PI;
   u8Quality = coRef.u8Quality;
   u8Fieldstrength = coRef.u8Fieldstrength;
   u8Multipath = coRef.u8Multipath;
   u8Neighbour = coRef.u8Neighbour;
   u8AFListLength = coRef.u8AFListLength;
   u8TestmodeBits = coRef.u8TestmodeBits;
   u8TMCStationCount = coRef.u8TMCStationCount;
   u8TMCGroupState = coRef.u8TMCGroupState;
   u8AntennaState = coRef.u8AntennaState;
   u8PSName1 = coRef.u8PSName1;
   u8PSName2 = coRef.u8PSName2;
   u8PSName3 = coRef.u8PSName3;
   u8PSName4 = coRef.u8PSName4;
   u8PSName5 = coRef.u8PSName5;
   u8PSName6 = coRef.u8PSName6;
   u8PSName7 = coRef.u8PSName7;
   u8PSName8 = coRef.u8PSName8;
   sPSName = coRef.sPSName;
   u8IFState = coRef.u8IFState;
   u8ChannelSeparation = coRef.u8ChannelSeparation;
   u8Hub = coRef.u8Hub;
   u8RdsErrorRate = coRef.u8RdsErrorRate;
}
midw_fi_tcl_TunerTestModeData& midw_fi_tcl_TunerTestModeData::operator=(const midw_fi_tcl_TunerTestModeData& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u8AdditionalInfo = coRef.u8AdditionalInfo;
   u32AFFrequency = coRef.u32AFFrequency;
   u32PI = coRef.u32PI;
   u8Quality = coRef.u8Quality;
   u8Fieldstrength = coRef.u8Fieldstrength;
   u8Multipath = coRef.u8Multipath;
   u8Neighbour = coRef.u8Neighbour;
   u8AFListLength = coRef.u8AFListLength;
   u8TestmodeBits = coRef.u8TestmodeBits;
   u8TMCStationCount = coRef.u8TMCStationCount;
   u8TMCGroupState = coRef.u8TMCGroupState;
   u8AntennaState = coRef.u8AntennaState;
   u8PSName1 = coRef.u8PSName1;
   u8PSName2 = coRef.u8PSName2;
   u8PSName3 = coRef.u8PSName3;
   u8PSName4 = coRef.u8PSName4;
   u8PSName5 = coRef.u8PSName5;
   u8PSName6 = coRef.u8PSName6;
   u8PSName7 = coRef.u8PSName7;
   u8PSName8 = coRef.u8PSName8;
   sPSName = coRef.sPSName;
   u8IFState = coRef.u8IFState;
   u8ChannelSeparation = coRef.u8ChannelSeparation;
   u8Hub = coRef.u8Hub;
   u8RdsErrorRate = coRef.u8RdsErrorRate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerTestModeData::vDestroy()
{
   sPSName.vDestroy();
}

midw_fi_tcl_TunerTestModeData::midw_fi_tcl_TunerTestModeData()
:u8TunerHeader()
,u8AdditionalInfo()
,u32AFFrequency(0)
,u32PI(0)
,u8Quality(0)
,u8Fieldstrength(0)
,u8Multipath(0)
,u8Neighbour(0)
,u8AFListLength(0)
,u8TestmodeBits()
,u8TMCStationCount(0)
,u8TMCGroupState()
,u8AntennaState()
,u8PSName1(0)
,u8PSName2(0)
,u8PSName3(0)
,u8PSName4(0)
,u8PSName5(0)
,u8PSName6(0)
,u8PSName7(0)
,u8PSName8(0)
,sPSName()
,u8IFState()
,u8ChannelSeparation(0)
,u8Hub(0)
,u8RdsErrorRate(0)
 {}

tS32 midw_fi_tcl_TunerTestModeData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERTESTMODEDATA;
}


midw_fi_tcl_TunerTestModeData::~midw_fi_tcl_TunerTestModeData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerTestModeData::u32GetSize(tU16 u16MajorVersion) const
{
   return 31+sPSName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerTestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u8AdditionalInfo);
   (tVoid) (oIn >> u32AFFrequency);
   (tVoid) (oIn >> u32PI);
   (tVoid) (oIn >> u8Quality);
   (tVoid) (oIn >> u8Fieldstrength);
   (tVoid) (oIn >> u8Multipath);
   (tVoid) (oIn >> u8Neighbour);
   (tVoid) (oIn >> u8AFListLength);
   (tVoid) (oIn >> u8TestmodeBits);
   (tVoid) (oIn >> u8TMCStationCount);
   (tVoid) (oIn >> u8TMCGroupState);
   (tVoid) (oIn >> u8AntennaState);
   (tVoid) (oIn >> u8PSName1);
   (tVoid) (oIn >> u8PSName2);
   (tVoid) (oIn >> u8PSName3);
   (tVoid) (oIn >> u8PSName4);
   (tVoid) (oIn >> u8PSName5);
   (tVoid) (oIn >> u8PSName6);
   (tVoid) (oIn >> u8PSName7);
   (tVoid) (oIn >> u8PSName8);
   (tVoid) (oIn >> sPSName);
   (tVoid) (oIn >> u8IFState);
   (tVoid) (oIn >> u8ChannelSeparation);
   (tVoid) (oIn >> u8Hub);
   (tVoid) (oIn >> u8RdsErrorRate);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerTestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u8AdditionalInfo);
   (tVoid) (oOut << u32AFFrequency);
   (tVoid) (oOut << u32PI);
   (tVoid) (oOut << u8Quality);
   (tVoid) (oOut << u8Fieldstrength);
   (tVoid) (oOut << u8Multipath);
   (tVoid) (oOut << u8Neighbour);
   (tVoid) (oOut << u8AFListLength);
   (tVoid) (oOut << u8TestmodeBits);
   (tVoid) (oOut << u8TMCStationCount);
   (tVoid) (oOut << u8TMCGroupState);
   (tVoid) (oOut << u8AntennaState);
   (tVoid) (oOut << u8PSName1);
   (tVoid) (oOut << u8PSName2);
   (tVoid) (oOut << u8PSName3);
   (tVoid) (oOut << u8PSName4);
   (tVoid) (oOut << u8PSName5);
   (tVoid) (oOut << u8PSName6);
   (tVoid) (oOut << u8PSName7);
   (tVoid) (oOut << u8PSName8);
   (tVoid) (oOut << sPSName);
   (tVoid) (oOut << u8IFState);
   (tVoid) (oOut << u8ChannelSeparation);
   (tVoid) (oOut << u8Hub);
   (tVoid) (oOut << u8RdsErrorRate);
   return oOut;
}

tBool midw_fi_tcl_TunerTestModeData::operator==(const midw_fi_tcl_TunerTestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u8AdditionalInfo == roRef.u8AdditionalInfo);
   bResult = bResult && (u32AFFrequency == roRef.u32AFFrequency);
   bResult = bResult && (u32PI == roRef.u32PI);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   bResult = bResult && (u8Fieldstrength == roRef.u8Fieldstrength);
   bResult = bResult && (u8Multipath == roRef.u8Multipath);
   bResult = bResult && (u8Neighbour == roRef.u8Neighbour);
   bResult = bResult && (u8AFListLength == roRef.u8AFListLength);
   bResult = bResult && (u8TestmodeBits == roRef.u8TestmodeBits);
   bResult = bResult && (u8TMCStationCount == roRef.u8TMCStationCount);
   bResult = bResult && (u8TMCGroupState == roRef.u8TMCGroupState);
   bResult = bResult && (u8AntennaState == roRef.u8AntennaState);
   bResult = bResult && (u8PSName1 == roRef.u8PSName1);
   bResult = bResult && (u8PSName2 == roRef.u8PSName2);
   bResult = bResult && (u8PSName3 == roRef.u8PSName3);
   bResult = bResult && (u8PSName4 == roRef.u8PSName4);
   bResult = bResult && (u8PSName5 == roRef.u8PSName5);
   bResult = bResult && (u8PSName6 == roRef.u8PSName6);
   bResult = bResult && (u8PSName7 == roRef.u8PSName7);
   bResult = bResult && (u8PSName8 == roRef.u8PSName8);
   bResult = bResult && (sPSName == roRef.sPSName);
   bResult = bResult && (u8IFState == roRef.u8IFState);
   bResult = bResult && (u8ChannelSeparation == roRef.u8ChannelSeparation);
   bResult = bResult && (u8Hub == roRef.u8Hub);
   bResult = bResult && (u8RdsErrorRate == roRef.u8RdsErrorRate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ListType::midw_fi_tcl_e8_Tun_ListType():enType(FI_EN_TUN_LIST_TYPE_STATIC) {}

tS32 midw_fi_tcl_e8_Tun_ListType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_LISTTYPE;
}


midw_fi_tcl_e8_Tun_ListType::~midw_fi_tcl_e8_Tun_ListType()
{}

tU32 midw_fi_tcl_e8_Tun_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ConfigListID::midw_fi_tcl_e8_Tun_ConfigListID():enType(FI_EN_TUN_TUN_CONFIG_LIST_FM) {}

tS32 midw_fi_tcl_e8_Tun_ConfigListID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_CONFIGLISTID;
}


midw_fi_tcl_e8_Tun_ConfigListID::~midw_fi_tcl_e8_Tun_ConfigListID()
{}

tU32 midw_fi_tcl_e8_Tun_ConfigListID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ConfigListID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ConfigListID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Config_Filters::midw_fi_tcl_e8_Tun_Config_Filters():enType(FI_EN_TUN_CONFIG_NO_FILTER) {}

tS32 midw_fi_tcl_e8_Tun_Config_Filters::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_CONFIG_FILTERS;
}


midw_fi_tcl_e8_Tun_Config_Filters::~midw_fi_tcl_e8_Tun_Config_Filters()
{}

tU32 midw_fi_tcl_e8_Tun_Config_Filters::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Config_Filters::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Config_Filters::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_SortingCriteria::midw_fi_tcl_e8_Tun_SortingCriteria():enType(FI_EN_TUN_TUN_SORT_PS_ASCENDING) {}

tS32 midw_fi_tcl_e8_Tun_SortingCriteria::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SORTINGCRITERIA;
}


midw_fi_tcl_e8_Tun_SortingCriteria::~midw_fi_tcl_e8_Tun_SortingCriteria()
{}

tU32 midw_fi_tcl_e8_Tun_SortingCriteria::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_SortingCriteria::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_SortingCriteria::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ModulationType::midw_fi_tcl_e8_Tun_ModulationType():enType(FI_EN_TUN_MODULATION_ANALOG) {}

tS32 midw_fi_tcl_e8_Tun_ModulationType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MODULATIONTYPE;
}


midw_fi_tcl_e8_Tun_ModulationType::~midw_fi_tcl_e8_Tun_ModulationType()
{}

tU32 midw_fi_tcl_e8_Tun_ModulationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ModulationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ModulationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_Digital_Filters::midw_fi_tcl_b8_Tun_Digital_Filters():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_Digital_Filters::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_DIGITAL_FILTERS;
}


midw_fi_tcl_b8_Tun_Digital_Filters::~midw_fi_tcl_b8_Tun_Digital_Filters()
{}

tU32 midw_fi_tcl_b8_Tun_Digital_Filters::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_Digital_Filters::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_Digital_Filters::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_TmcApplicationId::midw_fi_tcl_e16_TmcApplicationId():enType(FI_EN_RESERVED) {}

tS32 midw_fi_tcl_e16_TmcApplicationId::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_TMCAPPLICATIONID;
}


midw_fi_tcl_e16_TmcApplicationId::~midw_fi_tcl_e16_TmcApplicationId()
{}

tU32 midw_fi_tcl_e16_TmcApplicationId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_TmcApplicationId::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_TmcApplicationId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Encryption::midw_fi_tcl_Encryption(const midw_fi_tcl_Encryption& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Encrypted = coRef.Encrypted;
   Encid = coRef.Encid;
   TestBits = coRef.TestBits;
}
midw_fi_tcl_Encryption& midw_fi_tcl_Encryption::operator=(const midw_fi_tcl_Encryption& coRef)
{
   if (this == &coRef) return *this;
   Encrypted = coRef.Encrypted;
   Encid = coRef.Encid;
   TestBits = coRef.TestBits;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Encryption::midw_fi_tcl_Encryption()
:Encrypted(0)
,Encid(0)
,TestBits(0)
 {}

tS32 midw_fi_tcl_Encryption::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ENCRYPTION;
}


midw_fi_tcl_Encryption::~midw_fi_tcl_Encryption()
{}

tU32 midw_fi_tcl_Encryption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_Encryption::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Encrypted);
   (tVoid) (oIn >> Encid);
   (tVoid) (oIn >> TestBits);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Encryption::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Encrypted);
   (tVoid) (oOut << Encid);
   (tVoid) (oOut << TestBits);
   return oOut;
}

tBool midw_fi_tcl_Encryption::operator==(const midw_fi_tcl_Encryption& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Encrypted == roRef.Encrypted);
   bResult = bResult && (Encid == roRef.Encid);
   bResult = bResult && (TestBits == roRef.TestBits);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TmcMediumType::midw_fi_tcl_e8_TmcMediumType():enType(FI_EN_RESERVED) {}

tS32 midw_fi_tcl_e8_TmcMediumType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TMCMEDIUMTYPE;
}


midw_fi_tcl_e8_TmcMediumType::~midw_fi_tcl_e8_TmcMediumType()
{}

tU32 midw_fi_tcl_e8_TmcMediumType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TmcMediumType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TmcMediumType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MsgSource::midw_fi_tcl_MsgSource(const midw_fi_tcl_MsgSource& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MediumTypeId = coRef.MediumTypeId;
   Number = coRef.Number;
}
midw_fi_tcl_MsgSource& midw_fi_tcl_MsgSource::operator=(const midw_fi_tcl_MsgSource& coRef)
{
   if (this == &coRef) return *this;
   MediumTypeId = coRef.MediumTypeId;
   Number = coRef.Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MsgSource::midw_fi_tcl_MsgSource()
:MediumTypeId()
,Number(0)
 {}

tS32 midw_fi_tcl_MsgSource::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MSGSOURCE;
}


midw_fi_tcl_MsgSource::~midw_fi_tcl_MsgSource()
{}

tU32 midw_fi_tcl_MsgSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_MsgSource::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediumTypeId);
   (tVoid) (oIn >> Number);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MsgSource::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediumTypeId);
   (tVoid) (oOut << Number);
   return oOut;
}

tBool midw_fi_tcl_MsgSource::operator==(const midw_fi_tcl_MsgSource& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediumTypeId == roRef.MediumTypeId);
   bResult = bResult && (Number == roRef.Number);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_RDBID_Value::midw_fi_tcl_Tun_RDBID_Value(const midw_fi_tcl_Tun_RDBID_Value& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8RdbidCC = coRef.u8RdbidCC;
   u8RdbidLTN = coRef.u8RdbidLTN;
   u8RdbidSID = coRef.u8RdbidSID;
   bEncFlag = coRef.bEncFlag;
}
midw_fi_tcl_Tun_RDBID_Value& midw_fi_tcl_Tun_RDBID_Value::operator=(const midw_fi_tcl_Tun_RDBID_Value& coRef)
{
   if (this == &coRef) return *this;
   u8RdbidCC = coRef.u8RdbidCC;
   u8RdbidLTN = coRef.u8RdbidLTN;
   u8RdbidSID = coRef.u8RdbidSID;
   bEncFlag = coRef.bEncFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_RDBID_Value::midw_fi_tcl_Tun_RDBID_Value()
:u8RdbidCC(0)
,u8RdbidLTN(0)
,u8RdbidSID(0)
,bEncFlag(0)
 {}

tS32 midw_fi_tcl_Tun_RDBID_Value::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_RDBID_VALUE;
}


midw_fi_tcl_Tun_RDBID_Value::~midw_fi_tcl_Tun_RDBID_Value()
{}

tU32 midw_fi_tcl_Tun_RDBID_Value::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_Tun_RDBID_Value::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8RdbidCC);
   (tVoid) (oIn >> u8RdbidLTN);
   (tVoid) (oIn >> u8RdbidSID);
   (tVoid) (oIn >> bEncFlag);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_RDBID_Value::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8RdbidCC);
   (tVoid) (oOut << u8RdbidLTN);
   (tVoid) (oOut << u8RdbidSID);
   (tVoid) (oOut << bEncFlag);
   return oOut;
}

tBool midw_fi_tcl_Tun_RDBID_Value::operator==(const midw_fi_tcl_Tun_RDBID_Value& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8RdbidCC == roRef.u8RdbidCC);
   bResult = bResult && (u8RdbidLTN == roRef.u8RdbidLTN);
   bResult = bResult && (u8RdbidSID == roRef.u8RdbidSID);
   bResult = bResult && (bEncFlag == roRef.bEncFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerRdbId::midw_fi_tcl_TunerRdbId(const midw_fi_tcl_TunerRdbId& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TMCCountryCode = coRef.TMCCountryCode;
   TableNo = coRef.TableNo;
   ServiceID = coRef.ServiceID;
   Encrypted = coRef.Encrypted;
}
midw_fi_tcl_TunerRdbId& midw_fi_tcl_TunerRdbId::operator=(const midw_fi_tcl_TunerRdbId& coRef)
{
   if (this == &coRef) return *this;
   TMCCountryCode = coRef.TMCCountryCode;
   TableNo = coRef.TableNo;
   ServiceID = coRef.ServiceID;
   Encrypted = coRef.Encrypted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerRdbId::midw_fi_tcl_TunerRdbId()
:TMCCountryCode(0)
,TableNo(0)
,ServiceID(0)
,Encrypted(0)
 {}

tS32 midw_fi_tcl_TunerRdbId::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERRDBID;
}


midw_fi_tcl_TunerRdbId::~midw_fi_tcl_TunerRdbId()
{}

tU32 midw_fi_tcl_TunerRdbId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_TunerRdbId::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TMCCountryCode);
   (tVoid) (oIn >> TableNo);
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> Encrypted);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerRdbId::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TMCCountryCode);
   (tVoid) (oOut << TableNo);
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << Encrypted);
   return oOut;
}

tBool midw_fi_tcl_TunerRdbId::operator==(const midw_fi_tcl_TunerRdbId& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TMCCountryCode == roRef.TMCCountryCode);
   bResult = bResult && (TableNo == roRef.TableNo);
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (Encrypted == roRef.Encrypted);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerGetDataTMC::midw_fi_tcl_TunerGetDataTMC(const midw_fi_tcl_TunerGetDataTMC& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u16TMCData1 = coRef.u16TMCData1;
   u16TMCData2 = coRef.u16TMCData2;
   u16TMCData3 = coRef.u16TMCData3;
   u16TMCData4 = coRef.u16TMCData4;
}
midw_fi_tcl_TunerGetDataTMC& midw_fi_tcl_TunerGetDataTMC::operator=(const midw_fi_tcl_TunerGetDataTMC& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u16TMCData1 = coRef.u16TMCData1;
   u16TMCData2 = coRef.u16TMCData2;
   u16TMCData3 = coRef.u16TMCData3;
   u16TMCData4 = coRef.u16TMCData4;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerGetDataTMC::midw_fi_tcl_TunerGetDataTMC()
:u8TunerHeader()
,u16TMCData1(0)
,u16TMCData2(0)
,u16TMCData3(0)
,u16TMCData4(0)
 {}

tS32 midw_fi_tcl_TunerGetDataTMC::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERGETDATATMC;
}


midw_fi_tcl_TunerGetDataTMC::~midw_fi_tcl_TunerGetDataTMC()
{}

tU32 midw_fi_tcl_TunerGetDataTMC::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_fi_tcl_TunerGetDataTMC::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u16TMCData1);
   (tVoid) (oIn >> u16TMCData2);
   (tVoid) (oIn >> u16TMCData3);
   (tVoid) (oIn >> u16TMCData4);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerGetDataTMC::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u16TMCData1);
   (tVoid) (oOut << u16TMCData2);
   (tVoid) (oOut << u16TMCData3);
   (tVoid) (oOut << u16TMCData4);
   return oOut;
}

tBool midw_fi_tcl_TunerGetDataTMC::operator==(const midw_fi_tcl_TunerGetDataTMC& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u16TMCData1 == roRef.u16TMCData1);
   bResult = bResult && (u16TMCData2 == roRef.u16TMCData2);
   bResult = bResult && (u16TMCData3 == roRef.u16TMCData3);
   bResult = bResult && (u16TMCData4 == roRef.u16TMCData4);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TrafficInfo::midw_fi_tcl_TrafficInfo(const midw_fi_tcl_TrafficInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   RDBId = coRef.RDBId;
   ECC = coRef.ECC;
   ApplicationId = coRef.ApplicationId;
   ListOf8AData = coRef.ListOf8AData;
   ProgramID = coRef.ProgramID;
   Encryption = coRef.Encryption;
   MsgSource = coRef.MsgSource;
   ProgramServiceName = coRef.ProgramServiceName;
   ServiceProviderName = coRef.ServiceProviderName;
}
midw_fi_tcl_TrafficInfo& midw_fi_tcl_TrafficInfo::operator=(const midw_fi_tcl_TrafficInfo& coRef)
{
   if (this == &coRef) return *this;
   RDBId = coRef.RDBId;
   ECC = coRef.ECC;
   ApplicationId = coRef.ApplicationId;
   ListOf8AData = coRef.ListOf8AData;
   ProgramID = coRef.ProgramID;
   Encryption = coRef.Encryption;
   MsgSource = coRef.MsgSource;
   ProgramServiceName = coRef.ProgramServiceName;
   ServiceProviderName = coRef.ServiceProviderName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TrafficInfo::vDestroy()
{
   RDBId.vDestroy(); 
   {
   ListOf8AData.clear();
   }
   Encryption.vDestroy(); 
   MsgSource.vDestroy(); 
   ProgramServiceName.vDestroy();
   ServiceProviderName.vDestroy();
}

midw_fi_tcl_TrafficInfo::midw_fi_tcl_TrafficInfo()
:RDBId()
,ECC(0)
,ApplicationId()

,ProgramID(0)
,Encryption()
,MsgSource()
,ProgramServiceName()
,ServiceProviderName()
 {}

tS32 midw_fi_tcl_TrafficInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TRAFFICINFO;
}


midw_fi_tcl_TrafficInfo::~midw_fi_tcl_TrafficInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TrafficInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 19+ static_cast<tU32>(ListOf8AData.size()*1)+ProgramServiceName.u32GetSize(u16MajorVersion)+ServiceProviderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TrafficInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RDBId);
   (tVoid) (oIn >> ECC);
   (tVoid) (oIn >> ApplicationId);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ListOf8AData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOf8AData[u32Idx]);
      }
   }
   (tVoid) (oIn >> ProgramID);
   (tVoid) (oIn >> Encryption);
   (tVoid) (oIn >> MsgSource);
   (tVoid) (oIn >> ProgramServiceName);
   (tVoid) (oIn >> ServiceProviderName);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TrafficInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RDBId);
   (tVoid) (oOut << ECC);
   (tVoid) (oOut << ApplicationId);
   (tVoid) (oOut << (tU32)ListOf8AData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOf8AData.size(); ++u32Idx)
         (tVoid) (oOut << ListOf8AData[u32Idx]);
   }
   (tVoid) (oOut << ProgramID);
   (tVoid) (oOut << Encryption);
   (tVoid) (oOut << MsgSource);
   (tVoid) (oOut << ProgramServiceName);
   (tVoid) (oOut << ServiceProviderName);
   return oOut;
}

tBool midw_fi_tcl_TrafficInfo::operator==(const midw_fi_tcl_TrafficInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RDBId == roRef.RDBId);
   bResult = bResult && (ECC == roRef.ECC);
   bResult = bResult && (ApplicationId == roRef.ApplicationId);
      bResult = bResult && (ListOf8AData.size() == roRef.ListOf8AData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOf8AData.size()); ++u32Idx)
            bResult = bResult && (ListOf8AData[u32Idx] == roRef.ListOf8AData[u32Idx]);
      }
   bResult = bResult && (ProgramID == roRef.ProgramID);
   bResult = bResult && (Encryption == roRef.Encryption);
   bResult = bResult && (MsgSource == roRef.MsgSource);
   bResult = bResult && (ProgramServiceName == roRef.ProgramServiceName);
   bResult = bResult && (ServiceProviderName == roRef.ServiceProviderName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_PackedInfo::midw_fi_tcl_b8_Tun_PackedInfo():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_PackedInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_PACKEDINFO;
}


midw_fi_tcl_b8_Tun_PackedInfo::~midw_fi_tcl_b8_Tun_PackedInfo()
{}

tU32 midw_fi_tcl_b8_Tun_PackedInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_PackedInfo::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_PackedInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MakeConfigListElem::midw_fi_tcl_MakeConfigListElem(const midw_fi_tcl_MakeConfigListElem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ListID = coRef.e8ListID;
   u8NumOfElementsInList = coRef.u8NumOfElementsInList;
}
midw_fi_tcl_MakeConfigListElem& midw_fi_tcl_MakeConfigListElem::operator=(const midw_fi_tcl_MakeConfigListElem& coRef)
{
   if (this == &coRef) return *this;
   e8ListID = coRef.e8ListID;
   u8NumOfElementsInList = coRef.u8NumOfElementsInList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MakeConfigListElem::midw_fi_tcl_MakeConfigListElem()
:e8ListID()
,u8NumOfElementsInList(0)
 {}

tS32 midw_fi_tcl_MakeConfigListElem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MAKECONFIGLISTELEM;
}


midw_fi_tcl_MakeConfigListElem::~midw_fi_tcl_MakeConfigListElem()
{}

tU32 midw_fi_tcl_MakeConfigListElem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_MakeConfigListElem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> u8NumOfElementsInList);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MakeConfigListElem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << u8NumOfElementsInList);
   return oOut;
}

tBool midw_fi_tcl_MakeConfigListElem::operator==(const midw_fi_tcl_MakeConfigListElem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (u8NumOfElementsInList == roRef.u8NumOfElementsInList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_AvailFlags::midw_fi_tcl_b8_Tun_AvailFlags():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_AvailFlags::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_AVAILFLAGS;
}


midw_fi_tcl_b8_Tun_AvailFlags::~midw_fi_tcl_b8_Tun_AvailFlags()
{}

tU32 midw_fi_tcl_b8_Tun_AvailFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_AvailFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_AvailFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_HD_TextEncodingType::midw_fi_tcl_e8_Tun_HD_TextEncodingType():enType(FI_EN_ISO_IEC_8859_1_1998) {}

tS32 midw_fi_tcl_e8_Tun_HD_TextEncodingType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_HD_TEXTENCODINGTYPE;
}


midw_fi_tcl_e8_Tun_HD_TextEncodingType::~midw_fi_tcl_e8_Tun_HD_TextEncodingType()
{}

tU32 midw_fi_tcl_e8_Tun_HD_TextEncodingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_HD_TextEncodingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_HD_TextEncodingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_StationInfo::midw_fi_tcl_b8_Tun_StationInfo():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_StationInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_STATIONINFO;
}


midw_fi_tcl_b8_Tun_StationInfo::~midw_fi_tcl_b8_Tun_StationInfo()
{}

tU32 midw_fi_tcl_b8_Tun_StationInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_StationInfo::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_StationInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_SendernameInfo::midw_fi_tcl_e8_Tun_SendernameInfo():enType(FI_EN_TUN_NON_RDS) {}

tS32 midw_fi_tcl_e8_Tun_SendernameInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SENDERNAMEINFO;
}


midw_fi_tcl_e8_Tun_SendernameInfo::~midw_fi_tcl_e8_Tun_SendernameInfo()
{}

tU32 midw_fi_tcl_e8_Tun_SendernameInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_SendernameInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_SendernameInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Sel_List_Elem::midw_fi_tcl_Sel_List_Elem(const midw_fi_tcl_Sel_List_Elem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   eConfigListID = coRef.eConfigListID;
   u32Frequency = coRef.u32Frequency;
   u16PICode = coRef.u16PICode;
   u8ListElementID = coRef.u8ListElementID;
   u8Listtype = coRef.u8Listtype;
   u32HDStnID_DRMSrvID = coRef.u32HDStnID_DRMSrvID;
   e8ModulationType = coRef.e8ModulationType;
}
midw_fi_tcl_Sel_List_Elem& midw_fi_tcl_Sel_List_Elem::operator=(const midw_fi_tcl_Sel_List_Elem& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   eConfigListID = coRef.eConfigListID;
   u32Frequency = coRef.u32Frequency;
   u16PICode = coRef.u16PICode;
   u8ListElementID = coRef.u8ListElementID;
   u8Listtype = coRef.u8Listtype;
   u32HDStnID_DRMSrvID = coRef.u32HDStnID_DRMSrvID;
   e8ModulationType = coRef.e8ModulationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Sel_List_Elem::midw_fi_tcl_Sel_List_Elem()
:u8TunerHeader()
,eConfigListID()
,u32Frequency(0)
,u16PICode(0)
,u8ListElementID(0)
,u8Listtype()
,u32HDStnID_DRMSrvID(0)
,e8ModulationType()
 {}

tS32 midw_fi_tcl_Sel_List_Elem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SEL_LIST_ELEM;
}


midw_fi_tcl_Sel_List_Elem::~midw_fi_tcl_Sel_List_Elem()
{}

tU32 midw_fi_tcl_Sel_List_Elem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_fi_tcl_Sel_List_Elem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> eConfigListID);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u16PICode);
   (tVoid) (oIn >> u8ListElementID);
   (tVoid) (oIn >> u8Listtype);
   (tVoid) (oIn >> u32HDStnID_DRMSrvID);
   (tVoid) (oIn >> e8ModulationType);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Sel_List_Elem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << eConfigListID);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u16PICode);
   (tVoid) (oOut << u8ListElementID);
   (tVoid) (oOut << u8Listtype);
   (tVoid) (oOut << u32HDStnID_DRMSrvID);
   (tVoid) (oOut << e8ModulationType);
   return oOut;
}

tBool midw_fi_tcl_Sel_List_Elem::operator==(const midw_fi_tcl_Sel_List_Elem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (eConfigListID == roRef.eConfigListID);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u16PICode == roRef.u16PICode);
   bResult = bResult && (u8ListElementID == roRef.u8ListElementID);
   bResult = bResult && (u8Listtype == roRef.u8Listtype);
   bResult = bResult && (u32HDStnID_DRMSrvID == roRef.u32HDStnID_DRMSrvID);
   bResult = bResult && (e8ModulationType == roRef.e8ModulationType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TMCType::midw_fi_tcl_e8_Tun_TMCType():enType(FI_EN_TUN_TMC_UNDECODED) {}

tS32 midw_fi_tcl_e8_Tun_TMCType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TMCTYPE;
}


midw_fi_tcl_e8_Tun_TMCType::~midw_fi_tcl_e8_Tun_TMCType()
{}

tU32 midw_fi_tcl_e8_Tun_TMCType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TMCType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TMCType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ListID::midw_fi_tcl_e8_Tun_ListID():enType(FI_EN_TUN_BANK_FM1) {}

tS32 midw_fi_tcl_e8_Tun_ListID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_LISTID;
}


midw_fi_tcl_e8_Tun_ListID::~midw_fi_tcl_e8_Tun_ListID()
{}

tU32 midw_fi_tcl_e8_Tun_ListID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ListID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ListID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Abs_Or_Rel::midw_fi_tcl_e8_Tun_Abs_Or_Rel():enType(FI_EN_TUN_PI_ABS) {}

tS32 midw_fi_tcl_e8_Tun_Abs_Or_Rel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ABS_OR_REL;
}


midw_fi_tcl_e8_Tun_Abs_Or_Rel::~midw_fi_tcl_e8_Tun_Abs_Or_Rel()
{}

tU32 midw_fi_tcl_e8_Tun_Abs_Or_Rel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Abs_Or_Rel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Abs_Or_Rel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Rel_Steps::midw_fi_tcl_e8_Tun_Rel_Steps():enType(FI_EN_INVALID_TYPE) {}

tS32 midw_fi_tcl_e8_Tun_Rel_Steps::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_REL_STEPS;
}


midw_fi_tcl_e8_Tun_Rel_Steps::~midw_fi_tcl_e8_Tun_Rel_Steps()
{}

tU32 midw_fi_tcl_e8_Tun_Rel_Steps::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Rel_Steps::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Rel_Steps::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Direction::midw_fi_tcl_e8_Tun_Direction():enType(FI_EN_INVALID_TYPE) {}

tS32 midw_fi_tcl_e8_Tun_Direction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_DIRECTION;
}


midw_fi_tcl_e8_Tun_Direction::~midw_fi_tcl_e8_Tun_Direction()
{}

tU32 midw_fi_tcl_e8_Tun_Direction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Direction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Direction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_Set_PI::midw_fi_tcl_Tun_Set_PI(const midw_fi_tcl_Tun_Set_PI& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8AbsOrRel = coRef.u8AbsOrRel;
   u8RelSteps = coRef.u8RelSteps;
   u8Direction = coRef.u8Direction;
   u8Nsteps = coRef.u8Nsteps;
   u16PI = coRef.u16PI;
   u32Frequency = coRef.u32Frequency;
}
midw_fi_tcl_Tun_Set_PI& midw_fi_tcl_Tun_Set_PI::operator=(const midw_fi_tcl_Tun_Set_PI& coRef)
{
   if (this == &coRef) return *this;
   u8AbsOrRel = coRef.u8AbsOrRel;
   u8RelSteps = coRef.u8RelSteps;
   u8Direction = coRef.u8Direction;
   u8Nsteps = coRef.u8Nsteps;
   u16PI = coRef.u16PI;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_Set_PI::midw_fi_tcl_Tun_Set_PI()
:u8AbsOrRel()
,u8RelSteps()
,u8Direction()
,u8Nsteps(0)
,u16PI(0)
,u32Frequency(0)
 {}

tS32 midw_fi_tcl_Tun_Set_PI::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_SET_PI;
}


midw_fi_tcl_Tun_Set_PI::~midw_fi_tcl_Tun_Set_PI()
{}

tU32 midw_fi_tcl_Tun_Set_PI::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_fi_tcl_Tun_Set_PI::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AbsOrRel);
   (tVoid) (oIn >> u8RelSteps);
   (tVoid) (oIn >> u8Direction);
   (tVoid) (oIn >> u8Nsteps);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_Set_PI::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AbsOrRel);
   (tVoid) (oOut << u8RelSteps);
   (tVoid) (oOut << u8Direction);
   (tVoid) (oOut << u8Nsteps);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_fi_tcl_Tun_Set_PI::operator==(const midw_fi_tcl_Tun_Set_PI& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AbsOrRel == roRef.u8AbsOrRel);
   bResult = bResult && (u8RelSteps == roRef.u8RelSteps);
   bResult = bResult && (u8Direction == roRef.u8Direction);
   bResult = bResult && (u8Nsteps == roRef.u8Nsteps);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Autostore::midw_fi_tcl_e8_Tun_Autostore():enType(FI_EN_NO_AUTOSTORE) {}

tS32 midw_fi_tcl_e8_Tun_Autostore::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_AUTOSTORE;
}


midw_fi_tcl_e8_Tun_Autostore::~midw_fi_tcl_e8_Tun_Autostore()
{}

tU32 midw_fi_tcl_e8_Tun_Autostore::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Autostore::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Autostore::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ModeDirection::midw_fi_tcl_e8_Tun_ModeDirection():enType(FI_EN_INVALID) {}

tS32 midw_fi_tcl_e8_Tun_ModeDirection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MODEDIRECTION;
}


midw_fi_tcl_e8_Tun_ModeDirection::~midw_fi_tcl_e8_Tun_ModeDirection()
{}

tU32 midw_fi_tcl_e8_Tun_ModeDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ModeDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ModeDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ListElementInfo::midw_fi_tcl_e8_Tun_ListElementInfo():enType(FI_EN_LIST_ELEMENT_INFO_VALID) {}

tS32 midw_fi_tcl_e8_Tun_ListElementInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_LISTELEMENTINFO;
}


midw_fi_tcl_e8_Tun_ListElementInfo::~midw_fi_tcl_e8_Tun_ListElementInfo()
{}

tU32 midw_fi_tcl_e8_Tun_ListElementInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ListElementInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ListElementInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerStaticListElement::midw_fi_tcl_TunerStaticListElement(const midw_fi_tcl_TunerStaticListElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ListID = coRef.e8ListID;
   u8ElementID = coRef.u8ElementID;
   bSelected = coRef.bSelected;
   u32Frequency = coRef.u32Frequency;
   sPSName = coRef.sPSName;
   u16PI = coRef.u16PI;
   e8SendernameInfo = coRef.e8SendernameInfo;
   u8TpTmcInfo = coRef.u8TpTmcInfo;
   u32PTY = coRef.u32PTY;
   s8LevelCompensation = coRef.s8LevelCompensation;
   e8Modulation = coRef.e8Modulation;
   u32HDStationId_DRMServiceId = coRef.u32HDStationId_DRMServiceId;
   sHDCallSign_DRMServiceLabel = coRef.sHDCallSign_DRMServiceLabel;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   u8HDStationGenre_DRMPty = coRef.u8HDStationGenre_DRMPty;
   u8HDAudioProgram_DRMShortID = coRef.u8HDAudioProgram_DRMShortID;
   StationLogo = coRef.StationLogo;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMPTY = coRef.u8DRMPTY;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
}
midw_fi_tcl_TunerStaticListElement& midw_fi_tcl_TunerStaticListElement::operator=(const midw_fi_tcl_TunerStaticListElement& coRef)
{
   if (this == &coRef) return *this;
   e8ListID = coRef.e8ListID;
   u8ElementID = coRef.u8ElementID;
   bSelected = coRef.bSelected;
   u32Frequency = coRef.u32Frequency;
   sPSName = coRef.sPSName;
   u16PI = coRef.u16PI;
   e8SendernameInfo = coRef.e8SendernameInfo;
   u8TpTmcInfo = coRef.u8TpTmcInfo;
   u32PTY = coRef.u32PTY;
   s8LevelCompensation = coRef.s8LevelCompensation;
   e8Modulation = coRef.e8Modulation;
   u32HDStationId_DRMServiceId = coRef.u32HDStationId_DRMServiceId;
   sHDCallSign_DRMServiceLabel = coRef.sHDCallSign_DRMServiceLabel;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   u8HDStationGenre_DRMPty = coRef.u8HDStationGenre_DRMPty;
   u8HDAudioProgram_DRMShortID = coRef.u8HDAudioProgram_DRMShortID;
   StationLogo = coRef.StationLogo;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMPTY = coRef.u8DRMPTY;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerStaticListElement::vDestroy()
{
   sPSName.vDestroy();
   sHDCallSign_DRMServiceLabel.vDestroy();
   StationLogo.vDestroy();
   sDRMServiceLabel.vDestroy();
}

midw_fi_tcl_TunerStaticListElement::midw_fi_tcl_TunerStaticListElement()
:e8ListID()
,u8ElementID(0)
,bSelected(0)
,u32Frequency(0)
,sPSName()
,u16PI(0)
,e8SendernameInfo()
,u8TpTmcInfo(0)
,u32PTY(0)
,s8LevelCompensation(0)
,e8Modulation()
,u32HDStationId_DRMServiceId(0)
,sHDCallSign_DRMServiceLabel()
,e8HDTextEncoding()
,u8HDStationGenre_DRMPty(0)
,u8HDAudioProgram_DRMShortID(0)
,StationLogo()
,u32DRMServiceId(0)
,sDRMServiceLabel()
,u8DRMPTY(0)
,u8DRMServiceShortId(0)
 {}

tS32 midw_fi_tcl_TunerStaticListElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERSTATICLISTELEMENT;
}


midw_fi_tcl_TunerStaticListElement::~midw_fi_tcl_TunerStaticListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerStaticListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 30+sPSName.u32GetSize(u16MajorVersion)+sHDCallSign_DRMServiceLabel.u32GetSize(u16MajorVersion)+StationLogo.u32GetSize(u16MajorVersion)+sDRMServiceLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerStaticListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> u8ElementID);
   (tVoid) (oIn >> bSelected);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> sPSName);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> e8SendernameInfo);
   (tVoid) (oIn >> u8TpTmcInfo);
   (tVoid) (oIn >> u32PTY);
   (tVoid) (oIn >> s8LevelCompensation);
   (tVoid) (oIn >> e8Modulation);
   (tVoid) (oIn >> u32HDStationId_DRMServiceId);
   (tVoid) (oIn >> sHDCallSign_DRMServiceLabel);
   (tVoid) (oIn >> e8HDTextEncoding);
   (tVoid) (oIn >> u8HDStationGenre_DRMPty);
   (tVoid) (oIn >> u8HDAudioProgram_DRMShortID);
   (tVoid) (oIn >> StationLogo);
   (tVoid) (oIn >> u32DRMServiceId);
   (tVoid) (oIn >> sDRMServiceLabel);
   (tVoid) (oIn >> u8DRMPTY);
   (tVoid) (oIn >> u8DRMServiceShortId);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerStaticListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << u8ElementID);
   (tVoid) (oOut << bSelected);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << sPSName);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << e8SendernameInfo);
   (tVoid) (oOut << u8TpTmcInfo);
   (tVoid) (oOut << u32PTY);
   (tVoid) (oOut << s8LevelCompensation);
   (tVoid) (oOut << e8Modulation);
   (tVoid) (oOut << u32HDStationId_DRMServiceId);
   (tVoid) (oOut << sHDCallSign_DRMServiceLabel);
   (tVoid) (oOut << e8HDTextEncoding);
   (tVoid) (oOut << u8HDStationGenre_DRMPty);
   (tVoid) (oOut << u8HDAudioProgram_DRMShortID);
   (tVoid) (oOut << StationLogo);
   (tVoid) (oOut << u32DRMServiceId);
   (tVoid) (oOut << sDRMServiceLabel);
   (tVoid) (oOut << u8DRMPTY);
   (tVoid) (oOut << u8DRMServiceShortId);
   return oOut;
}

tBool midw_fi_tcl_TunerStaticListElement::operator==(const midw_fi_tcl_TunerStaticListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (u8ElementID == roRef.u8ElementID);
   bResult = bResult && (bSelected == roRef.bSelected);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (sPSName == roRef.sPSName);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (e8SendernameInfo == roRef.e8SendernameInfo);
   bResult = bResult && (u8TpTmcInfo == roRef.u8TpTmcInfo);
   bResult = bResult && (u32PTY == roRef.u32PTY);
   bResult = bResult && (s8LevelCompensation == roRef.s8LevelCompensation);
   bResult = bResult && (e8Modulation == roRef.e8Modulation);
   bResult = bResult && (u32HDStationId_DRMServiceId == roRef.u32HDStationId_DRMServiceId);
   bResult = bResult && (sHDCallSign_DRMServiceLabel == roRef.sHDCallSign_DRMServiceLabel);
   bResult = bResult && (e8HDTextEncoding == roRef.e8HDTextEncoding);
   bResult = bResult && (u8HDStationGenre_DRMPty == roRef.u8HDStationGenre_DRMPty);
   bResult = bResult && (u8HDAudioProgram_DRMShortID == roRef.u8HDAudioProgram_DRMShortID);
   bResult = bResult && (StationLogo == roRef.StationLogo);
   bResult = bResult && (u32DRMServiceId == roRef.u32DRMServiceId);
   bResult = bResult && (sDRMServiceLabel == roRef.sDRMServiceLabel);
   bResult = bResult && (u8DRMPTY == roRef.u8DRMPTY);
   bResult = bResult && (u8DRMServiceShortId == roRef.u8DRMServiceShortId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_HDNUMOFAUDIOPROGRAMS;
}


midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::~midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms()
{}

tU32 midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerConfigListElement::midw_fi_tcl_TunerConfigListElement(const midw_fi_tcl_TunerConfigListElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
   u8ElementID = coRef.u8ElementID;
   u8ElementSelected = coRef.u8ElementSelected;
   u32Frequency = coRef.u32Frequency;
   u32PI = coRef.u32PI;
   sPSName = coRef.sPSName;
   u8PTY = coRef.u8PTY;
   u8ECC = coRef.u8ECC;
   u8SID = coRef.u8SID;
   u8LTN = coRef.u8LTN;
   u8Quality = coRef.u8Quality;
   u8PositionInPresetList = coRef.u8PositionInPresetList;
   e8SendernameInfo = coRef.e8SendernameInfo;
   bTpInfo = coRef.bTpInfo;
   e8TMCType = coRef.e8TMCType;
   e8PresetListForAcmp = coRef.e8PresetListForAcmp;
   s8LevelCompensation = coRef.s8LevelCompensation;
   StationLogo = coRef.StationLogo;
   e8ModulationType = coRef.e8ModulationType;
   u8PTY_HDPTY_DRMPty = coRef.u8PTY_HDPTY_DRMPty;
   u32PI_HDStnId_DRMSrvId = coRef.u32PI_HDStnId_DRMSrvId;
   b8StationInfo = coRef.b8StationInfo;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   b8HDNumOfAudioPrograms = coRef.b8HDNumOfAudioPrograms;
}
midw_fi_tcl_TunerConfigListElement& midw_fi_tcl_TunerConfigListElement::operator=(const midw_fi_tcl_TunerConfigListElement& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   u8ElementID = coRef.u8ElementID;
   u8ElementSelected = coRef.u8ElementSelected;
   u32Frequency = coRef.u32Frequency;
   u32PI = coRef.u32PI;
   sPSName = coRef.sPSName;
   u8PTY = coRef.u8PTY;
   u8ECC = coRef.u8ECC;
   u8SID = coRef.u8SID;
   u8LTN = coRef.u8LTN;
   u8Quality = coRef.u8Quality;
   u8PositionInPresetList = coRef.u8PositionInPresetList;
   e8SendernameInfo = coRef.e8SendernameInfo;
   bTpInfo = coRef.bTpInfo;
   e8TMCType = coRef.e8TMCType;
   e8PresetListForAcmp = coRef.e8PresetListForAcmp;
   s8LevelCompensation = coRef.s8LevelCompensation;
   StationLogo = coRef.StationLogo;
   e8ModulationType = coRef.e8ModulationType;
   u8PTY_HDPTY_DRMPty = coRef.u8PTY_HDPTY_DRMPty;
   u32PI_HDStnId_DRMSrvId = coRef.u32PI_HDStnId_DRMSrvId;
   b8StationInfo = coRef.b8StationInfo;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   b8HDNumOfAudioPrograms = coRef.b8HDNumOfAudioPrograms;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerConfigListElement::vDestroy()
{
   sPSName.vDestroy();
   StationLogo.vDestroy();
}

midw_fi_tcl_TunerConfigListElement::midw_fi_tcl_TunerConfigListElement()
:e8ConfigListID()
,u8ElementID(0)
,u8ElementSelected(0)
,u32Frequency(0)
,u32PI(0)
,sPSName()
,u8PTY(0)
,u8ECC(0)
,u8SID(0)
,u8LTN(0)
,u8Quality(0)
,u8PositionInPresetList(0)
,e8SendernameInfo()
,bTpInfo(0)
,e8TMCType()
,e8PresetListForAcmp()
,s8LevelCompensation(0)
,StationLogo()
,e8ModulationType()
,u8PTY_HDPTY_DRMPty(0)
,u32PI_HDStnId_DRMSrvId(0)
,b8StationInfo()
,e8HDTextEncoding()
,b8HDNumOfAudioPrograms()
 {}

tS32 midw_fi_tcl_TunerConfigListElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERCONFIGLISTELEMENT;
}


midw_fi_tcl_TunerConfigListElement::~midw_fi_tcl_TunerConfigListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerConfigListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 31+sPSName.u32GetSize(u16MajorVersion)+StationLogo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerConfigListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   (tVoid) (oIn >> u8ElementID);
   (tVoid) (oIn >> u8ElementSelected);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u32PI);
   (tVoid) (oIn >> sPSName);
   (tVoid) (oIn >> u8PTY);
   (tVoid) (oIn >> u8ECC);
   (tVoid) (oIn >> u8SID);
   (tVoid) (oIn >> u8LTN);
   (tVoid) (oIn >> u8Quality);
   (tVoid) (oIn >> u8PositionInPresetList);
   (tVoid) (oIn >> e8SendernameInfo);
   (tVoid) (oIn >> bTpInfo);
   (tVoid) (oIn >> e8TMCType);
   (tVoid) (oIn >> e8PresetListForAcmp);
   (tVoid) (oIn >> s8LevelCompensation);
   (tVoid) (oIn >> StationLogo);
   (tVoid) (oIn >> e8ModulationType);
   (tVoid) (oIn >> u8PTY_HDPTY_DRMPty);
   (tVoid) (oIn >> u32PI_HDStnId_DRMSrvId);
   (tVoid) (oIn >> b8StationInfo);
   (tVoid) (oIn >> e8HDTextEncoding);
   (tVoid) (oIn >> b8HDNumOfAudioPrograms);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerConfigListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   (tVoid) (oOut << u8ElementID);
   (tVoid) (oOut << u8ElementSelected);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u32PI);
   (tVoid) (oOut << sPSName);
   (tVoid) (oOut << u8PTY);
   (tVoid) (oOut << u8ECC);
   (tVoid) (oOut << u8SID);
   (tVoid) (oOut << u8LTN);
   (tVoid) (oOut << u8Quality);
   (tVoid) (oOut << u8PositionInPresetList);
   (tVoid) (oOut << e8SendernameInfo);
   (tVoid) (oOut << bTpInfo);
   (tVoid) (oOut << e8TMCType);
   (tVoid) (oOut << e8PresetListForAcmp);
   (tVoid) (oOut << s8LevelCompensation);
   (tVoid) (oOut << StationLogo);
   (tVoid) (oOut << e8ModulationType);
   (tVoid) (oOut << u8PTY_HDPTY_DRMPty);
   (tVoid) (oOut << u32PI_HDStnId_DRMSrvId);
   (tVoid) (oOut << b8StationInfo);
   (tVoid) (oOut << e8HDTextEncoding);
   (tVoid) (oOut << b8HDNumOfAudioPrograms);
   return oOut;
}

tBool midw_fi_tcl_TunerConfigListElement::operator==(const midw_fi_tcl_TunerConfigListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   bResult = bResult && (u8ElementID == roRef.u8ElementID);
   bResult = bResult && (u8ElementSelected == roRef.u8ElementSelected);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u32PI == roRef.u32PI);
   bResult = bResult && (sPSName == roRef.sPSName);
   bResult = bResult && (u8PTY == roRef.u8PTY);
   bResult = bResult && (u8ECC == roRef.u8ECC);
   bResult = bResult && (u8SID == roRef.u8SID);
   bResult = bResult && (u8LTN == roRef.u8LTN);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   bResult = bResult && (u8PositionInPresetList == roRef.u8PositionInPresetList);
   bResult = bResult && (e8SendernameInfo == roRef.e8SendernameInfo);
   bResult = bResult && (bTpInfo == roRef.bTpInfo);
   bResult = bResult && (e8TMCType == roRef.e8TMCType);
   bResult = bResult && (e8PresetListForAcmp == roRef.e8PresetListForAcmp);
   bResult = bResult && (s8LevelCompensation == roRef.s8LevelCompensation);
   bResult = bResult && (StationLogo == roRef.StationLogo);
   bResult = bResult && (e8ModulationType == roRef.e8ModulationType);
   bResult = bResult && (u8PTY_HDPTY_DRMPty == roRef.u8PTY_HDPTY_DRMPty);
   bResult = bResult && (u32PI_HDStnId_DRMSrvId == roRef.u32PI_HDStnId_DRMSrvId);
   bResult = bResult && (b8StationInfo == roRef.b8StationInfo);
   bResult = bResult && (e8HDTextEncoding == roRef.e8HDTextEncoding);
   bResult = bResult && (b8HDNumOfAudioPrograms == roRef.b8HDNumOfAudioPrograms);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_PresetAction::midw_fi_tcl_e8_Tun_PresetAction():enType(FI_EN_RECALL_ELEMENT) {}

tS32 midw_fi_tcl_e8_Tun_PresetAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_PRESETACTION;
}


midw_fi_tcl_e8_Tun_PresetAction::~midw_fi_tcl_e8_Tun_PresetAction()
{}

tU32 midw_fi_tcl_e8_Tun_PresetAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_PresetAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_PresetAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerStaticListElementList::midw_fi_tcl_TunerStaticListElementList(const midw_fi_tcl_TunerStaticListElementList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerStaticListElement = coRef.TunerStaticListElement;
}
midw_fi_tcl_TunerStaticListElementList& midw_fi_tcl_TunerStaticListElementList::operator=(const midw_fi_tcl_TunerStaticListElementList& coRef)
{
   if (this == &coRef) return *this;
   TunerStaticListElement = coRef.TunerStaticListElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerStaticListElementList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerStaticListElement.size(); ++u32Idx)
         TunerStaticListElement[u32Idx].vDestroy();
   TunerStaticListElement.clear();
   }
}

midw_fi_tcl_TunerStaticListElementList::midw_fi_tcl_TunerStaticListElementList()

 {}

tS32 midw_fi_tcl_TunerStaticListElementList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERSTATICLISTELEMENTLIST;
}


midw_fi_tcl_TunerStaticListElementList::~midw_fi_tcl_TunerStaticListElementList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerStaticListElementList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TunerStaticListElement.size(); ++u32ListIdx)
      u32DynamicSize += TunerStaticListElement[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_TunerStaticListElementList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerStaticListElement.size(); ++u32Idx)
      {
         TunerStaticListElement[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerStaticListElement.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerStaticListElement[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerStaticListElementList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerStaticListElement.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerStaticListElement.size(); ++u32Idx)
         (tVoid) (oOut << TunerStaticListElement[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TunerStaticListElementList::operator==(const midw_fi_tcl_TunerStaticListElementList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerStaticListElement.size() == roRef.TunerStaticListElement.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerStaticListElement.size()); ++u32Idx)
            bResult = bResult && (TunerStaticListElement[u32Idx] == roRef.TunerStaticListElement[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_Tun_TroubleCode::midw_fi_tcl_e16_Tun_TroubleCode():enType(FI_EN_VDL_ITC_FC_TMC_TUNER_FM_RECEPTION_ERROR) {}

tS32 midw_fi_tcl_e16_Tun_TroubleCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_TUN_TROUBLECODE;
}


midw_fi_tcl_e16_Tun_TroubleCode::~midw_fi_tcl_e16_Tun_TroubleCode()
{}

tU32 midw_fi_tcl_e16_Tun_TroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_Tun_TroubleCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_Tun_TroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_MonitoringMode::midw_fi_tcl_e8_Tun_MonitoringMode():enType(FI_EN_FC_TUNER_MONITORING_OFF) {}

tS32 midw_fi_tcl_e8_Tun_MonitoringMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MONITORINGMODE;
}


midw_fi_tcl_e8_Tun_MonitoringMode::~midw_fi_tcl_e8_Tun_MonitoringMode()
{}

tU32 midw_fi_tcl_e8_Tun_MonitoringMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_MonitoringMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_MonitoringMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_SupervisionControl::midw_fi_tcl_e8_Tun_SupervisionControl():enType(FI_EN_FC_TUNER_SUPERVISION_DEFAULT) {}

tS32 midw_fi_tcl_e8_Tun_SupervisionControl::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SUPERVISIONCONTROL;
}


midw_fi_tcl_e8_Tun_SupervisionControl::~midw_fi_tcl_e8_Tun_SupervisionControl()
{}

tU32 midw_fi_tcl_e8_Tun_SupervisionControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_SupervisionControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_SupervisionControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerTestRoutineParameter::midw_fi_tcl_TunerTestRoutineParameter(const midw_fi_tcl_TunerTestRoutineParameter& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
}
midw_fi_tcl_TunerTestRoutineParameter& midw_fi_tcl_TunerTestRoutineParameter::operator=(const midw_fi_tcl_TunerTestRoutineParameter& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerTestRoutineParameter::midw_fi_tcl_TunerTestRoutineParameter()
:TroubleCode()
,WriteToRM(0)
,MonitoringMode()
,SupervisionControl()
 {}

tS32 midw_fi_tcl_TunerTestRoutineParameter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERTESTROUTINEPARAMETER;
}


midw_fi_tcl_TunerTestRoutineParameter::~midw_fi_tcl_TunerTestRoutineParameter()
{}

tU32 midw_fi_tcl_TunerTestRoutineParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TunerTestRoutineParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> WriteToRM);
   (tVoid) (oIn >> MonitoringMode);
   (tVoid) (oIn >> SupervisionControl);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerTestRoutineParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << WriteToRM);
   (tVoid) (oOut << MonitoringMode);
   (tVoid) (oOut << SupervisionControl);
   return oOut;
}

tBool midw_fi_tcl_TunerTestRoutineParameter::operator==(const midw_fi_tcl_TunerTestRoutineParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (WriteToRM == roRef.WriteToRM);
   bResult = bResult && (MonitoringMode == roRef.MonitoringMode);
   bResult = bResult && (SupervisionControl == roRef.SupervisionControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerTestRoutineParameterList::midw_fi_tcl_TunerTestRoutineParameterList(const midw_fi_tcl_TunerTestRoutineParameterList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerTestRoutineParameter = coRef.TunerTestRoutineParameter;
}
midw_fi_tcl_TunerTestRoutineParameterList& midw_fi_tcl_TunerTestRoutineParameterList::operator=(const midw_fi_tcl_TunerTestRoutineParameterList& coRef)
{
   if (this == &coRef) return *this;
   TunerTestRoutineParameter = coRef.TunerTestRoutineParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerTestRoutineParameterList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerTestRoutineParameter.size(); ++u32Idx)
         TunerTestRoutineParameter[u32Idx].vDestroy();
   TunerTestRoutineParameter.clear();
   }
}

midw_fi_tcl_TunerTestRoutineParameterList::midw_fi_tcl_TunerTestRoutineParameterList()

 {}

tS32 midw_fi_tcl_TunerTestRoutineParameterList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERTESTROUTINEPARAMETERLIST;
}


midw_fi_tcl_TunerTestRoutineParameterList::~midw_fi_tcl_TunerTestRoutineParameterList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerTestRoutineParameterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TunerTestRoutineParameter.size()*5);
}

fi_tclInContext& midw_fi_tcl_TunerTestRoutineParameterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerTestRoutineParameter.size(); ++u32Idx)
      {
         TunerTestRoutineParameter[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerTestRoutineParameter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerTestRoutineParameter[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerTestRoutineParameterList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerTestRoutineParameter.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerTestRoutineParameter.size(); ++u32Idx)
         (tVoid) (oOut << TunerTestRoutineParameter[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TunerTestRoutineParameterList::operator==(const midw_fi_tcl_TunerTestRoutineParameterList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerTestRoutineParameter.size() == roRef.TunerTestRoutineParameter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerTestRoutineParameter.size()); ++u32Idx)
            bResult = bResult && (TunerTestRoutineParameter[u32Idx] == roRef.TunerTestRoutineParameter[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ErrorStatus::midw_fi_tcl_e8_Tun_ErrorStatus():enType(FI_EN_FC_TUNER_TEST_PASSED) {}

tS32 midw_fi_tcl_e8_Tun_ErrorStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ERRORSTATUS;
}


midw_fi_tcl_e8_Tun_ErrorStatus::~midw_fi_tcl_e8_Tun_ErrorStatus()
{}

tU32 midw_fi_tcl_e8_Tun_ErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_MuteStatus::midw_fi_tcl_e8_Tun_MuteStatus():enType(FI_EN_MUTE) {}

tS32 midw_fi_tcl_e8_Tun_MuteStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_MUTESTATUS;
}


midw_fi_tcl_e8_Tun_MuteStatus::~midw_fi_tcl_e8_Tun_MuteStatus()
{}

tU32 midw_fi_tcl_e8_Tun_MuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_MuteStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_MuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_RoutineStatus::midw_fi_tcl_e8_Tun_RoutineStatus():enType(FI_EN_FC_TUNER_ROUTINE_NOT_RUNNING) {}

tS32 midw_fi_tcl_e8_Tun_RoutineStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ROUTINESTATUS;
}


midw_fi_tcl_e8_Tun_RoutineStatus::~midw_fi_tcl_e8_Tun_RoutineStatus()
{}

tU32 midw_fi_tcl_e8_Tun_RoutineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_RoutineStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_RoutineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_TestTroubleCodeStatus::midw_fi_tcl_Tun_TestTroubleCodeStatus(const midw_fi_tcl_Tun_TestTroubleCodeStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
}
midw_fi_tcl_Tun_TestTroubleCodeStatus& midw_fi_tcl_Tun_TestTroubleCodeStatus::operator=(const midw_fi_tcl_Tun_TestTroubleCodeStatus& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_TestTroubleCodeStatus::midw_fi_tcl_Tun_TestTroubleCodeStatus()
:TroubleCode()
,ErrorStatus()
,RoutineStatus()
 {}

tS32 midw_fi_tcl_Tun_TestTroubleCodeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_TESTTROUBLECODESTATUS;
}


midw_fi_tcl_Tun_TestTroubleCodeStatus::~midw_fi_tcl_Tun_TestTroubleCodeStatus()
{}

tU32 midw_fi_tcl_Tun_TestTroubleCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_Tun_TestTroubleCodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> ErrorStatus);
   (tVoid) (oIn >> RoutineStatus);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_TestTroubleCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << ErrorStatus);
   (tVoid) (oOut << RoutineStatus);
   return oOut;
}

tBool midw_fi_tcl_Tun_TestTroubleCodeStatus::operator==(const midw_fi_tcl_Tun_TestTroubleCodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (ErrorStatus == roRef.ErrorStatus);
   bResult = bResult && (RoutineStatus == roRef.RoutineStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_TestTroubleCodeStatusList::midw_fi_tcl_Tun_TestTroubleCodeStatusList(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerTestTroubleCodeStatus = coRef.TunerTestTroubleCodeStatus;
}
midw_fi_tcl_Tun_TestTroubleCodeStatusList& midw_fi_tcl_Tun_TestTroubleCodeStatusList::operator=(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& coRef)
{
   if (this == &coRef) return *this;
   TunerTestTroubleCodeStatus = coRef.TunerTestTroubleCodeStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Tun_TestTroubleCodeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerTestTroubleCodeStatus.size(); ++u32Idx)
         TunerTestTroubleCodeStatus[u32Idx].vDestroy();
   TunerTestTroubleCodeStatus.clear();
   }
}

midw_fi_tcl_Tun_TestTroubleCodeStatusList::midw_fi_tcl_Tun_TestTroubleCodeStatusList()

 {}

tS32 midw_fi_tcl_Tun_TestTroubleCodeStatusList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_TESTTROUBLECODESTATUSLIST;
}


midw_fi_tcl_Tun_TestTroubleCodeStatusList::~midw_fi_tcl_Tun_TestTroubleCodeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Tun_TestTroubleCodeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TunerTestTroubleCodeStatus.size()*4);
}

fi_tclInContext& midw_fi_tcl_Tun_TestTroubleCodeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerTestTroubleCodeStatus.size(); ++u32Idx)
      {
         TunerTestTroubleCodeStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerTestTroubleCodeStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerTestTroubleCodeStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_TestTroubleCodeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerTestTroubleCodeStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerTestTroubleCodeStatus.size(); ++u32Idx)
         (tVoid) (oOut << TunerTestTroubleCodeStatus[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Tun_TestTroubleCodeStatusList::operator==(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerTestTroubleCodeStatus.size() == roRef.TunerTestTroubleCodeStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerTestTroubleCodeStatus.size()); ++u32Idx)
            bResult = bResult && (TunerTestTroubleCodeStatus[u32Idx] == roRef.TunerTestTroubleCodeStatus[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerFieldstrength::midw_fi_tcl_TunerFieldstrength(const midw_fi_tcl_TunerFieldstrength& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Band = coRef.u8Band;
   u32Frequency = coRef.u32Frequency;
}
midw_fi_tcl_TunerFieldstrength& midw_fi_tcl_TunerFieldstrength::operator=(const midw_fi_tcl_TunerFieldstrength& coRef)
{
   if (this == &coRef) return *this;
   u8Band = coRef.u8Band;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerFieldstrength::midw_fi_tcl_TunerFieldstrength()
:u8Band(0)
,u32Frequency(0)
 {}

tS32 midw_fi_tcl_TunerFieldstrength::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERFIELDSTRENGTH;
}


midw_fi_tcl_TunerFieldstrength::~midw_fi_tcl_TunerFieldstrength()
{}

tU32 midw_fi_tcl_TunerFieldstrength::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TunerFieldstrength::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Band);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerFieldstrength::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Band);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_fi_tcl_TunerFieldstrength::operator==(const midw_fi_tcl_TunerFieldstrength& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Band == roRef.u8Band);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_Diag_ErrorCode::midw_fi_tcl_Tun_Diag_ErrorCode():enType(FI_EN_TUN_UNSPECIFIED) {}

tS32 midw_fi_tcl_Tun_Diag_ErrorCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_DIAG_ERRORCODE;
}


midw_fi_tcl_Tun_Diag_ErrorCode::~midw_fi_tcl_Tun_Diag_ErrorCode()
{}

tU32 midw_fi_tcl_Tun_Diag_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_Tun_Diag_ErrorCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_Diag_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BandChangeStatus::midw_fi_tcl_e8_BandChangeStatus():enType(FI_EN_TUN_BAND_CHANGE_INVALID_STATION_INFO) {}

tS32 midw_fi_tcl_e8_BandChangeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BANDCHANGESTATUS;
}


midw_fi_tcl_e8_BandChangeStatus::~midw_fi_tcl_e8_BandChangeStatus()
{}

tU32 midw_fi_tcl_e8_BandChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BandChangeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BandChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Source::midw_fi_tcl_e8_Tun_Source():enType(FI_EN_TUN_FM) {}

tS32 midw_fi_tcl_e8_Tun_Source::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SOURCE;
}


midw_fi_tcl_e8_Tun_Source::~midw_fi_tcl_e8_Tun_Source()
{}

tU32 midw_fi_tcl_e8_Tun_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_HDAudioProgram::midw_fi_tcl_e8_Tun_HDAudioProgram():enType(FI_EN_TUN_AUDIO_PROGRAM_ONE) {}

tS32 midw_fi_tcl_e8_Tun_HDAudioProgram::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_HDAUDIOPROGRAM;
}


midw_fi_tcl_e8_Tun_HDAudioProgram::~midw_fi_tcl_e8_Tun_HDAudioProgram()
{}

tU32 midw_fi_tcl_e8_Tun_HDAudioProgram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_HDAudioProgram::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_HDAudioProgram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Autocompare_Mode::midw_fi_tcl_e8_Tun_Autocompare_Mode():enType(FI_EN_TUN_AUTOCOMPARE_MODE_PREFER_USERSELECTION) {}

tS32 midw_fi_tcl_e8_Tun_Autocompare_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_AUTOCOMPARE_MODE;
}


midw_fi_tcl_e8_Tun_Autocompare_Mode::~midw_fi_tcl_e8_Tun_Autocompare_Mode()
{}

tU32 midw_fi_tcl_e8_Tun_Autocompare_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Autocompare_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Autocompare_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_AutoCompParam::midw_fi_tcl_Tun_AutoCompParam(const midw_fi_tcl_Tun_AutoCompParam& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8FirstElemId = coRef.u8FirstElemId;
   u8LastElemID = coRef.u8LastElemID;
   u8Mode = coRef.u8Mode;
}
midw_fi_tcl_Tun_AutoCompParam& midw_fi_tcl_Tun_AutoCompParam::operator=(const midw_fi_tcl_Tun_AutoCompParam& coRef)
{
   if (this == &coRef) return *this;
   u8FirstElemId = coRef.u8FirstElemId;
   u8LastElemID = coRef.u8LastElemID;
   u8Mode = coRef.u8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_AutoCompParam::midw_fi_tcl_Tun_AutoCompParam()
:u8FirstElemId(0)
,u8LastElemID(0)
,u8Mode()
 {}

tS32 midw_fi_tcl_Tun_AutoCompParam::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_AUTOCOMPPARAM;
}


midw_fi_tcl_Tun_AutoCompParam::~midw_fi_tcl_Tun_AutoCompParam()
{}

tU32 midw_fi_tcl_Tun_AutoCompParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_Tun_AutoCompParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FirstElemId);
   (tVoid) (oIn >> u8LastElemID);
   (tVoid) (oIn >> u8Mode);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_AutoCompParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FirstElemId);
   (tVoid) (oOut << u8LastElemID);
   (tVoid) (oOut << u8Mode);
   return oOut;
}

tBool midw_fi_tcl_Tun_AutoCompParam::operator==(const midw_fi_tcl_Tun_AutoCompParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FirstElemId == roRef.u8FirstElemId);
   bResult = bResult && (u8LastElemID == roRef.u8LastElemID);
   bResult = bResult && (u8Mode == roRef.u8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Component_Status::midw_fi_tcl_Component_Status(const midw_fi_tcl_Component_Status& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8AudioSinkTUN1 = coRef.u8AudioSinkTUN1;
   u8BGModeTuner = coRef.u8BGModeTuner;
}
midw_fi_tcl_Component_Status& midw_fi_tcl_Component_Status::operator=(const midw_fi_tcl_Component_Status& coRef)
{
   if (this == &coRef) return *this;
   u8AudioSinkTUN1 = coRef.u8AudioSinkTUN1;
   u8BGModeTuner = coRef.u8BGModeTuner;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Component_Status::midw_fi_tcl_Component_Status()
:u8AudioSinkTUN1(0)
,u8BGModeTuner(0)
 {}

tS32 midw_fi_tcl_Component_Status::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_COMPONENT_STATUS;
}


midw_fi_tcl_Component_Status::~midw_fi_tcl_Component_Status()
{}

tU32 midw_fi_tcl_Component_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_Component_Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AudioSinkTUN1);
   (tVoid) (oIn >> u8BGModeTuner);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Component_Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AudioSinkTUN1);
   (tVoid) (oOut << u8BGModeTuner);
   return oOut;
}

tBool midw_fi_tcl_Component_Status::operator==(const midw_fi_tcl_Component_Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AudioSinkTUN1 == roRef.u8AudioSinkTUN1);
   bResult = bResult && (u8BGModeTuner == roRef.u8BGModeTuner);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AtStationTPinfo::midw_fi_tcl_e8_AtStationTPinfo():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_AtStationTPinfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ATSTATIONTPINFO;
}


midw_fi_tcl_e8_AtStationTPinfo::~midw_fi_tcl_e8_AtStationTPinfo()
{}

tU32 midw_fi_tcl_e8_AtStationTPinfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AtStationTPinfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AtStationTPinfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_HDInfoBits::midw_fi_tcl_b8_Tun_HDInfoBits():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_HDInfoBits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_HDINFOBITS;
}


midw_fi_tcl_b8_Tun_HDInfoBits::~midw_fi_tcl_b8_Tun_HDInfoBits()
{}

tU32 midw_fi_tcl_b8_Tun_HDInfoBits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_HDInfoBits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_HDInfoBits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_DiversityState::midw_fi_tcl_e8_Tun_DiversityState():enType(FI_EN_NO_DIVERSITY_FEATURE) {}

tS32 midw_fi_tcl_e8_Tun_DiversityState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_DIVERSITYSTATE;
}


midw_fi_tcl_e8_Tun_DiversityState::~midw_fi_tcl_e8_Tun_DiversityState()
{}

tU32 midw_fi_tcl_e8_Tun_DiversityState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_DiversityState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_DiversityState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AntennaPathSwitch1::midw_fi_tcl_e8_Tun_AntennaPathSwitch1():enType(FI_EN_DDS_OFF) {}

tS32 midw_fi_tcl_e8_Tun_AntennaPathSwitch1::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ANTENNAPATHSWITCH1;
}


midw_fi_tcl_e8_Tun_AntennaPathSwitch1::~midw_fi_tcl_e8_Tun_AntennaPathSwitch1()
{}

tU32 midw_fi_tcl_e8_Tun_AntennaPathSwitch1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AntennaPathSwitch1::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AntennaPathSwitch1::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AntennaPathSwitch2::midw_fi_tcl_e8_Tun_AntennaPathSwitch2():enType(FI_EN_NO_ANTENNA_SELECTED) {}

tS32 midw_fi_tcl_e8_Tun_AntennaPathSwitch2::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ANTENNAPATHSWITCH2;
}


midw_fi_tcl_e8_Tun_AntennaPathSwitch2::~midw_fi_tcl_e8_Tun_AntennaPathSwitch2()
{}

tU32 midw_fi_tcl_e8_Tun_AntennaPathSwitch2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AntennaPathSwitch2::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AntennaPathSwitch2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerTestModeData_DDADDS::midw_fi_tcl_TunerTestModeData_DDADDS(const midw_fi_tcl_TunerTestModeData_DDADDS& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8PhysicalTuner = coRef.u8PhysicalTuner;
   u8Source = coRef.u8Source;
   u32AFFrequency = coRef.u32AFFrequency;
   u16CurrentPI = coRef.u16CurrentPI;
   u16TargetPI = coRef.u16TargetPI;
   u8Quality = coRef.u8Quality;
   u8Fieldstrength = coRef.u8Fieldstrength;
   u8Multipath = coRef.u8Multipath;
   u8Neighbour = coRef.u8Neighbour;
   u8AFListLength = coRef.u8AFListLength;
   u8HiCut = coRef.u8HiCut;
   u8Sharx = coRef.u8Sharx;
   sCurrentStationName = coRef.sCurrentStationName;
   sFixPSName = coRef.sFixPSName;
   bScrollPSStatus = coRef.bScrollPSStatus;
   bAFStatus = coRef.bAFStatus;
   u8FMDeviation = coRef.u8FMDeviation;
   u8RDSDeviation = coRef.u8RDSDeviation;
   s8IFOffset = coRef.s8IFOffset;
   s8RDSOffset = coRef.s8RDSOffset;
   u8CoChannelStatus = coRef.u8CoChannelStatus;
   u8AGC = coRef.u8AGC;
   u8ChannelSeparation = coRef.u8ChannelSeparation;
   u8RdsErrorRate = coRef.u8RdsErrorRate;
   e8DiversityState = coRef.e8DiversityState;
   e8AntennaPathSwitch1 = coRef.e8AntennaPathSwitch1;
   e8AntennaPathSwitch2 = coRef.e8AntennaPathSwitch2;
   u8TestmodeBits = coRef.u8TestmodeBits;
   u8HicutExtender = coRef.u8HicutExtender;
}
midw_fi_tcl_TunerTestModeData_DDADDS& midw_fi_tcl_TunerTestModeData_DDADDS::operator=(const midw_fi_tcl_TunerTestModeData_DDADDS& coRef)
{
   if (this == &coRef) return *this;
   u8PhysicalTuner = coRef.u8PhysicalTuner;
   u8Source = coRef.u8Source;
   u32AFFrequency = coRef.u32AFFrequency;
   u16CurrentPI = coRef.u16CurrentPI;
   u16TargetPI = coRef.u16TargetPI;
   u8Quality = coRef.u8Quality;
   u8Fieldstrength = coRef.u8Fieldstrength;
   u8Multipath = coRef.u8Multipath;
   u8Neighbour = coRef.u8Neighbour;
   u8AFListLength = coRef.u8AFListLength;
   u8HiCut = coRef.u8HiCut;
   u8Sharx = coRef.u8Sharx;
   sCurrentStationName = coRef.sCurrentStationName;
   sFixPSName = coRef.sFixPSName;
   bScrollPSStatus = coRef.bScrollPSStatus;
   bAFStatus = coRef.bAFStatus;
   u8FMDeviation = coRef.u8FMDeviation;
   u8RDSDeviation = coRef.u8RDSDeviation;
   s8IFOffset = coRef.s8IFOffset;
   s8RDSOffset = coRef.s8RDSOffset;
   u8CoChannelStatus = coRef.u8CoChannelStatus;
   u8AGC = coRef.u8AGC;
   u8ChannelSeparation = coRef.u8ChannelSeparation;
   u8RdsErrorRate = coRef.u8RdsErrorRate;
   e8DiversityState = coRef.e8DiversityState;
   e8AntennaPathSwitch1 = coRef.e8AntennaPathSwitch1;
   e8AntennaPathSwitch2 = coRef.e8AntennaPathSwitch2;
   u8TestmodeBits = coRef.u8TestmodeBits;
   u8HicutExtender = coRef.u8HicutExtender;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerTestModeData_DDADDS::vDestroy()
{
   sCurrentStationName.vDestroy();
   sFixPSName.vDestroy();
}

midw_fi_tcl_TunerTestModeData_DDADDS::midw_fi_tcl_TunerTestModeData_DDADDS()
:u8PhysicalTuner()
,u8Source()
,u32AFFrequency(0)
,u16CurrentPI(0)
,u16TargetPI(0)
,u8Quality(0)
,u8Fieldstrength(0)
,u8Multipath(0)
,u8Neighbour(0)
,u8AFListLength(0)
,u8HiCut(0)
,u8Sharx(0)
,sCurrentStationName()
,sFixPSName()
,bScrollPSStatus(0)
,bAFStatus(0)
,u8FMDeviation(0)
,u8RDSDeviation(0)
,s8IFOffset(0)
,s8RDSOffset(0)
,u8CoChannelStatus(0)
,u8AGC(0)
,u8ChannelSeparation(0)
,u8RdsErrorRate(0)
,e8DiversityState()
,e8AntennaPathSwitch1()
,e8AntennaPathSwitch2()
,u8TestmodeBits()
,u8HicutExtender(0)
 {}

tS32 midw_fi_tcl_TunerTestModeData_DDADDS::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERTESTMODEDATA_DDADDS;
}


midw_fi_tcl_TunerTestModeData_DDADDS::~midw_fi_tcl_TunerTestModeData_DDADDS()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerTestModeData_DDADDS::u32GetSize(tU16 u16MajorVersion) const
{
   return 32+sCurrentStationName.u32GetSize(u16MajorVersion)+sFixPSName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerTestModeData_DDADDS::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8PhysicalTuner);
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u32AFFrequency);
   (tVoid) (oIn >> u16CurrentPI);
   (tVoid) (oIn >> u16TargetPI);
   (tVoid) (oIn >> u8Quality);
   (tVoid) (oIn >> u8Fieldstrength);
   (tVoid) (oIn >> u8Multipath);
   (tVoid) (oIn >> u8Neighbour);
   (tVoid) (oIn >> u8AFListLength);
   (tVoid) (oIn >> u8HiCut);
   (tVoid) (oIn >> u8Sharx);
   (tVoid) (oIn >> sCurrentStationName);
   (tVoid) (oIn >> sFixPSName);
   (tVoid) (oIn >> bScrollPSStatus);
   (tVoid) (oIn >> bAFStatus);
   (tVoid) (oIn >> u8FMDeviation);
   (tVoid) (oIn >> u8RDSDeviation);
   (tVoid) (oIn >> s8IFOffset);
   (tVoid) (oIn >> s8RDSOffset);
   (tVoid) (oIn >> u8CoChannelStatus);
   (tVoid) (oIn >> u8AGC);
   (tVoid) (oIn >> u8ChannelSeparation);
   (tVoid) (oIn >> u8RdsErrorRate);
   (tVoid) (oIn >> e8DiversityState);
   (tVoid) (oIn >> e8AntennaPathSwitch1);
   (tVoid) (oIn >> e8AntennaPathSwitch2);
   (tVoid) (oIn >> u8TestmodeBits);
   (tVoid) (oIn >> u8HicutExtender);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerTestModeData_DDADDS::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8PhysicalTuner);
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u32AFFrequency);
   (tVoid) (oOut << u16CurrentPI);
   (tVoid) (oOut << u16TargetPI);
   (tVoid) (oOut << u8Quality);
   (tVoid) (oOut << u8Fieldstrength);
   (tVoid) (oOut << u8Multipath);
   (tVoid) (oOut << u8Neighbour);
   (tVoid) (oOut << u8AFListLength);
   (tVoid) (oOut << u8HiCut);
   (tVoid) (oOut << u8Sharx);
   (tVoid) (oOut << sCurrentStationName);
   (tVoid) (oOut << sFixPSName);
   (tVoid) (oOut << bScrollPSStatus);
   (tVoid) (oOut << bAFStatus);
   (tVoid) (oOut << u8FMDeviation);
   (tVoid) (oOut << u8RDSDeviation);
   (tVoid) (oOut << s8IFOffset);
   (tVoid) (oOut << s8RDSOffset);
   (tVoid) (oOut << u8CoChannelStatus);
   (tVoid) (oOut << u8AGC);
   (tVoid) (oOut << u8ChannelSeparation);
   (tVoid) (oOut << u8RdsErrorRate);
   (tVoid) (oOut << e8DiversityState);
   (tVoid) (oOut << e8AntennaPathSwitch1);
   (tVoid) (oOut << e8AntennaPathSwitch2);
   (tVoid) (oOut << u8TestmodeBits);
   (tVoid) (oOut << u8HicutExtender);
   return oOut;
}

tBool midw_fi_tcl_TunerTestModeData_DDADDS::operator==(const midw_fi_tcl_TunerTestModeData_DDADDS& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8PhysicalTuner == roRef.u8PhysicalTuner);
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u32AFFrequency == roRef.u32AFFrequency);
   bResult = bResult && (u16CurrentPI == roRef.u16CurrentPI);
   bResult = bResult && (u16TargetPI == roRef.u16TargetPI);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   bResult = bResult && (u8Fieldstrength == roRef.u8Fieldstrength);
   bResult = bResult && (u8Multipath == roRef.u8Multipath);
   bResult = bResult && (u8Neighbour == roRef.u8Neighbour);
   bResult = bResult && (u8AFListLength == roRef.u8AFListLength);
   bResult = bResult && (u8HiCut == roRef.u8HiCut);
   bResult = bResult && (u8Sharx == roRef.u8Sharx);
   bResult = bResult && (sCurrentStationName == roRef.sCurrentStationName);
   bResult = bResult && (sFixPSName == roRef.sFixPSName);
   bResult = bResult && (bScrollPSStatus == roRef.bScrollPSStatus);
   bResult = bResult && (bAFStatus == roRef.bAFStatus);
   bResult = bResult && (u8FMDeviation == roRef.u8FMDeviation);
   bResult = bResult && (u8RDSDeviation == roRef.u8RDSDeviation);
   bResult = bResult && (s8IFOffset == roRef.s8IFOffset);
   bResult = bResult && (s8RDSOffset == roRef.s8RDSOffset);
   bResult = bResult && (u8CoChannelStatus == roRef.u8CoChannelStatus);
   bResult = bResult && (u8AGC == roRef.u8AGC);
   bResult = bResult && (u8ChannelSeparation == roRef.u8ChannelSeparation);
   bResult = bResult && (u8RdsErrorRate == roRef.u8RdsErrorRate);
   bResult = bResult && (e8DiversityState == roRef.e8DiversityState);
   bResult = bResult && (e8AntennaPathSwitch1 == roRef.e8AntennaPathSwitch1);
   bResult = bResult && (e8AntennaPathSwitch2 == roRef.e8AntennaPathSwitch2);
   bResult = bResult && (u8TestmodeBits == roRef.u8TestmodeBits);
   bResult = bResult && (u8HicutExtender == roRef.u8HicutExtender);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Engg_Param_ID::midw_fi_tcl_e8_Tun_Engg_Param_ID():enType(FI_EN_FM_6_DB_STEREO_CHANNEL_SEPARATION) {}

tS32 midw_fi_tcl_e8_Tun_Engg_Param_ID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ENGG_PARAM_ID;
}


midw_fi_tcl_e8_Tun_Engg_Param_ID::~midw_fi_tcl_e8_Tun_Engg_Param_ID()
{}

tU32 midw_fi_tcl_e8_Tun_Engg_Param_ID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Engg_Param_ID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Engg_Param_ID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ConfigParam_Type::midw_fi_tcl_e8_Tun_ConfigParam_Type():enType(FI_EN_ALLPARAMETERS) {}

tS32 midw_fi_tcl_e8_Tun_ConfigParam_Type::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_CONFIGPARAM_TYPE;
}


midw_fi_tcl_e8_Tun_ConfigParam_Type::~midw_fi_tcl_e8_Tun_ConfigParam_Type()
{}

tU32 midw_fi_tcl_e8_Tun_ConfigParam_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ConfigParam_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ConfigParam_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TuningActionConfigParam::midw_fi_tcl_TuningActionConfigParam(const midw_fi_tcl_TuningActionConfigParam& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ConfigParamType = coRef.e8ConfigParamType;
   u32ConfigParamValue = coRef.u32ConfigParamValue;
}
midw_fi_tcl_TuningActionConfigParam& midw_fi_tcl_TuningActionConfigParam::operator=(const midw_fi_tcl_TuningActionConfigParam& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigParamType = coRef.e8ConfigParamType;
   u32ConfigParamValue = coRef.u32ConfigParamValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TuningActionConfigParam::midw_fi_tcl_TuningActionConfigParam()
:e8ConfigParamType()
,u32ConfigParamValue(0)
 {}

tS32 midw_fi_tcl_TuningActionConfigParam::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNINGACTIONCONFIGPARAM;
}


midw_fi_tcl_TuningActionConfigParam::~midw_fi_tcl_TuningActionConfigParam()
{}

tU32 midw_fi_tcl_TuningActionConfigParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TuningActionConfigParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigParamType);
   (tVoid) (oIn >> u32ConfigParamValue);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TuningActionConfigParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigParamType);
   (tVoid) (oOut << u32ConfigParamValue);
   return oOut;
}

tBool midw_fi_tcl_TuningActionConfigParam::operator==(const midw_fi_tcl_TuningActionConfigParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigParamType == roRef.e8ConfigParamType);
   bResult = bResult && (u32ConfigParamValue == roRef.u32ConfigParamValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::midw_fi_tcl_e8_Tun_TestTuneFrequencyMode():enType(FI_EN_AF_JUMP_ON) {}

tS32 midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TESTTUNEFREQUENCYMODE;
}


midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::~midw_fi_tcl_e8_Tun_TestTuneFrequencyMode()
{}

tU32 midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_AnnoTypes::midw_fi_tcl_b8_AnnoTypes():u8Value(0)
{}

tS32 midw_fi_tcl_b8_AnnoTypes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_ANNOTYPES;
}


midw_fi_tcl_b8_AnnoTypes::~midw_fi_tcl_b8_AnnoTypes()
{}

tU32 midw_fi_tcl_b8_AnnoTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_AnnoTypes::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_AnnoTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Anno_Message::midw_fi_tcl_b8_Anno_Message():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Anno_Message::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_ANNO_MESSAGE;
}


midw_fi_tcl_b8_Anno_Message::~midw_fi_tcl_b8_Anno_Message()
{}

tU32 midw_fi_tcl_b8_Anno_Message::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Anno_Message::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Anno_Message::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AnnoInfostatus::midw_fi_tcl_AnnoInfostatus(const midw_fi_tcl_AnnoInfostatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   sAnnoStationName = coRef.sAnnoStationName;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   u8Quality = coRef.u8Quality;
}
midw_fi_tcl_AnnoInfostatus& midw_fi_tcl_AnnoInfostatus::operator=(const midw_fi_tcl_AnnoInfostatus& coRef)
{
   if (this == &coRef) return *this;
   sAnnoStationName = coRef.sAnnoStationName;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   u8Quality = coRef.u8Quality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AnnoInfostatus::vDestroy()
{
   sAnnoStationName.vDestroy();
}

midw_fi_tcl_AnnoInfostatus::midw_fi_tcl_AnnoInfostatus()
:sAnnoStationName()
,u32Frequency(0)
,u16PI(0)
,u8Quality(0)
 {}

tS32 midw_fi_tcl_AnnoInfostatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ANNOINFOSTATUS;
}


midw_fi_tcl_AnnoInfostatus::~midw_fi_tcl_AnnoInfostatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AnnoInfostatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+sAnnoStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AnnoInfostatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAnnoStationName);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> u8Quality);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AnnoInfostatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAnnoStationName);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << u8Quality);
   return oOut;
}

tBool midw_fi_tcl_AnnoInfostatus::operator==(const midw_fi_tcl_AnnoInfostatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAnnoStationName == roRef.sAnnoStationName);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PS_Freeze_Mode::midw_fi_tcl_e8_PS_Freeze_Mode():enType(FI_EN_FREEZE) {}

tS32 midw_fi_tcl_e8_PS_Freeze_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PS_FREEZE_MODE;
}


midw_fi_tcl_e8_PS_Freeze_Mode::~midw_fi_tcl_e8_PS_Freeze_Mode()
{}

tU32 midw_fi_tcl_e8_PS_Freeze_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PS_Freeze_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PS_Freeze_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AnnoTypes::midw_fi_tcl_e8_Tun_AnnoTypes():enType(FI_EN_TP) {}

tS32 midw_fi_tcl_e8_Tun_AnnoTypes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ANNOTYPES;
}


midw_fi_tcl_e8_Tun_AnnoTypes::~midw_fi_tcl_e8_Tun_AnnoTypes()
{}

tU32 midw_fi_tcl_e8_Tun_AnnoTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AnnoTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AnnoTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Anno_Message::midw_fi_tcl_e8_Anno_Message():enType(FI_EN_TA_PTY_OFF) {}

tS32 midw_fi_tcl_e8_Anno_Message::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ANNO_MESSAGE;
}


midw_fi_tcl_e8_Anno_Message::~midw_fi_tcl_e8_Anno_Message()
{}

tU32 midw_fi_tcl_e8_Anno_Message::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Anno_Message::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Anno_Message::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_Engg_Param_List_Elem::midw_fi_tcl_Tun_Engg_Param_List_Elem(const midw_fi_tcl_Tun_Engg_Param_List_Elem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
}
midw_fi_tcl_Tun_Engg_Param_List_Elem& midw_fi_tcl_Tun_Engg_Param_List_Elem::operator=(const midw_fi_tcl_Tun_Engg_Param_List_Elem& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_Engg_Param_List_Elem::midw_fi_tcl_Tun_Engg_Param_List_Elem()
:e8ParameterID()
,u32ParameterValue(0)
 {}

tS32 midw_fi_tcl_Tun_Engg_Param_List_Elem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_ENGG_PARAM_LIST_ELEM;
}


midw_fi_tcl_Tun_Engg_Param_List_Elem::~midw_fi_tcl_Tun_Engg_Param_List_Elem()
{}

tU32 midw_fi_tcl_Tun_Engg_Param_List_Elem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_Tun_Engg_Param_List_Elem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterID);
   (tVoid) (oIn >> u32ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_Engg_Param_List_Elem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterID);
   (tVoid) (oOut << u32ParameterValue);
   return oOut;
}

tBool midw_fi_tcl_Tun_Engg_Param_List_Elem::operator==(const midw_fi_tcl_Tun_Engg_Param_List_Elem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterID == roRef.e8ParameterID);
   bResult = bResult && (u32ParameterValue == roRef.u32ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_DefaultSettingOption::midw_fi_tcl_e8_Tun_DefaultSettingOption():enType(FI_EN_INVALID_TYPE) {}

tS32 midw_fi_tcl_e8_Tun_DefaultSettingOption::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_DEFAULTSETTINGOPTION;
}


midw_fi_tcl_e8_Tun_DefaultSettingOption::~midw_fi_tcl_e8_Tun_DefaultSettingOption()
{}

tU32 midw_fi_tcl_e8_Tun_DefaultSettingOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_DefaultSettingOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_DefaultSettingOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AvailableBandInfoElement::midw_fi_tcl_AvailableBandInfoElement(const midw_fi_tcl_AvailableBandInfoElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8Band = coRef.e8Band;
   u32HighFrequency = coRef.u32HighFrequency;
   u32LowFrequency = coRef.u32LowFrequency;
   u16AutoSeekStepWidth = coRef.u16AutoSeekStepWidth;
   u16ManualStepWidth = coRef.u16ManualStepWidth;
}
midw_fi_tcl_AvailableBandInfoElement& midw_fi_tcl_AvailableBandInfoElement::operator=(const midw_fi_tcl_AvailableBandInfoElement& coRef)
{
   if (this == &coRef) return *this;
   e8Band = coRef.e8Band;
   u32HighFrequency = coRef.u32HighFrequency;
   u32LowFrequency = coRef.u32LowFrequency;
   u16AutoSeekStepWidth = coRef.u16AutoSeekStepWidth;
   u16ManualStepWidth = coRef.u16ManualStepWidth;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AvailableBandInfoElement::midw_fi_tcl_AvailableBandInfoElement()
:e8Band()
,u32HighFrequency(0)
,u32LowFrequency(0)
,u16AutoSeekStepWidth(0)
,u16ManualStepWidth(0)
 {}

tS32 midw_fi_tcl_AvailableBandInfoElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AVAILABLEBANDINFOELEMENT;
}


midw_fi_tcl_AvailableBandInfoElement::~midw_fi_tcl_AvailableBandInfoElement()
{}

tU32 midw_fi_tcl_AvailableBandInfoElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_fi_tcl_AvailableBandInfoElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Band);
   (tVoid) (oIn >> u32HighFrequency);
   (tVoid) (oIn >> u32LowFrequency);
   (tVoid) (oIn >> u16AutoSeekStepWidth);
   (tVoid) (oIn >> u16ManualStepWidth);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AvailableBandInfoElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Band);
   (tVoid) (oOut << u32HighFrequency);
   (tVoid) (oOut << u32LowFrequency);
   (tVoid) (oOut << u16AutoSeekStepWidth);
   (tVoid) (oOut << u16ManualStepWidth);
   return oOut;
}

tBool midw_fi_tcl_AvailableBandInfoElement::operator==(const midw_fi_tcl_AvailableBandInfoElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Band == roRef.e8Band);
   bResult = bResult && (u32HighFrequency == roRef.u32HighFrequency);
   bResult = bResult && (u32LowFrequency == roRef.u32LowFrequency);
   bResult = bResult && (u16AutoSeekStepWidth == roRef.u16AutoSeekStepWidth);
   bResult = bResult && (u16ManualStepWidth == roRef.u16ManualStepWidth);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AvailableBandInfoList::midw_fi_tcl_AvailableBandInfoList(const midw_fi_tcl_AvailableBandInfoList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AvailableBandInfoElement = coRef.AvailableBandInfoElement;
}
midw_fi_tcl_AvailableBandInfoList& midw_fi_tcl_AvailableBandInfoList::operator=(const midw_fi_tcl_AvailableBandInfoList& coRef)
{
   if (this == &coRef) return *this;
   AvailableBandInfoElement = coRef.AvailableBandInfoElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AvailableBandInfoList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableBandInfoElement.size(); ++u32Idx)
         AvailableBandInfoElement[u32Idx].vDestroy();
   AvailableBandInfoElement.clear();
   }
}

midw_fi_tcl_AvailableBandInfoList::midw_fi_tcl_AvailableBandInfoList()

 {}

tS32 midw_fi_tcl_AvailableBandInfoList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AVAILABLEBANDINFOLIST;
}


midw_fi_tcl_AvailableBandInfoList::~midw_fi_tcl_AvailableBandInfoList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AvailableBandInfoList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(AvailableBandInfoElement.size()*13);
}

fi_tclInContext& midw_fi_tcl_AvailableBandInfoList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableBandInfoElement.size(); ++u32Idx)
      {
         AvailableBandInfoElement[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableBandInfoElement.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableBandInfoElement[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AvailableBandInfoList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableBandInfoElement.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableBandInfoElement.size(); ++u32Idx)
         (tVoid) (oOut << AvailableBandInfoElement[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_AvailableBandInfoList::operator==(const midw_fi_tcl_AvailableBandInfoList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableBandInfoElement.size() == roRef.AvailableBandInfoElement.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableBandInfoElement.size()); ++u32Idx)
            bResult = bResult && (AvailableBandInfoElement[u32Idx] == roRef.AvailableBandInfoElement[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_DemodSwitch::midw_fi_tcl_b8_Tun_DemodSwitch():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_DemodSwitch::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_DEMODSWITCH;
}


midw_fi_tcl_b8_Tun_DemodSwitch::~midw_fi_tcl_b8_Tun_DemodSwitch()
{}

tU32 midw_fi_tcl_b8_Tun_DemodSwitch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_DemodSwitch::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_DemodSwitch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_SelectMode::midw_fi_tcl_e8_Tun_SelectMode():enType(FI_EN_TUN_SELECTMODE_ABSOLUTE) {}

tS32 midw_fi_tcl_e8_Tun_SelectMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_SELECTMODE;
}


midw_fi_tcl_e8_Tun_SelectMode::~midw_fi_tcl_e8_Tun_SelectMode()
{}

tU32 midw_fi_tcl_e8_Tun_SelectMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_SelectMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_SelectMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerBandAndStationInfo::midw_fi_tcl_TunerBandAndStationInfo(const midw_fi_tcl_TunerBandAndStationInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8Band = coRef.e8Band;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
   u16StaticListElementID = coRef.u16StaticListElementID;
   sHDCallSign = coRef.sHDCallSign;
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u8PresetAutocompare = coRef.u8PresetAutocompare;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u32DRMServiceId = coRef.u32DRMServiceId;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
}
midw_fi_tcl_TunerBandAndStationInfo& midw_fi_tcl_TunerBandAndStationInfo::operator=(const midw_fi_tcl_TunerBandAndStationInfo& coRef)
{
   if (this == &coRef) return *this;
   e8Band = coRef.e8Band;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
   u16StaticListElementID = coRef.u16StaticListElementID;
   sHDCallSign = coRef.sHDCallSign;
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u8PresetAutocompare = coRef.u8PresetAutocompare;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u32DRMServiceId = coRef.u32DRMServiceId;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerBandAndStationInfo::vDestroy()
{
   sPSName.vDestroy();
   sHDCallSign.vDestroy();
   sDRMServiceLabel.vDestroy();
}

midw_fi_tcl_TunerBandAndStationInfo::midw_fi_tcl_TunerBandAndStationInfo()
:e8Band()
,u32Frequency(0)
,u16PI(0)
,sPSName()
,u16StaticListElementID(0)
,sHDCallSign()
,u32HDStationId(0)
,e8HDAudioProgram()
,u8PresetAutocompare(0)
,sDRMServiceLabel()
,u32DRMServiceId(0)
,u8DRMServiceShortId(0)
 {}

tS32 midw_fi_tcl_TunerBandAndStationInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERBANDANDSTATIONINFO;
}


midw_fi_tcl_TunerBandAndStationInfo::~midw_fi_tcl_TunerBandAndStationInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerBandAndStationInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 20+sPSName.u32GetSize(u16MajorVersion)+sHDCallSign.u32GetSize(u16MajorVersion)+sDRMServiceLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerBandAndStationInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Band);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> sPSName);
   (tVoid) (oIn >> u16StaticListElementID);
   (tVoid) (oIn >> sHDCallSign);
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> e8HDAudioProgram);
   (tVoid) (oIn >> u8PresetAutocompare);
   (tVoid) (oIn >> sDRMServiceLabel);
   (tVoid) (oIn >> u32DRMServiceId);
   (tVoid) (oIn >> u8DRMServiceShortId);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerBandAndStationInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Band);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << sPSName);
   (tVoid) (oOut << u16StaticListElementID);
   (tVoid) (oOut << sHDCallSign);
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << e8HDAudioProgram);
   (tVoid) (oOut << u8PresetAutocompare);
   (tVoid) (oOut << sDRMServiceLabel);
   (tVoid) (oOut << u32DRMServiceId);
   (tVoid) (oOut << u8DRMServiceShortId);
   return oOut;
}

tBool midw_fi_tcl_TunerBandAndStationInfo::operator==(const midw_fi_tcl_TunerBandAndStationInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Band == roRef.e8Band);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (sPSName == roRef.sPSName);
   bResult = bResult && (u16StaticListElementID == roRef.u16StaticListElementID);
   bResult = bResult && (sHDCallSign == roRef.sHDCallSign);
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   bResult = bResult && (u8PresetAutocompare == roRef.u8PresetAutocompare);
   bResult = bResult && (sDRMServiceLabel == roRef.sDRMServiceLabel);
   bResult = bResult && (u32DRMServiceId == roRef.u32DRMServiceId);
   bResult = bResult && (u8DRMServiceShortId == roRef.u8DRMServiceShortId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_RelativeDirection::midw_fi_tcl_e8_Tun_RelativeDirection():enType(FI_EN_TUN_RELATIVE_DECREMENT) {}

tS32 midw_fi_tcl_e8_Tun_RelativeDirection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_RELATIVEDIRECTION;
}


midw_fi_tcl_e8_Tun_RelativeDirection::~midw_fi_tcl_e8_Tun_RelativeDirection()
{}

tU32 midw_fi_tcl_e8_Tun_RelativeDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_RelativeDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_RelativeDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_HDPrgmAvail::midw_fi_tcl_b8_Tun_HDPrgmAvail():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_HDPrgmAvail::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_HDPRGMAVAIL;
}


midw_fi_tcl_b8_Tun_HDPrgmAvail::~midw_fi_tcl_b8_Tun_HDPrgmAvail()
{}

tU32 midw_fi_tcl_b8_Tun_HDPrgmAvail::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_HDPrgmAvail::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_HDPrgmAvail::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_DRMStationInfoBits::midw_fi_tcl_b8_Tun_DRMStationInfoBits():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_DRMStationInfoBits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_DRMSTATIONINFOBITS;
}


midw_fi_tcl_b8_Tun_DRMStationInfoBits::~midw_fi_tcl_b8_Tun_DRMStationInfoBits()
{}

tU32 midw_fi_tcl_b8_Tun_DRMStationInfoBits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_DRMStationInfoBits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_DRMStationInfoBits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b16_Tun_DRMAnnouBits::midw_fi_tcl_b16_Tun_DRMAnnouBits():u16Value(0)
{}

tS32 midw_fi_tcl_b16_Tun_DRMAnnouBits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B16_TUN_DRMANNOUBITS;
}


midw_fi_tcl_b16_Tun_DRMAnnouBits::~midw_fi_tcl_b16_Tun_DRMAnnouBits()
{}

tU32 midw_fi_tcl_b16_Tun_DRMAnnouBits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_b16_Tun_DRMAnnouBits::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& midw_fi_tcl_b16_Tun_DRMAnnouBits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_DRMNUMBEROFAUDIOSERVICES;
}


midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::~midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices()
{}

tU32 midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Atstationinfo::midw_fi_tcl_Atstationinfo(const midw_fi_tcl_Atstationinfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u32AvailFlags = coRef.u32AvailFlags;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
   e8Band = coRef.e8Band;
   e8AtStationTPinfo = coRef.e8AtStationTPinfo;
   u16PresetListID = coRef.u16PresetListID;
   u8ActiveStationList = coRef.u8ActiveStationList;
   u16StaticListElementID = coRef.u16StaticListElementID;
   u16ConfigListElementID = coRef.u16ConfigListElementID;
   u8AtStationInfoBits = coRef.u8AtStationInfoBits;
   u8PTY = coRef.u8PTY;
   u8FieldStrngth = coRef.u8FieldStrngth;
   u8Quality = coRef.u8Quality;
   b8HDStationInfoBits = coRef.b8HDStationInfoBits;
   u32StationInfoHDStationID = coRef.u32StationInfoHDStationID;
   sHDCallSign = coRef.sHDCallSign;
   e8HDCallSignTextEncoding = coRef.e8HDCallSignTextEncoding;
   u8HDStationGenre = coRef.u8HDStationGenre;
   b8HDAudioPrgmAvail = coRef.b8HDAudioPrgmAvail;
   u8HDQuality = coRef.u8HDQuality;
   e8ActiveHDAudPrgm = coRef.e8ActiveHDAudPrgm;
   StationLogo = coRef.StationLogo;
   b8DRMStationInfoBits = coRef.b8DRMStationInfoBits;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMPTY = coRef.u8DRMPTY;
   b16DRMAnnouBits = coRef.b16DRMAnnouBits;
   b8DRMNumberOfAudioServices = coRef.b8DRMNumberOfAudioServices;
   u8DRMQuality = coRef.u8DRMQuality;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   u8Drmlanguage = coRef.u8Drmlanguage;
   u32DrmlanguageCode = coRef.u32DrmlanguageCode;
   u16DrmCountryCode = coRef.u16DrmCountryCode;
   s8DrmFrequencyCorrection = coRef.s8DrmFrequencyCorrection;
   u8JapanStationCount = coRef.u8JapanStationCount;
   bUserPresetAction = coRef.bUserPresetAction;
}
midw_fi_tcl_Atstationinfo& midw_fi_tcl_Atstationinfo::operator=(const midw_fi_tcl_Atstationinfo& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u32AvailFlags = coRef.u32AvailFlags;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
   e8Band = coRef.e8Band;
   e8AtStationTPinfo = coRef.e8AtStationTPinfo;
   u16PresetListID = coRef.u16PresetListID;
   u8ActiveStationList = coRef.u8ActiveStationList;
   u16StaticListElementID = coRef.u16StaticListElementID;
   u16ConfigListElementID = coRef.u16ConfigListElementID;
   u8AtStationInfoBits = coRef.u8AtStationInfoBits;
   u8PTY = coRef.u8PTY;
   u8FieldStrngth = coRef.u8FieldStrngth;
   u8Quality = coRef.u8Quality;
   b8HDStationInfoBits = coRef.b8HDStationInfoBits;
   u32StationInfoHDStationID = coRef.u32StationInfoHDStationID;
   sHDCallSign = coRef.sHDCallSign;
   e8HDCallSignTextEncoding = coRef.e8HDCallSignTextEncoding;
   u8HDStationGenre = coRef.u8HDStationGenre;
   b8HDAudioPrgmAvail = coRef.b8HDAudioPrgmAvail;
   u8HDQuality = coRef.u8HDQuality;
   e8ActiveHDAudPrgm = coRef.e8ActiveHDAudPrgm;
   StationLogo = coRef.StationLogo;
   b8DRMStationInfoBits = coRef.b8DRMStationInfoBits;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMPTY = coRef.u8DRMPTY;
   b16DRMAnnouBits = coRef.b16DRMAnnouBits;
   b8DRMNumberOfAudioServices = coRef.b8DRMNumberOfAudioServices;
   u8DRMQuality = coRef.u8DRMQuality;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   u8Drmlanguage = coRef.u8Drmlanguage;
   u32DrmlanguageCode = coRef.u32DrmlanguageCode;
   u16DrmCountryCode = coRef.u16DrmCountryCode;
   s8DrmFrequencyCorrection = coRef.s8DrmFrequencyCorrection;
   u8JapanStationCount = coRef.u8JapanStationCount;
   bUserPresetAction = coRef.bUserPresetAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Atstationinfo::vDestroy()
{
   sPSName.vDestroy();
   sHDCallSign.vDestroy();
   StationLogo.vDestroy();
   sDRMServiceLabel.vDestroy();
}

midw_fi_tcl_Atstationinfo::midw_fi_tcl_Atstationinfo()
:u8TunerHeader()
,u32AvailFlags()
,u32Frequency(0)
,u16PI(0)
,sPSName()
,e8Band()
,e8AtStationTPinfo()
,u16PresetListID(0)
,u8ActiveStationList(0)
,u16StaticListElementID(0)
,u16ConfigListElementID(0)
,u8AtStationInfoBits()
,u8PTY(0)
,u8FieldStrngth(0)
,u8Quality(0)
,b8HDStationInfoBits()
,u32StationInfoHDStationID(0)
,sHDCallSign()
,e8HDCallSignTextEncoding()
,u8HDStationGenre(0)
,b8HDAudioPrgmAvail()
,u8HDQuality(0)
,e8ActiveHDAudPrgm()
,StationLogo()
,b8DRMStationInfoBits()
,u32DRMServiceId(0)
,sDRMServiceLabel()
,u8DRMPTY(0)
,b16DRMAnnouBits()
,b8DRMNumberOfAudioServices()
,u8DRMQuality(0)
,u8DRMServiceShortId(0)
,u8Drmlanguage(0)
,u32DrmlanguageCode(0)
,u16DrmCountryCode(0)
,s8DrmFrequencyCorrection(0)
,u8JapanStationCount(0)
,bUserPresetAction(0)
 {}

tS32 midw_fi_tcl_Atstationinfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ATSTATIONINFO;
}


midw_fi_tcl_Atstationinfo::~midw_fi_tcl_Atstationinfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Atstationinfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 55+sPSName.u32GetSize(u16MajorVersion)+sHDCallSign.u32GetSize(u16MajorVersion)+StationLogo.u32GetSize(u16MajorVersion)+sDRMServiceLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_Atstationinfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u32AvailFlags);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> sPSName);
   (tVoid) (oIn >> e8Band);
   (tVoid) (oIn >> e8AtStationTPinfo);
   (tVoid) (oIn >> u16PresetListID);
   (tVoid) (oIn >> u8ActiveStationList);
   (tVoid) (oIn >> u16StaticListElementID);
   (tVoid) (oIn >> u16ConfigListElementID);
   (tVoid) (oIn >> u8AtStationInfoBits);
   (tVoid) (oIn >> u8PTY);
   (tVoid) (oIn >> u8FieldStrngth);
   (tVoid) (oIn >> u8Quality);
   (tVoid) (oIn >> b8HDStationInfoBits);
   (tVoid) (oIn >> u32StationInfoHDStationID);
   (tVoid) (oIn >> sHDCallSign);
   (tVoid) (oIn >> e8HDCallSignTextEncoding);
   (tVoid) (oIn >> u8HDStationGenre);
   (tVoid) (oIn >> b8HDAudioPrgmAvail);
   (tVoid) (oIn >> u8HDQuality);
   (tVoid) (oIn >> e8ActiveHDAudPrgm);
   (tVoid) (oIn >> StationLogo);
   (tVoid) (oIn >> b8DRMStationInfoBits);
   (tVoid) (oIn >> u32DRMServiceId);
   (tVoid) (oIn >> sDRMServiceLabel);
   (tVoid) (oIn >> u8DRMPTY);
   (tVoid) (oIn >> b16DRMAnnouBits);
   (tVoid) (oIn >> b8DRMNumberOfAudioServices);
   (tVoid) (oIn >> u8DRMQuality);
   (tVoid) (oIn >> u8DRMServiceShortId);
   (tVoid) (oIn >> u8Drmlanguage);
   (tVoid) (oIn >> u32DrmlanguageCode);
   (tVoid) (oIn >> u16DrmCountryCode);
   (tVoid) (oIn >> s8DrmFrequencyCorrection);
   (tVoid) (oIn >> u8JapanStationCount);
   (tVoid) (oIn >> bUserPresetAction);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Atstationinfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u32AvailFlags);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << sPSName);
   (tVoid) (oOut << e8Band);
   (tVoid) (oOut << e8AtStationTPinfo);
   (tVoid) (oOut << u16PresetListID);
   (tVoid) (oOut << u8ActiveStationList);
   (tVoid) (oOut << u16StaticListElementID);
   (tVoid) (oOut << u16ConfigListElementID);
   (tVoid) (oOut << u8AtStationInfoBits);
   (tVoid) (oOut << u8PTY);
   (tVoid) (oOut << u8FieldStrngth);
   (tVoid) (oOut << u8Quality);
   (tVoid) (oOut << b8HDStationInfoBits);
   (tVoid) (oOut << u32StationInfoHDStationID);
   (tVoid) (oOut << sHDCallSign);
   (tVoid) (oOut << e8HDCallSignTextEncoding);
   (tVoid) (oOut << u8HDStationGenre);
   (tVoid) (oOut << b8HDAudioPrgmAvail);
   (tVoid) (oOut << u8HDQuality);
   (tVoid) (oOut << e8ActiveHDAudPrgm);
   (tVoid) (oOut << StationLogo);
   (tVoid) (oOut << b8DRMStationInfoBits);
   (tVoid) (oOut << u32DRMServiceId);
   (tVoid) (oOut << sDRMServiceLabel);
   (tVoid) (oOut << u8DRMPTY);
   (tVoid) (oOut << b16DRMAnnouBits);
   (tVoid) (oOut << b8DRMNumberOfAudioServices);
   (tVoid) (oOut << u8DRMQuality);
   (tVoid) (oOut << u8DRMServiceShortId);
   (tVoid) (oOut << u8Drmlanguage);
   (tVoid) (oOut << u32DrmlanguageCode);
   (tVoid) (oOut << u16DrmCountryCode);
   (tVoid) (oOut << s8DrmFrequencyCorrection);
   (tVoid) (oOut << u8JapanStationCount);
   (tVoid) (oOut << bUserPresetAction);
   return oOut;
}

tBool midw_fi_tcl_Atstationinfo::operator==(const midw_fi_tcl_Atstationinfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u32AvailFlags == roRef.u32AvailFlags);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (sPSName == roRef.sPSName);
   bResult = bResult && (e8Band == roRef.e8Band);
   bResult = bResult && (e8AtStationTPinfo == roRef.e8AtStationTPinfo);
   bResult = bResult && (u16PresetListID == roRef.u16PresetListID);
   bResult = bResult && (u8ActiveStationList == roRef.u8ActiveStationList);
   bResult = bResult && (u16StaticListElementID == roRef.u16StaticListElementID);
   bResult = bResult && (u16ConfigListElementID == roRef.u16ConfigListElementID);
   bResult = bResult && (u8AtStationInfoBits == roRef.u8AtStationInfoBits);
   bResult = bResult && (u8PTY == roRef.u8PTY);
   bResult = bResult && (u8FieldStrngth == roRef.u8FieldStrngth);
   bResult = bResult && (u8Quality == roRef.u8Quality);
   bResult = bResult && (b8HDStationInfoBits == roRef.b8HDStationInfoBits);
   bResult = bResult && (u32StationInfoHDStationID == roRef.u32StationInfoHDStationID);
   bResult = bResult && (sHDCallSign == roRef.sHDCallSign);
   bResult = bResult && (e8HDCallSignTextEncoding == roRef.e8HDCallSignTextEncoding);
   bResult = bResult && (u8HDStationGenre == roRef.u8HDStationGenre);
   bResult = bResult && (b8HDAudioPrgmAvail == roRef.b8HDAudioPrgmAvail);
   bResult = bResult && (u8HDQuality == roRef.u8HDQuality);
   bResult = bResult && (e8ActiveHDAudPrgm == roRef.e8ActiveHDAudPrgm);
   bResult = bResult && (StationLogo == roRef.StationLogo);
   bResult = bResult && (b8DRMStationInfoBits == roRef.b8DRMStationInfoBits);
   bResult = bResult && (u32DRMServiceId == roRef.u32DRMServiceId);
   bResult = bResult && (sDRMServiceLabel == roRef.sDRMServiceLabel);
   bResult = bResult && (u8DRMPTY == roRef.u8DRMPTY);
   bResult = bResult && (b16DRMAnnouBits == roRef.b16DRMAnnouBits);
   bResult = bResult && (b8DRMNumberOfAudioServices == roRef.b8DRMNumberOfAudioServices);
   bResult = bResult && (u8DRMQuality == roRef.u8DRMQuality);
   bResult = bResult && (u8DRMServiceShortId == roRef.u8DRMServiceShortId);
   bResult = bResult && (u8Drmlanguage == roRef.u8Drmlanguage);
   bResult = bResult && (u32DrmlanguageCode == roRef.u32DrmlanguageCode);
   bResult = bResult && (u16DrmCountryCode == roRef.u16DrmCountryCode);
   bResult = bResult && (s8DrmFrequencyCorrection == roRef.s8DrmFrequencyCorrection);
   bResult = bResult && (u8JapanStationCount == roRef.u8JapanStationCount);
   bResult = bResult && (bUserPresetAction == roRef.bUserPresetAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_MakeConfigList::midw_fi_tcl_Tun_MakeConfigList(const midw_fi_tcl_Tun_MakeConfigList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   eConfigListID = coRef.eConfigListID;
   u32PTY = coRef.u32PTY;
   eSortingCriteria = coRef.eSortingCriteria;
   u8DigitalFilters = coRef.u8DigitalFilters;
   bFrozenList = coRef.bFrozenList;
}
midw_fi_tcl_Tun_MakeConfigList& midw_fi_tcl_Tun_MakeConfigList::operator=(const midw_fi_tcl_Tun_MakeConfigList& coRef)
{
   if (this == &coRef) return *this;
   eConfigListID = coRef.eConfigListID;
   u32PTY = coRef.u32PTY;
   eSortingCriteria = coRef.eSortingCriteria;
   u8DigitalFilters = coRef.u8DigitalFilters;
   bFrozenList = coRef.bFrozenList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_MakeConfigList::midw_fi_tcl_Tun_MakeConfigList()
:eConfigListID()
,u32PTY(0)
,eSortingCriteria()
,u8DigitalFilters()
,bFrozenList(true)
 {}

tS32 midw_fi_tcl_Tun_MakeConfigList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_MAKECONFIGLIST;
}


midw_fi_tcl_Tun_MakeConfigList::~midw_fi_tcl_Tun_MakeConfigList()
{}

tU32 midw_fi_tcl_Tun_MakeConfigList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_Tun_MakeConfigList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eConfigListID);
   (tVoid) (oIn >> u32PTY);
   (tVoid) (oIn >> eSortingCriteria);
   (tVoid) (oIn >> u8DigitalFilters);
   (tVoid) (oIn >> bFrozenList);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_MakeConfigList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eConfigListID);
   (tVoid) (oOut << u32PTY);
   (tVoid) (oOut << eSortingCriteria);
   (tVoid) (oOut << u8DigitalFilters);
   (tVoid) (oOut << bFrozenList);
   return oOut;
}

tBool midw_fi_tcl_Tun_MakeConfigList::operator==(const midw_fi_tcl_Tun_MakeConfigList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eConfigListID == roRef.eConfigListID);
   bResult = bResult && (u32PTY == roRef.u32PTY);
   bResult = bResult && (eSortingCriteria == roRef.eSortingCriteria);
   bResult = bResult && (u8DigitalFilters == roRef.u8DigitalFilters);
   bResult = bResult && (bFrozenList == roRef.bFrozenList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerConfigListElementList::midw_fi_tcl_TunerConfigListElementList(const midw_fi_tcl_TunerConfigListElementList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerConfigListElement = coRef.TunerConfigListElement;
}
midw_fi_tcl_TunerConfigListElementList& midw_fi_tcl_TunerConfigListElementList::operator=(const midw_fi_tcl_TunerConfigListElementList& coRef)
{
   if (this == &coRef) return *this;
   TunerConfigListElement = coRef.TunerConfigListElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerConfigListElementList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerConfigListElement.size(); ++u32Idx)
         TunerConfigListElement[u32Idx].vDestroy();
   TunerConfigListElement.clear();
   }
}

midw_fi_tcl_TunerConfigListElementList::midw_fi_tcl_TunerConfigListElementList()

 {}

tS32 midw_fi_tcl_TunerConfigListElementList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERCONFIGLISTELEMENTLIST;
}


midw_fi_tcl_TunerConfigListElementList::~midw_fi_tcl_TunerConfigListElementList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerConfigListElementList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TunerConfigListElement.size(); ++u32ListIdx)
      u32DynamicSize += TunerConfigListElement[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_TunerConfigListElementList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerConfigListElement.size(); ++u32Idx)
      {
         TunerConfigListElement[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerConfigListElement.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerConfigListElement[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerConfigListElementList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerConfigListElement.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerConfigListElement.size(); ++u32Idx)
         (tVoid) (oOut << TunerConfigListElement[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TunerConfigListElementList::operator==(const midw_fi_tcl_TunerConfigListElementList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerConfigListElement.size() == roRef.TunerConfigListElement.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerConfigListElement.size()); ++u32Idx)
            bResult = bResult && (TunerConfigListElement[u32Idx] == roRef.TunerConfigListElement[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerRadioText::midw_fi_tcl_TunerRadioText(const midw_fi_tcl_TunerRadioText& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunerHeader = coRef.u8TunerHeader;
   u8TunerSource = coRef.u8TunerSource;
   u8TextType = coRef.u8TextType;
   sRadioTextData = coRef.sRadioTextData;
}
midw_fi_tcl_TunerRadioText& midw_fi_tcl_TunerRadioText::operator=(const midw_fi_tcl_TunerRadioText& coRef)
{
   if (this == &coRef) return *this;
   u8TunerHeader = coRef.u8TunerHeader;
   u8TunerSource = coRef.u8TunerSource;
   u8TextType = coRef.u8TextType;
   sRadioTextData = coRef.sRadioTextData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerRadioText::vDestroy()
{
   sRadioTextData.vDestroy();
}

midw_fi_tcl_TunerRadioText::midw_fi_tcl_TunerRadioText()
:u8TunerHeader()
,u8TunerSource()
,u8TextType(0)
,sRadioTextData()
 {}

tS32 midw_fi_tcl_TunerRadioText::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERRADIOTEXT;
}


midw_fi_tcl_TunerRadioText::~midw_fi_tcl_TunerRadioText()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerRadioText::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sRadioTextData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerRadioText::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u8TunerSource);
   (tVoid) (oIn >> u8TextType);
   (tVoid) (oIn >> sRadioTextData);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerRadioText::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u8TunerSource);
   (tVoid) (oOut << u8TextType);
   (tVoid) (oOut << sRadioTextData);
   return oOut;
}

tBool midw_fi_tcl_TunerRadioText::operator==(const midw_fi_tcl_TunerRadioText& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u8TunerSource == roRef.u8TunerSource);
   bResult = bResult && (u8TextType == roRef.u8TextType);
   bResult = bResult && (sRadioTextData == roRef.sRadioTextData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_DRMSourceActivity::midw_fi_tcl_e8_Tun_DRMSourceActivity():enType(FI_EN_OFF) {}

tS32 midw_fi_tcl_e8_Tun_DRMSourceActivity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_DRMSOURCEACTIVITY;
}


midw_fi_tcl_e8_Tun_DRMSourceActivity::~midw_fi_tcl_e8_Tun_DRMSourceActivity()
{}

tU32 midw_fi_tcl_e8_Tun_DRMSourceActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_DRMSourceActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_DRMSourceActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PISearch_Status::midw_fi_tcl_e8_PISearch_Status():enType(FI_EN_SEARCH_STARTED) {}

tS32 midw_fi_tcl_e8_PISearch_Status::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PISEARCH_STATUS;
}


midw_fi_tcl_e8_PISearch_Status::~midw_fi_tcl_e8_PISearch_Status()
{}

tU32 midw_fi_tcl_e8_PISearch_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PISearch_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PISearch_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerHDTestModeData::midw_fi_tcl_TunerHDTestModeData(const midw_fi_tcl_TunerHDTestModeData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8PhysicalTuner = coRef.e8PhysicalTuner;
   sHDCallSign = coRef.sHDCallSign;
   u32HDStationId = coRef.u32HDStationId;
   b8HDAvailableAudioPrograms = coRef.b8HDAvailableAudioPrograms;
   e8HDActiveAudioProgram = coRef.e8HDActiveAudioProgram;
   u8AudioQuality = coRef.u8AudioQuality;
   b8HDStationInfoBits = coRef.b8HDStationInfoBits;
   u8ACQStates = coRef.u8ACQStates;
   u8CD_NO = coRef.u8CD_NO;
   u8TransitionCount = coRef.u8TransitionCount;
}
midw_fi_tcl_TunerHDTestModeData& midw_fi_tcl_TunerHDTestModeData::operator=(const midw_fi_tcl_TunerHDTestModeData& coRef)
{
   if (this == &coRef) return *this;
   e8PhysicalTuner = coRef.e8PhysicalTuner;
   sHDCallSign = coRef.sHDCallSign;
   u32HDStationId = coRef.u32HDStationId;
   b8HDAvailableAudioPrograms = coRef.b8HDAvailableAudioPrograms;
   e8HDActiveAudioProgram = coRef.e8HDActiveAudioProgram;
   u8AudioQuality = coRef.u8AudioQuality;
   b8HDStationInfoBits = coRef.b8HDStationInfoBits;
   u8ACQStates = coRef.u8ACQStates;
   u8CD_NO = coRef.u8CD_NO;
   u8TransitionCount = coRef.u8TransitionCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerHDTestModeData::vDestroy()
{
   sHDCallSign.vDestroy();
}

midw_fi_tcl_TunerHDTestModeData::midw_fi_tcl_TunerHDTestModeData()
:e8PhysicalTuner()
,sHDCallSign()
,u32HDStationId(0)
,b8HDAvailableAudioPrograms()
,e8HDActiveAudioProgram()
,u8AudioQuality(0)
,b8HDStationInfoBits()
,u8ACQStates(0)
,u8CD_NO(0)
,u8TransitionCount(0)
 {}

tS32 midw_fi_tcl_TunerHDTestModeData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERHDTESTMODEDATA;
}


midw_fi_tcl_TunerHDTestModeData::~midw_fi_tcl_TunerHDTestModeData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerHDTestModeData::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+sHDCallSign.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerHDTestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PhysicalTuner);
   (tVoid) (oIn >> sHDCallSign);
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> b8HDAvailableAudioPrograms);
   (tVoid) (oIn >> e8HDActiveAudioProgram);
   (tVoid) (oIn >> u8AudioQuality);
   (tVoid) (oIn >> b8HDStationInfoBits);
   (tVoid) (oIn >> u8ACQStates);
   (tVoid) (oIn >> u8CD_NO);
   (tVoid) (oIn >> u8TransitionCount);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerHDTestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PhysicalTuner);
   (tVoid) (oOut << sHDCallSign);
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << b8HDAvailableAudioPrograms);
   (tVoid) (oOut << e8HDActiveAudioProgram);
   (tVoid) (oOut << u8AudioQuality);
   (tVoid) (oOut << b8HDStationInfoBits);
   (tVoid) (oOut << u8ACQStates);
   (tVoid) (oOut << u8CD_NO);
   (tVoid) (oOut << u8TransitionCount);
   return oOut;
}

tBool midw_fi_tcl_TunerHDTestModeData::operator==(const midw_fi_tcl_TunerHDTestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PhysicalTuner == roRef.e8PhysicalTuner);
   bResult = bResult && (sHDCallSign == roRef.sHDCallSign);
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (b8HDAvailableAudioPrograms == roRef.b8HDAvailableAudioPrograms);
   bResult = bResult && (e8HDActiveAudioProgram == roRef.e8HDActiveAudioProgram);
   bResult = bResult && (u8AudioQuality == roRef.u8AudioQuality);
   bResult = bResult && (b8HDStationInfoBits == roRef.b8HDStationInfoBits);
   bResult = bResult && (u8ACQStates == roRef.u8ACQStates);
   bResult = bResult && (u8CD_NO == roRef.u8CD_NO);
   bResult = bResult && (u8TransitionCount == roRef.u8TransitionCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_HDAdvisoryInfo::midw_fi_tcl_e8_Tun_HDAdvisoryInfo():enType(FI_EN_TUN_HD_ADVISORY_ACQUIRING) {}

tS32 midw_fi_tcl_e8_Tun_HDAdvisoryInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_HDADVISORYINFO;
}


midw_fi_tcl_e8_Tun_HDAdvisoryInfo::~midw_fi_tcl_e8_Tun_HDAdvisoryInfo()
{}

tU32 midw_fi_tcl_e8_Tun_HDAdvisoryInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_HDAdvisoryInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_HDAdvisoryInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_DRMTestModeActivity::midw_fi_tcl_e8_Tun_DRMTestModeActivity():enType(FI_EN_TESTMODE_AUTO_NOTIFICATIONS_OFF) {}

tS32 midw_fi_tcl_e8_Tun_DRMTestModeActivity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_DRMTESTMODEACTIVITY;
}


midw_fi_tcl_e8_Tun_DRMTestModeActivity::~midw_fi_tcl_e8_Tun_DRMTestModeActivity()
{}

tU32 midw_fi_tcl_e8_Tun_DRMTestModeActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_DRMTestModeActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_DRMTestModeActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_HDImageType::midw_fi_tcl_e8_Tun_HDImageType():enType(FI_EN_TUN_HD_STATION_LOGO) {}

tS32 midw_fi_tcl_e8_Tun_HDImageType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_HDIMAGETYPE;
}


midw_fi_tcl_e8_Tun_HDImageType::~midw_fi_tcl_e8_Tun_HDImageType()
{}

tU32 midw_fi_tcl_e8_Tun_HDImageType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_HDImageType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_HDImageType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_HDImageCoding::midw_fi_tcl_e8_Tun_HDImageCoding():enType(FI_EN_TUN_JPG) {}

tS32 midw_fi_tcl_e8_Tun_HDImageCoding::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_HDIMAGECODING;
}


midw_fi_tcl_e8_Tun_HDImageCoding::~midw_fi_tcl_e8_Tun_HDImageCoding()
{}

tU32 midw_fi_tcl_e8_Tun_HDImageCoding::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_HDImageCoding::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_HDImageCoding::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ImageFileInfo::midw_fi_tcl_ImageFileInfo(const midw_fi_tcl_ImageFileInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32HDStationId = coRef.u32HDStationId;
   e8HDImageType = coRef.e8HDImageType;
   e8HDImageCoding = coRef.e8HDImageCoding;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u32NoOfImageFileBytes = coRef.u32NoOfImageFileBytes;
   ImageFileBytes = coRef.ImageFileBytes;
}
midw_fi_tcl_ImageFileInfo& midw_fi_tcl_ImageFileInfo::operator=(const midw_fi_tcl_ImageFileInfo& coRef)
{
   if (this == &coRef) return *this;
   u32HDStationId = coRef.u32HDStationId;
   e8HDImageType = coRef.e8HDImageType;
   e8HDImageCoding = coRef.e8HDImageCoding;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u32NoOfImageFileBytes = coRef.u32NoOfImageFileBytes;
   ImageFileBytes = coRef.ImageFileBytes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ImageFileInfo::vDestroy()
{
   {
   ImageFileBytes.clear();
   }
}

midw_fi_tcl_ImageFileInfo::midw_fi_tcl_ImageFileInfo()
:u32HDStationId(0)
,e8HDImageType()
,e8HDImageCoding()
,e8HDAudioProgram()
,u32NoOfImageFileBytes(0)

 {}

tS32 midw_fi_tcl_ImageFileInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_IMAGEFILEINFO;
}


midw_fi_tcl_ImageFileInfo::~midw_fi_tcl_ImageFileInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ImageFileInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15+ static_cast<tU32>(ImageFileBytes.size()*1);
}

fi_tclInContext& midw_fi_tcl_ImageFileInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> e8HDImageType);
   (tVoid) (oIn >> e8HDImageCoding);
   (tVoid) (oIn >> e8HDAudioProgram);
   (tVoid) (oIn >> u32NoOfImageFileBytes);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ImageFileBytes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ImageFileBytes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ImageFileInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << e8HDImageType);
   (tVoid) (oOut << e8HDImageCoding);
   (tVoid) (oOut << e8HDAudioProgram);
   (tVoid) (oOut << u32NoOfImageFileBytes);
   (tVoid) (oOut << (tU32)ImageFileBytes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ImageFileBytes.size(); ++u32Idx)
         (tVoid) (oOut << ImageFileBytes[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ImageFileInfo::operator==(const midw_fi_tcl_ImageFileInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (e8HDImageType == roRef.e8HDImageType);
   bResult = bResult && (e8HDImageCoding == roRef.e8HDImageCoding);
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   bResult = bResult && (u32NoOfImageFileBytes == roRef.u32NoOfImageFileBytes);
      bResult = bResult && (ImageFileBytes.size() == roRef.ImageFileBytes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ImageFileBytes.size()); ++u32Idx)
            bResult = bResult && (ImageFileBytes[u32Idx] == roRef.ImageFileBytes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunPSDCommercial::midw_fi_tcl_TunPSDCommercial(const midw_fi_tcl_TunPSDCommercial& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   sPriceString = coRef.sPriceString;
   sValidUntil = coRef.sValidUntil;
   sContactURL = coRef.sContactURL;
   sReceivedAs = coRef.sReceivedAs;
   sNameOfSeller = coRef.sNameOfSeller;
   sDescription = coRef.sDescription;
}
midw_fi_tcl_TunPSDCommercial& midw_fi_tcl_TunPSDCommercial::operator=(const midw_fi_tcl_TunPSDCommercial& coRef)
{
   if (this == &coRef) return *this;
   sPriceString = coRef.sPriceString;
   sValidUntil = coRef.sValidUntil;
   sContactURL = coRef.sContactURL;
   sReceivedAs = coRef.sReceivedAs;
   sNameOfSeller = coRef.sNameOfSeller;
   sDescription = coRef.sDescription;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunPSDCommercial::vDestroy()
{
   sPriceString.vDestroy();
   sValidUntil.vDestroy();
   sContactURL.vDestroy();
   sReceivedAs.vDestroy();
   sNameOfSeller.vDestroy();
   sDescription.vDestroy();
}

midw_fi_tcl_TunPSDCommercial::midw_fi_tcl_TunPSDCommercial()
:sPriceString()
,sValidUntil()
,sContactURL()
,sReceivedAs()
,sNameOfSeller()
,sDescription()
 {}

tS32 midw_fi_tcl_TunPSDCommercial::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNPSDCOMMERCIAL;
}


midw_fi_tcl_TunPSDCommercial::~midw_fi_tcl_TunPSDCommercial()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunPSDCommercial::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPriceString.u32GetSize(u16MajorVersion)+sValidUntil.u32GetSize(u16MajorVersion)+sContactURL.u32GetSize(u16MajorVersion)+sReceivedAs.u32GetSize(u16MajorVersion)+sNameOfSeller.u32GetSize(u16MajorVersion)+sDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunPSDCommercial::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPriceString);
   (tVoid) (oIn >> sValidUntil);
   (tVoid) (oIn >> sContactURL);
   (tVoid) (oIn >> sReceivedAs);
   (tVoid) (oIn >> sNameOfSeller);
   (tVoid) (oIn >> sDescription);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunPSDCommercial::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPriceString);
   (tVoid) (oOut << sValidUntil);
   (tVoid) (oOut << sContactURL);
   (tVoid) (oOut << sReceivedAs);
   (tVoid) (oOut << sNameOfSeller);
   (tVoid) (oOut << sDescription);
   return oOut;
}

tBool midw_fi_tcl_TunPSDCommercial::operator==(const midw_fi_tcl_TunPSDCommercial& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPriceString == roRef.sPriceString);
   bResult = bResult && (sValidUntil == roRef.sValidUntil);
   bResult = bResult && (sContactURL == roRef.sContactURL);
   bResult = bResult && (sReceivedAs == roRef.sReceivedAs);
   bResult = bResult && (sNameOfSeller == roRef.sNameOfSeller);
   bResult = bResult && (sDescription == roRef.sDescription);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunPSDComment::midw_fi_tcl_TunPSDComment(const midw_fi_tcl_TunPSDComment& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   sLanguage = coRef.sLanguage;
   sShortContentDescription = coRef.sShortContentDescription;
   sActualText = coRef.sActualText;
}
midw_fi_tcl_TunPSDComment& midw_fi_tcl_TunPSDComment::operator=(const midw_fi_tcl_TunPSDComment& coRef)
{
   if (this == &coRef) return *this;
   sLanguage = coRef.sLanguage;
   sShortContentDescription = coRef.sShortContentDescription;
   sActualText = coRef.sActualText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunPSDComment::vDestroy()
{
   sLanguage.vDestroy();
   sShortContentDescription.vDestroy();
   sActualText.vDestroy();
}

midw_fi_tcl_TunPSDComment::midw_fi_tcl_TunPSDComment()
:sLanguage()
,sShortContentDescription()
,sActualText()
 {}

tS32 midw_fi_tcl_TunPSDComment::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNPSDCOMMENT;
}


midw_fi_tcl_TunPSDComment::~midw_fi_tcl_TunPSDComment()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunPSDComment::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sLanguage.u32GetSize(u16MajorVersion)+sShortContentDescription.u32GetSize(u16MajorVersion)+sActualText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunPSDComment::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sLanguage);
   (tVoid) (oIn >> sShortContentDescription);
   (tVoid) (oIn >> sActualText);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunPSDComment::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sLanguage);
   (tVoid) (oOut << sShortContentDescription);
   (tVoid) (oOut << sActualText);
   return oOut;
}

tBool midw_fi_tcl_TunPSDComment::operator==(const midw_fi_tcl_TunPSDComment& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sLanguage == roRef.sLanguage);
   bResult = bResult && (sShortContentDescription == roRef.sShortContentDescription);
   bResult = bResult && (sActualText == roRef.sActualText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunPSDData::midw_fi_tcl_TunPSDData(const midw_fi_tcl_TunPSDData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   sTitle = coRef.sTitle;
   sArtist = coRef.sArtist;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   TunPSDCommercial = coRef.TunPSDCommercial;
   TunPSDComment = coRef.TunPSDComment;
}
midw_fi_tcl_TunPSDData& midw_fi_tcl_TunPSDData::operator=(const midw_fi_tcl_TunPSDData& coRef)
{
   if (this == &coRef) return *this;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   sTitle = coRef.sTitle;
   sArtist = coRef.sArtist;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   TunPSDCommercial = coRef.TunPSDCommercial;
   TunPSDComment = coRef.TunPSDComment;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunPSDData::vDestroy()
{
   sTitle.vDestroy();
   sArtist.vDestroy();
   sAlbum.vDestroy();
   sGenre.vDestroy();
   TunPSDCommercial.vDestroy(); 
   TunPSDComment.vDestroy(); 
}

midw_fi_tcl_TunPSDData::midw_fi_tcl_TunPSDData()
:e8HDAudioProgram()
,sTitle()
,sArtist()
,sAlbum()
,sGenre()
,TunPSDCommercial()
,TunPSDComment()
 {}

tS32 midw_fi_tcl_TunPSDData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNPSDDATA;
}


midw_fi_tcl_TunPSDData::~midw_fi_tcl_TunPSDData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunPSDData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sTitle.u32GetSize(u16MajorVersion)+sArtist.u32GetSize(u16MajorVersion)+sAlbum.u32GetSize(u16MajorVersion)+sGenre.u32GetSize(u16MajorVersion)+TunPSDCommercial.u32GetSize(u16MajorVersion)+TunPSDComment.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunPSDData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8HDAudioProgram);
   (tVoid) (oIn >> sTitle);
   (tVoid) (oIn >> sArtist);
   (tVoid) (oIn >> sAlbum);
   (tVoid) (oIn >> sGenre);
   (tVoid) (oIn >> TunPSDCommercial);
   (tVoid) (oIn >> TunPSDComment);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunPSDData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8HDAudioProgram);
   (tVoid) (oOut << sTitle);
   (tVoid) (oOut << sArtist);
   (tVoid) (oOut << sAlbum);
   (tVoid) (oOut << sGenre);
   (tVoid) (oOut << TunPSDCommercial);
   (tVoid) (oOut << TunPSDComment);
   return oOut;
}

tBool midw_fi_tcl_TunPSDData::operator==(const midw_fi_tcl_TunPSDData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   bResult = bResult && (sTitle == roRef.sTitle);
   bResult = bResult && (sArtist == roRef.sArtist);
   bResult = bResult && (sAlbum == roRef.sAlbum);
   bResult = bResult && (sGenre == roRef.sGenre);
   bResult = bResult && (TunPSDCommercial == roRef.TunPSDCommercial);
   bResult = bResult && (TunPSDComment == roRef.TunPSDComment);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TestModeActivity::midw_fi_tcl_e8_Tun_TestModeActivity():enType(FI_EN_TUN_TEST_MODE_NOTIFICATION_OFF) {}

tS32 midw_fi_tcl_e8_Tun_TestModeActivity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TESTMODEACTIVITY;
}


midw_fi_tcl_e8_Tun_TestModeActivity::~midw_fi_tcl_e8_Tun_TestModeActivity()
{}

tU32 midw_fi_tcl_e8_Tun_TestModeActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TestModeActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TestModeActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TestModeSource::midw_fi_tcl_e8_Tun_TestModeSource():enType(FI_EN_TUN_TEST_MODE_SOURCE_ANALOG_AMFM) {}

tS32 midw_fi_tcl_e8_Tun_TestModeSource::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TESTMODESOURCE;
}


midw_fi_tcl_e8_Tun_TestModeSource::~midw_fi_tcl_e8_Tun_TestModeSource()
{}

tU32 midw_fi_tcl_e8_Tun_TestModeSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TestModeSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TestModeSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AudioSplitMode::midw_fi_tcl_e8_Tun_AudioSplitMode():enType(FI_EN_TUN_DEACTIVATE_AUDIO_SPLIT_MODE) {}

tS32 midw_fi_tcl_e8_Tun_AudioSplitMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_AUDIOSPLITMODE;
}


midw_fi_tcl_e8_Tun_AudioSplitMode::~midw_fi_tcl_e8_Tun_AudioSplitMode()
{}

tU32 midw_fi_tcl_e8_Tun_AudioSplitMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AudioSplitMode::oRead(fi_tclInContext& oIn)
{
   tS8 s8Value;
   (tVoid) (oIn >> s8Value);
   enType = (tenType)s8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AudioSplitMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tS8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_Tun_ParameterID::midw_fi_tcl_e16_Tun_ParameterID():enType(FI_EN_AUDIO_SPLIT_MODE) {}

tS32 midw_fi_tcl_e16_Tun_ParameterID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_TUN_PARAMETERID;
}


midw_fi_tcl_e16_Tun_ParameterID::~midw_fi_tcl_e16_Tun_ParameterID()
{}

tU32 midw_fi_tcl_e16_Tun_ParameterID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_Tun_ParameterID::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_Tun_ParameterID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_PhysicalTunerCalibData::midw_fi_tcl_PhysicalTunerCalibData(const midw_fi_tcl_PhysicalTunerCalibData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   b8AvailableBands = coRef.b8AvailableBands;
   u16FMCalibrationValue = coRef.u16FMCalibrationValue;
   u16AMCalibrationValue = coRef.u16AMCalibrationValue;
}
midw_fi_tcl_PhysicalTunerCalibData& midw_fi_tcl_PhysicalTunerCalibData::operator=(const midw_fi_tcl_PhysicalTunerCalibData& coRef)
{
   if (this == &coRef) return *this;
   b8AvailableBands = coRef.b8AvailableBands;
   u16FMCalibrationValue = coRef.u16FMCalibrationValue;
   u16AMCalibrationValue = coRef.u16AMCalibrationValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_PhysicalTunerCalibData::midw_fi_tcl_PhysicalTunerCalibData()
:b8AvailableBands()
,u16FMCalibrationValue(0)
,u16AMCalibrationValue(0)
 {}

tS32 midw_fi_tcl_PhysicalTunerCalibData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PHYSICALTUNERCALIBDATA;
}


midw_fi_tcl_PhysicalTunerCalibData::~midw_fi_tcl_PhysicalTunerCalibData()
{}

tU32 midw_fi_tcl_PhysicalTunerCalibData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_PhysicalTunerCalibData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8AvailableBands);
   (tVoid) (oIn >> u16FMCalibrationValue);
   (tVoid) (oIn >> u16AMCalibrationValue);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_PhysicalTunerCalibData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8AvailableBands);
   (tVoid) (oOut << u16FMCalibrationValue);
   (tVoid) (oOut << u16AMCalibrationValue);
   return oOut;
}

tBool midw_fi_tcl_PhysicalTunerCalibData::operator==(const midw_fi_tcl_PhysicalTunerCalibData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8AvailableBands == roRef.b8AvailableBands);
   bResult = bResult && (u16FMCalibrationValue == roRef.u16FMCalibrationValue);
   bResult = bResult && (u16AMCalibrationValue == roRef.u16AMCalibrationValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CalibrationData::midw_fi_tcl_CalibrationData(const midw_fi_tcl_CalibrationData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   PhysicalTunerOne = coRef.PhysicalTunerOne;
   PhysicalTunerTwo = coRef.PhysicalTunerTwo;
   PhysicalTunerThree = coRef.PhysicalTunerThree;
   PhysicalTunerFour = coRef.PhysicalTunerFour;
}
midw_fi_tcl_CalibrationData& midw_fi_tcl_CalibrationData::operator=(const midw_fi_tcl_CalibrationData& coRef)
{
   if (this == &coRef) return *this;
   PhysicalTunerOne = coRef.PhysicalTunerOne;
   PhysicalTunerTwo = coRef.PhysicalTunerTwo;
   PhysicalTunerThree = coRef.PhysicalTunerThree;
   PhysicalTunerFour = coRef.PhysicalTunerFour;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_CalibrationData::midw_fi_tcl_CalibrationData()
:PhysicalTunerOne()
,PhysicalTunerTwo()
,PhysicalTunerThree()
,PhysicalTunerFour()
 {}

tS32 midw_fi_tcl_CalibrationData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CALIBRATIONDATA;
}


midw_fi_tcl_CalibrationData::~midw_fi_tcl_CalibrationData()
{}

tU32 midw_fi_tcl_CalibrationData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& midw_fi_tcl_CalibrationData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhysicalTunerOne);
   (tVoid) (oIn >> PhysicalTunerTwo);
   (tVoid) (oIn >> PhysicalTunerThree);
   (tVoid) (oIn >> PhysicalTunerFour);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CalibrationData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhysicalTunerOne);
   (tVoid) (oOut << PhysicalTunerTwo);
   (tVoid) (oOut << PhysicalTunerThree);
   (tVoid) (oOut << PhysicalTunerFour);
   return oOut;
}

tBool midw_fi_tcl_CalibrationData::operator==(const midw_fi_tcl_CalibrationData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhysicalTunerOne == roRef.PhysicalTunerOne);
   bResult = bResult && (PhysicalTunerTwo == roRef.PhysicalTunerTwo);
   bResult = bResult && (PhysicalTunerThree == roRef.PhysicalTunerThree);
   bResult = bResult && (PhysicalTunerFour == roRef.PhysicalTunerFour);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_StationSelectionOption::midw_fi_tcl_e8_StationSelectionOption():enType(FI_EN_FREQUENCY_INPUT) {}

tS32 midw_fi_tcl_e8_StationSelectionOption::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STATIONSELECTIONOPTION;
}


midw_fi_tcl_e8_StationSelectionOption::~midw_fi_tcl_e8_StationSelectionOption()
{}

tU32 midw_fi_tcl_e8_StationSelectionOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_StationSelectionOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_StationSelectionOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Japan_Region::midw_fi_tcl_e8_Tun_Japan_Region():enType(FI_EN_TUN_HOKKAIDO) {}

tS32 midw_fi_tcl_e8_Tun_Japan_Region::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_JAPAN_REGION;
}


midw_fi_tcl_e8_Tun_Japan_Region::~midw_fi_tcl_e8_Tun_Japan_Region()
{}

tU32 midw_fi_tcl_e8_Tun_Japan_Region::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Japan_Region::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Japan_Region::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_Language::midw_fi_tcl_e8_Tun_Language():enType(FI_EN_LANG_ENGLISH) {}

tS32 midw_fi_tcl_e8_Tun_Language::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_LANGUAGE;
}


midw_fi_tcl_e8_Tun_Language::~midw_fi_tcl_e8_Tun_Language()
{}

tU32 midw_fi_tcl_e8_Tun_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ChangeStationMode::midw_fi_tcl_e8_Tun_ChangeStationMode():enType(FI_EN_TUN_UP) {}

tS32 midw_fi_tcl_e8_Tun_ChangeStationMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_CHANGESTATIONMODE;
}


midw_fi_tcl_e8_Tun_ChangeStationMode::~midw_fi_tcl_e8_Tun_ChangeStationMode()
{}

tU32 midw_fi_tcl_e8_Tun_ChangeStationMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ChangeStationMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ChangeStationMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerJapanStationName::midw_fi_tcl_TunerJapanStationName(const midw_fi_tcl_TunerJapanStationName& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16IndexID = coRef.u16IndexID;
   sJapanStationName = coRef.sJapanStationName;
}
midw_fi_tcl_TunerJapanStationName& midw_fi_tcl_TunerJapanStationName::operator=(const midw_fi_tcl_TunerJapanStationName& coRef)
{
   if (this == &coRef) return *this;
   u16IndexID = coRef.u16IndexID;
   sJapanStationName = coRef.sJapanStationName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerJapanStationName::vDestroy()
{
   sJapanStationName.vDestroy();
}

midw_fi_tcl_TunerJapanStationName::midw_fi_tcl_TunerJapanStationName()
:u16IndexID(0)
,sJapanStationName()
 {}

tS32 midw_fi_tcl_TunerJapanStationName::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERJAPANSTATIONNAME;
}


midw_fi_tcl_TunerJapanStationName::~midw_fi_tcl_TunerJapanStationName()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerJapanStationName::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sJapanStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerJapanStationName::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16IndexID);
   (tVoid) (oIn >> sJapanStationName);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerJapanStationName::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16IndexID);
   (tVoid) (oOut << sJapanStationName);
   return oOut;
}

tBool midw_fi_tcl_TunerJapanStationName::operator==(const midw_fi_tcl_TunerJapanStationName& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16IndexID == roRef.u16IndexID);
   bResult = bResult && (sJapanStationName == roRef.sJapanStationName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerJapanStationNameList::midw_fi_tcl_TunerJapanStationNameList(const midw_fi_tcl_TunerJapanStationNameList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerJapanStationName = coRef.TunerJapanStationName;
}
midw_fi_tcl_TunerJapanStationNameList& midw_fi_tcl_TunerJapanStationNameList::operator=(const midw_fi_tcl_TunerJapanStationNameList& coRef)
{
   if (this == &coRef) return *this;
   TunerJapanStationName = coRef.TunerJapanStationName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerJapanStationNameList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerJapanStationName.size(); ++u32Idx)
         TunerJapanStationName[u32Idx].vDestroy();
   TunerJapanStationName.clear();
   }
}

midw_fi_tcl_TunerJapanStationNameList::midw_fi_tcl_TunerJapanStationNameList()

 {}

tS32 midw_fi_tcl_TunerJapanStationNameList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERJAPANSTATIONNAMELIST;
}


midw_fi_tcl_TunerJapanStationNameList::~midw_fi_tcl_TunerJapanStationNameList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerJapanStationNameList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TunerJapanStationName.size(); ++u32ListIdx)
      u32DynamicSize += TunerJapanStationName[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_TunerJapanStationNameList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerJapanStationName.size(); ++u32Idx)
      {
         TunerJapanStationName[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerJapanStationName.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerJapanStationName[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerJapanStationNameList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerJapanStationName.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerJapanStationName.size(); ++u32Idx)
         (tVoid) (oOut << TunerJapanStationName[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TunerJapanStationNameList::operator==(const midw_fi_tcl_TunerJapanStationNameList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerJapanStationName.size() == roRef.TunerJapanStationName.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerJapanStationName.size()); ++u32Idx)
            bResult = bResult && (TunerJapanStationName[u32Idx] == roRef.TunerJapanStationName[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_u32FrequencyList::midw_fi_tcl_u32FrequencyList(const midw_fi_tcl_u32FrequencyList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   FrequencyValues = coRef.FrequencyValues;
}
midw_fi_tcl_u32FrequencyList& midw_fi_tcl_u32FrequencyList::operator=(const midw_fi_tcl_u32FrequencyList& coRef)
{
   if (this == &coRef) return *this;
   FrequencyValues = coRef.FrequencyValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_u32FrequencyList::vDestroy()
{
   {
   FrequencyValues.clear();
   }
}

midw_fi_tcl_u32FrequencyList::midw_fi_tcl_u32FrequencyList()

 {}

tS32 midw_fi_tcl_u32FrequencyList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U32FREQUENCYLIST;
}


midw_fi_tcl_u32FrequencyList::~midw_fi_tcl_u32FrequencyList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_u32FrequencyList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(FrequencyValues.size()*4);
}

fi_tclInContext& midw_fi_tcl_u32FrequencyList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FrequencyValues.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FrequencyValues[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u32FrequencyList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FrequencyValues.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FrequencyValues.size(); ++u32Idx)
         (tVoid) (oOut << FrequencyValues[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_u32FrequencyList::operator==(const midw_fi_tcl_u32FrequencyList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FrequencyValues.size() == roRef.FrequencyValues.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FrequencyValues.size()); ++u32Idx)
            bResult = bResult && (FrequencyValues[u32Idx] == roRef.FrequencyValues[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_STATStatusRegister::midw_fi_tcl_b8_Tun_STATStatusRegister():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_STATStatusRegister::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_STATSTATUSREGISTER;
}


midw_fi_tcl_b8_Tun_STATStatusRegister::~midw_fi_tcl_b8_Tun_STATStatusRegister()
{}

tU32 midw_fi_tcl_b8_Tun_STATStatusRegister::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_STATStatusRegister::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_STATStatusRegister::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DARCDataBlock::midw_fi_tcl_DARCDataBlock(const midw_fi_tcl_DARCDataBlock& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   STAT_Status_Register = coRef.STAT_Status_Register;
   Block_Number_Register = coRef.Block_Number_Register;
   DARCDataList = coRef.DARCDataList;
}
midw_fi_tcl_DARCDataBlock& midw_fi_tcl_DARCDataBlock::operator=(const midw_fi_tcl_DARCDataBlock& coRef)
{
   if (this == &coRef) return *this;
   STAT_Status_Register = coRef.STAT_Status_Register;
   Block_Number_Register = coRef.Block_Number_Register;
   DARCDataList = coRef.DARCDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DARCDataBlock::vDestroy()
{
   {
   DARCDataList.clear();
   }
}

midw_fi_tcl_DARCDataBlock::midw_fi_tcl_DARCDataBlock()
:STAT_Status_Register()
,Block_Number_Register(0)

 {}

tS32 midw_fi_tcl_DARCDataBlock::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DARCDATABLOCK;
}


midw_fi_tcl_DARCDataBlock::~midw_fi_tcl_DARCDataBlock()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DARCDataBlock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(DARCDataList.size()*1);
}

fi_tclInContext& midw_fi_tcl_DARCDataBlock::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> STAT_Status_Register);
   (tVoid) (oIn >> Block_Number_Register);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DARCDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DARCDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DARCDataBlock::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << STAT_Status_Register);
   (tVoid) (oOut << Block_Number_Register);
   (tVoid) (oOut << (tU32)DARCDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DARCDataList.size(); ++u32Idx)
         (tVoid) (oOut << DARCDataList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DARCDataBlock::operator==(const midw_fi_tcl_DARCDataBlock& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (STAT_Status_Register == roRef.STAT_Status_Register);
   bResult = bResult && (Block_Number_Register == roRef.Block_Number_Register);
      bResult = bResult && (DARCDataList.size() == roRef.DARCDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DARCDataList.size()); ++u32Idx)
            bResult = bResult && (DARCDataList[u32Idx] == roRef.DARCDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DARCDataBlockList::midw_fi_tcl_DARCDataBlockList(const midw_fi_tcl_DARCDataBlockList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DARCDataBlock = coRef.DARCDataBlock;
}
midw_fi_tcl_DARCDataBlockList& midw_fi_tcl_DARCDataBlockList::operator=(const midw_fi_tcl_DARCDataBlockList& coRef)
{
   if (this == &coRef) return *this;
   DARCDataBlock = coRef.DARCDataBlock;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DARCDataBlockList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DARCDataBlock.size(); ++u32Idx)
         DARCDataBlock[u32Idx].vDestroy();
   DARCDataBlock.clear();
   }
}

midw_fi_tcl_DARCDataBlockList::midw_fi_tcl_DARCDataBlockList()

 {}

tS32 midw_fi_tcl_DARCDataBlockList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DARCDATABLOCKLIST;
}


midw_fi_tcl_DARCDataBlockList::~midw_fi_tcl_DARCDataBlockList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DARCDataBlockList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DARCDataBlock.size(); ++u32ListIdx)
      u32DynamicSize += DARCDataBlock[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_DARCDataBlockList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DARCDataBlock.size(); ++u32Idx)
      {
         DARCDataBlock[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DARCDataBlock.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DARCDataBlock[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DARCDataBlockList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DARCDataBlock.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DARCDataBlock.size(); ++u32Idx)
         (tVoid) (oOut << DARCDataBlock[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DARCDataBlockList::operator==(const midw_fi_tcl_DARCDataBlockList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DARCDataBlock.size() == roRef.DARCDataBlock.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DARCDataBlock.size()); ++u32Idx)
            bResult = bResult && (DARCDataBlock[u32Idx] == roRef.DARCDataBlock[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerListElement::midw_fi_tcl_TunerListElement(const midw_fi_tcl_TunerListElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8ListID = coRef.e8ListID;
   u8ElementID = coRef.u8ElementID;
   e8Modulation = coRef.e8Modulation;
   u32Frequency = coRef.u32Frequency;
   u32SID = coRef.u32SID;
   u8NumOfCharactersInStationName = coRef.u8NumOfCharactersInStationName;
   sStationName = coRef.sStationName;
   u8StationNameEncoding = coRef.u8StationNameEncoding;
   u8ProgramService = coRef.u8ProgramService;
}
midw_fi_tcl_TunerListElement& midw_fi_tcl_TunerListElement::operator=(const midw_fi_tcl_TunerListElement& coRef)
{
   if (this == &coRef) return *this;
   e8ListID = coRef.e8ListID;
   u8ElementID = coRef.u8ElementID;
   e8Modulation = coRef.e8Modulation;
   u32Frequency = coRef.u32Frequency;
   u32SID = coRef.u32SID;
   u8NumOfCharactersInStationName = coRef.u8NumOfCharactersInStationName;
   sStationName = coRef.sStationName;
   u8StationNameEncoding = coRef.u8StationNameEncoding;
   u8ProgramService = coRef.u8ProgramService;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerListElement::vDestroy()
{
   sStationName.vDestroy();
}

midw_fi_tcl_TunerListElement::midw_fi_tcl_TunerListElement()
:e8ListID()
,u8ElementID(0)
,e8Modulation()
,u32Frequency(0)
,u32SID(0)
,u8NumOfCharactersInStationName(0)
,sStationName()
,u8StationNameEncoding(0)
,u8ProgramService(0)
 {}

tS32 midw_fi_tcl_TunerListElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERLISTELEMENT;
}


midw_fi_tcl_TunerListElement::~midw_fi_tcl_TunerListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+sStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> u8ElementID);
   (tVoid) (oIn >> e8Modulation);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u32SID);
   (tVoid) (oIn >> u8NumOfCharactersInStationName);
   (tVoid) (oIn >> sStationName);
   (tVoid) (oIn >> u8StationNameEncoding);
   (tVoid) (oIn >> u8ProgramService);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << u8ElementID);
   (tVoid) (oOut << e8Modulation);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u32SID);
   (tVoid) (oOut << u8NumOfCharactersInStationName);
   (tVoid) (oOut << sStationName);
   (tVoid) (oOut << u8StationNameEncoding);
   (tVoid) (oOut << u8ProgramService);
   return oOut;
}

tBool midw_fi_tcl_TunerListElement::operator==(const midw_fi_tcl_TunerListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (u8ElementID == roRef.u8ElementID);
   bResult = bResult && (e8Modulation == roRef.e8Modulation);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u32SID == roRef.u32SID);
   bResult = bResult && (u8NumOfCharactersInStationName == roRef.u8NumOfCharactersInStationName);
   bResult = bResult && (sStationName == roRef.sStationName);
   bResult = bResult && (u8StationNameEncoding == roRef.u8StationNameEncoding);
   bResult = bResult && (u8ProgramService == roRef.u8ProgramService);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerListElementList::midw_fi_tcl_TunerListElementList(const midw_fi_tcl_TunerListElementList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerListElement = coRef.TunerListElement;
}
midw_fi_tcl_TunerListElementList& midw_fi_tcl_TunerListElementList::operator=(const midw_fi_tcl_TunerListElementList& coRef)
{
   if (this == &coRef) return *this;
   TunerListElement = coRef.TunerListElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerListElementList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerListElement.size(); ++u32Idx)
         TunerListElement[u32Idx].vDestroy();
   TunerListElement.clear();
   }
}

midw_fi_tcl_TunerListElementList::midw_fi_tcl_TunerListElementList()

 {}

tS32 midw_fi_tcl_TunerListElementList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERLISTELEMENTLIST;
}


midw_fi_tcl_TunerListElementList::~midw_fi_tcl_TunerListElementList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerListElementList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TunerListElement.size(); ++u32ListIdx)
      u32DynamicSize += TunerListElement[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_TunerListElementList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerListElement.size(); ++u32Idx)
      {
         TunerListElement[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerListElement.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerListElement[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerListElementList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerListElement.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerListElement.size(); ++u32Idx)
         (tVoid) (oOut << TunerListElement[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TunerListElementList::operator==(const midw_fi_tcl_TunerListElementList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerListElement.size() == roRef.TunerListElement.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerListElement.size()); ++u32Idx)
            bResult = bResult && (TunerListElement[u32Idx] == roRef.TunerListElement[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_SwitchingFrequency::midw_fi_tcl_b8_Tun_SwitchingFrequency():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_SwitchingFrequency::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_SWITCHINGFREQUENCY;
}


midw_fi_tcl_b8_Tun_SwitchingFrequency::~midw_fi_tcl_b8_Tun_SwitchingFrequency()
{}

tU32 midw_fi_tcl_b8_Tun_SwitchingFrequency::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_SwitchingFrequency::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_SwitchingFrequency::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Band::midw_fi_tcl_e8_Band():enType(FI_EN_TUN_MSTR_BAND_FM) {}

tS32 midw_fi_tcl_e8_Band::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BAND;
}


midw_fi_tcl_e8_Band::~midw_fi_tcl_e8_Band()
{}

tU32 midw_fi_tcl_e8_Band::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Band::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Band::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Preset_Option::midw_fi_tcl_e8_Preset_Option():enType(FI_EN_TUN_MSTR_PRESET_OPTION_KEEP_OTHERS) {}

tS32 midw_fi_tcl_e8_Preset_Option::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PRESET_OPTION;
}


midw_fi_tcl_e8_Preset_Option::~midw_fi_tcl_e8_Preset_Option()
{}

tU32 midw_fi_tcl_e8_Preset_Option::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Preset_Option::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Preset_Option::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Source::midw_fi_tcl_e8_Source():enType(FI_EN_TUN_MSTR_SOURCE_FM1) {}

tS32 midw_fi_tcl_e8_Source::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SOURCE;
}


midw_fi_tcl_e8_Source::~midw_fi_tcl_e8_Source()
{}

tU32 midw_fi_tcl_e8_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Action::midw_fi_tcl_e8_Action():enType(FI_EN_TUN_MSTR_PLAY) {}

tS32 midw_fi_tcl_e8_Action::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ACTION;
}


midw_fi_tcl_e8_Action::~midw_fi_tcl_e8_Action()
{}

tU32 midw_fi_tcl_e8_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_WhichTuner::midw_fi_tcl_e8_WhichTuner():enType(FI_EN_TUN_MSTR_TUNER_0) {}

tS32 midw_fi_tcl_e8_WhichTuner::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_WHICHTUNER;
}


midw_fi_tcl_e8_WhichTuner::~midw_fi_tcl_e8_WhichTuner()
{}

tU32 midw_fi_tcl_e8_WhichTuner::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_WhichTuner::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_WhichTuner::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_StopAnnouncements::midw_fi_tcl_StopAnnouncements():enType(FI_EN_TUN_MSTR_STOP_CURRENT) {}

tS32 midw_fi_tcl_StopAnnouncements::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_STOPANNOUNCEMENTS;
}


midw_fi_tcl_StopAnnouncements::~midw_fi_tcl_StopAnnouncements()
{}

tU32 midw_fi_tcl_StopAnnouncements::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_StopAnnouncements::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_StopAnnouncements::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunMstr_ResponseStatus::midw_fi_tcl_e8_TunMstr_ResponseStatus():enType(FI_EN_TUN_MSTR_RES_REQ_SUCCEED) {}

tS32 midw_fi_tcl_e8_TunMstr_ResponseStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNMSTR_RESPONSESTATUS;
}


midw_fi_tcl_e8_TunMstr_ResponseStatus::~midw_fi_tcl_e8_TunMstr_ResponseStatus()
{}

tU32 midw_fi_tcl_e8_TunMstr_ResponseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunMstr_ResponseStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunMstr_ResponseStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerMaster_StatusResponse::midw_fi_tcl_TunerMaster_StatusResponse(const midw_fi_tcl_TunerMaster_StatusResponse& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8TunermasterStatus = coRef.u8TunermasterStatus;
}
midw_fi_tcl_TunerMaster_StatusResponse& midw_fi_tcl_TunerMaster_StatusResponse::operator=(const midw_fi_tcl_TunerMaster_StatusResponse& coRef)
{
   if (this == &coRef) return *this;
   u8TunermasterStatus = coRef.u8TunermasterStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerMaster_StatusResponse::midw_fi_tcl_TunerMaster_StatusResponse()
:u8TunermasterStatus()
 {}

tS32 midw_fi_tcl_TunerMaster_StatusResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERMASTER_STATUSRESPONSE;
}


midw_fi_tcl_TunerMaster_StatusResponse::~midw_fi_tcl_TunerMaster_StatusResponse()
{}

tU32 midw_fi_tcl_TunerMaster_StatusResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_TunerMaster_StatusResponse::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunermasterStatus);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerMaster_StatusResponse::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunermasterStatus);
   return oOut;
}

tBool midw_fi_tcl_TunerMaster_StatusResponse::operator==(const midw_fi_tcl_TunerMaster_StatusResponse& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunermasterStatus == roRef.u8TunermasterStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response():enType(FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED) {}

tS32 midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNMSTR_RADIOPROFILESETTING_RESPONSE;
}


midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::~midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response()
{}

tU32 midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode():enType(FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED) {}

tS32 midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNMSTR_RADIOPROFILESETTING_ERRORCODE;
}


midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::~midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode()
{}

tU32 midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::midw_fi_tcl_TunMstr_RadioSetting_StatusResponse(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   RadioProfileSetting_Response = coRef.RadioProfileSetting_Response;
   RadioProfileSetting_ErrorCode = coRef.RadioProfileSetting_ErrorCode;
}
midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::operator=(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& coRef)
{
   if (this == &coRef) return *this;
   RadioProfileSetting_Response = coRef.RadioProfileSetting_Response;
   RadioProfileSetting_ErrorCode = coRef.RadioProfileSetting_ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::midw_fi_tcl_TunMstr_RadioSetting_StatusResponse()
:RadioProfileSetting_Response()
,RadioProfileSetting_ErrorCode()
 {}

tS32 midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNMSTR_RADIOSETTING_STATUSRESPONSE;
}


midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::~midw_fi_tcl_TunMstr_RadioSetting_StatusResponse()
{}

tU32 midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioProfileSetting_Response);
   (tVoid) (oIn >> RadioProfileSetting_ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioProfileSetting_Response);
   (tVoid) (oOut << RadioProfileSetting_ErrorCode);
   return oOut;
}

tBool midw_fi_tcl_TunMstr_RadioSetting_StatusResponse::operator==(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioProfileSetting_Response == roRef.RadioProfileSetting_Response);
   bResult = bResult && (RadioProfileSetting_ErrorCode == roRef.RadioProfileSetting_ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_List::midw_fi_tcl_e8_List():enType(FI_EN_BANK_FM1) {}

tS32 midw_fi_tcl_e8_List::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_LIST;
}


midw_fi_tcl_e8_List::~midw_fi_tcl_e8_List()
{}

tU32 midw_fi_tcl_e8_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_List::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_List::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RFAntenna::midw_fi_tcl_e8_RFAntenna():enType(FI_EN_TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_RFAntenna::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RFANTENNA;
}


midw_fi_tcl_e8_RFAntenna::~midw_fi_tcl_e8_RFAntenna()
{}

tU32 midw_fi_tcl_e8_RFAntenna::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RFAntenna::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RFAntenna::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AntennaTest::midw_fi_tcl_e8_AntennaTest():enType(FI_EN_AMFM_ANTENNA1) {}

tS32 midw_fi_tcl_e8_AntennaTest::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ANTENNATEST;
}


midw_fi_tcl_e8_AntennaTest::~midw_fi_tcl_e8_AntennaTest()
{}

tU32 midw_fi_tcl_e8_AntennaTest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AntennaTest::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AntennaTest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tclunmstr_RFAntenna::midw_fi_tclunmstr_RFAntenna(const midw_fi_tclunmstr_RFAntenna& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AntennaTest = coRef.AntennaTest;
   RFAntennaStatus = coRef.RFAntennaStatus;
   ConnectionCurrent = coRef.ConnectionCurrent;
}
midw_fi_tclunmstr_RFAntenna& midw_fi_tclunmstr_RFAntenna::operator=(const midw_fi_tclunmstr_RFAntenna& coRef)
{
   if (this == &coRef) return *this;
   AntennaTest = coRef.AntennaTest;
   RFAntennaStatus = coRef.RFAntennaStatus;
   ConnectionCurrent = coRef.ConnectionCurrent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tclunmstr_RFAntenna::midw_fi_tclunmstr_RFAntenna()
:AntennaTest()
,RFAntennaStatus()
,ConnectionCurrent(0)
 {}

tS32 midw_fi_tclunmstr_RFAntenna::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_NMSTR_RFANTENNA;
}


midw_fi_tclunmstr_RFAntenna::~midw_fi_tclunmstr_RFAntenna()
{}

tU32 midw_fi_tclunmstr_RFAntenna::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tclunmstr_RFAntenna::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AntennaTest);
   (tVoid) (oIn >> RFAntennaStatus);
   (tVoid) (oIn >> ConnectionCurrent);
   return oIn;
}

fi_tclOutContext& midw_fi_tclunmstr_RFAntenna::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AntennaTest);
   (tVoid) (oOut << RFAntennaStatus);
   (tVoid) (oOut << ConnectionCurrent);
   return oOut;
}

tBool midw_fi_tclunmstr_RFAntenna::operator==(const midw_fi_tclunmstr_RFAntenna& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AntennaTest == roRef.AntennaTest);
   bResult = bResult && (RFAntennaStatus == roRef.RFAntennaStatus);
   bResult = bResult && (ConnectionCurrent == roRef.ConnectionCurrent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RequestResult::midw_fi_tcl_e8_RequestResult():enType(FI_EN_TUN_MSTR_REQUEST_REJECTED) {}

tS32 midw_fi_tcl_e8_RequestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_REQUESTRESULT;
}


midw_fi_tcl_e8_RequestResult::~midw_fi_tcl_e8_RequestResult()
{}

tU32 midw_fi_tcl_e8_RequestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RequestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RequestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AST_Types::midw_fi_tcl_e8_AST_Types():enType(FI_EN_NORMAL_AST) {}

tS32 midw_fi_tcl_e8_AST_Types::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AST_TYPES;
}


midw_fi_tcl_e8_AST_Types::~midw_fi_tcl_e8_AST_Types()
{}

tU32 midw_fi_tcl_e8_AST_Types::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AST_Types::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AST_Types::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Graphics::midw_fi_tcl_e8_Graphics():enType(FI_EN_GRAPHICS_NEEDS_NOREFRESH) {}

tS32 midw_fi_tcl_e8_Graphics::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GRAPHICS;
}


midw_fi_tcl_e8_Graphics::~midw_fi_tcl_e8_Graphics()
{}

tU32 midw_fi_tcl_e8_Graphics::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Graphics::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Graphics::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SXMChannelAttributes::midw_fi_tcl_SXMChannelAttributes(const midw_fi_tcl_SXMChannelAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Logo = coRef.Logo;
   Name = coRef.Name;
   PDT = coRef.PDT;
   IsLocked = coRef.IsLocked;
   ContextualBanner = coRef.ContextualBanner;
   ChannelNumber = coRef.ChannelNumber;
}
midw_fi_tcl_SXMChannelAttributes& midw_fi_tcl_SXMChannelAttributes::operator=(const midw_fi_tcl_SXMChannelAttributes& coRef)
{
   if (this == &coRef) return *this;
   Logo = coRef.Logo;
   Name = coRef.Name;
   PDT = coRef.PDT;
   IsLocked = coRef.IsLocked;
   ContextualBanner = coRef.ContextualBanner;
   ChannelNumber = coRef.ChannelNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SXMChannelAttributes::vDestroy()
{
   {
   Logo.clear();
   }
   Name.vDestroy();
   PDT.vDestroy();
   ContextualBanner.vDestroy();
}

midw_fi_tcl_SXMChannelAttributes::midw_fi_tcl_SXMChannelAttributes()

:Name()
,PDT()
,IsLocked(0)
,ContextualBanner()
,ChannelNumber(0)
 {}

tS32 midw_fi_tcl_SXMChannelAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SXMCHANNELATTRIBUTES;
}


midw_fi_tcl_SXMChannelAttributes::~midw_fi_tcl_SXMChannelAttributes()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SXMChannelAttributes::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+ static_cast<tU32>(Logo.size()*1)+Name.u32GetSize(u16MajorVersion)+PDT.u32GetSize(u16MajorVersion)+ContextualBanner.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_SXMChannelAttributes::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Logo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Logo[u32Idx]);
      }
   }
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> PDT);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> ContextualBanner);
   (tVoid) (oIn >> ChannelNumber);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SXMChannelAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Logo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Logo.size(); ++u32Idx)
         (tVoid) (oOut << Logo[u32Idx]);
   }
   (tVoid) (oOut << Name);
   (tVoid) (oOut << PDT);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << ContextualBanner);
   (tVoid) (oOut << ChannelNumber);
   return oOut;
}

tBool midw_fi_tcl_SXMChannelAttributes::operator==(const midw_fi_tcl_SXMChannelAttributes& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Logo.size() == roRef.Logo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Logo.size()); ++u32Idx)
            bResult = bResult && (Logo[u32Idx] == roRef.Logo[u32Idx]);
      }
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (PDT == roRef.PDT);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (ContextualBanner == roRef.ContextualBanner);
   bResult = bResult && (ChannelNumber == roRef.ChannelNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_HDAudioProgram::midw_fi_tcl_e8_HDAudioProgram():enType(FI_EN_TUN_MSTR_AUDIO_PROGRAM_ONE) {}

tS32 midw_fi_tcl_e8_HDAudioProgram::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_HDAUDIOPROGRAM;
}


midw_fi_tcl_e8_HDAudioProgram::~midw_fi_tcl_e8_HDAudioProgram()
{}

tU32 midw_fi_tcl_e8_HDAudioProgram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_HDAudioProgram::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_HDAudioProgram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PresetType::midw_fi_tcl_e8_PresetType():enType(FI_EN_INVALID) {}

tS32 midw_fi_tcl_e8_PresetType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PRESETTYPE;
}


midw_fi_tcl_e8_PresetType::~midw_fi_tcl_e8_PresetType()
{}

tU32 midw_fi_tcl_e8_PresetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PresetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PresetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SXMChannelImagedata::midw_fi_tcl_SXMChannelImagedata(const midw_fi_tcl_SXMChannelImagedata& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SID = coRef.SID;
   ImageData = coRef.ImageData;
   ImageDataSize = coRef.ImageDataSize;
}
midw_fi_tcl_SXMChannelImagedata& midw_fi_tcl_SXMChannelImagedata::operator=(const midw_fi_tcl_SXMChannelImagedata& coRef)
{
   if (this == &coRef) return *this;
   SID = coRef.SID;
   ImageData = coRef.ImageData;
   ImageDataSize = coRef.ImageDataSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SXMChannelImagedata::vDestroy()
{
   {
   ImageData.clear();
   }
}

midw_fi_tcl_SXMChannelImagedata::midw_fi_tcl_SXMChannelImagedata()
:SID(0)

,ImageDataSize(0)
 {}

tS32 midw_fi_tcl_SXMChannelImagedata::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SXMCHANNELIMAGEDATA;
}


midw_fi_tcl_SXMChannelImagedata::~midw_fi_tcl_SXMChannelImagedata()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SXMChannelImagedata::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(ImageData.size()*1);
}

fi_tclInContext& midw_fi_tcl_SXMChannelImagedata::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ImageData[u32Idx]);
      }
   }
   (tVoid) (oIn >> ImageDataSize);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SXMChannelImagedata::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SID);
   (tVoid) (oOut << (tU32)ImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ImageData.size(); ++u32Idx)
         (tVoid) (oOut << ImageData[u32Idx]);
   }
   (tVoid) (oOut << ImageDataSize);
   return oOut;
}

tBool midw_fi_tcl_SXMChannelImagedata::operator==(const midw_fi_tcl_SXMChannelImagedata& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SID == roRef.SID);
      bResult = bResult && (ImageData.size() == roRef.ImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ImageData.size()); ++u32Idx)
            bResult = bResult && (ImageData[u32Idx] == roRef.ImageData[u32Idx]);
      }
   bResult = bResult && (ImageDataSize == roRef.ImageDataSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PSFreeze_Mode::midw_fi_tcl_e8_PSFreeze_Mode():enType(FI_EN_FREEZE) {}

tS32 midw_fi_tcl_e8_PSFreeze_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PSFREEZE_MODE;
}


midw_fi_tcl_e8_PSFreeze_Mode::~midw_fi_tcl_e8_PSFreeze_Mode()
{}

tU32 midw_fi_tcl_e8_PSFreeze_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PSFreeze_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PSFreeze_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Preset_Action::midw_fi_tcl_e8_Preset_Action():enType(FI_EN_TUNMSTR_PRESETRECALL) {}

tS32 midw_fi_tcl_e8_Preset_Action::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PRESET_ACTION;
}


midw_fi_tcl_e8_Preset_Action::~midw_fi_tcl_e8_Preset_Action()
{}

tU32 midw_fi_tcl_e8_Preset_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Preset_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Preset_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_StationSelection_Option::midw_fi_tcl_e8_StationSelection_Option():enType(FI_EN_FREQUENCY_INPUT) {}

tS32 midw_fi_tcl_e8_StationSelection_Option::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STATIONSELECTION_OPTION;
}


midw_fi_tcl_e8_StationSelection_Option::~midw_fi_tcl_e8_StationSelection_Option()
{}

tU32 midw_fi_tcl_e8_StationSelection_Option::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_StationSelection_Option::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_StationSelection_Option::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AnnoTypes::midw_fi_tcl_e8_AnnoTypes():enType(FI_EN_TUNMSTR_ANNOTYPE_PTY31) {}

tS32 midw_fi_tcl_e8_AnnoTypes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ANNOTYPES;
}


midw_fi_tcl_e8_AnnoTypes::~midw_fi_tcl_e8_AnnoTypes()
{}

tU32 midw_fi_tcl_e8_AnnoTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AnnoTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AnnoTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_AnnoType::midw_fi_tcl_b32_AnnoType():u32Value(0)
{}

tS32 midw_fi_tcl_b32_AnnoType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_ANNOTYPE;
}


midw_fi_tcl_b32_AnnoType::~midw_fi_tcl_b32_AnnoType()
{}

tU32 midw_fi_tcl_b32_AnnoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_AnnoType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_AnnoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_SourceAnno::midw_fi_tcl_b8_SourceAnno():u8Value(0)
{}

tS32 midw_fi_tcl_b8_SourceAnno::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_SOURCEANNO;
}


midw_fi_tcl_b8_SourceAnno::~midw_fi_tcl_b8_SourceAnno()
{}

tU32 midw_fi_tcl_b8_SourceAnno::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_SourceAnno::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_SourceAnno::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunerAvailability::midw_fi_tcl_e8_TunerAvailability():enType(FI_EN_TUNMSTR_FM_TUNER_NOW_AVAILABLE) {}

tS32 midw_fi_tcl_e8_TunerAvailability::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNERAVAILABILITY;
}


midw_fi_tcl_e8_TunerAvailability::~midw_fi_tcl_e8_TunerAvailability()
{}

tU32 midw_fi_tcl_e8_TunerAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunerAvailability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunerAvailability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_ModeType::midw_fi_tcl_b8_ModeType():u8Value(0)
{}

tS32 midw_fi_tcl_b8_ModeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_MODETYPE;
}


midw_fi_tcl_b8_ModeType::~midw_fi_tcl_b8_ModeType()
{}

tU32 midw_fi_tcl_b8_ModeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_ModeType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_ModeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_StationType::midw_fi_tcl_e8_StationType():enType(FI_EN_TUNMSTR_STATIONTYPE_DAB) {}

tS32 midw_fi_tcl_e8_StationType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STATIONTYPE;
}


midw_fi_tcl_e8_StationType::~midw_fi_tcl_e8_StationType()
{}

tU32 midw_fi_tcl_e8_StationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_StationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_StationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ModulationType::midw_fi_tcl_e8_ModulationType():enType(FI_EN_TUN_MSTR_MODULATION_ANALOG) {}

tS32 midw_fi_tcl_e8_ModulationType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MODULATIONTYPE;
}


midw_fi_tcl_e8_ModulationType::~midw_fi_tcl_e8_ModulationType()
{}

tU32 midw_fi_tcl_e8_ModulationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ModulationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ModulationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_HDTextEncoding::midw_fi_tcl_e8_HDTextEncoding():enType(FI_EN_TUN_MSTR_ISO_IEC_8859_1_1998) {}

tS32 midw_fi_tcl_e8_HDTextEncoding::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_HDTEXTENCODING;
}


midw_fi_tcl_e8_HDTextEncoding::~midw_fi_tcl_e8_HDTextEncoding()
{}

tU32 midw_fi_tcl_e8_HDTextEncoding::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_HDTextEncoding::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_HDTextEncoding::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SXMPresetListEntry::midw_fi_tcl_SXMPresetListEntry(const midw_fi_tcl_SXMPresetListEntry& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelActive = coRef.ChannelActive;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   IsSmartFavorite = coRef.IsSmartFavorite;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
}
midw_fi_tcl_SXMPresetListEntry& midw_fi_tcl_SXMPresetListEntry::operator=(const midw_fi_tcl_SXMPresetListEntry& coRef)
{
   if (this == &coRef) return *this;
   ServiceID = coRef.ServiceID;
   ChannelID = coRef.ChannelID;
   ChannelNameAvail = coRef.ChannelNameAvail;
   ChannelName = coRef.ChannelName;
   ChannelActive = coRef.ChannelActive;
   ChnGraphicAvail = coRef.ChnGraphicAvail;
   IsSmartFavorite = coRef.IsSmartFavorite;
   IsLocked = coRef.IsLocked;
   IsAvailable = coRef.IsAvailable;
   IsMature = coRef.IsMature;
   IsSkipped = coRef.IsSkipped;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SXMPresetListEntry::vDestroy()
{
   ChannelName.vDestroy();
}

midw_fi_tcl_SXMPresetListEntry::midw_fi_tcl_SXMPresetListEntry()
:ServiceID(0)
,ChannelID(0)
,ChannelNameAvail(0)
,ChannelName()
,ChannelActive(0)
,ChnGraphicAvail()
,IsSmartFavorite(0)
,IsLocked(0)
,IsAvailable(0)
,IsMature(0)
,IsSkipped(0)
 {}

tS32 midw_fi_tcl_SXMPresetListEntry::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SXMPRESETLISTENTRY;
}


midw_fi_tcl_SXMPresetListEntry::~midw_fi_tcl_SXMPresetListEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SXMPresetListEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+ChannelName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_SXMPresetListEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ChannelID);
   (tVoid) (oIn >> ChannelNameAvail);
   (tVoid) (oIn >> ChannelName);
   (tVoid) (oIn >> ChannelActive);
   (tVoid) (oIn >> ChnGraphicAvail);
   (tVoid) (oIn >> IsSmartFavorite);
   (tVoid) (oIn >> IsLocked);
   (tVoid) (oIn >> IsAvailable);
   (tVoid) (oIn >> IsMature);
   (tVoid) (oIn >> IsSkipped);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SXMPresetListEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ChannelID);
   (tVoid) (oOut << ChannelNameAvail);
   (tVoid) (oOut << ChannelName);
   (tVoid) (oOut << ChannelActive);
   (tVoid) (oOut << ChnGraphicAvail);
   (tVoid) (oOut << IsSmartFavorite);
   (tVoid) (oOut << IsLocked);
   (tVoid) (oOut << IsAvailable);
   (tVoid) (oOut << IsMature);
   (tVoid) (oOut << IsSkipped);
   return oOut;
}

tBool midw_fi_tcl_SXMPresetListEntry::operator==(const midw_fi_tcl_SXMPresetListEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ChannelID == roRef.ChannelID);
   bResult = bResult && (ChannelNameAvail == roRef.ChannelNameAvail);
   bResult = bResult && (ChannelName == roRef.ChannelName);
   bResult = bResult && (ChannelActive == roRef.ChannelActive);
   bResult = bResult && (ChnGraphicAvail == roRef.ChnGraphicAvail);
   bResult = bResult && (IsSmartFavorite == roRef.IsSmartFavorite);
   bResult = bResult && (IsLocked == roRef.IsLocked);
   bResult = bResult && (IsAvailable == roRef.IsAvailable);
   bResult = bResult && (IsMature == roRef.IsMature);
   bResult = bResult && (IsSkipped == roRef.IsSkipped);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunMst_RadioType::midw_fi_tcl_e8_TunMst_RadioType():enType(FI_EN_RADIOTYPE_NONE) {}

tS32 midw_fi_tcl_e8_TunMst_RadioType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNMST_RADIOTYPE;
}


midw_fi_tcl_e8_TunMst_RadioType::~midw_fi_tcl_e8_TunMst_RadioType()
{}

tU32 midw_fi_tcl_e8_TunMst_RadioType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunMst_RadioType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunMst_RadioType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DAB_Label::midw_fi_tcl_DAB_Label(const midw_fi_tcl_DAB_Label& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   sLabel = coRef.sLabel;
   sLabelShort = coRef.sLabelShort;
   u16LabelMask = coRef.u16LabelMask;
}
midw_fi_tcl_DAB_Label& midw_fi_tcl_DAB_Label::operator=(const midw_fi_tcl_DAB_Label& coRef)
{
   if (this == &coRef) return *this;
   sLabel = coRef.sLabel;
   sLabelShort = coRef.sLabelShort;
   u16LabelMask = coRef.u16LabelMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DAB_Label::vDestroy()
{
   sLabel.vDestroy();
   sLabelShort.vDestroy();
}

midw_fi_tcl_DAB_Label::midw_fi_tcl_DAB_Label()
:sLabel()
,sLabelShort()
,u16LabelMask(0)
 {}

tS32 midw_fi_tcl_DAB_Label::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DAB_LABEL;
}


midw_fi_tcl_DAB_Label::~midw_fi_tcl_DAB_Label()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DAB_Label::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sLabel.u32GetSize(u16MajorVersion)+sLabelShort.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DAB_Label::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sLabel);
   (tVoid) (oIn >> sLabelShort);
   (tVoid) (oIn >> u16LabelMask);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DAB_Label::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sLabel);
   (tVoid) (oOut << sLabelShort);
   (tVoid) (oOut << u16LabelMask);
   return oOut;
}

tBool midw_fi_tcl_DAB_Label::operator==(const midw_fi_tcl_DAB_Label& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sLabel == roRef.sLabel);
   bResult = bResult && (sLabelShort == roRef.sLabelShort);
   bResult = bResult && (u16LabelMask == roRef.u16LabelMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_RadioProfileSettingAction::midw_fi_tcl_b8_RadioProfileSettingAction():u8Value(0)
{}

tS32 midw_fi_tcl_b8_RadioProfileSettingAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_RADIOPROFILESETTINGACTION;
}


midw_fi_tcl_b8_RadioProfileSettingAction::~midw_fi_tcl_b8_RadioProfileSettingAction()
{}

tU32 midw_fi_tcl_b8_RadioProfileSettingAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_RadioProfileSettingAction::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_RadioProfileSettingAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunMst_PresetListElement::midw_fi_tcl_TunMst_PresetListElement(const midw_fi_tcl_TunMst_PresetListElement& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8RadioType = coRef.e8RadioType;
   u8PresetNumber = coRef.u8PresetNumber;
   u32Frequency = coRef.u32Frequency;
   u32SID = coRef.u32SID;
   sStationName = coRef.sStationName;
   u32TextEncoding = coRef.u32TextEncoding;
   u8ProgramNumber = coRef.u8ProgramNumber;
   u32EnsembleId = coRef.u32EnsembleId;
   ComponentLabel = coRef.ComponentLabel;
   u32ComponentLabelEncoding = coRef.u32ComponentLabelEncoding;
}
midw_fi_tcl_TunMst_PresetListElement& midw_fi_tcl_TunMst_PresetListElement::operator=(const midw_fi_tcl_TunMst_PresetListElement& coRef)
{
   if (this == &coRef) return *this;
   e8RadioType = coRef.e8RadioType;
   u8PresetNumber = coRef.u8PresetNumber;
   u32Frequency = coRef.u32Frequency;
   u32SID = coRef.u32SID;
   sStationName = coRef.sStationName;
   u32TextEncoding = coRef.u32TextEncoding;
   u8ProgramNumber = coRef.u8ProgramNumber;
   u32EnsembleId = coRef.u32EnsembleId;
   ComponentLabel = coRef.ComponentLabel;
   u32ComponentLabelEncoding = coRef.u32ComponentLabelEncoding;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunMst_PresetListElement::vDestroy()
{
   sStationName.vDestroy();
   ComponentLabel.vDestroy();
}

midw_fi_tcl_TunMst_PresetListElement::midw_fi_tcl_TunMst_PresetListElement()
:e8RadioType()
,u8PresetNumber(0)
,u32Frequency(0)
,u32SID(0)
,sStationName()
,u32TextEncoding(0)
,u8ProgramNumber(0)
,u32EnsembleId(0)
,ComponentLabel()
,u32ComponentLabelEncoding(0)
 {}

tS32 midw_fi_tcl_TunMst_PresetListElement::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNMST_PRESETLISTELEMENT;
}


midw_fi_tcl_TunMst_PresetListElement::~midw_fi_tcl_TunMst_PresetListElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunMst_PresetListElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 23+sStationName.u32GetSize(u16MajorVersion)+ComponentLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunMst_PresetListElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RadioType);
   (tVoid) (oIn >> u8PresetNumber);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u32SID);
   (tVoid) (oIn >> sStationName);
   (tVoid) (oIn >> u32TextEncoding);
   (tVoid) (oIn >> u8ProgramNumber);
   (tVoid) (oIn >> u32EnsembleId);
   (tVoid) (oIn >> ComponentLabel);
   (tVoid) (oIn >> u32ComponentLabelEncoding);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunMst_PresetListElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RadioType);
   (tVoid) (oOut << u8PresetNumber);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u32SID);
   (tVoid) (oOut << sStationName);
   (tVoid) (oOut << u32TextEncoding);
   (tVoid) (oOut << u8ProgramNumber);
   (tVoid) (oOut << u32EnsembleId);
   (tVoid) (oOut << ComponentLabel);
   (tVoid) (oOut << u32ComponentLabelEncoding);
   return oOut;
}

tBool midw_fi_tcl_TunMst_PresetListElement::operator==(const midw_fi_tcl_TunMst_PresetListElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RadioType == roRef.e8RadioType);
   bResult = bResult && (u8PresetNumber == roRef.u8PresetNumber);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u32SID == roRef.u32SID);
   bResult = bResult && (sStationName == roRef.sStationName);
   bResult = bResult && (u32TextEncoding == roRef.u32TextEncoding);
   bResult = bResult && (u8ProgramNumber == roRef.u8ProgramNumber);
   bResult = bResult && (u32EnsembleId == roRef.u32EnsembleId);
   bResult = bResult && (ComponentLabel == roRef.ComponentLabel);
   bResult = bResult && (u32ComponentLabelEncoding == roRef.u32ComponentLabelEncoding);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TunerErrorType::midw_fi_tcl_e8_TunerErrorType():enType(FI_EN_MESSAGENOTSUPPORTED) {}

tS32 midw_fi_tcl_e8_TunerErrorType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUNERERRORTYPE;
}


midw_fi_tcl_e8_TunerErrorType::~midw_fi_tcl_e8_TunerErrorType()
{}

tU32 midw_fi_tcl_e8_TunerErrorType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TunerErrorType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TunerErrorType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8SXMChannelArtErrorTypes::midw_fi_tcl_e8SXMChannelArtErrorTypes():enType(FI_EN_CHANNELART_SERVICE_ERROR) {}

tS32 midw_fi_tcl_e8SXMChannelArtErrorTypes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8SXMCHANNELARTERRORTYPES;
}


midw_fi_tcl_e8SXMChannelArtErrorTypes::~midw_fi_tcl_e8SXMChannelArtErrorTypes()
{}

tU32 midw_fi_tcl_e8SXMChannelArtErrorTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8SXMChannelArtErrorTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8SXMChannelArtErrorTypes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_PresetList::midw_fi_tcl_PresetList(const midw_fi_tcl_PresetList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   List = coRef.List;
   Band = coRef.Band;
   Element_ID = coRef.Element_ID;
   Frequency = coRef.Frequency;
   PSName = coRef.PSName;
   u8TpTmcInfo = coRef.u8TpTmcInfo;
   PTY = coRef.PTY;
   EnsembleName = coRef.EnsembleName;
   Frequency_Label = coRef.Frequency_Label;
   StationLogo = coRef.StationLogo;
   u32HDStationId = coRef.u32HDStationId;
   sHDCallSign = coRef.sHDCallSign;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   e8Modulation = coRef.e8Modulation;
   u32HDStationId_DRMServiceId = coRef.u32HDStationId_DRMServiceId;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   sHDCallSign_DRMServiceLabel = coRef.sHDCallSign_DRMServiceLabel;
   u8HDStationGenre_DRMPty = coRef.u8HDStationGenre_DRMPty;
   u8HDAudioProgram_DRMShortID = coRef.u8HDAudioProgram_DRMShortID;
   SXMSMSlib_PresetListEntry = coRef.SXMSMSlib_PresetListEntry;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   SXM360L_PresetListEntry = coRef.SXM360L_PresetListEntry;
}
midw_fi_tcl_PresetList& midw_fi_tcl_PresetList::operator=(const midw_fi_tcl_PresetList& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   Band = coRef.Band;
   Element_ID = coRef.Element_ID;
   Frequency = coRef.Frequency;
   PSName = coRef.PSName;
   u8TpTmcInfo = coRef.u8TpTmcInfo;
   PTY = coRef.PTY;
   EnsembleName = coRef.EnsembleName;
   Frequency_Label = coRef.Frequency_Label;
   StationLogo = coRef.StationLogo;
   u32HDStationId = coRef.u32HDStationId;
   sHDCallSign = coRef.sHDCallSign;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   u32DRMServiceId = coRef.u32DRMServiceId;
   sDRMServiceLabel = coRef.sDRMServiceLabel;
   u8DRMServiceShortId = coRef.u8DRMServiceShortId;
   e8Modulation = coRef.e8Modulation;
   u32HDStationId_DRMServiceId = coRef.u32HDStationId_DRMServiceId;
   e8HDTextEncoding = coRef.e8HDTextEncoding;
   sHDCallSign_DRMServiceLabel = coRef.sHDCallSign_DRMServiceLabel;
   u8HDStationGenre_DRMPty = coRef.u8HDStationGenre_DRMPty;
   u8HDAudioProgram_DRMShortID = coRef.u8HDAudioProgram_DRMShortID;
   SXMSMSlib_PresetListEntry = coRef.SXMSMSlib_PresetListEntry;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   SXM360L_PresetListEntry = coRef.SXM360L_PresetListEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_PresetList::vDestroy()
{
   PSName.vDestroy();
   EnsembleName.vDestroy();
   Frequency_Label.vDestroy();
   StationLogo.vDestroy();
   sHDCallSign.vDestroy();
   sDRMServiceLabel.vDestroy();
   sHDCallSign_DRMServiceLabel.vDestroy();
   SXMSMSlib_PresetListEntry.vDestroy(); 
   Key.vDestroy();
   SXM360L_PresetListEntry.vDestroy(); 
}

midw_fi_tcl_PresetList::midw_fi_tcl_PresetList()
:List()
,Band()
,Element_ID(0)
,Frequency(0)
,PSName()
,u8TpTmcInfo(0)
,PTY(0)
,EnsembleName()
,Frequency_Label()
,StationLogo()
,u32HDStationId(0)
,sHDCallSign()
,e8HDAudioProgram()
,u32DRMServiceId(0)
,sDRMServiceLabel()
,u8DRMServiceShortId(0)
,e8Modulation()
,u32HDStationId_DRMServiceId(0)
,e8HDTextEncoding()
,sHDCallSign_DRMServiceLabel()
,u8HDStationGenre_DRMPty(0)
,u8HDAudioProgram_DRMShortID(0)
,SXMSMSlib_PresetListEntry()
,Key()
,PresetType()
,SXM360L_PresetListEntry()
 {}

tS32 midw_fi_tcl_PresetList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PRESETLIST;
}


midw_fi_tcl_PresetList::~midw_fi_tcl_PresetList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_PresetList::u32GetSize(tU16 u16MajorVersion) const
{
   return 31+PSName.u32GetSize(u16MajorVersion)+EnsembleName.u32GetSize(u16MajorVersion)+Frequency_Label.u32GetSize(u16MajorVersion)+StationLogo.u32GetSize(u16MajorVersion)+sHDCallSign.u32GetSize(u16MajorVersion)+sDRMServiceLabel.u32GetSize(u16MajorVersion)+sHDCallSign_DRMServiceLabel.u32GetSize(u16MajorVersion)+SXMSMSlib_PresetListEntry.u32GetSize(u16MajorVersion)+Key.u32GetSize(u16MajorVersion)+SXM360L_PresetListEntry.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_PresetList::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> Element_ID);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> PSName);
   (tVoid) (oIn >> u8TpTmcInfo);
   (tVoid) (oIn >> PTY);
   (tVoid) (oIn >> EnsembleName);
   (tVoid) (oIn >> Frequency_Label);
   (tVoid) (oIn >> StationLogo);
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> sHDCallSign);
   (tVoid) (oIn >> e8HDAudioProgram);
   (tVoid) (oIn >> u32DRMServiceId);
   (tVoid) (oIn >> sDRMServiceLabel);
   (tVoid) (oIn >> u8DRMServiceShortId);
   (tVoid) (oIn >> e8Modulation);
   (tVoid) (oIn >> u32HDStationId_DRMServiceId);
   (tVoid) (oIn >> e8HDTextEncoding);
   (tVoid) (oIn >> sHDCallSign_DRMServiceLabel);
   (tVoid) (oIn >> u8HDStationGenre_DRMPty);
   (tVoid) (oIn >> u8HDAudioProgram_DRMShortID);
   (tVoid) (oIn >> SXMSMSlib_PresetListEntry);
   (tVoid) (oIn >> Key);
   (tVoid) (oIn >> PresetType);
   (tVoid) (oIn >> SXM360L_PresetListEntry);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_PresetList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << Element_ID);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << PSName);
   (tVoid) (oOut << u8TpTmcInfo);
   (tVoid) (oOut << PTY);
   (tVoid) (oOut << EnsembleName);
   (tVoid) (oOut << Frequency_Label);
   (tVoid) (oOut << StationLogo);
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << sHDCallSign);
   (tVoid) (oOut << e8HDAudioProgram);
   (tVoid) (oOut << u32DRMServiceId);
   (tVoid) (oOut << sDRMServiceLabel);
   (tVoid) (oOut << u8DRMServiceShortId);
   (tVoid) (oOut << e8Modulation);
   (tVoid) (oOut << u32HDStationId_DRMServiceId);
   (tVoid) (oOut << e8HDTextEncoding);
   (tVoid) (oOut << sHDCallSign_DRMServiceLabel);
   (tVoid) (oOut << u8HDStationGenre_DRMPty);
   (tVoid) (oOut << u8HDAudioProgram_DRMShortID);
   (tVoid) (oOut << SXMSMSlib_PresetListEntry);
   (tVoid) (oOut << Key);
   (tVoid) (oOut << PresetType);
   (tVoid) (oOut << SXM360L_PresetListEntry);
   return oOut;
}

tBool midw_fi_tcl_PresetList::operator==(const midw_fi_tcl_PresetList& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (Element_ID == roRef.Element_ID);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (PSName == roRef.PSName);
   bResult = bResult && (u8TpTmcInfo == roRef.u8TpTmcInfo);
   bResult = bResult && (PTY == roRef.PTY);
   bResult = bResult && (EnsembleName == roRef.EnsembleName);
   bResult = bResult && (Frequency_Label == roRef.Frequency_Label);
   bResult = bResult && (StationLogo == roRef.StationLogo);
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (sHDCallSign == roRef.sHDCallSign);
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   bResult = bResult && (u32DRMServiceId == roRef.u32DRMServiceId);
   bResult = bResult && (sDRMServiceLabel == roRef.sDRMServiceLabel);
   bResult = bResult && (u8DRMServiceShortId == roRef.u8DRMServiceShortId);
   bResult = bResult && (e8Modulation == roRef.e8Modulation);
   bResult = bResult && (u32HDStationId_DRMServiceId == roRef.u32HDStationId_DRMServiceId);
   bResult = bResult && (e8HDTextEncoding == roRef.e8HDTextEncoding);
   bResult = bResult && (sHDCallSign_DRMServiceLabel == roRef.sHDCallSign_DRMServiceLabel);
   bResult = bResult && (u8HDStationGenre_DRMPty == roRef.u8HDStationGenre_DRMPty);
   bResult = bResult && (u8HDAudioProgram_DRMShortID == roRef.u8HDAudioProgram_DRMShortID);
   bResult = bResult && (SXMSMSlib_PresetListEntry == roRef.SXMSMSlib_PresetListEntry);
   bResult = bResult && (Key == roRef.Key);
   bResult = bResult && (PresetType == roRef.PresetType);
   bResult = bResult && (SXM360L_PresetListEntry == roRef.SXM360L_PresetListEntry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SXMPresetEntry::midw_fi_tcl_SXMPresetEntry(const midw_fi_tcl_SXMPresetEntry& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   PresetIndex = coRef.PresetIndex;
   PresetElemID = coRef.PresetElemID;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   ChannelAttributes = coRef.ChannelAttributes;
}
midw_fi_tcl_SXMPresetEntry& midw_fi_tcl_SXMPresetEntry::operator=(const midw_fi_tcl_SXMPresetEntry& coRef)
{
   if (this == &coRef) return *this;
   PresetIndex = coRef.PresetIndex;
   PresetElemID = coRef.PresetElemID;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   ChannelAttributes = coRef.ChannelAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SXMPresetEntry::vDestroy()
{
   Key.vDestroy();
   ChannelAttributes.vDestroy(); 
}

midw_fi_tcl_SXMPresetEntry::midw_fi_tcl_SXMPresetEntry()
:PresetIndex(0)
,PresetElemID(0)
,Key()
,PresetType()
,ChannelAttributes()
 {}

tS32 midw_fi_tcl_SXMPresetEntry::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SXMPRESETENTRY;
}


midw_fi_tcl_SXMPresetEntry::~midw_fi_tcl_SXMPresetEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SXMPresetEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Key.u32GetSize(u16MajorVersion)+ChannelAttributes.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_SXMPresetEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> PresetElemID);
   (tVoid) (oIn >> Key);
   (tVoid) (oIn >> PresetType);
   (tVoid) (oIn >> ChannelAttributes);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SXMPresetEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << PresetElemID);
   (tVoid) (oOut << Key);
   (tVoid) (oOut << PresetType);
   (tVoid) (oOut << ChannelAttributes);
   return oOut;
}

tBool midw_fi_tcl_SXMPresetEntry::operator==(const midw_fi_tcl_SXMPresetEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (PresetElemID == roRef.PresetElemID);
   bResult = bResult && (Key == roRef.Key);
   bResult = bResult && (PresetType == roRef.PresetType);
   bResult = bResult && (ChannelAttributes == roRef.ChannelAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SXMSystemMessage::midw_fi_tcl_e8_SXMSystemMessage():enType(FI_EN_XMTUN_SYSTEM_MSG_NO_ERROR) {}

tS32 midw_fi_tcl_e8_SXMSystemMessage::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SXMSYSTEMMESSAGE;
}


midw_fi_tcl_e8_SXMSystemMessage::~midw_fi_tcl_e8_SXMSystemMessage()
{}

tU32 midw_fi_tcl_e8_SXMSystemMessage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SXMSystemMessage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SXMSystemMessage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProfileStatus::midw_fi_tcl_ProfileStatus():enType(FI_EN_IDLE) {}

tS32 midw_fi_tcl_ProfileStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROFILESTATUS;
}


midw_fi_tcl_ProfileStatus::~midw_fi_tcl_ProfileStatus()
{}

tU32 midw_fi_tcl_ProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_ProfileStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProfileAction::midw_fi_tcl_ProfileAction():enType(FI_EN_ACTIVEPROFILE) {}

tS32 midw_fi_tcl_ProfileAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROFILEACTION;
}


midw_fi_tcl_ProfileAction::~midw_fi_tcl_ProfileAction()
{}

tU32 midw_fi_tcl_ProfileAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_ProfileAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProfileAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProfileActionStatus::midw_fi_tcl_ProfileActionStatus():enType(FI_EN_FAILED) {}

tS32 midw_fi_tcl_ProfileActionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROFILEACTIONSTATUS;
}


midw_fi_tcl_ProfileActionStatus::~midw_fi_tcl_ProfileActionStatus()
{}

tU32 midw_fi_tcl_ProfileActionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_ProfileActionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProfileActionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ProfileResponse::midw_fi_tcl_ProfileResponse(const midw_fi_tcl_ProfileResponse& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
}
midw_fi_tcl_ProfileResponse& midw_fi_tcl_ProfileResponse::operator=(const midw_fi_tcl_ProfileResponse& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProfileResponse::midw_fi_tcl_ProfileResponse()
:Status()
,ProfileAction()
,ProfileStatus()
 {}

tS32 midw_fi_tcl_ProfileResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROFILERESPONSE;
}


midw_fi_tcl_ProfileResponse::~midw_fi_tcl_ProfileResponse()
{}

tU32 midw_fi_tcl_ProfileResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_ProfileResponse::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> ProfileAction);
   (tVoid) (oIn >> ProfileStatus);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProfileResponse::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << ProfileAction);
   (tVoid) (oOut << ProfileStatus);
   return oOut;
}

tBool midw_fi_tcl_ProfileResponse::operator==(const midw_fi_tcl_ProfileResponse& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (ProfileAction == roRef.ProfileAction);
   bResult = bResult && (ProfileStatus == roRef.ProfileStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_RequestResult::midw_fi_tcl_e8_Tun_RequestResult():enType(FI_EN_TUN_REQUEST_REJECTED) {}

tS32 midw_fi_tcl_e8_Tun_RequestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_REQUESTRESULT;
}


midw_fi_tcl_e8_Tun_RequestResult::~midw_fi_tcl_e8_Tun_RequestResult()
{}

tU32 midw_fi_tcl_e8_Tun_RequestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_RequestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_RequestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AlignCalibrate::midw_fi_tcl_e8_Tun_AlignCalibrate():enType(FI_EN_TUN_INVALID_STEP) {}

tS32 midw_fi_tcl_e8_Tun_AlignCalibrate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ALIGNCALIBRATE;
}


midw_fi_tcl_e8_Tun_AlignCalibrate::~midw_fi_tcl_e8_Tun_AlignCalibrate()
{}

tU32 midw_fi_tcl_e8_Tun_AlignCalibrate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AlignCalibrate::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AlignCalibrate::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_AlignCalibrateStatus::midw_fi_tcl_e8_Tun_AlignCalibrateStatus():enType(FI_EN_TUN_ALIGN_CALIBRATE_NOT_SUCCESS) {}

tS32 midw_fi_tcl_e8_Tun_AlignCalibrateStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_ALIGNCALIBRATESTATUS;
}


midw_fi_tcl_e8_Tun_AlignCalibrateStatus::~midw_fi_tcl_e8_Tun_AlignCalibrateStatus()
{}

tU32 midw_fi_tcl_e8_Tun_AlignCalibrateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_AlignCalibrateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_AlignCalibrateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_IFOutput::midw_fi_tcl_e8_Tun_IFOutput():enType(FI_EN_TUN_IF_OUTPUT_OK) {}

tS32 midw_fi_tcl_e8_Tun_IFOutput::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_IFOUTPUT;
}


midw_fi_tcl_e8_Tun_IFOutput::~midw_fi_tcl_e8_Tun_IFOutput()
{}

tU32 midw_fi_tcl_e8_Tun_IFOutput::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_IFOutput::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_IFOutput::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_IFOutput::midw_fi_tcl_Tun_IFOutput(const midw_fi_tcl_Tun_IFOutput& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8IFResult = coRef.u8IFResult;
}
midw_fi_tcl_Tun_IFOutput& midw_fi_tcl_Tun_IFOutput::operator=(const midw_fi_tcl_Tun_IFOutput& coRef)
{
   if (this == &coRef) return *this;
   u8IFResult = coRef.u8IFResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_IFOutput::midw_fi_tcl_Tun_IFOutput()
:u8IFResult()
 {}

tS32 midw_fi_tcl_Tun_IFOutput::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_IFOUTPUT;
}


midw_fi_tcl_Tun_IFOutput::~midw_fi_tcl_Tun_IFOutput()
{}

tU32 midw_fi_tcl_Tun_IFOutput::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_Tun_IFOutput::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8IFResult);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_IFOutput::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8IFResult);
   return oOut;
}

tBool midw_fi_tcl_Tun_IFOutput::operator==(const midw_fi_tcl_Tun_IFOutput& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8IFResult == roRef.u8IFResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_RFAntenna::midw_fi_tcl_e8_Tun_RFAntenna():enType(FI_EN_TUN_RF_ANTENNA_OK) {}

tS32 midw_fi_tcl_e8_Tun_RFAntenna::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_RFANTENNA;
}


midw_fi_tcl_e8_Tun_RFAntenna::~midw_fi_tcl_e8_Tun_RFAntenna()
{}

tU32 midw_fi_tcl_e8_Tun_RFAntenna::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_RFAntenna::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_RFAntenna::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ATMResult::midw_fi_tcl_e8_ATMResult():enType(FI_EN_TUN_ATM_OK) {}

tS32 midw_fi_tcl_e8_ATMResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ATMRESULT;
}


midw_fi_tcl_e8_ATMResult::~midw_fi_tcl_e8_ATMResult()
{}

tU32 midw_fi_tcl_e8_ATMResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ATMResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ATMResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_u8Result::midw_fi_tcl_u8Result(const midw_fi_tcl_u8Result& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8DataLength = coRef.u8DataLength;
   GenericBytes = coRef.GenericBytes;
}
midw_fi_tcl_u8Result& midw_fi_tcl_u8Result::operator=(const midw_fi_tcl_u8Result& coRef)
{
   if (this == &coRef) return *this;
   u8DataLength = coRef.u8DataLength;
   GenericBytes = coRef.GenericBytes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_u8Result::vDestroy()
{
   {
   GenericBytes.clear();
   }
}

midw_fi_tcl_u8Result::midw_fi_tcl_u8Result()
:u8DataLength(0)

 {}

tS32 midw_fi_tcl_u8Result::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8RESULT;
}


midw_fi_tcl_u8Result::~midw_fi_tcl_u8Result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_u8Result::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(GenericBytes.size()*1);
}

fi_tclInContext& midw_fi_tcl_u8Result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataLength);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      GenericBytes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GenericBytes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u8Result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataLength);
   (tVoid) (oOut << (tU32)GenericBytes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GenericBytes.size(); ++u32Idx)
         (tVoid) (oOut << GenericBytes[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_u8Result::operator==(const midw_fi_tcl_u8Result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataLength == roRef.u8DataLength);
      bResult = bResult && (GenericBytes.size() == roRef.GenericBytes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GenericBytes.size()); ++u32Idx)
            bResult = bResult && (GenericBytes[u32Idx] == roRef.GenericBytes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ANTENNA_TEST::midw_fi_tcl_e8_ANTENNA_TEST():enType(FI_EN_PHANTOM_ANTENNA) {}

tS32 midw_fi_tcl_e8_ANTENNA_TEST::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ANTENNA_TEST;
}


midw_fi_tcl_e8_ANTENNA_TEST::~midw_fi_tcl_e8_ANTENNA_TEST()
{}

tU32 midw_fi_tcl_e8_ANTENNA_TEST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ANTENNA_TEST::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ANTENNA_TEST::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_RFAntenna::midw_fi_tcl_Tun_RFAntenna(const midw_fi_tcl_Tun_RFAntenna& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ANTENNA_TEST = coRef.ANTENNA_TEST;
   RFAntennaStatus = coRef.RFAntennaStatus;
   ConnectionCurrent = coRef.ConnectionCurrent;
}
midw_fi_tcl_Tun_RFAntenna& midw_fi_tcl_Tun_RFAntenna::operator=(const midw_fi_tcl_Tun_RFAntenna& coRef)
{
   if (this == &coRef) return *this;
   ANTENNA_TEST = coRef.ANTENNA_TEST;
   RFAntennaStatus = coRef.RFAntennaStatus;
   ConnectionCurrent = coRef.ConnectionCurrent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Tun_RFAntenna::midw_fi_tcl_Tun_RFAntenna()
:ANTENNA_TEST()
,RFAntennaStatus()
,ConnectionCurrent(0)
 {}

tS32 midw_fi_tcl_Tun_RFAntenna::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_RFANTENNA;
}


midw_fi_tcl_Tun_RFAntenna::~midw_fi_tcl_Tun_RFAntenna()
{}

tU32 midw_fi_tcl_Tun_RFAntenna::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_Tun_RFAntenna::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ANTENNA_TEST);
   (tVoid) (oIn >> RFAntennaStatus);
   (tVoid) (oIn >> ConnectionCurrent);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_RFAntenna::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ANTENNA_TEST);
   (tVoid) (oOut << RFAntennaStatus);
   (tVoid) (oOut << ConnectionCurrent);
   return oOut;
}

tBool midw_fi_tcl_Tun_RFAntenna::operator==(const midw_fi_tcl_Tun_RFAntenna& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ANTENNA_TEST == roRef.ANTENNA_TEST);
   bResult = bResult && (RFAntennaStatus == roRef.RFAntennaStatus);
   bResult = bResult && (ConnectionCurrent == roRef.ConnectionCurrent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TMCInfo::midw_fi_tcl_e8_Tun_TMCInfo():enType(FI_EN_TUN_NOT_USED1) {}

tS32 midw_fi_tcl_e8_Tun_TMCInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TMCINFO;
}


midw_fi_tcl_e8_Tun_TMCInfo::~midw_fi_tcl_e8_Tun_TMCInfo()
{}

tU32 midw_fi_tcl_e8_Tun_TMCInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TMCInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TMCInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TPInfo::midw_fi_tcl_e8_Tun_TPInfo():enType(FI_EN_TUN_TP_UNDECODED) {}

tS32 midw_fi_tcl_e8_Tun_TPInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TPINFO;
}


midw_fi_tcl_e8_Tun_TPInfo::~midw_fi_tcl_e8_Tun_TPInfo()
{}

tU32 midw_fi_tcl_e8_Tun_TPInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TPInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TPInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_TA::midw_fi_tcl_e8_Tun_TA():enType(FI_EN_TUN_TA_INACTIVE) {}

tS32 midw_fi_tcl_e8_Tun_TA::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_TA;
}


midw_fi_tcl_e8_Tun_TA::~midw_fi_tcl_e8_Tun_TA()
{}

tU32 midw_fi_tcl_e8_Tun_TA::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_TA::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_TA::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_PI::midw_fi_tcl_e8_Tun_PI():enType(FI_EN_TUN_PI_NOTAVAILABLE) {}

tS32 midw_fi_tcl_e8_Tun_PI::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_PI;
}


midw_fi_tcl_e8_Tun_PI::~midw_fi_tcl_e8_Tun_PI()
{}

tU32 midw_fi_tcl_e8_Tun_PI::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_PI::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_PI::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_ProgramKind::midw_fi_tcl_e8_Tun_ProgramKind():enType(FI_EN_SPEECH) {}

tS32 midw_fi_tcl_e8_Tun_ProgramKind::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_PROGRAMKIND;
}


midw_fi_tcl_e8_Tun_ProgramKind::~midw_fi_tcl_e8_Tun_ProgramKind()
{}

tU32 midw_fi_tcl_e8_Tun_ProgramKind::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_ProgramKind::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_ProgramKind::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_EON::midw_fi_tcl_e8_Tun_EON():enType(FI_EN_TUN_EON_NOTAVAILABLE) {}

tS32 midw_fi_tcl_e8_Tun_EON::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_EON;
}


midw_fi_tcl_e8_Tun_EON::~midw_fi_tcl_e8_Tun_EON()
{}

tU32 midw_fi_tcl_e8_Tun_EON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_EON::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_EON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Tun_PTY::midw_fi_tcl_e8_Tun_PTY():enType(FI_EN_TUN_PTY_INVALID) {}

tS32 midw_fi_tcl_e8_Tun_PTY::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TUN_PTY;
}


midw_fi_tcl_e8_Tun_PTY::~midw_fi_tcl_e8_Tun_PTY()
{}

tU32 midw_fi_tcl_e8_Tun_PTY::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Tun_PTY::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Tun_PTY::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_TunerFeatureData::midw_fi_tcl_b32_TunerFeatureData():u32Value(0)
{}

tS32 midw_fi_tcl_b32_TunerFeatureData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_TUNERFEATUREDATA;
}


midw_fi_tcl_b32_TunerFeatureData::~midw_fi_tcl_b32_TunerFeatureData()
{}

tU32 midw_fi_tcl_b32_TunerFeatureData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_TunerFeatureData::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_TunerFeatureData::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_Tun_DiagMode::midw_fi_tcl_b8_Tun_DiagMode():u8Value(0)
{}

tS32 midw_fi_tcl_b8_Tun_DiagMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_TUN_DIAGMODE;
}


midw_fi_tcl_b8_Tun_DiagMode::~midw_fi_tcl_b8_Tun_DiagMode()
{}

tU32 midw_fi_tcl_b8_Tun_DiagMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_Tun_DiagMode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_Tun_DiagMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_AlignCalibrateParameterList::midw_fi_tcl_Tun_AlignCalibrateParameterList(const midw_fi_tcl_Tun_AlignCalibrateParameterList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerAlignCalibrateParameter = coRef.TunerAlignCalibrateParameter;
}
midw_fi_tcl_Tun_AlignCalibrateParameterList& midw_fi_tcl_Tun_AlignCalibrateParameterList::operator=(const midw_fi_tcl_Tun_AlignCalibrateParameterList& coRef)
{
   if (this == &coRef) return *this;
   TunerAlignCalibrateParameter = coRef.TunerAlignCalibrateParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Tun_AlignCalibrateParameterList::vDestroy()
{
   {
   TunerAlignCalibrateParameter.clear();
   }
}

midw_fi_tcl_Tun_AlignCalibrateParameterList::midw_fi_tcl_Tun_AlignCalibrateParameterList()

 {}

tS32 midw_fi_tcl_Tun_AlignCalibrateParameterList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_ALIGNCALIBRATEPARAMETERLIST;
}


midw_fi_tcl_Tun_AlignCalibrateParameterList::~midw_fi_tcl_Tun_AlignCalibrateParameterList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Tun_AlignCalibrateParameterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TunerAlignCalibrateParameter.size()*2);
}

fi_tclInContext& midw_fi_tcl_Tun_AlignCalibrateParameterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TunerAlignCalibrateParameter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerAlignCalibrateParameter[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_AlignCalibrateParameterList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunerAlignCalibrateParameter.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerAlignCalibrateParameter.size(); ++u32Idx)
         (tVoid) (oOut << TunerAlignCalibrateParameter[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Tun_AlignCalibrateParameterList::operator==(const midw_fi_tcl_Tun_AlignCalibrateParameterList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunerAlignCalibrateParameter.size() == roRef.TunerAlignCalibrateParameter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerAlignCalibrateParameter.size()); ++u32Idx)
            bResult = bResult && (TunerAlignCalibrateParameter[u32Idx] == roRef.TunerAlignCalibrateParameter[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerDiagMode::midw_fi_tcl_TunerDiagMode(const midw_fi_tcl_TunerDiagMode& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   b8DiagModeFeature = coRef.b8DiagModeFeature;
   b8DiagModeMask = coRef.b8DiagModeMask;
}
midw_fi_tcl_TunerDiagMode& midw_fi_tcl_TunerDiagMode::operator=(const midw_fi_tcl_TunerDiagMode& coRef)
{
   if (this == &coRef) return *this;
   b8DiagModeFeature = coRef.b8DiagModeFeature;
   b8DiagModeMask = coRef.b8DiagModeMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerDiagMode::midw_fi_tcl_TunerDiagMode()
:b8DiagModeFeature()
,b8DiagModeMask()
 {}

tS32 midw_fi_tcl_TunerDiagMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERDIAGMODE;
}


midw_fi_tcl_TunerDiagMode::~midw_fi_tcl_TunerDiagMode()
{}

tU32 midw_fi_tcl_TunerDiagMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_TunerDiagMode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8DiagModeFeature);
   (tVoid) (oIn >> b8DiagModeMask);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerDiagMode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8DiagModeFeature);
   (tVoid) (oOut << b8DiagModeMask);
   return oOut;
}

tBool midw_fi_tcl_TunerDiagMode::operator==(const midw_fi_tcl_TunerDiagMode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8DiagModeFeature == roRef.b8DiagModeFeature);
   bResult = bResult && (b8DiagModeMask == roRef.b8DiagModeMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Tun_ProgramInfo::midw_fi_tcl_Tun_ProgramInfo(const midw_fi_tcl_Tun_ProgramInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunerTypeInfo = coRef.TunerTypeInfo;
   TMCInfo = coRef.TMCInfo;
   TrafficAlarmInfo = coRef.TrafficAlarmInfo;
   TunerPIInfo = coRef.TunerPIInfo;
   ProgramID = coRef.ProgramID;
   sTunPSName = coRef.sTunPSName;
   TunPTY = coRef.TunPTY;
   TunProgramKind = coRef.TunProgramKind;
   TunTPInfo = coRef.TunTPInfo;
   TunEONInfo = coRef.TunEONInfo;
}
midw_fi_tcl_Tun_ProgramInfo& midw_fi_tcl_Tun_ProgramInfo::operator=(const midw_fi_tcl_Tun_ProgramInfo& coRef)
{
   if (this == &coRef) return *this;
   TunerTypeInfo = coRef.TunerTypeInfo;
   TMCInfo = coRef.TMCInfo;
   TrafficAlarmInfo = coRef.TrafficAlarmInfo;
   TunerPIInfo = coRef.TunerPIInfo;
   ProgramID = coRef.ProgramID;
   sTunPSName = coRef.sTunPSName;
   TunPTY = coRef.TunPTY;
   TunProgramKind = coRef.TunProgramKind;
   TunTPInfo = coRef.TunTPInfo;
   TunEONInfo = coRef.TunEONInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Tun_ProgramInfo::vDestroy()
{
   sTunPSName.vDestroy();
}

midw_fi_tcl_Tun_ProgramInfo::midw_fi_tcl_Tun_ProgramInfo()
:TunerTypeInfo()
,TMCInfo()
,TrafficAlarmInfo()
,TunerPIInfo()
,ProgramID(0)
,sTunPSName()
,TunPTY()
,TunProgramKind()
,TunTPInfo()
,TunEONInfo()
 {}

tS32 midw_fi_tcl_Tun_ProgramInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUN_PROGRAMINFO;
}


midw_fi_tcl_Tun_ProgramInfo::~midw_fi_tcl_Tun_ProgramInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Tun_ProgramInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+sTunPSName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_Tun_ProgramInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerTypeInfo);
   (tVoid) (oIn >> TMCInfo);
   (tVoid) (oIn >> TrafficAlarmInfo);
   (tVoid) (oIn >> TunerPIInfo);
   (tVoid) (oIn >> ProgramID);
   (tVoid) (oIn >> sTunPSName);
   (tVoid) (oIn >> TunPTY);
   (tVoid) (oIn >> TunProgramKind);
   (tVoid) (oIn >> TunTPInfo);
   (tVoid) (oIn >> TunEONInfo);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Tun_ProgramInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerTypeInfo);
   (tVoid) (oOut << TMCInfo);
   (tVoid) (oOut << TrafficAlarmInfo);
   (tVoid) (oOut << TunerPIInfo);
   (tVoid) (oOut << ProgramID);
   (tVoid) (oOut << sTunPSName);
   (tVoid) (oOut << TunPTY);
   (tVoid) (oOut << TunProgramKind);
   (tVoid) (oOut << TunTPInfo);
   (tVoid) (oOut << TunEONInfo);
   return oOut;
}

tBool midw_fi_tcl_Tun_ProgramInfo::operator==(const midw_fi_tcl_Tun_ProgramInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerTypeInfo == roRef.TunerTypeInfo);
   bResult = bResult && (TMCInfo == roRef.TMCInfo);
   bResult = bResult && (TrafficAlarmInfo == roRef.TrafficAlarmInfo);
   bResult = bResult && (TunerPIInfo == roRef.TunerPIInfo);
   bResult = bResult && (ProgramID == roRef.ProgramID);
   bResult = bResult && (sTunPSName == roRef.sTunPSName);
   bResult = bResult && (TunPTY == roRef.TunPTY);
   bResult = bResult && (TunProgramKind == roRef.TunProgramKind);
   bResult = bResult && (TunTPInfo == roRef.TunTPInfo);
   bResult = bResult && (TunEONInfo == roRef.TunEONInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerBandFrq::midw_fi_tcl_TunerBandFrq(const midw_fi_tcl_TunerBandFrq& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SourceSwitch = coRef.SourceSwitch;
   TunedBand = coRef.TunedBand;
   u32Frequency = coRef.u32Frequency;
}
midw_fi_tcl_TunerBandFrq& midw_fi_tcl_TunerBandFrq::operator=(const midw_fi_tcl_TunerBandFrq& coRef)
{
   if (this == &coRef) return *this;
   SourceSwitch = coRef.SourceSwitch;
   TunedBand = coRef.TunedBand;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TunerBandFrq::midw_fi_tcl_TunerBandFrq()
:SourceSwitch()
,TunedBand()
,u32Frequency(0)
 {}

tS32 midw_fi_tcl_TunerBandFrq::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERBANDFRQ;
}


midw_fi_tcl_TunerBandFrq::~midw_fi_tcl_TunerBandFrq()
{}

tU32 midw_fi_tcl_TunerBandFrq::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_fi_tcl_TunerBandFrq::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceSwitch);
   (tVoid) (oIn >> TunedBand);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerBandFrq::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceSwitch);
   (tVoid) (oOut << TunedBand);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_fi_tcl_TunerBandFrq::operator==(const midw_fi_tcl_TunerBandFrq& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceSwitch == roRef.SourceSwitch);
   bResult = bResult && (TunedBand == roRef.TunedBand);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TunerAlignCalibrate::midw_fi_tcl_TunerAlignCalibrate(const midw_fi_tcl_TunerAlignCalibrate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TunAlignCal = coRef.TunAlignCal;
   TunAlignCalStatus = coRef.TunAlignCalStatus;
   TunAlignCalParameters = coRef.TunAlignCalParameters;
}
midw_fi_tcl_TunerAlignCalibrate& midw_fi_tcl_TunerAlignCalibrate::operator=(const midw_fi_tcl_TunerAlignCalibrate& coRef)
{
   if (this == &coRef) return *this;
   TunAlignCal = coRef.TunAlignCal;
   TunAlignCalStatus = coRef.TunAlignCalStatus;
   TunAlignCalParameters = coRef.TunAlignCalParameters;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TunerAlignCalibrate::vDestroy()
{
   TunAlignCalParameters.vDestroy(); 
}

midw_fi_tcl_TunerAlignCalibrate::midw_fi_tcl_TunerAlignCalibrate()
:TunAlignCal()
,TunAlignCalStatus()
,TunAlignCalParameters()
 {}

tS32 midw_fi_tcl_TunerAlignCalibrate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TUNERALIGNCALIBRATE;
}


midw_fi_tcl_TunerAlignCalibrate::~midw_fi_tcl_TunerAlignCalibrate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TunerAlignCalibrate::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+TunAlignCalParameters.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TunerAlignCalibrate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunAlignCal);
   (tVoid) (oIn >> TunAlignCalStatus);
   (tVoid) (oIn >> TunAlignCalParameters);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TunerAlignCalibrate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunAlignCal);
   (tVoid) (oOut << TunAlignCalStatus);
   (tVoid) (oOut << TunAlignCalParameters);
   return oOut;
}

tBool midw_fi_tcl_TunerAlignCalibrate::operator==(const midw_fi_tcl_TunerAlignCalibrate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunAlignCal == roRef.TunAlignCal);
   bResult = bResult && (TunAlignCalStatus == roRef.TunAlignCalStatus);
   bResult = bResult && (TunAlignCalParameters == roRef.TunAlignCalParameters);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ApplicationState::midw_fi_tcl_e8_ApplicationState():enType(FI_EN_APP_STATE_NONE) {}

tS32 midw_fi_tcl_e8_ApplicationState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPLICATIONSTATE;
}


midw_fi_tcl_e8_ApplicationState::~midw_fi_tcl_e8_ApplicationState()
{}

tU32 midw_fi_tcl_e8_ApplicationState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ApplicationState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ApplicationState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AppMgrMethodResult::midw_fi_tcl_e8_AppMgrMethodResult():enType(FI_EN_RESULT_NO_ERROR) {}

tS32 midw_fi_tcl_e8_AppMgrMethodResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPMGRMETHODRESULT;
}


midw_fi_tcl_e8_AppMgrMethodResult::~midw_fi_tcl_e8_AppMgrMethodResult()
{}

tU32 midw_fi_tcl_e8_AppMgrMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AppMgrMethodResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AppMgrMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ApplicationData::midw_fi_tcl_ApplicationData(const midw_fi_tcl_ApplicationData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16ApplicationID = coRef.u16ApplicationID;
   u8State = coRef.u8State;
}
midw_fi_tcl_ApplicationData& midw_fi_tcl_ApplicationData::operator=(const midw_fi_tcl_ApplicationData& coRef)
{
   if (this == &coRef) return *this;
   u16ApplicationID = coRef.u16ApplicationID;
   u8State = coRef.u8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ApplicationData::midw_fi_tcl_ApplicationData()
:u16ApplicationID(0)
,u8State()
 {}

tS32 midw_fi_tcl_ApplicationData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPLICATIONDATA;
}


midw_fi_tcl_ApplicationData::~midw_fi_tcl_ApplicationData()
{}

tU32 midw_fi_tcl_ApplicationData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_ApplicationData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ApplicationID);
   (tVoid) (oIn >> u8State);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ApplicationData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ApplicationID);
   (tVoid) (oOut << u8State);
   return oOut;
}

tBool midw_fi_tcl_ApplicationData::operator==(const midw_fi_tcl_ApplicationData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ApplicationID == roRef.u16ApplicationID);
   bResult = bResult && (u8State == roRef.u8State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_streamrouter_routestate::midw_fi_tcl_e8_streamrouter_routestate():enType(FI_EN_INIT) {}

tS32 midw_fi_tcl_e8_streamrouter_routestate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STREAMROUTER_ROUTESTATE;
}


midw_fi_tcl_e8_streamrouter_routestate::~midw_fi_tcl_e8_streamrouter_routestate()
{}

tU32 midw_fi_tcl_e8_streamrouter_routestate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_streamrouter_routestate::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_streamrouter_routestate::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_streamrouter_ramptype::midw_fi_tcl_e8_streamrouter_ramptype():enType(FI_EN_NO) {}

tS32 midw_fi_tcl_e8_streamrouter_ramptype::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STREAMROUTER_RAMPTYPE;
}


midw_fi_tcl_e8_streamrouter_ramptype::~midw_fi_tcl_e8_streamrouter_ramptype()
{}

tU32 midw_fi_tcl_e8_streamrouter_ramptype::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_streamrouter_ramptype::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_streamrouter_ramptype::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_streamrouter_route_entry::midw_fi_tcl_streamrouter_route_entry(const midw_fi_tcl_streamrouter_route_entry& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32UCID = coRef.u32UCID;
   u16AppID = coRef.u16AppID;
   u16MLBChannelAddress = coRef.u16MLBChannelAddress;
   u8BlkWidth = coRef.u8BlkWidth;
   e8Routestate = coRef.e8Routestate;
}
midw_fi_tcl_streamrouter_route_entry& midw_fi_tcl_streamrouter_route_entry::operator=(const midw_fi_tcl_streamrouter_route_entry& coRef)
{
   if (this == &coRef) return *this;
   u32UCID = coRef.u32UCID;
   u16AppID = coRef.u16AppID;
   u16MLBChannelAddress = coRef.u16MLBChannelAddress;
   u8BlkWidth = coRef.u8BlkWidth;
   e8Routestate = coRef.e8Routestate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_streamrouter_route_entry::midw_fi_tcl_streamrouter_route_entry()
:u32UCID(0)
,u16AppID(0)
,u16MLBChannelAddress(0)
,u8BlkWidth(0)
,e8Routestate()
 {}

tS32 midw_fi_tcl_streamrouter_route_entry::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_STREAMROUTER_ROUTE_ENTRY;
}


midw_fi_tcl_streamrouter_route_entry::~midw_fi_tcl_streamrouter_route_entry()
{}

tU32 midw_fi_tcl_streamrouter_route_entry::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_fi_tcl_streamrouter_route_entry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UCID);
   (tVoid) (oIn >> u16AppID);
   (tVoid) (oIn >> u16MLBChannelAddress);
   (tVoid) (oIn >> u8BlkWidth);
   (tVoid) (oIn >> e8Routestate);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_streamrouter_route_entry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UCID);
   (tVoid) (oOut << u16AppID);
   (tVoid) (oOut << u16MLBChannelAddress);
   (tVoid) (oOut << u8BlkWidth);
   (tVoid) (oOut << e8Routestate);
   return oOut;
}

tBool midw_fi_tcl_streamrouter_route_entry::operator==(const midw_fi_tcl_streamrouter_route_entry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UCID == roRef.u32UCID);
   bResult = bResult && (u16AppID == roRef.u16AppID);
   bResult = bResult && (u16MLBChannelAddress == roRef.u16MLBChannelAddress);
   bResult = bResult && (u8BlkWidth == roRef.u8BlkWidth);
   bResult = bResult && (e8Routestate == roRef.e8Routestate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_streamrouter_routing_list::midw_fi_tcl_streamrouter_routing_list(const midw_fi_tcl_streamrouter_routing_list& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   sREntry = coRef.sREntry;
}
midw_fi_tcl_streamrouter_routing_list& midw_fi_tcl_streamrouter_routing_list::operator=(const midw_fi_tcl_streamrouter_routing_list& coRef)
{
   if (this == &coRef) return *this;
   sREntry = coRef.sREntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_streamrouter_routing_list::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < sREntry.size(); ++u32Idx)
         sREntry[u32Idx].vDestroy();
   sREntry.clear();
   }
}

midw_fi_tcl_streamrouter_routing_list::midw_fi_tcl_streamrouter_routing_list()

 {}

tS32 midw_fi_tcl_streamrouter_routing_list::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_STREAMROUTER_ROUTING_LIST;
}


midw_fi_tcl_streamrouter_routing_list::~midw_fi_tcl_streamrouter_routing_list()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_streamrouter_routing_list::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(sREntry.size()*10);
}

fi_tclInContext& midw_fi_tcl_streamrouter_routing_list::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < sREntry.size(); ++u32Idx)
      {
         sREntry[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      sREntry.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> sREntry[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_streamrouter_routing_list::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)sREntry.size());
   {
      for (tU32 u32Idx = 0; u32Idx < sREntry.size(); ++u32Idx)
         (tVoid) (oOut << sREntry[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_streamrouter_routing_list::operator==(const midw_fi_tcl_streamrouter_routing_list& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (sREntry.size() == roRef.sREntry.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < sREntry.size()); ++u32Idx)
            bResult = bResult && (sREntry[u32Idx] == roRef.sREntry[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_streamrouter_device_list::midw_fi_tcl_streamrouter_device_list(const midw_fi_tcl_streamrouter_device_list& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   strALSADev = coRef.strALSADev;
}
midw_fi_tcl_streamrouter_device_list& midw_fi_tcl_streamrouter_device_list::operator=(const midw_fi_tcl_streamrouter_device_list& coRef)
{
   if (this == &coRef) return *this;
   strALSADev = coRef.strALSADev;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_streamrouter_device_list::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < strALSADev.size(); ++u32Idx)
         strALSADev[u32Idx].vDestroy();
   strALSADev.clear();
   }
}

midw_fi_tcl_streamrouter_device_list::midw_fi_tcl_streamrouter_device_list()

 {}

tS32 midw_fi_tcl_streamrouter_device_list::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_STREAMROUTER_DEVICE_LIST;
}


midw_fi_tcl_streamrouter_device_list::~midw_fi_tcl_streamrouter_device_list()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_streamrouter_device_list::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < strALSADev.size(); ++u32ListIdx)
      u32DynamicSize += strALSADev[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_streamrouter_device_list::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < strALSADev.size(); ++u32Idx)
      {
         strALSADev[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      strALSADev.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> strALSADev[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_streamrouter_device_list::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)strALSADev.size());
   {
      for (tU32 u32Idx = 0; u32Idx < strALSADev.size(); ++u32Idx)
         (tVoid) (oOut << strALSADev[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_streamrouter_device_list::operator==(const midw_fi_tcl_streamrouter_device_list& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (strALSADev.size() == roRef.strALSADev.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < strALSADev.size()); ++u32Idx)
            bResult = bResult && (strALSADev[u32Idx] == roRef.strALSADev[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_streamrouter_fgcommand::midw_fi_tcl_e8_streamrouter_fgcommand():enType(FI_EN_ECNR_MICMUTE_ON) {}

tS32 midw_fi_tcl_e8_streamrouter_fgcommand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STREAMROUTER_FGCOMMAND;
}


midw_fi_tcl_e8_streamrouter_fgcommand::~midw_fi_tcl_e8_streamrouter_fgcommand()
{}

tU32 midw_fi_tcl_e8_streamrouter_fgcommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_streamrouter_fgcommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_streamrouter_fgcommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceConnectStatus::midw_fi_tcl_e8_DeviceConnectStatus():enType(FI_EN_USB_DEV_UNDEFINED) {}

tS32 midw_fi_tcl_e8_DeviceConnectStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICECONNECTSTATUS;
}


midw_fi_tcl_e8_DeviceConnectStatus::~midw_fi_tcl_e8_DeviceConnectStatus()
{}

tU32 midw_fi_tcl_e8_DeviceConnectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceConnectStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceConnectStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Device::midw_fi_tcl_e8_Device():enType(FI_EN_DTY_UNKNOWN) {}

tS32 midw_fi_tcl_e8_Device::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICE;
}


midw_fi_tcl_e8_Device::~midw_fi_tcl_e8_Device()
{}

tU32 midw_fi_tcl_e8_Device::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Device::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Device::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DevManager_DeviceProperty::midw_fi_tcl_DevManager_DeviceProperty(const midw_fi_tcl_DevManager_DeviceProperty& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DeviceSerialNo = coRef.DeviceSerialNo;
   USBPortNo = coRef.USBPortNo;
   DeviceType = coRef.DeviceType;
   DeviceVersion = coRef.DeviceVersion;
   DeviceName = coRef.DeviceName;
   AccessoryName = coRef.AccessoryName;
   MountPoint = coRef.MountPoint;
   DeviceConnectStatus = coRef.DeviceConnectStatus;
}
midw_fi_tcl_DevManager_DeviceProperty& midw_fi_tcl_DevManager_DeviceProperty::operator=(const midw_fi_tcl_DevManager_DeviceProperty& coRef)
{
   if (this == &coRef) return *this;
   DeviceSerialNo = coRef.DeviceSerialNo;
   USBPortNo = coRef.USBPortNo;
   DeviceType = coRef.DeviceType;
   DeviceVersion = coRef.DeviceVersion;
   DeviceName = coRef.DeviceName;
   AccessoryName = coRef.AccessoryName;
   MountPoint = coRef.MountPoint;
   DeviceConnectStatus = coRef.DeviceConnectStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DevManager_DeviceProperty::vDestroy()
{
   DeviceSerialNo.vDestroy();
   USBPortNo.vDestroy();
   DeviceVersion.vDestroy();
   DeviceName.vDestroy();
   AccessoryName.vDestroy();
   MountPoint.vDestroy();
}

midw_fi_tcl_DevManager_DeviceProperty::midw_fi_tcl_DevManager_DeviceProperty()
:DeviceSerialNo()
,USBPortNo()
,DeviceType()
,DeviceVersion()
,DeviceName()
,AccessoryName()
,MountPoint()
,DeviceConnectStatus()
 {}

tS32 midw_fi_tcl_DevManager_DeviceProperty::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY;
}


midw_fi_tcl_DevManager_DeviceProperty::~midw_fi_tcl_DevManager_DeviceProperty()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DevManager_DeviceProperty::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+DeviceSerialNo.u32GetSize(u16MajorVersion)+USBPortNo.u32GetSize(u16MajorVersion)+DeviceVersion.u32GetSize(u16MajorVersion)+DeviceName.u32GetSize(u16MajorVersion)+AccessoryName.u32GetSize(u16MajorVersion)+MountPoint.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DevManager_DeviceProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceSerialNo);
   (tVoid) (oIn >> USBPortNo);
   (tVoid) (oIn >> DeviceType);
   (tVoid) (oIn >> DeviceVersion);
   (tVoid) (oIn >> DeviceName);
   (tVoid) (oIn >> AccessoryName);
   (tVoid) (oIn >> MountPoint);
   (tVoid) (oIn >> DeviceConnectStatus);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DevManager_DeviceProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceSerialNo);
   (tVoid) (oOut << USBPortNo);
   (tVoid) (oOut << DeviceType);
   (tVoid) (oOut << DeviceVersion);
   (tVoid) (oOut << DeviceName);
   (tVoid) (oOut << AccessoryName);
   (tVoid) (oOut << MountPoint);
   (tVoid) (oOut << DeviceConnectStatus);
   return oOut;
}

tBool midw_fi_tcl_DevManager_DeviceProperty::operator==(const midw_fi_tcl_DevManager_DeviceProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceSerialNo == roRef.DeviceSerialNo);
   bResult = bResult && (USBPortNo == roRef.USBPortNo);
   bResult = bResult && (DeviceType == roRef.DeviceType);
   bResult = bResult && (DeviceVersion == roRef.DeviceVersion);
   bResult = bResult && (DeviceName == roRef.DeviceName);
   bResult = bResult && (AccessoryName == roRef.AccessoryName);
   bResult = bResult && (MountPoint == roRef.MountPoint);
   bResult = bResult && (DeviceConnectStatus == roRef.DeviceConnectStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DevManager_DevInfoStr::midw_fi_tcl_DevManager_DevInfoStr(const midw_fi_tcl_DevManager_DevInfoStr& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DevList = coRef.DevList;
}
midw_fi_tcl_DevManager_DevInfoStr& midw_fi_tcl_DevManager_DevInfoStr::operator=(const midw_fi_tcl_DevManager_DevInfoStr& coRef)
{
   if (this == &coRef) return *this;
   DevList = coRef.DevList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DevManager_DevInfoStr::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
         DevList[u32Idx].vDestroy();
   DevList.clear();
   }
}

midw_fi_tcl_DevManager_DevInfoStr::midw_fi_tcl_DevManager_DevInfoStr()

 {}

tS32 midw_fi_tcl_DevManager_DevInfoStr::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DEVMANAGER_DEVINFOSTR;
}


midw_fi_tcl_DevManager_DevInfoStr::~midw_fi_tcl_DevManager_DevInfoStr()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DevManager_DevInfoStr::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DevList.size(); ++u32ListIdx)
      u32DynamicSize += DevList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_DevManager_DevInfoStr::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
      {
         DevList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DevList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DevList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DevManager_DevInfoStr::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DevList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
         (tVoid) (oOut << DevList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DevManager_DevInfoStr::operator==(const midw_fi_tcl_DevManager_DevInfoStr& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DevList.size() == roRef.DevList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DevList.size()); ++u32Idx)
            bResult = bResult && (DevList[u32Idx] == roRef.DevList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_u8Array::midw_fi_tcl_u8Array(const midw_fi_tcl_u8Array& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   tU8Array = coRef.tU8Array;
}
midw_fi_tcl_u8Array& midw_fi_tcl_u8Array::operator=(const midw_fi_tcl_u8Array& coRef)
{
   if (this == &coRef) return *this;
   tU8Array = coRef.tU8Array;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_u8Array::vDestroy()
{
   {
   tU8Array.clear();
   }
}

midw_fi_tcl_u8Array::midw_fi_tcl_u8Array()

 {}

tS32 midw_fi_tcl_u8Array::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_U8ARRAY;
}


midw_fi_tcl_u8Array::~midw_fi_tcl_u8Array()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_u8Array::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tU8Array.size()*1);
}

fi_tclInContext& midw_fi_tcl_u8Array::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tU8Array.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tU8Array[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_u8Array::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tU8Array.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tU8Array.size(); ++u32Idx)
         (tVoid) (oOut << tU8Array[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_u8Array::operator==(const midw_fi_tcl_u8Array& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tU8Array.size() == roRef.tU8Array.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tU8Array.size()); ++u32Idx)
            bResult = bResult && (tU8Array[u32Idx] == roRef.tU8Array[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_InternalError::midw_fi_tcl_e8_InternalError():enType(FI_EN_INTERNAL_ERROR_ID_NOT_SUPPORTED) {}

tS32 midw_fi_tcl_e8_InternalError::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_INTERNALERROR;
}


midw_fi_tcl_e8_InternalError::~midw_fi_tcl_e8_InternalError()
{}

tU32 midw_fi_tcl_e8_InternalError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_InternalError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_InternalError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_RoutineBitMask::midw_fi_tcl_b32_RoutineBitMask():u32Value(0)
{}

tS32 midw_fi_tcl_b32_RoutineBitMask::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_ROUTINEBITMASK;
}


midw_fi_tcl_b32_RoutineBitMask::~midw_fi_tcl_b32_RoutineBitMask()
{}

tU32 midw_fi_tcl_b32_RoutineBitMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_RoutineBitMask::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_RoutineBitMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RoutineStatus::midw_fi_tcl_e8_RoutineStatus():enType(FI_EN_ROUTINE_CONTROL_OK) {}

tS32 midw_fi_tcl_e8_RoutineStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ROUTINESTATUS;
}


midw_fi_tcl_e8_RoutineStatus::~midw_fi_tcl_e8_RoutineStatus()
{}

tU32 midw_fi_tcl_e8_RoutineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RoutineStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RoutineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_IOResult::midw_fi_tcl_e8_IOResult():enType(FI_EN_IO_CONTROL_OK) {}

tS32 midw_fi_tcl_e8_IOResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_IORESULT;
}


midw_fi_tcl_e8_IOResult::~midw_fi_tcl_e8_IOResult()
{}

tU32 midw_fi_tcl_e8_IOResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_IOResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_IOResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SystemSetResult::midw_fi_tcl_e8_SystemSetResult():enType(FI_EN_SYSTEMSET_OK) {}

tS32 midw_fi_tcl_e8_SystemSetResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SYSTEMSETRESULT;
}


midw_fi_tcl_e8_SystemSetResult::~midw_fi_tcl_e8_SystemSetResult()
{}

tU32 midw_fi_tcl_e8_SystemSetResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SystemSetResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SystemSetResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagDataResult::midw_fi_tcl_e8_DiagDataResult():enType(FI_EN_DIAGDATA_OK) {}

tS32 midw_fi_tcl_e8_DiagDataResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGDATARESULT;
}


midw_fi_tcl_e8_DiagDataResult::~midw_fi_tcl_e8_DiagDataResult()
{}

tU32 midw_fi_tcl_e8_DiagDataResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagDataResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagDataResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_IOControlActionId::midw_fi_tcl_e8_IOControlActionId():enType(FI_EN_IO_CONTROL_ACTION_FREEZE) {}

tS32 midw_fi_tcl_e8_IOControlActionId::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_IOCONTROLACTIONID;
}


midw_fi_tcl_e8_IOControlActionId::~midw_fi_tcl_e8_IOControlActionId()
{}

tU32 midw_fi_tcl_e8_IOControlActionId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_IOControlActionId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_IOControlActionId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SystemSetType::midw_fi_tcl_e8_SystemSetType():enType(FI_EN_SYSTEMSET_TYPE_HMI) {}

tS32 midw_fi_tcl_e8_SystemSetType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SYSTEMSETTYPE;
}


midw_fi_tcl_e8_SystemSetType::~midw_fi_tcl_e8_SystemSetType()
{}

tU32 midw_fi_tcl_e8_SystemSetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SystemSetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SystemSetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ValueType::midw_fi_tcl_e8_ValueType():enType(FI_EN_TBOOL) {}

tS32 midw_fi_tcl_e8_ValueType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VALUETYPE;
}


midw_fi_tcl_e8_ValueType::~midw_fi_tcl_e8_ValueType()
{}

tU32 midw_fi_tcl_e8_ValueType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ValueType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ValueType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ValueUnion::midw_fi_tcl_ValueUnion(const midw_fi_tcl_ValueUnion& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ValueUnionType = coRef.ValueUnionType;
   if  (coRef.poValueUnionData)
   {
      switch(ValueUnionType.enType)
      {
      case midw_fi_tcl_e8_ValueType::FI_EN_TBOOL:
         poValueUnionData = OSAL_NEW midw_fi_tclBool((const midw_fi_tclBool&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU8:
         poValueUnionData = OSAL_NEW midw_fi_tclU8((const midw_fi_tclU8&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU16:
         poValueUnionData = OSAL_NEW midw_fi_tclU16((const midw_fi_tclU16&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU32:
         poValueUnionData = OSAL_NEW midw_fi_tclU32((const midw_fi_tclU32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS8:
         poValueUnionData = OSAL_NEW midw_fi_tclS8((const midw_fi_tclS8&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS16:
         poValueUnionData = OSAL_NEW midw_fi_tclS16((const midw_fi_tclS16&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS32:
         poValueUnionData = OSAL_NEW midw_fi_tclS32((const midw_fi_tclS32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF32:
         poValueUnionData = OSAL_NEW midw_fi_tclF32((const midw_fi_tclF32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF64:
         poValueUnionData = OSAL_NEW midw_fi_tclF64((const midw_fi_tclF64&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_E8_INTERNALERROR:
         poValueUnionData = OSAL_NEW midw_fi_tcl_e8_InternalError((const midw_fi_tcl_e8_InternalError&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_U8ARRAY:
         poValueUnionData = OSAL_NEW midw_fi_tcl_u8Array((const midw_fi_tcl_u8Array&)*coRef.poValueUnionData);
         break;
      default:
         poValueUnionData = OSAL_NULL;
      }
   }
   else
   {
      poValueUnionData = OSAL_NULL;
   }
}
midw_fi_tcl_ValueUnion& midw_fi_tcl_ValueUnion::operator=(const midw_fi_tcl_ValueUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poValueUnionData;
   ValueUnionType = coRef.ValueUnionType;
   if  (coRef.poValueUnionData)
   {
      switch(ValueUnionType.enType)
      {
      case midw_fi_tcl_e8_ValueType::FI_EN_TBOOL:
         poValueUnionData = OSAL_NEW midw_fi_tclBool((const midw_fi_tclBool&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU8:
         poValueUnionData = OSAL_NEW midw_fi_tclU8((const midw_fi_tclU8&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU16:
         poValueUnionData = OSAL_NEW midw_fi_tclU16((const midw_fi_tclU16&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU32:
         poValueUnionData = OSAL_NEW midw_fi_tclU32((const midw_fi_tclU32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS8:
         poValueUnionData = OSAL_NEW midw_fi_tclS8((const midw_fi_tclS8&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS16:
         poValueUnionData = OSAL_NEW midw_fi_tclS16((const midw_fi_tclS16&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS32:
         poValueUnionData = OSAL_NEW midw_fi_tclS32((const midw_fi_tclS32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF32:
         poValueUnionData = OSAL_NEW midw_fi_tclF32((const midw_fi_tclF32&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF64:
         poValueUnionData = OSAL_NEW midw_fi_tclF64((const midw_fi_tclF64&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_E8_INTERNALERROR:
         poValueUnionData = OSAL_NEW midw_fi_tcl_e8_InternalError((const midw_fi_tcl_e8_InternalError&)*coRef.poValueUnionData);
         break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_U8ARRAY:
         poValueUnionData = OSAL_NEW midw_fi_tcl_u8Array((const midw_fi_tcl_u8Array&)*coRef.poValueUnionData);
         break;
      default:
         poValueUnionData = OSAL_NULL;
      }
   }
   else
   {
      poValueUnionData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ValueUnion::vDestroy()
{
   if (poValueUnionData)
   {
      poValueUnionData->vDestroy();
      OSAL_DELETE poValueUnionData;
      poValueUnionData = OSAL_NULL;
   }
}

midw_fi_tcl_ValueUnion::midw_fi_tcl_ValueUnion()
:poValueUnionData(0)
 {}

tS32 midw_fi_tcl_ValueUnion::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VALUEUNION;
}


midw_fi_tcl_ValueUnion::~midw_fi_tcl_ValueUnion()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ValueUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poValueUnionData?poValueUnionData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& midw_fi_tcl_ValueUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poValueUnionData;
#else
   if (poValueUnionData)
   {
      poValueUnionData->vDestroy();
      OSAL_DELETE poValueUnionData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> ValueUnionType);
   switch(ValueUnionType.enType)
   {
   case midw_fi_tcl_e8_ValueType::FI_EN_TBOOL:
      poValueUnionData = OSAL_NEW midw_fi_tclBool;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TU8:
      poValueUnionData = OSAL_NEW midw_fi_tclU8;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TU16:
      poValueUnionData = OSAL_NEW midw_fi_tclU16;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TU32:
      poValueUnionData = OSAL_NEW midw_fi_tclU32;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TS8:
      poValueUnionData = OSAL_NEW midw_fi_tclS8;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TS16:
      poValueUnionData = OSAL_NEW midw_fi_tclS16;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TS32:
      poValueUnionData = OSAL_NEW midw_fi_tclS32;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TF32:
      poValueUnionData = OSAL_NEW midw_fi_tclF32;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_TF64:
      poValueUnionData = OSAL_NEW midw_fi_tclF64;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_T_E8_INTERNALERROR:
      poValueUnionData = OSAL_NEW midw_fi_tcl_e8_InternalError;
      break;
   case midw_fi_tcl_e8_ValueType::FI_EN_T_U8ARRAY:
      poValueUnionData = OSAL_NEW midw_fi_tcl_u8Array;
      break;
   default:
      oIn.Invalidate();
      poValueUnionData = OSAL_NULL;
   }
   if (poValueUnionData && oIn.bIsValid())
      poValueUnionData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ValueUnion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ValueUnionType);
   if (poValueUnionData)
   {
      (tVoid) poValueUnionData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool midw_fi_tcl_ValueUnion::operator==(const midw_fi_tcl_ValueUnion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ValueUnionType == roRef.ValueUnionType);
   if (bResult && poValueUnionData && roRef.poValueUnionData) 
   {
      switch (ValueUnionType.enType)
      {
      case midw_fi_tcl_e8_ValueType::FI_EN_TBOOL:
         bResult = bResult && (*(const midw_fi_tclBool*)poValueUnionData == *(const midw_fi_tclBool*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU8:
         bResult = bResult && (*(const midw_fi_tclU8*)poValueUnionData == *(const midw_fi_tclU8*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU16:
         bResult = bResult && (*(const midw_fi_tclU16*)poValueUnionData == *(const midw_fi_tclU16*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TU32:
         bResult = bResult && (*(const midw_fi_tclU32*)poValueUnionData == *(const midw_fi_tclU32*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS8:
         bResult = bResult && (*(const midw_fi_tclS8*)poValueUnionData == *(const midw_fi_tclS8*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS16:
         bResult = bResult && (*(const midw_fi_tclS16*)poValueUnionData == *(const midw_fi_tclS16*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TS32:
         bResult = bResult && (*(const midw_fi_tclS32*)poValueUnionData == *(const midw_fi_tclS32*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF32:
         bResult = bResult && (*(const midw_fi_tclF32*)poValueUnionData == *(const midw_fi_tclF32*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_TF64:
         bResult = bResult && (*(const midw_fi_tclF64*)poValueUnionData == *(const midw_fi_tclF64*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_E8_INTERNALERROR:
         bResult = bResult && (*(const midw_fi_tcl_e8_InternalError*)poValueUnionData == *(const midw_fi_tcl_e8_InternalError*)roRef.poValueUnionData); //lint !e826
      break;
      case midw_fi_tcl_e8_ValueType::FI_EN_T_U8ARRAY:
         bResult = bResult && (*(const midw_fi_tcl_u8Array*)poValueUnionData == *(const midw_fi_tcl_u8Array*)roRef.poValueUnionData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poValueUnionData == roRef.poValueUnionData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ValueList::midw_fi_tcl_ValueList(const midw_fi_tcl_ValueList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ValueList = coRef.ValueList;
}
midw_fi_tcl_ValueList& midw_fi_tcl_ValueList::operator=(const midw_fi_tcl_ValueList& coRef)
{
   if (this == &coRef) return *this;
   ValueList = coRef.ValueList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ValueList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ValueList.size(); ++u32Idx)
         ValueList[u32Idx].vDestroy();
   ValueList.clear();
   }
}

midw_fi_tcl_ValueList::midw_fi_tcl_ValueList()

 {}

tS32 midw_fi_tcl_ValueList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VALUELIST;
}


midw_fi_tcl_ValueList::~midw_fi_tcl_ValueList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ValueList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ValueList.size(); ++u32ListIdx)
      u32DynamicSize += ValueList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_ValueList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ValueList.size(); ++u32Idx)
      {
         ValueList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ValueList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ValueList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ValueList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ValueList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ValueList.size(); ++u32Idx)
         (tVoid) (oOut << ValueList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ValueList::operator==(const midw_fi_tcl_ValueList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ValueList.size() == roRef.ValueList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ValueList.size()); ++u32Idx)
            bResult = bResult && (ValueList[u32Idx] == roRef.ValueList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MethodResultReply::midw_fi_tcl_e8_MethodResultReply():enType(FI_EN_ACCEPTED) {}

tS32 midw_fi_tcl_e8_MethodResultReply::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_METHODRESULTREPLY;
}


midw_fi_tcl_e8_MethodResultReply::~midw_fi_tcl_e8_MethodResultReply()
{}

tU32 midw_fi_tcl_e8_MethodResultReply::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MethodResultReply::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MethodResultReply::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TestResult::midw_fi_tcl_e8_TestResult():enType(FI_EN_PASSED) {}

tS32 midw_fi_tcl_e8_TestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TESTRESULT;
}


midw_fi_tcl_e8_TestResult::~midw_fi_tcl_e8_TestResult()
{}

tU32 midw_fi_tcl_e8_TestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_FreezeFrameData::midw_fi_tcl_FreezeFrameData(const midw_fi_tcl_FreezeFrameData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Data = coRef.Data;
}
midw_fi_tcl_FreezeFrameData& midw_fi_tcl_FreezeFrameData::operator=(const midw_fi_tcl_FreezeFrameData& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_FreezeFrameData::vDestroy()
{
   {
   Data.clear();
   }
}

midw_fi_tcl_FreezeFrameData::midw_fi_tcl_FreezeFrameData()
:ID(0)

 {}

tS32 midw_fi_tcl_FreezeFrameData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_FREEZEFRAMEDATA;
}


midw_fi_tcl_FreezeFrameData::~midw_fi_tcl_FreezeFrameData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_FreezeFrameData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(Data.size()*1);
}

fi_tclInContext& midw_fi_tcl_FreezeFrameData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_FreezeFrameData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_FreezeFrameData::operator==(const midw_fi_tcl_FreezeFrameData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_FreezeFrameList::midw_fi_tcl_FreezeFrameList(const midw_fi_tcl_FreezeFrameList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   FreezeFrameDataList = coRef.FreezeFrameDataList;
}
midw_fi_tcl_FreezeFrameList& midw_fi_tcl_FreezeFrameList::operator=(const midw_fi_tcl_FreezeFrameList& coRef)
{
   if (this == &coRef) return *this;
   FreezeFrameDataList = coRef.FreezeFrameDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_FreezeFrameList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
         FreezeFrameDataList[u32Idx].vDestroy();
   FreezeFrameDataList.clear();
   }
}

midw_fi_tcl_FreezeFrameList::midw_fi_tcl_FreezeFrameList()

 {}

tS32 midw_fi_tcl_FreezeFrameList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_FREEZEFRAMELIST;
}


midw_fi_tcl_FreezeFrameList::~midw_fi_tcl_FreezeFrameList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_FreezeFrameList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FreezeFrameDataList.size(); ++u32ListIdx)
      u32DynamicSize += FreezeFrameDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_FreezeFrameList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
      {
         FreezeFrameDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FreezeFrameDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FreezeFrameDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_FreezeFrameList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FreezeFrameDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
         (tVoid) (oOut << FreezeFrameDataList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_FreezeFrameList::operator==(const midw_fi_tcl_FreezeFrameList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FreezeFrameDataList.size() == roRef.FreezeFrameDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FreezeFrameDataList.size()); ++u32Idx)
            bResult = bResult && (FreezeFrameDataList[u32Idx] == roRef.FreezeFrameDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ReadRequestBuffer::midw_fi_tcl_ReadRequestBuffer(const midw_fi_tcl_ReadRequestBuffer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ReadRequestBuffer = coRef.ReadRequestBuffer;
}
midw_fi_tcl_ReadRequestBuffer& midw_fi_tcl_ReadRequestBuffer::operator=(const midw_fi_tcl_ReadRequestBuffer& coRef)
{
   if (this == &coRef) return *this;
   ReadRequestBuffer = coRef.ReadRequestBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ReadRequestBuffer::vDestroy()
{
   {
   ReadRequestBuffer.clear();
   }
}

midw_fi_tcl_ReadRequestBuffer::midw_fi_tcl_ReadRequestBuffer()

 {}

tS32 midw_fi_tcl_ReadRequestBuffer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_READREQUESTBUFFER;
}


midw_fi_tcl_ReadRequestBuffer::~midw_fi_tcl_ReadRequestBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ReadRequestBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ReadRequestBuffer.size()*1);
}

fi_tclInContext& midw_fi_tcl_ReadRequestBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ReadRequestBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ReadRequestBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ReadRequestBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ReadRequestBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ReadRequestBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ReadRequestBuffer[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ReadRequestBuffer::operator==(const midw_fi_tcl_ReadRequestBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ReadRequestBuffer.size() == roRef.ReadRequestBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ReadRequestBuffer.size()); ++u32Idx)
            bResult = bResult && (ReadRequestBuffer[u32Idx] == roRef.ReadRequestBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ReadResultBuffer::midw_fi_tcl_ReadResultBuffer(const midw_fi_tcl_ReadResultBuffer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ReadResultBuffer = coRef.ReadResultBuffer;
}
midw_fi_tcl_ReadResultBuffer& midw_fi_tcl_ReadResultBuffer::operator=(const midw_fi_tcl_ReadResultBuffer& coRef)
{
   if (this == &coRef) return *this;
   ReadResultBuffer = coRef.ReadResultBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ReadResultBuffer::vDestroy()
{
   {
   ReadResultBuffer.clear();
   }
}

midw_fi_tcl_ReadResultBuffer::midw_fi_tcl_ReadResultBuffer()

 {}

tS32 midw_fi_tcl_ReadResultBuffer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_READRESULTBUFFER;
}


midw_fi_tcl_ReadResultBuffer::~midw_fi_tcl_ReadResultBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ReadResultBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ReadResultBuffer.size()*1);
}

fi_tclInContext& midw_fi_tcl_ReadResultBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ReadResultBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ReadResultBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ReadResultBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ReadResultBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ReadResultBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ReadResultBuffer[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ReadResultBuffer::operator==(const midw_fi_tcl_ReadResultBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ReadResultBuffer.size() == roRef.ReadResultBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ReadResultBuffer.size()); ++u32Idx)
            bResult = bResult && (ReadResultBuffer[u32Idx] == roRef.ReadResultBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ReadResultStructure::midw_fi_tcl_ReadResultStructure(const midw_fi_tcl_ReadResultStructure& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
}
midw_fi_tcl_ReadResultStructure& midw_fi_tcl_ReadResultStructure::operator=(const midw_fi_tcl_ReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ReadResultStructure::midw_fi_tcl_ReadResultStructure()
:DTC(0)
,StatusOfDtc(0)
 {}

tS32 midw_fi_tcl_ReadResultStructure::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_READRESULTSTRUCTURE;
}


midw_fi_tcl_ReadResultStructure::~midw_fi_tcl_ReadResultStructure()
{}

tU32 midw_fi_tcl_ReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_ReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   return oOut;
}

tBool midw_fi_tcl_ReadResultStructure::operator==(const midw_fi_tcl_ReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ReadResultList::midw_fi_tcl_ReadResultList(const midw_fi_tcl_ReadResultList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
midw_fi_tcl_ReadResultList& midw_fi_tcl_ReadResultList::operator=(const midw_fi_tcl_ReadResultList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         DTCList[u32Idx].vDestroy();
   DTCList.clear();
   }
}

midw_fi_tcl_ReadResultList::midw_fi_tcl_ReadResultList()

 {}

tS32 midw_fi_tcl_ReadResultList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_READRESULTLIST;
}


midw_fi_tcl_ReadResultList::~midw_fi_tcl_ReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*5);
}

fi_tclInContext& midw_fi_tcl_ReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
      {
         DTCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ReadResultList::operator==(const midw_fi_tcl_ReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ITC_Information::midw_fi_tcl_ITC_Information(const midw_fi_tcl_ITC_Information& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ITC = coRef.ITC;
   DTC = coRef.DTC;
   StatusOfItc = coRef.StatusOfItc;
   AgeingCounter = coRef.AgeingCounter;
   OccurenceCounter = coRef.OccurenceCounter;
}
midw_fi_tcl_ITC_Information& midw_fi_tcl_ITC_Information::operator=(const midw_fi_tcl_ITC_Information& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   DTC = coRef.DTC;
   StatusOfItc = coRef.StatusOfItc;
   AgeingCounter = coRef.AgeingCounter;
   OccurenceCounter = coRef.OccurenceCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ITC_Information::midw_fi_tcl_ITC_Information()
:ITC(0)
,DTC(0)
,StatusOfItc(0)
,AgeingCounter(0)
,OccurenceCounter(0)
 {}

tS32 midw_fi_tcl_ITC_Information::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ITC_INFORMATION;
}


midw_fi_tcl_ITC_Information::~midw_fi_tcl_ITC_Information()
{}

tU32 midw_fi_tcl_ITC_Information::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_fi_tcl_ITC_Information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfItc);
   (tVoid) (oIn >> AgeingCounter);
   (tVoid) (oIn >> OccurenceCounter);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ITC_Information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfItc);
   (tVoid) (oOut << AgeingCounter);
   (tVoid) (oOut << OccurenceCounter);
   return oOut;
}

tBool midw_fi_tcl_ITC_Information::operator==(const midw_fi_tcl_ITC_Information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfItc == roRef.StatusOfItc);
   bResult = bResult && (AgeingCounter == roRef.AgeingCounter);
   bResult = bResult && (OccurenceCounter == roRef.OccurenceCounter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ProductionReadResultStructure::midw_fi_tcl_ProductionReadResultStructure(const midw_fi_tcl_ProductionReadResultStructure& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ITC = coRef.ITC;
   Status = coRef.Status;
}
midw_fi_tcl_ProductionReadResultStructure& midw_fi_tcl_ProductionReadResultStructure::operator=(const midw_fi_tcl_ProductionReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProductionReadResultStructure::midw_fi_tcl_ProductionReadResultStructure()
:ITC(0)
,Status(0)
 {}

tS32 midw_fi_tcl_ProductionReadResultStructure::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PRODUCTIONREADRESULTSTRUCTURE;
}


midw_fi_tcl_ProductionReadResultStructure::~midw_fi_tcl_ProductionReadResultStructure()
{}

tU32 midw_fi_tcl_ProductionReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_ProductionReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProductionReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_fi_tcl_ProductionReadResultStructure::operator==(const midw_fi_tcl_ProductionReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ProductionReadResultList::midw_fi_tcl_ProductionReadResultList(const midw_fi_tcl_ProductionReadResultList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ITCList = coRef.ITCList;
}
midw_fi_tcl_ProductionReadResultList& midw_fi_tcl_ProductionReadResultList::operator=(const midw_fi_tcl_ProductionReadResultList& coRef)
{
   if (this == &coRef) return *this;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ProductionReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         ITCList[u32Idx].vDestroy();
   ITCList.clear();
   }
}

midw_fi_tcl_ProductionReadResultList::midw_fi_tcl_ProductionReadResultList()

 {}

tS32 midw_fi_tcl_ProductionReadResultList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PRODUCTIONREADRESULTLIST;
}


midw_fi_tcl_ProductionReadResultList::~midw_fi_tcl_ProductionReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ProductionReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ITCList.size()*3);
}

fi_tclInContext& midw_fi_tcl_ProductionReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
      {
         ITCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProductionReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ProductionReadResultList::operator==(const midw_fi_tcl_ProductionReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CustomerReadResultStructure::midw_fi_tcl_CustomerReadResultStructure(const midw_fi_tcl_CustomerReadResultStructure& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   Status = coRef.Status;
}
midw_fi_tcl_CustomerReadResultStructure& midw_fi_tcl_CustomerReadResultStructure::operator=(const midw_fi_tcl_CustomerReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_CustomerReadResultStructure::midw_fi_tcl_CustomerReadResultStructure()
:DTC(0)
,Status(0)
 {}

tS32 midw_fi_tcl_CustomerReadResultStructure::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CUSTOMERREADRESULTSTRUCTURE;
}


midw_fi_tcl_CustomerReadResultStructure::~midw_fi_tcl_CustomerReadResultStructure()
{}

tU32 midw_fi_tcl_CustomerReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_CustomerReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CustomerReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_fi_tcl_CustomerReadResultStructure::operator==(const midw_fi_tcl_CustomerReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CustomerReadResultList::midw_fi_tcl_CustomerReadResultList(const midw_fi_tcl_CustomerReadResultList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
midw_fi_tcl_CustomerReadResultList& midw_fi_tcl_CustomerReadResultList::operator=(const midw_fi_tcl_CustomerReadResultList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CustomerReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         DTCList[u32Idx].vDestroy();
   DTCList.clear();
   }
}

midw_fi_tcl_CustomerReadResultList::midw_fi_tcl_CustomerReadResultList()

 {}

tS32 midw_fi_tcl_CustomerReadResultList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CUSTOMERREADRESULTLIST;
}


midw_fi_tcl_CustomerReadResultList::~midw_fi_tcl_CustomerReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CustomerReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*5);
}

fi_tclInContext& midw_fi_tcl_CustomerReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
      {
         DTCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CustomerReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_CustomerReadResultList::operator==(const midw_fi_tcl_CustomerReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Protocol::midw_fi_tcl_e8_Protocol():enType(FI_EN_UDS) {}

tS32 midw_fi_tcl_e8_Protocol::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PROTOCOL;
}


midw_fi_tcl_e8_Protocol::~midw_fi_tcl_e8_Protocol()
{}

tU32 midw_fi_tcl_e8_Protocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Protocol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Protocol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TestResult::midw_fi_tcl_TestResult(const midw_fi_tcl_TestResult& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
   FreezeFrameList = coRef.FreezeFrameList;
}
midw_fi_tcl_TestResult& midw_fi_tcl_TestResult::operator=(const midw_fi_tcl_TestResult& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
   FreezeFrameList = coRef.FreezeFrameList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TestResult::vDestroy()
{
   FreezeFrameList.vDestroy(); 
}

midw_fi_tcl_TestResult::midw_fi_tcl_TestResult()
:TroubleCode(0)
,Result()
,FreezeFrameList()
 {}

tS32 midw_fi_tcl_TestResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TESTRESULT;
}


midw_fi_tcl_TestResult::~midw_fi_tcl_TestResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TestResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+FreezeFrameList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_TestResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> FreezeFrameList);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << Result);
   (tVoid) (oOut << FreezeFrameList);
   return oOut;
}

tBool midw_fi_tcl_TestResult::operator==(const midw_fi_tcl_TestResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (FreezeFrameList == roRef.FreezeFrameList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TestResultList::midw_fi_tcl_TestResultList(const midw_fi_tcl_TestResultList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TestResultList = coRef.TestResultList;
}
midw_fi_tcl_TestResultList& midw_fi_tcl_TestResultList::operator=(const midw_fi_tcl_TestResultList& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TestResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         TestResultList[u32Idx].vDestroy();
   TestResultList.clear();
   }
}

midw_fi_tcl_TestResultList::midw_fi_tcl_TestResultList()

 {}

tS32 midw_fi_tcl_TestResultList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TESTRESULTLIST;
}


midw_fi_tcl_TestResultList::~midw_fi_tcl_TestResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TestResultList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TestResultList.size(); ++u32ListIdx)
      u32DynamicSize += TestResultList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_TestResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
      {
         TestResultList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestResultList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestResultList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TestResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestResultList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         (tVoid) (oOut << TestResultList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TestResultList::operator==(const midw_fi_tcl_TestResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestResultList.size() == roRef.TestResultList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestResultList.size()); ++u32Idx)
            bResult = bResult && (TestResultList[u32Idx] == roRef.TestResultList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SnapshotData::midw_fi_tcl_SnapshotData(const midw_fi_tcl_SnapshotData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   RecordNumber = coRef.RecordNumber;
   NumberOfData = coRef.NumberOfData;
   Data = coRef.Data;
}
midw_fi_tcl_SnapshotData& midw_fi_tcl_SnapshotData::operator=(const midw_fi_tcl_SnapshotData& coRef)
{
   if (this == &coRef) return *this;
   RecordNumber = coRef.RecordNumber;
   NumberOfData = coRef.NumberOfData;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SnapshotData::vDestroy()
{
   {
   Data.clear();
   }
}

midw_fi_tcl_SnapshotData::midw_fi_tcl_SnapshotData()
:RecordNumber(0)
,NumberOfData(0)

 {}

tS32 midw_fi_tcl_SnapshotData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SNAPSHOTDATA;
}


midw_fi_tcl_SnapshotData::~midw_fi_tcl_SnapshotData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SnapshotData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(Data.size()*1);
}

fi_tclInContext& midw_fi_tcl_SnapshotData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecordNumber);
   (tVoid) (oIn >> NumberOfData);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SnapshotData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecordNumber);
   (tVoid) (oOut << NumberOfData);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_SnapshotData::operator==(const midw_fi_tcl_SnapshotData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecordNumber == roRef.RecordNumber);
   bResult = bResult && (NumberOfData == roRef.NumberOfData);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SnapshotDataList::midw_fi_tcl_SnapshotDataList(const midw_fi_tcl_SnapshotDataList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SnapshotData = coRef.SnapshotData;
}
midw_fi_tcl_SnapshotDataList& midw_fi_tcl_SnapshotDataList::operator=(const midw_fi_tcl_SnapshotDataList& coRef)
{
   if (this == &coRef) return *this;
   SnapshotData = coRef.SnapshotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SnapshotDataList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
         SnapshotData[u32Idx].vDestroy();
   SnapshotData.clear();
   }
}

midw_fi_tcl_SnapshotDataList::midw_fi_tcl_SnapshotDataList()

 {}

tS32 midw_fi_tcl_SnapshotDataList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SNAPSHOTDATALIST;
}


midw_fi_tcl_SnapshotDataList::~midw_fi_tcl_SnapshotDataList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SnapshotDataList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SnapshotData.size(); ++u32ListIdx)
      u32DynamicSize += SnapshotData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_SnapshotDataList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
      {
         SnapshotData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SnapshotData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SnapshotData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SnapshotDataList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SnapshotData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
         (tVoid) (oOut << SnapshotData[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_SnapshotDataList::operator==(const midw_fi_tcl_SnapshotDataList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SnapshotData.size() == roRef.SnapshotData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SnapshotData.size()); ++u32Idx)
            bResult = bResult && (SnapshotData[u32Idx] == roRef.SnapshotData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SnapshotIdentification::midw_fi_tcl_SnapshotIdentification(const midw_fi_tcl_SnapshotIdentification& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   RecordNumber = coRef.RecordNumber;
}
midw_fi_tcl_SnapshotIdentification& midw_fi_tcl_SnapshotIdentification::operator=(const midw_fi_tcl_SnapshotIdentification& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   RecordNumber = coRef.RecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_SnapshotIdentification::midw_fi_tcl_SnapshotIdentification()
:DTC(0)
,RecordNumber(0)
 {}

tS32 midw_fi_tcl_SnapshotIdentification::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SNAPSHOTIDENTIFICATION;
}


midw_fi_tcl_SnapshotIdentification::~midw_fi_tcl_SnapshotIdentification()
{}

tU32 midw_fi_tcl_SnapshotIdentification::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_SnapshotIdentification::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> RecordNumber);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SnapshotIdentification::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << RecordNumber);
   return oOut;
}

tBool midw_fi_tcl_SnapshotIdentification::operator==(const midw_fi_tcl_SnapshotIdentification& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (RecordNumber == roRef.RecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SnapshotIdentificationList::midw_fi_tcl_SnapshotIdentificationList(const midw_fi_tcl_SnapshotIdentificationList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SnapshotIdentification = coRef.SnapshotIdentification;
}
midw_fi_tcl_SnapshotIdentificationList& midw_fi_tcl_SnapshotIdentificationList::operator=(const midw_fi_tcl_SnapshotIdentificationList& coRef)
{
   if (this == &coRef) return *this;
   SnapshotIdentification = coRef.SnapshotIdentification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SnapshotIdentificationList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
         SnapshotIdentification[u32Idx].vDestroy();
   SnapshotIdentification.clear();
   }
}

midw_fi_tcl_SnapshotIdentificationList::midw_fi_tcl_SnapshotIdentificationList()

 {}

tS32 midw_fi_tcl_SnapshotIdentificationList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SNAPSHOTIDENTIFICATIONLIST;
}


midw_fi_tcl_SnapshotIdentificationList::~midw_fi_tcl_SnapshotIdentificationList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SnapshotIdentificationList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SnapshotIdentification.size()*5);
}

fi_tclInContext& midw_fi_tcl_SnapshotIdentificationList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
      {
         SnapshotIdentification[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SnapshotIdentification.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SnapshotIdentification[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SnapshotIdentificationList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SnapshotIdentification.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
         (tVoid) (oOut << SnapshotIdentification[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_SnapshotIdentificationList::operator==(const midw_fi_tcl_SnapshotIdentificationList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SnapshotIdentification.size() == roRef.SnapshotIdentification.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SnapshotIdentification.size()); ++u32Idx)
            bResult = bResult && (SnapshotIdentification[u32Idx] == roRef.SnapshotIdentification[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ClearRequestBuffer::midw_fi_tcl_ClearRequestBuffer(const midw_fi_tcl_ClearRequestBuffer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ClearRequestBuffer = coRef.ClearRequestBuffer;
}
midw_fi_tcl_ClearRequestBuffer& midw_fi_tcl_ClearRequestBuffer::operator=(const midw_fi_tcl_ClearRequestBuffer& coRef)
{
   if (this == &coRef) return *this;
   ClearRequestBuffer = coRef.ClearRequestBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ClearRequestBuffer::vDestroy()
{
   {
   ClearRequestBuffer.clear();
   }
}

midw_fi_tcl_ClearRequestBuffer::midw_fi_tcl_ClearRequestBuffer()

 {}

tS32 midw_fi_tcl_ClearRequestBuffer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CLEARREQUESTBUFFER;
}


midw_fi_tcl_ClearRequestBuffer::~midw_fi_tcl_ClearRequestBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ClearRequestBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ClearRequestBuffer.size()*1);
}

fi_tclInContext& midw_fi_tcl_ClearRequestBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ClearRequestBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClearRequestBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ClearRequestBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClearRequestBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClearRequestBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ClearRequestBuffer[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ClearRequestBuffer::operator==(const midw_fi_tcl_ClearRequestBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClearRequestBuffer.size() == roRef.ClearRequestBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClearRequestBuffer.size()); ++u32Idx)
            bResult = bResult && (ClearRequestBuffer[u32Idx] == roRef.ClearRequestBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ClearResultBuffer::midw_fi_tcl_ClearResultBuffer(const midw_fi_tcl_ClearResultBuffer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ClearResultBuffer = coRef.ClearResultBuffer;
}
midw_fi_tcl_ClearResultBuffer& midw_fi_tcl_ClearResultBuffer::operator=(const midw_fi_tcl_ClearResultBuffer& coRef)
{
   if (this == &coRef) return *this;
   ClearResultBuffer = coRef.ClearResultBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ClearResultBuffer::vDestroy()
{
   {
   ClearResultBuffer.clear();
   }
}

midw_fi_tcl_ClearResultBuffer::midw_fi_tcl_ClearResultBuffer()

 {}

tS32 midw_fi_tcl_ClearResultBuffer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CLEARRESULTBUFFER;
}


midw_fi_tcl_ClearResultBuffer::~midw_fi_tcl_ClearResultBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ClearResultBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ClearResultBuffer.size()*1);
}

fi_tclInContext& midw_fi_tcl_ClearResultBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ClearResultBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClearResultBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ClearResultBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClearResultBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClearResultBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ClearResultBuffer[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ClearResultBuffer::operator==(const midw_fi_tcl_ClearResultBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClearResultBuffer.size() == roRef.ClearResultBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClearResultBuffer.size()); ++u32Idx)
            bResult = bResult && (ClearResultBuffer[u32Idx] == roRef.ClearResultBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ControlParameter::midw_fi_tcl_e8_ControlParameter():enType(FI_EN_DISABLELOGGING) {}

tS32 midw_fi_tcl_e8_ControlParameter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_CONTROLPARAMETER;
}


midw_fi_tcl_e8_ControlParameter::~midw_fi_tcl_e8_ControlParameter()
{}

tU32 midw_fi_tcl_e8_ControlParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ControlParameter::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ControlParameter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ControlList::midw_fi_tcl_ControlList(const midw_fi_tcl_ControlList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
midw_fi_tcl_ControlList& midw_fi_tcl_ControlList::operator=(const midw_fi_tcl_ControlList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ControlList::vDestroy()
{
   {
   DTCList.clear();
   }
}

midw_fi_tcl_ControlList::midw_fi_tcl_ControlList()

 {}

tS32 midw_fi_tcl_ControlList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CONTROLLIST;
}


midw_fi_tcl_ControlList::~midw_fi_tcl_ControlList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ControlList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*4);
}

fi_tclInContext& midw_fi_tcl_ControlList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ControlList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ControlList::operator==(const midw_fi_tcl_ControlList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ReadValue::midw_fi_tcl_e8_ReadValue():enType(FI_EN_DTCSSETBYDIAGNOSTICTEST) {}

tS32 midw_fi_tcl_e8_ReadValue::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_READVALUE;
}


midw_fi_tcl_e8_ReadValue::~midw_fi_tcl_e8_ReadValue()
{}

tU32 midw_fi_tcl_e8_ReadValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ReadValue::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ReadValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VDLMediaType::midw_fi_tcl_e8_VDLMediaType():enType(FI_EN_FFS) {}

tS32 midw_fi_tcl_e8_VDLMediaType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VDLMEDIATYPE;
}


midw_fi_tcl_e8_VDLMediaType::~midw_fi_tcl_e8_VDLMediaType()
{}

tU32 midw_fi_tcl_e8_VDLMediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VDLMediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VDLMediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiaglogDefsetType::midw_fi_tcl_e8_DiaglogDefsetType():enType(FI_EN_CLEAR_ERRMEM) {}

tS32 midw_fi_tcl_e8_DiaglogDefsetType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE;
}


midw_fi_tcl_e8_DiaglogDefsetType::~midw_fi_tcl_e8_DiaglogDefsetType()
{}

tU32 midw_fi_tcl_e8_DiaglogDefsetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiaglogDefsetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiaglogDefsetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SendNextTestResReason::midw_fi_tcl_e8_SendNextTestResReason():enType(FI_EN_CLEAR_CODE) {}

tS32 midw_fi_tcl_e8_SendNextTestResReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SENDNEXTTESTRESREASON;
}


midw_fi_tcl_e8_SendNextTestResReason::~midw_fi_tcl_e8_SendNextTestResReason()
{}

tU32 midw_fi_tcl_e8_SendNextTestResReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SendNextTestResReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SendNextTestResReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SendNextTestResultStructure::midw_fi_tcl_SendNextTestResultStructure(const midw_fi_tcl_SendNextTestResultStructure& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   SendNextTestResReason = coRef.SendNextTestResReason;
   ITCList = coRef.ITCList;
}
midw_fi_tcl_SendNextTestResultStructure& midw_fi_tcl_SendNextTestResultStructure::operator=(const midw_fi_tcl_SendNextTestResultStructure& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SendNextTestResReason = coRef.SendNextTestResReason;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_SendNextTestResultStructure::vDestroy()
{
   {
   ITCList.clear();
   }
}

midw_fi_tcl_SendNextTestResultStructure::midw_fi_tcl_SendNextTestResultStructure()
:Status(0)
,SendNextTestResReason()

 {}

tS32 midw_fi_tcl_SendNextTestResultStructure::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SENDNEXTTESTRESULTSTRUCTURE;
}


midw_fi_tcl_SendNextTestResultStructure::~midw_fi_tcl_SendNextTestResultStructure()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_SendNextTestResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(ITCList.size()*2);
}

fi_tclInContext& midw_fi_tcl_SendNextTestResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SendNextTestResReason);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SendNextTestResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SendNextTestResReason);
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_SendNextTestResultStructure::operator==(const midw_fi_tcl_SendNextTestResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SendNextTestResReason == roRef.SendNextTestResReason);
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ErrorCode::midw_fi_tcl_e8_ErrorCode():enType(FI_EN_FBLOCKIDNOTAVAILABLE) {}

tS32 midw_fi_tcl_e8_ErrorCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ERRORCODE;
}


midw_fi_tcl_e8_ErrorCode::~midw_fi_tcl_e8_ErrorCode()
{}

tU32 midw_fi_tcl_e8_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ErrorCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_GMLnGWDTCFaultType::midw_fi_tcl_e8_GMLnGWDTCFaultType():enType(FI_EN_E8NOT_SUPPORTED) {}

tS32 midw_fi_tcl_e8_GMLnGWDTCFaultType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GMLNGWDTCFAULTTYPE;
}


midw_fi_tcl_e8_GMLnGWDTCFaultType::~midw_fi_tcl_e8_GMLnGWDTCFaultType()
{}

tU32 midw_fi_tcl_e8_GMLnGWDTCFaultType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_GMLnGWDTCFaultType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_GMLnGWDTCFaultType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ActiveDTCList::midw_fi_tcl_ActiveDTCList(const midw_fi_tcl_ActiveDTCList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
midw_fi_tcl_ActiveDTCList& midw_fi_tcl_ActiveDTCList::operator=(const midw_fi_tcl_ActiveDTCList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ActiveDTCList::vDestroy()
{
   {
   DTCList.clear();
   }
}

midw_fi_tcl_ActiveDTCList::midw_fi_tcl_ActiveDTCList()

 {}

tS32 midw_fi_tcl_ActiveDTCList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ACTIVEDTCLIST;
}


midw_fi_tcl_ActiveDTCList::~midw_fi_tcl_ActiveDTCList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ActiveDTCList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*4);
}

fi_tclInContext& midw_fi_tcl_ActiveDTCList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ActiveDTCList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ActiveDTCList::operator==(const midw_fi_tcl_ActiveDTCList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_DiagProtocol::midw_fi_tcl_DiagProtocol():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_DiagProtocol::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DIAGPROTOCOL;
}


midw_fi_tcl_DiagProtocol::~midw_fi_tcl_DiagProtocol()
{}

tU32 midw_fi_tcl_DiagProtocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_DiagProtocol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DiagProtocol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Store::midw_fi_tcl_e8_Store():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_Store::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STORE;
}


midw_fi_tcl_e8_Store::~midw_fi_tcl_e8_Store()
{}

tU32 midw_fi_tcl_e8_Store::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Store::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Store::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RouteCalculationCommand::midw_fi_tcl_e8_RouteCalculationCommand():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_RouteCalculationCommand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND;
}


midw_fi_tcl_e8_RouteCalculationCommand::~midw_fi_tcl_e8_RouteCalculationCommand()
{}

tU32 midw_fi_tcl_e8_RouteCalculationCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RouteCalculationCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RouteCalculationCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RouteCalculationStatus::midw_fi_tcl_e8_RouteCalculationStatus():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_RouteCalculationStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ROUTECALCULATIONSTATUS;
}


midw_fi_tcl_e8_RouteCalculationStatus::~midw_fi_tcl_e8_RouteCalculationStatus()
{}

tU32 midw_fi_tcl_e8_RouteCalculationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RouteCalculationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RouteCalculationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Language::midw_fi_tcl_e8_Language():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_Language::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_LANGUAGE;
}


midw_fi_tcl_e8_Language::~midw_fi_tcl_e8_Language()
{}

tU32 midw_fi_tcl_e8_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Country::midw_fi_tcl_e8_Country():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_Country::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_COUNTRY;
}


midw_fi_tcl_e8_Country::~midw_fi_tcl_e8_Country()
{}

tU32 midw_fi_tcl_e8_Country::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Country::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Country::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_LanguageSubsystem::midw_fi_tcl_e8_LanguageSubsystem():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_LanguageSubsystem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_LANGUAGESUBSYSTEM;
}


midw_fi_tcl_e8_LanguageSubsystem::~midw_fi_tcl_e8_LanguageSubsystem()
{}

tU32 midw_fi_tcl_e8_LanguageSubsystem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_LanguageSubsystem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_LanguageSubsystem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TestScreens::midw_fi_tcl_e8_TestScreens():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_TestScreens::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TESTSCREENS;
}


midw_fi_tcl_e8_TestScreens::~midw_fi_tcl_e8_TestScreens()
{}

tU32 midw_fi_tcl_e8_TestScreens::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TestScreens::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TestScreens::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayStringsList::midw_fi_tcl_DisplayStringsList(const midw_fi_tcl_DisplayStringsList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   StringList = coRef.StringList;
}
midw_fi_tcl_DisplayStringsList& midw_fi_tcl_DisplayStringsList::operator=(const midw_fi_tcl_DisplayStringsList& coRef)
{
   if (this == &coRef) return *this;
   StringList = coRef.StringList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DisplayStringsList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         StringList[u32Idx].vDestroy();
   StringList.clear();
   }
}

midw_fi_tcl_DisplayStringsList::midw_fi_tcl_DisplayStringsList()

 {}

tS32 midw_fi_tcl_DisplayStringsList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYSTRINGSLIST;
}


midw_fi_tcl_DisplayStringsList::~midw_fi_tcl_DisplayStringsList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DisplayStringsList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringList.size(); ++u32ListIdx)
      u32DynamicSize += StringList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_fi_tcl_DisplayStringsList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
      {
         StringList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayStringsList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         (tVoid) (oOut << StringList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DisplayStringsList::operator==(const midw_fi_tcl_DisplayStringsList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringList.size() == roRef.StringList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringList.size()); ++u32Idx)
            bResult = bResult && (StringList[u32Idx] == roRef.StringList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayData::midw_fi_tcl_DisplayData(const midw_fi_tcl_DisplayData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TestScreen = coRef.TestScreen;
   DisplayStrings = coRef.DisplayStrings;
}
midw_fi_tcl_DisplayData& midw_fi_tcl_DisplayData::operator=(const midw_fi_tcl_DisplayData& coRef)
{
   if (this == &coRef) return *this;
   TestScreen = coRef.TestScreen;
   DisplayStrings = coRef.DisplayStrings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DisplayData::vDestroy()
{
   DisplayStrings.vDestroy(); 
}

midw_fi_tcl_DisplayData::midw_fi_tcl_DisplayData()
:TestScreen()
,DisplayStrings()
 {}

tS32 midw_fi_tcl_DisplayData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYDATA;
}


midw_fi_tcl_DisplayData::~midw_fi_tcl_DisplayData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DisplayData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DisplayStrings.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DisplayData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestScreen);
   (tVoid) (oIn >> DisplayStrings);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestScreen);
   (tVoid) (oOut << DisplayStrings);
   return oOut;
}

tBool midw_fi_tcl_DisplayData::operator==(const midw_fi_tcl_DisplayData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestScreen == roRef.TestScreen);
   bResult = bResult && (DisplayStrings == roRef.DisplayStrings);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TroubleCodeType::midw_fi_tcl_e8_TroubleCodeType():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_TroubleCodeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TROUBLECODETYPE;
}


midw_fi_tcl_e8_TroubleCodeType::~midw_fi_tcl_e8_TroubleCodeType()
{}

tU32 midw_fi_tcl_e8_TroubleCodeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TroubleCodeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TroubleCodeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TestRoutines::midw_fi_tcl_e8_TestRoutines():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_TestRoutines::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TESTROUTINES;
}


midw_fi_tcl_e8_TestRoutines::~midw_fi_tcl_e8_TestRoutines()
{}

tU32 midw_fi_tcl_e8_TestRoutines::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TestRoutines::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TestRoutines::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DefaultSettingsCategories::midw_fi_tcl_e8_DefaultSettingsCategories():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_DefaultSettingsCategories::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES;
}


midw_fi_tcl_e8_DefaultSettingsCategories::~midw_fi_tcl_e8_DefaultSettingsCategories()
{}

tU32 midw_fi_tcl_e8_DefaultSettingsCategories::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DefaultSettingsCategories::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DefaultSettingsCategories::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CountryLanguage::midw_fi_tcl_CountryLanguage(const midw_fi_tcl_CountryLanguage& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Country = coRef.Country;
   Language = coRef.Language;
   Subsystem = coRef.Subsystem;
}
midw_fi_tcl_CountryLanguage& midw_fi_tcl_CountryLanguage::operator=(const midw_fi_tcl_CountryLanguage& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   Language = coRef.Language;
   Subsystem = coRef.Subsystem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_CountryLanguage::midw_fi_tcl_CountryLanguage()
:Country()
,Language()
,Subsystem()
 {}

tS32 midw_fi_tcl_CountryLanguage::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_COUNTRYLANGUAGE;
}


midw_fi_tcl_CountryLanguage::~midw_fi_tcl_CountryLanguage()
{}

tU32 midw_fi_tcl_CountryLanguage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_CountryLanguage::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> Language);
   (tVoid) (oIn >> Subsystem);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CountryLanguage::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << Language);
   (tVoid) (oOut << Subsystem);
   return oOut;
}

tBool midw_fi_tcl_CountryLanguage::operator==(const midw_fi_tcl_CountryLanguage& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (Language == roRef.Language);
   bResult = bResult && (Subsystem == roRef.Subsystem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CountryLanguageResult::midw_fi_tcl_CountryLanguageResult(const midw_fi_tcl_CountryLanguageResult& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Success = coRef.Success;
   CountryLanguageList = coRef.CountryLanguageList;
}
midw_fi_tcl_CountryLanguageResult& midw_fi_tcl_CountryLanguageResult::operator=(const midw_fi_tcl_CountryLanguageResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   CountryLanguageList = coRef.CountryLanguageList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CountryLanguageResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
         CountryLanguageList[u32Idx].vDestroy();
   CountryLanguageList.clear();
   }
}

midw_fi_tcl_CountryLanguageResult::midw_fi_tcl_CountryLanguageResult()
:Success(0)

 {}

tS32 midw_fi_tcl_CountryLanguageResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_COUNTRYLANGUAGERESULT;
}


midw_fi_tcl_CountryLanguageResult::~midw_fi_tcl_CountryLanguageResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CountryLanguageResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(CountryLanguageList.size()*3);
}

fi_tclInContext& midw_fi_tcl_CountryLanguageResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
      {
         CountryLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryLanguageList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CountryLanguageResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   (tVoid) (oOut << (tU32)CountryLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << CountryLanguageList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_CountryLanguageResult::operator==(const midw_fi_tcl_CountryLanguageResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
      bResult = bResult && (CountryLanguageList.size() == roRef.CountryLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryLanguageList.size()); ++u32Idx)
            bResult = bResult && (CountryLanguageList[u32Idx] == roRef.CountryLanguageList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TroubleCodeStatus::midw_fi_tcl_e8_TroubleCodeStatus():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_TroubleCodeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TROUBLECODESTATUS;
}


midw_fi_tcl_e8_TroubleCodeStatus::~midw_fi_tcl_e8_TroubleCodeStatus()
{}

tU32 midw_fi_tcl_e8_TroubleCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TroubleCodeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TroubleCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TroubleCode::midw_fi_tcl_TroubleCode(const midw_fi_tcl_TroubleCode& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   Status = coRef.Status;
}
midw_fi_tcl_TroubleCode& midw_fi_tcl_TroubleCode::operator=(const midw_fi_tcl_TroubleCode& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TroubleCode::midw_fi_tcl_TroubleCode()
:TroubleCode(0)
,Status()
 {}

tS32 midw_fi_tcl_TroubleCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TROUBLECODE;
}


midw_fi_tcl_TroubleCode::~midw_fi_tcl_TroubleCode()
{}

tU32 midw_fi_tcl_TroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TroubleCode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_fi_tcl_TroubleCode::operator==(const midw_fi_tcl_TroubleCode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TroubleCodeList::midw_fi_tcl_TroubleCodeList(const midw_fi_tcl_TroubleCodeList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCodeList = coRef.TroubleCodeList;
}
midw_fi_tcl_TroubleCodeList& midw_fi_tcl_TroubleCodeList::operator=(const midw_fi_tcl_TroubleCodeList& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeList = coRef.TroubleCodeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TroubleCodeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
         TroubleCodeList[u32Idx].vDestroy();
   TroubleCodeList.clear();
   }
}

midw_fi_tcl_TroubleCodeList::midw_fi_tcl_TroubleCodeList()

 {}

tS32 midw_fi_tcl_TroubleCodeList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TROUBLECODELIST;
}


midw_fi_tcl_TroubleCodeList::~midw_fi_tcl_TroubleCodeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TroubleCodeList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TroubleCodeList.size()*5);
}

fi_tclInContext& midw_fi_tcl_TroubleCodeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
      {
         TroubleCodeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TroubleCodeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TroubleCodeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TroubleCodeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TroubleCodeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
         (tVoid) (oOut << TroubleCodeList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TroubleCodeList::operator==(const midw_fi_tcl_TroubleCodeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TroubleCodeList.size() == roRef.TroubleCodeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TroubleCodeList.size()); ++u32Idx)
            bResult = bResult && (TroubleCodeList[u32Idx] == roRef.TroubleCodeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_RouteCalculationStartParameter::midw_fi_tcl_RouteCalculationStartParameter(const midw_fi_tcl_RouteCalculationStartParameter& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
}
midw_fi_tcl_RouteCalculationStartParameter& midw_fi_tcl_RouteCalculationStartParameter::operator=(const midw_fi_tcl_RouteCalculationStartParameter& coRef)
{
   if (this == &coRef) return *this;
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_RouteCalculationStartParameter::midw_fi_tcl_RouteCalculationStartParameter()
:CurrentPositionLongitude(0)
,CurrentPositionLatitude(0)
,DestinationLongitude(0)
,DestinationLatitude(0)
,RouteIndex(0)
,RouteOptimisation(0)
,Command()
 {}

tS32 midw_fi_tcl_RouteCalculationStartParameter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ROUTECALCULATIONSTARTPARAMETER;
}


midw_fi_tcl_RouteCalculationStartParameter::~midw_fi_tcl_RouteCalculationStartParameter()
{}

tU32 midw_fi_tcl_RouteCalculationStartParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& midw_fi_tcl_RouteCalculationStartParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentPositionLongitude);
   (tVoid) (oIn >> CurrentPositionLatitude);
   (tVoid) (oIn >> DestinationLongitude);
   (tVoid) (oIn >> DestinationLatitude);
   (tVoid) (oIn >> RouteIndex);
   (tVoid) (oIn >> RouteOptimisation);
   (tVoid) (oIn >> Command);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_RouteCalculationStartParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentPositionLongitude);
   (tVoid) (oOut << CurrentPositionLatitude);
   (tVoid) (oOut << DestinationLongitude);
   (tVoid) (oOut << DestinationLatitude);
   (tVoid) (oOut << RouteIndex);
   (tVoid) (oOut << RouteOptimisation);
   (tVoid) (oOut << Command);
   return oOut;
}

tBool midw_fi_tcl_RouteCalculationStartParameter::operator==(const midw_fi_tcl_RouteCalculationStartParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentPositionLongitude == roRef.CurrentPositionLongitude);
   bResult = bResult && (CurrentPositionLatitude == roRef.CurrentPositionLatitude);
   bResult = bResult && (DestinationLongitude == roRef.DestinationLongitude);
   bResult = bResult && (DestinationLatitude == roRef.DestinationLatitude);
   bResult = bResult && (RouteIndex == roRef.RouteIndex);
   bResult = bResult && (RouteOptimisation == roRef.RouteOptimisation);
   bResult = bResult && (Command == roRef.Command);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_RouteCalculationResultParameter::midw_fi_tcl_RouteCalculationResultParameter(const midw_fi_tcl_RouteCalculationResultParameter& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   RouteCalculationStatus = coRef.RouteCalculationStatus;
   RouteLength = coRef.RouteLength;
   RouteDuration = coRef.RouteDuration;
}
midw_fi_tcl_RouteCalculationResultParameter& midw_fi_tcl_RouteCalculationResultParameter::operator=(const midw_fi_tcl_RouteCalculationResultParameter& coRef)
{
   if (this == &coRef) return *this;
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   RouteCalculationStatus = coRef.RouteCalculationStatus;
   RouteLength = coRef.RouteLength;
   RouteDuration = coRef.RouteDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_RouteCalculationResultParameter::midw_fi_tcl_RouteCalculationResultParameter()
:CurrentPositionLongitude(0)
,CurrentPositionLatitude(0)
,DestinationLongitude(0)
,DestinationLatitude(0)
,RouteIndex(0)
,RouteOptimisation(0)
,Command()
,RouteCalculationStatus()
,RouteLength(0)
,RouteDuration(0)
 {}

tS32 midw_fi_tcl_RouteCalculationResultParameter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ROUTECALCULATIONRESULTPARAMETER;
}


midw_fi_tcl_RouteCalculationResultParameter::~midw_fi_tcl_RouteCalculationResultParameter()
{}

tU32 midw_fi_tcl_RouteCalculationResultParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& midw_fi_tcl_RouteCalculationResultParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentPositionLongitude);
   (tVoid) (oIn >> CurrentPositionLatitude);
   (tVoid) (oIn >> DestinationLongitude);
   (tVoid) (oIn >> DestinationLatitude);
   (tVoid) (oIn >> RouteIndex);
   (tVoid) (oIn >> RouteOptimisation);
   (tVoid) (oIn >> Command);
   (tVoid) (oIn >> RouteCalculationStatus);
   (tVoid) (oIn >> RouteLength);
   (tVoid) (oIn >> RouteDuration);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_RouteCalculationResultParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentPositionLongitude);
   (tVoid) (oOut << CurrentPositionLatitude);
   (tVoid) (oOut << DestinationLongitude);
   (tVoid) (oOut << DestinationLatitude);
   (tVoid) (oOut << RouteIndex);
   (tVoid) (oOut << RouteOptimisation);
   (tVoid) (oOut << Command);
   (tVoid) (oOut << RouteCalculationStatus);
   (tVoid) (oOut << RouteLength);
   (tVoid) (oOut << RouteDuration);
   return oOut;
}

tBool midw_fi_tcl_RouteCalculationResultParameter::operator==(const midw_fi_tcl_RouteCalculationResultParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentPositionLongitude == roRef.CurrentPositionLongitude);
   bResult = bResult && (CurrentPositionLatitude == roRef.CurrentPositionLatitude);
   bResult = bResult && (DestinationLongitude == roRef.DestinationLongitude);
   bResult = bResult && (DestinationLatitude == roRef.DestinationLatitude);
   bResult = bResult && (RouteIndex == roRef.RouteIndex);
   bResult = bResult && (RouteOptimisation == roRef.RouteOptimisation);
   bResult = bResult && (Command == roRef.Command);
   bResult = bResult && (RouteCalculationStatus == roRef.RouteCalculationStatus);
   bResult = bResult && (RouteLength == roRef.RouteLength);
   bResult = bResult && (RouteDuration == roRef.RouteDuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_Language::midw_fi_tcl_e16_Language():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e16_Language::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_LANGUAGE;
}


midw_fi_tcl_e16_Language::~midw_fi_tcl_e16_Language()
{}

tU32 midw_fi_tcl_e16_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_Language::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_SpeedLock::midw_fi_tcl_e16_SpeedLock():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e16_SpeedLock::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_SPEEDLOCK;
}


midw_fi_tcl_e16_SpeedLock::~midw_fi_tcl_e16_SpeedLock()
{}

tU32 midw_fi_tcl_e16_SpeedLock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_SpeedLock::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_SpeedLock::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MessageBuffer::midw_fi_tcl_MessageBuffer(const midw_fi_tcl_MessageBuffer& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MessageBuffer = coRef.MessageBuffer;
}
midw_fi_tcl_MessageBuffer& midw_fi_tcl_MessageBuffer::operator=(const midw_fi_tcl_MessageBuffer& coRef)
{
   if (this == &coRef) return *this;
   MessageBuffer = coRef.MessageBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MessageBuffer::vDestroy()
{
   {
   MessageBuffer.clear();
   }
}

midw_fi_tcl_MessageBuffer::midw_fi_tcl_MessageBuffer()

 {}

tS32 midw_fi_tcl_MessageBuffer::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MESSAGEBUFFER;
}


midw_fi_tcl_MessageBuffer::~midw_fi_tcl_MessageBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MessageBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MessageBuffer.size()*1);
}

fi_tclInContext& midw_fi_tcl_MessageBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      MessageBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MessageBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MessageBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MessageBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MessageBuffer.size(); ++u32Idx)
         (tVoid) (oOut << MessageBuffer[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_MessageBuffer::operator==(const midw_fi_tcl_MessageBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MessageBuffer.size() == roRef.MessageBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MessageBuffer.size()); ++u32Idx)
            bResult = bResult && (MessageBuffer[u32Idx] == roRef.MessageBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DefSetMode::midw_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_NOT_DEF) {}

tS32 midw_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEFSETMODE;
}


midw_fi_tcl_e8_DefSetMode::~midw_fi_tcl_e8_DefSetMode()
{}

tU32 midw_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DefSetServiceStatus::midw_fi_tcl_e8_DefSetServiceStatus():enType(FI_EN_DEFSET_STATE_UNDEFINED) {}

tS32 midw_fi_tcl_e8_DefSetServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEFSETSERVICESTATUS;
}


midw_fi_tcl_e8_DefSetServiceStatus::~midw_fi_tcl_e8_DefSetServiceStatus()
{}

tU32 midw_fi_tcl_e8_DefSetServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DefSetServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DefSetServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DefSetGroups::midw_fi_tcl_e8_DefSetGroups():enType(FI_EN_DEFSET_GROUP_UNDEFIEND) {}

tS32 midw_fi_tcl_e8_DefSetGroups::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEFSETGROUPS;
}


midw_fi_tcl_e8_DefSetGroups::~midw_fi_tcl_e8_DefSetGroups()
{}

tU32 midw_fi_tcl_e8_DefSetGroups::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DefSetGroups::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DefSetGroups::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagMausSetup::midw_fi_tcl_e8_DiagMausSetup():enType(FI_EN_MAUS_STATE_UNDEFINED) {}

tS32 midw_fi_tcl_e8_DiagMausSetup::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGMAUSSETUP;
}


midw_fi_tcl_e8_DiagMausSetup::~midw_fi_tcl_e8_DiagMausSetup()
{}

tU32 midw_fi_tcl_e8_DiagMausSetup::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagMausSetup::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagMausSetup::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SimulatedKeys::midw_fi_tcl_e8_SimulatedKeys():enType(FI_EN_KEY_CODE_SOFTKEY_UNDEFINED) {}

tS32 midw_fi_tcl_e8_SimulatedKeys::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SIMULATEDKEYS;
}


midw_fi_tcl_e8_SimulatedKeys::~midw_fi_tcl_e8_SimulatedKeys()
{}

tU32 midw_fi_tcl_e8_SimulatedKeys::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SimulatedKeys::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SimulatedKeys::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_KDSItemList::midw_fi_tcl_KDSItemList(const midw_fi_tcl_KDSItemList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
midw_fi_tcl_KDSItemList& midw_fi_tcl_KDSItemList::operator=(const midw_fi_tcl_KDSItemList& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_KDSItemList::vDestroy()
{
   {
   itemList.clear();
   }
}

midw_fi_tcl_KDSItemList::midw_fi_tcl_KDSItemList()

 {}

tS32 midw_fi_tcl_KDSItemList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_KDSITEMLIST;
}


midw_fi_tcl_KDSItemList::~midw_fi_tcl_KDSItemList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_KDSItemList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& midw_fi_tcl_KDSItemList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_KDSItemList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_KDSItemList::operator==(const midw_fi_tcl_KDSItemList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ConfigItemList::midw_fi_tcl_ConfigItemList(const midw_fi_tcl_ConfigItemList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
midw_fi_tcl_ConfigItemList& midw_fi_tcl_ConfigItemList::operator=(const midw_fi_tcl_ConfigItemList& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ConfigItemList::vDestroy()
{
   {
   itemList.clear();
   }
}

midw_fi_tcl_ConfigItemList::midw_fi_tcl_ConfigItemList()

 {}

tS32 midw_fi_tcl_ConfigItemList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CONFIGITEMLIST;
}


midw_fi_tcl_ConfigItemList::~midw_fi_tcl_ConfigItemList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ConfigItemList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& midw_fi_tcl_ConfigItemList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ConfigItemList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ConfigItemList::operator==(const midw_fi_tcl_ConfigItemList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_RequestDataUDS::midw_fi_tcl_RequestDataUDS(const midw_fi_tcl_RequestDataUDS& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
midw_fi_tcl_RequestDataUDS& midw_fi_tcl_RequestDataUDS::operator=(const midw_fi_tcl_RequestDataUDS& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_RequestDataUDS::vDestroy()
{
   {
   itemList.clear();
   }
}

midw_fi_tcl_RequestDataUDS::midw_fi_tcl_RequestDataUDS()

 {}

tS32 midw_fi_tcl_RequestDataUDS::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_REQUESTDATAUDS;
}


midw_fi_tcl_RequestDataUDS::~midw_fi_tcl_RequestDataUDS()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_RequestDataUDS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& midw_fi_tcl_RequestDataUDS::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_RequestDataUDS::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_RequestDataUDS::operator==(const midw_fi_tcl_RequestDataUDS& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ResponseDataUDS::midw_fi_tcl_ResponseDataUDS(const midw_fi_tcl_ResponseDataUDS& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
midw_fi_tcl_ResponseDataUDS& midw_fi_tcl_ResponseDataUDS::operator=(const midw_fi_tcl_ResponseDataUDS& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ResponseDataUDS::vDestroy()
{
   {
   itemList.clear();
   }
}

midw_fi_tcl_ResponseDataUDS::midw_fi_tcl_ResponseDataUDS()

 {}

tS32 midw_fi_tcl_ResponseDataUDS::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_RESPONSEDATAUDS;
}


midw_fi_tcl_ResponseDataUDS::~midw_fi_tcl_ResponseDataUDS()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ResponseDataUDS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& midw_fi_tcl_ResponseDataUDS::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ResponseDataUDS::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_ResponseDataUDS::operator==(const midw_fi_tcl_ResponseDataUDS& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DiagData::midw_fi_tcl_DiagData(const midw_fi_tcl_DiagData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
midw_fi_tcl_DiagData& midw_fi_tcl_DiagData::operator=(const midw_fi_tcl_DiagData& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DiagData::vDestroy()
{
   {
   itemList.clear();
   }
}

midw_fi_tcl_DiagData::midw_fi_tcl_DiagData()

 {}

tS32 midw_fi_tcl_DiagData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DIAGDATA;
}


midw_fi_tcl_DiagData::~midw_fi_tcl_DiagData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DiagData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& midw_fi_tcl_DiagData::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DiagData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DiagData::operator==(const midw_fi_tcl_DiagData& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RCtrlSource::midw_fi_tcl_e8_RCtrlSource():enType(FI_EN_RCTRL_SRC_UNKNOWN) {}

tS32 midw_fi_tcl_e8_RCtrlSource::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RCTRLSOURCE;
}


midw_fi_tcl_e8_RCtrlSource::~midw_fi_tcl_e8_RCtrlSource()
{}

tU32 midw_fi_tcl_e8_RCtrlSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RCtrlSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RCtrlSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RCtrlCommand::midw_fi_tcl_e8_RCtrlCommand():enType(FI_EN_RCTRL_CMD_DEACTIVATE) {}

tS32 midw_fi_tcl_e8_RCtrlCommand::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RCTRLCOMMAND;
}


midw_fi_tcl_e8_RCtrlCommand::~midw_fi_tcl_e8_RCtrlCommand()
{}

tU32 midw_fi_tcl_e8_RCtrlCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RCtrlCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RCtrlCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RCtrlSignal::midw_fi_tcl_e8_RCtrlSignal():enType(FI_EN_RCTRL_SIG_ALL) {}

tS32 midw_fi_tcl_e8_RCtrlSignal::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RCTRLSIGNAL;
}


midw_fi_tcl_e8_RCtrlSignal::~midw_fi_tcl_e8_RCtrlSignal()
{}

tU32 midw_fi_tcl_e8_RCtrlSignal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RCtrlSignal::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RCtrlSignal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagRVCSignal::midw_fi_tcl_e8_DiagRVCSignal():enType(FI_EN_EXT_VIDEO_SIGNAL_ON) {}

tS32 midw_fi_tcl_e8_DiagRVCSignal::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGRVCSIGNAL;
}


midw_fi_tcl_e8_DiagRVCSignal::~midw_fi_tcl_e8_DiagRVCSignal()
{}

tU32 midw_fi_tcl_e8_DiagRVCSignal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagRVCSignal::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagRVCSignal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_CalibrationTable::midw_fi_tcl_e8_CalibrationTable():enType(FI_EN_CALIBRATION_TABLE_ID_SYSTEM) {}

tS32 midw_fi_tcl_e8_CalibrationTable::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_CALIBRATIONTABLE;
}


midw_fi_tcl_e8_CalibrationTable::~midw_fi_tcl_e8_CalibrationTable()
{}

tU32 midw_fi_tcl_e8_CalibrationTable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_CalibrationTable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_CalibrationTable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CalibrationValue::midw_fi_tcl_CalibrationValue(const midw_fi_tcl_CalibrationValue& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   ByteValue = coRef.ByteValue;
}
midw_fi_tcl_CalibrationValue& midw_fi_tcl_CalibrationValue::operator=(const midw_fi_tcl_CalibrationValue& coRef)
{
   if (this == &coRef) return *this;
   ByteValue = coRef.ByteValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CalibrationValue::vDestroy()
{
   {
   ByteValue.clear();
   }
}

midw_fi_tcl_CalibrationValue::midw_fi_tcl_CalibrationValue()

 {}

tS32 midw_fi_tcl_CalibrationValue::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CALIBRATIONVALUE;
}


midw_fi_tcl_CalibrationValue::~midw_fi_tcl_CalibrationValue()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CalibrationValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ByteValue.size()*1);
}

fi_tclInContext& midw_fi_tcl_CalibrationValue::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ByteValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ByteValue[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CalibrationValue::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ByteValue.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ByteValue.size(); ++u32Idx)
         (tVoid) (oOut << ByteValue[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_CalibrationValue::operator==(const midw_fi_tcl_CalibrationValue& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ByteValue.size() == roRef.ByteValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ByteValue.size()); ++u32Idx)
            bResult = bResult && (ByteValue[u32Idx] == roRef.ByteValue[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_CalibrationTimeStampMonth::midw_fi_tcl_e8_CalibrationTimeStampMonth():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_CalibrationTimeStampMonth::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_CALIBRATIONTIMESTAMPMONTH;
}


midw_fi_tcl_e8_CalibrationTimeStampMonth::~midw_fi_tcl_e8_CalibrationTimeStampMonth()
{}

tU32 midw_fi_tcl_e8_CalibrationTimeStampMonth::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_CalibrationTimeStampMonth::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_CalibrationTimeStampMonth::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CalibrationTimeStamp::midw_fi_tcl_CalibrationTimeStamp(const midw_fi_tcl_CalibrationTimeStamp& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Hours = coRef.Hours;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   Day = coRef.Day;
   Month = coRef.Month;
   Year = coRef.Year;
}
midw_fi_tcl_CalibrationTimeStamp& midw_fi_tcl_CalibrationTimeStamp::operator=(const midw_fi_tcl_CalibrationTimeStamp& coRef)
{
   if (this == &coRef) return *this;
   Hours = coRef.Hours;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   Day = coRef.Day;
   Month = coRef.Month;
   Year = coRef.Year;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_CalibrationTimeStamp::midw_fi_tcl_CalibrationTimeStamp()
:Hours(0)
,Minutes(0)
,Seconds(0)
,Day(0)
,Month(0)
,Year(0)
 {}

tS32 midw_fi_tcl_CalibrationTimeStamp::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CALIBRATIONTIMESTAMP;
}


midw_fi_tcl_CalibrationTimeStamp::~midw_fi_tcl_CalibrationTimeStamp()
{}

tU32 midw_fi_tcl_CalibrationTimeStamp::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_CalibrationTimeStamp::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hours);
   (tVoid) (oIn >> Minutes);
   (tVoid) (oIn >> Seconds);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Year);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CalibrationTimeStamp::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hours);
   (tVoid) (oOut << Minutes);
   (tVoid) (oOut << Seconds);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Year);
   return oOut;
}

tBool midw_fi_tcl_CalibrationTimeStamp::operator==(const midw_fi_tcl_CalibrationTimeStamp& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hours == roRef.Hours);
   bResult = bResult && (Minutes == roRef.Minutes);
   bResult = bResult && (Seconds == roRef.Seconds);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Year == roRef.Year);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AlphaCode::midw_fi_tcl_AlphaCode(const midw_fi_tcl_AlphaCode& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Letter = coRef.Letter;
}
midw_fi_tcl_AlphaCode& midw_fi_tcl_AlphaCode::operator=(const midw_fi_tcl_AlphaCode& coRef)
{
   if (this == &coRef) return *this;
   Letter = coRef.Letter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AlphaCode::vDestroy()
{
   {
   Letter.clear();
   }
}

midw_fi_tcl_AlphaCode::midw_fi_tcl_AlphaCode()

 {}

tS32 midw_fi_tcl_AlphaCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ALPHACODE;
}


midw_fi_tcl_AlphaCode::~midw_fi_tcl_AlphaCode()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AlphaCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Letter.size()*1);
}

fi_tclInContext& midw_fi_tcl_AlphaCode::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Letter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Letter[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AlphaCode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Letter.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Letter.size(); ++u32Idx)
         (tVoid) (oOut << Letter[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_AlphaCode::operator==(const midw_fi_tcl_AlphaCode& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Letter.size() == roRef.Letter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Letter.size()); ++u32Idx)
            bResult = bResult && (Letter[u32Idx] == roRef.Letter[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_CalibrationParameterSize::midw_fi_tcl_e8_CalibrationParameterSize():enType(FI_EN_CALIBRATION_SIZE_BIT) {}

tS32 midw_fi_tcl_e8_CalibrationParameterSize::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_CALIBRATIONPARAMETERSIZE;
}


midw_fi_tcl_e8_CalibrationParameterSize::~midw_fi_tcl_e8_CalibrationParameterSize()
{}

tU32 midw_fi_tcl_e8_CalibrationParameterSize::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_CalibrationParameterSize::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_CalibrationParameterSize::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_KdsViaUsbUpdateStatus::midw_fi_tcl_e8_KdsViaUsbUpdateStatus():enType(FI_EN_UNDEFINED) {}

tS32 midw_fi_tcl_e8_KdsViaUsbUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_KDSVIAUSBUPDATESTATUS;
}


midw_fi_tcl_e8_KdsViaUsbUpdateStatus::~midw_fi_tcl_e8_KdsViaUsbUpdateStatus()
{}

tU32 midw_fi_tcl_e8_KdsViaUsbUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_KdsViaUsbUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_KdsViaUsbUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AntiTheftStatus::midw_fi_tcl_AntiTheftStatus():enType(FI_EN_HU_UNLOCKED) {}

tS32 midw_fi_tcl_AntiTheftStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ANTITHEFTSTATUS;
}


midw_fi_tcl_AntiTheftStatus::~midw_fi_tcl_AntiTheftStatus()
{}

tU32 midw_fi_tcl_AntiTheftStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_AntiTheftStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AntiTheftStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_Aud_TroubleCode::midw_fi_tcl_e16_Aud_TroubleCode():enType(FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED) {}

tS32 midw_fi_tcl_e16_Aud_TroubleCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_AUD_TROUBLECODE;
}


midw_fi_tcl_e16_Aud_TroubleCode::~midw_fi_tcl_e16_Aud_TroubleCode()
{}

tU32 midw_fi_tcl_e16_Aud_TroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_Aud_TroubleCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_Aud_TroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_MonitoringMode::midw_fi_tcl_e8_Aud_MonitoringMode():enType(FI_EN_FC_AUDIO_MONITORING_OFF) {}

tS32 midw_fi_tcl_e8_Aud_MonitoringMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_MONITORINGMODE;
}


midw_fi_tcl_e8_Aud_MonitoringMode::~midw_fi_tcl_e8_Aud_MonitoringMode()
{}

tU32 midw_fi_tcl_e8_Aud_MonitoringMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_MonitoringMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_MonitoringMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_SupervisionControl::midw_fi_tcl_e8_Aud_SupervisionControl():enType(FI_EN_FC_AUDIO_SUPERVISION_DEFAULT) {}

tS32 midw_fi_tcl_e8_Aud_SupervisionControl::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_SUPERVISIONCONTROL;
}


midw_fi_tcl_e8_Aud_SupervisionControl::~midw_fi_tcl_e8_Aud_SupervisionControl()
{}

tU32 midw_fi_tcl_e8_Aud_SupervisionControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_SupervisionControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_SupervisionControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_ErrorStatus::midw_fi_tcl_e8_Aud_ErrorStatus():enType(FI_EN_FC_AUDIO_TEST_PASSED) {}

tS32 midw_fi_tcl_e8_Aud_ErrorStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_ERRORSTATUS;
}


midw_fi_tcl_e8_Aud_ErrorStatus::~midw_fi_tcl_e8_Aud_ErrorStatus()
{}

tU32 midw_fi_tcl_e8_Aud_ErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_ErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_ErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_RoutineStatus::midw_fi_tcl_e8_Aud_RoutineStatus():enType(FI_EN_FC_AUDIO_ROUTINE_NOT_RUNNING) {}

tS32 midw_fi_tcl_e8_Aud_RoutineStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_ROUTINESTATUS;
}


midw_fi_tcl_e8_Aud_RoutineStatus::~midw_fi_tcl_e8_Aud_RoutineStatus()
{}

tU32 midw_fi_tcl_e8_Aud_RoutineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_RoutineStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_RoutineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_WriteTestErrorStatus::midw_fi_tcl_e8_Aud_WriteTestErrorStatus():enType(FI_EN_FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG) {}

tS32 midw_fi_tcl_e8_Aud_WriteTestErrorStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_WRITETESTERRORSTATUS;
}


midw_fi_tcl_e8_Aud_WriteTestErrorStatus::~midw_fi_tcl_e8_Aud_WriteTestErrorStatus()
{}

tU32 midw_fi_tcl_e8_Aud_WriteTestErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_WriteTestErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_WriteTestErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_SpeakerType::midw_fi_tcl_e8_Aud_SpeakerType():enType(FI_EN_FC_AUDIO_SPEAKER_UNDEF) {}

tS32 midw_fi_tcl_e8_Aud_SpeakerType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_SPEAKERTYPE;
}


midw_fi_tcl_e8_Aud_SpeakerType::~midw_fi_tcl_e8_Aud_SpeakerType()
{}

tU32 midw_fi_tcl_e8_Aud_SpeakerType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_SpeakerType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_SpeakerType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_TestToneControl::midw_fi_tcl_e8_Aud_TestToneControl():enType(FI_EN_FC_AUDIO_TEST_TONE_UNDEF) {}

tS32 midw_fi_tcl_e8_Aud_TestToneControl::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_TESTTONECONTROL;
}


midw_fi_tcl_e8_Aud_TestToneControl::~midw_fi_tcl_e8_Aud_TestToneControl()
{}

tU32 midw_fi_tcl_e8_Aud_TestToneControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_TestToneControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_TestToneControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_FreqTestTone::midw_fi_tcl_e8_Aud_FreqTestTone():enType(FI_EN_FC_AUDIO_FREQ_TEST_TONE_DEFAULT) {}

tS32 midw_fi_tcl_e8_Aud_FreqTestTone::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_FREQTESTTONE;
}


midw_fi_tcl_e8_Aud_FreqTestTone::~midw_fi_tcl_e8_Aud_FreqTestTone()
{}

tU32 midw_fi_tcl_e8_Aud_FreqTestTone::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_FreqTestTone::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_FreqTestTone::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_TestRoutineParameter::midw_fi_tcl_Aud_TestRoutineParameter(const midw_fi_tcl_Aud_TestRoutineParameter& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
}
midw_fi_tcl_Aud_TestRoutineParameter& midw_fi_tcl_Aud_TestRoutineParameter::operator=(const midw_fi_tcl_Aud_TestRoutineParameter& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   WriteToRM = coRef.WriteToRM;
   MonitoringMode = coRef.MonitoringMode;
   SupervisionControl = coRef.SupervisionControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_TestRoutineParameter::midw_fi_tcl_Aud_TestRoutineParameter()
:TroubleCode()
,WriteToRM(0)
,MonitoringMode()
,SupervisionControl()
 {}

tS32 midw_fi_tcl_Aud_TestRoutineParameter::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_TESTROUTINEPARAMETER;
}


midw_fi_tcl_Aud_TestRoutineParameter::~midw_fi_tcl_Aud_TestRoutineParameter()
{}

tU32 midw_fi_tcl_Aud_TestRoutineParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_Aud_TestRoutineParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> WriteToRM);
   (tVoid) (oIn >> MonitoringMode);
   (tVoid) (oIn >> SupervisionControl);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_TestRoutineParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << WriteToRM);
   (tVoid) (oOut << MonitoringMode);
   (tVoid) (oOut << SupervisionControl);
   return oOut;
}

tBool midw_fi_tcl_Aud_TestRoutineParameter::operator==(const midw_fi_tcl_Aud_TestRoutineParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (WriteToRM == roRef.WriteToRM);
   bResult = bResult && (MonitoringMode == roRef.MonitoringMode);
   bResult = bResult && (SupervisionControl == roRef.SupervisionControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_TestRoutineParameterList::midw_fi_tcl_Aud_TestRoutineParameterList(const midw_fi_tcl_Aud_TestRoutineParameterList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
midw_fi_tcl_Aud_TestRoutineParameterList& midw_fi_tcl_Aud_TestRoutineParameterList::operator=(const midw_fi_tcl_Aud_TestRoutineParameterList& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Aud_TestRoutineParameterList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         TestRoutineParameterList[u32Idx].vDestroy();
   TestRoutineParameterList.clear();
   }
}

midw_fi_tcl_Aud_TestRoutineParameterList::midw_fi_tcl_Aud_TestRoutineParameterList()

 {}

tS32 midw_fi_tcl_Aud_TestRoutineParameterList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_TESTROUTINEPARAMETERLIST;
}


midw_fi_tcl_Aud_TestRoutineParameterList::~midw_fi_tcl_Aud_TestRoutineParameterList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Aud_TestRoutineParameterList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TestRoutineParameterList.size()*5);
}

fi_tclInContext& midw_fi_tcl_Aud_TestRoutineParameterList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
      {
         TestRoutineParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestRoutineParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestRoutineParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_TestRoutineParameterList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestRoutineParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         (tVoid) (oOut << TestRoutineParameterList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Aud_TestRoutineParameterList::operator==(const midw_fi_tcl_Aud_TestRoutineParameterList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestRoutineParameterList.size() == roRef.TestRoutineParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestRoutineParameterList.size()); ++u32Idx)
            bResult = bResult && (TestRoutineParameterList[u32Idx] == roRef.TestRoutineParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_TestTroubleCodeStatus::midw_fi_tcl_Aud_TestTroubleCodeStatus(const midw_fi_tcl_Aud_TestTroubleCodeStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
   DiagnosisLogWrite = coRef.DiagnosisLogWrite;
}
midw_fi_tcl_Aud_TestTroubleCodeStatus& midw_fi_tcl_Aud_TestTroubleCodeStatus::operator=(const midw_fi_tcl_Aud_TestTroubleCodeStatus& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   ErrorStatus = coRef.ErrorStatus;
   RoutineStatus = coRef.RoutineStatus;
   DiagnosisLogWrite = coRef.DiagnosisLogWrite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_TestTroubleCodeStatus::midw_fi_tcl_Aud_TestTroubleCodeStatus()
:TroubleCode()
,ErrorStatus()
,RoutineStatus()
,DiagnosisLogWrite()
 {}

tS32 midw_fi_tcl_Aud_TestTroubleCodeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_TESTTROUBLECODESTATUS;
}


midw_fi_tcl_Aud_TestTroubleCodeStatus::~midw_fi_tcl_Aud_TestTroubleCodeStatus()
{}

tU32 midw_fi_tcl_Aud_TestTroubleCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_Aud_TestTroubleCodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> ErrorStatus);
   (tVoid) (oIn >> RoutineStatus);
   (tVoid) (oIn >> DiagnosisLogWrite);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_TestTroubleCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << ErrorStatus);
   (tVoid) (oOut << RoutineStatus);
   (tVoid) (oOut << DiagnosisLogWrite);
   return oOut;
}

tBool midw_fi_tcl_Aud_TestTroubleCodeStatus::operator==(const midw_fi_tcl_Aud_TestTroubleCodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (ErrorStatus == roRef.ErrorStatus);
   bResult = bResult && (RoutineStatus == roRef.RoutineStatus);
   bResult = bResult && (DiagnosisLogWrite == roRef.DiagnosisLogWrite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_TestTroubleCodeStatusList::midw_fi_tcl_Aud_TestTroubleCodeStatusList(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
}
midw_fi_tcl_Aud_TestTroubleCodeStatusList& midw_fi_tcl_Aud_TestTroubleCodeStatusList::operator=(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Aud_TestTroubleCodeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         TroubleCodeStatusList[u32Idx].vDestroy();
   TroubleCodeStatusList.clear();
   }
}

midw_fi_tcl_Aud_TestTroubleCodeStatusList::midw_fi_tcl_Aud_TestTroubleCodeStatusList()

 {}

tS32 midw_fi_tcl_Aud_TestTroubleCodeStatusList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_TESTTROUBLECODESTATUSLIST;
}


midw_fi_tcl_Aud_TestTroubleCodeStatusList::~midw_fi_tcl_Aud_TestTroubleCodeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Aud_TestTroubleCodeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TroubleCodeStatusList.size()*5);
}

fi_tclInContext& midw_fi_tcl_Aud_TestTroubleCodeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
      {
         TroubleCodeStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TroubleCodeStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TroubleCodeStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_TestTroubleCodeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TroubleCodeStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         (tVoid) (oOut << TroubleCodeStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Aud_TestTroubleCodeStatusList::operator==(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TroubleCodeStatusList.size() == roRef.TroubleCodeStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TroubleCodeStatusList.size()); ++u32Idx)
            bResult = bResult && (TroubleCodeStatusList[u32Idx] == roRef.TroubleCodeStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MicrophoneNumber::midw_fi_tcl_e8_MicrophoneNumber():enType(FI_EN_MIC_1) {}

tS32 midw_fi_tcl_e8_MicrophoneNumber::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MICROPHONENUMBER;
}


midw_fi_tcl_e8_MicrophoneNumber::~midw_fi_tcl_e8_MicrophoneNumber()
{}

tU32 midw_fi_tcl_e8_MicrophoneNumber::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MicrophoneNumber::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MicrophoneNumber::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MicrophoneConnectionStatus::midw_fi_tcl_e8_MicrophoneConnectionStatus():enType(FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OPEN) {}

tS32 midw_fi_tcl_e8_MicrophoneConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MICROPHONECONNECTIONSTATUS;
}


midw_fi_tcl_e8_MicrophoneConnectionStatus::~midw_fi_tcl_e8_MicrophoneConnectionStatus()
{}

tU32 midw_fi_tcl_e8_MicrophoneConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MicrophoneConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MicrophoneConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MicrophoneDetection::midw_fi_tcl_e8_MicrophoneDetection():enType(FI_EN_MIC_DET_ABSENT) {}

tS32 midw_fi_tcl_e8_MicrophoneDetection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MICROPHONEDETECTION;
}


midw_fi_tcl_e8_MicrophoneDetection::~midw_fi_tcl_e8_MicrophoneDetection()
{}

tU32 midw_fi_tcl_e8_MicrophoneDetection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MicrophoneDetection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MicrophoneDetection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MicrophoneConnectionStatus::midw_fi_tcl_MicrophoneConnectionStatus(const midw_fi_tcl_MicrophoneConnectionStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8MicrophoneNumber = coRef.e8MicrophoneNumber;
   u16MicrophoneCurrent = coRef.u16MicrophoneCurrent;
   e8MicrophoneConnectionStatus = coRef.e8MicrophoneConnectionStatus;
   e8MicrophoneDetection = coRef.e8MicrophoneDetection;
}
midw_fi_tcl_MicrophoneConnectionStatus& midw_fi_tcl_MicrophoneConnectionStatus::operator=(const midw_fi_tcl_MicrophoneConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8MicrophoneNumber = coRef.e8MicrophoneNumber;
   u16MicrophoneCurrent = coRef.u16MicrophoneCurrent;
   e8MicrophoneConnectionStatus = coRef.e8MicrophoneConnectionStatus;
   e8MicrophoneDetection = coRef.e8MicrophoneDetection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MicrophoneConnectionStatus::midw_fi_tcl_MicrophoneConnectionStatus()
:e8MicrophoneNumber()
,u16MicrophoneCurrent(0)
,e8MicrophoneConnectionStatus()
,e8MicrophoneDetection()
 {}

tS32 midw_fi_tcl_MicrophoneConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MICROPHONECONNECTIONSTATUS;
}


midw_fi_tcl_MicrophoneConnectionStatus::~midw_fi_tcl_MicrophoneConnectionStatus()
{}

tU32 midw_fi_tcl_MicrophoneConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_MicrophoneConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MicrophoneNumber);
   (tVoid) (oIn >> u16MicrophoneCurrent);
   (tVoid) (oIn >> e8MicrophoneConnectionStatus);
   (tVoid) (oIn >> e8MicrophoneDetection);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MicrophoneConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MicrophoneNumber);
   (tVoid) (oOut << u16MicrophoneCurrent);
   (tVoid) (oOut << e8MicrophoneConnectionStatus);
   (tVoid) (oOut << e8MicrophoneDetection);
   return oOut;
}

tBool midw_fi_tcl_MicrophoneConnectionStatus::operator==(const midw_fi_tcl_MicrophoneConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MicrophoneNumber == roRef.e8MicrophoneNumber);
   bResult = bResult && (u16MicrophoneCurrent == roRef.u16MicrophoneCurrent);
   bResult = bResult && (e8MicrophoneConnectionStatus == roRef.e8MicrophoneConnectionStatus);
   bResult = bResult && (e8MicrophoneDetection == roRef.e8MicrophoneDetection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MicrophoneConnectionStatusList::midw_fi_tcl_MicrophoneConnectionStatusList(const midw_fi_tcl_MicrophoneConnectionStatusList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
}
midw_fi_tcl_MicrophoneConnectionStatusList& midw_fi_tcl_MicrophoneConnectionStatusList::operator=(const midw_fi_tcl_MicrophoneConnectionStatusList& coRef)
{
   if (this == &coRef) return *this;
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MicrophoneConnectionStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
         MicrophoneConnectionStatusList[u32Idx].vDestroy();
   MicrophoneConnectionStatusList.clear();
   }
}

midw_fi_tcl_MicrophoneConnectionStatusList::midw_fi_tcl_MicrophoneConnectionStatusList()

 {}

tS32 midw_fi_tcl_MicrophoneConnectionStatusList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MICROPHONECONNECTIONSTATUSLIST;
}


midw_fi_tcl_MicrophoneConnectionStatusList::~midw_fi_tcl_MicrophoneConnectionStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MicrophoneConnectionStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MicrophoneConnectionStatusList.size()*5);
}

fi_tclInContext& midw_fi_tcl_MicrophoneConnectionStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
      {
         MicrophoneConnectionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MicrophoneConnectionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MicrophoneConnectionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MicrophoneConnectionStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MicrophoneConnectionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MicrophoneConnectionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << MicrophoneConnectionStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_MicrophoneConnectionStatusList::operator==(const midw_fi_tcl_MicrophoneConnectionStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MicrophoneConnectionStatusList.size() == roRef.MicrophoneConnectionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MicrophoneConnectionStatusList.size()); ++u32Idx)
            bResult = bResult && (MicrophoneConnectionStatusList[u32Idx] == roRef.MicrophoneConnectionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ResourceNo::midw_fi_tcl_e8_ResourceNo():enType(FI_EN_AUDIO_RESOURCE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_ResourceNo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RESOURCENO;
}


midw_fi_tcl_e8_ResourceNo::~midw_fi_tcl_e8_ResourceNo()
{}

tU32 midw_fi_tcl_e8_ResourceNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ResourceNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ResourceNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioServiceStatus::midw_fi_tcl_e8_AudioServiceStatus():enType(FI_EN_REJECTED) {}

tS32 midw_fi_tcl_e8_AudioServiceStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOSERVICESTATUS;
}


midw_fi_tcl_e8_AudioServiceStatus::~midw_fi_tcl_e8_AudioServiceStatus()
{}

tU32 midw_fi_tcl_e8_AudioServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_GalaLevel::midw_fi_tcl_e8_GalaLevel():enType(FI_EN_AUDIO_GALA_NOT_DEF) {}

tS32 midw_fi_tcl_e8_GalaLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GALALEVEL;
}


midw_fi_tcl_e8_GalaLevel::~midw_fi_tcl_e8_GalaLevel()
{}

tU32 midw_fi_tcl_e8_GalaLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_GalaLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_GalaLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioChannel::midw_fi_tcl_e8_AudioChannel():enType(FI_EN_AUDIO_CHANNEL_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioChannel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOCHANNEL;
}


midw_fi_tcl_e8_AudioChannel::~midw_fi_tcl_e8_AudioChannel()
{}

tU32 midw_fi_tcl_e8_AudioChannel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioChannel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioChannel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioVolumeType::midw_fi_tcl_e8_AudioVolumeType():enType(FI_EN_AUDIO_VAL_TYPE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioVolumeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOVOLUMETYPE;
}


midw_fi_tcl_e8_AudioVolumeType::~midw_fi_tcl_e8_AudioVolumeType()
{}

tU32 midw_fi_tcl_e8_AudioVolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioVolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioVolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioSoundType::midw_fi_tcl_e8_AudioSoundType():enType(FI_EN_AUDIO_SND_TYPE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioSoundType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOSOUNDTYPE;
}


midw_fi_tcl_e8_AudioSoundType::~midw_fi_tcl_e8_AudioSoundType()
{}

tU32 midw_fi_tcl_e8_AudioSoundType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioSoundType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioSoundType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioBeepType::midw_fi_tcl_e8_AudioBeepType():enType(FI_EN_AUDIO_BEEP_WARN_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioBeepType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOBEEPTYPE;
}


midw_fi_tcl_e8_AudioBeepType::~midw_fi_tcl_e8_AudioBeepType()
{}

tU32 midw_fi_tcl_e8_AudioBeepType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioBeepType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioBeepType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioBeepStatus::midw_fi_tcl_e8_AudioBeepStatus():enType(FI_EN_AUDIO_BEEP_STATUS_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioBeepStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOBEEPSTATUS;
}


midw_fi_tcl_e8_AudioBeepStatus::~midw_fi_tcl_e8_AudioBeepStatus()
{}

tU32 midw_fi_tcl_e8_AudioBeepStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioBeepStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioBeepStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VolumeMode::midw_fi_tcl_e8_VolumeMode():enType(FI_EN_AUDIO_VOLMODE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_VolumeMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VOLUMEMODE;
}


midw_fi_tcl_e8_VolumeMode::~midw_fi_tcl_e8_VolumeMode()
{}

tU32 midw_fi_tcl_e8_VolumeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VolumeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VolumeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SourceNo::midw_fi_tcl_e8_SourceNo():enType(FI_EN_AUDIO_SRC_NOT_DEF) {}

tS32 midw_fi_tcl_e8_SourceNo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SOURCENO;
}


midw_fi_tcl_e8_SourceNo::~midw_fi_tcl_e8_SourceNo()
{}

tU32 midw_fi_tcl_e8_SourceNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SourceNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SourceNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RouteNo::midw_fi_tcl_e8_RouteNo():enType(FI_EN_NOSOURCE) {}

tS32 midw_fi_tcl_e8_RouteNo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ROUTENO;
}


midw_fi_tcl_e8_RouteNo::~midw_fi_tcl_e8_RouteNo()
{}

tU32 midw_fi_tcl_e8_RouteNo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RouteNo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RouteNo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Sound::midw_fi_tcl_e8_Sound():enType(FI_EN_AUDIO_SOUND_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Sound::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SOUND;
}


midw_fi_tcl_e8_Sound::~midw_fi_tcl_e8_Sound()
{}

tU32 midw_fi_tcl_e8_Sound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Sound::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Sound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MemStatus::midw_fi_tcl_e8_MemStatus():enType(FI_EN_AUDIO_MEMSTATUS_NOT_DEF) {}

tS32 midw_fi_tcl_e8_MemStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MEMSTATUS;
}


midw_fi_tcl_e8_MemStatus::~midw_fi_tcl_e8_MemStatus()
{}

tU32 midw_fi_tcl_e8_MemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MemStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MemStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_FaderStatus::midw_fi_tcl_e8_FaderStatus():enType(FI_EN_AUDIO_FADERSTATUS_NOT_DEF) {}

tS32 midw_fi_tcl_e8_FaderStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_FADERSTATUS;
}


midw_fi_tcl_e8_FaderStatus::~midw_fi_tcl_e8_FaderStatus()
{}

tU32 midw_fi_tcl_e8_FaderStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_FaderStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_FaderStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DynCompression::midw_fi_tcl_e8_DynCompression():enType(FI_EN_AUDIO_DYN_COMPRESSION_NOT_DEF) {}

tS32 midw_fi_tcl_e8_DynCompression::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DYNCOMPRESSION;
}


midw_fi_tcl_e8_DynCompression::~midw_fi_tcl_e8_DynCompression()
{}

tU32 midw_fi_tcl_e8_DynCompression::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DynCompression::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DynCompression::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Optimization::midw_fi_tcl_e8_Optimization():enType(FI_EN_AUDIO_OPTIMIZATION_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Optimization::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_OPTIMIZATION;
}


midw_fi_tcl_e8_Optimization::~midw_fi_tcl_e8_Optimization()
{}

tU32 midw_fi_tcl_e8_Optimization::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Optimization::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Optimization::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_EquPresets::midw_fi_tcl_e8_EquPresets():enType(FI_EN_AUDIO_EQU_PRESET_NOT_DEF) {}

tS32 midw_fi_tcl_e8_EquPresets::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_EQUPRESETS;
}


midw_fi_tcl_e8_EquPresets::~midw_fi_tcl_e8_EquPresets()
{}

tU32 midw_fi_tcl_e8_EquPresets::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_EquPresets::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_EquPresets::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagAudMode::midw_fi_tcl_e8_DiagAudMode():enType(FI_EN_AUDIO_DIAG_AUD_MODE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_DiagAudMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGAUDMODE;
}


midw_fi_tcl_e8_DiagAudMode::~midw_fi_tcl_e8_DiagAudMode()
{}

tU32 midw_fi_tcl_e8_DiagAudMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagAudMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagAudMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_GenericDiagAudMode::midw_fi_tcl_e8_GenericDiagAudMode():enType(FI_EN_NOT_DEFINED) {}

tS32 midw_fi_tcl_e8_GenericDiagAudMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GENERICDIAGAUDMODE;
}


midw_fi_tcl_e8_GenericDiagAudMode::~midw_fi_tcl_e8_GenericDiagAudMode()
{}

tU32 midw_fi_tcl_e8_GenericDiagAudMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_GenericDiagAudMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_GenericDiagAudMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AuxInLevel::midw_fi_tcl_e8_AuxInLevel():enType(FI_EN_AUDIO_AUX_IN_LEVEL_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AuxInLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUXINLEVEL;
}


midw_fi_tcl_e8_AuxInLevel::~midw_fi_tcl_e8_AuxInLevel()
{}

tU32 midw_fi_tcl_e8_AuxInLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AuxInLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AuxInLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BeepLevel::midw_fi_tcl_e8_BeepLevel():enType(FI_EN_AUDIO_BEEP_LEVEL_NOT_DEF) {}

tS32 midw_fi_tcl_e8_BeepLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BEEPLEVEL;
}


midw_fi_tcl_e8_BeepLevel::~midw_fi_tcl_e8_BeepLevel()
{}

tU32 midw_fi_tcl_e8_BeepLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BeepLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BeepLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Rear_Mute::midw_fi_tcl_e8_Rear_Mute():enType(FI_EN_AUDIO_REAR_MUTE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Rear_Mute::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_REAR_MUTE;
}


midw_fi_tcl_e8_Rear_Mute::~midw_fi_tcl_e8_Rear_Mute()
{}

tU32 midw_fi_tcl_e8_Rear_Mute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Rear_Mute::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Rear_Mute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Geometry_Mode::midw_fi_tcl_e8_Geometry_Mode():enType(FI_EN_AUDIO_GEOMETRY_MODE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Geometry_Mode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GEOMETRY_MODE;
}


midw_fi_tcl_e8_Geometry_Mode::~midw_fi_tcl_e8_Geometry_Mode()
{}

tU32 midw_fi_tcl_e8_Geometry_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Geometry_Mode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Geometry_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PDCAttenuation::midw_fi_tcl_e8_PDCAttenuation():enType(FI_EN_AUDIO_PDC_COMMAND_NOT_DEF) {}

tS32 midw_fi_tcl_e8_PDCAttenuation::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PDCATTENUATION;
}


midw_fi_tcl_e8_PDCAttenuation::~midw_fi_tcl_e8_PDCAttenuation()
{}

tU32 midw_fi_tcl_e8_PDCAttenuation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PDCAttenuation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PDCAttenuation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VolumeType::midw_fi_tcl_e8_VolumeType():enType(FI_EN_INCREMENT) {}

tS32 midw_fi_tcl_e8_VolumeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VOLUMETYPE;
}


midw_fi_tcl_e8_VolumeType::~midw_fi_tcl_e8_VolumeType()
{}

tU32 midw_fi_tcl_e8_VolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Volume::midw_fi_tcl_Volume(const midw_fi_tcl_Volume& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8VolType = coRef.e8VolType;
   s16Volume = coRef.s16Volume;
}
midw_fi_tcl_Volume& midw_fi_tcl_Volume::operator=(const midw_fi_tcl_Volume& coRef)
{
   if (this == &coRef) return *this;
   e8VolType = coRef.e8VolType;
   s16Volume = coRef.s16Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Volume::midw_fi_tcl_Volume()
:e8VolType()
,s16Volume(0)
 {}

tS32 midw_fi_tcl_Volume::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VOLUME;
}


midw_fi_tcl_Volume::~midw_fi_tcl_Volume()
{}

tU32 midw_fi_tcl_Volume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_Volume::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VolType);
   (tVoid) (oIn >> s16Volume);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Volume::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VolType);
   (tVoid) (oOut << s16Volume);
   return oOut;
}

tBool midw_fi_tcl_Volume::operator==(const midw_fi_tcl_Volume& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VolType == roRef.e8VolType);
   bResult = bResult && (s16Volume == roRef.s16Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b8_ChannelSelect::midw_fi_tcl_b8_ChannelSelect():u8Value(0)
{}

tS32 midw_fi_tcl_b8_ChannelSelect::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B8_CHANNELSELECT;
}


midw_fi_tcl_b8_ChannelSelect::~midw_fi_tcl_b8_ChannelSelect()
{}

tU32 midw_fi_tcl_b8_ChannelSelect::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_b8_ChannelSelect::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& midw_fi_tcl_b8_ChannelSelect::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_Beep_Vol_Type::midw_fi_tcl_e8_Aud_Beep_Vol_Type():enType(FI_EN_FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT) {}

tS32 midw_fi_tcl_e8_Aud_Beep_Vol_Type::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_BEEP_VOL_TYPE;
}


midw_fi_tcl_e8_Aud_Beep_Vol_Type::~midw_fi_tcl_e8_Aud_Beep_Vol_Type()
{}

tU32 midw_fi_tcl_e8_Aud_Beep_Vol_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_Beep_Vol_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_Beep_Vol_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_BeepConfig::midw_fi_tcl_BeepConfig(const midw_fi_tcl_BeepConfig& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8VolType = coRef.e8VolType;
   s16VoldB = coRef.s16VoldB;
}
midw_fi_tcl_BeepConfig& midw_fi_tcl_BeepConfig::operator=(const midw_fi_tcl_BeepConfig& coRef)
{
   if (this == &coRef) return *this;
   e8VolType = coRef.e8VolType;
   s16VoldB = coRef.s16VoldB;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_BeepConfig::midw_fi_tcl_BeepConfig()
:e8VolType()
,s16VoldB(0)
 {}

tS32 midw_fi_tcl_BeepConfig::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_BEEPCONFIG;
}


midw_fi_tcl_BeepConfig::~midw_fi_tcl_BeepConfig()
{}

tU32 midw_fi_tcl_BeepConfig::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_BeepConfig::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VolType);
   (tVoid) (oIn >> s16VoldB);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_BeepConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VolType);
   (tVoid) (oOut << s16VoldB);
   return oOut;
}

tBool midw_fi_tcl_BeepConfig::operator==(const midw_fi_tcl_BeepConfig& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VolType == roRef.e8VolType);
   bResult = bResult && (s16VoldB == roRef.s16VoldB);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioDevice_Availability::midw_fi_tcl_e8_AudioDevice_Availability():enType(FI_EN_AUDIODEVICE_NOTAVAILABLE) {}

tS32 midw_fi_tcl_e8_AudioDevice_Availability::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIODEVICE_AVAILABILITY;
}


midw_fi_tcl_e8_AudioDevice_Availability::~midw_fi_tcl_e8_AudioDevice_Availability()
{}

tU32 midw_fi_tcl_e8_AudioDevice_Availability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioDevice_Availability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioDevice_Availability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_State::midw_fi_tcl_e8_State():enType(FI_EN_CUESTATE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_State::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_STATE;
}


midw_fi_tcl_e8_State::~midw_fi_tcl_e8_State()
{}

tU32 midw_fi_tcl_e8_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_VolumeType::midw_fi_tcl_e8_Aud_VolumeType():enType(FI_EN_VOLUME_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Aud_VolumeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_VOLUMETYPE;
}


midw_fi_tcl_e8_Aud_VolumeType::~midw_fi_tcl_e8_Aud_VolumeType()
{}

tU32 midw_fi_tcl_e8_Aud_VolumeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_VolumeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_VolumeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_VolumeStatus::midw_fi_tcl_Aud_VolumeStatus(const midw_fi_tcl_Aud_VolumeStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AudVolumeType = coRef.AudVolumeType;
   Volume = coRef.Volume;
}
midw_fi_tcl_Aud_VolumeStatus& midw_fi_tcl_Aud_VolumeStatus::operator=(const midw_fi_tcl_Aud_VolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudVolumeType = coRef.AudVolumeType;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_VolumeStatus::midw_fi_tcl_Aud_VolumeStatus()
:AudVolumeType()
,Volume(0)
 {}

tS32 midw_fi_tcl_Aud_VolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_VOLUMESTATUS;
}


midw_fi_tcl_Aud_VolumeStatus::~midw_fi_tcl_Aud_VolumeStatus()
{}

tU32 midw_fi_tcl_Aud_VolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_Aud_VolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudVolumeType);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_VolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudVolumeType);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_fi_tcl_Aud_VolumeStatus::operator==(const midw_fi_tcl_Aud_VolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudVolumeType == roRef.AudVolumeType);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_VolumeStatusList::midw_fi_tcl_Aud_VolumeStatusList(const midw_fi_tcl_Aud_VolumeStatusList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   VolumeStatusList = coRef.VolumeStatusList;
}
midw_fi_tcl_Aud_VolumeStatusList& midw_fi_tcl_Aud_VolumeStatusList::operator=(const midw_fi_tcl_Aud_VolumeStatusList& coRef)
{
   if (this == &coRef) return *this;
   VolumeStatusList = coRef.VolumeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Aud_VolumeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
         VolumeStatusList[u32Idx].vDestroy();
   VolumeStatusList.clear();
   }
}

midw_fi_tcl_Aud_VolumeStatusList::midw_fi_tcl_Aud_VolumeStatusList()

 {}

tS32 midw_fi_tcl_Aud_VolumeStatusList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_VOLUMESTATUSLIST;
}


midw_fi_tcl_Aud_VolumeStatusList::~midw_fi_tcl_Aud_VolumeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Aud_VolumeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(VolumeStatusList.size()*2);
}

fi_tclInContext& midw_fi_tcl_Aud_VolumeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
      {
         VolumeStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VolumeStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VolumeStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_VolumeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VolumeStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VolumeStatusList.size(); ++u32Idx)
         (tVoid) (oOut << VolumeStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Aud_VolumeStatusList::operator==(const midw_fi_tcl_Aud_VolumeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VolumeStatusList.size() == roRef.VolumeStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VolumeStatusList.size()); ++u32Idx)
            bResult = bResult && (VolumeStatusList[u32Idx] == roRef.VolumeStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BTAudioInLevel::midw_fi_tcl_e8_BTAudioInLevel():enType(FI_EN_AUDIO_BT_IN_LEVEL_1) {}

tS32 midw_fi_tcl_e8_BTAudioInLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BTAUDIOINLEVEL;
}


midw_fi_tcl_e8_BTAudioInLevel::~midw_fi_tcl_e8_BTAudioInLevel()
{}

tU32 midw_fi_tcl_e8_BTAudioInLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BTAudioInLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BTAudioInLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_EDType::midw_fi_tcl_e8_Aud_EDType():enType(FI_EN_ED_NOT_DEF) {}

tS32 midw_fi_tcl_e8_Aud_EDType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_EDTYPE;
}


midw_fi_tcl_e8_Aud_EDType::~midw_fi_tcl_e8_Aud_EDType()
{}

tU32 midw_fi_tcl_e8_Aud_EDType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_EDType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_EDType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_EDStatus::midw_fi_tcl_Aud_EDStatus(const midw_fi_tcl_Aud_EDStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AudEDType = coRef.AudEDType;
   EDValue = coRef.EDValue;
}
midw_fi_tcl_Aud_EDStatus& midw_fi_tcl_Aud_EDStatus::operator=(const midw_fi_tcl_Aud_EDStatus& coRef)
{
   if (this == &coRef) return *this;
   AudEDType = coRef.AudEDType;
   EDValue = coRef.EDValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_EDStatus::midw_fi_tcl_Aud_EDStatus()
:AudEDType()
,EDValue(0)
 {}

tS32 midw_fi_tcl_Aud_EDStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_EDSTATUS;
}


midw_fi_tcl_Aud_EDStatus::~midw_fi_tcl_Aud_EDStatus()
{}

tU32 midw_fi_tcl_Aud_EDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_Aud_EDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudEDType);
   (tVoid) (oIn >> EDValue);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_EDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudEDType);
   (tVoid) (oOut << EDValue);
   return oOut;
}

tBool midw_fi_tcl_Aud_EDStatus::operator==(const midw_fi_tcl_Aud_EDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudEDType == roRef.AudEDType);
   bResult = bResult && (EDValue == roRef.EDValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_EDStatusList::midw_fi_tcl_Aud_EDStatusList(const midw_fi_tcl_Aud_EDStatusList& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   EDStatusList = coRef.EDStatusList;
}
midw_fi_tcl_Aud_EDStatusList& midw_fi_tcl_Aud_EDStatusList::operator=(const midw_fi_tcl_Aud_EDStatusList& coRef)
{
   if (this == &coRef) return *this;
   EDStatusList = coRef.EDStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_Aud_EDStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
         EDStatusList[u32Idx].vDestroy();
   EDStatusList.clear();
   }
}

midw_fi_tcl_Aud_EDStatusList::midw_fi_tcl_Aud_EDStatusList()

 {}

tS32 midw_fi_tcl_Aud_EDStatusList::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_EDSTATUSLIST;
}


midw_fi_tcl_Aud_EDStatusList::~midw_fi_tcl_Aud_EDStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_Aud_EDStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(EDStatusList.size()*5);
}

fi_tclInContext& midw_fi_tcl_Aud_EDStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
      {
         EDStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      EDStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> EDStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_EDStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)EDStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < EDStatusList.size(); ++u32Idx)
         (tVoid) (oOut << EDStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_Aud_EDStatusList::operator==(const midw_fi_tcl_Aud_EDStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (EDStatusList.size() == roRef.EDStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EDStatusList.size()); ++u32Idx)
            bResult = bResult && (EDStatusList[u32Idx] == roRef.EDStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SurroundSetting::midw_fi_tcl_e8_SurroundSetting():enType(FI_EN_AUDIO_SURROUND_NOT_DEF) {}

tS32 midw_fi_tcl_e8_SurroundSetting::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SURROUNDSETTING;
}


midw_fi_tcl_e8_SurroundSetting::~midw_fi_tcl_e8_SurroundSetting()
{}

tU32 midw_fi_tcl_e8_SurroundSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SurroundSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SurroundSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AmpTemperatureLevel::midw_fi_tcl_e8_AmpTemperatureLevel():enType(FI_EN_THERMAL_WARNING_UNKNOWN) {}

tS32 midw_fi_tcl_e8_AmpTemperatureLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AMPTEMPERATURELEVEL;
}


midw_fi_tcl_e8_AmpTemperatureLevel::~midw_fi_tcl_e8_AmpTemperatureLevel()
{}

tU32 midw_fi_tcl_e8_AmpTemperatureLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AmpTemperatureLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AmpTemperatureLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagMode::midw_fi_tcl_e8_DiagMode():enType(FI_EN_OFF) {}

tS32 midw_fi_tcl_e8_DiagMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGMODE;
}


midw_fi_tcl_e8_DiagMode::~midw_fi_tcl_e8_DiagMode()
{}

tU32 midw_fi_tcl_e8_DiagMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiagState::midw_fi_tcl_e8_DiagState():enType(FI_EN_OFF) {}

tS32 midw_fi_tcl_e8_DiagState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIAGSTATE;
}


midw_fi_tcl_e8_DiagState::~midw_fi_tcl_e8_DiagState()
{}

tU32 midw_fi_tcl_e8_DiagState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiagState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiagState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Aud_DataId::midw_fi_tcl_e8_Aud_DataId():enType(FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF) {}

tS32 midw_fi_tcl_e8_Aud_DataId::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUD_DATAID;
}


midw_fi_tcl_e8_Aud_DataId::~midw_fi_tcl_e8_Aud_DataId()
{}

tU32 midw_fi_tcl_e8_Aud_DataId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Aud_DataId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Aud_DataId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32_MeasurementResult::midw_fi_tcl_b32_MeasurementResult():u32Value(0)
{}

tS32 midw_fi_tcl_b32_MeasurementResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32_MEASUREMENTRESULT;
}


midw_fi_tcl_b32_MeasurementResult::~midw_fi_tcl_b32_MeasurementResult()
{}

tU32 midw_fi_tcl_b32_MeasurementResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32_MeasurementResult::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32_MeasurementResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Aud_MeasurementResultItem::midw_fi_tcl_Aud_MeasurementResultItem(const midw_fi_tcl_Aud_MeasurementResultItem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8DataId = coRef.u8DataId;
   b32Result = coRef.b32Result;
}
midw_fi_tcl_Aud_MeasurementResultItem& midw_fi_tcl_Aud_MeasurementResultItem::operator=(const midw_fi_tcl_Aud_MeasurementResultItem& coRef)
{
   if (this == &coRef) return *this;
   u8DataId = coRef.u8DataId;
   b32Result = coRef.b32Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Aud_MeasurementResultItem::midw_fi_tcl_Aud_MeasurementResultItem()
:u8DataId()
,b32Result()
 {}

tS32 midw_fi_tcl_Aud_MeasurementResultItem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUD_MEASUREMENTRESULTITEM;
}


midw_fi_tcl_Aud_MeasurementResultItem::~midw_fi_tcl_Aud_MeasurementResultItem()
{}

tU32 midw_fi_tcl_Aud_MeasurementResultItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_Aud_MeasurementResultItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataId);
   (tVoid) (oIn >> b32Result);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Aud_MeasurementResultItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataId);
   (tVoid) (oOut << b32Result);
   return oOut;
}

tBool midw_fi_tcl_Aud_MeasurementResultItem::operator==(const midw_fi_tcl_Aud_MeasurementResultItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataId == roRef.u8DataId);
   bResult = bResult && (b32Result == roRef.b32Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VolumeLock::midw_fi_tcl_e8_VolumeLock():enType(FI_EN_AUDIO_VOLUME_LOCK_NOT_DEF) {}

tS32 midw_fi_tcl_e8_VolumeLock::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VOLUMELOCK;
}


midw_fi_tcl_e8_VolumeLock::~midw_fi_tcl_e8_VolumeLock()
{}

tU32 midw_fi_tcl_e8_VolumeLock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VolumeLock::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VolumeLock::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Requester::midw_fi_tcl_e8_Requester():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_Requester::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_REQUESTER;
}


midw_fi_tcl_e8_Requester::~midw_fi_tcl_e8_Requester()
{}

tU32 midw_fi_tcl_e8_Requester::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Requester::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Requester::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_RoomEffect::midw_fi_tcl_e8_RoomEffect():enType(FI_EN_AUDIO_ROOM_EFFECT_NOT_DEF) {}

tS32 midw_fi_tcl_e8_RoomEffect::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ROOMEFFECT;
}


midw_fi_tcl_e8_RoomEffect::~midw_fi_tcl_e8_RoomEffect()
{}

tU32 midw_fi_tcl_e8_RoomEffect::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_RoomEffect::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_RoomEffect::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudDiagDefSetPhase::midw_fi_tcl_e8_AudDiagDefSetPhase():enType(FI_EN_AUDIO_DIAGDEFSET_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudDiagDefSetPhase::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDDIAGDEFSETPHASE;
}


midw_fi_tcl_e8_AudDiagDefSetPhase::~midw_fi_tcl_e8_AudDiagDefSetPhase()
{}

tU32 midw_fi_tcl_e8_AudDiagDefSetPhase::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudDiagDefSetPhase::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudDiagDefSetPhase::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioMode::midw_fi_tcl_e8_AudioMode():enType(FI_EN_AUDIO_MODE_NOT_DEF) {}

tS32 midw_fi_tcl_e8_AudioMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOMODE;
}


midw_fi_tcl_e8_AudioMode::~midw_fi_tcl_e8_AudioMode()
{}

tU32 midw_fi_tcl_e8_AudioMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ADAS_UPA_SoundType::midw_fi_tcl_e8_ADAS_UPA_SoundType():enType(FI_EN_ADAS_UPA_SOUND_UNDEF) {}

tS32 midw_fi_tcl_e8_ADAS_UPA_SoundType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ADAS_UPA_SOUNDTYPE;
}


midw_fi_tcl_e8_ADAS_UPA_SoundType::~midw_fi_tcl_e8_ADAS_UPA_SoundType()
{}

tU32 midw_fi_tcl_e8_ADAS_UPA_SoundType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ADAS_UPA_SoundType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ADAS_UPA_SoundType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ADAS_ParkAssist_Volume::midw_fi_tcl_e8_ADAS_ParkAssist_Volume():enType(FI_EN_ADAS_PA_VOL_NO_SOUND) {}

tS32 midw_fi_tcl_e8_ADAS_ParkAssist_Volume::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ADAS_PARKASSIST_VOLUME;
}


midw_fi_tcl_e8_ADAS_ParkAssist_Volume::~midw_fi_tcl_e8_ADAS_ParkAssist_Volume()
{}

tU32 midw_fi_tcl_e8_ADAS_ParkAssist_Volume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ADAS_ParkAssist_Volume::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ADAS_ParkAssist_Volume::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ADAS_LDW_UserVolume::midw_fi_tcl_e8_ADAS_LDW_UserVolume():enType(FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID) {}

tS32 midw_fi_tcl_e8_ADAS_LDW_UserVolume::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ADAS_LDW_USERVOLUME;
}


midw_fi_tcl_e8_ADAS_LDW_UserVolume::~midw_fi_tcl_e8_ADAS_LDW_UserVolume()
{}

tU32 midw_fi_tcl_e8_ADAS_LDW_UserVolume::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ADAS_LDW_UserVolume::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ADAS_LDW_UserVolume::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ADAS_Setting_Sound::midw_fi_tcl_e8_ADAS_Setting_Sound():enType(FI_EN_ADAS_SETTING_SOUND_NONE) {}

tS32 midw_fi_tcl_e8_ADAS_Setting_Sound::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ADAS_SETTING_SOUND;
}


midw_fi_tcl_e8_ADAS_Setting_Sound::~midw_fi_tcl_e8_ADAS_Setting_Sound()
{}

tU32 midw_fi_tcl_e8_ADAS_Setting_Sound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ADAS_Setting_Sound::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ADAS_Setting_Sound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_OnGoingAction::midw_fi_tcl_e8_OnGoingAction():enType(FI_EN_UNDEF) {}

tS32 midw_fi_tcl_e8_OnGoingAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ONGOINGACTION;
}


midw_fi_tcl_e8_OnGoingAction::~midw_fi_tcl_e8_OnGoingAction()
{}

tU32 midw_fi_tcl_e8_OnGoingAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_OnGoingAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_OnGoingAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BOSE_UnitType::midw_fi_tcl_e8_BOSE_UnitType():enType(FI_EN_AUDIOAMPLIFIER) {}

tS32 midw_fi_tcl_e8_BOSE_UnitType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BOSE_UNITTYPE;
}


midw_fi_tcl_e8_BOSE_UnitType::~midw_fi_tcl_e8_BOSE_UnitType()
{}

tU32 midw_fi_tcl_e8_BOSE_UnitType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BOSE_UnitType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BOSE_UnitType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_BOSE_UnitConnectionStatus::midw_fi_tcl_BOSE_UnitConnectionStatus(const midw_fi_tcl_BOSE_UnitConnectionStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
}
midw_fi_tcl_BOSE_UnitConnectionStatus& midw_fi_tcl_BOSE_UnitConnectionStatus::operator=(const midw_fi_tcl_BOSE_UnitConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8UnitType = coRef.e8UnitType;
   bConnected = coRef.bConnected;
   u8AbsenceState = coRef.u8AbsenceState;
   u8MuteState = coRef.u8MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_BOSE_UnitConnectionStatus::midw_fi_tcl_BOSE_UnitConnectionStatus()
:e8UnitType()
,bConnected(0)
,u8AbsenceState(0)
,u8MuteState(0)
 {}

tS32 midw_fi_tcl_BOSE_UnitConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_BOSE_UNITCONNECTIONSTATUS;
}


midw_fi_tcl_BOSE_UnitConnectionStatus::~midw_fi_tcl_BOSE_UnitConnectionStatus()
{}

tU32 midw_fi_tcl_BOSE_UnitConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_BOSE_UnitConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8UnitType);
   (tVoid) (oIn >> bConnected);
   (tVoid) (oIn >> u8AbsenceState);
   (tVoid) (oIn >> u8MuteState);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_BOSE_UnitConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8UnitType);
   (tVoid) (oOut << bConnected);
   (tVoid) (oOut << u8AbsenceState);
   (tVoid) (oOut << u8MuteState);
   return oOut;
}

tBool midw_fi_tcl_BOSE_UnitConnectionStatus::operator==(const midw_fi_tcl_BOSE_UnitConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8UnitType == roRef.e8UnitType);
   bResult = bResult && (bConnected == roRef.bConnected);
   bResult = bResult && (u8AbsenceState == roRef.u8AbsenceState);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MicConnection::midw_fi_tcl_e8_MicConnection():enType(FI_EN_UNAVAILABLE) {}

tS32 midw_fi_tcl_e8_MicConnection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MICCONNECTION;
}


midw_fi_tcl_e8_MicConnection::~midw_fi_tcl_e8_MicConnection()
{}

tU32 midw_fi_tcl_e8_MicConnection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MicConnection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MicConnection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MicResult::midw_fi_tcl_e8_MicResult():enType(FI_EN_NORMAL) {}

tS32 midw_fi_tcl_e8_MicResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MICRESULT;
}


midw_fi_tcl_e8_MicResult::~midw_fi_tcl_e8_MicResult()
{}

tU32 midw_fi_tcl_e8_MicResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MicResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MicResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MicrophoneStatus::midw_fi_tcl_MicrophoneStatus(const midw_fi_tcl_MicrophoneStatus& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MicConnection = coRef.MicConnection;
   MicResult = coRef.MicResult;
}
midw_fi_tcl_MicrophoneStatus& midw_fi_tcl_MicrophoneStatus::operator=(const midw_fi_tcl_MicrophoneStatus& coRef)
{
   if (this == &coRef) return *this;
   MicConnection = coRef.MicConnection;
   MicResult = coRef.MicResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MicrophoneStatus::midw_fi_tcl_MicrophoneStatus()
:MicConnection()
,MicResult()
 {}

tS32 midw_fi_tcl_MicrophoneStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MICROPHONESTATUS;
}


midw_fi_tcl_MicrophoneStatus::~midw_fi_tcl_MicrophoneStatus()
{}

tU32 midw_fi_tcl_MicrophoneStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_MicrophoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MicConnection);
   (tVoid) (oIn >> MicResult);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MicrophoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MicConnection);
   (tVoid) (oOut << MicResult);
   return oOut;
}

tBool midw_fi_tcl_MicrophoneStatus::operator==(const midw_fi_tcl_MicrophoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MicConnection == roRef.MicConnection);
   bResult = bResult && (MicResult == roRef.MicResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MicrophoneResult::midw_fi_tcl_MicrophoneResult(const midw_fi_tcl_MicrophoneResult& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Mic1Result = coRef.Mic1Result;
   Mic2Result = coRef.Mic2Result;
   Mic3Result = coRef.Mic3Result;
   Mic4Result = coRef.Mic4Result;
}
midw_fi_tcl_MicrophoneResult& midw_fi_tcl_MicrophoneResult::operator=(const midw_fi_tcl_MicrophoneResult& coRef)
{
   if (this == &coRef) return *this;
   Mic1Result = coRef.Mic1Result;
   Mic2Result = coRef.Mic2Result;
   Mic3Result = coRef.Mic3Result;
   Mic4Result = coRef.Mic4Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MicrophoneResult::midw_fi_tcl_MicrophoneResult()
:Mic1Result()
,Mic2Result()
,Mic3Result()
,Mic4Result()
 {}

tS32 midw_fi_tcl_MicrophoneResult::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MICROPHONERESULT;
}


midw_fi_tcl_MicrophoneResult::~midw_fi_tcl_MicrophoneResult()
{}

tU32 midw_fi_tcl_MicrophoneResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_MicrophoneResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mic1Result);
   (tVoid) (oIn >> Mic2Result);
   (tVoid) (oIn >> Mic3Result);
   (tVoid) (oIn >> Mic4Result);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MicrophoneResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mic1Result);
   (tVoid) (oOut << Mic2Result);
   (tVoid) (oOut << Mic3Result);
   (tVoid) (oOut << Mic4Result);
   return oOut;
}

tBool midw_fi_tcl_MicrophoneResult::operator==(const midw_fi_tcl_MicrophoneResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mic1Result == roRef.Mic1Result);
   bResult = bResult && (Mic2Result == roRef.Mic2Result);
   bResult = bResult && (Mic3Result == roRef.Mic3Result);
   bResult = bResult && (Mic4Result == roRef.Mic4Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioPilotIntensity::midw_fi_tcl_e8_AudioPilotIntensity():enType(FI_EN_UNDEF) {}

tS32 midw_fi_tcl_e8_AudioPilotIntensity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOPILOTINTENSITY;
}


midw_fi_tcl_e8_AudioPilotIntensity::~midw_fi_tcl_e8_AudioPilotIntensity()
{}

tU32 midw_fi_tcl_e8_AudioPilotIntensity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioPilotIntensity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioPilotIntensity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TpegSid::midw_fi_tcl_TpegSid(const midw_fi_tcl_TpegSid& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SidA = coRef.SidA;
   SidB = coRef.SidB;
   SidC = coRef.SidC;
}
midw_fi_tcl_TpegSid& midw_fi_tcl_TpegSid::operator=(const midw_fi_tcl_TpegSid& coRef)
{
   if (this == &coRef) return *this;
   SidA = coRef.SidA;
   SidB = coRef.SidB;
   SidC = coRef.SidC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TpegSid::midw_fi_tcl_TpegSid()
:SidA(0)
,SidB(0)
,SidC(0)
 {}

tS32 midw_fi_tcl_TpegSid::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TPEGSID;
}


midw_fi_tcl_TpegSid::~midw_fi_tcl_TpegSid()
{}

tU32 midw_fi_tcl_TpegSid::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_TpegSid::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SidA);
   (tVoid) (oIn >> SidB);
   (tVoid) (oIn >> SidC);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TpegSid::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SidA);
   (tVoid) (oOut << SidB);
   (tVoid) (oOut << SidC);
   return oOut;
}

tBool midw_fi_tcl_TpegSid::operator==(const midw_fi_tcl_TpegSid& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SidA == roRef.SidA);
   bResult = bResult && (SidB == roRef.SidB);
   bResult = bResult && (SidC == roRef.SidC);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TpegApplication::midw_fi_tcl_e8_TpegApplication():enType(FI_EN_SNI) {}

tS32 midw_fi_tcl_e8_TpegApplication::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TPEGAPPLICATION;
}


midw_fi_tcl_e8_TpegApplication::~midw_fi_tcl_e8_TpegApplication()
{}

tU32 midw_fi_tcl_e8_TpegApplication::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TpegApplication::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TpegApplication::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TpegLocReferencing::midw_fi_tcl_e8_TpegLocReferencing():enType(FI_EN_TPEGLOCATIONREFERENCE) {}

tS32 midw_fi_tcl_e8_TpegLocReferencing::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TPEGLOCREFERENCING;
}


midw_fi_tcl_e8_TpegLocReferencing::~midw_fi_tcl_e8_TpegLocReferencing()
{}

tU32 midw_fi_tcl_e8_TpegLocReferencing::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TpegLocReferencing::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TpegLocReferencing::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TpegAcid::midw_fi_tcl_TpegAcid(const midw_fi_tcl_TpegAcid& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   OriginatorSID = coRef.OriginatorSID;
   ApplicationId = coRef.ApplicationId;
   ContentId = coRef.ContentId;
}
midw_fi_tcl_TpegAcid& midw_fi_tcl_TpegAcid::operator=(const midw_fi_tcl_TpegAcid& coRef)
{
   if (this == &coRef) return *this;
   OriginatorSID = coRef.OriginatorSID;
   ApplicationId = coRef.ApplicationId;
   ContentId = coRef.ContentId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TpegAcid::midw_fi_tcl_TpegAcid()
:OriginatorSID()
,ApplicationId()
,ContentId(0)
 {}

tS32 midw_fi_tcl_TpegAcid::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TPEGACID;
}


midw_fi_tcl_TpegAcid::~midw_fi_tcl_TpegAcid()
{}

tU32 midw_fi_tcl_TpegAcid::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TpegAcid::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OriginatorSID);
   (tVoid) (oIn >> ApplicationId);
   (tVoid) (oIn >> ContentId);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TpegAcid::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OriginatorSID);
   (tVoid) (oOut << ApplicationId);
   (tVoid) (oOut << ContentId);
   return oOut;
}

tBool midw_fi_tcl_TpegAcid::operator==(const midw_fi_tcl_TpegAcid& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OriginatorSID == roRef.OriginatorSID);
   bResult = bResult && (ApplicationId == roRef.ApplicationId);
   bResult = bResult && (ContentId == roRef.ContentId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_VersionedTpegAcid::midw_fi_tcl_VersionedTpegAcid(const midw_fi_tcl_VersionedTpegAcid& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Acid = coRef.Acid;
   Version = coRef.Version;
}
midw_fi_tcl_VersionedTpegAcid& midw_fi_tcl_VersionedTpegAcid::operator=(const midw_fi_tcl_VersionedTpegAcid& coRef)
{
   if (this == &coRef) return *this;
   Acid = coRef.Acid;
   Version = coRef.Version;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_VersionedTpegAcid::midw_fi_tcl_VersionedTpegAcid()
:Acid()
,Version(0)
 {}

tS32 midw_fi_tcl_VersionedTpegAcid::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VERSIONEDTPEGACID;
}


midw_fi_tcl_VersionedTpegAcid::~midw_fi_tcl_VersionedTpegAcid()
{}

tU32 midw_fi_tcl_VersionedTpegAcid::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_VersionedTpegAcid::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Acid);
   (tVoid) (oIn >> Version);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_VersionedTpegAcid::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Acid);
   (tVoid) (oOut << Version);
   return oOut;
}

tBool midw_fi_tcl_VersionedTpegAcid::operator==(const midw_fi_tcl_VersionedTpegAcid& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Acid == roRef.Acid);
   bResult = bResult && (Version == roRef.Version);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TpegStatisticsPerLocRef::midw_fi_tcl_TpegStatisticsPerLocRef(const midw_fi_tcl_TpegStatisticsPerLocRef& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   LocRefType = coRef.LocRefType;
   MsgsPerFrame = coRef.MsgsPerFrame;
   AvgMsgsPerFrame = coRef.AvgMsgsPerFrame;
   MaxMsgsPerFrame = coRef.MaxMsgsPerFrame;
}
midw_fi_tcl_TpegStatisticsPerLocRef& midw_fi_tcl_TpegStatisticsPerLocRef::operator=(const midw_fi_tcl_TpegStatisticsPerLocRef& coRef)
{
   if (this == &coRef) return *this;
   LocRefType = coRef.LocRefType;
   MsgsPerFrame = coRef.MsgsPerFrame;
   AvgMsgsPerFrame = coRef.AvgMsgsPerFrame;
   MaxMsgsPerFrame = coRef.MaxMsgsPerFrame;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TpegStatisticsPerLocRef::midw_fi_tcl_TpegStatisticsPerLocRef()
:LocRefType()
,MsgsPerFrame(0)
,AvgMsgsPerFrame(0)
,MaxMsgsPerFrame(0)
 {}

tS32 midw_fi_tcl_TpegStatisticsPerLocRef::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TPEGSTATISTICSPERLOCREF;
}


midw_fi_tcl_TpegStatisticsPerLocRef::~midw_fi_tcl_TpegStatisticsPerLocRef()
{}

tU32 midw_fi_tcl_TpegStatisticsPerLocRef::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_fi_tcl_TpegStatisticsPerLocRef::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LocRefType);
   (tVoid) (oIn >> MsgsPerFrame);
   (tVoid) (oIn >> AvgMsgsPerFrame);
   (tVoid) (oIn >> MaxMsgsPerFrame);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TpegStatisticsPerLocRef::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LocRefType);
   (tVoid) (oOut << MsgsPerFrame);
   (tVoid) (oOut << AvgMsgsPerFrame);
   (tVoid) (oOut << MaxMsgsPerFrame);
   return oOut;
}

tBool midw_fi_tcl_TpegStatisticsPerLocRef::operator==(const midw_fi_tcl_TpegStatisticsPerLocRef& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LocRefType == roRef.LocRefType);
   bResult = bResult && (MsgsPerFrame == roRef.MsgsPerFrame);
   bResult = bResult && (AvgMsgsPerFrame == roRef.AvgMsgsPerFrame);
   bResult = bResult && (MaxMsgsPerFrame == roRef.MaxMsgsPerFrame);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TpegStreamInfo::midw_fi_tcl_TpegStreamInfo(const midw_fi_tcl_TpegStreamInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   VersionedAcid = coRef.VersionedAcid;
   listOfStatisticsPerLocRef = coRef.listOfStatisticsPerLocRef;
}
midw_fi_tcl_TpegStreamInfo& midw_fi_tcl_TpegStreamInfo::operator=(const midw_fi_tcl_TpegStreamInfo& coRef)
{
   if (this == &coRef) return *this;
   VersionedAcid = coRef.VersionedAcid;
   listOfStatisticsPerLocRef = coRef.listOfStatisticsPerLocRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TpegStreamInfo::vDestroy()
{
   VersionedAcid.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < listOfStatisticsPerLocRef.size(); ++u32Idx)
         listOfStatisticsPerLocRef[u32Idx].vDestroy();
   listOfStatisticsPerLocRef.clear();
   }
}

midw_fi_tcl_TpegStreamInfo::midw_fi_tcl_TpegStreamInfo()
:VersionedAcid()

 {}

tS32 midw_fi_tcl_TpegStreamInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TPEGSTREAMINFO;
}


midw_fi_tcl_TpegStreamInfo::~midw_fi_tcl_TpegStreamInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TpegStreamInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(listOfStatisticsPerLocRef.size()*13);
}

fi_tclInContext& midw_fi_tcl_TpegStreamInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VersionedAcid);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < listOfStatisticsPerLocRef.size(); ++u32Idx)
      {
         listOfStatisticsPerLocRef[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      listOfStatisticsPerLocRef.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listOfStatisticsPerLocRef[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TpegStreamInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VersionedAcid);
   (tVoid) (oOut << (tU32)listOfStatisticsPerLocRef.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listOfStatisticsPerLocRef.size(); ++u32Idx)
         (tVoid) (oOut << listOfStatisticsPerLocRef[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TpegStreamInfo::operator==(const midw_fi_tcl_TpegStreamInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VersionedAcid == roRef.VersionedAcid);
      bResult = bResult && (listOfStatisticsPerLocRef.size() == roRef.listOfStatisticsPerLocRef.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listOfStatisticsPerLocRef.size()); ++u32Idx)
            bResult = bResult && (listOfStatisticsPerLocRef[u32Idx] == roRef.listOfStatisticsPerLocRef[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudSource::midw_fi_tcl_e8_AudSource():enType(FI_EN_NONE) {}

tS32 midw_fi_tcl_e8_AudSource::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDSOURCE;
}


midw_fi_tcl_e8_AudSource::~midw_fi_tcl_e8_AudSource()
{}

tU32 midw_fi_tcl_e8_AudSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SrcActivity::midw_fi_tcl_e8_SrcActivity():enType(FI_EN_PAUSE) {}

tS32 midw_fi_tcl_e8_SrcActivity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SRCACTIVITY;
}


midw_fi_tcl_e8_SrcActivity::~midw_fi_tcl_e8_SrcActivity()
{}

tU32 midw_fi_tcl_e8_SrcActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SrcActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SrcActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SrcAvailabilityReason::midw_fi_tcl_e8_SrcAvailabilityReason():enType(FI_EN_NEWMEDIA) {}

tS32 midw_fi_tcl_e8_SrcAvailabilityReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SRCAVAILABILITYREASON;
}


midw_fi_tcl_e8_SrcAvailabilityReason::~midw_fi_tcl_e8_SrcAvailabilityReason()
{}

tU32 midw_fi_tcl_e8_SrcAvailabilityReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SrcAvailabilityReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SrcAvailabilityReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SrcAvailability::midw_fi_tcl_e8_SrcAvailability():enType(FI_EN_NOT_AVAILABLE) {}

tS32 midw_fi_tcl_e8_SrcAvailability::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SRCAVAILABILITY;
}


midw_fi_tcl_e8_SrcAvailability::~midw_fi_tcl_e8_SrcAvailability()
{}

tU32 midw_fi_tcl_e8_SrcAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SrcAvailability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SrcAvailability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SourceAvailablityItem::midw_fi_tcl_SourceAvailablityItem(const midw_fi_tcl_SourceAvailablityItem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Reason = coRef.e8Reason;
   e8Availability = coRef.e8Availability;
}
midw_fi_tcl_SourceAvailablityItem& midw_fi_tcl_SourceAvailablityItem::operator=(const midw_fi_tcl_SourceAvailablityItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Reason = coRef.e8Reason;
   e8Availability = coRef.e8Availability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_SourceAvailablityItem::midw_fi_tcl_SourceAvailablityItem()
:u8Source()
,u16SubSource(0)
,e8Reason()
,e8Availability()
 {}

tS32 midw_fi_tcl_SourceAvailablityItem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SOURCEAVAILABLITYITEM;
}


midw_fi_tcl_SourceAvailablityItem::~midw_fi_tcl_SourceAvailablityItem()
{}

tU32 midw_fi_tcl_SourceAvailablityItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_SourceAvailablityItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> e8Reason);
   (tVoid) (oIn >> e8Availability);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SourceAvailablityItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << e8Reason);
   (tVoid) (oOut << e8Availability);
   return oOut;
}

tBool midw_fi_tcl_SourceAvailablityItem::operator==(const midw_fi_tcl_SourceAvailablityItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (e8Reason == roRef.e8Reason);
   bResult = bResult && (e8Availability == roRef.e8Availability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8MuteAction::midw_fi_tcl_e8MuteAction():enType(FI_EN_MUTE) {}

tS32 midw_fi_tcl_e8MuteAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8MUTEACTION;
}


midw_fi_tcl_e8MuteAction::~midw_fi_tcl_e8MuteAction()
{}

tU32 midw_fi_tcl_e8MuteAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8MuteAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8MuteAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_RequestAudioRouteItem::midw_fi_tcl_RequestAudioRouteItem(const midw_fi_tcl_RequestAudioRouteItem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Reason = coRef.u8Reason;
   e8Activity = coRef.e8Activity;
}
midw_fi_tcl_RequestAudioRouteItem& midw_fi_tcl_RequestAudioRouteItem::operator=(const midw_fi_tcl_RequestAudioRouteItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Reason = coRef.u8Reason;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_RequestAudioRouteItem::midw_fi_tcl_RequestAudioRouteItem()
:u8Source()
,u16SubSource(0)
,u8Reason(0)
,e8Activity()
 {}

tS32 midw_fi_tcl_RequestAudioRouteItem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_REQUESTAUDIOROUTEITEM;
}


midw_fi_tcl_RequestAudioRouteItem::~midw_fi_tcl_RequestAudioRouteItem()
{}

tU32 midw_fi_tcl_RequestAudioRouteItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_RequestAudioRouteItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u8Reason);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_RequestAudioRouteItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u8Reason);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool midw_fi_tcl_RequestAudioRouteItem::operator==(const midw_fi_tcl_RequestAudioRouteItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u8Reason == roRef.u8Reason);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioProperty::midw_fi_tcl_e8_AudioProperty():enType(FI_EN_AUDIO_PROP_VOLUME_LOCK) {}

tS32 midw_fi_tcl_e8_AudioProperty::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOPROPERTY;
}


midw_fi_tcl_e8_AudioProperty::~midw_fi_tcl_e8_AudioProperty()
{}

tU32 midw_fi_tcl_e8_AudioProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioProperty::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioProperty::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_b32MuteReason::midw_fi_tcl_b32MuteReason():u32Value(0)
{}

tS32 midw_fi_tcl_b32MuteReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_B32MUTEREASON;
}


midw_fi_tcl_b32MuteReason::~midw_fi_tcl_b32MuteReason()
{}

tU32 midw_fi_tcl_b32MuteReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_b32MuteReason::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& midw_fi_tcl_b32MuteReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MuteState::midw_fi_tcl_e8_MuteState():enType(FI_EN_MUTE) {}

tS32 midw_fi_tcl_e8_MuteState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MUTESTATE;
}


midw_fi_tcl_e8_MuteState::~midw_fi_tcl_e8_MuteState()
{}

tU32 midw_fi_tcl_e8_MuteState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MuteState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MuteState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MuteRequestItem::midw_fi_tcl_MuteRequestItem(const midw_fi_tcl_MuteRequestItem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u8Action = coRef.u8Action;
   u32Reason = coRef.u32Reason;
}
midw_fi_tcl_MuteRequestItem& midw_fi_tcl_MuteRequestItem::operator=(const midw_fi_tcl_MuteRequestItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Action = coRef.u8Action;
   u32Reason = coRef.u32Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MuteRequestItem::midw_fi_tcl_MuteRequestItem()
:u8Source()
,u8Action()
,u32Reason()
 {}

tS32 midw_fi_tcl_MuteRequestItem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MUTEREQUESTITEM;
}


midw_fi_tcl_MuteRequestItem::~midw_fi_tcl_MuteRequestItem()
{}

tU32 midw_fi_tcl_MuteRequestItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_MuteRequestItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Action);
   (tVoid) (oIn >> u32Reason);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MuteRequestItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Action);
   (tVoid) (oOut << u32Reason);
   return oOut;
}

tBool midw_fi_tcl_MuteRequestItem::operator==(const midw_fi_tcl_MuteRequestItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Action == roRef.u8Action);
   bResult = bResult && (u32Reason == roRef.u32Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MuteRequester::midw_fi_tcl_e8_MuteRequester():enType(FI_EN_AUDIOROUTINGMANAGER) {}

tS32 midw_fi_tcl_e8_MuteRequester::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MUTEREQUESTER;
}


midw_fi_tcl_e8_MuteRequester::~midw_fi_tcl_e8_MuteRequester()
{}

tU32 midw_fi_tcl_e8_MuteRequester::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MuteRequester::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MuteRequester::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8MuteSpeed::midw_fi_tcl_e8MuteSpeed():enType(FI_EN_VERY_FAST) {}

tS32 midw_fi_tcl_e8MuteSpeed::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8MUTESPEED;
}


midw_fi_tcl_e8MuteSpeed::~midw_fi_tcl_e8MuteSpeed()
{}

tU32 midw_fi_tcl_e8MuteSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8MuteSpeed::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8MuteSpeed::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SetAudioPropertyItem::midw_fi_tcl_SetAudioPropertyItem(const midw_fi_tcl_SetAudioPropertyItem& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
midw_fi_tcl_SetAudioPropertyItem& midw_fi_tcl_SetAudioPropertyItem::operator=(const midw_fi_tcl_SetAudioPropertyItem& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_SetAudioPropertyItem::midw_fi_tcl_SetAudioPropertyItem()
:u8Source()
,u16SubSource(0)
,u8Property()
,s32PropValue(0)
 {}

tS32 midw_fi_tcl_SetAudioPropertyItem::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SETAUDIOPROPERTYITEM;
}


midw_fi_tcl_SetAudioPropertyItem::~midw_fi_tcl_SetAudioPropertyItem()
{}

tU32 midw_fi_tcl_SetAudioPropertyItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_SetAudioPropertyItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SetAudioPropertyItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool midw_fi_tcl_SetAudioPropertyItem::operator==(const midw_fi_tcl_SetAudioPropertyItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_SourceRouteActivity::midw_fi_tcl_SourceRouteActivity(const midw_fi_tcl_SourceRouteActivity& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   PossibleNextSource = coRef.PossibleNextSource;
   Resource = coRef.Resource;
   Activity = coRef.Activity;
}
midw_fi_tcl_SourceRouteActivity& midw_fi_tcl_SourceRouteActivity::operator=(const midw_fi_tcl_SourceRouteActivity& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   PossibleNextSource = coRef.PossibleNextSource;
   Resource = coRef.Resource;
   Activity = coRef.Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_SourceRouteActivity::midw_fi_tcl_SourceRouteActivity()
:Source()
,SubSource(0)
,PossibleNextSource()
,Resource()
,Activity()
 {}

tS32 midw_fi_tcl_SourceRouteActivity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SOURCEROUTEACTIVITY;
}


midw_fi_tcl_SourceRouteActivity::~midw_fi_tcl_SourceRouteActivity()
{}

tU32 midw_fi_tcl_SourceRouteActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_SourceRouteActivity::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> SubSource);
   (tVoid) (oIn >> PossibleNextSource);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Activity);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_SourceRouteActivity::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << SubSource);
   (tVoid) (oOut << PossibleNextSource);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Activity);
   return oOut;
}

tBool midw_fi_tcl_SourceRouteActivity::operator==(const midw_fi_tcl_SourceRouteActivity& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (SubSource == roRef.SubSource);
   bResult = bResult && (PossibleNextSource == roRef.PossibleNextSource);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Activity == roRef.Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ResponseCode::midw_fi_tcl_e8_ResponseCode():enType(FI_EN_FAILURE) {}

tS32 midw_fi_tcl_e8_ResponseCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RESPONSECODE;
}


midw_fi_tcl_e8_ResponseCode::~midw_fi_tcl_e8_ResponseCode()
{}

tU32 midw_fi_tcl_e8_ResponseCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ResponseCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ResponseCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ErrorType::midw_fi_tcl_e8_ErrorType():enType(FI_EN_NO_ERROR) {}

tS32 midw_fi_tcl_e8_ErrorType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ERRORTYPE;
}


midw_fi_tcl_e8_ErrorType::~midw_fi_tcl_e8_ErrorType()
{}

tU32 midw_fi_tcl_e8_ErrorType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ErrorType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ErrorType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceCategory::midw_fi_tcl_e8_DeviceCategory():enType(FI_EN_DEV_TYPE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DeviceCategory::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICECATEGORY;
}


midw_fi_tcl_e8_DeviceCategory::~midw_fi_tcl_e8_DeviceCategory()
{}

tU32 midw_fi_tcl_e8_DeviceCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceConnectionStatus::midw_fi_tcl_e8_DeviceConnectionStatus():enType(FI_EN_DEV_NOT_CONNECTED) {}

tS32 midw_fi_tcl_e8_DeviceConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICECONNECTIONSTATUS;
}


midw_fi_tcl_e8_DeviceConnectionStatus::~midw_fi_tcl_e8_DeviceConnectionStatus()
{}

tU32 midw_fi_tcl_e8_DeviceConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceConnectionType::midw_fi_tcl_e8_DeviceConnectionType():enType(FI_EN_UNKNOWN_CONNECTION) {}

tS32 midw_fi_tcl_e8_DeviceConnectionType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICECONNECTIONTYPE;
}


midw_fi_tcl_e8_DeviceConnectionType::~midw_fi_tcl_e8_DeviceConnectionType()
{}

tU32 midw_fi_tcl_e8_DeviceConnectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceConnectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceConnectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SessionTransportType::midw_fi_tcl_e8_SessionTransportType():enType(FI_EN_SESSION_TRANSPORT_UNKNOWN) {}

tS32 midw_fi_tcl_e8_SessionTransportType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SESSIONTRANSPORTTYPE;
}


midw_fi_tcl_e8_SessionTransportType::~midw_fi_tcl_e8_SessionTransportType()
{}

tU32 midw_fi_tcl_e8_SessionTransportType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SessionTransportType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SessionTransportType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceStatusInfo::midw_fi_tcl_e8_DeviceStatusInfo():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_DeviceStatusInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICESTATUSINFO;
}


midw_fi_tcl_e8_DeviceStatusInfo::~midw_fi_tcl_e8_DeviceStatusInfo()
{}

tU32 midw_fi_tcl_e8_DeviceStatusInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceStatusInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceStatusInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AppStatusInfo::midw_fi_tcl_e8_AppStatusInfo():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_AppStatusInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPSTATUSINFO;
}


midw_fi_tcl_e8_AppStatusInfo::~midw_fi_tcl_e8_AppStatusInfo()
{}

tU32 midw_fi_tcl_e8_AppStatusInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AppStatusInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AppStatusInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SessionStatus::midw_fi_tcl_e8_SessionStatus():enType(FI_EN_SESSION_UNKNOWN) {}

tS32 midw_fi_tcl_e8_SessionStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SESSIONSTATUS;
}


midw_fi_tcl_e8_SessionStatus::~midw_fi_tcl_e8_SessionStatus()
{}

tU32 midw_fi_tcl_e8_SessionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SessionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SessionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_IconMimeType::midw_fi_tcl_e8_IconMimeType():enType(FI_EN_ICON_INVALID) {}

tS32 midw_fi_tcl_e8_IconMimeType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ICONMIMETYPE;
}


midw_fi_tcl_e8_IconMimeType::~midw_fi_tcl_e8_IconMimeType()
{}

tU32 midw_fi_tcl_e8_IconMimeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_IconMimeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_IconMimeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_OrientationMode::midw_fi_tcl_e8_OrientationMode():enType(FI_EN_INVALID_MODE) {}

tS32 midw_fi_tcl_e8_OrientationMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ORIENTATIONMODE;
}


midw_fi_tcl_e8_OrientationMode::~midw_fi_tcl_e8_OrientationMode()
{}

tU32 midw_fi_tcl_e8_OrientationMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_OrientationMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_OrientationMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BlockingMode::midw_fi_tcl_e8_BlockingMode():enType(FI_EN_DISABLE_BLOCKING) {}

tS32 midw_fi_tcl_e8_BlockingMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BLOCKINGMODE;
}


midw_fi_tcl_e8_BlockingMode::~midw_fi_tcl_e8_BlockingMode()
{}

tU32 midw_fi_tcl_e8_BlockingMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BlockingMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BlockingMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TouchMode::midw_fi_tcl_e8_TouchMode():enType(FI_EN_TOUCH_RELEASE) {}

tS32 midw_fi_tcl_e8_TouchMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TOUCHMODE;
}


midw_fi_tcl_e8_TouchMode::~midw_fi_tcl_e8_TouchMode()
{}

tU32 midw_fi_tcl_e8_TouchMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TouchMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TouchMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_KeyMode::midw_fi_tcl_e8_KeyMode():enType(FI_EN_KEY_RELEASE) {}

tS32 midw_fi_tcl_e8_KeyMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_KEYMODE;
}


midw_fi_tcl_e8_KeyMode::~midw_fi_tcl_e8_KeyMode()
{}

tU32 midw_fi_tcl_e8_KeyMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_KeyMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_KeyMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_EnabledInfo::midw_fi_tcl_e8_EnabledInfo():enType(FI_EN_USAGE_DISABLED) {}

tS32 midw_fi_tcl_e8_EnabledInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ENABLEDINFO;
}


midw_fi_tcl_e8_EnabledInfo::~midw_fi_tcl_e8_EnabledInfo()
{}

tU32 midw_fi_tcl_e8_EnabledInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_EnabledInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_EnabledInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ScreenAspectRatio::midw_fi_tcl_e8_ScreenAspectRatio():enType(FI_EN_ASPECT_UNKNOWN) {}

tS32 midw_fi_tcl_e8_ScreenAspectRatio::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SCREENASPECTRATIO;
}


midw_fi_tcl_e8_ScreenAspectRatio::~midw_fi_tcl_e8_ScreenAspectRatio()
{}

tU32 midw_fi_tcl_e8_ScreenAspectRatio::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ScreenAspectRatio::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ScreenAspectRatio::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceConnectionReq::midw_fi_tcl_e8_DeviceConnectionReq():enType(FI_EN_DEV_CONNECT) {}

tS32 midw_fi_tcl_e8_DeviceConnectionReq::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICECONNECTIONREQ;
}


midw_fi_tcl_e8_DeviceConnectionReq::~midw_fi_tcl_e8_DeviceConnectionReq()
{}

tU32 midw_fi_tcl_e8_DeviceConnectionReq::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceConnectionReq::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceConnectionReq::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e32_KeyCode::midw_fi_tcl_e32_KeyCode():enType(FI_EN_ITU_KEY_0) {}

tS32 midw_fi_tcl_e32_KeyCode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E32_KEYCODE;
}


midw_fi_tcl_e32_KeyCode::~midw_fi_tcl_e32_KeyCode()
{}

tU32 midw_fi_tcl_e32_KeyCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e32_KeyCode::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e32_KeyCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e32_AppCategory::midw_fi_tcl_e32_AppCategory():enType(FI_EN_APP_UNKNOWN) {}

tS32 midw_fi_tcl_e32_AppCategory::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E32_APPCATEGORY;
}


midw_fi_tcl_e32_AppCategory::~midw_fi_tcl_e32_AppCategory()
{}

tU32 midw_fi_tcl_e32_AppCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e32_AppCategory::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e32_AppCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e32_AppDisplayCategory::midw_fi_tcl_e32_AppDisplayCategory():enType(FI_EN_CONTENT_TEXT) {}

tS32 midw_fi_tcl_e32_AppDisplayCategory::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E32_APPDISPLAYCATEGORY;
}


midw_fi_tcl_e32_AppDisplayCategory::~midw_fi_tcl_e32_AppDisplayCategory()
{}

tU32 midw_fi_tcl_e32_AppDisplayCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e32_AppDisplayCategory::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e32_AppDisplayCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e32_AppAudioCategory::midw_fi_tcl_e32_AppAudioCategory():enType(FI_EN_PHONE_AUDIO) {}

tS32 midw_fi_tcl_e32_AppAudioCategory::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E32_APPAUDIOCATEGORY;
}


midw_fi_tcl_e32_AppAudioCategory::~midw_fi_tcl_e32_AppAudioCategory()
{}

tU32 midw_fi_tcl_e32_AppAudioCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e32_AppAudioCategory::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e32_AppAudioCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e16_TrustLevel::midw_fi_tcl_e16_TrustLevel():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_e16_TrustLevel::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E16_TRUSTLEVEL;
}


midw_fi_tcl_e16_TrustLevel::~midw_fi_tcl_e16_TrustLevel()
{}

tU32 midw_fi_tcl_e16_TrustLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_e16_TrustLevel::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e16_TrustLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AppCertificationInfo::midw_fi_tcl_e8_AppCertificationInfo():enType(FI_EN_NOT_CERTIFIED) {}

tS32 midw_fi_tcl_e8_AppCertificationInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPCERTIFICATIONINFO;
}


midw_fi_tcl_e8_AppCertificationInfo::~midw_fi_tcl_e8_AppCertificationInfo()
{}

tU32 midw_fi_tcl_e8_AppCertificationInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AppCertificationInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AppCertificationInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AppCertificationEntity::midw_fi_tcl_e8_AppCertificationEntity():enType(FI_EN_NOT_CERTIFIED) {}

tS32 midw_fi_tcl_e8_AppCertificationEntity::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPCERTIFICATIONENTITY;
}


midw_fi_tcl_e8_AppCertificationEntity::~midw_fi_tcl_e8_AppCertificationEntity()
{}

tU32 midw_fi_tcl_e8_AppCertificationEntity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AppCertificationEntity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AppCertificationEntity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AppStatus::midw_fi_tcl_e8_AppStatus():enType(FI_EN_FOREGROUND) {}

tS32 midw_fi_tcl_e8_AppStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_APPSTATUS;
}


midw_fi_tcl_e8_AppStatus::~midw_fi_tcl_e8_AppStatus()
{}

tU32 midw_fi_tcl_e8_AppStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AppStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AppStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DisplayContext::midw_fi_tcl_e8_DisplayContext():enType(FI_EN_DISPLAY_CONTEXT_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DisplayContext::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISPLAYCONTEXT;
}


midw_fi_tcl_e8_DisplayContext::~midw_fi_tcl_e8_DisplayContext()
{}

tU32 midw_fi_tcl_e8_DisplayContext::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DisplayContext::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DisplayContext::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DAPStatus::midw_fi_tcl_e8_DAPStatus():enType(FI_EN_DAP_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DAPStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DAPSTATUS;
}


midw_fi_tcl_e8_DAPStatus::~midw_fi_tcl_e8_DAPStatus()
{}

tU32 midw_fi_tcl_e8_DAPStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DAPStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DAPStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPOAppType::midw_fi_tcl_e8_DiPOAppType():enType(FI_EN_DIPO_NOT_USED) {}

tS32 midw_fi_tcl_e8_DiPOAppType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOAPPTYPE;
}


midw_fi_tcl_e8_DiPOAppType::~midw_fi_tcl_e8_DiPOAppType()
{}

tU32 midw_fi_tcl_e8_DiPOAppType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPOAppType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPOAppType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_EcnrSetting::midw_fi_tcl_e8_EcnrSetting():enType(FI_EN_ECNR_NOCHANGE) {}

tS32 midw_fi_tcl_e8_EcnrSetting::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_ECNRSETTING;
}


midw_fi_tcl_e8_EcnrSetting::~midw_fi_tcl_e8_EcnrSetting()
{}

tU32 midw_fi_tcl_e8_EcnrSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_EcnrSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_EcnrSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BTChangeInfo::midw_fi_tcl_e8_BTChangeInfo():enType(FI_EN_NO_CHANGE) {}

tS32 midw_fi_tcl_e8_BTChangeInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BTCHANGEINFO;
}


midw_fi_tcl_e8_BTChangeInfo::~midw_fi_tcl_e8_BTChangeInfo()
{}

tU32 midw_fi_tcl_e8_BTChangeInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BTChangeInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BTChangeInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Vehicle_Configuration::midw_fi_tcl_e8_Vehicle_Configuration():enType(FI_EN_DAY_MODE) {}

tS32 midw_fi_tcl_e8_Vehicle_Configuration::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VEHICLE_CONFIGURATION;
}


midw_fi_tcl_e8_Vehicle_Configuration::~midw_fi_tcl_e8_Vehicle_Configuration()
{}

tU32 midw_fi_tcl_e8_Vehicle_Configuration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Vehicle_Configuration::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Vehicle_Configuration::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Region::midw_fi_tcl_e8_Region():enType(FI_EN_WORLD) {}

tS32 midw_fi_tcl_e8_Region::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_REGION;
}


midw_fi_tcl_e8_Region::~midw_fi_tcl_e8_Region()
{}

tU32 midw_fi_tcl_e8_Region::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Region::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Region::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SupportInfo::midw_fi_tcl_e8_SupportInfo():enType(FI_EN_SUPPORT_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_SupportInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SUPPORTINFO;
}


midw_fi_tcl_e8_SupportInfo::~midw_fi_tcl_e8_SupportInfo()
{}

tU32 midw_fi_tcl_e8_SupportInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SupportInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SupportInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_USBPortType::midw_fi_tcl_e8_USBPortType():enType(FI_EN_PORT_TYPE_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_USBPortType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_USBPORTTYPE;
}


midw_fi_tcl_e8_USBPortType::~midw_fi_tcl_e8_USBPortType()
{}

tU32 midw_fi_tcl_e8_USBPortType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_USBPortType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_USBPortType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceType::midw_fi_tcl_e8_DeviceType():enType(FI_EN_DEVICE_TYPE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DeviceType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICETYPE;
}


midw_fi_tcl_e8_DeviceType::~midw_fi_tcl_e8_DeviceType()
{}

tU32 midw_fi_tcl_e8_DeviceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceSelectionState::midw_fi_tcl_e8_DeviceSelectionState():enType(FI_EN_DEVICE_NOT_SELECTED ) {}

tS32 midw_fi_tcl_e8_DeviceSelectionState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICESELECTIONSTATE;
}


midw_fi_tcl_e8_DeviceSelectionState::~midw_fi_tcl_e8_DeviceSelectionState()
{}

tU32 midw_fi_tcl_e8_DeviceSelectionState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceSelectionState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceSelectionState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceSelectionErrorType::midw_fi_tcl_e8_DeviceSelectionErrorType():enType(FI_EN_DEVICE_SELECTION_ERROR_NONE) {}

tS32 midw_fi_tcl_e8_DeviceSelectionErrorType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICESELECTIONERRORTYPE;
}


midw_fi_tcl_e8_DeviceSelectionErrorType::~midw_fi_tcl_e8_DeviceSelectionErrorType()
{}

tU32 midw_fi_tcl_e8_DeviceSelectionErrorType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceSelectionErrorType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceSelectionErrorType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SelectionType::midw_fi_tcl_e8_SelectionType():enType(FI_EN_SELECTION_TYPE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_SelectionType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SELECTIONTYPE;
}


midw_fi_tcl_e8_SelectionType::~midw_fi_tcl_e8_SelectionType()
{}

tU32 midw_fi_tcl_e8_SelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SelectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VideoBlockingReason::midw_fi_tcl_e8_VideoBlockingReason():enType(FI_EN_VIDEO_BLOCKING_REASON_USER_ACTION) {}

tS32 midw_fi_tcl_e8_VideoBlockingReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VIDEOBLOCKINGREASON;
}


midw_fi_tcl_e8_VideoBlockingReason::~midw_fi_tcl_e8_VideoBlockingReason()
{}

tU32 midw_fi_tcl_e8_VideoBlockingReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VideoBlockingReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VideoBlockingReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceSelectionProgressState::midw_fi_tcl_e8_DeviceSelectionProgressState():enType(FI_EN_NOT_APPLICABLE) {}

tS32 midw_fi_tcl_e8_DeviceSelectionProgressState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICESELECTIONPROGRESSSTATE;
}


midw_fi_tcl_e8_DeviceSelectionProgressState::~midw_fi_tcl_e8_DeviceSelectionProgressState()
{}

tU32 midw_fi_tcl_e8_DeviceSelectionProgressState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceSelectionProgressState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceSelectionProgressState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DeviceSelectionInfo::midw_fi_tcl_DeviceSelectionInfo(const midw_fi_tcl_DeviceSelectionInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enDeviceSelectionState = coRef.enDeviceSelectionState;
   enDeviceSelectionErrorType = coRef.enDeviceSelectionErrorType;
   enDeviceSelectionProgressState = coRef.enDeviceSelectionProgressState;
}
midw_fi_tcl_DeviceSelectionInfo& midw_fi_tcl_DeviceSelectionInfo::operator=(const midw_fi_tcl_DeviceSelectionInfo& coRef)
{
   if (this == &coRef) return *this;
   enDeviceSelectionState = coRef.enDeviceSelectionState;
   enDeviceSelectionErrorType = coRef.enDeviceSelectionErrorType;
   enDeviceSelectionProgressState = coRef.enDeviceSelectionProgressState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_DeviceSelectionInfo::midw_fi_tcl_DeviceSelectionInfo()
:enDeviceSelectionState()
,enDeviceSelectionErrorType()
,enDeviceSelectionProgressState()
 {}

tS32 midw_fi_tcl_DeviceSelectionInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DEVICESELECTIONINFO;
}


midw_fi_tcl_DeviceSelectionInfo::~midw_fi_tcl_DeviceSelectionInfo()
{}

tU32 midw_fi_tcl_DeviceSelectionInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_DeviceSelectionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDeviceSelectionState);
   (tVoid) (oIn >> enDeviceSelectionErrorType);
   (tVoid) (oIn >> enDeviceSelectionProgressState);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DeviceSelectionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDeviceSelectionState);
   (tVoid) (oOut << enDeviceSelectionErrorType);
   (tVoid) (oOut << enDeviceSelectionProgressState);
   return oOut;
}

tBool midw_fi_tcl_DeviceSelectionInfo::operator==(const midw_fi_tcl_DeviceSelectionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDeviceSelectionState == roRef.enDeviceSelectionState);
   bResult = bResult && (enDeviceSelectionErrorType == roRef.enDeviceSelectionErrorType);
   bResult = bResult && (enDeviceSelectionProgressState == roRef.enDeviceSelectionProgressState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_VersionInfo::midw_fi_tcl_VersionInfo(const midw_fi_tcl_VersionInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   szMinorVersion = coRef.szMinorVersion;
   szMajorVersion = coRef.szMajorVersion;
   szPatchVersion = coRef.szPatchVersion;
}
midw_fi_tcl_VersionInfo& midw_fi_tcl_VersionInfo::operator=(const midw_fi_tcl_VersionInfo& coRef)
{
   if (this == &coRef) return *this;
   szMinorVersion = coRef.szMinorVersion;
   szMajorVersion = coRef.szMajorVersion;
   szPatchVersion = coRef.szPatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_VersionInfo::vDestroy()
{
   szMinorVersion.vDestroy();
   szMajorVersion.vDestroy();
   szPatchVersion.vDestroy();
}

midw_fi_tcl_VersionInfo::midw_fi_tcl_VersionInfo()
:szMinorVersion()
,szMajorVersion()
,szPatchVersion()
 {}

tS32 midw_fi_tcl_VersionInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VERSIONINFO;
}


midw_fi_tcl_VersionInfo::~midw_fi_tcl_VersionInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_VersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szMinorVersion.u32GetSize(u16MajorVersion)+szMajorVersion.u32GetSize(u16MajorVersion)+szPatchVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_VersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szMinorVersion);
   (tVoid) (oIn >> szMajorVersion);
   (tVoid) (oIn >> szPatchVersion);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_VersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szMinorVersion);
   (tVoid) (oOut << szMajorVersion);
   (tVoid) (oOut << szPatchVersion);
   return oOut;
}

tBool midw_fi_tcl_VersionInfo::operator==(const midw_fi_tcl_VersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szMinorVersion == roRef.szMinorVersion);
   bResult = bResult && (szMajorVersion == roRef.szMajorVersion);
   bResult = bResult && (szPatchVersion == roRef.szPatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AppRemotingInfo::midw_fi_tcl_AppRemotingInfo(const midw_fi_tcl_AppRemotingInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   szRemotingProtocolID = coRef.szRemotingProtocolID;
   szRemotingFormat = coRef.szRemotingFormat;
   szRemotingDirection = coRef.szRemotingDirection;
   u32RemotingAudioIPL = coRef.u32RemotingAudioIPL;
   u32RemotingAudioMPL = coRef.u32RemotingAudioMPL;
}
midw_fi_tcl_AppRemotingInfo& midw_fi_tcl_AppRemotingInfo::operator=(const midw_fi_tcl_AppRemotingInfo& coRef)
{
   if (this == &coRef) return *this;
   szRemotingProtocolID = coRef.szRemotingProtocolID;
   szRemotingFormat = coRef.szRemotingFormat;
   szRemotingDirection = coRef.szRemotingDirection;
   u32RemotingAudioIPL = coRef.u32RemotingAudioIPL;
   u32RemotingAudioMPL = coRef.u32RemotingAudioMPL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AppRemotingInfo::vDestroy()
{
   szRemotingProtocolID.vDestroy();
   szRemotingFormat.vDestroy();
   szRemotingDirection.vDestroy();
}

midw_fi_tcl_AppRemotingInfo::midw_fi_tcl_AppRemotingInfo()
:szRemotingProtocolID()
,szRemotingFormat()
,szRemotingDirection()
,u32RemotingAudioIPL(0)
,u32RemotingAudioMPL(0)
 {}

tS32 midw_fi_tcl_AppRemotingInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPREMOTINGINFO;
}


midw_fi_tcl_AppRemotingInfo::~midw_fi_tcl_AppRemotingInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AppRemotingInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+szRemotingProtocolID.u32GetSize(u16MajorVersion)+szRemotingFormat.u32GetSize(u16MajorVersion)+szRemotingDirection.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AppRemotingInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szRemotingProtocolID);
   (tVoid) (oIn >> szRemotingFormat);
   (tVoid) (oIn >> szRemotingDirection);
   (tVoid) (oIn >> u32RemotingAudioIPL);
   (tVoid) (oIn >> u32RemotingAudioMPL);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AppRemotingInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szRemotingProtocolID);
   (tVoid) (oOut << szRemotingFormat);
   (tVoid) (oOut << szRemotingDirection);
   (tVoid) (oOut << u32RemotingAudioIPL);
   (tVoid) (oOut << u32RemotingAudioMPL);
   return oOut;
}

tBool midw_fi_tcl_AppRemotingInfo::operator==(const midw_fi_tcl_AppRemotingInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szRemotingProtocolID == roRef.szRemotingProtocolID);
   bResult = bResult && (szRemotingFormat == roRef.szRemotingFormat);
   bResult = bResult && (szRemotingDirection == roRef.szRemotingDirection);
   bResult = bResult && (u32RemotingAudioIPL == roRef.u32RemotingAudioIPL);
   bResult = bResult && (u32RemotingAudioMPL == roRef.u32RemotingAudioMPL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AppDisplayInfo::midw_fi_tcl_AppDisplayInfo(const midw_fi_tcl_AppDisplayInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enAppDisplayCategory = coRef.enAppDisplayCategory;
   enTrustLevel = coRef.enTrustLevel;
   u32AppDisplayRules = coRef.u32AppDisplayRules;
   szAppDisplayOrientation = coRef.szAppDisplayOrientation;
}
midw_fi_tcl_AppDisplayInfo& midw_fi_tcl_AppDisplayInfo::operator=(const midw_fi_tcl_AppDisplayInfo& coRef)
{
   if (this == &coRef) return *this;
   enAppDisplayCategory = coRef.enAppDisplayCategory;
   enTrustLevel = coRef.enTrustLevel;
   u32AppDisplayRules = coRef.u32AppDisplayRules;
   szAppDisplayOrientation = coRef.szAppDisplayOrientation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AppDisplayInfo::vDestroy()
{
   szAppDisplayOrientation.vDestroy();
}

midw_fi_tcl_AppDisplayInfo::midw_fi_tcl_AppDisplayInfo()
:enAppDisplayCategory()
,enTrustLevel()
,u32AppDisplayRules(0)
,szAppDisplayOrientation()
 {}

tS32 midw_fi_tcl_AppDisplayInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPDISPLAYINFO;
}


midw_fi_tcl_AppDisplayInfo::~midw_fi_tcl_AppDisplayInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AppDisplayInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+szAppDisplayOrientation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AppDisplayInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enAppDisplayCategory);
   (tVoid) (oIn >> enTrustLevel);
   (tVoid) (oIn >> u32AppDisplayRules);
   (tVoid) (oIn >> szAppDisplayOrientation);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AppDisplayInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enAppDisplayCategory);
   (tVoid) (oOut << enTrustLevel);
   (tVoid) (oOut << u32AppDisplayRules);
   (tVoid) (oOut << szAppDisplayOrientation);
   return oOut;
}

tBool midw_fi_tcl_AppDisplayInfo::operator==(const midw_fi_tcl_AppDisplayInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enAppDisplayCategory == roRef.enAppDisplayCategory);
   bResult = bResult && (enTrustLevel == roRef.enTrustLevel);
   bResult = bResult && (u32AppDisplayRules == roRef.u32AppDisplayRules);
   bResult = bResult && (szAppDisplayOrientation == roRef.szAppDisplayOrientation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AppAudioInfo::midw_fi_tcl_AppAudioInfo(const midw_fi_tcl_AppAudioInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   szAppAudioType = coRef.szAppAudioType;
   enAppAudioCategory = coRef.enAppAudioCategory;
   enTrustLevel = coRef.enTrustLevel;
   u32AppAudioRules = coRef.u32AppAudioRules;
}
midw_fi_tcl_AppAudioInfo& midw_fi_tcl_AppAudioInfo::operator=(const midw_fi_tcl_AppAudioInfo& coRef)
{
   if (this == &coRef) return *this;
   szAppAudioType = coRef.szAppAudioType;
   enAppAudioCategory = coRef.enAppAudioCategory;
   enTrustLevel = coRef.enTrustLevel;
   u32AppAudioRules = coRef.u32AppAudioRules;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AppAudioInfo::vDestroy()
{
   szAppAudioType.vDestroy();
}

midw_fi_tcl_AppAudioInfo::midw_fi_tcl_AppAudioInfo()
:szAppAudioType()
,enAppAudioCategory()
,enTrustLevel()
,u32AppAudioRules(0)
 {}

tS32 midw_fi_tcl_AppAudioInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPAUDIOINFO;
}


midw_fi_tcl_AppAudioInfo::~midw_fi_tcl_AppAudioInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AppAudioInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+szAppAudioType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AppAudioInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szAppAudioType);
   (tVoid) (oIn >> enAppAudioCategory);
   (tVoid) (oIn >> enTrustLevel);
   (tVoid) (oIn >> u32AppAudioRules);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AppAudioInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szAppAudioType);
   (tVoid) (oOut << enAppAudioCategory);
   (tVoid) (oOut << enTrustLevel);
   (tVoid) (oOut << u32AppAudioRules);
   return oOut;
}

tBool midw_fi_tcl_AppAudioInfo::operator==(const midw_fi_tcl_AppAudioInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szAppAudioType == roRef.szAppAudioType);
   bResult = bResult && (enAppAudioCategory == roRef.enAppAudioCategory);
   bResult = bResult && (enTrustLevel == roRef.enTrustLevel);
   bResult = bResult && (u32AppAudioRules == roRef.u32AppAudioRules);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_IconAttributes::midw_fi_tcl_IconAttributes(const midw_fi_tcl_IconAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32IconWidth = coRef.u32IconWidth;
   u32IconHeight = coRef.u32IconHeight;
   u32IconDepth = coRef.u32IconDepth;
   enIconMimeType = coRef.enIconMimeType;
   szIconURL = coRef.szIconURL;
}
midw_fi_tcl_IconAttributes& midw_fi_tcl_IconAttributes::operator=(const midw_fi_tcl_IconAttributes& coRef)
{
   if (this == &coRef) return *this;
   u32IconWidth = coRef.u32IconWidth;
   u32IconHeight = coRef.u32IconHeight;
   u32IconDepth = coRef.u32IconDepth;
   enIconMimeType = coRef.enIconMimeType;
   szIconURL = coRef.szIconURL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_IconAttributes::vDestroy()
{
   szIconURL.vDestroy();
}

midw_fi_tcl_IconAttributes::midw_fi_tcl_IconAttributes()
:u32IconWidth(0)
,u32IconHeight(0)
,u32IconDepth(0)
,enIconMimeType()
,szIconURL()
 {}

tS32 midw_fi_tcl_IconAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ICONATTRIBUTES;
}


midw_fi_tcl_IconAttributes::~midw_fi_tcl_IconAttributes()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_IconAttributes::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+szIconURL.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_IconAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32IconWidth);
   (tVoid) (oIn >> u32IconHeight);
   (tVoid) (oIn >> u32IconDepth);
   (tVoid) (oIn >> enIconMimeType);
   (tVoid) (oIn >> szIconURL);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_IconAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32IconWidth);
   (tVoid) (oOut << u32IconHeight);
   (tVoid) (oOut << u32IconDepth);
   (tVoid) (oOut << enIconMimeType);
   (tVoid) (oOut << szIconURL);
   return oOut;
}

tBool midw_fi_tcl_IconAttributes::operator==(const midw_fi_tcl_IconAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32IconWidth == roRef.u32IconWidth);
   bResult = bResult && (u32IconHeight == roRef.u32IconHeight);
   bResult = bResult && (u32IconDepth == roRef.u32IconDepth);
   bResult = bResult && (enIconMimeType == roRef.enIconMimeType);
   bResult = bResult && (szIconURL == roRef.szIconURL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ProjectionCapability::midw_fi_tcl_ProjectionCapability(const midw_fi_tcl_ProjectionCapability& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enUSBPortType = coRef.enUSBPortType;
   enDeviceType = coRef.enDeviceType;
   enCarplayProjection = coRef.enCarplayProjection;
   enAndroidProjection = coRef.enAndroidProjection;
   enMirrorlinkProjection = coRef.enMirrorlinkProjection;
   enMySPINProjection = coRef.enMySPINProjection;
   enCarlifeProjection = coRef.enCarlifeProjection;
   enOnCarProjection = coRef.enOnCarProjection;
}
midw_fi_tcl_ProjectionCapability& midw_fi_tcl_ProjectionCapability::operator=(const midw_fi_tcl_ProjectionCapability& coRef)
{
   if (this == &coRef) return *this;
   enUSBPortType = coRef.enUSBPortType;
   enDeviceType = coRef.enDeviceType;
   enCarplayProjection = coRef.enCarplayProjection;
   enAndroidProjection = coRef.enAndroidProjection;
   enMirrorlinkProjection = coRef.enMirrorlinkProjection;
   enMySPINProjection = coRef.enMySPINProjection;
   enCarlifeProjection = coRef.enCarlifeProjection;
   enOnCarProjection = coRef.enOnCarProjection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProjectionCapability::midw_fi_tcl_ProjectionCapability()
:enUSBPortType()
,enDeviceType()
,enCarplayProjection()
,enAndroidProjection()
,enMirrorlinkProjection()
,enMySPINProjection()
,enCarlifeProjection()
,enOnCarProjection()
 {}

tS32 midw_fi_tcl_ProjectionCapability::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROJECTIONCAPABILITY;
}


midw_fi_tcl_ProjectionCapability::~midw_fi_tcl_ProjectionCapability()
{}

tU32 midw_fi_tcl_ProjectionCapability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_ProjectionCapability::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enUSBPortType);
   (tVoid) (oIn >> enDeviceType);
   (tVoid) (oIn >> enCarplayProjection);
   (tVoid) (oIn >> enAndroidProjection);
   (tVoid) (oIn >> enMirrorlinkProjection);
   (tVoid) (oIn >> enMySPINProjection);
   (tVoid) (oIn >> enCarlifeProjection);
   (tVoid) (oIn >> enOnCarProjection);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProjectionCapability::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enUSBPortType);
   (tVoid) (oOut << enDeviceType);
   (tVoid) (oOut << enCarplayProjection);
   (tVoid) (oOut << enAndroidProjection);
   (tVoid) (oOut << enMirrorlinkProjection);
   (tVoid) (oOut << enMySPINProjection);
   (tVoid) (oOut << enCarlifeProjection);
   (tVoid) (oOut << enOnCarProjection);
   return oOut;
}

tBool midw_fi_tcl_ProjectionCapability::operator==(const midw_fi_tcl_ProjectionCapability& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enUSBPortType == roRef.enUSBPortType);
   bResult = bResult && (enDeviceType == roRef.enDeviceType);
   bResult = bResult && (enCarplayProjection == roRef.enCarplayProjection);
   bResult = bResult && (enAndroidProjection == roRef.enAndroidProjection);
   bResult = bResult && (enMirrorlinkProjection == roRef.enMirrorlinkProjection);
   bResult = bResult && (enMySPINProjection == roRef.enMySPINProjection);
   bResult = bResult && (enCarlifeProjection == roRef.enCarlifeProjection);
   bResult = bResult && (enOnCarProjection == roRef.enOnCarProjection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_EAPAppInfo::midw_fi_tcl_EAPAppInfo(const midw_fi_tcl_EAPAppInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   szAppName = coRef.szAppName;
   szProtocol = coRef.szProtocol;
   szBundleID = coRef.szBundleID;
}
midw_fi_tcl_EAPAppInfo& midw_fi_tcl_EAPAppInfo::operator=(const midw_fi_tcl_EAPAppInfo& coRef)
{
   if (this == &coRef) return *this;
   szAppName = coRef.szAppName;
   szProtocol = coRef.szProtocol;
   szBundleID = coRef.szBundleID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_EAPAppInfo::vDestroy()
{
   szAppName.vDestroy();
   szProtocol.vDestroy();
   szBundleID.vDestroy();
}

midw_fi_tcl_EAPAppInfo::midw_fi_tcl_EAPAppInfo()
:szAppName()
,szProtocol()
,szBundleID()
 {}

tS32 midw_fi_tcl_EAPAppInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_EAPAPPINFO;
}


midw_fi_tcl_EAPAppInfo::~midw_fi_tcl_EAPAppInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_EAPAppInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szAppName.u32GetSize(u16MajorVersion)+szProtocol.u32GetSize(u16MajorVersion)+szBundleID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_EAPAppInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> szProtocol);
   (tVoid) (oIn >> szBundleID);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_EAPAppInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << szProtocol);
   (tVoid) (oOut << szBundleID);
   return oOut;
}

tBool midw_fi_tcl_EAPAppInfo::operator==(const midw_fi_tcl_EAPAppInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (szProtocol == roRef.szProtocol);
   bResult = bResult && (szBundleID == roRef.szBundleID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AppDetails::midw_fi_tcl_AppDetails(const midw_fi_tcl_AppDetails& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32AppHandle = coRef.u32AppHandle;
   szAppName = coRef.szAppName;
   enAppStatus = coRef.enAppStatus;
   szAppVariant = coRef.szAppVariant;
   szAppProviderName = coRef.szAppProviderName;
   szAppProviderURL = coRef.szAppProviderURL;
   szAppDescription = coRef.szAppDescription;
   AppAllowedProfiles = coRef.AppAllowedProfiles;
   szAppCertificateURL = coRef.szAppCertificateURL;
   enAppCategory = coRef.enAppCategory;
   enTrustLevel = coRef.enTrustLevel;
   e8AppCertificationInfo = coRef.e8AppCertificationInfo;
   rAppDisplayInfo = coRef.rAppDisplayInfo;
   rAppAudioInfo = coRef.rAppAudioInfo;
   rAppRemotingInfo = coRef.rAppRemotingInfo;
   u16NumAppIcons = coRef.u16NumAppIcons;
   AppIconList = coRef.AppIconList;
   e8AppCertificationEntity = coRef.e8AppCertificationEntity;
}
midw_fi_tcl_AppDetails& midw_fi_tcl_AppDetails::operator=(const midw_fi_tcl_AppDetails& coRef)
{
   if (this == &coRef) return *this;
   u32AppHandle = coRef.u32AppHandle;
   szAppName = coRef.szAppName;
   enAppStatus = coRef.enAppStatus;
   szAppVariant = coRef.szAppVariant;
   szAppProviderName = coRef.szAppProviderName;
   szAppProviderURL = coRef.szAppProviderURL;
   szAppDescription = coRef.szAppDescription;
   AppAllowedProfiles = coRef.AppAllowedProfiles;
   szAppCertificateURL = coRef.szAppCertificateURL;
   enAppCategory = coRef.enAppCategory;
   enTrustLevel = coRef.enTrustLevel;
   e8AppCertificationInfo = coRef.e8AppCertificationInfo;
   rAppDisplayInfo = coRef.rAppDisplayInfo;
   rAppAudioInfo = coRef.rAppAudioInfo;
   rAppRemotingInfo = coRef.rAppRemotingInfo;
   u16NumAppIcons = coRef.u16NumAppIcons;
   AppIconList = coRef.AppIconList;
   e8AppCertificationEntity = coRef.e8AppCertificationEntity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AppDetails::vDestroy()
{
   szAppName.vDestroy();
   szAppVariant.vDestroy();
   szAppProviderName.vDestroy();
   szAppProviderURL.vDestroy();
   szAppDescription.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < AppAllowedProfiles.size(); ++u32Idx)
         AppAllowedProfiles[u32Idx].vDestroy();
   AppAllowedProfiles.clear();
   }
   szAppCertificateURL.vDestroy();
   rAppDisplayInfo.vDestroy(); 
   rAppAudioInfo.vDestroy(); 
   rAppRemotingInfo.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < AppIconList.size(); ++u32Idx)
         AppIconList[u32Idx].vDestroy();
   AppIconList.clear();
   }
}

midw_fi_tcl_AppDetails::midw_fi_tcl_AppDetails()
:u32AppHandle(0)
,szAppName()
,enAppStatus()
,szAppVariant()
,szAppProviderName()
,szAppProviderURL()
,szAppDescription()

,szAppCertificateURL()
,enAppCategory()
,enTrustLevel()
,e8AppCertificationInfo()
,rAppDisplayInfo()
,rAppAudioInfo()
,rAppRemotingInfo()
,u16NumAppIcons(0)

,e8AppCertificationEntity()
 {}

tS32 midw_fi_tcl_AppDetails::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPDETAILS;
}


midw_fi_tcl_AppDetails::~midw_fi_tcl_AppDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AppDetails::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AppAllowedProfiles.size(); ++u32ListIdx)
      u32DynamicSize += AppAllowedProfiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < AppIconList.size(); ++u32ListIdx)
      u32DynamicSize += AppIconList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+23+szAppName.u32GetSize(u16MajorVersion)+szAppVariant.u32GetSize(u16MajorVersion)+szAppProviderName.u32GetSize(u16MajorVersion)+szAppProviderURL.u32GetSize(u16MajorVersion)+szAppDescription.u32GetSize(u16MajorVersion)+szAppCertificateURL.u32GetSize(u16MajorVersion)+rAppDisplayInfo.u32GetSize(u16MajorVersion)+rAppAudioInfo.u32GetSize(u16MajorVersion)+rAppRemotingInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AppDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppHandle);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> enAppStatus);
   (tVoid) (oIn >> szAppVariant);
   (tVoid) (oIn >> szAppProviderName);
   (tVoid) (oIn >> szAppProviderURL);
   (tVoid) (oIn >> szAppDescription);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AppAllowedProfiles.size(); ++u32Idx)
      {
         AppAllowedProfiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AppAllowedProfiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AppAllowedProfiles[u32Idx]);
      }
   }
   (tVoid) (oIn >> szAppCertificateURL);
   (tVoid) (oIn >> enAppCategory);
   (tVoid) (oIn >> enTrustLevel);
   (tVoid) (oIn >> e8AppCertificationInfo);
   (tVoid) (oIn >> rAppDisplayInfo);
   (tVoid) (oIn >> rAppAudioInfo);
   (tVoid) (oIn >> rAppRemotingInfo);
   (tVoid) (oIn >> u16NumAppIcons);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AppIconList.size(); ++u32Idx)
      {
         AppIconList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AppIconList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AppIconList[u32Idx]);
      }
   }
   (tVoid) (oIn >> e8AppCertificationEntity);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AppDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppHandle);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << enAppStatus);
   (tVoid) (oOut << szAppVariant);
   (tVoid) (oOut << szAppProviderName);
   (tVoid) (oOut << szAppProviderURL);
   (tVoid) (oOut << szAppDescription);
   (tVoid) (oOut << (tU32)AppAllowedProfiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AppAllowedProfiles.size(); ++u32Idx)
         (tVoid) (oOut << AppAllowedProfiles[u32Idx]);
   }
   (tVoid) (oOut << szAppCertificateURL);
   (tVoid) (oOut << enAppCategory);
   (tVoid) (oOut << enTrustLevel);
   (tVoid) (oOut << e8AppCertificationInfo);
   (tVoid) (oOut << rAppDisplayInfo);
   (tVoid) (oOut << rAppAudioInfo);
   (tVoid) (oOut << rAppRemotingInfo);
   (tVoid) (oOut << u16NumAppIcons);
   (tVoid) (oOut << (tU32)AppIconList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AppIconList.size(); ++u32Idx)
         (tVoid) (oOut << AppIconList[u32Idx]);
   }
   (tVoid) (oOut << e8AppCertificationEntity);
   return oOut;
}

tBool midw_fi_tcl_AppDetails::operator==(const midw_fi_tcl_AppDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppHandle == roRef.u32AppHandle);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (enAppStatus == roRef.enAppStatus);
   bResult = bResult && (szAppVariant == roRef.szAppVariant);
   bResult = bResult && (szAppProviderName == roRef.szAppProviderName);
   bResult = bResult && (szAppProviderURL == roRef.szAppProviderURL);
   bResult = bResult && (szAppDescription == roRef.szAppDescription);
      bResult = bResult && (AppAllowedProfiles.size() == roRef.AppAllowedProfiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AppAllowedProfiles.size()); ++u32Idx)
            bResult = bResult && (AppAllowedProfiles[u32Idx] == roRef.AppAllowedProfiles[u32Idx]);
      }
   bResult = bResult && (szAppCertificateURL == roRef.szAppCertificateURL);
   bResult = bResult && (enAppCategory == roRef.enAppCategory);
   bResult = bResult && (enTrustLevel == roRef.enTrustLevel);
   bResult = bResult && (e8AppCertificationInfo == roRef.e8AppCertificationInfo);
   bResult = bResult && (rAppDisplayInfo == roRef.rAppDisplayInfo);
   bResult = bResult && (rAppAudioInfo == roRef.rAppAudioInfo);
   bResult = bResult && (rAppRemotingInfo == roRef.rAppRemotingInfo);
   bResult = bResult && (u16NumAppIcons == roRef.u16NumAppIcons);
      bResult = bResult && (AppIconList.size() == roRef.AppIconList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AppIconList.size()); ++u32Idx)
            bResult = bResult && (AppIconList[u32Idx] == roRef.AppIconList[u32Idx]);
      }
   bResult = bResult && (e8AppCertificationEntity == roRef.e8AppCertificationEntity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TouchCoordinates::midw_fi_tcl_TouchCoordinates(const midw_fi_tcl_TouchCoordinates& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enTouchMode = coRef.enTouchMode;
   u16XCoordinate = coRef.u16XCoordinate;
   u16YCoordinate = coRef.u16YCoordinate;
}
midw_fi_tcl_TouchCoordinates& midw_fi_tcl_TouchCoordinates::operator=(const midw_fi_tcl_TouchCoordinates& coRef)
{
   if (this == &coRef) return *this;
   enTouchMode = coRef.enTouchMode;
   u16XCoordinate = coRef.u16XCoordinate;
   u16YCoordinate = coRef.u16YCoordinate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_TouchCoordinates::midw_fi_tcl_TouchCoordinates()
:enTouchMode()
,u16XCoordinate(0)
,u16YCoordinate(0)
 {}

tS32 midw_fi_tcl_TouchCoordinates::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TOUCHCOORDINATES;
}


midw_fi_tcl_TouchCoordinates::~midw_fi_tcl_TouchCoordinates()
{}

tU32 midw_fi_tcl_TouchCoordinates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_TouchCoordinates::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTouchMode);
   (tVoid) (oIn >> u16XCoordinate);
   (tVoid) (oIn >> u16YCoordinate);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TouchCoordinates::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTouchMode);
   (tVoid) (oOut << u16XCoordinate);
   (tVoid) (oOut << u16YCoordinate);
   return oOut;
}

tBool midw_fi_tcl_TouchCoordinates::operator==(const midw_fi_tcl_TouchCoordinates& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTouchMode == roRef.enTouchMode);
   bResult = bResult && (u16XCoordinate == roRef.u16XCoordinate);
   bResult = bResult && (u16YCoordinate == roRef.u16YCoordinate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TouchInfo::midw_fi_tcl_TouchInfo(const midw_fi_tcl_TouchInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TouchCoordinatesList = coRef.TouchCoordinatesList;
}
midw_fi_tcl_TouchInfo& midw_fi_tcl_TouchInfo::operator=(const midw_fi_tcl_TouchInfo& coRef)
{
   if (this == &coRef) return *this;
   TouchCoordinatesList = coRef.TouchCoordinatesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TouchInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TouchCoordinatesList.size(); ++u32Idx)
         TouchCoordinatesList[u32Idx].vDestroy();
   TouchCoordinatesList.clear();
   }
}

midw_fi_tcl_TouchInfo::midw_fi_tcl_TouchInfo()

 {}

tS32 midw_fi_tcl_TouchInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TOUCHINFO;
}


midw_fi_tcl_TouchInfo::~midw_fi_tcl_TouchInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TouchInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TouchCoordinatesList.size()*5);
}

fi_tclInContext& midw_fi_tcl_TouchInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TouchCoordinatesList.size(); ++u32Idx)
      {
         TouchCoordinatesList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TouchCoordinatesList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TouchCoordinatesList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TouchInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TouchCoordinatesList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TouchCoordinatesList.size(); ++u32Idx)
         (tVoid) (oOut << TouchCoordinatesList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TouchInfo::operator==(const midw_fi_tcl_TouchInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TouchCoordinatesList.size() == roRef.TouchCoordinatesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TouchCoordinatesList.size()); ++u32Idx)
            bResult = bResult && (TouchCoordinatesList[u32Idx] == roRef.TouchCoordinatesList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_TouchData::midw_fi_tcl_TouchData(const midw_fi_tcl_TouchData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16TouchDescriptors = coRef.u16TouchDescriptors;
   TouchInfoList = coRef.TouchInfoList;
}
midw_fi_tcl_TouchData& midw_fi_tcl_TouchData::operator=(const midw_fi_tcl_TouchData& coRef)
{
   if (this == &coRef) return *this;
   u16TouchDescriptors = coRef.u16TouchDescriptors;
   TouchInfoList = coRef.TouchInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_TouchData::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TouchInfoList.size(); ++u32Idx)
         TouchInfoList[u32Idx].vDestroy();
   TouchInfoList.clear();
   }
}

midw_fi_tcl_TouchData::midw_fi_tcl_TouchData()
:u16TouchDescriptors(0)

 {}

tS32 midw_fi_tcl_TouchData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TOUCHDATA;
}


midw_fi_tcl_TouchData::~midw_fi_tcl_TouchData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_TouchData::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TouchInfoList.size(); ++u32ListIdx)
      u32DynamicSize += TouchInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_fi_tcl_TouchData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16TouchDescriptors);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TouchInfoList.size(); ++u32Idx)
      {
         TouchInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TouchInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TouchInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_TouchData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16TouchDescriptors);
   (tVoid) (oOut << (tU32)TouchInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TouchInfoList.size(); ++u32Idx)
         (tVoid) (oOut << TouchInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_TouchData::operator==(const midw_fi_tcl_TouchData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16TouchDescriptors == roRef.u16TouchDescriptors);
      bResult = bResult && (TouchInfoList.size() == roRef.TouchInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TouchInfoList.size()); ++u32Idx)
            bResult = bResult && (TouchInfoList[u32Idx] == roRef.TouchInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ScreenAttributes::midw_fi_tcl_ScreenAttributes(const midw_fi_tcl_ScreenAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16ScreenHeight = coRef.u16ScreenHeight;
   u16ScreenWidth = coRef.u16ScreenWidth;
   enScreenAspectRatio = coRef.enScreenAspectRatio;
}
midw_fi_tcl_ScreenAttributes& midw_fi_tcl_ScreenAttributes::operator=(const midw_fi_tcl_ScreenAttributes& coRef)
{
   if (this == &coRef) return *this;
   u16ScreenHeight = coRef.u16ScreenHeight;
   u16ScreenWidth = coRef.u16ScreenWidth;
   enScreenAspectRatio = coRef.enScreenAspectRatio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ScreenAttributes::midw_fi_tcl_ScreenAttributes()
:u16ScreenHeight(0)
,u16ScreenWidth(0)
,enScreenAspectRatio()
 {}

tS32 midw_fi_tcl_ScreenAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_SCREENATTRIBUTES;
}


midw_fi_tcl_ScreenAttributes::~midw_fi_tcl_ScreenAttributes()
{}

tU32 midw_fi_tcl_ScreenAttributes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_ScreenAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ScreenHeight);
   (tVoid) (oIn >> u16ScreenWidth);
   (tVoid) (oIn >> enScreenAspectRatio);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ScreenAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ScreenHeight);
   (tVoid) (oOut << u16ScreenWidth);
   (tVoid) (oOut << enScreenAspectRatio);
   return oOut;
}

tBool midw_fi_tcl_ScreenAttributes::operator==(const midw_fi_tcl_ScreenAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ScreenHeight == roRef.u16ScreenHeight);
   bResult = bResult && (u16ScreenWidth == roRef.u16ScreenWidth);
   bResult = bResult && (enScreenAspectRatio == roRef.enScreenAspectRatio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_NotificationEnable::midw_fi_tcl_NotificationEnable(const midw_fi_tcl_NotificationEnable& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32AppHandle = coRef.u32AppHandle;
   enEnabledInfo = coRef.enEnabledInfo;
}
midw_fi_tcl_NotificationEnable& midw_fi_tcl_NotificationEnable::operator=(const midw_fi_tcl_NotificationEnable& coRef)
{
   if (this == &coRef) return *this;
   u32AppHandle = coRef.u32AppHandle;
   enEnabledInfo = coRef.enEnabledInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_NotificationEnable::midw_fi_tcl_NotificationEnable()
:u32AppHandle(0)
,enEnabledInfo()
 {}

tS32 midw_fi_tcl_NotificationEnable::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_NOTIFICATIONENABLE;
}


midw_fi_tcl_NotificationEnable::~midw_fi_tcl_NotificationEnable()
{}

tU32 midw_fi_tcl_NotificationEnable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_fi_tcl_NotificationEnable::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AppHandle);
   (tVoid) (oIn >> enEnabledInfo);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_NotificationEnable::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AppHandle);
   (tVoid) (oOut << enEnabledInfo);
   return oOut;
}

tBool midw_fi_tcl_NotificationEnable::operator==(const midw_fi_tcl_NotificationEnable& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AppHandle == roRef.u32AppHandle);
   bResult = bResult && (enEnabledInfo == roRef.enEnabledInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_NotificationAction::midw_fi_tcl_NotificationAction(const midw_fi_tcl_NotificationAction& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16NotificationActionID = coRef.u16NotificationActionID;
   szNotificationActionName = coRef.szNotificationActionName;
   u16NotificationActionIconCount = coRef.u16NotificationActionIconCount;
   NotificationActionIconList = coRef.NotificationActionIconList;
}
midw_fi_tcl_NotificationAction& midw_fi_tcl_NotificationAction::operator=(const midw_fi_tcl_NotificationAction& coRef)
{
   if (this == &coRef) return *this;
   u16NotificationActionID = coRef.u16NotificationActionID;
   szNotificationActionName = coRef.szNotificationActionName;
   u16NotificationActionIconCount = coRef.u16NotificationActionIconCount;
   NotificationActionIconList = coRef.NotificationActionIconList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_NotificationAction::vDestroy()
{
   szNotificationActionName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationActionIconList.size(); ++u32Idx)
         NotificationActionIconList[u32Idx].vDestroy();
   NotificationActionIconList.clear();
   }
}

midw_fi_tcl_NotificationAction::midw_fi_tcl_NotificationAction()
:u16NotificationActionID(0)
,szNotificationActionName()
,u16NotificationActionIconCount(0)

 {}

tS32 midw_fi_tcl_NotificationAction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_NOTIFICATIONACTION;
}


midw_fi_tcl_NotificationAction::~midw_fi_tcl_NotificationAction()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_NotificationAction::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NotificationActionIconList.size(); ++u32ListIdx)
      u32DynamicSize += NotificationActionIconList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+szNotificationActionName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_NotificationAction::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NotificationActionID);
   (tVoid) (oIn >> szNotificationActionName);
   (tVoid) (oIn >> u16NotificationActionIconCount);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NotificationActionIconList.size(); ++u32Idx)
      {
         NotificationActionIconList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NotificationActionIconList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NotificationActionIconList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_NotificationAction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NotificationActionID);
   (tVoid) (oOut << szNotificationActionName);
   (tVoid) (oOut << u16NotificationActionIconCount);
   (tVoid) (oOut << (tU32)NotificationActionIconList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationActionIconList.size(); ++u32Idx)
         (tVoid) (oOut << NotificationActionIconList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_NotificationAction::operator==(const midw_fi_tcl_NotificationAction& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NotificationActionID == roRef.u16NotificationActionID);
   bResult = bResult && (szNotificationActionName == roRef.szNotificationActionName);
   bResult = bResult && (u16NotificationActionIconCount == roRef.u16NotificationActionIconCount);
      bResult = bResult && (NotificationActionIconList.size() == roRef.NotificationActionIconList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NotificationActionIconList.size()); ++u32Idx)
            bResult = bResult && (NotificationActionIconList[u32Idx] == roRef.NotificationActionIconList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_NotificationData::midw_fi_tcl_NotificationData(const midw_fi_tcl_NotificationData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16NotificationID = coRef.u16NotificationID;
   szNotificationTitle = coRef.szNotificationTitle;
   szNotificationBody = coRef.szNotificationBody;
   u16NotificationIconCount = coRef.u16NotificationIconCount;
   NotificationIconList = coRef.NotificationIconList;
   u16NotificationAppID = coRef.u16NotificationAppID;
   NotificationActionList = coRef.NotificationActionList;
}
midw_fi_tcl_NotificationData& midw_fi_tcl_NotificationData::operator=(const midw_fi_tcl_NotificationData& coRef)
{
   if (this == &coRef) return *this;
   u16NotificationID = coRef.u16NotificationID;
   szNotificationTitle = coRef.szNotificationTitle;
   szNotificationBody = coRef.szNotificationBody;
   u16NotificationIconCount = coRef.u16NotificationIconCount;
   NotificationIconList = coRef.NotificationIconList;
   u16NotificationAppID = coRef.u16NotificationAppID;
   NotificationActionList = coRef.NotificationActionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_NotificationData::vDestroy()
{
   szNotificationTitle.vDestroy();
   szNotificationBody.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationIconList.size(); ++u32Idx)
         NotificationIconList[u32Idx].vDestroy();
   NotificationIconList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationActionList.size(); ++u32Idx)
         NotificationActionList[u32Idx].vDestroy();
   NotificationActionList.clear();
   }
}

midw_fi_tcl_NotificationData::midw_fi_tcl_NotificationData()
:u16NotificationID(0)
,szNotificationTitle()
,szNotificationBody()
,u16NotificationIconCount(0)

,u16NotificationAppID(0)

 {}

tS32 midw_fi_tcl_NotificationData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_NOTIFICATIONDATA;
}


midw_fi_tcl_NotificationData::~midw_fi_tcl_NotificationData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_NotificationData::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NotificationIconList.size(); ++u32ListIdx)
      u32DynamicSize += NotificationIconList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < NotificationActionList.size(); ++u32ListIdx)
      u32DynamicSize += NotificationActionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14+szNotificationTitle.u32GetSize(u16MajorVersion)+szNotificationBody.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_NotificationData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NotificationID);
   (tVoid) (oIn >> szNotificationTitle);
   (tVoid) (oIn >> szNotificationBody);
   (tVoid) (oIn >> u16NotificationIconCount);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NotificationIconList.size(); ++u32Idx)
      {
         NotificationIconList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NotificationIconList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NotificationIconList[u32Idx]);
      }
   }
   (tVoid) (oIn >> u16NotificationAppID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NotificationActionList.size(); ++u32Idx)
      {
         NotificationActionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NotificationActionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NotificationActionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_NotificationData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NotificationID);
   (tVoid) (oOut << szNotificationTitle);
   (tVoid) (oOut << szNotificationBody);
   (tVoid) (oOut << u16NotificationIconCount);
   (tVoid) (oOut << (tU32)NotificationIconList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationIconList.size(); ++u32Idx)
         (tVoid) (oOut << NotificationIconList[u32Idx]);
   }
   (tVoid) (oOut << u16NotificationAppID);
   (tVoid) (oOut << (tU32)NotificationActionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationActionList.size(); ++u32Idx)
         (tVoid) (oOut << NotificationActionList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_NotificationData::operator==(const midw_fi_tcl_NotificationData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NotificationID == roRef.u16NotificationID);
   bResult = bResult && (szNotificationTitle == roRef.szNotificationTitle);
   bResult = bResult && (szNotificationBody == roRef.szNotificationBody);
   bResult = bResult && (u16NotificationIconCount == roRef.u16NotificationIconCount);
      bResult = bResult && (NotificationIconList.size() == roRef.NotificationIconList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NotificationIconList.size()); ++u32Idx)
            bResult = bResult && (NotificationIconList[u32Idx] == roRef.NotificationIconList[u32Idx]);
      }
   bResult = bResult && (u16NotificationAppID == roRef.u16NotificationAppID);
      bResult = bResult && (NotificationActionList.size() == roRef.NotificationActionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NotificationActionList.size()); ++u32Idx)
            bResult = bResult && (NotificationActionList[u32Idx] == roRef.NotificationActionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_VideoAttributes::midw_fi_tcl_VideoAttributes(const midw_fi_tcl_VideoAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enOrientationMode = coRef.enOrientationMode;
   rScreenAttributes = coRef.rScreenAttributes;
}
midw_fi_tcl_VideoAttributes& midw_fi_tcl_VideoAttributes::operator=(const midw_fi_tcl_VideoAttributes& coRef)
{
   if (this == &coRef) return *this;
   enOrientationMode = coRef.enOrientationMode;
   rScreenAttributes = coRef.rScreenAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_VideoAttributes::midw_fi_tcl_VideoAttributes()
:enOrientationMode()
,rScreenAttributes()
 {}

tS32 midw_fi_tcl_VideoAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_VIDEOATTRIBUTES;
}


midw_fi_tcl_VideoAttributes::~midw_fi_tcl_VideoAttributes()
{}

tU32 midw_fi_tcl_VideoAttributes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_VideoAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enOrientationMode);
   (tVoid) (oIn >> rScreenAttributes);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_VideoAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enOrientationMode);
   (tVoid) (oOut << rScreenAttributes);
   return oOut;
}

tBool midw_fi_tcl_VideoAttributes::operator==(const midw_fi_tcl_VideoAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enOrientationMode == roRef.enOrientationMode);
   bResult = bResult && (rScreenAttributes == roRef.rScreenAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_KeyCapabilities::midw_fi_tcl_KeyCapabilities(const midw_fi_tcl_KeyCapabilities& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32KnobKeySupport = coRef.u32KnobKeySupport;
   u32DeviceKeySupport = coRef.u32DeviceKeySupport;
   u32MultimediaKeySupport = coRef.u32MultimediaKeySupport;
   u32MiscKeySupport = coRef.u32MiscKeySupport;
   u32PointerTouchSupport = coRef.u32PointerTouchSupport;
}
midw_fi_tcl_KeyCapabilities& midw_fi_tcl_KeyCapabilities::operator=(const midw_fi_tcl_KeyCapabilities& coRef)
{
   if (this == &coRef) return *this;
   u32KnobKeySupport = coRef.u32KnobKeySupport;
   u32DeviceKeySupport = coRef.u32DeviceKeySupport;
   u32MultimediaKeySupport = coRef.u32MultimediaKeySupport;
   u32MiscKeySupport = coRef.u32MiscKeySupport;
   u32PointerTouchSupport = coRef.u32PointerTouchSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_KeyCapabilities::midw_fi_tcl_KeyCapabilities()
:u32KnobKeySupport(0)
,u32DeviceKeySupport(0)
,u32MultimediaKeySupport(0)
,u32MiscKeySupport(0)
,u32PointerTouchSupport(0)
 {}

tS32 midw_fi_tcl_KeyCapabilities::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_KEYCAPABILITIES;
}


midw_fi_tcl_KeyCapabilities::~midw_fi_tcl_KeyCapabilities()
{}

tU32 midw_fi_tcl_KeyCapabilities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& midw_fi_tcl_KeyCapabilities::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32KnobKeySupport);
   (tVoid) (oIn >> u32DeviceKeySupport);
   (tVoid) (oIn >> u32MultimediaKeySupport);
   (tVoid) (oIn >> u32MiscKeySupport);
   (tVoid) (oIn >> u32PointerTouchSupport);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_KeyCapabilities::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32KnobKeySupport);
   (tVoid) (oOut << u32DeviceKeySupport);
   (tVoid) (oOut << u32MultimediaKeySupport);
   (tVoid) (oOut << u32MiscKeySupport);
   (tVoid) (oOut << u32PointerTouchSupport);
   return oOut;
}

tBool midw_fi_tcl_KeyCapabilities::operator==(const midw_fi_tcl_KeyCapabilities& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32KnobKeySupport == roRef.u32KnobKeySupport);
   bResult = bResult && (u32DeviceKeySupport == roRef.u32DeviceKeySupport);
   bResult = bResult && (u32MultimediaKeySupport == roRef.u32MultimediaKeySupport);
   bResult = bResult && (u32MiscKeySupport == roRef.u32MiscKeySupport);
   bResult = bResult && (u32PointerTouchSupport == roRef.u32PointerTouchSupport);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_XDeviceKeys::midw_fi_tcl_XDeviceKeys(const midw_fi_tcl_XDeviceKeys& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   szName = coRef.szName;
   bMandatory = coRef.bMandatory;
   e32SymbolValue = coRef.e32SymbolValue;
   IconList = coRef.IconList;
}
midw_fi_tcl_XDeviceKeys& midw_fi_tcl_XDeviceKeys::operator=(const midw_fi_tcl_XDeviceKeys& coRef)
{
   if (this == &coRef) return *this;
   szName = coRef.szName;
   bMandatory = coRef.bMandatory;
   e32SymbolValue = coRef.e32SymbolValue;
   IconList = coRef.IconList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_XDeviceKeys::vDestroy()
{
   szName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < IconList.size(); ++u32Idx)
         IconList[u32Idx].vDestroy();
   IconList.clear();
   }
}

midw_fi_tcl_XDeviceKeys::midw_fi_tcl_XDeviceKeys()
:szName()
,bMandatory(0)
,e32SymbolValue()

 {}

tS32 midw_fi_tcl_XDeviceKeys::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_XDEVICEKEYS;
}


midw_fi_tcl_XDeviceKeys::~midw_fi_tcl_XDeviceKeys()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_XDeviceKeys::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IconList.size(); ++u32ListIdx)
      u32DynamicSize += IconList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+szName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_XDeviceKeys::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szName);
   (tVoid) (oIn >> bMandatory);
   (tVoid) (oIn >> e32SymbolValue);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IconList.size(); ++u32Idx)
      {
         IconList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IconList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IconList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_XDeviceKeys::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szName);
   (tVoid) (oOut << bMandatory);
   (tVoid) (oOut << e32SymbolValue);
   (tVoid) (oOut << (tU32)IconList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IconList.size(); ++u32Idx)
         (tVoid) (oOut << IconList[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_XDeviceKeys::operator==(const midw_fi_tcl_XDeviceKeys& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szName == roRef.szName);
   bResult = bResult && (bMandatory == roRef.bMandatory);
   bResult = bResult && (e32SymbolValue == roRef.e32SymbolValue);
      bResult = bResult && (IconList.size() == roRef.IconList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IconList.size()); ++u32Idx)
            bResult = bResult && (IconList[u32Idx] == roRef.IconList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ClientCapabilities::midw_fi_tcl_ClientCapabilities(const midw_fi_tcl_ClientCapabilities& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   rKeyCapabilities = coRef.rKeyCapabilities;
}
midw_fi_tcl_ClientCapabilities& midw_fi_tcl_ClientCapabilities::operator=(const midw_fi_tcl_ClientCapabilities& coRef)
{
   if (this == &coRef) return *this;
   rKeyCapabilities = coRef.rKeyCapabilities;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ClientCapabilities::midw_fi_tcl_ClientCapabilities()
:rKeyCapabilities()
 {}

tS32 midw_fi_tcl_ClientCapabilities::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CLIENTCAPABILITIES;
}


midw_fi_tcl_ClientCapabilities::~midw_fi_tcl_ClientCapabilities()
{}

tU32 midw_fi_tcl_ClientCapabilities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& midw_fi_tcl_ClientCapabilities::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rKeyCapabilities);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ClientCapabilities::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rKeyCapabilities);
   return oOut;
}

tBool midw_fi_tcl_ClientCapabilities::operator==(const midw_fi_tcl_ClientCapabilities& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rKeyCapabilities == roRef.rKeyCapabilities);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AudioCapabilities::midw_fi_tcl_AudioCapabilities(const midw_fi_tcl_AudioCapabilities& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16BTHFPSupport = coRef.u16BTHFPSupport;
   u16BTA2DPSupport = coRef.u16BTA2DPSupport;
   u16RTPInSupport = coRef.u16RTPInSupport;
   u16RTPOutSupport = coRef.u16RTPOutSupport;
}
midw_fi_tcl_AudioCapabilities& midw_fi_tcl_AudioCapabilities::operator=(const midw_fi_tcl_AudioCapabilities& coRef)
{
   if (this == &coRef) return *this;
   u16BTHFPSupport = coRef.u16BTHFPSupport;
   u16BTA2DPSupport = coRef.u16BTA2DPSupport;
   u16RTPInSupport = coRef.u16RTPInSupport;
   u16RTPOutSupport = coRef.u16RTPOutSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AudioCapabilities::midw_fi_tcl_AudioCapabilities()
:u16BTHFPSupport(0)
,u16BTA2DPSupport(0)
,u16RTPInSupport(0)
,u16RTPOutSupport(0)
 {}

tS32 midw_fi_tcl_AudioCapabilities::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AUDIOCAPABILITIES;
}


midw_fi_tcl_AudioCapabilities::~midw_fi_tcl_AudioCapabilities()
{}

tU32 midw_fi_tcl_AudioCapabilities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_fi_tcl_AudioCapabilities::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16BTHFPSupport);
   (tVoid) (oIn >> u16BTA2DPSupport);
   (tVoid) (oIn >> u16RTPInSupport);
   (tVoid) (oIn >> u16RTPOutSupport);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AudioCapabilities::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16BTHFPSupport);
   (tVoid) (oOut << u16BTA2DPSupport);
   (tVoid) (oOut << u16RTPInSupport);
   (tVoid) (oOut << u16RTPOutSupport);
   return oOut;
}

tBool midw_fi_tcl_AudioCapabilities::operator==(const midw_fi_tcl_AudioCapabilities& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16BTHFPSupport == roRef.u16BTHFPSupport);
   bResult = bResult && (u16BTA2DPSupport == roRef.u16BTA2DPSupport);
   bResult = bResult && (u16RTPInSupport == roRef.u16RTPInSupport);
   bResult = bResult && (u16RTPOutSupport == roRef.u16RTPOutSupport);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayCapabilities::midw_fi_tcl_DisplayCapabilities(const midw_fi_tcl_DisplayCapabilities& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16FrameBufferConfiguration = coRef.u16FrameBufferConfiguration;
   u16PixelFormat = coRef.u16PixelFormat;
}
midw_fi_tcl_DisplayCapabilities& midw_fi_tcl_DisplayCapabilities::operator=(const midw_fi_tcl_DisplayCapabilities& coRef)
{
   if (this == &coRef) return *this;
   u16FrameBufferConfiguration = coRef.u16FrameBufferConfiguration;
   u16PixelFormat = coRef.u16PixelFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_DisplayCapabilities::midw_fi_tcl_DisplayCapabilities()
:u16FrameBufferConfiguration(0)
,u16PixelFormat(0)
 {}

tS32 midw_fi_tcl_DisplayCapabilities::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYCAPABILITIES;
}


midw_fi_tcl_DisplayCapabilities::~midw_fi_tcl_DisplayCapabilities()
{}

tU32 midw_fi_tcl_DisplayCapabilities::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_DisplayCapabilities::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FrameBufferConfiguration);
   (tVoid) (oIn >> u16PixelFormat);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayCapabilities::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FrameBufferConfiguration);
   (tVoid) (oOut << u16PixelFormat);
   return oOut;
}

tBool midw_fi_tcl_DisplayCapabilities::operator==(const midw_fi_tcl_DisplayCapabilities& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FrameBufferConfiguration == roRef.u16FrameBufferConfiguration);
   bResult = bResult && (u16PixelFormat == roRef.u16PixelFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PlayBackState::midw_fi_tcl_e8_PlayBackState():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PlayBackState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PLAYBACKSTATE;
}


midw_fi_tcl_e8_PlayBackState::~midw_fi_tcl_e8_PlayBackState()
{}

tU32 midw_fi_tcl_e8_PlayBackState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PlayBackState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PlayBackState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PlayBackShuffleState::midw_fi_tcl_e8_PlayBackShuffleState():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PlayBackShuffleState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PLAYBACKSHUFFLESTATE;
}


midw_fi_tcl_e8_PlayBackShuffleState::~midw_fi_tcl_e8_PlayBackShuffleState()
{}

tU32 midw_fi_tcl_e8_PlayBackShuffleState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PlayBackShuffleState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PlayBackShuffleState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PlayBackRepeatState::midw_fi_tcl_e8_PlayBackRepeatState():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PlayBackRepeatState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PLAYBACKREPEATSTATE;
}


midw_fi_tcl_e8_PlayBackRepeatState::~midw_fi_tcl_e8_PlayBackRepeatState()
{}

tU32 midw_fi_tcl_e8_PlayBackRepeatState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PlayBackRepeatState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PlayBackRepeatState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PlayBackMediaType::midw_fi_tcl_e8_PlayBackMediaType():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PlayBackMediaType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PLAYBACKMEDIATYPE;
}


midw_fi_tcl_e8_PlayBackMediaType::~midw_fi_tcl_e8_PlayBackMediaType()
{}

tU32 midw_fi_tcl_e8_PlayBackMediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PlayBackMediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PlayBackMediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ApplicationMediaMetaData::midw_fi_tcl_ApplicationMediaMetaData(const midw_fi_tcl_ApplicationMediaMetaData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AppName = coRef.AppName;
   Title = coRef.Title;
   Artist = coRef.Artist;
   Album = coRef.Album;
   AlbumArtist = coRef.AlbumArtist;
   Genre = coRef.Genre;
   Composer = coRef.Composer;
   TrackNumber = coRef.TrackNumber;
   AlbumTrackCount = coRef.AlbumTrackCount;
   AlbumDiscNumber = coRef.AlbumDiscNumber;
   AlbumDiscCount = coRef.AlbumDiscCount;
   ChapterCount = coRef.ChapterCount;
   u32QueueIndex = coRef.u32QueueIndex;
   u32QueueCount = coRef.u32QueueCount;
   ImageMIMEType = coRef.ImageMIMEType;
   ImageSize = coRef.ImageSize;
   ImageUrl = coRef.ImageUrl;
   oImageData = coRef.oImageData;
   PlayBackState = coRef.PlayBackState;
   ShuffleState = coRef.ShuffleState;
   RepeatState = coRef.RepeatState;
   MediaType = coRef.MediaType;
   iTunesRadioAd = coRef.iTunesRadioAd;
   iTunesRadioStationName = coRef.iTunesRadioStationName;
   MediaRating = coRef.MediaRating;
}
midw_fi_tcl_ApplicationMediaMetaData& midw_fi_tcl_ApplicationMediaMetaData::operator=(const midw_fi_tcl_ApplicationMediaMetaData& coRef)
{
   if (this == &coRef) return *this;
   AppName = coRef.AppName;
   Title = coRef.Title;
   Artist = coRef.Artist;
   Album = coRef.Album;
   AlbumArtist = coRef.AlbumArtist;
   Genre = coRef.Genre;
   Composer = coRef.Composer;
   TrackNumber = coRef.TrackNumber;
   AlbumTrackCount = coRef.AlbumTrackCount;
   AlbumDiscNumber = coRef.AlbumDiscNumber;
   AlbumDiscCount = coRef.AlbumDiscCount;
   ChapterCount = coRef.ChapterCount;
   u32QueueIndex = coRef.u32QueueIndex;
   u32QueueCount = coRef.u32QueueCount;
   ImageMIMEType = coRef.ImageMIMEType;
   ImageSize = coRef.ImageSize;
   ImageUrl = coRef.ImageUrl;
   oImageData = coRef.oImageData;
   PlayBackState = coRef.PlayBackState;
   ShuffleState = coRef.ShuffleState;
   RepeatState = coRef.RepeatState;
   MediaType = coRef.MediaType;
   iTunesRadioAd = coRef.iTunesRadioAd;
   iTunesRadioStationName = coRef.iTunesRadioStationName;
   MediaRating = coRef.MediaRating;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ApplicationMediaMetaData::vDestroy()
{
   AppName.vDestroy();
   Title.vDestroy();
   Artist.vDestroy();
   Album.vDestroy();
   AlbumArtist.vDestroy();
   Genre.vDestroy();
   Composer.vDestroy();
   ImageMIMEType.vDestroy();
   ImageUrl.vDestroy();
   {
   oImageData.clear();
   }
   iTunesRadioStationName.vDestroy();
}

midw_fi_tcl_ApplicationMediaMetaData::midw_fi_tcl_ApplicationMediaMetaData()
:AppName()
,Title()
,Artist()
,Album()
,AlbumArtist()
,Genre()
,Composer()
,TrackNumber(0)
,AlbumTrackCount(0)
,AlbumDiscNumber(0)
,AlbumDiscCount(0)
,ChapterCount(0)
,u32QueueIndex(0)
,u32QueueCount(0)
,ImageMIMEType()
,ImageSize(0)
,ImageUrl()

,PlayBackState()
,ShuffleState()
,RepeatState()
,MediaType()
,iTunesRadioAd(0)
,iTunesRadioStationName()
,MediaRating(0)
 {}

tS32 midw_fi_tcl_ApplicationMediaMetaData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPLICATIONMEDIAMETADATA;
}


midw_fi_tcl_ApplicationMediaMetaData::~midw_fi_tcl_ApplicationMediaMetaData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ApplicationMediaMetaData::u32GetSize(tU16 u16MajorVersion) const
{
   return 42+AppName.u32GetSize(u16MajorVersion)+Title.u32GetSize(u16MajorVersion)+Artist.u32GetSize(u16MajorVersion)+Album.u32GetSize(u16MajorVersion)+AlbumArtist.u32GetSize(u16MajorVersion)+Genre.u32GetSize(u16MajorVersion)+Composer.u32GetSize(u16MajorVersion)+ImageMIMEType.u32GetSize(u16MajorVersion)+ImageUrl.u32GetSize(u16MajorVersion)+ static_cast<tU32>(oImageData.size()*1)+iTunesRadioStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_ApplicationMediaMetaData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AppName);
   (tVoid) (oIn >> Title);
   (tVoid) (oIn >> Artist);
   (tVoid) (oIn >> Album);
   (tVoid) (oIn >> AlbumArtist);
   (tVoid) (oIn >> Genre);
   (tVoid) (oIn >> Composer);
   (tVoid) (oIn >> TrackNumber);
   (tVoid) (oIn >> AlbumTrackCount);
   (tVoid) (oIn >> AlbumDiscNumber);
   (tVoid) (oIn >> AlbumDiscCount);
   (tVoid) (oIn >> ChapterCount);
   (tVoid) (oIn >> u32QueueIndex);
   (tVoid) (oIn >> u32QueueCount);
   (tVoid) (oIn >> ImageMIMEType);
   (tVoid) (oIn >> ImageSize);
   (tVoid) (oIn >> ImageUrl);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      oImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oImageData[u32Idx]);
      }
   }
   (tVoid) (oIn >> PlayBackState);
   (tVoid) (oIn >> ShuffleState);
   (tVoid) (oIn >> RepeatState);
   (tVoid) (oIn >> MediaType);
   (tVoid) (oIn >> iTunesRadioAd);
   (tVoid) (oIn >> iTunesRadioStationName);
   (tVoid) (oIn >> MediaRating);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ApplicationMediaMetaData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AppName);
   (tVoid) (oOut << Title);
   (tVoid) (oOut << Artist);
   (tVoid) (oOut << Album);
   (tVoid) (oOut << AlbumArtist);
   (tVoid) (oOut << Genre);
   (tVoid) (oOut << Composer);
   (tVoid) (oOut << TrackNumber);
   (tVoid) (oOut << AlbumTrackCount);
   (tVoid) (oOut << AlbumDiscNumber);
   (tVoid) (oOut << AlbumDiscCount);
   (tVoid) (oOut << ChapterCount);
   (tVoid) (oOut << u32QueueIndex);
   (tVoid) (oOut << u32QueueCount);
   (tVoid) (oOut << ImageMIMEType);
   (tVoid) (oOut << ImageSize);
   (tVoid) (oOut << ImageUrl);
   (tVoid) (oOut << (tU32)oImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oImageData.size(); ++u32Idx)
         (tVoid) (oOut << oImageData[u32Idx]);
   }
   (tVoid) (oOut << PlayBackState);
   (tVoid) (oOut << ShuffleState);
   (tVoid) (oOut << RepeatState);
   (tVoid) (oOut << MediaType);
   (tVoid) (oOut << iTunesRadioAd);
   (tVoid) (oOut << iTunesRadioStationName);
   (tVoid) (oOut << MediaRating);
   return oOut;
}

tBool midw_fi_tcl_ApplicationMediaMetaData::operator==(const midw_fi_tcl_ApplicationMediaMetaData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AppName == roRef.AppName);
   bResult = bResult && (Title == roRef.Title);
   bResult = bResult && (Artist == roRef.Artist);
   bResult = bResult && (Album == roRef.Album);
   bResult = bResult && (AlbumArtist == roRef.AlbumArtist);
   bResult = bResult && (Genre == roRef.Genre);
   bResult = bResult && (Composer == roRef.Composer);
   bResult = bResult && (TrackNumber == roRef.TrackNumber);
   bResult = bResult && (AlbumTrackCount == roRef.AlbumTrackCount);
   bResult = bResult && (AlbumDiscNumber == roRef.AlbumDiscNumber);
   bResult = bResult && (AlbumDiscCount == roRef.AlbumDiscCount);
   bResult = bResult && (ChapterCount == roRef.ChapterCount);
   bResult = bResult && (u32QueueIndex == roRef.u32QueueIndex);
   bResult = bResult && (u32QueueCount == roRef.u32QueueCount);
   bResult = bResult && (ImageMIMEType == roRef.ImageMIMEType);
   bResult = bResult && (ImageSize == roRef.ImageSize);
   bResult = bResult && (ImageUrl == roRef.ImageUrl);
      bResult = bResult && (oImageData.size() == roRef.oImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oImageData.size()); ++u32Idx)
            bResult = bResult && (oImageData[u32Idx] == roRef.oImageData[u32Idx]);
      }
   bResult = bResult && (PlayBackState == roRef.PlayBackState);
   bResult = bResult && (ShuffleState == roRef.ShuffleState);
   bResult = bResult && (RepeatState == roRef.RepeatState);
   bResult = bResult && (MediaType == roRef.MediaType);
   bResult = bResult && (iTunesRadioAd == roRef.iTunesRadioAd);
   bResult = bResult && (iTunesRadioStationName == roRef.iTunesRadioStationName);
   bResult = bResult && (MediaRating == roRef.MediaRating);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneSignalStrength::midw_fi_tcl_e8_PhoneSignalStrength():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PhoneSignalStrength::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONESIGNALSTRENGTH;
}


midw_fi_tcl_e8_PhoneSignalStrength::~midw_fi_tcl_e8_PhoneSignalStrength()
{}

tU32 midw_fi_tcl_e8_PhoneSignalStrength::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneSignalStrength::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneSignalStrength::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneRegistrationStatus::midw_fi_tcl_e8_PhoneRegistrationStatus():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PhoneRegistrationStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONEREGISTRATIONSTATUS;
}


midw_fi_tcl_e8_PhoneRegistrationStatus::~midw_fi_tcl_e8_PhoneRegistrationStatus()
{}

tU32 midw_fi_tcl_e8_PhoneRegistrationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneRegistrationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneRegistrationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneAirPlaneModeStatus::midw_fi_tcl_e8_PhoneAirPlaneModeStatus():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PhoneAirPlaneModeStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONEAIRPLANEMODESTATUS;
}


midw_fi_tcl_e8_PhoneAirPlaneModeStatus::~midw_fi_tcl_e8_PhoneAirPlaneModeStatus()
{}

tU32 midw_fi_tcl_e8_PhoneAirPlaneModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneAirPlaneModeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneAirPlaneModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneCallState::midw_fi_tcl_e8_PhoneCallState():enType(FI_EN_DISCONNECTED) {}

tS32 midw_fi_tcl_e8_PhoneCallState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONECALLSTATE;
}


midw_fi_tcl_e8_PhoneCallState::~midw_fi_tcl_e8_PhoneCallState()
{}

tU32 midw_fi_tcl_e8_PhoneCallState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneCallState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneCallState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneCallDirection::midw_fi_tcl_e8_PhoneCallDirection():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_PhoneCallDirection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONECALLDIRECTION;
}


midw_fi_tcl_e8_PhoneCallDirection::~midw_fi_tcl_e8_PhoneCallDirection()
{}

tU32 midw_fi_tcl_e8_PhoneCallDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneCallDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneCallDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_Mute::midw_fi_tcl_e8_Mute():enType(FI_EN_NOT_KNOWN) {}

tS32 midw_fi_tcl_e8_Mute::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MUTE;
}


midw_fi_tcl_e8_Mute::~midw_fi_tcl_e8_Mute()
{}

tU32 midw_fi_tcl_e8_Mute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_Mute::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_Mute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ApplicationPhoneCallMetadata::midw_fi_tcl_ApplicationPhoneCallMetadata(const midw_fi_tcl_ApplicationPhoneCallMetadata& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   PhoneNumber = coRef.PhoneNumber;
   DisplayName = coRef.DisplayName;
   CallState = coRef.CallState;
   CallDirection = coRef.CallDirection;
   CallDuration = coRef.CallDuration;
   CallerLabel = coRef.CallerLabel;
   ConferencedCall = coRef.ConferencedCall;
}
midw_fi_tcl_ApplicationPhoneCallMetadata& midw_fi_tcl_ApplicationPhoneCallMetadata::operator=(const midw_fi_tcl_ApplicationPhoneCallMetadata& coRef)
{
   if (this == &coRef) return *this;
   PhoneNumber = coRef.PhoneNumber;
   DisplayName = coRef.DisplayName;
   CallState = coRef.CallState;
   CallDirection = coRef.CallDirection;
   CallDuration = coRef.CallDuration;
   CallerLabel = coRef.CallerLabel;
   ConferencedCall = coRef.ConferencedCall;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ApplicationPhoneCallMetadata::vDestroy()
{
   PhoneNumber.vDestroy();
   DisplayName.vDestroy();
   CallerLabel.vDestroy();
}

midw_fi_tcl_ApplicationPhoneCallMetadata::midw_fi_tcl_ApplicationPhoneCallMetadata()
:PhoneNumber()
,DisplayName()
,CallState()
,CallDirection()
,CallDuration(0)
,CallerLabel()
,ConferencedCall(0)
 {}

tS32 midw_fi_tcl_ApplicationPhoneCallMetadata::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPLICATIONPHONECALLMETADATA;
}


midw_fi_tcl_ApplicationPhoneCallMetadata::~midw_fi_tcl_ApplicationPhoneCallMetadata()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ApplicationPhoneCallMetadata::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+PhoneNumber.u32GetSize(u16MajorVersion)+DisplayName.u32GetSize(u16MajorVersion)+CallerLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_ApplicationPhoneCallMetadata::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneNumber);
   (tVoid) (oIn >> DisplayName);
   (tVoid) (oIn >> CallState);
   (tVoid) (oIn >> CallDirection);
   (tVoid) (oIn >> CallDuration);
   (tVoid) (oIn >> CallerLabel);
   (tVoid) (oIn >> ConferencedCall);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ApplicationPhoneCallMetadata::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneNumber);
   (tVoid) (oOut << DisplayName);
   (tVoid) (oOut << CallState);
   (tVoid) (oOut << CallDirection);
   (tVoid) (oOut << CallDuration);
   (tVoid) (oOut << CallerLabel);
   (tVoid) (oOut << ConferencedCall);
   return oOut;
}

tBool midw_fi_tcl_ApplicationPhoneCallMetadata::operator==(const midw_fi_tcl_ApplicationPhoneCallMetadata& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneNumber == roRef.PhoneNumber);
   bResult = bResult && (DisplayName == roRef.DisplayName);
   bResult = bResult && (CallState == roRef.CallState);
   bResult = bResult && (CallDirection == roRef.CallDirection);
   bResult = bResult && (CallDuration == roRef.CallDuration);
   bResult = bResult && (CallerLabel == roRef.CallerLabel);
   bResult = bResult && (ConferencedCall == roRef.ConferencedCall);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_Time::midw_fi_tcl_Time(const midw_fi_tcl_Time& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
}
midw_fi_tcl_Time& midw_fi_tcl_Time::operator=(const midw_fi_tcl_Time& coRef)
{
   if (this == &coRef) return *this;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_Time::midw_fi_tcl_Time()
:u8Hour(0)
,u8Minute(0)
,u8Second(0)
 {}

tS32 midw_fi_tcl_Time::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_TIME;
}


midw_fi_tcl_Time::~midw_fi_tcl_Time()
{}

tU32 midw_fi_tcl_Time::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_fi_tcl_Time::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_Time::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   return oOut;
}

tBool midw_fi_tcl_Time::operator==(const midw_fi_tcl_Time& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_CallStateUpdateDisconnectReason::midw_fi_tcl_e8_CallStateUpdateDisconnectReason():enType(FI_EN_CALLSTATE_DISCONNECT_REASON_ENDED) {}

tS32 midw_fi_tcl_e8_CallStateUpdateDisconnectReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_CALLSTATEUPDATEDISCONNECTREASON;
}


midw_fi_tcl_e8_CallStateUpdateDisconnectReason::~midw_fi_tcl_e8_CallStateUpdateDisconnectReason()
{}

tU32 midw_fi_tcl_e8_CallStateUpdateDisconnectReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_CallStateUpdateDisconnectReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_CallStateUpdateDisconnectReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::midw_fi_tcl_ApplicationPhoneCallExtendedMetadata(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   PhoneNumber = coRef.PhoneNumber;
   DisplayName = coRef.DisplayName;
   sCallUUID = coRef.sCallUUID;
   CallStateDisconnectReason = coRef.CallStateDisconnectReason;
   CallState = coRef.CallState;
   CallDirection = coRef.CallDirection;
   CallerLabel = coRef.CallerLabel;
   ConferencedCall = coRef.ConferencedCall;
   u64StartTimeStamp = coRef.u64StartTimeStamp;
   CallProgress = coRef.CallProgress;
   CallProgressRefFromDevice = coRef.CallProgressRefFromDevice;
}
midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::operator=(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& coRef)
{
   if (this == &coRef) return *this;
   PhoneNumber = coRef.PhoneNumber;
   DisplayName = coRef.DisplayName;
   sCallUUID = coRef.sCallUUID;
   CallStateDisconnectReason = coRef.CallStateDisconnectReason;
   CallState = coRef.CallState;
   CallDirection = coRef.CallDirection;
   CallerLabel = coRef.CallerLabel;
   ConferencedCall = coRef.ConferencedCall;
   u64StartTimeStamp = coRef.u64StartTimeStamp;
   CallProgress = coRef.CallProgress;
   CallProgressRefFromDevice = coRef.CallProgressRefFromDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::vDestroy()
{
   PhoneNumber.vDestroy();
   DisplayName.vDestroy();
   sCallUUID.vDestroy();
   CallerLabel.vDestroy();
   CallProgress.vDestroy(); 
   CallProgressRefFromDevice.vDestroy(); 
}

midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::midw_fi_tcl_ApplicationPhoneCallExtendedMetadata()
:PhoneNumber()
,DisplayName()
,sCallUUID()
,CallStateDisconnectReason()
,CallState()
,CallDirection()
,CallerLabel()
,ConferencedCall(0)
,u64StartTimeStamp(0)
,CallProgress()
,CallProgressRefFromDevice()
 {}

tS32 midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_APPLICATIONPHONECALLEXTENDEDMETADATA;
}


midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::~midw_fi_tcl_ApplicationPhoneCallExtendedMetadata()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+PhoneNumber.u32GetSize(u16MajorVersion)+DisplayName.u32GetSize(u16MajorVersion)+sCallUUID.u32GetSize(u16MajorVersion)+CallerLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneNumber);
   (tVoid) (oIn >> DisplayName);
   (tVoid) (oIn >> sCallUUID);
   (tVoid) (oIn >> CallStateDisconnectReason);
   (tVoid) (oIn >> CallState);
   (tVoid) (oIn >> CallDirection);
   (tVoid) (oIn >> CallerLabel);
   (tVoid) (oIn >> ConferencedCall);
   (tVoid) (oIn >> u64StartTimeStamp);
   (tVoid) (oIn >> CallProgress);
   (tVoid) (oIn >> CallProgressRefFromDevice);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneNumber);
   (tVoid) (oOut << DisplayName);
   (tVoid) (oOut << sCallUUID);
   (tVoid) (oOut << CallStateDisconnectReason);
   (tVoid) (oOut << CallState);
   (tVoid) (oOut << CallDirection);
   (tVoid) (oOut << CallerLabel);
   (tVoid) (oOut << ConferencedCall);
   (tVoid) (oOut << u64StartTimeStamp);
   (tVoid) (oOut << CallProgress);
   (tVoid) (oOut << CallProgressRefFromDevice);
   return oOut;
}

tBool midw_fi_tcl_ApplicationPhoneCallExtendedMetadata::operator==(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneNumber == roRef.PhoneNumber);
   bResult = bResult && (DisplayName == roRef.DisplayName);
   bResult = bResult && (sCallUUID == roRef.sCallUUID);
   bResult = bResult && (CallStateDisconnectReason == roRef.CallStateDisconnectReason);
   bResult = bResult && (CallState == roRef.CallState);
   bResult = bResult && (CallDirection == roRef.CallDirection);
   bResult = bResult && (CallerLabel == roRef.CallerLabel);
   bResult = bResult && (ConferencedCall == roRef.ConferencedCall);
   bResult = bResult && (u64StartTimeStamp == roRef.u64StartTimeStamp);
   bResult = bResult && (CallProgress == roRef.CallProgress);
   bResult = bResult && (CallProgressRefFromDevice == roRef.CallProgressRefFromDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AudioContext::midw_fi_tcl_e8_AudioContext():enType(FI_EN_SPI_AUDIO_MAIN) {}

tS32 midw_fi_tcl_e8_AudioContext::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AUDIOCONTEXT;
}


midw_fi_tcl_e8_AudioContext::~midw_fi_tcl_e8_AudioContext()
{}

tU32 midw_fi_tcl_e8_AudioContext::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AudioContext::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AudioContext::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_SpeechAppState::midw_fi_tcl_e8_SpeechAppState():enType(FI_EN_SPI_APP_STATE_SPEECH_UNKNOWN) {}

tS32 midw_fi_tcl_e8_SpeechAppState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_SPEECHAPPSTATE;
}


midw_fi_tcl_e8_SpeechAppState::~midw_fi_tcl_e8_SpeechAppState()
{}

tU32 midw_fi_tcl_e8_SpeechAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_SpeechAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_SpeechAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_PhoneAppState::midw_fi_tcl_e8_PhoneAppState():enType(FI_EN_SPI_APP_STATE_PHONE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_PhoneAppState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PHONEAPPSTATE;
}


midw_fi_tcl_e8_PhoneAppState::~midw_fi_tcl_e8_PhoneAppState()
{}

tU32 midw_fi_tcl_e8_PhoneAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_PhoneAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_PhoneAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_NavigationAppState::midw_fi_tcl_e8_NavigationAppState():enType(FI_EN_SPI_APP_STATE_NAV_UNKNOWN) {}

tS32 midw_fi_tcl_e8_NavigationAppState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_NAVIGATIONAPPSTATE;
}


midw_fi_tcl_e8_NavigationAppState::~midw_fi_tcl_e8_NavigationAppState()
{}

tU32 midw_fi_tcl_e8_NavigationAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_NavigationAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_NavigationAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPOSwitchReqResponse::midw_fi_tcl_e8_DiPOSwitchReqResponse():enType(FI_EN_E8DIPO_ROLE_SWITCH_NOT_REQUIRED) {}

tS32 midw_fi_tcl_e8_DiPOSwitchReqResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOSWITCHREQRESPONSE;
}


midw_fi_tcl_e8_DiPOSwitchReqResponse::~midw_fi_tcl_e8_DiPOSwitchReqResponse()
{}

tU32 midw_fi_tcl_e8_DiPOSwitchReqResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPOSwitchReqResponse::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPOSwitchReqResponse::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DisplayInfo::midw_fi_tcl_e8_DisplayInfo():enType(FI_EN_DISPLAY_CONTEXT) {}

tS32 midw_fi_tcl_e8_DisplayInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISPLAYINFO;
}


midw_fi_tcl_e8_DisplayInfo::~midw_fi_tcl_e8_DisplayInfo()
{}

tU32 midw_fi_tcl_e8_DisplayInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DisplayInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DisplayInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AccessoryDisplayContext::midw_fi_tcl_AccessoryDisplayContext(const midw_fi_tcl_AccessoryDisplayContext& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DisplayContext = coRef.DisplayContext;
   DisplayFlag = coRef.DisplayFlag;
}
midw_fi_tcl_AccessoryDisplayContext& midw_fi_tcl_AccessoryDisplayContext::operator=(const midw_fi_tcl_AccessoryDisplayContext& coRef)
{
   if (this == &coRef) return *this;
   DisplayContext = coRef.DisplayContext;
   DisplayFlag = coRef.DisplayFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AccessoryDisplayContext::midw_fi_tcl_AccessoryDisplayContext()
:DisplayContext()
,DisplayFlag(0)
 {}

tS32 midw_fi_tcl_AccessoryDisplayContext::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ACCESSORYDISPLAYCONTEXT;
}


midw_fi_tcl_AccessoryDisplayContext::~midw_fi_tcl_AccessoryDisplayContext()
{}

tU32 midw_fi_tcl_AccessoryDisplayContext::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_AccessoryDisplayContext::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayContext);
   (tVoid) (oIn >> DisplayFlag);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AccessoryDisplayContext::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayContext);
   (tVoid) (oOut << DisplayFlag);
   return oOut;
}

tBool midw_fi_tcl_AccessoryDisplayContext::operator==(const midw_fi_tcl_AccessoryDisplayContext& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayContext == roRef.DisplayContext);
   bResult = bResult && (DisplayFlag == roRef.DisplayFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ResourceTransferType::midw_fi_tcl_e8_ResourceTransferType():enType(FI_EN_TRANSFER_TYPE_NA) {}

tS32 midw_fi_tcl_e8_ResourceTransferType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RESOURCETRANSFERTYPE;
}


midw_fi_tcl_e8_ResourceTransferType::~midw_fi_tcl_e8_ResourceTransferType()
{}

tU32 midw_fi_tcl_e8_ResourceTransferType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ResourceTransferType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ResourceTransferType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ResourceTransferPriority::midw_fi_tcl_e8_ResourceTransferPriority():enType(FI_EN_TRANSFER_PRIORITY_NA) {}

tS32 midw_fi_tcl_e8_ResourceTransferPriority::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RESOURCETRANSFERPRIORITY;
}


midw_fi_tcl_e8_ResourceTransferPriority::~midw_fi_tcl_e8_ResourceTransferPriority()
{}

tU32 midw_fi_tcl_e8_ResourceTransferPriority::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ResourceTransferPriority::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ResourceTransferPriority::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ResourceTransferConstraint::midw_fi_tcl_e8_ResourceTransferConstraint():enType(FI_EN_TRANSFER_CONSTRAINT_NA) {}

tS32 midw_fi_tcl_e8_ResourceTransferConstraint::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_RESOURCETRANSFERCONSTRAINT;
}


midw_fi_tcl_e8_ResourceTransferConstraint::~midw_fi_tcl_e8_ResourceTransferConstraint()
{}

tU32 midw_fi_tcl_e8_ResourceTransferConstraint::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ResourceTransferConstraint::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ResourceTransferConstraint::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayConstraint::midw_fi_tcl_DisplayConstraint(const midw_fi_tcl_DisplayConstraint& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   TransferType = coRef.TransferType;
   TransferPriority = coRef.TransferPriority;
   TakeConstraint = coRef.TakeConstraint;
   BorrowConstraint = coRef.BorrowConstraint;
   BorrowId = coRef.BorrowId;
}
midw_fi_tcl_DisplayConstraint& midw_fi_tcl_DisplayConstraint::operator=(const midw_fi_tcl_DisplayConstraint& coRef)
{
   if (this == &coRef) return *this;
   TransferType = coRef.TransferType;
   TransferPriority = coRef.TransferPriority;
   TakeConstraint = coRef.TakeConstraint;
   BorrowConstraint = coRef.BorrowConstraint;
   BorrowId = coRef.BorrowId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DisplayConstraint::vDestroy()
{
   BorrowId.vDestroy();
}

midw_fi_tcl_DisplayConstraint::midw_fi_tcl_DisplayConstraint()
:TransferType()
,TransferPriority()
,TakeConstraint()
,BorrowConstraint()
,BorrowId()
 {}

tS32 midw_fi_tcl_DisplayConstraint::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYCONSTRAINT;
}


midw_fi_tcl_DisplayConstraint::~midw_fi_tcl_DisplayConstraint()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DisplayConstraint::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+BorrowId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DisplayConstraint::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TransferType);
   (tVoid) (oIn >> TransferPriority);
   (tVoid) (oIn >> TakeConstraint);
   (tVoid) (oIn >> BorrowConstraint);
   (tVoid) (oIn >> BorrowId);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayConstraint::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TransferType);
   (tVoid) (oOut << TransferPriority);
   (tVoid) (oOut << TakeConstraint);
   (tVoid) (oOut << BorrowConstraint);
   (tVoid) (oOut << BorrowId);
   return oOut;
}

tBool midw_fi_tcl_DisplayConstraint::operator==(const midw_fi_tcl_DisplayConstraint& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TransferType == roRef.TransferType);
   bResult = bResult && (TransferPriority == roRef.TransferPriority);
   bResult = bResult && (TakeConstraint == roRef.TakeConstraint);
   bResult = bResult && (BorrowConstraint == roRef.BorrowConstraint);
   bResult = bResult && (BorrowId == roRef.BorrowId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DisplayType::midw_fi_tcl_e8_DisplayType():enType(FI_EN_E8RESISTIVE) {}

tS32 midw_fi_tcl_e8_DisplayType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISPLAYTYPE;
}


midw_fi_tcl_e8_DisplayType::~midw_fi_tcl_e8_DisplayType()
{}

tU32 midw_fi_tcl_e8_DisplayType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DisplayType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DisplayType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DisplayTouchType::midw_fi_tcl_e8_DisplayTouchType():enType(FI_EN_E8SINGLE_TOUCH) {}

tS32 midw_fi_tcl_e8_DisplayTouchType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISPLAYTOUCHTYPE;
}


midw_fi_tcl_e8_DisplayTouchType::~midw_fi_tcl_e8_DisplayTouchType()
{}

tU32 midw_fi_tcl_e8_DisplayTouchType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DisplayTouchType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DisplayTouchType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayLayerAttributes::midw_fi_tcl_DisplayLayerAttributes(const midw_fi_tcl_DisplayLayerAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   enDeviceCategory = coRef.enDeviceCategory;
   u16TouchLayerID = coRef.u16TouchLayerID;
   u16TouchSurfaceID = coRef.u16TouchSurfaceID;
   u16VideoLayerID = coRef.u16VideoLayerID;
   u16VideoSurfaceID = coRef.u16VideoSurfaceID;
   u16LayerWidth = coRef.u16LayerWidth;
   u16LayerHeight = coRef.u16LayerHeight;
   u16LayerWidthInMM = coRef.u16LayerWidthInMM;
   u16LayerHeightInMM = coRef.u16LayerHeightInMM;
   szPixelAspectRatio = coRef.szPixelAspectRatio;
   u16DPI = coRef.u16DPI;
   enDisplayTouchType = coRef.enDisplayTouchType;
   u16PriorityIndex = coRef.u16PriorityIndex;
}
midw_fi_tcl_DisplayLayerAttributes& midw_fi_tcl_DisplayLayerAttributes::operator=(const midw_fi_tcl_DisplayLayerAttributes& coRef)
{
   if (this == &coRef) return *this;
   enDeviceCategory = coRef.enDeviceCategory;
   u16TouchLayerID = coRef.u16TouchLayerID;
   u16TouchSurfaceID = coRef.u16TouchSurfaceID;
   u16VideoLayerID = coRef.u16VideoLayerID;
   u16VideoSurfaceID = coRef.u16VideoSurfaceID;
   u16LayerWidth = coRef.u16LayerWidth;
   u16LayerHeight = coRef.u16LayerHeight;
   u16LayerWidthInMM = coRef.u16LayerWidthInMM;
   u16LayerHeightInMM = coRef.u16LayerHeightInMM;
   szPixelAspectRatio = coRef.szPixelAspectRatio;
   u16DPI = coRef.u16DPI;
   enDisplayTouchType = coRef.enDisplayTouchType;
   u16PriorityIndex = coRef.u16PriorityIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DisplayLayerAttributes::vDestroy()
{
   szPixelAspectRatio.vDestroy();
}

midw_fi_tcl_DisplayLayerAttributes::midw_fi_tcl_DisplayLayerAttributes()
:enDeviceCategory()
,u16TouchLayerID(0)
,u16TouchSurfaceID(0)
,u16VideoLayerID(0)
,u16VideoSurfaceID(0)
,u16LayerWidth(0)
,u16LayerHeight(0)
,u16LayerWidthInMM(0)
,u16LayerHeightInMM(0)
,szPixelAspectRatio()
,u16DPI(0)
,enDisplayTouchType()
,u16PriorityIndex(0)
 {}

tS32 midw_fi_tcl_DisplayLayerAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYLAYERATTRIBUTES;
}


midw_fi_tcl_DisplayLayerAttributes::~midw_fi_tcl_DisplayLayerAttributes()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DisplayLayerAttributes::u32GetSize(tU16 u16MajorVersion) const
{
   return 22+szPixelAspectRatio.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DisplayLayerAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDeviceCategory);
   (tVoid) (oIn >> u16TouchLayerID);
   (tVoid) (oIn >> u16TouchSurfaceID);
   (tVoid) (oIn >> u16VideoLayerID);
   (tVoid) (oIn >> u16VideoSurfaceID);
   (tVoid) (oIn >> u16LayerWidth);
   (tVoid) (oIn >> u16LayerHeight);
   (tVoid) (oIn >> u16LayerWidthInMM);
   (tVoid) (oIn >> u16LayerHeightInMM);
   (tVoid) (oIn >> szPixelAspectRatio);
   (tVoid) (oIn >> u16DPI);
   (tVoid) (oIn >> enDisplayTouchType);
   (tVoid) (oIn >> u16PriorityIndex);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayLayerAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDeviceCategory);
   (tVoid) (oOut << u16TouchLayerID);
   (tVoid) (oOut << u16TouchSurfaceID);
   (tVoid) (oOut << u16VideoLayerID);
   (tVoid) (oOut << u16VideoSurfaceID);
   (tVoid) (oOut << u16LayerWidth);
   (tVoid) (oOut << u16LayerHeight);
   (tVoid) (oOut << u16LayerWidthInMM);
   (tVoid) (oOut << u16LayerHeightInMM);
   (tVoid) (oOut << szPixelAspectRatio);
   (tVoid) (oOut << u16DPI);
   (tVoid) (oOut << enDisplayTouchType);
   (tVoid) (oOut << u16PriorityIndex);
   return oOut;
}

tBool midw_fi_tcl_DisplayLayerAttributes::operator==(const midw_fi_tcl_DisplayLayerAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDeviceCategory == roRef.enDeviceCategory);
   bResult = bResult && (u16TouchLayerID == roRef.u16TouchLayerID);
   bResult = bResult && (u16TouchSurfaceID == roRef.u16TouchSurfaceID);
   bResult = bResult && (u16VideoLayerID == roRef.u16VideoLayerID);
   bResult = bResult && (u16VideoSurfaceID == roRef.u16VideoSurfaceID);
   bResult = bResult && (u16LayerWidth == roRef.u16LayerWidth);
   bResult = bResult && (u16LayerHeight == roRef.u16LayerHeight);
   bResult = bResult && (u16LayerWidthInMM == roRef.u16LayerWidthInMM);
   bResult = bResult && (u16LayerHeightInMM == roRef.u16LayerHeightInMM);
   bResult = bResult && (szPixelAspectRatio == roRef.szPixelAspectRatio);
   bResult = bResult && (u16DPI == roRef.u16DPI);
   bResult = bResult && (enDisplayTouchType == roRef.enDisplayTouchType);
   bResult = bResult && (u16PriorityIndex == roRef.u16PriorityIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DisplayAttributes::midw_fi_tcl_DisplayAttributes(const midw_fi_tcl_DisplayAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16ScreenHeight = coRef.u16ScreenHeight;
   u16ScreenWidth = coRef.u16ScreenWidth;
   u16ScreenHeightMm = coRef.u16ScreenHeightMm;
   u16ScreenWidthMm = coRef.u16ScreenWidthMm;
   enDisplayType = coRef.enDisplayType;
   DisplayLayerAttributes = coRef.DisplayLayerAttributes;
}
midw_fi_tcl_DisplayAttributes& midw_fi_tcl_DisplayAttributes::operator=(const midw_fi_tcl_DisplayAttributes& coRef)
{
   if (this == &coRef) return *this;
   u16ScreenHeight = coRef.u16ScreenHeight;
   u16ScreenWidth = coRef.u16ScreenWidth;
   u16ScreenHeightMm = coRef.u16ScreenHeightMm;
   u16ScreenWidthMm = coRef.u16ScreenWidthMm;
   enDisplayType = coRef.enDisplayType;
   DisplayLayerAttributes = coRef.DisplayLayerAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DisplayAttributes::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DisplayLayerAttributes.size(); ++u32Idx)
         DisplayLayerAttributes[u32Idx].vDestroy();
   DisplayLayerAttributes.clear();
   }
}

midw_fi_tcl_DisplayAttributes::midw_fi_tcl_DisplayAttributes()
:u16ScreenHeight(0)
,u16ScreenWidth(0)
,u16ScreenHeightMm(0)
,u16ScreenWidthMm(0)
,enDisplayType()

 {}

tS32 midw_fi_tcl_DisplayAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DISPLAYATTRIBUTES;
}


midw_fi_tcl_DisplayAttributes::~midw_fi_tcl_DisplayAttributes()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DisplayAttributes::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DisplayLayerAttributes.size(); ++u32ListIdx)
      u32DynamicSize += DisplayLayerAttributes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

fi_tclInContext& midw_fi_tcl_DisplayAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ScreenHeight);
   (tVoid) (oIn >> u16ScreenWidth);
   (tVoid) (oIn >> u16ScreenHeightMm);
   (tVoid) (oIn >> u16ScreenWidthMm);
   (tVoid) (oIn >> enDisplayType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DisplayLayerAttributes.size(); ++u32Idx)
      {
         DisplayLayerAttributes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DisplayLayerAttributes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DisplayLayerAttributes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DisplayAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ScreenHeight);
   (tVoid) (oOut << u16ScreenWidth);
   (tVoid) (oOut << u16ScreenHeightMm);
   (tVoid) (oOut << u16ScreenWidthMm);
   (tVoid) (oOut << enDisplayType);
   (tVoid) (oOut << (tU32)DisplayLayerAttributes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DisplayLayerAttributes.size(); ++u32Idx)
         (tVoid) (oOut << DisplayLayerAttributes[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_DisplayAttributes::operator==(const midw_fi_tcl_DisplayAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ScreenHeight == roRef.u16ScreenHeight);
   bResult = bResult && (u16ScreenWidth == roRef.u16ScreenWidth);
   bResult = bResult && (u16ScreenHeightMm == roRef.u16ScreenHeightMm);
   bResult = bResult && (u16ScreenWidthMm == roRef.u16ScreenWidthMm);
   bResult = bResult && (enDisplayType == roRef.enDisplayType);
      bResult = bResult && (DisplayLayerAttributes.size() == roRef.DisplayLayerAttributes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DisplayLayerAttributes.size()); ++u32Idx)
            bResult = bResult && (DisplayLayerAttributes[u32Idx] == roRef.DisplayLayerAttributes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AccessoryAudioContext::midw_fi_tcl_AccessoryAudioContext(const midw_fi_tcl_AccessoryAudioContext& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AudioContext = coRef.AudioContext;
   AudioFlag = coRef.AudioFlag;
}
midw_fi_tcl_AccessoryAudioContext& midw_fi_tcl_AccessoryAudioContext::operator=(const midw_fi_tcl_AccessoryAudioContext& coRef)
{
   if (this == &coRef) return *this;
   AudioContext = coRef.AudioContext;
   AudioFlag = coRef.AudioFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AccessoryAudioContext::midw_fi_tcl_AccessoryAudioContext()
:AudioContext()
,AudioFlag(0)
 {}

tS32 midw_fi_tcl_AccessoryAudioContext::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_ACCESSORYAUDIOCONTEXT;
}


midw_fi_tcl_AccessoryAudioContext::~midw_fi_tcl_AccessoryAudioContext()
{}

tU32 midw_fi_tcl_AccessoryAudioContext::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_fi_tcl_AccessoryAudioContext::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioContext);
   (tVoid) (oIn >> AudioFlag);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AccessoryAudioContext::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioContext);
   (tVoid) (oOut << AudioFlag);
   return oOut;
}

tBool midw_fi_tcl_AccessoryAudioContext::operator==(const midw_fi_tcl_AccessoryAudioContext& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioContext == roRef.AudioContext);
   bResult = bResult && (AudioFlag == roRef.AudioFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VehicleState::midw_fi_tcl_e8_VehicleState():enType(FI_EN_PARK_MODE) {}

tS32 midw_fi_tcl_e8_VehicleState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VEHICLESTATE;
}


midw_fi_tcl_e8_VehicleState::~midw_fi_tcl_e8_VehicleState()
{}

tU32 midw_fi_tcl_e8_VehicleState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VehicleState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VehicleState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ParkBrake::midw_fi_tcl_e8_ParkBrake():enType(FI_EN_PARK_BRAKE_INFO_UNAVAILABLE) {}

tS32 midw_fi_tcl_e8_ParkBrake::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_PARKBRAKE;
}


midw_fi_tcl_e8_ParkBrake::~midw_fi_tcl_e8_ParkBrake()
{}

tU32 midw_fi_tcl_e8_ParkBrake::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ParkBrake::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ParkBrake::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_GearState::midw_fi_tcl_e8_GearState():enType(FI_EN_GEAR_NEUTRAL) {}

tS32 midw_fi_tcl_e8_GearState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_GEARSTATE;
}


midw_fi_tcl_e8_GearState::~midw_fi_tcl_e8_GearState()
{}

tU32 midw_fi_tcl_e8_GearState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_GearState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_GearState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_HandsetInteraction::midw_fi_tcl_e8_HandsetInteraction():enType(FI_EN_HANDSET_INTERACTION_UNKNOWN) {}

tS32 midw_fi_tcl_e8_HandsetInteraction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_HANDSETINTERACTION;
}


midw_fi_tcl_e8_HandsetInteraction::~midw_fi_tcl_e8_HandsetInteraction()
{}

tU32 midw_fi_tcl_e8_HandsetInteraction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_HandsetInteraction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_HandsetInteraction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_UserAuthorizationStatus::midw_fi_tcl_e8_UserAuthorizationStatus():enType(FI_EN_USER_AUTH_UNKNOWN) {}

tS32 midw_fi_tcl_e8_UserAuthorizationStatus::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_USERAUTHORIZATIONSTATUS;
}


midw_fi_tcl_e8_UserAuthorizationStatus::~midw_fi_tcl_e8_UserAuthorizationStatus()
{}

tU32 midw_fi_tcl_e8_UserAuthorizationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_UserAuthorizationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_UserAuthorizationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DeviceDetails::midw_fi_tcl_DeviceDetails(const midw_fi_tcl_DeviceDetails& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u32DeviceHandle = coRef.u32DeviceHandle;
   szDeviceName = coRef.szDeviceName;
   enDeviceCategory = coRef.enDeviceCategory;
   szDeviceModelName = coRef.szDeviceModelName;
   szDeviceManufacturerName = coRef.szDeviceManufacturerName;
   enDeviceConnectionStatus = coRef.enDeviceConnectionStatus;
   enDeviceConnectionType = coRef.enDeviceConnectionType;
   rVersionInfo = coRef.rVersionInfo;
   enDeviceUsageEnabled = coRef.enDeviceUsageEnabled;
   bSelectedDevice = coRef.bSelectedDevice;
   bDAPSupport = coRef.bDAPSupport;
   rProjectionCapability = coRef.rProjectionCapability;
   szBTAddress = coRef.szBTAddress;
   rDeviceSelectionInfo = coRef.rDeviceSelectionInfo;
   szSerialNumber = coRef.szSerialNumber;
   enUserAuthorizationStatus = coRef.enUserAuthorizationStatus;
   enSessionTransportType = coRef.enSessionTransportType;
   u32VendorID = coRef.u32VendorID;
   u32ProductID = coRef.u32ProductID;
   szSystemPath = coRef.szSystemPath;
}
midw_fi_tcl_DeviceDetails& midw_fi_tcl_DeviceDetails::operator=(const midw_fi_tcl_DeviceDetails& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceHandle = coRef.u32DeviceHandle;
   szDeviceName = coRef.szDeviceName;
   enDeviceCategory = coRef.enDeviceCategory;
   szDeviceModelName = coRef.szDeviceModelName;
   szDeviceManufacturerName = coRef.szDeviceManufacturerName;
   enDeviceConnectionStatus = coRef.enDeviceConnectionStatus;
   enDeviceConnectionType = coRef.enDeviceConnectionType;
   rVersionInfo = coRef.rVersionInfo;
   enDeviceUsageEnabled = coRef.enDeviceUsageEnabled;
   bSelectedDevice = coRef.bSelectedDevice;
   bDAPSupport = coRef.bDAPSupport;
   rProjectionCapability = coRef.rProjectionCapability;
   szBTAddress = coRef.szBTAddress;
   rDeviceSelectionInfo = coRef.rDeviceSelectionInfo;
   szSerialNumber = coRef.szSerialNumber;
   enUserAuthorizationStatus = coRef.enUserAuthorizationStatus;
   enSessionTransportType = coRef.enSessionTransportType;
   u32VendorID = coRef.u32VendorID;
   u32ProductID = coRef.u32ProductID;
   szSystemPath = coRef.szSystemPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DeviceDetails::vDestroy()
{
   szDeviceName.vDestroy();
   szDeviceModelName.vDestroy();
   szDeviceManufacturerName.vDestroy();
   rVersionInfo.vDestroy(); 
   rProjectionCapability.vDestroy(); 
   szBTAddress.vDestroy();
   rDeviceSelectionInfo.vDestroy(); 
   szSerialNumber.vDestroy();
   szSystemPath.vDestroy();
}

midw_fi_tcl_DeviceDetails::midw_fi_tcl_DeviceDetails()
:u32DeviceHandle(0)
,szDeviceName()
,enDeviceCategory()
,szDeviceModelName()
,szDeviceManufacturerName()
,enDeviceConnectionStatus()
,enDeviceConnectionType()
,rVersionInfo()
,enDeviceUsageEnabled()
,bSelectedDevice(0)
,bDAPSupport(0)
,rProjectionCapability()
,szBTAddress()
,rDeviceSelectionInfo()
,szSerialNumber()
,enUserAuthorizationStatus()
,enSessionTransportType()
,u32VendorID(0)
,u32ProductID(0)
,szSystemPath()
 {}

tS32 midw_fi_tcl_DeviceDetails::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DEVICEDETAILS;
}


midw_fi_tcl_DeviceDetails::~midw_fi_tcl_DeviceDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DeviceDetails::u32GetSize(tU16 u16MajorVersion) const
{
   return 31+szDeviceName.u32GetSize(u16MajorVersion)+szDeviceModelName.u32GetSize(u16MajorVersion)+szDeviceManufacturerName.u32GetSize(u16MajorVersion)+rVersionInfo.u32GetSize(u16MajorVersion)+szBTAddress.u32GetSize(u16MajorVersion)+szSerialNumber.u32GetSize(u16MajorVersion)+szSystemPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DeviceDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceHandle);
   (tVoid) (oIn >> szDeviceName);
   (tVoid) (oIn >> enDeviceCategory);
   (tVoid) (oIn >> szDeviceModelName);
   (tVoid) (oIn >> szDeviceManufacturerName);
   (tVoid) (oIn >> enDeviceConnectionStatus);
   (tVoid) (oIn >> enDeviceConnectionType);
   (tVoid) (oIn >> rVersionInfo);
   (tVoid) (oIn >> enDeviceUsageEnabled);
   (tVoid) (oIn >> bSelectedDevice);
   (tVoid) (oIn >> bDAPSupport);
   (tVoid) (oIn >> rProjectionCapability);
   (tVoid) (oIn >> szBTAddress);
   (tVoid) (oIn >> rDeviceSelectionInfo);
   (tVoid) (oIn >> szSerialNumber);
   (tVoid) (oIn >> enUserAuthorizationStatus);
   (tVoid) (oIn >> enSessionTransportType);
   (tVoid) (oIn >> u32VendorID);
   (tVoid) (oIn >> u32ProductID);
   (tVoid) (oIn >> szSystemPath);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DeviceDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceHandle);
   (tVoid) (oOut << szDeviceName);
   (tVoid) (oOut << enDeviceCategory);
   (tVoid) (oOut << szDeviceModelName);
   (tVoid) (oOut << szDeviceManufacturerName);
   (tVoid) (oOut << enDeviceConnectionStatus);
   (tVoid) (oOut << enDeviceConnectionType);
   (tVoid) (oOut << rVersionInfo);
   (tVoid) (oOut << enDeviceUsageEnabled);
   (tVoid) (oOut << bSelectedDevice);
   (tVoid) (oOut << bDAPSupport);
   (tVoid) (oOut << rProjectionCapability);
   (tVoid) (oOut << szBTAddress);
   (tVoid) (oOut << rDeviceSelectionInfo);
   (tVoid) (oOut << szSerialNumber);
   (tVoid) (oOut << enUserAuthorizationStatus);
   (tVoid) (oOut << enSessionTransportType);
   (tVoid) (oOut << u32VendorID);
   (tVoid) (oOut << u32ProductID);
   (tVoid) (oOut << szSystemPath);
   return oOut;
}

tBool midw_fi_tcl_DeviceDetails::operator==(const midw_fi_tcl_DeviceDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceHandle == roRef.u32DeviceHandle);
   bResult = bResult && (szDeviceName == roRef.szDeviceName);
   bResult = bResult && (enDeviceCategory == roRef.enDeviceCategory);
   bResult = bResult && (szDeviceModelName == roRef.szDeviceModelName);
   bResult = bResult && (szDeviceManufacturerName == roRef.szDeviceManufacturerName);
   bResult = bResult && (enDeviceConnectionStatus == roRef.enDeviceConnectionStatus);
   bResult = bResult && (enDeviceConnectionType == roRef.enDeviceConnectionType);
   bResult = bResult && (rVersionInfo == roRef.rVersionInfo);
   bResult = bResult && (enDeviceUsageEnabled == roRef.enDeviceUsageEnabled);
   bResult = bResult && (bSelectedDevice == roRef.bSelectedDevice);
   bResult = bResult && (bDAPSupport == roRef.bDAPSupport);
   bResult = bResult && (rProjectionCapability == roRef.rProjectionCapability);
   bResult = bResult && (szBTAddress == roRef.szBTAddress);
   bResult = bResult && (rDeviceSelectionInfo == roRef.rDeviceSelectionInfo);
   bResult = bResult && (szSerialNumber == roRef.szSerialNumber);
   bResult = bResult && (enUserAuthorizationStatus == roRef.enUserAuthorizationStatus);
   bResult = bResult && (enSessionTransportType == roRef.enSessionTransportType);
   bResult = bResult && (u32VendorID == roRef.u32VendorID);
   bResult = bResult && (u32ProductID == roRef.u32ProductID);
   bResult = bResult && (szSystemPath == roRef.szSystemPath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DeviceAuthInfo::midw_fi_tcl_DeviceAuthInfo(const midw_fi_tcl_DeviceAuthInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceType = coRef.DeviceType;
   UserAuthorizationStatus = coRef.UserAuthorizationStatus;
}
midw_fi_tcl_DeviceAuthInfo& midw_fi_tcl_DeviceAuthInfo::operator=(const midw_fi_tcl_DeviceAuthInfo& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceType = coRef.DeviceType;
   UserAuthorizationStatus = coRef.UserAuthorizationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_DeviceAuthInfo::midw_fi_tcl_DeviceAuthInfo()
:DeviceHandle(0)
,DeviceType()
,UserAuthorizationStatus()
 {}

tS32 midw_fi_tcl_DeviceAuthInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DEVICEAUTHINFO;
}


midw_fi_tcl_DeviceAuthInfo::~midw_fi_tcl_DeviceAuthInfo()
{}

tU32 midw_fi_tcl_DeviceAuthInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_fi_tcl_DeviceAuthInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceType);
   (tVoid) (oIn >> UserAuthorizationStatus);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DeviceAuthInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceType);
   (tVoid) (oOut << UserAuthorizationStatus);
   return oOut;
}

tBool midw_fi_tcl_DeviceAuthInfo::operator==(const midw_fi_tcl_DeviceAuthInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceType == roRef.DeviceType);
   bResult = bResult && (UserAuthorizationStatus == roRef.UserAuthorizationStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_FeatureRestriction::midw_fi_tcl_FeatureRestriction(const midw_fi_tcl_FeatureRestriction& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   FeatureLockout = coRef.FeatureLockout;
}
midw_fi_tcl_FeatureRestriction& midw_fi_tcl_FeatureRestriction::operator=(const midw_fi_tcl_FeatureRestriction& coRef)
{
   if (this == &coRef) return *this;
   FeatureLockout = coRef.FeatureLockout;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_FeatureRestriction::midw_fi_tcl_FeatureRestriction()
:FeatureLockout(0)
 {}

tS32 midw_fi_tcl_FeatureRestriction::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_FEATURERESTRICTION;
}


midw_fi_tcl_FeatureRestriction::~midw_fi_tcl_FeatureRestriction()
{}

tU32 midw_fi_tcl_FeatureRestriction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_FeatureRestriction::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FeatureLockout);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_FeatureRestriction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FeatureLockout);
   return oOut;
}

tBool midw_fi_tcl_FeatureRestriction::operator==(const midw_fi_tcl_FeatureRestriction& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FeatureLockout == roRef.FeatureLockout);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DeviceSelectionMode::midw_fi_tcl_e8_DeviceSelectionMode():enType(FI_EN_SELECTION_MODE_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DeviceSelectionMode::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DEVICESELECTIONMODE;
}


midw_fi_tcl_e8_DeviceSelectionMode::~midw_fi_tcl_e8_DeviceSelectionMode()
{}

tU32 midw_fi_tcl_e8_DeviceSelectionMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DeviceSelectionMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DeviceSelectionMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_TurnSide::midw_fi_tcl_e8_TurnSide():enType(FI_EN_TURN_SIDE_LEFT) {}

tS32 midw_fi_tcl_e8_TurnSide::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_TURNSIDE;
}


midw_fi_tcl_e8_TurnSide::~midw_fi_tcl_e8_TurnSide()
{}

tU32 midw_fi_tcl_e8_TurnSide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_TurnSide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_TurnSide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_NextTurnEvent::midw_fi_tcl_e8_NextTurnEvent():enType(FI_EN_NEXT_TURN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_NextTurnEvent::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_NEXTTURNEVENT;
}


midw_fi_tcl_e8_NextTurnEvent::~midw_fi_tcl_e8_NextTurnEvent()
{}

tU32 midw_fi_tcl_e8_NextTurnEvent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_NextTurnEvent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_NextTurnEvent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ManeuverDistanceUnits::midw_fi_tcl_e8_ManeuverDistanceUnits():enType(FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN) {}

tS32 midw_fi_tcl_e8_ManeuverDistanceUnits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MANEUVERDISTANCEUNITS;
}


midw_fi_tcl_e8_ManeuverDistanceUnits::~midw_fi_tcl_e8_ManeuverDistanceUnits()
{}

tU32 midw_fi_tcl_e8_ManeuverDistanceUnits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ManeuverDistanceUnits::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ManeuverDistanceUnits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BTVoiceRecRequest::midw_fi_tcl_e8_BTVoiceRecRequest():enType(FI_EN_VOICESESSION_START) {}

tS32 midw_fi_tcl_e8_BTVoiceRecRequest::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BTVOICERECREQUEST;
}


midw_fi_tcl_e8_BTVoiceRecRequest::~midw_fi_tcl_e8_BTVoiceRecRequest()
{}

tU32 midw_fi_tcl_e8_BTVoiceRecRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BTVoiceRecRequest::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BTVoiceRecRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BTVoiceRecRequestResponse::midw_fi_tcl_e8_BTVoiceRecRequestResponse():enType(FI_EN_VOICESESSION_REQUEST_UNKNOWN) {}

tS32 midw_fi_tcl_e8_BTVoiceRecRequestResponse::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BTVOICERECREQUESTRESPONSE;
}


midw_fi_tcl_e8_BTVoiceRecRequestResponse::~midw_fi_tcl_e8_BTVoiceRecRequestResponse()
{}

tU32 midw_fi_tcl_e8_BTVoiceRecRequestResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BTVoiceRecRequestResponse::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BTVoiceRecRequestResponse::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_WiFiSecurityType::midw_fi_tcl_e8_WiFiSecurityType():enType(FI_EN_NONE) {}

tS32 midw_fi_tcl_e8_WiFiSecurityType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_WIFISECURITYTYPE;
}


midw_fi_tcl_e8_WiFiSecurityType::~midw_fi_tcl_e8_WiFiSecurityType()
{}

tU32 midw_fi_tcl_e8_WiFiSecurityType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_WiFiSecurityType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_WiFiSecurityType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_WiFiAPCredentials::midw_fi_tcl_WiFiAPCredentials(const midw_fi_tcl_WiFiAPCredentials& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   SSID = coRef.SSID;
   PassPhrase = coRef.PassPhrase;
   ChannelNo = coRef.ChannelNo;
   SecurityType = coRef.SecurityType;
}
midw_fi_tcl_WiFiAPCredentials& midw_fi_tcl_WiFiAPCredentials::operator=(const midw_fi_tcl_WiFiAPCredentials& coRef)
{
   if (this == &coRef) return *this;
   SSID = coRef.SSID;
   PassPhrase = coRef.PassPhrase;
   ChannelNo = coRef.ChannelNo;
   SecurityType = coRef.SecurityType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_WiFiAPCredentials::vDestroy()
{
   SSID.vDestroy();
   PassPhrase.vDestroy();
}

midw_fi_tcl_WiFiAPCredentials::midw_fi_tcl_WiFiAPCredentials()
:SSID()
,PassPhrase()
,ChannelNo(0)
,SecurityType()
 {}

tS32 midw_fi_tcl_WiFiAPCredentials::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_WIFIAPCREDENTIALS;
}


midw_fi_tcl_WiFiAPCredentials::~midw_fi_tcl_WiFiAPCredentials()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_WiFiAPCredentials::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+SSID.u32GetSize(u16MajorVersion)+PassPhrase.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_WiFiAPCredentials::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SSID);
   (tVoid) (oIn >> PassPhrase);
   (tVoid) (oIn >> ChannelNo);
   (tVoid) (oIn >> SecurityType);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_WiFiAPCredentials::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SSID);
   (tVoid) (oOut << PassPhrase);
   (tVoid) (oOut << ChannelNo);
   (tVoid) (oOut << SecurityType);
   return oOut;
}

tBool midw_fi_tcl_WiFiAPCredentials::operator==(const midw_fi_tcl_WiFiAPCredentials& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SSID == roRef.SSID);
   bResult = bResult && (PassPhrase == roRef.PassPhrase);
   bResult = bResult && (ChannelNo == roRef.ChannelNo);
   bResult = bResult && (SecurityType == roRef.SecurityType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_FidelityType::midw_fi_tcl_e8_FidelityType():enType(FI_EN_E8LOW_FIDELITY) {}

tS32 midw_fi_tcl_e8_FidelityType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_FIDELITYTYPE;
}


midw_fi_tcl_e8_FidelityType::~midw_fi_tcl_e8_FidelityType()
{}

tU32 midw_fi_tcl_e8_FidelityType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_FidelityType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_FidelityType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_OEMICONDetails::midw_fi_tcl_OEMICONDetails(const midw_fi_tcl_OEMICONDetails& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   OEMIconName = coRef.OEMIconName;
   OEMIconpath = coRef.OEMIconpath;
}
midw_fi_tcl_OEMICONDetails& midw_fi_tcl_OEMICONDetails::operator=(const midw_fi_tcl_OEMICONDetails& coRef)
{
   if (this == &coRef) return *this;
   OEMIconName = coRef.OEMIconName;
   OEMIconpath = coRef.OEMIconpath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_OEMICONDetails::vDestroy()
{
   OEMIconName.vDestroy();
   OEMIconpath.vDestroy();
}

midw_fi_tcl_OEMICONDetails::midw_fi_tcl_OEMICONDetails()
:OEMIconName()
,OEMIconpath()
 {}

tS32 midw_fi_tcl_OEMICONDetails::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_OEMICONDETAILS;
}


midw_fi_tcl_OEMICONDetails::~midw_fi_tcl_OEMICONDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_OEMICONDetails::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+OEMIconName.u32GetSize(u16MajorVersion)+OEMIconpath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_OEMICONDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OEMIconName);
   (tVoid) (oIn >> OEMIconpath);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_OEMICONDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OEMIconName);
   (tVoid) (oOut << OEMIconpath);
   return oOut;
}

tBool midw_fi_tcl_OEMICONDetails::operator==(const midw_fi_tcl_OEMICONDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OEMIconName == roRef.OEMIconName);
   bResult = bResult && (OEMIconpath == roRef.OEMIconpath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BatteryChargingState::midw_fi_tcl_e8_BatteryChargingState():enType(FI_EN_BATTERY_CHARGING_STATE_DISABLED) {}

tS32 midw_fi_tcl_e8_BatteryChargingState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BATTERYCHARGINGSTATE;
}


midw_fi_tcl_e8_BatteryChargingState::~midw_fi_tcl_e8_BatteryChargingState()
{}

tU32 midw_fi_tcl_e8_BatteryChargingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BatteryChargingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BatteryChargingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPoRouteGuidanceState::midw_fi_tcl_e8_DiPoRouteGuidanceState():enType(FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET) {}

tS32 midw_fi_tcl_e8_DiPoRouteGuidanceState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOROUTEGUIDANCESTATE;
}


midw_fi_tcl_e8_DiPoRouteGuidanceState::~midw_fi_tcl_e8_DiPoRouteGuidanceState()
{}

tU32 midw_fi_tcl_e8_DiPoRouteGuidanceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPoRouteGuidanceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPoRouteGuidanceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPoManeuverType::midw_fi_tcl_e8_DiPoManeuverType():enType(FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN) {}

tS32 midw_fi_tcl_e8_DiPoManeuverType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOMANEUVERTYPE;
}


midw_fi_tcl_e8_DiPoManeuverType::~midw_fi_tcl_e8_DiPoManeuverType()
{}

tU32 midw_fi_tcl_e8_DiPoManeuverType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPoManeuverType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPoManeuverType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPoManeuverState::midw_fi_tcl_e8_DiPoManeuverState():enType(FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE) {}

tS32 midw_fi_tcl_e8_DiPoManeuverState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOMANEUVERSTATE;
}


midw_fi_tcl_e8_DiPoManeuverState::~midw_fi_tcl_e8_DiPoManeuverState()
{}

tU32 midw_fi_tcl_e8_DiPoManeuverState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPoManeuverState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPoManeuverState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPoDrivingSide::midw_fi_tcl_e8_DiPoDrivingSide():enType(FI_EN_E8DIPO_DRIVING_SIDE_RIGHT) {}

tS32 midw_fi_tcl_e8_DiPoDrivingSide::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPODRIVINGSIDE;
}


midw_fi_tcl_e8_DiPoDrivingSide::~midw_fi_tcl_e8_DiPoDrivingSide()
{}

tU32 midw_fi_tcl_e8_DiPoDrivingSide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPoDrivingSide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPoDrivingSide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DistanceUnits::midw_fi_tcl_e8_DistanceUnits():enType(FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DistanceUnits::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISTANCEUNITS;
}


midw_fi_tcl_e8_DistanceUnits::~midw_fi_tcl_e8_DistanceUnits()
{}

tU32 midw_fi_tcl_e8_DistanceUnits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DistanceUnits::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DistanceUnits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DiPORouteGuidanceUpdate::midw_fi_tcl_DiPORouteGuidanceUpdate(const midw_fi_tcl_DiPORouteGuidanceUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   e8ManeuverState = coRef.e8ManeuverState;
   szCurrentRoadName = coRef.szCurrentRoadName;
   szDestinationName = coRef.szDestinationName;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
}
midw_fi_tcl_DiPORouteGuidanceUpdate& midw_fi_tcl_DiPORouteGuidanceUpdate::operator=(const midw_fi_tcl_DiPORouteGuidanceUpdate& coRef)
{
   if (this == &coRef) return *this;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   e8ManeuverState = coRef.e8ManeuverState;
   szCurrentRoadName = coRef.szCurrentRoadName;
   szDestinationName = coRef.szDestinationName;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DiPORouteGuidanceUpdate::vDestroy()
{
   szCurrentRoadName.vDestroy();
   szDestinationName.vDestroy();
   szDistanceRemainingDisplayStr.vDestroy();
   szDistanceToNextManeuverDisplayStr.vDestroy();
   {
   u16RouteGuidanceManeuverCurrentList.clear();
   }
}

midw_fi_tcl_DiPORouteGuidanceUpdate::midw_fi_tcl_DiPORouteGuidanceUpdate()
:e8RouteGuidanceState()
,e8ManeuverState()
,szCurrentRoadName()
,szDestinationName()
,u64EstimatedTimeOfArrival(0)
,u64TimeRemainingToDestination(0)
,u32DistanceRemaining(0)
,szDistanceRemainingDisplayStr()
,e8DistanceRemainingDisplayUnits()
,u32DistanceToNextManeuver(0)
,szDistanceToNextManeuverDisplayStr()
,e8DistanceToNextManeuverDisplayUnits()

,u16RouteGuidanceManeuverCount(0)
,bIsRouteGuidanceVisibleInApp(0)
 {}

tS32 midw_fi_tcl_DiPORouteGuidanceUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DIPOROUTEGUIDANCEUPDATE;
}


midw_fi_tcl_DiPORouteGuidanceUpdate::~midw_fi_tcl_DiPORouteGuidanceUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DiPORouteGuidanceUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 35+szCurrentRoadName.u32GetSize(u16MajorVersion)+szDestinationName.u32GetSize(u16MajorVersion)+szDistanceRemainingDisplayStr.u32GetSize(u16MajorVersion)+szDistanceToNextManeuverDisplayStr.u32GetSize(u16MajorVersion)+ static_cast<tU32>(u16RouteGuidanceManeuverCurrentList.size()*2);
}

fi_tclInContext& midw_fi_tcl_DiPORouteGuidanceUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RouteGuidanceState);
   (tVoid) (oIn >> e8ManeuverState);
   (tVoid) (oIn >> szCurrentRoadName);
   (tVoid) (oIn >> szDestinationName);
   (tVoid) (oIn >> u64EstimatedTimeOfArrival);
   (tVoid) (oIn >> u64TimeRemainingToDestination);
   (tVoid) (oIn >> u32DistanceRemaining);
   (tVoid) (oIn >> szDistanceRemainingDisplayStr);
   (tVoid) (oIn >> e8DistanceRemainingDisplayUnits);
   (tVoid) (oIn >> u32DistanceToNextManeuver);
   (tVoid) (oIn >> szDistanceToNextManeuverDisplayStr);
   (tVoid) (oIn >> e8DistanceToNextManeuverDisplayUnits);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u16RouteGuidanceManeuverCurrentList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u16RouteGuidanceManeuverCurrentList[u32Idx]);
      }
   }
   (tVoid) (oIn >> u16RouteGuidanceManeuverCount);
   (tVoid) (oIn >> bIsRouteGuidanceVisibleInApp);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DiPORouteGuidanceUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RouteGuidanceState);
   (tVoid) (oOut << e8ManeuverState);
   (tVoid) (oOut << szCurrentRoadName);
   (tVoid) (oOut << szDestinationName);
   (tVoid) (oOut << u64EstimatedTimeOfArrival);
   (tVoid) (oOut << u64TimeRemainingToDestination);
   (tVoid) (oOut << u32DistanceRemaining);
   (tVoid) (oOut << szDistanceRemainingDisplayStr);
   (tVoid) (oOut << e8DistanceRemainingDisplayUnits);
   (tVoid) (oOut << u32DistanceToNextManeuver);
   (tVoid) (oOut << szDistanceToNextManeuverDisplayStr);
   (tVoid) (oOut << e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oOut << (tU32)u16RouteGuidanceManeuverCurrentList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u16RouteGuidanceManeuverCurrentList.size(); ++u32Idx)
         (tVoid) (oOut << u16RouteGuidanceManeuverCurrentList[u32Idx]);
   }
   (tVoid) (oOut << u16RouteGuidanceManeuverCount);
   (tVoid) (oOut << bIsRouteGuidanceVisibleInApp);
   return oOut;
}

tBool midw_fi_tcl_DiPORouteGuidanceUpdate::operator==(const midw_fi_tcl_DiPORouteGuidanceUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RouteGuidanceState == roRef.e8RouteGuidanceState);
   bResult = bResult && (e8ManeuverState == roRef.e8ManeuverState);
   bResult = bResult && (szCurrentRoadName == roRef.szCurrentRoadName);
   bResult = bResult && (szDestinationName == roRef.szDestinationName);
   bResult = bResult && (u64EstimatedTimeOfArrival == roRef.u64EstimatedTimeOfArrival);
   bResult = bResult && (u64TimeRemainingToDestination == roRef.u64TimeRemainingToDestination);
   bResult = bResult && (u32DistanceRemaining == roRef.u32DistanceRemaining);
   bResult = bResult && (szDistanceRemainingDisplayStr == roRef.szDistanceRemainingDisplayStr);
   bResult = bResult && (e8DistanceRemainingDisplayUnits == roRef.e8DistanceRemainingDisplayUnits);
   bResult = bResult && (u32DistanceToNextManeuver == roRef.u32DistanceToNextManeuver);
   bResult = bResult && (szDistanceToNextManeuverDisplayStr == roRef.szDistanceToNextManeuverDisplayStr);
   bResult = bResult && (e8DistanceToNextManeuverDisplayUnits == roRef.e8DistanceToNextManeuverDisplayUnits);
      bResult = bResult && (u16RouteGuidanceManeuverCurrentList.size() == roRef.u16RouteGuidanceManeuverCurrentList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u16RouteGuidanceManeuverCurrentList.size()); ++u32Idx)
            bResult = bResult && (u16RouteGuidanceManeuverCurrentList[u32Idx] == roRef.u16RouteGuidanceManeuverCurrentList[u32Idx]);
      }
   bResult = bResult && (u16RouteGuidanceManeuverCount == roRef.u16RouteGuidanceManeuverCount);
   bResult = bResult && (bIsRouteGuidanceVisibleInApp == roRef.bIsRouteGuidanceVisibleInApp);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DiPoJunctionType::midw_fi_tcl_e8_DiPoJunctionType():enType(FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION) {}

tS32 midw_fi_tcl_e8_DiPoJunctionType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DIPOJUNCTIONTYPE;
}


midw_fi_tcl_e8_DiPoJunctionType::~midw_fi_tcl_e8_DiPoJunctionType()
{}

tU32 midw_fi_tcl_e8_DiPoJunctionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DiPoJunctionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DiPoJunctionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::midw_fi_tcl_DiPORouteGuidanceManeuverUpdate(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16Index = coRef.u16Index;
   szManeuverDescription = coRef.szManeuverDescription;
   e8ManeuverType = coRef.e8ManeuverType;
   szAfterManeuverRoadName = coRef.szAfterManeuverRoadName;
   u32DistanceBetweenManeuver = coRef.u32DistanceBetweenManeuver;
   szDistanceBetweenManeuverDisplayStr = coRef.szDistanceBetweenManeuverDisplayStr;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   e8DrivingSide = coRef.e8DrivingSide;
   e8JunctionType = coRef.e8JunctionType;
   s16JunctionElementAngle = coRef.s16JunctionElementAngle;
   s16JunctionElementExitAngle = coRef.s16JunctionElementExitAngle;
}
midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::operator=(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef)
{
   if (this == &coRef) return *this;
   u16Index = coRef.u16Index;
   szManeuverDescription = coRef.szManeuverDescription;
   e8ManeuverType = coRef.e8ManeuverType;
   szAfterManeuverRoadName = coRef.szAfterManeuverRoadName;
   u32DistanceBetweenManeuver = coRef.u32DistanceBetweenManeuver;
   szDistanceBetweenManeuverDisplayStr = coRef.szDistanceBetweenManeuverDisplayStr;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   e8DrivingSide = coRef.e8DrivingSide;
   e8JunctionType = coRef.e8JunctionType;
   s16JunctionElementAngle = coRef.s16JunctionElementAngle;
   s16JunctionElementExitAngle = coRef.s16JunctionElementExitAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::vDestroy()
{
   szManeuverDescription.vDestroy();
   szAfterManeuverRoadName.vDestroy();
   szDistanceBetweenManeuverDisplayStr.vDestroy();
}

midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::midw_fi_tcl_DiPORouteGuidanceManeuverUpdate()
:u16Index(0)
,szManeuverDescription()
,e8ManeuverType()
,szAfterManeuverRoadName()
,u32DistanceBetweenManeuver(0)
,szDistanceBetweenManeuverDisplayStr()
,e8DistanceBetweenManeuverDisplayUnits()
,e8DrivingSide()
,e8JunctionType()
,s16JunctionElementAngle(0)
,s16JunctionElementExitAngle(0)
 {}

tS32 midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_DIPOROUTEGUIDANCEMANEUVERUPDATE;
}


midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::~midw_fi_tcl_DiPORouteGuidanceManeuverUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+szManeuverDescription.u32GetSize(u16MajorVersion)+szAfterManeuverRoadName.u32GetSize(u16MajorVersion)+szDistanceBetweenManeuverDisplayStr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Index);
   (tVoid) (oIn >> szManeuverDescription);
   (tVoid) (oIn >> e8ManeuverType);
   (tVoid) (oIn >> szAfterManeuverRoadName);
   (tVoid) (oIn >> u32DistanceBetweenManeuver);
   (tVoid) (oIn >> szDistanceBetweenManeuverDisplayStr);
   (tVoid) (oIn >> e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oIn >> e8DrivingSide);
   (tVoid) (oIn >> e8JunctionType);
   (tVoid) (oIn >> s16JunctionElementAngle);
   (tVoid) (oIn >> s16JunctionElementExitAngle);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Index);
   (tVoid) (oOut << szManeuverDescription);
   (tVoid) (oOut << e8ManeuverType);
   (tVoid) (oOut << szAfterManeuverRoadName);
   (tVoid) (oOut << u32DistanceBetweenManeuver);
   (tVoid) (oOut << szDistanceBetweenManeuverDisplayStr);
   (tVoid) (oOut << e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oOut << e8DrivingSide);
   (tVoid) (oOut << e8JunctionType);
   (tVoid) (oOut << s16JunctionElementAngle);
   (tVoid) (oOut << s16JunctionElementExitAngle);
   return oOut;
}

tBool midw_fi_tcl_DiPORouteGuidanceManeuverUpdate::operator==(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Index == roRef.u16Index);
   bResult = bResult && (szManeuverDescription == roRef.szManeuverDescription);
   bResult = bResult && (e8ManeuverType == roRef.e8ManeuverType);
   bResult = bResult && (szAfterManeuverRoadName == roRef.szAfterManeuverRoadName);
   bResult = bResult && (u32DistanceBetweenManeuver == roRef.u32DistanceBetweenManeuver);
   bResult = bResult && (szDistanceBetweenManeuverDisplayStr == roRef.szDistanceBetweenManeuverDisplayStr);
   bResult = bResult && (e8DistanceBetweenManeuverDisplayUnits == roRef.e8DistanceBetweenManeuverDisplayUnits);
   bResult = bResult && (e8DrivingSide == roRef.e8DrivingSide);
   bResult = bResult && (e8JunctionType == roRef.e8JunctionType);
   bResult = bResult && (s16JunctionElementAngle == roRef.s16JunctionElementAngle);
   bResult = bResult && (s16JunctionElementExitAngle == roRef.s16JunctionElementExitAngle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_ComponentID::midw_fi_tcl_e8_ComponentID():enType(FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_1) {}

tS32 midw_fi_tcl_e8_ComponentID::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_COMPONENTID;
}


midw_fi_tcl_e8_ComponentID::~midw_fi_tcl_e8_ComponentID()
{}

tU32 midw_fi_tcl_e8_ComponentID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_ComponentID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_ComponentID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CarPlayTBTUpdate::midw_fi_tcl_CarPlayTBTUpdate(const midw_fi_tcl_CarPlayTBTUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DiPoRouteGuidanceUpdate = coRef.DiPoRouteGuidanceUpdate;
   isDiPoRouteGuidanceUpdateValid = coRef.isDiPoRouteGuidanceUpdateValid;
   DiPoRouteGuidanceManeuverUpdate = coRef.DiPoRouteGuidanceManeuverUpdate;
   isDiPoRouteGuidanceManeuverUpdateValid = coRef.isDiPoRouteGuidanceManeuverUpdateValid;
}
midw_fi_tcl_CarPlayTBTUpdate& midw_fi_tcl_CarPlayTBTUpdate::operator=(const midw_fi_tcl_CarPlayTBTUpdate& coRef)
{
   if (this == &coRef) return *this;
   DiPoRouteGuidanceUpdate = coRef.DiPoRouteGuidanceUpdate;
   isDiPoRouteGuidanceUpdateValid = coRef.isDiPoRouteGuidanceUpdateValid;
   DiPoRouteGuidanceManeuverUpdate = coRef.DiPoRouteGuidanceManeuverUpdate;
   isDiPoRouteGuidanceManeuverUpdateValid = coRef.isDiPoRouteGuidanceManeuverUpdateValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CarPlayTBTUpdate::vDestroy()
{
   DiPoRouteGuidanceUpdate.vDestroy(); 
   DiPoRouteGuidanceManeuverUpdate.vDestroy(); 
}

midw_fi_tcl_CarPlayTBTUpdate::midw_fi_tcl_CarPlayTBTUpdate()
:DiPoRouteGuidanceUpdate()
,isDiPoRouteGuidanceUpdateValid(0)
,DiPoRouteGuidanceManeuverUpdate()
,isDiPoRouteGuidanceManeuverUpdateValid(0)
 {}

tS32 midw_fi_tcl_CarPlayTBTUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CARPLAYTBTUPDATE;
}


midw_fi_tcl_CarPlayTBTUpdate::~midw_fi_tcl_CarPlayTBTUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CarPlayTBTUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+DiPoRouteGuidanceUpdate.u32GetSize(u16MajorVersion)+DiPoRouteGuidanceManeuverUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_CarPlayTBTUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiPoRouteGuidanceUpdate);
   (tVoid) (oIn >> isDiPoRouteGuidanceUpdateValid);
   (tVoid) (oIn >> DiPoRouteGuidanceManeuverUpdate);
   (tVoid) (oIn >> isDiPoRouteGuidanceManeuverUpdateValid);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CarPlayTBTUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiPoRouteGuidanceUpdate);
   (tVoid) (oOut << isDiPoRouteGuidanceUpdateValid);
   (tVoid) (oOut << DiPoRouteGuidanceManeuverUpdate);
   (tVoid) (oOut << isDiPoRouteGuidanceManeuverUpdateValid);
   return oOut;
}

tBool midw_fi_tcl_CarPlayTBTUpdate::operator==(const midw_fi_tcl_CarPlayTBTUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiPoRouteGuidanceUpdate == roRef.DiPoRouteGuidanceUpdate);
   bResult = bResult && (isDiPoRouteGuidanceUpdateValid == roRef.isDiPoRouteGuidanceUpdateValid);
   bResult = bResult && (DiPoRouteGuidanceManeuverUpdate == roRef.DiPoRouteGuidanceManeuverUpdate);
   bResult = bResult && (isDiPoRouteGuidanceManeuverUpdateValid == roRef.isDiPoRouteGuidanceManeuverUpdateValid);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AAutoTurnSide::midw_fi_tcl_e8_AAutoTurnSide():enType(FI_EN_TURN_SIDE_LEFT) {}

tS32 midw_fi_tcl_e8_AAutoTurnSide::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AAUTOTURNSIDE;
}


midw_fi_tcl_e8_AAutoTurnSide::~midw_fi_tcl_e8_AAutoTurnSide()
{}

tU32 midw_fi_tcl_e8_AAutoTurnSide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AAutoTurnSide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AAutoTurnSide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AAutoNavigationNextTurnDistanceData::midw_fi_tcl_AAutoNavigationNextTurnDistanceData(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   DistanceInMeters = coRef.DistanceInMeters;
   TimeInSec = coRef.TimeInSec;
   DistanceToManeuver = coRef.DistanceToManeuver;
   ManeuverDistanceUnits  = coRef.ManeuverDistanceUnits ;
}
midw_fi_tcl_AAutoNavigationNextTurnDistanceData& midw_fi_tcl_AAutoNavigationNextTurnDistanceData::operator=(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef)
{
   if (this == &coRef) return *this;
   DistanceInMeters = coRef.DistanceInMeters;
   TimeInSec = coRef.TimeInSec;
   DistanceToManeuver = coRef.DistanceToManeuver;
   ManeuverDistanceUnits  = coRef.ManeuverDistanceUnits ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AAutoNavigationNextTurnDistanceData::midw_fi_tcl_AAutoNavigationNextTurnDistanceData()
:DistanceInMeters(0)
,TimeInSec(0)
,DistanceToManeuver(0)
,ManeuverDistanceUnits ()
 {}

tS32 midw_fi_tcl_AAutoNavigationNextTurnDistanceData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AAUTONAVIGATIONNEXTTURNDISTANCEDATA;
}


midw_fi_tcl_AAutoNavigationNextTurnDistanceData::~midw_fi_tcl_AAutoNavigationNextTurnDistanceData()
{}

tU32 midw_fi_tcl_AAutoNavigationNextTurnDistanceData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_fi_tcl_AAutoNavigationNextTurnDistanceData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DistanceInMeters);
   (tVoid) (oIn >> TimeInSec);
   (tVoid) (oIn >> DistanceToManeuver);
   (tVoid) (oIn >> ManeuverDistanceUnits );
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AAutoNavigationNextTurnDistanceData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DistanceInMeters);
   (tVoid) (oOut << TimeInSec);
   (tVoid) (oOut << DistanceToManeuver);
   (tVoid) (oOut << ManeuverDistanceUnits );
   return oOut;
}

tBool midw_fi_tcl_AAutoNavigationNextTurnDistanceData::operator==(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DistanceInMeters == roRef.DistanceInMeters);
   bResult = bResult && (TimeInSec == roRef.TimeInSec);
   bResult = bResult && (DistanceToManeuver == roRef.DistanceToManeuver);
   bResult = bResult && (ManeuverDistanceUnits  == roRef.ManeuverDistanceUnits );
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AAutoNavigationAppState::midw_fi_tcl_e8_AAutoNavigationAppState():enType(FI_EN_AAUTO_STATE_NAV_UNKNOWN) {}

tS32 midw_fi_tcl_e8_AAutoNavigationAppState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AAUTONAVIGATIONAPPSTATE;
}


midw_fi_tcl_e8_AAutoNavigationAppState::~midw_fi_tcl_e8_AAutoNavigationAppState()
{}

tU32 midw_fi_tcl_e8_AAutoNavigationAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AAutoNavigationAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AAutoNavigationAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_AAutoNextTurnEvent::midw_fi_tcl_e8_AAutoNextTurnEvent():enType(FI_EN_NEXT_TURN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_AAutoNextTurnEvent::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_AAUTONEXTTURNEVENT;
}


midw_fi_tcl_e8_AAutoNextTurnEvent::~midw_fi_tcl_e8_AAutoNextTurnEvent()
{}

tU32 midw_fi_tcl_e8_AAutoNextTurnEvent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_AAutoNextTurnEvent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_AAutoNextTurnEvent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AAutoNavigationNextTurnData::midw_fi_tcl_AAutoNavigationNextTurnData(const midw_fi_tcl_AAutoNavigationNextTurnData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   RoadName = coRef.RoadName;
   TurnSide = coRef.TurnSide;
   NextTurnEvent = coRef.NextTurnEvent;
   Image = coRef.Image;
   TurnAngle = coRef.TurnAngle;
   TurnNumber = coRef.TurnNumber;
}
midw_fi_tcl_AAutoNavigationNextTurnData& midw_fi_tcl_AAutoNavigationNextTurnData::operator=(const midw_fi_tcl_AAutoNavigationNextTurnData& coRef)
{
   if (this == &coRef) return *this;
   RoadName = coRef.RoadName;
   TurnSide = coRef.TurnSide;
   NextTurnEvent = coRef.NextTurnEvent;
   Image = coRef.Image;
   TurnAngle = coRef.TurnAngle;
   TurnNumber = coRef.TurnNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AAutoNavigationNextTurnData::vDestroy()
{
   RoadName.vDestroy();
   {
   Image.clear();
   }
}

midw_fi_tcl_AAutoNavigationNextTurnData::midw_fi_tcl_AAutoNavigationNextTurnData()
:RoadName()
,TurnSide()
,NextTurnEvent()

,TurnAngle(0)
,TurnNumber(0)
 {}

tS32 midw_fi_tcl_AAutoNavigationNextTurnData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AAUTONAVIGATIONNEXTTURNDATA;
}


midw_fi_tcl_AAutoNavigationNextTurnData::~midw_fi_tcl_AAutoNavigationNextTurnData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AAutoNavigationNextTurnData::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+RoadName.u32GetSize(u16MajorVersion)+ static_cast<tU32>(Image.size()*1);
}

fi_tclInContext& midw_fi_tcl_AAutoNavigationNextTurnData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoadName);
   (tVoid) (oIn >> TurnSide);
   (tVoid) (oIn >> NextTurnEvent);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Image.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Image[u32Idx]);
      }
   }
   (tVoid) (oIn >> TurnAngle);
   (tVoid) (oIn >> TurnNumber);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AAutoNavigationNextTurnData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoadName);
   (tVoid) (oOut << TurnSide);
   (tVoid) (oOut << NextTurnEvent);
   (tVoid) (oOut << (tU32)Image.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Image.size(); ++u32Idx)
         (tVoid) (oOut << Image[u32Idx]);
   }
   (tVoid) (oOut << TurnAngle);
   (tVoid) (oOut << TurnNumber);
   return oOut;
}

tBool midw_fi_tcl_AAutoNavigationNextTurnData::operator==(const midw_fi_tcl_AAutoNavigationNextTurnData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoadName == roRef.RoadName);
   bResult = bResult && (TurnSide == roRef.TurnSide);
   bResult = bResult && (NextTurnEvent == roRef.NextTurnEvent);
      bResult = bResult && (Image.size() == roRef.Image.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Image.size()); ++u32Idx)
            bResult = bResult && (Image[u32Idx] == roRef.Image[u32Idx]);
      }
   bResult = bResult && (TurnAngle == roRef.TurnAngle);
   bResult = bResult && (TurnNumber == roRef.TurnNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AAutoTBTUpdate::midw_fi_tcl_AAutoTBTUpdate(const midw_fi_tcl_AAutoTBTUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   AAutoNavigationNextTurnData = coRef.AAutoNavigationNextTurnData;
   isAAutoNavigationNextTurnDataValid = coRef.isAAutoNavigationNextTurnDataValid;
   AAutoNavigationNextTurnDistanceData = coRef.AAutoNavigationNextTurnDistanceData;
   isAAutoNavigationNextTurnDistanceDataValid = coRef.isAAutoNavigationNextTurnDistanceDataValid;
   AAutoNavigationStatus = coRef.AAutoNavigationStatus;
   isAAutoNavigationStatusValid = coRef.isAAutoNavigationStatusValid;
}
midw_fi_tcl_AAutoTBTUpdate& midw_fi_tcl_AAutoTBTUpdate::operator=(const midw_fi_tcl_AAutoTBTUpdate& coRef)
{
   if (this == &coRef) return *this;
   AAutoNavigationNextTurnData = coRef.AAutoNavigationNextTurnData;
   isAAutoNavigationNextTurnDataValid = coRef.isAAutoNavigationNextTurnDataValid;
   AAutoNavigationNextTurnDistanceData = coRef.AAutoNavigationNextTurnDistanceData;
   isAAutoNavigationNextTurnDistanceDataValid = coRef.isAAutoNavigationNextTurnDistanceDataValid;
   AAutoNavigationStatus = coRef.AAutoNavigationStatus;
   isAAutoNavigationStatusValid = coRef.isAAutoNavigationStatusValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_AAutoTBTUpdate::vDestroy()
{
   AAutoNavigationNextTurnData.vDestroy(); 
   AAutoNavigationNextTurnDistanceData.vDestroy(); 
}

midw_fi_tcl_AAutoTBTUpdate::midw_fi_tcl_AAutoTBTUpdate()
:AAutoNavigationNextTurnData()
,isAAutoNavigationNextTurnDataValid(0)
,AAutoNavigationNextTurnDistanceData()
,isAAutoNavigationNextTurnDistanceDataValid(0)
,AAutoNavigationStatus()
,isAAutoNavigationStatusValid(0)
 {}

tS32 midw_fi_tcl_AAutoTBTUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AAUTOTBTUPDATE;
}


midw_fi_tcl_AAutoTBTUpdate::~midw_fi_tcl_AAutoTBTUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_AAutoTBTUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+AAutoNavigationNextTurnData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_AAutoTBTUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AAutoNavigationNextTurnData);
   (tVoid) (oIn >> isAAutoNavigationNextTurnDataValid);
   (tVoid) (oIn >> AAutoNavigationNextTurnDistanceData);
   (tVoid) (oIn >> isAAutoNavigationNextTurnDistanceDataValid);
   (tVoid) (oIn >> AAutoNavigationStatus);
   (tVoid) (oIn >> isAAutoNavigationStatusValid);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AAutoTBTUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AAutoNavigationNextTurnData);
   (tVoid) (oOut << isAAutoNavigationNextTurnDataValid);
   (tVoid) (oOut << AAutoNavigationNextTurnDistanceData);
   (tVoid) (oOut << isAAutoNavigationNextTurnDistanceDataValid);
   (tVoid) (oOut << AAutoNavigationStatus);
   (tVoid) (oOut << isAAutoNavigationStatusValid);
   return oOut;
}

tBool midw_fi_tcl_AAutoTBTUpdate::operator==(const midw_fi_tcl_AAutoTBTUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AAutoNavigationNextTurnData == roRef.AAutoNavigationNextTurnData);
   bResult = bResult && (isAAutoNavigationNextTurnDataValid == roRef.isAAutoNavigationNextTurnDataValid);
   bResult = bResult && (AAutoNavigationNextTurnDistanceData == roRef.AAutoNavigationNextTurnDistanceData);
   bResult = bResult && (isAAutoNavigationNextTurnDistanceDataValid == roRef.isAAutoNavigationNextTurnDistanceDataValid);
   bResult = bResult && (AAutoNavigationStatus == roRef.AAutoNavigationStatus);
   bResult = bResult && (isAAutoNavigationStatusValid == roRef.isAAutoNavigationStatusValid);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BDCLNavigationAppState::midw_fi_tcl_e8_BDCLNavigationAppState():enType(FI_EN_BDCL_NAV_STATE_ACTION_INVALID) {}

tS32 midw_fi_tcl_e8_BDCLNavigationAppState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BDCLNAVIGATIONAPPSTATE;
}


midw_fi_tcl_e8_BDCLNavigationAppState::~midw_fi_tcl_e8_BDCLNavigationAppState()
{}

tU32 midw_fi_tcl_e8_BDCLNavigationAppState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BDCLNavigationAppState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BDCLNavigationAppState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BDCLNextTurnType::midw_fi_tcl_e8_BDCLNextTurnType():enType(FI_EN_NEXT_TURN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_BDCLNextTurnType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BDCLNEXTTURNTYPE;
}


midw_fi_tcl_e8_BDCLNextTurnType::~midw_fi_tcl_e8_BDCLNextTurnType()
{}

tU32 midw_fi_tcl_e8_BDCLNextTurnType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BDCLNextTurnType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BDCLNextTurnType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CarlifeNaviNextTurnInfo::midw_fi_tcl_CarlifeNaviNextTurnInfo(const midw_fi_tcl_CarlifeNaviNextTurnInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   BDCLNavigationAppState = coRef.BDCLNavigationAppState;
   BDCLNaviTurnType = coRef.BDCLNaviTurnType;
   RoadName = coRef.RoadName;
   TotalDistance = coRef.TotalDistance;
   RemainDistance = coRef.RemainDistance;
   TurnIconData = coRef.TurnIconData;
}
midw_fi_tcl_CarlifeNaviNextTurnInfo& midw_fi_tcl_CarlifeNaviNextTurnInfo::operator=(const midw_fi_tcl_CarlifeNaviNextTurnInfo& coRef)
{
   if (this == &coRef) return *this;
   BDCLNavigationAppState = coRef.BDCLNavigationAppState;
   BDCLNaviTurnType = coRef.BDCLNaviTurnType;
   RoadName = coRef.RoadName;
   TotalDistance = coRef.TotalDistance;
   RemainDistance = coRef.RemainDistance;
   TurnIconData = coRef.TurnIconData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CarlifeNaviNextTurnInfo::vDestroy()
{
   RoadName.vDestroy();
   {
   TurnIconData.clear();
   }
}

midw_fi_tcl_CarlifeNaviNextTurnInfo::midw_fi_tcl_CarlifeNaviNextTurnInfo()
:BDCLNavigationAppState()
,BDCLNaviTurnType()
,RoadName()
,TotalDistance(0)
,RemainDistance(0)

 {}

tS32 midw_fi_tcl_CarlifeNaviNextTurnInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CARLIFENAVINEXTTURNINFO;
}


midw_fi_tcl_CarlifeNaviNextTurnInfo::~midw_fi_tcl_CarlifeNaviNextTurnInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CarlifeNaviNextTurnInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+RoadName.u32GetSize(u16MajorVersion)+ static_cast<tU32>(TurnIconData.size()*1);
}

fi_tclInContext& midw_fi_tcl_CarlifeNaviNextTurnInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BDCLNavigationAppState);
   (tVoid) (oIn >> BDCLNaviTurnType);
   (tVoid) (oIn >> RoadName);
   (tVoid) (oIn >> TotalDistance);
   (tVoid) (oIn >> RemainDistance);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TurnIconData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TurnIconData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CarlifeNaviNextTurnInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BDCLNavigationAppState);
   (tVoid) (oOut << BDCLNaviTurnType);
   (tVoid) (oOut << RoadName);
   (tVoid) (oOut << TotalDistance);
   (tVoid) (oOut << RemainDistance);
   (tVoid) (oOut << (tU32)TurnIconData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TurnIconData.size(); ++u32Idx)
         (tVoid) (oOut << TurnIconData[u32Idx]);
   }
   return oOut;
}

tBool midw_fi_tcl_CarlifeNaviNextTurnInfo::operator==(const midw_fi_tcl_CarlifeNaviNextTurnInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BDCLNavigationAppState == roRef.BDCLNavigationAppState);
   bResult = bResult && (BDCLNaviTurnType == roRef.BDCLNaviTurnType);
   bResult = bResult && (RoadName == roRef.RoadName);
   bResult = bResult && (TotalDistance == roRef.TotalDistance);
   bResult = bResult && (RemainDistance == roRef.RemainDistance);
      bResult = bResult && (TurnIconData.size() == roRef.TurnIconData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TurnIconData.size()); ++u32Idx)
            bResult = bResult && (TurnIconData[u32Idx] == roRef.TurnIconData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BDCLAssistantType::midw_fi_tcl_e8_BDCLAssistantType():enType(FI_EN_BDCL_ASSISTANT_TYPE_INVALID) {}

tS32 midw_fi_tcl_e8_BDCLAssistantType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BDCLASSISTANTTYPE;
}


midw_fi_tcl_e8_BDCLAssistantType::~midw_fi_tcl_e8_BDCLAssistantType()
{}

tU32 midw_fi_tcl_e8_BDCLAssistantType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BDCLAssistantType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BDCLAssistantType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_BDCLTrafficSignType::midw_fi_tcl_e8_BDCLTrafficSignType():enType(FI_EN_BDCL_TRAFFICSIGNTYPE_INVALID) {}

tS32 midw_fi_tcl_e8_BDCLTrafficSignType::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_BDCLTRAFFICSIGNTYPE;
}


midw_fi_tcl_e8_BDCLTrafficSignType::~midw_fi_tcl_e8_BDCLTrafficSignType()
{}

tU32 midw_fi_tcl_e8_BDCLTrafficSignType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_BDCLTrafficSignType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_BDCLTrafficSignType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CarlifeNaviAssistantGuideInfo::midw_fi_tcl_CarlifeNaviAssistantGuideInfo(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   BDCLAssistantGuideAppState = coRef.BDCLAssistantGuideAppState;
   AssistantType = coRef.AssistantType;
   TrafficSignType = coRef.TrafficSignType;
   TotalDistance = coRef.TotalDistance;
   RemainDistance = coRef.RemainDistance;
   CameraSpeed = coRef.CameraSpeed;
}
midw_fi_tcl_CarlifeNaviAssistantGuideInfo& midw_fi_tcl_CarlifeNaviAssistantGuideInfo::operator=(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef)
{
   if (this == &coRef) return *this;
   BDCLAssistantGuideAppState = coRef.BDCLAssistantGuideAppState;
   AssistantType = coRef.AssistantType;
   TrafficSignType = coRef.TrafficSignType;
   TotalDistance = coRef.TotalDistance;
   RemainDistance = coRef.RemainDistance;
   CameraSpeed = coRef.CameraSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_CarlifeNaviAssistantGuideInfo::midw_fi_tcl_CarlifeNaviAssistantGuideInfo()
:BDCLAssistantGuideAppState()
,AssistantType()
,TrafficSignType()
,TotalDistance(0)
,RemainDistance(0)
,CameraSpeed(0)
 {}

tS32 midw_fi_tcl_CarlifeNaviAssistantGuideInfo::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CARLIFENAVIASSISTANTGUIDEINFO;
}


midw_fi_tcl_CarlifeNaviAssistantGuideInfo::~midw_fi_tcl_CarlifeNaviAssistantGuideInfo()
{}

tU32 midw_fi_tcl_CarlifeNaviAssistantGuideInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_fi_tcl_CarlifeNaviAssistantGuideInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BDCLAssistantGuideAppState);
   (tVoid) (oIn >> AssistantType);
   (tVoid) (oIn >> TrafficSignType);
   (tVoid) (oIn >> TotalDistance);
   (tVoid) (oIn >> RemainDistance);
   (tVoid) (oIn >> CameraSpeed);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CarlifeNaviAssistantGuideInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BDCLAssistantGuideAppState);
   (tVoid) (oOut << AssistantType);
   (tVoid) (oOut << TrafficSignType);
   (tVoid) (oOut << TotalDistance);
   (tVoid) (oOut << RemainDistance);
   (tVoid) (oOut << CameraSpeed);
   return oOut;
}

tBool midw_fi_tcl_CarlifeNaviAssistantGuideInfo::operator==(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BDCLAssistantGuideAppState == roRef.BDCLAssistantGuideAppState);
   bResult = bResult && (AssistantType == roRef.AssistantType);
   bResult = bResult && (TrafficSignType == roRef.TrafficSignType);
   bResult = bResult && (TotalDistance == roRef.TotalDistance);
   bResult = bResult && (RemainDistance == roRef.RemainDistance);
   bResult = bResult && (CameraSpeed == roRef.CameraSpeed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_BDCLTBTUpdate::midw_fi_tcl_BDCLTBTUpdate(const midw_fi_tcl_BDCLTBTUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   CarlifeNaviNextTurnInfo = coRef.CarlifeNaviNextTurnInfo;
   isCarlifeNaviNextTurnInfoValid = coRef.isCarlifeNaviNextTurnInfoValid;
   CarlifeNaviAssistantGuideInfo = coRef.CarlifeNaviAssistantGuideInfo;
   isCarlifeNaviAssistantGuideInfoValid = coRef.isCarlifeNaviAssistantGuideInfoValid;
}
midw_fi_tcl_BDCLTBTUpdate& midw_fi_tcl_BDCLTBTUpdate::operator=(const midw_fi_tcl_BDCLTBTUpdate& coRef)
{
   if (this == &coRef) return *this;
   CarlifeNaviNextTurnInfo = coRef.CarlifeNaviNextTurnInfo;
   isCarlifeNaviNextTurnInfoValid = coRef.isCarlifeNaviNextTurnInfoValid;
   CarlifeNaviAssistantGuideInfo = coRef.CarlifeNaviAssistantGuideInfo;
   isCarlifeNaviAssistantGuideInfoValid = coRef.isCarlifeNaviAssistantGuideInfoValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_BDCLTBTUpdate::vDestroy()
{
   CarlifeNaviNextTurnInfo.vDestroy(); 
   CarlifeNaviAssistantGuideInfo.vDestroy(); 
}

midw_fi_tcl_BDCLTBTUpdate::midw_fi_tcl_BDCLTBTUpdate()
:CarlifeNaviNextTurnInfo()
,isCarlifeNaviNextTurnInfoValid(0)
,CarlifeNaviAssistantGuideInfo()
,isCarlifeNaviAssistantGuideInfoValid(0)
 {}

tS32 midw_fi_tcl_BDCLTBTUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_BDCLTBTUPDATE;
}


midw_fi_tcl_BDCLTBTUpdate::~midw_fi_tcl_BDCLTBTUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_BDCLTBTUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+CarlifeNaviNextTurnInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_BDCLTBTUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CarlifeNaviNextTurnInfo);
   (tVoid) (oIn >> isCarlifeNaviNextTurnInfoValid);
   (tVoid) (oIn >> CarlifeNaviAssistantGuideInfo);
   (tVoid) (oIn >> isCarlifeNaviAssistantGuideInfoValid);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_BDCLTBTUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CarlifeNaviNextTurnInfo);
   (tVoid) (oOut << isCarlifeNaviNextTurnInfoValid);
   (tVoid) (oOut << CarlifeNaviAssistantGuideInfo);
   (tVoid) (oOut << isCarlifeNaviAssistantGuideInfoValid);
   return oOut;
}

tBool midw_fi_tcl_BDCLTBTUpdate::operator==(const midw_fi_tcl_BDCLTBTUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CarlifeNaviNextTurnInfo == roRef.CarlifeNaviNextTurnInfo);
   bResult = bResult && (isCarlifeNaviNextTurnInfoValid == roRef.isCarlifeNaviNextTurnInfoValid);
   bResult = bResult && (CarlifeNaviAssistantGuideInfo == roRef.CarlifeNaviAssistantGuideInfo);
   bResult = bResult && (isCarlifeNaviAssistantGuideInfoValid == roRef.isCarlifeNaviAssistantGuideInfoValid);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CarPlayRouteGuidanceUpdate::midw_fi_tcl_CarPlayRouteGuidanceUpdate(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   e8RouteGuidanceDisplayComponentIDs = coRef.e8RouteGuidanceDisplayComponentIDs;
   bRouteGuidanceStateAvailable = coRef.bRouteGuidanceStateAvailable;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   bManeuverStateAvailable = coRef.bManeuverStateAvailable;
   e8ManeuverState = coRef.e8ManeuverState;
   bCurrentRoadNameAvailable = coRef.bCurrentRoadNameAvailable;
   szCurrentRoadName = coRef.szCurrentRoadName;
   bDestinationNameAvailable = coRef.bDestinationNameAvailable;
   szDestinationName = coRef.szDestinationName;
   bEstimatedTimeOfArrivalAvailable = coRef.bEstimatedTimeOfArrivalAvailable;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   bTimeRemainingToDestinationAvailable = coRef.bTimeRemainingToDestinationAvailable;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   bDistanceRemainingAvailable = coRef.bDistanceRemainingAvailable;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   bDistanceRemainingDisplayStrAvailable = coRef.bDistanceRemainingDisplayStrAvailable;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   bDistanceRemainingDisplayUnitsAvailable = coRef.bDistanceRemainingDisplayUnitsAvailable;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   bDistanceToNextManeuverAvailable = coRef.bDistanceToNextManeuverAvailable;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   bDistanceToNextManeuverDisplayStrAvailable = coRef.bDistanceToNextManeuverDisplayStrAvailable;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   bDistanceToNextManeuverDisplayUnitsAvailable = coRef.bDistanceToNextManeuverDisplayUnitsAvailable;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   bRouteGuidanceManeuverCurrentListAvailable = coRef.bRouteGuidanceManeuverCurrentListAvailable;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   bRouteGuidanceManeuverCountAvailable = coRef.bRouteGuidanceManeuverCountAvailable;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bRouteGuidanceVisibleInAppAvailable = coRef.bRouteGuidanceVisibleInAppAvailable;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
   bSourceNameAvailable = coRef.bSourceNameAvailable;
   SourceName = coRef.SourceName;
   bSourceSupportsRouteGuidanceAvailable = coRef.bSourceSupportsRouteGuidanceAvailable;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
}
midw_fi_tcl_CarPlayRouteGuidanceUpdate& midw_fi_tcl_CarPlayRouteGuidanceUpdate::operator=(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& coRef)
{
   if (this == &coRef) return *this;
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   e8RouteGuidanceDisplayComponentIDs = coRef.e8RouteGuidanceDisplayComponentIDs;
   bRouteGuidanceStateAvailable = coRef.bRouteGuidanceStateAvailable;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   bManeuverStateAvailable = coRef.bManeuverStateAvailable;
   e8ManeuverState = coRef.e8ManeuverState;
   bCurrentRoadNameAvailable = coRef.bCurrentRoadNameAvailable;
   szCurrentRoadName = coRef.szCurrentRoadName;
   bDestinationNameAvailable = coRef.bDestinationNameAvailable;
   szDestinationName = coRef.szDestinationName;
   bEstimatedTimeOfArrivalAvailable = coRef.bEstimatedTimeOfArrivalAvailable;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   bTimeRemainingToDestinationAvailable = coRef.bTimeRemainingToDestinationAvailable;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   bDistanceRemainingAvailable = coRef.bDistanceRemainingAvailable;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   bDistanceRemainingDisplayStrAvailable = coRef.bDistanceRemainingDisplayStrAvailable;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   bDistanceRemainingDisplayUnitsAvailable = coRef.bDistanceRemainingDisplayUnitsAvailable;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   bDistanceToNextManeuverAvailable = coRef.bDistanceToNextManeuverAvailable;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   bDistanceToNextManeuverDisplayStrAvailable = coRef.bDistanceToNextManeuverDisplayStrAvailable;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   bDistanceToNextManeuverDisplayUnitsAvailable = coRef.bDistanceToNextManeuverDisplayUnitsAvailable;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   bRouteGuidanceManeuverCurrentListAvailable = coRef.bRouteGuidanceManeuverCurrentListAvailable;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   bRouteGuidanceManeuverCountAvailable = coRef.bRouteGuidanceManeuverCountAvailable;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bRouteGuidanceVisibleInAppAvailable = coRef.bRouteGuidanceVisibleInAppAvailable;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
   bSourceNameAvailable = coRef.bSourceNameAvailable;
   SourceName = coRef.SourceName;
   bSourceSupportsRouteGuidanceAvailable = coRef.bSourceSupportsRouteGuidanceAvailable;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_CarPlayRouteGuidanceUpdate::vDestroy()
{
   {
   e8RouteGuidanceDisplayComponentIDs.clear();
   }
   szCurrentRoadName.vDestroy();
   szDestinationName.vDestroy();
   szDistanceRemainingDisplayStr.vDestroy();
   szDistanceToNextManeuverDisplayStr.vDestroy();
   {
   u16RouteGuidanceManeuverCurrentList.clear();
   }
   SourceName.vDestroy();
}

midw_fi_tcl_CarPlayRouteGuidanceUpdate::midw_fi_tcl_CarPlayRouteGuidanceUpdate()
:bRouteGuidanceDisplayComponentIDsAvailable(0)

,bRouteGuidanceStateAvailable(0)
,e8RouteGuidanceState()
,bManeuverStateAvailable(0)
,e8ManeuverState()
,bCurrentRoadNameAvailable(0)
,szCurrentRoadName()
,bDestinationNameAvailable(0)
,szDestinationName()
,bEstimatedTimeOfArrivalAvailable(0)
,u64EstimatedTimeOfArrival(0)
,bTimeRemainingToDestinationAvailable(0)
,u64TimeRemainingToDestination(0)
,bDistanceRemainingAvailable(0)
,u32DistanceRemaining(0)
,bDistanceRemainingDisplayStrAvailable(0)
,szDistanceRemainingDisplayStr()
,bDistanceRemainingDisplayUnitsAvailable(0)
,e8DistanceRemainingDisplayUnits()
,bDistanceToNextManeuverAvailable(0)
,u32DistanceToNextManeuver(0)
,bDistanceToNextManeuverDisplayStrAvailable(0)
,szDistanceToNextManeuverDisplayStr()
,bDistanceToNextManeuverDisplayUnitsAvailable(0)
,e8DistanceToNextManeuverDisplayUnits()
,bRouteGuidanceManeuverCurrentListAvailable(0)

,bRouteGuidanceManeuverCountAvailable(0)
,u16RouteGuidanceManeuverCount(0)
,bRouteGuidanceVisibleInAppAvailable(0)
,bIsRouteGuidanceVisibleInApp(0)
,bSourceNameAvailable(0)
,SourceName()
,bSourceSupportsRouteGuidanceAvailable(0)
,SourceSupportsRouteGuidance(0)
 {}

tS32 midw_fi_tcl_CarPlayRouteGuidanceUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_CARPLAYROUTEGUIDANCEUPDATE;
}


midw_fi_tcl_CarPlayRouteGuidanceUpdate::~midw_fi_tcl_CarPlayRouteGuidanceUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_CarPlayRouteGuidanceUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 58+ static_cast<tU32>(e8RouteGuidanceDisplayComponentIDs.size()*1)+szCurrentRoadName.u32GetSize(u16MajorVersion)+szDestinationName.u32GetSize(u16MajorVersion)+szDistanceRemainingDisplayStr.u32GetSize(u16MajorVersion)+szDistanceToNextManeuverDisplayStr.u32GetSize(u16MajorVersion)+ static_cast<tU32>(u16RouteGuidanceManeuverCurrentList.size()*2)+SourceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_CarPlayRouteGuidanceUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRouteGuidanceDisplayComponentIDsAvailable);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8RouteGuidanceDisplayComponentIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8RouteGuidanceDisplayComponentIDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> bRouteGuidanceStateAvailable);
   (tVoid) (oIn >> e8RouteGuidanceState);
   (tVoid) (oIn >> bManeuverStateAvailable);
   (tVoid) (oIn >> e8ManeuverState);
   (tVoid) (oIn >> bCurrentRoadNameAvailable);
   (tVoid) (oIn >> szCurrentRoadName);
   (tVoid) (oIn >> bDestinationNameAvailable);
   (tVoid) (oIn >> szDestinationName);
   (tVoid) (oIn >> bEstimatedTimeOfArrivalAvailable);
   (tVoid) (oIn >> u64EstimatedTimeOfArrival);
   (tVoid) (oIn >> bTimeRemainingToDestinationAvailable);
   (tVoid) (oIn >> u64TimeRemainingToDestination);
   (tVoid) (oIn >> bDistanceRemainingAvailable);
   (tVoid) (oIn >> u32DistanceRemaining);
   (tVoid) (oIn >> bDistanceRemainingDisplayStrAvailable);
   (tVoid) (oIn >> szDistanceRemainingDisplayStr);
   (tVoid) (oIn >> bDistanceRemainingDisplayUnitsAvailable);
   (tVoid) (oIn >> e8DistanceRemainingDisplayUnits);
   (tVoid) (oIn >> bDistanceToNextManeuverAvailable);
   (tVoid) (oIn >> u32DistanceToNextManeuver);
   (tVoid) (oIn >> bDistanceToNextManeuverDisplayStrAvailable);
   (tVoid) (oIn >> szDistanceToNextManeuverDisplayStr);
   (tVoid) (oIn >> bDistanceToNextManeuverDisplayUnitsAvailable);
   (tVoid) (oIn >> e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oIn >> bRouteGuidanceManeuverCurrentListAvailable);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u16RouteGuidanceManeuverCurrentList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u16RouteGuidanceManeuverCurrentList[u32Idx]);
      }
   }
   (tVoid) (oIn >> bRouteGuidanceManeuverCountAvailable);
   (tVoid) (oIn >> u16RouteGuidanceManeuverCount);
   (tVoid) (oIn >> bRouteGuidanceVisibleInAppAvailable);
   (tVoid) (oIn >> bIsRouteGuidanceVisibleInApp);
   (tVoid) (oIn >> bSourceNameAvailable);
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> bSourceSupportsRouteGuidanceAvailable);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_CarPlayRouteGuidanceUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRouteGuidanceDisplayComponentIDsAvailable);
   (tVoid) (oOut << (tU32)e8RouteGuidanceDisplayComponentIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8RouteGuidanceDisplayComponentIDs.size(); ++u32Idx)
         (tVoid) (oOut << e8RouteGuidanceDisplayComponentIDs[u32Idx]);
   }
   (tVoid) (oOut << bRouteGuidanceStateAvailable);
   (tVoid) (oOut << e8RouteGuidanceState);
   (tVoid) (oOut << bManeuverStateAvailable);
   (tVoid) (oOut << e8ManeuverState);
   (tVoid) (oOut << bCurrentRoadNameAvailable);
   (tVoid) (oOut << szCurrentRoadName);
   (tVoid) (oOut << bDestinationNameAvailable);
   (tVoid) (oOut << szDestinationName);
   (tVoid) (oOut << bEstimatedTimeOfArrivalAvailable);
   (tVoid) (oOut << u64EstimatedTimeOfArrival);
   (tVoid) (oOut << bTimeRemainingToDestinationAvailable);
   (tVoid) (oOut << u64TimeRemainingToDestination);
   (tVoid) (oOut << bDistanceRemainingAvailable);
   (tVoid) (oOut << u32DistanceRemaining);
   (tVoid) (oOut << bDistanceRemainingDisplayStrAvailable);
   (tVoid) (oOut << szDistanceRemainingDisplayStr);
   (tVoid) (oOut << bDistanceRemainingDisplayUnitsAvailable);
   (tVoid) (oOut << e8DistanceRemainingDisplayUnits);
   (tVoid) (oOut << bDistanceToNextManeuverAvailable);
   (tVoid) (oOut << u32DistanceToNextManeuver);
   (tVoid) (oOut << bDistanceToNextManeuverDisplayStrAvailable);
   (tVoid) (oOut << szDistanceToNextManeuverDisplayStr);
   (tVoid) (oOut << bDistanceToNextManeuverDisplayUnitsAvailable);
   (tVoid) (oOut << e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oOut << bRouteGuidanceManeuverCurrentListAvailable);
   (tVoid) (oOut << (tU32)u16RouteGuidanceManeuverCurrentList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u16RouteGuidanceManeuverCurrentList.size(); ++u32Idx)
         (tVoid) (oOut << u16RouteGuidanceManeuverCurrentList[u32Idx]);
   }
   (tVoid) (oOut << bRouteGuidanceManeuverCountAvailable);
   (tVoid) (oOut << u16RouteGuidanceManeuverCount);
   (tVoid) (oOut << bRouteGuidanceVisibleInAppAvailable);
   (tVoid) (oOut << bIsRouteGuidanceVisibleInApp);
   (tVoid) (oOut << bSourceNameAvailable);
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << bSourceSupportsRouteGuidanceAvailable);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   return oOut;
}

tBool midw_fi_tcl_CarPlayRouteGuidanceUpdate::operator==(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRouteGuidanceDisplayComponentIDsAvailable == roRef.bRouteGuidanceDisplayComponentIDsAvailable);
      bResult = bResult && (e8RouteGuidanceDisplayComponentIDs.size() == roRef.e8RouteGuidanceDisplayComponentIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8RouteGuidanceDisplayComponentIDs.size()); ++u32Idx)
            bResult = bResult && (e8RouteGuidanceDisplayComponentIDs[u32Idx] == roRef.e8RouteGuidanceDisplayComponentIDs[u32Idx]);
      }
   bResult = bResult && (bRouteGuidanceStateAvailable == roRef.bRouteGuidanceStateAvailable);
   bResult = bResult && (e8RouteGuidanceState == roRef.e8RouteGuidanceState);
   bResult = bResult && (bManeuverStateAvailable == roRef.bManeuverStateAvailable);
   bResult = bResult && (e8ManeuverState == roRef.e8ManeuverState);
   bResult = bResult && (bCurrentRoadNameAvailable == roRef.bCurrentRoadNameAvailable);
   bResult = bResult && (szCurrentRoadName == roRef.szCurrentRoadName);
   bResult = bResult && (bDestinationNameAvailable == roRef.bDestinationNameAvailable);
   bResult = bResult && (szDestinationName == roRef.szDestinationName);
   bResult = bResult && (bEstimatedTimeOfArrivalAvailable == roRef.bEstimatedTimeOfArrivalAvailable);
   bResult = bResult && (u64EstimatedTimeOfArrival == roRef.u64EstimatedTimeOfArrival);
   bResult = bResult && (bTimeRemainingToDestinationAvailable == roRef.bTimeRemainingToDestinationAvailable);
   bResult = bResult && (u64TimeRemainingToDestination == roRef.u64TimeRemainingToDestination);
   bResult = bResult && (bDistanceRemainingAvailable == roRef.bDistanceRemainingAvailable);
   bResult = bResult && (u32DistanceRemaining == roRef.u32DistanceRemaining);
   bResult = bResult && (bDistanceRemainingDisplayStrAvailable == roRef.bDistanceRemainingDisplayStrAvailable);
   bResult = bResult && (szDistanceRemainingDisplayStr == roRef.szDistanceRemainingDisplayStr);
   bResult = bResult && (bDistanceRemainingDisplayUnitsAvailable == roRef.bDistanceRemainingDisplayUnitsAvailable);
   bResult = bResult && (e8DistanceRemainingDisplayUnits == roRef.e8DistanceRemainingDisplayUnits);
   bResult = bResult && (bDistanceToNextManeuverAvailable == roRef.bDistanceToNextManeuverAvailable);
   bResult = bResult && (u32DistanceToNextManeuver == roRef.u32DistanceToNextManeuver);
   bResult = bResult && (bDistanceToNextManeuverDisplayStrAvailable == roRef.bDistanceToNextManeuverDisplayStrAvailable);
   bResult = bResult && (szDistanceToNextManeuverDisplayStr == roRef.szDistanceToNextManeuverDisplayStr);
   bResult = bResult && (bDistanceToNextManeuverDisplayUnitsAvailable == roRef.bDistanceToNextManeuverDisplayUnitsAvailable);
   bResult = bResult && (e8DistanceToNextManeuverDisplayUnits == roRef.e8DistanceToNextManeuverDisplayUnits);
   bResult = bResult && (bRouteGuidanceManeuverCurrentListAvailable == roRef.bRouteGuidanceManeuverCurrentListAvailable);
      bResult = bResult && (u16RouteGuidanceManeuverCurrentList.size() == roRef.u16RouteGuidanceManeuverCurrentList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u16RouteGuidanceManeuverCurrentList.size()); ++u32Idx)
            bResult = bResult && (u16RouteGuidanceManeuverCurrentList[u32Idx] == roRef.u16RouteGuidanceManeuverCurrentList[u32Idx]);
      }
   bResult = bResult && (bRouteGuidanceManeuverCountAvailable == roRef.bRouteGuidanceManeuverCountAvailable);
   bResult = bResult && (u16RouteGuidanceManeuverCount == roRef.u16RouteGuidanceManeuverCount);
   bResult = bResult && (bRouteGuidanceVisibleInAppAvailable == roRef.bRouteGuidanceVisibleInAppAvailable);
   bResult = bResult && (bIsRouteGuidanceVisibleInApp == roRef.bIsRouteGuidanceVisibleInApp);
   bResult = bResult && (bSourceNameAvailable == roRef.bSourceNameAvailable);
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (bSourceSupportsRouteGuidanceAvailable == roRef.bSourceSupportsRouteGuidanceAvailable);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_ProjectionVideoAttributes::midw_fi_tcl_ProjectionVideoAttributes(const midw_fi_tcl_ProjectionVideoAttributes& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   u16UIResolutionHeight = coRef.u16UIResolutionHeight;
   u16UIResolutionWidth = coRef.u16UIResolutionWidth;
}
midw_fi_tcl_ProjectionVideoAttributes& midw_fi_tcl_ProjectionVideoAttributes::operator=(const midw_fi_tcl_ProjectionVideoAttributes& coRef)
{
   if (this == &coRef) return *this;
   u16UIResolutionHeight = coRef.u16UIResolutionHeight;
   u16UIResolutionWidth = coRef.u16UIResolutionWidth;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_ProjectionVideoAttributes::midw_fi_tcl_ProjectionVideoAttributes()
:u16UIResolutionHeight(0)
,u16UIResolutionWidth(0)
 {}

tS32 midw_fi_tcl_ProjectionVideoAttributes::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_PROJECTIONVIDEOATTRIBUTES;
}


midw_fi_tcl_ProjectionVideoAttributes::~midw_fi_tcl_ProjectionVideoAttributes()
{}

tU32 midw_fi_tcl_ProjectionVideoAttributes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_ProjectionVideoAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UIResolutionHeight);
   (tVoid) (oIn >> u16UIResolutionWidth);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_ProjectionVideoAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UIResolutionHeight);
   (tVoid) (oOut << u16UIResolutionWidth);
   return oOut;
}

tBool midw_fi_tcl_ProjectionVideoAttributes::operator==(const midw_fi_tcl_ProjectionVideoAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UIResolutionHeight == roRef.u16UIResolutionHeight);
   bResult = bResult && (u16UIResolutionWidth == roRef.u16UIResolutionWidth);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DisplayContextReason::midw_fi_tcl_e8_DisplayContextReason():enType(FI_EN_DISPLAY_CONTEXT_REASON_UNKNOWN) {}

tS32 midw_fi_tcl_e8_DisplayContextReason::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISPLAYCONTEXTREASON;
}


midw_fi_tcl_e8_DisplayContextReason::~midw_fi_tcl_e8_DisplayContextReason()
{}

tU32 midw_fi_tcl_e8_DisplayContextReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DisplayContextReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DisplayContextReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MLGuidanceState::midw_fi_tcl_e8_MLGuidanceState():enType(FI_EN_UNKNOWN) {}

tS32 midw_fi_tcl_e8_MLGuidanceState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MLGUIDANCESTATE;
}


midw_fi_tcl_e8_MLGuidanceState::~midw_fi_tcl_e8_MLGuidanceState()
{}

tU32 midw_fi_tcl_e8_MLGuidanceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_MLGuidanceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MLGuidanceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MLGuidanceActive::midw_fi_tcl_e8_MLGuidanceActive():enType(FI_EN_GUIDANCE_CLIENT) {}

tS32 midw_fi_tcl_e8_MLGuidanceActive::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MLGUIDANCEACTIVE;
}


midw_fi_tcl_e8_MLGuidanceActive::~midw_fi_tcl_e8_MLGuidanceActive()
{}

tU32 midw_fi_tcl_e8_MLGuidanceActive::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e8_MLGuidanceActive::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MLGuidanceActive::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLNavigationInfoUpdate::midw_fi_tcl_MLNavigationInfoUpdate(const midw_fi_tcl_MLNavigationInfoUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   NavAppName = coRef.NavAppName;
   GuidanceState = coRef.GuidanceState;
   GuidanceActive = coRef.GuidanceActive;
   MetricSystem = coRef.MetricSystem;
   RightDriving = coRef.RightDriving;
}
midw_fi_tcl_MLNavigationInfoUpdate& midw_fi_tcl_MLNavigationInfoUpdate::operator=(const midw_fi_tcl_MLNavigationInfoUpdate& coRef)
{
   if (this == &coRef) return *this;
   NavAppName = coRef.NavAppName;
   GuidanceState = coRef.GuidanceState;
   GuidanceActive = coRef.GuidanceActive;
   MetricSystem = coRef.MetricSystem;
   RightDriving = coRef.RightDriving;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MLNavigationInfoUpdate::vDestroy()
{
   NavAppName.vDestroy();
}

midw_fi_tcl_MLNavigationInfoUpdate::midw_fi_tcl_MLNavigationInfoUpdate()
:NavAppName()
,GuidanceState()
,GuidanceActive()
,MetricSystem(0)
,RightDriving(0)
 {}

tS32 midw_fi_tcl_MLNavigationInfoUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLNAVIGATIONINFOUPDATE;
}


midw_fi_tcl_MLNavigationInfoUpdate::~midw_fi_tcl_MLNavigationInfoUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MLNavigationInfoUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+NavAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_MLNavigationInfoUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NavAppName);
   (tVoid) (oIn >> GuidanceState);
   (tVoid) (oIn >> GuidanceActive);
   (tVoid) (oIn >> MetricSystem);
   (tVoid) (oIn >> RightDriving);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLNavigationInfoUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavAppName);
   (tVoid) (oOut << GuidanceState);
   (tVoid) (oOut << GuidanceActive);
   (tVoid) (oOut << MetricSystem);
   (tVoid) (oOut << RightDriving);
   return oOut;
}

tBool midw_fi_tcl_MLNavigationInfoUpdate::operator==(const midw_fi_tcl_MLNavigationInfoUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavAppName == roRef.NavAppName);
   bResult = bResult && (GuidanceState == roRef.GuidanceState);
   bResult = bResult && (GuidanceActive == roRef.GuidanceActive);
   bResult = bResult && (MetricSystem == roRef.MetricSystem);
   bResult = bResult && (RightDriving == roRef.RightDriving);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_MLNextDirection::midw_fi_tcl_e8_MLNextDirection():enType(FI_EN_NO_SYMBOL) {}

tS32 midw_fi_tcl_e8_MLNextDirection::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_MLNEXTDIRECTION;
}


midw_fi_tcl_e8_MLNextDirection::~midw_fi_tcl_e8_MLNextDirection()
{}

tU32 midw_fi_tcl_e8_MLNextDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e8_MLNextDirection::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_MLNextDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLNavigationNextManeuverUpdate::midw_fi_tcl_MLNavigationNextManeuverUpdate(const midw_fi_tcl_MLNavigationNextManeuverUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   NextDirection = coRef.NextDirection;
   NextManeuverIndex = coRef.NextManeuverIndex;
   NextAngle = coRef.NextAngle;
   NextSideStreetAngles_1 = coRef.NextSideStreetAngles_1;
   NextSideStreetAngles_2 = coRef.NextSideStreetAngles_2;
   NextSideStreetAngles_3 = coRef.NextSideStreetAngles_3;
   NextStreetName = coRef.NextStreetName;
   CurrentStreetName = coRef.CurrentStreetName;
   NumOfSideStreetAngles_1 = coRef.NumOfSideStreetAngles_1;
   NumOfSideStreetAngles_2 = coRef.NumOfSideStreetAngles_2;
   NumOfSideStreetAngles_3 = coRef.NumOfSideStreetAngles_3;
}
midw_fi_tcl_MLNavigationNextManeuverUpdate& midw_fi_tcl_MLNavigationNextManeuverUpdate::operator=(const midw_fi_tcl_MLNavigationNextManeuverUpdate& coRef)
{
   if (this == &coRef) return *this;
   NextDirection = coRef.NextDirection;
   NextManeuverIndex = coRef.NextManeuverIndex;
   NextAngle = coRef.NextAngle;
   NextSideStreetAngles_1 = coRef.NextSideStreetAngles_1;
   NextSideStreetAngles_2 = coRef.NextSideStreetAngles_2;
   NextSideStreetAngles_3 = coRef.NextSideStreetAngles_3;
   NextStreetName = coRef.NextStreetName;
   CurrentStreetName = coRef.CurrentStreetName;
   NumOfSideStreetAngles_1 = coRef.NumOfSideStreetAngles_1;
   NumOfSideStreetAngles_2 = coRef.NumOfSideStreetAngles_2;
   NumOfSideStreetAngles_3 = coRef.NumOfSideStreetAngles_3;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MLNavigationNextManeuverUpdate::vDestroy()
{
   {
   NextSideStreetAngles_1.clear();
   }
   {
   NextSideStreetAngles_2.clear();
   }
   {
   NextSideStreetAngles_3.clear();
   }
   NextStreetName.vDestroy();
   CurrentStreetName.vDestroy();
}

midw_fi_tcl_MLNavigationNextManeuverUpdate::midw_fi_tcl_MLNavigationNextManeuverUpdate()
:NextDirection()
,NextManeuverIndex(0)
,NextAngle(0)



,NextStreetName()
,CurrentStreetName()
,NumOfSideStreetAngles_1(0)
,NumOfSideStreetAngles_2(0)
,NumOfSideStreetAngles_3(0)
 {}

tS32 midw_fi_tcl_MLNavigationNextManeuverUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLNAVIGATIONNEXTMANEUVERUPDATE;
}


midw_fi_tcl_MLNavigationNextManeuverUpdate::~midw_fi_tcl_MLNavigationNextManeuverUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MLNavigationNextManeuverUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 36+ static_cast<tU32>(NextSideStreetAngles_1.size()*4)+ static_cast<tU32>(NextSideStreetAngles_2.size()*4)+ static_cast<tU32>(NextSideStreetAngles_3.size()*4)+NextStreetName.u32GetSize(u16MajorVersion)+CurrentStreetName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_MLNavigationNextManeuverUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NextDirection);
   (tVoid) (oIn >> NextManeuverIndex);
   (tVoid) (oIn >> NextAngle);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NextSideStreetAngles_1.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NextSideStreetAngles_1[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NextSideStreetAngles_2.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NextSideStreetAngles_2[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NextSideStreetAngles_3.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NextSideStreetAngles_3[u32Idx]);
      }
   }
   (tVoid) (oIn >> NextStreetName);
   (tVoid) (oIn >> CurrentStreetName);
   (tVoid) (oIn >> NumOfSideStreetAngles_1);
   (tVoid) (oIn >> NumOfSideStreetAngles_2);
   (tVoid) (oIn >> NumOfSideStreetAngles_3);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLNavigationNextManeuverUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NextDirection);
   (tVoid) (oOut << NextManeuverIndex);
   (tVoid) (oOut << NextAngle);
   (tVoid) (oOut << (tU32)NextSideStreetAngles_1.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NextSideStreetAngles_1.size(); ++u32Idx)
         (tVoid) (oOut << NextSideStreetAngles_1[u32Idx]);
   }
   (tVoid) (oOut << (tU32)NextSideStreetAngles_2.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NextSideStreetAngles_2.size(); ++u32Idx)
         (tVoid) (oOut << NextSideStreetAngles_2[u32Idx]);
   }
   (tVoid) (oOut << (tU32)NextSideStreetAngles_3.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NextSideStreetAngles_3.size(); ++u32Idx)
         (tVoid) (oOut << NextSideStreetAngles_3[u32Idx]);
   }
   (tVoid) (oOut << NextStreetName);
   (tVoid) (oOut << CurrentStreetName);
   (tVoid) (oOut << NumOfSideStreetAngles_1);
   (tVoid) (oOut << NumOfSideStreetAngles_2);
   (tVoid) (oOut << NumOfSideStreetAngles_3);
   return oOut;
}

tBool midw_fi_tcl_MLNavigationNextManeuverUpdate::operator==(const midw_fi_tcl_MLNavigationNextManeuverUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NextDirection == roRef.NextDirection);
   bResult = bResult && (NextManeuverIndex == roRef.NextManeuverIndex);
   bResult = bResult && (NextAngle == roRef.NextAngle);
      bResult = bResult && (NextSideStreetAngles_1.size() == roRef.NextSideStreetAngles_1.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextSideStreetAngles_1.size()); ++u32Idx)
            bResult = bResult && (NextSideStreetAngles_1[u32Idx] == roRef.NextSideStreetAngles_1[u32Idx]);
      }
      bResult = bResult && (NextSideStreetAngles_2.size() == roRef.NextSideStreetAngles_2.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextSideStreetAngles_2.size()); ++u32Idx)
            bResult = bResult && (NextSideStreetAngles_2[u32Idx] == roRef.NextSideStreetAngles_2[u32Idx]);
      }
      bResult = bResult && (NextSideStreetAngles_3.size() == roRef.NextSideStreetAngles_3.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextSideStreetAngles_3.size()); ++u32Idx)
            bResult = bResult && (NextSideStreetAngles_3[u32Idx] == roRef.NextSideStreetAngles_3[u32Idx]);
      }
   bResult = bResult && (NextStreetName == roRef.NextStreetName);
   bResult = bResult && (CurrentStreetName == roRef.CurrentStreetName);
   bResult = bResult && (NumOfSideStreetAngles_1 == roRef.NumOfSideStreetAngles_1);
   bResult = bResult && (NumOfSideStreetAngles_2 == roRef.NumOfSideStreetAngles_2);
   bResult = bResult && (NumOfSideStreetAngles_3 == roRef.NumOfSideStreetAngles_3);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_DistanceUnit::midw_fi_tcl_e8_DistanceUnit():enType(FI_EN_DISTANCE_UNIT_METER) {}

tS32 midw_fi_tcl_e8_DistanceUnit::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_DISTANCEUNIT;
}


midw_fi_tcl_e8_DistanceUnit::~midw_fi_tcl_e8_DistanceUnit()
{}

tU32 midw_fi_tcl_e8_DistanceUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_DistanceUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_DistanceUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLNavigationNextDistanceUpdate::midw_fi_tcl_MLNavigationNextDistanceUpdate(const midw_fi_tcl_MLNavigationNextDistanceUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
   Time = coRef.Time;
   Percentage = coRef.Percentage;
}
midw_fi_tcl_MLNavigationNextDistanceUpdate& midw_fi_tcl_MLNavigationNextDistanceUpdate::operator=(const midw_fi_tcl_MLNavigationNextDistanceUpdate& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
   Time = coRef.Time;
   Percentage = coRef.Percentage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MLNavigationNextDistanceUpdate::midw_fi_tcl_MLNavigationNextDistanceUpdate()
:Distance(0)
,DistanceUnit()
,Time(0)
,Percentage(0)
 {}

tS32 midw_fi_tcl_MLNavigationNextDistanceUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLNAVIGATIONNEXTDISTANCEUPDATE;
}


midw_fi_tcl_MLNavigationNextDistanceUpdate::~midw_fi_tcl_MLNavigationNextDistanceUpdate()
{}

tU32 midw_fi_tcl_MLNavigationNextDistanceUpdate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& midw_fi_tcl_MLNavigationNextDistanceUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> DistanceUnit);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Percentage);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLNavigationNextDistanceUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << DistanceUnit);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Percentage);
   return oOut;
}

tBool midw_fi_tcl_MLNavigationNextDistanceUpdate::operator==(const midw_fi_tcl_MLNavigationNextDistanceUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (DistanceUnit == roRef.DistanceUnit);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Percentage == roRef.Percentage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLNavigationLaneGuidanceUpdate::midw_fi_tcl_MLNavigationLaneGuidanceUpdate(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   NextLaneGuidances = coRef.NextLaneGuidances;
   NumOfLaneGuidances = coRef.NumOfLaneGuidances;
}
midw_fi_tcl_MLNavigationLaneGuidanceUpdate& midw_fi_tcl_MLNavigationLaneGuidanceUpdate::operator=(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& coRef)
{
   if (this == &coRef) return *this;
   NextLaneGuidances = coRef.NextLaneGuidances;
   NumOfLaneGuidances = coRef.NumOfLaneGuidances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MLNavigationLaneGuidanceUpdate::vDestroy()
{
   {
   NextLaneGuidances.clear();
   }
}

midw_fi_tcl_MLNavigationLaneGuidanceUpdate::midw_fi_tcl_MLNavigationLaneGuidanceUpdate()

:NumOfLaneGuidances(0)
 {}

tS32 midw_fi_tcl_MLNavigationLaneGuidanceUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLNAVIGATIONLANEGUIDANCEUPDATE;
}


midw_fi_tcl_MLNavigationLaneGuidanceUpdate::~midw_fi_tcl_MLNavigationLaneGuidanceUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MLNavigationLaneGuidanceUpdate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(NextLaneGuidances.size()*4);
}

fi_tclInContext& midw_fi_tcl_MLNavigationLaneGuidanceUpdate::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NextLaneGuidances.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NextLaneGuidances[u32Idx]);
      }
   }
   (tVoid) (oIn >> NumOfLaneGuidances);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLNavigationLaneGuidanceUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)NextLaneGuidances.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NextLaneGuidances.size(); ++u32Idx)
         (tVoid) (oOut << NextLaneGuidances[u32Idx]);
   }
   (tVoid) (oOut << NumOfLaneGuidances);
   return oOut;
}

tBool midw_fi_tcl_MLNavigationLaneGuidanceUpdate::operator==(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (NextLaneGuidances.size() == roRef.NextLaneGuidances.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NextLaneGuidances.size()); ++u32Idx)
            bResult = bResult && (NextLaneGuidances[u32Idx] == roRef.NextLaneGuidances[u32Idx]);
      }
   bResult = bResult && (NumOfLaneGuidances == roRef.NumOfLaneGuidances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLNavigationTripInfoUpdate::midw_fi_tcl_MLNavigationTripInfoUpdate(const midw_fi_tcl_MLNavigationTripInfoUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   Destination = coRef.Destination;
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
   RemainingTravelTime = coRef.RemainingTravelTime;
   RemainingTrafficTime = coRef.RemainingTrafficTime;
}
midw_fi_tcl_MLNavigationTripInfoUpdate& midw_fi_tcl_MLNavigationTripInfoUpdate::operator=(const midw_fi_tcl_MLNavigationTripInfoUpdate& coRef)
{
   if (this == &coRef) return *this;
   Destination = coRef.Destination;
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
   RemainingTravelTime = coRef.RemainingTravelTime;
   RemainingTrafficTime = coRef.RemainingTrafficTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MLNavigationTripInfoUpdate::vDestroy()
{
   Destination.vDestroy();
}

midw_fi_tcl_MLNavigationTripInfoUpdate::midw_fi_tcl_MLNavigationTripInfoUpdate()
:Destination()
,Distance(0)
,DistanceUnit()
,RemainingTravelTime(0)
,RemainingTrafficTime(0)
 {}

tS32 midw_fi_tcl_MLNavigationTripInfoUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLNAVIGATIONTRIPINFOUPDATE;
}


midw_fi_tcl_MLNavigationTripInfoUpdate::~midw_fi_tcl_MLNavigationTripInfoUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MLNavigationTripInfoUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 21+Destination.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_MLNavigationTripInfoUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Destination);
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> DistanceUnit);
   (tVoid) (oIn >> RemainingTravelTime);
   (tVoid) (oIn >> RemainingTrafficTime);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLNavigationTripInfoUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Destination);
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << DistanceUnit);
   (tVoid) (oOut << RemainingTravelTime);
   (tVoid) (oOut << RemainingTrafficTime);
   return oOut;
}

tBool midw_fi_tcl_MLNavigationTripInfoUpdate::operator==(const midw_fi_tcl_MLNavigationTripInfoUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Destination == roRef.Destination);
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (DistanceUnit == roRef.DistanceUnit);
   bResult = bResult && (RemainingTravelTime == roRef.RemainingTravelTime);
   bResult = bResult && (RemainingTrafficTime == roRef.RemainingTrafficTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLSpeedLimitUpdate::midw_fi_tcl_MLSpeedLimitUpdate(const midw_fi_tcl_MLSpeedLimitUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   CurrentSpeedLimit = coRef.CurrentSpeedLimit;
   NextSpeedLimit = coRef.NextSpeedLimit;
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
}
midw_fi_tcl_MLSpeedLimitUpdate& midw_fi_tcl_MLSpeedLimitUpdate::operator=(const midw_fi_tcl_MLSpeedLimitUpdate& coRef)
{
   if (this == &coRef) return *this;
   CurrentSpeedLimit = coRef.CurrentSpeedLimit;
   NextSpeedLimit = coRef.NextSpeedLimit;
   Distance = coRef.Distance;
   DistanceUnit = coRef.DistanceUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_MLSpeedLimitUpdate::midw_fi_tcl_MLSpeedLimitUpdate()
:CurrentSpeedLimit(0)
,NextSpeedLimit(0)
,Distance(0)
,DistanceUnit()
 {}

tS32 midw_fi_tcl_MLSpeedLimitUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLSPEEDLIMITUPDATE;
}


midw_fi_tcl_MLSpeedLimitUpdate::~midw_fi_tcl_MLSpeedLimitUpdate()
{}

tU32 midw_fi_tcl_MLSpeedLimitUpdate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_fi_tcl_MLSpeedLimitUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentSpeedLimit);
   (tVoid) (oIn >> NextSpeedLimit);
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> DistanceUnit);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLSpeedLimitUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentSpeedLimit);
   (tVoid) (oOut << NextSpeedLimit);
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << DistanceUnit);
   return oOut;
}

tBool midw_fi_tcl_MLSpeedLimitUpdate::operator==(const midw_fi_tcl_MLSpeedLimitUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentSpeedLimit == roRef.CurrentSpeedLimit);
   bResult = bResult && (NextSpeedLimit == roRef.NextSpeedLimit);
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (DistanceUnit == roRef.DistanceUnit);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_MLTBTUpdate::midw_fi_tcl_MLTBTUpdate(const midw_fi_tcl_MLTBTUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   MLNavigationInfoUpdate = coRef.MLNavigationInfoUpdate;
   isMLNavigationInfoUpdateValid = coRef.isMLNavigationInfoUpdateValid;
   MLNavigationNextManeuverUpdate = coRef.MLNavigationNextManeuverUpdate;
   isMLNavigationNextManeuverUpdateValid = coRef.isMLNavigationNextManeuverUpdateValid;
   MLSpeedLimitUpdate = coRef.MLSpeedLimitUpdate;
   isMLSpeedLimitUpdateValid = coRef.isMLSpeedLimitUpdateValid;
   MLNavigationNextDistanceUpdate = coRef.MLNavigationNextDistanceUpdate;
   isMLNavigationNextDistanceUpdateValid = coRef.isMLNavigationNextDistanceUpdateValid;
   MLNavigationLaneGuidanceUpdate = coRef.MLNavigationLaneGuidanceUpdate;
   isMLNavigationLaneGuidanceUpdateValid = coRef.isMLNavigationLaneGuidanceUpdateValid;
   MLNavigationTripInfoUpdate = coRef.MLNavigationTripInfoUpdate;
   isMLNavigationTripInfoUpdateValid = coRef.isMLNavigationTripInfoUpdateValid;
}
midw_fi_tcl_MLTBTUpdate& midw_fi_tcl_MLTBTUpdate::operator=(const midw_fi_tcl_MLTBTUpdate& coRef)
{
   if (this == &coRef) return *this;
   MLNavigationInfoUpdate = coRef.MLNavigationInfoUpdate;
   isMLNavigationInfoUpdateValid = coRef.isMLNavigationInfoUpdateValid;
   MLNavigationNextManeuverUpdate = coRef.MLNavigationNextManeuverUpdate;
   isMLNavigationNextManeuverUpdateValid = coRef.isMLNavigationNextManeuverUpdateValid;
   MLSpeedLimitUpdate = coRef.MLSpeedLimitUpdate;
   isMLSpeedLimitUpdateValid = coRef.isMLSpeedLimitUpdateValid;
   MLNavigationNextDistanceUpdate = coRef.MLNavigationNextDistanceUpdate;
   isMLNavigationNextDistanceUpdateValid = coRef.isMLNavigationNextDistanceUpdateValid;
   MLNavigationLaneGuidanceUpdate = coRef.MLNavigationLaneGuidanceUpdate;
   isMLNavigationLaneGuidanceUpdateValid = coRef.isMLNavigationLaneGuidanceUpdateValid;
   MLNavigationTripInfoUpdate = coRef.MLNavigationTripInfoUpdate;
   isMLNavigationTripInfoUpdateValid = coRef.isMLNavigationTripInfoUpdateValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_fi_tcl_MLTBTUpdate::vDestroy()
{
   MLNavigationInfoUpdate.vDestroy(); 
   MLNavigationNextManeuverUpdate.vDestroy(); 
   MLSpeedLimitUpdate.vDestroy(); 
   MLNavigationNextDistanceUpdate.vDestroy(); 
   MLNavigationLaneGuidanceUpdate.vDestroy(); 
   MLNavigationTripInfoUpdate.vDestroy(); 
}

midw_fi_tcl_MLTBTUpdate::midw_fi_tcl_MLTBTUpdate()
:MLNavigationInfoUpdate()
,isMLNavigationInfoUpdateValid(0)
,MLNavigationNextManeuverUpdate()
,isMLNavigationNextManeuverUpdateValid(0)
,MLSpeedLimitUpdate()
,isMLSpeedLimitUpdateValid(0)
,MLNavigationNextDistanceUpdate()
,isMLNavigationNextDistanceUpdateValid(0)
,MLNavigationLaneGuidanceUpdate()
,isMLNavigationLaneGuidanceUpdateValid(0)
,MLNavigationTripInfoUpdate()
,isMLNavigationTripInfoUpdateValid(0)
 {}

tS32 midw_fi_tcl_MLTBTUpdate::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_MLTBTUPDATE;
}


midw_fi_tcl_MLTBTUpdate::~midw_fi_tcl_MLTBTUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_fi_tcl_MLTBTUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 36+MLNavigationInfoUpdate.u32GetSize(u16MajorVersion)+MLNavigationNextManeuverUpdate.u32GetSize(u16MajorVersion)+MLNavigationLaneGuidanceUpdate.u32GetSize(u16MajorVersion)+MLNavigationTripInfoUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_fi_tcl_MLTBTUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MLNavigationInfoUpdate);
   (tVoid) (oIn >> isMLNavigationInfoUpdateValid);
   (tVoid) (oIn >> MLNavigationNextManeuverUpdate);
   (tVoid) (oIn >> isMLNavigationNextManeuverUpdateValid);
   (tVoid) (oIn >> MLSpeedLimitUpdate);
   (tVoid) (oIn >> isMLSpeedLimitUpdateValid);
   (tVoid) (oIn >> MLNavigationNextDistanceUpdate);
   (tVoid) (oIn >> isMLNavigationNextDistanceUpdateValid);
   (tVoid) (oIn >> MLNavigationLaneGuidanceUpdate);
   (tVoid) (oIn >> isMLNavigationLaneGuidanceUpdateValid);
   (tVoid) (oIn >> MLNavigationTripInfoUpdate);
   (tVoid) (oIn >> isMLNavigationTripInfoUpdateValid);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_MLTBTUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MLNavigationInfoUpdate);
   (tVoid) (oOut << isMLNavigationInfoUpdateValid);
   (tVoid) (oOut << MLNavigationNextManeuverUpdate);
   (tVoid) (oOut << isMLNavigationNextManeuverUpdateValid);
   (tVoid) (oOut << MLSpeedLimitUpdate);
   (tVoid) (oOut << isMLSpeedLimitUpdateValid);
   (tVoid) (oOut << MLNavigationNextDistanceUpdate);
   (tVoid) (oOut << isMLNavigationNextDistanceUpdateValid);
   (tVoid) (oOut << MLNavigationLaneGuidanceUpdate);
   (tVoid) (oOut << isMLNavigationLaneGuidanceUpdateValid);
   (tVoid) (oOut << MLNavigationTripInfoUpdate);
   (tVoid) (oOut << isMLNavigationTripInfoUpdateValid);
   return oOut;
}

tBool midw_fi_tcl_MLTBTUpdate::operator==(const midw_fi_tcl_MLTBTUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MLNavigationInfoUpdate == roRef.MLNavigationInfoUpdate);
   bResult = bResult && (isMLNavigationInfoUpdateValid == roRef.isMLNavigationInfoUpdateValid);
   bResult = bResult && (MLNavigationNextManeuverUpdate == roRef.MLNavigationNextManeuverUpdate);
   bResult = bResult && (isMLNavigationNextManeuverUpdateValid == roRef.isMLNavigationNextManeuverUpdateValid);
   bResult = bResult && (MLSpeedLimitUpdate == roRef.MLSpeedLimitUpdate);
   bResult = bResult && (isMLSpeedLimitUpdateValid == roRef.isMLSpeedLimitUpdateValid);
   bResult = bResult && (MLNavigationNextDistanceUpdate == roRef.MLNavigationNextDistanceUpdate);
   bResult = bResult && (isMLNavigationNextDistanceUpdateValid == roRef.isMLNavigationNextDistanceUpdateValid);
   bResult = bResult && (MLNavigationLaneGuidanceUpdate == roRef.MLNavigationLaneGuidanceUpdate);
   bResult = bResult && (isMLNavigationLaneGuidanceUpdateValid == roRef.isMLNavigationLaneGuidanceUpdateValid);
   bResult = bResult && (MLNavigationTripInfoUpdate == roRef.MLNavigationTripInfoUpdate);
   bResult = bResult && (isMLNavigationTripInfoUpdateValid == roRef.isMLNavigationTripInfoUpdateValid);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e32_Language::midw_fi_tcl_e32_Language():enType(FI_EN_LANGUAGE_UNKNOWN) {}

tS32 midw_fi_tcl_e32_Language::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E32_LANGUAGE;
}


midw_fi_tcl_e32_Language::~midw_fi_tcl_e32_Language()
{}

tU32 midw_fi_tcl_e32_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_fi_tcl_e32_Language::oRead(fi_tclInContext& oIn)
{
   tS32 s32Value;
   (tVoid) (oIn >> s32Value);
   enType = (tenType)s32Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e32_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tS32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8_VehiclePowerModeState::midw_fi_tcl_e8_VehiclePowerModeState():enType(FI_EN_SLEEP) {}

tS32 midw_fi_tcl_e8_VehiclePowerModeState::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8_VEHICLEPOWERMODESTATE;
}


midw_fi_tcl_e8_VehiclePowerModeState::~midw_fi_tcl_e8_VehiclePowerModeState()
{}

tU32 midw_fi_tcl_e8_VehiclePowerModeState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8_VehiclePowerModeState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8_VehiclePowerModeState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_AmbientColourData::midw_fi_tcl_AmbientColourData(const midw_fi_tcl_AmbientColourData& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   fRed = coRef.fRed;
   fGreen = coRef.fGreen;
   fBlue = coRef.fBlue;
   fAlpha = coRef.fAlpha;
}
midw_fi_tcl_AmbientColourData& midw_fi_tcl_AmbientColourData::operator=(const midw_fi_tcl_AmbientColourData& coRef)
{
   if (this == &coRef) return *this;
   fRed = coRef.fRed;
   fGreen = coRef.fGreen;
   fBlue = coRef.fBlue;
   fAlpha = coRef.fAlpha;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_AmbientColourData::midw_fi_tcl_AmbientColourData()
:fRed(0)
,fGreen(0)
,fBlue(0)
,fAlpha(0)
 {}

tS32 midw_fi_tcl_AmbientColourData::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_AMBIENTCOLOURDATA;
}


midw_fi_tcl_AmbientColourData::~midw_fi_tcl_AmbientColourData()
{}

tU32 midw_fi_tcl_AmbientColourData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_fi_tcl_AmbientColourData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> fRed);
   (tVoid) (oIn >> fGreen);
   (tVoid) (oIn >> fBlue);
   (tVoid) (oIn >> fAlpha);
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_AmbientColourData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << fRed);
   (tVoid) (oOut << fGreen);
   (tVoid) (oOut << fBlue);
   (tVoid) (oOut << fAlpha);
   return oOut;
}

tBool midw_fi_tcl_AmbientColourData::operator==(const midw_fi_tcl_AmbientColourData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (fRed == roRef.fRed);
   bResult = bResult && (fGreen == roRef.fGreen);
   bResult = bResult && (fBlue == roRef.fBlue);
   bResult = bResult && (fAlpha == roRef.fAlpha);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_fi_tcl_e8Media_AppCategory::midw_fi_tcl_e8Media_AppCategory():enType(FI_EN_MEDIA_APP_TYPE_RADIO) {}

tS32 midw_fi_tcl_e8Media_AppCategory::s32GetTypeId() const
{
   return (tS32) midw_typesfi_tclToken::EN_E8MEDIA_APPCATEGORY;
}


midw_fi_tcl_e8Media_AppCategory::~midw_fi_tcl_e8Media_AppCategory()
{}

tU32 midw_fi_tcl_e8Media_AppCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_fi_tcl_e8Media_AppCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& midw_fi_tcl_e8Media_AppCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate::midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate(const midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& coRef)
   : midw_fi_tclVisitableTypeBase(coRef)
{
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bIndexAvailable = coRef.bIndexAvailable;
   u16Index = coRef.u16Index;
   bManeuverDescriptionAvailable = coRef.bManeuverDescriptionAvailable;
   szManeuverDescription = coRef.szManeuverDescription;
   bManeuverTypeAvailable = coRef.bManeuverTypeAvailable;
   e8ManeuverType = coRef.e8ManeuverType;
   bAfterManeuverRoadNameAvailable = coRef.bAfterManeuverRoadNameAvailable;
   szAfterManeuverRoadName = coRef.szAfterManeuverRoadName;
   bDistanceBetweenManeuverAvailable = coRef.bDistanceBetweenManeuverAvailable;
   u32DistanceBetweenManeuver = coRef.u32DistanceBetweenManeuver;
   bDistanceBetweenManeuverDisplayStrAvailable = coRef.bDistanceBetweenManeuverDisplayStrAvailable;
   szDistanceBetweenManeuverDisplayStr = coRef.szDistanceBetweenManeuverDisplayStr;
   bDistanceBetweenManeuverDisplayUnitsAvailable = coRef.bDistanceBetweenManeuverDisplayUnitsAvailable;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   bDrivingSideAvailable = coRef.bDrivingSideAvailable;
   e8DrivingSide = coRef.e8DrivingSide;
   bJunctionTypeAvailable = coRef.bJunctionTypeAvailable;
   e8JunctionType = coRef.e8JunctionType;
   bJunctionElementAngleAvailable = coRef.bJunctionElementAngleAvailable;
   s16JunctionElementAngleList = coRef.s16JunctionElementAngleList;
   bJunctionElementExitAngleAvailable = coRef.bJunctionElementExitAngleAvailable;
   s16JunctionElementExitAngle = coRef.s16JunctionElementExitAngle;
}
midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate::operator=(const midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& coRef)
{
   if (this == &coRef) return *this;
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bIndexAvailable = coRef.bIndexAvailable;
   u16Index = coRef.u1