#ifndef MIDW_FIVISITOR_HEADER
#define MIDW_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class midw_fi_tclOutput {
public:
   midw_fi_tclOutput();
   virtual ~midw_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class midw_fi_tclFileOutput : public midw_fi_tclOutput 
{
public:
   midw_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   midw_fi_tclFileOutput(); //lint !e1704
   midw_fi_tclFileOutput& operator=(const midw_fi_tclFileOutput& coRef);
   midw_fi_tclFileOutput(const midw_fi_tclFileOutput& coRef); //lint !e1704
};

class midw_fi_tclMemOutput : public midw_fi_tclOutput
{
public:
   midw_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~midw_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   midw_fi_tclMemOutput(); //lint !e1704
   midw_fi_tclMemOutput(const midw_fi_tclMemOutput& coRef); //lint !e1704
   midw_fi_tclMemOutput& operator=(const midw_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL midw_fi_tclVisitorBase {
public:

   // --Konstruktor
   midw_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~midw_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_fi_tclS64& oS64);
   virtual tVoid vVisitF32(midw_fi_tclF32& oF32);
   virtual tVoid vVisitF64(midw_fi_tclF64& oF64);
   virtual tVoid vVisitBool(midw_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(midw_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(midw_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(midw_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(midw_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(midw_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(midw_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(midw_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(midw_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(midw_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(midw_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(midw_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(midw_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(midw_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(midw_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(midw_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(midw_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(midw_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(midw_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(midw_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(midw_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(midw_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(midw_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(midw_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(midw_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(midw_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(midw_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(midw_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(midw_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(midw_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(midw_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(midw_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(midw_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(midw_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(midw_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(midw_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(midw_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(midw_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(midw_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(midw_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(midw_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(midw_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(midw_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(midw_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(midw_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(midw_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(midw_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(midw_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(midw_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_u8TstSrvATestResult(midw_fi_tcl_u8TstSrvATestResult& ou8TstSrvATestResult);

   virtual tVoid vVisit_u16TstSrvAEnumeration2(midw_fi_tcl_u16TstSrvAEnumeration2& ou16TstSrvAEnumeration2);

   virtual tVoid vVisit_TstSrvB_u8Enumeration1(midw_fi_tcl_TstSrvB_u8Enumeration1& oTstSrvB_u8Enumeration1);

   virtual tVoid vVisit_TstSrvB_u16Enumeration2(midw_fi_tcl_TstSrvB_u16Enumeration2& oTstSrvB_u16Enumeration2);

   virtual tVoid vVisit_u8TstSrvCTestResult(midw_fi_tcl_u8TstSrvCTestResult& ou8TstSrvCTestResult);

   virtual tVoid vVisit_u16TstSrvCEnumeration2(midw_fi_tcl_u16TstSrvCEnumeration2& ou16TstSrvCEnumeration2);

   virtual tVoid vVisit_TstSrvD_u8Enumeration1(midw_fi_tcl_TstSrvD_u8Enumeration1& oTstSrvD_u8Enumeration1);

   virtual tVoid vVisit_TstSrvD_u16Enumeration2(midw_fi_tcl_TstSrvD_u16Enumeration2& oTstSrvD_u16Enumeration2);

   virtual tVoid vVisit_e16_iPodAuthSelfTestResult(midw_fi_tcl_e16_iPodAuthSelfTestResult& oe16_iPodAuthSelfTestResult);

   virtual tVoid vVisit_e8_Tun_SubCommand(midw_fi_tcl_e8_Tun_SubCommand& oe8_Tun_SubCommand);

   virtual tVoid vVisit_e8_Tun_AudioSink(midw_fi_tcl_e8_Tun_AudioSink& oe8_Tun_AudioSink);

   virtual tVoid vVisit_e8_Tun_MTCAudioSource(midw_fi_tcl_e8_Tun_MTCAudioSource& oe8_Tun_MTCAudioSource);

   virtual tVoid vVisit_Tun_UserProfileAction(midw_fi_tcl_Tun_UserProfileAction& oTun_UserProfileAction);

   virtual tVoid vVisit_b8_Tun_AFSwitch(midw_fi_tcl_b8_Tun_AFSwitch& ob8_Tun_AFSwitch);

   virtual tVoid vVisit_b8_Tun_AudioSink(midw_fi_tcl_b8_Tun_AudioSink& ob8_Tun_AudioSink);

   virtual tVoid vVisit_b8_Tun_AtStationInfoBits(midw_fi_tcl_b8_Tun_AtStationInfoBits& ob8_Tun_AtStationInfoBits);

   virtual tVoid vVisit_b8_Tun_Tunerbandbits(midw_fi_tcl_b8_Tun_Tunerbandbits& ob8_Tun_Tunerbandbits);

   virtual tVoid vVisit_Audio_FG_BG(midw_fi_tcl_Audio_FG_BG& oAudio_FG_BG);

   virtual tVoid vVisit_e8_Tun_Client(midw_fi_tcl_e8_Tun_Client& oe8_Tun_Client);

   virtual tVoid vVisit_u16CalibrationData(midw_fi_tcl_u16CalibrationData& ou16CalibrationData);

   virtual tVoid vVisit_e8_Tun_TunerHeader(midw_fi_tcl_e8_Tun_TunerHeader& oe8_Tun_TunerHeader);

   virtual tVoid vVisit_AudFGBGStatus(midw_fi_tcl_AudFGBGStatus& oAudFGBGStatus);

   virtual tVoid vVisit_e8_Tun_ResponseStatus(midw_fi_tcl_e8_Tun_ResponseStatus& oe8_Tun_ResponseStatus);

   virtual tVoid vVisit_e8_Tun_ResponseState(midw_fi_tcl_e8_Tun_ResponseState& oe8_Tun_ResponseState);

   virtual tVoid vVisit_TunerServer_StatusResponse(midw_fi_tcl_TunerServer_StatusResponse& oTunerServer_StatusResponse);

   virtual tVoid vVisit_e8_Tun_TunerSeek(midw_fi_tcl_e8_Tun_TunerSeek& oe8_Tun_TunerSeek);

   virtual tVoid vVisit_e8_Tun_PhysicalTuner(midw_fi_tcl_e8_Tun_PhysicalTuner& oe8_Tun_PhysicalTuner);

   virtual tVoid vVisit_e8_Tun_TunerBand(midw_fi_tcl_e8_Tun_TunerBand& oe8_Tun_TunerBand);

   virtual tVoid vVisit_Aud_FGBG_New(midw_fi_tcl_Aud_FGBG_New& oAud_FGBG_New);

   virtual tVoid vVisit_e8_Tun_Testmode_TunerBand(midw_fi_tcl_e8_Tun_Testmode_TunerBand& oe8_Tun_Testmode_TunerBand);

   virtual tVoid vVisit_e8_Tun_TunerAutostore(midw_fi_tcl_e8_Tun_TunerAutostore& oe8_Tun_TunerAutostore);

   virtual tVoid vVisit_e8_Tun_TunerMode(midw_fi_tcl_e8_Tun_TunerMode& oe8_Tun_TunerMode);

   virtual tVoid vVisit_e8_Tun_TunerState(midw_fi_tcl_e8_Tun_TunerState& oe8_Tun_TunerState);

   virtual tVoid vVisit_e8_Tun_Announcement(midw_fi_tcl_e8_Tun_Announcement& oe8_Tun_Announcement);

   virtual tVoid vVisit_b32_Tun_AvailFlags(midw_fi_tcl_b32_Tun_AvailFlags& ob32_Tun_AvailFlags);

   virtual tVoid vVisit_e8_Tun_StaticListID(midw_fi_tcl_e8_Tun_StaticListID& oe8_Tun_StaticListID);

   virtual tVoid vVisit_e8_Tun_MixedpresetListID(midw_fi_tcl_e8_Tun_MixedpresetListID& oe8_Tun_MixedpresetListID);

   virtual tVoid vVisit_b32_Tun_Features(midw_fi_tcl_b32_Tun_Features& ob32_Tun_Features);

   virtual tVoid vVisit_b8_Tun_Antenna(midw_fi_tcl_b8_Tun_Antenna& ob8_Tun_Antenna);

   virtual tVoid vVisit_TunerStationData(midw_fi_tcl_TunerStationData& oTunerStationData);

   virtual tVoid vVisit_TunerFeature(midw_fi_tcl_TunerFeature& oTunerFeature);

   virtual tVoid vVisit_b32_Tun_AvailableFlags(midw_fi_tcl_b32_Tun_AvailableFlags& ob32_Tun_AvailableFlags);

   virtual tVoid vVisit_e8_Tun_ManualFreqAdjustment(midw_fi_tcl_e8_Tun_ManualFreqAdjustment& oe8_Tun_ManualFreqAdjustment);

   virtual tVoid vVisit_e8_Tun_AcceptAF(midw_fi_tcl_e8_Tun_AcceptAF& oe8_Tun_AcceptAF);

   virtual tVoid vVisit_TunerManualSingleStep(midw_fi_tcl_TunerManualSingleStep& oTunerManualSingleStep);

   virtual tVoid vVisit_e8_Tun_TunerStaticList(midw_fi_tcl_e8_Tun_TunerStaticList& oe8_Tun_TunerStaticList);

   virtual tVoid vVisit_e8_Tun_TunerMixedpresetList(midw_fi_tcl_e8_Tun_TunerMixedpresetList& oe8_Tun_TunerMixedpresetList);

   virtual tVoid vVisit_e8_Tun_EnableOrDisable(midw_fi_tcl_e8_Tun_EnableOrDisable& oe8_Tun_EnableOrDisable);

   virtual tVoid vVisit_e8_Tun_OperationFlags(midw_fi_tcl_e8_Tun_OperationFlags& oe8_Tun_OperationFlags);

   virtual tVoid vVisit_b8_Tun_OperationFlags(midw_fi_tcl_b8_Tun_OperationFlags& ob8_Tun_OperationFlags);

   virtual tVoid vVisit_TunerOperation(midw_fi_tcl_TunerOperation& oTunerOperation);

   virtual tVoid vVisit_e8_Tun_AFInformation(midw_fi_tcl_e8_Tun_AFInformation& oe8_Tun_AFInformation);

   virtual tVoid vVisit_e8_Tun_Notification(midw_fi_tcl_e8_Tun_Notification& oe8_Tun_Notification);

   virtual tVoid vVisit_TunerAFList(midw_fi_tcl_TunerAFList& oTunerAFList);

   virtual tVoid vVisit_e8_Tun_AdditionalInfo(midw_fi_tcl_e8_Tun_AdditionalInfo& oe8_Tun_AdditionalInfo);

   virtual tVoid vVisit_b8_Tun_TestmodeBits(midw_fi_tcl_b8_Tun_TestmodeBits& ob8_Tun_TestmodeBits);

   virtual tVoid vVisit_e8_Tuner_Mode(midw_fi_tcl_e8_Tuner_Mode& oe8_Tuner_Mode);

   virtual tVoid vVisit_e8_DDADDS_Mode(midw_fi_tcl_e8_DDADDS_Mode& oe8_DDADDS_Mode);

   virtual tVoid vVisit_e8_Tun_TMCGroupState(midw_fi_tcl_e8_Tun_TMCGroupState& oe8_Tun_TMCGroupState);

   virtual tVoid vVisit_e8_Tun_AntennaState(midw_fi_tcl_e8_Tun_AntennaState& oe8_Tun_AntennaState);

   virtual tVoid vVisit_e8_Tun_IfState(midw_fi_tcl_e8_Tun_IfState& oe8_Tun_IfState);

   virtual tVoid vVisit_TunerTestModeData(midw_fi_tcl_TunerTestModeData& oTunerTestModeData);

   virtual tVoid vVisit_e8_Tun_ListType(midw_fi_tcl_e8_Tun_ListType& oe8_Tun_ListType);

   virtual tVoid vVisit_e8_Tun_ConfigListID(midw_fi_tcl_e8_Tun_ConfigListID& oe8_Tun_ConfigListID);

   virtual tVoid vVisit_e8_Tun_Config_Filters(midw_fi_tcl_e8_Tun_Config_Filters& oe8_Tun_Config_Filters);

   virtual tVoid vVisit_e8_Tun_SortingCriteria(midw_fi_tcl_e8_Tun_SortingCriteria& oe8_Tun_SortingCriteria);

   virtual tVoid vVisit_e8_Tun_ModulationType(midw_fi_tcl_e8_Tun_ModulationType& oe8_Tun_ModulationType);

   virtual tVoid vVisit_b8_Tun_Digital_Filters(midw_fi_tcl_b8_Tun_Digital_Filters& ob8_Tun_Digital_Filters);

   virtual tVoid vVisit_e16_TmcApplicationId(midw_fi_tcl_e16_TmcApplicationId& oe16_TmcApplicationId);

   virtual tVoid vVisit_Encryption(midw_fi_tcl_Encryption& oEncryption);

   virtual tVoid vVisit_e8_TmcMediumType(midw_fi_tcl_e8_TmcMediumType& oe8_TmcMediumType);

   virtual tVoid vVisit_MsgSource(midw_fi_tcl_MsgSource& oMsgSource);

   virtual tVoid vVisit_Tun_RDBID_Value(midw_fi_tcl_Tun_RDBID_Value& oTun_RDBID_Value);

   virtual tVoid vVisit_TunerRdbId(midw_fi_tcl_TunerRdbId& oTunerRdbId);

   virtual tVoid vVisit_TunerGetDataTMC(midw_fi_tcl_TunerGetDataTMC& oTunerGetDataTMC);

   virtual tVoid vVisit_TrafficInfo(midw_fi_tcl_TrafficInfo& oTrafficInfo);

   virtual tVoid vVisit_b8_Tun_PackedInfo(midw_fi_tcl_b8_Tun_PackedInfo& ob8_Tun_PackedInfo);

   virtual tVoid vVisit_MakeConfigListElem(midw_fi_tcl_MakeConfigListElem& oMakeConfigListElem);

   virtual tVoid vVisit_b8_Tun_AvailFlags(midw_fi_tcl_b8_Tun_AvailFlags& ob8_Tun_AvailFlags);

   virtual tVoid vVisit_e8_Tun_HD_TextEncodingType(midw_fi_tcl_e8_Tun_HD_TextEncodingType& oe8_Tun_HD_TextEncodingType);

   virtual tVoid vVisit_b8_Tun_StationInfo(midw_fi_tcl_b8_Tun_StationInfo& ob8_Tun_StationInfo);

   virtual tVoid vVisit_e8_Tun_SendernameInfo(midw_fi_tcl_e8_Tun_SendernameInfo& oe8_Tun_SendernameInfo);

   virtual tVoid vVisit_Sel_List_Elem(midw_fi_tcl_Sel_List_Elem& oSel_List_Elem);

   virtual tVoid vVisit_e8_Tun_TMCType(midw_fi_tcl_e8_Tun_TMCType& oe8_Tun_TMCType);

   virtual tVoid vVisit_e8_Tun_ListID(midw_fi_tcl_e8_Tun_ListID& oe8_Tun_ListID);

   virtual tVoid vVisit_e8_Tun_Abs_Or_Rel(midw_fi_tcl_e8_Tun_Abs_Or_Rel& oe8_Tun_Abs_Or_Rel);

   virtual tVoid vVisit_e8_Tun_Rel_Steps(midw_fi_tcl_e8_Tun_Rel_Steps& oe8_Tun_Rel_Steps);

   virtual tVoid vVisit_e8_Tun_Direction(midw_fi_tcl_e8_Tun_Direction& oe8_Tun_Direction);

   virtual tVoid vVisit_Tun_Set_PI(midw_fi_tcl_Tun_Set_PI& oTun_Set_PI);

   virtual tVoid vVisit_e8_Tun_Autostore(midw_fi_tcl_e8_Tun_Autostore& oe8_Tun_Autostore);

   virtual tVoid vVisit_e8_Tun_ModeDirection(midw_fi_tcl_e8_Tun_ModeDirection& oe8_Tun_ModeDirection);

   virtual tVoid vVisit_e8_Tun_ListElementInfo(midw_fi_tcl_e8_Tun_ListElementInfo& oe8_Tun_ListElementInfo);

   virtual tVoid vVisit_TunerStaticListElement(midw_fi_tcl_TunerStaticListElement& oTunerStaticListElement);

   virtual tVoid vVisit_b8_Tun_HDNumOfAudioPrograms(midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms& ob8_Tun_HDNumOfAudioPrograms);

   virtual tVoid vVisit_TunerConfigListElement(midw_fi_tcl_TunerConfigListElement& oTunerConfigListElement);

   virtual tVoid vVisit_e8_Tun_PresetAction(midw_fi_tcl_e8_Tun_PresetAction& oe8_Tun_PresetAction);

   virtual tVoid vVisit_TunerStaticListElementList(midw_fi_tcl_TunerStaticListElementList& oTunerStaticListElementList);

   virtual tVoid vVisit_e16_Tun_TroubleCode(midw_fi_tcl_e16_Tun_TroubleCode& oe16_Tun_TroubleCode);

   virtual tVoid vVisit_e8_Tun_MonitoringMode(midw_fi_tcl_e8_Tun_MonitoringMode& oe8_Tun_MonitoringMode);

   virtual tVoid vVisit_e8_Tun_SupervisionControl(midw_fi_tcl_e8_Tun_SupervisionControl& oe8_Tun_SupervisionControl);

   virtual tVoid vVisit_TunerTestRoutineParameter(midw_fi_tcl_TunerTestRoutineParameter& oTunerTestRoutineParameter);

   virtual tVoid vVisit_TunerTestRoutineParameterList(midw_fi_tcl_TunerTestRoutineParameterList& oTunerTestRoutineParameterList);

   virtual tVoid vVisit_e8_Tun_ErrorStatus(midw_fi_tcl_e8_Tun_ErrorStatus& oe8_Tun_ErrorStatus);

   virtual tVoid vVisit_e8_Tun_MuteStatus(midw_fi_tcl_e8_Tun_MuteStatus& oe8_Tun_MuteStatus);

   virtual tVoid vVisit_e8_Tun_RoutineStatus(midw_fi_tcl_e8_Tun_RoutineStatus& oe8_Tun_RoutineStatus);

   virtual tVoid vVisit_Tun_TestTroubleCodeStatus(midw_fi_tcl_Tun_TestTroubleCodeStatus& oTun_TestTroubleCodeStatus);

   virtual tVoid vVisit_Tun_TestTroubleCodeStatusList(midw_fi_tcl_Tun_TestTroubleCodeStatusList& oTun_TestTroubleCodeStatusList);

   virtual tVoid vVisit_TunerFieldstrength(midw_fi_tcl_TunerFieldstrength& oTunerFieldstrength);

   virtual tVoid vVisit_Tun_Diag_ErrorCode(midw_fi_tcl_Tun_Diag_ErrorCode& oTun_Diag_ErrorCode);

   virtual tVoid vVisit_e8_BandChangeStatus(midw_fi_tcl_e8_BandChangeStatus& oe8_BandChangeStatus);

   virtual tVoid vVisit_e8_Tun_Source(midw_fi_tcl_e8_Tun_Source& oe8_Tun_Source);

   virtual tVoid vVisit_e8_Tun_HDAudioProgram(midw_fi_tcl_e8_Tun_HDAudioProgram& oe8_Tun_HDAudioProgram);

   virtual tVoid vVisit_e8_Tun_Autocompare_Mode(midw_fi_tcl_e8_Tun_Autocompare_Mode& oe8_Tun_Autocompare_Mode);

   virtual tVoid vVisit_Tun_AutoCompParam(midw_fi_tcl_Tun_AutoCompParam& oTun_AutoCompParam);

   virtual tVoid vVisit_Component_Status(midw_fi_tcl_Component_Status& oComponent_Status);

   virtual tVoid vVisit_e8_AtStationTPinfo(midw_fi_tcl_e8_AtStationTPinfo& oe8_AtStationTPinfo);

   virtual tVoid vVisit_b8_Tun_HDInfoBits(midw_fi_tcl_b8_Tun_HDInfoBits& ob8_Tun_HDInfoBits);

   virtual tVoid vVisit_e8_Tun_DiversityState(midw_fi_tcl_e8_Tun_DiversityState& oe8_Tun_DiversityState);

   virtual tVoid vVisit_e8_Tun_AntennaPathSwitch1(midw_fi_tcl_e8_Tun_AntennaPathSwitch1& oe8_Tun_AntennaPathSwitch1);

   virtual tVoid vVisit_e8_Tun_AntennaPathSwitch2(midw_fi_tcl_e8_Tun_AntennaPathSwitch2& oe8_Tun_AntennaPathSwitch2);

   virtual tVoid vVisit_TunerTestModeData_DDADDS(midw_fi_tcl_TunerTestModeData_DDADDS& oTunerTestModeData_DDADDS);

   virtual tVoid vVisit_e8_Tun_Engg_Param_ID(midw_fi_tcl_e8_Tun_Engg_Param_ID& oe8_Tun_Engg_Param_ID);

   virtual tVoid vVisit_e8_Tun_ConfigParam_Type(midw_fi_tcl_e8_Tun_ConfigParam_Type& oe8_Tun_ConfigParam_Type);

   virtual tVoid vVisit_TuningActionConfigParam(midw_fi_tcl_TuningActionConfigParam& oTuningActionConfigParam);

   virtual tVoid vVisit_e8_Tun_TestTuneFrequencyMode(midw_fi_tcl_e8_Tun_TestTuneFrequencyMode& oe8_Tun_TestTuneFrequencyMode);

   virtual tVoid vVisit_b8_AnnoTypes(midw_fi_tcl_b8_AnnoTypes& ob8_AnnoTypes);

   virtual tVoid vVisit_b8_Anno_Message(midw_fi_tcl_b8_Anno_Message& ob8_Anno_Message);

   virtual tVoid vVisit_AnnoInfostatus(midw_fi_tcl_AnnoInfostatus& oAnnoInfostatus);

   virtual tVoid vVisit_e8_PS_Freeze_Mode(midw_fi_tcl_e8_PS_Freeze_Mode& oe8_PS_Freeze_Mode);

   virtual tVoid vVisit_e8_Tun_AnnoTypes(midw_fi_tcl_e8_Tun_AnnoTypes& oe8_Tun_AnnoTypes);

   virtual tVoid vVisit_e8_Anno_Message(midw_fi_tcl_e8_Anno_Message& oe8_Anno_Message);

   virtual tVoid vVisit_Tun_Engg_Param_List_Elem(midw_fi_tcl_Tun_Engg_Param_List_Elem& oTun_Engg_Param_List_Elem);

   virtual tVoid vVisit_e8_Tun_DefaultSettingOption(midw_fi_tcl_e8_Tun_DefaultSettingOption& oe8_Tun_DefaultSettingOption);

   virtual tVoid vVisit_AvailableBandInfoElement(midw_fi_tcl_AvailableBandInfoElement& oAvailableBandInfoElement);

   virtual tVoid vVisit_AvailableBandInfoList(midw_fi_tcl_AvailableBandInfoList& oAvailableBandInfoList);

   virtual tVoid vVisit_b8_Tun_DemodSwitch(midw_fi_tcl_b8_Tun_DemodSwitch& ob8_Tun_DemodSwitch);

   virtual tVoid vVisit_e8_Tun_SelectMode(midw_fi_tcl_e8_Tun_SelectMode& oe8_Tun_SelectMode);

   virtual tVoid vVisit_TunerBandAndStationInfo(midw_fi_tcl_TunerBandAndStationInfo& oTunerBandAndStationInfo);

   virtual tVoid vVisit_e8_Tun_RelativeDirection(midw_fi_tcl_e8_Tun_RelativeDirection& oe8_Tun_RelativeDirection);

   virtual tVoid vVisit_b8_Tun_HDPrgmAvail(midw_fi_tcl_b8_Tun_HDPrgmAvail& ob8_Tun_HDPrgmAvail);

   virtual tVoid vVisit_b8_Tun_DRMStationInfoBits(midw_fi_tcl_b8_Tun_DRMStationInfoBits& ob8_Tun_DRMStationInfoBits);

   virtual tVoid vVisit_b16_Tun_DRMAnnouBits(midw_fi_tcl_b16_Tun_DRMAnnouBits& ob16_Tun_DRMAnnouBits);

   virtual tVoid vVisit_b8_Tun_DRMNumberOfAudioServices(midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices& ob8_Tun_DRMNumberOfAudioServices);

   virtual tVoid vVisit_Atstationinfo(midw_fi_tcl_Atstationinfo& oAtstationinfo);

   virtual tVoid vVisit_Tun_MakeConfigList(midw_fi_tcl_Tun_MakeConfigList& oTun_MakeConfigList);

   virtual tVoid vVisit_TunerConfigListElementList(midw_fi_tcl_TunerConfigListElementList& oTunerConfigListElementList);

   virtual tVoid vVisit_TunerRadioText(midw_fi_tcl_TunerRadioText& oTunerRadioText);

   virtual tVoid vVisit_e8_Tun_DRMSourceActivity(midw_fi_tcl_e8_Tun_DRMSourceActivity& oe8_Tun_DRMSourceActivity);

   virtual tVoid vVisit_e8_PISearch_Status(midw_fi_tcl_e8_PISearch_Status& oe8_PISearch_Status);

   virtual tVoid vVisit_TunerHDTestModeData(midw_fi_tcl_TunerHDTestModeData& oTunerHDTestModeData);

   virtual tVoid vVisit_e8_Tun_HDAdvisoryInfo(midw_fi_tcl_e8_Tun_HDAdvisoryInfo& oe8_Tun_HDAdvisoryInfo);

   virtual tVoid vVisit_e8_Tun_DRMTestModeActivity(midw_fi_tcl_e8_Tun_DRMTestModeActivity& oe8_Tun_DRMTestModeActivity);

   virtual tVoid vVisit_e8_Tun_HDImageType(midw_fi_tcl_e8_Tun_HDImageType& oe8_Tun_HDImageType);

   virtual tVoid vVisit_e8_Tun_HDImageCoding(midw_fi_tcl_e8_Tun_HDImageCoding& oe8_Tun_HDImageCoding);

   virtual tVoid vVisit_ImageFileInfo(midw_fi_tcl_ImageFileInfo& oImageFileInfo);

   virtual tVoid vVisit_TunPSDCommercial(midw_fi_tcl_TunPSDCommercial& oTunPSDCommercial);

   virtual tVoid vVisit_TunPSDComment(midw_fi_tcl_TunPSDComment& oTunPSDComment);

   virtual tVoid vVisit_TunPSDData(midw_fi_tcl_TunPSDData& oTunPSDData);

   virtual tVoid vVisit_e8_Tun_TestModeActivity(midw_fi_tcl_e8_Tun_TestModeActivity& oe8_Tun_TestModeActivity);

   virtual tVoid vVisit_e8_Tun_TestModeSource(midw_fi_tcl_e8_Tun_TestModeSource& oe8_Tun_TestModeSource);

   virtual tVoid vVisit_e8_Tun_AudioSplitMode(midw_fi_tcl_e8_Tun_AudioSplitMode& oe8_Tun_AudioSplitMode);

   virtual tVoid vVisit_e16_Tun_ParameterID(midw_fi_tcl_e16_Tun_ParameterID& oe16_Tun_ParameterID);

   virtual tVoid vVisit_PhysicalTunerCalibData(midw_fi_tcl_PhysicalTunerCalibData& oPhysicalTunerCalibData);

   virtual tVoid vVisit_CalibrationData(midw_fi_tcl_CalibrationData& oCalibrationData);

   virtual tVoid vVisit_e8_StationSelectionOption(midw_fi_tcl_e8_StationSelectionOption& oe8_StationSelectionOption);

   virtual tVoid vVisit_e8_Tun_Japan_Region(midw_fi_tcl_e8_Tun_Japan_Region& oe8_Tun_Japan_Region);

   virtual tVoid vVisit_e8_Tun_Language(midw_fi_tcl_e8_Tun_Language& oe8_Tun_Language);

   virtual tVoid vVisit_e8_Tun_ChangeStationMode(midw_fi_tcl_e8_Tun_ChangeStationMode& oe8_Tun_ChangeStationMode);

   virtual tVoid vVisit_TunerJapanStationName(midw_fi_tcl_TunerJapanStationName& oTunerJapanStationName);

   virtual tVoid vVisit_TunerJapanStationNameList(midw_fi_tcl_TunerJapanStationNameList& oTunerJapanStationNameList);

   virtual tVoid vVisit_u32FrequencyList(midw_fi_tcl_u32FrequencyList& ou32FrequencyList);

   virtual tVoid vVisit_b8_Tun_STATStatusRegister(midw_fi_tcl_b8_Tun_STATStatusRegister& ob8_Tun_STATStatusRegister);

   virtual tVoid vVisit_DARCDataBlock(midw_fi_tcl_DARCDataBlock& oDARCDataBlock);

   virtual tVoid vVisit_DARCDataBlockList(midw_fi_tcl_DARCDataBlockList& oDARCDataBlockList);

   virtual tVoid vVisit_TunerListElement(midw_fi_tcl_TunerListElement& oTunerListElement);

   virtual tVoid vVisit_TunerListElementList(midw_fi_tcl_TunerListElementList& oTunerListElementList);

   virtual tVoid vVisit_b8_Tun_SwitchingFrequency(midw_fi_tcl_b8_Tun_SwitchingFrequency& ob8_Tun_SwitchingFrequency);

   virtual tVoid vVisit_e8_Band(midw_fi_tcl_e8_Band& oe8_Band);

   virtual tVoid vVisit_e8_Preset_Option(midw_fi_tcl_e8_Preset_Option& oe8_Preset_Option);

   virtual tVoid vVisit_e8_Source(midw_fi_tcl_e8_Source& oe8_Source);

   virtual tVoid vVisit_e8_Action(midw_fi_tcl_e8_Action& oe8_Action);

   virtual tVoid vVisit_e8_WhichTuner(midw_fi_tcl_e8_WhichTuner& oe8_WhichTuner);

   virtual tVoid vVisit_StopAnnouncements(midw_fi_tcl_StopAnnouncements& oStopAnnouncements);

   virtual tVoid vVisit_e8_TunMstr_ResponseStatus(midw_fi_tcl_e8_TunMstr_ResponseStatus& oe8_TunMstr_ResponseStatus);

   virtual tVoid vVisit_TunerMaster_StatusResponse(midw_fi_tcl_TunerMaster_StatusResponse& oTunerMaster_StatusResponse);

   virtual tVoid vVisit_e8_TunMstr_RadioProfileSetting_Response(midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response& oe8_TunMstr_RadioProfileSetting_Response);

   virtual tVoid vVisit_e8_TunMstr_RadioProfileSetting_ErrorCode(midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode& oe8_TunMstr_RadioProfileSetting_ErrorCode);

   virtual tVoid vVisit_TunMstr_RadioSetting_StatusResponse(midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& oTunMstr_RadioSetting_StatusResponse);

   virtual tVoid vVisit_e8_List(midw_fi_tcl_e8_List& oe8_List);

   virtual tVoid vVisit_e8_RFAntenna(midw_fi_tcl_e8_RFAntenna& oe8_RFAntenna);

   virtual tVoid vVisit_e8_AntennaTest(midw_fi_tcl_e8_AntennaTest& oe8_AntennaTest);

   virtual tVoid vVisitunmstr_RFAntenna(midw_fi_tclunmstr_RFAntenna& onmstr_RFAntenna);

   virtual tVoid vVisit_e8_RequestResult(midw_fi_tcl_e8_RequestResult& oe8_RequestResult);

   virtual tVoid vVisit_e8_AST_Types(midw_fi_tcl_e8_AST_Types& oe8_AST_Types);

   virtual tVoid vVisit_e8_Graphics(midw_fi_tcl_e8_Graphics& oe8_Graphics);

   virtual tVoid vVisit_SXMChannelAttributes(midw_fi_tcl_SXMChannelAttributes& oSXMChannelAttributes);

   virtual tVoid vVisit_e8_HDAudioProgram(midw_fi_tcl_e8_HDAudioProgram& oe8_HDAudioProgram);

   virtual tVoid vVisit_e8_PresetType(midw_fi_tcl_e8_PresetType& oe8_PresetType);

   virtual tVoid vVisit_SXMChannelImagedata(midw_fi_tcl_SXMChannelImagedata& oSXMChannelImagedata);

   virtual tVoid vVisit_e8_PSFreeze_Mode(midw_fi_tcl_e8_PSFreeze_Mode& oe8_PSFreeze_Mode);

   virtual tVoid vVisit_e8_Preset_Action(midw_fi_tcl_e8_Preset_Action& oe8_Preset_Action);

   virtual tVoid vVisit_e8_StationSelection_Option(midw_fi_tcl_e8_StationSelection_Option& oe8_StationSelection_Option);

   virtual tVoid vVisit_e8_AnnoTypes(midw_fi_tcl_e8_AnnoTypes& oe8_AnnoTypes);

   virtual tVoid vVisit_b32_AnnoType(midw_fi_tcl_b32_AnnoType& ob32_AnnoType);

   virtual tVoid vVisit_b8_SourceAnno(midw_fi_tcl_b8_SourceAnno& ob8_SourceAnno);

   virtual tVoid vVisit_e8_TunerAvailability(midw_fi_tcl_e8_TunerAvailability& oe8_TunerAvailability);

   virtual tVoid vVisit_b8_ModeType(midw_fi_tcl_b8_ModeType& ob8_ModeType);

   virtual tVoid vVisit_e8_StationType(midw_fi_tcl_e8_StationType& oe8_StationType);

   virtual tVoid vVisit_e8_ModulationType(midw_fi_tcl_e8_ModulationType& oe8_ModulationType);

   virtual tVoid vVisit_e8_HDTextEncoding(midw_fi_tcl_e8_HDTextEncoding& oe8_HDTextEncoding);

   virtual tVoid vVisit_SXMPresetListEntry(midw_fi_tcl_SXMPresetListEntry& oSXMPresetListEntry);

   virtual tVoid vVisit_e8_TunMst_RadioType(midw_fi_tcl_e8_TunMst_RadioType& oe8_TunMst_RadioType);

   virtual tVoid vVisit_DAB_Label(midw_fi_tcl_DAB_Label& oDAB_Label);

   virtual tVoid vVisit_b8_RadioProfileSettingAction(midw_fi_tcl_b8_RadioProfileSettingAction& ob8_RadioProfileSettingAction);

   virtual tVoid vVisit_TunMst_PresetListElement(midw_fi_tcl_TunMst_PresetListElement& oTunMst_PresetListElement);

   virtual tVoid vVisit_e8_TunerErrorType(midw_fi_tcl_e8_TunerErrorType& oe8_TunerErrorType);

   virtual tVoid vVisit_e8SXMChannelArtErrorTypes(midw_fi_tcl_e8SXMChannelArtErrorTypes& oe8SXMChannelArtErrorTypes);

   virtual tVoid vVisit_PresetList(midw_fi_tcl_PresetList& oPresetList);

   virtual tVoid vVisit_SXMPresetEntry(midw_fi_tcl_SXMPresetEntry& oSXMPresetEntry);

   virtual tVoid vVisit_e8_SXMSystemMessage(midw_fi_tcl_e8_SXMSystemMessage& oe8_SXMSystemMessage);

   virtual tVoid vVisit_ProfileStatus(midw_fi_tcl_ProfileStatus& oProfileStatus);

   virtual tVoid vVisit_ProfileAction(midw_fi_tcl_ProfileAction& oProfileAction);

   virtual tVoid vVisit_ProfileActionStatus(midw_fi_tcl_ProfileActionStatus& oProfileActionStatus);

   virtual tVoid vVisit_ProfileResponse(midw_fi_tcl_ProfileResponse& oProfileResponse);

   virtual tVoid vVisit_e8_Tun_RequestResult(midw_fi_tcl_e8_Tun_RequestResult& oe8_Tun_RequestResult);

   virtual tVoid vVisit_e8_Tun_AlignCalibrate(midw_fi_tcl_e8_Tun_AlignCalibrate& oe8_Tun_AlignCalibrate);

   virtual tVoid vVisit_e8_Tun_AlignCalibrateStatus(midw_fi_tcl_e8_Tun_AlignCalibrateStatus& oe8_Tun_AlignCalibrateStatus);

   virtual tVoid vVisit_e8_Tun_IFOutput(midw_fi_tcl_e8_Tun_IFOutput& oe8_Tun_IFOutput);

   virtual tVoid vVisit_Tun_IFOutput(midw_fi_tcl_Tun_IFOutput& oTun_IFOutput);

   virtual tVoid vVisit_e8_Tun_RFAntenna(midw_fi_tcl_e8_Tun_RFAntenna& oe8_Tun_RFAntenna);

   virtual tVoid vVisit_e8_ATMResult(midw_fi_tcl_e8_ATMResult& oe8_ATMResult);

   virtual tVoid vVisit_u8Result(midw_fi_tcl_u8Result& ou8Result);

   virtual tVoid vVisit_e8_ANTENNA_TEST(midw_fi_tcl_e8_ANTENNA_TEST& oe8_ANTENNA_TEST);

   virtual tVoid vVisit_Tun_RFAntenna(midw_fi_tcl_Tun_RFAntenna& oTun_RFAntenna);

   virtual tVoid vVisit_e8_Tun_TMCInfo(midw_fi_tcl_e8_Tun_TMCInfo& oe8_Tun_TMCInfo);

   virtual tVoid vVisit_e8_Tun_TPInfo(midw_fi_tcl_e8_Tun_TPInfo& oe8_Tun_TPInfo);

   virtual tVoid vVisit_e8_Tun_TA(midw_fi_tcl_e8_Tun_TA& oe8_Tun_TA);

   virtual tVoid vVisit_e8_Tun_PI(midw_fi_tcl_e8_Tun_PI& oe8_Tun_PI);

   virtual tVoid vVisit_e8_Tun_ProgramKind(midw_fi_tcl_e8_Tun_ProgramKind& oe8_Tun_ProgramKind);

   virtual tVoid vVisit_e8_Tun_EON(midw_fi_tcl_e8_Tun_EON& oe8_Tun_EON);

   virtual tVoid vVisit_e8_Tun_PTY(midw_fi_tcl_e8_Tun_PTY& oe8_Tun_PTY);

   virtual tVoid vVisit_b32_TunerFeatureData(midw_fi_tcl_b32_TunerFeatureData& ob32_TunerFeatureData);

   virtual tVoid vVisit_b8_Tun_DiagMode(midw_fi_tcl_b8_Tun_DiagMode& ob8_Tun_DiagMode);

   virtual tVoid vVisit_Tun_AlignCalibrateParameterList(midw_fi_tcl_Tun_AlignCalibrateParameterList& oTun_AlignCalibrateParameterList);

   virtual tVoid vVisit_TunerDiagMode(midw_fi_tcl_TunerDiagMode& oTunerDiagMode);

   virtual tVoid vVisit_Tun_ProgramInfo(midw_fi_tcl_Tun_ProgramInfo& oTun_ProgramInfo);

   virtual tVoid vVisit_TunerBandFrq(midw_fi_tcl_TunerBandFrq& oTunerBandFrq);

   virtual tVoid vVisit_TunerAlignCalibrate(midw_fi_tcl_TunerAlignCalibrate& oTunerAlignCalibrate);

   virtual tVoid vVisit_e8_ApplicationState(midw_fi_tcl_e8_ApplicationState& oe8_ApplicationState);

   virtual tVoid vVisit_e8_AppMgrMethodResult(midw_fi_tcl_e8_AppMgrMethodResult& oe8_AppMgrMethodResult);

   virtual tVoid vVisit_ApplicationData(midw_fi_tcl_ApplicationData& oApplicationData);

   virtual tVoid vVisit_e8_streamrouter_routestate(midw_fi_tcl_e8_streamrouter_routestate& oe8_streamrouter_routestate);

   virtual tVoid vVisit_e8_streamrouter_ramptype(midw_fi_tcl_e8_streamrouter_ramptype& oe8_streamrouter_ramptype);

   virtual tVoid vVisit_streamrouter_route_entry(midw_fi_tcl_streamrouter_route_entry& ostreamrouter_route_entry);

   virtual tVoid vVisit_streamrouter_routing_list(midw_fi_tcl_streamrouter_routing_list& ostreamrouter_routing_list);

   virtual tVoid vVisit_streamrouter_device_list(midw_fi_tcl_streamrouter_device_list& ostreamrouter_device_list);

   virtual tVoid vVisit_e8_streamrouter_fgcommand(midw_fi_tcl_e8_streamrouter_fgcommand& oe8_streamrouter_fgcommand);

   virtual tVoid vVisit_e8_DeviceConnectStatus(midw_fi_tcl_e8_DeviceConnectStatus& oe8_DeviceConnectStatus);

   virtual tVoid vVisit_e8_Device(midw_fi_tcl_e8_Device& oe8_Device);

   virtual tVoid vVisit_DevManager_DeviceProperty(midw_fi_tcl_DevManager_DeviceProperty& oDevManager_DeviceProperty);

   virtual tVoid vVisit_DevManager_DevInfoStr(midw_fi_tcl_DevManager_DevInfoStr& oDevManager_DevInfoStr);

   virtual tVoid vVisit_u8Array(midw_fi_tcl_u8Array& ou8Array);

   virtual tVoid vVisit_e8_InternalError(midw_fi_tcl_e8_InternalError& oe8_InternalError);

   virtual tVoid vVisit_b32_RoutineBitMask(midw_fi_tcl_b32_RoutineBitMask& ob32_RoutineBitMask);

   virtual tVoid vVisit_e8_RoutineStatus(midw_fi_tcl_e8_RoutineStatus& oe8_RoutineStatus);

   virtual tVoid vVisit_e8_IOResult(midw_fi_tcl_e8_IOResult& oe8_IOResult);

   virtual tVoid vVisit_e8_SystemSetResult(midw_fi_tcl_e8_SystemSetResult& oe8_SystemSetResult);

   virtual tVoid vVisit_e8_DiagDataResult(midw_fi_tcl_e8_DiagDataResult& oe8_DiagDataResult);

   virtual tVoid vVisit_e8_IOControlActionId(midw_fi_tcl_e8_IOControlActionId& oe8_IOControlActionId);

   virtual tVoid vVisit_e8_SystemSetType(midw_fi_tcl_e8_SystemSetType& oe8_SystemSetType);

   virtual tVoid vVisit_e8_ValueType(midw_fi_tcl_e8_ValueType& oe8_ValueType);

   virtual tVoid vVisit_ValueUnion(midw_fi_tcl_ValueUnion& oValueUnion);

   virtual tVoid vVisit_ValueList(midw_fi_tcl_ValueList& oValueList);

   virtual tVoid vVisit_e8_MethodResultReply(midw_fi_tcl_e8_MethodResultReply& oe8_MethodResultReply);

   virtual tVoid vVisit_e8_TestResult(midw_fi_tcl_e8_TestResult& oe8_TestResult);

   virtual tVoid vVisit_FreezeFrameData(midw_fi_tcl_FreezeFrameData& oFreezeFrameData);

   virtual tVoid vVisit_FreezeFrameList(midw_fi_tcl_FreezeFrameList& oFreezeFrameList);

   virtual tVoid vVisit_ReadRequestBuffer(midw_fi_tcl_ReadRequestBuffer& oReadRequestBuffer);

   virtual tVoid vVisit_ReadResultBuffer(midw_fi_tcl_ReadResultBuffer& oReadResultBuffer);

   virtual tVoid vVisit_ReadResultStructure(midw_fi_tcl_ReadResultStructure& oReadResultStructure);

   virtual tVoid vVisit_ReadResultList(midw_fi_tcl_ReadResultList& oReadResultList);

   virtual tVoid vVisit_ITC_Information(midw_fi_tcl_ITC_Information& oITC_Information);

   virtual tVoid vVisit_ProductionReadResultStructure(midw_fi_tcl_ProductionReadResultStructure& oProductionReadResultStructure);

   virtual tVoid vVisit_ProductionReadResultList(midw_fi_tcl_ProductionReadResultList& oProductionReadResultList);

   virtual tVoid vVisit_CustomerReadResultStructure(midw_fi_tcl_CustomerReadResultStructure& oCustomerReadResultStructure);

   virtual tVoid vVisit_CustomerReadResultList(midw_fi_tcl_CustomerReadResultList& oCustomerReadResultList);

   virtual tVoid vVisit_e8_Protocol(midw_fi_tcl_e8_Protocol& oe8_Protocol);

   virtual tVoid vVisit_TestResult(midw_fi_tcl_TestResult& oTestResult);

   virtual tVoid vVisit_TestResultList(midw_fi_tcl_TestResultList& oTestResultList);

   virtual tVoid vVisit_SnapshotData(midw_fi_tcl_SnapshotData& oSnapshotData);

   virtual tVoid vVisit_SnapshotDataList(midw_fi_tcl_SnapshotDataList& oSnapshotDataList);

   virtual tVoid vVisit_SnapshotIdentification(midw_fi_tcl_SnapshotIdentification& oSnapshotIdentification);

   virtual tVoid vVisit_SnapshotIdentificationList(midw_fi_tcl_SnapshotIdentificationList& oSnapshotIdentificationList);

   virtual tVoid vVisit_ClearRequestBuffer(midw_fi_tcl_ClearRequestBuffer& oClearRequestBuffer);

   virtual tVoid vVisit_ClearResultBuffer(midw_fi_tcl_ClearResultBuffer& oClearResultBuffer);

   virtual tVoid vVisit_e8_ControlParameter(midw_fi_tcl_e8_ControlParameter& oe8_ControlParameter);

   virtual tVoid vVisit_ControlList(midw_fi_tcl_ControlList& oControlList);

   virtual tVoid vVisit_e8_ReadValue(midw_fi_tcl_e8_ReadValue& oe8_ReadValue);

   virtual tVoid vVisit_e8_VDLMediaType(midw_fi_tcl_e8_VDLMediaType& oe8_VDLMediaType);

   virtual tVoid vVisit_e8_DiaglogDefsetType(midw_fi_tcl_e8_DiaglogDefsetType& oe8_DiaglogDefsetType);

   virtual tVoid vVisit_e8_SendNextTestResReason(midw_fi_tcl_e8_SendNextTestResReason& oe8_SendNextTestResReason);

   virtual tVoid vVisit_SendNextTestResultStructure(midw_fi_tcl_SendNextTestResultStructure& oSendNextTestResultStructure);

   virtual tVoid vVisit_e8_ErrorCode(midw_fi_tcl_e8_ErrorCode& oe8_ErrorCode);

   virtual tVoid vVisit_e8_GMLnGWDTCFaultType(midw_fi_tcl_e8_GMLnGWDTCFaultType& oe8_GMLnGWDTCFaultType);

   virtual tVoid vVisit_ActiveDTCList(midw_fi_tcl_ActiveDTCList& oActiveDTCList);

   virtual tVoid vVisit_DiagProtocol(midw_fi_tcl_DiagProtocol& oDiagProtocol);

   virtual tVoid vVisit_e8_Store(midw_fi_tcl_e8_Store& oe8_Store);

   virtual tVoid vVisit_e8_RouteCalculationCommand(midw_fi_tcl_e8_RouteCalculationCommand& oe8_RouteCalculationCommand);

   virtual tVoid vVisit_e8_RouteCalculationStatus(midw_fi_tcl_e8_RouteCalculationStatus& oe8_RouteCalculationStatus);

   virtual tVoid vVisit_e8_Language(midw_fi_tcl_e8_Language& oe8_Language);

   virtual tVoid vVisit_e8_Country(midw_fi_tcl_e8_Country& oe8_Country);

   virtual tVoid vVisit_e8_LanguageSubsystem(midw_fi_tcl_e8_LanguageSubsystem& oe8_LanguageSubsystem);

   virtual tVoid vVisit_e8_TestScreens(midw_fi_tcl_e8_TestScreens& oe8_TestScreens);

   virtual tVoid vVisit_DisplayStringsList(midw_fi_tcl_DisplayStringsList& oDisplayStringsList);

   virtual tVoid vVisit_DisplayData(midw_fi_tcl_DisplayData& oDisplayData);

   virtual tVoid vVisit_e8_TroubleCodeType(midw_fi_tcl_e8_TroubleCodeType& oe8_TroubleCodeType);

   virtual tVoid vVisit_e8_TestRoutines(midw_fi_tcl_e8_TestRoutines& oe8_TestRoutines);

   virtual tVoid vVisit_e8_DefaultSettingsCategories(midw_fi_tcl_e8_DefaultSettingsCategories& oe8_DefaultSettingsCategories);

   virtual tVoid vVisit_CountryLanguage(midw_fi_tcl_CountryLanguage& oCountryLanguage);

   virtual tVoid vVisit_CountryLanguageResult(midw_fi_tcl_CountryLanguageResult& oCountryLanguageResult);

   virtual tVoid vVisit_e8_TroubleCodeStatus(midw_fi_tcl_e8_TroubleCodeStatus& oe8_TroubleCodeStatus);

   virtual tVoid vVisit_TroubleCode(midw_fi_tcl_TroubleCode& oTroubleCode);

   virtual tVoid vVisit_TroubleCodeList(midw_fi_tcl_TroubleCodeList& oTroubleCodeList);

   virtual tVoid vVisit_RouteCalculationStartParameter(midw_fi_tcl_RouteCalculationStartParameter& oRouteCalculationStartParameter);

   virtual tVoid vVisit_RouteCalculationResultParameter(midw_fi_tcl_RouteCalculationResultParameter& oRouteCalculationResultParameter);

   virtual tVoid vVisit_e16_Language(midw_fi_tcl_e16_Language& oe16_Language);

   virtual tVoid vVisit_e16_SpeedLock(midw_fi_tcl_e16_SpeedLock& oe16_SpeedLock);

   virtual tVoid vVisit_MessageBuffer(midw_fi_tcl_MessageBuffer& oMessageBuffer);

   virtual tVoid vVisit_e8_DefSetMode(midw_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(midw_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);

   virtual tVoid vVisit_e8_DefSetGroups(midw_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_DiagMausSetup(midw_fi_tcl_e8_DiagMausSetup& oe8_DiagMausSetup);

   virtual tVoid vVisit_e8_SimulatedKeys(midw_fi_tcl_e8_SimulatedKeys& oe8_SimulatedKeys);

   virtual tVoid vVisit_KDSItemList(midw_fi_tcl_KDSItemList& oKDSItemList);

   virtual tVoid vVisit_ConfigItemList(midw_fi_tcl_ConfigItemList& oConfigItemList);

   virtual tVoid vVisit_RequestDataUDS(midw_fi_tcl_RequestDataUDS& oRequestDataUDS);

   virtual tVoid vVisit_ResponseDataUDS(midw_fi_tcl_ResponseDataUDS& oResponseDataUDS);

   virtual tVoid vVisit_DiagData(midw_fi_tcl_DiagData& oDiagData);

   virtual tVoid vVisit_e8_RCtrlSource(midw_fi_tcl_e8_RCtrlSource& oe8_RCtrlSource);

   virtual tVoid vVisit_e8_RCtrlCommand(midw_fi_tcl_e8_RCtrlCommand& oe8_RCtrlCommand);

   virtual tVoid vVisit_e8_RCtrlSignal(midw_fi_tcl_e8_RCtrlSignal& oe8_RCtrlSignal);

   virtual tVoid vVisit_e8_DiagRVCSignal(midw_fi_tcl_e8_DiagRVCSignal& oe8_DiagRVCSignal);

   virtual tVoid vVisit_e8_CalibrationTable(midw_fi_tcl_e8_CalibrationTable& oe8_CalibrationTable);

   virtual tVoid vVisit_CalibrationValue(midw_fi_tcl_CalibrationValue& oCalibrationValue);

   virtual tVoid vVisit_e8_CalibrationTimeStampMonth(midw_fi_tcl_e8_CalibrationTimeStampMonth& oe8_CalibrationTimeStampMonth);

   virtual tVoid vVisit_CalibrationTimeStamp(midw_fi_tcl_CalibrationTimeStamp& oCalibrationTimeStamp);

   virtual tVoid vVisit_AlphaCode(midw_fi_tcl_AlphaCode& oAlphaCode);

   virtual tVoid vVisit_e8_CalibrationParameterSize(midw_fi_tcl_e8_CalibrationParameterSize& oe8_CalibrationParameterSize);

   virtual tVoid vVisit_e8_KdsViaUsbUpdateStatus(midw_fi_tcl_e8_KdsViaUsbUpdateStatus& oe8_KdsViaUsbUpdateStatus);

   virtual tVoid vVisit_AntiTheftStatus(midw_fi_tcl_AntiTheftStatus& oAntiTheftStatus);

   virtual tVoid vVisit_e16_Aud_TroubleCode(midw_fi_tcl_e16_Aud_TroubleCode& oe16_Aud_TroubleCode);

   virtual tVoid vVisit_e8_Aud_MonitoringMode(midw_fi_tcl_e8_Aud_MonitoringMode& oe8_Aud_MonitoringMode);

   virtual tVoid vVisit_e8_Aud_SupervisionControl(midw_fi_tcl_e8_Aud_SupervisionControl& oe8_Aud_SupervisionControl);

   virtual tVoid vVisit_e8_Aud_ErrorStatus(midw_fi_tcl_e8_Aud_ErrorStatus& oe8_Aud_ErrorStatus);

   virtual tVoid vVisit_e8_Aud_RoutineStatus(midw_fi_tcl_e8_Aud_RoutineStatus& oe8_Aud_RoutineStatus);

   virtual tVoid vVisit_e8_Aud_WriteTestErrorStatus(midw_fi_tcl_e8_Aud_WriteTestErrorStatus& oe8_Aud_WriteTestErrorStatus);

   virtual tVoid vVisit_e8_Aud_SpeakerType(midw_fi_tcl_e8_Aud_SpeakerType& oe8_Aud_SpeakerType);

   virtual tVoid vVisit_e8_Aud_TestToneControl(midw_fi_tcl_e8_Aud_TestToneControl& oe8_Aud_TestToneControl);

   virtual tVoid vVisit_e8_Aud_FreqTestTone(midw_fi_tcl_e8_Aud_FreqTestTone& oe8_Aud_FreqTestTone);

   virtual tVoid vVisit_Aud_TestRoutineParameter(midw_fi_tcl_Aud_TestRoutineParameter& oAud_TestRoutineParameter);

   virtual tVoid vVisit_Aud_TestRoutineParameterList(midw_fi_tcl_Aud_TestRoutineParameterList& oAud_TestRoutineParameterList);

   virtual tVoid vVisit_Aud_TestTroubleCodeStatus(midw_fi_tcl_Aud_TestTroubleCodeStatus& oAud_TestTroubleCodeStatus);

   virtual tVoid vVisit_Aud_TestTroubleCodeStatusList(midw_fi_tcl_Aud_TestTroubleCodeStatusList& oAud_TestTroubleCodeStatusList);

   virtual tVoid vVisit_e8_MicrophoneNumber(midw_fi_tcl_e8_MicrophoneNumber& oe8_MicrophoneNumber);

   virtual tVoid vVisit_e8_MicrophoneConnectionStatus(midw_fi_tcl_e8_MicrophoneConnectionStatus& oe8_MicrophoneConnectionStatus);

   virtual tVoid vVisit_e8_MicrophoneDetection(midw_fi_tcl_e8_MicrophoneDetection& oe8_MicrophoneDetection);

   virtual tVoid vVisit_MicrophoneConnectionStatus(midw_fi_tcl_MicrophoneConnectionStatus& oMicrophoneConnectionStatus);

   virtual tVoid vVisit_MicrophoneConnectionStatusList(midw_fi_tcl_MicrophoneConnectionStatusList& oMicrophoneConnectionStatusList);

   virtual tVoid vVisit_e8_ResourceNo(midw_fi_tcl_e8_ResourceNo& oe8_ResourceNo);

   virtual tVoid vVisit_e8_AudioServiceStatus(midw_fi_tcl_e8_AudioServiceStatus& oe8_AudioServiceStatus);

   virtual tVoid vVisit_e8_GalaLevel(midw_fi_tcl_e8_GalaLevel& oe8_GalaLevel);

   virtual tVoid vVisit_e8_AudioChannel(midw_fi_tcl_e8_AudioChannel& oe8_AudioChannel);

   virtual tVoid vVisit_e8_AudioVolumeType(midw_fi_tcl_e8_AudioVolumeType& oe8_AudioVolumeType);

   virtual tVoid vVisit_e8_AudioSoundType(midw_fi_tcl_e8_AudioSoundType& oe8_AudioSoundType);

   virtual tVoid vVisit_e8_AudioBeepType(midw_fi_tcl_e8_AudioBeepType& oe8_AudioBeepType);

   virtual tVoid vVisit_e8_AudioBeepStatus(midw_fi_tcl_e8_AudioBeepStatus& oe8_AudioBeepStatus);

   virtual tVoid vVisit_e8_VolumeMode(midw_fi_tcl_e8_VolumeMode& oe8_VolumeMode);

   virtual tVoid vVisit_e8_SourceNo(midw_fi_tcl_e8_SourceNo& oe8_SourceNo);

   virtual tVoid vVisit_e8_RouteNo(midw_fi_tcl_e8_RouteNo& oe8_RouteNo);

   virtual tVoid vVisit_e8_Sound(midw_fi_tcl_e8_Sound& oe8_Sound);

   virtual tVoid vVisit_e8_MemStatus(midw_fi_tcl_e8_MemStatus& oe8_MemStatus);

   virtual tVoid vVisit_e8_FaderStatus(midw_fi_tcl_e8_FaderStatus& oe8_FaderStatus);

   virtual tVoid vVisit_e8_DynCompression(midw_fi_tcl_e8_DynCompression& oe8_DynCompression);

   virtual tVoid vVisit_e8_Optimization(midw_fi_tcl_e8_Optimization& oe8_Optimization);

   virtual tVoid vVisit_e8_EquPresets(midw_fi_tcl_e8_EquPresets& oe8_EquPresets);

   virtual tVoid vVisit_e8_DiagAudMode(midw_fi_tcl_e8_DiagAudMode& oe8_DiagAudMode);

   virtual tVoid vVisit_e8_GenericDiagAudMode(midw_fi_tcl_e8_GenericDiagAudMode& oe8_GenericDiagAudMode);

   virtual tVoid vVisit_e8_AuxInLevel(midw_fi_tcl_e8_AuxInLevel& oe8_AuxInLevel);

   virtual tVoid vVisit_e8_BeepLevel(midw_fi_tcl_e8_BeepLevel& oe8_BeepLevel);

   virtual tVoid vVisit_e8_Rear_Mute(midw_fi_tcl_e8_Rear_Mute& oe8_Rear_Mute);

   virtual tVoid vVisit_e8_Geometry_Mode(midw_fi_tcl_e8_Geometry_Mode& oe8_Geometry_Mode);

   virtual tVoid vVisit_e8_PDCAttenuation(midw_fi_tcl_e8_PDCAttenuation& oe8_PDCAttenuation);

   virtual tVoid vVisit_e8_VolumeType(midw_fi_tcl_e8_VolumeType& oe8_VolumeType);

   virtual tVoid vVisit_Volume(midw_fi_tcl_Volume& oVolume);

   virtual tVoid vVisit_b8_ChannelSelect(midw_fi_tcl_b8_ChannelSelect& ob8_ChannelSelect);

   virtual tVoid vVisit_e8_Aud_Beep_Vol_Type(midw_fi_tcl_e8_Aud_Beep_Vol_Type& oe8_Aud_Beep_Vol_Type);

   virtual tVoid vVisit_BeepConfig(midw_fi_tcl_BeepConfig& oBeepConfig);

   virtual tVoid vVisit_e8_AudioDevice_Availability(midw_fi_tcl_e8_AudioDevice_Availability& oe8_AudioDevice_Availability);

   virtual tVoid vVisit_e8_State(midw_fi_tcl_e8_State& oe8_State);

   virtual tVoid vVisit_e8_Aud_VolumeType(midw_fi_tcl_e8_Aud_VolumeType& oe8_Aud_VolumeType);

   virtual tVoid vVisit_Aud_VolumeStatus(midw_fi_tcl_Aud_VolumeStatus& oAud_VolumeStatus);

   virtual tVoid vVisit_Aud_VolumeStatusList(midw_fi_tcl_Aud_VolumeStatusList& oAud_VolumeStatusList);

   virtual tVoid vVisit_e8_BTAudioInLevel(midw_fi_tcl_e8_BTAudioInLevel& oe8_BTAudioInLevel);

   virtual tVoid vVisit_e8_Aud_EDType(midw_fi_tcl_e8_Aud_EDType& oe8_Aud_EDType);

   virtual tVoid vVisit_Aud_EDStatus(midw_fi_tcl_Aud_EDStatus& oAud_EDStatus);

   virtual tVoid vVisit_Aud_EDStatusList(midw_fi_tcl_Aud_EDStatusList& oAud_EDStatusList);

   virtual tVoid vVisit_e8_SurroundSetting(midw_fi_tcl_e8_SurroundSetting& oe8_SurroundSetting);

   virtual tVoid vVisit_e8_AmpTemperatureLevel(midw_fi_tcl_e8_AmpTemperatureLevel& oe8_AmpTemperatureLevel);

   virtual tVoid vVisit_e8_DiagMode(midw_fi_tcl_e8_DiagMode& oe8_DiagMode);

   virtual tVoid vVisit_e8_DiagState(midw_fi_tcl_e8_DiagState& oe8_DiagState);

   virtual tVoid vVisit_e8_Aud_DataId(midw_fi_tcl_e8_Aud_DataId& oe8_Aud_DataId);

   virtual tVoid vVisit_b32_MeasurementResult(midw_fi_tcl_b32_MeasurementResult& ob32_MeasurementResult);

   virtual tVoid vVisit_Aud_MeasurementResultItem(midw_fi_tcl_Aud_MeasurementResultItem& oAud_MeasurementResultItem);

   virtual tVoid vVisit_e8_VolumeLock(midw_fi_tcl_e8_VolumeLock& oe8_VolumeLock);

   virtual tVoid vVisit_e8_Requester(midw_fi_tcl_e8_Requester& oe8_Requester);

   virtual tVoid vVisit_e8_RoomEffect(midw_fi_tcl_e8_RoomEffect& oe8_RoomEffect);

   virtual tVoid vVisit_e8_AudDiagDefSetPhase(midw_fi_tcl_e8_AudDiagDefSetPhase& oe8_AudDiagDefSetPhase);

   virtual tVoid vVisit_e8_AudioMode(midw_fi_tcl_e8_AudioMode& oe8_AudioMode);

   virtual tVoid vVisit_e8_ADAS_UPA_SoundType(midw_fi_tcl_e8_ADAS_UPA_SoundType& oe8_ADAS_UPA_SoundType);

   virtual tVoid vVisit_e8_ADAS_ParkAssist_Volume(midw_fi_tcl_e8_ADAS_ParkAssist_Volume& oe8_ADAS_ParkAssist_Volume);

   virtual tVoid vVisit_e8_ADAS_LDW_UserVolume(midw_fi_tcl_e8_ADAS_LDW_UserVolume& oe8_ADAS_LDW_UserVolume);

   virtual tVoid vVisit_e8_ADAS_Setting_Sound(midw_fi_tcl_e8_ADAS_Setting_Sound& oe8_ADAS_Setting_Sound);

   virtual tVoid vVisit_e8_OnGoingAction(midw_fi_tcl_e8_OnGoingAction& oe8_OnGoingAction);

   virtual tVoid vVisit_e8_BOSE_UnitType(midw_fi_tcl_e8_BOSE_UnitType& oe8_BOSE_UnitType);

   virtual tVoid vVisit_BOSE_UnitConnectionStatus(midw_fi_tcl_BOSE_UnitConnectionStatus& oBOSE_UnitConnectionStatus);

   virtual tVoid vVisit_e8_MicConnection(midw_fi_tcl_e8_MicConnection& oe8_MicConnection);

   virtual tVoid vVisit_e8_MicResult(midw_fi_tcl_e8_MicResult& oe8_MicResult);

   virtual tVoid vVisit_MicrophoneStatus(midw_fi_tcl_MicrophoneStatus& oMicrophoneStatus);

   virtual tVoid vVisit_MicrophoneResult(midw_fi_tcl_MicrophoneResult& oMicrophoneResult);

   virtual tVoid vVisit_e8_AudioPilotIntensity(midw_fi_tcl_e8_AudioPilotIntensity& oe8_AudioPilotIntensity);

   virtual tVoid vVisit_TpegSid(midw_fi_tcl_TpegSid& oTpegSid);

   virtual tVoid vVisit_e8_TpegApplication(midw_fi_tcl_e8_TpegApplication& oe8_TpegApplication);

   virtual tVoid vVisit_e8_TpegLocReferencing(midw_fi_tcl_e8_TpegLocReferencing& oe8_TpegLocReferencing);

   virtual tVoid vVisit_TpegAcid(midw_fi_tcl_TpegAcid& oTpegAcid);

   virtual tVoid vVisit_VersionedTpegAcid(midw_fi_tcl_VersionedTpegAcid& oVersionedTpegAcid);

   virtual tVoid vVisit_TpegStatisticsPerLocRef(midw_fi_tcl_TpegStatisticsPerLocRef& oTpegStatisticsPerLocRef);

   virtual tVoid vVisit_TpegStreamInfo(midw_fi_tcl_TpegStreamInfo& oTpegStreamInfo);

   virtual tVoid vVisit_e8_AudSource(midw_fi_tcl_e8_AudSource& oe8_AudSource);

   virtual tVoid vVisit_e8_SrcActivity(midw_fi_tcl_e8_SrcActivity& oe8_SrcActivity);

   virtual tVoid vVisit_e8_SrcAvailabilityReason(midw_fi_tcl_e8_SrcAvailabilityReason& oe8_SrcAvailabilityReason);

   virtual tVoid vVisit_e8_SrcAvailability(midw_fi_tcl_e8_SrcAvailability& oe8_SrcAvailability);

   virtual tVoid vVisit_SourceAvailablityItem(midw_fi_tcl_SourceAvailablityItem& oSourceAvailablityItem);

   virtual tVoid vVisit_e8MuteAction(midw_fi_tcl_e8MuteAction& oe8MuteAction);

   virtual tVoid vVisit_RequestAudioRouteItem(midw_fi_tcl_RequestAudioRouteItem& oRequestAudioRouteItem);

   virtual tVoid vVisit_e8_AudioProperty(midw_fi_tcl_e8_AudioProperty& oe8_AudioProperty);

   virtual tVoid vVisit_b32MuteReason(midw_fi_tcl_b32MuteReason& ob32MuteReason);

   virtual tVoid vVisit_e8_MuteState(midw_fi_tcl_e8_MuteState& oe8_MuteState);

   virtual tVoid vVisit_MuteRequestItem(midw_fi_tcl_MuteRequestItem& oMuteRequestItem);

   virtual tVoid vVisit_e8_MuteRequester(midw_fi_tcl_e8_MuteRequester& oe8_MuteRequester);

   virtual tVoid vVisit_e8MuteSpeed(midw_fi_tcl_e8MuteSpeed& oe8MuteSpeed);

   virtual tVoid vVisit_SetAudioPropertyItem(midw_fi_tcl_SetAudioPropertyItem& oSetAudioPropertyItem);

   virtual tVoid vVisit_SourceRouteActivity(midw_fi_tcl_SourceRouteActivity& oSourceRouteActivity);

   virtual tVoid vVisit_e8_ResponseCode(midw_fi_tcl_e8_ResponseCode& oe8_ResponseCode);

   virtual tVoid vVisit_e8_ErrorType(midw_fi_tcl_e8_ErrorType& oe8_ErrorType);

   virtual tVoid vVisit_e8_DeviceCategory(midw_fi_tcl_e8_DeviceCategory& oe8_DeviceCategory);

   virtual tVoid vVisit_e8_DeviceConnectionStatus(midw_fi_tcl_e8_DeviceConnectionStatus& oe8_DeviceConnectionStatus);

   virtual tVoid vVisit_e8_DeviceConnectionType(midw_fi_tcl_e8_DeviceConnectionType& oe8_DeviceConnectionType);

   virtual tVoid vVisit_e8_SessionTransportType(midw_fi_tcl_e8_SessionTransportType& oe8_SessionTransportType);

   virtual tVoid vVisit_e8_DeviceStatusInfo(midw_fi_tcl_e8_DeviceStatusInfo& oe8_DeviceStatusInfo);

   virtual tVoid vVisit_e8_AppStatusInfo(midw_fi_tcl_e8_AppStatusInfo& oe8_AppStatusInfo);

   virtual tVoid vVisit_e8_SessionStatus(midw_fi_tcl_e8_SessionStatus& oe8_SessionStatus);

   virtual tVoid vVisit_e8_IconMimeType(midw_fi_tcl_e8_IconMimeType& oe8_IconMimeType);

   virtual tVoid vVisit_e8_OrientationMode(midw_fi_tcl_e8_OrientationMode& oe8_OrientationMode);

   virtual tVoid vVisit_e8_BlockingMode(midw_fi_tcl_e8_BlockingMode& oe8_BlockingMode);

   virtual tVoid vVisit_e8_TouchMode(midw_fi_tcl_e8_TouchMode& oe8_TouchMode);

   virtual tVoid vVisit_e8_KeyMode(midw_fi_tcl_e8_KeyMode& oe8_KeyMode);

   virtual tVoid vVisit_e8_EnabledInfo(midw_fi_tcl_e8_EnabledInfo& oe8_EnabledInfo);

   virtual tVoid vVisit_e8_ScreenAspectRatio(midw_fi_tcl_e8_ScreenAspectRatio& oe8_ScreenAspectRatio);

   virtual tVoid vVisit_e8_DeviceConnectionReq(midw_fi_tcl_e8_DeviceConnectionReq& oe8_DeviceConnectionReq);

   virtual tVoid vVisit_e32_KeyCode(midw_fi_tcl_e32_KeyCode& oe32_KeyCode);

   virtual tVoid vVisit_e32_AppCategory(midw_fi_tcl_e32_AppCategory& oe32_AppCategory);

   virtual tVoid vVisit_e32_AppDisplayCategory(midw_fi_tcl_e32_AppDisplayCategory& oe32_AppDisplayCategory);

   virtual tVoid vVisit_e32_AppAudioCategory(midw_fi_tcl_e32_AppAudioCategory& oe32_AppAudioCategory);

   virtual tVoid vVisit_e16_TrustLevel(midw_fi_tcl_e16_TrustLevel& oe16_TrustLevel);

   virtual tVoid vVisit_e8_AppCertificationInfo(midw_fi_tcl_e8_AppCertificationInfo& oe8_AppCertificationInfo);

   virtual tVoid vVisit_e8_AppCertificationEntity(midw_fi_tcl_e8_AppCertificationEntity& oe8_AppCertificationEntity);

   virtual tVoid vVisit_e8_AppStatus(midw_fi_tcl_e8_AppStatus& oe8_AppStatus);

   virtual tVoid vVisit_e8_DisplayContext(midw_fi_tcl_e8_DisplayContext& oe8_DisplayContext);

   virtual tVoid vVisit_e8_DAPStatus(midw_fi_tcl_e8_DAPStatus& oe8_DAPStatus);

   virtual tVoid vVisit_e8_DiPOAppType(midw_fi_tcl_e8_DiPOAppType& oe8_DiPOAppType);

   virtual tVoid vVisit_e8_EcnrSetting(midw_fi_tcl_e8_EcnrSetting& oe8_EcnrSetting);

   virtual tVoid vVisit_e8_BTChangeInfo(midw_fi_tcl_e8_BTChangeInfo& oe8_BTChangeInfo);

   virtual tVoid vVisit_e8_Vehicle_Configuration(midw_fi_tcl_e8_Vehicle_Configuration& oe8_Vehicle_Configuration);

   virtual tVoid vVisit_e8_Region(midw_fi_tcl_e8_Region& oe8_Region);

   virtual tVoid vVisit_e8_SupportInfo(midw_fi_tcl_e8_SupportInfo& oe8_SupportInfo);

   virtual tVoid vVisit_e8_USBPortType(midw_fi_tcl_e8_USBPortType& oe8_USBPortType);

   virtual tVoid vVisit_e8_DeviceType(midw_fi_tcl_e8_DeviceType& oe8_DeviceType);

   virtual tVoid vVisit_e8_DeviceSelectionState(midw_fi_tcl_e8_DeviceSelectionState& oe8_DeviceSelectionState);

   virtual tVoid vVisit_e8_DeviceSelectionErrorType(midw_fi_tcl_e8_DeviceSelectionErrorType& oe8_DeviceSelectionErrorType);

   virtual tVoid vVisit_e8_SelectionType(midw_fi_tcl_e8_SelectionType& oe8_SelectionType);

   virtual tVoid vVisit_e8_VideoBlockingReason(midw_fi_tcl_e8_VideoBlockingReason& oe8_VideoBlockingReason);

   virtual tVoid vVisit_e8_DeviceSelectionProgressState(midw_fi_tcl_e8_DeviceSelectionProgressState& oe8_DeviceSelectionProgressState);

   virtual tVoid vVisit_DeviceSelectionInfo(midw_fi_tcl_DeviceSelectionInfo& oDeviceSelectionInfo);

   virtual tVoid vVisit_VersionInfo(midw_fi_tcl_VersionInfo& oVersionInfo);

   virtual tVoid vVisit_AppRemotingInfo(midw_fi_tcl_AppRemotingInfo& oAppRemotingInfo);

   virtual tVoid vVisit_AppDisplayInfo(midw_fi_tcl_AppDisplayInfo& oAppDisplayInfo);

   virtual tVoid vVisit_AppAudioInfo(midw_fi_tcl_AppAudioInfo& oAppAudioInfo);

   virtual tVoid vVisit_IconAttributes(midw_fi_tcl_IconAttributes& oIconAttributes);

   virtual tVoid vVisit_ProjectionCapability(midw_fi_tcl_ProjectionCapability& oProjectionCapability);

   virtual tVoid vVisit_EAPAppInfo(midw_fi_tcl_EAPAppInfo& oEAPAppInfo);

   virtual tVoid vVisit_AppDetails(midw_fi_tcl_AppDetails& oAppDetails);

   virtual tVoid vVisit_TouchCoordinates(midw_fi_tcl_TouchCoordinates& oTouchCoordinates);

   virtual tVoid vVisit_TouchInfo(midw_fi_tcl_TouchInfo& oTouchInfo);

   virtual tVoid vVisit_TouchData(midw_fi_tcl_TouchData& oTouchData);

   virtual tVoid vVisit_ScreenAttributes(midw_fi_tcl_ScreenAttributes& oScreenAttributes);

   virtual tVoid vVisit_NotificationEnable(midw_fi_tcl_NotificationEnable& oNotificationEnable);

   virtual tVoid vVisit_NotificationAction(midw_fi_tcl_NotificationAction& oNotificationAction);

   virtual tVoid vVisit_NotificationData(midw_fi_tcl_NotificationData& oNotificationData);

   virtual tVoid vVisit_VideoAttributes(midw_fi_tcl_VideoAttributes& oVideoAttributes);

   virtual tVoid vVisit_KeyCapabilities(midw_fi_tcl_KeyCapabilities& oKeyCapabilities);

   virtual tVoid vVisit_XDeviceKeys(midw_fi_tcl_XDeviceKeys& oXDeviceKeys);

   virtual tVoid vVisit_ClientCapabilities(midw_fi_tcl_ClientCapabilities& oClientCapabilities);

   virtual tVoid vVisit_AudioCapabilities(midw_fi_tcl_AudioCapabilities& oAudioCapabilities);

   virtual tVoid vVisit_DisplayCapabilities(midw_fi_tcl_DisplayCapabilities& oDisplayCapabilities);

   virtual tVoid vVisit_e8_PlayBackState(midw_fi_tcl_e8_PlayBackState& oe8_PlayBackState);

   virtual tVoid vVisit_e8_PlayBackShuffleState(midw_fi_tcl_e8_PlayBackShuffleState& oe8_PlayBackShuffleState);

   virtual tVoid vVisit_e8_PlayBackRepeatState(midw_fi_tcl_e8_PlayBackRepeatState& oe8_PlayBackRepeatState);

   virtual tVoid vVisit_e8_PlayBackMediaType(midw_fi_tcl_e8_PlayBackMediaType& oe8_PlayBackMediaType);

   virtual tVoid vVisit_ApplicationMediaMetaData(midw_fi_tcl_ApplicationMediaMetaData& oApplicationMediaMetaData);

   virtual tVoid vVisit_e8_PhoneSignalStrength(midw_fi_tcl_e8_PhoneSignalStrength& oe8_PhoneSignalStrength);

   virtual tVoid vVisit_e8_PhoneRegistrationStatus(midw_fi_tcl_e8_PhoneRegistrationStatus& oe8_PhoneRegistrationStatus);

   virtual tVoid vVisit_e8_PhoneAirPlaneModeStatus(midw_fi_tcl_e8_PhoneAirPlaneModeStatus& oe8_PhoneAirPlaneModeStatus);

   virtual tVoid vVisit_e8_PhoneCallState(midw_fi_tcl_e8_PhoneCallState& oe8_PhoneCallState);

   virtual tVoid vVisit_e8_PhoneCallDirection(midw_fi_tcl_e8_PhoneCallDirection& oe8_PhoneCallDirection);

   virtual tVoid vVisit_e8_Mute(midw_fi_tcl_e8_Mute& oe8_Mute);

   virtual tVoid vVisit_ApplicationPhoneCallMetadata(midw_fi_tcl_ApplicationPhoneCallMetadata& oApplicationPhoneCallMetadata);

   virtual tVoid vVisit_Time(midw_fi_tcl_Time& oTime);

   virtual tVoid vVisit_e8_CallStateUpdateDisconnectReason(midw_fi_tcl_e8_CallStateUpdateDisconnectReason& oe8_CallStateUpdateDisconnectReason);

   virtual tVoid vVisit_ApplicationPhoneCallExtendedMetadata(midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& oApplicationPhoneCallExtendedMetadata);

   virtual tVoid vVisit_e8_AudioContext(midw_fi_tcl_e8_AudioContext& oe8_AudioContext);

   virtual tVoid vVisit_e8_SpeechAppState(midw_fi_tcl_e8_SpeechAppState& oe8_SpeechAppState);

   virtual tVoid vVisit_e8_PhoneAppState(midw_fi_tcl_e8_PhoneAppState& oe8_PhoneAppState);

   virtual tVoid vVisit_e8_NavigationAppState(midw_fi_tcl_e8_NavigationAppState& oe8_NavigationAppState);

   virtual tVoid vVisit_e8_DiPOSwitchReqResponse(midw_fi_tcl_e8_DiPOSwitchReqResponse& oe8_DiPOSwitchReqResponse);

   virtual tVoid vVisit_e8_DisplayInfo(midw_fi_tcl_e8_DisplayInfo& oe8_DisplayInfo);

   virtual tVoid vVisit_AccessoryDisplayContext(midw_fi_tcl_AccessoryDisplayContext& oAccessoryDisplayContext);

   virtual tVoid vVisit_e8_ResourceTransferType(midw_fi_tcl_e8_ResourceTransferType& oe8_ResourceTransferType);

   virtual tVoid vVisit_e8_ResourceTransferPriority(midw_fi_tcl_e8_ResourceTransferPriority& oe8_ResourceTransferPriority);

   virtual tVoid vVisit_e8_ResourceTransferConstraint(midw_fi_tcl_e8_ResourceTransferConstraint& oe8_ResourceTransferConstraint);

   virtual tVoid vVisit_DisplayConstraint(midw_fi_tcl_DisplayConstraint& oDisplayConstraint);

   virtual tVoid vVisit_e8_DisplayType(midw_fi_tcl_e8_DisplayType& oe8_DisplayType);

   virtual tVoid vVisit_e8_DisplayTouchType(midw_fi_tcl_e8_DisplayTouchType& oe8_DisplayTouchType);

   virtual tVoid vVisit_DisplayLayerAttributes(midw_fi_tcl_DisplayLayerAttributes& oDisplayLayerAttributes);

   virtual tVoid vVisit_DisplayAttributes(midw_fi_tcl_DisplayAttributes& oDisplayAttributes);

   virtual tVoid vVisit_AccessoryAudioContext(midw_fi_tcl_AccessoryAudioContext& oAccessoryAudioContext);

   virtual tVoid vVisit_e8_VehicleState(midw_fi_tcl_e8_VehicleState& oe8_VehicleState);

   virtual tVoid vVisit_e8_ParkBrake(midw_fi_tcl_e8_ParkBrake& oe8_ParkBrake);

   virtual tVoid vVisit_e8_GearState(midw_fi_tcl_e8_GearState& oe8_GearState);

   virtual tVoid vVisit_e8_HandsetInteraction(midw_fi_tcl_e8_HandsetInteraction& oe8_HandsetInteraction);

   virtual tVoid vVisit_e8_UserAuthorizationStatus(midw_fi_tcl_e8_UserAuthorizationStatus& oe8_UserAuthorizationStatus);

   virtual tVoid vVisit_DeviceDetails(midw_fi_tcl_DeviceDetails& oDeviceDetails);

   virtual tVoid vVisit_DeviceAuthInfo(midw_fi_tcl_DeviceAuthInfo& oDeviceAuthInfo);

   virtual tVoid vVisit_FeatureRestriction(midw_fi_tcl_FeatureRestriction& oFeatureRestriction);

   virtual tVoid vVisit_e8_DeviceSelectionMode(midw_fi_tcl_e8_DeviceSelectionMode& oe8_DeviceSelectionMode);

   virtual tVoid vVisit_e8_TurnSide(midw_fi_tcl_e8_TurnSide& oe8_TurnSide);

   virtual tVoid vVisit_e8_NextTurnEvent(midw_fi_tcl_e8_NextTurnEvent& oe8_NextTurnEvent);

   virtual tVoid vVisit_e8_ManeuverDistanceUnits(midw_fi_tcl_e8_ManeuverDistanceUnits& oe8_ManeuverDistanceUnits);

   virtual tVoid vVisit_e8_BTVoiceRecRequest(midw_fi_tcl_e8_BTVoiceRecRequest& oe8_BTVoiceRecRequest);

   virtual tVoid vVisit_e8_BTVoiceRecRequestResponse(midw_fi_tcl_e8_BTVoiceRecRequestResponse& oe8_BTVoiceRecRequestResponse);

   virtual tVoid vVisit_e8_WiFiSecurityType(midw_fi_tcl_e8_WiFiSecurityType& oe8_WiFiSecurityType);

   virtual tVoid vVisit_WiFiAPCredentials(midw_fi_tcl_WiFiAPCredentials& oWiFiAPCredentials);

   virtual tVoid vVisit_e8_FidelityType(midw_fi_tcl_e8_FidelityType& oe8_FidelityType);

   virtual tVoid vVisit_OEMICONDetails(midw_fi_tcl_OEMICONDetails& oOEMICONDetails);

   virtual tVoid vVisit_e8_BatteryChargingState(midw_fi_tcl_e8_BatteryChargingState& oe8_BatteryChargingState);

   virtual tVoid vVisit_e8_DiPoRouteGuidanceState(midw_fi_tcl_e8_DiPoRouteGuidanceState& oe8_DiPoRouteGuidanceState);

   virtual tVoid vVisit_e8_DiPoManeuverType(midw_fi_tcl_e8_DiPoManeuverType& oe8_DiPoManeuverType);

   virtual tVoid vVisit_e8_DiPoManeuverState(midw_fi_tcl_e8_DiPoManeuverState& oe8_DiPoManeuverState);

   virtual tVoid vVisit_e8_DiPoDrivingSide(midw_fi_tcl_e8_DiPoDrivingSide& oe8_DiPoDrivingSide);

   virtual tVoid vVisit_e8_DistanceUnits(midw_fi_tcl_e8_DistanceUnits& oe8_DistanceUnits);

   virtual tVoid vVisit_DiPORouteGuidanceUpdate(midw_fi_tcl_DiPORouteGuidanceUpdate& oDiPORouteGuidanceUpdate);

   virtual tVoid vVisit_e8_DiPoJunctionType(midw_fi_tcl_e8_DiPoJunctionType& oe8_DiPoJunctionType);

   virtual tVoid vVisit_DiPORouteGuidanceManeuverUpdate(midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& oDiPORouteGuidanceManeuverUpdate);

   virtual tVoid vVisit_e8_ComponentID(midw_fi_tcl_e8_ComponentID& oe8_ComponentID);

   virtual tVoid vVisit_CarPlayTBTUpdate(midw_fi_tcl_CarPlayTBTUpdate& oCarPlayTBTUpdate);

   virtual tVoid vVisit_e8_AAutoTurnSide(midw_fi_tcl_e8_AAutoTurnSide& oe8_AAutoTurnSide);

   virtual tVoid vVisit_AAutoNavigationNextTurnDistanceData(midw_fi_tcl_AAutoNavigationNextTurnDistanceData& oAAutoNavigationNextTurnDistanceData);

   virtual tVoid vVisit_e8_AAutoNavigationAppState(midw_fi_tcl_e8_AAutoNavigationAppState& oe8_AAutoNavigationAppState);

   virtual tVoid vVisit_e8_AAutoNextTurnEvent(midw_fi_tcl_e8_AAutoNextTurnEvent& oe8_AAutoNextTurnEvent);

   virtual tVoid vVisit_AAutoNavigationNextTurnData(midw_fi_tcl_AAutoNavigationNextTurnData& oAAutoNavigationNextTurnData);

   virtual tVoid vVisit_AAutoTBTUpdate(midw_fi_tcl_AAutoTBTUpdate& oAAutoTBTUpdate);

   virtual tVoid vVisit_e8_BDCLNavigationAppState(midw_fi_tcl_e8_BDCLNavigationAppState& oe8_BDCLNavigationAppState);

   virtual tVoid vVisit_e8_BDCLNextTurnType(midw_fi_tcl_e8_BDCLNextTurnType& oe8_BDCLNextTurnType);

   virtual tVoid vVisit_CarlifeNaviNextTurnInfo(midw_fi_tcl_CarlifeNaviNextTurnInfo& oCarlifeNaviNextTurnInfo);

   virtual tVoid vVisit_e8_BDCLAssistantType(midw_fi_tcl_e8_BDCLAssistantType& oe8_BDCLAssistantType);

   virtual tVoid vVisit_e8_BDCLTrafficSignType(midw_fi_tcl_e8_BDCLTrafficSignType& oe8_BDCLTrafficSignType);

   virtual tVoid vVisit_CarlifeNaviAssistantGuideInfo(midw_fi_tcl_CarlifeNaviAssistantGuideInfo& oCarlifeNaviAssistantGuideInfo);

   virtual tVoid vVisit_BDCLTBTUpdate(midw_fi_tcl_BDCLTBTUpdate& oBDCLTBTUpdate);

   virtual tVoid vVisit_CarPlayRouteGuidanceUpdate(midw_fi_tcl_CarPlayRouteGuidanceUpdate& oCarPlayRouteGuidanceUpdate);

   virtual tVoid vVisit_ProjectionVideoAttributes(midw_fi_tcl_ProjectionVideoAttributes& oProjectionVideoAttributes);

   virtual tVoid vVisit_e8_DisplayContextReason(midw_fi_tcl_e8_DisplayContextReason& oe8_DisplayContextReason);

   virtual tVoid vVisit_e8_MLGuidanceState(midw_fi_tcl_e8_MLGuidanceState& oe8_MLGuidanceState);

   virtual tVoid vVisit_e8_MLGuidanceActive(midw_fi_tcl_e8_MLGuidanceActive& oe8_MLGuidanceActive);

   virtual tVoid vVisit_MLNavigationInfoUpdate(midw_fi_tcl_MLNavigationInfoUpdate& oMLNavigationInfoUpdate);

   virtual tVoid vVisit_e8_MLNextDirection(midw_fi_tcl_e8_MLNextDirection& oe8_MLNextDirection);

   virtual tVoid vVisit_MLNavigationNextManeuverUpdate(midw_fi_tcl_MLNavigationNextManeuverUpdate& oMLNavigationNextManeuverUpdate);

   virtual tVoid vVisit_e8_DistanceUnit(midw_fi_tcl_e8_DistanceUnit& oe8_DistanceUnit);

   virtual tVoid vVisit_MLNavigationNextDistanceUpdate(midw_fi_tcl_MLNavigationNextDistanceUpdate& oMLNavigationNextDistanceUpdate);

   virtual tVoid vVisit_MLNavigationLaneGuidanceUpdate(midw_fi_tcl_MLNavigationLaneGuidanceUpdate& oMLNavigationLaneGuidanceUpdate);

   virtual tVoid vVisit_MLNavigationTripInfoUpdate(midw_fi_tcl_MLNavigationTripInfoUpdate& oMLNavigationTripInfoUpdate);

   virtual tVoid vVisit_MLSpeedLimitUpdate(midw_fi_tcl_MLSpeedLimitUpdate& oMLSpeedLimitUpdate);

   virtual tVoid vVisit_MLTBTUpdate(midw_fi_tcl_MLTBTUpdate& oMLTBTUpdate);

   virtual tVoid vVisit_e32_Language(midw_fi_tcl_e32_Language& oe32_Language);

   virtual tVoid vVisit_e8_VehiclePowerModeState(midw_fi_tcl_e8_VehiclePowerModeState& oe8_VehiclePowerModeState);

   virtual tVoid vVisit_AmbientColourData(midw_fi_tcl_AmbientColourData& oAmbientColourData);

   virtual tVoid vVisit_e8Media_AppCategory(midw_fi_tcl_e8Media_AppCategory& oe8Media_AppCategory);

   virtual tVoid vVisit_CarPlayRouteGuidanceManeuverUpdate(midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& oCarPlayRouteGuidanceManeuverUpdate);

   virtual tVoid vVisit_RouteGuidanceDisplayComponent(midw_fi_tcl_RouteGuidanceDisplayComponent& oRouteGuidanceDisplayComponent);

   virtual tVoid vVisit_e8_ClientState(midw_fi_tcl_e8_ClientState& oe8_ClientState);

   virtual tVoid vVisit_e32_KeyType(midw_fi_tcl_e32_KeyType& oe32_KeyType);

   virtual tVoid vVisit_KeyInfo(midw_fi_tcl_KeyInfo& oKeyInfo);

   virtual tVoid vVisit_TechnologyKeyConfig(midw_fi_tcl_TechnologyKeyConfig& oTechnologyKeyConfig);

   virtual tVoid vVisit_e8_Entity(midw_fi_tcl_e8_Entity& oe8_Entity);

   virtual tVoid vVisit_HMI_GUI_Point(midw_fi_tcl_HMI_GUI_Point& oHMI_GUI_Point);

   virtual tVoid vVisit_e32_HMI_Gesture_Type(midw_fi_tcl_e32_HMI_Gesture_Type& oe32_HMI_Gesture_Type);

   virtual tVoid vVisit_e32_HMI_Touchpad_Gesture_Type(midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type& oe32_HMI_Touchpad_Gesture_Type);

   virtual tVoid vVisit_e32_HMI_Gesture_Event(midw_fi_tcl_e32_HMI_Gesture_Event& oe32_HMI_Gesture_Event);

   virtual tVoid vVisit_e32_HMI_Gesture_Direction(midw_fi_tcl_e32_HMI_Gesture_Direction& oe32_HMI_Gesture_Direction);

   virtual tVoid vVisit_e32_HMI_CharRecAction(midw_fi_tcl_e32_HMI_CharRecAction& oe32_HMI_CharRecAction);

   virtual tVoid vVisit_e32_HMI_CharRecActionStatus(midw_fi_tcl_e32_HMI_CharRecActionStatus& oe32_HMI_CharRecActionStatus);

   virtual tVoid vVisit_e32_HMI_ViewStatus(midw_fi_tcl_e32_HMI_ViewStatus& oe32_HMI_ViewStatus);

   virtual tVoid vVisit_ApplicationLayerDetails(midw_fi_tcl_ApplicationLayerDetails& oApplicationLayerDetails);

   virtual tVoid vVisit_AppWindowSettings(midw_fi_tcl_AppWindowSettings& oAppWindowSettings);

   virtual tVoid vVisit_e32_HMI_ViewType(midw_fi_tcl_e32_HMI_ViewType& oe32_HMI_ViewType);

   virtual tVoid vVisit_u16_DIMMING_DAY_SLIDER(midw_fi_tcl_u16_DIMMING_DAY_SLIDER& ou16_DIMMING_DAY_SLIDER);

   virtual tVoid vVisit_u16_DIMMING_NIGHT_SLIDER(midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER& ou16_DIMMING_NIGHT_SLIDER);

   virtual tVoid vVisit_u16_DIMMING_PWM_VALUE(midw_fi_tcl_u16_DIMMING_PWM_VALUE& ou16_DIMMING_PWM_VALUE);

   virtual tVoid vVisit_u16_DIMMING_USER_BRIGHTNESS(midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS& ou16_DIMMING_USER_BRIGHTNESS);

   virtual tVoid vVisit_e32_DimmingFeedback(midw_fi_tcl_e32_DimmingFeedback& oe32_DimmingFeedback);

   virtual tVoid vVisit_e8_DimmingSDC(midw_fi_tcl_e8_DimmingSDC& oe8_DimmingSDC);

   virtual tVoid vVisit_e8_DimmingMode(midw_fi_tcl_e8_DimmingMode& oe8_DimmingMode);

   virtual tVoid vVisit_e8_DimmingState(midw_fi_tcl_e8_DimmingState& oe8_DimmingState);

   virtual tVoid vVisit_u8_DIM_LUN(midw_fi_tcl_u8_DIM_LUN& ou8_DIM_LUN);

   virtual tVoid vVisit_u16_DIM_Permille(midw_fi_tcl_u16_DIM_Permille& ou16_DIM_Permille);

   virtual tVoid vVisit_e8_DIM_BrightnessLevel(midw_fi_tcl_e8_DIM_BrightnessLevel& oe8_DIM_BrightnessLevel);

   virtual tVoid vVisit_u8_DIM_Halfclasses(midw_fi_tcl_u8_DIM_Halfclasses& ou8_DIM_Halfclasses);

   virtual tVoid vVisit_e8_DIM_Variants(midw_fi_tcl_e8_DIM_Variants& oe8_DIM_Variants);

   virtual tVoid vVisit_e8_DIM_DisplaySize(midw_fi_tcl_e8_DIM_DisplaySize& oe8_DIM_DisplaySize);

   virtual tVoid vVisit_e8_DIM_Status(midw_fi_tcl_e8_DIM_Status& oe8_DIM_Status);

   virtual tVoid vVisit_e8_DIM_Mode(midw_fi_tcl_e8_DIM_Mode& oe8_DIM_Mode);

   virtual tVoid vVisit_e8_DIM_EmulationMode(midw_fi_tcl_e8_DIM_EmulationMode& oe8_DIM_EmulationMode);

   virtual tVoid vVisit_s16_DIM_Temperature(midw_fi_tcl_s16_DIM_Temperature& os16_DIM_Temperature);

   virtual tVoid vVisit_e8_DIM_WarningLevel(midw_fi_tcl_e8_DIM_WarningLevel& oe8_DIM_WarningLevel);

   virtual tVoid vVisit_e8_DIM_InputConfiguration(midw_fi_tcl_e8_DIM_InputConfiguration& oe8_DIM_InputConfiguration);

   virtual tVoid vVisit_e8_TouchAttr(midw_fi_tcl_e8_TouchAttr& oe8_TouchAttr);

   virtual tVoid vVisit_DispTouchInfo(midw_fi_tcl_DispTouchInfo& oDispTouchInfo);

   virtual tVoid vVisit_e8_KeyAttr(midw_fi_tcl_e8_KeyAttr& oe8_KeyAttr);

   virtual tVoid vVisit_e8_KeyCode(midw_fi_tcl_e8_KeyCode& oe8_KeyCode);

   virtual tVoid vVisit_e8_EncoderCode(midw_fi_tcl_e8_EncoderCode& oe8_EncoderCode);

   virtual tVoid vVisit_e8_EncoderDirection(midw_fi_tcl_e8_EncoderDirection& oe8_EncoderDirection);

   virtual tVoid vVisit_KeyEnc(midw_fi_tcl_KeyEnc& oKeyEnc);

   virtual tVoid vVisit_e8AuxInInfo(midw_fi_tcl_e8AuxInInfo& oe8AuxInInfo);

   virtual tVoid vVisit_DiagCANStatus(midw_fi_tcl_DiagCANStatus& oDiagCANStatus);

   virtual tVoid vVisit_DiagEncoderStatus(midw_fi_tcl_DiagEncoderStatus& oDiagEncoderStatus);

   virtual tVoid vVisit_DiagKeyList(midw_fi_tcl_DiagKeyList& oDiagKeyList);

   virtual tVoid vVisit_KeyList(midw_fi_tcl_KeyList& oKeyList);

   virtual tVoid vVisit_EncoderValuesList(midw_fi_tcl_EncoderValuesList& oEncoderValuesList);

   virtual tVoid vVisit_TouchCoordinateList(midw_fi_tcl_TouchCoordinateList& oTouchCoordinateList);

   virtual tVoid vVisit_DiagEncoderStatusList(midw_fi_tcl_DiagEncoderStatusList& oDiagEncoderStatusList);

   virtual tVoid vVisit_e8_EXT_RD_StatusAction(midw_fi_tcl_e8_EXT_RD_StatusAction& oe8_EXT_RD_StatusAction);

   virtual tVoid vVisit_e8_EXT_RD_SetReason(midw_fi_tcl_e8_EXT_RD_SetReason& oe8_EXT_RD_SetReason);

   virtual tVoid vVisit_e8_EXT_RD_AudioControl(midw_fi_tcl_e8_EXT_RD_AudioControl& oe8_EXT_RD_AudioControl);

   virtual tVoid vVisit_e8_EXT_RD_AudioControlResult(midw_fi_tcl_e8_EXT_RD_AudioControlResult& oe8_EXT_RD_AudioControlResult);

   virtual tVoid vVisit_e8_PageIndex(midw_fi_tcl_e8_PageIndex& oe8_PageIndex);

   virtual tVoid vVisit_e8_CalibStatusToHMI(midw_fi_tcl_e8_CalibStatusToHMI& oe8_CalibStatusToHMI);

   virtual tVoid vVisit_CalibrationPoint(midw_fi_tcl_CalibrationPoint& oCalibrationPoint);

   virtual tVoid vVisit_CalibrationMatrix(midw_fi_tcl_CalibrationMatrix& oCalibrationMatrix);

   virtual tVoid vVisit_e8_VDKBD_MethodResult(midw_fi_tcl_e8_VDKBD_MethodResult& oe8_VDKBD_MethodResult);

   virtual tVoid vVisit_e8_CalibrationType(midw_fi_tcl_e8_CalibrationType& oe8_CalibrationType);

   virtual tVoid vVisit_e8_Response(midw_fi_tcl_e8_Response& oe8_Response);

   virtual tVoid vVisit_e8_UriSelectState(midw_fi_tcl_e8_UriSelectState& oe8_UriSelectState);

   virtual tVoid vVisit_TpegUriChannel(midw_fi_tcl_TpegUriChannel& oTpegUriChannel);

   virtual tVoid vVisit_TpegInfo(midw_fi_tcl_TpegInfo& oTpegInfo);

   virtual tVoid vVisit_TrafficRdbidValue(midw_fi_tcl_TrafficRdbidValue& oTrafficRdbidValue);

   virtual tVoid vVisit_e16_TrafficTmcApplicationId(midw_fi_tcl_e16_TrafficTmcApplicationId& oe16_TrafficTmcApplicationId);

   virtual tVoid vVisit_TrafficEncryption(midw_fi_tcl_TrafficEncryption& oTrafficEncryption);

   virtual tVoid vVisit_e8_TrafficTmcMediumType(midw_fi_tcl_e8_TrafficTmcMediumType& oe8_TrafficTmcMediumType);

   virtual tVoid vVisit_TrafficMsgSource(midw_fi_tcl_TrafficMsgSource& oTrafficMsgSource);

   virtual tVoid vVisit_e16_TrafficInfo(midw_fi_tcl_e16_TrafficInfo& oe16_TrafficInfo);

   virtual tVoid vVisit_e8_OperationMode(midw_fi_tcl_e8_OperationMode& oe8_OperationMode);

   virtual tVoid vVisit_e8_TunerState(midw_fi_tcl_e8_TunerState& oe8_TunerState);

   virtual tVoid vVisit_e8_TunerReceptionState(midw_fi_tcl_e8_TunerReceptionState& oe8_TunerReceptionState);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
