/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_ALLFITYPES_HEADER
#define MIDW_ALLFITYPES_HEADER

#include <vector>

class midw_fi_tclVisitorBase;

const tU16 MIDW_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 MIDW_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 MIDW_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class midw_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  midw_fi_tclTypeBase() {}
  virtual ~midw_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& /*oVisitor*/) {}
};

class midw_fi_tclVisitableTypeBase :public midw_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& /*oVisitor*/) {}
};

class midw_fi_tclU8 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_U8;}
};

class midw_fi_tclS8 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_S8;}
};

class midw_fi_tclU16 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_U16;}
};

class midw_fi_tclS16 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_S16;}
};

class midw_fi_tclU24 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_U24;}
};

class midw_fi_tclS24 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_S24;}
};

class midw_fi_tclU32 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_U32;}
};

class midw_fi_tclS32 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_S32;}
};

class midw_fi_tclU64 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_U64;}
};

class midw_fi_tclS64 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_S64;}
};

class midw_fi_tclF32 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_F32;}
};

class midw_fi_tclF64 : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_F64;}
};

class midw_fi_tclBool : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_BOOL;}
};

class midw_fi_tclString : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tclString(const midw_fi_tclString& coRef);
   midw_fi_tclString& operator=(const midw_fi_tclString& coRef);
   virtual ~midw_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   midw_fi_tclString& operator=(tCString coszString); // ADDED
   midw_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const midw_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class midw_fi_tclList : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_LIST;}
};

class midw_fi_tclMultiLanguageString : public midw_fi_tclVisitableTypeBase
{
public:
   midw_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tclMultiLanguageString(const midw_fi_tclMultiLanguageString& coRef);
   midw_fi_tclMultiLanguageString& operator=(const midw_fi_tclMultiLanguageString& coRef);
   virtual ~midw_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   midw_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   midw_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return midw_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const midw_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class midw_fi_tcl_BinContainer;
class midw_fi_tcl_Reserved;
class midw_fi_tcl_u8_Percent;
class midw_fi_tcl_s16_PerThousand;
class midw_fi_tcl_u16_IndexInReferenceList;
class midw_fi_tcl_u16_ErrorCode;
class midw_fi_tcl_u16_RPM;
class midw_fi_tcl_s32_Kilogram;
class midw_fi_tcl_s32_Pound;
class midw_fi_tcl_s16_Meter;
class midw_fi_tcl_s32_Meter;
class midw_fi_tcl_s32_Yards;
class midw_fi_tcl_s32_Foot;
class midw_fi_tcl_s32_Centimeter;
class midw_fi_tcl_s32_Inch;
class midw_fi_tcl_s32_Millimeter;
class midw_fi_tcl_s32_Microliter;
class midw_fi_tcl_s32_Second;
class midw_fi_tcl_u16_MilliSecond;
class midw_fi_tcl_s32_MilliSecond;
class midw_fi_tcl_POSIXTime;
class midw_fi_tcl_e8_DST_State;
class midw_fi_tcl_TimeZoneElement;
class midw_fi_tcl_s16_KmPerHour;
class midw_fi_tcl_s16_MilesPerHour;
class midw_fi_tcl_s16_Knot;
class midw_fi_tcl_s16_CentimeterSecond;
class midw_fi_tcl_s16_Kelvin;
class midw_fi_tcl_s16_Fahrenheit;
class midw_fi_tcl_s32_Pascal;
class midw_fi_tcl_s32_Watt;
class midw_fi_tcl_FIVersion;
class midw_fi_tcl_s32_Longitude;
class midw_fi_tcl_s32_Latitude;
class midw_fi_tcl_PositionWGS84;
class midw_fi_tcl_RectangleWGS84;
class midw_fi_tcl_e16_ISOCountryCode;
class midw_fi_tcl_e16_ISOLanguageCode;
class midw_fi_tcl_LanguageID;
class midw_fi_tcl_u8_DirectionAbsolute;
class midw_fi_tcl_u8_DirectionRelative;
class midw_fi_tcl_s16_CentiDegree;
class midw_fi_tcl_s16_Degree;
class midw_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class midw_fi_tcl_s16_DirectionRelative_CentiDegree;
class midw_fi_tcl_e8_FuelType;
class midw_fi_tcl_DistTimeFuel;
class midw_fi_tcl_u8TstSrvATestResult;
class midw_fi_tcl_u16TstSrvAEnumeration2;
class midw_fi_tcl_TstSrvB_u8Enumeration1;
class midw_fi_tcl_TstSrvB_u16Enumeration2;
class midw_fi_tcl_u8TstSrvCTestResult;
class midw_fi_tcl_u16TstSrvCEnumeration2;
class midw_fi_tcl_TstSrvD_u8Enumeration1;
class midw_fi_tcl_TstSrvD_u16Enumeration2;
class midw_fi_tcl_e16_iPodAuthSelfTestResult;
class midw_fi_tcl_e8_Tun_SubCommand;
class midw_fi_tcl_e8_Tun_AudioSink;
class midw_fi_tcl_e8_Tun_MTCAudioSource;
class midw_fi_tcl_Tun_UserProfileAction;
class midw_fi_tcl_b8_Tun_AFSwitch;
class midw_fi_tcl_b8_Tun_AudioSink;
class midw_fi_tcl_b8_Tun_AtStationInfoBits;
class midw_fi_tcl_b8_Tun_Tunerbandbits;
class midw_fi_tcl_Audio_FG_BG;
class midw_fi_tcl_e8_Tun_Client;
class midw_fi_tcl_u16CalibrationData;
class midw_fi_tcl_e8_Tun_TunerHeader;
class midw_fi_tcl_AudFGBGStatus;
class midw_fi_tcl_e8_Tun_ResponseStatus;
class midw_fi_tcl_e8_Tun_ResponseState;
class midw_fi_tcl_TunerServer_StatusResponse;
class midw_fi_tcl_e8_Tun_TunerSeek;
class midw_fi_tcl_e8_Tun_PhysicalTuner;
class midw_fi_tcl_e8_Tun_TunerBand;
class midw_fi_tcl_Aud_FGBG_New;
class midw_fi_tcl_e8_Tun_Testmode_TunerBand;
class midw_fi_tcl_e8_Tun_TunerAutostore;
class midw_fi_tcl_e8_Tun_TunerMode;
class midw_fi_tcl_e8_Tun_TunerState;
class midw_fi_tcl_e8_Tun_Announcement;
class midw_fi_tcl_b32_Tun_AvailFlags;
class midw_fi_tcl_e8_Tun_StaticListID;
class midw_fi_tcl_e8_Tun_MixedpresetListID;
class midw_fi_tcl_b32_Tun_Features;
class midw_fi_tcl_b8_Tun_Antenna;
class midw_fi_tcl_TunerStationData;
class midw_fi_tcl_TunerFeature;
class midw_fi_tcl_b32_Tun_AvailableFlags;
class midw_fi_tcl_e8_Tun_ManualFreqAdjustment;
class midw_fi_tcl_e8_Tun_AcceptAF;
class midw_fi_tcl_TunerManualSingleStep;
class midw_fi_tcl_e8_Tun_TunerStaticList;
class midw_fi_tcl_e8_Tun_TunerMixedpresetList;
class midw_fi_tcl_e8_Tun_EnableOrDisable;
class midw_fi_tcl_e8_Tun_OperationFlags;
class midw_fi_tcl_b8_Tun_OperationFlags;
class midw_fi_tcl_TunerOperation;
class midw_fi_tcl_e8_Tun_AFInformation;
class midw_fi_tcl_e8_Tun_Notification;
class midw_fi_tcl_TunerAFList;
class midw_fi_tcl_e8_Tun_AdditionalInfo;
class midw_fi_tcl_b8_Tun_TestmodeBits;
class midw_fi_tcl_e8_Tuner_Mode;
class midw_fi_tcl_e8_DDADDS_Mode;
class midw_fi_tcl_e8_Tun_TMCGroupState;
class midw_fi_tcl_e8_Tun_AntennaState;
class midw_fi_tcl_e8_Tun_IfState;
class midw_fi_tcl_TunerTestModeData;
class midw_fi_tcl_e8_Tun_ListType;
class midw_fi_tcl_e8_Tun_ConfigListID;
class midw_fi_tcl_e8_Tun_Config_Filters;
class midw_fi_tcl_e8_Tun_SortingCriteria;
class midw_fi_tcl_e8_Tun_ModulationType;
class midw_fi_tcl_b8_Tun_Digital_Filters;
class midw_fi_tcl_e16_TmcApplicationId;
class midw_fi_tcl_Encryption;
class midw_fi_tcl_e8_TmcMediumType;
class midw_fi_tcl_MsgSource;
class midw_fi_tcl_Tun_RDBID_Value;
class midw_fi_tcl_TunerRdbId;
class midw_fi_tcl_TunerGetDataTMC;
class midw_fi_tcl_TrafficInfo;
class midw_fi_tcl_b8_Tun_PackedInfo;
class midw_fi_tcl_MakeConfigListElem;
class midw_fi_tcl_b8_Tun_AvailFlags;
class midw_fi_tcl_e8_Tun_HD_TextEncodingType;
class midw_fi_tcl_b8_Tun_StationInfo;
class midw_fi_tcl_e8_Tun_SendernameInfo;
class midw_fi_tcl_Sel_List_Elem;
class midw_fi_tcl_e8_Tun_TMCType;
class midw_fi_tcl_e8_Tun_ListID;
class midw_fi_tcl_e8_Tun_Abs_Or_Rel;
class midw_fi_tcl_e8_Tun_Rel_Steps;
class midw_fi_tcl_e8_Tun_Direction;
class midw_fi_tcl_Tun_Set_PI;
class midw_fi_tcl_e8_Tun_Autostore;
class midw_fi_tcl_e8_Tun_ModeDirection;
class midw_fi_tcl_e8_Tun_ListElementInfo;
class midw_fi_tcl_TunerStaticListElement;
class midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms;
class midw_fi_tcl_TunerConfigListElement;
class midw_fi_tcl_e8_Tun_PresetAction;
class midw_fi_tcl_TunerStaticListElementList;
class midw_fi_tcl_e16_Tun_TroubleCode;
class midw_fi_tcl_e8_Tun_MonitoringMode;
class midw_fi_tcl_e8_Tun_SupervisionControl;
class midw_fi_tcl_TunerTestRoutineParameter;
class midw_fi_tcl_TunerTestRoutineParameterList;
class midw_fi_tcl_e8_Tun_ErrorStatus;
class midw_fi_tcl_e8_Tun_MuteStatus;
class midw_fi_tcl_e8_Tun_RoutineStatus;
class midw_fi_tcl_Tun_TestTroubleCodeStatus;
class midw_fi_tcl_Tun_TestTroubleCodeStatusList;
class midw_fi_tcl_TunerFieldstrength;
class midw_fi_tcl_Tun_Diag_ErrorCode;
class midw_fi_tcl_e8_BandChangeStatus;
class midw_fi_tcl_e8_Tun_Source;
class midw_fi_tcl_e8_Tun_HDAudioProgram;
class midw_fi_tcl_e8_Tun_Autocompare_Mode;
class midw_fi_tcl_Tun_AutoCompParam;
class midw_fi_tcl_Component_Status;
class midw_fi_tcl_e8_AtStationTPinfo;
class midw_fi_tcl_b8_Tun_HDInfoBits;
class midw_fi_tcl_e8_Tun_DiversityState;
class midw_fi_tcl_e8_Tun_AntennaPathSwitch1;
class midw_fi_tcl_e8_Tun_AntennaPathSwitch2;
class midw_fi_tcl_TunerTestModeData_DDADDS;
class midw_fi_tcl_e8_Tun_Engg_Param_ID;
class midw_fi_tcl_e8_Tun_ConfigParam_Type;
class midw_fi_tcl_TuningActionConfigParam;
class midw_fi_tcl_e8_Tun_TestTuneFrequencyMode;
class midw_fi_tcl_b8_AnnoTypes;
class midw_fi_tcl_b8_Anno_Message;
class midw_fi_tcl_AnnoInfostatus;
class midw_fi_tcl_e8_PS_Freeze_Mode;
class midw_fi_tcl_e8_Tun_AnnoTypes;
class midw_fi_tcl_e8_Anno_Message;
class midw_fi_tcl_Tun_Engg_Param_List_Elem;
class midw_fi_tcl_e8_Tun_DefaultSettingOption;
class midw_fi_tcl_AvailableBandInfoElement;
class midw_fi_tcl_AvailableBandInfoList;
class midw_fi_tcl_b8_Tun_DemodSwitch;
class midw_fi_tcl_e8_Tun_SelectMode;
class midw_fi_tcl_TunerBandAndStationInfo;
class midw_fi_tcl_e8_Tun_RelativeDirection;
class midw_fi_tcl_b8_Tun_HDPrgmAvail;
class midw_fi_tcl_b8_Tun_DRMStationInfoBits;
class midw_fi_tcl_b16_Tun_DRMAnnouBits;
class midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices;
class midw_fi_tcl_Atstationinfo;
class midw_fi_tcl_Tun_MakeConfigList;
class midw_fi_tcl_TunerConfigListElementList;
class midw_fi_tcl_TunerRadioText;
class midw_fi_tcl_e8_Tun_DRMSourceActivity;
class midw_fi_tcl_e8_PISearch_Status;
class midw_fi_tcl_TunerHDTestModeData;
class midw_fi_tcl_e8_Tun_HDAdvisoryInfo;
class midw_fi_tcl_e8_Tun_DRMTestModeActivity;
class midw_fi_tcl_e8_Tun_HDImageType;
class midw_fi_tcl_e8_Tun_HDImageCoding;
class midw_fi_tcl_ImageFileInfo;
class midw_fi_tcl_TunPSDCommercial;
class midw_fi_tcl_TunPSDComment;
class midw_fi_tcl_TunPSDData;
class midw_fi_tcl_e8_Tun_TestModeActivity;
class midw_fi_tcl_e8_Tun_TestModeSource;
class midw_fi_tcl_e8_Tun_AudioSplitMode;
class midw_fi_tcl_e16_Tun_ParameterID;
class midw_fi_tcl_PhysicalTunerCalibData;
class midw_fi_tcl_CalibrationData;
class midw_fi_tcl_e8_StationSelectionOption;
class midw_fi_tcl_e8_Tun_Japan_Region;
class midw_fi_tcl_e8_Tun_Language;
class midw_fi_tcl_e8_Tun_ChangeStationMode;
class midw_fi_tcl_TunerJapanStationName;
class midw_fi_tcl_TunerJapanStationNameList;
class midw_fi_tcl_u32FrequencyList;
class midw_fi_tcl_b8_Tun_STATStatusRegister;
class midw_fi_tcl_DARCDataBlock;
class midw_fi_tcl_DARCDataBlockList;
class midw_fi_tcl_TunerListElement;
class midw_fi_tcl_TunerListElementList;
class midw_fi_tcl_b8_Tun_SwitchingFrequency;
class midw_fi_tcl_e8_Band;
class midw_fi_tcl_e8_Preset_Option;
class midw_fi_tcl_e8_Source;
class midw_fi_tcl_e8_Action;
class midw_fi_tcl_e8_WhichTuner;
class midw_fi_tcl_StopAnnouncements;
class midw_fi_tcl_e8_TunMstr_ResponseStatus;
class midw_fi_tcl_TunerMaster_StatusResponse;
class midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response;
class midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode;
class midw_fi_tcl_TunMstr_RadioSetting_StatusResponse;
class midw_fi_tcl_e8_List;
class midw_fi_tcl_e8_RFAntenna;
class midw_fi_tcl_e8_AntennaTest;
class midw_fi_tclunmstr_RFAntenna;
class midw_fi_tcl_e8_RequestResult;
class midw_fi_tcl_e8_AST_Types;
class midw_fi_tcl_e8_Graphics;
class midw_fi_tcl_SXMChannelAttributes;
class midw_fi_tcl_e8_HDAudioProgram;
class midw_fi_tcl_e8_PresetType;
class midw_fi_tcl_SXMChannelImagedata;
class midw_fi_tcl_e8_PSFreeze_Mode;
class midw_fi_tcl_e8_Preset_Action;
class midw_fi_tcl_e8_StationSelection_Option;
class midw_fi_tcl_e8_AnnoTypes;
class midw_fi_tcl_b32_AnnoType;
class midw_fi_tcl_b8_SourceAnno;
class midw_fi_tcl_e8_TunerAvailability;
class midw_fi_tcl_b8_ModeType;
class midw_fi_tcl_e8_StationType;
class midw_fi_tcl_e8_ModulationType;
class midw_fi_tcl_e8_HDTextEncoding;
class midw_fi_tcl_SXMPresetListEntry;
class midw_fi_tcl_e8_TunMst_RadioType;
class midw_fi_tcl_DAB_Label;
class midw_fi_tcl_b8_RadioProfileSettingAction;
class midw_fi_tcl_TunMst_PresetListElement;
class midw_fi_tcl_e8_TunerErrorType;
class midw_fi_tcl_e8SXMChannelArtErrorTypes;
class midw_fi_tcl_PresetList;
class midw_fi_tcl_SXMPresetEntry;
class midw_fi_tcl_e8_SXMSystemMessage;
class midw_fi_tcl_ProfileStatus;
class midw_fi_tcl_ProfileAction;
class midw_fi_tcl_ProfileActionStatus;
class midw_fi_tcl_ProfileResponse;
class midw_fi_tcl_e8_Tun_RequestResult;
class midw_fi_tcl_e8_Tun_AlignCalibrate;
class midw_fi_tcl_e8_Tun_AlignCalibrateStatus;
class midw_fi_tcl_e8_Tun_IFOutput;
class midw_fi_tcl_Tun_IFOutput;
class midw_fi_tcl_e8_Tun_RFAntenna;
class midw_fi_tcl_e8_ATMResult;
class midw_fi_tcl_u8Result;
class midw_fi_tcl_e8_ANTENNA_TEST;
class midw_fi_tcl_Tun_RFAntenna;
class midw_fi_tcl_e8_Tun_TMCInfo;
class midw_fi_tcl_e8_Tun_TPInfo;
class midw_fi_tcl_e8_Tun_TA;
class midw_fi_tcl_e8_Tun_PI;
class midw_fi_tcl_e8_Tun_ProgramKind;
class midw_fi_tcl_e8_Tun_EON;
class midw_fi_tcl_e8_Tun_PTY;
class midw_fi_tcl_b32_TunerFeatureData;
class midw_fi_tcl_b8_Tun_DiagMode;
class midw_fi_tcl_Tun_AlignCalibrateParameterList;
class midw_fi_tcl_TunerDiagMode;
class midw_fi_tcl_Tun_ProgramInfo;
class midw_fi_tcl_TunerBandFrq;
class midw_fi_tcl_TunerAlignCalibrate;
class midw_fi_tcl_e8_ApplicationState;
class midw_fi_tcl_e8_AppMgrMethodResult;
class midw_fi_tcl_ApplicationData;
class midw_fi_tcl_e8_streamrouter_routestate;
class midw_fi_tcl_e8_streamrouter_ramptype;
class midw_fi_tcl_streamrouter_route_entry;
class midw_fi_tcl_streamrouter_routing_list;
class midw_fi_tcl_streamrouter_device_list;
class midw_fi_tcl_e8_streamrouter_fgcommand;
class midw_fi_tcl_e8_DeviceConnectStatus;
class midw_fi_tcl_e8_Device;
class midw_fi_tcl_DevManager_DeviceProperty;
class midw_fi_tcl_DevManager_DevInfoStr;
class midw_fi_tcl_u8Array;
class midw_fi_tcl_e8_InternalError;
class midw_fi_tcl_b32_RoutineBitMask;
class midw_fi_tcl_e8_RoutineStatus;
class midw_fi_tcl_e8_IOResult;
class midw_fi_tcl_e8_SystemSetResult;
class midw_fi_tcl_e8_DiagDataResult;
class midw_fi_tcl_e8_IOControlActionId;
class midw_fi_tcl_e8_SystemSetType;
class midw_fi_tcl_e8_ValueType;
class midw_fi_tcl_ValueUnion;
class midw_fi_tcl_ValueList;
class midw_fi_tcl_e8_MethodResultReply;
class midw_fi_tcl_e8_TestResult;
class midw_fi_tcl_FreezeFrameData;
class midw_fi_tcl_FreezeFrameList;
class midw_fi_tcl_ReadRequestBuffer;
class midw_fi_tcl_ReadResultBuffer;
class midw_fi_tcl_ReadResultStructure;
class midw_fi_tcl_ReadResultList;
class midw_fi_tcl_ITC_Information;
class midw_fi_tcl_ProductionReadResultStructure;
class midw_fi_tcl_ProductionReadResultList;
class midw_fi_tcl_CustomerReadResultStructure;
class midw_fi_tcl_CustomerReadResultList;
class midw_fi_tcl_e8_Protocol;
class midw_fi_tcl_TestResult;
class midw_fi_tcl_TestResultList;
class midw_fi_tcl_SnapshotData;
class midw_fi_tcl_SnapshotDataList;
class midw_fi_tcl_SnapshotIdentification;
class midw_fi_tcl_SnapshotIdentificationList;
class midw_fi_tcl_ClearRequestBuffer;
class midw_fi_tcl_ClearResultBuffer;
class midw_fi_tcl_e8_ControlParameter;
class midw_fi_tcl_ControlList;
class midw_fi_tcl_e8_ReadValue;
class midw_fi_tcl_e8_VDLMediaType;
class midw_fi_tcl_e8_DiaglogDefsetType;
class midw_fi_tcl_e8_SendNextTestResReason;
class midw_fi_tcl_SendNextTestResultStructure;
class midw_fi_tcl_e8_ErrorCode;
class midw_fi_tcl_e8_GMLnGWDTCFaultType;
class midw_fi_tcl_ActiveDTCList;
class midw_fi_tcl_DiagProtocol;
class midw_fi_tcl_e8_Store;
class midw_fi_tcl_e8_RouteCalculationCommand;
class midw_fi_tcl_e8_RouteCalculationStatus;
class midw_fi_tcl_e8_Language;
class midw_fi_tcl_e8_Country;
class midw_fi_tcl_e8_LanguageSubsystem;
class midw_fi_tcl_e8_TestScreens;
class midw_fi_tcl_DisplayStringsList;
class midw_fi_tcl_DisplayData;
class midw_fi_tcl_e8_TroubleCodeType;
class midw_fi_tcl_e8_TestRoutines;
class midw_fi_tcl_e8_DefaultSettingsCategories;
class midw_fi_tcl_CountryLanguage;
class midw_fi_tcl_CountryLanguageResult;
class midw_fi_tcl_e8_TroubleCodeStatus;
class midw_fi_tcl_TroubleCode;
class midw_fi_tcl_TroubleCodeList;
class midw_fi_tcl_RouteCalculationStartParameter;
class midw_fi_tcl_RouteCalculationResultParameter;
class midw_fi_tcl_e16_Language;
class midw_fi_tcl_e16_SpeedLock;
class midw_fi_tcl_MessageBuffer;
class midw_fi_tcl_e8_DefSetMode;
class midw_fi_tcl_e8_DefSetServiceStatus;
class midw_fi_tcl_e8_DefSetGroups;
class midw_fi_tcl_e8_DiagMausSetup;
class midw_fi_tcl_e8_SimulatedKeys;
class midw_fi_tcl_KDSItemList;
class midw_fi_tcl_ConfigItemList;
class midw_fi_tcl_RequestDataUDS;
class midw_fi_tcl_ResponseDataUDS;
class midw_fi_tcl_DiagData;
class midw_fi_tcl_e8_RCtrlSource;
class midw_fi_tcl_e8_RCtrlCommand;
class midw_fi_tcl_e8_RCtrlSignal;
class midw_fi_tcl_e8_DiagRVCSignal;
class midw_fi_tcl_e8_CalibrationTable;
class midw_fi_tcl_CalibrationValue;
class midw_fi_tcl_e8_CalibrationTimeStampMonth;
class midw_fi_tcl_CalibrationTimeStamp;
class midw_fi_tcl_AlphaCode;
class midw_fi_tcl_e8_CalibrationParameterSize;
class midw_fi_tcl_e8_KdsViaUsbUpdateStatus;
class midw_fi_tcl_AntiTheftStatus;
class midw_fi_tcl_e16_Aud_TroubleCode;
class midw_fi_tcl_e8_Aud_MonitoringMode;
class midw_fi_tcl_e8_Aud_SupervisionControl;
class midw_fi_tcl_e8_Aud_ErrorStatus;
class midw_fi_tcl_e8_Aud_RoutineStatus;
class midw_fi_tcl_e8_Aud_WriteTestErrorStatus;
class midw_fi_tcl_e8_Aud_SpeakerType;
class midw_fi_tcl_e8_Aud_TestToneControl;
class midw_fi_tcl_e8_Aud_FreqTestTone;
class midw_fi_tcl_Aud_TestRoutineParameter;
class midw_fi_tcl_Aud_TestRoutineParameterList;
class midw_fi_tcl_Aud_TestTroubleCodeStatus;
class midw_fi_tcl_Aud_TestTroubleCodeStatusList;
class midw_fi_tcl_e8_MicrophoneNumber;
class midw_fi_tcl_e8_MicrophoneConnectionStatus;
class midw_fi_tcl_e8_MicrophoneDetection;
class midw_fi_tcl_MicrophoneConnectionStatus;
class midw_fi_tcl_MicrophoneConnectionStatusList;
class midw_fi_tcl_e8_ResourceNo;
class midw_fi_tcl_e8_AudioServiceStatus;
class midw_fi_tcl_e8_GalaLevel;
class midw_fi_tcl_e8_AudioChannel;
class midw_fi_tcl_e8_AudioVolumeType;
class midw_fi_tcl_e8_AudioSoundType;
class midw_fi_tcl_e8_AudioBeepType;
class midw_fi_tcl_e8_AudioBeepStatus;
class midw_fi_tcl_e8_VolumeMode;
class midw_fi_tcl_e8_SourceNo;
class midw_fi_tcl_e8_RouteNo;
class midw_fi_tcl_e8_Sound;
class midw_fi_tcl_e8_MemStatus;
class midw_fi_tcl_e8_FaderStatus;
class midw_fi_tcl_e8_DynCompression;
class midw_fi_tcl_e8_Optimization;
class midw_fi_tcl_e8_EquPresets;
class midw_fi_tcl_e8_DiagAudMode;
class midw_fi_tcl_e8_GenericDiagAudMode;
class midw_fi_tcl_e8_AuxInLevel;
class midw_fi_tcl_e8_BeepLevel;
class midw_fi_tcl_e8_Rear_Mute;
class midw_fi_tcl_e8_Geometry_Mode;
class midw_fi_tcl_e8_PDCAttenuation;
class midw_fi_tcl_e8_VolumeType;
class midw_fi_tcl_Volume;
class midw_fi_tcl_b8_ChannelSelect;
class midw_fi_tcl_e8_Aud_Beep_Vol_Type;
class midw_fi_tcl_BeepConfig;
class midw_fi_tcl_e8_AudioDevice_Availability;
class midw_fi_tcl_e8_State;
class midw_fi_tcl_e8_Aud_VolumeType;
class midw_fi_tcl_Aud_VolumeStatus;
class midw_fi_tcl_Aud_VolumeStatusList;
class midw_fi_tcl_e8_BTAudioInLevel;
class midw_fi_tcl_e8_Aud_EDType;
class midw_fi_tcl_Aud_EDStatus;
class midw_fi_tcl_Aud_EDStatusList;
class midw_fi_tcl_e8_SurroundSetting;
class midw_fi_tcl_e8_AmpTemperatureLevel;
class midw_fi_tcl_e8_DiagMode;
class midw_fi_tcl_e8_DiagState;
class midw_fi_tcl_e8_Aud_DataId;
class midw_fi_tcl_b32_MeasurementResult;
class midw_fi_tcl_Aud_MeasurementResultItem;
class midw_fi_tcl_e8_VolumeLock;
class midw_fi_tcl_e8_Requester;
class midw_fi_tcl_e8_RoomEffect;
class midw_fi_tcl_e8_AudDiagDefSetPhase;
class midw_fi_tcl_e8_AudioMode;
class midw_fi_tcl_e8_ADAS_UPA_SoundType;
class midw_fi_tcl_e8_ADAS_ParkAssist_Volume;
class midw_fi_tcl_e8_ADAS_LDW_UserVolume;
class midw_fi_tcl_e8_ADAS_Setting_Sound;
class midw_fi_tcl_e8_OnGoingAction;
class midw_fi_tcl_e8_BOSE_UnitType;
class midw_fi_tcl_BOSE_UnitConnectionStatus;
class midw_fi_tcl_e8_MicConnection;
class midw_fi_tcl_e8_MicResult;
class midw_fi_tcl_MicrophoneStatus;
class midw_fi_tcl_MicrophoneResult;
class midw_fi_tcl_e8_AudioPilotIntensity;
class midw_fi_tcl_TpegSid;
class midw_fi_tcl_e8_TpegApplication;
class midw_fi_tcl_e8_TpegLocReferencing;
class midw_fi_tcl_TpegAcid;
class midw_fi_tcl_VersionedTpegAcid;
class midw_fi_tcl_TpegStatisticsPerLocRef;
class midw_fi_tcl_TpegStreamInfo;
class midw_fi_tcl_e8_AudSource;
class midw_fi_tcl_e8_SrcActivity;
class midw_fi_tcl_e8_SrcAvailabilityReason;
class midw_fi_tcl_e8_SrcAvailability;
class midw_fi_tcl_SourceAvailablityItem;
class midw_fi_tcl_e8MuteAction;
class midw_fi_tcl_RequestAudioRouteItem;
class midw_fi_tcl_e8_AudioProperty;
class midw_fi_tcl_b32MuteReason;
class midw_fi_tcl_e8_MuteState;
class midw_fi_tcl_MuteRequestItem;
class midw_fi_tcl_e8_MuteRequester;
class midw_fi_tcl_e8MuteSpeed;
class midw_fi_tcl_SetAudioPropertyItem;
class midw_fi_tcl_SourceRouteActivity;
class midw_fi_tcl_e8_ResponseCode;
class midw_fi_tcl_e8_ErrorType;
class midw_fi_tcl_e8_DeviceCategory;
class midw_fi_tcl_e8_DeviceConnectionStatus;
class midw_fi_tcl_e8_DeviceConnectionType;
class midw_fi_tcl_e8_SessionTransportType;
class midw_fi_tcl_e8_DeviceStatusInfo;
class midw_fi_tcl_e8_AppStatusInfo;
class midw_fi_tcl_e8_SessionStatus;
class midw_fi_tcl_e8_IconMimeType;
class midw_fi_tcl_e8_OrientationMode;
class midw_fi_tcl_e8_BlockingMode;
class midw_fi_tcl_e8_TouchMode;
class midw_fi_tcl_e8_KeyMode;
class midw_fi_tcl_e8_EnabledInfo;
class midw_fi_tcl_e8_ScreenAspectRatio;
class midw_fi_tcl_e8_DeviceConnectionReq;
class midw_fi_tcl_e32_KeyCode;
class midw_fi_tcl_e32_AppCategory;
class midw_fi_tcl_e32_AppDisplayCategory;
class midw_fi_tcl_e32_AppAudioCategory;
class midw_fi_tcl_e16_TrustLevel;
class midw_fi_tcl_e8_AppCertificationInfo;
class midw_fi_tcl_e8_AppCertificationEntity;
class midw_fi_tcl_e8_AppStatus;
class midw_fi_tcl_e8_DisplayContext;
class midw_fi_tcl_e8_DAPStatus;
class midw_fi_tcl_e8_DiPOAppType;
class midw_fi_tcl_e8_EcnrSetting;
class midw_fi_tcl_e8_BTChangeInfo;
class midw_fi_tcl_e8_Vehicle_Configuration;
class midw_fi_tcl_e8_Region;
class midw_fi_tcl_e8_SupportInfo;
class midw_fi_tcl_e8_USBPortType;
class midw_fi_tcl_e8_DeviceType;
class midw_fi_tcl_e8_DeviceSelectionState;
class midw_fi_tcl_e8_DeviceSelectionErrorType;
class midw_fi_tcl_e8_SelectionType;
class midw_fi_tcl_e8_VideoBlockingReason;
class midw_fi_tcl_e8_DeviceSelectionProgressState;
class midw_fi_tcl_DeviceSelectionInfo;
class midw_fi_tcl_VersionInfo;
class midw_fi_tcl_AppRemotingInfo;
class midw_fi_tcl_AppDisplayInfo;
class midw_fi_tcl_AppAudioInfo;
class midw_fi_tcl_IconAttributes;
class midw_fi_tcl_ProjectionCapability;
class midw_fi_tcl_EAPAppInfo;
class midw_fi_tcl_AppDetails;
class midw_fi_tcl_TouchCoordinates;
class midw_fi_tcl_TouchInfo;
class midw_fi_tcl_TouchData;
class midw_fi_tcl_ScreenAttributes;
class midw_fi_tcl_NotificationEnable;
class midw_fi_tcl_NotificationAction;
class midw_fi_tcl_NotificationData;
class midw_fi_tcl_VideoAttributes;
class midw_fi_tcl_KeyCapabilities;
class midw_fi_tcl_XDeviceKeys;
class midw_fi_tcl_ClientCapabilities;
class midw_fi_tcl_AudioCapabilities;
class midw_fi_tcl_DisplayCapabilities;
class midw_fi_tcl_e8_PlayBackState;
class midw_fi_tcl_e8_PlayBackShuffleState;
class midw_fi_tcl_e8_PlayBackRepeatState;
class midw_fi_tcl_e8_PlayBackMediaType;
class midw_fi_tcl_ApplicationMediaMetaData;
class midw_fi_tcl_e8_PhoneSignalStrength;
class midw_fi_tcl_e8_PhoneRegistrationStatus;
class midw_fi_tcl_e8_PhoneAirPlaneModeStatus;
class midw_fi_tcl_e8_PhoneCallState;
class midw_fi_tcl_e8_PhoneCallDirection;
class midw_fi_tcl_e8_Mute;
class midw_fi_tcl_ApplicationPhoneCallMetadata;
class midw_fi_tcl_Time;
class midw_fi_tcl_e8_CallStateUpdateDisconnectReason;
class midw_fi_tcl_ApplicationPhoneCallExtendedMetadata;
class midw_fi_tcl_e8_AudioContext;
class midw_fi_tcl_e8_SpeechAppState;
class midw_fi_tcl_e8_PhoneAppState;
class midw_fi_tcl_e8_NavigationAppState;
class midw_fi_tcl_e8_DiPOSwitchReqResponse;
class midw_fi_tcl_e8_DisplayInfo;
class midw_fi_tcl_AccessoryDisplayContext;
class midw_fi_tcl_e8_ResourceTransferType;
class midw_fi_tcl_e8_ResourceTransferPriority;
class midw_fi_tcl_e8_ResourceTransferConstraint;
class midw_fi_tcl_DisplayConstraint;
class midw_fi_tcl_e8_DisplayType;
class midw_fi_tcl_e8_DisplayTouchType;
class midw_fi_tcl_DisplayLayerAttributes;
class midw_fi_tcl_DisplayAttributes;
class midw_fi_tcl_AccessoryAudioContext;
class midw_fi_tcl_e8_VehicleState;
class midw_fi_tcl_e8_ParkBrake;
class midw_fi_tcl_e8_GearState;
class midw_fi_tcl_e8_HandsetInteraction;
class midw_fi_tcl_e8_UserAuthorizationStatus;
class midw_fi_tcl_DeviceDetails;
class midw_fi_tcl_DeviceAuthInfo;
class midw_fi_tcl_FeatureRestriction;
class midw_fi_tcl_e8_DeviceSelectionMode;
class midw_fi_tcl_e8_TurnSide;
class midw_fi_tcl_e8_NextTurnEvent;
class midw_fi_tcl_e8_ManeuverDistanceUnits;
class midw_fi_tcl_e8_BTVoiceRecRequest;
class midw_fi_tcl_e8_BTVoiceRecRequestResponse;
class midw_fi_tcl_e8_WiFiSecurityType;
class midw_fi_tcl_WiFiAPCredentials;
class midw_fi_tcl_e8_FidelityType;
class midw_fi_tcl_OEMICONDetails;
class midw_fi_tcl_e8_BatteryChargingState;
class midw_fi_tcl_e8_DiPoRouteGuidanceState;
class midw_fi_tcl_e8_DiPoManeuverType;
class midw_fi_tcl_e8_DiPoManeuverState;
class midw_fi_tcl_e8_DiPoDrivingSide;
class midw_fi_tcl_e8_DistanceUnits;
class midw_fi_tcl_DiPORouteGuidanceUpdate;
class midw_fi_tcl_e8_DiPoJunctionType;
class midw_fi_tcl_DiPORouteGuidanceManeuverUpdate;
class midw_fi_tcl_e8_ComponentID;
class midw_fi_tcl_CarPlayTBTUpdate;
class midw_fi_tcl_e8_AAutoTurnSide;
class midw_fi_tcl_AAutoNavigationNextTurnDistanceData;
class midw_fi_tcl_e8_AAutoNavigationAppState;
class midw_fi_tcl_e8_AAutoNextTurnEvent;
class midw_fi_tcl_AAutoNavigationNextTurnData;
class midw_fi_tcl_AAutoTBTUpdate;
class midw_fi_tcl_e8_BDCLNavigationAppState;
class midw_fi_tcl_e8_BDCLNextTurnType;
class midw_fi_tcl_CarlifeNaviNextTurnInfo;
class midw_fi_tcl_e8_BDCLAssistantType;
class midw_fi_tcl_e8_BDCLTrafficSignType;
class midw_fi_tcl_CarlifeNaviAssistantGuideInfo;
class midw_fi_tcl_BDCLTBTUpdate;
class midw_fi_tcl_CarPlayRouteGuidanceUpdate;
class midw_fi_tcl_ProjectionVideoAttributes;
class midw_fi_tcl_e8_DisplayContextReason;
class midw_fi_tcl_e8_MLGuidanceState;
class midw_fi_tcl_e8_MLGuidanceActive;
class midw_fi_tcl_MLNavigationInfoUpdate;
class midw_fi_tcl_e8_MLNextDirection;
class midw_fi_tcl_MLNavigationNextManeuverUpdate;
class midw_fi_tcl_e8_DistanceUnit;
class midw_fi_tcl_MLNavigationNextDistanceUpdate;
class midw_fi_tcl_MLNavigationLaneGuidanceUpdate;
class midw_fi_tcl_MLNavigationTripInfoUpdate;
class midw_fi_tcl_MLSpeedLimitUpdate;
class midw_fi_tcl_MLTBTUpdate;
class midw_fi_tcl_e32_Language;
class midw_fi_tcl_e8_VehiclePowerModeState;
class midw_fi_tcl_AmbientColourData;
class midw_fi_tcl_e8Media_AppCategory;
class midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate;
class midw_fi_tcl_RouteGuidanceDisplayComponent;
class midw_fi_tcl_e8_ClientState;
class midw_fi_tcl_e32_KeyType;
class midw_fi_tcl_KeyInfo;
class midw_fi_tcl_TechnologyKeyConfig;
class midw_fi_tcl_e8_Entity;
class midw_fi_tcl_HMI_GUI_Point;
class midw_fi_tcl_e32_HMI_Gesture_Type;
class midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type;
class midw_fi_tcl_e32_HMI_Gesture_Event;
class midw_fi_tcl_e32_HMI_Gesture_Direction;
class midw_fi_tcl_e32_HMI_CharRecAction;
class midw_fi_tcl_e32_HMI_CharRecActionStatus;
class midw_fi_tcl_e32_HMI_ViewStatus;
class midw_fi_tcl_ApplicationLayerDetails;
class midw_fi_tcl_AppWindowSettings;
class midw_fi_tcl_e32_HMI_ViewType;
class midw_fi_tcl_u16_DIMMING_DAY_SLIDER;
class midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER;
class midw_fi_tcl_u16_DIMMING_PWM_VALUE;
class midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS;
class midw_fi_tcl_e32_DimmingFeedback;
class midw_fi_tcl_e8_DimmingSDC;
class midw_fi_tcl_e8_DimmingMode;
class midw_fi_tcl_e8_DimmingState;
class midw_fi_tcl_u8_DIM_LUN;
class midw_fi_tcl_u16_DIM_Permille;
class midw_fi_tcl_e8_DIM_BrightnessLevel;
class midw_fi_tcl_u8_DIM_Halfclasses;
class midw_fi_tcl_e8_DIM_Variants;
class midw_fi_tcl_e8_DIM_DisplaySize;
class midw_fi_tcl_e8_DIM_Status;
class midw_fi_tcl_e8_DIM_Mode;
class midw_fi_tcl_e8_DIM_EmulationMode;
class midw_fi_tcl_s16_DIM_Temperature;
class midw_fi_tcl_e8_DIM_WarningLevel;
class midw_fi_tcl_e8_DIM_InputConfiguration;
class midw_fi_tcl_e8_TouchAttr;
class midw_fi_tcl_DispTouchInfo;
class midw_fi_tcl_e8_KeyAttr;
class midw_fi_tcl_e8_KeyCode;
class midw_fi_tcl_e8_EncoderCode;
class midw_fi_tcl_e8_EncoderDirection;
class midw_fi_tcl_KeyEnc;
class midw_fi_tcl_e8AuxInInfo;
class midw_fi_tcl_DiagCANStatus;
class midw_fi_tcl_DiagEncoderStatus;
class midw_fi_tcl_DiagKeyList;
class midw_fi_tcl_KeyList;
class midw_fi_tcl_EncoderValuesList;
class midw_fi_tcl_TouchCoordinateList;
class midw_fi_tcl_DiagEncoderStatusList;
class midw_fi_tcl_e8_EXT_RD_StatusAction;
class midw_fi_tcl_e8_EXT_RD_SetReason;
class midw_fi_tcl_e8_EXT_RD_AudioControl;
class midw_fi_tcl_e8_EXT_RD_AudioControlResult;
class midw_fi_tcl_e8_PageIndex;
class midw_fi_tcl_e8_CalibStatusToHMI;
class midw_fi_tcl_CalibrationPoint;
class midw_fi_tcl_CalibrationMatrix;
class midw_fi_tcl_e8_VDKBD_MethodResult;
class midw_fi_tcl_e8_CalibrationType;
class midw_fi_tcl_e8_Response;
class midw_fi_tcl_e8_UriSelectState;
class midw_fi_tcl_TpegUriChannel;
class midw_fi_tcl_TpegInfo;
class midw_fi_tcl_TrafficRdbidValue;
class midw_fi_tcl_e16_TrafficTmcApplicationId;
class midw_fi_tcl_TrafficEncryption;
class midw_fi_tcl_e8_TrafficTmcMediumType;
class midw_fi_tcl_TrafficMsgSource;
class midw_fi_tcl_e16_TrafficInfo;
class midw_fi_tcl_e8_OperationMode;
class midw_fi_tcl_e8_TunerState;
class midw_fi_tcl_e8_TunerReceptionState;
class midw_fi_tcl_BinContainer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_BinContainer& operator=(const midw_fi_tcl_BinContainer& coRef);
   midw_fi_tcl_BinContainer(const midw_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~midw_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Reserved : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Reserved();

   virtual ~midw_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8_Percent : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_PerThousand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_IndexInReferenceList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_ErrorCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_RPM : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Kilogram : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Pound : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_Meter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Meter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Yards : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Foot : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Centimeter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Inch : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Millimeter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Microliter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Second : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_MilliSecond : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_MilliSecond : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_POSIXTime : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_POSIXTime& operator=(const midw_fi_tcl_POSIXTime& coRef);
   midw_fi_tcl_POSIXTime(const midw_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~midw_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DST_State : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_DST_State(midw_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TimeZoneElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TimeZoneElement& operator=(const midw_fi_tcl_TimeZoneElement& coRef);
   midw_fi_tcl_TimeZoneElement(const midw_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclMultiLanguageString Abbreviation_StandardTime;
   midw_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   midw_fi_tcl_s32_Second TimeZoneDifference;
   midw_fi_tcl_e8_DST_State DST_State;
   midw_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~midw_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_KmPerHour : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_MilesPerHour : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_Knot : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_CentimeterSecond : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_Kelvin : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_Fahrenheit : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Pascal : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Watt : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_FIVersion : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_FIVersion& operator=(const midw_fi_tcl_FIVersion& coRef);
   midw_fi_tcl_FIVersion(const midw_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~midw_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Longitude : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s32_Latitude : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_PositionWGS84 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_PositionWGS84& operator=(const midw_fi_tcl_PositionWGS84& coRef);
   midw_fi_tcl_PositionWGS84(const midw_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_s32_Longitude Longitude;
   midw_fi_tcl_s32_Latitude Latitude;
   virtual ~midw_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RectangleWGS84 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RectangleWGS84& operator=(const midw_fi_tcl_RectangleWGS84& coRef);
   midw_fi_tcl_RectangleWGS84(const midw_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_s32_Longitude LongitudeMin;
   midw_fi_tcl_s32_Latitude LatitudeMin;
   midw_fi_tcl_s32_Longitude LongitudeMax;
   midw_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~midw_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_ISOCountryCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   midw_fi_tcl_e16_ISOCountryCode(midw_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_ISOLanguageCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   midw_fi_tcl_e16_ISOLanguageCode(midw_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_LanguageID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_LanguageID& operator=(const midw_fi_tcl_LanguageID& coRef);
   midw_fi_tcl_LanguageID(const midw_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   midw_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~midw_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8_DirectionAbsolute : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8_DirectionRelative : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_CentiDegree : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_Degree : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DirectionAbsolute_CentiDegree : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_DirectionRelative_CentiDegree : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_FuelType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_FuelType(midw_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DistTimeFuel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DistTimeFuel& operator=(const midw_fi_tcl_DistTimeFuel& coRef);
   midw_fi_tcl_DistTimeFuel(const midw_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_s32_Meter Distance;
   midw_fi_tcl_s32_Second Time;
   midw_fi_tcl_s32_Microliter Fuel;
   virtual ~midw_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8TstSrvATestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8TstSrvATestResult();
   enum tenType {
      FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_FAILURE = 0UL,
      FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_u8TstSrvATestResult(midw_fi_tcl_u8TstSrvATestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_u8TstSrvATestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8TstSrvATestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16TstSrvAEnumeration2 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16TstSrvAEnumeration2();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0001 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0XFFFF = 65535UL
   };
   tenType enType;

   midw_fi_tcl_u16TstSrvAEnumeration2(midw_fi_tcl_u16TstSrvAEnumeration2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_u16TstSrvAEnumeration2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16TstSrvAEnumeration2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TstSrvB_u8Enumeration1 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TstSrvB_u8Enumeration1();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X00 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X01 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0XFF = 255UL
   };
   tenType enType;

   midw_fi_tcl_TstSrvB_u8Enumeration1(midw_fi_tcl_TstSrvB_u8Enumeration1::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_TstSrvB_u8Enumeration1();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_TstSrvB_u8Enumeration1& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TstSrvB_u16Enumeration2 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TstSrvB_u16Enumeration2();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0001 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0XFFFF = 65535UL
   };
   tenType enType;

   midw_fi_tcl_TstSrvB_u16Enumeration2(midw_fi_tcl_TstSrvB_u16Enumeration2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_TstSrvB_u16Enumeration2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_TstSrvB_u16Enumeration2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8TstSrvCTestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8TstSrvCTestResult();
   enum tenType {
      FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_FAILURE = 0UL,
      FI_EN_TSTSRV_ENUM_U8_TEST_RESULT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_u8TstSrvCTestResult(midw_fi_tcl_u8TstSrvCTestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_u8TstSrvCTestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8TstSrvCTestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16TstSrvCEnumeration2 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16TstSrvCEnumeration2();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0001 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0XFFFF = 65535UL
   };
   tenType enType;

   midw_fi_tcl_u16TstSrvCEnumeration2(midw_fi_tcl_u16TstSrvCEnumeration2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_u16TstSrvCEnumeration2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16TstSrvCEnumeration2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TstSrvD_u8Enumeration1 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TstSrvD_u8Enumeration1();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X00 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0X01 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U8_VALUE_0XFF = 255UL
   };
   tenType enType;

   midw_fi_tcl_TstSrvD_u8Enumeration1(midw_fi_tcl_TstSrvD_u8Enumeration1::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_TstSrvD_u8Enumeration1();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_TstSrvD_u8Enumeration1& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TstSrvD_u16Enumeration2 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TstSrvD_u16Enumeration2();
   enum tenType {
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0000 = 0UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0X0001 = 1UL,
      FI_EN_GENTSTSRV_ENUM_U16_VALUE_0XFFFF = 65535UL
   };
   tenType enType;

   midw_fi_tcl_TstSrvD_u16Enumeration2(midw_fi_tcl_TstSrvD_u16Enumeration2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_TstSrvD_u16Enumeration2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_TstSrvD_u16Enumeration2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_iPodAuthSelfTestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_iPodAuthSelfTestResult();
   enum tenType {
      FI_EN_IPODAUTHPASSED = 0UL,
      FI_EN_IPODCERTNOTFOUND = 4294967295UL,
      FI_EN_IPODKEYNOTFOUND = 2UL,
      FI_EN_IPODCERTNKEYNOTFOUND = 3UL
   };
   tenType enType;

   midw_fi_tcl_e16_iPodAuthSelfTestResult(midw_fi_tcl_e16_iPodAuthSelfTestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_iPodAuthSelfTestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_iPodAuthSelfTestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_SubCommand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_SubCommand();
   enum tenType {
      FI_EN_TUN_CHANGE_TO_FG = 0UL,
      FI_EN_TUN_CHANGE_TO_BG = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_SubCommand(midw_fi_tcl_e8_Tun_SubCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_SubCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_SubCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AudioSink : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AudioSink();
   enum tenType {
      FI_EN_TUN_USR1_CHANGE_TO_FG_BG = 0UL,
      FI_EN_TUN_TA_CHANGE_TO_FG_BG = 1UL,
      FI_EN_TUN_TIM_CHANGE_TO_FG_BG = 2UL,
      FI_EN_TUN_PTY_CHANGE_TO_FG_BG = 3UL,
      FI_EN_TUN_NEWS_CHANGE_TO_FG_BG = 4UL,
      FI_EN_TUN_DABTEMP_CHANGE_TO_FG_BG = 5UL,
      FI_EN_TUN_TEMPFM_CHANGE_TO_FG_BG = 6UL,
      FI_EN_TUN_WEATHERALERT_CHANGE_TO_FG_BG = 7UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AudioSink(midw_fi_tcl_e8_Tun_AudioSink::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AudioSink();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AudioSink& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_MTCAudioSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_MTCAudioSource();
   enum tenType {
      FI_EN_TUN_LASTAUDIOSOURCE = 255UL,
      FI_EN_TUN_NOHEARDSOURCE = 0UL,
      FI_EN_TUN_USERAUDIOFM = 1UL,
      FI_EN_TUN_USERAUDIODAB = 2UL,
      FI_EN_TUN_USERAUDIOLW = 3UL,
      FI_EN_TUN_USERAUDIOMW = 4UL,
      FI_EN_TUN_USERAUDIOTRF = 5UL,
      FI_EN_TUN_USERAUDIOWB = 6UL,
      FI_EN_TUN_USERAUDIOCB1 = 21UL,
      FI_EN_TUN_USERAUDIOCB2 = 22UL,
      FI_EN_TUN_ANNOAUDIORDS = 30UL,
      FI_EN_TUN_PTY31AUDIORDS = 31UL,
      FI_EN_TUN_DAB_ALARM = 40UL,
      FI_EN_TUN_DAB_ROADTRAFFIC = 41UL,
      FI_EN_TUN_DAB_TRANSPORT = 42UL,
      FI_EN_TUN_DAB_WARNINGSERVICE = 43UL,
      FI_EN_TUN_DAB_NEWS = 44UL,
      FI_EN_TUN_DAB_WEATHER = 45UL,
      FI_EN_TUN_DAB_EVENT = 46UL,
      FI_EN_TUN_DAB_SPECIALEVENT = 47UL,
      FI_EN_TUN_DAB_PROGRAMMEINFO = 48UL,
      FI_EN_TUN_DAB_SPORTREPORT = 49UL,
      FI_EN_TUN_DAB_FINANCIALREPORT = 50UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_MTCAudioSource(midw_fi_tcl_e8_Tun_MTCAudioSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_MTCAudioSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_MTCAudioSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_UserProfileAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_UserProfileAction();
   enum tenType {
      FI_EN_TUN_PROFILE_CHANGE = 0UL,
      FI_EN_TUN_PROFILE_DELETE = 1UL,
      FI_EN_TUN_PROFILE_COPY = 2UL
   };
   tenType enType;

   midw_fi_tcl_Tun_UserProfileAction(midw_fi_tcl_Tun_UserProfileAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_Tun_UserProfileAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_Tun_UserProfileAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_AFSwitch : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_AFSwitch();

   enum {
      FI_C_U8_BIT_RDS_AFBEST = 0x1UL,
      FI_C_U8_BIT_UNUSED = 0x2UL,
      FI_C_U8_BIT_DRM_AFBEST = 0x4UL
   };
   tBool bRDS_AFBEST() const {return (u8Value & FI_C_U8_BIT_RDS_AFBEST) != 0; }
   tVoid vSetRDS_AFBEST(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RDS_AFBEST):(u8Value & ~(tU8)FI_C_U8_BIT_RDS_AFBEST)); }
   tBool bunused() const {return (u8Value & FI_C_U8_BIT_UNUSED) != 0; }
   tVoid vSetunused(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_UNUSED):(u8Value & ~(tU8)FI_C_U8_BIT_UNUSED)); }
   tBool bDRM_AFBEST() const {return (u8Value & FI_C_U8_BIT_DRM_AFBEST) != 0; }
   tVoid vSetDRM_AFBEST(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM_AFBEST):(u8Value & ~(tU8)FI_C_U8_BIT_DRM_AFBEST)); }
   struct rBitValues {
      tBool RDS_AFBEST:1;
      tBool unused:1;
      tBool DRM_AFBEST:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_AFSwitch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_AFSwitch& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_AudioSink : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_AudioSink();

   enum {
      FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG = 0x1UL,
      FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG = 0x2UL,
      FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG = 0x4UL,
      FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG = 0x8UL,
      FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG = 0x10UL,
      FI_C_U8_BIT_DABTEMP_SWITCHED_TUN_TOFG = 0x20UL,
      FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG = 0x40UL,
      FI_C_U8_BIT_RESERVED1 = 0x80UL
   };
   tBool bUSR1_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetUSR1_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG)); }
   tBool bTA_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetTA_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG)); }
   tBool bTIM_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetTIM_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG)); }
   tBool bPTY_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetPTY_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG)); }
   tBool bNEWS_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetNEWS_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG)); }
   tBool bDABTEMP_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_DABTEMP_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetDABTEMP_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DABTEMP_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_DABTEMP_SWITCHED_TUN_TOFG)); }
   tBool bTEMPFM_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG) != 0; }
   tVoid vSetTEMPFM_SWITCHED_TUN_TOFG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG):(u8Value & ~(tU8)FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG)); }
   tBool bRESERVED1() const {return (u8Value & FI_C_U8_BIT_RESERVED1) != 0; }
   tVoid vSetRESERVED1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED1):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED1)); }
   struct rBitValues {
      tBool USR1_SWITCHED_TUN_TOFG:1;
      tBool TA_SWITCHED_TUN_TOFG:1;
      tBool TIM_SWITCHED_TUN_TOFG:1;
      tBool PTY_SWITCHED_TUN_TOFG:1;
      tBool NEWS_SWITCHED_TUN_TOFG:1;
      tBool DABTEMP_SWITCHED_TUN_TOFG:1;
      tBool TEMPFM_SWITCHED_TUN_TOFG:1;
      tBool RESERVED1:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_AudioSink();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_AudioSink& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_AtStationInfoBits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_AtStationInfoBits();

   enum {
      FI_C_U8_BIT_MONO_OR_STEREO_BIT = 0x1UL,
      FI_C_U8_BIT_SPEECH_OR_MUSIC_BIT = 0x2UL,
      FI_C_U8_BIT_RADIOTEXT_POSSIBLE_BIT = 0x4UL,
      FI_C_U8_BIT_ALTERNATE_FREQUENCY_BIT = 0x8UL,
      FI_C_U8_BIT_RADIOTEXT_AVAILABLE_BIT = 0x10UL,
      FI_C_U8_BIT_AF_AVAILABLE_BIT = 0x20UL,
      FI_C_U8_BIT_HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE = 0x40UL,
      FI_C_U8_BIT_MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL = 0x80UL
   };
   tBool bMONO_OR_STEREO_BIT() const {return (u8Value & FI_C_U8_BIT_MONO_OR_STEREO_BIT) != 0; }
   tVoid vSetMONO_OR_STEREO_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MONO_OR_STEREO_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_MONO_OR_STEREO_BIT)); }
   tBool bSPEECH_OR_MUSIC_BIT() const {return (u8Value & FI_C_U8_BIT_SPEECH_OR_MUSIC_BIT) != 0; }
   tVoid vSetSPEECH_OR_MUSIC_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPEECH_OR_MUSIC_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_SPEECH_OR_MUSIC_BIT)); }
   tBool bRADIOTEXT_POSSIBLE_BIT() const {return (u8Value & FI_C_U8_BIT_RADIOTEXT_POSSIBLE_BIT) != 0; }
   tVoid vSetRADIOTEXT_POSSIBLE_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RADIOTEXT_POSSIBLE_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_RADIOTEXT_POSSIBLE_BIT)); }
   tBool bALTERNATE_FREQUENCY_BIT() const {return (u8Value & FI_C_U8_BIT_ALTERNATE_FREQUENCY_BIT) != 0; }
   tVoid vSetALTERNATE_FREQUENCY_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_ALTERNATE_FREQUENCY_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_ALTERNATE_FREQUENCY_BIT)); }
   tBool bRADIOTEXT_AVAILABLE_BIT() const {return (u8Value & FI_C_U8_BIT_RADIOTEXT_AVAILABLE_BIT) != 0; }
   tVoid vSetRADIOTEXT_AVAILABLE_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RADIOTEXT_AVAILABLE_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_RADIOTEXT_AVAILABLE_BIT)); }
   tBool bAF_AVAILABLE_BIT() const {return (u8Value & FI_C_U8_BIT_AF_AVAILABLE_BIT) != 0; }
   tVoid vSetAF_AVAILABLE_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AF_AVAILABLE_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_AF_AVAILABLE_BIT)); }
   tBool bHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE() const {return (u8Value & FI_C_U8_BIT_HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE) != 0; }
   tVoid vSetHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE):(u8Value & ~(tU8)FI_C_U8_BIT_HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE)); }
   tBool bMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL() const {return (u8Value & FI_C_U8_BIT_MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL) != 0; }
   tVoid vSetMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL):(u8Value & ~(tU8)FI_C_U8_BIT_MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL)); }
   struct rBitValues {
      tBool MONO_OR_STEREO_BIT:1;
      tBool SPEECH_OR_MUSIC_BIT:1;
      tBool RADIOTEXT_POSSIBLE_BIT:1;
      tBool ALTERNATE_FREQUENCY_BIT:1;
      tBool RADIOTEXT_AVAILABLE_BIT:1;
      tBool AF_AVAILABLE_BIT:1;
      tBool HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE:1;
      tBool MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_AtStationInfoBits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_AtStationInfoBits& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_Tunerbandbits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_Tunerbandbits();

   enum {
      FI_C_U8_BIT_DDAMASTER_OR_NOT_A_DDAMASTER = 0x1UL,
      FI_C_U8_BIT_DDASLAVE_OR_NOT_A_DDASLAVE = 0x2UL,
      FI_C_U8_BIT_FM_SUPPORTED_OR_FM_NOTSUPPORTED = 0x4UL,
      FI_C_U8_BIT_AM_SUPPORTED_OR_AM_NOTSUPPORTED = 0x8UL,
      FI_C_U8_BIT_DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED = 0x10UL,
      FI_C_U8_BIT_DABL_SUPPORTED_OR_DABL_NOTSUPPORTED = 0x20UL
   };
   tBool bDDAMASTER_OR_NOT_A_DDAMASTER() const {return (u8Value & FI_C_U8_BIT_DDAMASTER_OR_NOT_A_DDAMASTER) != 0; }
   tVoid vSetDDAMASTER_OR_NOT_A_DDAMASTER(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DDAMASTER_OR_NOT_A_DDAMASTER):(u8Value & ~(tU8)FI_C_U8_BIT_DDAMASTER_OR_NOT_A_DDAMASTER)); }
   tBool bDDASLAVE_OR_NOT_A_DDASLAVE() const {return (u8Value & FI_C_U8_BIT_DDASLAVE_OR_NOT_A_DDASLAVE) != 0; }
   tVoid vSetDDASLAVE_OR_NOT_A_DDASLAVE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DDASLAVE_OR_NOT_A_DDASLAVE):(u8Value & ~(tU8)FI_C_U8_BIT_DDASLAVE_OR_NOT_A_DDASLAVE)); }
   tBool bFM_SUPPORTED_OR_FM_NOTSUPPORTED() const {return (u8Value & FI_C_U8_BIT_FM_SUPPORTED_OR_FM_NOTSUPPORTED) != 0; }
   tVoid vSetFM_SUPPORTED_OR_FM_NOTSUPPORTED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FM_SUPPORTED_OR_FM_NOTSUPPORTED):(u8Value & ~(tU8)FI_C_U8_BIT_FM_SUPPORTED_OR_FM_NOTSUPPORTED)); }
   tBool bAM_SUPPORTED_OR_AM_NOTSUPPORTED() const {return (u8Value & FI_C_U8_BIT_AM_SUPPORTED_OR_AM_NOTSUPPORTED) != 0; }
   tVoid vSetAM_SUPPORTED_OR_AM_NOTSUPPORTED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AM_SUPPORTED_OR_AM_NOTSUPPORTED):(u8Value & ~(tU8)FI_C_U8_BIT_AM_SUPPORTED_OR_AM_NOTSUPPORTED)); }
   tBool bDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED() const {return (u8Value & FI_C_U8_BIT_DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED) != 0; }
   tVoid vSetDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED)); }
   tBool bDABL_SUPPORTED_OR_DABL_NOTSUPPORTED() const {return (u8Value & FI_C_U8_BIT_DABL_SUPPORTED_OR_DABL_NOTSUPPORTED) != 0; }
   tVoid vSetDABL_SUPPORTED_OR_DABL_NOTSUPPORTED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DABL_SUPPORTED_OR_DABL_NOTSUPPORTED):(u8Value & ~(tU8)FI_C_U8_BIT_DABL_SUPPORTED_OR_DABL_NOTSUPPORTED)); }
   struct rBitValues {
      tBool DDAMASTER_OR_NOT_A_DDAMASTER:1;
      tBool DDASLAVE_OR_NOT_A_DDASLAVE:1;
      tBool FM_SUPPORTED_OR_FM_NOTSUPPORTED:1;
      tBool AM_SUPPORTED_OR_AM_NOTSUPPORTED:1;
      tBool DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED:1;
      tBool DABL_SUPPORTED_OR_DABL_NOTSUPPORTED:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_Tunerbandbits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_Tunerbandbits& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Audio_FG_BG : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Audio_FG_BG();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Audio_FG_BG& operator=(const midw_fi_tcl_Audio_FG_BG& coRef);
   midw_fi_tcl_Audio_FG_BG(const midw_fi_tcl_Audio_FG_BG& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_SubCommand u8SubCommand;
   midw_fi_tcl_e8_Tun_AudioSink u8AudioSink;
   virtual ~midw_fi_tcl_Audio_FG_BG();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Audio_FG_BG& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Client : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Client();
   enum tenType {
      FI_EN_DAB = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Client(midw_fi_tcl_e8_Tun_Client::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Client();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Client& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16CalibrationData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16CalibrationData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_u16CalibrationData& operator=(const midw_fi_tcl_u16CalibrationData& coRef);
   midw_fi_tcl_u16CalibrationData(const midw_fi_tcl_u16CalibrationData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DataLength;
   std::vector<tU16, std::allocator<tU16> > CalibrationValues;
   virtual ~midw_fi_tcl_u16CalibrationData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_u16CalibrationData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerHeader : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerHeader();
   enum tenType {
      FI_EN_TUN_FOREGROUND = 0UL,
      FI_EN_TUN_BACKGROUND = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerHeader(midw_fi_tcl_e8_Tun_TunerHeader::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerHeader();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerHeader& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AudFGBGStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AudFGBGStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AudFGBGStatus& operator=(const midw_fi_tcl_AudFGBGStatus& coRef);
   midw_fi_tcl_AudFGBGStatus(const midw_fi_tcl_AudFGBGStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8_TunerHeader;
   midw_fi_tcl_b8_Tun_AudioSink u8AudioSink;
   midw_fi_tcl_e8_Tun_MTCAudioSource e8MTCAudioSource;
   virtual ~midw_fi_tcl_AudFGBGStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AudFGBGStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ResponseStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ResponseStatus();
   enum tenType {
      FI_EN_TUN_RES_REQ_SUCCEED = 0UL,
      FI_EN_TUN_RES_REQ_FAIL = 1UL,
      FI_EN_TUN_RES_PREV_REQ_INPROCESS = 2UL,
      FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED = 3UL,
      FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ResponseStatus(midw_fi_tcl_e8_Tun_ResponseStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ResponseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ResponseStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ResponseState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ResponseState();
   enum tenType {
      FI_EN_TUN_TUN_STATE_NORMAL = 1UL,
      FI_EN_TUN_STATE_DIAGNOSIS = 2UL,
      FI_EN_TUN_STATE_PAUSE = 3UL,
      FI_EN_TUN_STATE_OFF = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ResponseState(midw_fi_tcl_e8_Tun_ResponseState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ResponseState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ResponseState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerServer_StatusResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerServer_StatusResponse();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerServer_StatusResponse& operator=(const midw_fi_tcl_TunerServer_StatusResponse& coRef);
   midw_fi_tcl_TunerServer_StatusResponse(const midw_fi_tcl_TunerServer_StatusResponse& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ResponseStatus u8TunerStatus;
   midw_fi_tcl_e8_Tun_ResponseState u8TunerState;
   virtual ~midw_fi_tcl_TunerServer_StatusResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerServer_StatusResponse& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerSeek : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerSeek();
   enum tenType {
      FI_EN_TUN_SEEKTYPE_OFF = 0UL,
      FI_EN_TUN_SEEKTYPE_UP_AUTO = 1UL,
      FI_EN_TUN_SEEKTYPE_UP_SCAN_PRESET = 2UL,
      FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY = 3UL,
      FI_EN_TUN_SEEKTYPE_UP_CONTINOUS_UNMUTED = 4UL,
      FI_EN_TUN_SEEKTYPE_UP_PRESET = 5UL,
      FI_EN_TUN_SEEKTYPE_UP_STATION_LIST = 6UL,
      FI_EN_TUN_SEEKTYPE_DOWN_AUTO = 7UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PRESET = 8UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SCAN_FREQUENCY = 9UL,
      FI_EN_TUN_SEEKTYPE_DOWN_CONTINOUS_UNMUTED = 10UL,
      FI_EN_TUN_SEEKTYPE_DOWN_PRESET = 11UL,
      FI_EN_TUN_SEEKTYPE_DOWN_STATION_LIST = 12UL,
      FI_EN_TUN_SEEKTYPE_UP_RDS = 13UL,
      FI_EN_TUN_SEEKTYPE_DOWN_RDS = 14UL,
      FI_EN_TUN_SEEKTYPE_UP_RDS_PTY = 15UL,
      FI_EN_TUN_SEEKTYPE_DOWN_RDS_PTY = 16UL,
      FI_EN_TUN_SEEKTYPE_UP_TP = 17UL,
      FI_EN_TUN_SEEKTYPE_DOWN_TP = 18UL,
      FI_EN_TUN_SEEKTYPE_UP_SELF_TP = 19UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SELF_TP = 20UL,
      FI_EN_TUN_SEEKTYPE_TP_PTY_UP = 21UL,
      FI_EN_TUN_SEEKTYPE_TP_PTY_DOWN = 22UL,
      FI_EN_TUN_SEEKTYPE_SELF_TP_PTY_UP = 23UL,
      FI_EN_TUN_SEEKTYPE_SELF_TP_PTY_DOWN = 24UL,
      FI_EN_TUN_SEEKTYPE_UP_CONTINUOUS_MUTED = 25UL,
      FI_EN_TUN_SEEKTYPE_DOWN_CONTINUOUS_MUTED = 26UL,
      FI_EN_TUN_SEEKTYPE_UP_SCAN_PI = 27UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PI = 28UL,
      FI_EN_TUN_SEEKTYPE_UP_SCAN_SORTED_PS = 29UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SCAN_SORTED_PS = 30UL,
      FI_EN_TUN_SEEKTYPE_UP_SCAN_ACTIVE_STATIONLIST = 31UL,
      FI_EN_TUN_SEEKTYPE_DOWN_SCAN_ACTIVE_STATIONLIST = 32UL,
      FI_EN_TUN_SEEKTYPE_UP_DRM_FREQUENCY = 33UL,
      FI_EN_TUN_SEEKTYPE_DOWN_DRM_FREQUENCY = 34UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerSeek(midw_fi_tcl_e8_Tun_TunerSeek::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerSeek();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerSeek& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_PhysicalTuner : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_PhysicalTuner();
   enum tenType {
      FI_EN_TUNER_0 = 0UL,
      FI_EN_TUNER_1 = 1UL,
      FI_EN_TUNER_2 = 2UL,
      FI_EN_TUNER_3 = 3UL,
      FI_EN_TUNER_AUTO = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_PhysicalTuner(midw_fi_tcl_e8_Tun_PhysicalTuner::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_PhysicalTuner();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_PhysicalTuner& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerBand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerBand();
   enum tenType {
      FI_EN_TUN_BAND_FM = 0UL,
      FI_EN_TUN_BAND_LW = 1UL,
      FI_EN_TUN_BAND_MW = 2UL,
      FI_EN_TUN_BAND_CB1 = 20UL,
      FI_EN_TUN_BAND_TRF = 17UL,
      FI_EN_TUN_BAND_WB = 18UL,
      FI_EN_TUN_BAND_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerBand(midw_fi_tcl_e8_Tun_TunerBand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerBand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerBand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_FGBG_New : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_FGBG_New();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_FGBG_New& operator=(const midw_fi_tcl_Aud_FGBG_New& coRef);
   midw_fi_tcl_Aud_FGBG_New(const midw_fi_tcl_Aud_FGBG_New& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8_TunerHeader;
   midw_fi_tcl_e8_Tun_SubCommand u8SubCommand;
   midw_fi_tcl_e8_Tun_AudioSink u8AudioSink;
   tBool bTunerState;
   midw_fi_tcl_e8_Tun_PhysicalTuner u8_PhysicalTuner;
   midw_fi_tcl_e8_Tun_TunerBand e8Band;
   midw_fi_tcl_e8_Tun_MTCAudioSource e8MTCAudioSource;
   virtual ~midw_fi_tcl_Aud_FGBG_New();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_FGBG_New& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Testmode_TunerBand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Testmode_TunerBand();
   enum tenType {
      FI_EN_TUN_BAND_FM = 1UL,
      FI_EN_TUN_BAND_FM_NON_RDS = 2UL,
      FI_EN_TUN_BAND_AM = 3UL,
      FI_EN_TUN_BAND_DAB = 6UL,
      FI_EN_UNKNOWN = 0UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Testmode_TunerBand(midw_fi_tcl_e8_Tun_Testmode_TunerBand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Testmode_TunerBand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Testmode_TunerBand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerAutostore : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerAutostore();
   enum tenType {
      FI_EN_TUN_AUTOSTORE_NO = 0UL,
      FI_EN_TUN_AUTOSTORE_NORMAL = 1UL,
      FI_EN_TUN_AUTOSTORE_INITIAL = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerAutostore(midw_fi_tcl_e8_Tun_TunerAutostore::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerAutostore();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerAutostore& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerMode();
   enum tenType {
      FI_EN_TUN_MODE_NORM = 0UL,
      FI_EN_TUN_MODE_BANDSCAN = 1UL,
      FI_EN_TUN_MODE_STATIC_LISTSCAN = 2UL,
      FI_EN_TUN_MODE_CONFIG_LISTSCAN = 3UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerMode(midw_fi_tcl_e8_Tun_TunerMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerState();
   enum tenType {
      FI_EN_TUN_STATE_PLAY = 0UL,
      FI_EN_TUN_STATE_SEEK = 1UL,
      FI_EN_TUN_STATE_STOP = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerState(midw_fi_tcl_e8_Tun_TunerState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Announcement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Announcement();
   enum tenType {
      FI_EN_TUN_NO_ANNOUNCEMENT = 0UL,
      FI_EN_TUN_ANNOUNCEMENT_TA = 1UL,
      FI_EN_TUN_ANNOUNCEMENT_PTY = 2UL,
      FI_EN_TUN_ANNOUNCEMENT_PTY_31 = 3UL,
      FI_EN_TUN_ANNOUNCEMENT_NEWS = 4UL,
      FI_EN_TUN_ANNOUNCEMENT_TA_ACTIVE = 16UL,
      FI_EN_TUN_ANNOUNCEMENT_EON = 32UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Announcement(midw_fi_tcl_e8_Tun_Announcement::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Announcement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Announcement& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_Tun_AvailFlags : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_Tun_AvailFlags();

   enum {
      FI_C_U32_BIT_TUN_FRQ_AVAILABLE = 0x1UL,
      FI_C_U32_BIT_TUN_PS_AVAILABLE = 0x2UL,
      FI_C_U32_BIT_TUN_PI_AVAILABLE = 0x4UL,
      FI_C_U32_BIT_TUN_PTY_AVAILABLE = 0x8UL,
      FI_C_U32_BIT_TUN_CT_AVAILABLE = 0x10UL,
      FI_C_U32_BIT_TUN_TMC_AVAILABLE = 0x20UL,
      FI_C_U32_BIT_TUN_RDS_AVAILABLE = 0x40UL,
      FI_C_U32_BIT_TUN_REG_AVAILABLE = 0x80UL,
      FI_C_U32_BIT_TUN_AF_AVAILABLE = 0x100UL,
      FI_C_U32_BIT_TUN_PTY_EON_AVAILABLE = 0x200UL,
      FI_C_U32_BIT_TUN_RT_AVAILABLE = 0x400UL,
      FI_C_U32_BIT_TUN_JAPAN_PS_AVAILABLE = 0x800UL,
      FI_C_U32_BIT_TUN_AUTO_COMPARE_AVAILABLE = 0x1000UL
   };
   tBool bTUN_FRQ_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_FRQ_AVAILABLE) != 0; }
   tVoid vSetTUN_FRQ_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FRQ_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FRQ_AVAILABLE)); }
   tBool bTUN_PS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_PS_AVAILABLE) != 0; }
   tVoid vSetTUN_PS_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_PS_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_PS_AVAILABLE)); }
   tBool bTUN_PI_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_PI_AVAILABLE) != 0; }
   tVoid vSetTUN_PI_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_PI_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_PI_AVAILABLE)); }
   tBool bTUN_PTY_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_PTY_AVAILABLE) != 0; }
   tVoid vSetTUN_PTY_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_PTY_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_PTY_AVAILABLE)); }
   tBool bTUN_CT_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_CT_AVAILABLE) != 0; }
   tVoid vSetTUN_CT_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_CT_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_CT_AVAILABLE)); }
   tBool bTUN_TMC_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_TMC_AVAILABLE) != 0; }
   tVoid vSetTUN_TMC_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_TMC_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_TMC_AVAILABLE)); }
   tBool bTUN_RDS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_RDS_AVAILABLE) != 0; }
   tVoid vSetTUN_RDS_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_RDS_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_RDS_AVAILABLE)); }
   tBool bTUN_REG_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_REG_AVAILABLE) != 0; }
   tVoid vSetTUN_REG_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_REG_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_REG_AVAILABLE)); }
   tBool bTUN_AF_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AF_AVAILABLE) != 0; }
   tVoid vSetTUN_AF_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_AF_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_AF_AVAILABLE)); }
   tBool bTUN_PTY_EON_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_PTY_EON_AVAILABLE) != 0; }
   tVoid vSetTUN_PTY_EON_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_PTY_EON_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_PTY_EON_AVAILABLE)); }
   tBool bTUN_RT_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_RT_AVAILABLE) != 0; }
   tVoid vSetTUN_RT_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_RT_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_RT_AVAILABLE)); }
   tBool bTUN_JAPAN_PS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_JAPAN_PS_AVAILABLE) != 0; }
   tVoid vSetTUN_JAPAN_PS_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_JAPAN_PS_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_JAPAN_PS_AVAILABLE)); }
   tBool bTUN_AUTO_COMPARE_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AUTO_COMPARE_AVAILABLE) != 0; }
   tVoid vSetTUN_AUTO_COMPARE_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_AUTO_COMPARE_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_AUTO_COMPARE_AVAILABLE)); }
   struct rBitValues {
      tBool TUN_FRQ_AVAILABLE:1;
      tBool TUN_PS_AVAILABLE:1;
      tBool TUN_PI_AVAILABLE:1;
      tBool TUN_PTY_AVAILABLE:1;
      tBool TUN_CT_AVAILABLE:1;
      tBool TUN_TMC_AVAILABLE:1;
      tBool TUN_RDS_AVAILABLE:1;
      tBool TUN_REG_AVAILABLE:1;
      tBool TUN_AF_AVAILABLE:1;
      tBool TUN_PTY_EON_AVAILABLE:1;
      tBool TUN_RT_AVAILABLE:1;
      tBool TUN_JAPAN_PS_AVAILABLE:1;
      tBool TUN_AUTO_COMPARE_AVAILABLE:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_Tun_AvailFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_Tun_AvailFlags& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_StaticListID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_StaticListID();
   enum tenType {
      FI_EN_TUN_TUN_STATIC_LIST_FM1 = 0UL,
      FI_EN_TUN_TUN_STATIC_LIST_FM2 = 1UL,
      FI_EN_TUN_TUN_STATIC_LIST_FM3 = 2UL,
      FI_EN_TUN_TUN_STATIC_LIST_AST = 3UL,
      FI_EN_TUN_TUN_STATIC_LIST_AM1 = 4UL,
      FI_EN_TUN_TUN_STATIC_LIST_LW1 = 5UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_StaticListID(midw_fi_tcl_e8_Tun_StaticListID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_StaticListID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_StaticListID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_MixedpresetListID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_MixedpresetListID();
   enum tenType {
      FI_EN_TUN_TUN_MIXEDPRESET_LIST_FMAM = 0UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_MixedpresetListID(midw_fi_tcl_e8_Tun_MixedpresetListID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_MixedpresetListID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_MixedpresetListID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_Tun_Features : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_Tun_Features();

   enum {
      FI_C_U32_BIT_TUN_FEATURE_AF_MODE = 0x1UL,
      FI_C_U32_BIT_TUN_FEATURE_CT_MODE = 0x2UL,
      FI_C_U32_BIT_TUN_FEATURE_LOC_MODE = 0x4UL,
      FI_C_U32_BIT_TUN_FEATURE_UNUSED = 0x8UL,
      FI_C_U32_BIT_TUN_FEATURE_MONO_MODE = 0x10UL,
      FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE = 0x20UL,
      FI_C_U32_BIT_TUN_FEATURE_REG_MODE = 0x80UL,
      FI_C_U32_BIT_TUN_FEATURE_RT_MODE = 0x100UL,
      FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE = 0x200UL,
      FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE = 0x400UL,
      FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE = 0x800UL,
      FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE = 0x1000UL,
      FI_C_U32_BIT_TUN_FEATURE_TMC_MODE = 0x4000UL,
      FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE = 0x8000UL,
      FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE = 0x10000UL,
      FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE = 0x20000UL,
      FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE = 0x40000UL,
      FI_C_U32_BIT_TUN_FEATURE_DDA_MODE = 0x80000UL,
      FI_C_U32_BIT_TUN_FEATURE_DDS_MODE = 0x100000UL,
      FI_C_U32_BIT_TUN_FEATURE_RESERVED = 0x200000UL,
      FI_C_U32_BIT_TUN_FEATURE_MEASURE_MODE = 0x400000UL,
      FI_C_U32_BIT_TUN_FEATURE_AMFMSETUP_MODE = 0x800000UL,
      FI_C_U32_BIT_TUN_FEATURE_PERSISTENTSTORAGE_MODE = 0x1000000UL
   };
   tBool bTUN_FEATURE_AF_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_AF_MODE) != 0; }
   tVoid vSetTUN_FEATURE_AF_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_AF_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_AF_MODE)); }
   tBool bTUN_FEATURE_CT_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_CT_MODE) != 0; }
   tVoid vSetTUN_FEATURE_CT_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_CT_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_CT_MODE)); }
   tBool bTUN_FEATURE_LOC_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_LOC_MODE) != 0; }
   tVoid vSetTUN_FEATURE_LOC_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_LOC_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_LOC_MODE)); }
   tBool bTUN_FEATURE_unused() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_UNUSED) != 0; }
   tVoid vSetTUN_FEATURE_unused(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_UNUSED):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_UNUSED)); }
   tBool bTUN_FEATURE_MONO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_MONO_MODE) != 0; }
   tVoid vSetTUN_FEATURE_MONO_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_MONO_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_MONO_MODE)); }
   tBool bTUN_FEATURE_PSFIX_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE) != 0; }
   tVoid vSetTUN_FEATURE_PSFIX_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE)); }
   tBool bTUN_FEATURE_REG_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_REG_MODE) != 0; }
   tVoid vSetTUN_FEATURE_REG_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_REG_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_REG_MODE)); }
   tBool bTUN_FEATURE_RT_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RT_MODE) != 0; }
   tVoid vSetTUN_FEATURE_RT_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_RT_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_RT_MODE)); }
   tBool bTUN_FEATURE_SEARCH_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE) != 0; }
   tVoid vSetTUN_FEATURE_SEARCH_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE)); }
   tBool bTUN_FEATURE_SEEK_SENSE_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE) != 0; }
   tVoid vSetTUN_FEATURE_SEEK_SENSE_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE)); }
   tBool bTUN_FEATURE_SHARX_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE) != 0; }
   tVoid vSetTUN_FEATURE_SHARX_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE)); }
   tBool bTUN_FEATURE_TM_DATA_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE) != 0; }
   tVoid vSetTUN_FEATURE_TM_DATA_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE)); }
   tBool bTUN_FEATURE_TMC_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_TMC_MODE) != 0; }
   tVoid vSetTUN_FEATURE_TMC_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_TMC_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_TMC_MODE)); }
   tBool bTUN_FEATURE_KHZ50_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE) != 0; }
   tVoid vSetTUN_FEATURE_KHZ50_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE)); }
   tBool bTUN_FEATURE_REG_AUTO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE) != 0; }
   tVoid vSetTUN_FEATURE_REG_AUTO_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE)); }
   tBool bTUN_FEATURE_NEWS_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE) != 0; }
   tVoid vSetTUN_FEATURE_NEWS_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE)); }
   tBool bTUN_FEATURE_RDS_AUTO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE) != 0; }
   tVoid vSetTUN_FEATURE_RDS_AUTO_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE)); }
   tBool bTUN_FEATURE_DDA_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_DDA_MODE) != 0; }
   tVoid vSetTUN_FEATURE_DDA_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_DDA_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_DDA_MODE)); }
   tBool bTUN_FEATURE_DDS_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_DDS_MODE) != 0; }
   tVoid vSetTUN_FEATURE_DDS_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_DDS_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_DDS_MODE)); }
   tBool bTUN_FEATURE_reserved() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RESERVED) != 0; }
   tVoid vSetTUN_FEATURE_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_RESERVED)); }
   tBool bTUN_FEATURE_MEASURE_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_MEASURE_MODE) != 0; }
   tVoid vSetTUN_FEATURE_MEASURE_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_MEASURE_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_MEASURE_MODE)); }
   tBool bTUN_FEATURE_AMFMSETUP_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_AMFMSETUP_MODE) != 0; }
   tVoid vSetTUN_FEATURE_AMFMSETUP_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_AMFMSETUP_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_AMFMSETUP_MODE)); }
   tBool bTUN_FEATURE_PERSISTENTSTORAGE_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PERSISTENTSTORAGE_MODE) != 0; }
   tVoid vSetTUN_FEATURE_PERSISTENTSTORAGE_MODE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_PERSISTENTSTORAGE_MODE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_PERSISTENTSTORAGE_MODE)); }
   struct rBitValues {
      tBool TUN_FEATURE_AF_MODE:1;
      tBool TUN_FEATURE_CT_MODE:1;
      tBool TUN_FEATURE_LOC_MODE:1;
      tBool TUN_FEATURE_unused:1;
      tBool TUN_FEATURE_MONO_MODE:1;
      tBool TUN_FEATURE_PSFIX_MODE:1;
      tBool dummy6:1;
      tBool TUN_FEATURE_REG_MODE:1;
      tBool TUN_FEATURE_RT_MODE:1;
      tBool TUN_FEATURE_SEARCH_MODE:1;
      tBool TUN_FEATURE_SEEK_SENSE_MODE:1;
      tBool TUN_FEATURE_SHARX_MODE:1;
      tBool TUN_FEATURE_TM_DATA_MODE:1;
      tBool dummy13:1;
      tBool TUN_FEATURE_TMC_MODE:1;
      tBool TUN_FEATURE_KHZ50_MODE:1;
      tBool TUN_FEATURE_REG_AUTO_MODE:1;
      tBool TUN_FEATURE_NEWS_MODE:1;
      tBool TUN_FEATURE_RDS_AUTO_MODE:1;
      tBool TUN_FEATURE_DDA_MODE:1;
      tBool TUN_FEATURE_DDS_MODE:1;
      tBool TUN_FEATURE_reserved:1;
      tBool TUN_FEATURE_MEASURE_MODE:1;
      tBool TUN_FEATURE_AMFMSETUP_MODE:1;
      tBool TUN_FEATURE_PERSISTENTSTORAGE_MODE:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_Tun_Features();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_Tun_Features& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_Antenna : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_Antenna();

   enum {
      FI_C_U8_BIT_TUNER_ANTENNA1 = 0x1UL,
      FI_C_U8_BIT_TUNER_ANTENNA2 = 0x2UL
   };
   tBool bTUNER_ANTENNA1() const {return (u8Value & FI_C_U8_BIT_TUNER_ANTENNA1) != 0; }
   tVoid vSetTUNER_ANTENNA1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNER_ANTENNA1):(u8Value & ~(tU8)FI_C_U8_BIT_TUNER_ANTENNA1)); }
   tBool bTUNER_ANTENNA2() const {return (u8Value & FI_C_U8_BIT_TUNER_ANTENNA2) != 0; }
   tVoid vSetTUNER_ANTENNA2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNER_ANTENNA2):(u8Value & ~(tU8)FI_C_U8_BIT_TUNER_ANTENNA2)); }
   struct rBitValues {
      tBool TUNER_ANTENNA1:1;
      tBool TUNER_ANTENNA2:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_Antenna();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_Antenna& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerStationData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerStationData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerStationData& operator=(const midw_fi_tcl_TunerStationData& coRef);
   midw_fi_tcl_TunerStationData(const midw_fi_tcl_TunerStationData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   tU8 u8PTY;
   tU16 u16PackedInfo;
   midw_fi_tcl_b32_Tun_AvailFlags u32AvailFlags;
   tU32 u32Frequency;
   tU32 u32PI;
   tU8 u8PSName1;
   tU8 u8PSName2;
   tU8 u8PSName3;
   tU8 u8PSName4;
   tU8 u8PSName5;
   tU8 u8PSName6;
   tU8 u8PSName7;
   tU8 u8PSName8;
   midw_fi_tclString sPSName;
   virtual ~midw_fi_tcl_TunerStationData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerStationData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerFeature : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerFeature();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerFeature& operator=(const midw_fi_tcl_TunerFeature& coRef);
   midw_fi_tcl_TunerFeature(const midw_fi_tcl_TunerFeature& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b32_Tun_Features b32Features;
   midw_fi_tcl_b32_Tun_Features b32MaskFeatures;
   virtual ~midw_fi_tcl_TunerFeature();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerFeature& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_Tun_AvailableFlags : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_Tun_AvailableFlags();

   enum {
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE = 0x1UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RESERVED = 0x2UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE = 0x4UL
   };
   tBool bTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_reserved() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RESERVED) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RESERVED)); }
   tBool bTUN_AVAILABLE_FLAGS_PS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_PS_AVAILABLE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE)); }
   struct rBitValues {
      tBool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_reserved:1;
      tBool TUN_AVAILABLE_FLAGS_PS_AVAILABLE:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_Tun_AvailableFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_Tun_AvailableFlags& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ManualFreqAdjustment : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ManualFreqAdjustment();
   enum tenType {
      FI_EN_TUN_SEEK_DIRECTION_UP = 0UL,
      FI_EN_TUN_SEEK_DIRECTION_DOWN = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ManualFreqAdjustment(midw_fi_tcl_e8_Tun_ManualFreqAdjustment::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ManualFreqAdjustment();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ManualFreqAdjustment& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AcceptAF : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AcceptAF();
   enum tenType {
      FI_EN_TUN_NOT_ACCEPT_AF = 0UL,
      FI_EN_TUN_ACCEPT_AF = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AcceptAF(midw_fi_tcl_e8_Tun_AcceptAF::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AcceptAF();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AcceptAF& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerManualSingleStep : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerManualSingleStep();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerManualSingleStep& operator=(const midw_fi_tcl_TunerManualSingleStep& coRef);
   midw_fi_tcl_TunerManualSingleStep(const midw_fi_tcl_TunerManualSingleStep& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment;
   tU8 u8NumberOfTicks;
   virtual ~midw_fi_tcl_TunerManualSingleStep();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerManualSingleStep& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerStaticList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerStaticList();
   enum tenType {
      FI_EN_TUN_TUN_STATIC_LIST_FM1 = 0UL,
      FI_EN_TUN_TUN_STATIC_LIST_FM2 = 1UL,
      FI_EN_TUN_TUN_STATIC_LIST_FM3 = 2UL,
      FI_EN_TUN_TUN_STATIC_LIST_AST = 3UL,
      FI_EN_TUN_TUN_STATIC_LIST_AM1 = 4UL,
      FI_EN_TUN_TUN_STATIC_LIST_LW1 = 5UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerStaticList(midw_fi_tcl_e8_Tun_TunerStaticList::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerStaticList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerStaticList& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TunerMixedpresetList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TunerMixedpresetList();
   enum tenType {
      FI_EN_TUN_TUN_MIXEDPRESET_LIST_FM1 = 0UL,
      FI_EN_TUN_TUN_MIXEDPRESET_LIST_FM2 = 1UL,
      FI_EN_TUN_TUN_MIXEDPRESET_LIST_AM = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TunerMixedpresetList(midw_fi_tcl_e8_Tun_TunerMixedpresetList::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TunerMixedpresetList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TunerMixedpresetList& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_EnableOrDisable : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_EnableOrDisable();
   enum tenType {
      FI_EN_DISABLE = 0UL,
      FI_EN_ENABLE = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_EnableOrDisable(midw_fi_tcl_e8_Tun_EnableOrDisable::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_EnableOrDisable();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_EnableOrDisable& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_OperationFlags : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_OperationFlags();
   enum tenType {
      FI_EN_TUN_OPERATION_AFBEST = 1UL,
      FI_EN_TUN_OPERATION_PTY = 2UL,
      FI_EN_TUN_OPERATION_SEARCH = 4UL,
      FI_EN_TUN_OPERATION_TA = 8UL,
      FI_EN_TUN_OPERATION_TPSEEK = 16UL,
      FI_EN_TUN_OPERATION_ACTION = 32UL,
      FI_EN_TUN_OPERATION_SEEK_LEVEL_LOGIC = 64UL,
      FI_EN_TUN_OPERATION_RESERVED = 128UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_OperationFlags(midw_fi_tcl_e8_Tun_OperationFlags::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_OperationFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_OperationFlags& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_OperationFlags : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_OperationFlags();

   enum {
      FI_C_U8_BIT_TUN_OPERATION_AFBEST = 0x1UL,
      FI_C_U8_BIT_TUN_OPERATION_PTY = 0x2UL,
      FI_C_U8_BIT_TUN_OPERATION_SEARCH = 0x4UL,
      FI_C_U8_BIT_TUN_OPERATION_TA = 0x8UL,
      FI_C_U8_BIT_TUN_OPERATION_TPSEEK = 0x10UL,
      FI_C_U8_BIT_TUN_OPERATION_ACTION = 0x20UL,
      FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC = 0x40UL,
      FI_C_U8_BIT_TUN_OPERATION_RESERVED = 0x80UL
   };
   tBool bTUN_OPERATION_AFBEST() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_AFBEST) != 0; }
   tVoid vSetTUN_OPERATION_AFBEST(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_AFBEST):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_AFBEST)); }
   tBool bTUN_OPERATION_PTY() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_PTY) != 0; }
   tVoid vSetTUN_OPERATION_PTY(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_PTY):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_PTY)); }
   tBool bTUN_OPERATION_SEARCH() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_SEARCH) != 0; }
   tVoid vSetTUN_OPERATION_SEARCH(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_SEARCH):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_SEARCH)); }
   tBool bTUN_OPERATION_TA() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_TA) != 0; }
   tVoid vSetTUN_OPERATION_TA(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_TA):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_TA)); }
   tBool bTUN_OPERATION_TPSEEK() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_TPSEEK) != 0; }
   tVoid vSetTUN_OPERATION_TPSEEK(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_TPSEEK):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_TPSEEK)); }
   tBool bTUN_OPERATION_ACTION() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_ACTION) != 0; }
   tVoid vSetTUN_OPERATION_ACTION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_ACTION):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_ACTION)); }
   tBool bTUN_OPERATION_SEEK_LEVEL_LOGIC() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC) != 0; }
   tVoid vSetTUN_OPERATION_SEEK_LEVEL_LOGIC(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC)); }
   tBool bTUN_OPERATION_reserved() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_RESERVED) != 0; }
   tVoid vSetTUN_OPERATION_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_OPERATION_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_OPERATION_RESERVED)); }
   struct rBitValues {
      tBool TUN_OPERATION_AFBEST:1;
      tBool TUN_OPERATION_PTY:1;
      tBool TUN_OPERATION_SEARCH:1;
      tBool TUN_OPERATION_TA:1;
      tBool TUN_OPERATION_TPSEEK:1;
      tBool TUN_OPERATION_ACTION:1;
      tBool TUN_OPERATION_SEEK_LEVEL_LOGIC:1;
      tBool TUN_OPERATION_reserved:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_OperationFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_OperationFlags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerOperation : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerOperation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerOperation& operator=(const midw_fi_tcl_TunerOperation& coRef);
   midw_fi_tcl_TunerOperation(const midw_fi_tcl_TunerOperation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_EnableOrDisable u8EnableOrDisable;
   midw_fi_tcl_e8_Tun_OperationFlags u8OperationFlags;
   virtual ~midw_fi_tcl_TunerOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerOperation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AFInformation : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AFInformation();
   enum tenType {
      FI_EN_TUN_AF_UNKNOWN = 0UL,
      FI_EN_TUN_AF_WRONG_PI = 1UL,
      FI_EN_TUN_AF_SAME_PI = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AFInformation(midw_fi_tcl_e8_Tun_AFInformation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AFInformation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AFInformation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Notification : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Notification();
   enum tenType {
      FI_EN_TUN_NOTIFICATION_OFF = 0UL,
      FI_EN_TUN_NOTIFICATION_ON_TEST_MODE_ON = 1UL,
      FI_EN_TUN_SINGLE_REQUEST = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Notification(midw_fi_tcl_e8_Tun_Notification::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Notification();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Notification& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerAFList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerAFList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerAFList& operator=(const midw_fi_tcl_TunerAFList& coRef);
   midw_fi_tcl_TunerAFList(const midw_fi_tcl_TunerAFList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   tU8 u8AFListElementID;
   tU32 u32AFFrequency;
   tU8 u8AFQualityLevel;
   tU8 u8AFFieldStrength;
   tU8 u8AFBitErrorRate;
   midw_fi_tcl_e8_Tun_AFInformation u8AFInfo;
   tU16 u16AFPI;
   virtual ~midw_fi_tcl_TunerAFList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerAFList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AdditionalInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AdditionalInfo();
   enum tenType {
      FI_EN_TUN_RDS_SYNC = 1UL,
      FI_EN_TUN_AF_CHANGE_REQUEST = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AdditionalInfo(midw_fi_tcl_e8_Tun_AdditionalInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AdditionalInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AdditionalInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_TestmodeBits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_TestmodeBits();

   enum {
      FI_C_U8_BIT_TUN_TP_BIT = 0x1UL,
      FI_C_U8_BIT_TUN_TA_BIT = 0x2UL,
      FI_C_U8_BIT_TUN_TMC_BIT = 0x4UL,
      FI_C_U8_BIT_TUN_UNUSED_BIT = 0x8UL,
      FI_C_U8_BIT_TUN_AUDIO_TUNER_BIT = 0x10UL
   };
   tBool bTUN_TP_BIT() const {return (u8Value & FI_C_U8_BIT_TUN_TP_BIT) != 0; }
   tVoid vSetTUN_TP_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TP_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TP_BIT)); }
   tBool bTUN_TA_BIT() const {return (u8Value & FI_C_U8_BIT_TUN_TA_BIT) != 0; }
   tVoid vSetTUN_TA_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TA_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TA_BIT)); }
   tBool bTUN_TMC_BIT() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_BIT) != 0; }
   tVoid vSetTUN_TMC_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TMC_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TMC_BIT)); }
   tBool bTUN_UNUSED_BIT() const {return (u8Value & FI_C_U8_BIT_TUN_UNUSED_BIT) != 0; }
   tVoid vSetTUN_UNUSED_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_UNUSED_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_UNUSED_BIT)); }
   tBool bTUN_AUDIO_TUNER_BIT() const {return (u8Value & FI_C_U8_BIT_TUN_AUDIO_TUNER_BIT) != 0; }
   tVoid vSetTUN_AUDIO_TUNER_BIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AUDIO_TUNER_BIT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AUDIO_TUNER_BIT)); }
   struct rBitValues {
      tBool TUN_TP_BIT:1;
      tBool TUN_TA_BIT:1;
      tBool TUN_TMC_BIT:1;
      tBool TUN_UNUSED_BIT:1;
      tBool TUN_AUDIO_TUNER_BIT:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_TestmodeBits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_TestmodeBits& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tuner_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tuner_Mode();
   enum tenType {
      FI_EN_TUN_CAL = 0UL,
      FI_EN_TUN_DDA = 1UL,
      FI_EN_TUN_DDS = 2UL,
      FI_EN_TUN_SINGLE = 3UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tuner_Mode(midw_fi_tcl_e8_Tuner_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tuner_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tuner_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DDADDS_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DDADDS_Mode();
   enum tenType {
      FI_EN_TUN_DDA = 1UL,
      FI_EN_TUN_DDS = 2UL,
      FI_EN_TUN_SINGLE = 3UL,
      FI_EN_TUN_AUTO = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DDADDS_Mode(midw_fi_tcl_e8_DDADDS_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DDADDS_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DDADDS_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TMCGroupState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TMCGroupState();
   enum tenType {
      FI_EN_TUN_NO_DATA_AVAILABLE = 0UL,
      FI_EN_TUN_DATA_NOT_REPEATED = 1UL,
      FI_EN_TUN_TWO_GROUPS_IDENTICAL = 2UL,
      FI_EN_TUN_THREE_GROUPS_IDENTICAL = 3UL,
      FI_EN_TUN_AFI_BIT = 128UL,
      FI_EN_TUN_GROUP_3A_DETECTED = 64UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TMCGroupState(midw_fi_tcl_e8_Tun_TMCGroupState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TMCGroupState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TMCGroupState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AntennaState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AntennaState();
   enum tenType {
      FI_EN_TUN_PHANTOM_SUPPLY_OFF = 0UL,
      FI_EN_TUN_PHANTOM_SUPPLY_ON = 1UL,
      FI_EN_TUN_PHANTOM_SUPPLY_UNKNOWN = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AntennaState(midw_fi_tcl_e8_Tun_AntennaState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AntennaState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AntennaState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_IfState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_IfState();
   enum tenType {
      FI_EN_TUN_OFF = 0UL,
      FI_EN_TUN_ON = 1UL,
      FI_EN_TUN_UNKNOWN = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_IfState(midw_fi_tcl_e8_Tun_IfState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_IfState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_IfState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerTestModeData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerTestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerTestModeData& operator=(const midw_fi_tcl_TunerTestModeData& coRef);
   midw_fi_tcl_TunerTestModeData(const midw_fi_tcl_TunerTestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   midw_fi_tcl_e8_Tun_AdditionalInfo u8AdditionalInfo;
   tU32 u32AFFrequency;
   tU32 u32PI;
   tU8 u8Quality;
   tU8 u8Fieldstrength;
   tU8 u8Multipath;
   tU8 u8Neighbour;
   tU8 u8AFListLength;
   midw_fi_tcl_b8_Tun_TestmodeBits u8TestmodeBits;
   tU8 u8TMCStationCount;
   midw_fi_tcl_e8_Tun_TMCGroupState u8TMCGroupState;
   midw_fi_tcl_e8_Tun_AntennaState u8AntennaState;
   tU8 u8PSName1;
   tU8 u8PSName2;
   tU8 u8PSName3;
   tU8 u8PSName4;
   tU8 u8PSName5;
   tU8 u8PSName6;
   tU8 u8PSName7;
   tU8 u8PSName8;
   midw_fi_tclString sPSName;
   midw_fi_tcl_e8_Tun_IfState u8IFState;
   tU8 u8ChannelSeparation;
   tU8 u8Hub;
   tU8 u8RdsErrorRate;
   virtual ~midw_fi_tcl_TunerTestModeData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerTestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ListType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ListType();
   enum tenType {
      FI_EN_TUN_LIST_TYPE_STATIC = 0UL,
      FI_EN_TUN_LIST_TYPE_CONFIG = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ListType(midw_fi_tcl_e8_Tun_ListType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ConfigListID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ConfigListID();
   enum tenType {
      FI_EN_TUN_TUN_CONFIG_LIST_FM = 0UL,
      FI_EN_TUN_TUN_CONFIG_LIST_TMC = 1UL,
      FI_EN_TUN_TUN_CONFIG_LIST_MW = 2UL,
      FI_EN_TUN_TUN_CONFIG_LIST_LW = 3UL,
      FI_EN_TUN_TUN_CONFIG_LIST_AM = 4UL,
      FI_EN_TUN_TUN_CONFIG_LIST_DRM = 5UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ConfigListID(midw_fi_tcl_e8_Tun_ConfigListID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ConfigListID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ConfigListID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Config_Filters : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Config_Filters();
   enum tenType {
      FI_EN_TUN_CONFIG_NO_FILTER = 0UL,
      FI_EN_TUN_CONFIG_FILTER_TP = 1UL,
      FI_EN_TUN_CONFIG_FILTER_TMC = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Config_Filters(midw_fi_tcl_e8_Tun_Config_Filters::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Config_Filters();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Config_Filters& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_SortingCriteria : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_SortingCriteria();
   enum tenType {
      FI_EN_TUN_TUN_SORT_PS_ASCENDING = 0UL,
      FI_EN_TUN_TUN_SORT_PI_ASCENDING = 1UL,
      FI_EN_TUN_TUN_SORT_FIELDSTRENGTH_ASCENDING = 2UL,
      FI_EN_TUN_TUN_SORT_FREQUENCY_ASCENDING = 3UL,
      FI_EN_TUN_TUN_SORT_PS_DESCENDING = 4UL,
      FI_EN_TUN_TUN_SORT_PI_DESCENDING = 5UL,
      FI_EN_TUN_TUN_SORT_FIELDSTRENGTH_DESCENDING = 6UL,
      FI_EN_TUN_TUN_SORT_FREQUENCY_DESCENDING = 7UL,
      FI_EN_TUN_SORT_SERVICELABEL_ALPHABETICAL_ASCENDING = 8UL,
      FI_EN_TUN_SORT_SERVICELABEL_ALPHABETICAL_DESCENDING = 9UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_SortingCriteria(midw_fi_tcl_e8_Tun_SortingCriteria::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_SortingCriteria();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_SortingCriteria& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ModulationType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ModulationType();
   enum tenType {
      FI_EN_TUN_MODULATION_ANALOG = 0UL,
      FI_EN_TUN_MODULATION_HD = 1UL,
      FI_EN_TUN_MODULATION_DRM = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ModulationType(midw_fi_tcl_e8_Tun_ModulationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ModulationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ModulationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_Digital_Filters : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_Digital_Filters();

   enum {
      FI_C_U8_BIT_STATIONLIST_WITHONLY_HDMPS = 0x1UL,
      FI_C_U8_BIT_STATIONLIST_WITH_HDMPS_SPS = 0x2UL,
      FI_C_U8_BIT_STATIONLIST_WITH_DRM = 0x4UL,
      FI_C_U8_BIT_RESERVED_1 = 0x8UL,
      FI_C_U8_BIT_RESERVED_2 = 0x10UL,
      FI_C_U8_BIT_RESERVED_3 = 0x20UL,
      FI_C_U8_BIT_RESERVED_4 = 0x40UL,
      FI_C_U8_BIT_RESERVED_5 = 0x80UL
   };
   tBool bSTATIONLIST_WITHONLY_HDMPS() const {return (u8Value & FI_C_U8_BIT_STATIONLIST_WITHONLY_HDMPS) != 0; }
   tVoid vSetSTATIONLIST_WITHONLY_HDMPS(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STATIONLIST_WITHONLY_HDMPS):(u8Value & ~(tU8)FI_C_U8_BIT_STATIONLIST_WITHONLY_HDMPS)); }
   tBool bSTATIONLIST_WITH_HDMPS_SPS() const {return (u8Value & FI_C_U8_BIT_STATIONLIST_WITH_HDMPS_SPS) != 0; }
   tVoid vSetSTATIONLIST_WITH_HDMPS_SPS(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STATIONLIST_WITH_HDMPS_SPS):(u8Value & ~(tU8)FI_C_U8_BIT_STATIONLIST_WITH_HDMPS_SPS)); }
   tBool bSTATIONLIST_WITH_DRM() const {return (u8Value & FI_C_U8_BIT_STATIONLIST_WITH_DRM) != 0; }
   tVoid vSetSTATIONLIST_WITH_DRM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STATIONLIST_WITH_DRM):(u8Value & ~(tU8)FI_C_U8_BIT_STATIONLIST_WITH_DRM)); }
   tBool bRESERVED_1() const {return (u8Value & FI_C_U8_BIT_RESERVED_1) != 0; }
   tVoid vSetRESERVED_1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_1):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_1)); }
   tBool bRESERVED_2() const {return (u8Value & FI_C_U8_BIT_RESERVED_2) != 0; }
   tVoid vSetRESERVED_2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_2):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_2)); }
   tBool bRESERVED_3() const {return (u8Value & FI_C_U8_BIT_RESERVED_3) != 0; }
   tVoid vSetRESERVED_3(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_3):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_3)); }
   tBool bRESERVED_4() const {return (u8Value & FI_C_U8_BIT_RESERVED_4) != 0; }
   tVoid vSetRESERVED_4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_4):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_4)); }
   tBool bRESERVED_5() const {return (u8Value & FI_C_U8_BIT_RESERVED_5) != 0; }
   tVoid vSetRESERVED_5(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_5):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_5)); }
   struct rBitValues {
      tBool STATIONLIST_WITHONLY_HDMPS:1;
      tBool STATIONLIST_WITH_HDMPS_SPS:1;
      tBool STATIONLIST_WITH_DRM:1;
      tBool RESERVED_1:1;
      tBool RESERVED_2:1;
      tBool RESERVED_3:1;
      tBool RESERVED_4:1;
      tBool RESERVED_5:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_Digital_Filters();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_Digital_Filters& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_TmcApplicationId : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_TmcApplicationId();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_TMCDATA = 52550UL,
      FI_EN_INVALID_TYPE = 65535UL
   };
   tenType enType;

   midw_fi_tcl_e16_TmcApplicationId(midw_fi_tcl_e16_TmcApplicationId::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_TmcApplicationId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_TmcApplicationId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Encryption : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Encryption();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Encryption& operator=(const midw_fi_tcl_Encryption& coRef);
   midw_fi_tcl_Encryption(const midw_fi_tcl_Encryption& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Encrypted;
   tU8 Encid;
   tU8 TestBits;
   virtual ~midw_fi_tcl_Encryption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Encryption& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TmcMediumType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TmcMediumType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_DAB = 2UL,
      FI_EN_SATELLITE = 3UL,
      FI_EN_INTERNET = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_TmcMediumType(midw_fi_tcl_e8_TmcMediumType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TmcMediumType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TmcMediumType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MsgSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MsgSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MsgSource& operator=(const midw_fi_tcl_MsgSource& coRef);
   midw_fi_tcl_MsgSource(const midw_fi_tcl_MsgSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TmcMediumType MediumTypeId;
   tU8 Number;
   virtual ~midw_fi_tcl_MsgSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MsgSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_RDBID_Value : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_RDBID_Value();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_RDBID_Value& operator=(const midw_fi_tcl_Tun_RDBID_Value& coRef);
   midw_fi_tcl_Tun_RDBID_Value(const midw_fi_tcl_Tun_RDBID_Value& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8RdbidCC;
   tU8 u8RdbidLTN;
   tU8 u8RdbidSID;
   tBool bEncFlag;
   virtual ~midw_fi_tcl_Tun_RDBID_Value();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_RDBID_Value& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerRdbId : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerRdbId();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerRdbId& operator=(const midw_fi_tcl_TunerRdbId& coRef);
   midw_fi_tcl_TunerRdbId(const midw_fi_tcl_TunerRdbId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TMCCountryCode;
   tU8 TableNo;
   tU8 ServiceID;
   tBool Encrypted;
   virtual ~midw_fi_tcl_TunerRdbId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerRdbId& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerGetDataTMC : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerGetDataTMC();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerGetDataTMC& operator=(const midw_fi_tcl_TunerGetDataTMC& coRef);
   midw_fi_tcl_TunerGetDataTMC(const midw_fi_tcl_TunerGetDataTMC& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   tU16 u16TMCData1;
   tU16 u16TMCData2;
   tU16 u16TMCData3;
   tU16 u16TMCData4;
   virtual ~midw_fi_tcl_TunerGetDataTMC();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerGetDataTMC& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TrafficInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TrafficInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TrafficInfo& operator=(const midw_fi_tcl_TrafficInfo& coRef);
   midw_fi_tcl_TrafficInfo(const midw_fi_tcl_TrafficInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerRdbId RDBId;
   tS16 ECC;
   midw_fi_tcl_e16_TmcApplicationId ApplicationId;
   std::vector<tU8, std::allocator<tU8> > ListOf8AData;
   tU16 ProgramID;
   midw_fi_tcl_Encryption Encryption;
   midw_fi_tcl_MsgSource MsgSource;
   midw_fi_tclString ProgramServiceName;
   midw_fi_tclString ServiceProviderName;
   virtual ~midw_fi_tcl_TrafficInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TrafficInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_PackedInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_PackedInfo();

   enum {
      FI_C_U8_BIT_TUN_TP = 0x1UL,
      FI_C_U8_BIT_TUN_TP_SELF = 0x2UL,
      FI_C_U8_BIT_TUN_PTY_DYNAMIC = 0x4UL,
      FI_C_U8_BIT_TUN_PS_DYNAMIC = 0x8UL,
      FI_C_U8_BIT_TUN_TMC_RESERVED = 0x10UL,
      FI_C_U8_BIT_TUN_TMC_YES = 0x20UL,
      FI_C_U8_BIT_TUN_TMC_NO = 0x40UL
   };
   tBool bTUN_TP() const {return (u8Value & FI_C_U8_BIT_TUN_TP) != 0; }
   tVoid vSetTUN_TP(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TP):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TP)); }
   tBool bTUN_TP_SELF() const {return (u8Value & FI_C_U8_BIT_TUN_TP_SELF) != 0; }
   tVoid vSetTUN_TP_SELF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TP_SELF):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TP_SELF)); }
   tBool bTUN_PTY_DYNAMIC() const {return (u8Value & FI_C_U8_BIT_TUN_PTY_DYNAMIC) != 0; }
   tVoid vSetTUN_PTY_DYNAMIC(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_PTY_DYNAMIC):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_PTY_DYNAMIC)); }
   tBool bTUN_PS_DYNAMIC() const {return (u8Value & FI_C_U8_BIT_TUN_PS_DYNAMIC) != 0; }
   tVoid vSetTUN_PS_DYNAMIC(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_PS_DYNAMIC):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_PS_DYNAMIC)); }
   tBool bTUN_TMC_reserved() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_RESERVED) != 0; }
   tVoid vSetTUN_TMC_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TMC_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TMC_RESERVED)); }
   tBool bTUN_TMC_YES() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_YES) != 0; }
   tVoid vSetTUN_TMC_YES(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TMC_YES):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TMC_YES)); }
   tBool bTUN_TMC_NO() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_NO) != 0; }
   tVoid vSetTUN_TMC_NO(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_TMC_NO):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_TMC_NO)); }
   struct rBitValues {
      tBool TUN_TP:1;
      tBool TUN_TP_SELF:1;
      tBool TUN_PTY_DYNAMIC:1;
      tBool TUN_PS_DYNAMIC:1;
      tBool TUN_TMC_reserved:1;
      tBool TUN_TMC_YES:1;
      tBool TUN_TMC_NO:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_PackedInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_PackedInfo& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MakeConfigListElem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MakeConfigListElem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MakeConfigListElem& operator=(const midw_fi_tcl_MakeConfigListElem& coRef);
   midw_fi_tcl_MakeConfigListElem(const midw_fi_tcl_MakeConfigListElem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ListID;
   tU8 u8NumOfElementsInList;
   virtual ~midw_fi_tcl_MakeConfigListElem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MakeConfigListElem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_AvailFlags : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_AvailFlags();

   enum {
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE = 0x1UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE = 0x2UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE = 0x4UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE = 0x8UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE = 0x10UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE = 0x20UL,
      FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RESERVED = 0x40UL
   };
   tBool bTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_PI_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_PI_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_PS_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_PS_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_PTY_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_PTY_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_CT_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_CT_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_RT_AVAILABLE() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_RT_AVAILABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE)); }
   tBool bTUN_AVAILABLE_FLAGS_reserved() const {return (u8Value & FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RESERVED) != 0; }
   tVoid vSetTUN_AVAILABLE_FLAGS_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_AVAILABLE_FLAGS_RESERVED)); }
   struct rBitValues {
      tBool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_PI_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_PS_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_PTY_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_CT_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_RT_AVAILABLE:1;
      tBool TUN_AVAILABLE_FLAGS_reserved:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_AvailFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_AvailFlags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_HD_TextEncodingType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_HD_TextEncodingType();
   enum tenType {
      FI_EN_ISO_IEC_8859_1_1998 = 0UL,
      FI_EN_ISO_IEC_10646_1_2000_UCS_2 = 4UL,
      FI_EN_RESERVED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_HD_TextEncodingType(midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_HD_TextEncodingType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_HD_TextEncodingType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_StationInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_StationInfo();

   enum {
      FI_C_U8_BIT_TP = 0x1UL,
      FI_C_U8_BIT_AF = 0x2UL
   };
   tBool bTP() const {return (u8Value & FI_C_U8_BIT_TP) != 0; }
   tVoid vSetTP(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TP):(u8Value & ~(tU8)FI_C_U8_BIT_TP)); }
   tBool bAF() const {return (u8Value & FI_C_U8_BIT_AF) != 0; }
   tVoid vSetAF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AF):(u8Value & ~(tU8)FI_C_U8_BIT_AF)); }
   struct rBitValues {
      tBool TP:1;
      tBool AF:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_StationInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_StationInfo& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_SendernameInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_SendernameInfo();
   enum tenType {
      FI_EN_TUN_NON_RDS = 0UL,
      FI_EN_TUN_FIRST_RECEIVED_PS = 1UL,
      FI_EN_TUN_LAST_RECEIVED_PS = 2UL,
      FI_EN_TUN_NOT_SUPPORTED = 3UL,
      FI_EN_TUN_NAME_ASSIGNED_BY_CUSTOMER = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_SendernameInfo(midw_fi_tcl_e8_Tun_SendernameInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_SendernameInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_SendernameInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Sel_List_Elem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Sel_List_Elem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Sel_List_Elem& operator=(const midw_fi_tcl_Sel_List_Elem& coRef);
   midw_fi_tcl_Sel_List_Elem(const midw_fi_tcl_Sel_List_Elem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   midw_fi_tcl_e8_Tun_ConfigListID eConfigListID;
   tU32 u32Frequency;
   tU16 u16PICode;
   tU8 u8ListElementID;
   midw_fi_tcl_e8_Tun_ListType u8Listtype;
   tU32 u32HDStnID_DRMSrvID;
   midw_fi_tcl_e8_Tun_ModulationType e8ModulationType;
   virtual ~midw_fi_tcl_Sel_List_Elem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Sel_List_Elem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TMCType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TMCType();
   enum tenType {
      FI_EN_TUN_TMC_UNDECODED = 0UL,
      FI_EN_TUN_TMC_LOST = 1UL,
      FI_EN_TUN_TMC_NO = 2UL,
      FI_EN_TUN_TMC_FREE = 3UL,
      FI_EN_TUN_TMC_PAY = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TMCType(midw_fi_tcl_e8_Tun_TMCType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TMCType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TMCType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ListID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ListID();
   enum tenType {
      FI_EN_TUN_BANK_FM1 = 0UL,
      FI_EN_TUN_BANK_FM2 = 1UL,
      FI_EN_TUN_BANK_FM3 = 2UL,
      FI_EN_TUN_BANK_FM_AST = 3UL,
      FI_EN_TUN_BANK_AM_MW1 = 4UL,
      FI_EN_TUN_BANK_AM_MW2 = 5UL,
      FI_EN_TUN_BANK_AM_MW3 = 6UL,
      FI_EN_TUN_BANK_AM_MWAST = 7UL,
      FI_EN_TUN_BANK_AM_LW1 = 8UL,
      FI_EN_TUN_BANK_AM_LW2 = 9UL,
      FI_EN_TUN_BANK_AM_LW3 = 10UL,
      FI_EN_TUN_BANK_AM_LWAST = 11UL,
      FI_EN_TUN_BANK_AM_AST = 12UL,
      FI_EN_TUN_BANK_MIX1 = 17UL,
      FI_EN_TUN_BANK_MIX2 = 18UL,
      FI_EN_TUN_BANK_MIX3 = 19UL,
      FI_EN_TUN_BANK_MIX_AST = 20UL,
      FI_EN_TUN_BANK_DRM1 = 21UL,
      FI_EN_TUN_BANK_DRM_AST = 22UL,
      FI_EN_TUN_BANK_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ListID(midw_fi_tcl_e8_Tun_ListID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ListID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ListID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Abs_Or_Rel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Abs_Or_Rel();
   enum tenType {
      FI_EN_TUN_PI_ABS = 0UL,
      FI_EN_TUN_PI_REL = 1UL,
      FI_EN_TUN_PI_NEXT_AVAIL = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Abs_Or_Rel(midw_fi_tcl_e8_Tun_Abs_Or_Rel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Abs_Or_Rel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Abs_Or_Rel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Rel_Steps : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Rel_Steps();
   enum tenType {
      FI_EN_INVALID_TYPE = 0UL,
      FI_EN_TUN_PI_INC = 1UL,
      FI_EN_TUN_PI_DEC = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Rel_Steps(midw_fi_tcl_e8_Tun_Rel_Steps::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Rel_Steps();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Rel_Steps& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Direction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Direction();
   enum tenType {
      FI_EN_INVALID_TYPE = 0UL,
      FI_EN_TUN_PI_DIR_UP = 1UL,
      FI_EN_TUN_PI_DIR_DOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Direction(midw_fi_tcl_e8_Tun_Direction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Direction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Direction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_Set_PI : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_Set_PI();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_Set_PI& operator=(const midw_fi_tcl_Tun_Set_PI& coRef);
   midw_fi_tcl_Tun_Set_PI(const midw_fi_tcl_Tun_Set_PI& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Abs_Or_Rel u8AbsOrRel;
   midw_fi_tcl_e8_Tun_Rel_Steps u8RelSteps;
   midw_fi_tcl_e8_Tun_Direction u8Direction;
   tU8 u8Nsteps;
   tU16 u16PI;
   tU32 u32Frequency;
   virtual ~midw_fi_tcl_Tun_Set_PI();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_Set_PI& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Autostore : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Autostore();
   enum tenType {
      FI_EN_NO_AUTOSTORE = 0UL,
      FI_EN_AUTOSTORE = 1UL,
      FI_EN_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Autostore(midw_fi_tcl_e8_Tun_Autostore::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Autostore();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Autostore& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ModeDirection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ModeDirection();
   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_TUN_DIR_UP = 1UL,
      FI_EN_TUN_DIR_DOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ModeDirection(midw_fi_tcl_e8_Tun_ModeDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ModeDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ModeDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ListElementInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ListElementInfo();
   enum tenType {
      FI_EN_LIST_ELEMENT_INFO_VALID = 1UL,
      FI_EN_LIST_ELEMENT_INFO_INVALID = 0UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ListElementInfo(midw_fi_tcl_e8_Tun_ListElementInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ListElementInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ListElementInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerStaticListElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerStaticListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerStaticListElement& operator=(const midw_fi_tcl_TunerStaticListElement& coRef);
   midw_fi_tcl_TunerStaticListElement(const midw_fi_tcl_TunerStaticListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ListID e8ListID;
   tU8 u8ElementID;
   tBool bSelected;
   tU32 u32Frequency;
   midw_fi_tclString sPSName;
   tU16 u16PI;
   midw_fi_tcl_e8_Tun_SendernameInfo e8SendernameInfo;
   tU8 u8TpTmcInfo;
   tU32 u32PTY;
   tS8 s8LevelCompensation;
   midw_fi_tcl_e8_Tun_ModulationType e8Modulation;
   tU32 u32HDStationId_DRMServiceId;
   midw_fi_tclString sHDCallSign_DRMServiceLabel;
   midw_fi_tcl_e8_Tun_HD_TextEncodingType e8HDTextEncoding;
   tU8 u8HDStationGenre_DRMPty;
   tU8 u8HDAudioProgram_DRMShortID;
   midw_fi_tclString StationLogo;
   tU32 u32DRMServiceId;
   midw_fi_tclString sDRMServiceLabel;
   tU8 u8DRMPTY;
   tU8 u8DRMServiceShortId;
   virtual ~midw_fi_tcl_TunerStaticListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerStaticListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms();

   enum {
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_MPS = 0x1UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS1 = 0x2UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS2 = 0x4UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS3 = 0x8UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS4 = 0x10UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS5 = 0x20UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS6 = 0x40UL,
      FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS7 = 0x80UL
   };
   tBool bTUN_HD_AUDIOPROGRAM_MPS() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_MPS) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_MPS(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_MPS):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_MPS)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS1() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS1) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS1):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS1)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS2() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS2) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS2):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS2)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS3() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS3) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS3(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS3):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS3)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS4() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS4) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS4):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS4)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS5() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS5) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS5(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS5):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS5)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS6() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS6) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS6(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS6):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS6)); }
   tBool bTUN_HD_AUDIOPROGRAM_SPS7() const {return (u8Value & FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS7) != 0; }
   tVoid vSetTUN_HD_AUDIOPROGRAM_SPS7(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS7):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_HD_AUDIOPROGRAM_SPS7)); }
   struct rBitValues {
      tBool TUN_HD_AUDIOPROGRAM_MPS:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS1:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS2:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS3:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS4:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS5:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS6:1;
      tBool TUN_HD_AUDIOPROGRAM_SPS7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerConfigListElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerConfigListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerConfigListElement& operator=(const midw_fi_tcl_TunerConfigListElement& coRef);
   midw_fi_tcl_TunerConfigListElement(const midw_fi_tcl_TunerConfigListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   tU8 u8ElementID;
   tU8 u8ElementSelected;
   tU32 u32Frequency;
   tU32 u32PI;
   midw_fi_tclString sPSName;
   tU8 u8PTY;
   tU8 u8ECC;
   tU8 u8SID;
   tU8 u8LTN;
   tU8 u8Quality;
   tU8 u8PositionInPresetList;
   midw_fi_tcl_e8_Tun_SendernameInfo e8SendernameInfo;
   tBool bTpInfo;
   midw_fi_tcl_e8_Tun_TMCType e8TMCType;
   midw_fi_tcl_e8_Tun_ListID e8PresetListForAcmp;
   tS8 s8LevelCompensation;
   midw_fi_tclString StationLogo;
   midw_fi_tcl_e8_Tun_ModulationType e8ModulationType;
   tU8 u8PTY_HDPTY_DRMPty;
   tU32 u32PI_HDStnId_DRMSrvId;
   midw_fi_tcl_b8_Tun_StationInfo b8StationInfo;
   midw_fi_tcl_e8_Tun_HD_TextEncodingType e8HDTextEncoding;
   midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms b8HDNumOfAudioPrograms;
   virtual ~midw_fi_tcl_TunerConfigListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerConfigListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_PresetAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_PresetAction();
   enum tenType {
      FI_EN_RECALL_ELEMENT = 0UL,
      FI_EN_SAVE_ELEMENT = 1UL,
      FI_EN_DELETE_ONE_ELEMENT = 2UL,
      FI_EN_DELETE_ALL_ELEMENTS = 3UL,
      FI_EN_SPECIAL_SAVE_ELEMENT = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_PresetAction(midw_fi_tcl_e8_Tun_PresetAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_PresetAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_PresetAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerStaticListElementList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerStaticListElementList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerStaticListElementList& operator=(const midw_fi_tcl_TunerStaticListElementList& coRef);
   midw_fi_tcl_TunerStaticListElementList(const midw_fi_tcl_TunerStaticListElementList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerStaticListElement, std::allocator<midw_fi_tcl_TunerStaticListElement> > TunerStaticListElement;
   virtual ~midw_fi_tcl_TunerStaticListElementList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerStaticListElementList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_Tun_TroubleCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_Tun_TroubleCode();
   enum tenType {
      FI_EN_VDL_ITC_FC_TMC_TUNER_FM_RECEPTION_ERROR = 2561UL,
      FI_EN_INVALID_TYPE = 65525UL
   };
   tenType enType;

   midw_fi_tcl_e16_Tun_TroubleCode(midw_fi_tcl_e16_Tun_TroubleCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_Tun_TroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_Tun_TroubleCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_MonitoringMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_MonitoringMode();
   enum tenType {
      FI_EN_FC_TUNER_MONITORING_OFF = 0UL,
      FI_EN_FC_TUNER_MONITORING_CONTINUOUS = 1UL,
      FI_EN_FC_TUNER_MONITORING_SINGLE = 2UL,
      FI_EN_FC_TUNER_MONITORING_DEFAULTMODE = 3UL,
      FI_EN_FC_TUNER_MONITORING_PREVIOUSMODE = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_MonitoringMode(midw_fi_tcl_e8_Tun_MonitoringMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_MonitoringMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_MonitoringMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_SupervisionControl : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_SupervisionControl();
   enum tenType {
      FI_EN_FC_TUNER_SUPERVISION_DEFAULT = 0UL,
      FI_EN_FC_TUNER_SUPERVISION_OFF = 1UL,
      FI_EN_FC_TUNER_SUPERVISION_ON = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_SupervisionControl(midw_fi_tcl_e8_Tun_SupervisionControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_SupervisionControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_SupervisionControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerTestRoutineParameter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerTestRoutineParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerTestRoutineParameter& operator=(const midw_fi_tcl_TunerTestRoutineParameter& coRef);
   midw_fi_tcl_TunerTestRoutineParameter(const midw_fi_tcl_TunerTestRoutineParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Tun_TroubleCode TroubleCode;
   tBool WriteToRM;
   midw_fi_tcl_e8_Tun_MonitoringMode MonitoringMode;
   midw_fi_tcl_e8_Tun_SupervisionControl SupervisionControl;
   virtual ~midw_fi_tcl_TunerTestRoutineParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerTestRoutineParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerTestRoutineParameterList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerTestRoutineParameterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerTestRoutineParameterList& operator=(const midw_fi_tcl_TunerTestRoutineParameterList& coRef);
   midw_fi_tcl_TunerTestRoutineParameterList(const midw_fi_tcl_TunerTestRoutineParameterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerTestRoutineParameter, std::allocator<midw_fi_tcl_TunerTestRoutineParameter> > TunerTestRoutineParameter;
   virtual ~midw_fi_tcl_TunerTestRoutineParameterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerTestRoutineParameterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ErrorStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ErrorStatus();
   enum tenType {
      FI_EN_FC_TUNER_TEST_PASSED = 0UL,
      FI_EN_FC_TUNER_TEST_FAILED = 1UL,
      FI_EN_FC_TUNER_TEST_NEVER_RAN = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ErrorStatus(midw_fi_tcl_e8_Tun_ErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_MuteStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_MuteStatus();
   enum tenType {
      FI_EN_MUTE = 0UL,
      FI_EN_DEMUTE = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_MuteStatus(midw_fi_tcl_e8_Tun_MuteStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_MuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_MuteStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_RoutineStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_RoutineStatus();
   enum tenType {
      FI_EN_FC_TUNER_ROUTINE_NOT_RUNNING = 0UL,
      FI_EN_FC_TUNER_ROUTINE_RUNNING = 1UL,
      FI_EN_FC_TUNER_ROUTINE_FINISHED = 2UL,
      FI_EN_FC_TUNER_ROUTINE_CANCELLED = 3UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_RoutineStatus(midw_fi_tcl_e8_Tun_RoutineStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_RoutineStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_RoutineStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_TestTroubleCodeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_TestTroubleCodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_TestTroubleCodeStatus& operator=(const midw_fi_tcl_Tun_TestTroubleCodeStatus& coRef);
   midw_fi_tcl_Tun_TestTroubleCodeStatus(const midw_fi_tcl_Tun_TestTroubleCodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Tun_TroubleCode TroubleCode;
   midw_fi_tcl_e8_Tun_ErrorStatus ErrorStatus;
   midw_fi_tcl_e8_Tun_RoutineStatus RoutineStatus;
   virtual ~midw_fi_tcl_Tun_TestTroubleCodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_TestTroubleCodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_TestTroubleCodeStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_TestTroubleCodeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_TestTroubleCodeStatusList& operator=(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& coRef);
   midw_fi_tcl_Tun_TestTroubleCodeStatusList(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Tun_TestTroubleCodeStatus, std::allocator<midw_fi_tcl_Tun_TestTroubleCodeStatus> > TunerTestTroubleCodeStatus;
   virtual ~midw_fi_tcl_Tun_TestTroubleCodeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_TestTroubleCodeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerFieldstrength : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerFieldstrength();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerFieldstrength& operator=(const midw_fi_tcl_TunerFieldstrength& coRef);
   midw_fi_tcl_TunerFieldstrength(const midw_fi_tcl_TunerFieldstrength& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Band;
   tU32 u32Frequency;
   virtual ~midw_fi_tcl_TunerFieldstrength();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerFieldstrength& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_Diag_ErrorCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_Diag_ErrorCode();
   enum tenType {
      FI_EN_TUN_UNSPECIFIED = 0UL,
      FI_EN_TUN_UNKNOWNSVCID = 1UL,
      FI_EN_TUN_UNKNOWNFCTID = 2UL,
      FI_EN_TUN_INVALIDOPCODE = 3UL,
      FI_EN_TUN_INVALIDCCATYPE = 4UL,
      FI_EN_TUN_PARAMETEROUTOFRANGE = 5UL,
      FI_EN_TUN_UNKNOWNREGID = 6UL,
      FI_EN_TUN_VERSIONNOTSUPPORTED = 7UL,
      FI_EN_TUN_PARAMETERMISSING = 8UL,
      FI_EN_TUN_PARAMETERTOOMANY = 9UL,
      FI_EN_TUN_BUSY = 10UL,
      FI_EN_TUN_TEMPORARYNOTAVAILABLE = 11UL,
      FI_EN_TUN_OPCODENOTSUPPORTED = 12UL,
      FI_EN_TUN_INTERNALFAILURE = 13UL,
      FI_EN_TUN_UPREGFAILURE = 14UL,
      FI_EN_TUN_RELUPREGFAILURE = 15UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_Tun_Diag_ErrorCode(midw_fi_tcl_Tun_Diag_ErrorCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_Tun_Diag_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_Tun_Diag_ErrorCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BandChangeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BandChangeStatus();
   enum tenType {
      FI_EN_TUN_BAND_CHANGE_INVALID_STATION_INFO = 0UL,
      FI_EN_TUN_BAND_CHANGE_VALID_STATION_INFO = 1UL,
      FI_EN_TUN_BAND_CHANGE_INVALID_BAND = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_BandChangeStatus(midw_fi_tcl_e8_BandChangeStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BandChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BandChangeStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Source : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Source();
   enum tenType {
      FI_EN_TUN_FM = 0UL,
      FI_EN_TUN_AM = 1UL,
      FI_EN_TUN_DRM = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Source(midw_fi_tcl_e8_Tun_Source::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Source();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Source& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_HDAudioProgram : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_HDAudioProgram();
   enum tenType {
      FI_EN_TUN_AUDIO_PROGRAM_ONE = 0UL,
      FI_EN_TUN_AUDIO_PROGRAM_TWO = 1UL,
      FI_EN_TUN_AUDIO_PROGRAM_THREE = 2UL,
      FI_EN_TUN_AUDIO_PROGRAM_FOUR = 3UL,
      FI_EN_TUN_AUDIO_PROGRAM_FIVE = 4UL,
      FI_EN_TUN_AUDIO_PROGRAM_SIX = 5UL,
      FI_EN_TUN_AUDIO_PROGRAM_SEVEN = 6UL,
      FI_EN_TUN_AUDIO_PROGRAM_EIGHT = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_HDAudioProgram(midw_fi_tcl_e8_Tun_HDAudioProgram::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_HDAudioProgram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_HDAudioProgram& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Autocompare_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Autocompare_Mode();
   enum tenType {
      FI_EN_TUN_AUTOCOMPARE_MODE_PREFER_USERSELECTION = 0UL,
      FI_EN_TUN_AUTOCOMPARE_MODE_PREFER_FIRST = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Autocompare_Mode(midw_fi_tcl_e8_Tun_Autocompare_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Autocompare_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Autocompare_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_AutoCompParam : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_AutoCompParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_AutoCompParam& operator=(const midw_fi_tcl_Tun_AutoCompParam& coRef);
   midw_fi_tcl_Tun_AutoCompParam(const midw_fi_tcl_Tun_AutoCompParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FirstElemId;
   tU8 u8LastElemID;
   midw_fi_tcl_e8_Tun_Autocompare_Mode u8Mode;
   virtual ~midw_fi_tcl_Tun_AutoCompParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_AutoCompParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Component_Status : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Component_Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Component_Status& operator=(const midw_fi_tcl_Component_Status& coRef);
   midw_fi_tcl_Component_Status(const midw_fi_tcl_Component_Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8AudioSinkTUN1;
   tU8 u8BGModeTuner;
   virtual ~midw_fi_tcl_Component_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Component_Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AtStationTPinfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AtStationTPinfo();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NO_TP = 1UL,
      FI_EN_SELF_TP = 2UL,
      FI_EN_EON_TP = 3UL,
      FI_EN_TP_NO_SYNC = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_AtStationTPinfo(midw_fi_tcl_e8_AtStationTPinfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AtStationTPinfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AtStationTPinfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_HDInfoBits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_HDInfoBits();

   enum {
      FI_C_U8_BIT_HD_MODULATION_DETECTION = 0x1UL,
      FI_C_U8_BIT_HD_DATA_DECODING = 0x2UL,
      FI_C_U8_BIT_HD_AUDIO_DECODING = 0x4UL,
      FI_C_U8_BIT_HD_BLEND_ANALOG = 0x8UL,
      FI_C_U8_BIT_HD_DIGITAL_AUDIO_MUTE = 0x10UL,
      FI_C_U8_BIT_HD_BALLGAME_MODE = 0x20UL,
      FI_C_U8_BIT_RESERVED_1 = 0x40UL,
      FI_C_U8_BIT_RESERVED_2 = 0x80UL
   };
   tBool bHD_MODULATION_DETECTION() const {return (u8Value & FI_C_U8_BIT_HD_MODULATION_DETECTION) != 0; }
   tVoid vSetHD_MODULATION_DETECTION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_MODULATION_DETECTION):(u8Value & ~(tU8)FI_C_U8_BIT_HD_MODULATION_DETECTION)); }
   tBool bHD_DATA_DECODING() const {return (u8Value & FI_C_U8_BIT_HD_DATA_DECODING) != 0; }
   tVoid vSetHD_DATA_DECODING(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_DATA_DECODING):(u8Value & ~(tU8)FI_C_U8_BIT_HD_DATA_DECODING)); }
   tBool bHD_AUDIO_DECODING() const {return (u8Value & FI_C_U8_BIT_HD_AUDIO_DECODING) != 0; }
   tVoid vSetHD_AUDIO_DECODING(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_AUDIO_DECODING):(u8Value & ~(tU8)FI_C_U8_BIT_HD_AUDIO_DECODING)); }
   tBool bHD_BLEND_ANALOG() const {return (u8Value & FI_C_U8_BIT_HD_BLEND_ANALOG) != 0; }
   tVoid vSetHD_BLEND_ANALOG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_BLEND_ANALOG):(u8Value & ~(tU8)FI_C_U8_BIT_HD_BLEND_ANALOG)); }
   tBool bHD_DIGITAL_AUDIO_MUTE() const {return (u8Value & FI_C_U8_BIT_HD_DIGITAL_AUDIO_MUTE) != 0; }
   tVoid vSetHD_DIGITAL_AUDIO_MUTE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_DIGITAL_AUDIO_MUTE):(u8Value & ~(tU8)FI_C_U8_BIT_HD_DIGITAL_AUDIO_MUTE)); }
   tBool bHD_BALLGAME_MODE() const {return (u8Value & FI_C_U8_BIT_HD_BALLGAME_MODE) != 0; }
   tVoid vSetHD_BALLGAME_MODE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HD_BALLGAME_MODE):(u8Value & ~(tU8)FI_C_U8_BIT_HD_BALLGAME_MODE)); }
   tBool bRESERVED_1() const {return (u8Value & FI_C_U8_BIT_RESERVED_1) != 0; }
   tVoid vSetRESERVED_1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_1):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_1)); }
   tBool bRESERVED_2() const {return (u8Value & FI_C_U8_BIT_RESERVED_2) != 0; }
   tVoid vSetRESERVED_2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_2):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_2)); }
   struct rBitValues {
      tBool HD_MODULATION_DETECTION:1;
      tBool HD_DATA_DECODING:1;
      tBool HD_AUDIO_DECODING:1;
      tBool HD_BLEND_ANALOG:1;
      tBool HD_DIGITAL_AUDIO_MUTE:1;
      tBool HD_BALLGAME_MODE:1;
      tBool RESERVED_1:1;
      tBool RESERVED_2:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_HDInfoBits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_HDInfoBits& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_DiversityState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_DiversityState();
   enum tenType {
      FI_EN_NO_DIVERSITY_FEATURE = 0UL,
      FI_EN_DMQ = 1UL,
      FI_EN_DDS = 2UL,
      FI_EN_DDA = 3UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_DiversityState(midw_fi_tcl_e8_Tun_DiversityState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_DiversityState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_DiversityState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AntennaPathSwitch1 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AntennaPathSwitch1();
   enum tenType {
      FI_EN_DDS_OFF = 0UL,
      FI_EN_ANTENNA1_SELECTED = 1UL,
      FI_EN_ANTENNA2_SELECTED = 2UL,
      FI_EN_DDS_ACTIVE = 3UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AntennaPathSwitch1(midw_fi_tcl_e8_Tun_AntennaPathSwitch1::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AntennaPathSwitch1();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AntennaPathSwitch1& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AntennaPathSwitch2 : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AntennaPathSwitch2();
   enum tenType {
      FI_EN_NO_ANTENNA_SELECTED = 0UL,
      FI_EN_ANTENNA1_SELECTED = 1UL,
      FI_EN_ANTENNA2_SELECTED = 2UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AntennaPathSwitch2(midw_fi_tcl_e8_Tun_AntennaPathSwitch2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AntennaPathSwitch2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AntennaPathSwitch2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerTestModeData_DDADDS : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerTestModeData_DDADDS();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerTestModeData_DDADDS& operator=(const midw_fi_tcl_TunerTestModeData_DDADDS& coRef);
   midw_fi_tcl_TunerTestModeData_DDADDS(const midw_fi_tcl_TunerTestModeData_DDADDS& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PhysicalTuner u8PhysicalTuner;
   midw_fi_tcl_e8_Tun_Testmode_TunerBand u8Source;
   tU32 u32AFFrequency;
   tU16 u16CurrentPI;
   tU16 u16TargetPI;
   tU8 u8Quality;
   tU8 u8Fieldstrength;
   tU8 u8Multipath;
   tU8 u8Neighbour;
   tU8 u8AFListLength;
   tU8 u8HiCut;
   tU8 u8Sharx;
   midw_fi_tclString sCurrentStationName;
   midw_fi_tclString sFixPSName;
   tBool bScrollPSStatus;
   tBool bAFStatus;
   tU8 u8FMDeviation;
   tU8 u8RDSDeviation;
   tS8 s8IFOffset;
   tS8 s8RDSOffset;
   tU8 u8CoChannelStatus;
   tU8 u8AGC;
   tU8 u8ChannelSeparation;
   tU8 u8RdsErrorRate;
   midw_fi_tcl_e8_Tun_DiversityState e8DiversityState;
   midw_fi_tcl_e8_Tun_AntennaPathSwitch1 e8AntennaPathSwitch1;
   midw_fi_tcl_e8_Tun_AntennaPathSwitch2 e8AntennaPathSwitch2;
   midw_fi_tcl_b8_Tun_TestmodeBits u8TestmodeBits;
   tU8 u8HicutExtender;
   virtual ~midw_fi_tcl_TunerTestModeData_DDADDS();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerTestModeData_DDADDS& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Engg_Param_ID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Engg_Param_ID();
   enum tenType {
      FI_EN_FM_6_DB_STEREO_CHANNEL_SEPARATION = 0UL,
      FI_EN_FM_MINUS_3_DB_POINT = 1UL,
      FI_EN_FM_NOISE_WITHOUT_SIGNAL = 2UL,
      FI_EN_AM_NOISE_WITHOUT_SIGNAL = 3UL,
      FI_EN_FM_NOISE_BLANKER_SENSITIVITY = 4UL,
      FI_EN_AM_NOISE_BLANKER_SENSITIVITY = 5UL,
      FI_EN_FRONTEND_AGC_THRESHOLD = 6UL,
      FI_EN_FM_STATIC_HICUT = 7UL,
      FI_EN_Q_LEVEL_LIST_IN = 8UL,
      FI_EN_Q_LEVEL_LIST_OUT = 9UL,
      FI_EN_FORCE_DDA_MODE = 10UL,
      FI_EN_AM_SHARX = 11UL,
      FI_EN_BACKGROUND_SCAN_ACTIVITY = 12UL,
      FI_EN_INVALID_TYPE = 254UL,
      FI_EN_SELECT_ALL_PARAMETERS = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Engg_Param_ID(midw_fi_tcl_e8_Tun_Engg_Param_ID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Engg_Param_ID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Engg_Param_ID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ConfigParam_Type : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ConfigParam_Type();
   enum tenType {
      FI_EN_ALLPARAMETERS = 0UL,
      FI_EN_NUMBEROFSEEKPERIODS = 1UL,
      FI_EN_SCANTIME = 2UL,
      FI_EN_AFBESTDELAYTIME = 3UL,
      FI_EN_TPSEEKSTATEGY = 4UL,
      FI_EN_PTYFILTER = 5UL,
      FI_EN_TUNINGSWITCHES = 6UL,
      FI_EN_AUTOSEEKSTEPDELAY = 7UL,
      FI_EN_MANUALSTEPDELAY = 8UL,
      FI_EN_WRONGPIACCEPTDELAY = 9UL,
      FI_EN_NON_RDSDETECTIONTIMER = 10UL,
      FI_EN_TPSEEKAFTERRDSLOSTTIMER = 11UL,
      FI_EN_AMSTATIONINLISTREMOVETIMER = 12UL,
      FI_EN_SCROLLINGPSDETECTIONTIMER = 13UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ConfigParam_Type(midw_fi_tcl_e8_Tun_ConfigParam_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ConfigParam_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ConfigParam_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TuningActionConfigParam : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TuningActionConfigParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TuningActionConfigParam& operator=(const midw_fi_tcl_TuningActionConfigParam& coRef);
   midw_fi_tcl_TuningActionConfigParam(const midw_fi_tcl_TuningActionConfigParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigParam_Type e8ConfigParamType;
   tU32 u32ConfigParamValue;
   virtual ~midw_fi_tcl_TuningActionConfigParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TuningActionConfigParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TestTuneFrequencyMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TestTuneFrequencyMode();
   enum tenType {
      FI_EN_AF_JUMP_ON = 0UL,
      FI_EN_AF_JUMP_OFF = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TestTuneFrequencyMode(midw_fi_tcl_e8_Tun_TestTuneFrequencyMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TestTuneFrequencyMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TestTuneFrequencyMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_AnnoTypes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_AnnoTypes();

   enum {
      FI_C_U8_BIT_TP = 0x1UL,
      FI_C_U8_BIT_PTY = 0x2UL,
      FI_C_U8_BIT_WEATHERALERT = 0x4UL
   };
   tBool bTP() const {return (u8Value & FI_C_U8_BIT_TP) != 0; }
   tVoid vSetTP(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TP):(u8Value & ~(tU8)FI_C_U8_BIT_TP)); }
   tBool bPTY() const {return (u8Value & FI_C_U8_BIT_PTY) != 0; }
   tVoid vSetPTY(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PTY):(u8Value & ~(tU8)FI_C_U8_BIT_PTY)); }
   tBool bWeatherAlert() const {return (u8Value & FI_C_U8_BIT_WEATHERALERT) != 0; }
   tVoid vSetWeatherAlert(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_WEATHERALERT):(u8Value & ~(tU8)FI_C_U8_BIT_WEATHERALERT)); }
   struct rBitValues {
      tBool TP:1;
      tBool PTY:1;
      tBool WeatherAlert:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_AnnoTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_AnnoTypes& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Anno_Message : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Anno_Message();

   enum {
      FI_C_U8_BIT_TA = 0x1UL,
      FI_C_U8_BIT_PTY31 = 0x2UL,
      FI_C_U8_BIT_WEATHERALERT = 0x4UL
   };
   tBool bTA() const {return (u8Value & FI_C_U8_BIT_TA) != 0; }
   tVoid vSetTA(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TA):(u8Value & ~(tU8)FI_C_U8_BIT_TA)); }
   tBool bPTY31() const {return (u8Value & FI_C_U8_BIT_PTY31) != 0; }
   tVoid vSetPTY31(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PTY31):(u8Value & ~(tU8)FI_C_U8_BIT_PTY31)); }
   tBool bWeatherAlert() const {return (u8Value & FI_C_U8_BIT_WEATHERALERT) != 0; }
   tVoid vSetWeatherAlert(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_WEATHERALERT):(u8Value & ~(tU8)FI_C_U8_BIT_WEATHERALERT)); }
   struct rBitValues {
      tBool TA:1;
      tBool PTY31:1;
      tBool WeatherAlert:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Anno_Message();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Anno_Message& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AnnoInfostatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AnnoInfostatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AnnoInfostatus& operator=(const midw_fi_tcl_AnnoInfostatus& coRef);
   midw_fi_tcl_AnnoInfostatus(const midw_fi_tcl_AnnoInfostatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sAnnoStationName;
   tU32 u32Frequency;
   tU16 u16PI;
   tU8 u8Quality;
   virtual ~midw_fi_tcl_AnnoInfostatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AnnoInfostatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PS_Freeze_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PS_Freeze_Mode();
   enum tenType {
      FI_EN_FREEZE = 0UL,
      FI_EN_UNFREEZE = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_PS_Freeze_Mode(midw_fi_tcl_e8_PS_Freeze_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PS_Freeze_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PS_Freeze_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AnnoTypes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AnnoTypes();
   enum tenType {
      FI_EN_TP = 0UL,
      FI_EN_PTY31 = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AnnoTypes(midw_fi_tcl_e8_Tun_AnnoTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AnnoTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AnnoTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Anno_Message : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Anno_Message();
   enum tenType {
      FI_EN_TA_PTY_OFF = 0UL,
      FI_EN_TA_ON_PTY31_OFF = 1UL,
      FI_EN_PTY31_ON_TA_OFF = 2UL,
      FI_EN_TA_ON_PTY31_ON = 3UL,
      FI_EN_TA_OFF_PTY31_OFF_WEATHERALERT_ON = 4UL,
      FI_EN_TA_ON_PTY31_OFF_WEATHERALERT_ON = 5UL,
      FI_EN_TA_OFF_PTY31_ON_WEATHERALERT_ON = 6UL,
      FI_EN_TA_ON_PTY31_ON_WEATHERALERT_ON = 7UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Anno_Message(midw_fi_tcl_e8_Anno_Message::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Anno_Message();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Anno_Message& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_Engg_Param_List_Elem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_Engg_Param_List_Elem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_Engg_Param_List_Elem& operator=(const midw_fi_tcl_Tun_Engg_Param_List_Elem& coRef);
   midw_fi_tcl_Tun_Engg_Param_List_Elem(const midw_fi_tcl_Tun_Engg_Param_List_Elem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Engg_Param_ID e8ParameterID;
   tU32 u32ParameterValue;
   virtual ~midw_fi_tcl_Tun_Engg_Param_List_Elem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_Engg_Param_List_Elem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_DefaultSettingOption : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_DefaultSettingOption();
   enum tenType {
      FI_EN_INVALID_TYPE = 255UL,
      FI_EN_RESET_ALL_USER_CHANGEABLE_PARAM = 0UL,
      FI_EN_RESET_ALL_USER_CHANGEABLE_PARAM_CURRENT_USR = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_DefaultSettingOption(midw_fi_tcl_e8_Tun_DefaultSettingOption::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_DefaultSettingOption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_DefaultSettingOption& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AvailableBandInfoElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AvailableBandInfoElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AvailableBandInfoElement& operator=(const midw_fi_tcl_AvailableBandInfoElement& coRef);
   midw_fi_tcl_AvailableBandInfoElement(const midw_fi_tcl_AvailableBandInfoElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerBand e8Band;
   tU32 u32HighFrequency;
   tU32 u32LowFrequency;
   tU16 u16AutoSeekStepWidth;
   tU16 u16ManualStepWidth;
   virtual ~midw_fi_tcl_AvailableBandInfoElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AvailableBandInfoElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AvailableBandInfoList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AvailableBandInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AvailableBandInfoList& operator=(const midw_fi_tcl_AvailableBandInfoList& coRef);
   midw_fi_tcl_AvailableBandInfoList(const midw_fi_tcl_AvailableBandInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_AvailableBandInfoElement, std::allocator<midw_fi_tcl_AvailableBandInfoElement> > AvailableBandInfoElement;
   virtual ~midw_fi_tcl_AvailableBandInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AvailableBandInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_DemodSwitch : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_DemodSwitch();

   enum {
      FI_C_U8_BIT_FM_AM = 0x1UL,
      FI_C_U8_BIT_FM_HD = 0x2UL,
      FI_C_U8_BIT_AM_HD = 0x4UL,
      FI_C_U8_BIT_DRM30 = 0x8UL
   };
   tBool bFM_AM() const {return (u8Value & FI_C_U8_BIT_FM_AM) != 0; }
   tVoid vSetFM_AM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FM_AM):(u8Value & ~(tU8)FI_C_U8_BIT_FM_AM)); }
   tBool bFM_HD() const {return (u8Value & FI_C_U8_BIT_FM_HD) != 0; }
   tVoid vSetFM_HD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FM_HD):(u8Value & ~(tU8)FI_C_U8_BIT_FM_HD)); }
   tBool bAM_HD() const {return (u8Value & FI_C_U8_BIT_AM_HD) != 0; }
   tVoid vSetAM_HD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AM_HD):(u8Value & ~(tU8)FI_C_U8_BIT_AM_HD)); }
   tBool bDRM30() const {return (u8Value & FI_C_U8_BIT_DRM30) != 0; }
   tVoid vSetDRM30(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM30):(u8Value & ~(tU8)FI_C_U8_BIT_DRM30)); }
   struct rBitValues {
      tBool FM_AM:1;
      tBool FM_HD:1;
      tBool AM_HD:1;
      tBool DRM30:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_DemodSwitch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_DemodSwitch& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_SelectMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_SelectMode();
   enum tenType {
      FI_EN_TUN_SELECTMODE_ABSOLUTE = 0UL,
      FI_EN_TUN_SELECTMODE_RELATIVE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_SelectMode(midw_fi_tcl_e8_Tun_SelectMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_SelectMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_SelectMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerBandAndStationInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerBandAndStationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerBandAndStationInfo& operator=(const midw_fi_tcl_TunerBandAndStationInfo& coRef);
   midw_fi_tcl_TunerBandAndStationInfo(const midw_fi_tcl_TunerBandAndStationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerBand e8Band;
   tU32 u32Frequency;
   tU16 u16PI;
   midw_fi_tclString sPSName;
   tU16 u16StaticListElementID;
   midw_fi_tclString sHDCallSign;
   tU32 u32HDStationId;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioProgram;
   tU8 u8PresetAutocompare;
   midw_fi_tclString sDRMServiceLabel;
   tU32 u32DRMServiceId;
   tU8 u8DRMServiceShortId;
   virtual ~midw_fi_tcl_TunerBandAndStationInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerBandAndStationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_RelativeDirection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_RelativeDirection();
   enum tenType {
      FI_EN_TUN_RELATIVE_DECREMENT = 0UL,
      FI_EN_TUN_RELATIVE_INCREMENT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_RelativeDirection(midw_fi_tcl_e8_Tun_RelativeDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_RelativeDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_RelativeDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_HDPrgmAvail : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_HDPrgmAvail();

   enum {
      FI_C_U8_BIT_MPS_AVAIL = 0x1UL,
      FI_C_U8_BIT_SPS_1_AVAIL = 0x2UL,
      FI_C_U8_BIT_SPS_2_AVAIL = 0x4UL,
      FI_C_U8_BIT_SPS_3_AVAIL = 0x8UL,
      FI_C_U8_BIT_SPS_4_AVAIL = 0x10UL,
      FI_C_U8_BIT_SPS_5_AVAIL = 0x20UL,
      FI_C_U8_BIT_SPS_6_AVAIL = 0x40UL,
      FI_C_U8_BIT_SPS_7_AVAIL = 0x80UL
   };
   tBool bMPS_AVAIL() const {return (u8Value & FI_C_U8_BIT_MPS_AVAIL) != 0; }
   tVoid vSetMPS_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MPS_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_MPS_AVAIL)); }
   tBool bSPS_1_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_1_AVAIL) != 0; }
   tVoid vSetSPS_1_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_1_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_1_AVAIL)); }
   tBool bSPS_2_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_2_AVAIL) != 0; }
   tVoid vSetSPS_2_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_2_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_2_AVAIL)); }
   tBool bSPS_3_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_3_AVAIL) != 0; }
   tVoid vSetSPS_3_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_3_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_3_AVAIL)); }
   tBool bSPS_4_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_4_AVAIL) != 0; }
   tVoid vSetSPS_4_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_4_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_4_AVAIL)); }
   tBool bSPS_5_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_5_AVAIL) != 0; }
   tVoid vSetSPS_5_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_5_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_5_AVAIL)); }
   tBool bSPS_6_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_6_AVAIL) != 0; }
   tVoid vSetSPS_6_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_6_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_6_AVAIL)); }
   tBool bSPS_7_AVAIL() const {return (u8Value & FI_C_U8_BIT_SPS_7_AVAIL) != 0; }
   tVoid vSetSPS_7_AVAIL(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SPS_7_AVAIL):(u8Value & ~(tU8)FI_C_U8_BIT_SPS_7_AVAIL)); }
   struct rBitValues {
      tBool MPS_AVAIL:1;
      tBool SPS_1_AVAIL:1;
      tBool SPS_2_AVAIL:1;
      tBool SPS_3_AVAIL:1;
      tBool SPS_4_AVAIL:1;
      tBool SPS_5_AVAIL:1;
      tBool SPS_6_AVAIL:1;
      tBool SPS_7_AVAIL:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_HDPrgmAvail();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_HDPrgmAvail& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_DRMStationInfoBits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_DRMStationInfoBits();

   enum {
      FI_C_U8_BIT_DRM_MODULATION_DETECTION = 0x1UL,
      FI_C_U8_BIT_DRM_MULTIPLEX_INFO_DECODING = 0x2UL,
      FI_C_U8_BIT_DRM_AUDIO_DECODING = 0x4UL,
      FI_C_U8_BIT_DRM_AUDIO_MUTE = 0x8UL,
      FI_C_U8_BIT_RESERVED_1 = 0x10UL,
      FI_C_U8_BIT_RESERVED_2 = 0x20UL,
      FI_C_U8_BIT_RESERVED_3 = 0x40UL,
      FI_C_U8_BIT_RESERVED_4 = 0x80UL
   };
   tBool bDRM_MODULATION_DETECTION() const {return (u8Value & FI_C_U8_BIT_DRM_MODULATION_DETECTION) != 0; }
   tVoid vSetDRM_MODULATION_DETECTION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM_MODULATION_DETECTION):(u8Value & ~(tU8)FI_C_U8_BIT_DRM_MODULATION_DETECTION)); }
   tBool bDRM_MULTIPLEX_INFO_DECODING() const {return (u8Value & FI_C_U8_BIT_DRM_MULTIPLEX_INFO_DECODING) != 0; }
   tVoid vSetDRM_MULTIPLEX_INFO_DECODING(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM_MULTIPLEX_INFO_DECODING):(u8Value & ~(tU8)FI_C_U8_BIT_DRM_MULTIPLEX_INFO_DECODING)); }
   tBool bDRM_AUDIO_DECODING() const {return (u8Value & FI_C_U8_BIT_DRM_AUDIO_DECODING) != 0; }
   tVoid vSetDRM_AUDIO_DECODING(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM_AUDIO_DECODING):(u8Value & ~(tU8)FI_C_U8_BIT_DRM_AUDIO_DECODING)); }
   tBool bDRM_AUDIO_MUTE() const {return (u8Value & FI_C_U8_BIT_DRM_AUDIO_MUTE) != 0; }
   tVoid vSetDRM_AUDIO_MUTE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DRM_AUDIO_MUTE):(u8Value & ~(tU8)FI_C_U8_BIT_DRM_AUDIO_MUTE)); }
   tBool bRESERVED_1() const {return (u8Value & FI_C_U8_BIT_RESERVED_1) != 0; }
   tVoid vSetRESERVED_1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_1):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_1)); }
   tBool bRESERVED_2() const {return (u8Value & FI_C_U8_BIT_RESERVED_2) != 0; }
   tVoid vSetRESERVED_2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_2):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_2)); }
   tBool bRESERVED_3() const {return (u8Value & FI_C_U8_BIT_RESERVED_3) != 0; }
   tVoid vSetRESERVED_3(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_3):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_3)); }
   tBool bRESERVED_4() const {return (u8Value & FI_C_U8_BIT_RESERVED_4) != 0; }
   tVoid vSetRESERVED_4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_4):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_4)); }
   struct rBitValues {
      tBool DRM_MODULATION_DETECTION:1;
      tBool DRM_MULTIPLEX_INFO_DECODING:1;
      tBool DRM_AUDIO_DECODING:1;
      tBool DRM_AUDIO_MUTE:1;
      tBool RESERVED_1:1;
      tBool RESERVED_2:1;
      tBool RESERVED_3:1;
      tBool RESERVED_4:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_DRMStationInfoBits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_DRMStationInfoBits& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b16_Tun_DRMAnnouBits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b16_Tun_DRMAnnouBits();

   enum {
      FI_C_U16_BIT_RESERVED_1 = 0x1UL,
      FI_C_U16_BIT_RESERVED_2 = 0x2UL,
      FI_C_U16_BIT_RESERVED_3 = 0x4UL,
      FI_C_U16_BIT_RESERVED_4 = 0x8UL,
      FI_C_U16_BIT_RESERVED_5 = 0x10UL,
      FI_C_U16_BIT_RESERVED_6 = 0x20UL,
      FI_C_U16_BIT_RESERVED_7 = 0x40UL,
      FI_C_U16_BIT_RESERVED_8 = 0x80UL,
      FI_C_U16_BIT_RESERVED_9 = 0x100UL,
      FI_C_U16_BIT_RESERVED_10 = 0x200UL,
      FI_C_U16_BIT_RESERVED_11 = 0x400UL,
      FI_C_U16_BIT_RESERVED_12 = 0x800UL,
      FI_C_U16_BIT_RESERVED_13 = 0x1000UL,
      FI_C_U16_BIT_RESERVED_14 = 0x2000UL,
      FI_C_U16_BIT_RESERVED_15 = 0x4000UL,
      FI_C_U16_BIT_RESERVED_16 = 0x8000UL
   };
   tBool bRESERVED_1() const {return (u16Value & FI_C_U16_BIT_RESERVED_1) != 0; }
   tVoid vSetRESERVED_1(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_1):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_1)); }
   tBool bRESERVED_2() const {return (u16Value & FI_C_U16_BIT_RESERVED_2) != 0; }
   tVoid vSetRESERVED_2(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_2):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_2)); }
   tBool bRESERVED_3() const {return (u16Value & FI_C_U16_BIT_RESERVED_3) != 0; }
   tVoid vSetRESERVED_3(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_3):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_3)); }
   tBool bRESERVED_4() const {return (u16Value & FI_C_U16_BIT_RESERVED_4) != 0; }
   tVoid vSetRESERVED_4(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_4):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_4)); }
   tBool bRESERVED_5() const {return (u16Value & FI_C_U16_BIT_RESERVED_5) != 0; }
   tVoid vSetRESERVED_5(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_5):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_5)); }
   tBool bRESERVED_6() const {return (u16Value & FI_C_U16_BIT_RESERVED_6) != 0; }
   tVoid vSetRESERVED_6(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_6):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_6)); }
   tBool bRESERVED_7() const {return (u16Value & FI_C_U16_BIT_RESERVED_7) != 0; }
   tVoid vSetRESERVED_7(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_7):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_7)); }
   tBool bRESERVED_8() const {return (u16Value & FI_C_U16_BIT_RESERVED_8) != 0; }
   tVoid vSetRESERVED_8(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_8):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_8)); }
   tBool bRESERVED_9() const {return (u16Value & FI_C_U16_BIT_RESERVED_9) != 0; }
   tVoid vSetRESERVED_9(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_9):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_9)); }
   tBool bRESERVED_10() const {return (u16Value & FI_C_U16_BIT_RESERVED_10) != 0; }
   tVoid vSetRESERVED_10(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_10):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_10)); }
   tBool bRESERVED_11() const {return (u16Value & FI_C_U16_BIT_RESERVED_11) != 0; }
   tVoid vSetRESERVED_11(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_11):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_11)); }
   tBool bRESERVED_12() const {return (u16Value & FI_C_U16_BIT_RESERVED_12) != 0; }
   tVoid vSetRESERVED_12(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_12):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_12)); }
   tBool bRESERVED_13() const {return (u16Value & FI_C_U16_BIT_RESERVED_13) != 0; }
   tVoid vSetRESERVED_13(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_13):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_13)); }
   tBool bRESERVED_14() const {return (u16Value & FI_C_U16_BIT_RESERVED_14) != 0; }
   tVoid vSetRESERVED_14(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_14):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_14)); }
   tBool bRESERVED_15() const {return (u16Value & FI_C_U16_BIT_RESERVED_15) != 0; }
   tVoid vSetRESERVED_15(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_15):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_15)); }
   tBool bRESERVED_16() const {return (u16Value & FI_C_U16_BIT_RESERVED_16) != 0; }
   tVoid vSetRESERVED_16(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_RESERVED_16):(u16Value & ~(tU16)FI_C_U16_BIT_RESERVED_16)); }
   struct rBitValues {
      tBool RESERVED_1:1;
      tBool RESERVED_2:1;
      tBool RESERVED_3:1;
      tBool RESERVED_4:1;
      tBool RESERVED_5:1;
      tBool RESERVED_6:1;
      tBool RESERVED_7:1;
      tBool RESERVED_8:1;
      tBool RESERVED_9:1;
      tBool RESERVED_10:1;
      tBool RESERVED_11:1;
      tBool RESERVED_12:1;
      tBool RESERVED_13:1;
      tBool RESERVED_14:1;
      tBool RESERVED_15:1;
      tBool RESERVED_16:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b16_Tun_DRMAnnouBits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b16_Tun_DRMAnnouBits& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices();

   enum {
      FI_C_U8_BIT_AUDIO_PROGRAM_1 = 0x1UL,
      FI_C_U8_BIT_AUDIO_PROGRAM_2 = 0x2UL,
      FI_C_U8_BIT_AUDIO_PROGRAM_3 = 0x4UL,
      FI_C_U8_BIT_AUDIO_PROGRAM_4 = 0x8UL,
      FI_C_U8_BIT_RESERVED_1 = 0x10UL,
      FI_C_U8_BIT_RESERVED_2 = 0x20UL,
      FI_C_U8_BIT_RESERVED_3 = 0x40UL,
      FI_C_U8_BIT_RESERVED_4 = 0x80UL
   };
   tBool bAUDIO_PROGRAM_1() const {return (u8Value & FI_C_U8_BIT_AUDIO_PROGRAM_1) != 0; }
   tVoid vSetAUDIO_PROGRAM_1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AUDIO_PROGRAM_1):(u8Value & ~(tU8)FI_C_U8_BIT_AUDIO_PROGRAM_1)); }
   tBool bAUDIO_PROGRAM_2() const {return (u8Value & FI_C_U8_BIT_AUDIO_PROGRAM_2) != 0; }
   tVoid vSetAUDIO_PROGRAM_2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AUDIO_PROGRAM_2):(u8Value & ~(tU8)FI_C_U8_BIT_AUDIO_PROGRAM_2)); }
   tBool bAUDIO_PROGRAM_3() const {return (u8Value & FI_C_U8_BIT_AUDIO_PROGRAM_3) != 0; }
   tVoid vSetAUDIO_PROGRAM_3(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AUDIO_PROGRAM_3):(u8Value & ~(tU8)FI_C_U8_BIT_AUDIO_PROGRAM_3)); }
   tBool bAUDIO_PROGRAM_4() const {return (u8Value & FI_C_U8_BIT_AUDIO_PROGRAM_4) != 0; }
   tVoid vSetAUDIO_PROGRAM_4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_AUDIO_PROGRAM_4):(u8Value & ~(tU8)FI_C_U8_BIT_AUDIO_PROGRAM_4)); }
   tBool bRESERVED_1() const {return (u8Value & FI_C_U8_BIT_RESERVED_1) != 0; }
   tVoid vSetRESERVED_1(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_1):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_1)); }
   tBool bRESERVED_2() const {return (u8Value & FI_C_U8_BIT_RESERVED_2) != 0; }
   tVoid vSetRESERVED_2(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_2):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_2)); }
   tBool bRESERVED_3() const {return (u8Value & FI_C_U8_BIT_RESERVED_3) != 0; }
   tVoid vSetRESERVED_3(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_3):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_3)); }
   tBool bRESERVED_4() const {return (u8Value & FI_C_U8_BIT_RESERVED_4) != 0; }
   tVoid vSetRESERVED_4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED_4):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED_4)); }
   struct rBitValues {
      tBool AUDIO_PROGRAM_1:1;
      tBool AUDIO_PROGRAM_2:1;
      tBool AUDIO_PROGRAM_3:1;
      tBool AUDIO_PROGRAM_4:1;
      tBool RESERVED_1:1;
      tBool RESERVED_2:1;
      tBool RESERVED_3:1;
      tBool RESERVED_4:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Atstationinfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Atstationinfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Atstationinfo& operator=(const midw_fi_tcl_Atstationinfo& coRef);
   midw_fi_tcl_Atstationinfo(const midw_fi_tcl_Atstationinfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   midw_fi_tcl_b32_Tun_AvailFlags u32AvailFlags;
   tU32 u32Frequency;
   tU16 u16PI;
   midw_fi_tclString sPSName;
   midw_fi_tcl_e8_Tun_TunerBand e8Band;
   midw_fi_tcl_e8_AtStationTPinfo e8AtStationTPinfo;
   tU16 u16PresetListID;
   tU8 u8ActiveStationList;
   tU16 u16StaticListElementID;
   tU16 u16ConfigListElementID;
   midw_fi_tcl_b8_Tun_AtStationInfoBits u8AtStationInfoBits;
   tU8 u8PTY;
   tU8 u8FieldStrngth;
   tU8 u8Quality;
   midw_fi_tcl_b8_Tun_HDInfoBits b8HDStationInfoBits;
   tU32 u32StationInfoHDStationID;
   midw_fi_tclString sHDCallSign;
   midw_fi_tcl_e8_Tun_HD_TextEncodingType e8HDCallSignTextEncoding;
   tU8 u8HDStationGenre;
   midw_fi_tcl_b8_Tun_HDPrgmAvail b8HDAudioPrgmAvail;
   tU8 u8HDQuality;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8ActiveHDAudPrgm;
   midw_fi_tclString StationLogo;
   midw_fi_tcl_b8_Tun_DRMStationInfoBits b8DRMStationInfoBits;
   tU32 u32DRMServiceId;
   midw_fi_tclString sDRMServiceLabel;
   tU8 u8DRMPTY;
   midw_fi_tcl_b16_Tun_DRMAnnouBits b16DRMAnnouBits;
   midw_fi_tcl_b8_Tun_DRMNumberOfAudioServices b8DRMNumberOfAudioServices;
   tU8 u8DRMQuality;
   tU8 u8DRMServiceShortId;
   tU8 u8Drmlanguage;
   tU32 u32DrmlanguageCode;
   tU16 u16DrmCountryCode;
   tS8 s8DrmFrequencyCorrection;
   tU8 u8JapanStationCount;
   tBool bUserPresetAction;
   virtual ~midw_fi_tcl_Atstationinfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Atstationinfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_MakeConfigList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_MakeConfigList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_MakeConfigList& operator=(const midw_fi_tcl_Tun_MakeConfigList& coRef);
   midw_fi_tcl_Tun_MakeConfigList(const midw_fi_tcl_Tun_MakeConfigList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID eConfigListID;
   tU32 u32PTY;
   midw_fi_tcl_e8_Tun_SortingCriteria eSortingCriteria;
   midw_fi_tcl_b8_Tun_Digital_Filters u8DigitalFilters;
   tBool bFrozenList;
   virtual ~midw_fi_tcl_Tun_MakeConfigList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_MakeConfigList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerConfigListElementList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerConfigListElementList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerConfigListElementList& operator=(const midw_fi_tcl_TunerConfigListElementList& coRef);
   midw_fi_tcl_TunerConfigListElementList(const midw_fi_tcl_TunerConfigListElementList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerConfigListElement, std::allocator<midw_fi_tcl_TunerConfigListElement> > TunerConfigListElement;
   virtual ~midw_fi_tcl_TunerConfigListElementList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerConfigListElementList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerRadioText : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerRadioText();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerRadioText& operator=(const midw_fi_tcl_TunerRadioText& coRef);
   midw_fi_tcl_TunerRadioText(const midw_fi_tcl_TunerRadioText& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   midw_fi_tcl_e8_Tun_Source u8TunerSource;
   tU8 u8TextType;
   midw_fi_tclString sRadioTextData;
   virtual ~midw_fi_tcl_TunerRadioText();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerRadioText& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_DRMSourceActivity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_DRMSourceActivity();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_PAUSE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_DRMSourceActivity(midw_fi_tcl_e8_Tun_DRMSourceActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_DRMSourceActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_DRMSourceActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PISearch_Status : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PISearch_Status();
   enum tenType {
      FI_EN_SEARCH_STARTED = 0UL,
      FI_EN_IDLE = 1UL,
      FI_EN_PI_LOST = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_PISearch_Status(midw_fi_tcl_e8_PISearch_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PISearch_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PISearch_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerHDTestModeData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerHDTestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerHDTestModeData& operator=(const midw_fi_tcl_TunerHDTestModeData& coRef);
   midw_fi_tcl_TunerHDTestModeData(const midw_fi_tcl_TunerHDTestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PhysicalTuner e8PhysicalTuner;
   midw_fi_tclString sHDCallSign;
   tU32 u32HDStationId;
   midw_fi_tcl_b8_Tun_HDNumOfAudioPrograms b8HDAvailableAudioPrograms;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDActiveAudioProgram;
   tU8 u8AudioQuality;
   midw_fi_tcl_b8_Tun_HDInfoBits b8HDStationInfoBits;
   tU8 u8ACQStates;
   tU8 u8CD_NO;
   tU8 u8TransitionCount;
   virtual ~midw_fi_tcl_TunerHDTestModeData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerHDTestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_HDAdvisoryInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_HDAdvisoryInfo();
   enum tenType {
      FI_EN_TUN_HD_ADVISORY_ACQUIRING = 0UL,
      FI_EN_TUN_HD_ADVISORY_SIGNAL_LOST = 1UL,
      FI_EN_TUN_HD_ADVISORY_WAITING_FOR_SIGNAL = 2UL,
      FI_EN_TUN_HD_ADVISORY_CHANNEL_NOT_AVAILABLE = 3UL,
      FI_EN_TUN_HD_ADVISORY_HDAUDIO_AVAILABLE = 4UL,
      FI_EN_TUN_HD_ADVISORY_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_HDAdvisoryInfo(midw_fi_tcl_e8_Tun_HDAdvisoryInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_HDAdvisoryInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_HDAdvisoryInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_DRMTestModeActivity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_DRMTestModeActivity();
   enum tenType {
      FI_EN_TESTMODE_AUTO_NOTIFICATIONS_OFF = 0UL,
      FI_EN_TESTMODE_AUTO_NOTIFICATIONS_ON = 1UL,
      FI_EN_TESTMODE_AUTO_NOTIFICATIONS_ON_FOR_AUDIOTUNER = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_DRMTestModeActivity(midw_fi_tcl_e8_Tun_DRMTestModeActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_DRMTestModeActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_DRMTestModeActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_HDImageType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_HDImageType();
   enum tenType {
      FI_EN_TUN_HD_STATION_LOGO = 0UL,
      FI_EN_TUN_HD_COVER_ART = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_HDImageType(midw_fi_tcl_e8_Tun_HDImageType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_HDImageType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_HDImageType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_HDImageCoding : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_HDImageCoding();
   enum tenType {
      FI_EN_TUN_JPG = 0UL,
      FI_EN_TUN_PNG = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_HDImageCoding(midw_fi_tcl_e8_Tun_HDImageCoding::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_HDImageCoding();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_HDImageCoding& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ImageFileInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ImageFileInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ImageFileInfo& operator=(const midw_fi_tcl_ImageFileInfo& coRef);
   midw_fi_tcl_ImageFileInfo(const midw_fi_tcl_ImageFileInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32HDStationId;
   midw_fi_tcl_e8_Tun_HDImageType e8HDImageType;
   midw_fi_tcl_e8_Tun_HDImageCoding e8HDImageCoding;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioProgram;
   tU32 u32NoOfImageFileBytes;
   std::vector<tU8, std::allocator<tU8> > ImageFileBytes;
   virtual ~midw_fi_tcl_ImageFileInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ImageFileInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunPSDCommercial : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunPSDCommercial();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunPSDCommercial& operator=(const midw_fi_tcl_TunPSDCommercial& coRef);
   midw_fi_tcl_TunPSDCommercial(const midw_fi_tcl_TunPSDCommercial& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sPriceString;
   midw_fi_tclString sValidUntil;
   midw_fi_tclString sContactURL;
   midw_fi_tclString sReceivedAs;
   midw_fi_tclString sNameOfSeller;
   midw_fi_tclString sDescription;
   virtual ~midw_fi_tcl_TunPSDCommercial();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunPSDCommercial& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunPSDComment : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunPSDComment();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunPSDComment& operator=(const midw_fi_tcl_TunPSDComment& coRef);
   midw_fi_tcl_TunPSDComment(const midw_fi_tcl_TunPSDComment& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sLanguage;
   midw_fi_tclString sShortContentDescription;
   midw_fi_tclString sActualText;
   virtual ~midw_fi_tcl_TunPSDComment();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunPSDComment& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunPSDData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunPSDData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunPSDData& operator=(const midw_fi_tcl_TunPSDData& coRef);
   midw_fi_tcl_TunPSDData(const midw_fi_tcl_TunPSDData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioProgram;
   midw_fi_tclString sTitle;
   midw_fi_tclString sArtist;
   midw_fi_tclString sAlbum;
   midw_fi_tclString sGenre;
   midw_fi_tcl_TunPSDCommercial TunPSDCommercial;
   midw_fi_tcl_TunPSDComment TunPSDComment;
   virtual ~midw_fi_tcl_TunPSDData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunPSDData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TestModeActivity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TestModeActivity();
   enum tenType {
      FI_EN_TUN_TEST_MODE_NOTIFICATION_OFF = 0UL,
      FI_EN_TUN_TEST_MODE_NOTIFICATION_ON = 1UL,
      FI_EN_TUN_TEST_MODE_NOTIFICATION_ON_AUDIO_TUNER_ONLY = 2UL,
      FI_EN_TUN_TEST_MODE_NOTIFICATION_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TestModeActivity(midw_fi_tcl_e8_Tun_TestModeActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TestModeActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TestModeActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TestModeSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TestModeSource();
   enum tenType {
      FI_EN_TUN_TEST_MODE_SOURCE_ANALOG_AMFM = 0UL,
      FI_EN_TUN_TEST_MODE_SOURCE_HD = 1UL,
      FI_EN_TUN_TEST_MODE_SOURCE_DRM = 2UL,
      FI_EN_TUN_TEST_MODE_SOURCE_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TestModeSource(midw_fi_tcl_e8_Tun_TestModeSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TestModeSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TestModeSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AudioSplitMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AudioSplitMode();
   enum tenType {
      FI_EN_TUN_DEACTIVATE_AUDIO_SPLIT_MODE = 0UL,
      FI_EN_TUN_ACTIVATE_AUDIO_SPLIT_MODE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AudioSplitMode(midw_fi_tcl_e8_Tun_AudioSplitMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AudioSplitMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AudioSplitMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_Tun_ParameterID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_Tun_ParameterID();
   enum tenType {
      FI_EN_AUDIO_SPLIT_MODE = 0UL,
      FI_EN_BLEND_THRESHOLD_FM_HYBRID = 1UL,
      FI_EN_BLEND_RATE_FM_HYBRID = 2UL,
      FI_EN_BLEND_THRESHOLD_AM_HYBRID = 3UL,
      FI_EN_AM_MPS_BLEND_RATE = 4UL,
      FI_EN_BLEND_DECISION = 5UL,
      FI_EN_FM_CD_OR_N0_BLEND_DECISION = 6UL,
      FI_EN_AM_CD_OR_N0_BLEND_DECISION = 7UL,
      FI_EN_FM_SPS_BLEND_THRESHOLD = 8UL,
      FI_EN_FM_SPS_BLEND_RATE = 9UL
   };
   tenType enType;

   midw_fi_tcl_e16_Tun_ParameterID(midw_fi_tcl_e16_Tun_ParameterID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_Tun_ParameterID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_Tun_ParameterID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_PhysicalTunerCalibData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_PhysicalTunerCalibData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_PhysicalTunerCalibData& operator=(const midw_fi_tcl_PhysicalTunerCalibData& coRef);
   midw_fi_tcl_PhysicalTunerCalibData(const midw_fi_tcl_PhysicalTunerCalibData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_Tunerbandbits b8AvailableBands;
   tU16 u16FMCalibrationValue;
   tU16 u16AMCalibrationValue;
   virtual ~midw_fi_tcl_PhysicalTunerCalibData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_PhysicalTunerCalibData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CalibrationData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CalibrationData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CalibrationData& operator=(const midw_fi_tcl_CalibrationData& coRef);
   midw_fi_tcl_CalibrationData(const midw_fi_tcl_CalibrationData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_PhysicalTunerCalibData PhysicalTunerOne;
   midw_fi_tcl_PhysicalTunerCalibData PhysicalTunerTwo;
   midw_fi_tcl_PhysicalTunerCalibData PhysicalTunerThree;
   midw_fi_tcl_PhysicalTunerCalibData PhysicalTunerFour;
   virtual ~midw_fi_tcl_CalibrationData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CalibrationData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_StationSelectionOption : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_StationSelectionOption();
   enum tenType {
      FI_EN_FREQUENCY_INPUT = 0UL,
      FI_EN_HDSTATIONID_INPUT = 1UL,
      FI_EN_DRMSERVICEID_INPUT = 2UL,
      FI_EN_PRESET_INPUT = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_StationSelectionOption(midw_fi_tcl_e8_StationSelectionOption::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_StationSelectionOption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_StationSelectionOption& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Japan_Region : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Japan_Region();
   enum tenType {
      FI_EN_TUN_HOKKAIDO = 0UL,
      FI_EN_TUN_TOHOKU = 1UL,
      FI_EN_TUN_KANTO = 2UL,
      FI_EN_TUN_SHINETSU = 3UL,
      FI_EN_TUN_CHUUBU = 4UL,
      FI_EN_TUN_HOKURIKU = 5UL,
      FI_EN_TUN_KANSAI = 6UL,
      FI_EN_TUN_CHUGOKU = 7UL,
      FI_EN_TUN_SHIKOKU = 8UL,
      FI_EN_TUN_KYUSHU = 9UL,
      FI_EN_TUN_AUTO = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Japan_Region(midw_fi_tcl_e8_Tun_Japan_Region::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Japan_Region();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Japan_Region& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_Language : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_Language();
   enum tenType {
      FI_EN_LANG_ENGLISH = 0UL,
      FI_EN_LANG_JAPANESE = 1UL,
      FI_EN_TUN_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_Language(midw_fi_tcl_e8_Tun_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ChangeStationMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ChangeStationMode();
   enum tenType {
      FI_EN_TUN_UP = 0UL,
      FI_EN_TUN_DOWN = 1UL,
      FI_EN_TUN_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ChangeStationMode(midw_fi_tcl_e8_Tun_ChangeStationMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ChangeStationMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ChangeStationMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerJapanStationName : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerJapanStationName();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerJapanStationName& operator=(const midw_fi_tcl_TunerJapanStationName& coRef);
   midw_fi_tcl_TunerJapanStationName(const midw_fi_tcl_TunerJapanStationName& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16IndexID;
   midw_fi_tclString sJapanStationName;
   virtual ~midw_fi_tcl_TunerJapanStationName();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerJapanStationName& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerJapanStationNameList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerJapanStationNameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerJapanStationNameList& operator=(const midw_fi_tcl_TunerJapanStationNameList& coRef);
   midw_fi_tcl_TunerJapanStationNameList(const midw_fi_tcl_TunerJapanStationNameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerJapanStationName, std::allocator<midw_fi_tcl_TunerJapanStationName> > TunerJapanStationName;
   virtual ~midw_fi_tcl_TunerJapanStationNameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerJapanStationNameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u32FrequencyList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u32FrequencyList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_u32FrequencyList& operator=(const midw_fi_tcl_u32FrequencyList& coRef);
   midw_fi_tcl_u32FrequencyList(const midw_fi_tcl_u32FrequencyList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > FrequencyValues;
   virtual ~midw_fi_tcl_u32FrequencyList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_u32FrequencyList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_STATStatusRegister : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_STATStatusRegister();

   enum {
      FI_C_U8_BIT_RESERVED = 0x1UL,
      FI_C_U8_BIT_STAT_CRC4 = 0x2UL,
      FI_C_U8_BIT_STAT_HEAD = 0x4UL,
      FI_C_U8_BIT_STAT_PRI = 0x8UL,
      FI_C_U8_BIT_STAT_ERR = 0x10UL,
      FI_C_U8_BIT_STAT_FRM = 0x20UL,
      FI_C_U8_BIT_STAT_BLK = 0x40UL,
      FI_C_U8_BIT_STAT_VH = 0x80UL
   };
   tBool bReserved() const {return (u8Value & FI_C_U8_BIT_RESERVED) != 0; }
   tVoid vSetReserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_RESERVED)); }
   tBool bSTAT_CRC4() const {return (u8Value & FI_C_U8_BIT_STAT_CRC4) != 0; }
   tVoid vSetSTAT_CRC4(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_CRC4):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_CRC4)); }
   tBool bSTAT_HEAD() const {return (u8Value & FI_C_U8_BIT_STAT_HEAD) != 0; }
   tVoid vSetSTAT_HEAD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_HEAD):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_HEAD)); }
   tBool bSTAT_PRI() const {return (u8Value & FI_C_U8_BIT_STAT_PRI) != 0; }
   tVoid vSetSTAT_PRI(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_PRI):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_PRI)); }
   tBool bSTAT_ERR() const {return (u8Value & FI_C_U8_BIT_STAT_ERR) != 0; }
   tVoid vSetSTAT_ERR(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_ERR):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_ERR)); }
   tBool bSTAT_FRM() const {return (u8Value & FI_C_U8_BIT_STAT_FRM) != 0; }
   tVoid vSetSTAT_FRM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_FRM):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_FRM)); }
   tBool bSTAT_BLK() const {return (u8Value & FI_C_U8_BIT_STAT_BLK) != 0; }
   tVoid vSetSTAT_BLK(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_BLK):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_BLK)); }
   tBool bSTAT_VH() const {return (u8Value & FI_C_U8_BIT_STAT_VH) != 0; }
   tVoid vSetSTAT_VH(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_STAT_VH):(u8Value & ~(tU8)FI_C_U8_BIT_STAT_VH)); }
   struct rBitValues {
      tBool Reserved:1;
      tBool STAT_CRC4:1;
      tBool STAT_HEAD:1;
      tBool STAT_PRI:1;
      tBool STAT_ERR:1;
      tBool STAT_FRM:1;
      tBool STAT_BLK:1;
      tBool STAT_VH:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_STATStatusRegister();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_STATStatusRegister& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DARCDataBlock : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DARCDataBlock();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DARCDataBlock& operator=(const midw_fi_tcl_DARCDataBlock& coRef);
   midw_fi_tcl_DARCDataBlock(const midw_fi_tcl_DARCDataBlock& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_STATStatusRegister STAT_Status_Register;
   tU8 Block_Number_Register;
   std::vector<tU8, std::allocator<tU8> > DARCDataList;
   virtual ~midw_fi_tcl_DARCDataBlock();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DARCDataBlock& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DARCDataBlockList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DARCDataBlockList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DARCDataBlockList& operator=(const midw_fi_tcl_DARCDataBlockList& coRef);
   midw_fi_tcl_DARCDataBlockList(const midw_fi_tcl_DARCDataBlockList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_DARCDataBlock, std::allocator<midw_fi_tcl_DARCDataBlock> > DARCDataBlock;
   virtual ~midw_fi_tcl_DARCDataBlockList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DARCDataBlockList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerListElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerListElement& operator=(const midw_fi_tcl_TunerListElement& coRef);
   midw_fi_tcl_TunerListElement(const midw_fi_tcl_TunerListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ListID e8ListID;
   tU8 u8ElementID;
   midw_fi_tcl_e8_Tun_ModulationType e8Modulation;
   tU32 u32Frequency;
   tU32 u32SID;
   tU8 u8NumOfCharactersInStationName;
   midw_fi_tclString sStationName;
   tU8 u8StationNameEncoding;
   tU8 u8ProgramService;
   virtual ~midw_fi_tcl_TunerListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerListElementList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerListElementList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerListElementList& operator=(const midw_fi_tcl_TunerListElementList& coRef);
   midw_fi_tcl_TunerListElementList(const midw_fi_tcl_TunerListElementList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerListElement, std::allocator<midw_fi_tcl_TunerListElement> > TunerListElement;
   virtual ~midw_fi_tcl_TunerListElementList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerListElementList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_SwitchingFrequency : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_SwitchingFrequency();

   enum {
      FI_C_U8_BIT_FREQUENCY_384KHZ = 0x1UL,
      FI_C_U8_BIT_FREQUENCY_432KHZ = 0x2UL
   };
   tBool bFREQUENCY_384kHz() const {return (u8Value & FI_C_U8_BIT_FREQUENCY_384KHZ) != 0; }
   tVoid vSetFREQUENCY_384kHz(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FREQUENCY_384KHZ):(u8Value & ~(tU8)FI_C_U8_BIT_FREQUENCY_384KHZ)); }
   tBool bFREQUENCY_432kHz() const {return (u8Value & FI_C_U8_BIT_FREQUENCY_432KHZ) != 0; }
   tVoid vSetFREQUENCY_432kHz(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FREQUENCY_432KHZ):(u8Value & ~(tU8)FI_C_U8_BIT_FREQUENCY_432KHZ)); }
   struct rBitValues {
      tBool FREQUENCY_384kHz:1;
      tBool FREQUENCY_432kHz:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_SwitchingFrequency();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_SwitchingFrequency& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Band : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Band();
   enum tenType {
      FI_EN_TUN_MSTR_BAND_FM = 0UL,
      FI_EN_TUN_MSTR_BAND_DAB = 1UL,
      FI_EN_TUN_MSTR_BAND_MW = 2UL,
      FI_EN_TUN_MSTR_BAND_LW = 3UL,
      FI_EN_TUN_MSTR_BAND_SXM = 4UL,
      FI_EN_TUN_MSTR_BAND_TRF = 17UL,
      FI_EN_TUN_MSTR_BAND_WB = 18UL,
      FI_EN_TUN_MSTR_BAND_CB1 = 20UL,
      FI_EN_TUN_MSTR_BAND_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Band(midw_fi_tcl_e8_Band::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Band();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Band& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Preset_Option : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Preset_Option();
   enum tenType {
      FI_EN_TUN_MSTR_PRESET_OPTION_KEEP_OTHERS = 0UL,
      FI_EN_TUN_MSTR_PRESET_OPTION_DELETE_OTHERS = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Preset_Option(midw_fi_tcl_e8_Preset_Option::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Preset_Option();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Preset_Option& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Source : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Source();
   enum tenType {
      FI_EN_TUN_MSTR_SOURCE_FM1 = 0UL,
      FI_EN_TUN_MSTR_SOURCE_FM2 = 1UL,
      FI_EN_TUN_MSTR_SOURCE_AM = 2UL,
      FI_EN_TUN_MSTR_SOURCE_DAB = 3UL,
      FI_EN_TUN_MSTR_SOURCE_FM_TA = 4UL,
      FI_EN_TUN_MSTR_SOURCE_DAB_TA = 5UL,
      FI_EN_TUN_MSTR_SOURCE_DAB_FM_SF = 6UL,
      FI_EN_TUN_MSTR_SOURCE_NON_RADIO = 7UL,
      FI_EN_TUN_MSTR_SOURCE_PTY31_FM = 8UL,
      FI_EN_TUN_MSTR_SOURCE_PTY31_DAB = 9UL,
      FI_EN_TUN_MSTR_SOURCE_DAB_OTHER_ANNO = 10UL,
      FI_EN_TUN_MSTR_SOURCE_NO_ANNO = 11UL,
      FI_EN_TUN_MSTR_SOURCE_DRM = 12UL,
      FI_EN_TUN_MSTR_SOURCE_SXM = 13UL,
      FI_EN_TUN_MSTR_SOURCE_WEATHER_ALERT = 14UL,
      FI_EN_TUN_MSTR_SOURCE_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Source(midw_fi_tcl_e8_Source::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Source();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Source& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Action : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Action();
   enum tenType {
      FI_EN_TUN_MSTR_PLAY = 0UL,
      FI_EN_TUN_MSTR_PAUSE = 1UL,
      FI_EN_TUN_MSTR_STOP = 2UL,
      FI_EN_TUN_MSTR_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Action(midw_fi_tcl_e8_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_WhichTuner : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_WhichTuner();
   enum tenType {
      FI_EN_TUN_MSTR_TUNER_0 = 0UL,
      FI_EN_TUN_MSTR_TUNER_1 = 1UL,
      FI_EN_TUN_MSTR_TUNER_2 = 2UL,
      FI_EN_TUN_MSTR_TUNER_3 = 3UL,
      FI_EN_TUN_MSTR_AUTO_MODE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_WhichTuner(midw_fi_tcl_e8_WhichTuner::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_WhichTuner();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_WhichTuner& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_StopAnnouncements : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_StopAnnouncements();
   enum tenType {
      FI_EN_TUN_MSTR_STOP_CURRENT = 0UL,
      FI_EN_TUN_MSTR_STOP_ALL = 1UL
   };
   tenType enType;

   midw_fi_tcl_StopAnnouncements(midw_fi_tcl_StopAnnouncements::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_StopAnnouncements();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_StopAnnouncements& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunMstr_ResponseStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunMstr_ResponseStatus();
   enum tenType {
      FI_EN_TUN_MSTR_RES_REQ_SUCCEED = 0UL,
      FI_EN_TUN_MSTR_RES_REQ_FAIL = 1UL,
      FI_EN_TUN_MSTR_RES_PREV_REQ_INPROCESS = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunMstr_ResponseStatus(midw_fi_tcl_e8_TunMstr_ResponseStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunMstr_ResponseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunMstr_ResponseStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerMaster_StatusResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerMaster_StatusResponse();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerMaster_StatusResponse& operator=(const midw_fi_tcl_TunerMaster_StatusResponse& coRef);
   midw_fi_tcl_TunerMaster_StatusResponse(const midw_fi_tcl_TunerMaster_StatusResponse& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunMstr_ResponseStatus u8TunermasterStatus;
   virtual ~midw_fi_tcl_TunerMaster_StatusResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerMaster_StatusResponse& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response();
   enum tenType {
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED = 0UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_SXM = 1UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB = 2UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response(midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode();
   enum tenType {
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED = 0UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY = 1UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_PRESETNOTCONFIGURED  = 2UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDSID_ENSEMBLEID = 3UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_UNKNOWN  = 4UL,
      FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE  = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode(midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunMstr_RadioSetting_StatusResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunMstr_RadioSetting_StatusResponse();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& operator=(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& coRef);
   midw_fi_tcl_TunMstr_RadioSetting_StatusResponse(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response RadioProfileSetting_Response;
   midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode RadioProfileSetting_ErrorCode;
   virtual ~midw_fi_tcl_TunMstr_RadioSetting_StatusResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_List : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_List();
   enum tenType {
      FI_EN_BANK_FM1 = 0UL,
      FI_EN_BANK_FM2 = 1UL,
      FI_EN_BANK_FM3 = 2UL,
      FI_EN_BANK_FMAST = 3UL,
      FI_EN_BANK_AM_MW1 = 4UL,
      FI_EN_BANK_AM_MW2 = 5UL,
      FI_EN_BANK_AM_MW3 = 6UL,
      FI_EN_BANK_AM_MWAST = 7UL,
      FI_EN_BANK_AM_LW1 = 8UL,
      FI_EN_BANK_AM_LW2 = 9UL,
      FI_EN_BANK_AM_LW3 = 10UL,
      FI_EN_BANK_AM_LWAST = 11UL,
      FI_EN_BANK_AM_AST = 12UL,
      FI_EN_BANK_DAB1 = 13UL,
      FI_EN_BANK_DAB2 = 14UL,
      FI_EN_BANK_DAB3 = 15UL,
      FI_EN_BANK_DABAST = 16UL,
      FI_EN_BANK_MIX1 = 17UL,
      FI_EN_BANK_MIX2 = 18UL,
      FI_EN_BANK_MIX3 = 19UL,
      FI_EN_BANK_MIX_AST = 20UL,
      FI_EN_BANK_DRM1 = 21UL,
      FI_EN_BANK_DRM_AST = 22UL,
      FI_EN_BANK_NONE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_List(midw_fi_tcl_e8_List::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_List();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_List& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RFAntenna : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RFAntenna();
   enum tenType {
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN = 0UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OK = 1UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OPEN = 2UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_SHORT = 3UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED = 4UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_LOW_VG = 5UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_HIGH_VG = 6UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_OPEN_AMPLIFIER = 7UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_PASSIVE = 8UL,
      FI_EN_TUN_MSTR_RF_ANTENNA_STATE_NUMBER_OF_ITEM = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_RFAntenna(midw_fi_tcl_e8_RFAntenna::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RFAntenna();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RFAntenna& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AntennaTest : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AntennaTest();
   enum tenType {
      FI_EN_AMFM_ANTENNA1 = 0UL,
      FI_EN_AMFM_ANTENNA2 = 1UL,
      FI_EN_DAB_ANTENNA1 = 2UL,
      FI_EN_GPS_ANTENNA = 3UL,
      FI_EN_DTV_ANTENNA1 = 4UL,
      FI_EN_DTV_ANTENNA2 = 5UL,
      FI_EN_DTV_ANTENNA3 = 6UL,
      FI_EN_DTV_ANTENNA4 = 7UL,
      FI_EN_DAB_ANTENNA2 = 8UL,
      FI_EN_UNKNOWN_ANTENNA = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_AntennaTest(midw_fi_tcl_e8_AntennaTest::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AntennaTest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AntennaTest& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tclunmstr_RFAntenna : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tclunmstr_RFAntenna();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tclunmstr_RFAntenna& operator=(const midw_fi_tclunmstr_RFAntenna& coRef);
   midw_fi_tclunmstr_RFAntenna(const midw_fi_tclunmstr_RFAntenna& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AntennaTest AntennaTest;
   midw_fi_tcl_e8_RFAntenna RFAntennaStatus;
   tU8 ConnectionCurrent;
   virtual ~midw_fi_tclunmstr_RFAntenna();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tclunmstr_RFAntenna& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RequestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RequestResult();
   enum tenType {
      FI_EN_TUN_MSTR_REQUEST_REJECTED = 0UL,
      FI_EN_TUN_MSTR_REQUEST_ACCEPTED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_RequestResult(midw_fi_tcl_e8_RequestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RequestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RequestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AST_Types : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AST_Types();
   enum tenType {
      FI_EN_NORMAL_AST = 0UL,
      FI_EN_INITIAL_AST = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_AST_Types(midw_fi_tcl_e8_AST_Types::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AST_Types();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AST_Types& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Graphics : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Graphics();
   enum tenType {
      FI_EN_GRAPHICS_NEEDS_NOREFRESH = 0UL,
      FI_EN_GRAPHICS_NEEDS_REFRESH = 1UL,
      FI_EN_GRAPHICS_NEEDS_DEFAULT = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Graphics(midw_fi_tcl_e8_Graphics::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Graphics();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Graphics& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SXMChannelAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SXMChannelAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SXMChannelAttributes& operator=(const midw_fi_tcl_SXMChannelAttributes& coRef);
   midw_fi_tcl_SXMChannelAttributes(const midw_fi_tcl_SXMChannelAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > Logo;
   midw_fi_tclString Name;
   midw_fi_tclString PDT;
   tBool IsLocked;
   midw_fi_tclString ContextualBanner;
   tU32 ChannelNumber;
   virtual ~midw_fi_tcl_SXMChannelAttributes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SXMChannelAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_HDAudioProgram : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_HDAudioProgram();
   enum tenType {
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_ONE = 0UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_TWO = 1UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_THREE = 2UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_FOUR = 3UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_FIVE = 4UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_SIX = 5UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_SEVEN = 6UL,
      FI_EN_TUN_MSTR_AUDIO_PROGRAM_EIGHT = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_HDAudioProgram(midw_fi_tcl_e8_HDAudioProgram::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_HDAudioProgram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_HDAudioProgram& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PresetType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PresetType();
   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_LIVECHANNEL = 1UL,
      FI_EN_SHOW = 2UL,
      FI_EN_SPORTSTEAM = 3UL,
      FI_EN_EPISODE = 4UL,
      FI_EN_ARTISTRADIOCHANNEL = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_PresetType(midw_fi_tcl_e8_PresetType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PresetType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PresetType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SXMChannelImagedata : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SXMChannelImagedata();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SXMChannelImagedata& operator=(const midw_fi_tcl_SXMChannelImagedata& coRef);
   midw_fi_tcl_SXMChannelImagedata(const midw_fi_tcl_SXMChannelImagedata& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SID;
   std::vector<tU8, std::allocator<tU8> > ImageData;
   tU32 ImageDataSize;
   virtual ~midw_fi_tcl_SXMChannelImagedata();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SXMChannelImagedata& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PSFreeze_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PSFreeze_Mode();
   enum tenType {
      FI_EN_FREEZE = 0UL,
      FI_EN_UNFREEZE = 1UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_PSFreeze_Mode(midw_fi_tcl_e8_PSFreeze_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PSFreeze_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PSFreeze_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Preset_Action : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Preset_Action();
   enum tenType {
      FI_EN_TUNMSTR_PRESETRECALL = 0UL,
      FI_EN_TUNMSTR_PRESETSAVE = 1UL,
      FI_EN_TUNMSTR_PRESETDELETE_ONE = 2UL,
      FI_EN_TUNMSTR_PRESETDELETE_ALL = 3UL,
      FI_EN_TUNMSTR_SPECIALPRESETSAVE = 4UL,
      FI_EN_TUNMSTR_GETPRESET = 5UL,
      FI_EN_TUNMSTR_GETPRESETLIST = 6UL,
      FI_EN_TUNMSTR_PRESETPROFILEUPDATE = 7UL,
      FI_EN_TUNMSTR_PRESETUP = 8UL,
      FI_EN_TUNMSTR_PRESETDOWN = 9UL,
      FI_EN_TUNMSTR_PRESETDELETE_MULTIPLE = 10UL,
      FI_EN_TUNMSTR_PRESETACTION_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_Preset_Action(midw_fi_tcl_e8_Preset_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Preset_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Preset_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_StationSelection_Option : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_StationSelection_Option();
   enum tenType {
      FI_EN_FREQUENCY_INPUT = 0UL,
      FI_EN_PRESET_INPUT = 1UL,
      FI_EN_STATIONNAME_INPUT = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_StationSelection_Option(midw_fi_tcl_e8_StationSelection_Option::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_StationSelection_Option();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_StationSelection_Option& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AnnoTypes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AnnoTypes();
   enum tenType {
      FI_EN_TUNMSTR_ANNOTYPE_PTY31 = 0UL,
      FI_EN_TUNMSTR_ANNOTYPE_TA = 1UL,
      FI_EN_TUNMSTR_ANNOTYPE_OTHER = 2UL,
      FI_EN_TUNMSTR_ANNOTYPE_TRANSPORT = 3UL,
      FI_EN_TUNMSTR_ANNOTYPE_WARNING = 4UL,
      FI_EN_TUNMSTR_ANNOTYPE_NEWS = 5UL,
      FI_EN_TUNMSTR_ANNOTYPE_WEATHER = 6UL,
      FI_EN_TUNMSTR_ANNOTYPE_EVENT = 7UL,
      FI_EN_TUNMSTR_ANNOTYPE_SPECIALEVENT = 8UL,
      FI_EN_TUNMSTR_ANNOTYPE_PROGRAMME = 9UL,
      FI_EN_TUNMSTR_ANNOTYPE_SPORT = 10UL,
      FI_EN_TUNMSTR_ANNOTYPE_FINANCE = 11UL,
      FI_EN_TUNMSTR_ANNOTYPE_WEATHER_ALERT = 12UL,
      FI_EN_TUNMSTR_ANNOTYPE_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_AnnoTypes(midw_fi_tcl_e8_AnnoTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AnnoTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AnnoTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_AnnoType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_AnnoType();

   enum {
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PTY = 0x1UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TA = 0x2UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TRANSPORT = 0x4UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WARNING = 0x8UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_NEWS = 0x10UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHER = 0x20UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_EVENT = 0x40UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPECIALEVENT = 0x80UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PROGRAMME = 0x100UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPORTS = 0x200UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_FINANCE = 0x400UL,
      FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHERALERT = 0x800UL
   };
   tBool bTUNMSTR_ANNOTYPE_PTY() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PTY) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_PTY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PTY):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PTY)); }
   tBool bTUNMSTR_ANNOTYPE_TA() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TA) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_TA(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TA):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TA)); }
   tBool bTUNMSTR_ANNOTYPE_TRANSPORT() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TRANSPORT) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_TRANSPORT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TRANSPORT):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_TRANSPORT)); }
   tBool bTUNMSTR_ANNOTYPE_WARNING() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WARNING) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_WARNING(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WARNING):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WARNING)); }
   tBool bTUNMSTR_ANNOTYPE_NEWS() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_NEWS) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_NEWS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_NEWS):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_NEWS)); }
   tBool bTUNMSTR_ANNOTYPE_WEATHER() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHER) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_WEATHER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHER):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHER)); }
   tBool bTUNMSTR_ANNOTYPE_EVENT() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_EVENT) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_EVENT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_EVENT):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_EVENT)); }
   tBool bTUNMSTR_ANNOTYPE_SPECIALEVENT() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPECIALEVENT) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_SPECIALEVENT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPECIALEVENT):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPECIALEVENT)); }
   tBool bTUNMSTR_ANNOTYPE_PROGRAMME() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PROGRAMME) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_PROGRAMME(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PROGRAMME):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_PROGRAMME)); }
   tBool bTUNMSTR_ANNOTYPE_SPORTS() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPORTS) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_SPORTS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPORTS):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_SPORTS)); }
   tBool bTUNMSTR_ANNOTYPE_FINANCE() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_FINANCE) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_FINANCE(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_FINANCE):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_FINANCE)); }
   tBool bTUNMSTR_ANNOTYPE_WEATHERALERT() const {return (u32Value & FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHERALERT) != 0; }
   tVoid vSetTUNMSTR_ANNOTYPE_WEATHERALERT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHERALERT):(u32Value & ~(tU32)FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHERALERT)); }
   struct rBitValues {
      tBool TUNMSTR_ANNOTYPE_PTY:1;
      tBool TUNMSTR_ANNOTYPE_TA:1;
      tBool TUNMSTR_ANNOTYPE_TRANSPORT:1;
      tBool TUNMSTR_ANNOTYPE_WARNING:1;
      tBool TUNMSTR_ANNOTYPE_NEWS:1;
      tBool TUNMSTR_ANNOTYPE_WEATHER:1;
      tBool TUNMSTR_ANNOTYPE_EVENT:1;
      tBool TUNMSTR_ANNOTYPE_SPECIALEVENT:1;
      tBool TUNMSTR_ANNOTYPE_PROGRAMME:1;
      tBool TUNMSTR_ANNOTYPE_SPORTS:1;
      tBool TUNMSTR_ANNOTYPE_FINANCE:1;
      tBool TUNMSTR_ANNOTYPE_WEATHERALERT:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_AnnoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_AnnoType& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_SourceAnno : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_SourceAnno();

   enum {
      FI_C_U8_BIT_TUNMSTR_ANNOSRC_FM = 0x1UL,
      FI_C_U8_BIT_TUNMSTR_ANNOSRC_DAB = 0x2UL,
      FI_C_U8_BIT_TUNMSTR_ANNOSRC_WEATHER = 0x4UL
   };
   tBool bTUNMSTR_ANNOSRC_FM() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_ANNOSRC_FM) != 0; }
   tVoid vSetTUNMSTR_ANNOSRC_FM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_ANNOSRC_FM):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_ANNOSRC_FM)); }
   tBool bTUNMSTR_ANNOSRC_DAB() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_ANNOSRC_DAB) != 0; }
   tVoid vSetTUNMSTR_ANNOSRC_DAB(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_ANNOSRC_DAB):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_ANNOSRC_DAB)); }
   tBool bTUNMSTR_ANNOSRC_WEATHER() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_ANNOSRC_WEATHER) != 0; }
   tVoid vSetTUNMSTR_ANNOSRC_WEATHER(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_ANNOSRC_WEATHER):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_ANNOSRC_WEATHER)); }
   struct rBitValues {
      tBool TUNMSTR_ANNOSRC_FM:1;
      tBool TUNMSTR_ANNOSRC_DAB:1;
      tBool TUNMSTR_ANNOSRC_WEATHER:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_SourceAnno();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_SourceAnno& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunerAvailability : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunerAvailability();
   enum tenType {
      FI_EN_TUNMSTR_FM_TUNER_NOW_AVAILABLE = 0UL,
      FI_EN_TUNMSTR_DAB_TUNER_NOW_AVAILABLE = 1UL,
      FI_EN_TUNMSTR_BOTH_TUNER_NOT_AVAILABLE = 2UL,
      FI_EN_TUNMSTR_BOTH_TUNER_NOW_AVAILABLE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunerAvailability(midw_fi_tcl_e8_TunerAvailability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunerAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunerAvailability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_ModeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_ModeType();

   enum {
      FI_C_U8_BIT_TUNMSTR_SF_FM = 0x1UL,
      FI_C_U8_BIT_TUNMSTR_SF_DAB = 0x2UL,
      FI_C_U8_BIT_TUNMSTR_SF_NONE = 0x80UL
   };
   tBool bTUNMSTR_SF_FM() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_SF_FM) != 0; }
   tVoid vSetTUNMSTR_SF_FM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_SF_FM):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_SF_FM)); }
   tBool bTUNMSTR_SF_DAB() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_SF_DAB) != 0; }
   tVoid vSetTUNMSTR_SF_DAB(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_SF_DAB):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_SF_DAB)); }
   tBool bTUNMSTR_SF_NONE() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_SF_NONE) != 0; }
   tVoid vSetTUNMSTR_SF_NONE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_SF_NONE):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_SF_NONE)); }
   struct rBitValues {
      tBool TUNMSTR_SF_FM:1;
      tBool TUNMSTR_SF_DAB:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool TUNMSTR_SF_NONE:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_ModeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_ModeType& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_StationType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_StationType();
   enum tenType {
      FI_EN_TUNMSTR_STATIONTYPE_DAB = 0UL,
      FI_EN_TUNMSTR_STATIONTYPE_FM = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_StationType(midw_fi_tcl_e8_StationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_StationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_StationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ModulationType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ModulationType();
   enum tenType {
      FI_EN_TUN_MSTR_MODULATION_ANALOG = 0UL,
      FI_EN_TUN_MSTR_MODULATION_HD = 1UL,
      FI_EN_TUN_MSTR_MODULATION_DRM = 2UL,
      FI_EN_TUN_MSTR_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_ModulationType(midw_fi_tcl_e8_ModulationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ModulationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ModulationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_HDTextEncoding : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_HDTextEncoding();
   enum tenType {
      FI_EN_TUN_MSTR_ISO_IEC_8859_1_1998 = 0UL,
      FI_EN_TUN_MSTR_ISO_IEC_10646_1_2000_UCS_2 = 4UL,
      FI_EN_TUN_MSTR_RESERVED = 1UL,
      FI_EN_TUN_MSTR_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_HDTextEncoding(midw_fi_tcl_e8_HDTextEncoding::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_HDTextEncoding();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_HDTextEncoding& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SXMPresetListEntry : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SXMPresetListEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SXMPresetListEntry& operator=(const midw_fi_tcl_SXMPresetListEntry& coRef);
   midw_fi_tcl_SXMPresetListEntry(const midw_fi_tcl_SXMPresetListEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServiceID;
   tU16 ChannelID;
   tBool ChannelNameAvail;
   midw_fi_tclString ChannelName;
   tBool ChannelActive;
   midw_fi_tcl_e8_Graphics ChnGraphicAvail;
   tBool IsSmartFavorite;
   tBool IsLocked;
   tBool IsAvailable;
   tBool IsMature;
   tBool IsSkipped;
   virtual ~midw_fi_tcl_SXMPresetListEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SXMPresetListEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunMst_RadioType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunMst_RadioType();
   enum tenType {
      FI_EN_RADIOTYPE_NONE = 0UL,
      FI_EN_RADIOTYPE_DAB = 1UL,
      FI_EN_RADIOTYPE_FM = 2UL,
      FI_EN_RADIOTYPE_AM = 3UL,
      FI_EN_RADIOTYPE_SXM = 4UL,
      FI_EN_RADIOTYPE_AMHD = 5UL,
      FI_EN_RADIOTYPE_FMHD = 6UL,
      FI_EN_RADIOTYPE_DRM = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunMst_RadioType(midw_fi_tcl_e8_TunMst_RadioType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunMst_RadioType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunMst_RadioType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DAB_Label : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DAB_Label();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DAB_Label& operator=(const midw_fi_tcl_DAB_Label& coRef);
   midw_fi_tcl_DAB_Label(const midw_fi_tcl_DAB_Label& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sLabel;
   midw_fi_tclString sLabelShort;
   tU16 u16LabelMask;
   virtual ~midw_fi_tcl_DAB_Label();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DAB_Label& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_RadioProfileSettingAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_RadioProfileSettingAction();

   enum {
      FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_PRESETS = 0x1UL,
      FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_AMSWITCH = 0x2UL
   };
   tBool bTUNMSTR_PROFILE_ACTION_PRESETS() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_PRESETS) != 0; }
   tVoid vSetTUNMSTR_PROFILE_ACTION_PRESETS(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_PRESETS):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_PRESETS)); }
   tBool bTUNMSTR_PROFILE_ACTION_AMSWITCH() const {return (u8Value & FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_AMSWITCH) != 0; }
   tVoid vSetTUNMSTR_PROFILE_ACTION_AMSWITCH(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_AMSWITCH):(u8Value & ~(tU8)FI_C_U8_BIT_TUNMSTR_PROFILE_ACTION_AMSWITCH)); }
   struct rBitValues {
      tBool TUNMSTR_PROFILE_ACTION_PRESETS:1;
      tBool TUNMSTR_PROFILE_ACTION_AMSWITCH:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_RadioProfileSettingAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_RadioProfileSettingAction& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunMst_PresetListElement : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunMst_PresetListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunMst_PresetListElement& operator=(const midw_fi_tcl_TunMst_PresetListElement& coRef);
   midw_fi_tcl_TunMst_PresetListElement(const midw_fi_tcl_TunMst_PresetListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunMst_RadioType e8RadioType;
   tU8 u8PresetNumber;
   tU32 u32Frequency;
   tU32 u32SID;
   midw_fi_tclString sStationName;
   tU32 u32TextEncoding;
   tU8 u8ProgramNumber;
   tU32 u32EnsembleId;
   midw_fi_tclString ComponentLabel;
   tU32 u32ComponentLabelEncoding;
   virtual ~midw_fi_tcl_TunMst_PresetListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunMst_PresetListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunerErrorType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunerErrorType();
   enum tenType {
      FI_EN_MESSAGENOTSUPPORTED = 0UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunerErrorType(midw_fi_tcl_e8_TunerErrorType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunerErrorType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunerErrorType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8SXMChannelArtErrorTypes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8SXMChannelArtErrorTypes();
   enum tenType {
      FI_EN_CHANNELART_SERVICE_ERROR = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8SXMChannelArtErrorTypes(midw_fi_tcl_e8SXMChannelArtErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8SXMChannelArtErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8SXMChannelArtErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_PresetList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_PresetList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_PresetList& operator=(const midw_fi_tcl_PresetList& coRef);
   midw_fi_tcl_PresetList(const midw_fi_tcl_PresetList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_List List;
   midw_fi_tcl_e8_Band Band;
   tU8 Element_ID;
   tU32 Frequency;
   midw_fi_tclString PSName;
   tU8 u8TpTmcInfo;
   tU32 PTY;
   midw_fi_tclString EnsembleName;
   midw_fi_tclString Frequency_Label;
   midw_fi_tclString StationLogo;
   tU32 u32HDStationId;
   midw_fi_tclString sHDCallSign;
   midw_fi_tcl_e8_HDAudioProgram e8HDAudioProgram;
   tU32 u32DRMServiceId;
   midw_fi_tclString sDRMServiceLabel;
   tU8 u8DRMServiceShortId;
   midw_fi_tcl_e8_ModulationType e8Modulation;
   tU32 u32HDStationId_DRMServiceId;
   midw_fi_tcl_e8_HDTextEncoding e8HDTextEncoding;
   midw_fi_tclString sHDCallSign_DRMServiceLabel;
   tU8 u8HDStationGenre_DRMPty;
   tU8 u8HDAudioProgram_DRMShortID;
   midw_fi_tcl_SXMPresetListEntry SXMSMSlib_PresetListEntry;
   midw_fi_tclString Key;
   midw_fi_tcl_e8_PresetType PresetType;
   midw_fi_tcl_SXMChannelAttributes SXM360L_PresetListEntry;
   virtual ~midw_fi_tcl_PresetList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_PresetList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SXMPresetEntry : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SXMPresetEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SXMPresetEntry& operator=(const midw_fi_tcl_SXMPresetEntry& coRef);
   midw_fi_tcl_SXMPresetEntry(const midw_fi_tcl_SXMPresetEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetIndex;
   tU32 PresetElemID;
   midw_fi_tclString Key;
   midw_fi_tcl_e8_PresetType PresetType;
   midw_fi_tcl_SXMChannelAttributes ChannelAttributes;
   virtual ~midw_fi_tcl_SXMPresetEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SXMPresetEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SXMSystemMessage : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SXMSystemMessage();
   enum tenType {
      FI_EN_XMTUN_SYSTEM_MSG_NO_ERROR = 0UL,
      FI_EN_XMTUN_SYSTEM_MSG_LOADING_XM = 1UL,
      FI_EN_XMTUN_SYSTEM_MSG_CATEGORY_NOT_FOUND = 2UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_OFFAIR = 3UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_UNAVAILABLE = 4UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_UNAUTHORIZED = 5UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_MATURE = 6UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_LOCKED = 7UL,
      FI_EN_XMTUN_SYSTEM_MSG_SUBSCRIPTION_UPDATED = 8UL,
      FI_EN_XMTUN_SYSTEM_MSG_ANTENNA_DISCONNECTED = 9UL,
      FI_EN_XMTUN_SYSTEM_MSG_NO_SIGNAL = 10UL,
      FI_EN_XMTUN_SYSTEM_MSG_HARDWARE_ERROR = 11UL,
      FI_EN_XMTUN_SYSTEM_MSG_SXM_INITIALIZING = 12UL
   };
   tenType enType;

   midw_fi_tcl_e8_SXMSystemMessage(midw_fi_tcl_e8_SXMSystemMessage::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SXMSystemMessage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SXMSystemMessage& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProfileStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProfileStatus();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_PREPARE = 1UL,
      FI_EN_CHANGED = 2UL,
      FI_EN_RESET = 3UL,
      FI_EN_DOWNLOAD = 4UL
   };
   tenType enType;

   midw_fi_tcl_ProfileStatus(midw_fi_tcl_ProfileStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_ProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_ProfileStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProfileAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProfileAction();
   enum tenType {
      FI_EN_ACTIVEPROFILE = 0UL,
      FI_EN_DATACHANGE = 1UL,
      FI_EN_COPYPROFILE = 2UL,
      FI_EN_DELETEPROFILE = 3UL
   };
   tenType enType;

   midw_fi_tcl_ProfileAction(midw_fi_tcl_ProfileAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_ProfileAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_ProfileAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProfileActionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProfileActionStatus();
   enum tenType {
      FI_EN_FAILED = 0UL,
      FI_EN_SUCCESS = 1UL
   };
   tenType enType;

   midw_fi_tcl_ProfileActionStatus(midw_fi_tcl_ProfileActionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_ProfileActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_ProfileActionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProfileResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProfileResponse();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ProfileResponse& operator=(const midw_fi_tcl_ProfileResponse& coRef);
   midw_fi_tcl_ProfileResponse(const midw_fi_tcl_ProfileResponse& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ProfileActionStatus Status;
   midw_fi_tcl_ProfileAction ProfileAction;
   midw_fi_tcl_ProfileStatus ProfileStatus;
   virtual ~midw_fi_tcl_ProfileResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ProfileResponse& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_RequestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_RequestResult();
   enum tenType {
      FI_EN_TUN_REQUEST_REJECTED = 0UL,
      FI_EN_TUN_REQUEST_ACCEPTED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_RequestResult(midw_fi_tcl_e8_Tun_RequestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_RequestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_RequestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AlignCalibrate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AlignCalibrate();
   enum tenType {
      FI_EN_TUN_INVALID_STEP = 0UL,
      FI_EN_TUNER_STEP_ONE_ALIGNMENT = 1UL,
      FI_EN_TUNER_STEP_TWO_ALIGNMENT = 2UL,
      FI_EN_TUNER_ONE_FM_CALIBRATION = 3UL,
      FI_EN_TUNER_TWO_FM_CALIBRATION = 4UL,
      FI_EN_TUNER_ONE_AM_CALIBRATION = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AlignCalibrate(midw_fi_tcl_e8_Tun_AlignCalibrate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AlignCalibrate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AlignCalibrate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_AlignCalibrateStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_AlignCalibrateStatus();
   enum tenType {
      FI_EN_TUN_ALIGN_CALIBRATE_NOT_SUCCESS = 0UL,
      FI_EN_TUN_ALIGN_CALIBRATE_SUCCESS = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_AlignCalibrateStatus(midw_fi_tcl_e8_Tun_AlignCalibrateStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_AlignCalibrateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_AlignCalibrateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_IFOutput : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_IFOutput();
   enum tenType {
      FI_EN_TUN_IF_OUTPUT_OK = 0UL,
      FI_EN_TUN_IF_OUTPUT_ERR_SHORT = 1UL,
      FI_EN_TUN_IF_OUTPUT_ERR_DISCON_IMP = 2UL,
      FI_EN_TUN_IF_OUTPUT_UNKNOWN = 3UL,
      FI_EN_TUN_IF_OUTPUT_ERR_DISCON_ANT = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_IFOutput(midw_fi_tcl_e8_Tun_IFOutput::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_IFOutput();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_IFOutput& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_IFOutput : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_IFOutput();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_IFOutput& operator=(const midw_fi_tcl_Tun_IFOutput& coRef);
   midw_fi_tcl_Tun_IFOutput(const midw_fi_tcl_Tun_IFOutput& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_IFOutput u8IFResult;
   virtual ~midw_fi_tcl_Tun_IFOutput();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_IFOutput& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_RFAntenna : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_RFAntenna();
   enum tenType {
      FI_EN_TUN_RF_ANTENNA_OK = 0UL,
      FI_EN_TUN_RF_ANTENNA_ERR_SHORT = 1UL,
      FI_EN_TUN_RF_ANTENNA_ERR_DISCON_IMP = 2UL,
      FI_EN_TUN_RF_ANTENNA_UNKNOWN = 3UL,
      FI_EN_TUN_RF_ANTENNA_ERR_DISCON_ANT = 4UL,
      FI_EN_TUN_RF_ANTENNA_ERR_OVER_CURRENT = 5UL,
      FI_EN_TUN_RF_ANTENNA_UNKNOWN_PASSIVE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_RFAntenna(midw_fi_tcl_e8_Tun_RFAntenna::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_RFAntenna();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_RFAntenna& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ATMResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ATMResult();
   enum tenType {
      FI_EN_TUN_ATM_OK = 1UL,
      FI_EN_TUN_ATM_NOT_OK = 0UL
   };
   tenType enType;

   midw_fi_tcl_e8_ATMResult(midw_fi_tcl_e8_ATMResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ATMResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ATMResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8Result : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8Result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_u8Result& operator=(const midw_fi_tcl_u8Result& coRef);
   midw_fi_tcl_u8Result(const midw_fi_tcl_u8Result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DataLength;
   std::vector<tU8, std::allocator<tU8> > GenericBytes;
   virtual ~midw_fi_tcl_u8Result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_u8Result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ANTENNA_TEST : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ANTENNA_TEST();
   enum tenType {
      FI_EN_PHANTOM_ANTENNA = 0UL,
      FI_EN_PHANTOM_ANTENNA2 = 2UL,
      FI_EN_PHANTOM_DAB_ANTENNA = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_ANTENNA_TEST(midw_fi_tcl_e8_ANTENNA_TEST::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ANTENNA_TEST();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ANTENNA_TEST& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_RFAntenna : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_RFAntenna();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_RFAntenna& operator=(const midw_fi_tcl_Tun_RFAntenna& coRef);
   midw_fi_tcl_Tun_RFAntenna(const midw_fi_tcl_Tun_RFAntenna& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ANTENNA_TEST ANTENNA_TEST;
   midw_fi_tcl_e8_Tun_RFAntenna RFAntennaStatus;
   tU8 ConnectionCurrent;
   virtual ~midw_fi_tcl_Tun_RFAntenna();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_RFAntenna& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TMCInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TMCInfo();
   enum tenType {
      FI_EN_TUN_NOT_USED1 = 0UL,
      FI_EN_TUN_TMC_UNDECODED = 1UL,
      FI_EN_TUN_TMC_NO = 2UL,
      FI_EN_TUN_TMC_YES = 3UL,
      FI_EN_TUN_TMC_QUALITY_LOST = 4UL,
      FI_EN_TUN_TMC_8A_LOST = 5UL,
      FI_EN_TUN_NOT_USED2 = 6UL,
      FI_EN_TUN_TMC_STATE = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TMCInfo(midw_fi_tcl_e8_Tun_TMCInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TMCInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TMCInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TPInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TPInfo();
   enum tenType {
      FI_EN_TUN_TP_UNDECODED = 0UL,
      FI_EN_TUN_TP_OFF = 1UL,
      FI_EN_TUN_TP_ON = 2UL,
      FI_EN_TUN_TP_LOST = 3UL,
      FI_EN_TUN_TP_UNUSED1 = 4UL,
      FI_EN_TUN_TP_UNUSED2 = 5UL,
      FI_EN_TUN_TP_OFF_TEMP = 6UL,
      FI_EN_TUN_TP_STATE = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TPInfo(midw_fi_tcl_e8_Tun_TPInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TPInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TPInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_TA : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_TA();
   enum tenType {
      FI_EN_TUN_TA_INACTIVE = 0UL,
      FI_EN_TUN_TA_ACTIVE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_TA(midw_fi_tcl_e8_Tun_TA::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_TA();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_TA& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_PI : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_PI();
   enum tenType {
      FI_EN_TUN_PI_NOTAVAILABLE = 0UL,
      FI_EN_TUN_PI_AVAILABLE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_PI(midw_fi_tcl_e8_Tun_PI::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_PI();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_PI& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_ProgramKind : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_ProgramKind();
   enum tenType {
      FI_EN_SPEECH = 0UL,
      FI_EN_MUSIC = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_ProgramKind(midw_fi_tcl_e8_Tun_ProgramKind::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_ProgramKind();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_ProgramKind& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_EON : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_EON();
   enum tenType {
      FI_EN_TUN_EON_NOTAVAILABLE = 0UL,
      FI_EN_TUN_EON_AVAILABLE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_EON(midw_fi_tcl_e8_Tun_EON::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_EON();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_EON& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Tun_PTY : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Tun_PTY();
   enum tenType {
      FI_EN_TUN_PTY_INVALID = 0UL,
      FI_EN_TUN_PTY_NEWS = 1UL,
      FI_EN_TUN_PTY_CURRENT_AFFAIRS = 2UL,
      FI_EN_TUN_PTY_INFORMATION = 3UL,
      FI_EN_TUN_PTY_SPORTS = 4UL,
      FI_EN_TUN_PTY_EDUCATION = 5UL,
      FI_EN_TUN_PTY_DRAMA = 6UL,
      FI_EN_TUN_PTY_CULTURE = 7UL,
      FI_EN_TUN_PTY_SCIENCE = 8UL,
      FI_EN_TUN_PTY_VARIED = 9UL,
      FI_EN_TUN_PTY_POP_MUSIC = 10UL,
      FI_EN_TUN_PTY_ROCK_MUSIC = 11UL,
      FI_EN_TUN_PTY_EASY_LEARNING_MUSIC = 12UL,
      FI_EN_TUN_PTY_LIGHT_CLASSICAL_MUSIC = 13UL,
      FI_EN_TUN_PTY_SERIOUS_CLASSICAL_MUSIC = 14UL,
      FI_EN_TUN_PTY_OTHER_MUSIC = 15UL,
      FI_EN_TUN_PTY_WEATHER = 16UL,
      FI_EN_TUN_PTY_FINANCE = 17UL,
      FI_EN_TUN_PTY_CHILDREN_PROGRAMME = 18UL,
      FI_EN_TUN_PTY_SOCIAL_AFFAIRS = 19UL,
      FI_EN_TUN_PTY_RELIGION = 20UL,
      FI_EN_TUN_PTY_PHONE_IN = 21UL,
      FI_EN_TUN_PTY_TRAVEL = 22UL,
      FI_EN_TUN_PTY_LEISURE = 23UL,
      FI_EN_TUN_PTY_JAZZ_MUSIC = 24UL,
      FI_EN_TUN_PTY_COUNTRY_MUSIC = 25UL,
      FI_EN_TUN_PTY_NATIONAL_MUSIC = 26UL,
      FI_EN_TUN_PTY_OLDIES_MUSIC = 27UL,
      FI_EN_TUN_PTY_FOLK_MUSIC = 28UL,
      FI_EN_TUN_PTY_DOCUMENTARY = 29UL,
      FI_EN_TUN_PTY_ALARM_TEST = 30UL,
      FI_EN_TUN_PTY_ALARM = 31UL
   };
   tenType enType;

   midw_fi_tcl_e8_Tun_PTY(midw_fi_tcl_e8_Tun_PTY::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Tun_PTY();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Tun_PTY& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_TunerFeatureData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_TunerFeatureData();

   enum {
      FI_C_U32_BIT_TUN_FEATURE_RDS_ADJ = 0x1UL,
      FI_C_U32_BIT_TUN_FEATURE_REG_ADJ = 0x2UL,
      FI_C_U32_BIT_TUN_FEATURE_PTY_STATION = 0x4UL,
      FI_C_U32_BIT_TUN_FEATURE_PTY_DYNAMIC = 0x8UL,
      FI_C_U32_BIT_TUN_FEATURE_EON_TA_ANNOUNCEMENT = 0x10UL,
      FI_C_U32_BIT_TUN_FEATURE_RESERVED = 0x20UL
   };
   tBool bTUN_FEATURE_RDS_ADJ() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RDS_ADJ) != 0; }
   tVoid vSetTUN_FEATURE_RDS_ADJ(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_RDS_ADJ):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_RDS_ADJ)); }
   tBool bTUN_FEATURE_REG_ADJ() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_REG_ADJ) != 0; }
   tVoid vSetTUN_FEATURE_REG_ADJ(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_REG_ADJ):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_REG_ADJ)); }
   tBool bTUN_FEATURE_PTY_STATION() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PTY_STATION) != 0; }
   tVoid vSetTUN_FEATURE_PTY_STATION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_PTY_STATION):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_PTY_STATION)); }
   tBool bTUN_FEATURE_PTY_DYNAMIC() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PTY_DYNAMIC) != 0; }
   tVoid vSetTUN_FEATURE_PTY_DYNAMIC(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_PTY_DYNAMIC):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_PTY_DYNAMIC)); }
   tBool bTUN_FEATURE_EON_TA_ANNOUNCEMENT() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_EON_TA_ANNOUNCEMENT) != 0; }
   tVoid vSetTUN_FEATURE_EON_TA_ANNOUNCEMENT(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_EON_TA_ANNOUNCEMENT):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_EON_TA_ANNOUNCEMENT)); }
   tBool bTUN_FEATURE_reserved() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RESERVED) != 0; }
   tVoid vSetTUN_FEATURE_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TUN_FEATURE_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_TUN_FEATURE_RESERVED)); }
   struct rBitValues {
      tBool TUN_FEATURE_RDS_ADJ:1;
      tBool TUN_FEATURE_REG_ADJ:1;
      tBool TUN_FEATURE_PTY_STATION:1;
      tBool TUN_FEATURE_PTY_DYNAMIC:1;
      tBool TUN_FEATURE_EON_TA_ANNOUNCEMENT:1;
      tBool TUN_FEATURE_reserved:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_TunerFeatureData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_TunerFeatureData& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_Tun_DiagMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_Tun_DiagMode();

   enum {
      FI_C_U8_BIT_TUN_FEATURE_SHARX = 0x1UL,
      FI_C_U8_BIT_TUN_FEATURE_AFBEST = 0x2UL,
      FI_C_U8_BIT_TUN_FEATURE_STEREOSPEED = 0x4UL,
      FI_C_U8_BIT_TUN_FEATURE_AM_ZF_REGULATION = 0x8UL,
      FI_C_U8_BIT_TUN_FEATURE_ACTION = 0x10UL,
      FI_C_U8_BIT_TUN_FEATURE_HICUT = 0x20UL,
      FI_C_U8_BIT_TUN_FEATURE_DDA = 0x40UL,
      FI_C_U8_BIT_TUN_FEATURE_DDS = 0x80UL
   };
   tBool bTUN_FEATURE_SHARX() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_SHARX) != 0; }
   tVoid vSetTUN_FEATURE_SHARX(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_SHARX):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_SHARX)); }
   tBool bTUN_FEATURE_AFBEST() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_AFBEST) != 0; }
   tVoid vSetTUN_FEATURE_AFBEST(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_AFBEST):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_AFBEST)); }
   tBool bTUN_FEATURE_STEREOSPEED() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_STEREOSPEED) != 0; }
   tVoid vSetTUN_FEATURE_STEREOSPEED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_STEREOSPEED):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_STEREOSPEED)); }
   tBool bTUN_FEATURE_AM_ZF_REGULATION() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_AM_ZF_REGULATION) != 0; }
   tVoid vSetTUN_FEATURE_AM_ZF_REGULATION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_AM_ZF_REGULATION):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_AM_ZF_REGULATION)); }
   tBool bTUN_FEATURE_ACTION() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_ACTION) != 0; }
   tVoid vSetTUN_FEATURE_ACTION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_ACTION):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_ACTION)); }
   tBool bTUN_FEATURE_HICUT() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_HICUT) != 0; }
   tVoid vSetTUN_FEATURE_HICUT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_HICUT):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_HICUT)); }
   tBool bTUN_FEATURE_DDA() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_DDA) != 0; }
   tVoid vSetTUN_FEATURE_DDA(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_DDA):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_DDA)); }
   tBool bTUN_FEATURE_DDS() const {return (u8Value & FI_C_U8_BIT_TUN_FEATURE_DDS) != 0; }
   tVoid vSetTUN_FEATURE_DDS(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TUN_FEATURE_DDS):(u8Value & ~(tU8)FI_C_U8_BIT_TUN_FEATURE_DDS)); }
   struct rBitValues {
      tBool TUN_FEATURE_SHARX:1;
      tBool TUN_FEATURE_AFBEST:1;
      tBool TUN_FEATURE_STEREOSPEED:1;
      tBool TUN_FEATURE_AM_ZF_REGULATION:1;
      tBool TUN_FEATURE_ACTION:1;
      tBool TUN_FEATURE_HICUT:1;
      tBool TUN_FEATURE_DDA:1;
      tBool TUN_FEATURE_DDS:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_Tun_DiagMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_Tun_DiagMode& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_AlignCalibrateParameterList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_AlignCalibrateParameterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_AlignCalibrateParameterList& operator=(const midw_fi_tcl_Tun_AlignCalibrateParameterList& coRef);
   midw_fi_tcl_Tun_AlignCalibrateParameterList(const midw_fi_tcl_Tun_AlignCalibrateParameterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > TunerAlignCalibrateParameter;
   virtual ~midw_fi_tcl_Tun_AlignCalibrateParameterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_AlignCalibrateParameterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerDiagMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerDiagMode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerDiagMode& operator=(const midw_fi_tcl_TunerDiagMode& coRef);
   midw_fi_tcl_TunerDiagMode(const midw_fi_tcl_TunerDiagMode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_DiagMode b8DiagModeFeature;
   midw_fi_tcl_b8_Tun_DiagMode b8DiagModeMask;
   virtual ~midw_fi_tcl_TunerDiagMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerDiagMode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Tun_ProgramInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Tun_ProgramInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Tun_ProgramInfo& operator=(const midw_fi_tcl_Tun_ProgramInfo& coRef);
   midw_fi_tcl_Tun_ProgramInfo(const midw_fi_tcl_Tun_ProgramInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader TunerTypeInfo;
   midw_fi_tcl_e8_Tun_TMCInfo TMCInfo;
   midw_fi_tcl_e8_Tun_TA TrafficAlarmInfo;
   midw_fi_tcl_e8_Tun_PI TunerPIInfo;
   tU32 ProgramID;
   midw_fi_tclString sTunPSName;
   midw_fi_tcl_e8_Tun_PTY TunPTY;
   midw_fi_tcl_e8_Tun_ProgramKind TunProgramKind;
   midw_fi_tcl_e8_Tun_TPInfo TunTPInfo;
   midw_fi_tcl_e8_Tun_EON TunEONInfo;
   virtual ~midw_fi_tcl_Tun_ProgramInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Tun_ProgramInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerBandFrq : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerBandFrq();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerBandFrq& operator=(const midw_fi_tcl_TunerBandFrq& coRef);
   midw_fi_tcl_TunerBandFrq(const midw_fi_tcl_TunerBandFrq& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Audio_FG_BG SourceSwitch;
   midw_fi_tcl_e8_Tun_TunerBand TunedBand;
   tU32 u32Frequency;
   virtual ~midw_fi_tcl_TunerBandFrq();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerBandFrq& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TunerAlignCalibrate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TunerAlignCalibrate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TunerAlignCalibrate& operator=(const midw_fi_tcl_TunerAlignCalibrate& coRef);
   midw_fi_tcl_TunerAlignCalibrate(const midw_fi_tcl_TunerAlignCalibrate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_AlignCalibrate TunAlignCal;
   midw_fi_tcl_e8_Tun_AlignCalibrateStatus TunAlignCalStatus;
   midw_fi_tcl_Tun_AlignCalibrateParameterList TunAlignCalParameters;
   virtual ~midw_fi_tcl_TunerAlignCalibrate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TunerAlignCalibrate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ApplicationState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ApplicationState();
   enum tenType {
      FI_EN_APP_STATE_NONE = 0UL,
      FI_EN_APP_STATE_INIT = 1UL,
      FI_EN_APP_STATE_VISIBLE = 2UL,
      FI_EN_APP_STATE_INVISIBLE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_ApplicationState(midw_fi_tcl_e8_ApplicationState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ApplicationState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ApplicationState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AppMgrMethodResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AppMgrMethodResult();
   enum tenType {
      FI_EN_RESULT_NO_ERROR = 0UL,
      FI_EN_RESULT_ERROR_INVALID_PARAMS = 1UL,
      FI_EN_RESULT_ERROR_INVALID_CONDITIONS = 2UL,
      FI_EN_RESULT_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_AppMgrMethodResult(midw_fi_tcl_e8_AppMgrMethodResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AppMgrMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AppMgrMethodResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ApplicationData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ApplicationData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ApplicationData& operator=(const midw_fi_tcl_ApplicationData& coRef);
   midw_fi_tcl_ApplicationData(const midw_fi_tcl_ApplicationData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ApplicationID;
   midw_fi_tcl_e8_ApplicationState u8State;
   virtual ~midw_fi_tcl_ApplicationData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ApplicationData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_streamrouter_routestate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_streamrouter_routestate();
   enum tenType {
      FI_EN_INIT = 0UL,
      FI_EN_STOP = 1UL,
      FI_EN_PLAY = 2UL,
      FI_EN_KILL = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_streamrouter_routestate(midw_fi_tcl_e8_streamrouter_routestate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_streamrouter_routestate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_streamrouter_routestate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_streamrouter_ramptype : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_streamrouter_ramptype();
   enum tenType {
      FI_EN_NO = 0UL,
      FI_EN_FAST = 1UL,
      FI_EN_MEDIUM = 2UL,
      FI_EN_SLOW = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_streamrouter_ramptype(midw_fi_tcl_e8_streamrouter_ramptype::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_streamrouter_ramptype();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_streamrouter_ramptype& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_streamrouter_route_entry : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_streamrouter_route_entry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_streamrouter_route_entry& operator=(const midw_fi_tcl_streamrouter_route_entry& coRef);
   midw_fi_tcl_streamrouter_route_entry(const midw_fi_tcl_streamrouter_route_entry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32UCID;
   tU16 u16AppID;
   tU16 u16MLBChannelAddress;
   tU8 u8BlkWidth;
   midw_fi_tcl_e8_streamrouter_routestate e8Routestate;
   virtual ~midw_fi_tcl_streamrouter_route_entry();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_streamrouter_route_entry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_streamrouter_routing_list : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_streamrouter_routing_list();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_streamrouter_routing_list& operator=(const midw_fi_tcl_streamrouter_routing_list& coRef);
   midw_fi_tcl_streamrouter_routing_list(const midw_fi_tcl_streamrouter_routing_list& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_streamrouter_route_entry, std::allocator<midw_fi_tcl_streamrouter_route_entry> > sREntry;
   virtual ~midw_fi_tcl_streamrouter_routing_list();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_streamrouter_routing_list& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_streamrouter_device_list : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_streamrouter_device_list();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_streamrouter_device_list& operator=(const midw_fi_tcl_streamrouter_device_list& coRef);
   midw_fi_tcl_streamrouter_device_list(const midw_fi_tcl_streamrouter_device_list& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tclString, std::allocator<midw_fi_tclString> > strALSADev;
   virtual ~midw_fi_tcl_streamrouter_device_list();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_streamrouter_device_list& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_streamrouter_fgcommand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_streamrouter_fgcommand();
   enum tenType {
      FI_EN_ECNR_MICMUTE_ON = 0UL,
      FI_EN_ECNR_MICMUTE_OFF = 1UL,
      FI_EN_ECNR_ECHOCANCELLATION_ON = 2UL,
      FI_EN_ECNR_ECHOCANCELLATION_OFF = 3UL,
      FI_EN_ECNR_GAIN_LOW = 4UL,
      FI_EN_ECNR_GAIN_MED = 5UL,
      FI_EN_ECNR_GAIN_HIG = 6UL,
      FI_EN_ECNR_MICNOISEREDUCTION_ON = 7UL,
      FI_EN_ECNR_MICNOISEREDUCTION_OFF = 8UL
   };
   tenType enType;

   midw_fi_tcl_e8_streamrouter_fgcommand(midw_fi_tcl_e8_streamrouter_fgcommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_streamrouter_fgcommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_streamrouter_fgcommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceConnectStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceConnectStatus();
   enum tenType {
      FI_EN_USB_DEV_UNDEFINED = 0UL,
      FI_EN_USB_DEV_WARNING = 1UL,
      FI_EN_USB_DEV_CONNECTED = 2UL,
      FI_EN_USB_DEV_REMOVED_BY_USR = 3UL,
      FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT = 4UL,
      FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceConnectStatus(midw_fi_tcl_e8_DeviceConnectStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceConnectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceConnectStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Device : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Device();
   enum tenType {
      FI_EN_DTY_UNKNOWN = 0UL,
      FI_EN_DTY_USB = 1UL,
      FI_EN_DTY_SDCARD = 2UL,
      FI_EN_DTY_IPOD = 3UL,
      FI_EN_DTY_IPHONE = 4UL,
      FI_EN_DTY_MTP = 5UL,
      FI_EN_DTY_MSZUNE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_Device(midw_fi_tcl_e8_Device::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Device();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Device& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DevManager_DeviceProperty : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DevManager_DeviceProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DevManager_DeviceProperty& operator=(const midw_fi_tcl_DevManager_DeviceProperty& coRef);
   midw_fi_tcl_DevManager_DeviceProperty(const midw_fi_tcl_DevManager_DeviceProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString DeviceSerialNo;
   midw_fi_tclString USBPortNo;
   midw_fi_tcl_e8_Device DeviceType;
   midw_fi_tclString DeviceVersion;
   midw_fi_tclString DeviceName;
   midw_fi_tclString AccessoryName;
   midw_fi_tclString MountPoint;
   midw_fi_tcl_e8_DeviceConnectStatus DeviceConnectStatus;
   virtual ~midw_fi_tcl_DevManager_DeviceProperty();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DevManager_DeviceProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DevManager_DevInfoStr : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DevManager_DevInfoStr();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DevManager_DevInfoStr& operator=(const midw_fi_tcl_DevManager_DevInfoStr& coRef);
   midw_fi_tcl_DevManager_DevInfoStr(const midw_fi_tcl_DevManager_DevInfoStr& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_DevManager_DeviceProperty, std::allocator<midw_fi_tcl_DevManager_DeviceProperty> > DevList;
   virtual ~midw_fi_tcl_DevManager_DevInfoStr();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DevManager_DevInfoStr& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8Array : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8Array();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_u8Array& operator=(const midw_fi_tcl_u8Array& coRef);
   midw_fi_tcl_u8Array(const midw_fi_tcl_u8Array& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > tU8Array;
   virtual ~midw_fi_tcl_u8Array();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_u8Array& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_InternalError : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_InternalError();
   enum tenType {
      FI_EN_INTERNAL_ERROR_ID_NOT_SUPPORTED = 0UL,
      FI_EN_INTERNAL_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE = 1UL,
      FI_EN_INTERNAL_ERROR_ROUTINE_NOT_RUNNING = 2UL,
      FI_EN_INTERNAL_ERROR_WRITE_NOT_SUPPORTED = 3UL,
      FI_EN_INTERNAL_ERROR_READ_NOT_SUPPORTED = 4UL,
      FI_EN_INTERNAL_ERROR_ROUTINE_NEVER_RAN = 5UL,
      FI_EN_INTERNAL_ERROR_ROUTINE_STILL_RUNNING = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_InternalError(midw_fi_tcl_e8_InternalError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_InternalError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_InternalError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_RoutineBitMask : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_RoutineBitMask();

   enum {
      FI_C_U32_BIT_ROUTINE_FLAG_WRITE_TO_RM = 0x1UL,
      FI_C_U32_BIT_ROUTINE_FLAG_SUPRESS_RESULTS = 0x2UL
   };
   tBool bROUTINE_FLAG_WRITE_TO_RM() const {return (u32Value & FI_C_U32_BIT_ROUTINE_FLAG_WRITE_TO_RM) != 0; }
   tVoid vSetROUTINE_FLAG_WRITE_TO_RM(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_ROUTINE_FLAG_WRITE_TO_RM):(u32Value & ~(tU32)FI_C_U32_BIT_ROUTINE_FLAG_WRITE_TO_RM)); }
   tBool bROUTINE_FLAG_SUPRESS_RESULTS() const {return (u32Value & FI_C_U32_BIT_ROUTINE_FLAG_SUPRESS_RESULTS) != 0; }
   tVoid vSetROUTINE_FLAG_SUPRESS_RESULTS(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_ROUTINE_FLAG_SUPRESS_RESULTS):(u32Value & ~(tU32)FI_C_U32_BIT_ROUTINE_FLAG_SUPRESS_RESULTS)); }
   struct rBitValues {
      tBool ROUTINE_FLAG_WRITE_TO_RM:1;
      tBool ROUTINE_FLAG_SUPRESS_RESULTS:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_RoutineBitMask();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_RoutineBitMask& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RoutineStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RoutineStatus();
   enum tenType {
      FI_EN_ROUTINE_CONTROL_OK = 0UL,
      FI_EN_ROUTINE_CONTROL_NOT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_RoutineStatus(midw_fi_tcl_e8_RoutineStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RoutineStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RoutineStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_IOResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_IOResult();
   enum tenType {
      FI_EN_IO_CONTROL_OK = 0UL,
      FI_EN_IO_CONTROL_NOT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_IOResult(midw_fi_tcl_e8_IOResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_IOResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_IOResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SystemSetResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SystemSetResult();
   enum tenType {
      FI_EN_SYSTEMSET_OK = 0UL,
      FI_EN_SYSTEMSET_NOT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_SystemSetResult(midw_fi_tcl_e8_SystemSetResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SystemSetResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SystemSetResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagDataResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagDataResult();
   enum tenType {
      FI_EN_DIAGDATA_OK = 0UL,
      FI_EN_DIAGDATA_NOT_OK = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagDataResult(midw_fi_tcl_e8_DiagDataResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagDataResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagDataResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_IOControlActionId : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_IOControlActionId();
   enum tenType {
      FI_EN_IO_CONTROL_ACTION_FREEZE = 0UL,
      FI_EN_IO_CONTROL_ACTION_UNFREEZE = 1UL,
      FI_EN_IO_CONTROL_ACTION_SET = 2UL,
      FI_EN_IO_CONTROL_ACTION_SET_TO_DEFAULT = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_IOControlActionId(midw_fi_tcl_e8_IOControlActionId::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_IOControlActionId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_IOControlActionId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SystemSetType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SystemSetType();
   enum tenType {
      FI_EN_SYSTEMSET_TYPE_HMI = 0UL,
      FI_EN_SYSTEMSET_TYPE_TEF = 1UL,
      FI_EN_SYSTEMSET_TYPE_CODING = 2UL,
      FI_EN_SYSTEMSET_TYPE_CALIBRATION = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_SystemSetType(midw_fi_tcl_e8_SystemSetType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SystemSetType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SystemSetType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ValueType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ValueType();
   enum tenType {
      FI_EN_TBOOL = 0UL,
      FI_EN_TU8 = 1UL,
      FI_EN_TU16 = 2UL,
      FI_EN_TU32 = 3UL,
      FI_EN_TS8 = 4UL,
      FI_EN_TS16 = 5UL,
      FI_EN_TS32 = 6UL,
      FI_EN_TF32 = 7UL,
      FI_EN_TF64 = 8UL,
      FI_EN_T_E8_INTERNALERROR = 9UL,
      FI_EN_T_U8ARRAY = 10UL
   };
   tenType enType;

   midw_fi_tcl_e8_ValueType(midw_fi_tcl_e8_ValueType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ValueType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ValueType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ValueUnion : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ValueUnion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ValueUnion& operator=(const midw_fi_tcl_ValueUnion& coRef);
   midw_fi_tcl_ValueUnion(const midw_fi_tcl_ValueUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ValueType ValueUnionType;
   fi_tclTypeBase* poValueUnionData;
   virtual ~midw_fi_tcl_ValueUnion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ValueUnion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ValueList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ValueList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ValueList& operator=(const midw_fi_tcl_ValueList& coRef);
   midw_fi_tcl_ValueList(const midw_fi_tcl_ValueList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ValueUnion, std::allocator<midw_fi_tcl_ValueUnion> > ValueList;
   virtual ~midw_fi_tcl_ValueList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ValueList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MethodResultReply : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MethodResultReply();
   enum tenType {
      FI_EN_ACCEPTED = 0UL,
      FI_EN_REJECTED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_MethodResultReply(midw_fi_tcl_e8_MethodResultReply::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MethodResultReply();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MethodResultReply& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TestResult();
   enum tenType {
      FI_EN_PASSED = 0UL,
      FI_EN_FAILED = 1UL,
      FI_EN_NORESULT = 2UL,
      FI_EN_PASSEDDIAGNOSTIC = 3UL,
      FI_EN_FAILEDDIAGNOSTIC = 4UL,
      FI_EN_NORESULTDIAGNOSTIC = 5UL,
      FI_EN_DISABLE = 6UL,
      FI_EN_ENABLE = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_TestResult(midw_fi_tcl_e8_TestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_FreezeFrameData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_FreezeFrameData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_FreezeFrameData& operator=(const midw_fi_tcl_FreezeFrameData& coRef);
   midw_fi_tcl_FreezeFrameData(const midw_fi_tcl_FreezeFrameData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ID;
   std::vector<tU8, std::allocator<tU8> > Data;
   virtual ~midw_fi_tcl_FreezeFrameData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_FreezeFrameData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_FreezeFrameList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_FreezeFrameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_FreezeFrameList& operator=(const midw_fi_tcl_FreezeFrameList& coRef);
   midw_fi_tcl_FreezeFrameList(const midw_fi_tcl_FreezeFrameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_FreezeFrameData, std::allocator<midw_fi_tcl_FreezeFrameData> > FreezeFrameDataList;
   virtual ~midw_fi_tcl_FreezeFrameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_FreezeFrameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ReadRequestBuffer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ReadRequestBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ReadRequestBuffer& operator=(const midw_fi_tcl_ReadRequestBuffer& coRef);
   midw_fi_tcl_ReadRequestBuffer(const midw_fi_tcl_ReadRequestBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ReadRequestBuffer;
   virtual ~midw_fi_tcl_ReadRequestBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ReadRequestBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ReadResultBuffer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ReadResultBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ReadResultBuffer& operator=(const midw_fi_tcl_ReadResultBuffer& coRef);
   midw_fi_tcl_ReadResultBuffer(const midw_fi_tcl_ReadResultBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ReadResultBuffer;
   virtual ~midw_fi_tcl_ReadResultBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ReadResultBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ReadResultStructure : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ReadResultStructure& operator=(const midw_fi_tcl_ReadResultStructure& coRef);
   midw_fi_tcl_ReadResultStructure(const midw_fi_tcl_ReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   virtual ~midw_fi_tcl_ReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ReadResultList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ReadResultList& operator=(const midw_fi_tcl_ReadResultList& coRef);
   midw_fi_tcl_ReadResultList(const midw_fi_tcl_ReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ReadResultStructure, std::allocator<midw_fi_tcl_ReadResultStructure> > DTCList;
   virtual ~midw_fi_tcl_ReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ITC_Information : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ITC_Information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ITC_Information& operator=(const midw_fi_tcl_ITC_Information& coRef);
   midw_fi_tcl_ITC_Information(const midw_fi_tcl_ITC_Information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   tU32 DTC;
   tU8 StatusOfItc;
   tU32 AgeingCounter;
   tU32 OccurenceCounter;
   virtual ~midw_fi_tcl_ITC_Information();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ITC_Information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProductionReadResultStructure : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProductionReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ProductionReadResultStructure& operator=(const midw_fi_tcl_ProductionReadResultStructure& coRef);
   midw_fi_tcl_ProductionReadResultStructure(const midw_fi_tcl_ProductionReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   tU8 Status;
   virtual ~midw_fi_tcl_ProductionReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ProductionReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProductionReadResultList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProductionReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ProductionReadResultList& operator=(const midw_fi_tcl_ProductionReadResultList& coRef);
   midw_fi_tcl_ProductionReadResultList(const midw_fi_tcl_ProductionReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ProductionReadResultStructure, std::allocator<midw_fi_tcl_ProductionReadResultStructure> > ITCList;
   virtual ~midw_fi_tcl_ProductionReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ProductionReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CustomerReadResultStructure : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CustomerReadResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CustomerReadResultStructure& operator=(const midw_fi_tcl_CustomerReadResultStructure& coRef);
   midw_fi_tcl_CustomerReadResultStructure(const midw_fi_tcl_CustomerReadResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 Status;
   virtual ~midw_fi_tcl_CustomerReadResultStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CustomerReadResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CustomerReadResultList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CustomerReadResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CustomerReadResultList& operator=(const midw_fi_tcl_CustomerReadResultList& coRef);
   midw_fi_tcl_CustomerReadResultList(const midw_fi_tcl_CustomerReadResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_CustomerReadResultStructure, std::allocator<midw_fi_tcl_CustomerReadResultStructure> > DTCList;
   virtual ~midw_fi_tcl_CustomerReadResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CustomerReadResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Protocol : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Protocol();
   enum tenType {
      FI_EN_UDS = 1UL,
      FI_EN_GMLAN = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Protocol(midw_fi_tcl_e8_Protocol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Protocol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Protocol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TestResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TestResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TestResult& operator=(const midw_fi_tcl_TestResult& coRef);
   midw_fi_tcl_TestResult(const midw_fi_tcl_TestResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TroubleCode;
   midw_fi_tcl_e8_TestResult Result;
   midw_fi_tcl_FreezeFrameList FreezeFrameList;
   virtual ~midw_fi_tcl_TestResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TestResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TestResultList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TestResultList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TestResultList& operator=(const midw_fi_tcl_TestResultList& coRef);
   midw_fi_tcl_TestResultList(const midw_fi_tcl_TestResultList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TestResult, std::allocator<midw_fi_tcl_TestResult> > TestResultList;
   virtual ~midw_fi_tcl_TestResultList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TestResultList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SnapshotData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SnapshotData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SnapshotData& operator=(const midw_fi_tcl_SnapshotData& coRef);
   midw_fi_tcl_SnapshotData(const midw_fi_tcl_SnapshotData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RecordNumber;
   tU8 NumberOfData;
   std::vector<tU8, std::allocator<tU8> > Data;
   virtual ~midw_fi_tcl_SnapshotData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SnapshotData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SnapshotDataList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SnapshotDataList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SnapshotDataList& operator=(const midw_fi_tcl_SnapshotDataList& coRef);
   midw_fi_tcl_SnapshotDataList(const midw_fi_tcl_SnapshotDataList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_SnapshotData, std::allocator<midw_fi_tcl_SnapshotData> > SnapshotData;
   virtual ~midw_fi_tcl_SnapshotDataList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SnapshotDataList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SnapshotIdentification : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SnapshotIdentification();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SnapshotIdentification& operator=(const midw_fi_tcl_SnapshotIdentification& coRef);
   midw_fi_tcl_SnapshotIdentification(const midw_fi_tcl_SnapshotIdentification& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 RecordNumber;
   virtual ~midw_fi_tcl_SnapshotIdentification();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SnapshotIdentification& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SnapshotIdentificationList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SnapshotIdentificationList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SnapshotIdentificationList& operator=(const midw_fi_tcl_SnapshotIdentificationList& coRef);
   midw_fi_tcl_SnapshotIdentificationList(const midw_fi_tcl_SnapshotIdentificationList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_SnapshotIdentification, std::allocator<midw_fi_tcl_SnapshotIdentification> > SnapshotIdentification;
   virtual ~midw_fi_tcl_SnapshotIdentificationList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SnapshotIdentificationList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ClearRequestBuffer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ClearRequestBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ClearRequestBuffer& operator=(const midw_fi_tcl_ClearRequestBuffer& coRef);
   midw_fi_tcl_ClearRequestBuffer(const midw_fi_tcl_ClearRequestBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ClearRequestBuffer;
   virtual ~midw_fi_tcl_ClearRequestBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ClearRequestBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ClearResultBuffer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ClearResultBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ClearResultBuffer& operator=(const midw_fi_tcl_ClearResultBuffer& coRef);
   midw_fi_tcl_ClearResultBuffer(const midw_fi_tcl_ClearResultBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ClearResultBuffer;
   virtual ~midw_fi_tcl_ClearResultBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ClearResultBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ControlParameter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ControlParameter();
   enum tenType {
      FI_EN_DISABLELOGGING = 0UL,
      FI_EN_ENABLELOGGING = 1UL,
      FI_EN_ENABLELOGGINGPERSISTENT = 2UL,
      FI_EN_DISABLELOGGINPERSISTENT = 3UL,
      FI_EN_ENABLECALIBRATIONBLOCKING = 4UL,
      FI_EN_DISABLECALIBRATIONBLOCKING = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_ControlParameter(midw_fi_tcl_e8_ControlParameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ControlParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ControlParameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ControlList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ControlList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ControlList& operator=(const midw_fi_tcl_ControlList& coRef);
   midw_fi_tcl_ControlList(const midw_fi_tcl_ControlList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DTCList;
   virtual ~midw_fi_tcl_ControlList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ControlList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ReadValue : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ReadValue();
   enum tenType {
      FI_EN_DTCSSETBYDIAGNOSTICTEST = 0UL,
      FI_EN_CONTINUOUSDTCSSET = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_ReadValue(midw_fi_tcl_e8_ReadValue::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ReadValue();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ReadValue& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VDLMediaType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VDLMediaType();
   enum tenType {
      FI_EN_FFS = 0UL,
      FI_EN_SDCARD = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_VDLMediaType(midw_fi_tcl_e8_VDLMediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VDLMediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VDLMediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiaglogDefsetType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiaglogDefsetType();
   enum tenType {
      FI_EN_CLEAR_ERRMEM = 1UL,
      FI_EN_ACTIVATE_DEACTIVATE_DTC = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiaglogDefsetType(midw_fi_tcl_e8_DiaglogDefsetType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiaglogDefsetType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiaglogDefsetType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SendNextTestResReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SendNextTestResReason();
   enum tenType {
      FI_EN_CLEAR_CODE = 1UL,
      FI_EN_BLOCKING_MODE_RESET = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_SendNextTestResReason(midw_fi_tcl_e8_SendNextTestResReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SendNextTestResReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SendNextTestResReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SendNextTestResultStructure : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SendNextTestResultStructure();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SendNextTestResultStructure& operator=(const midw_fi_tcl_SendNextTestResultStructure& coRef);
   midw_fi_tcl_SendNextTestResultStructure(const midw_fi_tcl_SendNextTestResultStructure& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   midw_fi_tcl_e8_SendNextTestResReason SendNextTestResReason;
   std::vector<tU16, std::allocator<tU16> > ITCList;
   virtual ~midw_fi_tcl_SendNextTestResultStructure();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SendNextTestResultStructure& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ErrorCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ErrorCode();
   enum tenType {
      FI_EN_FBLOCKIDNOTAVAILABLE = 1UL,
      FI_EN_INSTIDNOTAVAILABLE = 2UL,
      FI_EN_FKTIDNOTAVAILABLE = 3UL,
      FI_EN_OPTYPENOTAVAILABLE = 4UL,
      FI_EN_INVALIDLENGTH = 5UL,
      FI_EN_PARAMETERWRONG_OUTOFRANGE = 6UL,
      FI_EN_PARAMETERNOTAVAILABLE = 7UL,
      FI_EN_PARAMETERMISSING = 8UL,
      FI_EN_TOOMANYPARAMETERS = 9UL,
      FI_EN_FUNCTIONSPECIFIC = 32UL,
      FI_EN_BUSY = 64UL,
      FI_EN_NOTAVAILABLE = 65UL
   };
   tenType enType;

   midw_fi_tcl_e8_ErrorCode(midw_fi_tcl_e8_ErrorCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ErrorCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_GMLnGWDTCFaultType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_GMLnGWDTCFaultType();
   enum tenType {
      FI_EN_E8NOT_SUPPORTED = 0UL,
      FI_EN_E8TYPE_A = 1UL,
      FI_EN_E8TYPE_B = 2UL,
      FI_EN_E8TYPE_C = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_GMLnGWDTCFaultType(midw_fi_tcl_e8_GMLnGWDTCFaultType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_GMLnGWDTCFaultType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_GMLnGWDTCFaultType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ActiveDTCList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ActiveDTCList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ActiveDTCList& operator=(const midw_fi_tcl_ActiveDTCList& coRef);
   midw_fi_tcl_ActiveDTCList(const midw_fi_tcl_ActiveDTCList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DTCList;
   virtual ~midw_fi_tcl_ActiveDTCList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ActiveDTCList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagProtocol : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagProtocol();
   enum tenType {
      FI_EN_UNKNOWN = 255UL,
      FI_EN_UDS = 0UL,
      FI_EN_GMLAN = 1UL
   };
   tenType enType;

   midw_fi_tcl_DiagProtocol(midw_fi_tcl_DiagProtocol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_DiagProtocol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_DiagProtocol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Store : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Store();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_VOLATILE = 0UL,
      FI_EN_PERSISTENT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Store(midw_fi_tcl_e8_Store::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Store();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Store& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RouteCalculationCommand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RouteCalculationCommand();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_SETPOSITIONSANDCALCULATE = 0UL,
      FI_EN_CALCULATEONLY = 1UL,
      FI_EN_SETCURRENTPOSITION = 2UL,
      FI_EN_SETDESTINATION = 3UL,
      FI_EN_ABORTCALCULATION = 127UL
   };
   tenType enType;

   midw_fi_tcl_e8_RouteCalculationCommand(midw_fi_tcl_e8_RouteCalculationCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RouteCalculationCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RouteCalculationCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RouteCalculationStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RouteCalculationStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CALCULATIONCOMPLETE = 0UL,
      FI_EN_CALCULATIONFAILED = 1UL,
      FI_EN_CURRENTPOSITIONNOTSET = 2UL,
      FI_EN_DESTINATIONNOTSET = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_RouteCalculationStatus(midw_fi_tcl_e8_RouteCalculationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RouteCalculationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RouteCalculationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Language : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Language();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_GERMAN = 1UL,
      FI_EN_DUTCH = 2UL,
      FI_EN_ENGLISHMETRIC = 3UL,
      FI_EN_FRENCH = 4UL,
      FI_EN_SPANISH = 5UL,
      FI_EN_JAPANESE = 6UL,
      FI_EN_ITALIAN = 7UL,
      FI_EN_ENGLISHMETRICUSA = 8UL,
      FI_EN_SWEDISH = 9UL,
      FI_EN_DANISH = 10UL,
      FI_EN_PORTUGESE = 11UL,
      FI_EN_ENGLISHIMPERIAL = 12UL,
      FI_EN_ENGLISHIMPERIALUSA = 13UL,
      FI_EN_FINNISH = 14UL,
      FI_EN_NORWEGIAN = 15UL,
      FI_EN_GREEK = 16UL,
      FI_EN_TURKISH = 17UL,
      FI_EN_POLISH = 18UL,
      FI_EN_CZECH = 19UL,
      FI_EN_CHINESE = 20UL
   };
   tenType enType;

   midw_fi_tcl_e8_Language(midw_fi_tcl_e8_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Country : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Country();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_USA = 1UL,
      FI_EN_NETHERLANDS = 31UL,
      FI_EN_BELGIUM = 32UL,
      FI_EN_FRANCE = 33UL,
      FI_EN_SPAIN = 34UL,
      FI_EN_ITALY = 39UL,
      FI_EN_SWITZERLAND = 41UL,
      FI_EN_GREATBRITAIN = 44UL,
      FI_EN_DENMARK = 45UL,
      FI_EN_SWEDEN = 46UL,
      FI_EN_GERMANY = 49UL,
      FI_EN_PORTUGAL = 51UL,
      FI_EN_LUXEMBOURG = 52UL,
      FI_EN_JAPAN = 81UL
   };
   tenType enType;

   midw_fi_tcl_e8_Country(midw_fi_tcl_e8_Country::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Country();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Country& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_LanguageSubsystem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_LanguageSubsystem();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_HMI = 0UL,
      FI_EN_SDS = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_LanguageSubsystem(midw_fi_tcl_e8_LanguageSubsystem::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_LanguageSubsystem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_LanguageSubsystem& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TestScreens : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TestScreens();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_NOTESTSCREEN = 0UL,
      FI_EN_PLAINWHITE = 1UL,
      FI_EN_PLAINBLACK = 2UL,
      FI_EN_PLAINRED = 3UL,
      FI_EN_PLAINGREEN = 4UL,
      FI_EN_PLAINBLUE = 5UL,
      FI_EN_COLOURED = 6UL,
      FI_EN_SCREEN_7 = 7UL,
      FI_EN_SCREEN_8 = 8UL,
      FI_EN_SCREEN_9 = 9UL,
      FI_EN_DIAGNOSISMASK = 10UL,
      FI_EN_COLOURGRADIATION = 80UL,
      FI_EN_LATTICE = 81UL,
      FI_EN_LEFTWHITERIGHTBLACK = 96UL,
      FI_EN_LEFTBLACKRIGHTWHITE = 97UL,
      FI_EN_PIXELWISECHESSBOARD = 98UL,
      FI_EN_TEFSPECIAL1 = 146UL,
      FI_EN_TEFSPECIAL2 = 147UL,
      FI_EN_RGB_NOK = 16UL,
      FI_EN_RGB_OK = 17UL,
      FI_EN_RGB_REPDARK = 18UL
   };
   tenType enType;

   midw_fi_tcl_e8_TestScreens(midw_fi_tcl_e8_TestScreens::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TestScreens();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TestScreens& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayStringsList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayStringsList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayStringsList& operator=(const midw_fi_tcl_DisplayStringsList& coRef);
   midw_fi_tcl_DisplayStringsList(const midw_fi_tcl_DisplayStringsList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tclString, std::allocator<midw_fi_tclString> > StringList;
   virtual ~midw_fi_tcl_DisplayStringsList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayStringsList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayData& operator=(const midw_fi_tcl_DisplayData& coRef);
   midw_fi_tcl_DisplayData(const midw_fi_tcl_DisplayData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TestScreens TestScreen;
   midw_fi_tcl_DisplayStringsList DisplayStrings;
   virtual ~midw_fi_tcl_DisplayData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TroubleCodeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TroubleCodeType();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_DTC = 0UL,
      FI_EN_ITC = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_TroubleCodeType(midw_fi_tcl_e8_TroubleCodeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TroubleCodeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TroubleCodeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TestRoutines : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TestRoutines();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CDIFTEST = 0UL,
      FI_EN_DVDIFTEST = 1UL,
      FI_EN_CDREADTESTSHORT = 2UL,
      FI_EN_DVDREADTESTSHORT = 3UL,
      FI_EN_CDREADTESTINTENSIVE = 4UL,
      FI_EN_DVDREADTESTINTENSIVE = 5UL,
      FI_EN_FMSEEKTEST = 6UL,
      FI_EN_GYROTEST = 7UL,
      FI_EN_GPSANTENNATEST = 8UL,
      FI_EN_TWEETERTEST = 9UL,
      FI_EN_SPEAKERTEST = 10UL,
      FI_EN_ONDEMANDSELFTEST = 11UL
   };
   tenType enType;

   midw_fi_tcl_e8_TestRoutines(midw_fi_tcl_e8_TestRoutines::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TestRoutines();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TestRoutines& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DefaultSettingsCategories : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DefaultSettingsCategories();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_AMFM = 0UL,
      FI_EN_CDAUX = 1UL,
      FI_EN_NAVMAP = 2UL,
      FI_EN_DESTINATIONMEMORY = 3UL,
      FI_EN_VOLUMEDISPLAY = 4UL,
      FI_EN_RESTORE_VEHICLE_SETTING = 5UL,
      FI_EN_CLEAR_ALL_PRIVATE_DATA = 6UL,
      FI_EN_RESTORE_RADIO_SETTING = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_DefaultSettingsCategories(midw_fi_tcl_e8_DefaultSettingsCategories::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DefaultSettingsCategories();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DefaultSettingsCategories& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CountryLanguage : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CountryLanguage();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CountryLanguage& operator=(const midw_fi_tcl_CountryLanguage& coRef);
   midw_fi_tcl_CountryLanguage(const midw_fi_tcl_CountryLanguage& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Country Country;
   midw_fi_tcl_e8_Language Language;
   midw_fi_tcl_e8_LanguageSubsystem Subsystem;
   virtual ~midw_fi_tcl_CountryLanguage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CountryLanguage& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CountryLanguageResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CountryLanguageResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CountryLanguageResult& operator=(const midw_fi_tcl_CountryLanguageResult& coRef);
   midw_fi_tcl_CountryLanguageResult(const midw_fi_tcl_CountryLanguageResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   std::vector<midw_fi_tcl_CountryLanguage, std::allocator<midw_fi_tcl_CountryLanguage> > CountryLanguageList;
   virtual ~midw_fi_tcl_CountryLanguageResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CountryLanguageResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TroubleCodeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TroubleCodeStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_INACTIVE = 0UL,
      FI_EN_ACTIVE = 1UL,
      FI_EN_NOTCOMPLETE = 2UL,
      FI_EN_ACTIVENOTCOMPLETE = 3UL,
      FI_EN_WASACTIVE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_TroubleCodeStatus(midw_fi_tcl_e8_TroubleCodeStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TroubleCodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TroubleCodeStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TroubleCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TroubleCode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TroubleCode& operator=(const midw_fi_tcl_TroubleCode& coRef);
   midw_fi_tcl_TroubleCode(const midw_fi_tcl_TroubleCode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TroubleCode;
   midw_fi_tcl_e8_TroubleCodeStatus Status;
   virtual ~midw_fi_tcl_TroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TroubleCode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TroubleCodeList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TroubleCodeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TroubleCodeList& operator=(const midw_fi_tcl_TroubleCodeList& coRef);
   midw_fi_tcl_TroubleCodeList(const midw_fi_tcl_TroubleCodeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TroubleCode, std::allocator<midw_fi_tcl_TroubleCode> > TroubleCodeList;
   virtual ~midw_fi_tcl_TroubleCodeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TroubleCodeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RouteCalculationStartParameter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RouteCalculationStartParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RouteCalculationStartParameter& operator=(const midw_fi_tcl_RouteCalculationStartParameter& coRef);
   midw_fi_tcl_RouteCalculationStartParameter(const midw_fi_tcl_RouteCalculationStartParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 CurrentPositionLongitude;
   tS32 CurrentPositionLatitude;
   tS32 DestinationLongitude;
   tS32 DestinationLatitude;
   tU8 RouteIndex;
   tU8 RouteOptimisation;
   midw_fi_tcl_e8_RouteCalculationCommand Command;
   virtual ~midw_fi_tcl_RouteCalculationStartParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RouteCalculationStartParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RouteCalculationResultParameter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RouteCalculationResultParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RouteCalculationResultParameter& operator=(const midw_fi_tcl_RouteCalculationResultParameter& coRef);
   midw_fi_tcl_RouteCalculationResultParameter(const midw_fi_tcl_RouteCalculationResultParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 CurrentPositionLongitude;
   tS32 CurrentPositionLatitude;
   tS32 DestinationLongitude;
   tS32 DestinationLatitude;
   tU8 RouteIndex;
   tU8 RouteOptimisation;
   midw_fi_tcl_e8_RouteCalculationCommand Command;
   midw_fi_tcl_e8_RouteCalculationStatus RouteCalculationStatus;
   tU32 RouteLength;
   tU32 RouteDuration;
   virtual ~midw_fi_tcl_RouteCalculationResultParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RouteCalculationResultParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_Language : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_Language();
   enum tenType {
      FI_EN_UNDEFINED = 65535UL,
      FI_EN_SWEDISH = 1UL,
      FI_EN_DANISH = 2UL,
      FI_EN_FINNISH = 3UL,
      FI_EN_ENGLISH = 4UL,
      FI_EN_GERMAN = 5UL,
      FI_EN_DUTCH = 6UL,
      FI_EN_FRENCH = 7UL,
      FI_EN_ITALIAN = 8UL,
      FI_EN_SPANISH = 9UL,
      FI_EN_PORTUGUESE = 10UL,
      FI_EN_USENGLISH = 11UL,
      FI_EN_CANADIANFRENCH = 12UL,
      FI_EN_PORTUGUESEBRAZIL = 13UL,
      FI_EN_JAPANESE = 14UL,
      FI_EN_ENGLISHWITHNUMBERCODES = 15UL,
      FI_EN_HUNGARIAN = 16UL,
      FI_EN_TURKISH = 17UL,
      FI_EN_RUSSIAN = 18UL,
      FI_EN_POLISH = 19UL,
      FI_EN_CZECH = 20UL,
      FI_EN_NORWEGIAN = 21UL,
      FI_EN_LATINSPANISH = 22UL,
      FI_EN_AUSTRALIANENGLISH = 23UL,
      FI_EN_THAI = 24UL,
      FI_EN_ASIAPACIFICENGLISH = 25UL,
      FI_EN_CHINESE = 26UL,
      FI_EN_TAIWANESE = 27UL
   };
   tenType enType;

   midw_fi_tcl_e16_Language(midw_fi_tcl_e16_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_SpeedLock : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_SpeedLock();
   enum tenType {
      FI_EN_UNDEFINED = 65535UL,
      FI_EN_INACTIVE = 1UL,
      FI_EN_ACTIVE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e16_SpeedLock(midw_fi_tcl_e16_SpeedLock::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_SpeedLock();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_SpeedLock& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MessageBuffer : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MessageBuffer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MessageBuffer& operator=(const midw_fi_tcl_MessageBuffer& coRef);
   midw_fi_tcl_MessageBuffer(const midw_fi_tcl_MessageBuffer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > MessageBuffer;
   virtual ~midw_fi_tcl_MessageBuffer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MessageBuffer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DefSetMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DefSetMode();
   enum tenType {
      FI_EN_DEFSET_SRC_NOT_DEF = 255UL,
      FI_EN_DEFSET_SRC_SET_USER = 0UL,
      FI_EN_DEFSET_SRC_SET_TEF = 1UL,
      FI_EN_DEFSET_SRC_UPREG = 2UL,
      FI_EN_DEFSET_SRC_RELUPREG = 3UL,
      FI_EN_DEFSET_SRC_GET = 4UL,
      FI_EN_DEFSET_SRC_CODING = 5UL,
      FI_EN_DEFSET_SRC_CALIBRATION = 6UL,
      FI_EN_DEFSET_START = 7UL,
      FI_EN_DEFSET_COMPLETE = 8UL,
      FI_EN_DEFSET_SRC_SET_OEM = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_DefSetMode(midw_fi_tcl_e8_DefSetMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DefSetMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DefSetMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DefSetServiceStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DefSetServiceStatus();
   enum tenType {
      FI_EN_DEFSET_STATE_UNDEFINED = 255UL,
      FI_EN_DEFSET_STATE_CONFIRMED = 0UL,
      FI_EN_DEFSET_STATE_FAILED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DefSetServiceStatus(midw_fi_tcl_e8_DefSetServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DefSetServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DefSetServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DefSetGroups : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DefSetGroups();
   enum tenType {
      FI_EN_DEFSET_GROUP_UNDEFIEND = 255UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY = 0UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION = 1UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION = 2UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE = 3UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY = 4UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION = 5UL,
      FI_EN_DEFSET_GROUP__RADIO = 6UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE = 7UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX = 8UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO = 9UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO_CD = 10UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__MP3 = 11UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__CDC = 12UL,
      FI_EN_DEFSET_GROUP__MAINTENANCE = 13UL,
      FI_EN_DEFSET_GROUP__OFFICE__CLOCK = 14UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE = 15UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__LANGUAGE = 16UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__TTS = 17UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION = 18UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT = 19UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DIMMING = 20UL,
      FI_EN_DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT = 21UL,
      FI_EN_DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS = 22UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA = 23UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS = 24UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE = 25UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC = 26UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING = 27UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION = 28UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION = 29UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__COLOR = 30UL,
      FI_EN_DEFSET_GROUP_ALL = 31UL
   };
   tenType enType;

   midw_fi_tcl_e8_DefSetGroups(midw_fi_tcl_e8_DefSetGroups::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DefSetGroups();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DefSetGroups& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagMausSetup : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagMausSetup();
   enum tenType {
      FI_EN_MAUS_STATE_UNDEFINED = 255UL,
      FI_EN_MAUS_STATE_RESERVED = 0UL,
      FI_EN_MAUS_STATE_ENABLE_TIME_SLOT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagMausSetup(midw_fi_tcl_e8_DiagMausSetup::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagMausSetup();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagMausSetup& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SimulatedKeys : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SimulatedKeys();
   enum tenType {
      FI_EN_KEY_CODE_SOFTKEY_UNDEFINED = 255UL,
      FI_EN_KEY_CODE_SOFTKEY_1 = 1UL,
      FI_EN_KEY_CODE_SOFTKEY_2 = 2UL,
      FI_EN_KEY_CODE_SOFTKEY_3 = 3UL,
      FI_EN_KEY_CODE_SOFTKEY_4 = 4UL,
      FI_EN_KEY_CODE_SOFTKEY_5 = 5UL,
      FI_EN_KEY_CODE_SOFTKEY_6 = 6UL,
      FI_EN_KEY_CODE_NAVKEY = 7UL,
      FI_EN_KEY_CODE_ROTARY_RIGHT = 8UL
   };
   tenType enType;

   midw_fi_tcl_e8_SimulatedKeys(midw_fi_tcl_e8_SimulatedKeys::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SimulatedKeys();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SimulatedKeys& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_KDSItemList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_KDSItemList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_KDSItemList& operator=(const midw_fi_tcl_KDSItemList& coRef);
   midw_fi_tcl_KDSItemList(const midw_fi_tcl_KDSItemList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~midw_fi_tcl_KDSItemList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_KDSItemList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ConfigItemList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ConfigItemList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ConfigItemList& operator=(const midw_fi_tcl_ConfigItemList& coRef);
   midw_fi_tcl_ConfigItemList(const midw_fi_tcl_ConfigItemList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~midw_fi_tcl_ConfigItemList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ConfigItemList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RequestDataUDS : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RequestDataUDS();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RequestDataUDS& operator=(const midw_fi_tcl_RequestDataUDS& coRef);
   midw_fi_tcl_RequestDataUDS(const midw_fi_tcl_RequestDataUDS& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~midw_fi_tcl_RequestDataUDS();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RequestDataUDS& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ResponseDataUDS : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ResponseDataUDS();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ResponseDataUDS& operator=(const midw_fi_tcl_ResponseDataUDS& coRef);
   midw_fi_tcl_ResponseDataUDS(const midw_fi_tcl_ResponseDataUDS& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~midw_fi_tcl_ResponseDataUDS();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ResponseDataUDS& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiagData& operator=(const midw_fi_tcl_DiagData& coRef);
   midw_fi_tcl_DiagData(const midw_fi_tcl_DiagData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > itemList;
   virtual ~midw_fi_tcl_DiagData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiagData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RCtrlSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RCtrlSource();
   enum tenType {
      FI_EN_RCTRL_SRC_UNKNOWN = 255UL,
      FI_EN_RCTRL_SRC_HMI = 0UL,
      FI_EN_RCTRL_SRC_TEF = 1UL,
      FI_EN_RCTRL_SRC_CUSTOMER = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_RCtrlSource(midw_fi_tcl_e8_RCtrlSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RCtrlSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RCtrlSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RCtrlCommand : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RCtrlCommand();
   enum tenType {
      FI_EN_RCTRL_CMD_DEACTIVATE = 0UL,
      FI_EN_RCTRL_CMD_ACTIVATE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_RCtrlCommand(midw_fi_tcl_e8_RCtrlCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RCtrlCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RCtrlCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RCtrlSignal : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RCtrlSignal();
   enum tenType {
      FI_EN_RCTRL_SIG_ALL = 255UL,
      FI_EN_RCTRL_SIG_FM_FREQUENCY = 0UL,
      FI_EN_RCTRL_SIG_AM_FREQUENCY = 1UL,
      FI_EN_RCTRL_SIG_AUDIO_SOURCE = 2UL,
      FI_EN_RCTRL_SIG_AUDIO_VOLUME = 3UL,
      FI_EN_RCTRL_SIG_AUDIO_FADER_AND_BALANCE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_RCtrlSignal(midw_fi_tcl_e8_RCtrlSignal::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RCtrlSignal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RCtrlSignal& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagRVCSignal : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagRVCSignal();
   enum tenType {
      FI_EN_EXT_VIDEO_SIGNAL_ON = 0UL,
      FI_EN_EXT_VIDEO_SIGNAL_OFF = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagRVCSignal(midw_fi_tcl_e8_DiagRVCSignal::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagRVCSignal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagRVCSignal& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CalibrationTable : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CalibrationTable();
   enum tenType {
      FI_EN_CALIBRATION_TABLE_ID_SYSTEM = 2UL,
      FI_EN_CALIBRATION_TABLE_ID_DISPLAY_INTERFACE = 3UL,
      FI_EN_CALIBRATION_TABLE_ID_BLUETOOTH = 4UL,
      FI_EN_CALIBRATION_TABLE_ID_NAVIGATION_SYSTEM = 5UL,
      FI_EN_CALIBRATION_TABLE_ID_NAVIGATION_ICON = 6UL,
      FI_EN_CALIBRATION_TABLE_ID_BRAND = 7UL,
      FI_EN_CALIBRATION_TABLE_ID_COUNTRY = 8UL,
      FI_EN_CALIBRATION_TABLE_ID_SPEECH_RECOGNITION = 9UL,
      FI_EN_CALIBRATION_TABLE_ID_HAND_FREE_TUNING = 10UL,
      FI_EN_CALIBRATION_TABLE_ID_REAR_VISION_CAMERA = 11UL
   };
   tenType enType;

   midw_fi_tcl_e8_CalibrationTable(midw_fi_tcl_e8_CalibrationTable::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CalibrationTable();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CalibrationTable& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CalibrationValue : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CalibrationValue();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CalibrationValue& operator=(const midw_fi_tcl_CalibrationValue& coRef);
   midw_fi_tcl_CalibrationValue(const midw_fi_tcl_CalibrationValue& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ByteValue;
   virtual ~midw_fi_tcl_CalibrationValue();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CalibrationValue& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CalibrationTimeStampMonth : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CalibrationTimeStampMonth();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_JANUARY = 1UL,
      FI_EN_FEBRUARY = 2UL,
      FI_EN_MARCH = 3UL,
      FI_EN_APRIL = 4UL,
      FI_EN_MAY = 5UL,
      FI_EN_JUNE = 6UL,
      FI_EN_JULY = 7UL,
      FI_EN_AUGUST = 8UL,
      FI_EN_SEPTEMBER = 9UL,
      FI_EN_OCTOBER = 10UL,
      FI_EN_NOVEMBER = 11UL,
      FI_EN_DECEMBER = 12UL
   };
   tenType enType;

   midw_fi_tcl_e8_CalibrationTimeStampMonth(midw_fi_tcl_e8_CalibrationTimeStampMonth::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CalibrationTimeStampMonth();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CalibrationTimeStampMonth& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CalibrationTimeStamp : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CalibrationTimeStamp();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CalibrationTimeStamp& operator=(const midw_fi_tcl_CalibrationTimeStamp& coRef);
   midw_fi_tcl_CalibrationTimeStamp(const midw_fi_tcl_CalibrationTimeStamp& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Hours;
   tU8 Minutes;
   tU8 Seconds;
   tU8 Day;
   tU8 Month;
   tU8 Year;
   virtual ~midw_fi_tcl_CalibrationTimeStamp();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CalibrationTimeStamp& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AlphaCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AlphaCode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AlphaCode& operator=(const midw_fi_tcl_AlphaCode& coRef);
   midw_fi_tcl_AlphaCode(const midw_fi_tcl_AlphaCode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > Letter;
   virtual ~midw_fi_tcl_AlphaCode();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AlphaCode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CalibrationParameterSize : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CalibrationParameterSize();
   enum tenType {
      FI_EN_CALIBRATION_SIZE_BIT = 0UL,
      FI_EN_CALIBRATION_SIZE_BYTE = 1UL,
      FI_EN_CALIBRATION_SIZE_WORD = 2UL,
      FI_EN_CALIBRATION_SIZE_DWORD = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_CalibrationParameterSize(midw_fi_tcl_e8_CalibrationParameterSize::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CalibrationParameterSize();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CalibrationParameterSize& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_KdsViaUsbUpdateStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_KdsViaUsbUpdateStatus();
   enum tenType {
      FI_EN_UNDEFINED = 255UL,
      FI_EN_CONFIGUPDATEINPROGRESS = 0UL,
      FI_EN_CONFIGUPDATESUCCESS = 1UL,
      FI_EN_CONFIGUPDATEFAILED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_KdsViaUsbUpdateStatus(midw_fi_tcl_e8_KdsViaUsbUpdateStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_KdsViaUsbUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_KdsViaUsbUpdateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AntiTheftStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AntiTheftStatus();
   enum tenType {
      FI_EN_HU_UNLOCKED = 0UL,
      FI_EN_HU_LOCKED = 1UL,
      FI_EN_VID_MISSING = 2UL,
      FI_EN_INVALID = 255UL
   };
   tenType enType;

   midw_fi_tcl_AntiTheftStatus(midw_fi_tcl_AntiTheftStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_AntiTheftStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_AntiTheftStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_Aud_TroubleCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_Aud_TroubleCode();
   enum tenType {
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED = 1025UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_VSS = 1026UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_GND = 1027UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_WIRE = 1028UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_INTERRUPTED = 1029UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_VSS = 1030UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_GND = 1031UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_WIRE = 1032UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_INTERRUPTED = 1033UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_VSS = 1034UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_GND = 1035UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_WIRE = 1036UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_INTERRUPTED = 1037UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_VSS = 1038UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_GND = 1039UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_WIRE = 1040UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_ALL_CIRCUIT_FAULT = 1041UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LF_CIRCUIT_INTERRUPTED = 1042UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RF_CIRCUIT_INTERRUPTED = 1043UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LR_CIRCUIT_INTERRUPTED = 1044UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RR_CIRCUIT_INTERRUPTED = 1045UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_ALL_CIRCUIT_FAULT = 1046UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_INTERRUPTED = 1047UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_VSS = 1048UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_GND = 1049UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_WIRE = 1050UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_INTERRUPTED = 1051UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_VSS = 1052UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_GND = 1053UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_WIRE = 1054UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_INTERRUPTED = 1055UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_VSS = 1056UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_GND = 1057UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_WIRE = 1058UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_INTERRUPTED = 1059UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_VSS = 1060UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_GND = 1061UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_WIRE = 1062UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_ALL_CIRCUIT_FAULT = 1063UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_LF_CIRCUIT_NOT_CODED = 1064UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_RF_CIRCUIT_NOT_CODED = 1065UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_LR_CIRCUIT_NOT_CODED = 1066UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_RR_CIRCUIT_NOT_CODED = 1067UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LF_CIRCUIT_NOT_CODED = 1068UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RF_CIRCUIT_NOT_CODED = 1069UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LR_CIRCUIT_NOT_CODED = 1070UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RR_CIRCUIT_NOT_CODED = 1071UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_NOT_CODED = 1072UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_NOT_CODED = 1073UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_NOT_CODED = 1074UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_NOT_CODED = 1075UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_L_CIRCUIT_INTERRUPTED = 1076UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_R_CIRCUIT_INTERRUPTED = 1077UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_L_CIRCUIT_NOT_CODED = 1078UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_R_CIRCUIT_NOT_CODED = 1079UL
   };
   tenType enType;

   midw_fi_tcl_e16_Aud_TroubleCode(midw_fi_tcl_e16_Aud_TroubleCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_Aud_TroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_Aud_TroubleCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_MonitoringMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_MonitoringMode();
   enum tenType {
      FI_EN_FC_AUDIO_MONITORING_OFF = 0UL,
      FI_EN_FC_AUDIO_MONITORING_CONTINUOUS = 1UL,
      FI_EN_FC_AUDIO_MONITORING_SINGLE = 2UL,
      FI_EN_FC_AUDIO_MONITORING_DEFAULTMODE = 3UL,
      FI_EN_FC_AUDIO_MONITORING_PREVIOUSMODE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_MonitoringMode(midw_fi_tcl_e8_Aud_MonitoringMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_MonitoringMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_MonitoringMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_SupervisionControl : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_SupervisionControl();
   enum tenType {
      FI_EN_FC_AUDIO_SUPERVISION_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_SUPERVISION_OFF = 1UL,
      FI_EN_FC_AUDIO_SUPERVISION_ON = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_SupervisionControl(midw_fi_tcl_e8_Aud_SupervisionControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_SupervisionControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_SupervisionControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_ErrorStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_ErrorStatus();
   enum tenType {
      FI_EN_FC_AUDIO_TEST_PASSED = 0UL,
      FI_EN_FC_AUDIO_TEST_FAILED = 1UL,
      FI_EN_FC_AUDIO_TEST_NEVER_RAN = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_ErrorStatus(midw_fi_tcl_e8_Aud_ErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_ErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_ErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_RoutineStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_RoutineStatus();
   enum tenType {
      FI_EN_FC_AUDIO_ROUTINE_NOT_RUNNING = 0UL,
      FI_EN_FC_AUDIO_ROUTINE_RUNNING = 1UL,
      FI_EN_FC_AUDIO_ROUTINE_FINISHED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_RoutineStatus(midw_fi_tcl_e8_Aud_RoutineStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_RoutineStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_RoutineStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_WriteTestErrorStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_WriteTestErrorStatus();
   enum tenType {
      FI_EN_FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG = 0UL,
      FI_EN_FC_AUDIO_NO_ACTION_LOG = 1UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_REQ_FAILED = 2UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_REQ_PASSED = 3UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_NOT_REQ = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_WriteTestErrorStatus(midw_fi_tcl_e8_Aud_WriteTestErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_WriteTestErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_WriteTestErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_SpeakerType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_SpeakerType();
   enum tenType {
      FI_EN_FC_AUDIO_SPEAKER_UNDEF = 255UL,
      FI_EN_FC_AUDIO_SPEAKER_LF = 0UL,
      FI_EN_FC_AUDIO_SPEAKER_LR = 1UL,
      FI_EN_FC_AUDIO_SPEAKER_RF = 2UL,
      FI_EN_FC_AUDIO_SPEAKER_RR = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_SpeakerType(midw_fi_tcl_e8_Aud_SpeakerType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_SpeakerType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_SpeakerType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_TestToneControl : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_TestToneControl();
   enum tenType {
      FI_EN_FC_AUDIO_TEST_TONE_UNDEF = 255UL,
      FI_EN_FC_AUDIO_TEST_TONE_ON = 0UL,
      FI_EN_FC_AUDIO_TEST_TONE_OFF = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_TestToneControl(midw_fi_tcl_e8_Aud_TestToneControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_TestToneControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_TestToneControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_FreqTestTone : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_FreqTestTone();
   enum tenType {
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_1 = 1UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_2 = 2UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_3 = 3UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_4 = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_FreqTestTone(midw_fi_tcl_e8_Aud_FreqTestTone::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_FreqTestTone();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_FreqTestTone& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_TestRoutineParameter : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_TestRoutineParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_TestRoutineParameter& operator=(const midw_fi_tcl_Aud_TestRoutineParameter& coRef);
   midw_fi_tcl_Aud_TestRoutineParameter(const midw_fi_tcl_Aud_TestRoutineParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Aud_TroubleCode TroubleCode;
   tBool WriteToRM;
   midw_fi_tcl_e8_Aud_MonitoringMode MonitoringMode;
   midw_fi_tcl_e8_Aud_SupervisionControl SupervisionControl;
   virtual ~midw_fi_tcl_Aud_TestRoutineParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_TestRoutineParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_TestRoutineParameterList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_TestRoutineParameterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_TestRoutineParameterList& operator=(const midw_fi_tcl_Aud_TestRoutineParameterList& coRef);
   midw_fi_tcl_Aud_TestRoutineParameterList(const midw_fi_tcl_Aud_TestRoutineParameterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Aud_TestRoutineParameter, std::allocator<midw_fi_tcl_Aud_TestRoutineParameter> > TestRoutineParameterList;
   virtual ~midw_fi_tcl_Aud_TestRoutineParameterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_TestRoutineParameterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_TestTroubleCodeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_TestTroubleCodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_TestTroubleCodeStatus& operator=(const midw_fi_tcl_Aud_TestTroubleCodeStatus& coRef);
   midw_fi_tcl_Aud_TestTroubleCodeStatus(const midw_fi_tcl_Aud_TestTroubleCodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Aud_TroubleCode TroubleCode;
   midw_fi_tcl_e8_Aud_ErrorStatus ErrorStatus;
   midw_fi_tcl_e8_Aud_RoutineStatus RoutineStatus;
   midw_fi_tcl_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite;
   virtual ~midw_fi_tcl_Aud_TestTroubleCodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_TestTroubleCodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_TestTroubleCodeStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_TestTroubleCodeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_TestTroubleCodeStatusList& operator=(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& coRef);
   midw_fi_tcl_Aud_TestTroubleCodeStatusList(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Aud_TestTroubleCodeStatus, std::allocator<midw_fi_tcl_Aud_TestTroubleCodeStatus> > TroubleCodeStatusList;
   virtual ~midw_fi_tcl_Aud_TestTroubleCodeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_TestTroubleCodeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MicrophoneNumber : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MicrophoneNumber();
   enum tenType {
      FI_EN_MIC_1 = 1UL,
      FI_EN_MIC_2 = 2UL,
      FI_EN_MIC_NUMBER_UNDEFINED = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_MicrophoneNumber(midw_fi_tcl_e8_MicrophoneNumber::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MicrophoneNumber();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MicrophoneNumber& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MicrophoneConnectionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MicrophoneConnectionStatus();
   enum tenType {
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OPEN = 0UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT = 1UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OK = 2UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT_TO_BATTERY = 3UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_UNDEFINED = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_MicrophoneConnectionStatus(midw_fi_tcl_e8_MicrophoneConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MicrophoneConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MicrophoneConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MicrophoneDetection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MicrophoneDetection();
   enum tenType {
      FI_EN_MIC_DET_ABSENT = 0UL,
      FI_EN_MIC_DET_PRESENT = 1UL,
      FI_EN_MIC_DET_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_MicrophoneDetection(midw_fi_tcl_e8_MicrophoneDetection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MicrophoneDetection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MicrophoneDetection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MicrophoneConnectionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MicrophoneConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MicrophoneConnectionStatus& operator=(const midw_fi_tcl_MicrophoneConnectionStatus& coRef);
   midw_fi_tcl_MicrophoneConnectionStatus(const midw_fi_tcl_MicrophoneConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MicrophoneNumber e8MicrophoneNumber;
   tU16 u16MicrophoneCurrent;
   midw_fi_tcl_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus;
   midw_fi_tcl_e8_MicrophoneDetection e8MicrophoneDetection;
   virtual ~midw_fi_tcl_MicrophoneConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MicrophoneConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MicrophoneConnectionStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MicrophoneConnectionStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MicrophoneConnectionStatusList& operator=(const midw_fi_tcl_MicrophoneConnectionStatusList& coRef);
   midw_fi_tcl_MicrophoneConnectionStatusList(const midw_fi_tcl_MicrophoneConnectionStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_MicrophoneConnectionStatus, std::allocator<midw_fi_tcl_MicrophoneConnectionStatus> > MicrophoneConnectionStatusList;
   virtual ~midw_fi_tcl_MicrophoneConnectionStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MicrophoneConnectionStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ResourceNo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ResourceNo();
   enum tenType {
      FI_EN_AUDIO_RESOURCE_NOT_DEF = 0UL,
      FI_EN_AUDIO_RESOURCE_LS = 1UL,
      FI_EN_AUDIO_RESOURCE_HP = 2UL,
      FI_EN_AUDIO_LINE_OUT = 17UL,
      FI_EN_AUDIO_RESOURCE_SINK_4 = 4UL,
      FI_EN_AUDIO_RESOURCE_SINK_5 = 5UL,
      FI_EN_AUDIO_RESOURCE_SINK_6 = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_ResourceNo(midw_fi_tcl_e8_ResourceNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ResourceNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ResourceNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioServiceStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioServiceStatus();
   enum tenType {
      FI_EN_REJECTED = 0UL,
      FI_EN_RECEIVED = 1UL,
      FI_EN_PREVIOUS_REQUEST_PENDING = 2UL,
      FI_EN_PROCESSED = 3UL,
      FI_EN_ABORT = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioServiceStatus(midw_fi_tcl_e8_AudioServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_GalaLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_GalaLevel();
   enum tenType {
      FI_EN_AUDIO_GALA_NOT_DEF = 255UL,
      FI_EN_AUDIO_GALA_OFF = 0UL,
      FI_EN_AUDIO_GALA_LEVEL_1 = 1UL,
      FI_EN_AUDIO_GALA_LEVEL_2 = 2UL,
      FI_EN_AUDIO_GALA_LEVEL_3 = 3UL,
      FI_EN_AUDIO_GALA_LEVEL_4 = 4UL,
      FI_EN_AUDIO_GALA_LEVEL_5 = 5UL,
      FI_EN_AUDIO_GALA_LEVEL_6 = 6UL,
      FI_EN_AUDIO_GALA_LEVEL_7 = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_GalaLevel(midw_fi_tcl_e8_GalaLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_GalaLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_GalaLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioChannel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioChannel();
   enum tenType {
      FI_EN_AUDIO_CHANNEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_CHANNEL_EXC = 1UL,
      FI_EN_AUDIO_CHANNEL_MIX = 2UL,
      FI_EN_AUDIO_CHANNEL_MIX2 = 3UL,
      FI_EN_AUDIO_CHANNEL_MIX3 = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioChannel(midw_fi_tcl_e8_AudioChannel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioChannel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioChannel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioVolumeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioVolumeType();
   enum tenType {
      FI_EN_AUDIO_VAL_TYPE_NOT_DEF = 255UL,
      FI_EN_AUDIO_VAL_TYPE_ABS = 1UL,
      FI_EN_AUDIO_VAL_TYPE_INC = 2UL,
      FI_EN_AUDIO_VAL_TYPE_DEC = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioVolumeType(midw_fi_tcl_e8_AudioVolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioVolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioVolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioSoundType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioSoundType();
   enum tenType {
      FI_EN_AUDIO_SND_TYPE_NOT_DEF = 255UL,
      FI_EN_AUDIO_SND_TYPE_ABS = 1UL,
      FI_EN_AUDIO_SND_TYPE_INC = 2UL,
      FI_EN_AUDIO_SND_TYPE_DEC = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioSoundType(midw_fi_tcl_e8_AudioSoundType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioSoundType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioSoundType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioBeepType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioBeepType();
   enum tenType {
      FI_EN_AUDIO_BEEP_WARN_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_ERROR = 1UL,
      FI_EN_AUDIO_BEEP_ROGER = 2UL,
      FI_EN_AUDIO_BEEP_WARN = 3UL,
      FI_EN_AUDIO_BEEP_CLICK = 4UL,
      FI_EN_AUDIO_BEEP_POI = 5UL,
      FI_EN_AUDIO_BEEP_SDS_END = 6UL,
      FI_EN_AUDIO_BEEP_SMS_INCOMING = 7UL,
      FI_EN_AUDIO_BEEP_SMS_SEND = 8UL,
      FI_EN_AUDIO_BEEP_URGENT = 9UL,
      FI_EN_AUDIO_BEEP_SPEED_WARN = 10UL,
      FI_EN_AUDIO_BEEP_CURVE_WARN = 11UL,
      FI_EN_AUDIO_BEEP_AVM_OPERATION = 12UL,
      FI_EN_AUDIO_BEEP_AVM_ERROR = 13UL,
      FI_EN_AUDIO_BEEP_SPEED_HINT = 14UL,
      FI_EN_AUDIO_BEEP_CURVE_HINT = 15UL,
      FI_EN_AUDIO_BEEP_IPA_NOSOUND = 16UL,
      FI_EN_AUDIO_BEEP_IPA_3 = 17UL,
      FI_EN_AUDIO_BEEP_IPA_7 = 18UL,
      FI_EN_AUDIO_BEEP_IPA_8 = 19UL,
      FI_EN_AUDIO_BEEP_IPA_9 = 20UL,
      FI_EN_AUDIO_BEEP_IPA_10 = 21UL,
      FI_EN_AUDIO_BEEP_IPA_11 = 22UL,
      FI_EN_AUDIO_BEEP_IPA_STOP_SOUND = 23UL,
      FI_EN_AUDIO_BEEP_SDS_START = 24UL,
      FI_EN_AUDIO_BEEP_IPA_4 = 25UL,
      FI_EN_AUDIO_BEEP_IPA_5 = 26UL,
      FI_EN_AUDIO_BEEP_IPA_6 = 27UL,
      FI_EN_AUDIO_BEEP_GST_01 = 65UL,
      FI_EN_AUDIO_BEEP_GST_02 = 66UL,
      FI_EN_AUDIO_BEEP_GST_03 = 67UL,
      FI_EN_AUDIO_BEEP_GST_04 = 68UL,
      FI_EN_AUDIO_BEEP_GST_05 = 69UL,
      FI_EN_AUDIO_BEEP_GST_06 = 70UL,
      FI_EN_AUDIO_BEEP_GST_07 = 71UL,
      FI_EN_AUDIO_BEEP_GST_08 = 72UL,
      FI_EN_AUDIO_BEEP_GST_09 = 73UL,
      FI_EN_AUDIO_BEEP_GST_10 = 74UL,
      FI_EN_AUDIO_BEEP_GST_11 = 75UL,
      FI_EN_AUDIO_BEEP_GST_12 = 76UL,
      FI_EN_AUDIO_BEEP_GST_13 = 77UL,
      FI_EN_AUDIO_BEEP_GST_14 = 78UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioBeepType(midw_fi_tcl_e8_AudioBeepType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioBeepType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioBeepType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioBeepStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioBeepStatus();
   enum tenType {
      FI_EN_AUDIO_BEEP_STATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_STATUS_ON = 1UL,
      FI_EN_AUDIO_BEEP_STATUS_OFF = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioBeepStatus(midw_fi_tcl_e8_AudioBeepStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioBeepStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioBeepStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VolumeMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VolumeMode();
   enum tenType {
      FI_EN_AUDIO_VOLMODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_VOLMODE_NORMAL = 0UL,
      FI_EN_AUDIO_VOLMODE_SETUP_ONVOL = 1UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TEL = 2UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TIM = 3UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TA = 4UL,
      FI_EN_AUDIO_VOLMODE_SETUP_BEEPVOL = 5UL,
      FI_EN_AUDIO_VOLMODE_SETUP_DIAGVOL = 6UL,
      FI_EN_AUDIO_VOLMODE_NAV_ANNOUCEMENT = 7UL,
      FI_EN_AUDIO_VOLMODE_SETUP_NAV_VOL = 8UL,
      FI_EN_AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL = 9UL,
      FI_EN_AUDIO_VOLMODE_SETUP_PDC_ATTENUATION_VOL = 10UL,
      FI_EN_AUDIO_VOLMODE_SETUP_SDS = 11UL
   };
   tenType enType;

   midw_fi_tcl_e8_VolumeMode(midw_fi_tcl_e8_VolumeMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VolumeMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VolumeMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SourceNo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SourceNo();
   enum tenType {
      FI_EN_AUDIO_SRC_NOT_DEF = 255UL,
      FI_EN_AUDIO_SRC_NO = 0UL,
      FI_EN_AUDIO_SRC_FM = 1UL,
      FI_EN_AUDIO_SRC_AM = 2UL,
      FI_EN_AUDIO_SRC_CD = 3UL,
      FI_EN_AUDIO_SRC_CDC = 4UL,
      FI_EN_AUDIO_SRC_CC = 5UL,
      FI_EN_AUDIO_SRC_AUX = 6UL,
      FI_EN_AUDIO_SRC_TEL = 7UL,
      FI_EN_AUDIO_SRC_MD = 8UL,
      FI_EN_AUDIO_SRC_MP3 = 9UL,
      FI_EN_AUDIO_SRC_TA = 10UL,
      FI_EN_AUDIO_SRC_TV = 11UL,
      FI_EN_AUDIO_SRC_TIM = 12UL,
      FI_EN_AUDIO_SRC_NAVI = 13UL,
      FI_EN_AUDIO_SRC_NO1 = 14UL,
      FI_EN_AUDIO_SRC_FM2 = 15UL,
      FI_EN_AUDIO_SRC_AM2 = 16UL,
      FI_EN_AUDIO_SRC_TA2 = 17UL,
      FI_EN_AUDIO_SRC_DAB = 18UL,
      FI_EN_AUDIO_SRC_DAB_TA = 19UL,
      FI_EN_AUDIO_SRC_CDC2 = 20UL,
      FI_EN_AUDIO_SRC_GSM = 21UL,
      FI_EN_AUDIO_SRC_VRU = 22UL,
      FI_EN_AUDIO_SRC_MICROPHONE = 23UL,
      FI_EN_AUDIO_SRC_AUX2 = 24UL,
      FI_EN_AUDIO_SRC_VR2 = 25UL,
      FI_EN_AUDIO_SRC_AUX_FAKRA = 26UL,
      FI_EN_AUDIO_SRC_XMTUN = 27UL,
      FI_EN_AUDIO_SRC_IPOD = 28UL,
      FI_EN_AUDIO_SRC_DOV = 29UL,
      FI_EN_AUDIO_SRC_DOV_TEST = 30UL,
      FI_EN_AUDIO_SRC_DAB_SRV_FOLLOW = 31UL,
      FI_EN_AUDIO_SRC_PANDORA = 32UL,
      FI_EN_AUDIO_SRC_SMS = 33UL,
      FI_EN_AUDIO_SRC_AUX3 = 34UL
   };
   tenType enType;

   midw_fi_tcl_e8_SourceNo(midw_fi_tcl_e8_SourceNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SourceNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SourceNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RouteNo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RouteNo();
   enum tenType {
      FI_EN_NOSOURCE = 0UL,
      FI_EN_AUDIO_SNK_NOT_DEF = 255UL,
      FI_EN_TUN1 = 1UL,
      FI_EN_TUN2 = 2UL,
      FI_EN_DAB = 3UL,
      FI_EN_MEDIA = 4UL,
      FI_EN_CDA = 5UL,
      FI_EN_AUX = 6UL,
      FI_EN_PHONE1 = 7UL,
      FI_EN_PHONE2 = 8UL,
      FI_EN_ATP_MEMO = 9UL,
      FI_EN_XM = 10UL,
      FI_EN_NAVI = 11UL,
      FI_EN_AUX2 = 12UL,
      FI_EN_BTAUDIO = 13UL,
      FI_EN_PHONE3 = 14UL,
      FI_EN_PHONE4 = 15UL,
      FI_EN_CUE1 = 17UL,
      FI_EN_CUE2 = 20UL,
      FI_EN_IPA1 = 21UL,
      FI_EN_CUE3 = 22UL,
      FI_EN_CUE4 = 23UL,
      FI_EN_SOUNDGENERATOR1 = 32UL,
      FI_EN_SOUNDGENERATOR2 = 33UL,
      FI_EN_SOUNDSAMPLEPLAYER = 34UL,
      FI_EN_TV = 64UL,
      FI_EN_DVD = 65UL,
      FI_EN_EXT_MEDIA1 = 66UL,
      FI_EN_MIC1 = 80UL,
      FI_EN_MIC2 = 81UL,
      FI_EN_AUX3 = 83UL
   };
   tenType enType;

   midw_fi_tcl_e8_RouteNo(midw_fi_tcl_e8_RouteNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RouteNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RouteNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Sound : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Sound();
   enum tenType {
      FI_EN_AUDIO_SOUND_NOT_DEF = 255UL,
      FI_EN_AUDIO_SOUND_VOLUME = 0UL,
      FI_EN_AUDIO_SOUND_BASS = 1UL,
      FI_EN_AUDIO_SOUND_TREBLE = 2UL,
      FI_EN_AUDIO_SOUND_BALANCE = 3UL,
      FI_EN_AUDIO_SOUND_FADER = 4UL,
      FI_EN_AUDIO_SOUND_LOUDNESS = 5UL,
      FI_EN_AUDIO_SOUND_SUBW = 6UL,
      FI_EN_AUDIO_SOUND_MID = 7UL,
      FI_EN_AUDIO_SOUND_HPAS = 8UL,
      FI_EN_AUDIO_SOUND_GALA = 9UL,
      FI_EN_AUDIO_SOUND_AUDPILOT = 10UL,
      FI_EN_AUDIO_SOUND_VOLOFFSET = 11UL,
      FI_EN_AUDIO_SOUND_DYNCOMP = 12UL,
      FI_EN_AUDIO_SOUND_OPTIMIZATION = 13UL,
      FI_EN_AUDIO_SOUND_PDC_ATTENUATION_LEVEL = 14UL,
      FI_EN_AUDIO_SOUND_EQ_PRESET = 15UL
   };
   tenType enType;

   midw_fi_tcl_e8_Sound(midw_fi_tcl_e8_Sound::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Sound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Sound& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MemStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MemStatus();
   enum tenType {
      FI_EN_AUDIO_MEMSTATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_MEMSTATUS_SUCCESS = 0UL,
      FI_EN_AUDIO_MEMSTATUS_FAIL = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_MemStatus(midw_fi_tcl_e8_MemStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MemStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_FaderStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_FaderStatus();
   enum tenType {
      FI_EN_AUDIO_FADERSTATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_FADERSTATUS_INACTIVE = 0UL,
      FI_EN_AUDIO_FADERSTATUS_ACTIVE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_FaderStatus(midw_fi_tcl_e8_FaderStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_FaderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_FaderStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DynCompression : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DynCompression();
   enum tenType {
      FI_EN_AUDIO_DYN_COMPRESSION_NOT_DEF = 255UL,
      FI_EN_AUDIO_DYN_COMPRESSION_OFF = 0UL,
      FI_EN_AUDIO_DYN_COMPRESSION_ON = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DynCompression(midw_fi_tcl_e8_DynCompression::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DynCompression();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DynCompression& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Optimization : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Optimization();
   enum tenType {
      FI_EN_AUDIO_OPTIMIZATION_NOT_DEF = 255UL,
      FI_EN_AUDIO_OPTIMIZATION_OFF = 0UL,
      FI_EN_AUDIO_OPTIMIZATION_LEFT = 1UL,
      FI_EN_AUDIO_OPTIMIZATION_RIGHT = 2UL,
      FI_EN_AUDIO_OPTIMIZATION_ALL = 3UL,
      FI_EN_AUDIO_OPTIMIZATION_DRIVER = 4UL,
      FI_EN_AUDIO_OPTIMIZATION_FRONT_PASSENGER = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_Optimization(midw_fi_tcl_e8_Optimization::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Optimization();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Optimization& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EquPresets : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EquPresets();
   enum tenType {
      FI_EN_AUDIO_EQU_PRESET_NOT_DEF = 255UL,
      FI_EN_AUDIO_EQU_PRESET_0 = 0UL,
      FI_EN_AUDIO_EQU_PRESET_1 = 1UL,
      FI_EN_AUDIO_EQU_PRESET_2 = 2UL,
      FI_EN_AUDIO_EQU_PRESET_3 = 3UL,
      FI_EN_AUDIO_EQU_PRESET_4 = 4UL,
      FI_EN_AUDIO_EQU_PRESET_5 = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_EquPresets(midw_fi_tcl_e8_EquPresets::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EquPresets();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EquPresets& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagAudMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagAudMode();
   enum tenType {
      FI_EN_AUDIO_DIAG_AUD_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_OFF = 0UL,
      FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_ON = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagAudMode(midw_fi_tcl_e8_DiagAudMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagAudMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagAudMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_GenericDiagAudMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_GenericDiagAudMode();
   enum tenType {
      FI_EN_NOT_DEFINED = 255UL,
      FI_EN_NORMAL_MODE = 0UL,
      FI_EN_FEATURE_OFF = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_GenericDiagAudMode(midw_fi_tcl_e8_GenericDiagAudMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_GenericDiagAudMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_GenericDiagAudMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AuxInLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AuxInLevel();
   enum tenType {
      FI_EN_AUDIO_AUX_IN_LEVEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_1 = 1UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_2 = 2UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_3 = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AuxInLevel(midw_fi_tcl_e8_AuxInLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AuxInLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AuxInLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BeepLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BeepLevel();
   enum tenType {
      FI_EN_AUDIO_BEEP_LEVEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_LEVEL_1 = 1UL,
      FI_EN_AUDIO_BEEP_LEVEL_2 = 2UL,
      FI_EN_AUDIO_BEEP_LEVEL_3 = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_BeepLevel(midw_fi_tcl_e8_BeepLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BeepLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BeepLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Rear_Mute : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Rear_Mute();
   enum tenType {
      FI_EN_AUDIO_REAR_MUTE_NOT_DEF = 255UL,
      FI_EN_REAR_MUTE_OFF = 0UL,
      FI_EN_REAR_MUTE_ON = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Rear_Mute(midw_fi_tcl_e8_Rear_Mute::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Rear_Mute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Rear_Mute& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Geometry_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Geometry_Mode();
   enum tenType {
      FI_EN_AUDIO_GEOMETRY_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_GEOMETRY_MODE_MANUAL = 0UL,
      FI_EN_AUDIO_GEOMETRY_MODE_CHILD_SLEEP = 1UL,
      FI_EN_AUDIO_GEOMETRY_MODE_ALL_CAR = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Geometry_Mode(midw_fi_tcl_e8_Geometry_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Geometry_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Geometry_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PDCAttenuation : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PDCAttenuation();
   enum tenType {
      FI_EN_AUDIO_PDC_COMMAND_NOT_DEF = 255UL,
      FI_EN_AUDIO_PDC_COMMAND_START = 1UL,
      FI_EN_AUDIO_PDC_COMMAND_STOP = 2UL,
      FI_EN_AUDIO_PDC_COMMAND_BREAK = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_PDCAttenuation(midw_fi_tcl_e8_PDCAttenuation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PDCAttenuation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PDCAttenuation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VolumeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VolumeType();
   enum tenType {
      FI_EN_INCREMENT = 1UL,
      FI_EN_DB_LEVEL = 2UL,
      FI_EN_DBV_LEVEL = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_VolumeType(midw_fi_tcl_e8_VolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Volume : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Volume();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Volume& operator=(const midw_fi_tcl_Volume& coRef);
   midw_fi_tcl_Volume(const midw_fi_tcl_Volume& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeType e8VolType;
   tS16 s16Volume;
   virtual ~midw_fi_tcl_Volume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Volume& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b8_ChannelSelect : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b8_ChannelSelect();

   enum {
      FI_C_U8_BIT_CHANNEL_LF = 0x1UL,
      FI_C_U8_BIT_CHANNEL_RF = 0x2UL,
      FI_C_U8_BIT_CHANNEL_LR = 0x4UL,
      FI_C_U8_BIT_CHANNEL_RR = 0x8UL,
      FI_C_U8_BIT_CHANNEL_CENT = 0x10UL,
      FI_C_U8_BIT_CHANNEL_SUB = 0x20UL
   };
   tBool bCHANNEL_LF() const {return (u8Value & FI_C_U8_BIT_CHANNEL_LF) != 0; }
   tVoid vSetCHANNEL_LF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_LF):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_LF)); }
   tBool bCHANNEL_RF() const {return (u8Value & FI_C_U8_BIT_CHANNEL_RF) != 0; }
   tVoid vSetCHANNEL_RF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_RF):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_RF)); }
   tBool bCHANNEL_LR() const {return (u8Value & FI_C_U8_BIT_CHANNEL_LR) != 0; }
   tVoid vSetCHANNEL_LR(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_LR):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_LR)); }
   tBool bCHANNEL_RR() const {return (u8Value & FI_C_U8_BIT_CHANNEL_RR) != 0; }
   tVoid vSetCHANNEL_RR(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_RR):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_RR)); }
   tBool bCHANNEL_CENT() const {return (u8Value & FI_C_U8_BIT_CHANNEL_CENT) != 0; }
   tVoid vSetCHANNEL_CENT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_CENT):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_CENT)); }
   tBool bCHANNEL_SUB() const {return (u8Value & FI_C_U8_BIT_CHANNEL_SUB) != 0; }
   tVoid vSetCHANNEL_SUB(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_SUB):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_SUB)); }
   struct rBitValues {
      tBool CHANNEL_LF:1;
      tBool CHANNEL_RF:1;
      tBool CHANNEL_LR:1;
      tBool CHANNEL_RR:1;
      tBool CHANNEL_CENT:1;
      tBool CHANNEL_SUB:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b8_ChannelSelect();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b8_ChannelSelect& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_Beep_Vol_Type : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_Beep_Vol_Type();
   enum tenType {
      FI_EN_FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_BEEP_VOL_TYPE_USER_SPECIFIC = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_Beep_Vol_Type(midw_fi_tcl_e8_Aud_Beep_Vol_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_Beep_Vol_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_Beep_Vol_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_BeepConfig : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_BeepConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_BeepConfig& operator=(const midw_fi_tcl_BeepConfig& coRef);
   midw_fi_tcl_BeepConfig(const midw_fi_tcl_BeepConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Aud_Beep_Vol_Type e8VolType;
   tS16 s16VoldB;
   virtual ~midw_fi_tcl_BeepConfig();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_BeepConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioDevice_Availability : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioDevice_Availability();
   enum tenType {
      FI_EN_AUDIODEVICE_NOTAVAILABLE = 0UL,
      FI_EN_AUDIODEVICE_AVAILABLE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioDevice_Availability(midw_fi_tcl_e8_AudioDevice_Availability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioDevice_Availability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioDevice_Availability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_State : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_State();
   enum tenType {
      FI_EN_CUESTATE_NOT_DEF = 255UL,
      FI_EN_CUESTATE_START = 1UL,
      FI_EN_CUESTATE_STOP = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_State(midw_fi_tcl_e8_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_VolumeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_VolumeType();
   enum tenType {
      FI_EN_VOLUME_NOT_DEF = 255UL,
      FI_EN_VOLUME_ONVOL = 0UL,
      FI_EN_VOLUME_ENTERTAINMENT = 1UL,
      FI_EN_VOLUME_PHONE = 2UL,
      FI_EN_VOLUME_PHONE1 = 3UL,
      FI_EN_VOLUME_PHONE2 = 4UL,
      FI_EN_VOLUME_PHONE3 = 5UL,
      FI_EN_VOLUME_PHONE4 = 6UL,
      FI_EN_VOLUME_PHONE5 = 7UL,
      FI_EN_VOLUME_RINGTONE = 8UL,
      FI_EN_VOLUME_NAVIGATION = 9UL,
      FI_EN_VOLUME_SDS = 10UL,
      FI_EN_VOLUME_TASETUP = 11UL,
      FI_EN_VOLUME_VDA_PHONE = 12UL,
      FI_EN_VOLUME_BT_PHONE = 13UL,
      FI_EN_VOLUME_BEEP = 14UL,
      FI_EN_VOLUME_SPI_INFO = 15UL,
      FI_EN_VOLUME_PHONE6 = 16UL,
      FI_EN_VOLUME_PHONE7 = 17UL,
      FI_EN_VOLUME_PHONE8 = 18UL,
      FI_EN_VOLUME_PHONE9 = 19UL,
      FI_EN_VOLUME_PHONE10 = 20UL,
      FI_EN_VOLUME_CARPLAY_PHONE = 21UL,
      FI_EN_VOLUME_TCU_ECALL = 22UL,
      FI_EN_VOLUME_TCU_SERVICECALL = 23UL,
      FI_EN_VOLUME_TCU_TTS = 24UL,
      FI_EN_VOLUME_SPI_ALERT = 25UL,
      FI_EN_VOLUME_ONVOL_SPI_INFO = 26UL,
      FI_EN_VOLUME_AUX3 = 27UL,
      FI_EN_VOLUME_PHONE_WAIT = 28UL,
      FI_EN_VOLUME_PARK_ASSIST = 29UL,
      FI_EN_VOLUME_SDS_BARGEIN = 30UL,
      FI_EN_VOLUME_INTERCOM = 31UL,
      FI_EN_VOLUME_WX_ALERT = 32UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_VolumeType(midw_fi_tcl_e8_Aud_VolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_VolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_VolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_VolumeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_VolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_VolumeStatus& operator=(const midw_fi_tcl_Aud_VolumeStatus& coRef);
   midw_fi_tcl_Aud_VolumeStatus(const midw_fi_tcl_Aud_VolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Aud_VolumeType AudVolumeType;
   tU8 Volume;
   virtual ~midw_fi_tcl_Aud_VolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_VolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_VolumeStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_VolumeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_VolumeStatusList& operator=(const midw_fi_tcl_Aud_VolumeStatusList& coRef);
   midw_fi_tcl_Aud_VolumeStatusList(const midw_fi_tcl_Aud_VolumeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Aud_VolumeStatus, std::allocator<midw_fi_tcl_Aud_VolumeStatus> > VolumeStatusList;
   virtual ~midw_fi_tcl_Aud_VolumeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_VolumeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BTAudioInLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BTAudioInLevel();
   enum tenType {
      FI_EN_AUDIO_BT_IN_LEVEL_1 = 0UL,
      FI_EN_AUDIO_BT_IN_LEVEL_2 = 1UL,
      FI_EN_AUDIO_BT_IN_LEVEL_3 = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_BTAudioInLevel(midw_fi_tcl_e8_BTAudioInLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BTAudioInLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BTAudioInLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_EDType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_EDType();
   enum tenType {
      FI_EN_ED_NOT_DEF = 255UL,
      FI_EN_ED_GALA_GAIN = 0UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_FM = 1UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_AM = 2UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_DAB = 3UL,
      FI_EN_ED_INPUTGAINOFFSET_TA_TUNER_FM = 4UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_MFP = 5UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_CDA = 6UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_AUXADAPTER = 7UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_BTDEVICE = 8UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_AUXIN = 9UL,
      FI_EN_ED_INPUTGAINOFFSET_PHONE_VOICE = 10UL,
      FI_EN_ED_INPUTGAINOFFSET_PHONE_RINGER_OB = 11UL,
      FI_EN_ED_INPUTGAINOFFSET_HFP = 12UL,
      FI_EN_ED_INPUTGAINOFFSET_TONE_BEEP = 13UL,
      FI_EN_ED_INPUTGAINOFFSET_TONE_TOUCHSCREEN = 14UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_EDType(midw_fi_tcl_e8_Aud_EDType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_EDType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_EDType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_EDStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_EDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_EDStatus& operator=(const midw_fi_tcl_Aud_EDStatus& coRef);
   midw_fi_tcl_Aud_EDStatus(const midw_fi_tcl_Aud_EDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Aud_EDType AudEDType;
   tS32 EDValue;
   virtual ~midw_fi_tcl_Aud_EDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_EDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_EDStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_EDStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_EDStatusList& operator=(const midw_fi_tcl_Aud_EDStatusList& coRef);
   midw_fi_tcl_Aud_EDStatusList(const midw_fi_tcl_Aud_EDStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Aud_EDStatus, std::allocator<midw_fi_tcl_Aud_EDStatus> > EDStatusList;
   virtual ~midw_fi_tcl_Aud_EDStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_EDStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SurroundSetting : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SurroundSetting();
   enum tenType {
      FI_EN_AUDIO_SURROUND_NOT_DEF = 255UL,
      FI_EN_AUDIO_SURROUND_OFF = 0UL,
      FI_EN_AUDIO_SURROUND_DOLBY_PROLOGIC = 1UL,
      FI_EN_AUDIO_SURROUND_AC3 = 2UL,
      FI_EN_AUDIO_SURROUND_DTS = 3UL,
      FI_EN_AUDIO_SURROUND_MAX = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_SurroundSetting(midw_fi_tcl_e8_SurroundSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SurroundSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SurroundSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AmpTemperatureLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AmpTemperatureLevel();
   enum tenType {
      FI_EN_THERMAL_WARNING_UNKNOWN = 255UL,
      FI_EN_THERMAL_WARNING_STEP_0 = 0UL,
      FI_EN_THERMAL_WARNING_STEP_1 = 1UL,
      FI_EN_THERMAL_WARNING_STEP_2 = 2UL,
      FI_EN_THERMAL_WARNING_STEP_3 = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AmpTemperatureLevel(midw_fi_tcl_e8_AmpTemperatureLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AmpTemperatureLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AmpTemperatureLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagMode();
   enum tenType {
      FI_EN_OFF = 1UL,
      FI_EN_UNQUALIFIED = 2UL,
      FI_EN_QUALIFIED = 3UL,
      FI_EN_CONTINOUS = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagMode(midw_fi_tcl_e8_DiagMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiagState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiagState();
   enum tenType {
      FI_EN_OFF = 1UL,
      FI_EN_DC_STARTED = 2UL,
      FI_EN_AC_STARTED = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiagState(midw_fi_tcl_e8_DiagState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiagState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiagState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Aud_DataId : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Aud_DataId();
   enum tenType {
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF = 1UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RF = 2UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LR = 3UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RR = 4UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_CE = 5UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_SUB = 6UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_LF = 7UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_RF = 8UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_LR = 9UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_RR = 10UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_CE = 11UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_SUB = 12UL
   };
   tenType enType;

   midw_fi_tcl_e8_Aud_DataId(midw_fi_tcl_e8_Aud_DataId::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Aud_DataId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Aud_DataId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32_MeasurementResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32_MeasurementResult();

   enum {
      FI_C_U32_BIT_SHORT_TO_GROUND_OK = 0x1UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_ERROR = 0x2UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED = 0x4UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK = 0x8UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_OK = 0x10UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR = 0x20UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED = 0x40UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK = 0x80UL,
      FI_C_U32_BIT_SHORTED_LOAD_OK = 0x100UL,
      FI_C_U32_BIT_SHORTED_LOAD_ERROR = 0x200UL,
      FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED = 0x400UL,
      FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK = 0x800UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK = 0x1000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR = 0x2000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED = 0x4000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK = 0x8000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK = 0x10000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR = 0x20000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED = 0x40000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK = 0x80000UL,
      FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED = 0x4000000UL,
      FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED = 0x8000000UL,
      FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED = 0x10000000UL,
      FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED = 0x20000000UL,
      FI_C_U32_BIT_WOOFER_AVAILABILITY = 0x40000000UL,
      FI_C_U32_BIT_TWEETER_AVAILABILITY = 0x80000000UL
   };
   tBool bSHORT_TO_GROUND_OK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_OK) != 0; }
   tVoid vSetSHORT_TO_GROUND_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_OK)); }
   tBool bSHORT_TO_GROUND_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_ERROR) != 0; }
   tVoid vSetSHORT_TO_GROUND_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_ERROR)); }
   tBool bSHORT_TO_GROUND_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED) != 0; }
   tVoid vSetSHORT_TO_GROUND_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED)); }
   tBool bSHORT_TO_GROUND_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK) != 0; }
   tVoid vSetSHORT_TO_GROUND_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK)); }
   tBool bSHORT_TO_BATTERY_OK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_OK) != 0; }
   tVoid vSetSHORT_TO_BATTERY_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_OK)); }
   tBool bSHORT_TO_BATTERY_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR) != 0; }
   tVoid vSetSHORT_TO_BATTERY_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR)); }
   tBool bSHORT_TO_BATTERY_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED) != 0; }
   tVoid vSetSHORT_TO_BATTERY_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED)); }
   tBool bSHORT_TO_BATTERY_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK) != 0; }
   tVoid vSetSHORT_TO_BATTERY_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK)); }
   tBool bSHORTED_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_OK) != 0; }
   tVoid vSetSHORTED_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_OK)); }
   tBool bSHORTED_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_ERROR) != 0; }
   tVoid vSetSHORTED_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_ERROR)); }
   tBool bSHORTED_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED) != 0; }
   tVoid vSetSHORTED_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED)); }
   tBool bSHORTED_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetSHORTED_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK)); }
   tBool bWOOFER_OPEN_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK)); }
   tBool bWOOFER_OPEN_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR)); }
   tBool bWOOFER_OPEN_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED)); }
   tBool bWOOFER_OPEN_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK)); }
   tBool bTWEETER_OPEN_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK)); }
   tBool bTWEETER_OPEN_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR)); }
   tBool bTWEETER_OPEN_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED)); }
   tBool bTWEETER_OPEN_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK)); }
   tBool bDC_DIAGMODE_UNQUALIFIED() const {return (u32Value & FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED) != 0; }
   tVoid vSetDC_DIAGMODE_UNQUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED)); }
   tBool bDC_DIAGMODE_QUALIFIED() const {return (u32Value & FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED) != 0; }
   tVoid vSetDC_DIAGMODE_QUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED)); }
   tBool bAC_DIAGMODE_UNQUALIFIED() const {return (u32Value & FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED) != 0; }
   tVoid vSetAC_DIAGMODE_UNQUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED)); }
   tBool bAC_DIAGMODE_QUALIFIED() const {return (u32Value & FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED) != 0; }
   tVoid vSetAC_DIAGMODE_QUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED)); }
   tBool bWOOFER_AVAILABILITY() const {return (u32Value & FI_C_U32_BIT_WOOFER_AVAILABILITY) != 0; }
   tVoid vSetWOOFER_AVAILABILITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_AVAILABILITY):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_AVAILABILITY)); }
   tBool bTWEETER_AVAILABILITY() const {return (u32Value & FI_C_U32_BIT_TWEETER_AVAILABILITY) != 0; }
   tVoid vSetTWEETER_AVAILABILITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_AVAILABILITY):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_AVAILABILITY)); }
   struct rBitValues {
      tBool SHORT_TO_GROUND_OK:1;
      tBool SHORT_TO_GROUND_ERROR:1;
      tBool SHORT_TO_GROUND_NOT_TESTED:1;
      tBool SHORT_TO_GROUND_CONDITION_NOK:1;
      tBool SHORT_TO_BATTERY_OK:1;
      tBool SHORT_TO_BATTERY_ERROR:1;
      tBool SHORT_TO_BATTERY_NOT_TESTED:1;
      tBool SHORT_TO_BATTERY_CONDITION_NOK:1;
      tBool SHORTED_LOAD_OK:1;
      tBool SHORTED_LOAD_ERROR:1;
      tBool SHORTED_LOAD_NOT_TESTED:1;
      tBool SHORTED_LOAD_CONDITION_NOK:1;
      tBool WOOFER_OPEN_LOAD_OK:1;
      tBool WOOFER_OPEN_LOAD_ERROR:1;
      tBool WOOFER_OPEN_LOAD_NOT_TESTED:1;
      tBool WOOFER_OPEN_LOAD_CONDITION_NOK:1;
      tBool TWEETER_OPEN_LOAD_OK:1;
      tBool TWEETER_OPEN_LOAD_ERROR:1;
      tBool TWEETER_OPEN_LOAD_NOT_TESTED:1;
      tBool TWEETER_OPEN_LOAD_CONDITION_NOK:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool DC_DIAGMODE_UNQUALIFIED:1;
      tBool DC_DIAGMODE_QUALIFIED:1;
      tBool AC_DIAGMODE_UNQUALIFIED:1;
      tBool AC_DIAGMODE_QUALIFIED:1;
      tBool WOOFER_AVAILABILITY:1;
      tBool TWEETER_AVAILABILITY:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32_MeasurementResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32_MeasurementResult& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Aud_MeasurementResultItem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Aud_MeasurementResultItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Aud_MeasurementResultItem& operator=(const midw_fi_tcl_Aud_MeasurementResultItem& coRef);
   midw_fi_tcl_Aud_MeasurementResultItem(const midw_fi_tcl_Aud_MeasurementResultItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Aud_DataId u8DataId;
   midw_fi_tcl_b32_MeasurementResult b32Result;
   virtual ~midw_fi_tcl_Aud_MeasurementResultItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Aud_MeasurementResultItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VolumeLock : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VolumeLock();
   enum tenType {
      FI_EN_AUDIO_VOLUME_LOCK_NOT_DEF = 255UL,
      FI_EN_AUDIO_VOLUME_LOCK_OFF = 0UL,
      FI_EN_AUDIO_VOLUME_LOCK_TOTAL = 1UL,
      FI_EN_AUDIO_VOLUME_LOCK_INCREASING = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_VolumeLock(midw_fi_tcl_e8_VolumeLock::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VolumeLock();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VolumeLock& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Requester : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Requester();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HMI = 1UL,
      FI_EN_AUDIOROUTINGMANAGER = 2UL,
      FI_EN_TEMPERATUREHANDLER = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_Requester(midw_fi_tcl_e8_Requester::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Requester();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Requester& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_RoomEffect : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_RoomEffect();
   enum tenType {
      FI_EN_AUDIO_ROOM_EFFECT_NOT_DEF = 255UL,
      FI_EN_AUDIO_ROOM_EFFECT_0 = 0UL,
      FI_EN_AUDIO_ROOM_EFFECT_1 = 1UL,
      FI_EN_AUDIO_ROOM_EFFECT_2 = 2UL,
      FI_EN_AUDIO_ROOM_EFFECT_3 = 3UL,
      FI_EN_AUDIO_ROOM_EFFECT_4 = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_RoomEffect(midw_fi_tcl_e8_RoomEffect::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_RoomEffect();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_RoomEffect& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudDiagDefSetPhase : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudDiagDefSetPhase();
   enum tenType {
      FI_EN_AUDIO_DIAGDEFSET_NOT_DEF = 255UL,
      FI_EN_AUDIO_DIAGDEFSET_PREPARE = 1UL,
      FI_EN_AUDIO_DIAGDEFSET_SET = 2UL,
      FI_EN_AUDIO_DIAGDEFSET_FINISH = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudDiagDefSetPhase(midw_fi_tcl_e8_AudDiagDefSetPhase::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudDiagDefSetPhase();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudDiagDefSetPhase& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioMode();
   enum tenType {
      FI_EN_AUDIO_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_MODE_BYPASS = 1UL,
      FI_EN_AUDIO_MODE_CLASSIC = 2UL,
      FI_EN_AUDIO_MODE_AUDITORIUM = 3UL,
      FI_EN_AUDIO_MODE_PREMIUM_1 = 4UL,
      FI_EN_AUDIO_MODE_PREMIUM_2 = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioMode(midw_fi_tcl_e8_AudioMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ADAS_UPA_SoundType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ADAS_UPA_SoundType();
   enum tenType {
      FI_EN_ADAS_UPA_SOUND_UNDEF = 255UL,
      FI_EN_ADAS_UPA_SOUND_BIP = 1UL,
      FI_EN_ADAS_UPA_SOUND_CORDE = 2UL,
      FI_EN_ADAS_UPA_SOUND_SONAR = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_ADAS_UPA_SoundType(midw_fi_tcl_e8_ADAS_UPA_SoundType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ADAS_UPA_SoundType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ADAS_UPA_SoundType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ADAS_ParkAssist_Volume : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ADAS_ParkAssist_Volume();
   enum tenType {
      FI_EN_ADAS_PA_VOL_NO_SOUND = 0UL,
      FI_EN_ADAS_PA_VOL_LEVEL_1 = 1UL,
      FI_EN_ADAS_PA_VOL_LEVEL_2 = 2UL,
      FI_EN_ADAS_PA_VOL_LEVEL_3 = 3UL,
      FI_EN_ADAS_PA_VOL_LEVEL_4 = 4UL,
      FI_EN_ADAS_PA_VOL_LEVEL_5 = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_ADAS_ParkAssist_Volume(midw_fi_tcl_e8_ADAS_ParkAssist_Volume::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ADAS_ParkAssist_Volume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ADAS_ParkAssist_Volume& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ADAS_LDW_UserVolume : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ADAS_LDW_UserVolume();
   enum tenType {
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID = 0UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_1 = 1UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_2 = 2UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_3 = 3UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_4 = 4UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_5 = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_ADAS_LDW_UserVolume(midw_fi_tcl_e8_ADAS_LDW_UserVolume::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ADAS_LDW_UserVolume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ADAS_LDW_UserVolume& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ADAS_Setting_Sound : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ADAS_Setting_Sound();
   enum tenType {
      FI_EN_ADAS_SETTING_SOUND_NONE = 0UL,
      FI_EN_ADAS_SETTING_SOUND_LDW = 1UL,
      FI_EN_ADAS_SETTING_SOUND_UPA = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_ADAS_Setting_Sound(midw_fi_tcl_e8_ADAS_Setting_Sound::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ADAS_Setting_Sound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ADAS_Setting_Sound& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_OnGoingAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_OnGoingAction();
   enum tenType {
      FI_EN_UNDEF = 0UL,
      FI_EN_ALLOCATE = 1UL,
      FI_EN_DEALLOCATE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_OnGoingAction(midw_fi_tcl_e8_OnGoingAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_OnGoingAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_OnGoingAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BOSE_UnitType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BOSE_UnitType();
   enum tenType {
      FI_EN_AUDIOAMPLIFIER = 0UL,
      FI_EN_MASTERAMPLIFIER = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_BOSE_UnitType(midw_fi_tcl_e8_BOSE_UnitType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BOSE_UnitType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BOSE_UnitType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_BOSE_UnitConnectionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_BOSE_UnitConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_BOSE_UnitConnectionStatus& operator=(const midw_fi_tcl_BOSE_UnitConnectionStatus& coRef);
   midw_fi_tcl_BOSE_UnitConnectionStatus(const midw_fi_tcl_BOSE_UnitConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BOSE_UnitType e8UnitType;
   tBool bConnected;
   tU8 u8AbsenceState;
   tU8 u8MuteState;
   virtual ~midw_fi_tcl_BOSE_UnitConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_BOSE_UnitConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MicConnection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MicConnection();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_AVAILABLE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_MicConnection(midw_fi_tcl_e8_MicConnection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MicConnection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MicConnection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MicResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MicResult();
   enum tenType {
      FI_EN_NORMAL = 0UL,
      FI_EN_OPEN = 1UL,
      FI_EN_SHORT = 2UL,
      FI_EN_SHORTBATTERY = 3UL,
      FI_EN_SHORTGROUND = 4UL,
      FI_EN_AMPOVERTEMP = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_MicResult(midw_fi_tcl_e8_MicResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MicResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MicResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MicrophoneStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MicrophoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MicrophoneStatus& operator=(const midw_fi_tcl_MicrophoneStatus& coRef);
   midw_fi_tcl_MicrophoneStatus(const midw_fi_tcl_MicrophoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MicConnection MicConnection;
   midw_fi_tcl_e8_MicResult MicResult;
   virtual ~midw_fi_tcl_MicrophoneStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MicrophoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MicrophoneResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MicrophoneResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MicrophoneResult& operator=(const midw_fi_tcl_MicrophoneResult& coRef);
   midw_fi_tcl_MicrophoneResult(const midw_fi_tcl_MicrophoneResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_MicrophoneStatus Mic1Result;
   midw_fi_tcl_MicrophoneStatus Mic2Result;
   midw_fi_tcl_MicrophoneStatus Mic3Result;
   midw_fi_tcl_MicrophoneStatus Mic4Result;
   virtual ~midw_fi_tcl_MicrophoneResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MicrophoneResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioPilotIntensity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioPilotIntensity();
   enum tenType {
      FI_EN_UNDEF = 255UL,
      FI_EN_LOW = 1UL,
      FI_EN_MEDIUM = 2UL,
      FI_EN_HIGH = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioPilotIntensity(midw_fi_tcl_e8_AudioPilotIntensity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioPilotIntensity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioPilotIntensity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegSid : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegSid();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegSid& operator=(const midw_fi_tcl_TpegSid& coRef);
   midw_fi_tcl_TpegSid(const midw_fi_tcl_TpegSid& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SidA;
   tU8 SidB;
   tU8 SidC;
   virtual ~midw_fi_tcl_TpegSid();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegSid& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TpegApplication : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TpegApplication();
   enum tenType {
      FI_EN_SNI = 0UL,
      FI_EN_RTM = 1UL,
      FI_EN_PTI = 2UL,
      FI_EN_PKI = 3UL,
      FI_EN_CTT = 4UL,
      FI_EN_TEC = 5UL,
      FI_EN_CAI = 6UL,
      FI_EN_TFP = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_TpegApplication(midw_fi_tcl_e8_TpegApplication::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TpegApplication();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TpegApplication& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TpegLocReferencing : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TpegLocReferencing();
   enum tenType {
      FI_EN_TPEGLOCATIONREFERENCE = 0UL,
      FI_EN_DLR1LOCATIONREFERENCE = 1UL,
      FI_EN_TMCLOCATIONREFERENCE = 2UL,
      FI_EN_VICSLINKREFERENCE = 3UL,
      FI_EN_KOREANNODELINKLOCATIONREFERENCE = 4UL,
      FI_EN_ETLLOCATIONREFERENCE = 5UL,
      FI_EN_GLRLOCATIONREFERENCE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_TpegLocReferencing(midw_fi_tcl_e8_TpegLocReferencing::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TpegLocReferencing();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TpegLocReferencing& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegAcid : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegAcid();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegAcid& operator=(const midw_fi_tcl_TpegAcid& coRef);
   midw_fi_tcl_TpegAcid(const midw_fi_tcl_TpegAcid& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TpegSid OriginatorSID;
   midw_fi_tcl_e8_TpegApplication ApplicationId;
   tU8 ContentId;
   virtual ~midw_fi_tcl_TpegAcid();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegAcid& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_VersionedTpegAcid : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_VersionedTpegAcid();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_VersionedTpegAcid& operator=(const midw_fi_tcl_VersionedTpegAcid& coRef);
   midw_fi_tcl_VersionedTpegAcid(const midw_fi_tcl_VersionedTpegAcid& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TpegAcid Acid;
   tU8 Version;
   virtual ~midw_fi_tcl_VersionedTpegAcid();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_VersionedTpegAcid& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegStatisticsPerLocRef : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegStatisticsPerLocRef();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegStatisticsPerLocRef& operator=(const midw_fi_tcl_TpegStatisticsPerLocRef& coRef);
   midw_fi_tcl_TpegStatisticsPerLocRef(const midw_fi_tcl_TpegStatisticsPerLocRef& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TpegLocReferencing LocRefType;
   tU32 MsgsPerFrame;
   tU32 AvgMsgsPerFrame;
   tU32 MaxMsgsPerFrame;
   virtual ~midw_fi_tcl_TpegStatisticsPerLocRef();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegStatisticsPerLocRef& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegStreamInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegStreamInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegStreamInfo& operator=(const midw_fi_tcl_TpegStreamInfo& coRef);
   midw_fi_tcl_TpegStreamInfo(const midw_fi_tcl_TpegStreamInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_VersionedTpegAcid VersionedAcid;
   std::vector<midw_fi_tcl_TpegStatisticsPerLocRef, std::allocator<midw_fi_tcl_TpegStatisticsPerLocRef> > listOfStatisticsPerLocRef;
   virtual ~midw_fi_tcl_TpegStreamInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegStreamInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudSource();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM_TA = 2UL,
      FI_EN_AM = 3UL,
      FI_EN_DAB = 4UL,
      FI_EN_DAB_TA = 5UL,
      FI_EN_XMTUN = 6UL,
      FI_EN_CPRA = 7UL,
      FI_EN_CDDA = 8UL,
      FI_EN_AUX = 9UL,
      FI_EN_SPI_BT_AUDIO = 10UL,
      FI_EN_SPI_USB = 11UL,
      FI_EN_SPI_VR_USB = 12UL,
      FI_EN_SPI_VR_BT_AUDIO = 13UL,
      FI_EN_SPI_TTS = 14UL,
      FI_EN_BT_AUDIO = 15UL,
      FI_EN_PHONE = 16UL,
      FI_EN_AUX2 = 17UL,
      FI_EN_VRU = 18UL,
      FI_EN_SMS = 19UL,
      FI_EN_NAVI = 20UL,
      FI_EN_CUE = 21UL,
      FI_EN_MIC = 22UL,
      FI_EN_PHONE2 = 23UL,
      FI_EN_CPRA2 = 24UL,
      FI_EN_IAPPS = 25UL,
      FI_EN_SPI_MAIN = 26UL,
      FI_EN_SPI_PHONE = 27UL,
      FI_EN_SPI_VR = 28UL,
      FI_EN_SPI_MIX = 29UL,
      FI_EN_PHONE_ANALOG_EXT = 30UL,
      FI_EN_PHONE_ECALL = 31UL,
      FI_EN_PHONE_OUTBAND_RING = 32UL,
      FI_EN_PHONE_VR = 33UL,
      FI_EN_SPI_ALERT = 34UL,
      FI_EN_DRM = 35UL,
      FI_EN_PHONE_WAIT = 36UL,
      FI_EN_TCU_ECALL = 37UL,
      FI_EN_TCU_SERVICECALL = 38UL,
      FI_EN_TCU_TTS = 39UL,
      FI_EN_SPI_TRANSIENT = 40UL,
      FI_EN_WEB_ENT = 41UL,
      FI_EN_WEB_INFO_USR = 42UL,
      FI_EN_SXM_TTS = 43UL,
      FI_EN_SPI_ML_INFO = 44UL,
      FI_EN_SPI_VR_STEREO = 45UL,
      FI_EN_BLU_RAY = 46UL,
      FI_EN_EXTERNAL_CD = 47UL,
      FI_EN_AUX3 = 48UL,
      FI_EN_SXM_NEWS = 49UL,
      FI_EN_IPA_TTS = 50UL,
      FI_EN_DTV = 51UL,
      FI_EN_MIC2 = 52UL,
      FI_EN_AM_TI = 53UL,
      FI_EN_WEB_INFO_SYSTEM = 54UL,
      FI_EN_WEB_MIX = 55UL,
      FI_EN_WEB_TTS = 56UL,
      FI_EN_AUX2_DIAG = 57UL,
      FI_EN_VPA_MAIN = 58UL,
      FI_EN_VPA_SDS = 59UL,
      FI_EN_VPA_TTS = 60UL,
      FI_EN_RSE_IN = 61UL,
      FI_EN_NAVI_BY_SDS = 62UL,
      FI_EN_USB_VIDEO = 63UL,
      FI_EN_AUTO_DRIVE = 64UL,
      FI_EN_DRVASS_VIDEO = 65UL,
      FI_EN_EXT_MEDIA1 = 66UL,
      FI_EN_SPARE_CD = 67UL,
      FI_EN_ECO_TTS = 68UL,
      FI_EN_EXT_NAVI = 69UL,
      FI_EN_WX = 70UL,
      FI_EN_WEB_SDS = 71UL,
      FI_EN_INTERCOM = 72UL,
      FI_EN_MCS_AUDIO = 73UL,
      FI_EN_MCS_VIDEO = 74UL,
      FI_EN_NAVI_HORIZON = 75UL,
      FI_EN_NAVI_HORIZON_RETRIGGER = 76UL,
      FI_EN_NAVI_XURGENT = 77UL,
      FI_EN_NAVI_XURGENT_RETRIGGER = 78UL,
      FI_EN_NAVI_ROUTE_AND_DEST_INFO = 79UL,
      FI_EN_NAVI_ROUTE_AND_DEST_INFO_RETRIGGER = 80UL,
      FI_EN_NAVI_EXTERNAL_TRIGGERED = 81UL,
      FI_EN_NAVI_EXTERNAL_TRIGGERED_RETRIGGER = 82UL,
      FI_EN_NAVI_DEBUG = 83UL,
      FI_EN_NAVI_DEBUG_RETRIGGER = 84UL,
      FI_EN_NAVI_SOUND = 85UL,
      FI_EN_NAVI_SOUND_RETRIGGER = 86UL,
      FI_EN_SDS_PROMPT = 87UL,
      FI_EN_NAVI_DRIVING_RECOMMENDATION = 88UL,
      FI_EN_NAVI_DRIVING_RECOMMENDATION_RETRIGGER = 89UL,
      FI_EN_HMI_SMS = 90UL,
      FI_EN_SXM_TTS_SPEECH = 91UL,
      FI_EN_TTS_DEFAULT = 92UL,
      FI_EN_MIC_PERMANENT = 93UL,
      FI_EN_SXM_IP = 94UL,
      FI_EN_WX_ALERT = 95UL,
      FI_EN_SRC_MAX = 96UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudSource(midw_fi_tcl_e8_AudSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SrcActivity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SrcActivity();
   enum tenType {
      FI_EN_PAUSE = 2UL,
      FI_EN_ON = 1UL,
      FI_EN_OFF = 0UL
   };
   tenType enType;

   midw_fi_tcl_e8_SrcActivity(midw_fi_tcl_e8_SrcActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SrcActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SrcActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SrcAvailabilityReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SrcAvailabilityReason();
   enum tenType {
      FI_EN_NEWMEDIA = 0UL,
      FI_EN_SAMEMEDIA = 1UL,
      FI_EN_NOMEDIA = 2UL,
      FI_EN_TEMPERATURE = 3UL,
      FI_EN_VOLTAGE = 4UL,
      FI_EN_ERROR = 5UL,
      FI_EN_NO_CONTENT = 6UL,
      FI_EN_OVERCURRENT = 7UL,
      FI_EN_INTERNALDISCONNECT = 8UL
   };
   tenType enType;

   midw_fi_tcl_e8_SrcAvailabilityReason(midw_fi_tcl_e8_SrcAvailabilityReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SrcAvailabilityReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SrcAvailabilityReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SrcAvailability : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SrcAvailability();
   enum tenType {
      FI_EN_NOT_AVAILABLE = 0UL,
      FI_EN_PLAYABLE_UNKNOWN = 1UL,
      FI_EN_PLAYABLE = 2UL,
      FI_EN_NOT_PLAYABLE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_SrcAvailability(midw_fi_tcl_e8_SrcAvailability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SrcAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SrcAvailability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SourceAvailablityItem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SourceAvailablityItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SourceAvailablityItem& operator=(const midw_fi_tcl_SourceAvailablityItem& coRef);
   midw_fi_tcl_SourceAvailablityItem(const midw_fi_tcl_SourceAvailablityItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   midw_fi_tcl_e8_SrcAvailabilityReason e8Reason;
   midw_fi_tcl_e8_SrcAvailability e8Availability;
   virtual ~midw_fi_tcl_SourceAvailablityItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SourceAvailablityItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8MuteAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8MuteAction();
   enum tenType {
      FI_EN_MUTE = 1UL,
      FI_EN_DEMUTE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8MuteAction(midw_fi_tcl_e8MuteAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8MuteAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8MuteAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RequestAudioRouteItem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RequestAudioRouteItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RequestAudioRouteItem& operator=(const midw_fi_tcl_RequestAudioRouteItem& coRef);
   midw_fi_tcl_RequestAudioRouteItem(const midw_fi_tcl_RequestAudioRouteItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU8 u8Reason;
   midw_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~midw_fi_tcl_RequestAudioRouteItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RequestAudioRouteItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioProperty : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioProperty();
   enum tenType {
      FI_EN_AUDIO_PROP_VOLUME_LOCK = 1UL,
      FI_EN_AUDIO_PROP_INPUT_GAIN = 2UL,
      FI_EN_AUDIO_PROP_IPOD_DUCKING = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioProperty(midw_fi_tcl_e8_AudioProperty::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioProperty();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioProperty& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_b32MuteReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_b32MuteReason();

   enum {
      FI_C_U32_BIT_MUTE_REAS_USER_ACTION = 0x1UL,
      FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK = 0x2UL,
      FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL = 0x4UL,
      FI_C_U32_BIT_MUTE_REAS_DIAG = 0x8UL,
      FI_C_U32_BIT_MUTE_REAS_OTHER = 0x10UL
   };
   tBool bMUTE_REAS_USER_ACTION() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_USER_ACTION) != 0; }
   tVoid vSetMUTE_REAS_USER_ACTION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_USER_ACTION):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_USER_ACTION)); }
   tBool bMUTE_REAS_START_OF_TRACK() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK) != 0; }
   tVoid vSetMUTE_REAS_START_OF_TRACK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK)); }
   tBool bMUTE_REAS_SOURCE_SEL() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL) != 0; }
   tVoid vSetMUTE_REAS_SOURCE_SEL(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL)); }
   tBool bMUTE_REAS_DIAG() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_DIAG) != 0; }
   tVoid vSetMUTE_REAS_DIAG(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_DIAG):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_DIAG)); }
   tBool bMUTE_REAS_OTHER() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_OTHER) != 0; }
   tVoid vSetMUTE_REAS_OTHER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_OTHER):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_OTHER)); }
   struct rBitValues {
      tBool MUTE_REAS_USER_ACTION:1;
      tBool MUTE_REAS_START_OF_TRACK:1;
      tBool MUTE_REAS_SOURCE_SEL:1;
      tBool MUTE_REAS_DIAG:1;
      tBool MUTE_REAS_OTHER:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_fi_tcl_b32MuteReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_b32MuteReason& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MuteState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MuteState();
   enum tenType {
      FI_EN_MUTE = 1UL,
      FI_EN_DEMUTE = 2UL,
      FI_EN_DEMUTERUNNING = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_MuteState(midw_fi_tcl_e8_MuteState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MuteState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MuteState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MuteRequestItem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MuteRequestItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MuteRequestItem& operator=(const midw_fi_tcl_MuteRequestItem& coRef);
   midw_fi_tcl_MuteRequestItem(const midw_fi_tcl_MuteRequestItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   midw_fi_tcl_e8MuteAction u8Action;
   midw_fi_tcl_b32MuteReason u32Reason;
   virtual ~midw_fi_tcl_MuteRequestItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MuteRequestItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MuteRequester : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MuteRequester();
   enum tenType {
      FI_EN_AUDIOROUTINGMANAGER = 1UL,
      FI_EN_GENIVIAUDIOMANAGER = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_MuteRequester(midw_fi_tcl_e8_MuteRequester::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MuteRequester();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MuteRequester& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8MuteSpeed : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8MuteSpeed();
   enum tenType {
      FI_EN_VERY_FAST = 1UL,
      FI_EN_FAST = 2UL,
      FI_EN_SLOW = 3UL,
      FI_EN_MID = 4UL,
      FI_EN_VERY_SLOW = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8MuteSpeed(midw_fi_tcl_e8MuteSpeed::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8MuteSpeed();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8MuteSpeed& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SetAudioPropertyItem : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SetAudioPropertyItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SetAudioPropertyItem& operator=(const midw_fi_tcl_SetAudioPropertyItem& coRef);
   midw_fi_tcl_SetAudioPropertyItem(const midw_fi_tcl_SetAudioPropertyItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   midw_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~midw_fi_tcl_SetAudioPropertyItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SetAudioPropertyItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_SourceRouteActivity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_SourceRouteActivity();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_SourceRouteActivity& operator=(const midw_fi_tcl_SourceRouteActivity& coRef);
   midw_fi_tcl_SourceRouteActivity(const midw_fi_tcl_SourceRouteActivity& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource Source;
   tU16 SubSource;
   midw_fi_tcl_e8_AudSource PossibleNextSource;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_SrcActivity Activity;
   virtual ~midw_fi_tcl_SourceRouteActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_SourceRouteActivity& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ResponseCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ResponseCode();
   enum tenType {
      FI_EN_FAILURE = 0UL,
      FI_EN_SUCCESS = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_ResponseCode(midw_fi_tcl_e8_ResponseCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ResponseCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ResponseCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ErrorType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ErrorType();
   enum tenType {
      FI_EN_NO_ERROR = 0UL,
      FI_EN_UNKNOWN_ERROR = 1UL,
      FI_EN_INVALID_ARGUMENT = 2UL,
      FI_EN_INVALID_DEV_HANDLE = 3UL,
      FI_EN_INVALID_APP_HANDLE = 4UL,
      FI_EN_RESOURCE_BUSY = 5UL,
      FI_EN_OPERATION_REJECTED = 6UL,
      FI_EN_LAUNCH_FAILED = 7UL,
      FI_EN_TERMINATE_FAILED = 8UL,
      FI_EN_UNSUPPORTED_KEY = 9UL,
      FI_EN_UNSUPPORTED_OPERATION = 10UL,
      FI_EN_INVALID_SERVICE_HANDLE = 11UL,
      FI_EN_SELECTION_FAILED = 12UL,
      FI_EN_DEVICE_NOT_CONNECTED = 13UL,
      FI_EN_REMOTE_APP_START_FAILED = 14UL,
      FI_EN_CONNECT_TIME_OUT = 15UL,
      FI_EN_DEVICE_DISCONNECTED_DURING_SELECTION = 16UL,
      FI_EN_PROJECTION_NOT_ENABLED = 17UL,
      FI_EN_OPERATION_CANCELLED_BY_USER = 18UL,
      FI_EN_DEVICE_SWITCH_FAILED = 19UL,
      FI_EN_FATAL_ERROR = 20UL,
      FI_EN_PHONE_UNSUPPORTED = 21UL,
      FI_EN_APP_NOT_INSTALLED = 22UL,
      FI_EN_INTERNAL_ERROR = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_ErrorType(midw_fi_tcl_e8_ErrorType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ErrorType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ErrorType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceCategory : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceCategory();
   enum tenType {
      FI_EN_DEV_TYPE_UNKNOWN = 0UL,
      FI_EN_DEV_TYPE_DIPO = 1UL,
      FI_EN_DEV_TYPE_MIRRORLINK = 2UL,
      FI_EN_DEV_TYPE_ANDROIDAUTO = 3UL,
      FI_EN_DEV_TYPE_MYSPIN = 4UL,
      FI_EN_DEV_TYPE_CARLIFE = 5UL,
      FI_EN_DEV_TYPE_ONCAR = 6UL,
      FI_EN_DEV_TYPE_DEFAULT = 15UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceCategory(midw_fi_tcl_e8_DeviceCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceConnectionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceConnectionStatus();
   enum tenType {
      FI_EN_DEV_NOT_CONNECTED = 0UL,
      FI_EN_DEV_CONNECTED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceConnectionStatus(midw_fi_tcl_e8_DeviceConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceConnectionType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceConnectionType();
   enum tenType {
      FI_EN_UNKNOWN_CONNECTION = 0UL,
      FI_EN_USB_CONNECTED = 1UL,
      FI_EN_WIFI_CONNECTED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceConnectionType(midw_fi_tcl_e8_DeviceConnectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceConnectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceConnectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SessionTransportType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SessionTransportType();
   enum tenType {
      FI_EN_SESSION_TRANSPORT_UNKNOWN = 0UL,
      FI_EN_SESSION_TRANSPORT_USB = 1UL,
      FI_EN_SESSION_TRANSPORT_WIFI = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_SessionTransportType(midw_fi_tcl_e8_SessionTransportType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SessionTransportType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SessionTransportType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceStatusInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceStatusInfo();
   enum tenType {
      FI_EN_NOT_KNOWN = 0UL,
      FI_EN_DEVICE_ADDED = 1UL,
      FI_EN_DEVICE_REMOVED = 2UL,
      FI_EN_DEVICE_CHANGED = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceStatusInfo(midw_fi_tcl_e8_DeviceStatusInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceStatusInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceStatusInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AppStatusInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AppStatusInfo();
   enum tenType {
      FI_EN_NOT_KNOWN = 0UL,
      FI_EN_APP_LIST_CHANGED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_AppStatusInfo(midw_fi_tcl_e8_AppStatusInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AppStatusInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AppStatusInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SessionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SessionStatus();
   enum tenType {
      FI_EN_SESSION_UNKNOWN = 0UL,
      FI_EN_SESSION_INACTIVE = 1UL,
      FI_EN_SESSION_ACTIVE = 2UL,
      FI_EN_SESSION_SUSPENDED = 3UL,
      FI_EN_SESSION_ERROR = 4UL,
      FI_EN_SESSION_SUSPENDED_NON_ML_APP = 5UL,
      FI_EN_SESSION_SUSPENDED_NON_DRIVE_APP = 6UL,
      FI_EN_SESSION_SUSPENDED_APP_TRANSITION = 7UL,
      FI_EN_SESSION_AUTHENTICATION_FAILURE = 8UL,
      FI_EN_SESSION_PING_FAILURE = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_SessionStatus(midw_fi_tcl_e8_SessionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SessionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SessionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_IconMimeType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_IconMimeType();
   enum tenType {
      FI_EN_ICON_INVALID = 0UL,
      FI_EN_ICON_PNG = 1UL,
      FI_EN_ICON_JPEG = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_IconMimeType(midw_fi_tcl_e8_IconMimeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_IconMimeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_IconMimeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_OrientationMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_OrientationMode();
   enum tenType {
      FI_EN_INVALID_MODE = 0UL,
      FI_EN_PORTRAIT_MODE = 1UL,
      FI_EN_LANDSCAPE_MODE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_OrientationMode(midw_fi_tcl_e8_OrientationMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_OrientationMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_OrientationMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BlockingMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BlockingMode();
   enum tenType {
      FI_EN_DISABLE_BLOCKING = 0UL,
      FI_EN_ENABLE_BLOCKING = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_BlockingMode(midw_fi_tcl_e8_BlockingMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BlockingMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BlockingMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TouchMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TouchMode();
   enum tenType {
      FI_EN_TOUCH_RELEASE = 0UL,
      FI_EN_TOUCH_PRESS = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_TouchMode(midw_fi_tcl_e8_TouchMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TouchMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TouchMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_KeyMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_KeyMode();
   enum tenType {
      FI_EN_KEY_RELEASE = 0UL,
      FI_EN_KEY_PRESS = 1UL,
      FI_EN_KEY_LONGPRESS = 2UL,
      FI_EN_KEY_SOFTPRESS = 3UL,
      FI_EN_KEY_SOFTRELEASE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_KeyMode(midw_fi_tcl_e8_KeyMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_KeyMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_KeyMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EnabledInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EnabledInfo();
   enum tenType {
      FI_EN_USAGE_DISABLED = 0UL,
      FI_EN_USAGE_ENABLED = 1UL,
      FI_EN_USAGE_CONF_REQD = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_EnabledInfo(midw_fi_tcl_e8_EnabledInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EnabledInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EnabledInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ScreenAspectRatio : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ScreenAspectRatio();
   enum tenType {
      FI_EN_ASPECT_UNKNOWN = 0UL,
      FI_EN_ASPECT_4_3 = 1UL,
      FI_EN_ASPECT_16_9 = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_ScreenAspectRatio(midw_fi_tcl_e8_ScreenAspectRatio::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ScreenAspectRatio();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ScreenAspectRatio& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceConnectionReq : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceConnectionReq();
   enum tenType {
      FI_EN_DEV_CONNECT = 0UL,
      FI_EN_DEV_DISCONNECT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceConnectionReq(midw_fi_tcl_e8_DeviceConnectionReq::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceConnectionReq();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceConnectionReq& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_KeyCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_KeyCode();
   enum tenType {
      FI_EN_ITU_KEY_0 = 0UL,
      FI_EN_ITU_KEY_1 = 1UL,
      FI_EN_ITU_KEY_2 = 2UL,
      FI_EN_ITU_KEY_3 = 3UL,
      FI_EN_ITU_KEY_4 = 4UL,
      FI_EN_ITU_KEY_5 = 5UL,
      FI_EN_ITU_KEY_6 = 6UL,
      FI_EN_ITU_KEY_7 = 7UL,
      FI_EN_ITU_KEY_8 = 8UL,
      FI_EN_ITU_KEY_9 = 9UL,
      FI_EN_ITU_KEY_ASTERIX = 10UL,
      FI_EN_ITU_KEY_POUND = 11UL,
      FI_EN_DEV_PHONE_CALL = 12UL,
      FI_EN_DEV_PHONE_END = 13UL,
      FI_EN_DEV_SOFT_LEFT = 14UL,
      FI_EN_DEV_SOFT_MIDDLE = 15UL,
      FI_EN_DEV_SOFT_RIGHT = 16UL,
      FI_EN_DEV_APPLICATION = 17UL,
      FI_EN_DEV_OK = 18UL,
      FI_EN_DEV_DELETE = 19UL,
      FI_EN_DEV_ZOOM_IN = 20UL,
      FI_EN_DEV_ZOOM_OUT = 21UL,
      FI_EN_DEV_CLEAR = 22UL,
      FI_EN_DEV_FORWARD = 23UL,
      FI_EN_DEV_BACKWARD = 24UL,
      FI_EN_DEV_HOME = 25UL,
      FI_EN_DEV_SEARCH = 26UL,
      FI_EN_DEV_MENU = 27UL,
      FI_EN_DEV_PTT = 28UL,
      FI_EN_MULTIMEDIA_PLAY = 29UL,
      FI_EN_MULTIMEDIA_PAUSE = 30UL,
      FI_EN_MULTIMEDIA_STOP = 31UL,
      FI_EN_MULTIMEDIA_FORWARD = 32UL,
      FI_EN_MULTIMEDIA_REWIND = 33UL,
      FI_EN_MULTIMEDIA_NEXT = 34UL,
      FI_EN_MULTIMEDIA_PREVIOUS = 35UL,
      FI_EN_MULTIMEDIA_MUTE = 36UL,
      FI_EN_MULTIMEDIA_UNMUTE = 37UL,
      FI_EN_MULTIMEDIA_PHOTO = 38UL,
      FI_EN_DEV_PHONE_FLASH = 39UL,
      FI_EN_TWODKNOB0_SHIFT_RIGHT = 40UL,
      FI_EN_TWODKNOB0_SHIFT_LEFT = 41UL,
      FI_EN_TWODKNOB0_SHIFT_UP = 42UL,
      FI_EN_TWODKNOB0_SHIFT_UP_RIGHT = 43UL,
      FI_EN_TWODKNOB0_SHIFT_UP_LEFT = 44UL,
      FI_EN_TWODKNOB0_SHIFT_DOWN = 45UL,
      FI_EN_TWODKNOB0_SHIFT_DOWN_RIGHT = 46UL,
      FI_EN_TWODKNOB0_SHIFT_DOWN_LEFT = 47UL,
      FI_EN_TWODKNOB0_PUSH = 48UL,
      FI_EN_TWODKNOB0_PULL = 49UL,
      FI_EN_TWODKNOB0_ROTATE_CLOCKWISE_X = 50UL,
      FI_EN_TWODKNOB0_ROTATE_ANTICLOCKWISE_X = 51UL,
      FI_EN_TWODKNOB0_ROTATE_CLOCKWISE_Y = 52UL,
      FI_EN_TWODKNOB0_ROTATE_ANTICLOCKWISE_Y = 53UL,
      FI_EN_TWODKNOB0_ROTATE_CLOCKWISE_Z = 54UL,
      FI_EN_TWODKNOB0_ROTATE_ANTICLOCKWISE_Z = 55UL,
      FI_EN_TWODKNOB1_SHIFT_RIGHT = 56UL,
      FI_EN_TWODKNOB1_SHIFT_LEFT = 57UL,
      FI_EN_TWODKNOB1_SHIFT_UP = 58UL,
      FI_EN_TWODKNOB1_SHIFT_UP_RIGHT = 59UL,
      FI_EN_TWODKNOB1_SHIFT_UP_LEFT = 60UL,
      FI_EN_TWODKNOB1_SHIFT_DOWN = 61UL,
      FI_EN_TWODKNOB1_SHIFT_DOWN_RIGHT = 62UL,
      FI_EN_TWODKNOB1_SHIFT_DOWN_LEFT = 63UL,
      FI_EN_TWODKNOB1_PUSH = 64UL,
      FI_EN_TWODKNOB1_PULL = 65UL,
      FI_EN_TWODKNOB1_ROTATE_CLOCKWISE_X = 66UL,
      FI_EN_TWODKNOB1_ROTATE_ANTICLOCKWISE_X = 67UL,
      FI_EN_TWODKNOB1_ROTATE_CLOCKWISE_Y = 68UL,
      FI_EN_TWODKNOB1_ROTATE_ANTICLOCKWISE_Y = 69UL,
      FI_EN_TWODKNOB1_ROTATE_CLOCKWISE_Z = 70UL,
      FI_EN_TWODKNOB1_ROTATE_ANTICLOCKWISE_Z = 71UL,
      FI_EN_TWODKNOB2_SHIFT_RIGHT = 72UL,
      FI_EN_TWODKNOB2_SHIFT_LEFT = 73UL,
      FI_EN_TWODKNOB2_SHIFT_UP = 74UL,
      FI_EN_TWODKNOB2_SHIFT_UP_RIGHT = 75UL,
      FI_EN_TWODKNOB2_SHIFT_UP_LEFT = 76UL,
      FI_EN_TWODKNOB2_SHIFT_DOWN = 77UL,
      FI_EN_TWODKNOB2_SHIFT_DOWN_RIGHT = 78UL,
      FI_EN_TWODKNOB2_SHIFT_DOWN_LEFT = 79UL,
      FI_EN_TWODKNOB2_PUSH = 80UL,
      FI_EN_TWODKNOB2_PULL = 81UL,
      FI_EN_TWODKNOB2_ROTATE_CLOCKWISE_X = 82UL,
      FI_EN_TWODKNOB2_ROTATE_ANTICLOCKWISE_X = 83UL,
      FI_EN_TWODKNOB2_ROTATE_CLOCKWISE_Y = 84UL,
      FI_EN_TWODKNOB2_ROTATE_ANTICLOCKWISE_Y = 85UL,
      FI_EN_TWODKNOB2_ROTATE_CLOCKWISE_Z = 86UL,
      FI_EN_TWODKNOB2_ROTATE_ANTICLOCKWISE_Z = 87UL,
      FI_EN_TWODKNOB3_SHIFT_RIGHT = 88UL,
      FI_EN_TWODKNOB3_SHIFT_LEFT = 89UL,
      FI_EN_TWODKNOB3_SHIFT_UP = 90UL,
      FI_EN_TWODKNOB3_SHIFT_UP_RIGHT = 91UL,
      FI_EN_TWODKNOB3_SHIFT_UP_LEFT = 92UL,
      FI_EN_TWODKNOB3_SHIFT_DOWN = 93UL,
      FI_EN_TWODKNOB3_SHIFT_DOWN_RIGHT = 94UL,
      FI_EN_TWODKNOB3_SHIFT_DOWN_LEFT = 95UL,
      FI_EN_TWODKNOB3_PUSH = 96UL,
      FI_EN_TWODKNOB3_PULL = 97UL,
      FI_EN_TWODKNOB3_ROTATE_CLOCKWISE_X = 98UL,
      FI_EN_TWODKNOB3_ROTATE_ANTICLOCKWISE_X = 99UL,
      FI_EN_TWODKNOB3_ROTATE_CLOCKWISE_Y = 100UL,
      FI_EN_TWODKNOB3_ROTATE_ANTICLOCKWISE_Y = 101UL,
      FI_EN_TWODKNOB3_ROTATE_CLOCKWISE_Z = 102UL,
      FI_EN_TWODKNOB3_ROTATE_ANTICLOCKWISE_Z = 103UL,
      FI_EN_FUNCTIONKEY_0 = 104UL,
      FI_EN_FUNCTIONKEY_1 = 105UL,
      FI_EN_FUNCTIONKEY_2 = 106UL,
      FI_EN_FUNCTIONKEY_3 = 107UL,
      FI_EN_FUNCTIONKEY_4 = 108UL,
      FI_EN_FUNCTIONKEY_5 = 109UL,
      FI_EN_FUNCTIONKEY_6 = 110UL,
      FI_EN_FUNCTIONKEY_7 = 111UL,
      FI_EN_DEV_MEDIA = 112UL,
      FI_EN_DEV_NAV = 113UL,
      FI_EN_DEV_TEL = 114UL,
      FI_EN_DEV_KEY_0 = 115UL,
      FI_EN_DEV_KEY_1 = 116UL,
      FI_EN_DEV_KEY_2 = 117UL,
      FI_EN_DEV_KEY_3 = 118UL,
      FI_EN_DEV_KEY_4 = 119UL,
      FI_EN_DEV_KEY_5 = 120UL,
      FI_EN_DEV_KEY_6 = 121UL,
      FI_EN_DEV_KEY_7 = 122UL,
      FI_EN_DEV_KEY_8 = 123UL,
      FI_EN_DEV_KEY_9 = 124UL,
      FI_EN_DEV_KEY_STAR = 125UL,
      FI_EN_DEV_KEY_HASH = 126UL,
      FI_EN_DEV_KEY_PLUS = 127UL,
      FI_EN_DEV_KEY_PHONE_MUTE = 128UL,
      FI_EN_MULTIMEDIA_PLAY_PAUSE = 129UL,
      FI_EN_ROTARY_KNOB = 130UL,
      FI_EN_DEV_PHONE_MERGE_CALLS = 131UL,
      FI_EN_DEV_PHONE_SWAP_CALLS = 132UL
   };
   tenType enType;

   midw_fi_tcl_e32_KeyCode(midw_fi_tcl_e32_KeyCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_KeyCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_KeyCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_AppCategory : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_AppCategory();
   enum tenType {
      FI_EN_APP_UNKNOWN = 0UL,
      FI_EN_APP_UI = 65536UL,
      FI_EN_APP_UIHOMESCREEN = 65537UL,
      FI_EN_APP_UIMENU = 65538UL,
      FI_EN_APP_UINOTIFICATION = 65539UL,
      FI_EN_APP_UIAPPLICATIONLISTING = 65540UL,
      FI_EN_APP_UISETTINGS = 65541UL,
      FI_EN_APP_PHONE = 131072UL,
      FI_EN_APP_PHONECONTACTLIST = 131073UL,
      FI_EN_APP_PHONECALLLOG = 131074UL,
      FI_EN_APP_MEDIA = 196608UL,
      FI_EN_APP_MEDIAMUSIC = 196609UL,
      FI_EN_APP_MEDIAVIDEO = 196610UL,
      FI_EN_APP_MEDIAGAMING = 196611UL,
      FI_EN_APP_MEDIAIMAGE = 196612UL,
      FI_EN_APP_MESSAGING = 262144UL,
      FI_EN_APP_MESSAGINGSMS = 262145UL,
      FI_EN_APP_MESSAGINGMMS = 262146UL,
      FI_EN_APP_MESSAGINGEMAIL = 262147UL,
      FI_EN_APP_NAVIGATION = 327680UL,
      FI_EN_APP_BROWSER = 393216UL,
      FI_EN_APP_BROWSERAPPLICATIONSTORE = 393217UL,
      FI_EN_APP_PRODUCTIVITY = 458752UL,
      FI_EN_APP_PRODUCTIVITYDOCVIEWER = 458753UL,
      FI_EN_APP_PRODUCTIVITYDOCEDITOR = 458754UL,
      FI_EN_APP_INFORMATION = 524288UL,
      FI_EN_APP_INFORMATIONNEWS = 524289UL,
      FI_EN_APP_INFORMATIONWEATHER = 524290UL,
      FI_EN_APP_INFORMATIONSTOCKS = 524291UL,
      FI_EN_APP_INFORMATIONTRAVEL = 524292UL,
      FI_EN_APP_INFORMATIONSPORTS = 524293UL,
      FI_EN_APP_INFORMATIONCLOCK = 524294UL,
      FI_EN_APP_SOCIALNETWORKING = 589824UL,
      FI_EN_APP_PIM = 655360UL,
      FI_EN_APP_PIMCALENDAR = 655361UL,
      FI_EN_APP_PIMNOTES = 655362UL,
      FI_EN_APP_NOUI = 4026531840UL,
      FI_EN_APP_NOUIAUDIOSERVER = 4026531841UL,
      FI_EN_APP_NOUIAUDIOCLIENT = 4026531842UL,
      FI_EN_APP_NOUIVOICECMDENGINE = 4026531856UL,
      FI_EN_APP_NOUICONVERSATIONALAUDIO = 4026531872UL,
      FI_EN_APP_SWITCHTOCLIENTNATIVEUI = 4026597375UL,
      FI_EN_APP_TESTAPP = 4294836224UL,
      FI_EN_APP_SYSTEM = 4294901760UL,
      FI_EN_APP_SYSTEMINPUTUNLOCKPIN = 4294901761UL,
      FI_EN_APP_SYSTEMINPUTBTPIN = 4294901762UL,
      FI_EN_APP_SYSTEMINPUTOTHERPWD = 4294901775UL,
      FI_EN_APP_SYSTEMVOICECMDCONFIRMATION = 4294901776UL
   };
   tenType enType;

   midw_fi_tcl_e32_AppCategory(midw_fi_tcl_e32_AppCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_AppCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_AppCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_AppDisplayCategory : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_AppDisplayCategory();
   enum tenType {
      FI_EN_CONTENT_TEXT = 1UL,
      FI_EN_CONTENT_VIDEO = 2UL,
      FI_EN_CONTENT_IMAGE = 4UL,
      FI_EN_CONTENT_GRAPHICSVECTOR = 128UL,
      FI_EN_CONTENT_GRAPHICS3D = 16UL,
      FI_EN_CONTENT_UI = 32UL,
      FI_EN_CONTENT_CARMODE = 65536UL,
      FI_EN_CONTENT_MISC = 2147483648UL
   };
   tenType enType;

   midw_fi_tcl_e32_AppDisplayCategory(midw_fi_tcl_e32_AppDisplayCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_AppDisplayCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_AppDisplayCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_AppAudioCategory : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_AppAudioCategory();
   enum tenType {
      FI_EN_PHONE_AUDIO = 1UL,
      FI_EN_MEDIA_AUDIOOUT = 2UL,
      FI_EN_MEDIA_AUDIOIN = 4UL,
      FI_EN_VOICE_COMMANDOUT = 128UL,
      FI_EN_VOICE_COMMANDIN = 16UL,
      FI_EN_MISC_CONTENT = 2147483648UL
   };
   tenType enType;

   midw_fi_tcl_e32_AppAudioCategory(midw_fi_tcl_e32_AppAudioCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_AppAudioCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_AppAudioCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_TrustLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_TrustLevel();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_USER_CONFIGURATION = 64UL,
      FI_EN_SELFREGISTERED_APPLICATION = 96UL,
      FI_EN_REGISTERED_APPLICATION = 128UL,
      FI_EN_APPLICATION_CERTIFICATE = 160UL
   };
   tenType enType;

   midw_fi_tcl_e16_TrustLevel(midw_fi_tcl_e16_TrustLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_TrustLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_TrustLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AppCertificationInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AppCertificationInfo();
   enum tenType {
      FI_EN_NOT_CERTIFIED = 0UL,
      FI_EN_BASE_CERTIFIED = 1UL,
      FI_EN_NONDRIVE_CERTIFIED_ONLY = 2UL,
      FI_EN_DRIVE_CERTIFIED_ONLY = 3UL,
      FI_EN_DRIVE_CERTIFIED = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_AppCertificationInfo(midw_fi_tcl_e8_AppCertificationInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AppCertificationInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AppCertificationInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AppCertificationEntity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AppCertificationEntity();
   enum tenType {
      FI_EN_NOT_CERTIFIED = 0UL,
      FI_EN_CCC_CERTIFIED = 1UL,
      FI_EN_CCC_MEMBER_CERTIFIED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_AppCertificationEntity(midw_fi_tcl_e8_AppCertificationEntity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AppCertificationEntity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AppCertificationEntity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AppStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AppStatus();
   enum tenType {
      FI_EN_FOREGROUND = 0UL,
      FI_EN_BACKGROUND = 1UL,
      FI_EN_NOTRUNNING = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_AppStatus(midw_fi_tcl_e8_AppStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AppStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AppStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DisplayContext : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DisplayContext();
   enum tenType {
      FI_EN_DISPLAY_CONTEXT_UNKNOWN = 0UL,
      FI_EN_DISPLAY_CONTEXT_SPEECH_REC = 1UL,
      FI_EN_DISPLAY_CONTEXT_PHONE = 2UL,
      FI_EN_DISPLAY_CONTEXT_NAVIGATION = 3UL,
      FI_EN_DISPLAY_CONTEXT_MEDIA = 4UL,
      FI_EN_DISPLAY_CONTEXT_INFORMATIONAL = 5UL,
      FI_EN_DISPLAY_CONTEXT_EMERGENCY = 6UL,
      FI_EN_DISPLAY_CONTEXT_SPEAKING = 7UL,
      FI_EN_DISPLAY_CONTEXT_TBT_NAVIGATION = 8UL,
      FI_EN_DISPLAY_CONTEXT_SLEEP_MODE = 9UL,
      FI_EN_DISPLAY_CONTEXT_STANDBY_MODE = 10UL,
      FI_EN_DISPLAY_CONTEXT_SCREEN_SAVER = 11UL,
      FI_EN_DISPLAY_CONTEXT_NATIVE = 12UL,
      FI_EN_DISPLAY_CONTEXT_PROJECTION = 13UL,
      FI_EN_DISPLAY_CONTEXT_USER_INPUT = 14UL
   };
   tenType enType;

   midw_fi_tcl_e8_DisplayContext(midw_fi_tcl_e8_DisplayContext::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DisplayContext();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DisplayContext& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DAPStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DAPStatus();
   enum tenType {
      FI_EN_DAP_UNKNOWN = 0UL,
      FI_EN_DAP_NOT_SUPPORTED = 1UL,
      FI_EN_DAP_IN_PROGRESS = 2UL,
      FI_EN_DAP_SUCCESS = 3UL,
      FI_EN_DAP_FAILED = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DAPStatus(midw_fi_tcl_e8_DAPStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DAPStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DAPStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPOAppType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPOAppType();
   enum tenType {
      FI_EN_DIPO_NOT_USED = 0UL,
      FI_EN_DIPO_NO_URL = 1UL,
      FI_EN_DIPO_MAPS = 2UL,
      FI_EN_DIPO_MOBILEPHONE = 3UL,
      FI_EN_DIPO_TEL_NUMBER = 4UL,
      FI_EN_DIPO_SIRI_PREWARN = 5UL,
      FI_EN_DIPO_SIRI_BUTTONDOWN = 6UL,
      FI_EN_DIPO_SIRI_BUTTONUP = 7UL,
      FI_EN_DIPO_MUSIC = 8UL,
      FI_EN_DIPO_NOWPLAYING = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPOAppType(midw_fi_tcl_e8_DiPOAppType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPOAppType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPOAppType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EcnrSetting : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EcnrSetting();
   enum tenType {
      FI_EN_ECNR_NOCHANGE = 0UL,
      FI_EN_ECNR_VOICE = 1UL,
      FI_EN_ECNR_SERVER = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_EcnrSetting(midw_fi_tcl_e8_EcnrSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EcnrSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EcnrSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BTChangeInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BTChangeInfo();
   enum tenType {
      FI_EN_NO_CHANGE = 0UL,
      FI_EN_SWITCH_BT_TO_ML = 1UL,
      FI_EN_SWITCH_BT_TO_DIPO = 2UL,
      FI_EN_SWITCH_ML_TO_BT = 3UL,
      FI_EN_SWITCH_DIPO_TO_BT = 4UL,
      FI_EN_SWITCH_BT_TO_AAP = 5UL,
      FI_EN_SWITCH_AAP_TO_BT = 6UL,
      FI_EN_SWITCH_CL_TO_BT = 7UL,
      FI_EN_SWITCH_BT_TO_CL = 8UL
   };
   tenType enType;

   midw_fi_tcl_e8_BTChangeInfo(midw_fi_tcl_e8_BTChangeInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BTChangeInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BTChangeInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Vehicle_Configuration : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Vehicle_Configuration();
   enum tenType {
      FI_EN_DAY_MODE = 2UL,
      FI_EN_NIGHT_MODE = 3UL,
      FI_EN_RIGHT_HAND_DRIVE = 4UL,
      FI_EN_LEFT_HAND_DRIVE = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_Vehicle_Configuration(midw_fi_tcl_e8_Vehicle_Configuration::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Vehicle_Configuration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Vehicle_Configuration& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Region : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Region();
   enum tenType {
      FI_EN_WORLD = 0UL,
      FI_EN_EU = 1UL,
      FI_EN_EPE = 2UL,
      FI_EN_CAN = 3UL,
      FI_EN_USA = 4UL,
      FI_EN_AMERICA = 5UL,
      FI_EN_AUS = 6UL,
      FI_EN_KOR = 7UL,
      FI_EN_JPN = 8UL,
      FI_EN_CHN = 9UL,
      FI_EN_HKG = 10UL,
      FI_EN_TPE = 11UL,
      FI_EN_IND = 12UL,
      FI_EN_APAC = 13UL,
      FI_EN_AFRICA = 14UL
   };
   tenType enType;

   midw_fi_tcl_e8_Region(midw_fi_tcl_e8_Region::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Region();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Region& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SupportInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SupportInfo();
   enum tenType {
      FI_EN_SUPPORT_NOT_KNOWN = 0UL,
      FI_EN_SUPPORTED = 1UL,
      FI_EN_NOT_SUPPORTED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_SupportInfo(midw_fi_tcl_e8_SupportInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SupportInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SupportInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_USBPortType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_USBPortType();
   enum tenType {
      FI_EN_PORT_TYPE_NOT_KNOWN = 0UL,
      FI_EN_PORT_TYPE_OTG = 1UL,
      FI_EN_PORT_TYPE_NON_OTG = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_USBPortType(midw_fi_tcl_e8_USBPortType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_USBPortType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_USBPortType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceType();
   enum tenType {
      FI_EN_DEVICE_TYPE_UNKNOWN = 0UL,
      FI_EN_ANDROID_DEVICE = 1UL,
      FI_EN_APPLE_DEVICE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceType(midw_fi_tcl_e8_DeviceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceSelectionState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceSelectionState();
   enum tenType {
      FI_EN_DEVICE_NOT_SELECTED  = 0UL,
      FI_EN_DEVICE_SELECTION_INPROGRESS  = 1UL,
      FI_EN_DEVICE_SELECTED = 2UL,
      FI_EN_DEVICE_DESELECTION_INPROGRESS = 3UL,
      FI_EN_DEVICE_USER_DESELECTED = 4UL,
      FI_EN_DEVICE_SELECTION_ERROR = 5UL,
      FI_EN_DEVICE_DESELECTION_ERROR = 6UL,
      FI_EN_DEVICE_REENUMERATION_IN_PROGRESS = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceSelectionState(midw_fi_tcl_e8_DeviceSelectionState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceSelectionState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceSelectionState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceSelectionErrorType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceSelectionErrorType();
   enum tenType {
      FI_EN_DEVICE_SELECTION_ERROR_NONE = 0UL,
      FI_EN_DEVICE_SELECTION_ERROR_NOT_CONNECTED = 1UL,
      FI_EN_DEVICE_SELECTION_ERROR_RESOURCE_BUSY = 2UL,
      FI_EN_DEVICE_SELECTION_DEVICE_ERROR = 3UL,
      FI_EN_DEVICE_SELECTION_ERROR_USBRESET_FAILED = 4UL,
      FI_EN_DEVICE_SELECTION_CANCELLED_BY_USER = 5UL,
      FI_EN_DEVICE_SELECTION_DEVICE_ERROR_FATAL = 6UL,
      FI_EN_DEVICE_SELECTION_ERROR_PHONE_UNSUPPORTED = 7UL,
      FI_EN_DEVICE_SELECTION_ERROR_APP_NOT_INSTALLED = 8UL,
      FI_EN_DEVICE_SELECTION_WIFI_AP_SETUP_ERROR = 9UL,
      FI_EN_DEVICE_SELECTION_STA_DISCONNECTED = 10UL,
      FI_EN_DEVICE_SELECTION_ERROR_SWITCH_FAILED = 11UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceSelectionErrorType(midw_fi_tcl_e8_DeviceSelectionErrorType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceSelectionErrorType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceSelectionErrorType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SelectionType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SelectionType();
   enum tenType {
      FI_EN_SELECTION_TYPE_UNKNOWN = 0UL,
      FI_EN_SELECTION_TYPE_USER_TRIGGERED = 1UL,
      FI_EN_SELECTION_TYPE_HMI_TRIGGERED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_SelectionType(midw_fi_tcl_e8_SelectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VideoBlockingReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VideoBlockingReason();
   enum tenType {
      FI_EN_VIDEO_BLOCKING_REASON_USER_ACTION = 0UL,
      FI_EN_VIDEO_BLOCKING_REASON_INVALID_APP = 1UL,
      FI_EN_VIDEO_BLOCKING_REASON_NON_DRIVE_APP = 2UL,
      FI_EN_VIDEO_BLOCKING_REASON_PHONE_REQUEST = 3UL,
      FI_EN_VIDEO_BLOCKING_REASON_DISPLAY_VIDEO = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_VideoBlockingReason(midw_fi_tcl_e8_VideoBlockingReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VideoBlockingReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VideoBlockingReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceSelectionProgressState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceSelectionProgressState();
   enum tenType {
      FI_EN_NOT_APPLICABLE = 0UL,
      FI_EN_SWITCHING_PROFILE = 1UL,
      FI_EN_PREPARING_ENDPOINTS = 2UL,
      FI_EN_SERVICE_DISCOVERY = 3UL,
      FI_EN_AUTHENTICATING = 4UL,
      FI_EN_RESOURCE_INITIALIZATION = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceSelectionProgressState(midw_fi_tcl_e8_DeviceSelectionProgressState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceSelectionProgressState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceSelectionProgressState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DeviceSelectionInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DeviceSelectionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DeviceSelectionInfo& operator=(const midw_fi_tcl_DeviceSelectionInfo& coRef);
   midw_fi_tcl_DeviceSelectionInfo(const midw_fi_tcl_DeviceSelectionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DeviceSelectionState enDeviceSelectionState;
   midw_fi_tcl_e8_DeviceSelectionErrorType enDeviceSelectionErrorType;
   midw_fi_tcl_e8_DeviceSelectionProgressState enDeviceSelectionProgressState;
   virtual ~midw_fi_tcl_DeviceSelectionInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DeviceSelectionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_VersionInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_VersionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_VersionInfo& operator=(const midw_fi_tcl_VersionInfo& coRef);
   midw_fi_tcl_VersionInfo(const midw_fi_tcl_VersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szMinorVersion;
   midw_fi_tclString szMajorVersion;
   midw_fi_tclString szPatchVersion;
   virtual ~midw_fi_tcl_VersionInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_VersionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AppRemotingInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AppRemotingInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AppRemotingInfo& operator=(const midw_fi_tcl_AppRemotingInfo& coRef);
   midw_fi_tcl_AppRemotingInfo(const midw_fi_tcl_AppRemotingInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szRemotingProtocolID;
   midw_fi_tclString szRemotingFormat;
   midw_fi_tclString szRemotingDirection;
   tU32 u32RemotingAudioIPL;
   tU32 u32RemotingAudioMPL;
   virtual ~midw_fi_tcl_AppRemotingInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AppRemotingInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AppDisplayInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AppDisplayInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AppDisplayInfo& operator=(const midw_fi_tcl_AppDisplayInfo& coRef);
   midw_fi_tcl_AppDisplayInfo(const midw_fi_tcl_AppDisplayInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_AppDisplayCategory enAppDisplayCategory;
   midw_fi_tcl_e16_TrustLevel enTrustLevel;
   tU32 u32AppDisplayRules;
   midw_fi_tclString szAppDisplayOrientation;
   virtual ~midw_fi_tcl_AppDisplayInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AppDisplayInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AppAudioInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AppAudioInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AppAudioInfo& operator=(const midw_fi_tcl_AppAudioInfo& coRef);
   midw_fi_tcl_AppAudioInfo(const midw_fi_tcl_AppAudioInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szAppAudioType;
   midw_fi_tcl_e32_AppAudioCategory enAppAudioCategory;
   midw_fi_tcl_e16_TrustLevel enTrustLevel;
   tU32 u32AppAudioRules;
   virtual ~midw_fi_tcl_AppAudioInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AppAudioInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_IconAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_IconAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_IconAttributes& operator=(const midw_fi_tcl_IconAttributes& coRef);
   midw_fi_tcl_IconAttributes(const midw_fi_tcl_IconAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32IconWidth;
   tU32 u32IconHeight;
   tU32 u32IconDepth;
   midw_fi_tcl_e8_IconMimeType enIconMimeType;
   midw_fi_tclString szIconURL;
   virtual ~midw_fi_tcl_IconAttributes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_IconAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProjectionCapability : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProjectionCapability();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ProjectionCapability& operator=(const midw_fi_tcl_ProjectionCapability& coRef);
   midw_fi_tcl_ProjectionCapability(const midw_fi_tcl_ProjectionCapability& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_USBPortType enUSBPortType;
   midw_fi_tcl_e8_DeviceType enDeviceType;
   midw_fi_tcl_e8_SupportInfo enCarplayProjection;
   midw_fi_tcl_e8_SupportInfo enAndroidProjection;
   midw_fi_tcl_e8_SupportInfo enMirrorlinkProjection;
   midw_fi_tcl_e8_SupportInfo enMySPINProjection;
   midw_fi_tcl_e8_SupportInfo enCarlifeProjection;
   midw_fi_tcl_e8_SupportInfo enOnCarProjection;
   virtual ~midw_fi_tcl_ProjectionCapability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ProjectionCapability& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_EAPAppInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_EAPAppInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_EAPAppInfo& operator=(const midw_fi_tcl_EAPAppInfo& coRef);
   midw_fi_tcl_EAPAppInfo(const midw_fi_tcl_EAPAppInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szAppName;
   midw_fi_tclString szProtocol;
   midw_fi_tclString szBundleID;
   virtual ~midw_fi_tcl_EAPAppInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_EAPAppInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AppDetails : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AppDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AppDetails& operator=(const midw_fi_tcl_AppDetails& coRef);
   midw_fi_tcl_AppDetails(const midw_fi_tcl_AppDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppHandle;
   midw_fi_tclString szAppName;
   midw_fi_tcl_e8_AppStatus enAppStatus;
   midw_fi_tclString szAppVariant;
   midw_fi_tclString szAppProviderName;
   midw_fi_tclString szAppProviderURL;
   midw_fi_tclString szAppDescription;
   std::vector<midw_fi_tclString, std::allocator<midw_fi_tclString> > AppAllowedProfiles;
   midw_fi_tclString szAppCertificateURL;
   midw_fi_tcl_e32_AppCategory enAppCategory;
   midw_fi_tcl_e16_TrustLevel enTrustLevel;
   midw_fi_tcl_e8_AppCertificationInfo e8AppCertificationInfo;
   midw_fi_tcl_AppDisplayInfo rAppDisplayInfo;
   midw_fi_tcl_AppAudioInfo rAppAudioInfo;
   midw_fi_tcl_AppRemotingInfo rAppRemotingInfo;
   tU16 u16NumAppIcons;
   std::vector<midw_fi_tcl_IconAttributes, std::allocator<midw_fi_tcl_IconAttributes> > AppIconList;
   midw_fi_tcl_e8_AppCertificationEntity e8AppCertificationEntity;
   virtual ~midw_fi_tcl_AppDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AppDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TouchCoordinates : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TouchCoordinates();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TouchCoordinates& operator=(const midw_fi_tcl_TouchCoordinates& coRef);
   midw_fi_tcl_TouchCoordinates(const midw_fi_tcl_TouchCoordinates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TouchMode enTouchMode;
   tU16 u16XCoordinate;
   tU16 u16YCoordinate;
   virtual ~midw_fi_tcl_TouchCoordinates();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TouchCoordinates& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TouchInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TouchInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TouchInfo& operator=(const midw_fi_tcl_TouchInfo& coRef);
   midw_fi_tcl_TouchInfo(const midw_fi_tcl_TouchInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TouchCoordinates, std::allocator<midw_fi_tcl_TouchCoordinates> > TouchCoordinatesList;
   virtual ~midw_fi_tcl_TouchInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TouchInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TouchData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TouchData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TouchData& operator=(const midw_fi_tcl_TouchData& coRef);
   midw_fi_tcl_TouchData(const midw_fi_tcl_TouchData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16TouchDescriptors;
   std::vector<midw_fi_tcl_TouchInfo, std::allocator<midw_fi_tcl_TouchInfo> > TouchInfoList;
   virtual ~midw_fi_tcl_TouchData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TouchData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ScreenAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ScreenAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ScreenAttributes& operator=(const midw_fi_tcl_ScreenAttributes& coRef);
   midw_fi_tcl_ScreenAttributes(const midw_fi_tcl_ScreenAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ScreenHeight;
   tU16 u16ScreenWidth;
   midw_fi_tcl_e8_ScreenAspectRatio enScreenAspectRatio;
   virtual ~midw_fi_tcl_ScreenAttributes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ScreenAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_NotificationEnable : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_NotificationEnable();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_NotificationEnable& operator=(const midw_fi_tcl_NotificationEnable& coRef);
   midw_fi_tcl_NotificationEnable(const midw_fi_tcl_NotificationEnable& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppHandle;
   midw_fi_tcl_e8_EnabledInfo enEnabledInfo;
   virtual ~midw_fi_tcl_NotificationEnable();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_NotificationEnable& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_NotificationAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_NotificationAction();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_NotificationAction& operator=(const midw_fi_tcl_NotificationAction& coRef);
   midw_fi_tcl_NotificationAction(const midw_fi_tcl_NotificationAction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NotificationActionID;
   midw_fi_tclString szNotificationActionName;
   tU16 u16NotificationActionIconCount;
   std::vector<midw_fi_tcl_IconAttributes, std::allocator<midw_fi_tcl_IconAttributes> > NotificationActionIconList;
   virtual ~midw_fi_tcl_NotificationAction();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_NotificationAction& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_NotificationData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_NotificationData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_NotificationData& operator=(const midw_fi_tcl_NotificationData& coRef);
   midw_fi_tcl_NotificationData(const midw_fi_tcl_NotificationData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NotificationID;
   midw_fi_tclString szNotificationTitle;
   midw_fi_tclString szNotificationBody;
   tU16 u16NotificationIconCount;
   std::vector<midw_fi_tcl_IconAttributes, std::allocator<midw_fi_tcl_IconAttributes> > NotificationIconList;
   tU16 u16NotificationAppID;
   std::vector<midw_fi_tcl_NotificationAction, std::allocator<midw_fi_tcl_NotificationAction> > NotificationActionList;
   virtual ~midw_fi_tcl_NotificationData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_NotificationData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_VideoAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_VideoAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_VideoAttributes& operator=(const midw_fi_tcl_VideoAttributes& coRef);
   midw_fi_tcl_VideoAttributes(const midw_fi_tcl_VideoAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_OrientationMode enOrientationMode;
   midw_fi_tcl_ScreenAttributes rScreenAttributes;
   virtual ~midw_fi_tcl_VideoAttributes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_VideoAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_KeyCapabilities : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_KeyCapabilities();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_KeyCapabilities& operator=(const midw_fi_tcl_KeyCapabilities& coRef);
   midw_fi_tcl_KeyCapabilities(const midw_fi_tcl_KeyCapabilities& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32KnobKeySupport;
   tU32 u32DeviceKeySupport;
   tU32 u32MultimediaKeySupport;
   tU32 u32MiscKeySupport;
   tU32 u32PointerTouchSupport;
   virtual ~midw_fi_tcl_KeyCapabilities();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_KeyCapabilities& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_XDeviceKeys : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_XDeviceKeys();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_XDeviceKeys& operator=(const midw_fi_tcl_XDeviceKeys& coRef);
   midw_fi_tcl_XDeviceKeys(const midw_fi_tcl_XDeviceKeys& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szName;
   tBool bMandatory;
   midw_fi_tcl_e32_KeyCode e32SymbolValue;
   std::vector<midw_fi_tcl_IconAttributes, std::allocator<midw_fi_tcl_IconAttributes> > IconList;
   virtual ~midw_fi_tcl_XDeviceKeys();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_XDeviceKeys& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ClientCapabilities : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ClientCapabilities();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ClientCapabilities& operator=(const midw_fi_tcl_ClientCapabilities& coRef);
   midw_fi_tcl_ClientCapabilities(const midw_fi_tcl_ClientCapabilities& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyCapabilities rKeyCapabilities;
   virtual ~midw_fi_tcl_ClientCapabilities();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ClientCapabilities& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AudioCapabilities : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AudioCapabilities();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AudioCapabilities& operator=(const midw_fi_tcl_AudioCapabilities& coRef);
   midw_fi_tcl_AudioCapabilities(const midw_fi_tcl_AudioCapabilities& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16BTHFPSupport;
   tU16 u16BTA2DPSupport;
   tU16 u16RTPInSupport;
   tU16 u16RTPOutSupport;
   virtual ~midw_fi_tcl_AudioCapabilities();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AudioCapabilities& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayCapabilities : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayCapabilities();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayCapabilities& operator=(const midw_fi_tcl_DisplayCapabilities& coRef);
   midw_fi_tcl_DisplayCapabilities(const midw_fi_tcl_DisplayCapabilities& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FrameBufferConfiguration;
   tU16 u16PixelFormat;
   virtual ~midw_fi_tcl_DisplayCapabilities();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayCapabilities& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PlayBackState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PlayBackState();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_STOPPED = 0UL,
      FI_EN_PLAYING = 1UL,
      FI_EN_PAUSED = 2UL,
      FI_EN_SEEKFORWARD = 3UL,
      FI_EN_SEEKBACKWARD = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_PlayBackState(midw_fi_tcl_e8_PlayBackState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PlayBackState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PlayBackState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PlayBackShuffleState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PlayBackShuffleState();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_OFF = 0UL,
      FI_EN_SONGS = 1UL,
      FI_EN_ALBUMS = 2UL,
      FI_EN_ON = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_PlayBackShuffleState(midw_fi_tcl_e8_PlayBackShuffleState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PlayBackShuffleState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PlayBackShuffleState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PlayBackRepeatState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PlayBackRepeatState();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_OFF = 0UL,
      FI_EN_ONE = 1UL,
      FI_EN_ALL = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_PlayBackRepeatState(midw_fi_tcl_e8_PlayBackRepeatState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PlayBackRepeatState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PlayBackRepeatState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PlayBackMediaType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PlayBackMediaType();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_MUSIC = 0UL,
      FI_EN_PODCAST = 1UL,
      FI_EN_AUDIOBOOK = 2UL,
      FI_EN_ITUNESU = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_PlayBackMediaType(midw_fi_tcl_e8_PlayBackMediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PlayBackMediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PlayBackMediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ApplicationMediaMetaData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ApplicationMediaMetaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ApplicationMediaMetaData& operator=(const midw_fi_tcl_ApplicationMediaMetaData& coRef);
   midw_fi_tcl_ApplicationMediaMetaData(const midw_fi_tcl_ApplicationMediaMetaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString AppName;
   midw_fi_tclString Title;
   midw_fi_tclString Artist;
   midw_fi_tclString Album;
   midw_fi_tclString AlbumArtist;
   midw_fi_tclString Genre;
   midw_fi_tclString Composer;
   tU32 TrackNumber;
   tU32 AlbumTrackCount;
   tU32 AlbumDiscNumber;
   tU32 AlbumDiscCount;
   tU32 ChapterCount;
   tU32 u32QueueIndex;
   tU32 u32QueueCount;
   midw_fi_tclString ImageMIMEType;
   tU32 ImageSize;
   midw_fi_tclString ImageUrl;
   std::vector<tU8, std::allocator<tU8> > oImageData;
   midw_fi_tcl_e8_PlayBackState PlayBackState;
   midw_fi_tcl_e8_PlayBackShuffleState ShuffleState;
   midw_fi_tcl_e8_PlayBackRepeatState RepeatState;
   midw_fi_tcl_e8_PlayBackMediaType MediaType;
   tBool iTunesRadioAd;
   midw_fi_tclString iTunesRadioStationName;
   tU8 MediaRating;
   virtual ~midw_fi_tcl_ApplicationMediaMetaData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ApplicationMediaMetaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneSignalStrength : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneSignalStrength();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_ZERO_BARS = 0UL,
      FI_EN_ONE_BAR = 1UL,
      FI_EN_TWO_BARS = 2UL,
      FI_EN_THREE_BARS = 3UL,
      FI_EN_FOUR_BARS = 4UL,
      FI_EN_FIVE_BARS = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneSignalStrength(midw_fi_tcl_e8_PhoneSignalStrength::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneSignalStrength();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneSignalStrength& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneRegistrationStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneRegistrationStatus();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_NOT_REGISTERED = 1UL,
      FI_EN_SEARCHING = 2UL,
      FI_EN_DENIED = 3UL,
      FI_EN_REGISTERED_HOME = 4UL,
      FI_EN_REGISTERED_ROAMING = 5UL,
      FI_EN_EMERGENCY_CALLS_ONLY = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneRegistrationStatus(midw_fi_tcl_e8_PhoneRegistrationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneRegistrationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneRegistrationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneAirPlaneModeStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneAirPlaneModeStatus();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_FALSE = 0UL,
      FI_EN_TRUE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneAirPlaneModeStatus(midw_fi_tcl_e8_PhoneAirPlaneModeStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneAirPlaneModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneAirPlaneModeStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneCallState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneCallState();
   enum tenType {
      FI_EN_DISCONNECTED = 0UL,
      FI_EN_SENDING = 1UL,
      FI_EN_RINGING = 2UL,
      FI_EN_CONNECTING = 3UL,
      FI_EN_ACTIVE = 4UL,
      FI_EN_HELD = 5UL,
      FI_EN_DISCONNECTING = 6UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneCallState(midw_fi_tcl_e8_PhoneCallState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneCallState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneCallState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneCallDirection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneCallDirection();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_INCOMING = 1UL,
      FI_EN_OUTGOING = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneCallDirection(midw_fi_tcl_e8_PhoneCallDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneCallDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneCallDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Mute : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Mute();
   enum tenType {
      FI_EN_NOT_KNOWN = 255UL,
      FI_EN_FALSE = 0UL,
      FI_EN_TRUE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_Mute(midw_fi_tcl_e8_Mute::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Mute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Mute& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ApplicationPhoneCallMetadata : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ApplicationPhoneCallMetadata();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ApplicationPhoneCallMetadata& operator=(const midw_fi_tcl_ApplicationPhoneCallMetadata& coRef);
   midw_fi_tcl_ApplicationPhoneCallMetadata(const midw_fi_tcl_ApplicationPhoneCallMetadata& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString PhoneNumber;
   midw_fi_tclString DisplayName;
   midw_fi_tcl_e8_PhoneCallState CallState;
   midw_fi_tcl_e8_PhoneCallDirection CallDirection;
   tU32 CallDuration;
   midw_fi_tclString CallerLabel;
   tBool ConferencedCall;
   virtual ~midw_fi_tcl_ApplicationPhoneCallMetadata();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ApplicationPhoneCallMetadata& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_Time : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_Time();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_Time& operator=(const midw_fi_tcl_Time& coRef);
   midw_fi_tcl_Time(const midw_fi_tcl_Time& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   virtual ~midw_fi_tcl_Time();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_Time& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CallStateUpdateDisconnectReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CallStateUpdateDisconnectReason();
   enum tenType {
      FI_EN_CALLSTATE_DISCONNECT_REASON_ENDED = 0UL,
      FI_EN_CALLSTATE_DISCONNECT_REASON_DECLINED = 1UL,
      FI_EN_CALLSTATE_DISCONNECT_REASON_FAILED = 2UL,
      FI_EN_CALLSTATE_DISCONNECT_REASON_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_CallStateUpdateDisconnectReason(midw_fi_tcl_e8_CallStateUpdateDisconnectReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CallStateUpdateDisconnectReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CallStateUpdateDisconnectReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ApplicationPhoneCallExtendedMetadata : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ApplicationPhoneCallExtendedMetadata();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& operator=(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& coRef);
   midw_fi_tcl_ApplicationPhoneCallExtendedMetadata(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString PhoneNumber;
   midw_fi_tclString DisplayName;
   midw_fi_tclString sCallUUID;
   midw_fi_tcl_e8_CallStateUpdateDisconnectReason CallStateDisconnectReason;
   midw_fi_tcl_e8_PhoneCallState CallState;
   midw_fi_tcl_e8_PhoneCallDirection CallDirection;
   midw_fi_tclString CallerLabel;
   tBool ConferencedCall;
   tU64 u64StartTimeStamp;
   midw_fi_tcl_Time CallProgress;
   midw_fi_tcl_Time CallProgressRefFromDevice;
   virtual ~midw_fi_tcl_ApplicationPhoneCallExtendedMetadata();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ApplicationPhoneCallExtendedMetadata& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AudioContext : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AudioContext();
   enum tenType {
      FI_EN_SPI_AUDIO_MAIN = 0UL,
      FI_EN_SPI_AUDIO_INTERNET_APP = 1UL,
      FI_EN_SPI_AUDIO_SPEECH_REC = 2UL,
      FI_EN_SPI_AUDIO_ADVISOR_PHONE = 3UL,
      FI_EN_SPI_AUDIO_EMER_PHONE = 4UL,
      FI_EN_SPI_AUDIO_PHONE = 5UL,
      FI_EN_SPI_AUDIO_INCOM_TONE = 6UL,
      FI_EN_SPI_AUDIO_TRAFFIC = 7UL,
      FI_EN_SPI_AUDIO_EMERGENCY_MSG = 8UL,
      FI_EN_SPI_AUDIO_SYNC_MSG = 9UL,
      FI_EN_SPI_AUDIO_MIX_NAVI_PROMPT = 10UL,
      FI_EN_SPI_AUDIO_MIX_BEEP_TONE = 11UL,
      FI_EN_SPI_AUDIO_SLEEP_MODE = 12UL,
      FI_EN_SPI_AUDIO_STANDBY_MODE = 13UL,
      FI_EN_SPI_AUDIO_MUTE = 14UL,
      FI_EN_SPI_AUDIO_MAIN_DEFAULT = 15UL,
      FI_EN_SPI_AUDIO_PROJECTION = 16UL
   };
   tenType enType;

   midw_fi_tcl_e8_AudioContext(midw_fi_tcl_e8_AudioContext::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AudioContext();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AudioContext& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_SpeechAppState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_SpeechAppState();
   enum tenType {
      FI_EN_SPI_APP_STATE_SPEECH_UNKNOWN = 0UL,
      FI_EN_SPI_APP_STATE_SPEECH_END = 1UL,
      FI_EN_SPI_APP_STATE_SPEECH_RECOGNISING = 2UL,
      FI_EN_SPI_APP_STATE_SPEECH_SPEAKING = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_SpeechAppState(midw_fi_tcl_e8_SpeechAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_SpeechAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_SpeechAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PhoneAppState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PhoneAppState();
   enum tenType {
      FI_EN_SPI_APP_STATE_PHONE_UNKNOWN = 0UL,
      FI_EN_SPI_APP_STATE_PHONE_ACTIVE = 1UL,
      FI_EN_SPI_APP_STATE_PHONE_NOTACTIVE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_PhoneAppState(midw_fi_tcl_e8_PhoneAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PhoneAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PhoneAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_NavigationAppState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_NavigationAppState();
   enum tenType {
      FI_EN_SPI_APP_STATE_NAV_UNKNOWN = 0UL,
      FI_EN_SPI_APP_STATE_NAV_ACTIVE = 1UL,
      FI_EN_SPI_APP_STATE_NAV_NOTACTIVE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_NavigationAppState(midw_fi_tcl_e8_NavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_NavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_NavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPOSwitchReqResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPOSwitchReqResponse();
   enum tenType {
      FI_EN_E8DIPO_ROLE_SWITCH_NOT_REQUIRED = 0UL,
      FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED = 1UL,
      FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT = 2UL,
      FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT = 3UL,
      FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPOSwitchReqResponse(midw_fi_tcl_e8_DiPOSwitchReqResponse::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPOSwitchReqResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPOSwitchReqResponse& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DisplayInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DisplayInfo();
   enum tenType {
      FI_EN_DISPLAY_CONTEXT = 0UL,
      FI_EN_DISPLAY_CONSTRAINT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DisplayInfo(midw_fi_tcl_e8_DisplayInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DisplayInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DisplayInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AccessoryDisplayContext : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AccessoryDisplayContext();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AccessoryDisplayContext& operator=(const midw_fi_tcl_AccessoryDisplayContext& coRef);
   midw_fi_tcl_AccessoryDisplayContext(const midw_fi_tcl_AccessoryDisplayContext& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DisplayContext DisplayContext;
   tBool DisplayFlag;
   virtual ~midw_fi_tcl_AccessoryDisplayContext();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AccessoryDisplayContext& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ResourceTransferType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ResourceTransferType();
   enum tenType {
      FI_EN_TRANSFER_TYPE_NA = 0UL,
      FI_EN_TRANSFER_TYPE_TAKE = 1UL,
      FI_EN_TRANSFER_TYPE_UNTAKE = 2UL,
      FI_EN_TRANSFER_TYPE_BORROW = 3UL,
      FI_EN_TRANSFER_TYPE_UNBORROW = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_ResourceTransferType(midw_fi_tcl_e8_ResourceTransferType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ResourceTransferType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ResourceTransferType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ResourceTransferPriority : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ResourceTransferPriority();
   enum tenType {
      FI_EN_TRANSFER_PRIORITY_NA = 0UL,
      FI_EN_TRANSFER_PRIORITY_NICETOHAVE = 1UL,
      FI_EN_TRANSFER_PRIORITY_USERINITIATED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_ResourceTransferPriority(midw_fi_tcl_e8_ResourceTransferPriority::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ResourceTransferPriority();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ResourceTransferPriority& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ResourceTransferConstraint : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ResourceTransferConstraint();
   enum tenType {
      FI_EN_TRANSFER_CONSTRAINT_NA = 0UL,
      FI_EN_TRANSFER_CONSTRAINT_ANYTIME = 1UL,
      FI_EN_TRANSFER_CONSTRAINT_USERINITIATED = 2UL,
      FI_EN_TRANSFER_CONSTRAINT_NEVER = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_ResourceTransferConstraint(midw_fi_tcl_e8_ResourceTransferConstraint::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ResourceTransferConstraint();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ResourceTransferConstraint& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayConstraint : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayConstraint();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayConstraint& operator=(const midw_fi_tcl_DisplayConstraint& coRef);
   midw_fi_tcl_DisplayConstraint(const midw_fi_tcl_DisplayConstraint& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResourceTransferType TransferType;
   midw_fi_tcl_e8_ResourceTransferPriority TransferPriority;
   midw_fi_tcl_e8_ResourceTransferConstraint TakeConstraint;
   midw_fi_tcl_e8_ResourceTransferConstraint BorrowConstraint;
   midw_fi_tclString BorrowId;
   virtual ~midw_fi_tcl_DisplayConstraint();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayConstraint& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DisplayType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DisplayType();
   enum tenType {
      FI_EN_E8RESISTIVE = 0UL,
      FI_EN_E8CAPACITIVE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DisplayType(midw_fi_tcl_e8_DisplayType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DisplayType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DisplayType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DisplayTouchType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DisplayTouchType();
   enum tenType {
      FI_EN_E8SINGLE_TOUCH = 0UL,
      FI_EN_E8MULTI_TOUCH = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DisplayTouchType(midw_fi_tcl_e8_DisplayTouchType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DisplayTouchType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DisplayTouchType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayLayerAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayLayerAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayLayerAttributes& operator=(const midw_fi_tcl_DisplayLayerAttributes& coRef);
   midw_fi_tcl_DisplayLayerAttributes(const midw_fi_tcl_DisplayLayerAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DeviceCategory enDeviceCategory;
   tU16 u16TouchLayerID;
   tU16 u16TouchSurfaceID;
   tU16 u16VideoLayerID;
   tU16 u16VideoSurfaceID;
   tU16 u16LayerWidth;
   tU16 u16LayerHeight;
   tU16 u16LayerWidthInMM;
   tU16 u16LayerHeightInMM;
   midw_fi_tclString szPixelAspectRatio;
   tU16 u16DPI;
   midw_fi_tcl_e8_DisplayTouchType enDisplayTouchType;
   tU16 u16PriorityIndex;
   virtual ~midw_fi_tcl_DisplayLayerAttributes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayLayerAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DisplayAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DisplayAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DisplayAttributes& operator=(const midw_fi_tcl_DisplayAttributes& coRef);
   midw_fi_tcl_DisplayAttributes(const midw_fi_tcl_DisplayAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ScreenHeight;
   tU16 u16ScreenWidth;
   tU16 u16ScreenHeightMm;
   tU16 u16ScreenWidthMm;
   midw_fi_tcl_e8_DisplayType enDisplayType;
   std::vector<midw_fi_tcl_DisplayLayerAttributes, std::allocator<midw_fi_tcl_DisplayLayerAttributes> > DisplayLayerAttributes;
   virtual ~midw_fi_tcl_DisplayAttributes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DisplayAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AccessoryAudioContext : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AccessoryAudioContext();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AccessoryAudioContext& operator=(const midw_fi_tcl_AccessoryAudioContext& coRef);
   midw_fi_tcl_AccessoryAudioContext(const midw_fi_tcl_AccessoryAudioContext& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioContext AudioContext;
   tBool AudioFlag;
   virtual ~midw_fi_tcl_AccessoryAudioContext();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AccessoryAudioContext& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VehicleState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VehicleState();
   enum tenType {
      FI_EN_PARK_MODE = 0UL,
      FI_EN_DRIVE_MODE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_VehicleState(midw_fi_tcl_e8_VehicleState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VehicleState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VehicleState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ParkBrake : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ParkBrake();
   enum tenType {
      FI_EN_PARK_BRAKE_INFO_UNAVAILABLE = 0UL,
      FI_EN_PARK_BRAKE_NOT_ENGAGED = 1UL,
      FI_EN_PARK_BRAKE_ENGAGED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_ParkBrake(midw_fi_tcl_e8_ParkBrake::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ParkBrake();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ParkBrake& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_GearState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_GearState();
   enum tenType {
      FI_EN_GEAR_NEUTRAL = 0UL,
      FI_EN_GEAR_1 = 1UL,
      FI_EN_GEAR_2 = 2UL,
      FI_EN_GEAR_3 = 3UL,
      FI_EN_GEAR_4 = 4UL,
      FI_EN_GEAR_5 = 5UL,
      FI_EN_GEAR_6 = 6UL,
      FI_EN_GEAR_LOW = 7UL,
      FI_EN_GEAR_DRIVE = 100UL,
      FI_EN_GEAR_PARK = 101UL,
      FI_EN_GEAR_REVERSE = 102UL,
      FI_EN_GEAR_INFO_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_GearState(midw_fi_tcl_e8_GearState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_GearState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_GearState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_HandsetInteraction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_HandsetInteraction();
   enum tenType {
      FI_EN_HANDSET_INTERACTION_UNKNOWN = 0UL,
      FI_EN_HANDSET_INTERACTION_REQUIRED = 1UL,
      FI_EN_HANDSET_INTERACTION_NOT_REQUIRED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_HandsetInteraction(midw_fi_tcl_e8_HandsetInteraction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_HandsetInteraction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_HandsetInteraction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_UserAuthorizationStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_UserAuthorizationStatus();
   enum tenType {
      FI_EN_USER_AUTH_UNKNOWN = 0UL,
      FI_EN_USER_AUTH_UNAUTHORIZED = 1UL,
      FI_EN_USER_AUTH_AUTHORIZED = 2UL,
      FI_EN_USER_AUTH_CANCELLED = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_UserAuthorizationStatus(midw_fi_tcl_e8_UserAuthorizationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_UserAuthorizationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_UserAuthorizationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DeviceDetails : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DeviceDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DeviceDetails& operator=(const midw_fi_tcl_DeviceDetails& coRef);
   midw_fi_tcl_DeviceDetails(const midw_fi_tcl_DeviceDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceHandle;
   midw_fi_tclString szDeviceName;
   midw_fi_tcl_e8_DeviceCategory enDeviceCategory;
   midw_fi_tclString szDeviceModelName;
   midw_fi_tclString szDeviceManufacturerName;
   midw_fi_tcl_e8_DeviceConnectionStatus enDeviceConnectionStatus;
   midw_fi_tcl_e8_DeviceConnectionType enDeviceConnectionType;
   midw_fi_tcl_VersionInfo rVersionInfo;
   midw_fi_tcl_e8_EnabledInfo enDeviceUsageEnabled;
   tBool bSelectedDevice;
   tBool bDAPSupport;
   midw_fi_tcl_ProjectionCapability rProjectionCapability;
   midw_fi_tclString szBTAddress;
   midw_fi_tcl_DeviceSelectionInfo rDeviceSelectionInfo;
   midw_fi_tclString szSerialNumber;
   midw_fi_tcl_e8_UserAuthorizationStatus enUserAuthorizationStatus;
   midw_fi_tcl_e8_SessionTransportType enSessionTransportType;
   tU32 u32VendorID;
   tU32 u32ProductID;
   midw_fi_tclString szSystemPath;
   virtual ~midw_fi_tcl_DeviceDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DeviceDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DeviceAuthInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DeviceAuthInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DeviceAuthInfo& operator=(const midw_fi_tcl_DeviceAuthInfo& coRef);
   midw_fi_tcl_DeviceAuthInfo(const midw_fi_tcl_DeviceAuthInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceType DeviceType;
   midw_fi_tcl_e8_UserAuthorizationStatus UserAuthorizationStatus;
   virtual ~midw_fi_tcl_DeviceAuthInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DeviceAuthInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_FeatureRestriction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_FeatureRestriction();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_FeatureRestriction& operator=(const midw_fi_tcl_FeatureRestriction& coRef);
   midw_fi_tcl_FeatureRestriction(const midw_fi_tcl_FeatureRestriction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 FeatureLockout;
   virtual ~midw_fi_tcl_FeatureRestriction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_FeatureRestriction& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DeviceSelectionMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DeviceSelectionMode();
   enum tenType {
      FI_EN_SELECTION_MODE_UNKNOWN = 0UL,
      FI_EN_SELECTION_MODE_MANUAL = 1UL,
      FI_EN_SELECTION_MODE_AUTOMATIC = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_DeviceSelectionMode(midw_fi_tcl_e8_DeviceSelectionMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DeviceSelectionMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DeviceSelectionMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TurnSide : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TurnSide();
   enum tenType {
      FI_EN_TURN_SIDE_LEFT = 1UL,
      FI_EN_TURN_SIDE_RIGHT = 2UL,
      FI_EN_TURN_SIDE_UNSPECIFIED = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_TurnSide(midw_fi_tcl_e8_TurnSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TurnSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TurnSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_NextTurnEvent : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_NextTurnEvent();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_NEXT_TURN_DEPART = 1UL,
      FI_EN_NEXT_TURN_NAME_CHANGE = 2UL,
      FI_EN_NEXT_TURN_SLIGHT_TURN = 3UL,
      FI_EN_NEXT_TURN_TURN = 4UL,
      FI_EN_NEXT_TURN_SHARP_TURN = 5UL,
      FI_EN_NEXT_TURN_U_TURN = 6UL,
      FI_EN_NEXT_TURN_ON_RAMP = 7UL,
      FI_EN_NEXT_TURN_OFF_RAMP = 8UL,
      FI_EN_NEXT_TURN_FORK = 9UL,
      FI_EN_NEXT_TURN_MERGE = 10UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER = 11UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_EXIT = 12UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT = 13UL,
      FI_EN_NEXT_TURN_STRAIGHT = 14UL,
      FI_EN_NEXT_TURN_FERRY_BOAT = 16UL,
      FI_EN_NEXT_TURN_FERRY_TRAIN = 17UL,
      FI_EN_NEXT_TURN_DESTINATION = 19UL
   };
   tenType enType;

   midw_fi_tcl_e8_NextTurnEvent(midw_fi_tcl_e8_NextTurnEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_NextTurnEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_NextTurnEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ManeuverDistanceUnits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ManeuverDistanceUnits();
   enum tenType {
      FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN = 0UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_METERS = 1UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS = 2UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS_P1 = 3UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES = 4UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES_P1 = 5UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_FEET = 6UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_YARDS  = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_ManeuverDistanceUnits(midw_fi_tcl_e8_ManeuverDistanceUnits::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ManeuverDistanceUnits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ManeuverDistanceUnits& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BTVoiceRecRequest : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BTVoiceRecRequest();
   enum tenType {
      FI_EN_VOICESESSION_START = 1UL,
      FI_EN_VOICESESSION_START_MIC_ONLY = 2UL,
      FI_EN_VOICESESSION_STOP = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_BTVoiceRecRequest(midw_fi_tcl_e8_BTVoiceRecRequest::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BTVoiceRecRequest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BTVoiceRecRequest& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BTVoiceRecRequestResponse : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BTVoiceRecRequestResponse();
   enum tenType {
      FI_EN_VOICESESSION_REQUEST_UNKNOWN = 0UL,
      FI_EN_VOICESESSION_REQUEST_ACCEPTED = 1UL,
      FI_EN_VOICESESSION_REQUEST_DENIED = 2UL,
      FI_EN_VOICESESSION_REQUEST_DENIED_NOHFP = 3UL,
      FI_EN_VOICESESSION_REQUEST_DENIED_VOICEALREADYACTIVE = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_BTVoiceRecRequestResponse(midw_fi_tcl_e8_BTVoiceRecRequestResponse::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BTVoiceRecRequestResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BTVoiceRecRequestResponse& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_WiFiSecurityType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_WiFiSecurityType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_WEP = 1UL,
      FI_EN_WPA_PERSONAL = 2UL,
      FI_EN_WPA2_PERSONAL = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_WiFiSecurityType(midw_fi_tcl_e8_WiFiSecurityType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_WiFiSecurityType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_WiFiSecurityType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_WiFiAPCredentials : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_WiFiAPCredentials();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_WiFiAPCredentials& operator=(const midw_fi_tcl_WiFiAPCredentials& coRef);
   midw_fi_tcl_WiFiAPCredentials(const midw_fi_tcl_WiFiAPCredentials& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString SSID;
   midw_fi_tclString PassPhrase;
   tU16 ChannelNo;
   midw_fi_tcl_e8_WiFiSecurityType SecurityType;
   virtual ~midw_fi_tcl_WiFiAPCredentials();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_WiFiAPCredentials& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_FidelityType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_FidelityType();
   enum tenType {
      FI_EN_E8LOW_FIDELITY = 0UL,
      FI_EN_E8HIGH_FIDELITY = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_FidelityType(midw_fi_tcl_e8_FidelityType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_FidelityType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_FidelityType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_OEMICONDetails : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_OEMICONDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_OEMICONDetails& operator=(const midw_fi_tcl_OEMICONDetails& coRef);
   midw_fi_tcl_OEMICONDetails(const midw_fi_tcl_OEMICONDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString OEMIconName;
   midw_fi_tclString OEMIconpath;
   virtual ~midw_fi_tcl_OEMICONDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_OEMICONDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BatteryChargingState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BatteryChargingState();
   enum tenType {
      FI_EN_BATTERY_CHARGING_STATE_DISABLED = 0UL,
      FI_EN_BATTERY_CHARGING_STATE_CHARGING = 1UL,
      FI_EN_BATTERY_CHARGING_STATE_CHARGED = 2UL,
      FI_EN_BATTERY_CHARGING_STATE_UNKNOWN = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_BatteryChargingState(midw_fi_tcl_e8_BatteryChargingState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BatteryChargingState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BatteryChargingState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPoRouteGuidanceState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPoRouteGuidanceState();
   enum tenType {
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET = 0UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET = 1UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED = 2UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOADING = 3UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING = 4UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING = 5UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPoRouteGuidanceState(midw_fi_tcl_e8_DiPoRouteGuidanceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPoRouteGuidanceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPoRouteGuidanceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPoManeuverType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPoManeuverType();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN = 0UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_LEFT_TURN = 1UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_RIGHT_TURN = 2UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD = 3UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN = 4UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CONTINUE = 5UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT = 6UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT = 7UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_OFF_RAMP = 8UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ON_RAMP = 9UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION = 10UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE = 11UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION = 12UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_LEFT = 13UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_RIGHT = 14UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_FERRY = 15UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_FERRY = 16UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY = 17UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE = 18UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN = 19UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT = 20UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT = 21UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT = 22UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT = 23UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT = 24UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT = 25UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE = 26UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS = 27UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1 = 28UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2 = 29UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3 = 30UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4 = 31UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5 = 32UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6 = 33UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7 = 34UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8 = 35UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9 = 36UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10 = 37UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11 = 38UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12 = 39UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13 = 40UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14 = 41UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15 = 42UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16 = 43UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17 = 44UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18 = 45UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19 = 46UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN = 47UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN = 48UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN = 49UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN = 50UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY = 51UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT = 52UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT = 53UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPoManeuverType(midw_fi_tcl_e8_DiPoManeuverType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPoManeuverType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPoManeuverType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPoManeuverState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPoManeuverState();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE = 0UL,
      FI_EN_E8DIPO_MANEUVER_STATE_INITIAL = 1UL,
      FI_EN_E8DIPO_MANEUVER_STATE_PREPARE = 2UL,
      FI_EN_E8DIPO_MANEUVER_STATE_EXECUTE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPoManeuverState(midw_fi_tcl_e8_DiPoManeuverState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPoManeuverState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPoManeuverState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPoDrivingSide : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPoDrivingSide();
   enum tenType {
      FI_EN_E8DIPO_DRIVING_SIDE_RIGHT = 0UL,
      FI_EN_E8DIPO_DRIVING_SIDE_LEFT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPoDrivingSide(midw_fi_tcl_e8_DiPoDrivingSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPoDrivingSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPoDrivingSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DistanceUnits : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DistanceUnits();
   enum tenType {
      FI_EN_MANEUVER_DISTANCE_UNITS_UNKNOWN = 0UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_METERS = 1UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS = 2UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_KILOMETERS_P1 = 3UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES = 4UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_MILES_P1 = 5UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_FEET = 6UL,
      FI_EN_MANEUVER_DISTANCE_UNITS_YARDS  = 7UL
   };
   tenType enType;

   midw_fi_tcl_e8_DistanceUnits(midw_fi_tcl_e8_DistanceUnits::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DistanceUnits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DistanceUnits& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiPORouteGuidanceUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiPORouteGuidanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiPORouteGuidanceUpdate& operator=(const midw_fi_tcl_DiPORouteGuidanceUpdate& coRef);
   midw_fi_tcl_DiPORouteGuidanceUpdate(const midw_fi_tcl_DiPORouteGuidanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiPoRouteGuidanceState e8RouteGuidanceState;
   midw_fi_tcl_e8_DiPoManeuverState e8ManeuverState;
   midw_fi_tclString szCurrentRoadName;
   midw_fi_tclString szDestinationName;
   tU64 u64EstimatedTimeOfArrival;
   tU64 u64TimeRemainingToDestination;
   tU32 u32DistanceRemaining;
   midw_fi_tclString szDistanceRemainingDisplayStr;
   midw_fi_tcl_e8_DistanceUnits e8DistanceRemainingDisplayUnits;
   tU32 u32DistanceToNextManeuver;
   midw_fi_tclString szDistanceToNextManeuverDisplayStr;
   midw_fi_tcl_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits;
   std::vector<tU16, std::allocator<tU16> > u16RouteGuidanceManeuverCurrentList;
   tU16 u16RouteGuidanceManeuverCount;
   tBool bIsRouteGuidanceVisibleInApp;
   virtual ~midw_fi_tcl_DiPORouteGuidanceUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiPORouteGuidanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DiPoJunctionType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DiPoJunctionType();
   enum tenType {
      FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION = 0UL,
      FI_EN_E8DIPO_JUNCTION_TYPE_ROUNDABOUT = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DiPoJunctionType(midw_fi_tcl_e8_DiPoJunctionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DiPoJunctionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DiPoJunctionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiPORouteGuidanceManeuverUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiPORouteGuidanceManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& operator=(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef);
   midw_fi_tcl_DiPORouteGuidanceManeuverUpdate(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Index;
   midw_fi_tclString szManeuverDescription;
   midw_fi_tcl_e8_DiPoManeuverType e8ManeuverType;
   midw_fi_tclString szAfterManeuverRoadName;
   tU32 u32DistanceBetweenManeuver;
   midw_fi_tclString szDistanceBetweenManeuverDisplayStr;
   midw_fi_tcl_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits;
   midw_fi_tcl_e8_DiPoDrivingSide e8DrivingSide;
   midw_fi_tcl_e8_DiPoJunctionType e8JunctionType;
   tS16 s16JunctionElementAngle;
   tS16 s16JunctionElementExitAngle;
   virtual ~midw_fi_tcl_DiPORouteGuidanceManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiPORouteGuidanceManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ComponentID : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ComponentID();
   enum tenType {
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_1 = 1UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_2 = 2UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_3 = 3UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_4 = 4UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_5 = 5UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_6 = 6UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_7 = 7UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_8 = 8UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_9 = 9UL,
      FI_EN_DISPLAY_ID_HEADUNIT_DISPLAY_10 = 10UL,
      FI_EN_DISPLAY_ID_CLUSTER_1 = 11UL,
      FI_EN_DISPLAY_ID_CLUSTER_2 = 12UL,
      FI_EN_DISPLAY_ID_CLUSTER_3 = 13UL,
      FI_EN_DISPLAY_ID_CLUSTER_4 = 14UL,
      FI_EN_DISPLAY_ID_CLUSTER_5 = 15UL,
      FI_EN_DISPLAY_ID_CLUSTER_6 = 16UL,
      FI_EN_DISPLAY_ID_CLUSTER_7 = 17UL,
      FI_EN_DISPLAY_ID_CLUSTER_8 = 18UL,
      FI_EN_DISPLAY_ID_CLUSTER_9 = 19UL,
      FI_EN_DISPLAY_ID_CLUSTER_10 = 20UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_1 = 21UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_2 = 22UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_3 = 23UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_4 = 24UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_5 = 25UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_6 = 26UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_7 = 27UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_8 = 28UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_9 = 29UL,
      FI_EN_DISPLAY_ID_HEAD_UP_DISPLAY_10 = 30UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_1 = 31UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_2 = 32UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_3 = 33UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_4 = 34UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_5 = 35UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_6 = 36UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_7 = 37UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_8 = 38UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_9 = 39UL,
      FI_EN_DISPLAY_ID_MISCELLANEOUS_DISPLAY_10 = 40UL,
      FI_EN_DISPLAY_ID_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_ComponentID(midw_fi_tcl_e8_ComponentID::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ComponentID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ComponentID& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CarPlayTBTUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CarPlayTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CarPlayTBTUpdate& operator=(const midw_fi_tcl_CarPlayTBTUpdate& coRef);
   midw_fi_tcl_CarPlayTBTUpdate(const midw_fi_tcl_CarPlayTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DiPORouteGuidanceUpdate DiPoRouteGuidanceUpdate;
   tBool isDiPoRouteGuidanceUpdateValid;
   midw_fi_tcl_DiPORouteGuidanceManeuverUpdate DiPoRouteGuidanceManeuverUpdate;
   tBool isDiPoRouteGuidanceManeuverUpdateValid;
   virtual ~midw_fi_tcl_CarPlayTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CarPlayTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AAutoTurnSide : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AAutoTurnSide();
   enum tenType {
      FI_EN_TURN_SIDE_LEFT = 1UL,
      FI_EN_TURN_SIDE_RIGHT = 2UL,
      FI_EN_TURN_SIDE_UNSPECIFIED = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_AAutoTurnSide(midw_fi_tcl_e8_AAutoTurnSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AAutoTurnSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AAutoTurnSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AAutoNavigationNextTurnDistanceData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AAutoNavigationNextTurnDistanceData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AAutoNavigationNextTurnDistanceData& operator=(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef);
   midw_fi_tcl_AAutoNavigationNextTurnDistanceData(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 DistanceInMeters;
   tS32 TimeInSec;
   tS32 DistanceToManeuver;
   midw_fi_tcl_e8_DistanceUnits ManeuverDistanceUnits ;
   virtual ~midw_fi_tcl_AAutoNavigationNextTurnDistanceData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AAutoNavigationNextTurnDistanceData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AAutoNavigationAppState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AAutoNavigationAppState();
   enum tenType {
      FI_EN_AAUTO_STATE_NAV_UNKNOWN = 0UL,
      FI_EN_AAUTO_STATE_NAV_ACTIVE = 1UL,
      FI_EN_AAUTO_STATE_NAV_NOTACTIVE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_AAutoNavigationAppState(midw_fi_tcl_e8_AAutoNavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AAutoNavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AAutoNavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_AAutoNextTurnEvent : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_AAutoNextTurnEvent();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_NEXT_TURN_DEPART = 1UL,
      FI_EN_NEXT_TURN_NAME_CHANGE = 2UL,
      FI_EN_NEXT_TURN_SLIGHT_TURN = 3UL,
      FI_EN_NEXT_TURN_TURN = 4UL,
      FI_EN_NEXT_TURN_SHARP_TURN = 5UL,
      FI_EN_NEXT_TURN_U_TURN = 6UL,
      FI_EN_NEXT_TURN_ON_RAMP = 7UL,
      FI_EN_NEXT_TURN_OFF_RAMP = 8UL,
      FI_EN_NEXT_TURN_FORK = 9UL,
      FI_EN_NEXT_TURN_MERGE = 10UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER = 11UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_EXIT = 12UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT = 13UL,
      FI_EN_NEXT_TURN_STRAIGHT = 14UL,
      FI_EN_NEXT_TURN_FERRY_BOAT = 16UL,
      FI_EN_NEXT_TURN_FERRY_TRAIN = 17UL,
      FI_EN_NEXT_TURN_DESTINATION = 19UL
   };
   tenType enType;

   midw_fi_tcl_e8_AAutoNextTurnEvent(midw_fi_tcl_e8_AAutoNextTurnEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_AAutoNextTurnEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_AAutoNextTurnEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AAutoNavigationNextTurnData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AAutoNavigationNextTurnData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AAutoNavigationNextTurnData& operator=(const midw_fi_tcl_AAutoNavigationNextTurnData& coRef);
   midw_fi_tcl_AAutoNavigationNextTurnData(const midw_fi_tcl_AAutoNavigationNextTurnData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString RoadName;
   midw_fi_tcl_e8_AAutoTurnSide TurnSide;
   midw_fi_tcl_e8_AAutoNextTurnEvent NextTurnEvent;
   std::vector<tU8, std::allocator<tU8> > Image;
   tS32 TurnAngle;
   tS32 TurnNumber;
   virtual ~midw_fi_tcl_AAutoNavigationNextTurnData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AAutoNavigationNextTurnData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AAutoTBTUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AAutoTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AAutoTBTUpdate& operator=(const midw_fi_tcl_AAutoTBTUpdate& coRef);
   midw_fi_tcl_AAutoTBTUpdate(const midw_fi_tcl_AAutoTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_AAutoNavigationNextTurnData AAutoNavigationNextTurnData;
   tBool isAAutoNavigationNextTurnDataValid;
   midw_fi_tcl_AAutoNavigationNextTurnDistanceData AAutoNavigationNextTurnDistanceData;
   tBool isAAutoNavigationNextTurnDistanceDataValid;
   midw_fi_tcl_e8_AAutoNavigationAppState AAutoNavigationStatus;
   tBool isAAutoNavigationStatusValid;
   virtual ~midw_fi_tcl_AAutoTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AAutoTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BDCLNavigationAppState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BDCLNavigationAppState();
   enum tenType {
      FI_EN_BDCL_NAV_STATE_ACTION_INVALID = 0UL,
      FI_EN_BDCL_NAV_STATE_ACTION_SHOW = 1UL,
      FI_EN_BDCL_NAV_STATE_ACTION_UPDATE = 2UL,
      FI_EN_BDCL_NAV_STATE_ACTION_HIDE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_BDCLNavigationAppState(midw_fi_tcl_e8_BDCLNavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BDCLNavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BDCLNavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BDCLNextTurnType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BDCLNextTurnType();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_TURN_KIND_FRONT = 1UL,
      FI_EN_TURN_KIND_RIGHT_FRONT = 2UL,
      FI_EN_TURN_KIND_RIGHT = 3UL,
      FI_EN_TURN_KIND_RIGHT_BACK = 4UL,
      FI_EN_TURN_KIND_BACK = 5UL,
      FI_EN_TURN_KIND_LEFT_BACK = 6UL,
      FI_EN_TURN_KIND_LEFT = 7UL,
      FI_EN_TURN_KIND_LEFT_FRONT = 8UL,
      FI_EN_TURN_KIND_LEFT_SIDE = 9UL,
      FI_EN_TURN_KIND_RIGHT_SIDE = 10UL,
      FI_EN_TURN_KIND_BRANCH_LEFT = 11UL,
      FI_EN_TURN_KIND_BRANCH_CENTER = 12UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT = 13UL,
      FI_EN_TURN_KIND_RING = 14UL,
      FI_EN_TURN_KIND_INFERRY = 15UL,
      FI_EN_TURN_KIND_OUTFERRY = 16UL,
      FI_EN_TURN_KIND_TOLLGATE = 17UL,
      FI_EN_TURN_KIND_LEFT_SIDE_MAIN = 18UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_MAIN = 19UL,
      FI_EN_TURN_KIND_LEFT_SIDE_IC = 20UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_IC = 21UL,
      FI_EN_TURN_KIND_LEFT_SIDE_STRAIGHT_IC = 22UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_STRAIGHT_IC = 23UL,
      FI_EN_TURN_KIND_LEFT_SIDE_STRAIGHT = 24UL,
      FI_EN_TURN_KIND_RIGHT_SIDE_STRAIGHT = 25UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_STRAIGHT = 26UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_STRAIGHT = 27UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_STRAIGHT = 28UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_IC = 29UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_IC = 30UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_IC = 31UL,
      FI_EN_TURN_KIND_BRANCH_LEFT_IC_STRAIGHT = 32UL,
      FI_EN_TURN_KIND_BRANCH_CENTER_IC_STRAIGHT = 33UL,
      FI_EN_TURN_KIND_BRANCH_RIGHT_IC_STRAIGHT = 34UL,
      FI_EN_TURN_KIND_STRAIGHT_2BRANCH_LEFT_BASE = 35UL,
      FI_EN_TURN_KIND_STRAIGHT_2BRANCH_RIGHT_BASE = 36UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_LEFT_BASE = 37UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_MIDDLE_BASE = 38UL,
      FI_EN_TURN_KIND_STRAIGHT_3BRANCH_RIGHT_BASE = 39UL,
      FI_EN_TURN_KIND_LEFT_2BRANCH_LEFT_BASE = 40UL,
      FI_EN_TURN_KIND_LEFT_2BRANCH_RIGHT_BASE = 41UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_LEFT_BASE = 42UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_MIDDLE_BASE = 43UL,
      FI_EN_TURN_KIND_LEFT_3BRANCH_RIGHT_BASE = 44UL,
      FI_EN_TURN_KIND_RIGHT_2BRANCH_LEFT_BASE = 45UL,
      FI_EN_TURN_KIND_RIGHT_2BRANCH_RIGHT_BASE = 46UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_LEFT_BASE = 47UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_MIDDLE_BASE = 48UL,
      FI_EN_TURN_KIND_RIGHT_3BRANCH_RIGHT_BASE = 49UL,
      FI_EN_TURN_KIND_LEFT_FRONT_2BRANCH_LEFT_BASE = 50UL,
      FI_EN_TURN_KIND_LEFT_FRONT_2BRANCH_RIGHT_BASE = 51UL,
      FI_EN_TURN_KIND_RIGHT_FRONT_2BRANCH_LEFT_BASE = 52UL,
      FI_EN_TURN_KIND_RIGHT_FRONT_2BRANCH_RIGHT_BASE = 53UL,
      FI_EN_TURN_KIND_BACK_2BRANCH_LEFT_BASE = 54UL,
      FI_EN_TURN_KIND_BACK_2BRANCH_RIGHT_BASE = 55UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_LEFT_BASE = 56UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_MIDDLE_BASE = 57UL,
      FI_EN_TURN_KIND_BACK_3BRANCH_RIGHT_BASE = 58UL
   };
   tenType enType;

   midw_fi_tcl_e8_BDCLNextTurnType(midw_fi_tcl_e8_BDCLNextTurnType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BDCLNextTurnType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BDCLNextTurnType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CarlifeNaviNextTurnInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CarlifeNaviNextTurnInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CarlifeNaviNextTurnInfo& operator=(const midw_fi_tcl_CarlifeNaviNextTurnInfo& coRef);
   midw_fi_tcl_CarlifeNaviNextTurnInfo(const midw_fi_tcl_CarlifeNaviNextTurnInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BDCLNavigationAppState BDCLNavigationAppState;
   midw_fi_tcl_e8_BDCLNextTurnType BDCLNaviTurnType;
   midw_fi_tclString RoadName;
   tU32 TotalDistance;
   tU32 RemainDistance;
   std::vector<tU8, std::allocator<tU8> > TurnIconData;
   virtual ~midw_fi_tcl_CarlifeNaviNextTurnInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CarlifeNaviNextTurnInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BDCLAssistantType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BDCLAssistantType();
   enum tenType {
      FI_EN_BDCL_ASSISTANT_TYPE_INVALID = 0UL,
      FI_EN_BDCL_ASSISTANT_TYPE_TRAFFICSIGN = 1UL,
      FI_EN_BDCL_ASSISTANT_TYPE_SPEEDCAMERA = 2UL,
      FI_EN_BDCL_ASSISTANT_TYPE_TRAFFICLIGHTCAMERA = 3UL,
      FI_EN_BDCL_ASSISTANT_TYPE_PECCANRYCAMERA = 4UL,
      FI_EN_BDCL_ASSISTANT_TYPE_INTERVALCAMERA = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_BDCLAssistantType(midw_fi_tcl_e8_BDCLAssistantType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BDCLAssistantType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BDCLAssistantType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_BDCLTrafficSignType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_BDCLTrafficSignType();
   enum tenType {
      FI_EN_BDCL_TRAFFICSIGNTYPE_INVALID = 0UL
   };
   tenType enType;

   midw_fi_tcl_e8_BDCLTrafficSignType(midw_fi_tcl_e8_BDCLTrafficSignType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_BDCLTrafficSignType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_BDCLTrafficSignType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CarlifeNaviAssistantGuideInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CarlifeNaviAssistantGuideInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CarlifeNaviAssistantGuideInfo& operator=(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef);
   midw_fi_tcl_CarlifeNaviAssistantGuideInfo(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BDCLNavigationAppState BDCLAssistantGuideAppState;
   midw_fi_tcl_e8_BDCLAssistantType AssistantType;
   midw_fi_tcl_e8_BDCLTrafficSignType TrafficSignType;
   tU32 TotalDistance;
   tU32 RemainDistance;
   tU32 CameraSpeed;
   virtual ~midw_fi_tcl_CarlifeNaviAssistantGuideInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CarlifeNaviAssistantGuideInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_BDCLTBTUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_BDCLTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_BDCLTBTUpdate& operator=(const midw_fi_tcl_BDCLTBTUpdate& coRef);
   midw_fi_tcl_BDCLTBTUpdate(const midw_fi_tcl_BDCLTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CarlifeNaviNextTurnInfo CarlifeNaviNextTurnInfo;
   tBool isCarlifeNaviNextTurnInfoValid;
   midw_fi_tcl_CarlifeNaviAssistantGuideInfo CarlifeNaviAssistantGuideInfo;
   tBool isCarlifeNaviAssistantGuideInfoValid;
   virtual ~midw_fi_tcl_BDCLTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_BDCLTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CarPlayRouteGuidanceUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CarPlayRouteGuidanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CarPlayRouteGuidanceUpdate& operator=(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& coRef);
   midw_fi_tcl_CarPlayRouteGuidanceUpdate(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRouteGuidanceDisplayComponentIDsAvailable;
   std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> > e8RouteGuidanceDisplayComponentIDs;
   tBool bRouteGuidanceStateAvailable;
   midw_fi_tcl_e8_DiPoRouteGuidanceState e8RouteGuidanceState;
   tBool bManeuverStateAvailable;
   midw_fi_tcl_e8_DiPoManeuverState e8ManeuverState;
   tBool bCurrentRoadNameAvailable;
   midw_fi_tclString szCurrentRoadName;
   tBool bDestinationNameAvailable;
   midw_fi_tclString szDestinationName;
   tBool bEstimatedTimeOfArrivalAvailable;
   tU64 u64EstimatedTimeOfArrival;
   tBool bTimeRemainingToDestinationAvailable;
   tU64 u64TimeRemainingToDestination;
   tBool bDistanceRemainingAvailable;
   tU32 u32DistanceRemaining;
   tBool bDistanceRemainingDisplayStrAvailable;
   midw_fi_tclString szDistanceRemainingDisplayStr;
   tBool bDistanceRemainingDisplayUnitsAvailable;
   midw_fi_tcl_e8_DistanceUnits e8DistanceRemainingDisplayUnits;
   tBool bDistanceToNextManeuverAvailable;
   tU32 u32DistanceToNextManeuver;
   tBool bDistanceToNextManeuverDisplayStrAvailable;
   midw_fi_tclString szDistanceToNextManeuverDisplayStr;
   tBool bDistanceToNextManeuverDisplayUnitsAvailable;
   midw_fi_tcl_e8_DistanceUnits e8DistanceToNextManeuverDisplayUnits;
   tBool bRouteGuidanceManeuverCurrentListAvailable;
   std::vector<tU16, std::allocator<tU16> > u16RouteGuidanceManeuverCurrentList;
   tBool bRouteGuidanceManeuverCountAvailable;
   tU16 u16RouteGuidanceManeuverCount;
   tBool bRouteGuidanceVisibleInAppAvailable;
   tBool bIsRouteGuidanceVisibleInApp;
   tBool bSourceNameAvailable;
   midw_fi_tclString SourceName;
   tBool bSourceSupportsRouteGuidanceAvailable;
   tBool SourceSupportsRouteGuidance;
   virtual ~midw_fi_tcl_CarPlayRouteGuidanceUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CarPlayRouteGuidanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ProjectionVideoAttributes : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ProjectionVideoAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ProjectionVideoAttributes& operator=(const midw_fi_tcl_ProjectionVideoAttributes& coRef);
   midw_fi_tcl_ProjectionVideoAttributes(const midw_fi_tcl_ProjectionVideoAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UIResolutionHeight;
   tU16 u16UIResolutionWidth;
   virtual ~midw_fi_tcl_ProjectionVideoAttributes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ProjectionVideoAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DisplayContextReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DisplayContextReason();
   enum tenType {
      FI_EN_DISPLAY_CONTEXT_REASON_UNKNOWN = 0UL,
      FI_EN_DISPLAY_CONTEXT_REASON_HOME_SCREEN = 1UL,
      FI_EN_DISPLAY_CONTEXT_REASON_LAST_SCREEN = 2UL,
      FI_EN_DISPLAY_CONTEXT_REASON_PHONE_SCREEN_OFF = 3UL,
      FI_EN_DISPLAY_CONTEXT_REASON_SHOW_NATIVE_BT_SCREEN = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DisplayContextReason(midw_fi_tcl_e8_DisplayContextReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DisplayContextReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DisplayContextReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MLGuidanceState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MLGuidanceState();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NO_DESTINATION_SET = 1UL,
      FI_EN_CALCULATING_ROUTE = 2UL,
      FI_EN_NEW_ROUTE = 3UL,
      FI_EN_NO_ROUTE = 4UL,
      FI_EN_NORMAL_OPERATION = 5UL,
      FI_EN_OFF_ROAD = 6UL,
      FI_EN_OFF_MAP = 7UL,
      FI_EN_DESTINATION_AREA = 8UL,
      FI_EN_DESTINATION_REACHED = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_MLGuidanceState(midw_fi_tcl_e8_MLGuidanceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MLGuidanceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MLGuidanceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MLGuidanceActive : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MLGuidanceActive();
   enum tenType {
      FI_EN_GUIDANCE_CLIENT = 0UL,
      FI_EN_GUIDANCE_NONE = 1UL,
      FI_EN_GUIDANCE_SERVER = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_MLGuidanceActive(midw_fi_tcl_e8_MLGuidanceActive::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MLGuidanceActive();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MLGuidanceActive& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLNavigationInfoUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLNavigationInfoUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLNavigationInfoUpdate& operator=(const midw_fi_tcl_MLNavigationInfoUpdate& coRef);
   midw_fi_tcl_MLNavigationInfoUpdate(const midw_fi_tcl_MLNavigationInfoUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString NavAppName;
   midw_fi_tcl_e8_MLGuidanceState GuidanceState;
   midw_fi_tcl_e8_MLGuidanceActive GuidanceActive;
   tBool MetricSystem;
   tBool RightDriving;
   virtual ~midw_fi_tcl_MLNavigationInfoUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLNavigationInfoUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_MLNextDirection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_MLNextDirection();
   enum tenType {
      FI_EN_NO_SYMBOL = 0UL,
      FI_EN_NO_INFO = 1UL,
      FI_EN_FOLLOW_STREET = 2UL,
      FI_EN_TURN_STRAIGHT = 3UL,
      FI_EN_TURN_SLIGHT_RIGHT = 4UL,
      FI_EN_TURN_SLIGHT_LEFT = 5UL,
      FI_EN_TURN_RIGHT = 6UL,
      FI_EN_TURN_LEFT = 7UL,
      FI_EN_TURN_SHARP_RIGHT = 8UL,
      FI_EN_TURN_SHARP_LEFT = 9UL,
      FI_EN_UTURN_RIGHT = 10UL,
      FI_EN_UTURN_LEFT = 11UL,
      FI_EN_KEEP_RIGHT = 12UL,
      FI_EN_KEEP_LEFT = 13UL,
      FI_EN_EXIT_RIGHT = 14UL,
      FI_EN_EXIT_LEFT = 15UL,
      FI_EN_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT_AGAIN = 16UL,
      FI_EN_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT_AGAIN = 17UL,
      FI_EN_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT = 18UL,
      FI_EN_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT = 19UL,
      FI_EN_DOUBLE_TURN_RIGHT_AND_RIGHT = 20UL,
      FI_EN_DOUBLE_TURN_LEFT_AND_LEFT = 21UL,
      FI_EN_DOUBLE_TURN_RIGHT_AND_LEFT = 22UL,
      FI_EN_DOUBLE_TURN_LEFT_AND_RIGHT = 23UL,
      FI_EN_MERGE = 24UL,
      FI_EN_HIGHWAY_FOLLOW = 25UL,
      FI_EN_HIGHWAY_SLIGHT_RIGHT = 26UL,
      FI_EN_HIGHWAY_SLIGHT_LEFT = 27UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_SLIGHT_RIGHT = 28UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_SLIGHT_LEFT = 29UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_RIGHT_AND_STRAIGHT = 30UL,
      FI_EN_HIGHWAY_DOUBLE_TURN_SLIGHT_LEFT_AND_STRAIGHT = 31UL,
      FI_EN_MICHIGAN_TURN_VARIANT_1_RIGHT = 32UL,
      FI_EN_MICHIGAN_TURN_VARIANT_1_LEFT = 33UL,
      FI_EN_MICHIGAN_TURN_VARIANT_2_RIGHT = 34UL,
      FI_EN_MICHIGAN_TURN_VARIANT_2_LEFT = 35UL,
      FI_EN_TUNNEL_ENTER = 36UL,
      FI_EN_TUNNEL = 37UL,
      FI_EN_TUNNEL_EXIT = 38UL,
      FI_EN_FERRY_ENTER = 39UL,
      FI_EN_FERRY = 40UL,
      FI_EN_FERRY_EXIT = 41UL,
      FI_EN_PUBLIC_TRANSPORTATION = 42UL,
      FI_EN_WALK = 43UL,
      FI_EN_COMPASS = 44UL,
      FI_EN_DIRECTION_TO_DESTINATION = 45UL,
      FI_EN_ROUNDABOUT_RIGHT_EXIT_NOW = 46UL,
      FI_EN_ROUNDABOUT_LEFT_EXIT_NOW = 47UL,
      FI_EN_ROUNDABOUT_RIGHT_UNKNOWN_EXIT_NUMBER = 48UL,
      FI_EN_ROUNDABOUT_RIGHT_KNOWN_EXIT_NUMBER = 49UL,
      FI_EN_ROUNDABOUT_LEFT_UNKNOWN_EXIT_NUMBER = 64UL,
      FI_EN_ROUNDABOUT_LEFT_KNOWN_EXIT_NUMBER = 65UL,
      FI_EN_FINAL_DESTINATION = 80UL,
      FI_EN_FINAL_DESTINATION_ON_THE_RIGHT = 81UL,
      FI_EN_FINAL_DESTINATION_ON_THE_LEFT = 82UL,
      FI_EN_INTERMEDIATE_DESTINATION = 83UL,
      FI_EN_INTERMEDIATE_DESTINATION_ON_THE_RIGHT = 84UL,
      FI_EN_INTERMEDIATE_DESTINATION_ON_THE_LEFT = 85UL
   };
   tenType enType;

   midw_fi_tcl_e8_MLNextDirection(midw_fi_tcl_e8_MLNextDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_MLNextDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_MLNextDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLNavigationNextManeuverUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLNavigationNextManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLNavigationNextManeuverUpdate& operator=(const midw_fi_tcl_MLNavigationNextManeuverUpdate& coRef);
   midw_fi_tcl_MLNavigationNextManeuverUpdate(const midw_fi_tcl_MLNavigationNextManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MLNextDirection NextDirection;
   tU32 NextManeuverIndex;
   tU32 NextAngle;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_1;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_2;
   std::vector<tU32, std::allocator<tU32> > NextSideStreetAngles_3;
   midw_fi_tclString NextStreetName;
   midw_fi_tclString CurrentStreetName;
   tU32 NumOfSideStreetAngles_1;
   tU32 NumOfSideStreetAngles_2;
   tU32 NumOfSideStreetAngles_3;
   virtual ~midw_fi_tcl_MLNavigationNextManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLNavigationNextManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DistanceUnit : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DistanceUnit();
   enum tenType {
      FI_EN_DISTANCE_UNIT_METER = 0UL,
      FI_EN_DISTANCE_UNIT_KM = 1UL,
      FI_EN_DISTANCE_UNIT_FEET = 2UL,
      FI_EN_DISTANCE_UNIT_YARDS = 3UL,
      FI_EN_DISTANCE_UNIT_MILES = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DistanceUnit(midw_fi_tcl_e8_DistanceUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DistanceUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DistanceUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLNavigationNextDistanceUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLNavigationNextDistanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLNavigationNextDistanceUpdate& operator=(const midw_fi_tcl_MLNavigationNextDistanceUpdate& coRef);
   midw_fi_tcl_MLNavigationNextDistanceUpdate(const midw_fi_tcl_MLNavigationNextDistanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Distance;
   midw_fi_tcl_e8_DistanceUnit DistanceUnit;
   tU64 Time;
   tU32 Percentage;
   virtual ~midw_fi_tcl_MLNavigationNextDistanceUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLNavigationNextDistanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLNavigationLaneGuidanceUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLNavigationLaneGuidanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLNavigationLaneGuidanceUpdate& operator=(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& coRef);
   midw_fi_tcl_MLNavigationLaneGuidanceUpdate(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > NextLaneGuidances;
   tU32 NumOfLaneGuidances;
   virtual ~midw_fi_tcl_MLNavigationLaneGuidanceUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLNavigationLaneGuidanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLNavigationTripInfoUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLNavigationTripInfoUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLNavigationTripInfoUpdate& operator=(const midw_fi_tcl_MLNavigationTripInfoUpdate& coRef);
   midw_fi_tcl_MLNavigationTripInfoUpdate(const midw_fi_tcl_MLNavigationTripInfoUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString Destination;
   tU32 Distance;
   midw_fi_tcl_e8_DistanceUnit DistanceUnit;
   tU64 RemainingTravelTime;
   tU64 RemainingTrafficTime;
   virtual ~midw_fi_tcl_MLNavigationTripInfoUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLNavigationTripInfoUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLSpeedLimitUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLSpeedLimitUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLSpeedLimitUpdate& operator=(const midw_fi_tcl_MLSpeedLimitUpdate& coRef);
   midw_fi_tcl_MLSpeedLimitUpdate(const midw_fi_tcl_MLSpeedLimitUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CurrentSpeedLimit;
   tU32 NextSpeedLimit;
   tU32 Distance;
   midw_fi_tcl_e8_DistanceUnit DistanceUnit;
   virtual ~midw_fi_tcl_MLSpeedLimitUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLSpeedLimitUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_MLTBTUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_MLTBTUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_MLTBTUpdate& operator=(const midw_fi_tcl_MLTBTUpdate& coRef);
   midw_fi_tcl_MLTBTUpdate(const midw_fi_tcl_MLTBTUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_MLNavigationInfoUpdate MLNavigationInfoUpdate;
   tBool isMLNavigationInfoUpdateValid;
   midw_fi_tcl_MLNavigationNextManeuverUpdate MLNavigationNextManeuverUpdate;
   tBool isMLNavigationNextManeuverUpdateValid;
   midw_fi_tcl_MLSpeedLimitUpdate MLSpeedLimitUpdate;
   tBool isMLSpeedLimitUpdateValid;
   midw_fi_tcl_MLNavigationNextDistanceUpdate MLNavigationNextDistanceUpdate;
   tBool isMLNavigationNextDistanceUpdateValid;
   midw_fi_tcl_MLNavigationLaneGuidanceUpdate MLNavigationLaneGuidanceUpdate;
   tBool isMLNavigationLaneGuidanceUpdateValid;
   midw_fi_tcl_MLNavigationTripInfoUpdate MLNavigationTripInfoUpdate;
   tBool isMLNavigationTripInfoUpdateValid;
   virtual ~midw_fi_tcl_MLTBTUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_MLTBTUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_Language : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_Language();
   enum tenType {
      FI_EN_LANGUAGE_UNKNOWN = 0UL,
      FI_EN_LANGUAGE_ALBANIAN = 1UL,
      FI_EN_LANGUAGE_ARABIC = 2UL,
      FI_EN_LANGUAGE_BULGARIAN = 3UL,
      FI_EN_LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED = 4UL,
      FI_EN_LANGUAGE_CHINESE_CANTONESE_TRADITIONAL = 5UL,
      FI_EN_LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED = 6UL,
      FI_EN_LANGUAGE_CROATIAN = 7UL,
      FI_EN_LANGUAGE_CZECH = 8UL,
      FI_EN_LANGUAGE_DANISH = 9UL,
      FI_EN_LANGUAGE_DUTCH = 10UL,
      FI_EN_LANGUAGE_ENGLISH_AUSTRALIAN = 11UL,
      FI_EN_LANGUAGE_ENGLISH_UK = 12UL,
      FI_EN_LANGUAGE_ENGLISH_US = 13UL,
      FI_EN_LANGUAGE_ENGLISH_US_FOR_JPN = 14UL,
      FI_EN_LANGUAGE_ENGLISH_US_FOR_PRC = 15UL,
      FI_EN_LANGUAGE_ENGLISH_CANADIAN = 16UL,
      FI_EN_LANGUAGE_ENGLISH_INDIA = 17UL,
      FI_EN_LANGUAGE_ESTONIAN = 18UL,
      FI_EN_LANGUAGE_FINNISH = 19UL,
      FI_EN_LANGUAGE_FLEMISH = 20UL,
      FI_EN_LANGUAGE_FRENCH = 21UL,
      FI_EN_LANGUAGE_FRENCH_CANDIAN = 22UL,
      FI_EN_LANGUAGE_GERMAN = 23UL,
      FI_EN_LANGUAGE_GREEK = 24UL,
      FI_EN_LANGUAGE_HEBREW = 25UL,
      FI_EN_LANGUAGE_HINDI = 26UL,
      FI_EN_LANGUAGE_HUNGARIAN = 27UL,
      FI_EN_LANGUAGE_INDONESIAN = 28UL,
      FI_EN_LANGUAGE_ITALIAN = 29UL,
      FI_EN_LANGUAGE_JAPANESE = 30UL,
      FI_EN_LANGUAGE_KOREAN = 31UL,
      FI_EN_LANGUAGE_LATVIAN = 32UL,
      FI_EN_LANGUAGE_LITHUANIAN = 33UL,
      FI_EN_LANGUAGE_MALAY = 34UL,
      FI_EN_LANGUAGE_NORWEGIAN = 35UL,
      FI_EN_LANGUAGE_PERSIAN_FARSI_IRANIAN = 36UL,
      FI_EN_LANGUAGE_PHILIPPINES = 37UL,
      FI_EN_LANGUAGE_POLISH = 38UL,
      FI_EN_LANGUAGE_PORTUGUESE = 39UL,
      FI_EN_LANGUAGE_PORTUGUESE_BRAZILIAN = 40UL,
      FI_EN_LANGUAGE_ROMANIAN = 41UL,
      FI_EN_LANGUAGE_RUSSIAN = 42UL,
      FI_EN_LANGUAGE_SERBIAN = 43UL,
      FI_EN_LANGUAGE_SLOVAKIAN = 44UL,
      FI_EN_LANGUAGE_SLOVENIAN = 45UL,
      FI_EN_LANGUAGE_SPANISH = 46UL,
      FI_EN_LANGUAGE_SPANISH_LATIN_AMERICAN = 47UL,
      FI_EN_LANGUAGE_SPANISH_MEXICAN = 48UL,
      FI_EN_LANGUAGE_SWEDISH = 49UL,
      FI_EN_LANGUAGE_TAIWANESE = 50UL,
      FI_EN_LANGUAGE_THAI = 51UL,
      FI_EN_LANGUAGE_TURKISH = 52UL,
      FI_EN_LANGUAGE_UKRAINIAN = 53UL,
      FI_EN_LANGUAGE_VIETNAMESE = 54UL,
      FI_EN_LANGUAGE_UNSUPPORTED = 4294967295UL
   };
   tenType enType;

   midw_fi_tcl_e32_Language(midw_fi_tcl_e32_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VehiclePowerModeState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VehiclePowerModeState();
   enum tenType {
      FI_EN_SLEEP = 0UL,
      FI_EN_AUTO_ACC = 1UL,
      FI_EN_IGNITION_ON = 2UL,
      FI_EN_INITIAL_STARTING_IN_PROGRESS = 3UL,
      FI_EN_ENGINE_RUNNING = 4UL,
      FI_EN_VEHICLE_POWERMODE_UNSUPPORTED = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_VehiclePowerModeState(midw_fi_tcl_e8_VehiclePowerModeState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VehiclePowerModeState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VehiclePowerModeState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AmbientColourData : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AmbientColourData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AmbientColourData& operator=(const midw_fi_tcl_AmbientColourData& coRef);
   midw_fi_tcl_AmbientColourData(const midw_fi_tcl_AmbientColourData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 fRed;
   tF32 fGreen;
   tF32 fBlue;
   tF32 fAlpha;
   virtual ~midw_fi_tcl_AmbientColourData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AmbientColourData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8Media_AppCategory : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8Media_AppCategory();
   enum tenType {
      FI_EN_MEDIA_APP_TYPE_RADIO = 0UL,
      FI_EN_MEDIA_APP_TYPE_MUSIC = 1UL,
      FI_EN_MEDIA_APP_TYPE_VIDEO = 2UL,
      FI_EN_MEDIA_APP_TYPE_GAMING = 3UL,
      FI_EN_MEDIA_APP_TYPE_IMAGE = 4UL,
      FI_EN_MEDIA_APP_TYPE_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8Media_AppCategory(midw_fi_tcl_e8Media_AppCategory::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8Media_AppCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8Media_AppCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& operator=(const midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& coRef);
   midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate(const midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRouteGuidanceDisplayComponentIDsAvailable;
   std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> > RouteGuidanceDisplayComponentIDs;
   tBool bIndexAvailable;
   tU16 u16Index;
   tBool bManeuverDescriptionAvailable;
   midw_fi_tclString szManeuverDescription;
   tBool bManeuverTypeAvailable;
   midw_fi_tcl_e8_DiPoManeuverType e8ManeuverType;
   tBool bAfterManeuverRoadNameAvailable;
   midw_fi_tclString szAfterManeuverRoadName;
   tBool bDistanceBetweenManeuverAvailable;
   tU32 u32DistanceBetweenManeuver;
   tBool bDistanceBetweenManeuverDisplayStrAvailable;
   midw_fi_tclString szDistanceBetweenManeuverDisplayStr;
   tBool bDistanceBetweenManeuverDisplayUnitsAvailable;
   midw_fi_tcl_e8_DistanceUnits e8DistanceBetweenManeuverDisplayUnits;
   tBool bDrivingSideAvailable;
   midw_fi_tcl_e8_DiPoDrivingSide e8DrivingSide;
   tBool bJunctionTypeAvailable;
   midw_fi_tcl_e8_DiPoJunctionType e8JunctionType;
   tBool bJunctionElementAngleAvailable;
   std::vector<tS16, std::allocator<tS16> > s16JunctionElementAngleList;
   tBool bJunctionElementExitAngleAvailable;
   tS16 s16JunctionElementExitAngle;
   virtual ~midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_RouteGuidanceDisplayComponent : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_RouteGuidanceDisplayComponent();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_RouteGuidanceDisplayComponent& operator=(const midw_fi_tcl_RouteGuidanceDisplayComponent& coRef);
   midw_fi_tcl_RouteGuidanceDisplayComponent(const midw_fi_tcl_RouteGuidanceDisplayComponent& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ComponentID ComponentID;
   midw_fi_tclString DisplayName;
   tU16 u16MaxCurrentRoadNameLength;
   tU16 u16MaxDestinationNameLength;
   tU16 u16MaxAfterManeuverRoadNameLength;
   tU16 u16MaxManeuverDescriptionLength;
   tU16 u16MaxGuidanceManeuverCapacity;
   virtual ~midw_fi_tcl_RouteGuidanceDisplayComponent();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_RouteGuidanceDisplayComponent& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_ClientState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_ClientState();
   enum tenType {
      FI_EN_CLIENT_STATUS_UNKNOWN = 0UL,
      FI_EN_CLIENT_STATUS_INITIALIZED = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_ClientState(midw_fi_tcl_e8_ClientState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_ClientState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_ClientState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_KeyType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_KeyType();
   enum tenType {
      FI_EN_HARD_KEY = 0UL,
      FI_EN_SOFT_KEY = 1UL
   };
   tenType enType;

   midw_fi_tcl_e32_KeyType(midw_fi_tcl_e32_KeyType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_KeyType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_KeyType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_KeyInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_KeyInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_KeyInfo& operator=(const midw_fi_tcl_KeyInfo& coRef);
   midw_fi_tcl_KeyInfo(const midw_fi_tcl_KeyInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_KeyCode KeyCode;
   midw_fi_tcl_e32_KeyType KeyType;
   virtual ~midw_fi_tcl_KeyInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_KeyInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TechnologyKeyConfig : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TechnologyKeyConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TechnologyKeyConfig& operator=(const midw_fi_tcl_TechnologyKeyConfig& coRef);
   midw_fi_tcl_TechnologyKeyConfig(const midw_fi_tcl_TechnologyKeyConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DeviceCategory enDeviceCategory;
   std::vector<midw_fi_tcl_KeyInfo, std::allocator<midw_fi_tcl_KeyInfo> > KeyInfo;
   virtual ~midw_fi_tcl_TechnologyKeyConfig();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TechnologyKeyConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Entity : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Entity();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HEADUNIT = 1UL,
      FI_EN_PHONE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_Entity(midw_fi_tcl_e8_Entity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Entity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Entity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_HMI_GUI_Point : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_HMI_GUI_Point();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_HMI_GUI_Point& operator=(const midw_fi_tcl_HMI_GUI_Point& coRef);
   midw_fi_tcl_HMI_GUI_Point(const midw_fi_tcl_HMI_GUI_Point& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32XCoordinate;
   tS32 s32YCoordinate;
   virtual ~midw_fi_tcl_HMI_GUI_Point();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_HMI_GUI_Point& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_Gesture_Type : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_Gesture_Type();
   enum tenType {
      FI_EN_EN_HMI_GESTURE_NONE = 4294967295UL,
      FI_EN_EN_HMI_GESTURE_PRESSHOLDREPEATTAP = 0UL,
      FI_EN_EN_HMI_GESTURE_DRAGNUDGE = 1UL,
      FI_EN_EN_HMI_GESTURE_SWIPEFLING = 2UL,
      FI_EN_EN_HMI_GESTURE_PINCHSPREAD = 3UL,
      FI_EN_EN_HMI_GESTURE_RAW_DATA = 4UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_Gesture_Type(midw_fi_tcl_e32_HMI_Gesture_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_Gesture_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_Gesture_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type();
   enum tenType {
      FI_EN_EN_HMI_GESTURE_NONE = 4294967295UL,
      FI_EN_EN_HMI_TP_GESTURE_PRESSHOLDREPEATTAP = 0UL,
      FI_EN_EN_HMI_TP_GESTURE_DRAGNUDGE = 1UL,
      FI_EN_EN_HMI_TP_GESTURE_SWIPEFLING = 2UL,
      FI_EN_EN_HMI_TP_GESTURE_PINCHSPREAD = 3UL,
      FI_EN_EN_HMI_TP_GESTURE_TWOFINGERCLICK = 4UL,
      FI_EN_EN_HMI_TP_GESTURE_TWOFINGERGLIDE = 5UL,
      FI_EN_EN_HMI_TP_GESTURE_THREEFINGERCLICK = 6UL,
      FI_EN_EN_HMI_TP_GESTURE_THREEFINGERGLIDE = 7UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type(midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_Gesture_Event : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_Gesture_Event();
   enum tenType {
      FI_EN_EN_HMI_GESTURE_START = 0UL,
      FI_EN_EN_HMI_GESTURE_HOLD = 1UL,
      FI_EN_EN_HMI_GESTURE_MOVE = 2UL,
      FI_EN_EN_HMI_GESTURE_REPEAT = 3UL,
      FI_EN_EN_HMI_GESTURE_END = 4UL,
      FI_EN_EN_HMI_GESTURE_ABORT = 5UL,
      FI_EN_EN_HMI_GESTURE_DOUBLETAP = 6UL,
      FI_EN_EN_HMI_GESTURE_RAW_DATA_UPDATE = 7UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_Gesture_Event(midw_fi_tcl_e32_HMI_Gesture_Event::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_Gesture_Event();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_Gesture_Event& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_Gesture_Direction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_Gesture_Direction();
   enum tenType {
      FI_EN_EN_HMI_GESTURE_DIR_HORIZONTAL = 0UL,
      FI_EN_EN_HMI_GESTURE_DIR_VERTICAL = 1UL,
      FI_EN_EN_HMI_GESTURE_DIR_2D = 2UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_Gesture_Direction(midw_fi_tcl_e32_HMI_Gesture_Direction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_Gesture_Direction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_Gesture_Direction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_CharRecAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_CharRecAction();
   enum tenType {
      FI_EN_HMI_CHAR_REC_REQENABLE = 0UL,
      FI_EN_HMI_CHAR_REC_REQDISABLE = 1UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_CharRecAction(midw_fi_tcl_e32_HMI_CharRecAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_CharRecAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_CharRecAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_CharRecActionStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_CharRecActionStatus();
   enum tenType {
      FI_EN_HMI_CHAR_REC_UNKNOWN = 0UL,
      FI_EN_HMI_CHAR_REC_ENABLE = 1UL,
      FI_EN_HMI_CHAR_REC_DISABLE = 2UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_CharRecActionStatus(midw_fi_tcl_e32_HMI_CharRecActionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_CharRecActionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_CharRecActionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_ViewStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_ViewStatus();
   enum tenType {
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_STATUS_INVALID = 0UL,
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_STATUS_ACTIVE = 1UL,
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_STATUS_STOPPED = 2UL,
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_STATUS_ABOUT_TO_CHANGE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_ViewStatus(midw_fi_tcl_e32_HMI_ViewStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_ViewStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_ViewStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_ApplicationLayerDetails : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_ApplicationLayerDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_ApplicationLayerDetails& operator=(const midw_fi_tcl_ApplicationLayerDetails& coRef);
   midw_fi_tcl_ApplicationLayerDetails(const midw_fi_tcl_ApplicationLayerDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szLayerName;
   virtual ~midw_fi_tcl_ApplicationLayerDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_ApplicationLayerDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_AppWindowSettings : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_AppWindowSettings();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_AppWindowSettings& operator=(const midw_fi_tcl_AppWindowSettings& coRef);
   midw_fi_tcl_AppWindowSettings(const midw_fi_tcl_AppWindowSettings& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_HMI_GUI_Point rOrigin;
   tU32 u32Width;
   tU32 u32Height;
   virtual ~midw_fi_tcl_AppWindowSettings();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_AppWindowSettings& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_HMI_ViewType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_HMI_ViewType();
   enum tenType {
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_TYPE_TEXT = 0UL,
      FI_EN_EN_HMI_LAYER_SYNC_VIEW_STATUS_VIDEO = 1UL
   };
   tenType enType;

   midw_fi_tcl_e32_HMI_ViewType(midw_fi_tcl_e32_HMI_ViewType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_HMI_ViewType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_HMI_ViewType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DIMMING_DAY_SLIDER : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DIMMING_DAY_SLIDER(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DIMMING_DAY_SLIDER();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DIMMING_DAY_SLIDER& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DIMMING_PWM_VALUE : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DIMMING_PWM_VALUE(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DIMMING_PWM_VALUE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DIMMING_PWM_VALUE& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e32_DimmingFeedback : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e32_DimmingFeedback();
   enum tenType {
      FI_EN_VD_DIMMING_FEEDBACK_DEFROST = 131072UL,
      FI_EN_VD_DIMMING_FEEDBACK_RECIRC = 262144UL,
      FI_EN_VD_DIMMING_FEEDBACK_FLOOR = 524288UL,
      FI_EN_VD_DIMMING_FEEDBACK_CABIN = 1048576UL,
      FI_EN_VD_DIMMING_FEEDBACK_SCREEN = 2097152UL
   };
   tenType enType;

   midw_fi_tcl_e32_DimmingFeedback(midw_fi_tcl_e32_DimmingFeedback::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e32_DimmingFeedback();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e32_DimmingFeedback& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DimmingSDC : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DimmingSDC();
   enum tenType {
      FI_EN_VD_DIMMING_SDC_OFF = 0UL,
      FI_EN_VD_DIMMING_SDC_ON = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DimmingSDC(midw_fi_tcl_e8_DimmingSDC::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DimmingSDC();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DimmingSDC& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DimmingMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DimmingMode();
   enum tenType {
      FI_EN_VD_DIMMING_MODE_DAY = 1UL,
      FI_EN_VD_DIMMING_MODE_NIGHT = 2UL,
      FI_EN_VD_DIMMING_MODE_AUTO = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_DimmingMode(midw_fi_tcl_e8_DimmingMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DimmingMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DimmingMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DimmingState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DimmingState();
   enum tenType {
      FI_EN_VD_DIMMING_STATE_OFF = 0UL,
      FI_EN_VD_DIMMING_STATE_ON = 1UL
   };
   tenType enType;

   midw_fi_tcl_e8_DimmingState(midw_fi_tcl_e8_DimmingState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DimmingState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DimmingState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8_DIM_LUN : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8_DIM_LUN(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_fi_tcl_u8_DIM_LUN();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8_DIM_LUN& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u16_DIM_Permille : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u16_DIM_Permille(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_fi_tcl_u16_DIM_Permille();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u16_DIM_Permille& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_BrightnessLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_BrightnessLevel();
   enum tenType {
      FI_EN_EVENDARKER = 1UL,
      FI_EN_DARKER = 2UL,
      FI_EN_STANDARD = 3UL,
      FI_EN_BRIGHTER = 4UL,
      FI_EN_EVENBRIGHTER = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_BrightnessLevel(midw_fi_tcl_e8_DIM_BrightnessLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_BrightnessLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_BrightnessLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_u8_DIM_Halfclasses : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_u8_DIM_Halfclasses(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_fi_tcl_u8_DIM_Halfclasses();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_u8_DIM_Halfclasses& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_Variants : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_Variants();
   enum tenType {
      FI_EN_NOT_DETECTED = 0UL,
      FI_EN_7_L42_YELLOW = 1UL,
      FI_EN_7_L42_WHITE = 2UL,
      FI_EN_7_P32_YELLOW = 3UL,
      FI_EN_RESERVED_1 = 4UL,
      FI_EN_RESERVED_2 = 5UL,
      FI_EN_8_INCHES = 6UL,
      FI_EN_RESERVED_3 = 7UL,
      FI_EN_5_8_L12_YELLOW = 8UL,
      FI_EN_NOT_SUPPORTED_BY_HARDWARE = 254UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_Variants(midw_fi_tcl_e8_DIM_Variants::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_Variants();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_Variants& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_DisplaySize : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_DisplaySize();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_SIZE_58 = 58UL,
      FI_EN_SIZE_70 = 70UL,
      FI_EN_SIZE_80 = 80UL,
      FI_EN_NOT_SUPPORTED_BY_HARDWARE = 254UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_DisplaySize(midw_fi_tcl_e8_DIM_DisplaySize::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_DisplaySize();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_DisplaySize& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_Status : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_Status();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_AUTOMATIC = 2UL,
      FI_EN_OFF_BY_HEATCTRL = 10UL,
      FI_EN_ON_BY_HEATCTRL = 11UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_Status(midw_fi_tcl_e8_DIM_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_Mode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_Mode();
   enum tenType {
      FI_EN_DAY = 1UL,
      FI_EN_NIGHT = 2UL,
      FI_EN_AUTO = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_Mode(midw_fi_tcl_e8_DIM_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_EmulationMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_EmulationMode();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_KEYBFREEZE = 1UL,
      FI_EN_DISPFREEZE = 2UL,
      FI_EN_SETUP = 3UL,
      FI_EN_VERIFY = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_EmulationMode(midw_fi_tcl_e8_DIM_EmulationMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_EmulationMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_EmulationMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_s16_DIM_Temperature : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_s16_DIM_Temperature(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_fi_tcl_s16_DIM_Temperature();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_s16_DIM_Temperature& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_WarningLevel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_WarningLevel();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_DIMMING = 1UL,
      FI_EN_OVERHEATING = 2UL,
      FI_EN_CRITICAL = 3UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_WarningLevel(midw_fi_tcl_e8_DIM_WarningLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_WarningLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_WarningLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_DIM_InputConfiguration : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_DIM_InputConfiguration();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_CAN = 1UL,
      FI_EN_PWM = 2UL,
      FI_EN_ADC = 3UL,
      FI_EN_HMI = 4UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_DIM_InputConfiguration(midw_fi_tcl_e8_DIM_InputConfiguration::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_DIM_InputConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_DIM_InputConfiguration& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TouchAttr : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TouchAttr();
   enum tenType {
      FI_EN_TOUCH_EN_MAKECODE = 1UL,
      FI_EN_TOUCH_EN_ARPTCODE = 2UL,
      FI_EN_TOUCH_EN_BREAKCODE = 3UL,
      FI_EN_TOUCH_EN_NOCODE = 4UL,
      FI_EN_TOUCH_EN_NEVERCODE = 5UL,
      FI_EN_TOUCH_EN_SCREENCODE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_TouchAttr(midw_fi_tcl_e8_TouchAttr::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TouchAttr();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TouchAttr& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DispTouchInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DispTouchInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DispTouchInfo& operator=(const midw_fi_tcl_DispTouchInfo& coRef);
   midw_fi_tcl_DispTouchInfo(const midw_fi_tcl_DispTouchInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TouchAttr e8TouchAttr;
   tS16 s16CoordinateX;
   tS16 s16CoordinateY;
   tU16 u16Time;
   virtual ~midw_fi_tcl_DispTouchInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DispTouchInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_KeyAttr : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_KeyAttr();
   enum tenType {
      FI_EN_KBD_EN_MAKECODE = 1UL,
      FI_EN_KBD_EN_ARPTCODE = 2UL,
      FI_EN_KBD_EN_BREAKCODE = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_KeyAttr(midw_fi_tcl_e8_KeyAttr::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_KeyAttr();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_KeyAttr& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_KeyCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_KeyCode();
   enum tenType {
      FI_EN_KBD_BZL_HK_NONE = 0UL,
      FI_EN_KBD_BZL_HK_NAV = 1UL,
      FI_EN_KBD_BZL_HK_FMAM = 2UL,
      FI_EN_KBD_BZL_HK_CDAUX = 3UL,
      FI_EN_KBD_BZL_HK_EJECT = 4UL,
      FI_EN_KBD_BZL_HK_PREV = 5UL,
      FI_EN_KBD_BZL_HK_NEXT = 6UL,
      FI_EN_KBD_BZL_HK_TRAFFIC = 7UL,
      FI_EN_KBD_BZL_HK_PHONE = 8UL,
      FI_EN_KBD_BZL_HK_SETTINGS = 9UL,
      FI_EN_KBD_BZL_HK_MAP = 10UL,
      FI_EN_KBD_BZL_HK_INFO = 11UL,
      FI_EN_KBD_BZL_HK_HOME = 12UL,
      FI_EN_KBD_BZL_HK_SOUND = 13UL,
      FI_EN_KBD_BZL_CLIMATE = 14UL,
      FI_EN_KBD_BZL_AC = 15UL,
      FI_EN_KBD_BZL_AUTO = 16UL,
      FI_EN_KBD_BZL_BLOWERUP = 17UL,
      FI_EN_KBD_BZL_BLOWERDOWN = 18UL,
      FI_EN_KBD_BZL_DEFROST = 19UL,
      FI_EN_KBD_BZL_FLOOR = 20UL,
      FI_EN_KBD_BZL_CABIN = 21UL,
      FI_EN_KBD_BZL_SCREEN = 22UL,
      FI_EN_KBD_BZL_RECIRC = 23UL,
      FI_EN_KBD_INC_BZL_VOL = 24UL,
      FI_EN_KBD_INC_BZL_LTEMP = 25UL,
      FI_EN_KBD_INC_BZL_RTEMP = 26UL,
      FI_EN_KBD_RCL_LSWC_LEFT = 27UL,
      FI_EN_KBD_RCL_LSWC_RIGHT = 28UL,
      FI_EN_KBD_RCL_LSWC_UP = 29UL,
      FI_EN_KBD_RCL_LSWC_DOWN = 30UL,
      FI_EN_KBD_RCL_LSWC_MODE = 31UL,
      FI_EN_KBD_RCL_RSWC_LEFT = 32UL,
      FI_EN_KBD_RCL_RSWC_RIGHT = 33UL,
      FI_EN_KBD_RCL_RSWC_UP = 34UL,
      FI_EN_KBD_RCL_RSWC_DOWN = 35UL,
      FI_EN_KBD_RCL_RSWC_OK = 36UL,
      FI_EN_KBD_RCL_PTT = 37UL,
      FI_EN_KBD_RCL_ACCEPT = 38UL,
      FI_EN_KBD_RCL_REJECT = 39UL,
      FI_EN_KBD_BZL_HK_MENU = 40UL,
      FI_EN_KBD_BZL_HK_SK1 = 41UL,
      FI_EN_KBD_BZL_HK_SK2 = 42UL,
      FI_EN_KBD_BZL_HK_SK3 = 43UL,
      FI_EN_KBD_BZL_HK_SK4 = 44UL,
      FI_EN_KBD_BZL_HK_SELECT = 45UL,
      FI_EN_KBD_BZL_HK_ESC = 46UL,
      FI_EN_KBD_VIRTUAL_KEY_DEALER_SERVICE = 47UL,
      FI_EN_KBD_VIRTUAL_KEY_DEV_TEST_PRE = 48UL,
      FI_EN_KBD_VIRTUAL_KEY_DEV_TEST_FINAL = 49UL,
      FI_EN_KBD_VIRTUAL_KEY_EOL_DIAGNOSIS = 50UL,
      FI_EN_KBD_VIRTUAL_KEY_DIAG_START_MAUS = 51UL,
      FI_EN_KBD_VIRTUAL_KEY_EOL_INTERFACE_TEST = 52UL,
      FI_EN_KBD_VIRTUAL_KEY_EOL_INTERACTIVE_FM_SEEK_TEST = 53UL,
      FI_EN_KBD_VIRTUAL_KEY_EOL_CODE_DEACTIVATION = 54UL,
      FI_EN_KBD_VIRTUAL_KEY_ASSEMBLY_LINE_TEMP_UNLOCK = 55UL,
      FI_EN_KBD_VIRTUAL_KEY_FORCE_DOWNLOAD_MODE = 56UL,
      FI_EN_KBD_VIRTUAL_KEY_IMMOBILIZER_UNLOCK = 57UL,
      FI_EN_KBD_SWC_MODE = 60UL,
      FI_EN_KBD_SWC_SKIP_PLUS = 61UL,
      FI_EN_KBD_SWC_SKIP_MINUS = 62UL,
      FI_EN_KBD_SWC_DOUBLE_LEFT = 63UL,
      FI_EN_KBD_SWC_DOUBLE_RIGHT = 64UL,
      FI_EN_KBD_SWC_VOLUME_UP = 65UL,
      FI_EN_KBD_SWC_VOLUME_DOWN = 66UL,
      FI_EN_KBD_SWC_PHONE = 67UL,
      FI_EN_KBD_SWC_UP = 68UL,
      FI_EN_KBD_SWC_DOWN = 69UL,
      FI_EN_KBD_SWC_OK = 70UL,
      FI_EN_KBD_SWC_BACK = 71UL,
      FI_EN_KBD_SWC_MUTE = 72UL,
      FI_EN_KBD_SWC_HANGUP = 73UL,
      FI_EN_KBD_SWC_OFFHOOK = 74UL,
      FI_EN_KBD_SWC_HANGUP_MODE = 75UL,
      FI_EN_KBD_SWC_PTT = 76UL,
      FI_EN_KBD_SWC_OFFHOOK_PTT = 77UL,
      FI_EN_KEY_MULTIPRESS_4 = 78UL,
      FI_EN_KEY_VOL_ROCKER_UP = 79UL,
      FI_EN_KEY_VOL_ROCKER_DOWN = 80UL,
      FI_EN_KEY_VOL_ROCKER_PUSH = 81UL,
      FI_EN_KEY_MULTIFUNC_ROCKER_UP = 82UL,
      FI_EN_KEY_MULTIFUNC_ROCKER_DOWN = 83UL,
      FI_EN_KEY_MULTIFUNC_ROCKER_PUSH = 84UL,
      FI_EN_KEY_UP = 85UL,
      FI_EN_KEY_DOWN = 86UL,
      FI_EN_KEY_VOICE_RECO = 87UL,
      FI_EN_KEY_ONSTAR = 88UL,
      FI_EN_KEY_RESERVED_11 = 89UL,
      FI_EN_KBD_CRADLE_T1 = 90UL,
      FI_EN_KBD_CRADLE_T2 = 91UL,
      FI_EN_KBD_CRADLE_T3 = 92UL,
      FI_EN_KBD_RCL_LSWC_PTT = 93UL,
      FI_EN_KBD_RCL_CAN_PTT = 94UL,
      FI_EN_KEY_RESERVED_17 = 95UL,
      FI_EN_KEY_RESERVED_18 = 96UL,
      FI_EN_KEY_RESERVED_19 = 97UL,
      FI_EN_KBD_VIRTUAL_KEY_DIAG_TIMESLOT_MAUS_ON_OFF = 98UL,
      FI_EN_RESERVEDBA = 99UL,
      FI_EN_KBD_BZL_HK_0 = 100UL,
      FI_EN_KBD_BZL_HK_1 = 101UL,
      FI_EN_KBD_BZL_HK_2 = 102UL,
      FI_EN_KBD_BZL_HK_3 = 103UL,
      FI_EN_KBD_BZL_HK_4 = 104UL,
      FI_EN_KBD_BZL_HK_5 = 105UL,
      FI_EN_KBD_BZL_HK_6 = 106UL,
      FI_EN_KBD_BZL_HK_7 = 107UL,
      FI_EN_KBD_BZL_HK_8 = 108UL,
      FI_EN_KBD_BZL_HK_9 = 109UL,
      FI_EN_KBD_BZL_HK_STAR = 110UL,
      FI_EN_KBD_BZL_HK_HASH = 111UL,
      FI_EN_KBD_BZL_HK_CD = 112UL,
      FI_EN_KBD_BZL_HK_AUX = 113UL,
      FI_EN_KBD_BZL_HK_ILLUM = 114UL,
      FI_EN_KBD_BZL_HK_ONOFF = 115UL,
      FI_EN_KBD_BZL_HK_XMTUNER = 116UL,
      FI_EN_KBD_BZL_HK_CAM = 117UL
   };
   tenType enType;

   midw_fi_tcl_e8_KeyCode(midw_fi_tcl_e8_KeyCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_KeyCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_KeyCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EncoderCode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EncoderCode();
   enum tenType {
      FI_EN_INC_BZL_NONE = 0UL,
      FI_EN_INC_BZL_VOL = 1UL,
      FI_EN_INC_BZL_LTEMP = 2UL,
      FI_EN_INC_BZL_RTEMP = 3UL,
      FI_EN_ENCODER_VOLUME = 4UL,
      FI_EN_ENCODER_MULTIFUNCTION = 5UL,
      FI_EN_INC_BZL_SELECT = 6UL,
      FI_EN_INC_SWC_VOLUME = 10UL,
      FI_EN_INC_SWC_UP_DOWN = 11UL
   };
   tenType enType;

   midw_fi_tcl_e8_EncoderCode(midw_fi_tcl_e8_EncoderCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EncoderCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EncoderCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EncoderDirection : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EncoderDirection();
   enum tenType {
      FI_EN_INC_DIR_NONE = 0UL,
      FI_EN_INC_DIR_LEFT = 1UL,
      FI_EN_INC_DIR_RIGHT = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_EncoderDirection(midw_fi_tcl_e8_EncoderDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EncoderDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EncoderDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_KeyEnc : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_KeyEnc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_KeyEnc& operator=(const midw_fi_tcl_KeyEnc& coRef);
   midw_fi_tcl_KeyEnc(const midw_fi_tcl_KeyEnc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EncoderDirection e8EncoderDirection;
   midw_fi_tcl_e8_EncoderCode e8EncoderCode;
   tU8 u8Steps;
   virtual ~midw_fi_tcl_KeyEnc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_KeyEnc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8AuxInInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8AuxInInfo();
   enum tenType {
      FI_EN_AUXIN_STATUS_NONE = 0UL,
      FI_EN_AUXIN_STATUS_CONNECTED = 1UL,
      FI_EN_AUXIN_STATUS_NOTCONNECTED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8AuxInInfo(midw_fi_tcl_e8AuxInInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8AuxInInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8AuxInInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagCANStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagCANStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiagCANStatus& operator=(const midw_fi_tcl_DiagCANStatus& coRef);
   midw_fi_tcl_DiagCANStatus(const midw_fi_tcl_DiagCANStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32SignalStatus;
   tU8 u8CAN0;
   tU8 u8CAN1;
   tU8 u8CAN2;
   tU8 u8CAN3;
   virtual ~midw_fi_tcl_DiagCANStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiagCANStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagEncoderStatus : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagEncoderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiagEncoderStatus& operator=(const midw_fi_tcl_DiagEncoderStatus& coRef);
   midw_fi_tcl_DiagEncoderStatus(const midw_fi_tcl_DiagEncoderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EncoderCode e8EncoderCode;
   tU8 u8Ticks;
   virtual ~midw_fi_tcl_DiagEncoderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiagEncoderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagKeyList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagKeyList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiagKeyList& operator=(const midw_fi_tcl_DiagKeyList& coRef);
   midw_fi_tcl_DiagKeyList(const midw_fi_tcl_DiagKeyList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_e8_KeyCode, std::allocator<midw_fi_tcl_e8_KeyCode> > e8KeyCode;
   virtual ~midw_fi_tcl_DiagKeyList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiagKeyList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_KeyList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_KeyList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_KeyList& operator=(const midw_fi_tcl_KeyList& coRef);
   midw_fi_tcl_KeyList(const midw_fi_tcl_KeyList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > KeyCode;
   virtual ~midw_fi_tcl_KeyList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_KeyList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_EncoderValuesList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_EncoderValuesList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_EncoderValuesList& operator=(const midw_fi_tcl_EncoderValuesList& coRef);
   midw_fi_tcl_EncoderValuesList(const midw_fi_tcl_EncoderValuesList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tS8, std::allocator<tS8> > EncoderValue;
   virtual ~midw_fi_tcl_EncoderValuesList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_EncoderValuesList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TouchCoordinateList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TouchCoordinateList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TouchCoordinateList& operator=(const midw_fi_tcl_TouchCoordinateList& coRef);
   midw_fi_tcl_TouchCoordinateList(const midw_fi_tcl_TouchCoordinateList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > TouchPosition;
   virtual ~midw_fi_tcl_TouchCoordinateList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TouchCoordinateList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_DiagEncoderStatusList : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_DiagEncoderStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_DiagEncoderStatusList& operator=(const midw_fi_tcl_DiagEncoderStatusList& coRef);
   midw_fi_tcl_DiagEncoderStatusList(const midw_fi_tcl_DiagEncoderStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_DiagEncoderStatus, std::allocator<midw_fi_tcl_DiagEncoderStatus> > DiagEncoderStatus;
   virtual ~midw_fi_tcl_DiagEncoderStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_DiagEncoderStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EXT_RD_StatusAction : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EXT_RD_StatusAction();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_GET = 1UL,
      FI_EN_START = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_EXT_RD_StatusAction(midw_fi_tcl_e8_EXT_RD_StatusAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EXT_RD_StatusAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EXT_RD_StatusAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EXT_RD_SetReason : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EXT_RD_SetReason();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SPONTANEOUS = 1UL,
      FI_EN_ONGET = 2UL,
      FI_EN_ONSTART = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_EXT_RD_SetReason(midw_fi_tcl_e8_EXT_RD_SetReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EXT_RD_SetReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EXT_RD_SetReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EXT_RD_AudioControl : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EXT_RD_AudioControl();
   enum tenType {
      FI_EN_ABORT = 0UL,
      FI_EN_NEXT = 1UL,
      FI_EN_PREVIOUS = 2UL,
      FI_EN_FASTFORWARD = 3UL,
      FI_EN_FASTBACKWARD = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_EXT_RD_AudioControl(midw_fi_tcl_e8_EXT_RD_AudioControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EXT_RD_AudioControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EXT_RD_AudioControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_EXT_RD_AudioControlResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_EXT_RD_AudioControlResult();
   enum tenType {
      FI_EN_SUCCESS = 0UL,
      FI_EN_NOSUCCESS = 1UL,
      FI_EN_ABORTSUCCESS = 2UL,
      FI_EN_ABORTNOSUCCESS = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_EXT_RD_AudioControlResult(midw_fi_tcl_e8_EXT_RD_AudioControlResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_EXT_RD_AudioControlResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_EXT_RD_AudioControlResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_PageIndex : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_PageIndex();
   enum tenType {
      FI_EN_PAGE_INVALID = 0UL,
      FI_EN_PAGE1 = 1UL,
      FI_EN_PAGE2 = 2UL,
      FI_EN_PAGE3 = 3UL,
      FI_EN_VAL_PAGE1 = 4UL,
      FI_EN_VAL_PAGE2 = 5UL
   };
   tenType enType;

   midw_fi_tcl_e8_PageIndex(midw_fi_tcl_e8_PageIndex::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_PageIndex();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_PageIndex& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CalibStatusToHMI : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CalibStatusToHMI();
   enum tenType {
      FI_EN_CALIB_UNKNOWN = 0UL,
      FI_EN_CALIB_SUCCESS = 1UL,
      FI_EN_CALIB_FAILURE = 2UL,
      FI_EN_CALIB_ABORT = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_CalibStatusToHMI(midw_fi_tcl_e8_CalibStatusToHMI::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CalibStatusToHMI();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CalibStatusToHMI& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CalibrationPoint : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CalibrationPoint();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CalibrationPoint& operator=(const midw_fi_tcl_CalibrationPoint& coRef);
   midw_fi_tcl_CalibrationPoint(const midw_fi_tcl_CalibrationPoint& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PageIndex e8PageIndex;
   tU16 u16X;
   tU16 u16Y;
   virtual ~midw_fi_tcl_CalibrationPoint();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CalibrationPoint& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_CalibrationMatrix : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_CalibrationMatrix();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_CalibrationMatrix& operator=(const midw_fi_tcl_CalibrationMatrix& coRef);
   midw_fi_tcl_CalibrationMatrix(const midw_fi_tcl_CalibrationMatrix& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Version;
   tS32 s32An;
   tS32 s32Bn;
   tS32 s32Cn;
   tS32 s32Dn;
   tS32 s32En;
   tS32 s32Fn;
   tS32 s32Divider;
   virtual ~midw_fi_tcl_CalibrationMatrix();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_CalibrationMatrix& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_VDKBD_MethodResult : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_VDKBD_MethodResult();
   enum tenType {
      FI_EN_VDKBD_RES_ACCEPTED = 1UL,
      FI_EN_VDKBD_RES_NOT_ACCEPTED = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_VDKBD_MethodResult(midw_fi_tcl_e8_VDKBD_MethodResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_VDKBD_MethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_VDKBD_MethodResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_CalibrationType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_CalibrationType();
   enum tenType {
      FI_EN_VDKBD_USER_CALIBRATION = 1UL,
      FI_EN_VDKBD_FACTORY_CALIBRATION = 2UL
   };
   tenType enType;

   midw_fi_tcl_e8_CalibrationType(midw_fi_tcl_e8_CalibrationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_CalibrationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_CalibrationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_Response : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_Response();
   enum tenType {
      FI_EN_RES_OK = 0UL,
      FI_EN_RES_FAILED = 1UL,
      FI_EN_RES_NOT_AVAILABLE = 2UL,
      FI_EN_RES_INPROCESS = 3UL
   };
   tenType enType;

   midw_fi_tcl_e8_Response(midw_fi_tcl_e8_Response::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_Response();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_Response& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_UriSelectState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_UriSelectState();
   enum tenType {
      FI_EN_URI_SELECT_STATE_OK = 0UL,
      FI_EN_URI_SELECT_STATE_NOT_VALID = 1UL,
      FI_EN_URI_SELECT_STATE_NO_RESOURCES = 4UL,
      FI_EN_URI_SELECT_STATE_URI_NOT_VALID = 5UL,
      FI_EN_URI_SELECT_STATE_ALREADY_SELECTED = 17UL,
      FI_EN_URI_SELECT_STATE_NOT_SELECTED = 18UL,
      FI_EN_URI_SELECT_STATE_URI_PROCESSING = 32UL,
      FI_EN_URI_SELECT_STATE_URI_ACTIVATED = 33UL,
      FI_EN_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER = 34UL,
      FI_EN_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION = 35UL,
      FI_EN_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER = 36UL,
      FI_EN_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS = 37UL,
      FI_EN_URI_SELECT_STATE_ERROR = 65535UL
   };
   tenType enType;

   midw_fi_tcl_e8_UriSelectState(midw_fi_tcl_e8_UriSelectState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_UriSelectState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_UriSelectState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegUriChannel : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegUriChannel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegUriChannel& operator=(const midw_fi_tcl_TpegUriChannel& coRef);
   midw_fi_tcl_TpegUriChannel(const midw_fi_tcl_TpegUriChannel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sTpegUriChn;
   midw_fi_tcl_e8_UriSelectState TpegUriSelectState;
   tBool bActive;
   virtual ~midw_fi_tcl_TpegUriChannel();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegUriChannel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TpegInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TpegInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TpegInfo& operator=(const midw_fi_tcl_TpegInfo& coRef);
   midw_fi_tcl_TpegInfo(const midw_fi_tcl_TpegInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > TpegData;
   virtual ~midw_fi_tcl_TpegInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TpegInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TrafficRdbidValue : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TrafficRdbidValue();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TrafficRdbidValue& operator=(const midw_fi_tcl_TrafficRdbidValue& coRef);
   midw_fi_tcl_TrafficRdbidValue(const midw_fi_tcl_TrafficRdbidValue& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8RdbidCC;
   tU8 u8RdbidLTN;
   tU16 u16Bsa;
   tU8 u8RdbidSID;
   tBool bEncFlag;
   virtual ~midw_fi_tcl_TrafficRdbidValue();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TrafficRdbidValue& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_TrafficTmcApplicationId : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_TrafficTmcApplicationId();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_TMCDATA = 52550UL,
      FI_EN_INVALID_TYPE = 65535UL
   };
   tenType enType;

   midw_fi_tcl_e16_TrafficTmcApplicationId(midw_fi_tcl_e16_TrafficTmcApplicationId::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e16_TrafficTmcApplicationId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e16_TrafficTmcApplicationId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TrafficEncryption : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TrafficEncryption();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TrafficEncryption& operator=(const midw_fi_tcl_TrafficEncryption& coRef);
   midw_fi_tcl_TrafficEncryption(const midw_fi_tcl_TrafficEncryption& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Encrypted;
   tU8 Encid;
   tU8 TestBits;
   virtual ~midw_fi_tcl_TrafficEncryption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TrafficEncryption& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TrafficTmcMediumType : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TrafficTmcMediumType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_DAB = 2UL,
      FI_EN_SATELLITE = 3UL,
      FI_EN_INTERNET = 4UL,
      FI_EN_INVALID_TYPE = 255UL
   };
   tenType enType;

   midw_fi_tcl_e8_TrafficTmcMediumType(midw_fi_tcl_e8_TrafficTmcMediumType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TrafficTmcMediumType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TrafficTmcMediumType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_TrafficMsgSource : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_TrafficMsgSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_TrafficMsgSource& operator=(const midw_fi_tcl_TrafficMsgSource& coRef);
   midw_fi_tcl_TrafficMsgSource(const midw_fi_tcl_TrafficMsgSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TrafficTmcMediumType MediumTypeId;
   tU8 Number;
   virtual ~midw_fi_tcl_TrafficMsgSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_TrafficMsgSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e16_TrafficInfo : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e16_TrafficInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_fi_tcl_e16_TrafficInfo& operator=(const midw_fi_tcl_e16_TrafficInfo& coRef);
   midw_fi_tcl_e16_TrafficInfo(const midw_fi_tcl_e16_TrafficInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TrafficRdbidValue RDBId;
   tS16 ECC;
   midw_fi_tcl_e16_TrafficTmcApplicationId ApplicationId;
   std::vector<tU8, std::allocator<tU8> > ListOf8AData;
   tU16 ProgramID;
   midw_fi_tcl_TrafficEncryption Encryption;
   midw_fi_tcl_TrafficMsgSource MsgSource;
   midw_fi_tclString ProgramServiceName;
   midw_fi_tclString ServiceProviderName;
   virtual ~midw_fi_tcl_e16_TrafficInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_fi_tcl_e16_TrafficInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_OperationMode : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_OperationMode();
   enum tenType {
      FI_EN_TUNER_OP_MODE_INITIAL = 0UL,
      FI_EN_TUNER_OP_MODE_FULLY_OPERABLE = 1UL,
      FI_EN_TUNER_OP_MODE_ERROR = 2UL,
      FI_EN_TUNER_OP_MODE_DIAGNOSIS = 3UL,
      FI_EN_TUNER_OP_MODE_CHN_UNAVAILABLE = 4UL,
      FI_EN_TUNER_OP_MODE_CHN_OFF_AIR = 5UL,
      FI_EN_TUNER_OP_MODE_CHN_UNAUTHORIZED = 6UL,
      FI_EN_TUNER_OP_MODE_NO_SIGNAL = 7UL,
      FI_EN_TUNER_OP_MODE_XM_DEACTIVATED = 8UL,
      FI_EN_TUNER_OP_MODE_SERVICE_DEACTIVATED = 9UL
   };
   tenType enType;

   midw_fi_tcl_e8_OperationMode(midw_fi_tcl_e8_OperationMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_OperationMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_OperationMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunerState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunerState();
   enum tenType {
      FI_EN_TUNER_STATE_ON = 0UL,
      FI_EN_TUNER_STATE_OFF = 1UL,
      FI_EN_TUNER_STATE_NO_DATA = 2UL,
      FI_EN_TUNER_STATE_TEMP_NOT_AVAILABLE = 3UL,
      FI_EN_TUNER_STATE_TEMP_NO_DATA = 4UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunerState(midw_fi_tcl_e8_TunerState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunerState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunerState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

class midw_fi_tcl_e8_TunerReceptionState : public midw_fi_tclVisitableTypeBase
{
public:

   midw_fi_tcl_e8_TunerReceptionState();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OK = 1UL,
      FI_EN_NOTSUBSCRIBED = 2UL,
      FI_EN_NOTAVAILABLE = 3UL,
      FI_EN_NOANTENNA = 4UL,
      FI_EN_NOSIGNAL = 5UL,
      FI_EN_TEMPORARYNOTAVAILABLE = 6UL
   };
   tenType enType;

   midw_fi_tcl_e8_TunerReceptionState(midw_fi_tcl_e8_TunerReceptionState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_fi_tcl_e8_TunerReceptionState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_fi_tcl_e8_TunerReceptionState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_fi_tclVisitorBase& rfoVisitor);
};

#endif
