/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_TUNER_FI message types

fi_tclMessageBase* midw_tunerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCYMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCYMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATSEEK_WITH_TUNERHEADERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATSEEK_WITH_TUNERHEADERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_S_TUN_GET_FIELD_STRENGTHMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_S_TUN_GET_FIELD_STRENGTHMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ACTIVE_PRESETLISTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ACTIVE_PRESETLISTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_FEATUREMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_FEATUREMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HICUTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HICUTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AFLIST_V2METHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AFLIST_V2METHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2METHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2METHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DIRECT_FREQUENCYMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DIRECT_FREQUENCYMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUTOSTOREMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUTOSTOREMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_LIST_ELEMMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_LIST_ELEMMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_CONFIG_LISTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_CONFIG_LISTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_FG_BG_NEWMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_FG_BG_NEWMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_PIMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_PIMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_SHARXLEVELMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_SHARXLEVELMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_STATIC_LISTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_STATIC_LISTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SETUP_DDADDSMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SETUP_DDADDSMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_HANDLINGMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_HANDLINGMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PS_FREEZEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PS_FREEZEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUTOCOMP_PARAMMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUTOCOMP_PARAMMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_RDBIDMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_RDBIDMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CALIBRATION_DATAMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CALIBRATION_DATAMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ACTIVE_TUNERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ACTIVE_TUNERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_STATIONLIST_EXITMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_STATIONLIST_EXITMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SURVEIL_TPMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SURVEIL_TPMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ENGG_PARAMETERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ENGG_PARAMETERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_SWITCHMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_SWITCHMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_ESCAPEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_ESCAPEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_STORAGE_PS_FREEZEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_STORAGE_PS_FREEZEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SPEED_INFOMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SPEED_INFOMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_MUTEREQUESTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_MUTEREQUESTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CONFIGLIST_UPDATEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CONFIGLIST_UPDATEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DEFAULT_SETTINGMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DEFAULT_SETTINGMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DEMODULATION_SWITCHMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DEMODULATION_SWITCHMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_DRM_AUDIOPRGMMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_DRM_AUDIOPRGMMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_DEVICEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_DEVICEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DRM_SRCACTIVITYMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DRM_SRCACTIVITYMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_TESTMODEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_TESTMODEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_HD_AUDIOPRGMMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_HD_AUDIOPRGMMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_HD_RESET_TRANSITIONCOUNTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_HD_RESET_TRANSITIONCOUNTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUDIO_SPLIT_MODEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUDIO_SPLIT_MODEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HD_SECTION_PARAMETERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HD_SECTION_PARAMETERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_TESTMODEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_TESTMODEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_RESET_MUTECOUNTERMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_RESET_MUTECOUNTERMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AFMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AFMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CHANGE_LSMMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CHANGE_LSMMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_VICS_FREQUENCY_LISTMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_VICS_FREQUENCY_LISTMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SET_AREAMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SET_AREAMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_CHANGE_STATION_NAMEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_CHANGE_STATION_NAMEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_LANGUAGE_SETTINGMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_LANGUAGE_SETTINGMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SELECT_STATION_NAMEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SELECT_STATION_NAMEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_USER_PROFILE_UPDATEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_USER_PROFILE_UPDATEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESETLIST_CONTENT_UPDATEMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESETLIST_CONTENT_UPDATEMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DISABLE_BANDMETHODSTART:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DISABLE_BANDMETHODRESULT:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATAGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATUREUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATURERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATUREGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATURESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2UPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2RELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2GET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2STATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDAGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODEGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFORELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFORELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFORELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFORELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGEGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFOUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFORELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFOSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMEGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATEUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATERELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATEGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATESTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREAUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREARELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREAGET:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREASTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRELUPREG:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg;

      case midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYSTATUS:
         return OSAL_NEW midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_tunerfifi messages

// common functions

tU16 midw_tunerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_TUNERFI_C_U16_SERVICE_ID;
}

tU16 midw_tunerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_tunerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_tunerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_tunerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_tunerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_tunerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_tunerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   ManualFreqAdjustment = coRef.ManualFreqAdjustment;
   TunerHeader = coRef.TunerHeader;
}
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ManualFreqAdjustment = coRef.ManualFreqAdjustment;
   TunerHeader = coRef.TunerHeader;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart()
:ManualFreqAdjustment()
,TunerHeader()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ManualFreqAdjustment);
   (tVoid) (oIn >> TunerHeader);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ManualFreqAdjustment);
   (tVoid) (oOut << TunerHeader);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ManualFreqAdjustment == roRef.ManualFreqAdjustment);
   bResult = bResult && (TunerHeader == roRef.TunerHeader);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerHeader = coRef.TunerHeader;
   TunerManualSingleStep = coRef.TunerManualSingleStep;
   u8AcceptAF = coRef.u8AcceptAF;
}
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunerHeader = coRef.TunerHeader;
   TunerManualSingleStep = coRef.TunerManualSingleStep;
   u8AcceptAF = coRef.u8AcceptAF;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart()
:TunerHeader()
,TunerManualSingleStep()
,u8AcceptAF()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCYMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerHeader);
   (tVoid) (oIn >> TunerManualSingleStep);
   (tVoid) (oIn >> u8AcceptAF);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerHeader);
   (tVoid) (oOut << TunerManualSingleStep);
   (tVoid) (oOut << u8AcceptAF);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerHeader == roRef.TunerHeader);
   bResult = bResult && (TunerManualSingleStep == roRef.TunerManualSingleStep);
   bResult = bResult && (u8AcceptAF == roRef.u8AcceptAF);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATFREQUENCYMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8TunerSeek = coRef.u8TunerSeek;
   u8TunerHeader = coRef.u8TunerHeader;
   u32Frequency = coRef.u32Frequency;
}
midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8TunerSeek = coRef.u8TunerSeek;
   u8TunerHeader = coRef.u8TunerHeader;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart()
:u8TunerSeek()
,u8TunerHeader()
,u32Frequency(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATSEEK_WITH_TUNERHEADERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerSeek);
   (tVoid) (oIn >> u8TunerHeader);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerSeek);
   (tVoid) (oOut << u8TunerHeader);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerSeek == roRef.u8TunerSeek);
   bResult = bResult && (u8TunerHeader == roRef.u8TunerHeader);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ATSEEK_WITH_TUNERHEADERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart::midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_S_TUN_GET_FIELD_STRENGTHMETHODSTART;
}


midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart::~midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Tuner_Field_Strength = coRef.Tuner_Field_Strength;
}
midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::operator=(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Tuner_Field_Strength = coRef.Tuner_Field_Strength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult()
:Tuner_Field_Strength(0)
 {}

tS32 midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_S_TUN_GET_FIELD_STRENGTHMETHODRESULT;
}


midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::~midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Tuner_Field_Strength);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Tuner_Field_Strength);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult::operator==(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Tuner_Field_Strength == roRef.Tuner_Field_Strength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ListID = coRef.e8ListID;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListID = coRef.e8ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart()
:e8ListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ACTIVE_PRESETLISTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListID == roRef.e8ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ACTIVE_PRESETLISTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerFeature = coRef.TunerFeature;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunerFeature = coRef.TunerFeature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart()
:TunerFeature()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_FEATUREMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerFeature);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerFeature);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerFeature == roRef.TunerFeature);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_FEATUREMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8AbsVal = coRef.u8AbsVal;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8AbsVal = coRef.u8AbsVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart()
:u8AbsVal(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HICUTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AbsVal);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AbsVal);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AbsVal == roRef.u8AbsVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HICUTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8Notification = coRef.u8Notification;
}
midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Notification = coRef.u8Notification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart()
:u8Notification()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AFLIST_V2METHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::~midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Notification);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Notification);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Notification == roRef.u8Notification);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AFLIST_V2METHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::~midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8PhysicalTunerId = coRef.u8PhysicalTunerId;
   u8Mode = coRef.u8Mode;
   u32Frequency = coRef.u32Frequency;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8PhysicalTunerId = coRef.u8PhysicalTunerId;
   u8Mode = coRef.u8Mode;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart()
:u8PhysicalTunerId()
,u8Mode()
,u32Frequency(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2METHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8PhysicalTunerId);
   (tVoid) (oIn >> u8Mode);
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8PhysicalTunerId);
   (tVoid) (oOut << u8Mode);
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8PhysicalTunerId == roRef.u8PhysicalTunerId);
   bResult = bResult && (u8Mode == roRef.u8Mode);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2METHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32Frequency = coRef.u32Frequency;
   u8Band = coRef.u8Band;
}
midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   u8Band = coRef.u8Band;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart()
:u32Frequency(0)
,u8Band()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DIRECT_FREQUENCYMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u8Band);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u8Band);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u8Band == roRef.u8Band);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DIRECT_FREQUENCYMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bStatus = coRef.bStatus;
   e8ListID = coRef.e8ListID;
}
midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bStatus = coRef.bStatus;
   e8ListID = coRef.e8ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart()
:bStatus(0)
,e8ListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUTOSTOREMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatus);
   (tVoid) (oIn >> e8ListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatus);
   (tVoid) (oOut << e8ListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatus == roRef.bStatus);
   bResult = bResult && (e8ListID == roRef.e8ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUTOSTOREMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Sel_List_Elem = coRef.Sel_List_Elem;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Sel_List_Elem = coRef.Sel_List_Elem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart()
:Sel_List_Elem()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_LIST_ELEMMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sel_List_Elem);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sel_List_Elem);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sel_List_Elem == roRef.Sel_List_Elem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_LIST_ELEMMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunMakeConfigList = coRef.TunMakeConfigList;
}
midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunMakeConfigList = coRef.TunMakeConfigList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart()
:TunMakeConfigList()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_CONFIG_LISTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunMakeConfigList);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunMakeConfigList);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunMakeConfigList == roRef.TunMakeConfigList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunMakeConfigListElem = coRef.TunMakeConfigListElem;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunMakeConfigListElem = coRef.TunMakeConfigListElem;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult()
:TunMakeConfigListElem()
,TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_CONFIG_LISTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunMakeConfigListElem);
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunMakeConfigListElem);
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunMakeConfigListElem == roRef.TunMakeConfigListElem);
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunAudFGBGNew = coRef.TunAudFGBGNew;
}
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunAudFGBGNew = coRef.TunAudFGBGNew;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart()
:TunAudFGBGNew()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_FG_BG_NEWMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunAudFGBGNew);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunAudFGBGNew);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunAudFGBGNew == roRef.TunAudFGBGNew);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   TunAudioFgBgStatus = coRef.TunAudioFgBgStatus;
}
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   TunAudioFgBgStatus = coRef.TunAudioFgBgStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult()
:TunerServer_StatusResponse()
,TunAudioFgBgStatus()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_FG_BG_NEWMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   (tVoid) (oIn >> TunAudioFgBgStatus);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   (tVoid) (oOut << TunAudioFgBgStatus);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   bResult = bResult && (TunAudioFgBgStatus == roRef.TunAudioFgBgStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunSetPIPara = coRef.TunSetPIPara;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunSetPIPara = coRef.TunSetPIPara;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart()
:TunSetPIPara()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_PIMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunSetPIPara);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunSetPIPara);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunSetPIPara == roRef.TunSetPIPara);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_PIMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8SharxStep = coRef.u8SharxStep;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SharxStep = coRef.u8SharxStep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart()
:u8SharxStep(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_SHARXLEVELMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SharxStep);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SharxStep);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SharxStep == roRef.u8SharxStep);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_SHARXLEVELMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ListID = coRef.e8ListID;
}
midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListID = coRef.e8ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart()
:e8ListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_STATIC_LISTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListID == roRef.e8ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_GET_STATIC_LISTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   DDADDS_Mode = coRef.DDADDS_Mode;
}
midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DDADDS_Mode = coRef.DDADDS_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart()
:DDADDS_Mode()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SETUP_DDADDSMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DDADDS_Mode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DDADDS_Mode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DDADDS_Mode == roRef.DDADDS_Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SETUP_DDADDSMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   u8ListElementID = coRef.u8ListElementID;
   e8ListID = coRef.e8ListID;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   u16SecondaryPI = coRef.u16SecondaryPI;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   u8ListElementID = coRef.u8ListElementID;
   e8ListID = coRef.e8ListID;
   u32Frequency = coRef.u32Frequency;
   u16PI = coRef.u16PI;
   u16SecondaryPI = coRef.u16SecondaryPI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart()
:e8Action()
,u8ListElementID(0)
,e8ListID()
,u32Frequency(0)
,u16PI(0)
,u16SecondaryPI(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_HANDLINGMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8ListElementID);
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> u16SecondaryPI);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8ListElementID);
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << u16SecondaryPI);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8ListElementID == roRef.u8ListElementID);
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (u16SecondaryPI == roRef.u16SecondaryPI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult()
:e8Action()
,TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_HANDLINGMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bPSFreeze = coRef.bPSFreeze;
}
midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bPSFreeze = coRef.bPSFreeze;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart()
:bPSFreeze(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PS_FREEZEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bPSFreeze);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bPSFreeze);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bPSFreeze == roRef.bPSFreeze);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PS_FREEZEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunAutoCompParam = coRef.TunAutoCompParam;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunAutoCompParam = coRef.TunAutoCompParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart()
:TunAutoCompParam()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUTOCOMP_PARAMMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunAutoCompParam);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunAutoCompParam);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunAutoCompParam == roRef.TunAutoCompParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUTOCOMP_PARAMMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8NumOfRDBID = coRef.u8NumOfRDBID;
   TunRDBID_Value = coRef.TunRDBID_Value;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfRDBID = coRef.u8NumOfRDBID;
   TunRDBID_Value = coRef.TunRDBID_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         TunRDBID_Value[u32Idx].vDestroy();
   TunRDBID_Value.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart()
:u8NumOfRDBID(0)

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_RDBIDMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(TunRDBID_Value.size()*4);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfRDBID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
      {
         TunRDBID_Value[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunRDBID_Value.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunRDBID_Value[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfRDBID);
   (tVoid) (oOut << (tU32)TunRDBID_Value.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         (tVoid) (oOut << TunRDBID_Value[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfRDBID == roRef.u8NumOfRDBID);
      bResult = bResult && (TunRDBID_Value.size() == roRef.TunRDBID_Value.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunRDBID_Value.size()); ++u32Idx)
            bResult = bResult && (TunRDBID_Value[u32Idx] == roRef.TunRDBID_Value[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunRDBID_Value = coRef.TunRDBID_Value;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunRDBID_Value = coRef.TunRDBID_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         TunRDBID_Value[u32Idx].vDestroy();
   TunRDBID_Value.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult()

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_RDBIDMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TunRDBID_Value.size()*4);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
      {
         TunRDBID_Value[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunRDBID_Value.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunRDBID_Value[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunRDBID_Value.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         (tVoid) (oOut << TunRDBID_Value[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunRDBID_Value.size() == roRef.TunRDBID_Value.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunRDBID_Value.size()); ++u32Idx)
            bResult = bResult && (TunRDBID_Value[u32Idx] == roRef.TunRDBID_Value[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart::midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CALIBRATION_DATAMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CALIBRATION_DATAMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ACTIVE_TUNERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8_PhysicalTuner = coRef.u8_PhysicalTuner;
}
midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8_PhysicalTuner = coRef.u8_PhysicalTuner;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult()
:u8_PhysicalTuner()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ACTIVE_TUNERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8_PhysicalTuner);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8_PhysicalTuner);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8_PhysicalTuner == roRef.u8_PhysicalTuner);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
   bFrozenList = coRef.bFrozenList;
}
midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   bFrozenList = coRef.bFrozenList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart()
:e8ConfigListID()
,bFrozenList(true)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_STATIONLIST_EXITMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   (tVoid) (oIn >> bFrozenList);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   (tVoid) (oOut << bFrozenList);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   bResult = bResult && (bFrozenList == roRef.bFrozenList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_STATIONLIST_EXITMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bSurveilTP = coRef.bSurveilTP;
}
midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bSurveilTP = coRef.bSurveilTP;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart()
:bSurveilTP(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SURVEIL_TPMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSurveilTP);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSurveilTP);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSurveilTP == roRef.bSurveilTP);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SURVEIL_TPMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart()
:e8ParameterID()
,u32ParameterValue(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ENGG_PARAMETERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterID);
   (tVoid) (oIn >> u32ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterID);
   (tVoid) (oOut << u32ParameterValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterID == roRef.e8ParameterID);
   bResult = bResult && (u32ParameterValue == roRef.u32ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_ENGG_PARAMETERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   b8AnnoType = coRef.b8AnnoType;
}
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& coRef)
{
   if (this == &coRef) return *this;
   b8AnnoType = coRef.b8AnnoType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart()
:b8AnnoType()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_SWITCHMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8AnnoType);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8AnnoType);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8AnnoType == roRef.b8AnnoType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_SWITCHMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8AnnoType = coRef.e8AnnoType;
}
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8AnnoType = coRef.e8AnnoType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart()
:e8AnnoType()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_ESCAPEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AnnoType);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AnnoType);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AnnoType == roRef.e8AnnoType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_ANNOUNCEMENT_ESCAPEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart()
:e8Mode()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_STORAGE_PS_FREEZEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESET_STORAGE_PS_FREEZEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8Speed = coRef.u8Speed;
}
midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Speed = coRef.u8Speed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart()
:u8Speed(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SPEED_INFOMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Speed);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Speed);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Speed == roRef.u8Speed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SPEED_INFOMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_MUTEREQUESTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_MUTEREQUESTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
   bStatus = coRef.bStatus;
}
midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   bStatus = coRef.bStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart()
:e8ConfigListID()
,bStatus(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CONFIGLIST_UPDATEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   (tVoid) (oIn >> bStatus);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   (tVoid) (oOut << bStatus);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   bResult = bResult && (bStatus == roRef.bStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CONFIGLIST_UPDATEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8DefaultSettingOption = coRef.e8DefaultSettingOption;
}
midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DefaultSettingOption = coRef.e8DefaultSettingOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart()
:e8DefaultSettingOption()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DEFAULT_SETTINGMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DefaultSettingOption);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DefaultSettingOption);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DefaultSettingOption == roRef.e8DefaultSettingOption);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DEFAULT_SETTINGMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   DemodulationSwitch = coRef.DemodulationSwitch;
   b8DemodulationSwitchMask = coRef.b8DemodulationSwitchMask;
   b8DemodulationSwitchValue = coRef.b8DemodulationSwitchValue;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DemodulationSwitch = coRef.DemodulationSwitch;
   b8DemodulationSwitchMask = coRef.b8DemodulationSwitchMask;
   b8DemodulationSwitchValue = coRef.b8DemodulationSwitchValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart()
:DemodulationSwitch()
,b8DemodulationSwitchMask()
,b8DemodulationSwitchValue()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DEMODULATION_SWITCHMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DemodulationSwitch);
   (tVoid) (oIn >> b8DemodulationSwitchMask);
   (tVoid) (oIn >> b8DemodulationSwitchValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DemodulationSwitch);
   (tVoid) (oOut << b8DemodulationSwitchMask);
   (tVoid) (oOut << b8DemodulationSwitchValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DemodulationSwitch == roRef.DemodulationSwitch);
   bResult = bResult && (b8DemodulationSwitchMask == roRef.b8DemodulationSwitchMask);
   bResult = bResult && (b8DemodulationSwitchValue == roRef.b8DemodulationSwitchValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DEMODULATION_SWITCHMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32Frequency = coRef.u32Frequency;
   u32DRMServiceId = coRef.u32DRMServiceId;
}
midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   u32DRMServiceId = coRef.u32DRMServiceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart()
:u32Frequency(0)
,u32DRMServiceId(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_DRM_AUDIOPRGMMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u32DRMServiceId);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u32DRMServiceId);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u32DRMServiceId == roRef.u32DRMServiceId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_DRM_AUDIOPRGMMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   sDRMAudioSinkName = coRef.sDRMAudioSinkName;
}
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDRMAudioSinkName = coRef.sDRMAudioSinkName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::vDestroy()
{
   sDRMAudioSinkName.vDestroy();
}

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart()
:sDRMAudioSinkName()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_DEVICEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDRMAudioSinkName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDRMAudioSinkName);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDRMAudioSinkName);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDRMAudioSinkName == roRef.sDRMAudioSinkName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_AUDIO_DEVICEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8DRMSourceActivity = coRef.e8DRMSourceActivity;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DRMSourceActivity = coRef.e8DRMSourceActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart()
:e8DRMSourceActivity()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DRM_SRCACTIVITYMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DRMSourceActivity);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DRMSourceActivity);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DRMSourceActivity == roRef.e8DRMSourceActivity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_DRM_SRCACTIVITYMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8TestModeSource = coRef.e8TestModeSource;
   e8TestModeActivity = coRef.e8TestModeActivity;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8TestModeSource = coRef.e8TestModeSource;
   e8TestModeActivity = coRef.e8TestModeActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart()
:e8TestModeSource()
,e8TestModeActivity()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_TESTMODEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TestModeSource);
   (tVoid) (oIn >> e8TestModeActivity);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TestModeSource);
   (tVoid) (oOut << e8TestModeActivity);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TestModeSource == roRef.e8TestModeSource);
   bResult = bResult && (e8TestModeActivity == roRef.e8TestModeActivity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_TESTMODEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   SelectMode = coRef.SelectMode;
   e8HDAudioPrg = coRef.e8HDAudioPrg;
   e8Direction = coRef.e8Direction;
}
midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectMode = coRef.SelectMode;
   e8HDAudioPrg = coRef.e8HDAudioPrg;
   e8Direction = coRef.e8Direction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart()
:SelectMode()
,e8HDAudioPrg()
,e8Direction()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_HD_AUDIOPRGMMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectMode);
   (tVoid) (oIn >> e8HDAudioPrg);
   (tVoid) (oIn >> e8Direction);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectMode);
   (tVoid) (oOut << e8HDAudioPrg);
   (tVoid) (oOut << e8Direction);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectMode == roRef.SelectMode);
   bResult = bResult && (e8HDAudioPrg == roRef.e8HDAudioPrg);
   bResult = bResult && (e8Direction == roRef.e8Direction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SELECT_HD_AUDIOPRGMMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32Frequency = coRef.u32Frequency;
   e8HDAudioPrg = coRef.e8HDAudioPrg;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   e8HDAudioPrg = coRef.e8HDAudioPrg;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart()
:u32Frequency(0)
,e8HDAudioPrg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> e8HDAudioPrg);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << e8HDAudioPrg);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (e8HDAudioPrg == roRef.e8HDAudioPrg);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_HD_RESET_TRANSITIONCOUNTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_HD_RESET_TRANSITIONCOUNTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ParameterValue = coRef.e8ParameterValue;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterValue = coRef.e8ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart()
:e8ParameterValue()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUDIO_SPLIT_MODEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterValue == roRef.e8ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AUDIO_SPLIT_MODEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e16Parameter_ID = coRef.e16Parameter_ID;
   s8ParameterValue = coRef.s8ParameterValue;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e16Parameter_ID = coRef.e16Parameter_ID;
   s8ParameterValue = coRef.s8ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart()
:e16Parameter_ID()
,s8ParameterValue(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HD_SECTION_PARAMETERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Parameter_ID);
   (tVoid) (oIn >> s8ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Parameter_ID);
   (tVoid) (oOut << s8ParameterValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Parameter_ID == roRef.e16Parameter_ID);
   bResult = bResult && (s8ParameterValue == roRef.s8ParameterValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_HD_SECTION_PARAMETERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8DRMTestModeActivity = coRef.e8DRMTestModeActivity;
}
midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DRMTestModeActivity = coRef.e8DRMTestModeActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart()
:e8DRMTestModeActivity()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_TESTMODEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DRMTestModeActivity);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DRMTestModeActivity);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DRMTestModeActivity == roRef.e8DRMTestModeActivity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_TESTMODEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_RESET_MUTECOUNTERMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DRM_RESET_MUTECOUNTERMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   b8AFSwitchMask = coRef.b8AFSwitchMask;
   b8AFSwitch = coRef.b8AFSwitch;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& coRef)
{
   if (this == &coRef) return *this;
   b8AFSwitchMask = coRef.b8AFSwitchMask;
   b8AFSwitch = coRef.b8AFSwitch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart()
:b8AFSwitchMask()
,b8AFSwitch()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AFMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8AFSwitchMask);
   (tVoid) (oIn >> b8AFSwitch);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8AFSwitchMask);
   (tVoid) (oOut << b8AFSwitch);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8AFSwitchMask == roRef.b8AFSwitchMask);
   bResult = bResult && (b8AFSwitch == roRef.b8AFSwitch);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_SET_AFMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Option = coRef.Option;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   u8Element_ID = coRef.u8Element_ID;
   e8ListID = coRef.e8ListID;
   PI = coRef.PI;
   HDProgramNumber = coRef.HDProgramNumber;
}
midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Option = coRef.Option;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   u8Element_ID = coRef.u8Element_ID;
   e8ListID = coRef.e8ListID;
   PI = coRef.PI;
   HDProgramNumber = coRef.HDProgramNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart()
:Option()
,Band()
,Frequency(0)
,u8Element_ID(0)
,e8ListID()
,PI(0)
,HDProgramNumber(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CHANGE_LSMMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Option);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> u8Element_ID);
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> PI);
   (tVoid) (oIn >> HDProgramNumber);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Option);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << u8Element_ID);
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << PI);
   (tVoid) (oOut << HDProgramNumber);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Option == roRef.Option);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (u8Element_ID == roRef.u8Element_ID);
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (PI == roRef.PI);
   bResult = bResult && (HDProgramNumber == roRef.HDProgramNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_CHANGE_LSMMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   FrequencyData = coRef.FrequencyData;
}
midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FrequencyData = coRef.FrequencyData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::vDestroy()
{
   FrequencyData.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart()
:FrequencyData()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_VICS_FREQUENCY_LISTMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FrequencyData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FrequencyData);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FrequencyData);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FrequencyData == roRef.FrequencyData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DARC_VICS_FREQUENCY_LISTMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8SelectedRegion = coRef.e8SelectedRegion;
   bAreaSelectionMode = coRef.bAreaSelectionMode;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SelectedRegion = coRef.e8SelectedRegion;
   bAreaSelectionMode = coRef.bAreaSelectionMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart()
:e8SelectedRegion()
,bAreaSelectionMode(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SET_AREAMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectedRegion);
   (tVoid) (oIn >> bAreaSelectionMode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectedRegion);
   (tVoid) (oOut << bAreaSelectionMode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectedRegion == roRef.e8SelectedRegion);
   bResult = bResult && (bAreaSelectionMode == roRef.bAreaSelectionMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SET_AREAMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ChangeStationMode = coRef.e8ChangeStationMode;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ChangeStationMode = coRef.e8ChangeStationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart()
:e8ChangeStationMode()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_CHANGE_STATION_NAMEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ChangeStationMode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ChangeStationMode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ChangeStationMode == roRef.e8ChangeStationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_CHANGE_STATION_NAMEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart()
:e8Language()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_LANGUAGE_SETTINGMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_LANGUAGE_SETTINGMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8SelectMode = coRef.e8SelectMode;
   e8Direction = coRef.e8Direction;
   u16ElementID = coRef.u16ElementID;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SelectMode = coRef.e8SelectMode;
   e8Direction = coRef.e8Direction;
   u16ElementID = coRef.u16ElementID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart()
:e8SelectMode()
,e8Direction()
,u16ElementID(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SELECT_STATION_NAMEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectMode);
   (tVoid) (oIn >> e8Direction);
   (tVoid) (oIn >> u16ElementID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectMode);
   (tVoid) (oOut << e8Direction);
   (tVoid) (oOut << u16ElementID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectMode == roRef.e8SelectMode);
   bResult = bResult && (e8Direction == roRef.e8Direction);
   bResult = bResult && (u16ElementID == roRef.u16ElementID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_JAPAN_SELECT_STATION_NAMEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   UserID = coRef.UserID;
   DestinationUserID = coRef.DestinationUserID;
}
midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   UserID = coRef.UserID;
   DestinationUserID = coRef.DestinationUserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart()
:Action()
,UserID(0)
,DestinationUserID(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_USER_PROFILE_UPDATEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> DestinationUserID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << DestinationUserID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (DestinationUserID == roRef.DestinationUserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   ActiveUserID = coRef.ActiveUserID;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   ActiveUserID = coRef.ActiveUserID;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult()
:Action()
,ActiveUserID(0)
,TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_USER_PROFILE_UPDATEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ActiveUserID);
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ActiveUserID);
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ActiveUserID == roRef.ActiveUserID);
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   UserID = coRef.UserID;
   Tun_ListElements = coRef.Tun_ListElements;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UserID = coRef.UserID;
   Tun_ListElements = coRef.Tun_ListElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::vDestroy()
{
   Tun_ListElements.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart()
:UserID(0)
,Tun_ListElements()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESETLIST_CONTENT_UPDATEMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Tun_ListElements.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> Tun_ListElements);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << Tun_ListElements);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (Tun_ListElements == roRef.Tun_ListElements);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_PRESETLIST_CONTENT_UPDATEMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8Band = coRef.u8Band;
}
midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Band = coRef.u8Band;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart()
:u8Band()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DISABLE_BANDMETHODSTART;
}


midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::~midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Band);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Band);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Band == roRef.u8Band);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
}
midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::operator=(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerServer_StatusResponse = coRef.TunerServer_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult()
:TunerServer_StatusResponse()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_S_DISABLE_BANDMETHODRESULT;
}


midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::~midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerServer_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerServer_StatusResponse);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult::operator==(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerServer_StatusResponse == roRef.TunerServer_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg::midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet::midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATAGET;
}


midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet::~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   CalibrationData = coRef.CalibrationData;
   CalibrationDataValues = coRef.CalibrationDataValues;
}
midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   CalibrationData = coRef.CalibrationData;
   CalibrationDataValues = coRef.CalibrationDataValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::vDestroy()
{
   CalibrationData.vDestroy(); 
   CalibrationDataValues.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus()
:CalibrationData()
,CalibrationDataValues()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_CALIBRATION_DATASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 20+CalibrationData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CalibrationData);
   (tVoid) (oIn >> CalibrationDataValues);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CalibrationData);
   (tVoid) (oOut << CalibrationDataValues);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CalibrationData == roRef.CalibrationData);
   bResult = bResult && (CalibrationDataValues == roRef.CalibrationDataValues);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATUREUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATURERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet::midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATUREGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   b32_Features = coRef.b32_Features;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& coRef)
{
   if (this == &coRef) return *this;
   b32_Features = coRef.b32_Features;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus()
:b32_Features()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_FEATURESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32_Features);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32_Features);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32_Features == roRef.b32_Features);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet::midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8AbsVal = coRef.u8AbsVal;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& coRef)
{
   if (this == &coRef) return *this;
   u8AbsVal = coRef.u8AbsVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus()
:u8AbsVal(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_HICUTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AbsVal);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AbsVal);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AbsVal == roRef.u8AbsVal);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg::midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2UPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg::~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg::midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2RELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get::midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2GET;
}


midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get::~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8LengthOfAFList = coRef.u8LengthOfAFList;
   TunerAFList = coRef.TunerAFList;
}
midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::operator=(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& coRef)
{
   if (this == &coRef) return *this;
   u8LengthOfAFList = coRef.u8LengthOfAFList;
   TunerAFList = coRef.TunerAFList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunerAFList.size(); ++u32Idx)
         TunerAFList[u32Idx].vDestroy();
   TunerAFList.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status()
:u8LengthOfAFList(0)

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AFLIST_V2STATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(TunerAFList.size()*12);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8LengthOfAFList);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunerAFList.size(); ++u32Idx)
      {
         TunerAFList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunerAFList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerAFList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8LengthOfAFList);
   (tVoid) (oOut << (tU32)TunerAFList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerAFList.size(); ++u32Idx)
         (tVoid) (oOut << TunerAFList[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status::operator==(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8LengthOfAFList == roRef.u8LengthOfAFList);
      bResult = bResult && (TunerAFList.size() == roRef.TunerAFList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerAFList.size()); ++u32Idx)
            bResult = bResult && (TunerAFList[u32Idx] == roRef.TunerAFList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet()
:e8ConfigListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
   Tun_ConfigListElements = coRef.Tun_ConfigListElements;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   Tun_ConfigListElements = coRef.Tun_ConfigListElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::vDestroy()
{
   Tun_ConfigListElements.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus()
:e8ConfigListID()
,Tun_ConfigListElements()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_CONFIG_LISTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Tun_ConfigListElements.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   (tVoid) (oIn >> Tun_ConfigListElements);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   (tVoid) (oOut << Tun_ConfigListElements);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   bResult = bResult && (Tun_ConfigListElements == roRef.Tun_ConfigListElements);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet::midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8SharxStep = coRef.u8SharxStep;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SharxStep = coRef.u8SharxStep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus()
:u8SharxStep(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_SHARXLEVELSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SharxStep);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SharxStep);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SharxStep == roRef.u8SharxStep);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet::midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDAGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8DDA = coRef.u8DDA;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DDA = coRef.u8DDA;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus()
:u8DDA(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_DDASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DDA);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DDA);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DDA == roRef.u8DDA);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet::midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8AF = coRef.u8AF;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& coRef)
{
   if (this == &coRef) return *this;
   u8AF = coRef.u8AF;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus()
:u8AF(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_AFSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AF);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AF);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AF == roRef.u8AF);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet::midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODEGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8Measuremode = coRef.u8Measuremode;
   e8PhysicalTunerId = coRef.e8PhysicalTunerId;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Measuremode = coRef.u8Measuremode;
   e8PhysicalTunerId = coRef.e8PhysicalTunerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus()
:u8Measuremode(0)
,e8PhysicalTunerId()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_MEASUREMODESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Measuremode);
   (tVoid) (oIn >> e8PhysicalTunerId);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Measuremode);
   (tVoid) (oOut << e8PhysicalTunerId);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Measuremode == roRef.u8Measuremode);
   bResult = bResult && (e8PhysicalTunerId == roRef.e8PhysicalTunerId);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8RDSreg = coRef.u8RDSreg;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& coRef)
{
   if (this == &coRef) return *this;
   u8RDSreg = coRef.u8RDSreg;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus()
:u8RDSreg(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSREGSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8RDSreg);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8RDSreg);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8RDSreg == roRef.u8RDSreg);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet::midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet::~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8NumofElementsinList = coRef.u8NumofElementsinList;
   e8ListID = coRef.e8ListID;
   Tun_StaticListElements = coRef.Tun_StaticListElements;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NumofElementsinList = coRef.u8NumofElementsinList;
   e8ListID = coRef.e8ListID;
   Tun_StaticListElements = coRef.Tun_StaticListElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::vDestroy()
{
   Tun_StaticListElements.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus()
:u8NumofElementsinList(0)
,e8ListID()
,Tun_StaticListElements()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_STATIC_LISTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Tun_StaticListElements.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumofElementsinList);
   (tVoid) (oIn >> e8ListID);
   (tVoid) (oIn >> Tun_StaticListElements);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumofElementsinList);
   (tVoid) (oOut << e8ListID);
   (tVoid) (oOut << Tun_StaticListElements);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumofElementsinList == roRef.u8NumofElementsinList);
   bResult = bResult && (e8ListID == roRef.e8ListID);
   bResult = bResult && (Tun_StaticListElements == roRef.Tun_StaticListElements);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg::midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet::midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet::~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u16PICode = coRef.u16PICode;
   TunerRadioText = coRef.TunerRadioText;
}
midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& coRef)
{
   if (this == &coRef) return *this;
   u16PICode = coRef.u16PICode;
   TunerRadioText = coRef.TunerRadioText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::vDestroy()
{
   TunerRadioText.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus()
:u16PICode(0)
,TunerRadioText()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RADIO_TEXTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+TunerRadioText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PICode);
   (tVoid) (oIn >> TunerRadioText);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PICode);
   (tVoid) (oOut << TunerRadioText);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PICode == roRef.u16PICode);
   bResult = bResult && (TunerRadioText == roRef.TunerRadioText);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg::midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg::~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg::midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFORELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet::midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOGET;
}


midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet::~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerBandAndStationInfo = coRef.TunerBandAndStationInfo;
}
midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerBandAndStationInfo = coRef.TunerBandAndStationInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::vDestroy()
{
   TunerBandAndStationInfo.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus()
:TunerBandAndStationInfo()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_BAND_PLUS_STATION_INFOSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunerBandAndStationInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerBandAndStationInfo);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerBandAndStationInfo);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerBandAndStationInfo == roRef.TunerBandAndStationInfo);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg::midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet::midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet::~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   DDADDS_Mode = coRef.DDADDS_Mode;
}
midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& coRef)
{
   if (this == &coRef) return *this;
   DDADDS_Mode = coRef.DDADDS_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus()
:DDADDS_Mode()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SETUP_DDADDSSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DDADDS_Mode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DDADDS_Mode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DDADDS_Mode == roRef.DDADDS_Mode);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSGET;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerTestModeData = coRef.TunerTestModeData;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerTestModeData = coRef.TunerTestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::vDestroy()
{
   TunerTestModeData.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus()
:TunerTestModeData()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TESTMODE_DDADDSSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunerTestModeData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerTestModeData);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerTestModeData);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerTestModeData == roRef.TunerTestModeData);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg::midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg::~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg::midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFORELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet::midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOGET;
}


midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet::~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bTMCAvailableFlag = coRef.bTMCAvailableFlag;
}
midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   bTMCAvailableFlag = coRef.bTMCAvailableFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus()
:bTMCAvailableFlag(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_TMC_INFOSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTMCAvailableFlag);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTMCAvailableFlag);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTMCAvailableFlag == roRef.bTMCAvailableFlag);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCGET;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         ListOfTrafficInfo[u32Idx].vDestroy();
   ListOfTrafficInfo.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus()

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DATA_TMCSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTrafficInfo.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTrafficInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
      {
         ListOfTrafficInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfTrafficInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfTrafficInfo[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfTrafficInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         (tVoid) (oOut << ListOfTrafficInfo[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTrafficInfo.size() == roRef.ListOfTrafficInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTrafficInfo.size()); ++u32Idx)
            bResult = bResult && (ListOfTrafficInfo[u32Idx] == roRef.ListOfTrafficInfo[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFORELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet::midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOGET;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet::~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Atstationinfo = coRef.Atstationinfo;
}
midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& coRef)
{
   if (this == &coRef) return *this;
   Atstationinfo = coRef.Atstationinfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::vDestroy()
{
   Atstationinfo.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus()
:Atstationinfo()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSTATIONINFOSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Atstationinfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Atstationinfo);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Atstationinfo);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Atstationinfo == roRef.Atstationinfo);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet::midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKGET;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet::~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8SeekState = coRef.e8SeekState;
}
midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SeekState = coRef.e8SeekState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus()
:e8SeekState()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATSEEKSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SeekState);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SeekState);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SeekState == roRef.e8SeekState);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg::midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet::midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLGET;
}


midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet::~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bRemoteCtrl = coRef.bRemoteCtrl;
}
midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& coRef)
{
   if (this == &coRef) return *this;
   bRemoteCtrl = coRef.bRemoteCtrl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus()
:bRemoteCtrl(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DIAG_REMOTE_CONTROLSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRemoteCtrl);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRemoteCtrl);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRemoteCtrl == roRef.bRemoteCtrl);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet::midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet::~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg::midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg::~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   ListOfRdbIds = coRef.ListOfRdbIds;
}
midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfRdbIds = coRef.ListOfRdbIds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         ListOfRdbIds[u32Idx].vDestroy();
   ListOfRdbIds.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus()

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_RDBIDACTUALLISTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ListOfRdbIds.size()*4);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
      {
         ListOfRdbIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfRdbIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfRdbIds[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfRdbIds.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         (tVoid) (oOut << ListOfRdbIds[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfRdbIds.size() == roRef.ListOfRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIds.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIds[u32Idx] == roRef.ListOfRdbIds[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8RDS = coRef.u8RDS;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& coRef)
{
   if (this == &coRef) return *this;
   u8RDS = coRef.u8RDS;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus()
:u8RDS(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_RDSSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8RDS);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8RDS);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8RDS == roRef.u8RDS);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ParameterID = coRef.e8ParameterID;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterID = coRef.e8ParameterID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet()
:e8ParameterID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterID == roRef.e8ParameterID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
   ListOfEnggParamValues = coRef.ListOfEnggParamValues;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterID = coRef.e8ParameterID;
   u32ParameterValue = coRef.u32ParameterValue;
   ListOfEnggParamValues = coRef.ListOfEnggParamValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfEnggParamValues.size(); ++u32Idx)
         ListOfEnggParamValues[u32Idx].vDestroy();
   ListOfEnggParamValues.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus()
:e8ParameterID()
,u32ParameterValue(0)

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_ENGG_PARAMETERSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+ static_cast<tU32>(ListOfEnggParamValues.size()*5);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterID);
   (tVoid) (oIn >> u32ParameterValue);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfEnggParamValues.size(); ++u32Idx)
      {
         ListOfEnggParamValues[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfEnggParamValues.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfEnggParamValues[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterID);
   (tVoid) (oOut << u32ParameterValue);
   (tVoid) (oOut << (tU32)ListOfEnggParamValues.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfEnggParamValues.size(); ++u32Idx)
         (tVoid) (oOut << ListOfEnggParamValues[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterID == roRef.e8ParameterID);
   bResult = bResult && (u32ParameterValue == roRef.u32ParameterValue);
      bResult = bResult && (ListOfEnggParamValues.size() == roRef.ListOfEnggParamValues.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfEnggParamValues.size()); ++u32Idx)
            bResult = bResult && (ListOfEnggParamValues[u32Idx] == roRef.ListOfEnggParamValues[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigParamType = coRef.e8ConfigParamType;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigParamType = coRef.e8ConfigParamType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet()
:e8ConfigParamType()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigParamType);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigParamType);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigParamType == roRef.e8ConfigParamType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   ListOfTuningActionConfigParameters = coRef.ListOfTuningActionConfigParameters;
}
midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfTuningActionConfigParameters = coRef.ListOfTuningActionConfigParameters;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTuningActionConfigParameters.size(); ++u32Idx)
         ListOfTuningActionConfigParameters[u32Idx].vDestroy();
   ListOfTuningActionConfigParameters.clear();
   }
}

midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus()

 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SET_TUNING_ACTION_CONFIGSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ListOfTuningActionConfigParameters.size()*5);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTuningActionConfigParameters.size(); ++u32Idx)
      {
         ListOfTuningActionConfigParameters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfTuningActionConfigParameters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfTuningActionConfigParameters[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfTuningActionConfigParameters.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTuningActionConfigParameters.size(); ++u32Idx)
         (tVoid) (oOut << ListOfTuningActionConfigParameters[u32Idx]);
   }
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTuningActionConfigParameters.size() == roRef.ListOfTuningActionConfigParameters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTuningActionConfigParameters.size()); ++u32Idx)
            bResult = bResult && (ListOfTuningActionConfigParameters[u32Idx] == roRef.ListOfTuningActionConfigParameters[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8AnnoMessage = coRef.e8AnnoMessage;
}
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& coRef)
{
   if (this == &coRef) return *this;
   e8AnnoMessage = coRef.e8AnnoMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus()
:e8AnnoMessage()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_MESSAGESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AnnoMessage);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AnnoMessage);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AnnoMessage == roRef.e8AnnoMessage);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFORELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOGET;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   AnnoInfoStatus = coRef.AnnoInfoStatus;
   b8AnnoTypes = coRef.b8AnnoTypes;
}
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   AnnoInfoStatus = coRef.AnnoInfoStatus;
   b8AnnoTypes = coRef.b8AnnoTypes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::vDestroy()
{
   AnnoInfoStatus.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus()
:AnnoInfoStatus()
,b8AnnoTypes()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_INFOSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+AnnoInfoStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AnnoInfoStatus);
   (tVoid) (oIn >> b8AnnoTypes);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AnnoInfoStatus);
   (tVoid) (oOut << b8AnnoTypes);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AnnoInfoStatus == roRef.AnnoInfoStatus);
   bResult = bResult && (b8AnnoTypes == roRef.b8AnnoTypes);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHGET;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bTPState = coRef.bTPState;
   bPTYState = coRef.bPTYState;
   bWeatherAlertState = coRef.bWeatherAlertState;
}
midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& coRef)
{
   if (this == &coRef) return *this;
   bTPState = coRef.bTPState;
   bPTYState = coRef.bPTYState;
   bWeatherAlertState = coRef.bWeatherAlertState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus()
:bTPState(0)
,bPTYState(0)
,bWeatherAlertState(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ANNOUNCEMENT_SWITCHSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTPState);
   (tVoid) (oIn >> bPTYState);
   (tVoid) (oIn >> bWeatherAlertState);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTPState);
   (tVoid) (oOut << bPTYState);
   (tVoid) (oOut << bWeatherAlertState);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTPState == roRef.bTPState);
   bResult = bResult && (bPTYState == roRef.bPTYState);
   bResult = bResult && (bWeatherAlertState == roRef.bWeatherAlertState);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg::midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg::~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
}
midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& coRef)
{
   if (this == &coRef) return *this;
   u16PI = coRef.u16PI;
   sPSName = coRef.sPSName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::vDestroy()
{
   sPSName.vDestroy();
}

midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus()
:u16PI(0)
,sPSName()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_PI_PS_RELATIONSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sPSName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PI);
   (tVoid) (oIn >> sPSName);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PI);
   (tVoid) (oOut << sPSName);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PI == roRef.u16PI);
   bResult = bResult && (sPSName == roRef.sPSName);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg::midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet::midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGEGET;
}


midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet::~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32AvailableBands = coRef.u32AvailableBands;
   TunerAvailableBandInfoList = coRef.TunerAvailableBandInfoList;
}
midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& coRef)
{
   if (this == &coRef) return *this;
   u32AvailableBands = coRef.u32AvailableBands;
   TunerAvailableBandInfoList = coRef.TunerAvailableBandInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::vDestroy()
{
   TunerAvailableBandInfoList.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus()
:u32AvailableBands(0)
,TunerAvailableBandInfoList()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AVAILABLE_BAND_RANGESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+TunerAvailableBandInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32AvailableBands);
   (tVoid) (oIn >> TunerAvailableBandInfoList);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32AvailableBands);
   (tVoid) (oOut << TunerAvailableBandInfoList);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32AvailableBands == roRef.u32AvailableBands);
   bResult = bResult && (TunerAvailableBandInfoList == roRef.TunerAvailableBandInfoList);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg::midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bMute = coRef.bMute;
   u8Attenuation = coRef.u8Attenuation;
   bMute_Interrupt = coRef.bMute_Interrupt;
}
midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& coRef)
{
   if (this == &coRef) return *this;
   bMute = coRef.bMute;
   u8Attenuation = coRef.u8Attenuation;
   bMute_Interrupt = coRef.bMute_Interrupt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus()
:bMute(0)
,u8Attenuation(0)
,bMute_Interrupt(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_MUTE_REQUESTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMute);
   (tVoid) (oIn >> u8Attenuation);
   (tVoid) (oIn >> bMute_Interrupt);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMute);
   (tVoid) (oOut << u8Attenuation);
   (tVoid) (oOut << bMute_Interrupt);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMute == roRef.bMute);
   bResult = bResult && (u8Attenuation == roRef.u8Attenuation);
   bResult = bResult && (bMute_Interrupt == roRef.bMute_Interrupt);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg::midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg::~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8FreqPerc = coRef.u8FreqPerc;
}
midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& coRef)
{
   if (this == &coRef) return *this;
   u8FreqPerc = coRef.u8FreqPerc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus()
:u8FreqPerc(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_UPDATELANDSCAPE_PROGRESSSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FreqPerc);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FreqPerc);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FreqPerc == roRef.u8FreqPerc);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg::midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet::midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTGET;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet::~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   sDRMRadioText = coRef.sDRMRadioText;
}
midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& coRef)
{
   if (this == &coRef) return *this;
   sDRMRadioText = coRef.sDRMRadioText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::vDestroy()
{
   sDRMRadioText.vDestroy();
}

midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus()
:sDRMRadioText()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_RADIO_TEXTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDRMRadioText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDRMRadioText);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDRMRadioText);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDRMRadioText == roRef.sDRMRadioText);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8PISearchStatus = coRef.e8PISearchStatus;
   u16PI = coRef.u16PI;
}
midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PISearchStatus = coRef.e8PISearchStatus;
   u16PI = coRef.u16PI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus()
:e8PISearchStatus()
,u16PI(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_ATPISEARCHSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PISearchStatus);
   (tVoid) (oIn >> u16PI);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PISearchStatus);
   (tVoid) (oOut << u16PI);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PISearchStatus == roRef.e8PISearchStatus);
   bResult = bResult && (u16PI == roRef.u16PI);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8HDAudioPrgNo = coRef.e8HDAudioPrgNo;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& coRef)
{
   if (this == &coRef) return *this;
   e8HDAudioPrgNo = coRef.e8HDAudioPrgNo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus()
:e8HDAudioPrgNo()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AUDIOPRGMSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8HDAudioPrgNo);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8HDAudioPrgNo);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8HDAudioPrgNo == roRef.e8HDAudioPrgNo);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunPSDData = coRef.TunPSDData;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TunPSDData = coRef.TunPSDData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::vDestroy()
{
   TunPSDData.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus()
:TunPSDData()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_PSD_DATASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunPSDData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunPSDData);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunPSDData);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunPSDData == roRef.TunPSDData);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   TunerHDTestModeData = coRef.TunerHDTestModeData;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerHDTestModeData = coRef.TunerHDTestModeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::vDestroy()
{
   TunerHDTestModeData.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus()
:TunerHDTestModeData()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_TEST_MODE_DATASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TunerHDTestModeData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerHDTestModeData);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerHDTestModeData);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerHDTestModeData == roRef.TunerHDTestModeData);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFOUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFORELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8HDAdvisoryInfo = coRef.e8HDAdvisoryInfo;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   e8HDAdvisoryInfo = coRef.e8HDAdvisoryInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus()
:e8HDAdvisoryInfo()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_AVISORY_INFOSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8HDAdvisoryInfo);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8HDAdvisoryInfo);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8HDAdvisoryInfo == roRef.e8HDAdvisoryInfo);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg::midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   DemodulationSwitch = coRef.DemodulationSwitch;
}
midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   DemodulationSwitch = coRef.DemodulationSwitch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus()
:DemodulationSwitch()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DEMODULATION_SWITCH_STATUSSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DemodulationSwitch);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DemodulationSwitch);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DemodulationSwitch == roRef.DemodulationSwitch);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ParameterValue = coRef.e8ParameterValue;
}
midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ParameterValue = coRef.e8ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus()
:e8ParameterValue()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_SPLIT_MODESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ParameterValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ParameterValue == roRef.e8ParameterValue);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e16Parameter_ID = coRef.e16Parameter_ID;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& coRef)
{
   if (this == &coRef) return *this;
   e16Parameter_ID = coRef.e16Parameter_ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet()
:e16Parameter_ID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERGET;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Parameter_ID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Parameter_ID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Parameter_ID == roRef.e16Parameter_ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e16Parameter_ID = coRef.e16Parameter_ID;
   s8ParameterValue = coRef.s8ParameterValue;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& coRef)
{
   if (this == &coRef) return *this;
   e16Parameter_ID = coRef.e16Parameter_ID;
   s8ParameterValue = coRef.s8ParameterValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus()
:e16Parameter_ID()
,s8ParameterValue(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SECTION_PARAMETERSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Parameter_ID);
   (tVoid) (oIn >> s8ParameterValue);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Parameter_ID);
   (tVoid) (oOut << s8ParameterValue);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Parameter_ID == roRef.e16Parameter_ID);
   bResult = bResult && (s8ParameterValue == roRef.s8ParameterValue);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg::midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8TunerInfo = coRef.u8TunerInfo;
   u32Frequency = coRef.u32Frequency;
   u8FieldStrength = coRef.u8FieldStrength;
   u8SyncStatus = coRef.u8SyncStatus;
   u8RobustnessMode = coRef.u8RobustnessMode;
   u32ChannelParams = coRef.u32ChannelParams;
   tU8ListDRMService = coRef.tU8ListDRMService;
   sDRMServiceLabelData = coRef.sDRMServiceLabelData;
   u32AudioConfig = coRef.u32AudioConfig;
   u8ProtectionLevels = coRef.u8ProtectionLevels;
   s32MSC_BER = coRef.s32MSC_BER;
   u8AudioCRCFails = coRef.u8AudioCRCFails;
   u8AudioMute = coRef.u8AudioMute;
   u8ServiceQuality = coRef.u8ServiceQuality;
   u16FAC_ERRS = coRef.u16FAC_ERRS;
   u8FAC_CRC_Fails = coRef.u8FAC_CRC_Fails;
   u16SDC_ERRS = coRef.u16SDC_ERRS;
   u8SDC_CRC_Fails = coRef.u8SDC_CRC_Fails;
   u16MuteCounter = coRef.u16MuteCounter;
}
midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& coRef)
{
   if (this == &coRef) return *this;
   u8TunerInfo = coRef.u8TunerInfo;
   u32Frequency = coRef.u32Frequency;
   u8FieldStrength = coRef.u8FieldStrength;
   u8SyncStatus = coRef.u8SyncStatus;
   u8RobustnessMode = coRef.u8RobustnessMode;
   u32ChannelParams = coRef.u32ChannelParams;
   tU8ListDRMService = coRef.tU8ListDRMService;
   sDRMServiceLabelData = coRef.sDRMServiceLabelData;
   u32AudioConfig = coRef.u32AudioConfig;
   u8ProtectionLevels = coRef.u8ProtectionLevels;
   s32MSC_BER = coRef.s32MSC_BER;
   u8AudioCRCFails = coRef.u8AudioCRCFails;
   u8AudioMute = coRef.u8AudioMute;
   u8ServiceQuality = coRef.u8ServiceQuality;
   u16FAC_ERRS = coRef.u16FAC_ERRS;
   u8FAC_CRC_Fails = coRef.u8FAC_CRC_Fails;
   u16SDC_ERRS = coRef.u16SDC_ERRS;
   u8SDC_CRC_Fails = coRef.u8SDC_CRC_Fails;
   u16MuteCounter = coRef.u16MuteCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::vDestroy()
{
   {
   tU8ListDRMService.clear();
   }
   sDRMServiceLabelData.vDestroy();
}

midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus()
:u8TunerInfo(0)
,u32Frequency(0)
,u8FieldStrength(0)
,u8SyncStatus(0)
,u8RobustnessMode(0)
,u32ChannelParams(0)

,sDRMServiceLabelData()
,u32AudioConfig(0)
,u8ProtectionLevels(0)
,s32MSC_BER(0)
,u8AudioCRCFails(0)
,u8AudioMute(0)
,u8ServiceQuality(0)
,u16FAC_ERRS(0)
,u8FAC_CRC_Fails(0)
,u16SDC_ERRS(0)
,u8SDC_CRC_Fails(0)
,u16MuteCounter(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_DRM_TESTMODESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 36+ static_cast<tU32>(tU8ListDRMService.size()*1)+sDRMServiceLabelData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TunerInfo);
   (tVoid) (oIn >> u32Frequency);
   (tVoid) (oIn >> u8FieldStrength);
   (tVoid) (oIn >> u8SyncStatus);
   (tVoid) (oIn >> u8RobustnessMode);
   (tVoid) (oIn >> u32ChannelParams);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tU8ListDRMService.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tU8ListDRMService[u32Idx]);
      }
   }
   (tVoid) (oIn >> sDRMServiceLabelData);
   (tVoid) (oIn >> u32AudioConfig);
   (tVoid) (oIn >> u8ProtectionLevels);
   (tVoid) (oIn >> s32MSC_BER);
   (tVoid) (oIn >> u8AudioCRCFails);
   (tVoid) (oIn >> u8AudioMute);
   (tVoid) (oIn >> u8ServiceQuality);
   (tVoid) (oIn >> u16FAC_ERRS);
   (tVoid) (oIn >> u8FAC_CRC_Fails);
   (tVoid) (oIn >> u16SDC_ERRS);
   (tVoid) (oIn >> u8SDC_CRC_Fails);
   (tVoid) (oIn >> u16MuteCounter);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TunerInfo);
   (tVoid) (oOut << u32Frequency);
   (tVoid) (oOut << u8FieldStrength);
   (tVoid) (oOut << u8SyncStatus);
   (tVoid) (oOut << u8RobustnessMode);
   (tVoid) (oOut << u32ChannelParams);
   (tVoid) (oOut << (tU32)tU8ListDRMService.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tU8ListDRMService.size(); ++u32Idx)
         (tVoid) (oOut << tU8ListDRMService[u32Idx]);
   }
   (tVoid) (oOut << sDRMServiceLabelData);
   (tVoid) (oOut << u32AudioConfig);
   (tVoid) (oOut << u8ProtectionLevels);
   (tVoid) (oOut << s32MSC_BER);
   (tVoid) (oOut << u8AudioCRCFails);
   (tVoid) (oOut << u8AudioMute);
   (tVoid) (oOut << u8ServiceQuality);
   (tVoid) (oOut << u16FAC_ERRS);
   (tVoid) (oOut << u8FAC_CRC_Fails);
   (tVoid) (oOut << u16SDC_ERRS);
   (tVoid) (oOut << u8SDC_CRC_Fails);
   (tVoid) (oOut << u16MuteCounter);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TunerInfo == roRef.u8TunerInfo);
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   bResult = bResult && (u8FieldStrength == roRef.u8FieldStrength);
   bResult = bResult && (u8SyncStatus == roRef.u8SyncStatus);
   bResult = bResult && (u8RobustnessMode == roRef.u8RobustnessMode);
   bResult = bResult && (u32ChannelParams == roRef.u32ChannelParams);
      bResult = bResult && (tU8ListDRMService.size() == roRef.tU8ListDRMService.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tU8ListDRMService.size()); ++u32Idx)
            bResult = bResult && (tU8ListDRMService[u32Idx] == roRef.tU8ListDRMService[u32Idx]);
      }
   bResult = bResult && (sDRMServiceLabelData == roRef.sDRMServiceLabelData);
   bResult = bResult && (u32AudioConfig == roRef.u32AudioConfig);
   bResult = bResult && (u8ProtectionLevels == roRef.u8ProtectionLevels);
   bResult = bResult && (s32MSC_BER == roRef.s32MSC_BER);
   bResult = bResult && (u8AudioCRCFails == roRef.u8AudioCRCFails);
   bResult = bResult && (u8AudioMute == roRef.u8AudioMute);
   bResult = bResult && (u8ServiceQuality == roRef.u8ServiceQuality);
   bResult = bResult && (u16FAC_ERRS == roRef.u16FAC_ERRS);
   bResult = bResult && (u8FAC_CRC_Fails == roRef.u8FAC_CRC_Fails);
   bResult = bResult && (u16SDC_ERRS == roRef.u16SDC_ERRS);
   bResult = bResult && (u8SDC_CRC_Fails == roRef.u8SDC_CRC_Fails);
   bResult = bResult && (u16MuteCounter == roRef.u16MuteCounter);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& coRef)
{
   if (this == &coRef) return *this;
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet()
:u32HDStationId(0)
,e8HDAudioProgram()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMEGET;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> e8HDAudioProgram);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << e8HDAudioProgram);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   sHDLongName = coRef.sHDLongName;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& coRef)
{
   if (this == &coRef) return *this;
   u32HDStationId = coRef.u32HDStationId;
   e8HDAudioProgram = coRef.e8HDAudioProgram;
   sHDLongName = coRef.sHDLongName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::vDestroy()
{
   sHDLongName.vDestroy();
}

midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus()
:u32HDStationId(0)
,e8HDAudioProgram()
,sHDLongName()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_LONGNAMESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+sHDLongName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32HDStationId);
   (tVoid) (oIn >> e8HDAudioProgram);
   (tVoid) (oIn >> sHDLongName);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32HDStationId);
   (tVoid) (oOut << e8HDAudioProgram);
   (tVoid) (oOut << sHDLongName);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32HDStationId == roRef.u32HDStationId);
   bResult = bResult && (e8HDAudioProgram == roRef.e8HDAudioProgram);
   bResult = bResult && (sHDLongName == roRef.sHDLongName);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bDisplayImage = coRef.bDisplayImage;
   ImageFileInfo = coRef.ImageFileInfo;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& coRef)
{
   if (this == &coRef) return *this;
   bDisplayImage = coRef.bDisplayImage;
   ImageFileInfo = coRef.ImageFileInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::vDestroy()
{
   ImageFileInfo.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus()
:bDisplayImage(0)
,ImageFileInfo()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_IMAGEFILE_UPDATESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ImageFileInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDisplayImage);
   (tVoid) (oIn >> ImageFileInfo);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDisplayImage);
   (tVoid) (oOut << ImageFileInfo);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDisplayImage == roRef.bDisplayImage);
   bResult = bResult && (ImageFileInfo == roRef.ImageFileInfo);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bTimer = coRef.bTimer;
}
midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& coRef)
{
   if (this == &coRef) return *this;
   bTimer = coRef.bTimer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus()
:bTimer(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTimer);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTimer);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTimer == roRef.bTimer);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg::midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_HD_SIGNALLOST_TIMERUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg::~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATEUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATERELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
}
midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet()
:e8ConfigListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATEGET;
}


midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8ConfigListID = coRef.e8ConfigListID;
   Tun_ConfigListElements = coRef.Tun_ConfigListElements;
}
midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigListID = coRef.e8ConfigListID;
   Tun_ConfigListElements = coRef.Tun_ConfigListElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::vDestroy()
{
   Tun_ConfigListElements.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus()
:e8ConfigListID()
,Tun_ConfigListElements()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_SURVIELLANCE_LISTUPDATESTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Tun_ConfigListElements.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigListID);
   (tVoid) (oIn >> Tun_ConfigListElements);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigListID);
   (tVoid) (oOut << Tun_ConfigListElements);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigListID == roRef.e8ConfigListID);
   bResult = bResult && (Tun_ConfigListElements == roRef.Tun_ConfigListElements);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg::midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg::~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   bListUpdate = coRef.bListUpdate;
}
midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& coRef)
{
   if (this == &coRef) return *this;
   bListUpdate = coRef.bListUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus()
:bListUpdate(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_LISTUPDATE_NOTIFICATIONSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bListUpdate);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bListUpdate);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bListUpdate == roRef.bListUpdate);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   Frequency = coRef.Frequency;
   DARCData = coRef.DARCData;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& coRef)
{
   if (this == &coRef) return *this;
   Frequency = coRef.Frequency;
   DARCData = coRef.DARCData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::vDestroy()
{
   DARCData.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus()
:Frequency(0)
,DARCData()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_DARC_DATASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DARCData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> DARCData);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << DARCData);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (DARCData == roRef.DARCData);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREAUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREARELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREAGET;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   e8SelectedRegion = coRef.e8SelectedRegion;
   bAreaSelectionMode = coRef.bAreaSelectionMode;
}
midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SelectedRegion = coRef.e8SelectedRegion;
   bAreaSelectionMode = coRef.bAreaSelectionMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus()
:e8SelectedRegion()
,bAreaSelectionMode(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_AREASTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectedRegion);
   (tVoid) (oIn >> bAreaSelectionMode);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectedRegion);
   (tVoid) (oOut << bAreaSelectionMode);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectedRegion == roRef.e8SelectedRegion);
   bResult = bResult && (bAreaSelectionMode == roRef.bAreaSelectionMode);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   FMPresetListID = coRef.FMPresetListID;
   AMPresetListID = coRef.AMPresetListID;
}
midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& coRef)
{
   if (this == &coRef) return *this;
   FMPresetListID = coRef.FMPresetListID;
   AMPresetListID = coRef.AMPresetListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus()
:FMPresetListID()
,AMPresetListID()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_GET_ACTIVE_PRESETLISTIDSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FMPresetListID);
   (tVoid) (oIn >> AMPresetListID);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FMPresetListID);
   (tVoid) (oOut << AMPresetListID);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FMPresetListID == roRef.FMPresetListID);
   bResult = bResult && (AMPresetListID == roRef.AMPresetListID);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   u8JapanStationCount = coRef.u8JapanStationCount;
   JapanStationNamesList = coRef.JapanStationNamesList;
   u16SelectedElement = coRef.u16SelectedElement;
}
midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   u8JapanStationCount = coRef.u8JapanStationCount;
   JapanStationNamesList = coRef.JapanStationNamesList;
   u16SelectedElement = coRef.u16SelectedElement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::vDestroy()
{
   JapanStationNamesList.vDestroy(); 
}

midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus()
:u8JapanStationCount(0)
,JapanStationNamesList()
,u16SelectedElement(0)
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_JAPAN_STATION_NAME_LISTSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+JapanStationNamesList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8JapanStationCount);
   (tVoid) (oIn >> JapanStationNamesList);
   (tVoid) (oIn >> u16SelectedElement);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8JapanStationCount);
   (tVoid) (oOut << JapanStationNamesList);
   (tVoid) (oOut << u16SelectedElement);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8JapanStationCount == roRef.u8JapanStationCount);
   bResult = bResult && (JapanStationNamesList == roRef.JapanStationNamesList);
   bResult = bResult && (u16SelectedElement == roRef.u16SelectedElement);
   return bResult;
}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg()
{}

//=============================================================================

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRELUPREG;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& coRef)
   : midw_tunerfi_tclMsgBaseMessage(coRef)
{
   b8SwitchingFrequencyMask = coRef.b8SwitchingFrequencyMask;
}
midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::operator=(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& coRef)
{
   if (this == &coRef) return *this;
   b8SwitchingFrequencyMask = coRef.b8SwitchingFrequencyMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus()
:b8SwitchingFrequencyMask()
 {}

tS32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::s32GetTypeId() const
{
   return (tS32) midw_tunerfi_tclToken::EN_MSG_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYSTATUS;
}


midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus()
{}

tU32 midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b8SwitchingFrequencyMask);
   return oIn;
}

fi_tclOutContext& midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b8SwitchingFrequencyMask);
   return oOut;
}

tBool midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus::operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b8SwitchingFrequencyMask == roRef.b8SwitchingFrequencyMask);
   return bResult;
}

