/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_TRAFFICFITYPES_HEADER
#define MIDW_TRAFFICFITYPES_HEADER


class midw_trafficfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_TRAFFIC_FI message types

fi_tclMessageBase* midw_trafficfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_trafficfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_trafficfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfRDBID;
   std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > TunRDBID_Value;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > TunRDBID_Value;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumberOfElements;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Response e8MethodResult;
   std::vector<midw_fi_tcl_TpegUriChannel, std::allocator<midw_fi_tcl_TpegUriChannel> > TpegUriChannelList;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActive;
   midw_fi_tcl_TpegUriChannel sTpegUriChn;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Response e8MethodResult;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunerReceptionState ReceptionState;
   std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > ListOfRdbIds;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 bTMCAvailableFlag;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TpegInfo, std::allocator<midw_fi_tcl_TpegInfo> > TpegData;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_e16_TrafficInfo, std::allocator<midw_fi_tcl_e16_TrafficInfo> > ListOfTrafficInfo;
   tBool CycleStart;
   midw_fi_tcl_TrafficRdbidValue RDBId;
   tBool DataForRdbIdComplete;
   tBool Duplicate;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg();

   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg();

   inline tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus : public midw_trafficfi_tclMsgBaseMessage
{
public:

   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& coRef);
   midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunerState TunerState;
   midw_fi_tcl_e8_OperationMode OperationMode;
   midw_fi_tclString Message;
   virtual ~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
