#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TRAFFICFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_trafficfi_tclDescription::bInitMessage(midw_trafficfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_trafficfi_tclToken::EN_LAST_TOKEN:
   case midw_trafficfi_tclToken::EN_LIST:
   case midw_trafficfi_tclToken::EN_END_OF_STRUCT:
   case midw_trafficfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_TUNRDBID_VALUE)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_MSG_U8NUMOFRDBID)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_TUNRDBID_VALUE)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_MSG_U8NUMBEROFELEMENTS)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TPEGURICHANNEL,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_TPEGURICHANNELLIST)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_RESPONSE,midw_trafficfi_tclSemanticDomain::EN_MSG_E8METHODRESULT)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TPEGURICHANNEL,midw_trafficfi_tclSemanticDomain::EN_MSG_STPEGURICHN)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_MSG_BACTIVE)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_RESPONSE,midw_trafficfi_tclSemanticDomain::EN_MSG_E8METHODRESULT)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTSTATUS:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_LISTOFRDBIDS)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_TUNERRECEPTIONSTATE,midw_trafficfi_tclSemanticDomain::EN_MSG_RECEPTIONSTATE)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_MSG_BTMCAVAILABLEFLAG)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TPEGINFO,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_TPEGDATA)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_MSG_DUPLICATE)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_MSG_DATAFORRDBIDCOMPLETE)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE,midw_trafficfi_tclSemanticDomain::EN_MSG_RDBID)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_MSG_CYCLESTART)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E16_TRAFFICINFO,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_MSG_LISTOFTRAFFICINFO)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODESTATUS:
   {
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_STRING,midw_trafficfi_tclSemanticDomain::EN_MSG_MESSAGE)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_OPERATIONMODE,midw_trafficfi_tclSemanticDomain::EN_MSG_OPERATIONMODE)) && bResult;
      bResult = oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_TUNERSTATE,midw_trafficfi_tclSemanticDomain::EN_MSG_TUNERSTATE)) && bResult;
   } break;
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTGET:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTRELUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFORELUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOGET:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATAUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATARELUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATARELUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAGET:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEGET:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEUPREG:
   case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODERELUPREG:
   case midw_trafficfi_tclToken::EN_BINCONTAINER:
   case midw_trafficfi_tclToken::EN_E8_RESPONSE:
   case midw_trafficfi_tclToken::EN_E8_URISELECTSTATE:
   case midw_trafficfi_tclToken::EN_TPEGURICHANNEL:
   case midw_trafficfi_tclToken::EN_TPEGINFO:
   case midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE:
   case midw_trafficfi_tclToken::EN_E16_TRAFFICTMCAPPLICATIONID:
   case midw_trafficfi_tclToken::EN_TRAFFICENCRYPTION:
   case midw_trafficfi_tclToken::EN_E8_TRAFFICTMCMEDIUMTYPE:
   case midw_trafficfi_tclToken::EN_TRAFFICMSGSOURCE:
   case midw_trafficfi_tclToken::EN_E16_TRAFFICINFO:
   case midw_trafficfi_tclToken::EN_E8_OPERATIONMODE:
   case midw_trafficfi_tclToken::EN_E8_TUNERSTATE:
   case midw_trafficfi_tclToken::EN_E8_TUNERRECEPTIONSTATE:
   case midw_trafficfi_tclToken::EN_U8:   
   case midw_trafficfi_tclToken::EN_S8:   
   case midw_trafficfi_tclToken::EN_U16:   
   case midw_trafficfi_tclToken::EN_S16:   
   case midw_trafficfi_tclToken::EN_U24:   
   case midw_trafficfi_tclToken::EN_S24:   
   case midw_trafficfi_tclToken::EN_U32:   
   case midw_trafficfi_tclToken::EN_S32:   
   case midw_trafficfi_tclToken::EN_U64:   
   case midw_trafficfi_tclToken::EN_S64:   
   case midw_trafficfi_tclToken::EN_F32:   
   case midw_trafficfi_tclToken::EN_F64:   
   case midw_trafficfi_tclToken::EN_BOOL:   
   case midw_trafficfi_tclToken::EN_STRING:   
   case midw_trafficfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(enMsgToken,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_trafficfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_trafficfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_trafficfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_trafficfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_trafficfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_trafficfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_trafficfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_trafficfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_trafficfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_trafficfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_trafficfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_trafficfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODSTART:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODRESULT:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODSTART:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODRESULT:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODSTART:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODRESULT:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTGET:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTRELUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTSTATUS:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFORELUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOGET:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOSTATUS:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATAUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATARELUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATASTATUS:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATARELUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAGET:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATASTATUS:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEGET:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODERELUPREG:
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_trafficfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_E8_RESPONSE:
      {
         midw_fi_tcl_e8_Response o_e8_Response;
         if (!bDoIt(o_e8_Response))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_E8_URISELECTSTATE:
      {
         midw_fi_tcl_e8_UriSelectState o_e8_UriSelectState;
         if (!bDoIt(o_e8_UriSelectState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_TPEGURICHANNEL:
      {
      if (poVisitor->bDoExpand_TpegUriChannel(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_BACTIVE));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_URISELECTSTATE,midw_trafficfi_tclSemanticDomain::EN_TPEGURISELECTSTATE));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_STRING,midw_trafficfi_tclSemanticDomain::EN_STPEGURICHN));
      }
      else
      {
         midw_fi_tcl_TpegUriChannel o_TpegUriChannel;
         if (!bDoIt(o_TpegUriChannel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegUriChannel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegUriChannel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_TPEGINFO:
      {
      if (poVisitor->bDoExpand_TpegInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_TPEGDATA));
      }
      else
      {
         midw_fi_tcl_TpegInfo o_TpegInfo;
         if (!bDoIt(o_TpegInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE:
      {
      if (poVisitor->bDoExpand_TrafficRdbidValue(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_BENCFLAG));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_U8RDBIDSID));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U16,midw_trafficfi_tclSemanticDomain::EN_U16BSA));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_U8RDBIDLTN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_U8RDBIDCC));
      }
      else
      {
         midw_fi_tcl_TrafficRdbidValue o_TrafficRdbidValue;
         if (!bDoIt(o_TrafficRdbidValue))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficRdbidValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficRdbidValue.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_E16_TRAFFICTMCAPPLICATIONID:
      {
         midw_fi_tcl_e16_TrafficTmcApplicationId o_e16_TrafficTmcApplicationId;
         if (!bDoIt(o_e16_TrafficTmcApplicationId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_TRAFFICENCRYPTION:
      {
      if (poVisitor->bDoExpand_TrafficEncryption(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_TESTBITS));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_ENCID));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_BOOL,midw_trafficfi_tclSemanticDomain::EN_ENCRYPTED));
      }
      else
      {
         midw_fi_tcl_TrafficEncryption o_TrafficEncryption;
         if (!bDoIt(o_TrafficEncryption))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficEncryption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficEncryption.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_E8_TRAFFICTMCMEDIUMTYPE:
      {
         midw_fi_tcl_e8_TrafficTmcMediumType o_e8_TrafficTmcMediumType;
         if (!bDoIt(o_e8_TrafficTmcMediumType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_TRAFFICMSGSOURCE:
      {
      if (poVisitor->bDoExpand_TrafficMsgSource(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_NUMBER));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E8_TRAFFICTMCMEDIUMTYPE,midw_trafficfi_tclSemanticDomain::EN_MEDIUMTYPEID));
      }
      else
      {
         midw_fi_tcl_TrafficMsgSource o_TrafficMsgSource;
         if (!bDoIt(o_TrafficMsgSource))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgSource.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgSource.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_E16_TRAFFICINFO:
      {
      if (poVisitor->bDoExpand_e16_TrafficInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_END_OF_STRUCT,midw_trafficfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_STRING,midw_trafficfi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_STRING,midw_trafficfi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICMSGSOURCE,midw_trafficfi_tclSemanticDomain::EN_MSGSOURCE));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICENCRYPTION,midw_trafficfi_tclSemanticDomain::EN_ENCRYPTION));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U16,midw_trafficfi_tclSemanticDomain::EN_PROGRAMID));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_U8,midw_trafficfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_LIST,midw_trafficfi_tclSemanticDomain::EN_LISTOF8ADATA));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_E16_TRAFFICTMCAPPLICATIONID,midw_trafficfi_tclSemanticDomain::EN_APPLICATIONID));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_S16,midw_trafficfi_tclSemanticDomain::EN_ECC));
         (tVoid) oPath.bGoDown(midw_trafficfi_tclKnot(midw_trafficfi_tclToken::EN_TRAFFICRDBIDVALUE,midw_trafficfi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         midw_fi_tcl_e16_TrafficInfo o_e16_TrafficInfo;
         if (!bDoIt(o_e16_TrafficInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e16_TrafficInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e16_TrafficInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_trafficfi_tclToken::EN_E8_OPERATIONMODE:
      {
         midw_fi_tcl_e8_OperationMode o_e8_OperationMode;
         if (!bDoIt(o_e8_OperationMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_E8_TUNERSTATE:
      {
         midw_fi_tcl_e8_TunerState o_e8_TunerState;
         if (!bDoIt(o_e8_TunerState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_E8_TUNERRECEPTIONSTATE:
      {
         midw_fi_tcl_e8_TunerReceptionState o_e8_TunerReceptionState;
         if (!bDoIt(o_e8_TunerReceptionState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_trafficfi_tclToken::EN_UNKNOWN:
      case midw_trafficfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

