/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TPEGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TPEGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TPEGFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_TPEG_FI message types

fi_tclMessageBase* midw_tpegfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONGET:
         return OSAL_NEW midw_tpegfi_tclMsgStreamInformationGet;

      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONUPREG:
         return OSAL_NEW midw_tpegfi_tclMsgStreamInformationUpReg;

      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONRELUPREG:
         return OSAL_NEW midw_tpegfi_tclMsgStreamInformationRelUpReg;

      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONSTATUS:
         return OSAL_NEW midw_tpegfi_tclMsgStreamInformationStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_tpegfifi messages

// common functions

tU16 midw_tpegfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_TPEGFI_C_U16_SERVICE_ID;
}

tU16 midw_tpegfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_tpegfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_tpegfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_tpegfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_tpegfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_tpegfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_tpegfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

midw_tpegfi_tclMsgStreamInformationGet::midw_tpegfi_tclMsgStreamInformationGet()
 {}

tS32 midw_tpegfi_tclMsgStreamInformationGet::s32GetTypeId() const
{
   return (tS32) midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONGET;
}


midw_tpegfi_tclMsgStreamInformationGet::~midw_tpegfi_tclMsgStreamInformationGet()
{}

//=============================================================================

midw_tpegfi_tclMsgStreamInformationUpReg::midw_tpegfi_tclMsgStreamInformationUpReg()
 {}

tS32 midw_tpegfi_tclMsgStreamInformationUpReg::s32GetTypeId() const
{
   return (tS32) midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONUPREG;
}


midw_tpegfi_tclMsgStreamInformationUpReg::~midw_tpegfi_tclMsgStreamInformationUpReg()
{}

//=============================================================================

midw_tpegfi_tclMsgStreamInformationRelUpReg::midw_tpegfi_tclMsgStreamInformationRelUpReg()
 {}

tS32 midw_tpegfi_tclMsgStreamInformationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONRELUPREG;
}


midw_tpegfi_tclMsgStreamInformationRelUpReg::~midw_tpegfi_tclMsgStreamInformationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tpegfi_tclMsgStreamInformationStatus::midw_tpegfi_tclMsgStreamInformationStatus(const midw_tpegfi_tclMsgStreamInformationStatus& coRef)
   : midw_tpegfi_tclMsgBaseMessage(coRef)
{
   listOfStreamInfo = coRef.listOfStreamInfo;
   MsgsPerFrame = coRef.MsgsPerFrame;
   ACIDPerFrame = coRef.ACIDPerFrame;
}
midw_tpegfi_tclMsgStreamInformationStatus& midw_tpegfi_tclMsgStreamInformationStatus::operator=(const midw_tpegfi_tclMsgStreamInformationStatus& coRef)
{
   if (this == &coRef) return *this;
   listOfStreamInfo = coRef.listOfStreamInfo;
   MsgsPerFrame = coRef.MsgsPerFrame;
   ACIDPerFrame = coRef.ACIDPerFrame;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tpegfi_tclMsgStreamInformationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < listOfStreamInfo.size(); ++u32Idx)
         listOfStreamInfo[u32Idx].vDestroy();
   listOfStreamInfo.clear();
   }
}

midw_tpegfi_tclMsgStreamInformationStatus::midw_tpegfi_tclMsgStreamInformationStatus()

:MsgsPerFrame(0)
,ACIDPerFrame(0)
 {}

tS32 midw_tpegfi_tclMsgStreamInformationStatus::s32GetTypeId() const
{
   return (tS32) midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONSTATUS;
}


midw_tpegfi_tclMsgStreamInformationStatus::~midw_tpegfi_tclMsgStreamInformationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tpegfi_tclMsgStreamInformationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < listOfStreamInfo.size(); ++u32ListIdx)
      u32DynamicSize += listOfStreamInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

fi_tclInContext& midw_tpegfi_tclMsgStreamInformationStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < listOfStreamInfo.size(); ++u32Idx)
      {
         listOfStreamInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      listOfStreamInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listOfStreamInfo[u32Idx]);
      }
   }
   (tVoid) (oIn >> MsgsPerFrame);
   (tVoid) (oIn >> ACIDPerFrame);
   return oIn;
}

fi_tclOutContext& midw_tpegfi_tclMsgStreamInformationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)listOfStreamInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listOfStreamInfo.size(); ++u32Idx)
         (tVoid) (oOut << listOfStreamInfo[u32Idx]);
   }
   (tVoid) (oOut << MsgsPerFrame);
   (tVoid) (oOut << ACIDPerFrame);
   return oOut;
}

tBool midw_tpegfi_tclMsgStreamInformationStatus::operator==(const midw_tpegfi_tclMsgStreamInformationStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (listOfStreamInfo.size() == roRef.listOfStreamInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listOfStreamInfo.size()); ++u32Idx)
            bResult = bResult && (listOfStreamInfo[u32Idx] == roRef.listOfStreamInfo[u32Idx]);
      }
   bResult = bResult && (MsgsPerFrame == roRef.MsgsPerFrame);
   bResult = bResult && (ACIDPerFrame == roRef.ACIDPerFrame);
   return bResult;
}

