#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TPEGFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_tpegfi_tclDescription::bInitMessage(midw_tpegfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_tpegfi_tclToken::EN_LAST_TOKEN:
   case midw_tpegfi_tclToken::EN_LIST:
   case midw_tpegfi_tclToken::EN_END_OF_STRUCT:
   case midw_tpegfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONSTATUS:
   {
      bResult = oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U32,midw_tpegfi_tclSemanticDomain::EN_MSG_ACIDPERFRAME)) && bResult;
      bResult = oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U32,midw_tpegfi_tclSemanticDomain::EN_MSG_MSGSPERFRAME)) && bResult;
      bResult = oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_TPEGSTREAMINFO,midw_tpegfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_LIST,midw_tpegfi_tclSemanticDomain::EN_MSG_LISTOFSTREAMINFO)) && bResult;
   } break;
   case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONGET:
   case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONUPREG:
   case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONRELUPREG:
   case midw_tpegfi_tclToken::EN_BINCONTAINER:
   case midw_tpegfi_tclToken::EN_TPEGSID:
   case midw_tpegfi_tclToken::EN_E8_TPEGAPPLICATION:
   case midw_tpegfi_tclToken::EN_E8_TPEGLOCREFERENCING:
   case midw_tpegfi_tclToken::EN_TPEGACID:
   case midw_tpegfi_tclToken::EN_VERSIONEDTPEGACID:
   case midw_tpegfi_tclToken::EN_TPEGSTATISTICSPERLOCREF:
   case midw_tpegfi_tclToken::EN_TPEGSTREAMINFO:
   case midw_tpegfi_tclToken::EN_U8:   
   case midw_tpegfi_tclToken::EN_S8:   
   case midw_tpegfi_tclToken::EN_U16:   
   case midw_tpegfi_tclToken::EN_S16:   
   case midw_tpegfi_tclToken::EN_U24:   
   case midw_tpegfi_tclToken::EN_S24:   
   case midw_tpegfi_tclToken::EN_U32:   
   case midw_tpegfi_tclToken::EN_S32:   
   case midw_tpegfi_tclToken::EN_U64:   
   case midw_tpegfi_tclToken::EN_S64:   
   case midw_tpegfi_tclToken::EN_F32:   
   case midw_tpegfi_tclToken::EN_F64:   
   case midw_tpegfi_tclToken::EN_BOOL:   
   case midw_tpegfi_tclToken::EN_STRING:   
   case midw_tpegfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(enMsgToken,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_tpegfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_tpegfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_tpegfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_tpegfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_tpegfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_tpegfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_tpegfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_tpegfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_tpegfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_tpegfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_tpegfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_tpegfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_tpegfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONGET:
      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONUPREG:
      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONRELUPREG:
      case midw_tpegfi_tclToken::EN_MSG_STREAMINFORMATIONSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_tpegfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_LIST,midw_tpegfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_TPEGSID:
      {
      if (poVisitor->bDoExpand_TpegSid(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_SIDC));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_SIDB));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_SIDA));
      }
      else
      {
         midw_fi_tcl_TpegSid o_TpegSid;
         if (!bDoIt(o_TpegSid))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegSid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegSid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_E8_TPEGAPPLICATION:
      {
         midw_fi_tcl_e8_TpegApplication o_e8_TpegApplication;
         if (!bDoIt(o_e8_TpegApplication))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_E8_TPEGLOCREFERENCING:
      {
         midw_fi_tcl_e8_TpegLocReferencing o_e8_TpegLocReferencing;
         if (!bDoIt(o_e8_TpegLocReferencing))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_tpegfi_tclToken::EN_TPEGACID:
      {
      if (poVisitor->bDoExpand_TpegAcid(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_CONTENTID));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_E8_TPEGAPPLICATION,midw_tpegfi_tclSemanticDomain::EN_APPLICATIONID));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_TPEGSID,midw_tpegfi_tclSemanticDomain::EN_ORIGINATORSID));
      }
      else
      {
         midw_fi_tcl_TpegAcid o_TpegAcid;
         if (!bDoIt(o_TpegAcid))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_VERSIONEDTPEGACID:
      {
      if (poVisitor->bDoExpand_VersionedTpegAcid(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U8,midw_tpegfi_tclSemanticDomain::EN_VERSION));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_TPEGACID,midw_tpegfi_tclSemanticDomain::EN_ACID));
      }
      else
      {
         midw_fi_tcl_VersionedTpegAcid o_VersionedTpegAcid;
         if (!bDoIt(o_VersionedTpegAcid))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionedTpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VersionedTpegAcid.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_TPEGSTATISTICSPERLOCREF:
      {
      if (poVisitor->bDoExpand_TpegStatisticsPerLocRef(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U32,midw_tpegfi_tclSemanticDomain::EN_MAXMSGSPERFRAME));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U32,midw_tpegfi_tclSemanticDomain::EN_AVGMSGSPERFRAME));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_U32,midw_tpegfi_tclSemanticDomain::EN_MSGSPERFRAME));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_E8_TPEGLOCREFERENCING,midw_tpegfi_tclSemanticDomain::EN_LOCREFTYPE));
      }
      else
      {
         midw_fi_tcl_TpegStatisticsPerLocRef o_TpegStatisticsPerLocRef;
         if (!bDoIt(o_TpegStatisticsPerLocRef))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegStatisticsPerLocRef.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegStatisticsPerLocRef.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_TPEGSTREAMINFO:
      {
      if (poVisitor->bDoExpand_TpegStreamInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_END_OF_STRUCT,midw_tpegfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_TPEGSTATISTICSPERLOCREF,midw_tpegfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_LIST,midw_tpegfi_tclSemanticDomain::EN_LISTOFSTATISTICSPERLOCREF));
         (tVoid) oPath.bGoDown(midw_tpegfi_tclKnot(midw_tpegfi_tclToken::EN_VERSIONEDTPEGACID,midw_tpegfi_tclSemanticDomain::EN_VERSIONEDACID));
      }
      else
      {
         midw_fi_tcl_TpegStreamInfo o_TpegStreamInfo;
         if (!bDoIt(o_TpegStreamInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegStreamInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TpegStreamInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_tpegfi_tclToken::EN_UNKNOWN:
      case midw_tpegfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

