/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_streamrouter_fi message types

fi_tclMessageBase* midw_streamrouterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODSTART:
         return OSAL_NEW midw_streamrouterfi_tclMsgAllocateRouteMethodStart;

      case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODRESULT:
         return OSAL_NEW midw_streamrouterfi_tclMsgAllocateRouteMethodResult;

      case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODSTART:
         return OSAL_NEW midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart;

      case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODRESULT:
         return OSAL_NEW midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult;

      case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODSTART:
         return OSAL_NEW midw_streamrouterfi_tclMsgSetPlayMethodStart;

      case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODRESULT:
         return OSAL_NEW midw_streamrouterfi_tclMsgSetPlayMethodResult;

      case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODSTART:
         return OSAL_NEW midw_streamrouterfi_tclMsgSetStopMethodStart;

      case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODRESULT:
         return OSAL_NEW midw_streamrouterfi_tclMsgSetStopMethodResult;

      case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODSTART:
         return OSAL_NEW midw_streamrouterfi_tclMsgSendFGCommandMethodStart;

      case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODRESULT:
         return OSAL_NEW midw_streamrouterfi_tclMsgSendFGCommandMethodResult;

      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEUPREG:
         return OSAL_NEW midw_streamrouterfi_tclMsgRoutingStateUpReg;

      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATERELUPREG:
         return OSAL_NEW midw_streamrouterfi_tclMsgRoutingStateRelUpReg;

      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEGET:
         return OSAL_NEW midw_streamrouterfi_tclMsgRoutingStateGet;

      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATESTATUS:
         return OSAL_NEW midw_streamrouterfi_tclMsgRoutingStateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_streamrouterfifi messages

// common functions

tU16 midw_streamrouterfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_STREAMROUTERFI_C_U16_SERVICE_ID;
}

tU16 midw_streamrouterfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_streamrouterfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_streamrouterfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_streamrouterfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_streamrouterfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_streamrouterfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgAllocateRouteMethodStart::midw_streamrouterfi_tclMsgAllocateRouteMethodStart(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
   s32STM_MsgBufID = coRef.s32STM_MsgBufID;
   u16Sink = coRef.u16Sink;
}
midw_streamrouterfi_tclMsgAllocateRouteMethodStart& midw_streamrouterfi_tclMsgAllocateRouteMethodStart::operator=(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   s32STM_MsgBufID = coRef.s32STM_MsgBufID;
   u16Sink = coRef.u16Sink;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgAllocateRouteMethodStart::midw_streamrouterfi_tclMsgAllocateRouteMethodStart()
:u16UCID(0)
,s32STM_MsgBufID(0)
,u16Sink(0)
 {}

tS32 midw_streamrouterfi_tclMsgAllocateRouteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODSTART;
}


midw_streamrouterfi_tclMsgAllocateRouteMethodStart::~midw_streamrouterfi_tclMsgAllocateRouteMethodStart()
{}

tU32 midw_streamrouterfi_tclMsgAllocateRouteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_streamrouterfi_tclMsgAllocateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   (tVoid) (oIn >> s32STM_MsgBufID);
   (tVoid) (oIn >> u16Sink);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgAllocateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   (tVoid) (oOut << s32STM_MsgBufID);
   (tVoid) (oOut << u16Sink);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgAllocateRouteMethodStart::operator==(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   bResult = bResult && (s32STM_MsgBufID == roRef.s32STM_MsgBufID);
   bResult = bResult && (u16Sink == roRef.u16Sink);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgAllocateRouteMethodResult::midw_streamrouterfi_tclMsgAllocateRouteMethodResult(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
   u32STM_MsgBufID = coRef.u32STM_MsgBufID;
   u16MOSTConnectionLabel = coRef.u16MOSTConnectionLabel;
   u16MLBChannelAddress = coRef.u16MLBChannelAddress;
   u8BlkWidth = coRef.u8BlkWidth;
   u32SmHandle = coRef.u32SmHandle;
   listInputDev = coRef.listInputDev;
   listOutputDev = coRef.listOutputDev;
}
midw_streamrouterfi_tclMsgAllocateRouteMethodResult& midw_streamrouterfi_tclMsgAllocateRouteMethodResult::operator=(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   u32STM_MsgBufID = coRef.u32STM_MsgBufID;
   u16MOSTConnectionLabel = coRef.u16MOSTConnectionLabel;
   u16MLBChannelAddress = coRef.u16MLBChannelAddress;
   u8BlkWidth = coRef.u8BlkWidth;
   u32SmHandle = coRef.u32SmHandle;
   listInputDev = coRef.listInputDev;
   listOutputDev = coRef.listOutputDev;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_streamrouterfi_tclMsgAllocateRouteMethodResult::vDestroy()
{
   listInputDev.vDestroy(); 
   listOutputDev.vDestroy(); 
}

midw_streamrouterfi_tclMsgAllocateRouteMethodResult::midw_streamrouterfi_tclMsgAllocateRouteMethodResult()
:u16UCID(0)
,u32STM_MsgBufID(0)
,u16MOSTConnectionLabel(0)
,u16MLBChannelAddress(0)
,u8BlkWidth(0)
,u32SmHandle(0)
,listInputDev()
,listOutputDev()
 {}

tS32 midw_streamrouterfi_tclMsgAllocateRouteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODRESULT;
}


midw_streamrouterfi_tclMsgAllocateRouteMethodResult::~midw_streamrouterfi_tclMsgAllocateRouteMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_streamrouterfi_tclMsgAllocateRouteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+listInputDev.u32GetSize(u16MajorVersion)+listOutputDev.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_streamrouterfi_tclMsgAllocateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   (tVoid) (oIn >> u32STM_MsgBufID);
   (tVoid) (oIn >> u16MOSTConnectionLabel);
   (tVoid) (oIn >> u16MLBChannelAddress);
   (tVoid) (oIn >> u8BlkWidth);
   (tVoid) (oIn >> u32SmHandle);
   (tVoid) (oIn >> listInputDev);
   (tVoid) (oIn >> listOutputDev);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgAllocateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   (tVoid) (oOut << u32STM_MsgBufID);
   (tVoid) (oOut << u16MOSTConnectionLabel);
   (tVoid) (oOut << u16MLBChannelAddress);
   (tVoid) (oOut << u8BlkWidth);
   (tVoid) (oOut << u32SmHandle);
   (tVoid) (oOut << listInputDev);
   (tVoid) (oOut << listOutputDev);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgAllocateRouteMethodResult::operator==(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   bResult = bResult && (u32STM_MsgBufID == roRef.u32STM_MsgBufID);
   bResult = bResult && (u16MOSTConnectionLabel == roRef.u16MOSTConnectionLabel);
   bResult = bResult && (u16MLBChannelAddress == roRef.u16MLBChannelAddress);
   bResult = bResult && (u8BlkWidth == roRef.u8BlkWidth);
   bResult = bResult && (u32SmHandle == roRef.u32SmHandle);
   bResult = bResult && (listInputDev == roRef.listInputDev);
   bResult = bResult && (listOutputDev == roRef.listOutputDev);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
}
midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::operator=(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart()
:u16UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODSTART;
}


midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::~midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart()
{}

tU32 midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart::operator==(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
}
midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::operator=(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult()
:u16UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODRESULT;
}


midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::~midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult()
{}

tU32 midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult::operator==(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSetPlayMethodStart::midw_streamrouterfi_tclMsgSetPlayMethodStart(const midw_streamrouterfi_tclMsgSetPlayMethodStart& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
   eRampType = coRef.eRampType;
}
midw_streamrouterfi_tclMsgSetPlayMethodStart& midw_streamrouterfi_tclMsgSetPlayMethodStart::operator=(const midw_streamrouterfi_tclMsgSetPlayMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   eRampType = coRef.eRampType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSetPlayMethodStart::midw_streamrouterfi_tclMsgSetPlayMethodStart()
:u16UCID(0)
,eRampType()
 {}

tS32 midw_streamrouterfi_tclMsgSetPlayMethodStart::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODSTART;
}


midw_streamrouterfi_tclMsgSetPlayMethodStart::~midw_streamrouterfi_tclMsgSetPlayMethodStart()
{}

tU32 midw_streamrouterfi_tclMsgSetPlayMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSetPlayMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   (tVoid) (oIn >> eRampType);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSetPlayMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   (tVoid) (oOut << eRampType);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSetPlayMethodStart::operator==(const midw_streamrouterfi_tclMsgSetPlayMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   bResult = bResult && (eRampType == roRef.eRampType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSetPlayMethodResult::midw_streamrouterfi_tclMsgSetPlayMethodResult(const midw_streamrouterfi_tclMsgSetPlayMethodResult& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
}
midw_streamrouterfi_tclMsgSetPlayMethodResult& midw_streamrouterfi_tclMsgSetPlayMethodResult::operator=(const midw_streamrouterfi_tclMsgSetPlayMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSetPlayMethodResult::midw_streamrouterfi_tclMsgSetPlayMethodResult()
:u16UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgSetPlayMethodResult::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODRESULT;
}


midw_streamrouterfi_tclMsgSetPlayMethodResult::~midw_streamrouterfi_tclMsgSetPlayMethodResult()
{}

tU32 midw_streamrouterfi_tclMsgSetPlayMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSetPlayMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSetPlayMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSetPlayMethodResult::operator==(const midw_streamrouterfi_tclMsgSetPlayMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSetStopMethodStart::midw_streamrouterfi_tclMsgSetStopMethodStart(const midw_streamrouterfi_tclMsgSetStopMethodStart& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
   eRampType = coRef.eRampType;
}
midw_streamrouterfi_tclMsgSetStopMethodStart& midw_streamrouterfi_tclMsgSetStopMethodStart::operator=(const midw_streamrouterfi_tclMsgSetStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   eRampType = coRef.eRampType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSetStopMethodStart::midw_streamrouterfi_tclMsgSetStopMethodStart()
:u16UCID(0)
,eRampType()
 {}

tS32 midw_streamrouterfi_tclMsgSetStopMethodStart::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODSTART;
}


midw_streamrouterfi_tclMsgSetStopMethodStart::~midw_streamrouterfi_tclMsgSetStopMethodStart()
{}

tU32 midw_streamrouterfi_tclMsgSetStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSetStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   (tVoid) (oIn >> eRampType);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSetStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   (tVoid) (oOut << eRampType);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSetStopMethodStart::operator==(const midw_streamrouterfi_tclMsgSetStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   bResult = bResult && (eRampType == roRef.eRampType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSetStopMethodResult::midw_streamrouterfi_tclMsgSetStopMethodResult(const midw_streamrouterfi_tclMsgSetStopMethodResult& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
}
midw_streamrouterfi_tclMsgSetStopMethodResult& midw_streamrouterfi_tclMsgSetStopMethodResult::operator=(const midw_streamrouterfi_tclMsgSetStopMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSetStopMethodResult::midw_streamrouterfi_tclMsgSetStopMethodResult()
:u16UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgSetStopMethodResult::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODRESULT;
}


midw_streamrouterfi_tclMsgSetStopMethodResult::~midw_streamrouterfi_tclMsgSetStopMethodResult()
{}

tU32 midw_streamrouterfi_tclMsgSetStopMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSetStopMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSetStopMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSetStopMethodResult::operator==(const midw_streamrouterfi_tclMsgSetStopMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSendFGCommandMethodStart::midw_streamrouterfi_tclMsgSendFGCommandMethodStart(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
   u16FGRouteID = coRef.u16FGRouteID;
   eCmd = coRef.eCmd;
}
midw_streamrouterfi_tclMsgSendFGCommandMethodStart& midw_streamrouterfi_tclMsgSendFGCommandMethodStart::operator=(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   u16FGRouteID = coRef.u16FGRouteID;
   eCmd = coRef.eCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSendFGCommandMethodStart::midw_streamrouterfi_tclMsgSendFGCommandMethodStart()
:u16UCID(0)
,u16FGRouteID(0)
,eCmd()
 {}

tS32 midw_streamrouterfi_tclMsgSendFGCommandMethodStart::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODSTART;
}


midw_streamrouterfi_tclMsgSendFGCommandMethodStart::~midw_streamrouterfi_tclMsgSendFGCommandMethodStart()
{}

tU32 midw_streamrouterfi_tclMsgSendFGCommandMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSendFGCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   (tVoid) (oIn >> u16FGRouteID);
   (tVoid) (oIn >> eCmd);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSendFGCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   (tVoid) (oOut << u16FGRouteID);
   (tVoid) (oOut << eCmd);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSendFGCommandMethodStart::operator==(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   bResult = bResult && (u16FGRouteID == roRef.u16FGRouteID);
   bResult = bResult && (eCmd == roRef.eCmd);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgSendFGCommandMethodResult::midw_streamrouterfi_tclMsgSendFGCommandMethodResult(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   u16UCID = coRef.u16UCID;
}
midw_streamrouterfi_tclMsgSendFGCommandMethodResult& midw_streamrouterfi_tclMsgSendFGCommandMethodResult::operator=(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16UCID = coRef.u16UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgSendFGCommandMethodResult::midw_streamrouterfi_tclMsgSendFGCommandMethodResult()
:u16UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgSendFGCommandMethodResult::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODRESULT;
}


midw_streamrouterfi_tclMsgSendFGCommandMethodResult::~midw_streamrouterfi_tclMsgSendFGCommandMethodResult()
{}

tU32 midw_streamrouterfi_tclMsgSendFGCommandMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_streamrouterfi_tclMsgSendFGCommandMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgSendFGCommandMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgSendFGCommandMethodResult::operator==(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UCID == roRef.u16UCID);
   return bResult;
}

//=============================================================================

midw_streamrouterfi_tclMsgRoutingStateUpReg::midw_streamrouterfi_tclMsgRoutingStateUpReg()
 {}

tS32 midw_streamrouterfi_tclMsgRoutingStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEUPREG;
}


midw_streamrouterfi_tclMsgRoutingStateUpReg::~midw_streamrouterfi_tclMsgRoutingStateUpReg()
{}

//=============================================================================

midw_streamrouterfi_tclMsgRoutingStateRelUpReg::midw_streamrouterfi_tclMsgRoutingStateRelUpReg()
 {}

tS32 midw_streamrouterfi_tclMsgRoutingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATERELUPREG;
}


midw_streamrouterfi_tclMsgRoutingStateRelUpReg::~midw_streamrouterfi_tclMsgRoutingStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgRoutingStateGet::midw_streamrouterfi_tclMsgRoutingStateGet(const midw_streamrouterfi_tclMsgRoutingStateGet& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   s32UCID = coRef.s32UCID;
}
midw_streamrouterfi_tclMsgRoutingStateGet& midw_streamrouterfi_tclMsgRoutingStateGet::operator=(const midw_streamrouterfi_tclMsgRoutingStateGet& coRef)
{
   if (this == &coRef) return *this;
   s32UCID = coRef.s32UCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_streamrouterfi_tclMsgRoutingStateGet::midw_streamrouterfi_tclMsgRoutingStateGet()
:s32UCID(0)
 {}

tS32 midw_streamrouterfi_tclMsgRoutingStateGet::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEGET;
}


midw_streamrouterfi_tclMsgRoutingStateGet::~midw_streamrouterfi_tclMsgRoutingStateGet()
{}

tU32 midw_streamrouterfi_tclMsgRoutingStateGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_streamrouterfi_tclMsgRoutingStateGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32UCID);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgRoutingStateGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32UCID);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgRoutingStateGet::operator==(const midw_streamrouterfi_tclMsgRoutingStateGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32UCID == roRef.s32UCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_streamrouterfi_tclMsgRoutingStateStatus::midw_streamrouterfi_tclMsgRoutingStateStatus(const midw_streamrouterfi_tclMsgRoutingStateStatus& coRef)
   : midw_streamrouterfi_tclMsgBaseMessage(coRef)
{
   routing_list = coRef.routing_list;
}
midw_streamrouterfi_tclMsgRoutingStateStatus& midw_streamrouterfi_tclMsgRoutingStateStatus::operator=(const midw_streamrouterfi_tclMsgRoutingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   routing_list = coRef.routing_list;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_streamrouterfi_tclMsgRoutingStateStatus::vDestroy()
{
   routing_list.vDestroy(); 
}

midw_streamrouterfi_tclMsgRoutingStateStatus::midw_streamrouterfi_tclMsgRoutingStateStatus()
:routing_list()
 {}

tS32 midw_streamrouterfi_tclMsgRoutingStateStatus::s32GetTypeId() const
{
   return (tS32) midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATESTATUS;
}


midw_streamrouterfi_tclMsgRoutingStateStatus::~midw_streamrouterfi_tclMsgRoutingStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_streamrouterfi_tclMsgRoutingStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+routing_list.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_streamrouterfi_tclMsgRoutingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> routing_list);
   return oIn;
}

fi_tclOutContext& midw_streamrouterfi_tclMsgRoutingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << routing_list);
   return oOut;
}

tBool midw_streamrouterfi_tclMsgRoutingStateStatus::operator==(const midw_streamrouterfi_tclMsgRoutingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (routing_list == roRef.routing_list);
   return bResult;
}

