#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_STREAMROUTERFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_streamrouterfi_tclDescription::bInitMessage(midw_streamrouterfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_streamrouterfi_tclToken::EN_LAST_TOKEN:
   case midw_streamrouterfi_tclToken::EN_LIST:
   case midw_streamrouterfi_tclToken::EN_END_OF_STRUCT:
   case midw_streamrouterfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16SINK)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_S32,midw_streamrouterfi_tclSemanticDomain::EN_MSG_S32STM_MSGBUFID)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_STREAMROUTER_DEVICE_LIST,midw_streamrouterfi_tclSemanticDomain::EN_MSG_LISTOUTPUTDEV)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_STREAMROUTER_DEVICE_LIST,midw_streamrouterfi_tclSemanticDomain::EN_MSG_LISTINPUTDEV)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U32,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U32SMHANDLE)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U8,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U8BLKWIDTH)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16MLBCHANNELADDRESS)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16MOSTCONNECTIONLABEL)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U32,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U32STM_MSGBUFID)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_RAMPTYPE,midw_streamrouterfi_tclSemanticDomain::EN_MSG_ERAMPTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_RAMPTYPE,midw_streamrouterfi_tclSemanticDomain::EN_MSG_ERAMPTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_FGCOMMAND,midw_streamrouterfi_tclSemanticDomain::EN_MSG_ECMD)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16FGROUTEID)) && bResult;
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_MSG_U16UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEGET:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_S32,midw_streamrouterfi_tclSemanticDomain::EN_MSG_S32UCID)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATESTATUS:
   {
      bResult = oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTING_LIST,midw_streamrouterfi_tclSemanticDomain::EN_MSG_ROUTING_LIST)) && bResult;
   } break;
   case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEUPREG:
   case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATERELUPREG:
   case midw_streamrouterfi_tclToken::EN_BINCONTAINER:
   case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_ROUTESTATE:
   case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_RAMPTYPE:
   case midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTE_ENTRY:
   case midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTING_LIST:
   case midw_streamrouterfi_tclToken::EN_STREAMROUTER_DEVICE_LIST:
   case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_FGCOMMAND:
   case midw_streamrouterfi_tclToken::EN_U8:   
   case midw_streamrouterfi_tclToken::EN_S8:   
   case midw_streamrouterfi_tclToken::EN_U16:   
   case midw_streamrouterfi_tclToken::EN_S16:   
   case midw_streamrouterfi_tclToken::EN_U24:   
   case midw_streamrouterfi_tclToken::EN_S24:   
   case midw_streamrouterfi_tclToken::EN_U32:   
   case midw_streamrouterfi_tclToken::EN_S32:   
   case midw_streamrouterfi_tclToken::EN_U64:   
   case midw_streamrouterfi_tclToken::EN_S64:   
   case midw_streamrouterfi_tclToken::EN_F32:   
   case midw_streamrouterfi_tclToken::EN_F64:   
   case midw_streamrouterfi_tclToken::EN_BOOL:   
   case midw_streamrouterfi_tclToken::EN_STRING:   
   case midw_streamrouterfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(enMsgToken,midw_streamrouterfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_streamrouterfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_streamrouterfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_streamrouterfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_streamrouterfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_streamrouterfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_streamrouterfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_streamrouterfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_streamrouterfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_streamrouterfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_streamrouterfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_streamrouterfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_streamrouterfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_streamrouterfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODSTART:
      case midw_streamrouterfi_tclToken::EN_MSG_ALLOCATEROUTEMETHODRESULT:
      case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODSTART:
      case midw_streamrouterfi_tclToken::EN_MSG_DEALLOCATEROUTEMETHODRESULT:
      case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODSTART:
      case midw_streamrouterfi_tclToken::EN_MSG_SETPLAYMETHODRESULT:
      case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODSTART:
      case midw_streamrouterfi_tclToken::EN_MSG_SETSTOPMETHODRESULT:
      case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODSTART:
      case midw_streamrouterfi_tclToken::EN_MSG_SENDFGCOMMANDMETHODRESULT:
      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEUPREG:
      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATERELUPREG:
      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATEGET:
      case midw_streamrouterfi_tclToken::EN_MSG_ROUTINGSTATESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_streamrouterfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_END_OF_STRUCT,midw_streamrouterfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U8,midw_streamrouterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_LIST,midw_streamrouterfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_ROUTESTATE:
      {
         midw_fi_tcl_e8_streamrouter_routestate o_e8_streamrouter_routestate;
         if (!bDoIt(o_e8_streamrouter_routestate))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_RAMPTYPE:
      {
         midw_fi_tcl_e8_streamrouter_ramptype o_e8_streamrouter_ramptype;
         if (!bDoIt(o_e8_streamrouter_ramptype))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTE_ENTRY:
      {
      if (poVisitor->bDoExpand_streamrouter_route_entry(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_END_OF_STRUCT,midw_streamrouterfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_ROUTESTATE,midw_streamrouterfi_tclSemanticDomain::EN_E8ROUTESTATE));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U8,midw_streamrouterfi_tclSemanticDomain::EN_U8BLKWIDTH));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_U16MLBCHANNELADDRESS));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U16,midw_streamrouterfi_tclSemanticDomain::EN_U16APPID));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_U32,midw_streamrouterfi_tclSemanticDomain::EN_U32UCID));
      }
      else
      {
         midw_fi_tcl_streamrouter_route_entry o_streamrouter_route_entry;
         if (!bDoIt(o_streamrouter_route_entry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_route_entry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_route_entry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTING_LIST:
      {
      if (poVisitor->bDoExpand_streamrouter_routing_list(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_END_OF_STRUCT,midw_streamrouterfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_STREAMROUTER_ROUTE_ENTRY,midw_streamrouterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_LIST,midw_streamrouterfi_tclSemanticDomain::EN_SRENTRY));
      }
      else
      {
         midw_fi_tcl_streamrouter_routing_list o_streamrouter_routing_list;
         if (!bDoIt(o_streamrouter_routing_list))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_routing_list.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_routing_list.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_streamrouterfi_tclToken::EN_STREAMROUTER_DEVICE_LIST:
      {
      if (poVisitor->bDoExpand_streamrouter_device_list(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_END_OF_STRUCT,midw_streamrouterfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_STRING,midw_streamrouterfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_streamrouterfi_tclKnot(midw_streamrouterfi_tclToken::EN_LIST,midw_streamrouterfi_tclSemanticDomain::EN_STRALSADEV));
      }
      else
      {
         midw_fi_tcl_streamrouter_device_list o_streamrouter_device_list;
         if (!bDoIt(o_streamrouter_device_list))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_device_list.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_streamrouter_device_list.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_streamrouterfi_tclToken::EN_E8_STREAMROUTER_FGCOMMAND:
      {
         midw_fi_tcl_e8_streamrouter_fgcommand o_e8_streamrouter_fgcommand;
         if (!bDoIt(o_e8_streamrouter_fgcommand))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_streamrouterfi_tclToken::EN_UNKNOWN:
      case midw_streamrouterfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

