/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_SMARTPHONEINTFITYPES_HEADER
#define MIDW_SMARTPHONEINTFITYPES_HEADER


class midw_smartphoneintfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_smartphoneint_fi message types

fi_tclMessageBase* midw_smartphoneintfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_smartphoneintfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_smartphoneintfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart();

   virtual ~midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 NumDevices;
   std::vector<midw_fi_tcl_DeviceDetails, std::allocator<midw_fi_tcl_DeviceDetails> > DeviceInfoList;
   virtual ~midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSelectDeviceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSelectDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& operator=(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSelectDeviceMethodStart(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceConnectionType DeviceConnectionType;
   midw_fi_tcl_e8_DeviceConnectionReq DeviceConnectionReq;
   midw_fi_tcl_e8_EnabledInfo DAPUsage;
   midw_fi_tcl_e8_EnabledInfo CDBUsage;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_e8_SelectionType SelectionType;
   virtual ~midw_smartphoneintfi_tclMsgSelectDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSelectDeviceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSelectDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& operator=(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSelectDeviceMethodResult(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceConnectionType DeviceConnectionType;
   midw_fi_tcl_e8_DeviceConnectionReq DeviceConnectionReq;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   tBool BTPairingRequired;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   virtual ~midw_smartphoneintfi_tclMsgSelectDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgLaunchAppMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgLaunchAppMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgLaunchAppMethodStart& operator=(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& coRef);
   midw_smartphoneintfi_tclMsgLaunchAppMethodStart(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   tU32 AppHandle;
   midw_fi_tcl_e8_DiPOAppType DiPOAppType;
   midw_fi_tclString TelephoneNumber;
   midw_fi_tcl_e8_EcnrSetting EcnrSetting;
   virtual ~midw_smartphoneintfi_tclMsgLaunchAppMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgLaunchAppMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgLaunchAppMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgLaunchAppMethodResult& operator=(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& coRef);
   midw_smartphoneintfi_tclMsgLaunchAppMethodResult(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   midw_fi_tcl_e8_DiPOAppType DiPOAppType;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgLaunchAppMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTerminateAppMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTerminateAppMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgTerminateAppMethodStart& operator=(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& coRef);
   midw_smartphoneintfi_tclMsgTerminateAppMethodStart(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   virtual ~midw_smartphoneintfi_tclMsgTerminateAppMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTerminateAppMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTerminateAppMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgTerminateAppMethodResult& operator=(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& coRef);
   midw_smartphoneintfi_tclMsgTerminateAppMethodResult(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgTerminateAppMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetAppListMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetAppListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetAppListMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetAppListMethodStart(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   virtual ~midw_smartphoneintfi_tclMsgGetAppListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetAppListMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetAppListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetAppListMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetAppListMethodResult(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU16 NumAppDetailsList;
   std::vector<midw_fi_tcl_AppDetails, std::allocator<midw_fi_tcl_AppDetails> > AppDetailsList;
   virtual ~midw_smartphoneintfi_tclMsgGetAppListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString AppIconURL;
   virtual ~midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString IconMimeType;
   std::vector<tU8, std::allocator<tU8> > AppIconData;
   virtual ~midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   midw_fi_tcl_IconAttributes IconAttributes;
   virtual ~midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_e8_EnabledInfo EnabledInfo;
   virtual ~midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU16 NumNotificationEnableList;
   std::vector<midw_fi_tcl_NotificationEnable, std::allocator<midw_fi_tcl_NotificationEnable> > NotificationEnableList;
   virtual ~midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& operator=(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& coRef);
   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   tU16 NotificationID;
   tU16 NotificationActionID;
   virtual ~midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& operator=(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& coRef);
   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   virtual ~midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_VideoAttributes VideoAttributes;
   virtual ~midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_OrientationMode OrientationMode;
   virtual ~midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ScreenAttributes ScreenAttributes;
   virtual ~midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_BlockingMode BlockingMode;
   midw_fi_tcl_e8_VideoBlockingReason VideoBlockingReason;
   virtual ~midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool GlobalMuteEnable;
   tBool MediaAudioBlockingEnable;
   virtual ~midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Vehicle_Configuration VehicleConfiguration;
   tBool SetConfiguration;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendTouchEventMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendTouchEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& operator=(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSendTouchEventMethodStart(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_TouchData TouchData;
   virtual ~midw_smartphoneintfi_tclMsgSendTouchEventMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendTouchEventMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendTouchEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& operator=(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSendTouchEventMethodResult(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSendTouchEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendKeyEventMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendKeyEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& operator=(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSendKeyEventMethodStart(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_KeyMode KeyMode;
   midw_fi_tcl_e32_KeyCode KeyCode;
   virtual ~midw_smartphoneintfi_tclMsgSendKeyEventMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendKeyEventMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendKeyEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& operator=(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSendKeyEventMethodResult(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSendKeyEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ClientCapabilities ClientCapabilities;
   virtual ~midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& operator=(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& coRef);
   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool DisplayFlag;
   midw_fi_tcl_e8_DisplayContext DisplayContext;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& operator=(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& coRef);
   midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   virtual ~midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_e8_EnabledInfo EnabledInfo;
   virtual ~midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString BTAddress;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& operator=(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& coRef);
   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 BluetoothDeviceHandle;
   tU32 ProjectionDeviceHandle;
   midw_fi_tcl_e8_BTChangeInfo BTChangeInfo;
   virtual ~midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& operator=(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& coRef);
   midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& operator=(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& coRef);
   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool AudioFlag;
   midw_fi_tcl_e8_AudioContext AudioContext;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& operator=(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& coRef);
   midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& operator=(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& coRef);
   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SpeechAppState AppStateSpeech;
   midw_fi_tcl_e8_PhoneAppState AppStatePhone;
   midw_fi_tcl_e8_NavigationAppState AppStateNavigation;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& operator=(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& coRef);
   midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetRegionMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetRegionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetRegionMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetRegionMethodStart(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Region Region;
   virtual ~midw_smartphoneintfi_tclMsgSetRegionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetRegionMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetRegionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetRegionMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetRegionMethodResult(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetRegionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& operator=(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& coRef);
   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   midw_fi_tclString USBSerialNumber;
   tBool DeviceCarplayCapability;
   virtual ~midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& operator=(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& coRef);
   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   midw_fi_tcl_e8_DiPOSwitchReqResponse e8DiPOSwitchReqResponse;
   midw_fi_tclString USBSerialNumber;
   midw_fi_tcl_EAPAppInfo rEAPAppInfo;
   virtual ~midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_AccessoryDisplayContext DisplayContextInfo;
   midw_fi_tcl_DisplayConstraint DisplayConstraintInfo;
   midw_fi_tcl_e8_DisplayInfo ContextResponsibility;
   virtual ~midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tclString KeyIconURL;
   virtual ~midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   std::vector<tU8, std::allocator<tU8> > KeyIconData;
   virtual ~midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DisplayAttributes DisplayAttributes;
   virtual ~midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& operator=(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& coRef);
   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tS8 ControllerDeltaCounts;
   virtual ~midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& operator=(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& coRef);
   midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   std::vector<midw_fi_tcl_AccessoryAudioContext, std::allocator<midw_fi_tcl_AccessoryAudioContext> > AudioContextInfo;
   virtual ~midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ParkBrake ParkBrakeInfo;
   midw_fi_tcl_e8_GearState GearInfo;
   midw_fi_tcl_e8_VehicleState VehicleState;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_FeatureRestriction ParkModeRestrictionInfo;
   midw_fi_tcl_FeatureRestriction DriveModeRestrictionInfo;
   tU16 GeneralRestrictionInfo;
   virtual ~midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& operator=(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& coRef);
   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 VehicleSpeed;
   virtual ~midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& operator=(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& coRef);
   midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString VehicleMake;
   midw_fi_tclString VehicleModel;
   midw_fi_tclString VehicleModelYear;
   midw_fi_tclString VehicleHUSwVersion;
   midw_fi_tclString VehicleHUHwVersion;
   midw_fi_tclString VehicleHUMake;
   midw_fi_tclString VehicleHUModel;
   midw_fi_tclString VehicleHUSwBuild;
   midw_fi_tcl_e8_Vehicle_Configuration DriverSideInfo;
   tBool isNativeNavSupported;
   midw_fi_tcl_OEMICONDetails OEMICONDetails;
   tBool isRotaryCtrlSupported;
   midw_fi_tcl_e8_FidelityType FidelityType;
   tU16 SupportedSPITechnologiesInfo;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF64 OutsideTemperature;
   tBool ValidTemperature;
   tF64 BarometricPressure;
   tBool ValidPressure;
   virtual ~midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tclString sAlbumArt;
   virtual ~midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > oImageData;
   virtual ~midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU16 NumofPreferences;
   std::vector<midw_fi_tcl_e8_DeviceCategory, std::allocator<midw_fi_tcl_e8_DeviceCategory> > PreferenceOrderList;
   midw_fi_tcl_e8_DeviceType DeviceType;
   virtual ~midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceType DeviceType;
   virtual ~midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 NumofPreferences;
   std::vector<midw_fi_tcl_e8_DeviceCategory, std::allocator<midw_fi_tcl_e8_DeviceCategory> > PreferenceOrderList;
   virtual ~midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DeviceSelectionMode DeviceSelectionMode;
   virtual ~midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart();

   virtual ~midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString SPIVersion;
   virtual ~midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& operator=(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& coRef);
   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString BTMACAddress;
   midw_fi_tcl_e8_DeviceCategory Technology;
   tBool isKnownDevice;
   virtual ~midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& operator=(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& coRef);
   midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& operator=(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& coRef);
   midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DeviceList;
   virtual ~midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& operator=(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& coRef);
   midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > DeviceList;
   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString BTMACAddress;
   virtual ~midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString BTMACAddress;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   midw_fi_tcl_WiFiAPCredentials AccessoryWiFiAPCredentials;
   virtual ~midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetETCStatusMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetETCStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetETCStatusMethodStart(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ETCStatus;
   virtual ~midw_smartphoneintfi_tclMsgSetETCStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetETCStatusMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetETCStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetETCStatusMethodResult(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgSetETCStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& operator=(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& coRef);
   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 DistanceToEmptyTank;
   virtual ~midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& operator=(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& coRef);
   midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& operator=(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_Language LanguageSetting;
   virtual ~midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& operator=(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& operator=(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VehiclePowerModeState VehiclePowerModeState;
   virtual ~midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& operator=(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& operator=(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_AmbientColourData AmbientColourData;
   virtual ~midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& operator=(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   midw_fi_tcl_e8_ErrorType ErrorCode;
   virtual ~midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& operator=(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& coRef);
   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_RouteGuidanceDisplayComponent, std::allocator<midw_fi_tcl_RouteGuidanceDisplayComponent> > RouteGuidanceDisplayComponents;
   virtual ~midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& operator=(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& coRef);
   midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& operator=(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> > RoutGuidanceComponentID;
   tBool SourceName;
   tBool SourceSupportsRouteGuidance;
   tBool NeedAutoStartStopTBTUpdates;
   virtual ~midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& operator=(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& operator=(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> > RoutGuidanceComponentID;
   virtual ~midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& operator=(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetDeviceListMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& operator=(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& coRef);
   midw_smartphoneintfi_tclMsgGetDeviceListMethodStart(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   virtual ~midw_smartphoneintfi_tclMsgGetDeviceListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgGetDeviceListMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgGetDeviceListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& operator=(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& coRef);
   midw_smartphoneintfi_tclMsgGetDeviceListMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 NumDevices;
   std::vector<midw_fi_tcl_DeviceDetails, std::allocator<midw_fi_tcl_DeviceDetails> > DeviceInfoList;
   virtual ~midw_smartphoneintfi_tclMsgGetDeviceListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetClientStateMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetClientStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetClientStateMethodStart& operator=(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& coRef);
   midw_smartphoneintfi_tclMsgSetClientStateMethodStart(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ClientState ClientState;
   virtual ~midw_smartphoneintfi_tclMsgSetClientStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSetClientStateMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSetClientStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSetClientStateMethodResult& operator=(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& coRef);
   midw_smartphoneintfi_tclMsgSetClientStateMethodResult(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   virtual ~midw_smartphoneintfi_tclMsgSetClientStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& operator=(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& coRef);
   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TechnologyKeyConfig, std::allocator<midw_fi_tcl_TechnologyKeyConfig> > SupportedKeys;
   virtual ~midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& operator=(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& coRef);
   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResponseCode ResponseCode;
   std::vector<midw_fi_tcl_TechnologyKeyConfig, std::allocator<midw_fi_tcl_TechnologyKeyConfig> > UnSupportedKeys;
   virtual ~midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceConnectionType DeviceConnectionType;
   midw_fi_tcl_e8_DeviceStatusInfo DeviceStatus;
   virtual ~midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAppStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAppStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAppStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAppStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAppStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAppStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAppStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgAppStatusInfoStatus(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceConnectionType DeviceConnectionType;
   midw_fi_tcl_e8_AppStatusInfo AppStatus;
   virtual ~midw_smartphoneintfi_tclMsgAppStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDAPStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDAPStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgDAPStatusInfoStatus(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceConnectionType DeviceConnectionType;
   midw_fi_tcl_e8_DAPStatus DAPStatus;
   virtual ~midw_smartphoneintfi_tclMsgDAPStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNotificationInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNotificationInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNotificationInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNotificationInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNotificationInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNotificationInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgNotificationInfoStatus& operator=(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgNotificationInfoStatus(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 AppHandle;
   midw_fi_tcl_NotificationData NotificationData;
   virtual ~midw_smartphoneintfi_tclMsgNotificationInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& operator=(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& coRef);
   midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool MetaDataValid;
   midw_fi_tcl_ApplicationMediaMetaData ApplicationMediaMetaData;
   virtual ~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& operator=(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& coRef);
   midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool DisplayFlag;
   midw_fi_tcl_e8_DisplayContextReason DisplayContextReason;
   midw_fi_tcl_e8_Entity DisplayPermanentEntity;
   virtual ~midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& operator=(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& coRef);
   midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool PhoneDataValid;
   std::vector<midw_fi_tcl_ApplicationPhoneCallMetadata, std::allocator<midw_fi_tcl_ApplicationPhoneCallMetadata> > PhoneCallMetadata;
   midw_fi_tcl_e8_PhoneSignalStrength SignalStrength;
   midw_fi_tcl_e8_PhoneRegistrationStatus RegistrationStatus;
   midw_fi_tcl_e8_PhoneAirPlaneModeStatus AirPlaneModeStatus;
   midw_fi_tcl_e8_Mute Mute;
   midw_fi_tclString CarrierName;
   tU8 BatteryChargeLevel;
   midw_fi_tcl_e8_BatteryChargingState BatteryChargingState;
   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& operator=(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& coRef);
   midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 BluetoothDeviceHandle;
   tU32 ProjectionDeviceHandle;
   tU8 ConnectedProfiles;
   midw_fi_tcl_e8_BTChangeInfo BTChangeInfo;
   tBool SameDevice;
   tBool CallActiveStatus;
   virtual ~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceAudioContextStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceAudioContextStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& operator=(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& coRef);
   midw_smartphoneintfi_tclMsgDeviceAudioContextStatus(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tBool AudioFlag;
   midw_fi_tcl_e8_AudioContext AudioContext;
   midw_fi_tcl_e8_Entity AudioPermanentEntity;
   virtual ~midw_smartphoneintfi_tclMsgDeviceAudioContextStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SpeechAppState AppStateSpeech;
   midw_fi_tcl_e8_PhoneAppState AppStatePhone;
   midw_fi_tcl_e8_NavigationAppState AppStateNavigation;
   virtual ~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgSessionStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgSessionStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgSessionStatusInfoStatus(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_e8_SessionStatus SessionStatus;
   midw_fi_tcl_e8_HandsetInteraction HandsetInteractionStatus;
   virtual ~midw_smartphoneintfi_tclMsgSessionStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBTPairingRequiredStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBTPairingRequiredStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& operator=(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& coRef);
   midw_smartphoneintfi_tclMsgBTPairingRequiredStatus(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sDevBTAddr;
   tBool bPairingReqd;
   virtual ~midw_smartphoneintfi_tclMsgBTPairingRequiredStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& operator=(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& coRef);
   midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU16 ValidityOfData;
   tU16 NumXDeviceKeys;
   std::vector<midw_fi_tcl_XDeviceKeys, std::allocator<midw_fi_tcl_XDeviceKeys> > XDeviceKeysList;
   midw_fi_tcl_KeyCapabilities rKeyCapabilities;
   midw_fi_tcl_e8_SupportInfo VoiceRecognitionSupportInfo;
   virtual ~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDialUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDialUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDialUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDialUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDialRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDialRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDialRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDialRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDialSet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDialSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDialSet& operator=(const midw_smartphoneintfi_tclMsgDialSet& coRef);
   midw_smartphoneintfi_tclMsgDialSet(const midw_smartphoneintfi_tclMsgDialSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_PhoneCallState PhoneCallState;
   virtual ~midw_smartphoneintfi_tclMsgDialSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDialSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDialStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDialStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDialStatus& operator=(const midw_smartphoneintfi_tclMsgDialStatus& coRef);
   midw_smartphoneintfi_tclMsgDialStatus(const midw_smartphoneintfi_tclMsgDialStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tclString TelephoneNumber;
   midw_fi_tclString DisplayContent;
   virtual ~midw_smartphoneintfi_tclMsgDialStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDialStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& operator=(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& coRef);
   midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   tU32 TotalPlayTime;
   tU32 ElapsedPlayTime;
   virtual ~midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg();

   virtual ~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& operator=(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& coRef);
   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_UserAuthorizationStatus UserAuthorizationStatus;
   virtual ~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& operator=(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& coRef);
   midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 NumDevices;
   std::vector<midw_fi_tcl_DeviceAuthInfo, std::allocator<midw_fi_tcl_DeviceAuthInfo> > DeviceAuthInfoList;
   virtual ~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& operator=(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_e8_NavigationAppState NavigationStatus;
   virtual ~midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& operator=(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& coRef);
   midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tclString RoadName;
   midw_fi_tcl_e8_TurnSide TurnSide;
   midw_fi_tcl_e8_NextTurnEvent NextTurnEvent;
   midw_fi_tclString Image;
   tS32 TurnAngle;
   tS32 TurnNumber;
   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& operator=(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& coRef);
   midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   tS32 DistanceInMeters;
   tS32 TimeInSec ;
   tS32 DistanceToManeuver;
   midw_fi_tcl_e8_ManeuverDistanceUnits ManeuverDistanceUnits ;
   virtual ~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAPNotificationEventSet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAPNotificationEventSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAAPNotificationEventSet& operator=(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& coRef);
   midw_smartphoneintfi_tclMsgAAPNotificationEventSet(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString AAPNotificationId;
   virtual ~midw_smartphoneintfi_tclMsgAAPNotificationEventSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAPNotificationEventStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAPNotificationEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& operator=(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& coRef);
   midw_smartphoneintfi_tclMsgAAPNotificationEventStatus(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tclString AAPNotificationId;
   midw_fi_tclString NotificationText;
   std::vector<tU8, std::allocator<tU8> > NotificationIcon;
   virtual ~midw_smartphoneintfi_tclMsgAAPNotificationEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& operator=(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& coRef);
   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_BTVoiceRecRequestResponse BTVoiceRecReqResponse;
   virtual ~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& operator=(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_BTVoiceRecRequest BTVoiceRecRequest;
   virtual ~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTechnologySelectionUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTechnologySelectionUpReg();

   virtual ~midw_smartphoneintfi_tclMsgTechnologySelectionUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTechnologySelectionSet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTechnologySelectionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgTechnologySelectionSet& operator=(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& coRef);
   midw_smartphoneintfi_tclMsgTechnologySelectionSet(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory SelectedTechnology;
   virtual ~midw_smartphoneintfi_tclMsgTechnologySelectionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTechnologySelectionStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTechnologySelectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgTechnologySelectionStatus& operator=(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& coRef);
   midw_smartphoneintfi_tclMsgTechnologySelectionStatus(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory SelectedTechnology;
   midw_fi_tcl_e8_DeviceType DeviceType;
   virtual ~midw_smartphoneintfi_tclMsgTechnologySelectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg();

   virtual ~midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgWiFiCredentialsGet : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgWiFiCredentialsGet();

   virtual ~midw_smartphoneintfi_tclMsgWiFiCredentialsGet();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgWiFiCredentialsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgWiFiCredentialsStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgWiFiCredentialsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& operator=(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& coRef);
   midw_smartphoneintfi_tclMsgWiFiCredentialsStatus(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_WiFiAPCredentials AccessoryWiFiAPCredentials;
   virtual ~midw_smartphoneintfi_tclMsgWiFiCredentialsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& operator=(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   midw_fi_tcl_CarPlayTBTUpdate CarPlayTBTUpdate;
   midw_fi_tcl_AAutoTBTUpdate AAutoTBTUpdate;
   midw_fi_tcl_BDCLTBTUpdate BDCLTBTUpdate;
   midw_fi_tcl_MLTBTUpdate MLTBTUpdate;
   virtual ~midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& operator=(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_ProjectionVideoAttributes ProjectedVideoAttributes;
   virtual ~midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgDeviceLockStatusStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgDeviceLockStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& operator=(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& coRef);
   midw_smartphoneintfi_tclMsgDeviceLockStatusStatus(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_e8_DeviceCategory DeviceCategory;
   tBool bDeviceLockStatus;
   virtual ~midw_smartphoneintfi_tclMsgDeviceLockStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg();

   virtual ~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& operator=(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& coRef);
   midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MediaAppHandle;
   midw_fi_tcl_e8Media_AppCategory MediaAppCategory;
   virtual ~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg();

   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& operator=(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& coRef);
   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tclString DeviceUSBSerialNumber;
   midw_fi_tcl_CarPlayRouteGuidanceUpdate RouteGuidanceUpdate;
   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg();

   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& operator=(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& coRef);
   midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tclString DeviceUSBSerialNumber;
   midw_fi_tcl_CarPlayRouteGuidanceManeuverUpdate RouteGuidanceManeuverUpdate;
   virtual ~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& operator=(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_AAutoTBTUpdate AAutoTBTUpdate;
   virtual ~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& operator=(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_BDCLTBTUpdate BDCLTBTUpdate;
   virtual ~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& operator=(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& coRef);
   midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   midw_fi_tcl_MLTBTUpdate MLTBTUpdate;
   virtual ~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg();

   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg();

   inline tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus : public midw_smartphoneintfi_tclMsgBaseMessage
{
public:

   midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& operator=(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& coRef);
   midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceHandle;
   std::vector<midw_fi_tcl_ApplicationPhoneCallExtendedMetadata, std::allocator<midw_fi_tcl_ApplicationPhoneCallExtendedMetadata> > PhoneCallExtendedMetadata;
   virtual ~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
