/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_smartphoneint_fi message types

fi_tclMessageBase* midw_smartphoneintfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEINFOLISTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEINFOLISTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SELECTDEVICEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSelectDeviceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SELECTDEVICEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSelectDeviceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_LAUNCHAPPMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgLaunchAppMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_LAUNCHAPPMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgLaunchAppMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_TERMINATEAPPMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTerminateAppMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_TERMINATEAPPMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTerminateAppMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETAPPLISTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetAppListMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETAPPLISTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetAppListMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETAPPICONDATAMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETAPPICONDATAMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETAPPICONATTRIBUTESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETAPPICONATTRIBUTESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICEUSAGEPREFERENCEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICEUSAGEPREFERENCEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETMLNOTIFICATIONENABLEDINFOMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETMLNOTIFICATIONENABLEDINFOMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_INVOKENOTIFICATIONACTIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_INVOKENOTIFICATIONACTIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETVIDEOSETTINGSMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETVIDEOSETTINGSMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETORIENTATIONMODEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETORIENTATIONMODEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETSCREENSIZEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETSCREENSIZEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVIDEOBLOCKINGMODEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVIDEOBLOCKINGMODEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETAUDIOBLOCKINGMODEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETAUDIOBLOCKINGMODEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLECONFIGURATIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLECONFIGURATIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDTOUCHEVENTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendTouchEventMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDTOUCHEVENTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendTouchEventMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDKEYEVENTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendKeyEventMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDKEYEVENTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendKeyEventMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTCAPABILITIESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTCAPABILITIESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYDISPLAYCONTEXTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYDISPLAYCONTEXTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEUSAGEPREFERENCEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEUSAGEPREFERENCEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEBTADDRESSMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEBTADDRESSMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_INVOKEBLUETOOTHDEVICEACTIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_INVOKEBLUETOOTHDEVICEACTIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAUDIOCONTEXTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAUDIOCONTEXTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAPPSTATEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAPPSTATEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETREGIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetRegionMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETREGIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetRegionMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIPOROLESWITCHREQUIREDMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIPOROLESWITCHREQUIREDMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYDISPLAYCONTEXTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYDISPLAYCONTEXTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETKEYICONDATAMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETKEYICONDATAMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDISPLAYATTRIBUTESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDISPLAYATTRIBUTESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_ROTARYCONTROLLEREVENTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_ROTARYCONTROLLEREVENTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYAUDIOCONTEXTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYAUDIOCONTEXTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMOVEMENTSTATEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMOVEMENTSTATEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETFEATURERESTRICTIONSMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETFEATURERESTRICTIONSMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_VEHICLEMECHANICALSPEEDMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_VEHICLEMECHANICALSPEEDMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMANUFACTURERINFORMATIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMANUFACTURERINFORMATIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETENVIRONMENTDATAMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETENVIRONMENTDATAMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETTECHNOLOGYPREFERENCEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETTECHNOLOGYPREFERENCEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETTECHNOLOGYPREFERENCEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETTECHNOLOGYPREFERENCEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICESELECTIONMODEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICESELECTIONMODEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETSPIVERSIONINFOMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETSPIVERSIONINFOMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_INITIATEWIRELESSDISCOVERYMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_INITIATEWIRELESSDISCOVERYMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_DELETEDEVICEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_DELETEDEVICEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETWIFICREDENTIALSMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETWIFICREDENTIALSMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETETCSTATUSMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetETCStatusMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETETCSTATUSMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetETCStatusMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_DISTANCETOEMPTYTANKMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_DISTANCETOEMPTYTANKMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDLANGUAGESETTINGMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDLANGUAGESETTINGMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDVEHICLEPOWERMODESTATEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDVEHICLEPOWERMODESTATEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDAMBIENTCOLOURMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SENDAMBIENTCOLOURMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_REGISTERROUTEGUIDANCEDISPLAYCONFIGURATIONMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_REGISTERROUTEGUIDANCEDISPLAYCONFIGURATIONMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_STARTROUTEGUIDANCEUPDATESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_STARTROUTEGUIDANCEUPDATESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_STOPROUTEGUIDANCEUPDATESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_STOPROUTEGUIDANCEUPDATESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICELISTMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceListMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICELISTMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgGetDeviceListMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTSTATEMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetClientStateMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTSTATEMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSetClientStateMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_REGISTERKEYCODESMETHODSTART:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart;

      case midw_smartphoneintfi_tclToken::EN_MSG_REGISTERKEYCODESMETHODRESULT:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAppStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAppStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDAPStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNotificationInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNotificationInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATAUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATARELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATASTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATAUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATARELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATASTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceAudioContextStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgSessionStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBTPairingRequiredStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIALUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDialUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIALRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDialRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIALSET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDialSet;

      case midw_smartphoneintfi_tclToken::EN_MSG_DIALSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDialStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMEUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMERELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMESTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONSET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATAUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATARELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATASTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATAUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATARELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATASTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTSET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAPNotificationEventSet;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAPNotificationEventStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOSET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet;

      case midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTechnologySelectionUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONSET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTechnologySelectionSet;

      case midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTechnologySelectionStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSGET:
         return OSAL_NEW midw_smartphoneintfi_tclMsgWiFiCredentialsGet;

      case midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgWiFiCredentialsStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgDeviceLockStatusStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPRELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATEUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATERELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATESTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATEUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATERELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATESTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFOUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFORELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFOSTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATAUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATARELUPREG:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg;

      case midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATASTATUS:
         return OSAL_NEW midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_smartphoneintfifi messages

// common functions

tU16 midw_smartphoneintfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_SMARTPHONEINTFI_C_U16_SERVICE_ID;
}

tU16 midw_smartphoneintfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_smartphoneintfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_smartphoneintfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_smartphoneintfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_smartphoneintfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart::midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart()
 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEINFOLISTMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart::~midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   NumDevices = coRef.NumDevices;
   DeviceInfoList = coRef.DeviceInfoList;
}
midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumDevices = coRef.NumDevices;
   DeviceInfoList = coRef.DeviceInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
         DeviceInfoList[u32Idx].vDestroy();
   DeviceInfoList.clear();
   }
}

midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult()
:NumDevices(0)

 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEINFOLISTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::~midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceInfoList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NumDevices);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
      {
         DeviceInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NumDevices);
   (tVoid) (oOut << (tU32)DeviceInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NumDevices == roRef.NumDevices);
      bResult = bResult && (DeviceInfoList.size() == roRef.DeviceInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceInfoList.size()); ++u32Idx)
            bResult = bResult && (DeviceInfoList[u32Idx] == roRef.DeviceInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::midw_smartphoneintfi_tclMsgSelectDeviceMethodStart(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceConnectionReq = coRef.DeviceConnectionReq;
   DAPUsage = coRef.DAPUsage;
   CDBUsage = coRef.CDBUsage;
   DeviceCategory = coRef.DeviceCategory;
   SelectionType = coRef.SelectionType;
}
midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::operator=(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceConnectionReq = coRef.DeviceConnectionReq;
   DAPUsage = coRef.DAPUsage;
   CDBUsage = coRef.CDBUsage;
   DeviceCategory = coRef.DeviceCategory;
   SelectionType = coRef.SelectionType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::midw_smartphoneintfi_tclMsgSelectDeviceMethodStart()
:DeviceHandle(0)
,DeviceConnectionType()
,DeviceConnectionReq()
,DAPUsage()
,CDBUsage()
,DeviceCategory()
,SelectionType()
 {}

tS32 midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SELECTDEVICEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::~midw_smartphoneintfi_tclMsgSelectDeviceMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceConnectionType);
   (tVoid) (oIn >> DeviceConnectionReq);
   (tVoid) (oIn >> DAPUsage);
   (tVoid) (oIn >> CDBUsage);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> SelectionType);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceConnectionType);
   (tVoid) (oOut << DeviceConnectionReq);
   (tVoid) (oOut << DAPUsage);
   (tVoid) (oOut << CDBUsage);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << SelectionType);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSelectDeviceMethodStart::operator==(const midw_smartphoneintfi_tclMsgSelectDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceConnectionType == roRef.DeviceConnectionType);
   bResult = bResult && (DeviceConnectionReq == roRef.DeviceConnectionReq);
   bResult = bResult && (DAPUsage == roRef.DAPUsage);
   bResult = bResult && (CDBUsage == roRef.CDBUsage);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (SelectionType == roRef.SelectionType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::midw_smartphoneintfi_tclMsgSelectDeviceMethodResult(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceConnectionReq = coRef.DeviceConnectionReq;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   BTPairingRequired = coRef.BTPairingRequired;
   DeviceCategory = coRef.DeviceCategory;
}
midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::operator=(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceConnectionReq = coRef.DeviceConnectionReq;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   BTPairingRequired = coRef.BTPairingRequired;
   DeviceCategory = coRef.DeviceCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::midw_smartphoneintfi_tclMsgSelectDeviceMethodResult()
:DeviceHandle(0)
,DeviceConnectionType()
,DeviceConnectionReq()
,ResponseCode()
,ErrorCode()
,BTPairingRequired(0)
,DeviceCategory()
 {}

tS32 midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SELECTDEVICEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::~midw_smartphoneintfi_tclMsgSelectDeviceMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceConnectionType);
   (tVoid) (oIn >> DeviceConnectionReq);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   (tVoid) (oIn >> BTPairingRequired);
   (tVoid) (oIn >> DeviceCategory);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceConnectionType);
   (tVoid) (oOut << DeviceConnectionReq);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   (tVoid) (oOut << BTPairingRequired);
   (tVoid) (oOut << DeviceCategory);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSelectDeviceMethodResult::operator==(const midw_smartphoneintfi_tclMsgSelectDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceConnectionType == roRef.DeviceConnectionType);
   bResult = bResult && (DeviceConnectionReq == roRef.DeviceConnectionReq);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   bResult = bResult && (BTPairingRequired == roRef.BTPairingRequired);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgLaunchAppMethodStart::midw_smartphoneintfi_tclMsgLaunchAppMethodStart(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   AppHandle = coRef.AppHandle;
   DiPOAppType = coRef.DiPOAppType;
   TelephoneNumber = coRef.TelephoneNumber;
   EcnrSetting = coRef.EcnrSetting;
}
midw_smartphoneintfi_tclMsgLaunchAppMethodStart& midw_smartphoneintfi_tclMsgLaunchAppMethodStart::operator=(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   AppHandle = coRef.AppHandle;
   DiPOAppType = coRef.DiPOAppType;
   TelephoneNumber = coRef.TelephoneNumber;
   EcnrSetting = coRef.EcnrSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgLaunchAppMethodStart::vDestroy()
{
   TelephoneNumber.vDestroy();
}

midw_smartphoneintfi_tclMsgLaunchAppMethodStart::midw_smartphoneintfi_tclMsgLaunchAppMethodStart()
:DeviceHandle(0)
,DeviceCategory()
,AppHandle(0)
,DiPOAppType()
,TelephoneNumber()
,EcnrSetting()
 {}

tS32 midw_smartphoneintfi_tclMsgLaunchAppMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_LAUNCHAPPMETHODSTART;
}


midw_smartphoneintfi_tclMsgLaunchAppMethodStart::~midw_smartphoneintfi_tclMsgLaunchAppMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgLaunchAppMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+TelephoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgLaunchAppMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> DiPOAppType);
   (tVoid) (oIn >> TelephoneNumber);
   (tVoid) (oIn >> EcnrSetting);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgLaunchAppMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << DiPOAppType);
   (tVoid) (oOut << TelephoneNumber);
   (tVoid) (oOut << EcnrSetting);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgLaunchAppMethodStart::operator==(const midw_smartphoneintfi_tclMsgLaunchAppMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (DiPOAppType == roRef.DiPOAppType);
   bResult = bResult && (TelephoneNumber == roRef.TelephoneNumber);
   bResult = bResult && (EcnrSetting == roRef.EcnrSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgLaunchAppMethodResult::midw_smartphoneintfi_tclMsgLaunchAppMethodResult(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   DiPOAppType = coRef.DiPOAppType;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgLaunchAppMethodResult& midw_smartphoneintfi_tclMsgLaunchAppMethodResult::operator=(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   DiPOAppType = coRef.DiPOAppType;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgLaunchAppMethodResult::midw_smartphoneintfi_tclMsgLaunchAppMethodResult()
:DeviceHandle(0)
,AppHandle(0)
,DiPOAppType()
,ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgLaunchAppMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_LAUNCHAPPMETHODRESULT;
}


midw_smartphoneintfi_tclMsgLaunchAppMethodResult::~midw_smartphoneintfi_tclMsgLaunchAppMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgLaunchAppMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgLaunchAppMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> DiPOAppType);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgLaunchAppMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << DiPOAppType);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgLaunchAppMethodResult::operator==(const midw_smartphoneintfi_tclMsgLaunchAppMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (DiPOAppType == roRef.DiPOAppType);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgTerminateAppMethodStart::midw_smartphoneintfi_tclMsgTerminateAppMethodStart(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
}
midw_smartphoneintfi_tclMsgTerminateAppMethodStart& midw_smartphoneintfi_tclMsgTerminateAppMethodStart::operator=(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgTerminateAppMethodStart::midw_smartphoneintfi_tclMsgTerminateAppMethodStart()
:DeviceHandle(0)
,AppHandle(0)
 {}

tS32 midw_smartphoneintfi_tclMsgTerminateAppMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TERMINATEAPPMETHODSTART;
}


midw_smartphoneintfi_tclMsgTerminateAppMethodStart::~midw_smartphoneintfi_tclMsgTerminateAppMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgTerminateAppMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgTerminateAppMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgTerminateAppMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgTerminateAppMethodStart::operator==(const midw_smartphoneintfi_tclMsgTerminateAppMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgTerminateAppMethodResult::midw_smartphoneintfi_tclMsgTerminateAppMethodResult(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgTerminateAppMethodResult& midw_smartphoneintfi_tclMsgTerminateAppMethodResult::operator=(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgTerminateAppMethodResult::midw_smartphoneintfi_tclMsgTerminateAppMethodResult()
:DeviceHandle(0)
,AppHandle(0)
,ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgTerminateAppMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TERMINATEAPPMETHODRESULT;
}


midw_smartphoneintfi_tclMsgTerminateAppMethodResult::~midw_smartphoneintfi_tclMsgTerminateAppMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgTerminateAppMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgTerminateAppMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgTerminateAppMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgTerminateAppMethodResult::operator==(const midw_smartphoneintfi_tclMsgTerminateAppMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetAppListMethodStart::midw_smartphoneintfi_tclMsgGetAppListMethodStart(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
}
midw_smartphoneintfi_tclMsgGetAppListMethodStart& midw_smartphoneintfi_tclMsgGetAppListMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetAppListMethodStart::midw_smartphoneintfi_tclMsgGetAppListMethodStart()
:DeviceHandle(0)
 {}

tS32 midw_smartphoneintfi_tclMsgGetAppListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETAPPLISTMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetAppListMethodStart::~midw_smartphoneintfi_tclMsgGetAppListMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgGetAppListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetAppListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetAppListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetAppListMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetAppListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetAppListMethodResult::midw_smartphoneintfi_tclMsgGetAppListMethodResult(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   NumAppDetailsList = coRef.NumAppDetailsList;
   AppDetailsList = coRef.AppDetailsList;
}
midw_smartphoneintfi_tclMsgGetAppListMethodResult& midw_smartphoneintfi_tclMsgGetAppListMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   NumAppDetailsList = coRef.NumAppDetailsList;
   AppDetailsList = coRef.AppDetailsList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetAppListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AppDetailsList.size(); ++u32Idx)
         AppDetailsList[u32Idx].vDestroy();
   AppDetailsList.clear();
   }
}

midw_smartphoneintfi_tclMsgGetAppListMethodResult::midw_smartphoneintfi_tclMsgGetAppListMethodResult()
:DeviceHandle(0)
,NumAppDetailsList(0)

 {}

tS32 midw_smartphoneintfi_tclMsgGetAppListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETAPPLISTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetAppListMethodResult::~midw_smartphoneintfi_tclMsgGetAppListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetAppListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AppDetailsList.size(); ++u32ListIdx)
      u32DynamicSize += AppDetailsList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetAppListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> NumAppDetailsList);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AppDetailsList.size(); ++u32Idx)
      {
         AppDetailsList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AppDetailsList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AppDetailsList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetAppListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << NumAppDetailsList);
   (tVoid) (oOut << (tU32)AppDetailsList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AppDetailsList.size(); ++u32Idx)
         (tVoid) (oOut << AppDetailsList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetAppListMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetAppListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (NumAppDetailsList == roRef.NumAppDetailsList);
      bResult = bResult && (AppDetailsList.size() == roRef.AppDetailsList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AppDetailsList.size()); ++u32Idx)
            bResult = bResult && (AppDetailsList[u32Idx] == roRef.AppDetailsList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AppIconURL = coRef.AppIconURL;
}
midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AppIconURL = coRef.AppIconURL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::vDestroy()
{
   AppIconURL.vDestroy();
}

midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart()
:AppIconURL()
 {}

tS32 midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETAPPICONDATAMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::~midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AppIconURL.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AppIconURL);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AppIconURL);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AppIconURL == roRef.AppIconURL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   IconMimeType = coRef.IconMimeType;
   AppIconData = coRef.AppIconData;
}
midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IconMimeType = coRef.IconMimeType;
   AppIconData = coRef.AppIconData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::vDestroy()
{
   IconMimeType.vDestroy();
   {
   AppIconData.clear();
   }
}

midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult()
:IconMimeType()

 {}

tS32 midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETAPPICONDATAMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::~midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+IconMimeType.u32GetSize(u16MajorVersion)+ static_cast<tU32>(AppIconData.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IconMimeType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      AppIconData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AppIconData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IconMimeType);
   (tVoid) (oOut << (tU32)AppIconData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AppIconData.size(); ++u32Idx)
         (tVoid) (oOut << AppIconData[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IconMimeType == roRef.IconMimeType);
      bResult = bResult && (AppIconData.size() == roRef.AppIconData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AppIconData.size()); ++u32Idx)
            bResult = bResult && (AppIconData[u32Idx] == roRef.AppIconData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   IconAttributes = coRef.IconAttributes;
}
midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   IconAttributes = coRef.IconAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::vDestroy()
{
   IconAttributes.vDestroy(); 
}

midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart()
:DeviceHandle(0)
,AppHandle(0)
,IconAttributes()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETAPPICONATTRIBUTESMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::~midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+IconAttributes.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> IconAttributes);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << IconAttributes);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (IconAttributes == roRef.IconAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETAPPICONATTRIBUTESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::~midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   EnabledInfo = coRef.EnabledInfo;
}
midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   EnabledInfo = coRef.EnabledInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart()
:DeviceHandle(0)
,DeviceCategory()
,EnabledInfo()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICEUSAGEPREFERENCEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::~midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> EnabledInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << EnabledInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (EnabledInfo == roRef.EnabledInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult()
:DeviceHandle(0)
,ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICEUSAGEPREFERENCEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::~midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   NumNotificationEnableList = coRef.NumNotificationEnableList;
   NotificationEnableList = coRef.NotificationEnableList;
}
midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   NumNotificationEnableList = coRef.NumNotificationEnableList;
   NotificationEnableList = coRef.NotificationEnableList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationEnableList.size(); ++u32Idx)
         NotificationEnableList[u32Idx].vDestroy();
   NotificationEnableList.clear();
   }
}

midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart()
:DeviceHandle(0)
,NumNotificationEnableList(0)

 {}

tS32 midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETMLNOTIFICATIONENABLEDINFOMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::~midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+ static_cast<tU32>(NotificationEnableList.size()*5);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> NumNotificationEnableList);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NotificationEnableList.size(); ++u32Idx)
      {
         NotificationEnableList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NotificationEnableList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NotificationEnableList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << NumNotificationEnableList);
   (tVoid) (oOut << (tU32)NotificationEnableList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationEnableList.size(); ++u32Idx)
         (tVoid) (oOut << NotificationEnableList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (NumNotificationEnableList == roRef.NumNotificationEnableList);
      bResult = bResult && (NotificationEnableList.size() == roRef.NotificationEnableList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NotificationEnableList.size()); ++u32Idx)
            bResult = bResult && (NotificationEnableList[u32Idx] == roRef.NotificationEnableList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult()
:DeviceHandle(0)
,ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETMLNOTIFICATIONENABLEDINFOMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::~midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   NotificationID = coRef.NotificationID;
   NotificationActionID = coRef.NotificationActionID;
}
midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::operator=(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   NotificationID = coRef.NotificationID;
   NotificationActionID = coRef.NotificationActionID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart()
:DeviceHandle(0)
,AppHandle(0)
,NotificationID(0)
,NotificationActionID(0)
 {}

tS32 midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INVOKENOTIFICATIONACTIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::~midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> NotificationID);
   (tVoid) (oIn >> NotificationActionID);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << NotificationID);
   (tVoid) (oOut << NotificationActionID);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart::operator==(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (NotificationID == roRef.NotificationID);
   bResult = bResult && (NotificationActionID == roRef.NotificationActionID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::operator=(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INVOKENOTIFICATIONACTIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::~midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult::operator==(const midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
}
midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart()
:DeviceHandle(0)
 {}

tS32 midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETVIDEOSETTINGSMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::~midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   VideoAttributes = coRef.VideoAttributes;
}
midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   VideoAttributes = coRef.VideoAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult()
:DeviceHandle(0)
,VideoAttributes()
 {}

tS32 midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETVIDEOSETTINGSMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::~midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> VideoAttributes);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << VideoAttributes);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (VideoAttributes == roRef.VideoAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   OrientationMode = coRef.OrientationMode;
}
midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   OrientationMode = coRef.OrientationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart()
:DeviceHandle(0)
,OrientationMode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETORIENTATIONMODEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::~midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> OrientationMode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << OrientationMode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (OrientationMode == roRef.OrientationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETORIENTATIONMODEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::~midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ScreenAttributes = coRef.ScreenAttributes;
}
midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ScreenAttributes = coRef.ScreenAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart()
:ScreenAttributes()
 {}

tS32 midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETSCREENSIZEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::~midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ScreenAttributes);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ScreenAttributes);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ScreenAttributes == roRef.ScreenAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETSCREENSIZEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::~midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   BlockingMode = coRef.BlockingMode;
   VideoBlockingReason = coRef.VideoBlockingReason;
}
midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   BlockingMode = coRef.BlockingMode;
   VideoBlockingReason = coRef.VideoBlockingReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart()
:DeviceHandle(0)
,BlockingMode()
,VideoBlockingReason()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVIDEOBLOCKINGMODEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::~midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> BlockingMode);
   (tVoid) (oIn >> VideoBlockingReason);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << BlockingMode);
   (tVoid) (oOut << VideoBlockingReason);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (BlockingMode == roRef.BlockingMode);
   bResult = bResult && (VideoBlockingReason == roRef.VideoBlockingReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult()
:DeviceHandle(0)
,ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVIDEOBLOCKINGMODEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::~midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   GlobalMuteEnable = coRef.GlobalMuteEnable;
   MediaAudioBlockingEnable = coRef.MediaAudioBlockingEnable;
}
midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GlobalMuteEnable = coRef.GlobalMuteEnable;
   MediaAudioBlockingEnable = coRef.MediaAudioBlockingEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart()
:GlobalMuteEnable(0)
,MediaAudioBlockingEnable(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETAUDIOBLOCKINGMODEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::~midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GlobalMuteEnable);
   (tVoid) (oIn >> MediaAudioBlockingEnable);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GlobalMuteEnable);
   (tVoid) (oOut << MediaAudioBlockingEnable);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GlobalMuteEnable == roRef.GlobalMuteEnable);
   bResult = bResult && (MediaAudioBlockingEnable == roRef.MediaAudioBlockingEnable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETAUDIOBLOCKINGMODEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::~midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   VehicleConfiguration = coRef.VehicleConfiguration;
   SetConfiguration = coRef.SetConfiguration;
}
midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleConfiguration = coRef.VehicleConfiguration;
   SetConfiguration = coRef.SetConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart()
:VehicleConfiguration()
,SetConfiguration(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLECONFIGURATIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::~midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleConfiguration);
   (tVoid) (oIn >> SetConfiguration);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleConfiguration);
   (tVoid) (oOut << SetConfiguration);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleConfiguration == roRef.VehicleConfiguration);
   bResult = bResult && (SetConfiguration == roRef.SetConfiguration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLECONFIGURATIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::~midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::midw_smartphoneintfi_tclMsgSendTouchEventMethodStart(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   TouchData = coRef.TouchData;
}
midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::operator=(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   TouchData = coRef.TouchData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::vDestroy()
{
   TouchData.vDestroy(); 
}

midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::midw_smartphoneintfi_tclMsgSendTouchEventMethodStart()
:DeviceHandle(0)
,TouchData()
 {}

tS32 midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDTOUCHEVENTMETHODSTART;
}


midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::~midw_smartphoneintfi_tclMsgSendTouchEventMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+TouchData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> TouchData);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << TouchData);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendTouchEventMethodStart::operator==(const midw_smartphoneintfi_tclMsgSendTouchEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (TouchData == roRef.TouchData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::midw_smartphoneintfi_tclMsgSendTouchEventMethodResult(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::operator=(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::midw_smartphoneintfi_tclMsgSendTouchEventMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDTOUCHEVENTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::~midw_smartphoneintfi_tclMsgSendTouchEventMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendTouchEventMethodResult::operator==(const midw_smartphoneintfi_tclMsgSendTouchEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::midw_smartphoneintfi_tclMsgSendKeyEventMethodStart(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   KeyMode = coRef.KeyMode;
   KeyCode = coRef.KeyCode;
}
midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::operator=(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   KeyMode = coRef.KeyMode;
   KeyCode = coRef.KeyCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::midw_smartphoneintfi_tclMsgSendKeyEventMethodStart()
:DeviceHandle(0)
,KeyMode()
,KeyCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDKEYEVENTMETHODSTART;
}


midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::~midw_smartphoneintfi_tclMsgSendKeyEventMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> KeyMode);
   (tVoid) (oIn >> KeyCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << KeyMode);
   (tVoid) (oOut << KeyCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendKeyEventMethodStart::operator==(const midw_smartphoneintfi_tclMsgSendKeyEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (KeyMode == roRef.KeyMode);
   bResult = bResult && (KeyCode == roRef.KeyCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::midw_smartphoneintfi_tclMsgSendKeyEventMethodResult(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::operator=(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::midw_smartphoneintfi_tclMsgSendKeyEventMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDKEYEVENTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::~midw_smartphoneintfi_tclMsgSendKeyEventMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendKeyEventMethodResult::operator==(const midw_smartphoneintfi_tclMsgSendKeyEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ClientCapabilities = coRef.ClientCapabilities;
}
midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ClientCapabilities = coRef.ClientCapabilities;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart()
:ClientCapabilities()
 {}

tS32 midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTCAPABILITIESMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::~midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClientCapabilities);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClientCapabilities);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClientCapabilities == roRef.ClientCapabilities);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTCAPABILITIESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::~midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DisplayFlag = coRef.DisplayFlag;
   DisplayContext = coRef.DisplayContext;
}
midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::operator=(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DisplayFlag = coRef.DisplayFlag;
   DisplayContext = coRef.DisplayContext;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart()
:DeviceHandle(0)
,DisplayFlag(0)
,DisplayContext()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYDISPLAYCONTEXTMETHODSTART;
}


midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::~midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DisplayFlag);
   (tVoid) (oIn >> DisplayContext);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DisplayFlag);
   (tVoid) (oOut << DisplayContext);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart::operator==(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DisplayFlag == roRef.DisplayFlag);
   bResult = bResult && (DisplayContext == roRef.DisplayContext);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::operator=(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYDISPLAYCONTEXTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::~midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult::operator==(const midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
}
midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart()
:DeviceHandle(0)
,DeviceCategory()
 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEUSAGEPREFERENCEMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::~midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   EnabledInfo = coRef.EnabledInfo;
}
midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   EnabledInfo = coRef.EnabledInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult()
:DeviceHandle(0)
,DeviceCategory()
,EnabledInfo()
 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICEUSAGEPREFERENCEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::~midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> EnabledInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << EnabledInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (EnabledInfo == roRef.EnabledInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BTAddress = coRef.BTAddress;
}
midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BTAddress = coRef.BTAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::vDestroy()
{
   BTAddress.vDestroy();
}

midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart()
:BTAddress()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEBTADDRESSMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::~midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BTAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAddress);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAddress);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAddress == roRef.BTAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEBTADDRESSMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::~midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BluetoothDeviceHandle = coRef.BluetoothDeviceHandle;
   ProjectionDeviceHandle = coRef.ProjectionDeviceHandle;
   BTChangeInfo = coRef.BTChangeInfo;
}
midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::operator=(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BluetoothDeviceHandle = coRef.BluetoothDeviceHandle;
   ProjectionDeviceHandle = coRef.ProjectionDeviceHandle;
   BTChangeInfo = coRef.BTChangeInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart()
:BluetoothDeviceHandle(0)
,ProjectionDeviceHandle(0)
,BTChangeInfo()
 {}

tS32 midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INVOKEBLUETOOTHDEVICEACTIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::~midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BluetoothDeviceHandle);
   (tVoid) (oIn >> ProjectionDeviceHandle);
   (tVoid) (oIn >> BTChangeInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BluetoothDeviceHandle);
   (tVoid) (oOut << ProjectionDeviceHandle);
   (tVoid) (oOut << BTChangeInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart::operator==(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BluetoothDeviceHandle == roRef.BluetoothDeviceHandle);
   bResult = bResult && (ProjectionDeviceHandle == roRef.ProjectionDeviceHandle);
   bResult = bResult && (BTChangeInfo == roRef.BTChangeInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::operator=(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INVOKEBLUETOOTHDEVICEACTIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::~midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult::operator==(const midw_smartphoneintfi_tclMsgInvokeBluetoothDeviceActionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AudioFlag = coRef.AudioFlag;
   AudioContext = coRef.AudioContext;
}
midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::operator=(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AudioFlag = coRef.AudioFlag;
   AudioContext = coRef.AudioContext;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart()
:DeviceHandle(0)
,AudioFlag(0)
,AudioContext()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAUDIOCONTEXTMETHODSTART;
}


midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::~midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AudioFlag);
   (tVoid) (oIn >> AudioContext);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AudioFlag);
   (tVoid) (oOut << AudioContext);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart::operator==(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AudioFlag == roRef.AudioFlag);
   bResult = bResult && (AudioContext == roRef.AudioContext);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::operator=(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAUDIOCONTEXTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::~midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult::operator==(const midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AppStateSpeech = coRef.AppStateSpeech;
   AppStatePhone = coRef.AppStatePhone;
   AppStateNavigation = coRef.AppStateNavigation;
}
midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::operator=(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AppStateSpeech = coRef.AppStateSpeech;
   AppStatePhone = coRef.AppStatePhone;
   AppStateNavigation = coRef.AppStateNavigation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart()
:AppStateSpeech()
,AppStatePhone()
,AppStateNavigation()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAPPSTATEMETHODSTART;
}


midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::~midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AppStateSpeech);
   (tVoid) (oIn >> AppStatePhone);
   (tVoid) (oIn >> AppStateNavigation);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AppStateSpeech);
   (tVoid) (oOut << AppStatePhone);
   (tVoid) (oOut << AppStateNavigation);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart::operator==(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AppStateSpeech == roRef.AppStateSpeech);
   bResult = bResult && (AppStatePhone == roRef.AppStatePhone);
   bResult = bResult && (AppStateNavigation == roRef.AppStateNavigation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::operator=(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ACCESSORYAPPSTATEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::~midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult::operator==(const midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetRegionMethodStart::midw_smartphoneintfi_tclMsgSetRegionMethodStart(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   Region = coRef.Region;
}
midw_smartphoneintfi_tclMsgSetRegionMethodStart& midw_smartphoneintfi_tclMsgSetRegionMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Region = coRef.Region;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetRegionMethodStart::midw_smartphoneintfi_tclMsgSetRegionMethodStart()
:Region()
 {}

tS32 midw_smartphoneintfi_tclMsgSetRegionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETREGIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetRegionMethodStart::~midw_smartphoneintfi_tclMsgSetRegionMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetRegionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetRegionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Region);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetRegionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Region);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetRegionMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetRegionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Region == roRef.Region);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetRegionMethodResult::midw_smartphoneintfi_tclMsgSetRegionMethodResult(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetRegionMethodResult& midw_smartphoneintfi_tclMsgSetRegionMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetRegionMethodResult::midw_smartphoneintfi_tclMsgSetRegionMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetRegionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETREGIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetRegionMethodResult::~midw_smartphoneintfi_tclMsgSetRegionMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetRegionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetRegionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetRegionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetRegionMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetRegionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   USBSerialNumber = coRef.USBSerialNumber;
   DeviceCarplayCapability = coRef.DeviceCarplayCapability;
}
midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::operator=(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   USBSerialNumber = coRef.USBSerialNumber;
   DeviceCarplayCapability = coRef.DeviceCarplayCapability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::vDestroy()
{
   USBSerialNumber.vDestroy();
}

midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart()
:u8DeviceTag(0)
,USBSerialNumber()
,DeviceCarplayCapability(0)
 {}

tS32 midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIPOROLESWITCHREQUIREDMETHODSTART;
}


midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::~midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+USBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> USBSerialNumber);
   (tVoid) (oIn >> DeviceCarplayCapability);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << USBSerialNumber);
   (tVoid) (oOut << DeviceCarplayCapability);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart::operator==(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (USBSerialNumber == roRef.USBSerialNumber);
   bResult = bResult && (DeviceCarplayCapability == roRef.DeviceCarplayCapability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8DiPOSwitchReqResponse = coRef.e8DiPOSwitchReqResponse;
   USBSerialNumber = coRef.USBSerialNumber;
   rEAPAppInfo = coRef.rEAPAppInfo;
}
midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::operator=(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8DiPOSwitchReqResponse = coRef.e8DiPOSwitchReqResponse;
   USBSerialNumber = coRef.USBSerialNumber;
   rEAPAppInfo = coRef.rEAPAppInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::vDestroy()
{
   USBSerialNumber.vDestroy();
   rEAPAppInfo.vDestroy(); 
}

midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult()
:u8DeviceTag(0)
,e8DiPOSwitchReqResponse()
,USBSerialNumber()
,rEAPAppInfo()
 {}

tS32 midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIPOROLESWITCHREQUIREDMETHODRESULT;
}


midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::~midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+USBSerialNumber.u32GetSize(u16MajorVersion)+rEAPAppInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8DiPOSwitchReqResponse);
   (tVoid) (oIn >> USBSerialNumber);
   (tVoid) (oIn >> rEAPAppInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8DiPOSwitchReqResponse);
   (tVoid) (oOut << USBSerialNumber);
   (tVoid) (oOut << rEAPAppInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult::operator==(const midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8DiPOSwitchReqResponse == roRef.e8DiPOSwitchReqResponse);
   bResult = bResult && (USBSerialNumber == roRef.USBSerialNumber);
   bResult = bResult && (rEAPAppInfo == roRef.rEAPAppInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DisplayContextInfo = coRef.DisplayContextInfo;
   DisplayConstraintInfo = coRef.DisplayConstraintInfo;
   ContextResponsibility = coRef.ContextResponsibility;
}
midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DisplayContextInfo = coRef.DisplayContextInfo;
   DisplayConstraintInfo = coRef.DisplayConstraintInfo;
   ContextResponsibility = coRef.ContextResponsibility;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::vDestroy()
{
   DisplayContextInfo.vDestroy(); 
   DisplayConstraintInfo.vDestroy(); 
}

midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart()
:DeviceHandle(0)
,DisplayContextInfo()
,DisplayConstraintInfo()
,ContextResponsibility()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYDISPLAYCONTEXTMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::~midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+DisplayConstraintInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DisplayContextInfo);
   (tVoid) (oIn >> DisplayConstraintInfo);
   (tVoid) (oIn >> ContextResponsibility);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DisplayContextInfo);
   (tVoid) (oOut << DisplayConstraintInfo);
   (tVoid) (oOut << ContextResponsibility);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DisplayContextInfo == roRef.DisplayContextInfo);
   bResult = bResult && (DisplayConstraintInfo == roRef.DisplayConstraintInfo);
   bResult = bResult && (ContextResponsibility == roRef.ContextResponsibility);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYDISPLAYCONTEXTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::~midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   KeyIconURL = coRef.KeyIconURL;
}
midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   KeyIconURL = coRef.KeyIconURL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::vDestroy()
{
   KeyIconURL.vDestroy();
}

midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart()
:DeviceHandle(0)
,KeyIconURL()
 {}

tS32 midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETKEYICONDATAMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::~midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+KeyIconURL.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> KeyIconURL);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << KeyIconURL);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (KeyIconURL == roRef.KeyIconURL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   KeyIconData = coRef.KeyIconData;
}
midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   KeyIconData = coRef.KeyIconData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::vDestroy()
{
   {
   KeyIconData.clear();
   }
}

midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult()
:DeviceHandle(0)

 {}

tS32 midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETKEYICONDATAMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::~midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(KeyIconData.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      KeyIconData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> KeyIconData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << (tU32)KeyIconData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < KeyIconData.size(); ++u32Idx)
         (tVoid) (oOut << KeyIconData[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
      bResult = bResult && (KeyIconData.size() == roRef.KeyIconData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < KeyIconData.size()); ++u32Idx)
            bResult = bResult && (KeyIconData[u32Idx] == roRef.KeyIconData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DisplayAttributes = coRef.DisplayAttributes;
}
midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DisplayAttributes = coRef.DisplayAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::vDestroy()
{
   DisplayAttributes.vDestroy(); 
}

midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart()
:DisplayAttributes()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDISPLAYATTRIBUTESMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::~midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DisplayAttributes.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayAttributes);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayAttributes);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayAttributes == roRef.DisplayAttributes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDISPLAYATTRIBUTESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::~midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ControllerDeltaCounts = coRef.ControllerDeltaCounts;
}
midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::operator=(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ControllerDeltaCounts = coRef.ControllerDeltaCounts;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart()
:DeviceHandle(0)
,ControllerDeltaCounts(0)
 {}

tS32 midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ROTARYCONTROLLEREVENTMETHODSTART;
}


midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::~midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ControllerDeltaCounts);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ControllerDeltaCounts);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart::operator==(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ControllerDeltaCounts == roRef.ControllerDeltaCounts);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::operator=(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_ROTARYCONTROLLEREVENTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::~midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult::operator==(const midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AudioContextInfo = coRef.AudioContextInfo;
}
midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AudioContextInfo = coRef.AudioContextInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AudioContextInfo.size(); ++u32Idx)
         AudioContextInfo[u32Idx].vDestroy();
   AudioContextInfo.clear();
   }
}

midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart()
:DeviceHandle(0)

 {}

tS32 midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYAUDIOCONTEXTMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::~midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(AudioContextInfo.size()*2);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AudioContextInfo.size(); ++u32Idx)
      {
         AudioContextInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AudioContextInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AudioContextInfo[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << (tU32)AudioContextInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AudioContextInfo.size(); ++u32Idx)
         (tVoid) (oOut << AudioContextInfo[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
      bResult = bResult && (AudioContextInfo.size() == roRef.AudioContextInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AudioContextInfo.size()); ++u32Idx)
            bResult = bResult && (AudioContextInfo[u32Idx] == roRef.AudioContextInfo[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETACCESSORYAUDIOCONTEXTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::~midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ParkBrakeInfo = coRef.ParkBrakeInfo;
   GearInfo = coRef.GearInfo;
   VehicleState = coRef.VehicleState;
}
midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ParkBrakeInfo = coRef.ParkBrakeInfo;
   GearInfo = coRef.GearInfo;
   VehicleState = coRef.VehicleState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart()
:ParkBrakeInfo()
,GearInfo()
,VehicleState()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMOVEMENTSTATEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::~midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkBrakeInfo);
   (tVoid) (oIn >> GearInfo);
   (tVoid) (oIn >> VehicleState);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkBrakeInfo);
   (tVoid) (oOut << GearInfo);
   (tVoid) (oOut << VehicleState);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkBrakeInfo == roRef.ParkBrakeInfo);
   bResult = bResult && (GearInfo == roRef.GearInfo);
   bResult = bResult && (VehicleState == roRef.VehicleState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMOVEMENTSTATEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::~midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceCategory = coRef.DeviceCategory;
   ParkModeRestrictionInfo = coRef.ParkModeRestrictionInfo;
   DriveModeRestrictionInfo = coRef.DriveModeRestrictionInfo;
   GeneralRestrictionInfo = coRef.GeneralRestrictionInfo;
}
midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceCategory = coRef.DeviceCategory;
   ParkModeRestrictionInfo = coRef.ParkModeRestrictionInfo;
   DriveModeRestrictionInfo = coRef.DriveModeRestrictionInfo;
   GeneralRestrictionInfo = coRef.GeneralRestrictionInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart()
:DeviceCategory()
,ParkModeRestrictionInfo()
,DriveModeRestrictionInfo()
,GeneralRestrictionInfo(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETFEATURERESTRICTIONSMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::~midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> ParkModeRestrictionInfo);
   (tVoid) (oIn >> DriveModeRestrictionInfo);
   (tVoid) (oIn >> GeneralRestrictionInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << ParkModeRestrictionInfo);
   (tVoid) (oOut << DriveModeRestrictionInfo);
   (tVoid) (oOut << GeneralRestrictionInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (ParkModeRestrictionInfo == roRef.ParkModeRestrictionInfo);
   bResult = bResult && (DriveModeRestrictionInfo == roRef.DriveModeRestrictionInfo);
   bResult = bResult && (GeneralRestrictionInfo == roRef.GeneralRestrictionInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETFEATURERESTRICTIONSMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::~midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   VehicleSpeed = coRef.VehicleSpeed;
}
midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::operator=(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleSpeed = coRef.VehicleSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart()
:VehicleSpeed(0)
 {}

tS32 midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_VEHICLEMECHANICALSPEEDMETHODSTART;
}


midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::~midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleSpeed);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleSpeed);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart::operator==(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleSpeed == roRef.VehicleSpeed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::operator=(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_VEHICLEMECHANICALSPEEDMETHODRESULT;
}


midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::~midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult::operator==(const midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   VehicleMake = coRef.VehicleMake;
   VehicleModel = coRef.VehicleModel;
   VehicleModelYear = coRef.VehicleModelYear;
   VehicleHUSwVersion = coRef.VehicleHUSwVersion;
   VehicleHUHwVersion = coRef.VehicleHUHwVersion;
   VehicleHUMake = coRef.VehicleHUMake;
   VehicleHUModel = coRef.VehicleHUModel;
   VehicleHUSwBuild = coRef.VehicleHUSwBuild;
   DriverSideInfo = coRef.DriverSideInfo;
   isNativeNavSupported = coRef.isNativeNavSupported;
   OEMICONDetails = coRef.OEMICONDetails;
   isRotaryCtrlSupported = coRef.isRotaryCtrlSupported;
   FidelityType = coRef.FidelityType;
   SupportedSPITechnologiesInfo = coRef.SupportedSPITechnologiesInfo;
}
midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleMake = coRef.VehicleMake;
   VehicleModel = coRef.VehicleModel;
   VehicleModelYear = coRef.VehicleModelYear;
   VehicleHUSwVersion = coRef.VehicleHUSwVersion;
   VehicleHUHwVersion = coRef.VehicleHUHwVersion;
   VehicleHUMake = coRef.VehicleHUMake;
   VehicleHUModel = coRef.VehicleHUModel;
   VehicleHUSwBuild = coRef.VehicleHUSwBuild;
   DriverSideInfo = coRef.DriverSideInfo;
   isNativeNavSupported = coRef.isNativeNavSupported;
   OEMICONDetails = coRef.OEMICONDetails;
   isRotaryCtrlSupported = coRef.isRotaryCtrlSupported;
   FidelityType = coRef.FidelityType;
   SupportedSPITechnologiesInfo = coRef.SupportedSPITechnologiesInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::vDestroy()
{
   VehicleMake.vDestroy();
   VehicleModel.vDestroy();
   VehicleModelYear.vDestroy();
   VehicleHUSwVersion.vDestroy();
   VehicleHUHwVersion.vDestroy();
   VehicleHUMake.vDestroy();
   VehicleHUModel.vDestroy();
   VehicleHUSwBuild.vDestroy();
   OEMICONDetails.vDestroy(); 
}

midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart()
:VehicleMake()
,VehicleModel()
,VehicleModelYear()
,VehicleHUSwVersion()
,VehicleHUHwVersion()
,VehicleHUMake()
,VehicleHUModel()
,VehicleHUSwBuild()
,DriverSideInfo()
,isNativeNavSupported(0)
,OEMICONDetails()
,isRotaryCtrlSupported(0)
,FidelityType()
,SupportedSPITechnologiesInfo(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMANUFACTURERINFORMATIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::~midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+VehicleMake.u32GetSize(u16MajorVersion)+VehicleModel.u32GetSize(u16MajorVersion)+VehicleModelYear.u32GetSize(u16MajorVersion)+VehicleHUSwVersion.u32GetSize(u16MajorVersion)+VehicleHUHwVersion.u32GetSize(u16MajorVersion)+VehicleHUMake.u32GetSize(u16MajorVersion)+VehicleHUModel.u32GetSize(u16MajorVersion)+VehicleHUSwBuild.u32GetSize(u16MajorVersion)+OEMICONDetails.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleMake);
   (tVoid) (oIn >> VehicleModel);
   (tVoid) (oIn >> VehicleModelYear);
   (tVoid) (oIn >> VehicleHUSwVersion);
   (tVoid) (oIn >> VehicleHUHwVersion);
   (tVoid) (oIn >> VehicleHUMake);
   (tVoid) (oIn >> VehicleHUModel);
   (tVoid) (oIn >> VehicleHUSwBuild);
   (tVoid) (oIn >> DriverSideInfo);
   (tVoid) (oIn >> isNativeNavSupported);
   (tVoid) (oIn >> OEMICONDetails);
   (tVoid) (oIn >> isRotaryCtrlSupported);
   (tVoid) (oIn >> FidelityType);
   (tVoid) (oIn >> SupportedSPITechnologiesInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleMake);
   (tVoid) (oOut << VehicleModel);
   (tVoid) (oOut << VehicleModelYear);
   (tVoid) (oOut << VehicleHUSwVersion);
   (tVoid) (oOut << VehicleHUHwVersion);
   (tVoid) (oOut << VehicleHUMake);
   (tVoid) (oOut << VehicleHUModel);
   (tVoid) (oOut << VehicleHUSwBuild);
   (tVoid) (oOut << DriverSideInfo);
   (tVoid) (oOut << isNativeNavSupported);
   (tVoid) (oOut << OEMICONDetails);
   (tVoid) (oOut << isRotaryCtrlSupported);
   (tVoid) (oOut << FidelityType);
   (tVoid) (oOut << SupportedSPITechnologiesInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleMake == roRef.VehicleMake);
   bResult = bResult && (VehicleModel == roRef.VehicleModel);
   bResult = bResult && (VehicleModelYear == roRef.VehicleModelYear);
   bResult = bResult && (VehicleHUSwVersion == roRef.VehicleHUSwVersion);
   bResult = bResult && (VehicleHUHwVersion == roRef.VehicleHUHwVersion);
   bResult = bResult && (VehicleHUMake == roRef.VehicleHUMake);
   bResult = bResult && (VehicleHUModel == roRef.VehicleHUModel);
   bResult = bResult && (VehicleHUSwBuild == roRef.VehicleHUSwBuild);
   bResult = bResult && (DriverSideInfo == roRef.DriverSideInfo);
   bResult = bResult && (isNativeNavSupported == roRef.isNativeNavSupported);
   bResult = bResult && (OEMICONDetails == roRef.OEMICONDetails);
   bResult = bResult && (isRotaryCtrlSupported == roRef.isRotaryCtrlSupported);
   bResult = bResult && (FidelityType == roRef.FidelityType);
   bResult = bResult && (SupportedSPITechnologiesInfo == roRef.SupportedSPITechnologiesInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETVEHICLEMANUFACTURERINFORMATIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::~midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   OutsideTemperature = coRef.OutsideTemperature;
   ValidTemperature = coRef.ValidTemperature;
   BarometricPressure = coRef.BarometricPressure;
   ValidPressure = coRef.ValidPressure;
}
midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OutsideTemperature = coRef.OutsideTemperature;
   ValidTemperature = coRef.ValidTemperature;
   BarometricPressure = coRef.BarometricPressure;
   ValidPressure = coRef.ValidPressure;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart()
:OutsideTemperature(0)
,ValidTemperature(0)
,BarometricPressure(0)
,ValidPressure(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETENVIRONMENTDATAMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::~midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OutsideTemperature);
   (tVoid) (oIn >> ValidTemperature);
   (tVoid) (oIn >> BarometricPressure);
   (tVoid) (oIn >> ValidPressure);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OutsideTemperature);
   (tVoid) (oOut << ValidTemperature);
   (tVoid) (oOut << BarometricPressure);
   (tVoid) (oOut << ValidPressure);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OutsideTemperature == roRef.OutsideTemperature);
   bResult = bResult && (ValidTemperature == roRef.ValidTemperature);
   bResult = bResult && (BarometricPressure == roRef.BarometricPressure);
   bResult = bResult && (ValidPressure == roRef.ValidPressure);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETENVIRONMENTDATAMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::~midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetEnvironmentDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   sAlbumArt = coRef.sAlbumArt;
}
midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   sAlbumArt = coRef.sAlbumArt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::vDestroy()
{
   sAlbumArt.vDestroy();
}

midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart()
:DeviceHandle(0)
,sAlbumArt()
 {}

tS32 midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::~midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sAlbumArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> sAlbumArt);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << sAlbumArt);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   oImageData = coRef.oImageData;
}
midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oImageData = coRef.oImageData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::vDestroy()
{
   {
   oImageData.clear();
   }
}

midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult()

 {}

tS32 midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::~midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(oImageData.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      oImageData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oImageData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oImageData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oImageData.size(); ++u32Idx)
         (tVoid) (oOut << oImageData[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oImageData.size() == roRef.oImageData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oImageData.size()); ++u32Idx)
            bResult = bResult && (oImageData[u32Idx] == roRef.oImageData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   NumofPreferences = coRef.NumofPreferences;
   PreferenceOrderList = coRef.PreferenceOrderList;
   DeviceType = coRef.DeviceType;
}
midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   NumofPreferences = coRef.NumofPreferences;
   PreferenceOrderList = coRef.PreferenceOrderList;
   DeviceType = coRef.DeviceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::vDestroy()
{
   {
   PreferenceOrderList.clear();
   }
}

midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart()
:DeviceHandle(0)
,NumofPreferences(0)

,DeviceType()
 {}

tS32 midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETTECHNOLOGYPREFERENCEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::~midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11+ static_cast<tU32>(PreferenceOrderList.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> NumofPreferences);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PreferenceOrderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PreferenceOrderList[u32Idx]);
      }
   }
   (tVoid) (oIn >> DeviceType);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << NumofPreferences);
   (tVoid) (oOut << (tU32)PreferenceOrderList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PreferenceOrderList.size(); ++u32Idx)
         (tVoid) (oOut << PreferenceOrderList[u32Idx]);
   }
   (tVoid) (oOut << DeviceType);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (NumofPreferences == roRef.NumofPreferences);
      bResult = bResult && (PreferenceOrderList.size() == roRef.PreferenceOrderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PreferenceOrderList.size()); ++u32Idx)
            bResult = bResult && (PreferenceOrderList[u32Idx] == roRef.PreferenceOrderList[u32Idx]);
      }
   bResult = bResult && (DeviceType == roRef.DeviceType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETTECHNOLOGYPREFERENCEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::~midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceType = coRef.DeviceType;
}
midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceType = coRef.DeviceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart()
:DeviceHandle(0)
,DeviceType()
 {}

tS32 midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETTECHNOLOGYPREFERENCEMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::~midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceType);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceType);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceType == roRef.DeviceType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   NumofPreferences = coRef.NumofPreferences;
   PreferenceOrderList = coRef.PreferenceOrderList;
}
midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumofPreferences = coRef.NumofPreferences;
   PreferenceOrderList = coRef.PreferenceOrderList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::vDestroy()
{
   {
   PreferenceOrderList.clear();
   }
}

midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult()
:NumofPreferences(0)

 {}

tS32 midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETTECHNOLOGYPREFERENCEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::~midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(PreferenceOrderList.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NumofPreferences);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PreferenceOrderList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PreferenceOrderList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NumofPreferences);
   (tVoid) (oOut << (tU32)PreferenceOrderList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PreferenceOrderList.size(); ++u32Idx)
         (tVoid) (oOut << PreferenceOrderList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NumofPreferences == roRef.NumofPreferences);
      bResult = bResult && (PreferenceOrderList.size() == roRef.PreferenceOrderList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PreferenceOrderList.size()); ++u32Idx)
            bResult = bResult && (PreferenceOrderList[u32Idx] == roRef.PreferenceOrderList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceSelectionMode = coRef.DeviceSelectionMode;
}
midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceSelectionMode = coRef.DeviceSelectionMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart()
:DeviceSelectionMode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICESELECTIONMODEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::~midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceSelectionMode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceSelectionMode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceSelectionMode == roRef.DeviceSelectionMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETDEVICESELECTIONMODEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::~midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart::midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart()
 {}

tS32 midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETSPIVERSIONINFOMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart::~midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   SPIVersion = coRef.SPIVersion;
}
midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SPIVersion = coRef.SPIVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::vDestroy()
{
   SPIVersion.vDestroy();
}

midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult()
:SPIVersion()
 {}

tS32 midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETSPIVERSIONINFOMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::~midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SPIVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SPIVersion);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SPIVersion);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SPIVersion == roRef.SPIVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BTMACAddress = coRef.BTMACAddress;
   Technology = coRef.Technology;
   isKnownDevice = coRef.isKnownDevice;
}
midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::operator=(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BTMACAddress = coRef.BTMACAddress;
   Technology = coRef.Technology;
   isKnownDevice = coRef.isKnownDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::vDestroy()
{
   BTMACAddress.vDestroy();
}

midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart()
:BTMACAddress()
,Technology()
,isKnownDevice(0)
 {}

tS32 midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INITIATEWIRELESSDISCOVERYMETHODSTART;
}


midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::~midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+BTMACAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTMACAddress);
   (tVoid) (oIn >> Technology);
   (tVoid) (oIn >> isKnownDevice);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTMACAddress);
   (tVoid) (oOut << Technology);
   (tVoid) (oOut << isKnownDevice);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart::operator==(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTMACAddress == roRef.BTMACAddress);
   bResult = bResult && (Technology == roRef.Technology);
   bResult = bResult && (isKnownDevice == roRef.isKnownDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::operator=(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_INITIATEWIRELESSDISCOVERYMETHODRESULT;
}


midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::~midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult::operator==(const midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceList = coRef.DeviceList;
}
midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::operator=(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::vDestroy()
{
   {
   DeviceList.clear();
   }
}

midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart()

 {}

tS32 midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DELETEDEVICEMETHODSTART;
}


midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::~midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DeviceList.size()*4);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart::operator==(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceList = coRef.DeviceList;
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::operator=(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceList = coRef.DeviceList;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::vDestroy()
{
   {
   DeviceList.clear();
   }
}

midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult()

:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DELETEDEVICEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::~midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(DeviceList.size()*4);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult::operator==(const midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BTMACAddress = coRef.BTMACAddress;
}
midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BTMACAddress = coRef.BTMACAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::vDestroy()
{
   BTMACAddress.vDestroy();
}

midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart()
:BTMACAddress()
 {}

tS32 midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETWIFICREDENTIALSMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::~midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BTMACAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTMACAddress);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTMACAddress);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTMACAddress == roRef.BTMACAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BTMACAddress = coRef.BTMACAddress;
   ErrorCode = coRef.ErrorCode;
   AccessoryWiFiAPCredentials = coRef.AccessoryWiFiAPCredentials;
}
midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BTMACAddress = coRef.BTMACAddress;
   ErrorCode = coRef.ErrorCode;
   AccessoryWiFiAPCredentials = coRef.AccessoryWiFiAPCredentials;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::vDestroy()
{
   BTMACAddress.vDestroy();
   AccessoryWiFiAPCredentials.vDestroy(); 
}

midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult()
:BTMACAddress()
,ErrorCode()
,AccessoryWiFiAPCredentials()
 {}

tS32 midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETWIFICREDENTIALSMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::~midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BTMACAddress.u32GetSize(u16MajorVersion)+AccessoryWiFiAPCredentials.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTMACAddress);
   (tVoid) (oIn >> ErrorCode);
   (tVoid) (oIn >> AccessoryWiFiAPCredentials);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTMACAddress);
   (tVoid) (oOut << ErrorCode);
   (tVoid) (oOut << AccessoryWiFiAPCredentials);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTMACAddress == roRef.BTMACAddress);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   bResult = bResult && (AccessoryWiFiAPCredentials == roRef.AccessoryWiFiAPCredentials);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::midw_smartphoneintfi_tclMsgSetETCStatusMethodStart(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ETCStatus = coRef.ETCStatus;
}
midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ETCStatus = coRef.ETCStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::midw_smartphoneintfi_tclMsgSetETCStatusMethodStart()
:ETCStatus(0)
 {}

tS32 midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETETCSTATUSMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::~midw_smartphoneintfi_tclMsgSetETCStatusMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ETCStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ETCStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetETCStatusMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetETCStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ETCStatus == roRef.ETCStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::midw_smartphoneintfi_tclMsgSetETCStatusMethodResult(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::midw_smartphoneintfi_tclMsgSetETCStatusMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETETCSTATUSMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::~midw_smartphoneintfi_tclMsgSetETCStatusMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetETCStatusMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetETCStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DistanceToEmptyTank = coRef.DistanceToEmptyTank;
}
midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::operator=(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DistanceToEmptyTank = coRef.DistanceToEmptyTank;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart()
:DistanceToEmptyTank(0)
 {}

tS32 midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DISTANCETOEMPTYTANKMETHODSTART;
}


midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::~midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DistanceToEmptyTank);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DistanceToEmptyTank);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart::operator==(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DistanceToEmptyTank == roRef.DistanceToEmptyTank);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::operator=(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DISTANCETOEMPTYTANKMETHODRESULT;
}


midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::~midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult::operator==(const midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   LanguageSetting = coRef.LanguageSetting;
}
midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::operator=(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageSetting = coRef.LanguageSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart()
:LanguageSetting()
 {}

tS32 midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDLANGUAGESETTINGMETHODSTART;
}


midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::~midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageSetting);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageSetting);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart::operator==(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageSetting == roRef.LanguageSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::operator=(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDLANGUAGESETTINGMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::~midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult::operator==(const midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   VehiclePowerModeState = coRef.VehiclePowerModeState;
}
midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::operator=(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehiclePowerModeState = coRef.VehiclePowerModeState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart()
:VehiclePowerModeState()
 {}

tS32 midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDVEHICLEPOWERMODESTATEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::~midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehiclePowerModeState);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehiclePowerModeState);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart::operator==(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehiclePowerModeState == roRef.VehiclePowerModeState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::operator=(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDVEHICLEPOWERMODESTATEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::~midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult::operator==(const midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AmbientColourData = coRef.AmbientColourData;
}
midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::operator=(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AmbientColourData = coRef.AmbientColourData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart()
:AmbientColourData()
 {}

tS32 midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDAMBIENTCOLOURMETHODSTART;
}


midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::~midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmbientColourData);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmbientColourData);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart::operator==(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmbientColourData == roRef.AmbientColourData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
}
midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::operator=(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult()
:ResponseCode()
,ErrorCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SENDAMBIENTCOLOURMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::~midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult::operator==(const midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   RouteGuidanceDisplayComponents = coRef.RouteGuidanceDisplayComponents;
}
midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::operator=(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RouteGuidanceDisplayComponents = coRef.RouteGuidanceDisplayComponents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RouteGuidanceDisplayComponents.size(); ++u32Idx)
         RouteGuidanceDisplayComponents[u32Idx].vDestroy();
   RouteGuidanceDisplayComponents.clear();
   }
}

midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart()

 {}

tS32 midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_REGISTERROUTEGUIDANCEDISPLAYCONFIGURATIONMETHODSTART;
}


midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::~midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RouteGuidanceDisplayComponents.size(); ++u32ListIdx)
      u32DynamicSize += RouteGuidanceDisplayComponents[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RouteGuidanceDisplayComponents.size(); ++u32Idx)
      {
         RouteGuidanceDisplayComponents[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RouteGuidanceDisplayComponents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RouteGuidanceDisplayComponents[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RouteGuidanceDisplayComponents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RouteGuidanceDisplayComponents.size(); ++u32Idx)
         (tVoid) (oOut << RouteGuidanceDisplayComponents[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart::operator==(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RouteGuidanceDisplayComponents.size() == roRef.RouteGuidanceDisplayComponents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RouteGuidanceDisplayComponents.size()); ++u32Idx)
            bResult = bResult && (RouteGuidanceDisplayComponents[u32Idx] == roRef.RouteGuidanceDisplayComponents[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::operator=(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_REGISTERROUTEGUIDANCEDISPLAYCONFIGURATIONMETHODRESULT;
}


midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::~midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult::operator==(const midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   RoutGuidanceComponentID = coRef.RoutGuidanceComponentID;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   NeedAutoStartStopTBTUpdates = coRef.NeedAutoStartStopTBTUpdates;
}
midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::operator=(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RoutGuidanceComponentID = coRef.RoutGuidanceComponentID;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   NeedAutoStartStopTBTUpdates = coRef.NeedAutoStartStopTBTUpdates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::vDestroy()
{
   {
   RoutGuidanceComponentID.clear();
   }
}

midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart()

:SourceName(0)
,SourceSupportsRouteGuidance(0)
,NeedAutoStartStopTBTUpdates(0)
 {}

tS32 midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_STARTROUTEGUIDANCEUPDATESMETHODSTART;
}


midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::~midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+ static_cast<tU32>(RoutGuidanceComponentID.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      RoutGuidanceComponentID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RoutGuidanceComponentID[u32Idx]);
      }
   }
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   (tVoid) (oIn >> NeedAutoStartStopTBTUpdates);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RoutGuidanceComponentID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RoutGuidanceComponentID.size(); ++u32Idx)
         (tVoid) (oOut << RoutGuidanceComponentID[u32Idx]);
   }
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   (tVoid) (oOut << NeedAutoStartStopTBTUpdates);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart::operator==(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RoutGuidanceComponentID.size() == roRef.RoutGuidanceComponentID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoutGuidanceComponentID.size()); ++u32Idx)
            bResult = bResult && (RoutGuidanceComponentID[u32Idx] == roRef.RoutGuidanceComponentID[u32Idx]);
      }
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   bResult = bResult && (NeedAutoStartStopTBTUpdates == roRef.NeedAutoStartStopTBTUpdates);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::operator=(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_STARTROUTEGUIDANCEUPDATESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::~midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult::operator==(const midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   RoutGuidanceComponentID = coRef.RoutGuidanceComponentID;
}
midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::operator=(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RoutGuidanceComponentID = coRef.RoutGuidanceComponentID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::vDestroy()
{
   {
   RoutGuidanceComponentID.clear();
   }
}

midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart()

 {}

tS32 midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_STOPROUTEGUIDANCEUPDATESMETHODSTART;
}


midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::~midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(RoutGuidanceComponentID.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      RoutGuidanceComponentID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RoutGuidanceComponentID[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RoutGuidanceComponentID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RoutGuidanceComponentID.size(); ++u32Idx)
         (tVoid) (oOut << RoutGuidanceComponentID[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart::operator==(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RoutGuidanceComponentID.size() == roRef.RoutGuidanceComponentID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoutGuidanceComponentID.size()); ++u32Idx)
            bResult = bResult && (RoutGuidanceComponentID[u32Idx] == roRef.RoutGuidanceComponentID[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::operator=(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_STOPROUTEGUIDANCEUPDATESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::~midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult::operator==(const midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::midw_smartphoneintfi_tclMsgGetDeviceListMethodStart(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
}
midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::operator=(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::midw_smartphoneintfi_tclMsgGetDeviceListMethodStart()
:DeviceHandle(0)
 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICELISTMETHODSTART;
}


midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::~midw_smartphoneintfi_tclMsgGetDeviceListMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetDeviceListMethodStart::operator==(const midw_smartphoneintfi_tclMsgGetDeviceListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::midw_smartphoneintfi_tclMsgGetDeviceListMethodResult(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   NumDevices = coRef.NumDevices;
   DeviceInfoList = coRef.DeviceInfoList;
}
midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::operator=(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NumDevices = coRef.NumDevices;
   DeviceInfoList = coRef.DeviceInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
         DeviceInfoList[u32Idx].vDestroy();
   DeviceInfoList.clear();
   }
}

midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::midw_smartphoneintfi_tclMsgGetDeviceListMethodResult()
:NumDevices(0)

 {}

tS32 midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_GETDEVICELISTMETHODRESULT;
}


midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::~midw_smartphoneintfi_tclMsgGetDeviceListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceInfoList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NumDevices);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
      {
         DeviceInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NumDevices);
   (tVoid) (oOut << (tU32)DeviceInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceInfoList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgGetDeviceListMethodResult::operator==(const midw_smartphoneintfi_tclMsgGetDeviceListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NumDevices == roRef.NumDevices);
      bResult = bResult && (DeviceInfoList.size() == roRef.DeviceInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceInfoList.size()); ++u32Idx)
            bResult = bResult && (DeviceInfoList[u32Idx] == roRef.DeviceInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetClientStateMethodStart::midw_smartphoneintfi_tclMsgSetClientStateMethodStart(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ClientState = coRef.ClientState;
}
midw_smartphoneintfi_tclMsgSetClientStateMethodStart& midw_smartphoneintfi_tclMsgSetClientStateMethodStart::operator=(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ClientState = coRef.ClientState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetClientStateMethodStart::midw_smartphoneintfi_tclMsgSetClientStateMethodStart()
:ClientState()
 {}

tS32 midw_smartphoneintfi_tclMsgSetClientStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTSTATEMETHODSTART;
}


midw_smartphoneintfi_tclMsgSetClientStateMethodStart::~midw_smartphoneintfi_tclMsgSetClientStateMethodStart()
{}

tU32 midw_smartphoneintfi_tclMsgSetClientStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetClientStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClientState);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetClientStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClientState);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetClientStateMethodStart::operator==(const midw_smartphoneintfi_tclMsgSetClientStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClientState == roRef.ClientState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSetClientStateMethodResult::midw_smartphoneintfi_tclMsgSetClientStateMethodResult(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
}
midw_smartphoneintfi_tclMsgSetClientStateMethodResult& midw_smartphoneintfi_tclMsgSetClientStateMethodResult::operator=(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSetClientStateMethodResult::midw_smartphoneintfi_tclMsgSetClientStateMethodResult()
:ResponseCode()
 {}

tS32 midw_smartphoneintfi_tclMsgSetClientStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SETCLIENTSTATEMETHODRESULT;
}


midw_smartphoneintfi_tclMsgSetClientStateMethodResult::~midw_smartphoneintfi_tclMsgSetClientStateMethodResult()
{}

tU32 midw_smartphoneintfi_tclMsgSetClientStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSetClientStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSetClientStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSetClientStateMethodResult::operator==(const midw_smartphoneintfi_tclMsgSetClientStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   SupportedKeys = coRef.SupportedKeys;
}
midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::operator=(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SupportedKeys = coRef.SupportedKeys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedKeys.size(); ++u32Idx)
         SupportedKeys[u32Idx].vDestroy();
   SupportedKeys.clear();
   }
}

midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart()

 {}

tS32 midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_REGISTERKEYCODESMETHODSTART;
}


midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::~midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SupportedKeys.size(); ++u32ListIdx)
      u32DynamicSize += SupportedKeys[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedKeys.size(); ++u32Idx)
      {
         SupportedKeys[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SupportedKeys.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SupportedKeys[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SupportedKeys.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedKeys.size(); ++u32Idx)
         (tVoid) (oOut << SupportedKeys[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart::operator==(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SupportedKeys.size() == roRef.SupportedKeys.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedKeys.size()); ++u32Idx)
            bResult = bResult && (SupportedKeys[u32Idx] == roRef.SupportedKeys[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   ResponseCode = coRef.ResponseCode;
   UnSupportedKeys = coRef.UnSupportedKeys;
}
midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::operator=(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResponseCode = coRef.ResponseCode;
   UnSupportedKeys = coRef.UnSupportedKeys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UnSupportedKeys.size(); ++u32Idx)
         UnSupportedKeys[u32Idx].vDestroy();
   UnSupportedKeys.clear();
   }
}

midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult()
:ResponseCode()

 {}

tS32 midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_REGISTERKEYCODESMETHODRESULT;
}


midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::~midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UnSupportedKeys.size(); ++u32ListIdx)
      u32DynamicSize += UnSupportedKeys[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResponseCode);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UnSupportedKeys.size(); ++u32Idx)
      {
         UnSupportedKeys[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      UnSupportedKeys.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> UnSupportedKeys[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResponseCode);
   (tVoid) (oOut << (tU32)UnSupportedKeys.size());
   {
      for (tU32 u32Idx = 0; u32Idx < UnSupportedKeys.size(); ++u32Idx)
         (tVoid) (oOut << UnSupportedKeys[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult::operator==(const midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResponseCode == roRef.ResponseCode);
      bResult = bResult && (UnSupportedKeys.size() == roRef.UnSupportedKeys.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UnSupportedKeys.size()); ++u32Idx)
            bResult = bResult && (UnSupportedKeys[u32Idx] == roRef.UnSupportedKeys[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg::midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg::~midw_smartphoneintfi_tclMsgDeviceStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgDeviceStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceStatus = coRef.DeviceStatus;
}
midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DeviceStatus = coRef.DeviceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus()
:DeviceHandle(0)
,DeviceConnectionType()
,DeviceStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::~midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceConnectionType);
   (tVoid) (oIn >> DeviceStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceConnectionType);
   (tVoid) (oOut << DeviceStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceConnectionType == roRef.DeviceConnectionType);
   bResult = bResult && (DeviceStatus == roRef.DeviceStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgAppStatusInfoUpReg::midw_smartphoneintfi_tclMsgAppStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAppStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgAppStatusInfoUpReg::~midw_smartphoneintfi_tclMsgAppStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgAppStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAppStatusInfoStatus::midw_smartphoneintfi_tclMsgAppStatusInfoStatus(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   AppStatus = coRef.AppStatus;
}
midw_smartphoneintfi_tclMsgAppStatusInfoStatus& midw_smartphoneintfi_tclMsgAppStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   AppStatus = coRef.AppStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgAppStatusInfoStatus::midw_smartphoneintfi_tclMsgAppStatusInfoStatus()
:DeviceHandle(0)
,DeviceConnectionType()
,AppStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgAppStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPSTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgAppStatusInfoStatus::~midw_smartphoneintfi_tclMsgAppStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgAppStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAppStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceConnectionType);
   (tVoid) (oIn >> AppStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAppStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceConnectionType);
   (tVoid) (oOut << AppStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAppStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgAppStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceConnectionType == roRef.DeviceConnectionType);
   bResult = bResult && (AppStatus == roRef.AppStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg::midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg::~midw_smartphoneintfi_tclMsgDAPStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgDAPStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::midw_smartphoneintfi_tclMsgDAPStatusInfoStatus(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DAPStatus = coRef.DAPStatus;
}
midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceConnectionType = coRef.DeviceConnectionType;
   DAPStatus = coRef.DAPStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::midw_smartphoneintfi_tclMsgDAPStatusInfoStatus()
:DeviceHandle(0)
,DeviceConnectionType()
,DAPStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DAPSTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::~midw_smartphoneintfi_tclMsgDAPStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceConnectionType);
   (tVoid) (oIn >> DAPStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceConnectionType);
   (tVoid) (oOut << DAPStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDAPStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgDAPStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceConnectionType == roRef.DeviceConnectionType);
   bResult = bResult && (DAPStatus == roRef.DAPStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgNotificationInfoUpReg::midw_smartphoneintfi_tclMsgNotificationInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNotificationInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFOUPREG;
}


midw_smartphoneintfi_tclMsgNotificationInfoUpReg::~midw_smartphoneintfi_tclMsgNotificationInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg::midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFORELUPREG;
}


midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg::~midw_smartphoneintfi_tclMsgNotificationInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgNotificationInfoStatus::midw_smartphoneintfi_tclMsgNotificationInfoStatus(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   NotificationData = coRef.NotificationData;
}
midw_smartphoneintfi_tclMsgNotificationInfoStatus& midw_smartphoneintfi_tclMsgNotificationInfoStatus::operator=(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AppHandle = coRef.AppHandle;
   NotificationData = coRef.NotificationData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgNotificationInfoStatus::vDestroy()
{
   NotificationData.vDestroy(); 
}

midw_smartphoneintfi_tclMsgNotificationInfoStatus::midw_smartphoneintfi_tclMsgNotificationInfoStatus()
:DeviceHandle(0)
,AppHandle(0)
,NotificationData()
 {}

tS32 midw_smartphoneintfi_tclMsgNotificationInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NOTIFICATIONINFOSTATUS;
}


midw_smartphoneintfi_tclMsgNotificationInfoStatus::~midw_smartphoneintfi_tclMsgNotificationInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgNotificationInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+NotificationData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgNotificationInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AppHandle);
   (tVoid) (oIn >> NotificationData);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgNotificationInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AppHandle);
   (tVoid) (oOut << NotificationData);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgNotificationInfoStatus::operator==(const midw_smartphoneintfi_tclMsgNotificationInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AppHandle == roRef.AppHandle);
   bResult = bResult && (NotificationData == roRef.NotificationData);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg::midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATAUPREG;
}


midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg::~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg::midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATARELUPREG;
}


midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg::~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   MetaDataValid = coRef.MetaDataValid;
   ApplicationMediaMetaData = coRef.ApplicationMediaMetaData;
}
midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::operator=(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   MetaDataValid = coRef.MetaDataValid;
   ApplicationMediaMetaData = coRef.ApplicationMediaMetaData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::vDestroy()
{
   ApplicationMediaMetaData.vDestroy(); 
}

midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus()
:DeviceHandle(0)
,MetaDataValid(0)
,ApplicationMediaMetaData()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONMEDIAMETADATASTATUS;
}


midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::~midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+ApplicationMediaMetaData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> MetaDataValid);
   (tVoid) (oIn >> ApplicationMediaMetaData);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << MetaDataValid);
   (tVoid) (oOut << ApplicationMediaMetaData);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus::operator==(const midw_smartphoneintfi_tclMsgApplicationMediaMetaDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (MetaDataValid == roRef.MetaDataValid);
   bResult = bResult && (ApplicationMediaMetaData == roRef.ApplicationMediaMetaData);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg::midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTUPREG;
}


midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg::~midw_smartphoneintfi_tclMsgDeviceDisplayContextUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg::midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTRELUPREG;
}


midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg::~midw_smartphoneintfi_tclMsgDeviceDisplayContextRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DisplayFlag = coRef.DisplayFlag;
   DisplayContextReason = coRef.DisplayContextReason;
   DisplayPermanentEntity = coRef.DisplayPermanentEntity;
}
midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::operator=(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DisplayFlag = coRef.DisplayFlag;
   DisplayContextReason = coRef.DisplayContextReason;
   DisplayPermanentEntity = coRef.DisplayPermanentEntity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus()
:DeviceHandle(0)
,DisplayFlag(0)
,DisplayContextReason()
,DisplayPermanentEntity()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEDISPLAYCONTEXTSTATUS;
}


midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::~midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DisplayFlag);
   (tVoid) (oIn >> DisplayContextReason);
   (tVoid) (oIn >> DisplayPermanentEntity);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DisplayFlag);
   (tVoid) (oOut << DisplayContextReason);
   (tVoid) (oOut << DisplayPermanentEntity);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus::operator==(const midw_smartphoneintfi_tclMsgDeviceDisplayContextStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DisplayFlag == roRef.DisplayFlag);
   bResult = bResult && (DisplayContextReason == roRef.DisplayContextReason);
   bResult = bResult && (DisplayPermanentEntity == roRef.DisplayPermanentEntity);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg::midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATAUPREG;
}


midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg::~midw_smartphoneintfi_tclMsgApplicationPhoneDataUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg::midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATARELUPREG;
}


midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg::~midw_smartphoneintfi_tclMsgApplicationPhoneDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   PhoneDataValid = coRef.PhoneDataValid;
   PhoneCallMetadata = coRef.PhoneCallMetadata;
   SignalStrength = coRef.SignalStrength;
   RegistrationStatus = coRef.RegistrationStatus;
   AirPlaneModeStatus = coRef.AirPlaneModeStatus;
   Mute = coRef.Mute;
   CarrierName = coRef.CarrierName;
   BatteryChargeLevel = coRef.BatteryChargeLevel;
   BatteryChargingState = coRef.BatteryChargingState;
}
midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::operator=(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   PhoneDataValid = coRef.PhoneDataValid;
   PhoneCallMetadata = coRef.PhoneCallMetadata;
   SignalStrength = coRef.SignalStrength;
   RegistrationStatus = coRef.RegistrationStatus;
   AirPlaneModeStatus = coRef.AirPlaneModeStatus;
   Mute = coRef.Mute;
   CarrierName = coRef.CarrierName;
   BatteryChargeLevel = coRef.BatteryChargeLevel;
   BatteryChargingState = coRef.BatteryChargingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneCallMetadata.size(); ++u32Idx)
         PhoneCallMetadata[u32Idx].vDestroy();
   PhoneCallMetadata.clear();
   }
   CarrierName.vDestroy();
}

midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus()
:DeviceHandle(0)
,PhoneDataValid(0)

,SignalStrength()
,RegistrationStatus()
,AirPlaneModeStatus()
,Mute()
,CarrierName()
,BatteryChargeLevel(0)
,BatteryChargingState()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONEDATASTATUS;
}


midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::~midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhoneCallMetadata.size(); ++u32ListIdx)
      u32DynamicSize += PhoneCallMetadata[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+15+CarrierName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> PhoneDataValid);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhoneCallMetadata.size(); ++u32Idx)
      {
         PhoneCallMetadata[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhoneCallMetadata.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhoneCallMetadata[u32Idx]);
      }
   }
   (tVoid) (oIn >> SignalStrength);
   (tVoid) (oIn >> RegistrationStatus);
   (tVoid) (oIn >> AirPlaneModeStatus);
   (tVoid) (oIn >> Mute);
   (tVoid) (oIn >> CarrierName);
   (tVoid) (oIn >> BatteryChargeLevel);
   (tVoid) (oIn >> BatteryChargingState);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << PhoneDataValid);
   (tVoid) (oOut << (tU32)PhoneCallMetadata.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneCallMetadata.size(); ++u32Idx)
         (tVoid) (oOut << PhoneCallMetadata[u32Idx]);
   }
   (tVoid) (oOut << SignalStrength);
   (tVoid) (oOut << RegistrationStatus);
   (tVoid) (oOut << AirPlaneModeStatus);
   (tVoid) (oOut << Mute);
   (tVoid) (oOut << CarrierName);
   (tVoid) (oOut << BatteryChargeLevel);
   (tVoid) (oOut << BatteryChargingState);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus::operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (PhoneDataValid == roRef.PhoneDataValid);
      bResult = bResult && (PhoneCallMetadata.size() == roRef.PhoneCallMetadata.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhoneCallMetadata.size()); ++u32Idx)
            bResult = bResult && (PhoneCallMetadata[u32Idx] == roRef.PhoneCallMetadata[u32Idx]);
      }
   bResult = bResult && (SignalStrength == roRef.SignalStrength);
   bResult = bResult && (RegistrationStatus == roRef.RegistrationStatus);
   bResult = bResult && (AirPlaneModeStatus == roRef.AirPlaneModeStatus);
   bResult = bResult && (Mute == roRef.Mute);
   bResult = bResult && (CarrierName == roRef.CarrierName);
   bResult = bResult && (BatteryChargeLevel == roRef.BatteryChargeLevel);
   bResult = bResult && (BatteryChargingState == roRef.BatteryChargingState);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg::midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSUPREG;
}


midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg::~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg::midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSRELUPREG;
}


midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg::~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   BluetoothDeviceHandle = coRef.BluetoothDeviceHandle;
   ProjectionDeviceHandle = coRef.ProjectionDeviceHandle;
   ConnectedProfiles = coRef.ConnectedProfiles;
   BTChangeInfo = coRef.BTChangeInfo;
   SameDevice = coRef.SameDevice;
   CallActiveStatus = coRef.CallActiveStatus;
}
midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::operator=(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   BluetoothDeviceHandle = coRef.BluetoothDeviceHandle;
   ProjectionDeviceHandle = coRef.ProjectionDeviceHandle;
   ConnectedProfiles = coRef.ConnectedProfiles;
   BTChangeInfo = coRef.BTChangeInfo;
   SameDevice = coRef.SameDevice;
   CallActiveStatus = coRef.CallActiveStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus()
:BluetoothDeviceHandle(0)
,ProjectionDeviceHandle(0)
,ConnectedProfiles(0)
,BTChangeInfo()
,SameDevice(0)
,CallActiveStatus(0)
 {}

tS32 midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BLUETOOTHDEVICESTATUSSTATUS;
}


midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::~midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus()
{}

tU32 midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BluetoothDeviceHandle);
   (tVoid) (oIn >> ProjectionDeviceHandle);
   (tVoid) (oIn >> ConnectedProfiles);
   (tVoid) (oIn >> BTChangeInfo);
   (tVoid) (oIn >> SameDevice);
   (tVoid) (oIn >> CallActiveStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BluetoothDeviceHandle);
   (tVoid) (oOut << ProjectionDeviceHandle);
   (tVoid) (oOut << ConnectedProfiles);
   (tVoid) (oOut << BTChangeInfo);
   (tVoid) (oOut << SameDevice);
   (tVoid) (oOut << CallActiveStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus::operator==(const midw_smartphoneintfi_tclMsgBluetoothDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BluetoothDeviceHandle == roRef.BluetoothDeviceHandle);
   bResult = bResult && (ProjectionDeviceHandle == roRef.ProjectionDeviceHandle);
   bResult = bResult && (ConnectedProfiles == roRef.ConnectedProfiles);
   bResult = bResult && (BTChangeInfo == roRef.BTChangeInfo);
   bResult = bResult && (SameDevice == roRef.SameDevice);
   bResult = bResult && (CallActiveStatus == roRef.CallActiveStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg::midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTUPREG;
}


midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg::~midw_smartphoneintfi_tclMsgDeviceAudioContextUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg::midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTRELUPREG;
}


midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg::~midw_smartphoneintfi_tclMsgDeviceAudioContextRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::midw_smartphoneintfi_tclMsgDeviceAudioContextStatus(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AudioFlag = coRef.AudioFlag;
   AudioContext = coRef.AudioContext;
   AudioPermanentEntity = coRef.AudioPermanentEntity;
}
midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::operator=(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AudioFlag = coRef.AudioFlag;
   AudioContext = coRef.AudioContext;
   AudioPermanentEntity = coRef.AudioPermanentEntity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::midw_smartphoneintfi_tclMsgDeviceAudioContextStatus()
:DeviceHandle(0)
,AudioFlag(0)
,AudioContext()
,AudioPermanentEntity()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICEAUDIOCONTEXTSTATUS;
}


midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::~midw_smartphoneintfi_tclMsgDeviceAudioContextStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AudioFlag);
   (tVoid) (oIn >> AudioContext);
   (tVoid) (oIn >> AudioPermanentEntity);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AudioFlag);
   (tVoid) (oOut << AudioContext);
   (tVoid) (oOut << AudioPermanentEntity);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeviceAudioContextStatus::operator==(const midw_smartphoneintfi_tclMsgDeviceAudioContextStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AudioFlag == roRef.AudioFlag);
   bResult = bResult && (AudioContext == roRef.AudioContext);
   bResult = bResult && (AudioPermanentEntity == roRef.AudioPermanentEntity);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg::midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg::~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AppStateSpeech = coRef.AppStateSpeech;
   AppStatePhone = coRef.AppStatePhone;
   AppStateNavigation = coRef.AppStateNavigation;
}
midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   AppStateSpeech = coRef.AppStateSpeech;
   AppStatePhone = coRef.AppStatePhone;
   AppStateNavigation = coRef.AppStateNavigation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus()
:AppStateSpeech()
,AppStatePhone()
,AppStateNavigation()
 {}

tS32 midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIPOAPPSTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::~midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AppStateSpeech);
   (tVoid) (oIn >> AppStatePhone);
   (tVoid) (oIn >> AppStateNavigation);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AppStateSpeech);
   (tVoid) (oOut << AppStatePhone);
   (tVoid) (oOut << AppStateNavigation);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgDiPOAppStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AppStateSpeech == roRef.AppStateSpeech);
   bResult = bResult && (AppStatePhone == roRef.AppStatePhone);
   bResult = bResult && (AppStateNavigation == roRef.AppStateNavigation);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg::midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg::~midw_smartphoneintfi_tclMsgSessionStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgSessionStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::midw_smartphoneintfi_tclMsgSessionStatusInfoStatus(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   SessionStatus = coRef.SessionStatus;
   HandsetInteractionStatus = coRef.HandsetInteractionStatus;
}
midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   SessionStatus = coRef.SessionStatus;
   HandsetInteractionStatus = coRef.HandsetInteractionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::midw_smartphoneintfi_tclMsgSessionStatusInfoStatus()
:DeviceHandle(0)
,DeviceCategory()
,SessionStatus()
,HandsetInteractionStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_SESSIONSTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::~midw_smartphoneintfi_tclMsgSessionStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> SessionStatus);
   (tVoid) (oIn >> HandsetInteractionStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << SessionStatus);
   (tVoid) (oOut << HandsetInteractionStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgSessionStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgSessionStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (SessionStatus == roRef.SessionStatus);
   bResult = bResult && (HandsetInteractionStatus == roRef.HandsetInteractionStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg::midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDUPREG;
}


midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg::~midw_smartphoneintfi_tclMsgBTPairingRequiredUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg::midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDRELUPREG;
}


midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg::~midw_smartphoneintfi_tclMsgBTPairingRequiredRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::midw_smartphoneintfi_tclMsgBTPairingRequiredStatus(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   sDevBTAddr = coRef.sDevBTAddr;
   bPairingReqd = coRef.bPairingReqd;
}
midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::operator=(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& coRef)
{
   if (this == &coRef) return *this;
   sDevBTAddr = coRef.sDevBTAddr;
   bPairingReqd = coRef.bPairingReqd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::vDestroy()
{
   sDevBTAddr.vDestroy();
}

midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::midw_smartphoneintfi_tclMsgBTPairingRequiredStatus()
:sDevBTAddr()
,bPairingReqd(0)
 {}

tS32 midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BTPAIRINGREQUIREDSTATUS;
}


midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::~midw_smartphoneintfi_tclMsgBTPairingRequiredStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDevBTAddr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDevBTAddr);
   (tVoid) (oIn >> bPairingReqd);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDevBTAddr);
   (tVoid) (oOut << bPairingReqd);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgBTPairingRequiredStatus::operator==(const midw_smartphoneintfi_tclMsgBTPairingRequiredStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDevBTAddr == roRef.sDevBTAddr);
   bResult = bResult && (bPairingReqd == roRef.bPairingReqd);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg::midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESUPREG;
}


midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg::~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg::midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESRELUPREG;
}


midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg::~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ValidityOfData = coRef.ValidityOfData;
   NumXDeviceKeys = coRef.NumXDeviceKeys;
   XDeviceKeysList = coRef.XDeviceKeysList;
   rKeyCapabilities = coRef.rKeyCapabilities;
   VoiceRecognitionSupportInfo = coRef.VoiceRecognitionSupportInfo;
}
midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::operator=(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ValidityOfData = coRef.ValidityOfData;
   NumXDeviceKeys = coRef.NumXDeviceKeys;
   XDeviceKeysList = coRef.XDeviceKeysList;
   rKeyCapabilities = coRef.rKeyCapabilities;
   VoiceRecognitionSupportInfo = coRef.VoiceRecognitionSupportInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < XDeviceKeysList.size(); ++u32Idx)
         XDeviceKeysList[u32Idx].vDestroy();
   XDeviceKeysList.clear();
   }
   rKeyCapabilities.vDestroy(); 
}

midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus()
:DeviceHandle(0)
,ValidityOfData(0)
,NumXDeviceKeys(0)

,rKeyCapabilities()
,VoiceRecognitionSupportInfo()
 {}

tS32 midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLSERVERKEYCAPABILITIESSTATUS;
}


midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::~midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < XDeviceKeysList.size(); ++u32ListIdx)
      u32DynamicSize += XDeviceKeysList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+33;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ValidityOfData);
   (tVoid) (oIn >> NumXDeviceKeys);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < XDeviceKeysList.size(); ++u32Idx)
      {
         XDeviceKeysList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      XDeviceKeysList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> XDeviceKeysList[u32Idx]);
      }
   }
   (tVoid) (oIn >> rKeyCapabilities);
   (tVoid) (oIn >> VoiceRecognitionSupportInfo);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ValidityOfData);
   (tVoid) (oOut << NumXDeviceKeys);
   (tVoid) (oOut << (tU32)XDeviceKeysList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < XDeviceKeysList.size(); ++u32Idx)
         (tVoid) (oOut << XDeviceKeysList[u32Idx]);
   }
   (tVoid) (oOut << rKeyCapabilities);
   (tVoid) (oOut << VoiceRecognitionSupportInfo);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus::operator==(const midw_smartphoneintfi_tclMsgMLServerKeyCapabilitiesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ValidityOfData == roRef.ValidityOfData);
   bResult = bResult && (NumXDeviceKeys == roRef.NumXDeviceKeys);
      bResult = bResult && (XDeviceKeysList.size() == roRef.XDeviceKeysList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < XDeviceKeysList.size()); ++u32Idx)
            bResult = bResult && (XDeviceKeysList[u32Idx] == roRef.XDeviceKeysList[u32Idx]);
      }
   bResult = bResult && (rKeyCapabilities == roRef.rKeyCapabilities);
   bResult = bResult && (VoiceRecognitionSupportInfo == roRef.VoiceRecognitionSupportInfo);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDialUpReg::midw_smartphoneintfi_tclMsgDialUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDialUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIALUPREG;
}


midw_smartphoneintfi_tclMsgDialUpReg::~midw_smartphoneintfi_tclMsgDialUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDialRelUpReg::midw_smartphoneintfi_tclMsgDialRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDialRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIALRELUPREG;
}


midw_smartphoneintfi_tclMsgDialRelUpReg::~midw_smartphoneintfi_tclMsgDialRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDialSet::midw_smartphoneintfi_tclMsgDialSet(const midw_smartphoneintfi_tclMsgDialSet& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   PhoneCallState = coRef.PhoneCallState;
}
midw_smartphoneintfi_tclMsgDialSet& midw_smartphoneintfi_tclMsgDialSet::operator=(const midw_smartphoneintfi_tclMsgDialSet& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   PhoneCallState = coRef.PhoneCallState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDialSet::midw_smartphoneintfi_tclMsgDialSet()
:DeviceHandle(0)
,PhoneCallState()
 {}

tS32 midw_smartphoneintfi_tclMsgDialSet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIALSET;
}


midw_smartphoneintfi_tclMsgDialSet::~midw_smartphoneintfi_tclMsgDialSet()
{}

tU32 midw_smartphoneintfi_tclMsgDialSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDialSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> PhoneCallState);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDialSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << PhoneCallState);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDialSet::operator==(const midw_smartphoneintfi_tclMsgDialSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (PhoneCallState == roRef.PhoneCallState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDialStatus::midw_smartphoneintfi_tclMsgDialStatus(const midw_smartphoneintfi_tclMsgDialStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   TelephoneNumber = coRef.TelephoneNumber;
   DisplayContent = coRef.DisplayContent;
}
midw_smartphoneintfi_tclMsgDialStatus& midw_smartphoneintfi_tclMsgDialStatus::operator=(const midw_smartphoneintfi_tclMsgDialStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   TelephoneNumber = coRef.TelephoneNumber;
   DisplayContent = coRef.DisplayContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgDialStatus::vDestroy()
{
   TelephoneNumber.vDestroy();
   DisplayContent.vDestroy();
}

midw_smartphoneintfi_tclMsgDialStatus::midw_smartphoneintfi_tclMsgDialStatus()
:DeviceHandle(0)
,TelephoneNumber()
,DisplayContent()
 {}

tS32 midw_smartphoneintfi_tclMsgDialStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DIALSTATUS;
}


midw_smartphoneintfi_tclMsgDialStatus::~midw_smartphoneintfi_tclMsgDialStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgDialStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+TelephoneNumber.u32GetSize(u16MajorVersion)+DisplayContent.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDialStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> TelephoneNumber);
   (tVoid) (oIn >> DisplayContent);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDialStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << TelephoneNumber);
   (tVoid) (oOut << DisplayContent);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDialStatus::operator==(const midw_smartphoneintfi_tclMsgDialStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (TelephoneNumber == roRef.TelephoneNumber);
   bResult = bResult && (DisplayContent == roRef.DisplayContent);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg::midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMEUPREG;
}


midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg::~midw_smartphoneintfi_tclMsgMediaPlayBackTimeUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg::midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMERELUPREG;
}


midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg::~midw_smartphoneintfi_tclMsgMediaPlayBackTimeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   TotalPlayTime = coRef.TotalPlayTime;
   ElapsedPlayTime = coRef.ElapsedPlayTime;
}
midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::operator=(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   TotalPlayTime = coRef.TotalPlayTime;
   ElapsedPlayTime = coRef.ElapsedPlayTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus()
:DeviceHandle(0)
,TotalPlayTime(0)
,ElapsedPlayTime(0)
 {}

tS32 midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MEDIAPLAYBACKTIMESTATUS;
}


midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::~midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus()
{}

tU32 midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> TotalPlayTime);
   (tVoid) (oIn >> ElapsedPlayTime);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << TotalPlayTime);
   (tVoid) (oOut << ElapsedPlayTime);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus::operator==(const midw_smartphoneintfi_tclMsgMediaPlayBackTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (TotalPlayTime == roRef.TotalPlayTime);
   bResult = bResult && (ElapsedPlayTime == roRef.ElapsedPlayTime);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONUPREG;
}


midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg::~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONRELUPREG;
}


midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg::~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   UserAuthorizationStatus = coRef.UserAuthorizationStatus;
}
midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::operator=(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   UserAuthorizationStatus = coRef.UserAuthorizationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet()
:DeviceHandle(0)
,UserAuthorizationStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONSET;
}


midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet()
{}

tU32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> UserAuthorizationStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << UserAuthorizationStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet::operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (UserAuthorizationStatus == roRef.UserAuthorizationStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   NumDevices = coRef.NumDevices;
   DeviceAuthInfoList = coRef.DeviceAuthInfoList;
}
midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::operator=(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& coRef)
{
   if (this == &coRef) return *this;
   NumDevices = coRef.NumDevices;
   DeviceAuthInfoList = coRef.DeviceAuthInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceAuthInfoList.size(); ++u32Idx)
         DeviceAuthInfoList[u32Idx].vDestroy();
   DeviceAuthInfoList.clear();
   }
}

midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus()
:NumDevices(0)

 {}

tS32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTIONDEVICEAUTHORIZATIONSTATUS;
}


midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::~midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(DeviceAuthInfoList.size()*6);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NumDevices);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceAuthInfoList.size(); ++u32Idx)
      {
         DeviceAuthInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceAuthInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceAuthInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NumDevices);
   (tVoid) (oOut << (tU32)DeviceAuthInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceAuthInfoList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceAuthInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus::operator==(const midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NumDevices == roRef.NumDevices);
      bResult = bResult && (DeviceAuthInfoList.size() == roRef.DeviceAuthInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceAuthInfoList.size()); ++u32Idx)
            bResult = bResult && (DeviceAuthInfoList[u32Idx] == roRef.DeviceAuthInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg::midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFOUPREG;
}


midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg::~midw_smartphoneintfi_tclMsgNavigationStatusInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg::midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFORELUPREG;
}


midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg::~midw_smartphoneintfi_tclMsgNavigationStatusInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   NavigationStatus = coRef.NavigationStatus;
}
midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::operator=(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   NavigationStatus = coRef.NavigationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus()
:DeviceHandle(0)
,DeviceCategory()
,NavigationStatus()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONSTATUSINFOSTATUS;
}


midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::~midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> NavigationStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << NavigationStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus::operator==(const midw_smartphoneintfi_tclMsgNavigationStatusInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (NavigationStatus == roRef.NavigationStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg::midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATAUPREG;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg::~midw_smartphoneintfi_tclMsgNavigationNextTurnDataUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg::midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATARELUPREG;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg::~midw_smartphoneintfi_tclMsgNavigationNextTurnDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   RoadName = coRef.RoadName;
   TurnSide = coRef.TurnSide;
   NextTurnEvent = coRef.NextTurnEvent;
   Image = coRef.Image;
   TurnAngle = coRef.TurnAngle;
   TurnNumber = coRef.TurnNumber;
}
midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::operator=(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   RoadName = coRef.RoadName;
   TurnSide = coRef.TurnSide;
   NextTurnEvent = coRef.NextTurnEvent;
   Image = coRef.Image;
   TurnAngle = coRef.TurnAngle;
   TurnNumber = coRef.TurnNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::vDestroy()
{
   RoadName.vDestroy();
   Image.vDestroy();
}

midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus()
:DeviceHandle(0)
,DeviceCategory()
,RoadName()
,TurnSide()
,NextTurnEvent()
,Image()
,TurnAngle(0)
,TurnNumber(0)
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDATASTATUS;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::~midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+RoadName.u32GetSize(u16MajorVersion)+Image.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> RoadName);
   (tVoid) (oIn >> TurnSide);
   (tVoid) (oIn >> NextTurnEvent);
   (tVoid) (oIn >> Image);
   (tVoid) (oIn >> TurnAngle);
   (tVoid) (oIn >> TurnNumber);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << RoadName);
   (tVoid) (oOut << TurnSide);
   (tVoid) (oOut << NextTurnEvent);
   (tVoid) (oOut << Image);
   (tVoid) (oOut << TurnAngle);
   (tVoid) (oOut << TurnNumber);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus::operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (RoadName == roRef.RoadName);
   bResult = bResult && (TurnSide == roRef.TurnSide);
   bResult = bResult && (NextTurnEvent == roRef.NextTurnEvent);
   bResult = bResult && (Image == roRef.Image);
   bResult = bResult && (TurnAngle == roRef.TurnAngle);
   bResult = bResult && (TurnNumber == roRef.TurnNumber);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg::midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATAUPREG;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg::~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg::midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATARELUPREG;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg::~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   DistanceInMeters = coRef.DistanceInMeters;
   TimeInSec  = coRef.TimeInSec ;
   DistanceToManeuver = coRef.DistanceToManeuver;
   ManeuverDistanceUnits  = coRef.ManeuverDistanceUnits ;
}
midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::operator=(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   DistanceInMeters = coRef.DistanceInMeters;
   TimeInSec  = coRef.TimeInSec ;
   DistanceToManeuver = coRef.DistanceToManeuver;
   ManeuverDistanceUnits  = coRef.ManeuverDistanceUnits ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus()
:DeviceHandle(0)
,DeviceCategory()
,DistanceInMeters(0)
,TimeInSec (0)
,DistanceToManeuver(0)
,ManeuverDistanceUnits ()
 {}

tS32 midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_NAVIGATIONNEXTTURNDISTANCEDATASTATUS;
}


midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::~midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus()
{}

tU32 midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> DistanceInMeters);
   (tVoid) (oIn >> TimeInSec );
   (tVoid) (oIn >> DistanceToManeuver);
   (tVoid) (oIn >> ManeuverDistanceUnits );
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << DistanceInMeters);
   (tVoid) (oOut << TimeInSec );
   (tVoid) (oOut << DistanceToManeuver);
   (tVoid) (oOut << ManeuverDistanceUnits );
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus::operator==(const midw_smartphoneintfi_tclMsgNavigationNextTurnDistanceDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (DistanceInMeters == roRef.DistanceInMeters);
   bResult = bResult && (TimeInSec  == roRef.TimeInSec );
   bResult = bResult && (DistanceToManeuver == roRef.DistanceToManeuver);
   bResult = bResult && (ManeuverDistanceUnits  == roRef.ManeuverDistanceUnits );
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg::midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTUPREG;
}


midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg::~midw_smartphoneintfi_tclMsgAAPNotificationEventUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg::midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTRELUPREG;
}


midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg::~midw_smartphoneintfi_tclMsgAAPNotificationEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAAPNotificationEventSet::midw_smartphoneintfi_tclMsgAAPNotificationEventSet(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AAPNotificationId = coRef.AAPNotificationId;
}
midw_smartphoneintfi_tclMsgAAPNotificationEventSet& midw_smartphoneintfi_tclMsgAAPNotificationEventSet::operator=(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& coRef)
{
   if (this == &coRef) return *this;
   AAPNotificationId = coRef.AAPNotificationId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgAAPNotificationEventSet::vDestroy()
{
   AAPNotificationId.vDestroy();
}

midw_smartphoneintfi_tclMsgAAPNotificationEventSet::midw_smartphoneintfi_tclMsgAAPNotificationEventSet()
:AAPNotificationId()
 {}

tS32 midw_smartphoneintfi_tclMsgAAPNotificationEventSet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTSET;
}


midw_smartphoneintfi_tclMsgAAPNotificationEventSet::~midw_smartphoneintfi_tclMsgAAPNotificationEventSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgAAPNotificationEventSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AAPNotificationId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAAPNotificationEventSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AAPNotificationId);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAAPNotificationEventSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AAPNotificationId);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAAPNotificationEventSet::operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AAPNotificationId == roRef.AAPNotificationId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::midw_smartphoneintfi_tclMsgAAPNotificationEventStatus(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   AAPNotificationId = coRef.AAPNotificationId;
   NotificationText = coRef.NotificationText;
   NotificationIcon = coRef.NotificationIcon;
}
midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::operator=(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   AAPNotificationId = coRef.AAPNotificationId;
   NotificationText = coRef.NotificationText;
   NotificationIcon = coRef.NotificationIcon;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::vDestroy()
{
   AAPNotificationId.vDestroy();
   NotificationText.vDestroy();
   {
   NotificationIcon.clear();
   }
}

midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::midw_smartphoneintfi_tclMsgAAPNotificationEventStatus()
:DeviceHandle(0)
,DeviceCategory()
,AAPNotificationId()
,NotificationText()

 {}

tS32 midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAPNOTIFICATIONEVENTSTATUS;
}


midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::~midw_smartphoneintfi_tclMsgAAPNotificationEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+AAPNotificationId.u32GetSize(u16MajorVersion)+NotificationText.u32GetSize(u16MajorVersion)+ static_cast<tU32>(NotificationIcon.size()*1);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> AAPNotificationId);
   (tVoid) (oIn >> NotificationText);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NotificationIcon.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NotificationIcon[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << AAPNotificationId);
   (tVoid) (oOut << NotificationText);
   (tVoid) (oOut << (tU32)NotificationIcon.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NotificationIcon.size(); ++u32Idx)
         (tVoid) (oOut << NotificationIcon[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAAPNotificationEventStatus::operator==(const midw_smartphoneintfi_tclMsgAAPNotificationEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (AAPNotificationId == roRef.AAPNotificationId);
   bResult = bResult && (NotificationText == roRef.NotificationText);
      bResult = bResult && (NotificationIcon.size() == roRef.NotificationIcon.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NotificationIcon.size()); ++u32Idx)
            bResult = bResult && (NotificationIcon[u32Idx] == roRef.NotificationIcon[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOUPREG;
}


midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg::~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFORELUPREG;
}


midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg::~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   BTVoiceRecReqResponse = coRef.BTVoiceRecReqResponse;
}
midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::operator=(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   BTVoiceRecReqResponse = coRef.BTVoiceRecReqResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet()
:DeviceHandle(0)
,BTVoiceRecReqResponse()
 {}

tS32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOSET;
}


midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet()
{}

tU32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> BTVoiceRecReqResponse);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << BTVoiceRecReqResponse);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet::operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (BTVoiceRecReqResponse == roRef.BTVoiceRecReqResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   BTVoiceRecRequest = coRef.BTVoiceRecRequest;
}
midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::operator=(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   BTVoiceRecRequest = coRef.BTVoiceRecRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus()
:DeviceHandle(0)
,BTVoiceRecRequest()
 {}

tS32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MYSPINBLUETOOTHVOICERECINFOSTATUS;
}


midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::~midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> BTVoiceRecRequest);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << BTVoiceRecRequest);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus::operator==(const midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (BTVoiceRecRequest == roRef.BTVoiceRecRequest);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgTechnologySelectionUpReg::midw_smartphoneintfi_tclMsgTechnologySelectionUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgTechnologySelectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONUPREG;
}


midw_smartphoneintfi_tclMsgTechnologySelectionUpReg::~midw_smartphoneintfi_tclMsgTechnologySelectionUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg::midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONRELUPREG;
}


midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg::~midw_smartphoneintfi_tclMsgTechnologySelectionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgTechnologySelectionSet::midw_smartphoneintfi_tclMsgTechnologySelectionSet(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   SelectedTechnology = coRef.SelectedTechnology;
}
midw_smartphoneintfi_tclMsgTechnologySelectionSet& midw_smartphoneintfi_tclMsgTechnologySelectionSet::operator=(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   SelectedTechnology = coRef.SelectedTechnology;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgTechnologySelectionSet::midw_smartphoneintfi_tclMsgTechnologySelectionSet()
:DeviceHandle(0)
,SelectedTechnology()
 {}

tS32 midw_smartphoneintfi_tclMsgTechnologySelectionSet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONSET;
}


midw_smartphoneintfi_tclMsgTechnologySelectionSet::~midw_smartphoneintfi_tclMsgTechnologySelectionSet()
{}

tU32 midw_smartphoneintfi_tclMsgTechnologySelectionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgTechnologySelectionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> SelectedTechnology);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgTechnologySelectionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << SelectedTechnology);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgTechnologySelectionSet::operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (SelectedTechnology == roRef.SelectedTechnology);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgTechnologySelectionStatus::midw_smartphoneintfi_tclMsgTechnologySelectionStatus(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   SelectedTechnology = coRef.SelectedTechnology;
   DeviceType = coRef.DeviceType;
}
midw_smartphoneintfi_tclMsgTechnologySelectionStatus& midw_smartphoneintfi_tclMsgTechnologySelectionStatus::operator=(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   SelectedTechnology = coRef.SelectedTechnology;
   DeviceType = coRef.DeviceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgTechnologySelectionStatus::midw_smartphoneintfi_tclMsgTechnologySelectionStatus()
:DeviceHandle(0)
,SelectedTechnology()
,DeviceType()
 {}

tS32 midw_smartphoneintfi_tclMsgTechnologySelectionStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TECHNOLOGYSELECTIONSTATUS;
}


midw_smartphoneintfi_tclMsgTechnologySelectionStatus::~midw_smartphoneintfi_tclMsgTechnologySelectionStatus()
{}

tU32 midw_smartphoneintfi_tclMsgTechnologySelectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgTechnologySelectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> SelectedTechnology);
   (tVoid) (oIn >> DeviceType);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgTechnologySelectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << SelectedTechnology);
   (tVoid) (oOut << DeviceType);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgTechnologySelectionStatus::operator==(const midw_smartphoneintfi_tclMsgTechnologySelectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (SelectedTechnology == roRef.SelectedTechnology);
   bResult = bResult && (DeviceType == roRef.DeviceType);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg::midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSUPREG;
}


midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg::~midw_smartphoneintfi_tclMsgWiFiCredentialsUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg::midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSRELUPREG;
}


midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg::~midw_smartphoneintfi_tclMsgWiFiCredentialsRelUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgWiFiCredentialsGet::midw_smartphoneintfi_tclMsgWiFiCredentialsGet()
 {}

tS32 midw_smartphoneintfi_tclMsgWiFiCredentialsGet::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSGET;
}


midw_smartphoneintfi_tclMsgWiFiCredentialsGet::~midw_smartphoneintfi_tclMsgWiFiCredentialsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::midw_smartphoneintfi_tclMsgWiFiCredentialsStatus(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   AccessoryWiFiAPCredentials = coRef.AccessoryWiFiAPCredentials;
}
midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::operator=(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& coRef)
{
   if (this == &coRef) return *this;
   AccessoryWiFiAPCredentials = coRef.AccessoryWiFiAPCredentials;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::vDestroy()
{
   AccessoryWiFiAPCredentials.vDestroy(); 
}

midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::midw_smartphoneintfi_tclMsgWiFiCredentialsStatus()
:AccessoryWiFiAPCredentials()
 {}

tS32 midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_WIFICREDENTIALSSTATUS;
}


midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::~midw_smartphoneintfi_tclMsgWiFiCredentialsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AccessoryWiFiAPCredentials.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AccessoryWiFiAPCredentials);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AccessoryWiFiAPCredentials);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgWiFiCredentialsStatus::operator==(const midw_smartphoneintfi_tclMsgWiFiCredentialsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AccessoryWiFiAPCredentials == roRef.AccessoryWiFiAPCredentials);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg::midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFOUPREG;
}


midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg::~midw_smartphoneintfi_tclMsgTurnByTurnInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg::midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFORELUPREG;
}


midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg::~midw_smartphoneintfi_tclMsgTurnByTurnInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   CarPlayTBTUpdate = coRef.CarPlayTBTUpdate;
   AAutoTBTUpdate = coRef.AAutoTBTUpdate;
   BDCLTBTUpdate = coRef.BDCLTBTUpdate;
   MLTBTUpdate = coRef.MLTBTUpdate;
}
midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::operator=(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   CarPlayTBTUpdate = coRef.CarPlayTBTUpdate;
   AAutoTBTUpdate = coRef.AAutoTBTUpdate;
   BDCLTBTUpdate = coRef.BDCLTBTUpdate;
   MLTBTUpdate = coRef.MLTBTUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::vDestroy()
{
   CarPlayTBTUpdate.vDestroy(); 
   AAutoTBTUpdate.vDestroy(); 
   BDCLTBTUpdate.vDestroy(); 
   MLTBTUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus()
:DeviceHandle(0)
,DeviceCategory()
,CarPlayTBTUpdate()
,AAutoTBTUpdate()
,BDCLTBTUpdate()
,MLTBTUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_TURNBYTURNINFOSTATUS;
}


midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::~midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+CarPlayTBTUpdate.u32GetSize(u16MajorVersion)+AAutoTBTUpdate.u32GetSize(u16MajorVersion)+BDCLTBTUpdate.u32GetSize(u16MajorVersion)+MLTBTUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> CarPlayTBTUpdate);
   (tVoid) (oIn >> AAutoTBTUpdate);
   (tVoid) (oIn >> BDCLTBTUpdate);
   (tVoid) (oIn >> MLTBTUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << CarPlayTBTUpdate);
   (tVoid) (oOut << AAutoTBTUpdate);
   (tVoid) (oOut << BDCLTBTUpdate);
   (tVoid) (oOut << MLTBTUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus::operator==(const midw_smartphoneintfi_tclMsgTurnByTurnInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (CarPlayTBTUpdate == roRef.CarPlayTBTUpdate);
   bResult = bResult && (AAutoTBTUpdate == roRef.AAutoTBTUpdate);
   bResult = bResult && (BDCLTBTUpdate == roRef.BDCLTBTUpdate);
   bResult = bResult && (MLTBTUpdate == roRef.MLTBTUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg::midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFOUPREG;
}


midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg::~midw_smartphoneintfi_tclMsgProjectedVideoInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg::midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFORELUPREG;
}


midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg::~midw_smartphoneintfi_tclMsgProjectedVideoInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   ProjectedVideoAttributes = coRef.ProjectedVideoAttributes;
}
midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::operator=(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   ProjectedVideoAttributes = coRef.ProjectedVideoAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus()
:DeviceHandle(0)
,ProjectedVideoAttributes()
 {}

tS32 midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_PROJECTEDVIDEOINFOSTATUS;
}


midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::~midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus()
{}

tU32 midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> ProjectedVideoAttributes);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << ProjectedVideoAttributes);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus::operator==(const midw_smartphoneintfi_tclMsgProjectedVideoInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (ProjectedVideoAttributes == roRef.ProjectedVideoAttributes);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg::midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSUPREG;
}


midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg::~midw_smartphoneintfi_tclMsgDeviceLockStatusUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg::midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSRELUPREG;
}


midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg::~midw_smartphoneintfi_tclMsgDeviceLockStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::midw_smartphoneintfi_tclMsgDeviceLockStatusStatus(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   bDeviceLockStatus = coRef.bDeviceLockStatus;
}
midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::operator=(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceCategory = coRef.DeviceCategory;
   bDeviceLockStatus = coRef.bDeviceLockStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::midw_smartphoneintfi_tclMsgDeviceLockStatusStatus()
:DeviceHandle(0)
,DeviceCategory()
,bDeviceLockStatus(0)
 {}

tS32 midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_DEVICELOCKSTATUSSTATUS;
}


midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::~midw_smartphoneintfi_tclMsgDeviceLockStatusStatus()
{}

tU32 midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceCategory);
   (tVoid) (oIn >> bDeviceLockStatus);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceCategory);
   (tVoid) (oOut << bDeviceLockStatus);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgDeviceLockStatusStatus::operator==(const midw_smartphoneintfi_tclMsgDeviceLockStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceCategory == roRef.DeviceCategory);
   bResult = bResult && (bDeviceLockStatus == roRef.bDeviceLockStatus);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg::midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPUPREG;
}


midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg::~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg::midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPRELUPREG;
}


midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg::~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   MediaAppHandle = coRef.MediaAppHandle;
   MediaAppCategory = coRef.MediaAppCategory;
}
midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::operator=(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaAppHandle = coRef.MediaAppHandle;
   MediaAppCategory = coRef.MediaAppCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus()
:MediaAppHandle(0)
,MediaAppCategory()
 {}

tS32 midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_RELATIVELYACTIVEMEDIAAPPSTATUS;
}


midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::~midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus()
{}

tU32 midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaAppHandle);
   (tVoid) (oIn >> MediaAppCategory);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaAppHandle);
   (tVoid) (oOut << MediaAppCategory);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus::operator==(const midw_smartphoneintfi_tclMsgRelativelyActiveMediaAppStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaAppHandle == roRef.MediaAppHandle);
   bResult = bResult && (MediaAppCategory == roRef.MediaAppCategory);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATEUPREG;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATERELUPREG;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceUSBSerialNumber = coRef.DeviceUSBSerialNumber;
   RouteGuidanceUpdate = coRef.RouteGuidanceUpdate;
}
midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::operator=(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceUSBSerialNumber = coRef.DeviceUSBSerialNumber;
   RouteGuidanceUpdate = coRef.RouteGuidanceUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::vDestroy()
{
   DeviceUSBSerialNumber.vDestroy();
   RouteGuidanceUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus()
:DeviceHandle(0)
,DeviceUSBSerialNumber()
,RouteGuidanceUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEUPDATESTATUS;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus::operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceUSBSerialNumber == roRef.DeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceUpdate == roRef.RouteGuidanceUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATEUPREG;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATERELUPREG;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   DeviceUSBSerialNumber = coRef.DeviceUSBSerialNumber;
   RouteGuidanceManeuverUpdate = coRef.RouteGuidanceManeuverUpdate;
}
midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::operator=(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   DeviceUSBSerialNumber = coRef.DeviceUSBSerialNumber;
   RouteGuidanceManeuverUpdate = coRef.RouteGuidanceManeuverUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::vDestroy()
{
   DeviceUSBSerialNumber.vDestroy();
   RouteGuidanceManeuverUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus()
:DeviceHandle(0)
,DeviceUSBSerialNumber()
,RouteGuidanceManeuverUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_CARPLAYROUTEGUIDANCEMANEUVERUPDATESTATUS;
}


midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::~midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceManeuverUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> DeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceManeuverUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << DeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceManeuverUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus::operator==(const midw_smartphoneintfi_tclMsgCarplayRouteGuidanceManeuverUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (DeviceUSBSerialNumber == roRef.DeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceManeuverUpdate == roRef.RouteGuidanceManeuverUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg::midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFOUPREG;
}


midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg::~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg::midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFORELUPREG;
}


midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg::~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   AAutoTBTUpdate = coRef.AAutoTBTUpdate;
}
midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::operator=(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   AAutoTBTUpdate = coRef.AAutoTBTUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::vDestroy()
{
   AAutoTBTUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus()
:DeviceHandle(0)
,AAutoTBTUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_AAUTOTURNBYTURNINFOSTATUS;
}


midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::~midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+AAutoTBTUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> AAutoTBTUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << AAutoTBTUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus::operator==(const midw_smartphoneintfi_tclMsgAAutoTurnByTurnInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (AAutoTBTUpdate == roRef.AAutoTBTUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg::midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFOUPREG;
}


midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg::~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg::midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFORELUPREG;
}


midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg::~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   BDCLTBTUpdate = coRef.BDCLTBTUpdate;
}
midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::operator=(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   BDCLTBTUpdate = coRef.BDCLTBTUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::vDestroy()
{
   BDCLTBTUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus()
:DeviceHandle(0)
,BDCLTBTUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_BDCLTURNBYTURNINFOSTATUS;
}


midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::~midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+BDCLTBTUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> BDCLTBTUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << BDCLTBTUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus::operator==(const midw_smartphoneintfi_tclMsgBDCLTurnByTurnInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (BDCLTBTUpdate == roRef.BDCLTBTUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg::midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFOUPREG;
}


midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg::~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg::midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFORELUPREG;
}


midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg::~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   MLTBTUpdate = coRef.MLTBTUpdate;
}
midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::operator=(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   MLTBTUpdate = coRef.MLTBTUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::vDestroy()
{
   MLTBTUpdate.vDestroy(); 
}

midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus()
:DeviceHandle(0)
,MLTBTUpdate()
 {}

tS32 midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_MLTURNBYTURNINFOSTATUS;
}


midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::~midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MLTBTUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> MLTBTUpdate);
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << MLTBTUpdate);
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus::operator==(const midw_smartphoneintfi_tclMsgMLTurnByTurnInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (MLTBTUpdate == roRef.MLTBTUpdate);
   return bResult;
}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg::midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATAUPREG;
}


midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg::~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataUpReg()
{}

//=============================================================================

midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg::midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg()
 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATARELUPREG;
}


midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg::~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& coRef)
   : midw_smartphoneintfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   PhoneCallExtendedMetadata = coRef.PhoneCallExtendedMetadata;
}
midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::operator=(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   PhoneCallExtendedMetadata = coRef.PhoneCallExtendedMetadata;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneCallExtendedMetadata.size(); ++u32Idx)
         PhoneCallExtendedMetadata[u32Idx].vDestroy();
   PhoneCallExtendedMetadata.clear();
   }
}

midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus()
:DeviceHandle(0)

 {}

tS32 midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::s32GetTypeId() const
{
   return (tS32) midw_smartphoneintfi_tclToken::EN_MSG_APPLICATIONPHONECALLDATASTATUS;
}


midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::~midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhoneCallExtendedMetadata.size(); ++u32ListIdx)
      u32DynamicSize += PhoneCallExtendedMetadata[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhoneCallExtendedMetadata.size(); ++u32Idx)
      {
         PhoneCallExtendedMetadata[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhoneCallExtendedMetadata.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhoneCallExtendedMetadata[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << (tU32)PhoneCallExtendedMetadata.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneCallExtendedMetadata.size(); ++u32Idx)
         (tVoid) (oOut << PhoneCallExtendedMetadata[u32Idx]);
   }
   return oOut;
}

tBool midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus::operator==(const midw_smartphoneintfi_tclMsgApplicationPhoneCallDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
      bResult = bResult && (PhoneCallExtendedMetadata.size() == roRef.PhoneCallExtendedMetadata.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhoneCallExtendedMetadata.size()); ++u32Idx)
            bResult = bResult && (PhoneCallExtendedMetadata[u32Idx] == roRef.PhoneCallExtendedMetadata[u32Idx]);
      }
   return bResult;
}

