/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_KBDFITYPES_HEADER
#define MIDW_KBDFITYPES_HEADER


class midw_kbdfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_KBD_FI message types

fi_tclMessageBase* midw_kbdfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_kbdfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_kbdfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& operator=(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& coRef);
   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibrationType e8CalibrationType;
   virtual ~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort();

   virtual ~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort();

   inline tBool operator==(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& operator=(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& coRef);
   midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VDKBD_MethodResult e8MethodResult;
   virtual ~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoUpReg();

   virtual ~midw_kbdfi_tclMsgKeyInfoUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoRelUpReg();

   virtual ~midw_kbdfi_tclMsgKeyInfoRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoSet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgKeyInfoSet& operator=(const midw_kbdfi_tclMsgKeyInfoSet& coRef);
   midw_kbdfi_tclMsgKeyInfoSet(const midw_kbdfi_tclMsgKeyInfoSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyInfo SimulatedKeyData;
   virtual ~midw_kbdfi_tclMsgKeyInfoSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgKeyInfoSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgKeyInfoStatus& operator=(const midw_kbdfi_tclMsgKeyInfoStatus& coRef);
   midw_kbdfi_tclMsgKeyInfoStatus(const midw_kbdfi_tclMsgKeyInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyInfo KeyInfo;
   virtual ~midw_kbdfi_tclMsgKeyInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgKeyInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoEjectUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoEjectUpReg();

   virtual ~midw_kbdfi_tclMsgKeyInfoEjectUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyInfoEjectUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoEjectRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoEjectRelUpReg();

   virtual ~midw_kbdfi_tclMsgKeyInfoEjectRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyInfoEjectRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyInfoEjectStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyInfoEjectStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgKeyInfoEjectStatus& operator=(const midw_kbdfi_tclMsgKeyInfoEjectStatus& coRef);
   midw_kbdfi_tclMsgKeyInfoEjectStatus(const midw_kbdfi_tclMsgKeyInfoEjectStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_KeyAttr e8KeyAttr;
   virtual ~midw_kbdfi_tclMsgKeyInfoEjectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgKeyInfoEjectStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgEncoderInfoUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgEncoderInfoUpReg();

   virtual ~midw_kbdfi_tclMsgEncoderInfoUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgEncoderInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgEncoderInfoRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgEncoderInfoRelUpReg();

   virtual ~midw_kbdfi_tclMsgEncoderInfoRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgEncoderInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgEncoderInfoSet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgEncoderInfoSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgEncoderInfoSet& operator=(const midw_kbdfi_tclMsgEncoderInfoSet& coRef);
   midw_kbdfi_tclMsgEncoderInfoSet(const midw_kbdfi_tclMsgEncoderInfoSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyEnc SimulatedKeyData;
   virtual ~midw_kbdfi_tclMsgEncoderInfoSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgEncoderInfoSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgEncoderInfoStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgEncoderInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgEncoderInfoStatus& operator=(const midw_kbdfi_tclMsgEncoderInfoStatus& coRef);
   midw_kbdfi_tclMsgEncoderInfoStatus(const midw_kbdfi_tclMsgEncoderInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyEnc KeyEncoder;
   virtual ~midw_kbdfi_tclMsgEncoderInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgEncoderInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgSetCalibrationPointsSet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgSetCalibrationPointsSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgSetCalibrationPointsSet& operator=(const midw_kbdfi_tclMsgSetCalibrationPointsSet& coRef);
   midw_kbdfi_tclMsgSetCalibrationPointsSet(const midw_kbdfi_tclMsgSetCalibrationPointsSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_CalibrationPoint oCalibrationPoint;
   virtual ~midw_kbdfi_tclMsgSetCalibrationPointsSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgSetCalibrationPointsSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgSetCalibrationPointsStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgSetCalibrationPointsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgSetCalibrationPointsStatus& operator=(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& coRef);
   midw_kbdfi_tclMsgSetCalibrationPointsStatus(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSetSuccess;
   virtual ~midw_kbdfi_tclMsgSetCalibrationPointsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDrawCalibrationPageUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDrawCalibrationPageUpReg();

   virtual ~midw_kbdfi_tclMsgDrawCalibrationPageUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDrawCalibrationPageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg();

   virtual ~midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDrawCalibrationPageStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDrawCalibrationPageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgDrawCalibrationPageStatus& operator=(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& coRef);
   midw_kbdfi_tclMsgDrawCalibrationPageStatus(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PageIndex e8Page;
   virtual ~midw_kbdfi_tclMsgDrawCalibrationPageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgCalibrationStatusUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgCalibrationStatusUpReg();

   virtual ~midw_kbdfi_tclMsgCalibrationStatusUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgCalibrationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgCalibrationStatusRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgCalibrationStatusRelUpReg();

   virtual ~midw_kbdfi_tclMsgCalibrationStatusRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgCalibrationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgCalibrationStatusStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgCalibrationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgCalibrationStatusStatus& operator=(const midw_kbdfi_tclMsgCalibrationStatusStatus& coRef);
   midw_kbdfi_tclMsgCalibrationStatusStatus(const midw_kbdfi_tclMsgCalibrationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_CalibStatusToHMI e8CalibrationStsToHMI;
   virtual ~midw_kbdfi_tclMsgCalibrationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgCalibrationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgFasciaIdUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgFasciaIdUpReg();

   virtual ~midw_kbdfi_tclMsgFasciaIdUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgFasciaIdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgFasciaIdRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgFasciaIdRelUpReg();

   virtual ~midw_kbdfi_tclMsgFasciaIdRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgFasciaIdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgFasciaIdStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgFasciaIdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgFasciaIdStatus& operator=(const midw_kbdfi_tclMsgFasciaIdStatus& coRef);
   midw_kbdfi_tclMsgFasciaIdStatus(const midw_kbdfi_tclMsgFasciaIdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString tSfasciaId;
   virtual ~midw_kbdfi_tclMsgFasciaIdStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgFasciaIdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgTouchInfoUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgTouchInfoUpReg();

   virtual ~midw_kbdfi_tclMsgTouchInfoUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgTouchInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgTouchInfoRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgTouchInfoRelUpReg();

   virtual ~midw_kbdfi_tclMsgTouchInfoRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgTouchInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgTouchInfoGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgTouchInfoGet();

   virtual ~midw_kbdfi_tclMsgTouchInfoGet();

   inline tBool operator==(const midw_kbdfi_tclMsgTouchInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgTouchInfoStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgTouchInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgTouchInfoStatus& operator=(const midw_kbdfi_tclMsgTouchInfoStatus& coRef);
   midw_kbdfi_tclMsgTouchInfoStatus(const midw_kbdfi_tclMsgTouchInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DispTouchInfo TouchInfo;
   virtual ~midw_kbdfi_tclMsgTouchInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgTouchInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAuxInInfoUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAuxInInfoUpReg();

   virtual ~midw_kbdfi_tclMsgAuxInInfoUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAuxInInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAuxInInfoRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAuxInInfoRelUpReg();

   virtual ~midw_kbdfi_tclMsgAuxInInfoRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAuxInInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAuxInInfoGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAuxInInfoGet();

   virtual ~midw_kbdfi_tclMsgAuxInInfoGet();

   inline tBool operator==(const midw_kbdfi_tclMsgAuxInInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAuxInInfoStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAuxInInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgAuxInInfoStatus& operator=(const midw_kbdfi_tclMsgAuxInInfoStatus& coRef);
   midw_kbdfi_tclMsgAuxInInfoStatus(const midw_kbdfi_tclMsgAuxInInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8AuxInInfo AuxInInfo;
   virtual ~midw_kbdfi_tclMsgAuxInInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgAuxInInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyRepeatTimeUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyRepeatTimeUpReg();

   virtual ~midw_kbdfi_tclMsgKeyRepeatTimeUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyRepeatTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg();

   virtual ~midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyRepeatTimeSet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyRepeatTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgKeyRepeatTimeSet& operator=(const midw_kbdfi_tclMsgKeyRepeatTimeSet& coRef);
   midw_kbdfi_tclMsgKeyRepeatTimeSet(const midw_kbdfi_tclMsgKeyRepeatTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RepeatTime;
   virtual ~midw_kbdfi_tclMsgKeyRepeatTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgKeyRepeatTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyRepeatTimeGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyRepeatTimeGet();

   virtual ~midw_kbdfi_tclMsgKeyRepeatTimeGet();

   inline tBool operator==(const midw_kbdfi_tclMsgKeyRepeatTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgKeyRepeatTimeStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgKeyRepeatTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgKeyRepeatTimeStatus& operator=(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& coRef);
   midw_kbdfi_tclMsgKeyRepeatTimeStatus(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RepeatTime;
   virtual ~midw_kbdfi_tclMsgKeyRepeatTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastReleasedKeyGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastReleasedKeyGet();

   virtual ~midw_kbdfi_tclMsgLastReleasedKeyGet();

   inline tBool operator==(const midw_kbdfi_tclMsgLastReleasedKeyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastReleasedKeyStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastReleasedKeyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastReleasedKeyStatus& operator=(const midw_kbdfi_tclMsgLastReleasedKeyStatus& coRef);
   midw_kbdfi_tclMsgLastReleasedKeyStatus(const midw_kbdfi_tclMsgLastReleasedKeyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_KeyCode LastReleasedKeyCode;
   virtual ~midw_kbdfi_tclMsgLastReleasedKeyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastReleasedKeyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastUsedEncoderGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastUsedEncoderGet();

   virtual ~midw_kbdfi_tclMsgLastUsedEncoderGet();

   inline tBool operator==(const midw_kbdfi_tclMsgLastUsedEncoderGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastUsedEncoderStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastUsedEncoderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastUsedEncoderStatus& operator=(const midw_kbdfi_tclMsgLastUsedEncoderStatus& coRef);
   midw_kbdfi_tclMsgLastUsedEncoderStatus(const midw_kbdfi_tclMsgLastUsedEncoderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EncoderCode LastUsedEncoderCode;
   virtual ~midw_kbdfi_tclMsgLastUsedEncoderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastUsedEncoderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastUsedEncoderInfoGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastUsedEncoderInfoGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastUsedEncoderInfoGet& operator=(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& coRef);
   midw_kbdfi_tclMsgLastUsedEncoderInfoGet(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyEnc KeyEncoder;
   virtual ~midw_kbdfi_tclMsgLastUsedEncoderInfoGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastUsedEncoderInfoStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastUsedEncoderInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& operator=(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& coRef);
   midw_kbdfi_tclMsgLastUsedEncoderInfoStatus(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyEnc KeyEncoder;
   virtual ~midw_kbdfi_tclMsgLastUsedEncoderInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastPressedKeyGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastPressedKeyGet();

   virtual ~midw_kbdfi_tclMsgLastPressedKeyGet();

   inline tBool operator==(const midw_kbdfi_tclMsgLastPressedKeyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastPressedKeySet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastPressedKeySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastPressedKeySet& operator=(const midw_kbdfi_tclMsgLastPressedKeySet& coRef);
   midw_kbdfi_tclMsgLastPressedKeySet(const midw_kbdfi_tclMsgLastPressedKeySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_KeyCode KeyCode;
   virtual ~midw_kbdfi_tclMsgLastPressedKeySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastPressedKeySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgLastPressedKeyStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgLastPressedKeyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgLastPressedKeyStatus& operator=(const midw_kbdfi_tclMsgLastPressedKeyStatus& coRef);
   midw_kbdfi_tclMsgLastPressedKeyStatus(const midw_kbdfi_tclMsgLastPressedKeyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_KeyCode LastPressedKeyCode;
   virtual ~midw_kbdfi_tclMsgLastPressedKeyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgLastPressedKeyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg();

   virtual ~midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg();

   virtual ~midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet();

   virtual ~midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& operator=(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& coRef);
   midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DiagKeyList KeyList;
   midw_fi_tcl_DiagEncoderStatusList EncoderStatusList;
   midw_fi_tcl_DiagCANStatus LastCANStatus;
   tU8 LastCradleStatus;
   midw_fi_tcl_e8_KeyAttr OnTipperStatus;
   virtual ~midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedKeysUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedKeysUpReg();

   virtual ~midw_kbdfi_tclMsgDiagPressedKeysUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedKeysUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedKeysRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedKeysRelUpReg();

   virtual ~midw_kbdfi_tclMsgDiagPressedKeysRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedKeysRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedKeysGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedKeysGet();

   virtual ~midw_kbdfi_tclMsgDiagPressedKeysGet();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedKeysGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedKeysStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedKeysStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgDiagPressedKeysStatus& operator=(const midw_kbdfi_tclMsgDiagPressedKeysStatus& coRef);
   midw_kbdfi_tclMsgDiagPressedKeysStatus(const midw_kbdfi_tclMsgDiagPressedKeysStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_KeyList KeyList;
   virtual ~midw_kbdfi_tclMsgDiagPressedKeysStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgDiagPressedKeysStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagEncoderStatusUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagEncoderStatusUpReg();

   virtual ~midw_kbdfi_tclMsgDiagEncoderStatusUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagEncoderStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg();

   virtual ~midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagEncoderStatusGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagEncoderStatusGet();

   virtual ~midw_kbdfi_tclMsgDiagEncoderStatusGet();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagEncoderStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagEncoderStatusStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagEncoderStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgDiagEncoderStatusStatus& operator=(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& coRef);
   midw_kbdfi_tclMsgDiagEncoderStatusStatus(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_EncoderValuesList EncoderValuesList;
   virtual ~midw_kbdfi_tclMsgDiagEncoderStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg();

   virtual ~midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg();

   virtual ~midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedTouchPositionsGet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedTouchPositionsGet();

   virtual ~midw_kbdfi_tclMsgDiagPressedTouchPositionsGet();

   inline tBool operator==(const midw_kbdfi_tclMsgDiagPressedTouchPositionsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& operator=(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& coRef);
   midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TouchCoordinateList TouchCoordinateList;
   virtual ~midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlUpReg();

   virtual ~midw_kbdfi_tclMsgAudioControlUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAudioControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlRelUpReg();

   virtual ~midw_kbdfi_tclMsgAudioControlRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAudioControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgAudioControlStatus& operator=(const midw_kbdfi_tclMsgAudioControlStatus& coRef);
   midw_kbdfi_tclMsgAudioControlStatus(const midw_kbdfi_tclMsgAudioControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EXT_RD_StatusAction Action;
   midw_fi_tcl_e8_EXT_RD_AudioControl ControlType;
   virtual ~midw_kbdfi_tclMsgAudioControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgAudioControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlSet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgAudioControlSet& operator=(const midw_kbdfi_tclMsgAudioControlSet& coRef);
   midw_kbdfi_tclMsgAudioControlSet(const midw_kbdfi_tclMsgAudioControlSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EXT_RD_SetReason Reason;
   tBool DataValid;
   midw_fi_tcl_e8_EXT_RD_AudioControlResult ControlResult;
   virtual ~midw_kbdfi_tclMsgAudioControlSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgAudioControlSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg();

   virtual ~midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg();

   virtual ~midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg();

   inline tBool operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlSelectListEntryStatus : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlSelectListEntryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& operator=(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& coRef);
   midw_kbdfi_tclMsgAudioControlSelectListEntryStatus(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EXT_RD_StatusAction Action;
   tU32 UniqueListID;
   tU16 ListSelection;
   virtual ~midw_kbdfi_tclMsgAudioControlSelectListEntryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_kbdfi_tclMsgAudioControlSelectListEntrySet : public midw_kbdfi_tclMsgBaseMessage
{
public:

   midw_kbdfi_tclMsgAudioControlSelectListEntrySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_kbdfi_tclMsgAudioControlSelectListEntrySet& operator=(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& coRef);
   midw_kbdfi_tclMsgAudioControlSelectListEntrySet(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EXT_RD_SetReason Reason;
   tBool DataValid;
   tBool Result;
   virtual ~midw_kbdfi_tclMsgAudioControlSelectListEntrySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
