#ifndef MIDW_KBDFILANGUAGE_HEADER
#define MIDW_KBDFILANGUAGE_HEADER

class midw_kbdfi_tclInContext;
class midw_kbdfi_tclOutContext;
class midw_kbdfi_tclVisitorBase;

class MY_DECL midw_kbdfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  midw_kbdfi_tclDescription(fi_tclInContext* poIn, midw_kbdfi_tclVisitorBase* poVisit);
  midw_kbdfi_tclDescription(fi_tclOutContext* poOut, midw_kbdfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(midw_kbdfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(midw_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ midw_kbdfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  midw_kbdfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<midw_kbdfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<midw_kbdfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline midw_kbdfi_tclDescription::midw_kbdfi_tclDescription(fi_tclInContext* poIn, midw_kbdfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline midw_kbdfi_tclDescription::midw_kbdfi_tclDescription(fi_tclOutContext* poOut, midw_kbdfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

