#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_KBDFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_kbdfi_tclDescription::bInitMessage(midw_kbdfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_kbdfi_tclToken::EN_LAST_TOKEN:
   case midw_kbdfi_tclToken::EN_LIST:
   case midw_kbdfi_tclToken::EN_END_OF_STRUCT:
   case midw_kbdfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_CALIBRATIONTYPE,midw_kbdfi_tclSemanticDomain::EN_MSG_E8CALIBRATIONTYPE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_VDKBD_METHODRESULT,midw_kbdfi_tclSemanticDomain::EN_MSG_E8METHODRESULT)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYINFO,midw_kbdfi_tclSemanticDomain::EN_MSG_SIMULATEDKEYDATA)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYINFO,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYINFO)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYATTR,midw_kbdfi_tclSemanticDomain::EN_MSG_E8KEYATTR)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYENC,midw_kbdfi_tclSemanticDomain::EN_MSG_SIMULATEDKEYDATA)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYENC,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYENCODER)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_CALIBRATIONPOINT,midw_kbdfi_tclSemanticDomain::EN_MSG_OCALIBRATIONPOINT)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_BOOL,midw_kbdfi_tclSemanticDomain::EN_MSG_BSETSUCCESS)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGESTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_PAGEINDEX,midw_kbdfi_tclSemanticDomain::EN_MSG_E8PAGE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_CALIBSTATUSTOHMI,midw_kbdfi_tclSemanticDomain::EN_MSG_E8CALIBRATIONSTSTOHMI)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_FASCIAIDSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_STRING,midw_kbdfi_tclSemanticDomain::EN_MSG_TSFASCIAID)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_DISPTOUCHINFO,midw_kbdfi_tclSemanticDomain::EN_MSG_TOUCHINFO)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_AUXININFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8AUXININFO,midw_kbdfi_tclSemanticDomain::EN_MSG_AUXININFO)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_MSG_REPEATTIME)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_MSG_REPEATTIME)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYCODE,midw_kbdfi_tclSemanticDomain::EN_MSG_LASTRELEASEDKEYCODE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_ENCODERCODE,midw_kbdfi_tclSemanticDomain::EN_MSG_LASTUSEDENCODERCODE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOGET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYENC,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYENCODER)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYENC,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYENCODER)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYCODE,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYCODE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYCODE,midw_kbdfi_tclSemanticDomain::EN_MSG_LASTPRESSEDKEYCODE)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYATTR,midw_kbdfi_tclSemanticDomain::EN_MSG_ONTIPPERSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_MSG_LASTCRADLESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_DIAGCANSTATUS,midw_kbdfi_tclSemanticDomain::EN_MSG_LASTCANSTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_DIAGENCODERSTATUSLIST,midw_kbdfi_tclSemanticDomain::EN_MSG_ENCODERSTATUSLIST)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_DIAGKEYLIST,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYLIST)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_KEYLIST,midw_kbdfi_tclSemanticDomain::EN_MSG_KEYLIST)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_ENCODERVALUESLIST,midw_kbdfi_tclSemanticDomain::EN_MSG_ENCODERVALUESLIST)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_TOUCHCOORDINATELIST,midw_kbdfi_tclSemanticDomain::EN_MSG_TOUCHCOORDINATELIST)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROL,midw_kbdfi_tclSemanticDomain::EN_MSG_CONTROLTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_STATUSACTION,midw_kbdfi_tclSemanticDomain::EN_MSG_ACTION)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROLRESULT,midw_kbdfi_tclSemanticDomain::EN_MSG_CONTROLRESULT)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_BOOL,midw_kbdfi_tclSemanticDomain::EN_MSG_DATAVALID)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_SETREASON,midw_kbdfi_tclSemanticDomain::EN_MSG_REASON)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSTATUS:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_MSG_LISTSELECTION)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U32,midw_kbdfi_tclSemanticDomain::EN_MSG_UNIQUELISTID)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_STATUSACTION,midw_kbdfi_tclSemanticDomain::EN_MSG_ACTION)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSET:
   {
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_BOOL,midw_kbdfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_BOOL,midw_kbdfi_tclSemanticDomain::EN_MSG_DATAVALID)) && bResult;
      bResult = oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_EXT_RD_SETREASON,midw_kbdfi_tclSemanticDomain::EN_MSG_REASON)) && bResult;
   } break;
   case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODABORT:
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOUPREG:
   case midw_kbdfi_tclToken::EN_MSG_KEYINFORELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTUPREG:
   case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOUPREG:
   case midw_kbdfi_tclToken::EN_MSG_ENCODERINFORELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGEUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGERELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSUPREG:
   case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_FASCIAIDUPREG:
   case midw_kbdfi_tclToken::EN_MSG_FASCIAIDRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOUPREG:
   case midw_kbdfi_tclToken::EN_MSG_TOUCHINFORELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOGET:
   case midw_kbdfi_tclToken::EN_MSG_AUXININFOUPREG:
   case midw_kbdfi_tclToken::EN_MSG_AUXININFORELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_AUXININFOGET:
   case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEUPREG:
   case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMERELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEGET:
   case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYGET:
   case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERGET:
   case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYGET:
   case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSGET:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSGET:
   case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSGET:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSGET:
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLUPREG:
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLRELUPREG:
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYUPREG:
   case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYRELUPREG:
   case midw_kbdfi_tclToken::EN_BINCONTAINER:
   case midw_kbdfi_tclToken::EN_E8_TOUCHATTR:
   case midw_kbdfi_tclToken::EN_E8_KEYATTR:
   case midw_kbdfi_tclToken::EN_DISPTOUCHINFO:
   case midw_kbdfi_tclToken::EN_E8_KEYCODE:
   case midw_kbdfi_tclToken::EN_KEYINFO:
   case midw_kbdfi_tclToken::EN_E8_ENCODERCODE:
   case midw_kbdfi_tclToken::EN_E8_ENCODERDIRECTION:
   case midw_kbdfi_tclToken::EN_KEYENC:
   case midw_kbdfi_tclToken::EN_E8AUXININFO:
   case midw_kbdfi_tclToken::EN_DIAGCANSTATUS:
   case midw_kbdfi_tclToken::EN_DIAGENCODERSTATUS:
   case midw_kbdfi_tclToken::EN_DIAGKEYLIST:
   case midw_kbdfi_tclToken::EN_KEYLIST:
   case midw_kbdfi_tclToken::EN_ENCODERVALUESLIST:
   case midw_kbdfi_tclToken::EN_TOUCHCOORDINATELIST:
   case midw_kbdfi_tclToken::EN_DIAGENCODERSTATUSLIST:
   case midw_kbdfi_tclToken::EN_E8_EXT_RD_STATUSACTION:
   case midw_kbdfi_tclToken::EN_E8_EXT_RD_SETREASON:
   case midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROL:
   case midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROLRESULT:
   case midw_kbdfi_tclToken::EN_E8_PAGEINDEX:
   case midw_kbdfi_tclToken::EN_E8_CALIBSTATUSTOHMI:
   case midw_kbdfi_tclToken::EN_CALIBRATIONPOINT:
   case midw_kbdfi_tclToken::EN_E8_VDKBD_METHODRESULT:
   case midw_kbdfi_tclToken::EN_E8_CALIBRATIONTYPE:
   case midw_kbdfi_tclToken::EN_U8:   
   case midw_kbdfi_tclToken::EN_S8:   
   case midw_kbdfi_tclToken::EN_U16:   
   case midw_kbdfi_tclToken::EN_S16:   
   case midw_kbdfi_tclToken::EN_U24:   
   case midw_kbdfi_tclToken::EN_S24:   
   case midw_kbdfi_tclToken::EN_U32:   
   case midw_kbdfi_tclToken::EN_S32:   
   case midw_kbdfi_tclToken::EN_U64:   
   case midw_kbdfi_tclToken::EN_S64:   
   case midw_kbdfi_tclToken::EN_F32:   
   case midw_kbdfi_tclToken::EN_F64:   
   case midw_kbdfi_tclToken::EN_BOOL:   
   case midw_kbdfi_tclToken::EN_STRING:   
   case midw_kbdfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(enMsgToken,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_kbdfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_kbdfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_kbdfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_kbdfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_kbdfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_kbdfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_kbdfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_kbdfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_kbdfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_kbdfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_kbdfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_kbdfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODSTART:
      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODABORT:
      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODRESULT:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFORELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOSET:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOUPREG:
      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFORELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSET:
      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSET:
      case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGEUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGERELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGESTATUS:
      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSUPREG:
      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDUPREG:
      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOUPREG:
      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFORELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOGET:
      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_AUXININFOUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUXININFORELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUXININFOGET:
      case midw_kbdfi_tclToken::EN_MSG_AUXININFOSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMERELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESET:
      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEGET:
      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESTATUS:
      case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYGET:
      case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERGET:
      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOGET:
      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYGET:
      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSET:
      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSGET:
      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSGET:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSGET:
      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSGET:
      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSET:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYRELUPREG:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSTATUS:
      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSET:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_kbdfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8_TOUCHATTR:
      {
         midw_fi_tcl_e8_TouchAttr o_e8_TouchAttr;
         if (!bDoIt(o_e8_TouchAttr))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_KEYATTR:
      {
         midw_fi_tcl_e8_KeyAttr o_e8_KeyAttr;
         if (!bDoIt(o_e8_KeyAttr))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_DISPTOUCHINFO:
      {
      if (poVisitor->bDoExpand_DispTouchInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_U16TIME));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_S16,midw_kbdfi_tclSemanticDomain::EN_S16COORDINATEY));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_S16,midw_kbdfi_tclSemanticDomain::EN_S16COORDINATEX));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_TOUCHATTR,midw_kbdfi_tclSemanticDomain::EN_E8TOUCHATTR));
      }
      else
      {
         midw_fi_tcl_DispTouchInfo o_DispTouchInfo;
         if (!bDoIt(o_DispTouchInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DispTouchInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DispTouchInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8_KEYCODE:
      {
         midw_fi_tcl_e8_KeyCode o_e8_KeyCode;
         if (!bDoIt(o_e8_KeyCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_KEYINFO:
      {
      if (poVisitor->bDoExpand_KeyInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_U16TIME));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYCODE,midw_kbdfi_tclSemanticDomain::EN_E8KEYCODE));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYATTR,midw_kbdfi_tclSemanticDomain::EN_E8KEYATTR));
      }
      else
      {
         midw_fi_tcl_KeyInfo o_KeyInfo;
         if (!bDoIt(o_KeyInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8_ENCODERCODE:
      {
         midw_fi_tcl_e8_EncoderCode o_e8_EncoderCode;
         if (!bDoIt(o_e8_EncoderCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_ENCODERDIRECTION:
      {
         midw_fi_tcl_e8_EncoderDirection o_e8_EncoderDirection;
         if (!bDoIt(o_e8_EncoderDirection))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_KEYENC:
      {
      if (poVisitor->bDoExpand_KeyEnc(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8STEPS));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_ENCODERCODE,midw_kbdfi_tclSemanticDomain::EN_E8ENCODERCODE));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_ENCODERDIRECTION,midw_kbdfi_tclSemanticDomain::EN_E8ENCODERDIRECTION));
      }
      else
      {
         midw_fi_tcl_KeyEnc o_KeyEnc;
         if (!bDoIt(o_KeyEnc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyEnc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyEnc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8AUXININFO:
      {
         midw_fi_tcl_e8AuxInInfo o_e8AuxInInfo;
         if (!bDoIt(o_e8AuxInInfo))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_DIAGCANSTATUS:
      {
      if (poVisitor->bDoExpand_DiagCANStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8CAN3));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8CAN2));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8CAN1));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8CAN0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U32,midw_kbdfi_tclSemanticDomain::EN_U32SIGNALSTATUS));
      }
      else
      {
         midw_fi_tcl_DiagCANStatus o_DiagCANStatus;
         if (!bDoIt(o_DiagCANStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagCANStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagCANStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_DIAGENCODERSTATUS:
      {
      if (poVisitor->bDoExpand_DiagEncoderStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U8,midw_kbdfi_tclSemanticDomain::EN_U8TICKS));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_ENCODERCODE,midw_kbdfi_tclSemanticDomain::EN_E8ENCODERCODE));
      }
      else
      {
         midw_fi_tcl_DiagEncoderStatus o_DiagEncoderStatus;
         if (!bDoIt(o_DiagEncoderStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEncoderStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEncoderStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_DIAGKEYLIST:
      {
      if (poVisitor->bDoExpand_DiagKeyList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_KEYCODE,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_E8KEYCODE));
      }
      else
      {
         midw_fi_tcl_DiagKeyList o_DiagKeyList;
         if (!bDoIt(o_DiagKeyList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagKeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagKeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_KEYLIST:
      {
      if (poVisitor->bDoExpand_KeyList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_KEYCODE));
      }
      else
      {
         midw_fi_tcl_KeyList o_KeyList;
         if (!bDoIt(o_KeyList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_ENCODERVALUESLIST:
      {
      if (poVisitor->bDoExpand_EncoderValuesList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_S8,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_ENCODERVALUE));
      }
      else
      {
         midw_fi_tcl_EncoderValuesList o_EncoderValuesList;
         if (!bDoIt(o_EncoderValuesList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderValuesList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderValuesList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_TOUCHCOORDINATELIST:
      {
      if (poVisitor->bDoExpand_TouchCoordinateList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U32,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_TOUCHPOSITION));
      }
      else
      {
         midw_fi_tcl_TouchCoordinateList o_TouchCoordinateList;
         if (!bDoIt(o_TouchCoordinateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchCoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchCoordinateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_DIAGENCODERSTATUSLIST:
      {
      if (poVisitor->bDoExpand_DiagEncoderStatusList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_DIAGENCODERSTATUS,midw_kbdfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_LIST,midw_kbdfi_tclSemanticDomain::EN_DIAGENCODERSTATUS));
      }
      else
      {
         midw_fi_tcl_DiagEncoderStatusList o_DiagEncoderStatusList;
         if (!bDoIt(o_DiagEncoderStatusList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEncoderStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEncoderStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8_EXT_RD_STATUSACTION:
      {
         midw_fi_tcl_e8_EXT_RD_StatusAction o_e8_EXT_RD_StatusAction;
         if (!bDoIt(o_e8_EXT_RD_StatusAction))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_EXT_RD_SETREASON:
      {
         midw_fi_tcl_e8_EXT_RD_SetReason o_e8_EXT_RD_SetReason;
         if (!bDoIt(o_e8_EXT_RD_SetReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROL:
      {
         midw_fi_tcl_e8_EXT_RD_AudioControl o_e8_EXT_RD_AudioControl;
         if (!bDoIt(o_e8_EXT_RD_AudioControl))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_EXT_RD_AUDIOCONTROLRESULT:
      {
         midw_fi_tcl_e8_EXT_RD_AudioControlResult o_e8_EXT_RD_AudioControlResult;
         if (!bDoIt(o_e8_EXT_RD_AudioControlResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_PAGEINDEX:
      {
         midw_fi_tcl_e8_PageIndex o_e8_PageIndex;
         if (!bDoIt(o_e8_PageIndex))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_CALIBSTATUSTOHMI:
      {
         midw_fi_tcl_e8_CalibStatusToHMI o_e8_CalibStatusToHMI;
         if (!bDoIt(o_e8_CalibStatusToHMI))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_CALIBRATIONPOINT:
      {
      if (poVisitor->bDoExpand_CalibrationPoint(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_END_OF_STRUCT,midw_kbdfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_U16Y));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_U16,midw_kbdfi_tclSemanticDomain::EN_U16X));
         (tVoid) oPath.bGoDown(midw_kbdfi_tclKnot(midw_kbdfi_tclToken::EN_E8_PAGEINDEX,midw_kbdfi_tclSemanticDomain::EN_E8PAGEINDEX));
      }
      else
      {
         midw_fi_tcl_CalibrationPoint o_CalibrationPoint;
         if (!bDoIt(o_CalibrationPoint))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CalibrationPoint.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_kbdfi_tclToken::EN_E8_VDKBD_METHODRESULT:
      {
         midw_fi_tcl_e8_VDKBD_MethodResult o_e8_VDKBD_MethodResult;
         if (!bDoIt(o_e8_VDKBD_MethodResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_E8_CALIBRATIONTYPE:
      {
         midw_fi_tcl_e8_CalibrationType o_e8_CalibrationType;
         if (!bDoIt(o_e8_CalibrationType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_kbdfi_tclToken::EN_UNKNOWN:
      case midw_kbdfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

