/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_HMI_LAYER_SYNCFITYPES_HEADER
#define MIDW_HMI_LAYER_SYNCFITYPES_HEADER


class midw_hmi_layer_syncfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_hmi_layer_sync_fi message types

fi_tclMessageBase* midw_hmi_layer_syncfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_hmi_layer_syncfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_hmi_layer_syncfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& operator=(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& coRef);
   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_ViewType enViewType;
   virtual ~midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& operator=(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& coRef);
   midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ApplicationLayerDetails, std::allocator<midw_fi_tcl_ApplicationLayerDetails> > rListOfLayerDetails;
   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& operator=(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& coRef);
   midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult();

   virtual ~midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& operator=(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& coRef);
   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_AppWindowSettings, std::allocator<midw_fi_tcl_AppWindowSettings> > rAppWindowSettings;
   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& operator=(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& coRef);
   midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& operator=(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& coRef);
   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& operator=(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& coRef);
   midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewStatusUpReg : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewStatusUpReg();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewStatusUpReg();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewStatusGet : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewStatusGet();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewStatusGet();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewStatusStatus : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgViewStatusStatus& operator=(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& coRef);
   midw_hmi_layer_syncfi_tclMsgViewStatusStatus(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_ViewStatus enViewStatus;
   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgViewStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewStatusSet : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgViewStatusSet& operator=(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& coRef);
   midw_hmi_layer_syncfi_tclMsgViewStatusSet(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_ViewStatus enViewStatus;
   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgViewStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewTypeUpReg : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewTypeUpReg();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewTypeUpReg();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewTypeGet : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewTypeGet();

   virtual ~midw_hmi_layer_syncfi_tclMsgViewTypeGet();

   inline tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_layer_syncfi_tclMsgViewTypeStatus : public midw_hmi_layer_syncfi_tclMsgBaseMessage
{
public:

   midw_hmi_layer_syncfi_tclMsgViewTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_layer_syncfi_tclMsgViewTypeStatus& operator=(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& coRef);
   midw_hmi_layer_syncfi_tclMsgViewTypeStatus(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_ViewType enViewType;
   tU32 u32ViewHandle;
   virtual ~midw_hmi_layer_syncfi_tclMsgViewTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
