/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_LAYER_SYNCFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_LAYER_SYNCFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_LAYER_SYNCFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_hmi_layer_sync_fi message types

fi_tclMessageBase* midw_hmi_layer_syncfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_hmi_layer_syncfi_tclToken::EN_MSG_CREATEAPPLICATIONINSTANCEMETHODSTART:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_CREATEAPPLICATIONINSTANCEMETHODRESULT:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_DELETEAPPLICATIONINSTANCEMETHODSTART:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_DELETEAPPLICATIONINSTANCEMETHODRESULT:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLICATIONSETTINGSMETHODSTART:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLICATIONSETTINGSMETHODRESULT:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLYSETTINGSMETHODSTART:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLYSETTINGSMETHODRESULT:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSUPREG:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewStatusUpReg;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSRELUPREG:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSGET:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewStatusGet;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSSTATUS:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewStatusStatus;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSSET:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewStatusSet;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPEUPREG:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewTypeUpReg;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPERELUPREG:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPEGET:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewTypeGet;

      case midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPESTATUS:
         return OSAL_NEW midw_hmi_layer_syncfi_tclMsgViewTypeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_hmi_layer_syncfifi messages

// common functions

tU16 midw_hmi_layer_syncfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_HMI_LAYER_SYNCFI_C_U16_SERVICE_ID;
}

tU16 midw_hmi_layer_syncfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_hmi_layer_syncfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_hmi_layer_syncfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_hmi_layer_syncfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_hmi_layer_syncfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   enViewType = coRef.enViewType;
}
midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::operator=(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   enViewType = coRef.enViewType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart()
:enViewType()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_CREATEAPPLICATIONINSTANCEMETHODSTART;
}


midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::~midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart()
{}

tU32 midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enViewType);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enViewType);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart::operator==(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enViewType == roRef.enViewType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   rListOfLayerDetails = coRef.rListOfLayerDetails;
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::operator=(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   rListOfLayerDetails = coRef.rListOfLayerDetails;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < rListOfLayerDetails.size(); ++u32Idx)
         rListOfLayerDetails[u32Idx].vDestroy();
   rListOfLayerDetails.clear();
   }
}

midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult()

:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_CREATEAPPLICATIONINSTANCEMETHODRESULT;
}


midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::~midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < rListOfLayerDetails.size(); ++u32ListIdx)
      u32DynamicSize += rListOfLayerDetails[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rListOfLayerDetails.size(); ++u32Idx)
      {
         rListOfLayerDetails[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rListOfLayerDetails.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rListOfLayerDetails[u32Idx]);
      }
   }
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)rListOfLayerDetails.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rListOfLayerDetails.size(); ++u32Idx)
         (tVoid) (oOut << rListOfLayerDetails[u32Idx]);
   }
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult::operator==(const midw_hmi_layer_syncfi_tclMsgCreateApplicationInstanceMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (rListOfLayerDetails.size() == roRef.rListOfLayerDetails.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rListOfLayerDetails.size()); ++u32Idx)
            bResult = bResult && (rListOfLayerDetails[u32Idx] == roRef.rListOfLayerDetails[u32Idx]);
      }
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::operator=(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart()
:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_DELETEAPPLICATIONINSTANCEMETHODSTART;
}


midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::~midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart()
{}

tU32 midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart::operator==(const midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult::midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_DELETEAPPLICATIONINSTANCEMETHODRESULT;
}


midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult::~midw_hmi_layer_syncfi_tclMsgDeleteApplicationInstanceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   rAppWindowSettings = coRef.rAppWindowSettings;
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::operator=(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   rAppWindowSettings = coRef.rAppWindowSettings;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < rAppWindowSettings.size(); ++u32Idx)
         rAppWindowSettings[u32Idx].vDestroy();
   rAppWindowSettings.clear();
   }
}

midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart()

:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLICATIONSETTINGSMETHODSTART;
}


midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::~midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(rAppWindowSettings.size()*16);
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < rAppWindowSettings.size(); ++u32Idx)
      {
         rAppWindowSettings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      rAppWindowSettings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> rAppWindowSettings[u32Idx]);
      }
   }
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)rAppWindowSettings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < rAppWindowSettings.size(); ++u32Idx)
         (tVoid) (oOut << rAppWindowSettings[u32Idx]);
   }
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart::operator==(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (rAppWindowSettings.size() == roRef.rAppWindowSettings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < rAppWindowSettings.size()); ++u32Idx)
            bResult = bResult && (rAppWindowSettings[u32Idx] == roRef.rAppWindowSettings[u32Idx]);
      }
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::operator=(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult()
:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLICATIONSETTINGSMETHODRESULT;
}


midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::~midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult()
{}

tU32 midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult::operator==(const midw_hmi_layer_syncfi_tclMsgApplicationSettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::operator=(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart()
:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLYSETTINGSMETHODSTART;
}


midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::~midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart()
{}

tU32 midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart::operator==(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::operator=(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult()
:u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_APPLYSETTINGSMETHODRESULT;
}


midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::~midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult()
{}

tU32 midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult::operator==(const midw_hmi_layer_syncfi_tclMsgApplySettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewStatusUpReg::midw_hmi_layer_syncfi_tclMsgViewStatusUpReg()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSUPREG;
}


midw_hmi_layer_syncfi_tclMsgViewStatusUpReg::~midw_hmi_layer_syncfi_tclMsgViewStatusUpReg()
{}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg::midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSRELUPREG;
}


midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg::~midw_hmi_layer_syncfi_tclMsgViewStatusRelUpReg()
{}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewStatusGet::midw_hmi_layer_syncfi_tclMsgViewStatusGet()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewStatusGet::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSGET;
}


midw_hmi_layer_syncfi_tclMsgViewStatusGet::~midw_hmi_layer_syncfi_tclMsgViewStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgViewStatusStatus::midw_hmi_layer_syncfi_tclMsgViewStatusStatus(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   enViewStatus = coRef.enViewStatus;
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgViewStatusStatus& midw_hmi_layer_syncfi_tclMsgViewStatusStatus::operator=(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   enViewStatus = coRef.enViewStatus;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgViewStatusStatus::midw_hmi_layer_syncfi_tclMsgViewStatusStatus()
:enViewStatus()
,u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSSTATUS;
}


midw_hmi_layer_syncfi_tclMsgViewStatusStatus::~midw_hmi_layer_syncfi_tclMsgViewStatusStatus()
{}

tU32 midw_hmi_layer_syncfi_tclMsgViewStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgViewStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enViewStatus);
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgViewStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enViewStatus);
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgViewStatusStatus::operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enViewStatus == roRef.enViewStatus);
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgViewStatusSet::midw_hmi_layer_syncfi_tclMsgViewStatusSet(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   enViewStatus = coRef.enViewStatus;
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgViewStatusSet& midw_hmi_layer_syncfi_tclMsgViewStatusSet::operator=(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& coRef)
{
   if (this == &coRef) return *this;
   enViewStatus = coRef.enViewStatus;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgViewStatusSet::midw_hmi_layer_syncfi_tclMsgViewStatusSet()
:enViewStatus()
,u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewStatusSet::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWSTATUSSET;
}


midw_hmi_layer_syncfi_tclMsgViewStatusSet::~midw_hmi_layer_syncfi_tclMsgViewStatusSet()
{}

tU32 midw_hmi_layer_syncfi_tclMsgViewStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgViewStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enViewStatus);
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgViewStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enViewStatus);
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgViewStatusSet::operator==(const midw_hmi_layer_syncfi_tclMsgViewStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enViewStatus == roRef.enViewStatus);
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewTypeUpReg::midw_hmi_layer_syncfi_tclMsgViewTypeUpReg()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewTypeUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPEUPREG;
}


midw_hmi_layer_syncfi_tclMsgViewTypeUpReg::~midw_hmi_layer_syncfi_tclMsgViewTypeUpReg()
{}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg::midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPERELUPREG;
}


midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg::~midw_hmi_layer_syncfi_tclMsgViewTypeRelUpReg()
{}

//=============================================================================

midw_hmi_layer_syncfi_tclMsgViewTypeGet::midw_hmi_layer_syncfi_tclMsgViewTypeGet()
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewTypeGet::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPEGET;
}


midw_hmi_layer_syncfi_tclMsgViewTypeGet::~midw_hmi_layer_syncfi_tclMsgViewTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_layer_syncfi_tclMsgViewTypeStatus::midw_hmi_layer_syncfi_tclMsgViewTypeStatus(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& coRef)
   : midw_hmi_layer_syncfi_tclMsgBaseMessage(coRef)
{
   enViewType = coRef.enViewType;
   u32ViewHandle = coRef.u32ViewHandle;
}
midw_hmi_layer_syncfi_tclMsgViewTypeStatus& midw_hmi_layer_syncfi_tclMsgViewTypeStatus::operator=(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   enViewType = coRef.enViewType;
   u32ViewHandle = coRef.u32ViewHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_layer_syncfi_tclMsgViewTypeStatus::midw_hmi_layer_syncfi_tclMsgViewTypeStatus()
:enViewType()
,u32ViewHandle(0)
 {}

tS32 midw_hmi_layer_syncfi_tclMsgViewTypeStatus::s32GetTypeId() const
{
   return (tS32) midw_hmi_layer_syncfi_tclToken::EN_MSG_VIEWTYPESTATUS;
}


midw_hmi_layer_syncfi_tclMsgViewTypeStatus::~midw_hmi_layer_syncfi_tclMsgViewTypeStatus()
{}

tU32 midw_hmi_layer_syncfi_tclMsgViewTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_hmi_layer_syncfi_tclMsgViewTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enViewType);
   (tVoid) (oIn >> u32ViewHandle);
   return oIn;
}

fi_tclOutContext& midw_hmi_layer_syncfi_tclMsgViewTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enViewType);
   (tVoid) (oOut << u32ViewHandle);
   return oOut;
}

tBool midw_hmi_layer_syncfi_tclMsgViewTypeStatus::operator==(const midw_hmi_layer_syncfi_tclMsgViewTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enViewType == roRef.enViewType);
   bResult = bResult && (u32ViewHandle == roRef.u32ViewHandle);
   return bResult;
}

