/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_GESTUREFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_GESTUREFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_GESTUREFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_hmi_gesture_fi message types

fi_tclMessageBase* midw_hmi_gesturefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODSTART:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart;

      case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODRESULT:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult;

      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgGestureEventUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTRELUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgGestureEventRelUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTSET:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgGestureEventSet;

      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTRELUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTSET:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet;

      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgEnableCharRecUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECRELUPREG:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg;

      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSTATUS:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgEnableCharRecStatus;

      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSET:
         return OSAL_NEW midw_hmi_gesturefi_tclMsgEnableCharRecSet;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_hmi_gesturefifi messages

// common functions

tU16 midw_hmi_gesturefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_HMI_GESTUREFI_C_U16_SERVICE_ID;
}

tU16 midw_hmi_gesturefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_hmi_gesturefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_hmi_gesturefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_hmi_gesturefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_hmi_gesturefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   szText = coRef.szText;
}
midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::operator=(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szText = coRef.szText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::vDestroy()
{
   szText.vDestroy();
}

midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart()
:szText()
 {}

tS32 midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODSTART;
}


midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::~midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szText);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szText);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart::operator==(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szText == roRef.szText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   u8Result = coRef.u8Result;
}
midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::operator=(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Result = coRef.u8Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult()
:u8Result(0)
 {}

tS32 midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODRESULT;
}


midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::~midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult()
{}

tU32 midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Result);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Result);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult::operator==(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Result == roRef.u8Result);
   return bResult;
}

//=============================================================================

midw_hmi_gesturefi_tclMsgGestureEventUpReg::midw_hmi_gesturefi_tclMsgGestureEventUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgGestureEventUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTUPREG;
}


midw_hmi_gesturefi_tclMsgGestureEventUpReg::~midw_hmi_gesturefi_tclMsgGestureEventUpReg()
{}

//=============================================================================

midw_hmi_gesturefi_tclMsgGestureEventRelUpReg::midw_hmi_gesturefi_tclMsgGestureEventRelUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgGestureEventRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTRELUPREG;
}


midw_hmi_gesturefi_tclMsgGestureEventRelUpReg::~midw_hmi_gesturefi_tclMsgGestureEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgGestureEventSet::midw_hmi_gesturefi_tclMsgGestureEventSet(const midw_hmi_gesturefi_tclMsgGestureEventSet& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   enGestureType = coRef.enGestureType;
   enGestureEvent = coRef.enGestureEvent;
   enGestureDirection = coRef.enGestureDirection;
   rGesturePoint1 = coRef.rGesturePoint1;
   bPoint1Valid = coRef.bPoint1Valid;
   rGesturePoint2 = coRef.rGesturePoint2;
   bPoint2Valid = coRef.bPoint2Valid;
}
midw_hmi_gesturefi_tclMsgGestureEventSet& midw_hmi_gesturefi_tclMsgGestureEventSet::operator=(const midw_hmi_gesturefi_tclMsgGestureEventSet& coRef)
{
   if (this == &coRef) return *this;
   enGestureType = coRef.enGestureType;
   enGestureEvent = coRef.enGestureEvent;
   enGestureDirection = coRef.enGestureDirection;
   rGesturePoint1 = coRef.rGesturePoint1;
   bPoint1Valid = coRef.bPoint1Valid;
   rGesturePoint2 = coRef.rGesturePoint2;
   bPoint2Valid = coRef.bPoint2Valid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_gesturefi_tclMsgGestureEventSet::midw_hmi_gesturefi_tclMsgGestureEventSet()
:enGestureType()
,enGestureEvent()
,enGestureDirection()
,rGesturePoint1()
,bPoint1Valid(0)
,rGesturePoint2()
,bPoint2Valid(0)
 {}

tS32 midw_hmi_gesturefi_tclMsgGestureEventSet::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTSET;
}


midw_hmi_gesturefi_tclMsgGestureEventSet::~midw_hmi_gesturefi_tclMsgGestureEventSet()
{}

tU32 midw_hmi_gesturefi_tclMsgGestureEventSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 30;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgGestureEventSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enGestureType);
   (tVoid) (oIn >> enGestureEvent);
   (tVoid) (oIn >> enGestureDirection);
   (tVoid) (oIn >> rGesturePoint1);
   (tVoid) (oIn >> bPoint1Valid);
   (tVoid) (oIn >> rGesturePoint2);
   (tVoid) (oIn >> bPoint2Valid);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgGestureEventSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enGestureType);
   (tVoid) (oOut << enGestureEvent);
   (tVoid) (oOut << enGestureDirection);
   (tVoid) (oOut << rGesturePoint1);
   (tVoid) (oOut << bPoint1Valid);
   (tVoid) (oOut << rGesturePoint2);
   (tVoid) (oOut << bPoint2Valid);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgGestureEventSet::operator==(const midw_hmi_gesturefi_tclMsgGestureEventSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enGestureType == roRef.enGestureType);
   bResult = bResult && (enGestureEvent == roRef.enGestureEvent);
   bResult = bResult && (enGestureDirection == roRef.enGestureDirection);
   bResult = bResult && (rGesturePoint1 == roRef.rGesturePoint1);
   bResult = bResult && (bPoint1Valid == roRef.bPoint1Valid);
   bResult = bResult && (rGesturePoint2 == roRef.rGesturePoint2);
   bResult = bResult && (bPoint2Valid == roRef.bPoint2Valid);
   return bResult;
}

//=============================================================================

midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg::midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTUPREG;
}


midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg::~midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg()
{}

//=============================================================================

midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg::midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTRELUPREG;
}


midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg::~midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   enGestureType = coRef.enGestureType;
   enGestureEvent = coRef.enGestureEvent;
   enGestureDirection = coRef.enGestureDirection;
   rGesturePoint1 = coRef.rGesturePoint1;
   bPoint1Valid = coRef.bPoint1Valid;
   rGesturePoint2 = coRef.rGesturePoint2;
   bPoint2Valid = coRef.bPoint2Valid;
   rGesturePoint3 = coRef.rGesturePoint3;
   bPoint3Valid = coRef.bPoint3Valid;
}
midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::operator=(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& coRef)
{
   if (this == &coRef) return *this;
   enGestureType = coRef.enGestureType;
   enGestureEvent = coRef.enGestureEvent;
   enGestureDirection = coRef.enGestureDirection;
   rGesturePoint1 = coRef.rGesturePoint1;
   bPoint1Valid = coRef.bPoint1Valid;
   rGesturePoint2 = coRef.rGesturePoint2;
   bPoint2Valid = coRef.bPoint2Valid;
   rGesturePoint3 = coRef.rGesturePoint3;
   bPoint3Valid = coRef.bPoint3Valid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet()
:enGestureType()
,enGestureEvent()
,enGestureDirection()
,rGesturePoint1()
,bPoint1Valid(0)
,rGesturePoint2()
,bPoint2Valid(0)
,rGesturePoint3()
,bPoint3Valid(0)
 {}

tS32 midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTSET;
}


midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::~midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet()
{}

tU32 midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 39;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enGestureType);
   (tVoid) (oIn >> enGestureEvent);
   (tVoid) (oIn >> enGestureDirection);
   (tVoid) (oIn >> rGesturePoint1);
   (tVoid) (oIn >> bPoint1Valid);
   (tVoid) (oIn >> rGesturePoint2);
   (tVoid) (oIn >> bPoint2Valid);
   (tVoid) (oIn >> rGesturePoint3);
   (tVoid) (oIn >> bPoint3Valid);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enGestureType);
   (tVoid) (oOut << enGestureEvent);
   (tVoid) (oOut << enGestureDirection);
   (tVoid) (oOut << rGesturePoint1);
   (tVoid) (oOut << bPoint1Valid);
   (tVoid) (oOut << rGesturePoint2);
   (tVoid) (oOut << bPoint2Valid);
   (tVoid) (oOut << rGesturePoint3);
   (tVoid) (oOut << bPoint3Valid);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet::operator==(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enGestureType == roRef.enGestureType);
   bResult = bResult && (enGestureEvent == roRef.enGestureEvent);
   bResult = bResult && (enGestureDirection == roRef.enGestureDirection);
   bResult = bResult && (rGesturePoint1 == roRef.rGesturePoint1);
   bResult = bResult && (bPoint1Valid == roRef.bPoint1Valid);
   bResult = bResult && (rGesturePoint2 == roRef.rGesturePoint2);
   bResult = bResult && (bPoint2Valid == roRef.bPoint2Valid);
   bResult = bResult && (rGesturePoint3 == roRef.rGesturePoint3);
   bResult = bResult && (bPoint3Valid == roRef.bPoint3Valid);
   return bResult;
}

//=============================================================================

midw_hmi_gesturefi_tclMsgEnableCharRecUpReg::midw_hmi_gesturefi_tclMsgEnableCharRecUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgEnableCharRecUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECUPREG;
}


midw_hmi_gesturefi_tclMsgEnableCharRecUpReg::~midw_hmi_gesturefi_tclMsgEnableCharRecUpReg()
{}

//=============================================================================

midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg::midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg()
 {}

tS32 midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECRELUPREG;
}


midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg::~midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgEnableCharRecStatus::midw_hmi_gesturefi_tclMsgEnableCharRecStatus(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   enActionStatus = coRef.enActionStatus;
}
midw_hmi_gesturefi_tclMsgEnableCharRecStatus& midw_hmi_gesturefi_tclMsgEnableCharRecStatus::operator=(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& coRef)
{
   if (this == &coRef) return *this;
   enActionStatus = coRef.enActionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_gesturefi_tclMsgEnableCharRecStatus::midw_hmi_gesturefi_tclMsgEnableCharRecStatus()
:enActionStatus()
 {}

tS32 midw_hmi_gesturefi_tclMsgEnableCharRecStatus::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSTATUS;
}


midw_hmi_gesturefi_tclMsgEnableCharRecStatus::~midw_hmi_gesturefi_tclMsgEnableCharRecStatus()
{}

tU32 midw_hmi_gesturefi_tclMsgEnableCharRecStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgEnableCharRecStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enActionStatus);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgEnableCharRecStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enActionStatus);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgEnableCharRecStatus::operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enActionStatus == roRef.enActionStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_hmi_gesturefi_tclMsgEnableCharRecSet::midw_hmi_gesturefi_tclMsgEnableCharRecSet(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& coRef)
   : midw_hmi_gesturefi_tclMsgBaseMessage(coRef)
{
   enAction = coRef.enAction;
}
midw_hmi_gesturefi_tclMsgEnableCharRecSet& midw_hmi_gesturefi_tclMsgEnableCharRecSet::operator=(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& coRef)
{
   if (this == &coRef) return *this;
   enAction = coRef.enAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_hmi_gesturefi_tclMsgEnableCharRecSet::midw_hmi_gesturefi_tclMsgEnableCharRecSet()
:enAction()
 {}

tS32 midw_hmi_gesturefi_tclMsgEnableCharRecSet::s32GetTypeId() const
{
   return (tS32) midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSET;
}


midw_hmi_gesturefi_tclMsgEnableCharRecSet::~midw_hmi_gesturefi_tclMsgEnableCharRecSet()
{}

tU32 midw_hmi_gesturefi_tclMsgEnableCharRecSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_hmi_gesturefi_tclMsgEnableCharRecSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enAction);
   return oIn;
}

fi_tclOutContext& midw_hmi_gesturefi_tclMsgEnableCharRecSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enAction);
   return oOut;
}

tBool midw_hmi_gesturefi_tclMsgEnableCharRecSet::operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enAction == roRef.enAction);
   return bResult;
}

