#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HMI_GESTUREFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_hmi_gesturefi_tclDescription::bInitMessage(midw_hmi_gesturefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_hmi_gesturefi_tclToken::EN_LAST_TOKEN:
   case midw_hmi_gesturefi_tclToken::EN_LIST:
   case midw_hmi_gesturefi_tclToken::EN_END_OF_STRUCT:
   case midw_hmi_gesturefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_STRING,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_SZTEXT)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_U8,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_U8RESULT)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTSET:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_BOOL,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_BPOINT2VALID)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_RGESTUREPOINT2)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_BOOL,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_BPOINT1VALID)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_RGESTUREPOINT1)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_DIRECTION,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTUREDIRECTION)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_EVENT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTUREEVENT)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_TYPE,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTURETYPE)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTSET:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_BOOL,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_BPOINT3VALID)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_RGESTUREPOINT3)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_BOOL,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_BPOINT2VALID)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_RGESTUREPOINT2)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_BOOL,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_BPOINT1VALID)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_RGESTUREPOINT1)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_DIRECTION,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTUREDIRECTION)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_EVENT,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTUREEVENT)) && bResult;
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_TOUCHPAD_GESTURE_TYPE,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENGESTURETYPE)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSTATUS:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTIONSTATUS,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENACTIONSTATUS)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSET:
   {
      bResult = oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTION,midw_hmi_gesturefi_tclSemanticDomain::EN_MSG_ENACTION)) && bResult;
   } break;
   case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTUPREG:
   case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTRELUPREG:
   case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTUPREG:
   case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTRELUPREG:
   case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECUPREG:
   case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECRELUPREG:
   case midw_hmi_gesturefi_tclToken::EN_BINCONTAINER:
   case midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_TYPE:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_TOUCHPAD_GESTURE_TYPE:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_EVENT:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_DIRECTION:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTION:
   case midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTIONSTATUS:
   case midw_hmi_gesturefi_tclToken::EN_U8:   
   case midw_hmi_gesturefi_tclToken::EN_S8:   
   case midw_hmi_gesturefi_tclToken::EN_U16:   
   case midw_hmi_gesturefi_tclToken::EN_S16:   
   case midw_hmi_gesturefi_tclToken::EN_U24:   
   case midw_hmi_gesturefi_tclToken::EN_S24:   
   case midw_hmi_gesturefi_tclToken::EN_U32:   
   case midw_hmi_gesturefi_tclToken::EN_S32:   
   case midw_hmi_gesturefi_tclToken::EN_U64:   
   case midw_hmi_gesturefi_tclToken::EN_S64:   
   case midw_hmi_gesturefi_tclToken::EN_F32:   
   case midw_hmi_gesturefi_tclToken::EN_F64:   
   case midw_hmi_gesturefi_tclToken::EN_BOOL:   
   case midw_hmi_gesturefi_tclToken::EN_STRING:   
   case midw_hmi_gesturefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(enMsgToken,midw_hmi_gesturefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_hmi_gesturefi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_hmi_gesturefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_hmi_gesturefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_hmi_gesturefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_hmi_gesturefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_hmi_gesturefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_hmi_gesturefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_hmi_gesturefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_hmi_gesturefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_hmi_gesturefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_hmi_gesturefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_hmi_gesturefi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_hmi_gesturefi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODSTART:
      case midw_hmi_gesturefi_tclToken::EN_MSG_SETCHARRECTEXTMETHODRESULT:
      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTRELUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_GESTUREEVENTSET:
      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTRELUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_TOUCHPADGESTUREEVENTSET:
      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECRELUPREG:
      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSTATUS:
      case midw_hmi_gesturefi_tclToken::EN_MSG_ENABLECHARRECSET:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_hmi_gesturefi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_END_OF_STRUCT,midw_hmi_gesturefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_U8,midw_hmi_gesturefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_LIST,midw_hmi_gesturefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_hmi_gesturefi_tclToken::EN_HMI_GUI_POINT:
      {
      if (poVisitor->bDoExpand_HMI_GUI_Point(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_END_OF_STRUCT,midw_hmi_gesturefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_S32,midw_hmi_gesturefi_tclSemanticDomain::EN_S32YCOORDINATE));
         (tVoid) oPath.bGoDown(midw_hmi_gesturefi_tclKnot(midw_hmi_gesturefi_tclToken::EN_S32,midw_hmi_gesturefi_tclSemanticDomain::EN_S32XCOORDINATE));
      }
      else
      {
         midw_fi_tcl_HMI_GUI_Point o_HMI_GUI_Point;
         if (!bDoIt(o_HMI_GUI_Point))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HMI_GUI_Point.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HMI_GUI_Point.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_TYPE:
      {
         midw_fi_tcl_e32_HMI_Gesture_Type o_e32_HMI_Gesture_Type;
         if (!bDoIt(o_e32_HMI_Gesture_Type))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_TOUCHPAD_GESTURE_TYPE:
      {
         midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type o_e32_HMI_Touchpad_Gesture_Type;
         if (!bDoIt(o_e32_HMI_Touchpad_Gesture_Type))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_EVENT:
      {
         midw_fi_tcl_e32_HMI_Gesture_Event o_e32_HMI_Gesture_Event;
         if (!bDoIt(o_e32_HMI_Gesture_Event))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_GESTURE_DIRECTION:
      {
         midw_fi_tcl_e32_HMI_Gesture_Direction o_e32_HMI_Gesture_Direction;
         if (!bDoIt(o_e32_HMI_Gesture_Direction))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTION:
      {
         midw_fi_tcl_e32_HMI_CharRecAction o_e32_HMI_CharRecAction;
         if (!bDoIt(o_e32_HMI_CharRecAction))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_E32_HMI_CHARRECACTIONSTATUS:
      {
         midw_fi_tcl_e32_HMI_CharRecActionStatus o_e32_HMI_CharRecActionStatus;
         if (!bDoIt(o_e32_HMI_CharRecActionStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_hmi_gesturefi_tclToken::EN_UNKNOWN:
      case midw_hmi_gesturefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

