/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_DIMMINGFITYPES_HEADER
#define MIDW_DIMMINGFITYPES_HEADER


class midw_dimmingfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_DIMMING_FI message types

fi_tclMessageBase* midw_dimmingfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_dimmingfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_dimmingfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsMode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefaultSettingsGroup;
   tU8 DefaultSettingsStatus;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Mode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Mode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   midw_fi_tcl_e8_DIM_Status DimmingStatus;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   midw_fi_tcl_e8_DIM_Status DimmingStatus;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LUN;
   midw_fi_tcl_e8_DIM_Status DimmingState;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8_DIM_LUN LUN;
   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8_DIM_LUN LUN;
   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8_DIM_LUN LUN;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8_DIM_LUN LUN;
   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SetDriverInitialized;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SetDriverInitialized;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDriverInitalizedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SetScreenContentAvailable;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SetScreenContentAvailable;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetScreenContentAvailableMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SwitchBacklight;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SwitchBacklight;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SwitchBacklightMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevelDay;
   tU8 VideoBrightnessLevelNight;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevelDay;
   tU8 VideoBrightnessLevelNight;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SetVideoBrightnessLevelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& operator=(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef);
   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType;
   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& operator=(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef);
   midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_InputConfiguration SetBrightnessInputType;
   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_SetBrightnessInputTypeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_DAY_SLIDER DayIllumination;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_DAY_SLIDER DayIllumination;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DAY_SLIDERStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER NightIllumination;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_NIGHT_SLIDER NightIllumination;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_NIGHT_SLIDERStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingMode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODESet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingMode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_MODEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingMode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODESet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingMode DimmingMode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DIAG_EMULATION_MODEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingState DimmingState;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_DimmingFeedback DimmingFeedback;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_DimmingFeedback DimmingFeedback;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_FEEDBACK_LEDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingSDC SDC_LED_State;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DimmingSDC SDC_LED_State;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_SDC_LEDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_PWM_VALUE DimmingPWM;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_PWMStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TroubleCode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLESet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TroubleCode;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_INTERNAL_TROUBLEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 LightSensor;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 III_Disp_NAV;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_DISP_NAVStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 III_BEZ_NAV;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_III_BEZ_NAVStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS UserBrightness;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIMMING_USER_BRIGHTNESS UserBrightness;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_USER_BRIGHTNESSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg();

   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   tU8 DefSetStateMode;
   tBool DefSetStateSuccesful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& operator=(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& coRef);
   midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DefSetStateGroup;
   tU8 DefSetStateMode;
   tBool DefSetStateSuccesful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgFI_VD_DIMMING_DEFAULT_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status IlluminationSwitch;
   midw_fi_tcl_u16_DIM_Permille IlluminationBrightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status SensorAvail;
   midw_fi_tcl_u16_DIM_Permille SensorBrightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_LightSensorBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Mode Config;
   midw_fi_tcl_e8_DIM_Mode Car;
   midw_fi_tcl_e8_DIM_Mode Status;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_EmulationMode EmulationMode;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_EmulationModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_ITCUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_ITCRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_ITCGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_ITCGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_ITCGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_ITCGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_ITCStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_ITCStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_ITCStatus(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ITC;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_ITCStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_ITCStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille PWMBrightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet();

   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& operator=(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef);
   midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille CANBrightness;
   virtual ~midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_INFO_CANBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet();

   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& operator=(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& coRef);
   midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8_DIM_Halfclasses Halfclass_A;
   midw_fi_tcl_u8_DIM_Halfclasses Halfclass_B;
   tU8 ADC_CFG_A;
   tU8 ADC_CFG_B;
   tU16 ADC_A;
   tU16 ADC_B;
   tU16 PWM_HC_A;
   tU16 PWM_HC_B;
   virtual ~midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status DriverInitialized;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_DriverInitalizedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status ContentAvailable;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_ScreenContentAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16_DIM_Permille Brightness;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BacklightUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BacklightRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BacklightGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BacklightGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BacklightGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BacklightGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_Status BacklightStatus;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BacklightStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_s16_DIM_Temperature PanelTemp;
   midw_fi_tcl_s16_DIM_Temperature AmbientTemp;
   midw_fi_tcl_e8_DIM_WarningLevel WarningLevel;
   tU16 CriticalLevelTimeout;
   tU16 CriticalLevelElapsed;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_TemperatureInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SizeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SizeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SizeGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SizeGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SizeGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SizeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_SizeStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_SizeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_SizeStatus(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_DisplaySize Size;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_SizeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_SizeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_BrightnessLevel BrightnessLevel;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_s16_DIM_Temperature Temperature;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BrightnessLevelExtended;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& operator=(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VideoBrightnessLevel;
   virtual ~midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DISP_VideoBrightnessLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_VariantUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_VariantRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_VariantGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_VariantGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_VariantGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_VariantGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& operator=(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Variant;
   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_VariantStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet();

   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet();

   inline tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus : public midw_dimmingfi_tclMsgBaseMessage
{
public:

   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& operator=(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef);
   midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DIM_InputConfiguration InputConfiguration;
   virtual ~midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_dimmingfi_tclMsgDIM_DIAG_BrightnessInputTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
