/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for Midw_Diagnostics_FI message types

fi_tclMessageBase* midw_diagnosticsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgTestMessageMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgTestMessageMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagRequestMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagRequestMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgReadDiagLogMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgReadDiagLogMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDiagLogMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDiagLogMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODSTART:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart;

      case midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODRESULT:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartRouteCalculationSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgStartRouteCalculationStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRouteCalculationResultSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRouteCalculationResultStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleStartSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleStartUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleStartStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleResultSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleResultUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetLocaleResultStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetLocaleSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALEUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetLocaleUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALERELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetLocaleRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetLocaleStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDisplaySet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDisplayUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDisplayRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetDisplayStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_CONFIGUPDATEVIAUSBSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftStatusSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftStatusStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHURELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDestinationMemorySet;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZEUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZERELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSimulateKeyPressSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSimulateKeyPressStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgResetSecuritySet;

      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgResetSecurityUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgResetSecurityRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgResetSecurityStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgLanguageGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgLanguageStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSpeedLockGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSpeedLockStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSpdLockSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSpdLockStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRVCSignalGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRVCSignalSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRVCSignalUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetRVCSignalStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRVCSignalStatusSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRVCSignalStatusStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgKdsEntryGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgKdsEntrySet;

      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgKdsEntryStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgKdsEntryUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgKdsEntryRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagConfigItemGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagConfigItemSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagConfigItemStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagConfigItemUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRemoteControlUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRemoteControlRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRemoteControlGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRemoteControlSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgRemoteControlStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateProcessSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSRELUPREG:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCalibrationParameterGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCalibrationParameterSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgCalibrationParameterStatus;

      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERGET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgPartNumberGet;

      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSET:
         return OSAL_NEW midw_diagnosticsfi_tclMsgPartNumberSet;

      case midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSTATUS:
         return OSAL_NEW midw_diagnosticsfi_tclMsgPartNumberStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_diagnosticsfifi messages

// common functions

tU16 midw_diagnosticsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_DIAGNOSTICSFI_C_U16_SERVICE_ID;
}

tU16 midw_diagnosticsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_diagnosticsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_diagnosticsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_diagnosticsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_diagnosticsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgTestMessageMethodStart::midw_diagnosticsfi_tclMsgTestMessageMethodStart(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ProtocolId = coRef.ProtocolId;
   MessageBuffer = coRef.MessageBuffer;
}
midw_diagnosticsfi_tclMsgTestMessageMethodStart& midw_diagnosticsfi_tclMsgTestMessageMethodStart::operator=(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProtocolId = coRef.ProtocolId;
   MessageBuffer = coRef.MessageBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgTestMessageMethodStart::vDestroy()
{
   MessageBuffer.vDestroy(); 
}

midw_diagnosticsfi_tclMsgTestMessageMethodStart::midw_diagnosticsfi_tclMsgTestMessageMethodStart()
:ProtocolId(0)
,MessageBuffer()
 {}

tS32 midw_diagnosticsfi_tclMsgTestMessageMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODSTART;
}


midw_diagnosticsfi_tclMsgTestMessageMethodStart::~midw_diagnosticsfi_tclMsgTestMessageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgTestMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+MessageBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgTestMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProtocolId);
   (tVoid) (oIn >> MessageBuffer);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgTestMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProtocolId);
   (tVoid) (oOut << MessageBuffer);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgTestMessageMethodStart::operator==(const midw_diagnosticsfi_tclMsgTestMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProtocolId == roRef.ProtocolId);
   bResult = bResult && (MessageBuffer == roRef.MessageBuffer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgTestMessageMethodResult::midw_diagnosticsfi_tclMsgTestMessageMethodResult(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ProtocolId = coRef.ProtocolId;
   MessageBuffer = coRef.MessageBuffer;
}
midw_diagnosticsfi_tclMsgTestMessageMethodResult& midw_diagnosticsfi_tclMsgTestMessageMethodResult::operator=(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProtocolId = coRef.ProtocolId;
   MessageBuffer = coRef.MessageBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgTestMessageMethodResult::vDestroy()
{
   MessageBuffer.vDestroy(); 
}

midw_diagnosticsfi_tclMsgTestMessageMethodResult::midw_diagnosticsfi_tclMsgTestMessageMethodResult()
:ProtocolId(0)
,MessageBuffer()
 {}

tS32 midw_diagnosticsfi_tclMsgTestMessageMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_TESTMESSAGEMETHODRESULT;
}


midw_diagnosticsfi_tclMsgTestMessageMethodResult::~midw_diagnosticsfi_tclMsgTestMessageMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgTestMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+MessageBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgTestMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProtocolId);
   (tVoid) (oIn >> MessageBuffer);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgTestMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProtocolId);
   (tVoid) (oOut << MessageBuffer);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgTestMessageMethodResult::operator==(const midw_diagnosticsfi_tclMsgTestMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProtocolId == roRef.ProtocolId);
   bResult = bResult && (MessageBuffer == roRef.MessageBuffer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagRequestMethodStart::midw_diagnosticsfi_tclMsgDiagRequestMethodStart(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   protID = coRef.protID;
   diagData = coRef.diagData;
   cookie = coRef.cookie;
}
midw_diagnosticsfi_tclMsgDiagRequestMethodStart& midw_diagnosticsfi_tclMsgDiagRequestMethodStart::operator=(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   protID = coRef.protID;
   diagData = coRef.diagData;
   cookie = coRef.cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgDiagRequestMethodStart::vDestroy()
{
   diagData.vDestroy(); 
}

midw_diagnosticsfi_tclMsgDiagRequestMethodStart::midw_diagnosticsfi_tclMsgDiagRequestMethodStart()
:protID()
,diagData()
,cookie(0)
 {}

tS32 midw_diagnosticsfi_tclMsgDiagRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODSTART;
}


midw_diagnosticsfi_tclMsgDiagRequestMethodStart::~midw_diagnosticsfi_tclMsgDiagRequestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgDiagRequestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+diagData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> protID);
   (tVoid) (oIn >> diagData);
   (tVoid) (oIn >> cookie);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << protID);
   (tVoid) (oOut << diagData);
   (tVoid) (oOut << cookie);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagRequestMethodStart::operator==(const midw_diagnosticsfi_tclMsgDiagRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (protID == roRef.protID);
   bResult = bResult && (diagData == roRef.diagData);
   bResult = bResult && (cookie == roRef.cookie);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagRequestMethodResult::midw_diagnosticsfi_tclMsgDiagRequestMethodResult(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   protID = coRef.protID;
   diagData = coRef.diagData;
   cookie = coRef.cookie;
}
midw_diagnosticsfi_tclMsgDiagRequestMethodResult& midw_diagnosticsfi_tclMsgDiagRequestMethodResult::operator=(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   protID = coRef.protID;
   diagData = coRef.diagData;
   cookie = coRef.cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgDiagRequestMethodResult::vDestroy()
{
   diagData.vDestroy(); 
}

midw_diagnosticsfi_tclMsgDiagRequestMethodResult::midw_diagnosticsfi_tclMsgDiagRequestMethodResult()
:protID()
,diagData()
,cookie(0)
 {}

tS32 midw_diagnosticsfi_tclMsgDiagRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGREQUESTMETHODRESULT;
}


midw_diagnosticsfi_tclMsgDiagRequestMethodResult::~midw_diagnosticsfi_tclMsgDiagRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgDiagRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+diagData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> protID);
   (tVoid) (oIn >> diagData);
   (tVoid) (oIn >> cookie);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << protID);
   (tVoid) (oOut << diagData);
   (tVoid) (oOut << cookie);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagRequestMethodResult::operator==(const midw_diagnosticsfi_tclMsgDiagRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (protID == roRef.protID);
   bResult = bResult && (diagData == roRef.diagData);
   bResult = bResult && (cookie == roRef.cookie);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::midw_diagnosticsfi_tclMsgReadDiagLogMethodStart(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TroubleCodes = coRef.TroubleCodes;
}
midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::operator=(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodes = coRef.TroubleCodes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::midw_diagnosticsfi_tclMsgReadDiagLogMethodStart()
:TroubleCodes()
 {}

tS32 midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODSTART;
}


midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::~midw_diagnosticsfi_tclMsgReadDiagLogMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodes);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodes);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgReadDiagLogMethodStart::operator==(const midw_diagnosticsfi_tclMsgReadDiagLogMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodes == roRef.TroubleCodes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::midw_diagnosticsfi_tclMsgReadDiagLogMethodResult(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TroubleCodes = coRef.TroubleCodes;
   TroubleCodeList = coRef.TroubleCodeList;
}
midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::operator=(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodes = coRef.TroubleCodes;
   TroubleCodeList = coRef.TroubleCodeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::vDestroy()
{
   TroubleCodeList.vDestroy(); 
}

midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::midw_diagnosticsfi_tclMsgReadDiagLogMethodResult()
:TroubleCodes()
,TroubleCodeList()
 {}

tS32 midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_READDIAGLOGMETHODRESULT;
}


midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::~midw_diagnosticsfi_tclMsgReadDiagLogMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+TroubleCodeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodes);
   (tVoid) (oIn >> TroubleCodeList);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodes);
   (tVoid) (oOut << TroubleCodeList);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgReadDiagLogMethodResult::operator==(const midw_diagnosticsfi_tclMsgReadDiagLogMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodes == roRef.TroubleCodes);
   bResult = bResult && (TroubleCodeList == roRef.TroubleCodeList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::midw_diagnosticsfi_tclMsgClearDiagLogMethodStart(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TroubleCodes = coRef.TroubleCodes;
}
midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::operator=(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodes = coRef.TroubleCodes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::midw_diagnosticsfi_tclMsgClearDiagLogMethodStart()
:TroubleCodes()
 {}

tS32 midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODSTART;
}


midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::~midw_diagnosticsfi_tclMsgClearDiagLogMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodes);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodes);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgClearDiagLogMethodStart::operator==(const midw_diagnosticsfi_tclMsgClearDiagLogMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodes == roRef.TroubleCodes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::midw_diagnosticsfi_tclMsgClearDiagLogMethodResult(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TroubleCodes = coRef.TroubleCodes;
}
midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::operator=(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodes = coRef.TroubleCodes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::midw_diagnosticsfi_tclMsgClearDiagLogMethodResult()
:TroubleCodes()
 {}

tS32 midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDIAGLOGMETHODRESULT;
}


midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::~midw_diagnosticsfi_tclMsgClearDiagLogMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodes);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodes);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgClearDiagLogMethodResult::operator==(const midw_diagnosticsfi_tclMsgClearDiagLogMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodes == roRef.TroubleCodes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TestRoutine = coRef.TestRoutine;
}
midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::operator=(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestRoutine = coRef.TestRoutine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart()
:TestRoutine()
 {}

tS32 midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODSTART;
}


midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::~midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutine);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutine);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart::operator==(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutine == roRef.TestRoutine);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TestRoutine = coRef.TestRoutine;
   Success = coRef.Success;
}
midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::operator=(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TestRoutine = coRef.TestRoutine;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult()
:TestRoutine()
,Success(0)
 {}

tS32 midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTDIAGNOSTICTESTMETHODRESULT;
}


midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::~midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutine);
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutine);
   (tVoid) (oOut << Success);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult::operator==(const midw_diagnosticsfi_tclMsgStartDiagnosticTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutine == roRef.TestRoutine);
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SettingsCategory = coRef.SettingsCategory;
}
midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::operator=(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SettingsCategory = coRef.SettingsCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart()
:SettingsCategory()
 {}

tS32 midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODSTART;
}


midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::~midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SettingsCategory);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SettingsCategory);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart::operator==(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SettingsCategory == roRef.SettingsCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SettingsSuccessful = coRef.SettingsSuccessful;
   SettingsCategory = coRef.SettingsCategory;
}
midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::operator=(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SettingsSuccessful = coRef.SettingsSuccessful;
   SettingsCategory = coRef.SettingsCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult()
:SettingsSuccessful(0)
,SettingsCategory()
 {}

tS32 midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDEFAULTSETTINGSMETHODRESULT;
}


midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::~midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SettingsSuccessful);
   (tVoid) (oIn >> SettingsCategory);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SettingsSuccessful);
   (tVoid) (oOut << SettingsCategory);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult::operator==(const midw_diagnosticsfi_tclMsgSetDefaultSettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SettingsSuccessful == roRef.SettingsSuccessful);
   bResult = bResult && (SettingsCategory == roRef.SettingsCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   MausSetup = coRef.MausSetup;
}
midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::operator=(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MausSetup = coRef.MausSetup;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart()
:MausSetup()
 {}

tS32 midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODSTART;
}


midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::~midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MausSetup);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MausSetup);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart::operator==(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MausSetup == roRef.MausSetup);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   EnableSuccessful = coRef.EnableSuccessful;
}
midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::operator=(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& coRef)
{
   if (this == &coRef) return *this;
   EnableSuccessful = coRef.EnableSuccessful;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult()
:EnableSuccessful(0)
 {}

tS32 midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ENABLETIMESLOTMETHODRESULT;
}


midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::~midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EnableSuccessful);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EnableSuccessful);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult::operator==(const midw_diagnosticsfi_tclMsgEnableTimeSlotMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EnableSuccessful == roRef.EnableSuccessful);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TestRoutine = coRef.TestRoutine;
}
midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::operator=(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestRoutine = coRef.TestRoutine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart()
:TestRoutine()
 {}

tS32 midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODSTART;
}


midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::~midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutine);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutine);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart::operator==(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutine == roRef.TestRoutine);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   TestRoutine = coRef.TestRoutine;
   Success = coRef.Success;
}
midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::operator=(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TestRoutine = coRef.TestRoutine;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult()
:TestRoutine()
,Success(0)
 {}

tS32 midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STOPDIAGNOSTICTESTMETHODRESULT;
}


midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::~midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutine);
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutine);
   (tVoid) (oOut << Success);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult::operator==(const midw_diagnosticsfi_tclMsgStopDiagnosticTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutine == roRef.TestRoutine);
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart()
:DefSetStateGroup(0)
,DefSetStateMode()
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODSTART;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::~midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetServiceStatus = coRef.DefSetServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult()
:DefSetStateGroup(0)
,DefSetServiceStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSMETHODRESULT;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::~midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetServiceStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetServiceStatus == roRef.DefSetServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ResetSupplierConfig = coRef.ResetSupplierConfig;
}
midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::operator=(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ResetSupplierConfig = coRef.ResetSupplierConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart()
:ResetSupplierConfig(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODSTART;
}


midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::~midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetSupplierConfig);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetSupplierConfig);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart::operator==(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetSupplierConfig == roRef.ResetSupplierConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefResetServiceStatus = coRef.DefResetServiceStatus;
}
midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::operator=(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefResetServiceStatus = coRef.DefResetServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult()
:DefResetServiceStatus(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRESETTOSUPPLIERDEFAULTCONFIGMETHODRESULT;
}


midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::~midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefResetServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefResetServiceStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult::operator==(const midw_diagnosticsfi_tclMsgSetResetToSupplierDefaultConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefResetServiceStatus == roRef.DefResetServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   RunTimeSourceAppID = coRef.RunTimeSourceAppID;
   RunTimeSourceAppData = coRef.RunTimeSourceAppData;
}
midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::operator=(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RunTimeSourceAppID = coRef.RunTimeSourceAppID;
   RunTimeSourceAppData = coRef.RunTimeSourceAppData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart()
:RunTimeSourceAppID(0)
,RunTimeSourceAppData(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODSTART;
}


midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::~midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RunTimeSourceAppID);
   (tVoid) (oIn >> RunTimeSourceAppData);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RunTimeSourceAppID);
   (tVoid) (oOut << RunTimeSourceAppData);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart::operator==(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RunTimeSourceAppID == roRef.RunTimeSourceAppID);
   bResult = bResult && (RunTimeSourceAppData == roRef.RunTimeSourceAppData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   RunTimeSourceDiagResp = coRef.RunTimeSourceDiagResp;
}
midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::operator=(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RunTimeSourceDiagResp = coRef.RunTimeSourceDiagResp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult()
:RunTimeSourceDiagResp(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRUNTIMESOURCEDATAMETHODRESULT;
}


midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::~midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RunTimeSourceDiagResp);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RunTimeSourceDiagResp);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult::operator==(const midw_diagnosticsfi_tclMsgSetRunTimeSourceDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RunTimeSourceDiagResp == roRef.RunTimeSourceDiagResp);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart()
:DefSetStateGroup(0)
,DefSetStateMode()
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::~midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::~midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Table = coRef.Table;
}
midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::operator=(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Table = coRef.Table;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart()
:Table()
 {}

tS32 midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODSTART;
}


midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::~midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Table);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Table);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart::operator==(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Table == roRef.Table);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Table = coRef.Table;
   SessionHandle = coRef.SessionHandle;
}
midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::operator=(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Table = coRef.Table;
   SessionHandle = coRef.SessionHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult()
:Table()
,SessionHandle(0)
 {}

tS32 midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTCALIBRATIONSESSIONMETHODRESULT;
}


midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::~midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Table);
   (tVoid) (oIn >> SessionHandle);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Table);
   (tVoid) (oOut << SessionHandle);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult::operator==(const midw_diagnosticsfi_tclMsgStartCalibrationSessionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Table == roRef.Table);
   bResult = bResult && (SessionHandle == roRef.SessionHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SessionHandle = coRef.SessionHandle;
   TimeStamp = coRef.TimeStamp;
}
midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::operator=(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SessionHandle = coRef.SessionHandle;
   TimeStamp = coRef.TimeStamp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart()
:SessionHandle(0)
,TimeStamp()
 {}

tS32 midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODSTART;
}


midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::~midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart()
{}

tU32 midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SessionHandle);
   (tVoid) (oIn >> TimeStamp);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SessionHandle);
   (tVoid) (oOut << TimeStamp);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart::operator==(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SessionHandle == roRef.SessionHandle);
   bResult = bResult && (TimeStamp == roRef.TimeStamp);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Table = coRef.Table;
}
midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::operator=(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Table = coRef.Table;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult()
:Table()
 {}

tS32 midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STOPCALIBRATIONSESSIONMETHODRESULT;
}


midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::~midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult()
{}

tU32 midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Table);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Table);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult::operator==(const midw_diagnosticsfi_tclMsgStopCalibrationSessionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Table == roRef.Table);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartRouteCalculationSet::midw_diagnosticsfi_tclMsgStartRouteCalculationSet(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CalculationStarted = coRef.CalculationStarted;
}
midw_diagnosticsfi_tclMsgStartRouteCalculationSet& midw_diagnosticsfi_tclMsgStartRouteCalculationSet::operator=(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& coRef)
{
   if (this == &coRef) return *this;
   CalculationStarted = coRef.CalculationStarted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartRouteCalculationSet::midw_diagnosticsfi_tclMsgStartRouteCalculationSet()
:CalculationStarted(0)
 {}

tS32 midw_diagnosticsfi_tclMsgStartRouteCalculationSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSET;
}


midw_diagnosticsfi_tclMsgStartRouteCalculationSet::~midw_diagnosticsfi_tclMsgStartRouteCalculationSet()
{}

tU32 midw_diagnosticsfi_tclMsgStartRouteCalculationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartRouteCalculationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CalculationStarted);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartRouteCalculationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CalculationStarted);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartRouteCalculationSet::operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CalculationStarted == roRef.CalculationStarted);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg::midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONUPREG;
}


midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg::~midw_diagnosticsfi_tclMsgStartRouteCalculationUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg::midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONRELUPREG;
}


midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg::~midw_diagnosticsfi_tclMsgStartRouteCalculationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::midw_diagnosticsfi_tclMsgStartRouteCalculationStatus(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   RouteDetails = coRef.RouteDetails;
}
midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::operator=(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& coRef)
{
   if (this == &coRef) return *this;
   RouteDetails = coRef.RouteDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::midw_diagnosticsfi_tclMsgStartRouteCalculationStatus()
:RouteDetails()
 {}

tS32 midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_STARTROUTECALCULATIONSTATUS;
}


midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::~midw_diagnosticsfi_tclMsgStartRouteCalculationStatus()
{}

tU32 midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RouteDetails);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RouteDetails);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgStartRouteCalculationStatus::operator==(const midw_diagnosticsfi_tclMsgStartRouteCalculationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RouteDetails == roRef.RouteDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRouteCalculationResultSet::midw_diagnosticsfi_tclMsgRouteCalculationResultSet(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CalculationResult = coRef.CalculationResult;
}
midw_diagnosticsfi_tclMsgRouteCalculationResultSet& midw_diagnosticsfi_tclMsgRouteCalculationResultSet::operator=(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& coRef)
{
   if (this == &coRef) return *this;
   CalculationResult = coRef.CalculationResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRouteCalculationResultSet::midw_diagnosticsfi_tclMsgRouteCalculationResultSet()
:CalculationResult()
 {}

tS32 midw_diagnosticsfi_tclMsgRouteCalculationResultSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSET;
}


midw_diagnosticsfi_tclMsgRouteCalculationResultSet::~midw_diagnosticsfi_tclMsgRouteCalculationResultSet()
{}

tU32 midw_diagnosticsfi_tclMsgRouteCalculationResultSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRouteCalculationResultSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CalculationResult);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRouteCalculationResultSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CalculationResult);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRouteCalculationResultSet::operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CalculationResult == roRef.CalculationResult);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg::midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTUPREG;
}


midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg::~midw_diagnosticsfi_tclMsgRouteCalculationResultUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg::midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTRELUPREG;
}


midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg::~midw_diagnosticsfi_tclMsgRouteCalculationResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::midw_diagnosticsfi_tclMsgRouteCalculationResultStatus(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CalculationResultRequested = coRef.CalculationResultRequested;
}
midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::operator=(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& coRef)
{
   if (this == &coRef) return *this;
   CalculationResultRequested = coRef.CalculationResultRequested;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::midw_diagnosticsfi_tclMsgRouteCalculationResultStatus()
:CalculationResultRequested(0)
 {}

tS32 midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ROUTECALCULATIONRESULTSTATUS;
}


midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::~midw_diagnosticsfi_tclMsgRouteCalculationResultStatus()
{}

tU32 midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CalculationResultRequested);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CalculationResultRequested);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRouteCalculationResultStatus::operator==(const midw_diagnosticsfi_tclMsgRouteCalculationResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CalculationResultRequested == roRef.CalculationResultRequested);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetLocaleStartSet::midw_diagnosticsfi_tclMsgSetLocaleStartSet(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   LocaleSwitched = coRef.LocaleSwitched;
}
midw_diagnosticsfi_tclMsgSetLocaleStartSet& midw_diagnosticsfi_tclMsgSetLocaleStartSet::operator=(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& coRef)
{
   if (this == &coRef) return *this;
   LocaleSwitched = coRef.LocaleSwitched;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetLocaleStartSet::midw_diagnosticsfi_tclMsgSetLocaleStartSet()
:LocaleSwitched(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleStartSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSET;
}


midw_diagnosticsfi_tclMsgSetLocaleStartSet::~midw_diagnosticsfi_tclMsgSetLocaleStartSet()
{}

tU32 midw_diagnosticsfi_tclMsgSetLocaleStartSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetLocaleStartSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LocaleSwitched);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetLocaleStartSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LocaleSwitched);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetLocaleStartSet::operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LocaleSwitched == roRef.LocaleSwitched);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSetLocaleStartUpReg::midw_diagnosticsfi_tclMsgSetLocaleStartUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleStartUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTUPREG;
}


midw_diagnosticsfi_tclMsgSetLocaleStartUpReg::~midw_diagnosticsfi_tclMsgSetLocaleStartUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg::midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTRELUPREG;
}


midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg::~midw_diagnosticsfi_tclMsgSetLocaleStartRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetLocaleStartStatus::midw_diagnosticsfi_tclMsgSetLocaleStartStatus(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CountryLanguage = coRef.CountryLanguage;
   Store = coRef.Store;
}
midw_diagnosticsfi_tclMsgSetLocaleStartStatus& midw_diagnosticsfi_tclMsgSetLocaleStartStatus::operator=(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& coRef)
{
   if (this == &coRef) return *this;
   CountryLanguage = coRef.CountryLanguage;
   Store = coRef.Store;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetLocaleStartStatus::midw_diagnosticsfi_tclMsgSetLocaleStartStatus()
:CountryLanguage()
,Store()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleStartStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALESTARTSTATUS;
}


midw_diagnosticsfi_tclMsgSetLocaleStartStatus::~midw_diagnosticsfi_tclMsgSetLocaleStartStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSetLocaleStartStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetLocaleStartStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryLanguage);
   (tVoid) (oIn >> Store);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetLocaleStartStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryLanguage);
   (tVoid) (oOut << Store);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetLocaleStartStatus::operator==(const midw_diagnosticsfi_tclMsgSetLocaleStartStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryLanguage == roRef.CountryLanguage);
   bResult = bResult && (Store == roRef.Store);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetLocaleResultSet::midw_diagnosticsfi_tclMsgSetLocaleResultSet(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CountryLanguageResult = coRef.CountryLanguageResult;
}
midw_diagnosticsfi_tclMsgSetLocaleResultSet& midw_diagnosticsfi_tclMsgSetLocaleResultSet::operator=(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& coRef)
{
   if (this == &coRef) return *this;
   CountryLanguageResult = coRef.CountryLanguageResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgSetLocaleResultSet::vDestroy()
{
   CountryLanguageResult.vDestroy(); 
}

midw_diagnosticsfi_tclMsgSetLocaleResultSet::midw_diagnosticsfi_tclMsgSetLocaleResultSet()
:CountryLanguageResult()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleResultSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSET;
}


midw_diagnosticsfi_tclMsgSetLocaleResultSet::~midw_diagnosticsfi_tclMsgSetLocaleResultSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgSetLocaleResultSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CountryLanguageResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetLocaleResultSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryLanguageResult);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetLocaleResultSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryLanguageResult);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetLocaleResultSet::operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryLanguageResult == roRef.CountryLanguageResult);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSetLocaleResultUpReg::midw_diagnosticsfi_tclMsgSetLocaleResultUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleResultUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTUPREG;
}


midw_diagnosticsfi_tclMsgSetLocaleResultUpReg::~midw_diagnosticsfi_tclMsgSetLocaleResultUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg::midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTRELUPREG;
}


midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg::~midw_diagnosticsfi_tclMsgSetLocaleResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetLocaleResultStatus::midw_diagnosticsfi_tclMsgSetLocaleResultStatus(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SetLocaleResultRequested = coRef.SetLocaleResultRequested;
}
midw_diagnosticsfi_tclMsgSetLocaleResultStatus& midw_diagnosticsfi_tclMsgSetLocaleResultStatus::operator=(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& coRef)
{
   if (this == &coRef) return *this;
   SetLocaleResultRequested = coRef.SetLocaleResultRequested;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetLocaleResultStatus::midw_diagnosticsfi_tclMsgSetLocaleResultStatus()
:SetLocaleResultRequested(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetLocaleResultStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETLOCALERESULTSTATUS;
}


midw_diagnosticsfi_tclMsgSetLocaleResultStatus::~midw_diagnosticsfi_tclMsgSetLocaleResultStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSetLocaleResultStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetLocaleResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SetLocaleResultRequested);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetLocaleResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SetLocaleResultRequested);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetLocaleResultStatus::operator==(const midw_diagnosticsfi_tclMsgSetLocaleResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SetLocaleResultRequested == roRef.SetLocaleResultRequested);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgGetLocaleSet::midw_diagnosticsfi_tclMsgGetLocaleSet(const midw_diagnosticsfi_tclMsgGetLocaleSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   CountryLanguage = coRef.CountryLanguage;
}
midw_diagnosticsfi_tclMsgGetLocaleSet& midw_diagnosticsfi_tclMsgGetLocaleSet::operator=(const midw_diagnosticsfi_tclMsgGetLocaleSet& coRef)
{
   if (this == &coRef) return *this;
   CountryLanguage = coRef.CountryLanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgGetLocaleSet::midw_diagnosticsfi_tclMsgGetLocaleSet()
:CountryLanguage()
 {}

tS32 midw_diagnosticsfi_tclMsgGetLocaleSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESET;
}


midw_diagnosticsfi_tclMsgGetLocaleSet::~midw_diagnosticsfi_tclMsgGetLocaleSet()
{}

tU32 midw_diagnosticsfi_tclMsgGetLocaleSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgGetLocaleSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryLanguage);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgGetLocaleSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryLanguage);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgGetLocaleSet::operator==(const midw_diagnosticsfi_tclMsgGetLocaleSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryLanguage == roRef.CountryLanguage);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgGetLocaleUpReg::midw_diagnosticsfi_tclMsgGetLocaleUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgGetLocaleUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALEUPREG;
}


midw_diagnosticsfi_tclMsgGetLocaleUpReg::~midw_diagnosticsfi_tclMsgGetLocaleUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgGetLocaleRelUpReg::midw_diagnosticsfi_tclMsgGetLocaleRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgGetLocaleRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALERELUPREG;
}


midw_diagnosticsfi_tclMsgGetLocaleRelUpReg::~midw_diagnosticsfi_tclMsgGetLocaleRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgGetLocaleStatus::midw_diagnosticsfi_tclMsgGetLocaleStatus(const midw_diagnosticsfi_tclMsgGetLocaleStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   GetLocaleRequested = coRef.GetLocaleRequested;
}
midw_diagnosticsfi_tclMsgGetLocaleStatus& midw_diagnosticsfi_tclMsgGetLocaleStatus::operator=(const midw_diagnosticsfi_tclMsgGetLocaleStatus& coRef)
{
   if (this == &coRef) return *this;
   GetLocaleRequested = coRef.GetLocaleRequested;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgGetLocaleStatus::midw_diagnosticsfi_tclMsgGetLocaleStatus()
:GetLocaleRequested(0)
 {}

tS32 midw_diagnosticsfi_tclMsgGetLocaleStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETLOCALESTATUS;
}


midw_diagnosticsfi_tclMsgGetLocaleStatus::~midw_diagnosticsfi_tclMsgGetLocaleStatus()
{}

tU32 midw_diagnosticsfi_tclMsgGetLocaleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgGetLocaleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GetLocaleRequested);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgGetLocaleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GetLocaleRequested);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgGetLocaleStatus::operator==(const midw_diagnosticsfi_tclMsgGetLocaleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GetLocaleRequested == roRef.GetLocaleRequested);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetDisplaySet::midw_diagnosticsfi_tclMsgSetDisplaySet(const midw_diagnosticsfi_tclMsgSetDisplaySet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DisplayTestSuccess = coRef.DisplayTestSuccess;
}
midw_diagnosticsfi_tclMsgSetDisplaySet& midw_diagnosticsfi_tclMsgSetDisplaySet::operator=(const midw_diagnosticsfi_tclMsgSetDisplaySet& coRef)
{
   if (this == &coRef) return *this;
   DisplayTestSuccess = coRef.DisplayTestSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetDisplaySet::midw_diagnosticsfi_tclMsgSetDisplaySet()
:DisplayTestSuccess(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetDisplaySet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSET;
}


midw_diagnosticsfi_tclMsgSetDisplaySet::~midw_diagnosticsfi_tclMsgSetDisplaySet()
{}

tU32 midw_diagnosticsfi_tclMsgSetDisplaySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetDisplaySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayTestSuccess);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetDisplaySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayTestSuccess);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetDisplaySet::operator==(const midw_diagnosticsfi_tclMsgSetDisplaySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayTestSuccess == roRef.DisplayTestSuccess);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSetDisplayUpReg::midw_diagnosticsfi_tclMsgSetDisplayUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetDisplayUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYUPREG;
}


midw_diagnosticsfi_tclMsgSetDisplayUpReg::~midw_diagnosticsfi_tclMsgSetDisplayUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSetDisplayRelUpReg::midw_diagnosticsfi_tclMsgSetDisplayRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetDisplayRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYRELUPREG;
}


midw_diagnosticsfi_tclMsgSetDisplayRelUpReg::~midw_diagnosticsfi_tclMsgSetDisplayRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetDisplayStatus::midw_diagnosticsfi_tclMsgSetDisplayStatus(const midw_diagnosticsfi_tclMsgSetDisplayStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DisplayData = coRef.DisplayData;
}
midw_diagnosticsfi_tclMsgSetDisplayStatus& midw_diagnosticsfi_tclMsgSetDisplayStatus::operator=(const midw_diagnosticsfi_tclMsgSetDisplayStatus& coRef)
{
   if (this == &coRef) return *this;
   DisplayData = coRef.DisplayData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgSetDisplayStatus::vDestroy()
{
   DisplayData.vDestroy(); 
}

midw_diagnosticsfi_tclMsgSetDisplayStatus::midw_diagnosticsfi_tclMsgSetDisplayStatus()
:DisplayData()
 {}

tS32 midw_diagnosticsfi_tclMsgSetDisplayStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETDISPLAYSTATUS;
}


midw_diagnosticsfi_tclMsgSetDisplayStatus::~midw_diagnosticsfi_tclMsgSetDisplayStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgSetDisplayStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DisplayData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetDisplayStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayData);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetDisplayStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayData);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetDisplayStatus::operator==(const midw_diagnosticsfi_tclMsgSetDisplayStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayData == roRef.DisplayData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigUpdateStatus = coRef.ConfigUpdateStatus;
}
midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::operator=(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& coRef)
{
   if (this == &coRef) return *this;
   ConfigUpdateStatus = coRef.ConfigUpdateStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus()
:ConfigUpdateStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CONFIGUPDATEVIAUSBSTATUS;
}


midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::~midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus()
{}

tU32 midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigUpdateStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigUpdateStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus::operator==(const midw_diagnosticsfi_tclMsgConfigUpdateViaUSBStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigUpdateStatus == roRef.ConfigUpdateStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgAntiTheftStatusSet::midw_diagnosticsfi_tclMsgAntiTheftStatusSet(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   AntiTheftStatus = coRef.AntiTheftStatus;
}
midw_diagnosticsfi_tclMsgAntiTheftStatusSet& midw_diagnosticsfi_tclMsgAntiTheftStatusSet::operator=(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& coRef)
{
   if (this == &coRef) return *this;
   AntiTheftStatus = coRef.AntiTheftStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgAntiTheftStatusSet::midw_diagnosticsfi_tclMsgAntiTheftStatusSet()
:AntiTheftStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftStatusSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSET;
}


midw_diagnosticsfi_tclMsgAntiTheftStatusSet::~midw_diagnosticsfi_tclMsgAntiTheftStatusSet()
{}

tU32 midw_diagnosticsfi_tclMsgAntiTheftStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgAntiTheftStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AntiTheftStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgAntiTheftStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AntiTheftStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgAntiTheftStatusSet::operator==(const midw_diagnosticsfi_tclMsgAntiTheftStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AntiTheftStatus == roRef.AntiTheftStatus);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg::midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg::~midw_diagnosticsfi_tclMsgAntiTheftStatusUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg::midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSRELUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg::~midw_diagnosticsfi_tclMsgAntiTheftStatusRelUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftStatusStatus::midw_diagnosticsfi_tclMsgAntiTheftStatusStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTSTATUSSTATUS;
}


midw_diagnosticsfi_tclMsgAntiTheftStatusStatus::~midw_diagnosticsfi_tclMsgAntiTheftStatusStatus()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet::midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISET;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMISet()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg::midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg::midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMIRELUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   VIDWriteStatus = coRef.VIDWriteStatus;
}
midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::operator=(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& coRef)
{
   if (this == &coRef) return *this;
   VIDWriteStatus = coRef.VIDWriteStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus()
:VIDWriteStatus(0)
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHMISTATUS;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus()
{}

tU32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VIDWriteStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VIDWriteStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus::operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHMIStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VIDWriteStatus == roRef.VIDWriteStatus);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet::midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSET;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUSet()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg::midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg::midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHURELUPREG;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHURelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   PINValidationStatus = coRef.PINValidationStatus;
}
midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::operator=(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& coRef)
{
   if (this == &coRef) return *this;
   PINValidationStatus = coRef.PINValidationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus()
:PINValidationStatus(0)
 {}

tS32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_ANTITHEFTUNLOCKHUSTATUS;
}


midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::~midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus()
{}

tU32 midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PINValidationStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PINValidationStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus::operator==(const midw_diagnosticsfi_tclMsgAntiTheftUnlockHUStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PINValidationStatus == roRef.PINValidationStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgClearDestinationMemorySet::midw_diagnosticsfi_tclMsgClearDestinationMemorySet(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ClearMemorySuccess = coRef.ClearMemorySuccess;
}
midw_diagnosticsfi_tclMsgClearDestinationMemorySet& midw_diagnosticsfi_tclMsgClearDestinationMemorySet::operator=(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& coRef)
{
   if (this == &coRef) return *this;
   ClearMemorySuccess = coRef.ClearMemorySuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgClearDestinationMemorySet::midw_diagnosticsfi_tclMsgClearDestinationMemorySet()
:ClearMemorySuccess(0)
 {}

tS32 midw_diagnosticsfi_tclMsgClearDestinationMemorySet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSET;
}


midw_diagnosticsfi_tclMsgClearDestinationMemorySet::~midw_diagnosticsfi_tclMsgClearDestinationMemorySet()
{}

tU32 midw_diagnosticsfi_tclMsgClearDestinationMemorySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgClearDestinationMemorySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClearMemorySuccess);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgClearDestinationMemorySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClearMemorySuccess);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgClearDestinationMemorySet::operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemorySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClearMemorySuccess == roRef.ClearMemorySuccess);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg::midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYUPREG;
}


midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg::~midw_diagnosticsfi_tclMsgClearDestinationMemoryUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg::midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYRELUPREG;
}


midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg::~midw_diagnosticsfi_tclMsgClearDestinationMemoryRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ClearMemory = coRef.ClearMemory;
}
midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::operator=(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   ClearMemory = coRef.ClearMemory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus()
:ClearMemory(0)
 {}

tS32 midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CLEARDESTINATIONMEMORYSTATUS;
}


midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::~midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus()
{}

tU32 midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClearMemory);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClearMemory);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus::operator==(const midw_diagnosticsfi_tclMsgClearDestinationMemoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClearMemory == roRef.ClearMemory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   RecordCount = coRef.RecordCount;
}
midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::operator=(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& coRef)
{
   if (this == &coRef) return *this;
   RecordCount = coRef.RecordCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet()
:RecordCount(0)
 {}

tS32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESET;
}


midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet()
{}

tU32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecordCount);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecordCount);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet::operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecordCount == roRef.RecordCount);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZEUPREG;
}


midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg::~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZERELUPREG;
}


midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg::~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   GetMemorySize = coRef.GetMemorySize;
}
midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::operator=(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& coRef)
{
   if (this == &coRef) return *this;
   GetMemorySize = coRef.GetMemorySize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus()
:GetMemorySize(0)
 {}

tS32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_GETDESTINATIONMEMORYSIZESTATUS;
}


midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::~midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus()
{}

tU32 midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GetMemorySize);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GetMemorySize);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus::operator==(const midw_diagnosticsfi_tclMsgGetDestinationMemorySizeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GetMemorySize == roRef.GetMemorySize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSimulateKeyPressSet::midw_diagnosticsfi_tclMsgSimulateKeyPressSet(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KeyPressSuccess = coRef.KeyPressSuccess;
}
midw_diagnosticsfi_tclMsgSimulateKeyPressSet& midw_diagnosticsfi_tclMsgSimulateKeyPressSet::operator=(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& coRef)
{
   if (this == &coRef) return *this;
   KeyPressSuccess = coRef.KeyPressSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSimulateKeyPressSet::midw_diagnosticsfi_tclMsgSimulateKeyPressSet()
:KeyPressSuccess(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSimulateKeyPressSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSET;
}


midw_diagnosticsfi_tclMsgSimulateKeyPressSet::~midw_diagnosticsfi_tclMsgSimulateKeyPressSet()
{}

tU32 midw_diagnosticsfi_tclMsgSimulateKeyPressSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSimulateKeyPressSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyPressSuccess);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSimulateKeyPressSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyPressSuccess);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSimulateKeyPressSet::operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyPressSuccess == roRef.KeyPressSuccess);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg::midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSUPREG;
}


midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg::~midw_diagnosticsfi_tclMsgSimulateKeyPressUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg::midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSRELUPREG;
}


midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg::~midw_diagnosticsfi_tclMsgSimulateKeyPressRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::midw_diagnosticsfi_tclMsgSimulateKeyPressStatus(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KeyCommand = coRef.KeyCommand;
   EncoderSteps = coRef.EncoderSteps;
}
midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::operator=(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyCommand = coRef.KeyCommand;
   EncoderSteps = coRef.EncoderSteps;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::midw_diagnosticsfi_tclMsgSimulateKeyPressStatus()
:KeyCommand()
,EncoderSteps(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SIMULATEKEYPRESSSTATUS;
}


midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::~midw_diagnosticsfi_tclMsgSimulateKeyPressStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyCommand);
   (tVoid) (oIn >> EncoderSteps);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyCommand);
   (tVoid) (oOut << EncoderSteps);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSimulateKeyPressStatus::operator==(const midw_diagnosticsfi_tclMsgSimulateKeyPressStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyCommand == roRef.KeyCommand);
   bResult = bResult && (EncoderSteps == roRef.EncoderSteps);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgResetSecuritySet::midw_diagnosticsfi_tclMsgResetSecuritySet(const midw_diagnosticsfi_tclMsgResetSecuritySet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ResetSuccess = coRef.ResetSuccess;
}
midw_diagnosticsfi_tclMsgResetSecuritySet& midw_diagnosticsfi_tclMsgResetSecuritySet::operator=(const midw_diagnosticsfi_tclMsgResetSecuritySet& coRef)
{
   if (this == &coRef) return *this;
   ResetSuccess = coRef.ResetSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgResetSecuritySet::midw_diagnosticsfi_tclMsgResetSecuritySet()
:ResetSuccess(0)
 {}

tS32 midw_diagnosticsfi_tclMsgResetSecuritySet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSET;
}


midw_diagnosticsfi_tclMsgResetSecuritySet::~midw_diagnosticsfi_tclMsgResetSecuritySet()
{}

tU32 midw_diagnosticsfi_tclMsgResetSecuritySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgResetSecuritySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetSuccess);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgResetSecuritySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetSuccess);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgResetSecuritySet::operator==(const midw_diagnosticsfi_tclMsgResetSecuritySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetSuccess == roRef.ResetSuccess);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgResetSecurityUpReg::midw_diagnosticsfi_tclMsgResetSecurityUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgResetSecurityUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYUPREG;
}


midw_diagnosticsfi_tclMsgResetSecurityUpReg::~midw_diagnosticsfi_tclMsgResetSecurityUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgResetSecurityRelUpReg::midw_diagnosticsfi_tclMsgResetSecurityRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgResetSecurityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYRELUPREG;
}


midw_diagnosticsfi_tclMsgResetSecurityRelUpReg::~midw_diagnosticsfi_tclMsgResetSecurityRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgResetSecurityStatus::midw_diagnosticsfi_tclMsgResetSecurityStatus(const midw_diagnosticsfi_tclMsgResetSecurityStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Reset = coRef.Reset;
}
midw_diagnosticsfi_tclMsgResetSecurityStatus& midw_diagnosticsfi_tclMsgResetSecurityStatus::operator=(const midw_diagnosticsfi_tclMsgResetSecurityStatus& coRef)
{
   if (this == &coRef) return *this;
   Reset = coRef.Reset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgResetSecurityStatus::midw_diagnosticsfi_tclMsgResetSecurityStatus()
:Reset(0)
 {}

tS32 midw_diagnosticsfi_tclMsgResetSecurityStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RESETSECURITYSTATUS;
}


midw_diagnosticsfi_tclMsgResetSecurityStatus::~midw_diagnosticsfi_tclMsgResetSecurityStatus()
{}

tU32 midw_diagnosticsfi_tclMsgResetSecurityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgResetSecurityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Reset);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgResetSecurityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Reset);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgResetSecurityStatus::operator==(const midw_diagnosticsfi_tclMsgResetSecurityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Reset == roRef.Reset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgLanguageGet::midw_diagnosticsfi_tclMsgLanguageGet(const midw_diagnosticsfi_tclMsgLanguageGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
midw_diagnosticsfi_tclMsgLanguageGet& midw_diagnosticsfi_tclMsgLanguageGet::operator=(const midw_diagnosticsfi_tclMsgLanguageGet& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgLanguageGet::midw_diagnosticsfi_tclMsgLanguageGet()
:Language()
 {}

tS32 midw_diagnosticsfi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGEGET;
}


midw_diagnosticsfi_tclMsgLanguageGet::~midw_diagnosticsfi_tclMsgLanguageGet()
{}

tU32 midw_diagnosticsfi_tclMsgLanguageGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgLanguageGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgLanguageGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgLanguageGet::operator==(const midw_diagnosticsfi_tclMsgLanguageGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgLanguageStatus::midw_diagnosticsfi_tclMsgLanguageStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_LANGUAGESTATUS;
}


midw_diagnosticsfi_tclMsgLanguageStatus::~midw_diagnosticsfi_tclMsgLanguageStatus()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSpeedLockGet::midw_diagnosticsfi_tclMsgSpeedLockGet(const midw_diagnosticsfi_tclMsgSpeedLockGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SpeedLock = coRef.SpeedLock;
}
midw_diagnosticsfi_tclMsgSpeedLockGet& midw_diagnosticsfi_tclMsgSpeedLockGet::operator=(const midw_diagnosticsfi_tclMsgSpeedLockGet& coRef)
{
   if (this == &coRef) return *this;
   SpeedLock = coRef.SpeedLock;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSpeedLockGet::midw_diagnosticsfi_tclMsgSpeedLockGet()
:SpeedLock()
 {}

tS32 midw_diagnosticsfi_tclMsgSpeedLockGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKGET;
}


midw_diagnosticsfi_tclMsgSpeedLockGet::~midw_diagnosticsfi_tclMsgSpeedLockGet()
{}

tU32 midw_diagnosticsfi_tclMsgSpeedLockGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSpeedLockGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedLock);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSpeedLockGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedLock);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSpeedLockGet::operator==(const midw_diagnosticsfi_tclMsgSpeedLockGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedLock == roRef.SpeedLock);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSpeedLockStatus::midw_diagnosticsfi_tclMsgSpeedLockStatus(const midw_diagnosticsfi_tclMsgSpeedLockStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SpeedLockStatus = coRef.SpeedLockStatus;
   SpeedLockThreshold = coRef.SpeedLockThreshold;
}
midw_diagnosticsfi_tclMsgSpeedLockStatus& midw_diagnosticsfi_tclMsgSpeedLockStatus::operator=(const midw_diagnosticsfi_tclMsgSpeedLockStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeedLockStatus = coRef.SpeedLockStatus;
   SpeedLockThreshold = coRef.SpeedLockThreshold;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSpeedLockStatus::midw_diagnosticsfi_tclMsgSpeedLockStatus()
:SpeedLockStatus()
,SpeedLockThreshold(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSpeedLockStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SPEEDLOCKSTATUS;
}


midw_diagnosticsfi_tclMsgSpeedLockStatus::~midw_diagnosticsfi_tclMsgSpeedLockStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSpeedLockStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSpeedLockStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedLockStatus);
   (tVoid) (oIn >> SpeedLockThreshold);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSpeedLockStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedLockStatus);
   (tVoid) (oOut << SpeedLockThreshold);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSpeedLockStatus::operator==(const midw_diagnosticsfi_tclMsgSpeedLockStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedLockStatus == roRef.SpeedLockStatus);
   bResult = bResult && (SpeedLockThreshold == roRef.SpeedLockThreshold);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSpdLockSet::midw_diagnosticsfi_tclMsgSpdLockSet(const midw_diagnosticsfi_tclMsgSpdLockSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SpeedLock = coRef.SpeedLock;
}
midw_diagnosticsfi_tclMsgSpdLockSet& midw_diagnosticsfi_tclMsgSpdLockSet::operator=(const midw_diagnosticsfi_tclMsgSpdLockSet& coRef)
{
   if (this == &coRef) return *this;
   SpeedLock = coRef.SpeedLock;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSpdLockSet::midw_diagnosticsfi_tclMsgSpdLockSet()
:SpeedLock()
 {}

tS32 midw_diagnosticsfi_tclMsgSpdLockSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSET;
}


midw_diagnosticsfi_tclMsgSpdLockSet::~midw_diagnosticsfi_tclMsgSpdLockSet()
{}

tU32 midw_diagnosticsfi_tclMsgSpdLockSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSpdLockSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedLock);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSpdLockSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedLock);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSpdLockSet::operator==(const midw_diagnosticsfi_tclMsgSpdLockSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedLock == roRef.SpeedLock);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSpdLockStatus::midw_diagnosticsfi_tclMsgSpdLockStatus(const midw_diagnosticsfi_tclMsgSpdLockStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SpeedLockStatus = coRef.SpeedLockStatus;
}
midw_diagnosticsfi_tclMsgSpdLockStatus& midw_diagnosticsfi_tclMsgSpdLockStatus::operator=(const midw_diagnosticsfi_tclMsgSpdLockStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeedLockStatus = coRef.SpeedLockStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSpdLockStatus::midw_diagnosticsfi_tclMsgSpdLockStatus()
:SpeedLockStatus(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSpdLockStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SPDLOCKSTATUS;
}


midw_diagnosticsfi_tclMsgSpdLockStatus::~midw_diagnosticsfi_tclMsgSpdLockStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSpdLockStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSpdLockStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedLockStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSpdLockStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedLockStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSpdLockStatus::operator==(const midw_diagnosticsfi_tclMsgSpdLockStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedLockStatus == roRef.SpeedLockStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetRVCSignalGet::midw_diagnosticsfi_tclMsgSetRVCSignalGet(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SignalStatus = coRef.SignalStatus;
}
midw_diagnosticsfi_tclMsgSetRVCSignalGet& midw_diagnosticsfi_tclMsgSetRVCSignalGet::operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& coRef)
{
   if (this == &coRef) return *this;
   SignalStatus = coRef.SignalStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetRVCSignalGet::midw_diagnosticsfi_tclMsgSetRVCSignalGet()
:SignalStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgSetRVCSignalGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALGET;
}


midw_diagnosticsfi_tclMsgSetRVCSignalGet::~midw_diagnosticsfi_tclMsgSetRVCSignalGet()
{}

tU32 midw_diagnosticsfi_tclMsgSetRVCSignalGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetRVCSignalGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SignalStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetRVCSignalGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SignalStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetRVCSignalGet::operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SignalStatus == roRef.SignalStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetRVCSignalSet::midw_diagnosticsfi_tclMsgSetRVCSignalSet(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   StatusChanged = coRef.StatusChanged;
}
midw_diagnosticsfi_tclMsgSetRVCSignalSet& midw_diagnosticsfi_tclMsgSetRVCSignalSet::operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& coRef)
{
   if (this == &coRef) return *this;
   StatusChanged = coRef.StatusChanged;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetRVCSignalSet::midw_diagnosticsfi_tclMsgSetRVCSignalSet()
:StatusChanged(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetRVCSignalSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSET;
}


midw_diagnosticsfi_tclMsgSetRVCSignalSet::~midw_diagnosticsfi_tclMsgSetRVCSignalSet()
{}

tU32 midw_diagnosticsfi_tclMsgSetRVCSignalSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetRVCSignalSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusChanged);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetRVCSignalSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusChanged);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetRVCSignalSet::operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusChanged == roRef.StatusChanged);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSetRVCSignalUpReg::midw_diagnosticsfi_tclMsgSetRVCSignalUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetRVCSignalUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALUPREG;
}


midw_diagnosticsfi_tclMsgSetRVCSignalUpReg::~midw_diagnosticsfi_tclMsgSetRVCSignalUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg::midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALRELUPREG;
}


midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg::~midw_diagnosticsfi_tclMsgSetRVCSignalRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetRVCSignalStatus::midw_diagnosticsfi_tclMsgSetRVCSignalStatus(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SignalStatus = coRef.SignalStatus;
}
midw_diagnosticsfi_tclMsgSetRVCSignalStatus& midw_diagnosticsfi_tclMsgSetRVCSignalStatus::operator=(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& coRef)
{
   if (this == &coRef) return *this;
   SignalStatus = coRef.SignalStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetRVCSignalStatus::midw_diagnosticsfi_tclMsgSetRVCSignalStatus()
:SignalStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgSetRVCSignalStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETRVCSIGNALSTATUS;
}


midw_diagnosticsfi_tclMsgSetRVCSignalStatus::~midw_diagnosticsfi_tclMsgSetRVCSignalStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSetRVCSignalStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetRVCSignalStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SignalStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetRVCSignalStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SignalStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetRVCSignalStatus::operator==(const midw_diagnosticsfi_tclMsgSetRVCSignalStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SignalStatus == roRef.SignalStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRVCSignalStatusSet::midw_diagnosticsfi_tclMsgRVCSignalStatusSet(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SignalStatus = coRef.SignalStatus;
}
midw_diagnosticsfi_tclMsgRVCSignalStatusSet& midw_diagnosticsfi_tclMsgRVCSignalStatusSet::operator=(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& coRef)
{
   if (this == &coRef) return *this;
   SignalStatus = coRef.SignalStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRVCSignalStatusSet::midw_diagnosticsfi_tclMsgRVCSignalStatusSet()
:SignalStatus()
 {}

tS32 midw_diagnosticsfi_tclMsgRVCSignalStatusSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSET;
}


midw_diagnosticsfi_tclMsgRVCSignalStatusSet::~midw_diagnosticsfi_tclMsgRVCSignalStatusSet()
{}

tU32 midw_diagnosticsfi_tclMsgRVCSignalStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRVCSignalStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SignalStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRVCSignalStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SignalStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRVCSignalStatusSet::operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SignalStatus == roRef.SignalStatus);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg::midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSUPREG;
}


midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg::~midw_diagnosticsfi_tclMsgRVCSignalStatusUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg::midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSRELUPREG;
}


midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg::~midw_diagnosticsfi_tclMsgRVCSignalStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::midw_diagnosticsfi_tclMsgRVCSignalStatusStatus(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   RequestStatus = coRef.RequestStatus;
}
midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::operator=(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   RequestStatus = coRef.RequestStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::midw_diagnosticsfi_tclMsgRVCSignalStatusStatus()
:RequestStatus(0)
 {}

tS32 midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_RVCSIGNALSTATUSSTATUS;
}


midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::~midw_diagnosticsfi_tclMsgRVCSignalStatusStatus()
{}

tU32 midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestStatus);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestStatus);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRVCSignalStatusStatus::operator==(const midw_diagnosticsfi_tclMsgRVCSignalStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestStatus == roRef.RequestStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgKdsEntryGet::midw_diagnosticsfi_tclMsgKdsEntryGet(const midw_diagnosticsfi_tclMsgKdsEntryGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KdsEntry = coRef.KdsEntry;
}
midw_diagnosticsfi_tclMsgKdsEntryGet& midw_diagnosticsfi_tclMsgKdsEntryGet::operator=(const midw_diagnosticsfi_tclMsgKdsEntryGet& coRef)
{
   if (this == &coRef) return *this;
   KdsEntry = coRef.KdsEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgKdsEntryGet::midw_diagnosticsfi_tclMsgKdsEntryGet()
:KdsEntry(0)
 {}

tS32 midw_diagnosticsfi_tclMsgKdsEntryGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYGET;
}


midw_diagnosticsfi_tclMsgKdsEntryGet::~midw_diagnosticsfi_tclMsgKdsEntryGet()
{}

tU32 midw_diagnosticsfi_tclMsgKdsEntryGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgKdsEntryGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KdsEntry);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgKdsEntryGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KdsEntry);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgKdsEntryGet::operator==(const midw_diagnosticsfi_tclMsgKdsEntryGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KdsEntry == roRef.KdsEntry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgKdsEntrySet::midw_diagnosticsfi_tclMsgKdsEntrySet(const midw_diagnosticsfi_tclMsgKdsEntrySet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KdsEntry = coRef.KdsEntry;
   KdsDataList = coRef.KdsDataList;
}
midw_diagnosticsfi_tclMsgKdsEntrySet& midw_diagnosticsfi_tclMsgKdsEntrySet::operator=(const midw_diagnosticsfi_tclMsgKdsEntrySet& coRef)
{
   if (this == &coRef) return *this;
   KdsEntry = coRef.KdsEntry;
   KdsDataList = coRef.KdsDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgKdsEntrySet::vDestroy()
{
   KdsDataList.vDestroy(); 
}

midw_diagnosticsfi_tclMsgKdsEntrySet::midw_diagnosticsfi_tclMsgKdsEntrySet()
:KdsEntry(0)
,KdsDataList()
 {}

tS32 midw_diagnosticsfi_tclMsgKdsEntrySet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSET;
}


midw_diagnosticsfi_tclMsgKdsEntrySet::~midw_diagnosticsfi_tclMsgKdsEntrySet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgKdsEntrySet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+KdsDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgKdsEntrySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KdsEntry);
   (tVoid) (oIn >> KdsDataList);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgKdsEntrySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KdsEntry);
   (tVoid) (oOut << KdsDataList);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgKdsEntrySet::operator==(const midw_diagnosticsfi_tclMsgKdsEntrySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KdsEntry == roRef.KdsEntry);
   bResult = bResult && (KdsDataList == roRef.KdsDataList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgKdsEntryStatus::midw_diagnosticsfi_tclMsgKdsEntryStatus(const midw_diagnosticsfi_tclMsgKdsEntryStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KdsEntry = coRef.KdsEntry;
   KdsDataList = coRef.KdsDataList;
}
midw_diagnosticsfi_tclMsgKdsEntryStatus& midw_diagnosticsfi_tclMsgKdsEntryStatus::operator=(const midw_diagnosticsfi_tclMsgKdsEntryStatus& coRef)
{
   if (this == &coRef) return *this;
   KdsEntry = coRef.KdsEntry;
   KdsDataList = coRef.KdsDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgKdsEntryStatus::vDestroy()
{
   KdsDataList.vDestroy(); 
}

midw_diagnosticsfi_tclMsgKdsEntryStatus::midw_diagnosticsfi_tclMsgKdsEntryStatus()
:KdsEntry(0)
,KdsDataList()
 {}

tS32 midw_diagnosticsfi_tclMsgKdsEntryStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYSTATUS;
}


midw_diagnosticsfi_tclMsgKdsEntryStatus::~midw_diagnosticsfi_tclMsgKdsEntryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgKdsEntryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+KdsDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgKdsEntryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KdsEntry);
   (tVoid) (oIn >> KdsDataList);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgKdsEntryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KdsEntry);
   (tVoid) (oOut << KdsDataList);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgKdsEntryStatus::operator==(const midw_diagnosticsfi_tclMsgKdsEntryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KdsEntry == roRef.KdsEntry);
   bResult = bResult && (KdsDataList == roRef.KdsDataList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgKdsEntryUpReg::midw_diagnosticsfi_tclMsgKdsEntryUpReg(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KdsEntry = coRef.KdsEntry;
}
midw_diagnosticsfi_tclMsgKdsEntryUpReg& midw_diagnosticsfi_tclMsgKdsEntryUpReg::operator=(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& coRef)
{
   if (this == &coRef) return *this;
   KdsEntry = coRef.KdsEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgKdsEntryUpReg::midw_diagnosticsfi_tclMsgKdsEntryUpReg()
:KdsEntry(0)
 {}

tS32 midw_diagnosticsfi_tclMsgKdsEntryUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYUPREG;
}


midw_diagnosticsfi_tclMsgKdsEntryUpReg::~midw_diagnosticsfi_tclMsgKdsEntryUpReg()
{}

tU32 midw_diagnosticsfi_tclMsgKdsEntryUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgKdsEntryUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KdsEntry);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgKdsEntryUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KdsEntry);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgKdsEntryUpReg::operator==(const midw_diagnosticsfi_tclMsgKdsEntryUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KdsEntry == roRef.KdsEntry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::midw_diagnosticsfi_tclMsgKdsEntryRelUpReg(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   KdsEntry = coRef.KdsEntry;
}
midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::operator=(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   KdsEntry = coRef.KdsEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::midw_diagnosticsfi_tclMsgKdsEntryRelUpReg()
:KdsEntry(0)
 {}

tS32 midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_KDSENTRYRELUPREG;
}


midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::~midw_diagnosticsfi_tclMsgKdsEntryRelUpReg()
{}

tU32 midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KdsEntry);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KdsEntry);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgKdsEntryRelUpReg::operator==(const midw_diagnosticsfi_tclMsgKdsEntryRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KdsEntry == roRef.KdsEntry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagConfigItemGet::midw_diagnosticsfi_tclMsgDiagConfigItemGet(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigItem = coRef.ConfigItem;
}
midw_diagnosticsfi_tclMsgDiagConfigItemGet& midw_diagnosticsfi_tclMsgDiagConfigItemGet::operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& coRef)
{
   if (this == &coRef) return *this;
   ConfigItem = coRef.ConfigItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgDiagConfigItemGet::midw_diagnosticsfi_tclMsgDiagConfigItemGet()
:ConfigItem(0)
 {}

tS32 midw_diagnosticsfi_tclMsgDiagConfigItemGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMGET;
}


midw_diagnosticsfi_tclMsgDiagConfigItemGet::~midw_diagnosticsfi_tclMsgDiagConfigItemGet()
{}

tU32 midw_diagnosticsfi_tclMsgDiagConfigItemGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagConfigItemGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigItem);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagConfigItemGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigItem);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagConfigItemGet::operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigItem == roRef.ConfigItem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagConfigItemSet::midw_diagnosticsfi_tclMsgDiagConfigItemSet(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigItem = coRef.ConfigItem;
   ConfigItemContent = coRef.ConfigItemContent;
}
midw_diagnosticsfi_tclMsgDiagConfigItemSet& midw_diagnosticsfi_tclMsgDiagConfigItemSet::operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& coRef)
{
   if (this == &coRef) return *this;
   ConfigItem = coRef.ConfigItem;
   ConfigItemContent = coRef.ConfigItemContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgDiagConfigItemSet::vDestroy()
{
   ConfigItemContent.vDestroy(); 
}

midw_diagnosticsfi_tclMsgDiagConfigItemSet::midw_diagnosticsfi_tclMsgDiagConfigItemSet()
:ConfigItem(0)
,ConfigItemContent()
 {}

tS32 midw_diagnosticsfi_tclMsgDiagConfigItemSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSET;
}


midw_diagnosticsfi_tclMsgDiagConfigItemSet::~midw_diagnosticsfi_tclMsgDiagConfigItemSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgDiagConfigItemSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+ConfigItemContent.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagConfigItemSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigItem);
   (tVoid) (oIn >> ConfigItemContent);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagConfigItemSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigItem);
   (tVoid) (oOut << ConfigItemContent);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagConfigItemSet::operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigItem == roRef.ConfigItem);
   bResult = bResult && (ConfigItemContent == roRef.ConfigItemContent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagConfigItemStatus::midw_diagnosticsfi_tclMsgDiagConfigItemStatus(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigItem = coRef.ConfigItem;
   ConfigItemValid = coRef.ConfigItemValid;
   ConfigItemContent = coRef.ConfigItemContent;
}
midw_diagnosticsfi_tclMsgDiagConfigItemStatus& midw_diagnosticsfi_tclMsgDiagConfigItemStatus::operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& coRef)
{
   if (this == &coRef) return *this;
   ConfigItem = coRef.ConfigItem;
   ConfigItemValid = coRef.ConfigItemValid;
   ConfigItemContent = coRef.ConfigItemContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgDiagConfigItemStatus::vDestroy()
{
   ConfigItemContent.vDestroy(); 
}

midw_diagnosticsfi_tclMsgDiagConfigItemStatus::midw_diagnosticsfi_tclMsgDiagConfigItemStatus()
:ConfigItem(0)
,ConfigItemValid(0)
,ConfigItemContent()
 {}

tS32 midw_diagnosticsfi_tclMsgDiagConfigItemStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMSTATUS;
}


midw_diagnosticsfi_tclMsgDiagConfigItemStatus::~midw_diagnosticsfi_tclMsgDiagConfigItemStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgDiagConfigItemStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+ConfigItemContent.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagConfigItemStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigItem);
   (tVoid) (oIn >> ConfigItemValid);
   (tVoid) (oIn >> ConfigItemContent);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagConfigItemStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigItem);
   (tVoid) (oOut << ConfigItemValid);
   (tVoid) (oOut << ConfigItemContent);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagConfigItemStatus::operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigItem == roRef.ConfigItem);
   bResult = bResult && (ConfigItemValid == roRef.ConfigItemValid);
   bResult = bResult && (ConfigItemContent == roRef.ConfigItemContent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::midw_diagnosticsfi_tclMsgDiagConfigItemUpReg(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigItem = coRef.ConfigItem;
}
midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& coRef)
{
   if (this == &coRef) return *this;
   ConfigItem = coRef.ConfigItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::midw_diagnosticsfi_tclMsgDiagConfigItemUpReg()
:ConfigItem(0)
 {}

tS32 midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMUPREG;
}


midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::~midw_diagnosticsfi_tclMsgDiagConfigItemUpReg()
{}

tU32 midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigItem);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigItem);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagConfigItemUpReg::operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigItem == roRef.ConfigItem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   ConfigItem = coRef.ConfigItem;
}
midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::operator=(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   ConfigItem = coRef.ConfigItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg()
:ConfigItem(0)
 {}

tS32 midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_DIAGCONFIGITEMRELUPREG;
}


midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::~midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg()
{}

tU32 midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigItem);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigItem);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg::operator==(const midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigItem == roRef.ConfigItem);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSUPREG;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg::~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSRELUPREG;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg::~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSGET;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSET;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::operator=(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus()
:DefSetStateGroup(0)
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_SETFACTORYSETTINGSSTATUSSTATUS;
}


midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::~midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus()
{}

tU32 midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus::operator==(const midw_diagnosticsfi_tclMsgSetFactorySettingsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgRemoteControlUpReg::midw_diagnosticsfi_tclMsgRemoteControlUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRemoteControlUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLUPREG;
}


midw_diagnosticsfi_tclMsgRemoteControlUpReg::~midw_diagnosticsfi_tclMsgRemoteControlUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgRemoteControlRelUpReg::midw_diagnosticsfi_tclMsgRemoteControlRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgRemoteControlRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLRELUPREG;
}


midw_diagnosticsfi_tclMsgRemoteControlRelUpReg::~midw_diagnosticsfi_tclMsgRemoteControlRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRemoteControlGet::midw_diagnosticsfi_tclMsgRemoteControlGet(const midw_diagnosticsfi_tclMsgRemoteControlGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
}
midw_diagnosticsfi_tclMsgRemoteControlGet& midw_diagnosticsfi_tclMsgRemoteControlGet::operator=(const midw_diagnosticsfi_tclMsgRemoteControlGet& coRef)
{
   if (this == &coRef) return *this;
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRemoteControlGet::midw_diagnosticsfi_tclMsgRemoteControlGet()
:src()
,cmd()
,signal()
 {}

tS32 midw_diagnosticsfi_tclMsgRemoteControlGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLGET;
}


midw_diagnosticsfi_tclMsgRemoteControlGet::~midw_diagnosticsfi_tclMsgRemoteControlGet()
{}

tU32 midw_diagnosticsfi_tclMsgRemoteControlGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRemoteControlGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> src);
   (tVoid) (oIn >> cmd);
   (tVoid) (oIn >> signal);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRemoteControlGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << src);
   (tVoid) (oOut << cmd);
   (tVoid) (oOut << signal);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRemoteControlGet::operator==(const midw_diagnosticsfi_tclMsgRemoteControlGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (src == roRef.src);
   bResult = bResult && (cmd == roRef.cmd);
   bResult = bResult && (signal == roRef.signal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRemoteControlSet::midw_diagnosticsfi_tclMsgRemoteControlSet(const midw_diagnosticsfi_tclMsgRemoteControlSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgRemoteControlSet& midw_diagnosticsfi_tclMsgRemoteControlSet::operator=(const midw_diagnosticsfi_tclMsgRemoteControlSet& coRef)
{
   if (this == &coRef) return *this;
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRemoteControlSet::midw_diagnosticsfi_tclMsgRemoteControlSet()
:src()
,cmd()
,signal()
,status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgRemoteControlSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSET;
}


midw_diagnosticsfi_tclMsgRemoteControlSet::~midw_diagnosticsfi_tclMsgRemoteControlSet()
{}

tU32 midw_diagnosticsfi_tclMsgRemoteControlSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRemoteControlSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> src);
   (tVoid) (oIn >> cmd);
   (tVoid) (oIn >> signal);
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRemoteControlSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << src);
   (tVoid) (oOut << cmd);
   (tVoid) (oOut << signal);
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRemoteControlSet::operator==(const midw_diagnosticsfi_tclMsgRemoteControlSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (src == roRef.src);
   bResult = bResult && (cmd == roRef.cmd);
   bResult = bResult && (signal == roRef.signal);
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgRemoteControlStatus::midw_diagnosticsfi_tclMsgRemoteControlStatus(const midw_diagnosticsfi_tclMsgRemoteControlStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgRemoteControlStatus& midw_diagnosticsfi_tclMsgRemoteControlStatus::operator=(const midw_diagnosticsfi_tclMsgRemoteControlStatus& coRef)
{
   if (this == &coRef) return *this;
   src = coRef.src;
   cmd = coRef.cmd;
   signal = coRef.signal;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgRemoteControlStatus::midw_diagnosticsfi_tclMsgRemoteControlStatus()
:src()
,cmd()
,signal()
,status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgRemoteControlStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_REMOTECONTROLSTATUS;
}


midw_diagnosticsfi_tclMsgRemoteControlStatus::~midw_diagnosticsfi_tclMsgRemoteControlStatus()
{}

tU32 midw_diagnosticsfi_tclMsgRemoteControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgRemoteControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> src);
   (tVoid) (oIn >> cmd);
   (tVoid) (oIn >> signal);
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgRemoteControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << src);
   (tVoid) (oOut << cmd);
   (tVoid) (oOut << signal);
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgRemoteControlStatus::operator==(const midw_diagnosticsfi_tclMsgRemoteControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (src == roRef.src);
   bResult = bResult && (cmd == roRef.cmd);
   bResult = bResult && (signal == roRef.signal);
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg::midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSUPREG;
}


midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg::~midw_diagnosticsfi_tclMsgCISswUpdateProcessUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg::midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSRELUPREG;
}


midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg::~midw_diagnosticsfi_tclMsgCISswUpdateProcessRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::midw_diagnosticsfi_tclMsgCISswUpdateProcessSet(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::operator=(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& coRef)
{
   if (this == &coRef) return *this;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::midw_diagnosticsfi_tclMsgCISswUpdateProcessSet()
:status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSET;
}


midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::~midw_diagnosticsfi_tclMsgCISswUpdateProcessSet()
{}

tU32 midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCISswUpdateProcessSet::operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::operator=(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& coRef)
{
   if (this == &coRef) return *this;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus()
:status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATEPROCESSSTATUS;
}


midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::~midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus()
{}

tU32 midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus::operator==(const midw_diagnosticsfi_tclMsgCISswUpdateProcessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSUPREG;
}


midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg::~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessUpReg()
{}

//=============================================================================

midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg()
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSRELUPREG;
}


midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg::~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::operator=(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& coRef)
{
   if (this == &coRef) return *this;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet()
:status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSET;
}


midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet()
{}

tU32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet::operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   status = coRef.status;
}
midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::operator=(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& coRef)
{
   if (this == &coRef) return *this;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus()
:status(0)
 {}

tS32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CISSWUPDATESTAGE2PROCESSSTATUS;
}


midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::~midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus()
{}

tU32 midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << status);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus::operator==(const midw_diagnosticsfi_tclMsgCISswUpdateStage2ProcessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCalibrationParameterGet::midw_diagnosticsfi_tclMsgCalibrationParameterGet(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SessionHandle = coRef.SessionHandle;
   Name = coRef.Name;
}
midw_diagnosticsfi_tclMsgCalibrationParameterGet& midw_diagnosticsfi_tclMsgCalibrationParameterGet::operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& coRef)
{
   if (this == &coRef) return *this;
   SessionHandle = coRef.SessionHandle;
   Name = coRef.Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgCalibrationParameterGet::vDestroy()
{
   Name.vDestroy();
}

midw_diagnosticsfi_tclMsgCalibrationParameterGet::midw_diagnosticsfi_tclMsgCalibrationParameterGet()
:SessionHandle(0)
,Name()
 {}

tS32 midw_diagnosticsfi_tclMsgCalibrationParameterGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERGET;
}


midw_diagnosticsfi_tclMsgCalibrationParameterGet::~midw_diagnosticsfi_tclMsgCalibrationParameterGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgCalibrationParameterGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCalibrationParameterGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SessionHandle);
   (tVoid) (oIn >> Name);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCalibrationParameterGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SessionHandle);
   (tVoid) (oOut << Name);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCalibrationParameterGet::operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SessionHandle == roRef.SessionHandle);
   bResult = bResult && (Name == roRef.Name);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCalibrationParameterSet::midw_diagnosticsfi_tclMsgCalibrationParameterSet(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   SessionHandle = coRef.SessionHandle;
   Name = coRef.Name;
   Value = coRef.Value;
}
midw_diagnosticsfi_tclMsgCalibrationParameterSet& midw_diagnosticsfi_tclMsgCalibrationParameterSet::operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& coRef)
{
   if (this == &coRef) return *this;
   SessionHandle = coRef.SessionHandle;
   Name = coRef.Name;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgCalibrationParameterSet::vDestroy()
{
   Name.vDestroy();
   Value.vDestroy(); 
}

midw_diagnosticsfi_tclMsgCalibrationParameterSet::midw_diagnosticsfi_tclMsgCalibrationParameterSet()
:SessionHandle(0)
,Name()
,Value()
 {}

tS32 midw_diagnosticsfi_tclMsgCalibrationParameterSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSET;
}


midw_diagnosticsfi_tclMsgCalibrationParameterSet::~midw_diagnosticsfi_tclMsgCalibrationParameterSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgCalibrationParameterSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Name.u32GetSize(u16MajorVersion)+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCalibrationParameterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SessionHandle);
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCalibrationParameterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SessionHandle);
   (tVoid) (oOut << Name);
   (tVoid) (oOut << Value);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCalibrationParameterSet::operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SessionHandle == roRef.SessionHandle);
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgCalibrationParameterStatus::midw_diagnosticsfi_tclMsgCalibrationParameterStatus(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   Table = coRef.Table;
   Name = coRef.Name;
   Value = coRef.Value;
   ElementSize = coRef.ElementSize;
}
midw_diagnosticsfi_tclMsgCalibrationParameterStatus& midw_diagnosticsfi_tclMsgCalibrationParameterStatus::operator=(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& coRef)
{
   if (this == &coRef) return *this;
   Table = coRef.Table;
   Name = coRef.Name;
   Value = coRef.Value;
   ElementSize = coRef.ElementSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgCalibrationParameterStatus::vDestroy()
{
   Name.vDestroy();
   Value.vDestroy(); 
}

midw_diagnosticsfi_tclMsgCalibrationParameterStatus::midw_diagnosticsfi_tclMsgCalibrationParameterStatus()
:Table()
,Name()
,Value()
,ElementSize()
 {}

tS32 midw_diagnosticsfi_tclMsgCalibrationParameterStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_CALIBRATIONPARAMETERSTATUS;
}


midw_diagnosticsfi_tclMsgCalibrationParameterStatus::~midw_diagnosticsfi_tclMsgCalibrationParameterStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgCalibrationParameterStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Name.u32GetSize(u16MajorVersion)+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgCalibrationParameterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Table);
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> ElementSize);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgCalibrationParameterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Table);
   (tVoid) (oOut << Name);
   (tVoid) (oOut << Value);
   (tVoid) (oOut << ElementSize);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgCalibrationParameterStatus::operator==(const midw_diagnosticsfi_tclMsgCalibrationParameterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Table == roRef.Table);
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (ElementSize == roRef.ElementSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgPartNumberGet::midw_diagnosticsfi_tclMsgPartNumberGet(const midw_diagnosticsfi_tclMsgPartNumberGet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DataIdentifier = coRef.DataIdentifier;
}
midw_diagnosticsfi_tclMsgPartNumberGet& midw_diagnosticsfi_tclMsgPartNumberGet::operator=(const midw_diagnosticsfi_tclMsgPartNumberGet& coRef)
{
   if (this == &coRef) return *this;
   DataIdentifier = coRef.DataIdentifier;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diagnosticsfi_tclMsgPartNumberGet::midw_diagnosticsfi_tclMsgPartNumberGet()
:DataIdentifier(0)
 {}

tS32 midw_diagnosticsfi_tclMsgPartNumberGet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERGET;
}


midw_diagnosticsfi_tclMsgPartNumberGet::~midw_diagnosticsfi_tclMsgPartNumberGet()
{}

tU32 midw_diagnosticsfi_tclMsgPartNumberGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diagnosticsfi_tclMsgPartNumberGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataIdentifier);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgPartNumberGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataIdentifier);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgPartNumberGet::operator==(const midw_diagnosticsfi_tclMsgPartNumberGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataIdentifier == roRef.DataIdentifier);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgPartNumberSet::midw_diagnosticsfi_tclMsgPartNumberSet(const midw_diagnosticsfi_tclMsgPartNumberSet& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DataIdentifier = coRef.DataIdentifier;
   PartNumber = coRef.PartNumber;
   AlphaCode = coRef.AlphaCode;
}
midw_diagnosticsfi_tclMsgPartNumberSet& midw_diagnosticsfi_tclMsgPartNumberSet::operator=(const midw_diagnosticsfi_tclMsgPartNumberSet& coRef)
{
   if (this == &coRef) return *this;
   DataIdentifier = coRef.DataIdentifier;
   PartNumber = coRef.PartNumber;
   AlphaCode = coRef.AlphaCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgPartNumberSet::vDestroy()
{
   AlphaCode.vDestroy(); 
}

midw_diagnosticsfi_tclMsgPartNumberSet::midw_diagnosticsfi_tclMsgPartNumberSet()
:DataIdentifier(0)
,PartNumber(0)
,AlphaCode()
 {}

tS32 midw_diagnosticsfi_tclMsgPartNumberSet::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSET;
}


midw_diagnosticsfi_tclMsgPartNumberSet::~midw_diagnosticsfi_tclMsgPartNumberSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgPartNumberSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+AlphaCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgPartNumberSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataIdentifier);
   (tVoid) (oIn >> PartNumber);
   (tVoid) (oIn >> AlphaCode);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgPartNumberSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataIdentifier);
   (tVoid) (oOut << PartNumber);
   (tVoid) (oOut << AlphaCode);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgPartNumberSet::operator==(const midw_diagnosticsfi_tclMsgPartNumberSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataIdentifier == roRef.DataIdentifier);
   bResult = bResult && (PartNumber == roRef.PartNumber);
   bResult = bResult && (AlphaCode == roRef.AlphaCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diagnosticsfi_tclMsgPartNumberStatus::midw_diagnosticsfi_tclMsgPartNumberStatus(const midw_diagnosticsfi_tclMsgPartNumberStatus& coRef)
   : midw_diagnosticsfi_tclMsgBaseMessage(coRef)
{
   DataIdentifier = coRef.DataIdentifier;
   PartNumber = coRef.PartNumber;
   AlphaCode = coRef.AlphaCode;
}
midw_diagnosticsfi_tclMsgPartNumberStatus& midw_diagnosticsfi_tclMsgPartNumberStatus::operator=(const midw_diagnosticsfi_tclMsgPartNumberStatus& coRef)
{
   if (this == &coRef) return *this;
   DataIdentifier = coRef.DataIdentifier;
   PartNumber = coRef.PartNumber;
   AlphaCode = coRef.AlphaCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diagnosticsfi_tclMsgPartNumberStatus::vDestroy()
{
   AlphaCode.vDestroy(); 
}

midw_diagnosticsfi_tclMsgPartNumberStatus::midw_diagnosticsfi_tclMsgPartNumberStatus()
:DataIdentifier(0)
,PartNumber(0)
,AlphaCode()
 {}

tS32 midw_diagnosticsfi_tclMsgPartNumberStatus::s32GetTypeId() const
{
   return (tS32) midw_diagnosticsfi_tclToken::EN_MSG_PARTNUMBERSTATUS;
}


midw_diagnosticsfi_tclMsgPartNumberStatus::~midw_diagnosticsfi_tclMsgPartNumberStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diagnosticsfi_tclMsgPartNumberStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+AlphaCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diagnosticsfi_tclMsgPartNumberStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataIdentifier);
   (tVoid) (oIn >> PartNumber);
   (tVoid) (oIn >> AlphaCode);
   return oIn;
}

fi_tclOutContext& midw_diagnosticsfi_tclMsgPartNumberStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataIdentifier);
   (tVoid) (oOut << PartNumber);
   (tVoid) (oOut << AlphaCode);
   return oOut;
}

tBool midw_diagnosticsfi_tclMsgPartNumberStatus::operator==(const midw_diagnosticsfi_tclMsgPartNumberStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataIdentifier == roRef.DataIdentifier);
   bResult = bResult && (PartNumber == roRef.PartNumber);
   bResult = bResult && (AlphaCode == roRef.AlphaCode);
   return bResult;
}

