/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for Midw_DiagLog_FI message types

fi_tclMessageBase* midw_diaglogfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgSaveTestResultMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgSaveTestResultMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgProductionReadRequestMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgProductionReadRequestMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgCustomerReadRequestMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgCustomerReadRequestMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetItcInformationMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetItcInformationMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgProductionClearRequestMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgProductionClearRequestMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgCustomerClearRequestMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgCustomerClearRequestMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgWriteToMediaMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgWriteToMediaMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetSupportedDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetSupportedDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetStatusByDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetStatusByDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsggetStatusByITCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsggetStatusByITCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgclearDTCMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgclearDTCMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgControlMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgControlMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgControlDtcSettingMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgControlDtcSettingMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
         return OSAL_NEW midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart;

      case midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
         return OSAL_NEW midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult;

      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEGET:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCActiveGet;

      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCActiveUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVERELUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCActiveRelUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCACTIVESTATUS:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCActiveStatus;

      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgSendNextTestResultUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgSendNextTestResultRelUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS:
         return OSAL_NEW midw_diaglogfi_tclMsgSendNextTestResultStatus;

      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCTriggeredUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCTriggeredRelUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDGET:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCTriggeredGet;

      case midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS:
         return OSAL_NEW midw_diaglogfi_tclMsgDTCTriggeredStatus;

      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgSendActiveDTCListUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS:
         return OSAL_NEW midw_diaglogfi_tclMsgSendActiveDTCListStatus;

      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDtcStatusChangedUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG:
         return OSAL_NEW midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg;

      case midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS:
         return OSAL_NEW midw_diaglogfi_tclMsgDtcStatusChangedStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_diaglogfifi messages

// common functions

tU16 midw_diaglogfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_DIAGLOGFI_C_U16_SERVICE_ID;
}

tU16 midw_diaglogfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_diaglogfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_diaglogfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_diaglogfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_diaglogfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_diaglogfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_diaglogfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSaveTestResultMethodStart::midw_diaglogfi_tclMsgSaveTestResultMethodStart(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   TestResultList = coRef.TestResultList;
}
midw_diaglogfi_tclMsgSaveTestResultMethodStart& midw_diaglogfi_tclMsgSaveTestResultMethodStart::operator=(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgSaveTestResultMethodStart::vDestroy()
{
   TestResultList.vDestroy(); 
}

midw_diaglogfi_tclMsgSaveTestResultMethodStart::midw_diaglogfi_tclMsgSaveTestResultMethodStart()
:TestResultList()
 {}

tS32 midw_diaglogfi_tclMsgSaveTestResultMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART;
}


midw_diaglogfi_tclMsgSaveTestResultMethodStart::~midw_diaglogfi_tclMsgSaveTestResultMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgSaveTestResultMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgSaveTestResultMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestResultList);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSaveTestResultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestResultList);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSaveTestResultMethodStart::operator==(const midw_diaglogfi_tclMsgSaveTestResultMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestResultList == roRef.TestResultList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSaveTestResultMethodResult::midw_diaglogfi_tclMsgSaveTestResultMethodResult(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgSaveTestResultMethodResult& midw_diaglogfi_tclMsgSaveTestResultMethodResult::operator=(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgSaveTestResultMethodResult::midw_diaglogfi_tclMsgSaveTestResultMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgSaveTestResultMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT;
}


midw_diaglogfi_tclMsgSaveTestResultMethodResult::~midw_diaglogfi_tclMsgSaveTestResultMethodResult()
{}

tU32 midw_diaglogfi_tclMsgSaveTestResultMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgSaveTestResultMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSaveTestResultMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSaveTestResultMethodResult::operator==(const midw_diaglogfi_tclMsgSaveTestResultMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   TestResultList = coRef.TestResultList;
}
midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::operator=(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::vDestroy()
{
   TestResultList.vDestroy(); 
}

midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart()
:TestResultList()
 {}

tS32 midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART;
}


midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::~midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestResultList);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestResultList);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart::operator==(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestResultList == roRef.TestResultList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::operator=(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT;
}


midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::~midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult()
{}

tU32 midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult::operator==(const midw_diaglogfi_tclMsgSaveTestResultDynamicalDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgProductionReadRequestMethodStart::midw_diaglogfi_tclMsgProductionReadRequestMethodStart(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   ITCMask = coRef.ITCMask;
   Option = coRef.Option;
}
midw_diaglogfi_tclMsgProductionReadRequestMethodStart& midw_diaglogfi_tclMsgProductionReadRequestMethodStart::operator=(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   ITCMask = coRef.ITCMask;
   Option = coRef.Option;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgProductionReadRequestMethodStart::midw_diaglogfi_tclMsgProductionReadRequestMethodStart()
:Protocol()
,StatusMask(0)
,ITCMask(0)
,Option(0)
 {}

tS32 midw_diaglogfi_tclMsgProductionReadRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART;
}


midw_diaglogfi_tclMsgProductionReadRequestMethodStart::~midw_diaglogfi_tclMsgProductionReadRequestMethodStart()
{}

tU32 midw_diaglogfi_tclMsgProductionReadRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_diaglogfi_tclMsgProductionReadRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Protocol);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> ITCMask);
   (tVoid) (oIn >> Option);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgProductionReadRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Protocol);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << ITCMask);
   (tVoid) (oOut << Option);
   return oOut;
}

tBool midw_diaglogfi_tclMsgProductionReadRequestMethodStart::operator==(const midw_diaglogfi_tclMsgProductionReadRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Protocol == roRef.Protocol);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (ITCMask == roRef.ITCMask);
   bResult = bResult && (Option == roRef.Option);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgProductionReadRequestMethodResult::midw_diaglogfi_tclMsgProductionReadRequestMethodResult(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ProductionReadResultList = coRef.ProductionReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgProductionReadRequestMethodResult& midw_diaglogfi_tclMsgProductionReadRequestMethodResult::operator=(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProductionReadResultList = coRef.ProductionReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgProductionReadRequestMethodResult::vDestroy()
{
   ProductionReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsgProductionReadRequestMethodResult::midw_diaglogfi_tclMsgProductionReadRequestMethodResult()
:ProductionReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsgProductionReadRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT;
}


midw_diaglogfi_tclMsgProductionReadRequestMethodResult::~midw_diaglogfi_tclMsgProductionReadRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgProductionReadRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ProductionReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgProductionReadRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProductionReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgProductionReadRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProductionReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgProductionReadRequestMethodResult::operator==(const midw_diaglogfi_tclMsgProductionReadRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProductionReadResultList == roRef.ProductionReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::midw_diaglogfi_tclMsgCustomerReadRequestMethodStart(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   Option = coRef.Option;
}
midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::operator=(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   Option = coRef.Option;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::midw_diaglogfi_tclMsgCustomerReadRequestMethodStart()
:Protocol()
,StatusMask(0)
,DTCMask(0)
,Option(0)
 {}

tS32 midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART;
}


midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::~midw_diaglogfi_tclMsgCustomerReadRequestMethodStart()
{}

tU32 midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Protocol);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   (tVoid) (oIn >> Option);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Protocol);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   (tVoid) (oOut << Option);
   return oOut;
}

tBool midw_diaglogfi_tclMsgCustomerReadRequestMethodStart::operator==(const midw_diaglogfi_tclMsgCustomerReadRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Protocol == roRef.Protocol);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   bResult = bResult && (Option == roRef.Option);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::midw_diaglogfi_tclMsgCustomerReadRequestMethodResult(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   CustomerReadResultList = coRef.CustomerReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::operator=(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CustomerReadResultList = coRef.CustomerReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::vDestroy()
{
   CustomerReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::midw_diaglogfi_tclMsgCustomerReadRequestMethodResult()
:CustomerReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT;
}


midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::~midw_diaglogfi_tclMsgCustomerReadRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+CustomerReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CustomerReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CustomerReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgCustomerReadRequestMethodResult::operator==(const midw_diaglogfi_tclMsgCustomerReadRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CustomerReadResultList == roRef.CustomerReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetItcInformationMethodStart::midw_diaglogfi_tclMsggetItcInformationMethodStart(const midw_diaglogfi_tclMsggetItcInformationMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   ITCList = coRef.ITCList;
}
midw_diaglogfi_tclMsggetItcInformationMethodStart& midw_diaglogfi_tclMsggetItcInformationMethodStart::operator=(const midw_diaglogfi_tclMsggetItcInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetItcInformationMethodStart::vDestroy()
{
   {
   ITCList.clear();
   }
}

midw_diaglogfi_tclMsggetItcInformationMethodStart::midw_diaglogfi_tclMsggetItcInformationMethodStart()
:Group(0)

 {}

tS32 midw_diaglogfi_tclMsggetItcInformationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART;
}


midw_diaglogfi_tclMsggetItcInformationMethodStart::~midw_diaglogfi_tclMsggetItcInformationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetItcInformationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ITCList.size()*2);
}

fi_tclInContext& midw_diaglogfi_tclMsggetItcInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetItcInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool midw_diaglogfi_tclMsggetItcInformationMethodStart::operator==(const midw_diaglogfi_tclMsggetItcInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetItcInformationMethodResult::midw_diaglogfi_tclMsggetItcInformationMethodResult(const midw_diaglogfi_tclMsggetItcInformationMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ItcInformationList = coRef.ItcInformationList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetItcInformationMethodResult& midw_diaglogfi_tclMsggetItcInformationMethodResult::operator=(const midw_diaglogfi_tclMsggetItcInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ItcInformationList = coRef.ItcInformationList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetItcInformationMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
         ItcInformationList[u32Idx].vDestroy();
   ItcInformationList.clear();
   }
}

midw_diaglogfi_tclMsggetItcInformationMethodResult::midw_diaglogfi_tclMsggetItcInformationMethodResult()

:Status()
 {}

tS32 midw_diaglogfi_tclMsggetItcInformationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT;
}


midw_diaglogfi_tclMsggetItcInformationMethodResult::~midw_diaglogfi_tclMsggetItcInformationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetItcInformationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ItcInformationList.size()*15);
}

fi_tclInContext& midw_diaglogfi_tclMsggetItcInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
      {
         ItcInformationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ItcInformationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ItcInformationList[u32Idx]);
      }
   }
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetItcInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ItcInformationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
         (tVoid) (oOut << ItcInformationList[u32Idx]);
   }
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetItcInformationMethodResult::operator==(const midw_diaglogfi_tclMsggetItcInformationMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ItcInformationList.size() == roRef.ItcInformationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ItcInformationList.size()); ++u32Idx)
            bResult = bResult && (ItcInformationList[u32Idx] == roRef.ItcInformationList[u32Idx]);
      }
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgProductionClearRequestMethodStart::midw_diaglogfi_tclMsgProductionClearRequestMethodStart()
 {}

tS32 midw_diaglogfi_tclMsgProductionClearRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART;
}


midw_diaglogfi_tclMsgProductionClearRequestMethodStart::~midw_diaglogfi_tclMsgProductionClearRequestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgProductionClearRequestMethodResult::midw_diaglogfi_tclMsgProductionClearRequestMethodResult(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgProductionClearRequestMethodResult& midw_diaglogfi_tclMsgProductionClearRequestMethodResult::operator=(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgProductionClearRequestMethodResult::midw_diaglogfi_tclMsgProductionClearRequestMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgProductionClearRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT;
}


midw_diaglogfi_tclMsgProductionClearRequestMethodResult::~midw_diaglogfi_tclMsgProductionClearRequestMethodResult()
{}

tU32 midw_diaglogfi_tclMsgProductionClearRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgProductionClearRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgProductionClearRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgProductionClearRequestMethodResult::operator==(const midw_diaglogfi_tclMsgProductionClearRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgCustomerClearRequestMethodStart::midw_diaglogfi_tclMsgCustomerClearRequestMethodStart()
 {}

tS32 midw_diaglogfi_tclMsgCustomerClearRequestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART;
}


midw_diaglogfi_tclMsgCustomerClearRequestMethodStart::~midw_diaglogfi_tclMsgCustomerClearRequestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::midw_diaglogfi_tclMsgCustomerClearRequestMethodResult(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::operator=(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::midw_diaglogfi_tclMsgCustomerClearRequestMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT;
}


midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::~midw_diaglogfi_tclMsgCustomerClearRequestMethodResult()
{}

tU32 midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgCustomerClearRequestMethodResult::operator==(const midw_diaglogfi_tclMsgCustomerClearRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgWriteToMediaMethodStart::midw_diaglogfi_tclMsgWriteToMediaMethodStart(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Media = coRef.Media;
}
midw_diaglogfi_tclMsgWriteToMediaMethodStart& midw_diaglogfi_tclMsgWriteToMediaMethodStart::operator=(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Media = coRef.Media;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgWriteToMediaMethodStart::midw_diaglogfi_tclMsgWriteToMediaMethodStart()
:Media()
 {}

tS32 midw_diaglogfi_tclMsgWriteToMediaMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART;
}


midw_diaglogfi_tclMsgWriteToMediaMethodStart::~midw_diaglogfi_tclMsgWriteToMediaMethodStart()
{}

tU32 midw_diaglogfi_tclMsgWriteToMediaMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgWriteToMediaMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Media);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgWriteToMediaMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Media);
   return oOut;
}

tBool midw_diaglogfi_tclMsgWriteToMediaMethodStart::operator==(const midw_diaglogfi_tclMsgWriteToMediaMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Media == roRef.Media);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgWriteToMediaMethodResult::midw_diaglogfi_tclMsgWriteToMediaMethodResult(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgWriteToMediaMethodResult& midw_diaglogfi_tclMsgWriteToMediaMethodResult::operator=(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgWriteToMediaMethodResult::midw_diaglogfi_tclMsgWriteToMediaMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgWriteToMediaMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT;
}


midw_diaglogfi_tclMsgWriteToMediaMethodResult::~midw_diaglogfi_tclMsgWriteToMediaMethodResult()
{}

tU32 midw_diaglogfi_tclMsgWriteToMediaMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgWriteToMediaMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgWriteToMediaMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgWriteToMediaMethodResult::operator==(const midw_diaglogfi_tclMsgWriteToMediaMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
}
midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::operator=(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart()
:Group(0)
,StatusMask(0)
,DTCMask(0)
 {}

tS32 midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART;
}


midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::~midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart::operator==(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::operator=(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT;
}


midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::~midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult::operator==(const midw_diaglogfi_tclMsggetDTCbyStatusMaskMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::operator=(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart()
:Group(0)
 {}

tS32 midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART;
}


midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::~midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart::operator==(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::operator=(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT;
}


midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::~midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult::operator==(const midw_diaglogfi_tclMsggetLastConfirmedDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetSupportedDTCMethodStart::midw_diaglogfi_tclMsggetSupportedDTCMethodStart(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
midw_diaglogfi_tclMsggetSupportedDTCMethodStart& midw_diaglogfi_tclMsggetSupportedDTCMethodStart::operator=(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetSupportedDTCMethodStart::midw_diaglogfi_tclMsggetSupportedDTCMethodStart()
:Group(0)
 {}

tS32 midw_diaglogfi_tclMsggetSupportedDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART;
}


midw_diaglogfi_tclMsggetSupportedDTCMethodStart::~midw_diaglogfi_tclMsggetSupportedDTCMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetSupportedDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsggetSupportedDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetSupportedDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetSupportedDTCMethodStart::operator==(const midw_diaglogfi_tclMsggetSupportedDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetSupportedDTCMethodResult::midw_diaglogfi_tclMsggetSupportedDTCMethodResult(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetSupportedDTCMethodResult& midw_diaglogfi_tclMsggetSupportedDTCMethodResult::operator=(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetSupportedDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsggetSupportedDTCMethodResult::midw_diaglogfi_tclMsggetSupportedDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetSupportedDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT;
}


midw_diaglogfi_tclMsggetSupportedDTCMethodResult::~midw_diaglogfi_tclMsggetSupportedDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetSupportedDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetSupportedDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetSupportedDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetSupportedDTCMethodResult::operator==(const midw_diaglogfi_tclMsggetSupportedDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
}
midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::operator=(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart()
:Group(0)
,StatusMask(0)
,DTCMask(0)
 {}

tS32 midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART;
}


midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::~midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::operator==(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   NumberOfDTC = coRef.NumberOfDTC;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::operator=(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   NumberOfDTC = coRef.NumberOfDTC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult()
:StatusAvailabilityMask(0)
,NumberOfDTC(0)
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT;
}


midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::~midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult()
{}

tU32 midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> NumberOfDTC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << NumberOfDTC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::operator==(const midw_diaglogfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (NumberOfDTC == roRef.NumberOfDTC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetStatusByDTCMethodStart::midw_diaglogfi_tclMsggetStatusByDTCMethodStart(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
}
midw_diaglogfi_tclMsggetStatusByDTCMethodStart& midw_diaglogfi_tclMsggetStatusByDTCMethodStart::operator=(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetStatusByDTCMethodStart::midw_diaglogfi_tclMsggetStatusByDTCMethodStart()
:Group(0)
,DTCMask(0)
 {}

tS32 midw_diaglogfi_tclMsggetStatusByDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART;
}


midw_diaglogfi_tclMsggetStatusByDTCMethodStart::~midw_diaglogfi_tclMsggetStatusByDTCMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetStatusByDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglogfi_tclMsggetStatusByDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetStatusByDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetStatusByDTCMethodStart::operator==(const midw_diaglogfi_tclMsggetStatusByDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetStatusByDTCMethodResult::midw_diaglogfi_tclMsggetStatusByDTCMethodResult(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetStatusByDTCMethodResult& midw_diaglogfi_tclMsggetStatusByDTCMethodResult::operator=(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetStatusByDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsggetStatusByDTCMethodResult::midw_diaglogfi_tclMsggetStatusByDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetStatusByDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT;
}


midw_diaglogfi_tclMsggetStatusByDTCMethodResult::~midw_diaglogfi_tclMsggetStatusByDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetStatusByDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetStatusByDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetStatusByDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetStatusByDTCMethodResult::operator==(const midw_diaglogfi_tclMsggetStatusByDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCExtDataRecordNumber = coRef.DTCExtDataRecordNumber;
}
midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::operator=(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCExtDataRecordNumber = coRef.DTCExtDataRecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart()
:Group(0)
,DTC(0)
,DTCExtDataRecordNumber(0)
 {}

tS32 midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART;
}


midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::~midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCExtDataRecordNumber);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCExtDataRecordNumber);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart::operator==(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCExtDataRecordNumber == roRef.DTCExtDataRecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   FreezeFrameList = coRef.FreezeFrameList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::operator=(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   FreezeFrameList = coRef.FreezeFrameList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::vDestroy()
{
   FreezeFrameList.vDestroy(); 
}

midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult()
:DTC(0)
,StatusOfDtc(0)
,FreezeFrameList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT;
}


midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::~midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+FreezeFrameList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   (tVoid) (oIn >> FreezeFrameList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   (tVoid) (oOut << FreezeFrameList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult::operator==(const midw_diaglogfi_tclMsggetExtendedDataByDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   bResult = bResult && (FreezeFrameList == roRef.FreezeFrameList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetStatusByITCMethodStart::midw_diaglogfi_tclMsggetStatusByITCMethodStart(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   ITCMask = coRef.ITCMask;
}
midw_diaglogfi_tclMsggetStatusByITCMethodStart& midw_diaglogfi_tclMsggetStatusByITCMethodStart::operator=(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   ITCMask = coRef.ITCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsggetStatusByITCMethodStart::midw_diaglogfi_tclMsggetStatusByITCMethodStart()
:Group(0)
,ITCMask(0)
 {}

tS32 midw_diaglogfi_tclMsggetStatusByITCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART;
}


midw_diaglogfi_tclMsggetStatusByITCMethodStart::~midw_diaglogfi_tclMsggetStatusByITCMethodStart()
{}

tU32 midw_diaglogfi_tclMsggetStatusByITCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglogfi_tclMsggetStatusByITCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> ITCMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetStatusByITCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << ITCMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetStatusByITCMethodStart::operator==(const midw_diaglogfi_tclMsggetStatusByITCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (ITCMask == roRef.ITCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsggetStatusByITCMethodResult::midw_diaglogfi_tclMsggetStatusByITCMethodResult(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsggetStatusByITCMethodResult& midw_diaglogfi_tclMsggetStatusByITCMethodResult::operator=(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsggetStatusByITCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

midw_diaglogfi_tclMsggetStatusByITCMethodResult::midw_diaglogfi_tclMsggetStatusByITCMethodResult()
:ReadResultList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsggetStatusByITCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT;
}


midw_diaglogfi_tclMsggetStatusByITCMethodResult::~midw_diaglogfi_tclMsggetStatusByITCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsggetStatusByITCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsggetStatusByITCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsggetStatusByITCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsggetStatusByITCMethodResult::operator==(const midw_diaglogfi_tclMsggetStatusByITCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart()
:Group(0)
 {}

tS32 midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART;
}


midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::~midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart()
{}

tU32 midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart::operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   SnapshotIdentificationList = coRef.SnapshotIdentificationList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SnapshotIdentificationList = coRef.SnapshotIdentificationList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::vDestroy()
{
   SnapshotIdentificationList.vDestroy(); 
}

midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult()
:SnapshotIdentificationList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT;
}


midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::~midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SnapshotIdentificationList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SnapshotIdentificationList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SnapshotIdentificationList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult::operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotIdentificationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SnapshotIdentificationList == roRef.SnapshotIdentificationList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCSnapshotRecordNumber = coRef.DTCSnapshotRecordNumber;
}
midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCSnapshotRecordNumber = coRef.DTCSnapshotRecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart()
:Group(0)
,DTC(0)
,DTCSnapshotRecordNumber(0)
 {}

tS32 midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART;
}


midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::~midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart()
{}

tU32 midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCSnapshotRecordNumber);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCSnapshotRecordNumber);
   return oOut;
}

tBool midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCSnapshotRecordNumber == roRef.DTCSnapshotRecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   SnapshotDataList = coRef.SnapshotDataList;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::operator=(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   SnapshotDataList = coRef.SnapshotDataList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::vDestroy()
{
   SnapshotDataList.vDestroy(); 
}

midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult()
:DTC(0)
,StatusOfDtc(0)
,SnapshotDataList()
,Status()
 {}

tS32 midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT;
}


midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::~midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+SnapshotDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   (tVoid) (oIn >> SnapshotDataList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   (tVoid) (oOut << SnapshotDataList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::operator==(const midw_diaglogfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   bResult = bResult && (SnapshotDataList == roRef.SnapshotDataList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgclearDTCMethodStart::midw_diaglogfi_tclMsgclearDTCMethodStart(const midw_diaglogfi_tclMsgclearDTCMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
}
midw_diaglogfi_tclMsgclearDTCMethodStart& midw_diaglogfi_tclMsgclearDTCMethodStart::operator=(const midw_diaglogfi_tclMsgclearDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgclearDTCMethodStart::midw_diaglogfi_tclMsgclearDTCMethodStart()
:Group(0)
,DTCMask(0)
 {}

tS32 midw_diaglogfi_tclMsgclearDTCMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODSTART;
}


midw_diaglogfi_tclMsgclearDTCMethodStart::~midw_diaglogfi_tclMsgclearDTCMethodStart()
{}

tU32 midw_diaglogfi_tclMsgclearDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglogfi_tclMsgclearDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgclearDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsgclearDTCMethodStart::operator==(const midw_diaglogfi_tclMsgclearDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgclearDTCMethodResult::midw_diaglogfi_tclMsgclearDTCMethodResult(const midw_diaglogfi_tclMsgclearDTCMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgclearDTCMethodResult& midw_diaglogfi_tclMsgclearDTCMethodResult::operator=(const midw_diaglogfi_tclMsgclearDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgclearDTCMethodResult::midw_diaglogfi_tclMsgclearDTCMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgclearDTCMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT;
}


midw_diaglogfi_tclMsgclearDTCMethodResult::~midw_diaglogfi_tclMsgclearDTCMethodResult()
{}

tU32 midw_diaglogfi_tclMsgclearDTCMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgclearDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgclearDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgclearDTCMethodResult::operator==(const midw_diaglogfi_tclMsgclearDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgControlMethodStart::midw_diaglogfi_tclMsgControlMethodStart(const midw_diaglogfi_tclMsgControlMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ControlParameter = coRef.ControlParameter;
}
midw_diaglogfi_tclMsgControlMethodStart& midw_diaglogfi_tclMsgControlMethodStart::operator=(const midw_diaglogfi_tclMsgControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ControlParameter = coRef.ControlParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgControlMethodStart::midw_diaglogfi_tclMsgControlMethodStart()
:ControlParameter()
 {}

tS32 midw_diaglogfi_tclMsgControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODSTART;
}


midw_diaglogfi_tclMsgControlMethodStart::~midw_diaglogfi_tclMsgControlMethodStart()
{}

tU32 midw_diaglogfi_tclMsgControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlParameter);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlParameter);
   return oOut;
}

tBool midw_diaglogfi_tclMsgControlMethodStart::operator==(const midw_diaglogfi_tclMsgControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlParameter == roRef.ControlParameter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgControlMethodResult::midw_diaglogfi_tclMsgControlMethodResult(const midw_diaglogfi_tclMsgControlMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgControlMethodResult& midw_diaglogfi_tclMsgControlMethodResult::operator=(const midw_diaglogfi_tclMsgControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgControlMethodResult::midw_diaglogfi_tclMsgControlMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CONTROLMETHODRESULT;
}


midw_diaglogfi_tclMsgControlMethodResult::~midw_diaglogfi_tclMsgControlMethodResult()
{}

tU32 midw_diaglogfi_tclMsgControlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgControlMethodResult::operator==(const midw_diaglogfi_tclMsgControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgControlDtcSettingMethodStart::midw_diaglogfi_tclMsgControlDtcSettingMethodStart(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ControlParameter = coRef.ControlParameter;
   DTC_List = coRef.DTC_List;
}
midw_diaglogfi_tclMsgControlDtcSettingMethodStart& midw_diaglogfi_tclMsgControlDtcSettingMethodStart::operator=(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ControlParameter = coRef.ControlParameter;
   DTC_List = coRef.DTC_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgControlDtcSettingMethodStart::vDestroy()
{
   DTC_List.vDestroy(); 
}

midw_diaglogfi_tclMsgControlDtcSettingMethodStart::midw_diaglogfi_tclMsgControlDtcSettingMethodStart()
:ControlParameter()
,DTC_List()
 {}

tS32 midw_diaglogfi_tclMsgControlDtcSettingMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART;
}


midw_diaglogfi_tclMsgControlDtcSettingMethodStart::~midw_diaglogfi_tclMsgControlDtcSettingMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgControlDtcSettingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DTC_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgControlDtcSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlParameter);
   (tVoid) (oIn >> DTC_List);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgControlDtcSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlParameter);
   (tVoid) (oOut << DTC_List);
   return oOut;
}

tBool midw_diaglogfi_tclMsgControlDtcSettingMethodStart::operator==(const midw_diaglogfi_tclMsgControlDtcSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlParameter == roRef.ControlParameter);
   bResult = bResult && (DTC_List == roRef.DTC_List);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgControlDtcSettingMethodResult::midw_diaglogfi_tclMsgControlDtcSettingMethodResult(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgControlDtcSettingMethodResult& midw_diaglogfi_tclMsgControlDtcSettingMethodResult::operator=(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgControlDtcSettingMethodResult::midw_diaglogfi_tclMsgControlDtcSettingMethodResult()
:Status()
 {}

tS32 midw_diaglogfi_tclMsgControlDtcSettingMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT;
}


midw_diaglogfi_tclMsgControlDtcSettingMethodResult::~midw_diaglogfi_tclMsgControlDtcSettingMethodResult()
{}

tU32 midw_diaglogfi_tclMsgControlDtcSettingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgControlDtcSettingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgControlDtcSettingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgControlDtcSettingMethodResult::operator==(const midw_diaglogfi_tclMsgControlDtcSettingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::operator=(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart()
:DefSetStateGroup()
,DefSetStateMode()
 {}

tS32 midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART;
}


midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::~midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart()
{}

tU32 midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart::operator==(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::operator=(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult()
:DefSetStateGroup()
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT;
}


midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::~midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult()
{}

tU32 midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult::operator==(const midw_diaglogfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDTCActiveGet::midw_diaglogfi_tclMsgDTCActiveGet(const midw_diaglogfi_tclMsgDTCActiveGet& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   IsDTCActive = coRef.IsDTCActive;
}
midw_diaglogfi_tclMsgDTCActiveGet& midw_diaglogfi_tclMsgDTCActiveGet::operator=(const midw_diaglogfi_tclMsgDTCActiveGet& coRef)
{
   if (this == &coRef) return *this;
   IsDTCActive = coRef.IsDTCActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDTCActiveGet::midw_diaglogfi_tclMsgDTCActiveGet()
:IsDTCActive(0)
 {}

tS32 midw_diaglogfi_tclMsgDTCActiveGet::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEGET;
}


midw_diaglogfi_tclMsgDTCActiveGet::~midw_diaglogfi_tclMsgDTCActiveGet()
{}

tU32 midw_diaglogfi_tclMsgDTCActiveGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_diaglogfi_tclMsgDTCActiveGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsDTCActive);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDTCActiveGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsDTCActive);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDTCActiveGet::operator==(const midw_diaglogfi_tclMsgDTCActiveGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsDTCActive == roRef.IsDTCActive);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgDTCActiveUpReg::midw_diaglogfi_tclMsgDTCActiveUpReg()
 {}

tS32 midw_diaglogfi_tclMsgDTCActiveUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCACTIVEUPREG;
}


midw_diaglogfi_tclMsgDTCActiveUpReg::~midw_diaglogfi_tclMsgDTCActiveUpReg()
{}

//=============================================================================

midw_diaglogfi_tclMsgDTCActiveRelUpReg::midw_diaglogfi_tclMsgDTCActiveRelUpReg()
 {}

tS32 midw_diaglogfi_tclMsgDTCActiveRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCACTIVERELUPREG;
}


midw_diaglogfi_tclMsgDTCActiveRelUpReg::~midw_diaglogfi_tclMsgDTCActiveRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDTCActiveStatus::midw_diaglogfi_tclMsgDTCActiveStatus(const midw_diaglogfi_tclMsgDTCActiveStatus& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   IsDTCActive = coRef.IsDTCActive;
   DTC = coRef.DTC;
   DTCStatus = coRef.DTCStatus;
   DTCFailureType = coRef.DTCFailureType;
}
midw_diaglogfi_tclMsgDTCActiveStatus& midw_diaglogfi_tclMsgDTCActiveStatus::operator=(const midw_diaglogfi_tclMsgDTCActiveStatus& coRef)
{
   if (this == &coRef) return *this;
   IsDTCActive = coRef.IsDTCActive;
   DTC = coRef.DTC;
   DTCStatus = coRef.DTCStatus;
   DTCFailureType = coRef.DTCFailureType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDTCActiveStatus::midw_diaglogfi_tclMsgDTCActiveStatus()
:IsDTCActive(0)
,DTC(0)
,DTCStatus(0)
,DTCFailureType(0)
 {}

tS32 midw_diaglogfi_tclMsgDTCActiveStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCACTIVESTATUS;
}


midw_diaglogfi_tclMsgDTCActiveStatus::~midw_diaglogfi_tclMsgDTCActiveStatus()
{}

tU32 midw_diaglogfi_tclMsgDTCActiveStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_diaglogfi_tclMsgDTCActiveStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsDTCActive);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCStatus);
   (tVoid) (oIn >> DTCFailureType);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDTCActiveStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsDTCActive);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCStatus);
   (tVoid) (oOut << DTCFailureType);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDTCActiveStatus::operator==(const midw_diaglogfi_tclMsgDTCActiveStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsDTCActive == roRef.IsDTCActive);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCStatus == roRef.DTCStatus);
   bResult = bResult && (DTCFailureType == roRef.DTCFailureType);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgSendNextTestResultUpReg::midw_diaglogfi_tclMsgSendNextTestResultUpReg()
 {}

tS32 midw_diaglogfi_tclMsgSendNextTestResultUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG;
}


midw_diaglogfi_tclMsgSendNextTestResultUpReg::~midw_diaglogfi_tclMsgSendNextTestResultUpReg()
{}

//=============================================================================

midw_diaglogfi_tclMsgSendNextTestResultRelUpReg::midw_diaglogfi_tclMsgSendNextTestResultRelUpReg()
 {}

tS32 midw_diaglogfi_tclMsgSendNextTestResultRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG;
}


midw_diaglogfi_tclMsgSendNextTestResultRelUpReg::~midw_diaglogfi_tclMsgSendNextTestResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSendNextTestResultStatus::midw_diaglogfi_tclMsgSendNextTestResultStatus(const midw_diaglogfi_tclMsgSendNextTestResultStatus& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   NextTestResultStruct = coRef.NextTestResultStruct;
   Status = coRef.Status;
}
midw_diaglogfi_tclMsgSendNextTestResultStatus& midw_diaglogfi_tclMsgSendNextTestResultStatus::operator=(const midw_diaglogfi_tclMsgSendNextTestResultStatus& coRef)
{
   if (this == &coRef) return *this;
   NextTestResultStruct = coRef.NextTestResultStruct;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgSendNextTestResultStatus::vDestroy()
{
   NextTestResultStruct.vDestroy(); 
}

midw_diaglogfi_tclMsgSendNextTestResultStatus::midw_diaglogfi_tclMsgSendNextTestResultStatus()
:NextTestResultStruct()
,Status(0)
 {}

tS32 midw_diaglogfi_tclMsgSendNextTestResultStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS;
}


midw_diaglogfi_tclMsgSendNextTestResultStatus::~midw_diaglogfi_tclMsgSendNextTestResultStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgSendNextTestResultStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+NextTestResultStruct.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgSendNextTestResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NextTestResultStruct);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSendNextTestResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NextTestResultStruct);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSendNextTestResultStatus::operator==(const midw_diaglogfi_tclMsgSendNextTestResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NextTestResultStruct == roRef.NextTestResultStruct);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgDTCTriggeredUpReg::midw_diaglogfi_tclMsgDTCTriggeredUpReg()
 {}

tS32 midw_diaglogfi_tclMsgDTCTriggeredUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG;
}


midw_diaglogfi_tclMsgDTCTriggeredUpReg::~midw_diaglogfi_tclMsgDTCTriggeredUpReg()
{}

//=============================================================================

midw_diaglogfi_tclMsgDTCTriggeredRelUpReg::midw_diaglogfi_tclMsgDTCTriggeredRelUpReg()
 {}

tS32 midw_diaglogfi_tclMsgDTCTriggeredRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG;
}


midw_diaglogfi_tclMsgDTCTriggeredRelUpReg::~midw_diaglogfi_tclMsgDTCTriggeredRelUpReg()
{}

//=============================================================================

midw_diaglogfi_tclMsgDTCTriggeredGet::midw_diaglogfi_tclMsgDTCTriggeredGet()
 {}

tS32 midw_diaglogfi_tclMsgDTCTriggeredGet::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDGET;
}


midw_diaglogfi_tclMsgDTCTriggeredGet::~midw_diaglogfi_tclMsgDTCTriggeredGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDTCTriggeredStatus::midw_diaglogfi_tclMsgDTCTriggeredStatus(const midw_diaglogfi_tclMsgDTCTriggeredStatus& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   bDTCTriggeredFlag = coRef.bDTCTriggeredFlag;
   u8DTCSource = coRef.u8DTCSource;
   u16DTCNumber = coRef.u16DTCNumber;
   u8DTCFailureType = coRef.u8DTCFailureType;
   bDTCWarningIndicatorRequestedStatus = coRef.bDTCWarningIndicatorRequestedStatus;
   bDTCTestFailedSincePowerUpStatus = coRef.bDTCTestFailedSincePowerUpStatus;
   bDTCTestNotPassedSincePowerUpStatus = coRef.bDTCTestNotPassedSincePowerUpStatus;
   bDTCHistoryStatus = coRef.bDTCHistoryStatus;
   bDTCTestFailedSinceCodeClearedStatus = coRef.bDTCTestFailedSinceCodeClearedStatus;
   bDTCTestNotPassedSinceCodeClearedStatus = coRef.bDTCTestNotPassedSinceCodeClearedStatus;
   bDTCCurrentStatus = coRef.bDTCCurrentStatus;
   bDTCCodeSupported = coRef.bDTCCodeSupported;
   e8DTCFaultType = coRef.e8DTCFaultType;
}
midw_diaglogfi_tclMsgDTCTriggeredStatus& midw_diaglogfi_tclMsgDTCTriggeredStatus::operator=(const midw_diaglogfi_tclMsgDTCTriggeredStatus& coRef)
{
   if (this == &coRef) return *this;
   bDTCTriggeredFlag = coRef.bDTCTriggeredFlag;
   u8DTCSource = coRef.u8DTCSource;
   u16DTCNumber = coRef.u16DTCNumber;
   u8DTCFailureType = coRef.u8DTCFailureType;
   bDTCWarningIndicatorRequestedStatus = coRef.bDTCWarningIndicatorRequestedStatus;
   bDTCTestFailedSincePowerUpStatus = coRef.bDTCTestFailedSincePowerUpStatus;
   bDTCTestNotPassedSincePowerUpStatus = coRef.bDTCTestNotPassedSincePowerUpStatus;
   bDTCHistoryStatus = coRef.bDTCHistoryStatus;
   bDTCTestFailedSinceCodeClearedStatus = coRef.bDTCTestFailedSinceCodeClearedStatus;
   bDTCTestNotPassedSinceCodeClearedStatus = coRef.bDTCTestNotPassedSinceCodeClearedStatus;
   bDTCCurrentStatus = coRef.bDTCCurrentStatus;
   bDTCCodeSupported = coRef.bDTCCodeSupported;
   e8DTCFaultType = coRef.e8DTCFaultType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDTCTriggeredStatus::midw_diaglogfi_tclMsgDTCTriggeredStatus()
:bDTCTriggeredFlag(0)
,u8DTCSource(0)
,u16DTCNumber(0)
,u8DTCFailureType(0)
,bDTCWarningIndicatorRequestedStatus(0)
,bDTCTestFailedSincePowerUpStatus(0)
,bDTCTestNotPassedSincePowerUpStatus(0)
,bDTCHistoryStatus(0)
,bDTCTestFailedSinceCodeClearedStatus(0)
,bDTCTestNotPassedSinceCodeClearedStatus(0)
,bDTCCurrentStatus(0)
,bDTCCodeSupported(0)
,e8DTCFaultType()
 {}

tS32 midw_diaglogfi_tclMsgDTCTriggeredStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS;
}


midw_diaglogfi_tclMsgDTCTriggeredStatus::~midw_diaglogfi_tclMsgDTCTriggeredStatus()
{}

tU32 midw_diaglogfi_tclMsgDTCTriggeredStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& midw_diaglogfi_tclMsgDTCTriggeredStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDTCTriggeredFlag);
   (tVoid) (oIn >> u8DTCSource);
   (tVoid) (oIn >> u16DTCNumber);
   (tVoid) (oIn >> u8DTCFailureType);
   (tVoid) (oIn >> bDTCWarningIndicatorRequestedStatus);
   (tVoid) (oIn >> bDTCTestFailedSincePowerUpStatus);
   (tVoid) (oIn >> bDTCTestNotPassedSincePowerUpStatus);
   (tVoid) (oIn >> bDTCHistoryStatus);
   (tVoid) (oIn >> bDTCTestFailedSinceCodeClearedStatus);
   (tVoid) (oIn >> bDTCTestNotPassedSinceCodeClearedStatus);
   (tVoid) (oIn >> bDTCCurrentStatus);
   (tVoid) (oIn >> bDTCCodeSupported);
   (tVoid) (oIn >> e8DTCFaultType);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDTCTriggeredStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDTCTriggeredFlag);
   (tVoid) (oOut << u8DTCSource);
   (tVoid) (oOut << u16DTCNumber);
   (tVoid) (oOut << u8DTCFailureType);
   (tVoid) (oOut << bDTCWarningIndicatorRequestedStatus);
   (tVoid) (oOut << bDTCTestFailedSincePowerUpStatus);
   (tVoid) (oOut << bDTCTestNotPassedSincePowerUpStatus);
   (tVoid) (oOut << bDTCHistoryStatus);
   (tVoid) (oOut << bDTCTestFailedSinceCodeClearedStatus);
   (tVoid) (oOut << bDTCTestNotPassedSinceCodeClearedStatus);
   (tVoid) (oOut << bDTCCurrentStatus);
   (tVoid) (oOut << bDTCCodeSupported);
   (tVoid) (oOut << e8DTCFaultType);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDTCTriggeredStatus::operator==(const midw_diaglogfi_tclMsgDTCTriggeredStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDTCTriggeredFlag == roRef.bDTCTriggeredFlag);
   bResult = bResult && (u8DTCSource == roRef.u8DTCSource);
   bResult = bResult && (u16DTCNumber == roRef.u16DTCNumber);
   bResult = bResult && (u8DTCFailureType == roRef.u8DTCFailureType);
   bResult = bResult && (bDTCWarningIndicatorRequestedStatus == roRef.bDTCWarningIndicatorRequestedStatus);
   bResult = bResult && (bDTCTestFailedSincePowerUpStatus == roRef.bDTCTestFailedSincePowerUpStatus);
   bResult = bResult && (bDTCTestNotPassedSincePowerUpStatus == roRef.bDTCTestNotPassedSincePowerUpStatus);
   bResult = bResult && (bDTCHistoryStatus == roRef.bDTCHistoryStatus);
   bResult = bResult && (bDTCTestFailedSinceCodeClearedStatus == roRef.bDTCTestFailedSinceCodeClearedStatus);
   bResult = bResult && (bDTCTestNotPassedSinceCodeClearedStatus == roRef.bDTCTestNotPassedSinceCodeClearedStatus);
   bResult = bResult && (bDTCCurrentStatus == roRef.bDTCCurrentStatus);
   bResult = bResult && (bDTCCodeSupported == roRef.bDTCCodeSupported);
   bResult = bResult && (e8DTCFaultType == roRef.e8DTCFaultType);
   return bResult;
}

//=============================================================================

midw_diaglogfi_tclMsgSendActiveDTCListUpReg::midw_diaglogfi_tclMsgSendActiveDTCListUpReg()
 {}

tS32 midw_diaglogfi_tclMsgSendActiveDTCListUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG;
}


midw_diaglogfi_tclMsgSendActiveDTCListUpReg::~midw_diaglogfi_tclMsgSendActiveDTCListUpReg()
{}

//=============================================================================

midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg::midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg()
 {}

tS32 midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG;
}


midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg::~midw_diaglogfi_tclMsgSendActiveDTCListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgSendActiveDTCListStatus::midw_diaglogfi_tclMsgSendActiveDTCListStatus(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   ActiveDTCList = coRef.ActiveDTCList;
}
midw_diaglogfi_tclMsgSendActiveDTCListStatus& midw_diaglogfi_tclMsgSendActiveDTCListStatus::operator=(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& coRef)
{
   if (this == &coRef) return *this;
   ActiveDTCList = coRef.ActiveDTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglogfi_tclMsgSendActiveDTCListStatus::vDestroy()
{
   ActiveDTCList.vDestroy(); 
}

midw_diaglogfi_tclMsgSendActiveDTCListStatus::midw_diaglogfi_tclMsgSendActiveDTCListStatus()
:ActiveDTCList()
 {}

tS32 midw_diaglogfi_tclMsgSendActiveDTCListStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS;
}


midw_diaglogfi_tclMsgSendActiveDTCListStatus::~midw_diaglogfi_tclMsgSendActiveDTCListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglogfi_tclMsgSendActiveDTCListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ActiveDTCList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglogfi_tclMsgSendActiveDTCListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActiveDTCList);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgSendActiveDTCListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActiveDTCList);
   return oOut;
}

tBool midw_diaglogfi_tclMsgSendActiveDTCListStatus::operator==(const midw_diaglogfi_tclMsgSendActiveDTCListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActiveDTCList == roRef.ActiveDTCList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDtcStatusChangedUpReg::midw_diaglogfi_tclMsgDtcStatusChangedUpReg(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
}
midw_diaglogfi_tclMsgDtcStatusChangedUpReg& midw_diaglogfi_tclMsgDtcStatusChangedUpReg::operator=(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDtcStatusChangedUpReg::midw_diaglogfi_tclMsgDtcStatusChangedUpReg()
:Group(0)
,DTCNumber(0)
,DTCStatusBitMask(0)
 {}

tS32 midw_diaglogfi_tclMsgDtcStatusChangedUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG;
}


midw_diaglogfi_tclMsgDtcStatusChangedUpReg::~midw_diaglogfi_tclMsgDtcStatusChangedUpReg()
{}

tU32 midw_diaglogfi_tclMsgDtcStatusChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsgDtcStatusChangedUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCNumber);
   (tVoid) (oIn >> DTCStatusBitMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDtcStatusChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCNumber);
   (tVoid) (oOut << DTCStatusBitMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDtcStatusChangedUpReg::operator==(const midw_diaglogfi_tclMsgDtcStatusChangedUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCNumber == roRef.DTCNumber);
   bResult = bResult && (DTCStatusBitMask == roRef.DTCStatusBitMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
}
midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::operator=(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg()
:Group(0)
,DTCNumber(0)
,DTCStatusBitMask(0)
 {}

tS32 midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG;
}


midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::~midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg()
{}

tU32 midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCNumber);
   (tVoid) (oIn >> DTCStatusBitMask);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCNumber);
   (tVoid) (oOut << DTCStatusBitMask);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg::operator==(const midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCNumber == roRef.DTCNumber);
   bResult = bResult && (DTCStatusBitMask == roRef.DTCStatusBitMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglogfi_tclMsgDtcStatusChangedStatus::midw_diaglogfi_tclMsgDtcStatusChangedStatus(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& coRef)
   : midw_diaglogfi_tclMsgBaseMessage(coRef)
{
   DTCResponse = coRef.DTCResponse;
}
midw_diaglogfi_tclMsgDtcStatusChangedStatus& midw_diaglogfi_tclMsgDtcStatusChangedStatus::operator=(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   DTCResponse = coRef.DTCResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglogfi_tclMsgDtcStatusChangedStatus::midw_diaglogfi_tclMsgDtcStatusChangedStatus()
:DTCResponse()
 {}

tS32 midw_diaglogfi_tclMsgDtcStatusChangedStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglogfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS;
}


midw_diaglogfi_tclMsgDtcStatusChangedStatus::~midw_diaglogfi_tclMsgDtcStatusChangedStatus()
{}

tU32 midw_diaglogfi_tclMsgDtcStatusChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglogfi_tclMsgDtcStatusChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTCResponse);
   return oIn;
}

fi_tclOutContext& midw_diaglogfi_tclMsgDtcStatusChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTCResponse);
   return oOut;
}

tBool midw_diaglogfi_tclMsgDtcStatusChangedStatus::operator==(const midw_diaglogfi_tclMsgDtcStatusChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTCResponse == roRef.DTCResponse);
   return bResult;
}

