/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_diaglib_fi message types

fi_tclMessageBase* midw_diaglibfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgRoutineControlMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgRoutineControlMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODABORT:
         return OSAL_NEW midw_diaglibfi_tclMsgRoutineControlMethodAbort;

      case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgGetRoutineResultMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgGetRoutineResultMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgIOControlMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgIOControlMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetPrepareMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetPrepareMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetFinishedMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetFinishedMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetVerifyMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgSystemSetVerifyMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisReadMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisReadMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODSTART:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisWriteMethodStart;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODRESULT:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisWriteMethodResult;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATAGET:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisDataGet;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASET:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisDataSet;

      case midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASTATUS:
         return OSAL_NEW midw_diaglibfi_tclMsgDiagnosisDataStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_diaglibfifi messages

// common functions

tU16 midw_diaglibfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_DIAGLIBFI_C_U16_SERVICE_ID;
}

tU16 midw_diaglibfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_diaglibfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_diaglibfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_diaglibfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_diaglibfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_diaglibfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_diaglibfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgRoutineControlMethodStart::midw_diaglibfi_tclMsgRoutineControlMethodStart(const midw_diaglibfi_tclMsgRoutineControlMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   RoutineId = coRef.RoutineId;
   RoutineBitMask = coRef.RoutineBitMask;
   RoutineParameterList = coRef.RoutineParameterList;
}
midw_diaglibfi_tclMsgRoutineControlMethodStart& midw_diaglibfi_tclMsgRoutineControlMethodStart::operator=(const midw_diaglibfi_tclMsgRoutineControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RoutineId = coRef.RoutineId;
   RoutineBitMask = coRef.RoutineBitMask;
   RoutineParameterList = coRef.RoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgRoutineControlMethodStart::vDestroy()
{
   RoutineParameterList.vDestroy(); 
}

midw_diaglibfi_tclMsgRoutineControlMethodStart::midw_diaglibfi_tclMsgRoutineControlMethodStart()
:RoutineId(0)
,RoutineBitMask()
,RoutineParameterList()
 {}

tS32 midw_diaglibfi_tclMsgRoutineControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODSTART;
}


midw_diaglibfi_tclMsgRoutineControlMethodStart::~midw_diaglibfi_tclMsgRoutineControlMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgRoutineControlMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RoutineParameterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgRoutineControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoutineId);
   (tVoid) (oIn >> RoutineBitMask);
   (tVoid) (oIn >> RoutineParameterList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgRoutineControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoutineId);
   (tVoid) (oOut << RoutineBitMask);
   (tVoid) (oOut << RoutineParameterList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgRoutineControlMethodStart::operator==(const midw_diaglibfi_tclMsgRoutineControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoutineId == roRef.RoutineId);
   bResult = bResult && (RoutineBitMask == roRef.RoutineBitMask);
   bResult = bResult && (RoutineParameterList == roRef.RoutineParameterList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgRoutineControlMethodResult::midw_diaglibfi_tclMsgRoutineControlMethodResult(const midw_diaglibfi_tclMsgRoutineControlMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   RoutineId = coRef.RoutineId;
   RoutineStatus = coRef.RoutineStatus;
   RoutineResult = coRef.RoutineResult;
}
midw_diaglibfi_tclMsgRoutineControlMethodResult& midw_diaglibfi_tclMsgRoutineControlMethodResult::operator=(const midw_diaglibfi_tclMsgRoutineControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RoutineId = coRef.RoutineId;
   RoutineStatus = coRef.RoutineStatus;
   RoutineResult = coRef.RoutineResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgRoutineControlMethodResult::vDestroy()
{
   RoutineResult.vDestroy(); 
}

midw_diaglibfi_tclMsgRoutineControlMethodResult::midw_diaglibfi_tclMsgRoutineControlMethodResult()
:RoutineId(0)
,RoutineStatus()
,RoutineResult()
 {}

tS32 midw_diaglibfi_tclMsgRoutineControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODRESULT;
}


midw_diaglibfi_tclMsgRoutineControlMethodResult::~midw_diaglibfi_tclMsgRoutineControlMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgRoutineControlMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+RoutineResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgRoutineControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoutineId);
   (tVoid) (oIn >> RoutineStatus);
   (tVoid) (oIn >> RoutineResult);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgRoutineControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoutineId);
   (tVoid) (oOut << RoutineStatus);
   (tVoid) (oOut << RoutineResult);
   return oOut;
}

tBool midw_diaglibfi_tclMsgRoutineControlMethodResult::operator==(const midw_diaglibfi_tclMsgRoutineControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoutineId == roRef.RoutineId);
   bResult = bResult && (RoutineStatus == roRef.RoutineStatus);
   bResult = bResult && (RoutineResult == roRef.RoutineResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgRoutineControlMethodAbort::midw_diaglibfi_tclMsgRoutineControlMethodAbort(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   RoutineId = coRef.RoutineId;
}
midw_diaglibfi_tclMsgRoutineControlMethodAbort& midw_diaglibfi_tclMsgRoutineControlMethodAbort::operator=(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   RoutineId = coRef.RoutineId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgRoutineControlMethodAbort::midw_diaglibfi_tclMsgRoutineControlMethodAbort()
:RoutineId(0)
 {}

tS32 midw_diaglibfi_tclMsgRoutineControlMethodAbort::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_ROUTINECONTROLMETHODABORT;
}


midw_diaglibfi_tclMsgRoutineControlMethodAbort::~midw_diaglibfi_tclMsgRoutineControlMethodAbort()
{}

tU32 midw_diaglibfi_tclMsgRoutineControlMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diaglibfi_tclMsgRoutineControlMethodAbort::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoutineId);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgRoutineControlMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoutineId);
   return oOut;
}

tBool midw_diaglibfi_tclMsgRoutineControlMethodAbort::operator==(const midw_diaglibfi_tclMsgRoutineControlMethodAbort& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoutineId == roRef.RoutineId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgGetRoutineResultMethodStart::midw_diaglibfi_tclMsgGetRoutineResultMethodStart(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   RoutineId = coRef.RoutineId;
}
midw_diaglibfi_tclMsgGetRoutineResultMethodStart& midw_diaglibfi_tclMsgGetRoutineResultMethodStart::operator=(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RoutineId = coRef.RoutineId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgGetRoutineResultMethodStart::midw_diaglibfi_tclMsgGetRoutineResultMethodStart()
:RoutineId(0)
 {}

tS32 midw_diaglibfi_tclMsgGetRoutineResultMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODSTART;
}


midw_diaglibfi_tclMsgGetRoutineResultMethodStart::~midw_diaglibfi_tclMsgGetRoutineResultMethodStart()
{}

tU32 midw_diaglibfi_tclMsgGetRoutineResultMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diaglibfi_tclMsgGetRoutineResultMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoutineId);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgGetRoutineResultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoutineId);
   return oOut;
}

tBool midw_diaglibfi_tclMsgGetRoutineResultMethodStart::operator==(const midw_diaglibfi_tclMsgGetRoutineResultMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoutineId == roRef.RoutineId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgGetRoutineResultMethodResult::midw_diaglibfi_tclMsgGetRoutineResultMethodResult(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   RoutineId = coRef.RoutineId;
   RoutineStatus = coRef.RoutineStatus;
   RoutineResult = coRef.RoutineResult;
}
midw_diaglibfi_tclMsgGetRoutineResultMethodResult& midw_diaglibfi_tclMsgGetRoutineResultMethodResult::operator=(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RoutineId = coRef.RoutineId;
   RoutineStatus = coRef.RoutineStatus;
   RoutineResult = coRef.RoutineResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgGetRoutineResultMethodResult::vDestroy()
{
   RoutineResult.vDestroy(); 
}

midw_diaglibfi_tclMsgGetRoutineResultMethodResult::midw_diaglibfi_tclMsgGetRoutineResultMethodResult()
:RoutineId(0)
,RoutineStatus()
,RoutineResult()
 {}

tS32 midw_diaglibfi_tclMsgGetRoutineResultMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_GETROUTINERESULTMETHODRESULT;
}


midw_diaglibfi_tclMsgGetRoutineResultMethodResult::~midw_diaglibfi_tclMsgGetRoutineResultMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgGetRoutineResultMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+RoutineResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgGetRoutineResultMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoutineId);
   (tVoid) (oIn >> RoutineStatus);
   (tVoid) (oIn >> RoutineResult);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgGetRoutineResultMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoutineId);
   (tVoid) (oOut << RoutineStatus);
   (tVoid) (oOut << RoutineResult);
   return oOut;
}

tBool midw_diaglibfi_tclMsgGetRoutineResultMethodResult::operator==(const midw_diaglibfi_tclMsgGetRoutineResultMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoutineId == roRef.RoutineId);
   bResult = bResult && (RoutineStatus == roRef.RoutineStatus);
   bResult = bResult && (RoutineResult == roRef.RoutineResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgIOControlMethodStart::midw_diaglibfi_tclMsgIOControlMethodStart(const midw_diaglibfi_tclMsgIOControlMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   ControlId = coRef.ControlId;
   ActionId = coRef.ActionId;
   IOParameterList = coRef.IOParameterList;
}
midw_diaglibfi_tclMsgIOControlMethodStart& midw_diaglibfi_tclMsgIOControlMethodStart::operator=(const midw_diaglibfi_tclMsgIOControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ControlId = coRef.ControlId;
   ActionId = coRef.ActionId;
   IOParameterList = coRef.IOParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgIOControlMethodStart::vDestroy()
{
   IOParameterList.vDestroy(); 
}

midw_diaglibfi_tclMsgIOControlMethodStart::midw_diaglibfi_tclMsgIOControlMethodStart()
:ControlId(0)
,ActionId()
,IOParameterList()
 {}

tS32 midw_diaglibfi_tclMsgIOControlMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODSTART;
}


midw_diaglibfi_tclMsgIOControlMethodStart::~midw_diaglibfi_tclMsgIOControlMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgIOControlMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+IOParameterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgIOControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlId);
   (tVoid) (oIn >> ActionId);
   (tVoid) (oIn >> IOParameterList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgIOControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlId);
   (tVoid) (oOut << ActionId);
   (tVoid) (oOut << IOParameterList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgIOControlMethodStart::operator==(const midw_diaglibfi_tclMsgIOControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlId == roRef.ControlId);
   bResult = bResult && (ActionId == roRef.ActionId);
   bResult = bResult && (IOParameterList == roRef.IOParameterList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgIOControlMethodResult::midw_diaglibfi_tclMsgIOControlMethodResult(const midw_diaglibfi_tclMsgIOControlMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   ControlId = coRef.ControlId;
   ActionId = coRef.ActionId;
   IOResult = coRef.IOResult;
   IOResultList = coRef.IOResultList;
}
midw_diaglibfi_tclMsgIOControlMethodResult& midw_diaglibfi_tclMsgIOControlMethodResult::operator=(const midw_diaglibfi_tclMsgIOControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ControlId = coRef.ControlId;
   ActionId = coRef.ActionId;
   IOResult = coRef.IOResult;
   IOResultList = coRef.IOResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgIOControlMethodResult::vDestroy()
{
   IOResultList.vDestroy(); 
}

midw_diaglibfi_tclMsgIOControlMethodResult::midw_diaglibfi_tclMsgIOControlMethodResult()
:ControlId(0)
,ActionId()
,IOResult()
,IOResultList()
 {}

tS32 midw_diaglibfi_tclMsgIOControlMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_IOCONTROLMETHODRESULT;
}


midw_diaglibfi_tclMsgIOControlMethodResult::~midw_diaglibfi_tclMsgIOControlMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgIOControlMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+IOResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgIOControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlId);
   (tVoid) (oIn >> ActionId);
   (tVoid) (oIn >> IOResult);
   (tVoid) (oIn >> IOResultList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgIOControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlId);
   (tVoid) (oOut << ActionId);
   (tVoid) (oOut << IOResult);
   (tVoid) (oOut << IOResultList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgIOControlMethodResult::operator==(const midw_diaglibfi_tclMsgIOControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlId == roRef.ControlId);
   bResult = bResult && (ActionId == roRef.ActionId);
   bResult = bResult && (IOResult == roRef.IOResult);
   bResult = bResult && (IOResultList == roRef.IOResultList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::midw_diaglibfi_tclMsgSystemSetPrepareMethodStart(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
}
midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::operator=(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::midw_diaglibfi_tclMsgSystemSetPrepareMethodStart()
:SystemSetId(0)
,SystemSetMode()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODSTART;
}


midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::~midw_diaglibfi_tclMsgSystemSetPrepareMethodStart()
{}

tU32 midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetPrepareMethodStart::operator==(const midw_diaglibfi_tclMsgSystemSetPrepareMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::midw_diaglibfi_tclMsgSystemSetPrepareMethodResult(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ErrorList = coRef.ErrorList;
}
midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::operator=(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ErrorList = coRef.ErrorList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::vDestroy()
{
   ErrorList.vDestroy(); 
}

midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::midw_diaglibfi_tclMsgSystemSetPrepareMethodResult()
:SystemSetId(0)
,SystemSetMode()
,SystemSetResult()
,ErrorList()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETPREPAREMETHODRESULT;
}


midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::~midw_diaglibfi_tclMsgSystemSetPrepareMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+ErrorList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   (tVoid) (oIn >> SystemSetResult);
   (tVoid) (oIn >> ErrorList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   (tVoid) (oOut << SystemSetResult);
   (tVoid) (oOut << ErrorList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetPrepareMethodResult::operator==(const midw_diaglibfi_tclMsgSystemSetPrepareMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   bResult = bResult && (SystemSetResult == roRef.SystemSetResult);
   bResult = bResult && (ErrorList == roRef.ErrorList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::midw_diaglibfi_tclMsgSystemSetFinishedMethodStart(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
}
midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::operator=(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::midw_diaglibfi_tclMsgSystemSetFinishedMethodStart()
:SystemSetId(0)
,SystemSetMode()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODSTART;
}


midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::~midw_diaglibfi_tclMsgSystemSetFinishedMethodStart()
{}

tU32 midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetFinishedMethodStart::operator==(const midw_diaglibfi_tclMsgSystemSetFinishedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::midw_diaglibfi_tclMsgSystemSetFinishedMethodResult(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetResult = coRef.SystemSetResult;
}
midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::operator=(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetResult = coRef.SystemSetResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::midw_diaglibfi_tclMsgSystemSetFinishedMethodResult()
:SystemSetId(0)
,SystemSetResult()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETFINISHEDMETHODRESULT;
}


midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::~midw_diaglibfi_tclMsgSystemSetFinishedMethodResult()
{}

tU32 midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetResult);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetResult);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetFinishedMethodResult::operator==(const midw_diaglibfi_tclMsgSystemSetFinishedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetResult == roRef.SystemSetResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetMethodStart::midw_diaglibfi_tclMsgSystemSetMethodStart(const midw_diaglibfi_tclMsgSystemSetMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
}
midw_diaglibfi_tclMsgSystemSetMethodStart& midw_diaglibfi_tclMsgSystemSetMethodStart::operator=(const midw_diaglibfi_tclMsgSystemSetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgSystemSetMethodStart::midw_diaglibfi_tclMsgSystemSetMethodStart()
:SystemSetId(0)
,SystemSetMode()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODSTART;
}


midw_diaglibfi_tclMsgSystemSetMethodStart::~midw_diaglibfi_tclMsgSystemSetMethodStart()
{}

tU32 midw_diaglibfi_tclMsgSystemSetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetMethodStart::operator==(const midw_diaglibfi_tclMsgSystemSetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetMethodResult::midw_diaglibfi_tclMsgSystemSetMethodResult(const midw_diaglibfi_tclMsgSystemSetMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ErrorList = coRef.ErrorList;
}
midw_diaglibfi_tclMsgSystemSetMethodResult& midw_diaglibfi_tclMsgSystemSetMethodResult::operator=(const midw_diaglibfi_tclMsgSystemSetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ErrorList = coRef.ErrorList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgSystemSetMethodResult::vDestroy()
{
   ErrorList.vDestroy(); 
}

midw_diaglibfi_tclMsgSystemSetMethodResult::midw_diaglibfi_tclMsgSystemSetMethodResult()
:SystemSetId(0)
,SystemSetMode()
,SystemSetResult()
,ErrorList()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETMETHODRESULT;
}


midw_diaglibfi_tclMsgSystemSetMethodResult::~midw_diaglibfi_tclMsgSystemSetMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgSystemSetMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+ErrorList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   (tVoid) (oIn >> SystemSetResult);
   (tVoid) (oIn >> ErrorList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   (tVoid) (oOut << SystemSetResult);
   (tVoid) (oOut << ErrorList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetMethodResult::operator==(const midw_diaglibfi_tclMsgSystemSetMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   bResult = bResult && (SystemSetResult == roRef.SystemSetResult);
   bResult = bResult && (ErrorList == roRef.ErrorList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::midw_diaglibfi_tclMsgSystemSetVerifyMethodStart(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
}
midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::operator=(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::midw_diaglibfi_tclMsgSystemSetVerifyMethodStart()
:SystemSetId(0)
,SystemSetMode()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODSTART;
}


midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::~midw_diaglibfi_tclMsgSystemSetVerifyMethodStart()
{}

tU32 midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetVerifyMethodStart::operator==(const midw_diaglibfi_tclMsgSystemSetVerifyMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::midw_diaglibfi_tclMsgSystemSetVerifyMethodResult(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ValueList = coRef.ValueList;
}
midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::operator=(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SystemSetId = coRef.SystemSetId;
   SystemSetMode = coRef.SystemSetMode;
   SystemSetResult = coRef.SystemSetResult;
   ValueList = coRef.ValueList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::vDestroy()
{
   ValueList.vDestroy(); 
}

midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::midw_diaglibfi_tclMsgSystemSetVerifyMethodResult()
:SystemSetId(0)
,SystemSetMode()
,SystemSetResult()
,ValueList()
 {}

tS32 midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_SYSTEMSETVERIFYMETHODRESULT;
}


midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::~midw_diaglibfi_tclMsgSystemSetVerifyMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+ValueList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemSetId);
   (tVoid) (oIn >> SystemSetMode);
   (tVoid) (oIn >> SystemSetResult);
   (tVoid) (oIn >> ValueList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemSetId);
   (tVoid) (oOut << SystemSetMode);
   (tVoid) (oOut << SystemSetResult);
   (tVoid) (oOut << ValueList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgSystemSetVerifyMethodResult::operator==(const midw_diaglibfi_tclMsgSystemSetVerifyMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemSetId == roRef.SystemSetId);
   bResult = bResult && (SystemSetMode == roRef.SystemSetMode);
   bResult = bResult && (SystemSetResult == roRef.SystemSetResult);
   bResult = bResult && (ValueList == roRef.ValueList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisReadMethodStart::midw_diaglibfi_tclMsgDiagnosisReadMethodStart(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
}
midw_diaglibfi_tclMsgDiagnosisReadMethodStart& midw_diaglibfi_tclMsgDiagnosisReadMethodStart::operator=(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgDiagnosisReadMethodStart::midw_diaglibfi_tclMsgDiagnosisReadMethodStart()
:DiagnosisDataId(0)
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisReadMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODSTART;
}


midw_diaglibfi_tclMsgDiagnosisReadMethodStart::~midw_diaglibfi_tclMsgDiagnosisReadMethodStart()
{}

tU32 midw_diaglibfi_tclMsgDiagnosisReadMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisReadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisReadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisReadMethodStart::operator==(const midw_diaglibfi_tclMsgDiagnosisReadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisReadMethodResult::midw_diaglibfi_tclMsgDiagnosisReadMethodResult(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisReadResult = coRef.DiagnosisReadResult;
   DiagnosisReadValues = coRef.DiagnosisReadValues;
}
midw_diaglibfi_tclMsgDiagnosisReadMethodResult& midw_diaglibfi_tclMsgDiagnosisReadMethodResult::operator=(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisReadResult = coRef.DiagnosisReadResult;
   DiagnosisReadValues = coRef.DiagnosisReadValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgDiagnosisReadMethodResult::vDestroy()
{
   DiagnosisReadValues.vDestroy(); 
}

midw_diaglibfi_tclMsgDiagnosisReadMethodResult::midw_diaglibfi_tclMsgDiagnosisReadMethodResult()
:DiagnosisDataId(0)
,DiagnosisReadResult()
,DiagnosisReadValues()
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisReadMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISREADMETHODRESULT;
}


midw_diaglibfi_tclMsgDiagnosisReadMethodResult::~midw_diaglibfi_tclMsgDiagnosisReadMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgDiagnosisReadMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+DiagnosisReadValues.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisReadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   (tVoid) (oIn >> DiagnosisReadResult);
   (tVoid) (oIn >> DiagnosisReadValues);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisReadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   (tVoid) (oOut << DiagnosisReadResult);
   (tVoid) (oOut << DiagnosisReadValues);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisReadMethodResult::operator==(const midw_diaglibfi_tclMsgDiagnosisReadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   bResult = bResult && (DiagnosisReadResult == roRef.DiagnosisReadResult);
   bResult = bResult && (DiagnosisReadValues == roRef.DiagnosisReadValues);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::midw_diaglibfi_tclMsgDiagnosisWriteMethodStart(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteValues = coRef.DiagnosisWriteValues;
}
midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::operator=(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteValues = coRef.DiagnosisWriteValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::vDestroy()
{
   DiagnosisWriteValues.vDestroy(); 
}

midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::midw_diaglibfi_tclMsgDiagnosisWriteMethodStart()
:DiagnosisDataId(0)
,DiagnosisWriteValues()
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODSTART;
}


midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::~midw_diaglibfi_tclMsgDiagnosisWriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DiagnosisWriteValues.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   (tVoid) (oIn >> DiagnosisWriteValues);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   (tVoid) (oOut << DiagnosisWriteValues);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisWriteMethodStart::operator==(const midw_diaglibfi_tclMsgDiagnosisWriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   bResult = bResult && (DiagnosisWriteValues == roRef.DiagnosisWriteValues);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::midw_diaglibfi_tclMsgDiagnosisWriteMethodResult(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteResult = coRef.DiagnosisWriteResult;
   ErrorList = coRef.ErrorList;
}
midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::operator=(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteResult = coRef.DiagnosisWriteResult;
   ErrorList = coRef.ErrorList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::vDestroy()
{
   ErrorList.vDestroy(); 
}

midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::midw_diaglibfi_tclMsgDiagnosisWriteMethodResult()
:DiagnosisDataId(0)
,DiagnosisWriteResult()
,ErrorList()
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISWRITEMETHODRESULT;
}


midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::~midw_diaglibfi_tclMsgDiagnosisWriteMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+ErrorList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   (tVoid) (oIn >> DiagnosisWriteResult);
   (tVoid) (oIn >> ErrorList);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   (tVoid) (oOut << DiagnosisWriteResult);
   (tVoid) (oOut << ErrorList);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisWriteMethodResult::operator==(const midw_diaglibfi_tclMsgDiagnosisWriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   bResult = bResult && (DiagnosisWriteResult == roRef.DiagnosisWriteResult);
   bResult = bResult && (ErrorList == roRef.ErrorList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisDataGet::midw_diaglibfi_tclMsgDiagnosisDataGet(const midw_diaglibfi_tclMsgDiagnosisDataGet& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
}
midw_diaglibfi_tclMsgDiagnosisDataGet& midw_diaglibfi_tclMsgDiagnosisDataGet::operator=(const midw_diaglibfi_tclMsgDiagnosisDataGet& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_diaglibfi_tclMsgDiagnosisDataGet::midw_diaglibfi_tclMsgDiagnosisDataGet()
:DiagnosisDataId(0)
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisDataGet::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATAGET;
}


midw_diaglibfi_tclMsgDiagnosisDataGet::~midw_diaglibfi_tclMsgDiagnosisDataGet()
{}

tU32 midw_diaglibfi_tclMsgDiagnosisDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisDataGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisDataGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisDataGet::operator==(const midw_diaglibfi_tclMsgDiagnosisDataGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisDataSet::midw_diaglibfi_tclMsgDiagnosisDataSet(const midw_diaglibfi_tclMsgDiagnosisDataSet& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteValues = coRef.DiagnosisWriteValues;
}
midw_diaglibfi_tclMsgDiagnosisDataSet& midw_diaglibfi_tclMsgDiagnosisDataSet::operator=(const midw_diaglibfi_tclMsgDiagnosisDataSet& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisWriteValues = coRef.DiagnosisWriteValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgDiagnosisDataSet::vDestroy()
{
   DiagnosisWriteValues.vDestroy(); 
}

midw_diaglibfi_tclMsgDiagnosisDataSet::midw_diaglibfi_tclMsgDiagnosisDataSet()
:DiagnosisDataId(0)
,DiagnosisWriteValues()
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisDataSet::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASET;
}


midw_diaglibfi_tclMsgDiagnosisDataSet::~midw_diaglibfi_tclMsgDiagnosisDataSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgDiagnosisDataSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DiagnosisWriteValues.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisDataSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   (tVoid) (oIn >> DiagnosisWriteValues);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisDataSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   (tVoid) (oOut << DiagnosisWriteValues);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisDataSet::operator==(const midw_diaglibfi_tclMsgDiagnosisDataSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   bResult = bResult && (DiagnosisWriteValues == roRef.DiagnosisWriteValues);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_diaglibfi_tclMsgDiagnosisDataStatus::midw_diaglibfi_tclMsgDiagnosisDataStatus(const midw_diaglibfi_tclMsgDiagnosisDataStatus& coRef)
   : midw_diaglibfi_tclMsgBaseMessage(coRef)
{
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisDataResult = coRef.DiagnosisDataResult;
   DiagnosisDataValues = coRef.DiagnosisDataValues;
}
midw_diaglibfi_tclMsgDiagnosisDataStatus& midw_diaglibfi_tclMsgDiagnosisDataStatus::operator=(const midw_diaglibfi_tclMsgDiagnosisDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisDataId = coRef.DiagnosisDataId;
   DiagnosisDataResult = coRef.DiagnosisDataResult;
   DiagnosisDataValues = coRef.DiagnosisDataValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_diaglibfi_tclMsgDiagnosisDataStatus::vDestroy()
{
   DiagnosisDataValues.vDestroy(); 
}

midw_diaglibfi_tclMsgDiagnosisDataStatus::midw_diaglibfi_tclMsgDiagnosisDataStatus()
:DiagnosisDataId(0)
,DiagnosisDataResult()
,DiagnosisDataValues()
 {}

tS32 midw_diaglibfi_tclMsgDiagnosisDataStatus::s32GetTypeId() const
{
   return (tS32) midw_diaglibfi_tclToken::EN_MSG_DIAGNOSISDATASTATUS;
}


midw_diaglibfi_tclMsgDiagnosisDataStatus::~midw_diaglibfi_tclMsgDiagnosisDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_diaglibfi_tclMsgDiagnosisDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+DiagnosisDataValues.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_diaglibfi_tclMsgDiagnosisDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisDataId);
   (tVoid) (oIn >> DiagnosisDataResult);
   (tVoid) (oIn >> DiagnosisDataValues);
   return oIn;
}

fi_tclOutContext& midw_diaglibfi_tclMsgDiagnosisDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisDataId);
   (tVoid) (oOut << DiagnosisDataResult);
   (tVoid) (oOut << DiagnosisDataValues);
   return oOut;
}

tBool midw_diaglibfi_tclMsgDiagnosisDataStatus::operator==(const midw_diaglibfi_tclMsgDiagnosisDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisDataId == roRef.DiagnosisDataId);
   bResult = bResult && (DiagnosisDataResult == roRef.DiagnosisDataResult);
   bResult = bResult && (DiagnosisDataValues == roRef.DiagnosisDataValues);
   return bResult;
}

