/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_DEVICEMANAGERFITYPES_HEADER
#define MIDW_DEVICEMANAGERFITYPES_HEADER


class midw_devicemanagerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_devicemanager_fi message types

fi_tclMessageBase* midw_devicemanagerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_devicemanagerfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_devicemanagerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& operator=(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef);
   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString DeviceSerialNo;
   virtual ~midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& operator=(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef);
   midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DevManager_DeviceProperty DeviceProperty;
   virtual ~midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart();

   virtual ~midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart();

   inline tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& operator=(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef);
   midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_DevManager_DevInfoStr DevInfoArr;
   virtual ~midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg();

   virtual ~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg();

   inline tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg();

   virtual ~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg();

   inline tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet();

   virtual ~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet();

   inline tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus : public midw_devicemanagerfi_tclMsgBaseMessage
{
public:

   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& operator=(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef);
   midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_DevManager_DeviceProperty, std::allocator<midw_fi_tcl_DevManager_DeviceProperty> > Devicetype;
   virtual ~midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
