/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_CMAFITYPES_HEADER
#define MIDW_CMAFITYPES_HEADER


class midw_cmafi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_cma_fi message types

fi_tclMessageBase* midw_cmafi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_cmafi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_cmafi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_cmafi_tclMsgAsBuiltInfoMethodStart : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAsBuiltInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_cmafi_tclMsgAsBuiltInfoMethodStart& operator=(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& coRef);
   midw_cmafi_tclMsgAsBuiltInfoMethodStart(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 DeviceId;
   virtual ~midw_cmafi_tclMsgAsBuiltInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgAsBuiltInfoMethodResult : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAsBuiltInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_cmafi_tclMsgAsBuiltInfoMethodResult& operator=(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& coRef);
   midw_cmafi_tclMsgAsBuiltInfoMethodResult(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString AsBuiltInfo;
   virtual ~midw_cmafi_tclMsgAsBuiltInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgAvailabilityUpReg : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAvailabilityUpReg();

   virtual ~midw_cmafi_tclMsgAvailabilityUpReg();

   inline tBool operator==(const midw_cmafi_tclMsgAvailabilityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgAvailabilityRelUpReg : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAvailabilityRelUpReg();

   virtual ~midw_cmafi_tclMsgAvailabilityRelUpReg();

   inline tBool operator==(const midw_cmafi_tclMsgAvailabilityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgAvailabilityGet : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAvailabilityGet();

   virtual ~midw_cmafi_tclMsgAvailabilityGet();

   inline tBool operator==(const midw_cmafi_tclMsgAvailabilityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgAvailabilityStatus : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgAvailabilityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_cmafi_tclMsgAvailabilityStatus& operator=(const midw_cmafi_tclMsgAvailabilityStatus& coRef);
   midw_cmafi_tclMsgAvailabilityStatus(const midw_cmafi_tclMsgAvailabilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsReady;
   virtual ~midw_cmafi_tclMsgAvailabilityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_cmafi_tclMsgAvailabilityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgPublishingMonitorUpReg : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgPublishingMonitorUpReg();

   virtual ~midw_cmafi_tclMsgPublishingMonitorUpReg();

   inline tBool operator==(const midw_cmafi_tclMsgPublishingMonitorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgPublishingMonitorRelUpReg : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgPublishingMonitorRelUpReg();

   virtual ~midw_cmafi_tclMsgPublishingMonitorRelUpReg();

   inline tBool operator==(const midw_cmafi_tclMsgPublishingMonitorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgPublishingMonitorGet : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgPublishingMonitorGet();

   virtual ~midw_cmafi_tclMsgPublishingMonitorGet();

   inline tBool operator==(const midw_cmafi_tclMsgPublishingMonitorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgPublishingMonitorStatus : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgPublishingMonitorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_cmafi_tclMsgPublishingMonitorStatus& operator=(const midw_cmafi_tclMsgPublishingMonitorStatus& coRef);
   midw_cmafi_tclMsgPublishingMonitorStatus(const midw_cmafi_tclMsgPublishingMonitorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > PublishedServices;
   virtual ~midw_cmafi_tclMsgPublishingMonitorStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_cmafi_tclMsgPublishingMonitorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgCumulatedMessageCounterGet : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgCumulatedMessageCounterGet();

   virtual ~midw_cmafi_tclMsgCumulatedMessageCounterGet();

   inline tBool operator==(const midw_cmafi_tclMsgCumulatedMessageCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_cmafi_tclMsgCumulatedMessageCounterStatus : public midw_cmafi_tclMsgBaseMessage
{
public:

   midw_cmafi_tclMsgCumulatedMessageCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_cmafi_tclMsgCumulatedMessageCounterStatus& operator=(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& coRef);
   midw_cmafi_tclMsgCumulatedMessageCounterStatus(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CurrentValue;
   virtual ~midw_cmafi_tclMsgCumulatedMessageCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
