/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CMAFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CMAFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CMAFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_cma_fi message types

fi_tclMessageBase* midw_cmafi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_cmafi_tclToken::EN_MSG_ASBUILTINFOMETHODSTART:
         return OSAL_NEW midw_cmafi_tclMsgAsBuiltInfoMethodStart;

      case midw_cmafi_tclToken::EN_MSG_ASBUILTINFOMETHODRESULT:
         return OSAL_NEW midw_cmafi_tclMsgAsBuiltInfoMethodResult;

      case midw_cmafi_tclToken::EN_MSG_AVAILABILITYUPREG:
         return OSAL_NEW midw_cmafi_tclMsgAvailabilityUpReg;

      case midw_cmafi_tclToken::EN_MSG_AVAILABILITYRELUPREG:
         return OSAL_NEW midw_cmafi_tclMsgAvailabilityRelUpReg;

      case midw_cmafi_tclToken::EN_MSG_AVAILABILITYGET:
         return OSAL_NEW midw_cmafi_tclMsgAvailabilityGet;

      case midw_cmafi_tclToken::EN_MSG_AVAILABILITYSTATUS:
         return OSAL_NEW midw_cmafi_tclMsgAvailabilityStatus;

      case midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORUPREG:
         return OSAL_NEW midw_cmafi_tclMsgPublishingMonitorUpReg;

      case midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORRELUPREG:
         return OSAL_NEW midw_cmafi_tclMsgPublishingMonitorRelUpReg;

      case midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORGET:
         return OSAL_NEW midw_cmafi_tclMsgPublishingMonitorGet;

      case midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORSTATUS:
         return OSAL_NEW midw_cmafi_tclMsgPublishingMonitorStatus;

      case midw_cmafi_tclToken::EN_MSG_CUMULATEDMESSAGECOUNTERGET:
         return OSAL_NEW midw_cmafi_tclMsgCumulatedMessageCounterGet;

      case midw_cmafi_tclToken::EN_MSG_CUMULATEDMESSAGECOUNTERSTATUS:
         return OSAL_NEW midw_cmafi_tclMsgCumulatedMessageCounterStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_cmafifi messages

// common functions

tU16 midw_cmafi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_CMAFI_C_U16_SERVICE_ID;
}

tU16 midw_cmafi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_cmafi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_cmafi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_cmafi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_cmafi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_cmafi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_cmafi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_cmafi_tclMsgAsBuiltInfoMethodStart::midw_cmafi_tclMsgAsBuiltInfoMethodStart(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& coRef)
   : midw_cmafi_tclMsgBaseMessage(coRef)
{
   DeviceId = coRef.DeviceId;
}
midw_cmafi_tclMsgAsBuiltInfoMethodStart& midw_cmafi_tclMsgAsBuiltInfoMethodStart::operator=(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceId = coRef.DeviceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_cmafi_tclMsgAsBuiltInfoMethodStart::midw_cmafi_tclMsgAsBuiltInfoMethodStart()
:DeviceId(0)
 {}

tS32 midw_cmafi_tclMsgAsBuiltInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_ASBUILTINFOMETHODSTART;
}


midw_cmafi_tclMsgAsBuiltInfoMethodStart::~midw_cmafi_tclMsgAsBuiltInfoMethodStart()
{}

tU32 midw_cmafi_tclMsgAsBuiltInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_cmafi_tclMsgAsBuiltInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceId);
   return oIn;
}

fi_tclOutContext& midw_cmafi_tclMsgAsBuiltInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceId);
   return oOut;
}

tBool midw_cmafi_tclMsgAsBuiltInfoMethodStart::operator==(const midw_cmafi_tclMsgAsBuiltInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceId == roRef.DeviceId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_cmafi_tclMsgAsBuiltInfoMethodResult::midw_cmafi_tclMsgAsBuiltInfoMethodResult(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& coRef)
   : midw_cmafi_tclMsgBaseMessage(coRef)
{
   AsBuiltInfo = coRef.AsBuiltInfo;
}
midw_cmafi_tclMsgAsBuiltInfoMethodResult& midw_cmafi_tclMsgAsBuiltInfoMethodResult::operator=(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AsBuiltInfo = coRef.AsBuiltInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_cmafi_tclMsgAsBuiltInfoMethodResult::vDestroy()
{
   AsBuiltInfo.vDestroy();
}

midw_cmafi_tclMsgAsBuiltInfoMethodResult::midw_cmafi_tclMsgAsBuiltInfoMethodResult()
:AsBuiltInfo()
 {}

tS32 midw_cmafi_tclMsgAsBuiltInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_ASBUILTINFOMETHODRESULT;
}


midw_cmafi_tclMsgAsBuiltInfoMethodResult::~midw_cmafi_tclMsgAsBuiltInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_cmafi_tclMsgAsBuiltInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AsBuiltInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_cmafi_tclMsgAsBuiltInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AsBuiltInfo);
   return oIn;
}

fi_tclOutContext& midw_cmafi_tclMsgAsBuiltInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AsBuiltInfo);
   return oOut;
}

tBool midw_cmafi_tclMsgAsBuiltInfoMethodResult::operator==(const midw_cmafi_tclMsgAsBuiltInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AsBuiltInfo == roRef.AsBuiltInfo);
   return bResult;
}

//=============================================================================

midw_cmafi_tclMsgAvailabilityUpReg::midw_cmafi_tclMsgAvailabilityUpReg()
 {}

tS32 midw_cmafi_tclMsgAvailabilityUpReg::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_AVAILABILITYUPREG;
}


midw_cmafi_tclMsgAvailabilityUpReg::~midw_cmafi_tclMsgAvailabilityUpReg()
{}

//=============================================================================

midw_cmafi_tclMsgAvailabilityRelUpReg::midw_cmafi_tclMsgAvailabilityRelUpReg()
 {}

tS32 midw_cmafi_tclMsgAvailabilityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_AVAILABILITYRELUPREG;
}


midw_cmafi_tclMsgAvailabilityRelUpReg::~midw_cmafi_tclMsgAvailabilityRelUpReg()
{}

//=============================================================================

midw_cmafi_tclMsgAvailabilityGet::midw_cmafi_tclMsgAvailabilityGet()
 {}

tS32 midw_cmafi_tclMsgAvailabilityGet::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_AVAILABILITYGET;
}


midw_cmafi_tclMsgAvailabilityGet::~midw_cmafi_tclMsgAvailabilityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_cmafi_tclMsgAvailabilityStatus::midw_cmafi_tclMsgAvailabilityStatus(const midw_cmafi_tclMsgAvailabilityStatus& coRef)
   : midw_cmafi_tclMsgBaseMessage(coRef)
{
   IsReady = coRef.IsReady;
}
midw_cmafi_tclMsgAvailabilityStatus& midw_cmafi_tclMsgAvailabilityStatus::operator=(const midw_cmafi_tclMsgAvailabilityStatus& coRef)
{
   if (this == &coRef) return *this;
   IsReady = coRef.IsReady;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_cmafi_tclMsgAvailabilityStatus::midw_cmafi_tclMsgAvailabilityStatus()
:IsReady(0)
 {}

tS32 midw_cmafi_tclMsgAvailabilityStatus::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_AVAILABILITYSTATUS;
}


midw_cmafi_tclMsgAvailabilityStatus::~midw_cmafi_tclMsgAvailabilityStatus()
{}

tU32 midw_cmafi_tclMsgAvailabilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_cmafi_tclMsgAvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsReady);
   return oIn;
}

fi_tclOutContext& midw_cmafi_tclMsgAvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsReady);
   return oOut;
}

tBool midw_cmafi_tclMsgAvailabilityStatus::operator==(const midw_cmafi_tclMsgAvailabilityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsReady == roRef.IsReady);
   return bResult;
}

//=============================================================================

midw_cmafi_tclMsgPublishingMonitorUpReg::midw_cmafi_tclMsgPublishingMonitorUpReg()
 {}

tS32 midw_cmafi_tclMsgPublishingMonitorUpReg::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORUPREG;
}


midw_cmafi_tclMsgPublishingMonitorUpReg::~midw_cmafi_tclMsgPublishingMonitorUpReg()
{}

//=============================================================================

midw_cmafi_tclMsgPublishingMonitorRelUpReg::midw_cmafi_tclMsgPublishingMonitorRelUpReg()
 {}

tS32 midw_cmafi_tclMsgPublishingMonitorRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORRELUPREG;
}


midw_cmafi_tclMsgPublishingMonitorRelUpReg::~midw_cmafi_tclMsgPublishingMonitorRelUpReg()
{}

//=============================================================================

midw_cmafi_tclMsgPublishingMonitorGet::midw_cmafi_tclMsgPublishingMonitorGet()
 {}

tS32 midw_cmafi_tclMsgPublishingMonitorGet::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORGET;
}


midw_cmafi_tclMsgPublishingMonitorGet::~midw_cmafi_tclMsgPublishingMonitorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_cmafi_tclMsgPublishingMonitorStatus::midw_cmafi_tclMsgPublishingMonitorStatus(const midw_cmafi_tclMsgPublishingMonitorStatus& coRef)
   : midw_cmafi_tclMsgBaseMessage(coRef)
{
   PublishedServices = coRef.PublishedServices;
}
midw_cmafi_tclMsgPublishingMonitorStatus& midw_cmafi_tclMsgPublishingMonitorStatus::operator=(const midw_cmafi_tclMsgPublishingMonitorStatus& coRef)
{
   if (this == &coRef) return *this;
   PublishedServices = coRef.PublishedServices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_cmafi_tclMsgPublishingMonitorStatus::vDestroy()
{
   {
   PublishedServices.clear();
   }
}

midw_cmafi_tclMsgPublishingMonitorStatus::midw_cmafi_tclMsgPublishingMonitorStatus()

 {}

tS32 midw_cmafi_tclMsgPublishingMonitorStatus::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_PUBLISHINGMONITORSTATUS;
}


midw_cmafi_tclMsgPublishingMonitorStatus::~midw_cmafi_tclMsgPublishingMonitorStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_cmafi_tclMsgPublishingMonitorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(PublishedServices.size()*2);
}

fi_tclInContext& midw_cmafi_tclMsgPublishingMonitorStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PublishedServices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PublishedServices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_cmafi_tclMsgPublishingMonitorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PublishedServices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PublishedServices.size(); ++u32Idx)
         (tVoid) (oOut << PublishedServices[u32Idx]);
   }
   return oOut;
}

tBool midw_cmafi_tclMsgPublishingMonitorStatus::operator==(const midw_cmafi_tclMsgPublishingMonitorStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PublishedServices.size() == roRef.PublishedServices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PublishedServices.size()); ++u32Idx)
            bResult = bResult && (PublishedServices[u32Idx] == roRef.PublishedServices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_cmafi_tclMsgCumulatedMessageCounterGet::midw_cmafi_tclMsgCumulatedMessageCounterGet()
 {}

tS32 midw_cmafi_tclMsgCumulatedMessageCounterGet::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_CUMULATEDMESSAGECOUNTERGET;
}


midw_cmafi_tclMsgCumulatedMessageCounterGet::~midw_cmafi_tclMsgCumulatedMessageCounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_cmafi_tclMsgCumulatedMessageCounterStatus::midw_cmafi_tclMsgCumulatedMessageCounterStatus(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& coRef)
   : midw_cmafi_tclMsgBaseMessage(coRef)
{
   CurrentValue = coRef.CurrentValue;
}
midw_cmafi_tclMsgCumulatedMessageCounterStatus& midw_cmafi_tclMsgCumulatedMessageCounterStatus::operator=(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentValue = coRef.CurrentValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_cmafi_tclMsgCumulatedMessageCounterStatus::midw_cmafi_tclMsgCumulatedMessageCounterStatus()
:CurrentValue(0)
 {}

tS32 midw_cmafi_tclMsgCumulatedMessageCounterStatus::s32GetTypeId() const
{
   return (tS32) midw_cmafi_tclToken::EN_MSG_CUMULATEDMESSAGECOUNTERSTATUS;
}


midw_cmafi_tclMsgCumulatedMessageCounterStatus::~midw_cmafi_tclMsgCumulatedMessageCounterStatus()
{}

tU32 midw_cmafi_tclMsgCumulatedMessageCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_cmafi_tclMsgCumulatedMessageCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentValue);
   return oIn;
}

fi_tclOutContext& midw_cmafi_tclMsgCumulatedMessageCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentValue);
   return oOut;
}

tBool midw_cmafi_tclMsgCumulatedMessageCounterStatus::operator==(const midw_cmafi_tclMsgCumulatedMessageCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentValue == roRef.CurrentValue);
   return bResult;
}

