/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_audio_route_mgr_fi message types

fi_tclMessageBase* midw_audio_route_mgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_audio_route_mgrfi_tclToken::EN_MSG_LOADSOURCESETTINGSMETHODSTART:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYRELUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYGET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSTATUS:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYGET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet;

      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS:
         return OSAL_NEW midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_audio_route_mgrfifi messages

// common functions

tU16 midw_audio_route_mgrfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_AUDIO_ROUTE_MGRFI_C_U16_SERVICE_ID;
}

tU16 midw_audio_route_mgrfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_audio_route_mgrfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_audio_route_mgrfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_audio_route_mgrfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_audio_route_mgrfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   SourceRouteActivity = coRef.SourceRouteActivity;
}
midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::operator=(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SourceRouteActivity = coRef.SourceRouteActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart()
:SourceRouteActivity()
 {}

tS32 midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_LOADSOURCESETTINGSMETHODSTART;
}


midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::~midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart()
{}

tU32 midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceRouteActivity);
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceRouteActivity);
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart::operator==(const midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceRouteActivity == roRef.SourceRouteActivity);
   return bResult;
}

//=============================================================================

midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYUPREG;
}


midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg::~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYRELUPREG;
}


midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg::~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityRelUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet()
 {}

tS32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYGET;
}


midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet::~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   SourceRouteActivity = coRef.SourceRouteActivity;
}
midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::operator=(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& coRef)
{
   if (this == &coRef) return *this;
   SourceRouteActivity = coRef.SourceRouteActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet()
:SourceRouteActivity()
 {}

tS32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSET;
}


midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet()
{}

tU32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceRouteActivity);
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceRouteActivity);
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet::operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceRouteActivity == roRef.SourceRouteActivity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   SourceRouteActivity = coRef.SourceRouteActivity;
   ErrorCode = coRef.ErrorCode;
}
midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::operator=(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& coRef)
{
   if (this == &coRef) return *this;
   SourceRouteActivity = coRef.SourceRouteActivity;
   ErrorCode = coRef.ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus()
:SourceRouteActivity()
,ErrorCode(0)
 {}

tS32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSTATUS;
}


midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::~midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus()
{}

tU32 midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceRouteActivity);
   (tVoid) (oIn >> ErrorCode);
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceRouteActivity);
   (tVoid) (oOut << ErrorCode);
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus::operator==(const midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceRouteActivity == roRef.SourceRouteActivity);
   bResult = bResult && (ErrorCode == roRef.ErrorCode);
   return bResult;
}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg::midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRelUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet::midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   RequestAudioRouteList = coRef.RequestAudioRouteList;
}
midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& coRef)
{
   if (this == &coRef) return *this;
   RequestAudioRouteList = coRef.RequestAudioRouteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
         RequestAudioRouteList[u32Idx].vDestroy();
   RequestAudioRouteList.clear();
   }
}

midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus()

 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(RequestAudioRouteList.size()*5);
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
      {
         RequestAudioRouteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RequestAudioRouteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RequestAudioRouteList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RequestAudioRouteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
         (tVoid) (oOut << RequestAudioRouteList[u32Idx]);
   }
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus::operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RequestAudioRouteList.size() == roRef.RequestAudioRouteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequestAudioRouteList.size()); ++u32Idx)
            bResult = bResult && (RequestAudioRouteList[u32Idx] == roRef.RequestAudioRouteList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg::midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG;
}


midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg::~midw_audio_route_mgrfi_tclMsgSourceAvailabilityUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg::midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG;
}


midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg::~midw_audio_route_mgrfi_tclMsgSourceAvailabilityRelUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet::midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet()
 {}

tS32 midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYGET;
}


midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet::~midw_audio_route_mgrfi_tclMsgSourceAvailabilityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   SourceAvailabilityList = coRef.SourceAvailabilityList;
}
midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::operator=(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& coRef)
{
   if (this == &coRef) return *this;
   SourceAvailabilityList = coRef.SourceAvailabilityList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
         SourceAvailabilityList[u32Idx].vDestroy();
   SourceAvailabilityList.clear();
   }
}

midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus()

 {}

tS32 midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS;
}


midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::~midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SourceAvailabilityList.size()*5);
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
      {
         SourceAvailabilityList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SourceAvailabilityList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SourceAvailabilityList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SourceAvailabilityList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
         (tVoid) (oOut << SourceAvailabilityList[u32Idx]);
   }
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus::operator==(const midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SourceAvailabilityList.size() == roRef.SourceAvailabilityList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SourceAvailabilityList.size()); ++u32Idx)
            bResult = bResult && (SourceAvailabilityList[u32Idx] == roRef.SourceAvailabilityList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectRelUpReg()
{}

//=============================================================================

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet()
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   Reason = coRef.Reason;
}
midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet()
:Source()
,SubSource(0)
,Reason(0)
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet()
{}

tU32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> SubSource);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << SubSource);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet::operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (SubSource == roRef.SubSource);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& coRef)
   : midw_audio_route_mgrfi_tclMsgBaseMessage(coRef)
{
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   Reason = coRef.Reason;
}
midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::operator=(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   SubSource = coRef.SubSource;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus()
:Source()
,SubSource(0)
,Reason(0)
 {}

tS32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::s32GetTypeId() const
{
   return (tS32) midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS;
}


midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::~midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus()
{}

tU32 midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> SubSource);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << SubSource);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus::operator==(const midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (SubSource == roRef.SubSource);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

