#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_STDVISITORS
#include "midw_fi_gen_if.h"

tBool midw_audio_route_mgrfi_tclDescription::bInitMessage(midw_audio_route_mgrfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_audio_route_mgrfi_tclToken::EN_LAST_TOKEN:
   case midw_audio_route_mgrfi_tclToken::EN_LIST:
   case midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT:
   case midw_audio_route_mgrfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_audio_route_mgrfi_tclToken::EN_MSG_LOADSOURCESETTINGSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_SOURCEROUTEACTIVITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCEROUTEACTIVITY)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSET:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_SOURCEROUTEACTIVITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCEROUTEACTIVITY)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSTATUS:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_ERRORCODE)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_SOURCEROUTEACTIVITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCEROUTEACTIVITY)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_REQUESTAUDIOROUTEITEM,midw_audio_route_mgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_LIST,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_REQUESTAUDIOROUTELIST)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_SOURCEAVAILABLITYITEM,midw_audio_route_mgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_LIST,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCEAVAILABILITYLIST)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_REASON)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SUBSOURCE)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCE)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS:
   {
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_REASON)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SUBSOURCE)) && bResult;
      bResult = oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_MSG_SOURCE)) && bResult;
   } break;
   case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYRELUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYGET:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYGET:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG:
   case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET:
   case midw_audio_route_mgrfi_tclToken::EN_BINCONTAINER:
   case midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE:
   case midw_audio_route_mgrfi_tclToken::EN_E8_SRCACTIVITY:
   case midw_audio_route_mgrfi_tclToken::EN_E8_RESOURCENO:
   case midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITYREASON:
   case midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITY:
   case midw_audio_route_mgrfi_tclToken::EN_SOURCEAVAILABLITYITEM:
   case midw_audio_route_mgrfi_tclToken::EN_REQUESTAUDIOROUTEITEM:
   case midw_audio_route_mgrfi_tclToken::EN_SOURCEROUTEACTIVITY:
   case midw_audio_route_mgrfi_tclToken::EN_U8:   
   case midw_audio_route_mgrfi_tclToken::EN_S8:   
   case midw_audio_route_mgrfi_tclToken::EN_U16:   
   case midw_audio_route_mgrfi_tclToken::EN_S16:   
   case midw_audio_route_mgrfi_tclToken::EN_U24:   
   case midw_audio_route_mgrfi_tclToken::EN_S24:   
   case midw_audio_route_mgrfi_tclToken::EN_U32:   
   case midw_audio_route_mgrfi_tclToken::EN_S32:   
   case midw_audio_route_mgrfi_tclToken::EN_U64:   
   case midw_audio_route_mgrfi_tclToken::EN_S64:   
   case midw_audio_route_mgrfi_tclToken::EN_F32:   
   case midw_audio_route_mgrfi_tclToken::EN_F64:   
   case midw_audio_route_mgrfi_tclToken::EN_BOOL:   
   case midw_audio_route_mgrfi_tclToken::EN_STRING:   
   case midw_audio_route_mgrfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(enMsgToken,midw_audio_route_mgrfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_audio_route_mgrfi_tclDescription::bDoIt(midw_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_audio_route_mgrfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_audio_route_mgrfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_audio_route_mgrfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_audio_route_mgrfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_audio_route_mgrfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_audio_route_mgrfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_audio_route_mgrfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_LIST: 
      {
         midw_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_audio_route_mgrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_audio_route_mgrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_U8: 
      {
         midw_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_U16: 
      {
         midw_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_U24: 
      {
         midw_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_U32: 
      {
         midw_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_U64: 
      {
         midw_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_S8: 
      {
         midw_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_S16: 
      {
         midw_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_S24: 
      {
         midw_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_S32: 
      {
         midw_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_S64: 
      {
         midw_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_F32: 
      {
         midw_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_F64: 
      {
         midw_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_BOOL: 
      {
         midw_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_STRING: 
      {
         midw_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_audio_route_mgrfi_tclToken::EN_MSG_LOADSOURCESETTINGSMETHODSTART:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYRELUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYGET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_P_SOURCEROUTEACTIVITYSTATUS:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYGET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET:
      case midw_audio_route_mgrfi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_audio_route_mgrfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT,midw_audio_route_mgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U8,midw_audio_route_mgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_LIST,midw_audio_route_mgrfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE:
      {
         midw_fi_tcl_e8_AudSource o_e8_AudSource;
         if (!bDoIt(o_e8_AudSource))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_E8_SRCACTIVITY:
      {
         midw_fi_tcl_e8_SrcActivity o_e8_SrcActivity;
         if (!bDoIt(o_e8_SrcActivity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_E8_RESOURCENO:
      {
         midw_fi_tcl_e8_ResourceNo o_e8_ResourceNo;
         if (!bDoIt(o_e8_ResourceNo))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITYREASON:
      {
         midw_fi_tcl_e8_SrcAvailabilityReason o_e8_SrcAvailabilityReason;
         if (!bDoIt(o_e8_SrcAvailabilityReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITY:
      {
         midw_fi_tcl_e8_SrcAvailability o_e8_SrcAvailability;
         if (!bDoIt(o_e8_SrcAvailability))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_SOURCEAVAILABLITYITEM:
      {
      if (poVisitor->bDoExpand_SourceAvailablityItem(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT,midw_audio_route_mgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_E8AVAILABILITY));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_SRCAVAILABILITYREASON,midw_audio_route_mgrfi_tclSemanticDomain::EN_E8REASON));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_U16SUBSOURCE));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_U8SOURCE));
      }
      else
      {
         midw_fi_tcl_SourceAvailablityItem o_SourceAvailablityItem;
         if (!bDoIt(o_SourceAvailablityItem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SourceAvailablityItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SourceAvailablityItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_REQUESTAUDIOROUTEITEM:
      {
      if (poVisitor->bDoExpand_RequestAudioRouteItem(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT,midw_audio_route_mgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_SRCACTIVITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_E8ACTIVITY));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U8,midw_audio_route_mgrfi_tclSemanticDomain::EN_U8REASON));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_U16SUBSOURCE));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_U8SOURCE));
      }
      else
      {
         midw_fi_tcl_RequestAudioRouteItem o_RequestAudioRouteItem;
         if (!bDoIt(o_RequestAudioRouteItem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequestAudioRouteItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RequestAudioRouteItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_SOURCEROUTEACTIVITY:
      {
      if (poVisitor->bDoExpand_SourceRouteActivity(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_END_OF_STRUCT,midw_audio_route_mgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_SRCACTIVITY,midw_audio_route_mgrfi_tclSemanticDomain::EN_ACTIVITY));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_RESOURCENO,midw_audio_route_mgrfi_tclSemanticDomain::EN_RESOURCE));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_POSSIBLENEXTSOURCE));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_U16,midw_audio_route_mgrfi_tclSemanticDomain::EN_SUBSOURCE));
         (tVoid) oPath.bGoDown(midw_audio_route_mgrfi_tclKnot(midw_audio_route_mgrfi_tclToken::EN_E8_AUDSOURCE,midw_audio_route_mgrfi_tclSemanticDomain::EN_SOURCE));
      }
      else
      {
         midw_fi_tcl_SourceRouteActivity o_SourceRouteActivity;
         if (!bDoIt(o_SourceRouteActivity))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SourceRouteActivity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SourceRouteActivity.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_audio_route_mgrfi_tclToken::EN_UNKNOWN:
      case midw_audio_route_mgrfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

