/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_aud_src_route_fi message types

fi_tclMessageBase* midw_aud_src_routefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_aud_src_routefi_tclToken::EN_MSG_ALLOCATEMETHODSTART:
         return OSAL_NEW midw_aud_src_routefi_tclMsgAllocateMethodStart;

      case midw_aud_src_routefi_tclToken::EN_MSG_ALLOCATEMETHODRESULT:
         return OSAL_NEW midw_aud_src_routefi_tclMsgAllocateMethodResult;

      case midw_aud_src_routefi_tclToken::EN_MSG_DEALLOCATEMETHODSTART:
         return OSAL_NEW midw_aud_src_routefi_tclMsgDeAllocateMethodStart;

      case midw_aud_src_routefi_tclToken::EN_MSG_DEALLOCATEMETHODRESULT:
         return OSAL_NEW midw_aud_src_routefi_tclMsgDeAllocateMethodResult;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEACTIVITYMETHODSTART:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceActivityMethodStart;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEACTIVITYMETHODRESULT:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceActivityMethodResult;

      case midw_aud_src_routefi_tclToken::EN_MSG_SRCACTTIMEREXPIRYMETHODSTART:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart;

      case midw_aud_src_routefi_tclToken::EN_MSG_SRCACTTIMEREXPIRYMETHODRESULT:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteRequestUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTRELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteRequestRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTSTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteRequestStatus;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATEUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteStateUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATERELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteStateRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATESET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteStateSet;

      case midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATESTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgMuteStateStatus;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteGet;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteStatus;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYGET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceAvailabilityGet;

      case midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSourceAvailabilityStatus;

      case midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYGET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSetAudioPropertyGet;

      case midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgSetAudioPropertyStatus;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet;

      case midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS:
         return OSAL_NEW midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_aud_src_routefifi messages

// common functions

tU16 midw_aud_src_routefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_AUD_SRC_ROUTEFI_C_U16_SERVICE_ID;
}

tU16 midw_aud_src_routefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_aud_src_routefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_aud_src_routefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_aud_src_routefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_aud_src_routefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgAllocateMethodStart::midw_aud_src_routefi_tclMsgAllocateMethodStart(const midw_aud_src_routefi_tclMsgAllocateMethodStart& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Sink = coRef.u16Sink;
}
midw_aud_src_routefi_tclMsgAllocateMethodStart& midw_aud_src_routefi_tclMsgAllocateMethodStart::operator=(const midw_aud_src_routefi_tclMsgAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Sink = coRef.u16Sink;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgAllocateMethodStart::midw_aud_src_routefi_tclMsgAllocateMethodStart()
:u8Source()
,u16SubSource(0)
,u16Sink(0)
 {}

tS32 midw_aud_src_routefi_tclMsgAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_ALLOCATEMETHODSTART;
}


midw_aud_src_routefi_tclMsgAllocateMethodStart::~midw_aud_src_routefi_tclMsgAllocateMethodStart()
{}

tU32 midw_aud_src_routefi_tclMsgAllocateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u16Sink);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u16Sink);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgAllocateMethodStart::operator==(const midw_aud_src_routefi_tclMsgAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u16Sink == roRef.u16Sink);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgAllocateMethodResult::midw_aud_src_routefi_tclMsgAllocateMethodResult(const midw_aud_src_routefi_tclMsgAllocateMethodResult& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Sink = coRef.u16Sink;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   u16Error = coRef.u16Error;
}
midw_aud_src_routefi_tclMsgAllocateMethodResult& midw_aud_src_routefi_tclMsgAllocateMethodResult::operator=(const midw_aud_src_routefi_tclMsgAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Sink = coRef.u16Sink;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   u16Error = coRef.u16Error;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgAllocateMethodResult::midw_aud_src_routefi_tclMsgAllocateMethodResult()
:u8Source()
,u16SubSource(0)
,u16Sink(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
,u16Error(0x00)
 {}

tS32 midw_aud_src_routefi_tclMsgAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_ALLOCATEMETHODRESULT;
}


midw_aud_src_routefi_tclMsgAllocateMethodResult::~midw_aud_src_routefi_tclMsgAllocateMethodResult()
{}

tU32 midw_aud_src_routefi_tclMsgAllocateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u16Sink);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   (tVoid) (oIn >> u16Error);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u16Sink);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   (tVoid) (oOut << u16Error);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgAllocateMethodResult::operator==(const midw_aud_src_routefi_tclMsgAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u16Sink == roRef.u16Sink);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   bResult = bResult && (u16Error == roRef.u16Error);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgDeAllocateMethodStart::midw_aud_src_routefi_tclMsgDeAllocateMethodStart(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
}
midw_aud_src_routefi_tclMsgDeAllocateMethodStart& midw_aud_src_routefi_tclMsgDeAllocateMethodStart::operator=(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgDeAllocateMethodStart::midw_aud_src_routefi_tclMsgDeAllocateMethodStart()
:u8Source()
,u16SubSource(0)
 {}

tS32 midw_aud_src_routefi_tclMsgDeAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_DEALLOCATEMETHODSTART;
}


midw_aud_src_routefi_tclMsgDeAllocateMethodStart::~midw_aud_src_routefi_tclMsgDeAllocateMethodStart()
{}

tU32 midw_aud_src_routefi_tclMsgDeAllocateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgDeAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgDeAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgDeAllocateMethodStart::operator==(const midw_aud_src_routefi_tclMsgDeAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgDeAllocateMethodResult::midw_aud_src_routefi_tclMsgDeAllocateMethodResult(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Error = coRef.u16Error;
}
midw_aud_src_routefi_tclMsgDeAllocateMethodResult& midw_aud_src_routefi_tclMsgDeAllocateMethodResult::operator=(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Error = coRef.u16Error;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgDeAllocateMethodResult::midw_aud_src_routefi_tclMsgDeAllocateMethodResult()
:u8Source()
,u16SubSource(0)
,u16Error(0x00)
 {}

tS32 midw_aud_src_routefi_tclMsgDeAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_DEALLOCATEMETHODRESULT;
}


midw_aud_src_routefi_tclMsgDeAllocateMethodResult::~midw_aud_src_routefi_tclMsgDeAllocateMethodResult()
{}

tU32 midw_aud_src_routefi_tclMsgDeAllocateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgDeAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u16Error);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgDeAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u16Error);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgDeAllocateMethodResult::operator==(const midw_aud_src_routefi_tclMsgDeAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u16Error == roRef.u16Error);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSourceActivityMethodStart::midw_aud_src_routefi_tclMsgSourceActivityMethodStart(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Activity = coRef.e8Activity;
   u8PosNextSrc = coRef.u8PosNextSrc;
}
midw_aud_src_routefi_tclMsgSourceActivityMethodStart& midw_aud_src_routefi_tclMsgSourceActivityMethodStart::operator=(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Activity = coRef.e8Activity;
   u8PosNextSrc = coRef.u8PosNextSrc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgSourceActivityMethodStart::midw_aud_src_routefi_tclMsgSourceActivityMethodStart()
:u8Source()
,u16SubSource(0)
,e8Activity()
,u8PosNextSrc()
 {}

tS32 midw_aud_src_routefi_tclMsgSourceActivityMethodStart::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEACTIVITYMETHODSTART;
}


midw_aud_src_routefi_tclMsgSourceActivityMethodStart::~midw_aud_src_routefi_tclMsgSourceActivityMethodStart()
{}

tU32 midw_aud_src_routefi_tclMsgSourceActivityMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSourceActivityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> e8Activity);
   (tVoid) (oIn >> u8PosNextSrc);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSourceActivityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << e8Activity);
   (tVoid) (oOut << u8PosNextSrc);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSourceActivityMethodStart::operator==(const midw_aud_src_routefi_tclMsgSourceActivityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   bResult = bResult && (u8PosNextSrc == roRef.u8PosNextSrc);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSourceActivityMethodResult::midw_aud_src_routefi_tclMsgSourceActivityMethodResult(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Activity = coRef.e8Activity;
   u16Error = coRef.u16Error;
}
midw_aud_src_routefi_tclMsgSourceActivityMethodResult& midw_aud_src_routefi_tclMsgSourceActivityMethodResult::operator=(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   e8Activity = coRef.e8Activity;
   u16Error = coRef.u16Error;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgSourceActivityMethodResult::midw_aud_src_routefi_tclMsgSourceActivityMethodResult()
:u8Source()
,u16SubSource(0)
,e8Activity()
,u16Error(0x00)
 {}

tS32 midw_aud_src_routefi_tclMsgSourceActivityMethodResult::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEACTIVITYMETHODRESULT;
}


midw_aud_src_routefi_tclMsgSourceActivityMethodResult::~midw_aud_src_routefi_tclMsgSourceActivityMethodResult()
{}

tU32 midw_aud_src_routefi_tclMsgSourceActivityMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSourceActivityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> e8Activity);
   (tVoid) (oIn >> u16Error);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSourceActivityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << e8Activity);
   (tVoid) (oOut << u16Error);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSourceActivityMethodResult::operator==(const midw_aud_src_routefi_tclMsgSourceActivityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   bResult = bResult && (u16Error == roRef.u16Error);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
}
midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::operator=(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart()
:u8Source()
 {}

tS32 midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SRCACTTIMEREXPIRYMETHODSTART;
}


midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::~midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart()
{}

tU32 midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart::operator==(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
}
midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::operator=(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult()
:u8Source()
 {}

tS32 midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SRCACTTIMEREXPIRYMETHODRESULT;
}


midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::~midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult()
{}

tU32 midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult::operator==(const midw_aud_src_routefi_tclMsgSrcActTimerExpiryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgMuteRequestUpReg::midw_aud_src_routefi_tclMsgMuteRequestUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteRequestUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTUPREG;
}


midw_aud_src_routefi_tclMsgMuteRequestUpReg::~midw_aud_src_routefi_tclMsgMuteRequestUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgMuteRequestRelUpReg::midw_aud_src_routefi_tclMsgMuteRequestRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTRELUPREG;
}


midw_aud_src_routefi_tclMsgMuteRequestRelUpReg::~midw_aud_src_routefi_tclMsgMuteRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgMuteRequestStatus::midw_aud_src_routefi_tclMsgMuteRequestStatus(const midw_aud_src_routefi_tclMsgMuteRequestStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   MuteRequestList = coRef.MuteRequestList;
}
midw_aud_src_routefi_tclMsgMuteRequestStatus& midw_aud_src_routefi_tclMsgMuteRequestStatus::operator=(const midw_aud_src_routefi_tclMsgMuteRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   MuteRequestList = coRef.MuteRequestList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_aud_src_routefi_tclMsgMuteRequestStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MuteRequestList.size(); ++u32Idx)
         MuteRequestList[u32Idx].vDestroy();
   MuteRequestList.clear();
   }
}

midw_aud_src_routefi_tclMsgMuteRequestStatus::midw_aud_src_routefi_tclMsgMuteRequestStatus()

 {}

tS32 midw_aud_src_routefi_tclMsgMuteRequestStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTEREQUESTSTATUS;
}


midw_aud_src_routefi_tclMsgMuteRequestStatus::~midw_aud_src_routefi_tclMsgMuteRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_aud_src_routefi_tclMsgMuteRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MuteRequestList.size()*6);
}

fi_tclInContext& midw_aud_src_routefi_tclMsgMuteRequestStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MuteRequestList.size(); ++u32Idx)
      {
         MuteRequestList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MuteRequestList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MuteRequestList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgMuteRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MuteRequestList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MuteRequestList.size(); ++u32Idx)
         (tVoid) (oOut << MuteRequestList[u32Idx]);
   }
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgMuteRequestStatus::operator==(const midw_aud_src_routefi_tclMsgMuteRequestStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MuteRequestList.size() == roRef.MuteRequestList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MuteRequestList.size()); ++u32Idx)
            bResult = bResult && (MuteRequestList[u32Idx] == roRef.MuteRequestList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgMuteStateUpReg::midw_aud_src_routefi_tclMsgMuteStateUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATEUPREG;
}


midw_aud_src_routefi_tclMsgMuteStateUpReg::~midw_aud_src_routefi_tclMsgMuteStateUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgMuteStateRelUpReg::midw_aud_src_routefi_tclMsgMuteStateRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATERELUPREG;
}


midw_aud_src_routefi_tclMsgMuteStateRelUpReg::~midw_aud_src_routefi_tclMsgMuteStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgMuteStateSet::midw_aud_src_routefi_tclMsgMuteStateSet(const midw_aud_src_routefi_tclMsgMuteStateSet& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8MuteState = coRef.u8MuteState;
}
midw_aud_src_routefi_tclMsgMuteStateSet& midw_aud_src_routefi_tclMsgMuteStateSet::operator=(const midw_aud_src_routefi_tclMsgMuteStateSet& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8MuteState = coRef.u8MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgMuteStateSet::midw_aud_src_routefi_tclMsgMuteStateSet()
:u8Source()
,u8MuteState()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteStateSet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATESET;
}


midw_aud_src_routefi_tclMsgMuteStateSet::~midw_aud_src_routefi_tclMsgMuteStateSet()
{}

tU32 midw_aud_src_routefi_tclMsgMuteStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgMuteStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8MuteState);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgMuteStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8MuteState);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgMuteStateSet::operator==(const midw_aud_src_routefi_tclMsgMuteStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgMuteStateStatus::midw_aud_src_routefi_tclMsgMuteStateStatus(const midw_aud_src_routefi_tclMsgMuteStateStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8MuteState = coRef.u8MuteState;
}
midw_aud_src_routefi_tclMsgMuteStateStatus& midw_aud_src_routefi_tclMsgMuteStateStatus::operator=(const midw_aud_src_routefi_tclMsgMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8MuteState = coRef.u8MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgMuteStateStatus::midw_aud_src_routefi_tclMsgMuteStateStatus()
:u8Source()
,u8MuteState()
 {}

tS32 midw_aud_src_routefi_tclMsgMuteStateStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_MUTESTATESTATUS;
}


midw_aud_src_routefi_tclMsgMuteStateStatus::~midw_aud_src_routefi_tclMsgMuteStateStatus()
{}

tU32 midw_aud_src_routefi_tclMsgMuteStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8MuteState);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8MuteState);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgMuteStateStatus::operator==(const midw_aud_src_routefi_tclMsgMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8MuteState == roRef.u8MuteState);
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg::midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEUPREG;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg::~midw_aud_src_routefi_tclMsgRequestAudioRouteUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg::midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTERELUPREG;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg::~midw_aud_src_routefi_tclMsgRequestAudioRouteRelUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteGet::midw_aud_src_routefi_tclMsgRequestAudioRouteGet()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteGet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEGET;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteGet::~midw_aud_src_routefi_tclMsgRequestAudioRouteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::midw_aud_src_routefi_tclMsgRequestAudioRouteStatus(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   RequestAudioRouteList = coRef.RequestAudioRouteList;
}
midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& coRef)
{
   if (this == &coRef) return *this;
   RequestAudioRouteList = coRef.RequestAudioRouteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
         RequestAudioRouteList[u32Idx].vDestroy();
   RequestAudioRouteList.clear();
   }
}

midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::midw_aud_src_routefi_tclMsgRequestAudioRouteStatus()

 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTESTATUS;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::~midw_aud_src_routefi_tclMsgRequestAudioRouteStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(RequestAudioRouteList.size()*5);
}

fi_tclInContext& midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
      {
         RequestAudioRouteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RequestAudioRouteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RequestAudioRouteList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RequestAudioRouteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RequestAudioRouteList.size(); ++u32Idx)
         (tVoid) (oOut << RequestAudioRouteList[u32Idx]);
   }
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgRequestAudioRouteStatus::operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RequestAudioRouteList.size() == roRef.RequestAudioRouteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RequestAudioRouteList.size()); ++u32Idx)
            bResult = bResult && (RequestAudioRouteList[u32Idx] == roRef.RequestAudioRouteList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg::midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYUPREG;
}


midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg::~midw_aud_src_routefi_tclMsgSourceAvailabilityUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg::midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYRELUPREG;
}


midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg::~midw_aud_src_routefi_tclMsgSourceAvailabilityRelUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgSourceAvailabilityGet::midw_aud_src_routefi_tclMsgSourceAvailabilityGet()
 {}

tS32 midw_aud_src_routefi_tclMsgSourceAvailabilityGet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYGET;
}


midw_aud_src_routefi_tclMsgSourceAvailabilityGet::~midw_aud_src_routefi_tclMsgSourceAvailabilityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::midw_aud_src_routefi_tclMsgSourceAvailabilityStatus(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   SourceAvailabilityList = coRef.SourceAvailabilityList;
}
midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::operator=(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& coRef)
{
   if (this == &coRef) return *this;
   SourceAvailabilityList = coRef.SourceAvailabilityList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
         SourceAvailabilityList[u32Idx].vDestroy();
   SourceAvailabilityList.clear();
   }
}

midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::midw_aud_src_routefi_tclMsgSourceAvailabilityStatus()

 {}

tS32 midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SOURCEAVAILABILITYSTATUS;
}


midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::~midw_aud_src_routefi_tclMsgSourceAvailabilityStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SourceAvailabilityList.size()*5);
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
      {
         SourceAvailabilityList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SourceAvailabilityList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SourceAvailabilityList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SourceAvailabilityList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SourceAvailabilityList.size(); ++u32Idx)
         (tVoid) (oOut << SourceAvailabilityList[u32Idx]);
   }
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSourceAvailabilityStatus::operator==(const midw_aud_src_routefi_tclMsgSourceAvailabilityStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SourceAvailabilityList.size() == roRef.SourceAvailabilityList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SourceAvailabilityList.size()); ++u32Idx)
            bResult = bResult && (SourceAvailabilityList[u32Idx] == roRef.SourceAvailabilityList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg::midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG;
}


midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg::~midw_aud_src_routefi_tclMsgSetAudioPropertyUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg::midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG;
}


midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg::~midw_aud_src_routefi_tclMsgSetAudioPropertyRelUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgSetAudioPropertyGet::midw_aud_src_routefi_tclMsgSetAudioPropertyGet()
 {}

tS32 midw_aud_src_routefi_tclMsgSetAudioPropertyGet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYGET;
}


midw_aud_src_routefi_tclMsgSetAudioPropertyGet::~midw_aud_src_routefi_tclMsgSetAudioPropertyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::midw_aud_src_routefi_tclMsgSetAudioPropertyStatus(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   SetAudioPropertyList = coRef.SetAudioPropertyList;
}
midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::operator=(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& coRef)
{
   if (this == &coRef) return *this;
   SetAudioPropertyList = coRef.SetAudioPropertyList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SetAudioPropertyList.size(); ++u32Idx)
         SetAudioPropertyList[u32Idx].vDestroy();
   SetAudioPropertyList.clear();
   }
}

midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::midw_aud_src_routefi_tclMsgSetAudioPropertyStatus()

 {}

tS32 midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS;
}


midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::~midw_aud_src_routefi_tclMsgSetAudioPropertyStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SetAudioPropertyList.size()*8);
}

fi_tclInContext& midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SetAudioPropertyList.size(); ++u32Idx)
      {
         SetAudioPropertyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SetAudioPropertyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SetAudioPropertyList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SetAudioPropertyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SetAudioPropertyList.size(); ++u32Idx)
         (tVoid) (oOut << SetAudioPropertyList[u32Idx]);
   }
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgSetAudioPropertyStatus::operator==(const midw_aud_src_routefi_tclMsgSetAudioPropertyStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SetAudioPropertyList.size() == roRef.SetAudioPropertyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SetAudioPropertyList.size()); ++u32Idx)
            bResult = bResult && (SetAudioPropertyList[u32Idx] == roRef.SetAudioPropertyList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTUPREG;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg::~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTRELUPREG;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg::~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectRelUpReg()
{}

//=============================================================================

midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet()
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTGET;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet::~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Reason = coRef.u16Reason;
}
midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Reason = coRef.u16Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet()
:u8Source()
,u16SubSource(0)
,u16Reason(0)
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSET;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet()
{}

tU32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u16Reason);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u16Reason);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet::operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u16Reason == roRef.u16Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& coRef)
   : midw_aud_src_routefi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Reason = coRef.u16Reason;
}
midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::operator=(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u16SubSource = coRef.u16SubSource;
   u16Reason = coRef.u16Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus()
:u8Source()
,u16SubSource(0)
,u16Reason(0)
 {}

tS32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::s32GetTypeId() const
{
   return (tS32) midw_aud_src_routefi_tclToken::EN_MSG_REQUESTAUDIOROUTEREJECTSTATUS;
}


midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::~midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus()
{}

tU32 midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u16SubSource);
   (tVoid) (oIn >> u16Reason);
   return oIn;
}

fi_tclOutContext& midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u16SubSource);
   (tVoid) (oOut << u16Reason);
   return oOut;
}

tBool midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus::operator==(const midw_aud_src_routefi_tclMsgRequestAudioRouteRejectStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u16SubSource == roRef.u16SubSource);
   bResult = bResult && (u16Reason == roRef.u16Reason);
   return bResult;
}

