/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_APPCONTROLFITYPES_HEADER
#define MIDW_APPCONTROLFITYPES_HEADER


class midw_appcontrolfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_appcontrol_fi message types

fi_tclMessageBase* midw_appcontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_appcontrolfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_appcontrolfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_appcontrolfi_tclMsgConnectMethodStart : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgConnectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgConnectMethodStart& operator=(const midw_appcontrolfi_tclMsgConnectMethodStart& coRef);
   midw_appcontrolfi_tclMsgConnectMethodStart(const midw_appcontrolfi_tclMsgConnectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szProtocol;
   midw_fi_tclString szBundleSeedID;
   midw_fi_tclString szAppName;
   virtual ~midw_appcontrolfi_tclMsgConnectMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgConnectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgConnectMethodResult : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgConnectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgConnectMethodResult& operator=(const midw_appcontrolfi_tclMsgConnectMethodResult& coRef);
   midw_appcontrolfi_tclMsgConnectMethodResult(const midw_appcontrolfi_tclMsgConnectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   tU16 u16SessionId;
   midw_fi_tclString szAppName;
   virtual ~midw_appcontrolfi_tclMsgConnectMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgConnectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgCommandMethodStart : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgCommandMethodStart& operator=(const midw_appcontrolfi_tclMsgCommandMethodStart& coRef);
   midw_appcontrolfi_tclMsgCommandMethodStart(const midw_appcontrolfi_tclMsgCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   midw_fi_tcl_BinContainer au8CommandBuffer ;
   virtual ~midw_appcontrolfi_tclMsgCommandMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgCommandMethodResult : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgCommandMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgCommandMethodResult& operator=(const midw_appcontrolfi_tclMsgCommandMethodResult& coRef);
   midw_appcontrolfi_tclMsgCommandMethodResult(const midw_appcontrolfi_tclMsgCommandMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   midw_fi_tcl_BinContainer au8CommandResponseBuffer;
   virtual ~midw_appcontrolfi_tclMsgCommandMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgCommandMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgCloseMethodStart : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgCloseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgCloseMethodStart& operator=(const midw_appcontrolfi_tclMsgCloseMethodStart& coRef);
   midw_appcontrolfi_tclMsgCloseMethodStart(const midw_appcontrolfi_tclMsgCloseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   virtual ~midw_appcontrolfi_tclMsgCloseMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgCloseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgCloseMethodResult : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgCloseMethodResult();

   virtual ~midw_appcontrolfi_tclMsgCloseMethodResult();

   inline tBool operator==(const midw_appcontrolfi_tclMsgCloseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart();

   virtual ~midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart();

   inline tBool operator==(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& operator=(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef);
   midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_iPodAuthSelfTestResult enResult;
   virtual ~midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgDataResponseUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgDataResponseUpReg();

   virtual ~midw_appcontrolfi_tclMsgDataResponseUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgDataResponseUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgDataResponseRelUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgDataResponseRelUpReg();

   virtual ~midw_appcontrolfi_tclMsgDataResponseRelUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgDataResponseRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgDataResponseGet : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgDataResponseGet();

   virtual ~midw_appcontrolfi_tclMsgDataResponseGet();

   inline tBool operator==(const midw_appcontrolfi_tclMsgDataResponseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgDataResponseStatus : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgDataResponseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgDataResponseStatus& operator=(const midw_appcontrolfi_tclMsgDataResponseStatus& coRef);
   midw_appcontrolfi_tclMsgDataResponseStatus(const midw_appcontrolfi_tclMsgDataResponseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   midw_fi_tcl_BinContainer au8CommandResponseBuffer;
   virtual ~midw_appcontrolfi_tclMsgDataResponseStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgDataResponseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionOpenedUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionOpenedUpReg();

   virtual ~midw_appcontrolfi_tclMsgSessionOpenedUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionOpenedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionOpenedRelUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionOpenedRelUpReg();

   virtual ~midw_appcontrolfi_tclMsgSessionOpenedRelUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionOpenedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionOpenedGet : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionOpenedGet();

   virtual ~midw_appcontrolfi_tclMsgSessionOpenedGet();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionOpenedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionOpenedStatus : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionOpenedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgSessionOpenedStatus& operator=(const midw_appcontrolfi_tclMsgSessionOpenedStatus& coRef);
   midw_appcontrolfi_tclMsgSessionOpenedStatus(const midw_appcontrolfi_tclMsgSessionOpenedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   virtual ~midw_appcontrolfi_tclMsgSessionOpenedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgSessionOpenedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionClosedUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionClosedUpReg();

   virtual ~midw_appcontrolfi_tclMsgSessionClosedUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionClosedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionClosedRelUpReg : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionClosedRelUpReg();

   virtual ~midw_appcontrolfi_tclMsgSessionClosedRelUpReg();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionClosedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionClosedGet : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionClosedGet();

   virtual ~midw_appcontrolfi_tclMsgSessionClosedGet();

   inline tBool operator==(const midw_appcontrolfi_tclMsgSessionClosedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_appcontrolfi_tclMsgSessionClosedStatus : public midw_appcontrolfi_tclMsgBaseMessage
{
public:

   midw_appcontrolfi_tclMsgSessionClosedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_appcontrolfi_tclMsgSessionClosedStatus& operator=(const midw_appcontrolfi_tclMsgSessionClosedStatus& coRef);
   midw_appcontrolfi_tclMsgSessionClosedStatus(const midw_appcontrolfi_tclMsgSessionClosedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szDeviceId;
   midw_fi_tclString szAppName;
   tU16 u16SessionId;
   virtual ~midw_appcontrolfi_tclMsgSessionClosedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_appcontrolfi_tclMsgSessionClosedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
