/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPCONTROLFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPCONTROLFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_APPCONTROLFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_appcontrol_fi message types

fi_tclMessageBase* midw_appcontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODSTART:
         return OSAL_NEW midw_appcontrolfi_tclMsgConnectMethodStart;

      case midw_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODRESULT:
         return OSAL_NEW midw_appcontrolfi_tclMsgConnectMethodResult;

      case midw_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODSTART:
         return OSAL_NEW midw_appcontrolfi_tclMsgCommandMethodStart;

      case midw_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODRESULT:
         return OSAL_NEW midw_appcontrolfi_tclMsgCommandMethodResult;

      case midw_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODSTART:
         return OSAL_NEW midw_appcontrolfi_tclMsgCloseMethodStart;

      case midw_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODRESULT:
         return OSAL_NEW midw_appcontrolfi_tclMsgCloseMethodResult;

      case midw_appcontrolfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODSTART:
         return OSAL_NEW midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart;

      case midw_appcontrolfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODRESULT:
         return OSAL_NEW midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult;

      case midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSEUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgDataResponseUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSERELUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgDataResponseRelUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSEGET:
         return OSAL_NEW midw_appcontrolfi_tclMsgDataResponseGet;

      case midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSESTATUS:
         return OSAL_NEW midw_appcontrolfi_tclMsgDataResponseStatus;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionOpenedUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDRELUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionOpenedRelUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDGET:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionOpenedGet;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDSTATUS:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionOpenedStatus;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionClosedUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDRELUPREG:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionClosedRelUpReg;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDGET:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionClosedGet;

      case midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDSTATUS:
         return OSAL_NEW midw_appcontrolfi_tclMsgSessionClosedStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_appcontrolfifi messages

// common functions

tU16 midw_appcontrolfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_APPCONTROLFI_C_U16_SERVICE_ID;
}

tU16 midw_appcontrolfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_appcontrolfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_appcontrolfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_appcontrolfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_appcontrolfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_appcontrolfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgConnectMethodStart::midw_appcontrolfi_tclMsgConnectMethodStart(const midw_appcontrolfi_tclMsgConnectMethodStart& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szProtocol = coRef.szProtocol;
   szBundleSeedID = coRef.szBundleSeedID;
   szAppName = coRef.szAppName;
}
midw_appcontrolfi_tclMsgConnectMethodStart& midw_appcontrolfi_tclMsgConnectMethodStart::operator=(const midw_appcontrolfi_tclMsgConnectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szProtocol = coRef.szProtocol;
   szBundleSeedID = coRef.szBundleSeedID;
   szAppName = coRef.szAppName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgConnectMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szProtocol.vDestroy();
   szBundleSeedID.vDestroy();
   szAppName.vDestroy();
}

midw_appcontrolfi_tclMsgConnectMethodStart::midw_appcontrolfi_tclMsgConnectMethodStart()
:szDeviceId()
,szProtocol()
,szBundleSeedID()
,szAppName()
 {}

tS32 midw_appcontrolfi_tclMsgConnectMethodStart::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODSTART;
}


midw_appcontrolfi_tclMsgConnectMethodStart::~midw_appcontrolfi_tclMsgConnectMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgConnectMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDeviceId.u32GetSize(u16MajorVersion)+szProtocol.u32GetSize(u16MajorVersion)+szBundleSeedID.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgConnectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szProtocol);
   (tVoid) (oIn >> szBundleSeedID);
   (tVoid) (oIn >> szAppName);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgConnectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szProtocol);
   (tVoid) (oOut << szBundleSeedID);
   (tVoid) (oOut << szAppName);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgConnectMethodStart::operator==(const midw_appcontrolfi_tclMsgConnectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szProtocol == roRef.szProtocol);
   bResult = bResult && (szBundleSeedID == roRef.szBundleSeedID);
   bResult = bResult && (szAppName == roRef.szAppName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgConnectMethodResult::midw_appcontrolfi_tclMsgConnectMethodResult(const midw_appcontrolfi_tclMsgConnectMethodResult& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   u16SessionId = coRef.u16SessionId;
   szAppName = coRef.szAppName;
}
midw_appcontrolfi_tclMsgConnectMethodResult& midw_appcontrolfi_tclMsgConnectMethodResult::operator=(const midw_appcontrolfi_tclMsgConnectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   u16SessionId = coRef.u16SessionId;
   szAppName = coRef.szAppName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgConnectMethodResult::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

midw_appcontrolfi_tclMsgConnectMethodResult::midw_appcontrolfi_tclMsgConnectMethodResult()
:szDeviceId()
,u16SessionId(0)
,szAppName()
 {}

tS32 midw_appcontrolfi_tclMsgConnectMethodResult::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODRESULT;
}


midw_appcontrolfi_tclMsgConnectMethodResult::~midw_appcontrolfi_tclMsgConnectMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgConnectMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgConnectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> szAppName);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgConnectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << szAppName);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgConnectMethodResult::operator==(const midw_appcontrolfi_tclMsgConnectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (szAppName == roRef.szAppName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgCommandMethodStart::midw_appcontrolfi_tclMsgCommandMethodStart(const midw_appcontrolfi_tclMsgCommandMethodStart& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandBuffer  = coRef.au8CommandBuffer ;
}
midw_appcontrolfi_tclMsgCommandMethodStart& midw_appcontrolfi_tclMsgCommandMethodStart::operator=(const midw_appcontrolfi_tclMsgCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandBuffer  = coRef.au8CommandBuffer ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgCommandMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandBuffer .vDestroy(); 
}

midw_appcontrolfi_tclMsgCommandMethodStart::midw_appcontrolfi_tclMsgCommandMethodStart()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandBuffer ()
 {}

tS32 midw_appcontrolfi_tclMsgCommandMethodStart::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODSTART;
}


midw_appcontrolfi_tclMsgCommandMethodStart::~midw_appcontrolfi_tclMsgCommandMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgCommandMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandBuffer .u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandBuffer );
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandBuffer );
   return oOut;
}

tBool midw_appcontrolfi_tclMsgCommandMethodStart::operator==(const midw_appcontrolfi_tclMsgCommandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandBuffer  == roRef.au8CommandBuffer );
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgCommandMethodResult::midw_appcontrolfi_tclMsgCommandMethodResult(const midw_appcontrolfi_tclMsgCommandMethodResult& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
}
midw_appcontrolfi_tclMsgCommandMethodResult& midw_appcontrolfi_tclMsgCommandMethodResult::operator=(const midw_appcontrolfi_tclMsgCommandMethodResult& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgCommandMethodResult::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandResponseBuffer.vDestroy(); 
}

midw_appcontrolfi_tclMsgCommandMethodResult::midw_appcontrolfi_tclMsgCommandMethodResult()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandResponseBuffer()
 {}

tS32 midw_appcontrolfi_tclMsgCommandMethodResult::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODRESULT;
}


midw_appcontrolfi_tclMsgCommandMethodResult::~midw_appcontrolfi_tclMsgCommandMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgCommandMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandResponseBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgCommandMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandResponseBuffer);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgCommandMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandResponseBuffer);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgCommandMethodResult::operator==(const midw_appcontrolfi_tclMsgCommandMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandResponseBuffer == roRef.au8CommandResponseBuffer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgCloseMethodStart::midw_appcontrolfi_tclMsgCloseMethodStart(const midw_appcontrolfi_tclMsgCloseMethodStart& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
}
midw_appcontrolfi_tclMsgCloseMethodStart& midw_appcontrolfi_tclMsgCloseMethodStart::operator=(const midw_appcontrolfi_tclMsgCloseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgCloseMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

midw_appcontrolfi_tclMsgCloseMethodStart::midw_appcontrolfi_tclMsgCloseMethodStart()
:szDeviceId()
,szAppName()
,u16SessionId(0)
 {}

tS32 midw_appcontrolfi_tclMsgCloseMethodStart::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODSTART;
}


midw_appcontrolfi_tclMsgCloseMethodStart::~midw_appcontrolfi_tclMsgCloseMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgCloseMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgCloseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgCloseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgCloseMethodStart::operator==(const midw_appcontrolfi_tclMsgCloseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   return bResult;
}

//=============================================================================

midw_appcontrolfi_tclMsgCloseMethodResult::midw_appcontrolfi_tclMsgCloseMethodResult()
 {}

tS32 midw_appcontrolfi_tclMsgCloseMethodResult::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODRESULT;
}


midw_appcontrolfi_tclMsgCloseMethodResult::~midw_appcontrolfi_tclMsgCloseMethodResult()
{}

//=============================================================================

midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart::midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart()
 {}

tS32 midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODSTART;
}


midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart::~midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   enResult = coRef.enResult;
}
midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::operator=(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   enResult = coRef.enResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult()
:enResult()
 {}

tS32 midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODRESULT;
}


midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::~midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult()
{}

tU32 midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enResult);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enResult);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult::operator==(const midw_appcontrolfi_tclMsgiPodAuthenticationSelftestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enResult == roRef.enResult);
   return bResult;
}

//=============================================================================

midw_appcontrolfi_tclMsgDataResponseUpReg::midw_appcontrolfi_tclMsgDataResponseUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgDataResponseUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSEUPREG;
}


midw_appcontrolfi_tclMsgDataResponseUpReg::~midw_appcontrolfi_tclMsgDataResponseUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgDataResponseRelUpReg::midw_appcontrolfi_tclMsgDataResponseRelUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgDataResponseRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSERELUPREG;
}


midw_appcontrolfi_tclMsgDataResponseRelUpReg::~midw_appcontrolfi_tclMsgDataResponseRelUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgDataResponseGet::midw_appcontrolfi_tclMsgDataResponseGet()
 {}

tS32 midw_appcontrolfi_tclMsgDataResponseGet::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSEGET;
}


midw_appcontrolfi_tclMsgDataResponseGet::~midw_appcontrolfi_tclMsgDataResponseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgDataResponseStatus::midw_appcontrolfi_tclMsgDataResponseStatus(const midw_appcontrolfi_tclMsgDataResponseStatus& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
}
midw_appcontrolfi_tclMsgDataResponseStatus& midw_appcontrolfi_tclMsgDataResponseStatus::operator=(const midw_appcontrolfi_tclMsgDataResponseStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgDataResponseStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandResponseBuffer.vDestroy(); 
}

midw_appcontrolfi_tclMsgDataResponseStatus::midw_appcontrolfi_tclMsgDataResponseStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandResponseBuffer()
 {}

tS32 midw_appcontrolfi_tclMsgDataResponseStatus::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_DATARESPONSESTATUS;
}


midw_appcontrolfi_tclMsgDataResponseStatus::~midw_appcontrolfi_tclMsgDataResponseStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgDataResponseStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandResponseBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgDataResponseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandResponseBuffer);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgDataResponseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandResponseBuffer);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgDataResponseStatus::operator==(const midw_appcontrolfi_tclMsgDataResponseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandResponseBuffer == roRef.au8CommandResponseBuffer);
   return bResult;
}

//=============================================================================

midw_appcontrolfi_tclMsgSessionOpenedUpReg::midw_appcontrolfi_tclMsgSessionOpenedUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgSessionOpenedUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDUPREG;
}


midw_appcontrolfi_tclMsgSessionOpenedUpReg::~midw_appcontrolfi_tclMsgSessionOpenedUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgSessionOpenedRelUpReg::midw_appcontrolfi_tclMsgSessionOpenedRelUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgSessionOpenedRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDRELUPREG;
}


midw_appcontrolfi_tclMsgSessionOpenedRelUpReg::~midw_appcontrolfi_tclMsgSessionOpenedRelUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgSessionOpenedGet::midw_appcontrolfi_tclMsgSessionOpenedGet()
 {}

tS32 midw_appcontrolfi_tclMsgSessionOpenedGet::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDGET;
}


midw_appcontrolfi_tclMsgSessionOpenedGet::~midw_appcontrolfi_tclMsgSessionOpenedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgSessionOpenedStatus::midw_appcontrolfi_tclMsgSessionOpenedStatus(const midw_appcontrolfi_tclMsgSessionOpenedStatus& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
}
midw_appcontrolfi_tclMsgSessionOpenedStatus& midw_appcontrolfi_tclMsgSessionOpenedStatus::operator=(const midw_appcontrolfi_tclMsgSessionOpenedStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgSessionOpenedStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

midw_appcontrolfi_tclMsgSessionOpenedStatus::midw_appcontrolfi_tclMsgSessionOpenedStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
 {}

tS32 midw_appcontrolfi_tclMsgSessionOpenedStatus::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDSTATUS;
}


midw_appcontrolfi_tclMsgSessionOpenedStatus::~midw_appcontrolfi_tclMsgSessionOpenedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgSessionOpenedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgSessionOpenedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgSessionOpenedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgSessionOpenedStatus::operator==(const midw_appcontrolfi_tclMsgSessionOpenedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   return bResult;
}

//=============================================================================

midw_appcontrolfi_tclMsgSessionClosedUpReg::midw_appcontrolfi_tclMsgSessionClosedUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgSessionClosedUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDUPREG;
}


midw_appcontrolfi_tclMsgSessionClosedUpReg::~midw_appcontrolfi_tclMsgSessionClosedUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgSessionClosedRelUpReg::midw_appcontrolfi_tclMsgSessionClosedRelUpReg()
 {}

tS32 midw_appcontrolfi_tclMsgSessionClosedRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDRELUPREG;
}


midw_appcontrolfi_tclMsgSessionClosedRelUpReg::~midw_appcontrolfi_tclMsgSessionClosedRelUpReg()
{}

//=============================================================================

midw_appcontrolfi_tclMsgSessionClosedGet::midw_appcontrolfi_tclMsgSessionClosedGet()
 {}

tS32 midw_appcontrolfi_tclMsgSessionClosedGet::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDGET;
}


midw_appcontrolfi_tclMsgSessionClosedGet::~midw_appcontrolfi_tclMsgSessionClosedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_appcontrolfi_tclMsgSessionClosedStatus::midw_appcontrolfi_tclMsgSessionClosedStatus(const midw_appcontrolfi_tclMsgSessionClosedStatus& coRef)
   : midw_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
}
midw_appcontrolfi_tclMsgSessionClosedStatus& midw_appcontrolfi_tclMsgSessionClosedStatus::operator=(const midw_appcontrolfi_tclMsgSessionClosedStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_appcontrolfi_tclMsgSessionClosedStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

midw_appcontrolfi_tclMsgSessionClosedStatus::midw_appcontrolfi_tclMsgSessionClosedStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
 {}

tS32 midw_appcontrolfi_tclMsgSessionClosedStatus::s32GetTypeId() const
{
   return (tS32) midw_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDSTATUS;
}


midw_appcontrolfi_tclMsgSessionClosedStatus::~midw_appcontrolfi_tclMsgSessionClosedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_appcontrolfi_tclMsgSessionClosedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_appcontrolfi_tclMsgSessionClosedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   return oIn;
}

fi_tclOutContext& midw_appcontrolfi_tclMsgSessionClosedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   return oOut;
}

tBool midw_appcontrolfi_tclMsgSessionClosedStatus::operator==(const midw_appcontrolfi_tclMsgSessionClosedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   return bResult;
}

