/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_APPLICATIONMGRFITYPES_HEADER
#define MIDW_APPLICATIONMGRFITYPES_HEADER


class midw_applicationmgrfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_ApplicationMgr_fi message types

fi_tclMessageBase* midw_applicationmgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_applicationmgrfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_applicationmgrfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& operator=(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& coRef);
   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ApplicationData ApplicationData;
   virtual ~midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& operator=(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& coRef);
   midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AppMgrMethodResult ResultCode;
   virtual ~midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_applicationmgrfi_tclMsgApplication_State_ReqMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_applicationmgrfi_tclMsgApplicationStateListUpReg : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplicationStateListUpReg();

   virtual ~midw_applicationmgrfi_tclMsgApplicationStateListUpReg();

   inline tBool operator==(const midw_applicationmgrfi_tclMsgApplicationStateListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_applicationmgrfi_tclMsgApplicationStateListGet : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplicationStateListGet();

   virtual ~midw_applicationmgrfi_tclMsgApplicationStateListGet();

   inline tBool operator==(const midw_applicationmgrfi_tclMsgApplicationStateListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_applicationmgrfi_tclMsgApplicationStateListSet : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplicationStateListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_applicationmgrfi_tclMsgApplicationStateListSet& operator=(const midw_applicationmgrfi_tclMsgApplicationStateListSet& coRef);
   midw_applicationmgrfi_tclMsgApplicationStateListSet(const midw_applicationmgrfi_tclMsgApplicationStateListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ApplicationData ApplicationData;
   virtual ~midw_applicationmgrfi_tclMsgApplicationStateListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_applicationmgrfi_tclMsgApplicationStateListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_applicationmgrfi_tclMsgApplicationStateListStatus : public midw_applicationmgrfi_tclMsgBaseMessage
{
public:

   midw_applicationmgrfi_tclMsgApplicationStateListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_applicationmgrfi_tclMsgApplicationStateListStatus& operator=(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& coRef);
   midw_applicationmgrfi_tclMsgApplicationStateListStatus(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_ApplicationData, std::allocator<midw_fi_tcl_ApplicationData> > ApplicationList;
   virtual ~midw_applicationmgrfi_tclMsgApplicationStateListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_applicationmgrfi_tclMsgApplicationStateListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
