/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_ALLFITYPES_HEADER
#define MIDW_EXT_ALLFITYPES_HEADER

#include <vector>

class midw_ext_fi_tclVisitorBase;

const tU16 MIDW_EXT_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 MIDW_EXT_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 MIDW_EXT_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class midw_ext_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  midw_ext_fi_tclTypeBase() {}
  virtual ~midw_ext_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& /*oVisitor*/) {}
};

class midw_ext_fi_tclVisitableTypeBase :public midw_ext_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& /*oVisitor*/) {}
};

class midw_ext_fi_tclU8 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_U8;}
};

class midw_ext_fi_tclS8 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_S8;}
};

class midw_ext_fi_tclU16 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_U16;}
};

class midw_ext_fi_tclS16 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_S16;}
};

class midw_ext_fi_tclU24 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_U24;}
};

class midw_ext_fi_tclS24 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_S24;}
};

class midw_ext_fi_tclU32 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_U32;}
};

class midw_ext_fi_tclS32 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_S32;}
};

class midw_ext_fi_tclU64 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_U64;}
};

class midw_ext_fi_tclS64 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_S64;}
};

class midw_ext_fi_tclF32 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_F32;}
};

class midw_ext_fi_tclF64 : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_F64;}
};

class midw_ext_fi_tclBool : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const midw_ext_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_BOOL;}
};

class midw_ext_fi_tclString : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tclString(const midw_ext_fi_tclString& coRef);
   midw_ext_fi_tclString& operator=(const midw_ext_fi_tclString& coRef);
   virtual ~midw_ext_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_ext_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   midw_ext_fi_tclString& operator=(tCString coszString); // ADDED
   midw_ext_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const midw_ext_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class midw_ext_fi_tclList : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_ext_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_LIST;}
};

class midw_ext_fi_tclMultiLanguageString : public midw_ext_fi_tclVisitableTypeBase
{
public:
   midw_ext_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tclMultiLanguageString(const midw_ext_fi_tclMultiLanguageString& coRef);
   midw_ext_fi_tclMultiLanguageString& operator=(const midw_ext_fi_tclMultiLanguageString& coRef);
   virtual ~midw_ext_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const midw_ext_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(midw_ext_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   midw_ext_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   midw_ext_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return midw_ext_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const midw_ext_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class midw_ext_fi_tcl_BinContainer;
class midw_ext_fi_tcl_Reserved;
class midw_ext_fi_tcl_u8_Percent;
class midw_ext_fi_tcl_s16_PerThousand;
class midw_ext_fi_tcl_u16_IndexInReferenceList;
class midw_ext_fi_tcl_u16_ErrorCode;
class midw_ext_fi_tcl_u16_RPM;
class midw_ext_fi_tcl_s32_Kilogram;
class midw_ext_fi_tcl_s32_Pound;
class midw_ext_fi_tcl_s16_Meter;
class midw_ext_fi_tcl_s32_Meter;
class midw_ext_fi_tcl_s32_Yards;
class midw_ext_fi_tcl_s32_Foot;
class midw_ext_fi_tcl_s32_Centimeter;
class midw_ext_fi_tcl_s32_Inch;
class midw_ext_fi_tcl_s32_Millimeter;
class midw_ext_fi_tcl_s32_Microliter;
class midw_ext_fi_tcl_s32_Second;
class midw_ext_fi_tcl_u16_MilliSecond;
class midw_ext_fi_tcl_s32_MilliSecond;
class midw_ext_fi_tcl_POSIXTime;
class midw_ext_fi_tcl_e8_DST_State;
class midw_ext_fi_tcl_TimeZoneElement;
class midw_ext_fi_tcl_s16_KmPerHour;
class midw_ext_fi_tcl_s16_MilesPerHour;
class midw_ext_fi_tcl_s16_Knot;
class midw_ext_fi_tcl_s16_CentimeterSecond;
class midw_ext_fi_tcl_s16_Kelvin;
class midw_ext_fi_tcl_s16_Fahrenheit;
class midw_ext_fi_tcl_s32_Pascal;
class midw_ext_fi_tcl_s32_Watt;
class midw_ext_fi_tcl_FIVersion;
class midw_ext_fi_tcl_s32_Longitude;
class midw_ext_fi_tcl_s32_Latitude;
class midw_ext_fi_tcl_PositionWGS84;
class midw_ext_fi_tcl_RectangleWGS84;
class midw_ext_fi_tcl_e16_ISOCountryCode;
class midw_ext_fi_tcl_e16_ISOLanguageCode;
class midw_ext_fi_tcl_LanguageID;
class midw_ext_fi_tcl_u8_DirectionAbsolute;
class midw_ext_fi_tcl_u8_DirectionRelative;
class midw_ext_fi_tcl_s16_CentiDegree;
class midw_ext_fi_tcl_s16_Degree;
class midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree;
class midw_ext_fi_tcl_e8_FuelType;
class midw_ext_fi_tcl_DistTimeFuel;
class midw_ext_fi_tcl_e8_DAB_Response;
class midw_ext_fi_tcl_e8_DAB_UserProfileAction;
class midw_ext_fi_tcl_e8_DAB_SourceState;
class midw_ext_fi_tcl_DAB_Label;
class midw_ext_fi_tcl_e8_DAB_ServiceType;
class midw_ext_fi_tcl_e8_DAB_ServiceListSortingType;
class midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType;
class midw_ext_fi_tcl_e8_DAB_AST_Type;
class midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode;
class midw_ext_fi_tcl_b8_DAB_MTC_SetMode;
class midw_ext_fi_tcl_e8_MTC_Request;
class midw_ext_fi_tcl_e8_MTC_Tuner_Status;
class midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState;
class midw_ext_fi_tcl_e8_StationType;
class midw_ext_fi_tcl_e8_TPState;
class midw_ext_fi_tcl_e8_DAB_SampleRate;
class midw_ext_fi_tcl_e8_DAB_AudioMode;
class midw_ext_fi_tcl_e8_DAB_AudioCodec;
class midw_ext_fi_tcl_e8_DAB_Encoding;
class midw_ext_fi_tcl_e8_DAB_ComponentType;
class midw_ext_fi_tcl_e8_DAB_TMIdType;
class midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType;
class midw_ext_fi_tcl_e8_DAB_DataServiceComponentType;
class midw_ext_fi_tcl_b16_DAB_AnnouncementType;
class midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState;
class midw_ext_fi_tcl_e8_DAB_AnnouncementStatus;
class midw_ext_fi_tcl_e8_DAB_AnnouncementSource;
class midw_ext_fi_tcl_e8_DAB_ChnSelectMode;
class midw_ext_fi_tcl_e8_DAB_EnsSelectMode;
class midw_ext_fi_tcl_e8_DAB_CompSelectMode;
class midw_ext_fi_tcl_e8_DAB_UriSelectState;
class midw_ext_fi_tcl_e8_DAB_TunerActivityType;
class midw_ext_fi_tcl_DAB_Frequency;
class midw_ext_fi_tcl_e8_DAB_FrequencyTable;
class midw_ext_fi_tcl_b16_DAB_TunerStatusFlags;
class midw_ext_fi_tcl_DAB_TunerStatus;
class midw_ext_fi_tcl_DAB_RadioText;
class midw_ext_fi_tcl_DAB_RadioTextPlus;
class midw_ext_fi_tcl_DAB_EnsembleInfo;
class midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags;
class midw_ext_fi_tcl_DAB_ServiceInfo;
class midw_ext_fi_tcl_e8_DAB_ChannelInfoState;
class midw_ext_fi_tcl_DAB_ChannelInfo;
class midw_ext_fi_tcl_DAB_ComponentInfo;
class midw_ext_fi_tcl_DAB_AnnoConfig;
class midw_ext_fi_tcl_DAB_AnnoElement;
class midw_ext_fi_tcl_DAB_AnnoStatus;
class midw_ext_fi_tcl_DAB_ADRMsg;
class midw_ext_fi_tcl_DAB_LogoElement;
class midw_ext_fi_tcl_DAB_ContentID;
class midw_ext_fi_tcl_e8_DAB_TuneType;
class midw_ext_fi_tcl_DAB_TuneParam;
class midw_ext_fi_tcl_e8_DAB_LearnType;
class midw_ext_fi_tcl_DAB_LearnParam;
class midw_ext_fi_tcl_b32_DAB_SetupMask;
class midw_ext_fi_tcl_b32_DAB_SetupFlags;
class midw_ext_fi_tcl_b8_DAB_LinkingSetupMask;
class midw_ext_fi_tcl_e8_DAB_SwitchTuner;
class midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner;
class midw_ext_fi_tcl_e8_DAB_MuteStatus;
class midw_ext_fi_tcl_e8_DAB_Source;
class midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags;
class midw_ext_fi_tcl_e8_DAB_DeleteAction;
class midw_ext_fi_tcl_DAB_PresetListElement;
class midw_ext_fi_tcl_e8_DAB_ListOperation;
class midw_ext_fi_tcl_e8_DAB_ServiceListType;
class midw_ext_fi_tcl_DAB_ChnListElement;
class midw_ext_fi_tcl_DAB_ListElementAvailInfo;
class midw_ext_fi_tcl_DAB_TIIListElement;
class midw_ext_fi_tcl_e8_DAB_BankList;
class midw_ext_fi_tcl_e8_DAB_TestOperation;
class midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation;
class midw_ext_fi_tcl_b8_DAB_TestMode_Flags;
class midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags;
class midw_ext_fi_tcl_e8_DAB_LinkType;
class midw_ext_fi_tcl_DAB_BG_TestModeData;
class midw_ext_fi_tcl_DAB_Time;
class midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData;
class midw_ext_fi_tcl_DAB_LinkListElem;
class midw_ext_fi_tcl_DAB_AltFreqInfo;
class midw_ext_fi_tcl_DAB_TestModeData;
class midw_ext_fi_tcl_DAB_RdbId;
class midw_ext_fi_tcl_DAB_TmcData;
class midw_ext_fi_tcl_DAB_Encryption;
class midw_ext_fi_tcl_e8_DAB_TmcMediumType;
class midw_ext_fi_tcl_e8_DAB_TuneCmd;
class midw_ext_fi_tcl_DAB_MsgSource;
class midw_ext_fi_tcl_DAB_TmcInfo;
class midw_ext_fi_tcl_DAB_EnsembleTmcInfo;
class midw_ext_fi_tcl_DAB_TpegInfo;
class midw_ext_fi_tcl_DAB_TpegUriChannel;
class midw_ext_fi_tcl_e8_DefSetMode;
class midw_ext_fi_tcl_e8_DefSetServiceStatus;
class midw_ext_fi_tcl_e8_DefSetGroups;
class midw_ext_fi_tcl_e8_RCtrlSource;
class midw_ext_fi_tcl_e8_RCtrlCommand;
class midw_ext_fi_tcl_e8_RCtrlSignal;
class midw_ext_fi_tcl_e8_PHN_VAG_CCAError;
class midw_ext_fi_tcl_e8_PHN_VAG_PhoneError;
class midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus;
class midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState;
class midw_ext_fi_tcl_PHN_VAG_BTDeviceName;
class midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress;
class midw_ext_fi_tcl_PHN_VAG_PairedBTDevice;
class midw_ext_fi_tcl_PHN_U8_Handle;
class midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService;
class midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation;
class midw_ext_fi_tcl_PHN_BTVirtualDeviceData;
class midw_ext_fi_tcl_PHN_VAG_BTDevice;
class midw_ext_fi_tcl_PHN_VAG_PINString;
class midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability;
class midw_ext_fi_tcl_PHN_VAG_ProviderName;
class midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off;
class midw_ext_fi_tcl_e8_PHN_VAG_DeviceType;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList;
class midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState;
class midw_ext_fi_tcl_PHN_HASH_Value;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBState;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration;
class midw_ext_fi_tcl_PHN_VAG_BTM_PIN;
class midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE;
class midw_ext_fi_tcl_e8_PHN_BTTestAction;
class midw_ext_fi_tcl_PHN_SetGetShortcutNumber;
class midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest;
class midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL;
class midw_ext_fi_tcl_PHN_SMS_Handle;
class midw_ext_fi_tcl_e8_PHN_SMS_Message_Status;
class midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status;
class midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status;
class midw_ext_fi_tcl_e8_PHN_VAG_NumberType;
class midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE;
class midw_ext_fi_tcl_PHN_VAG_StartPairingRequest;
class midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest;
class midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest;
class midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest;
class midw_ext_fi_tcl_e8_PHN_BT_Profile;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff;
class midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode;
class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest;
class midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST;
class midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult;
class midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult;
class midw_ext_fi_tcl_PHN_VAG_StartPairingResult;
class midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList;
class midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult;
class midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult;
class midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult;
class midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult;
class midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult;
class midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult;
class midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE;
class midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name;
class midw_ext_fi_tcl_PHN_PB_FLI_Result;
class midw_ext_fi_tcl_PHN_PB_FLI_Details_Result;
class midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM;
class midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult;
class midw_ext_fi_tcl_e8_PHN_VAG_SearchDir;
class midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult;
class midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult;
class midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State;
class midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason;
class midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication;
class midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS;
class midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS;
class midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason;
class midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action;
class midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource;
class midw_ext_fi_tcl_e8_PHN_GAIN_SETTING;
class midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER;
class midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER;
class midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS;
class midw_ext_fi_tcl_e8_PHN_TX_MODE_SET;
class midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH;
class midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE;
class midw_ext_fi_tcl_e8_Meter_UnitType;
class midw_ext_fi_tcl_e8_Meter_ConfigurationStatus;
class midw_ext_fi_tcl_Meter_VersionInfo;
class midw_ext_fi_tcl_Meter_UnitConnectionStatus;
class midw_ext_fi_tcl_Meter_UnitConfiguration;
class midw_ext_fi_tcl_Meter_UnitVersion;
class midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus;
class midw_ext_fi_tcl_e8_Meter_Language;
class midw_ext_fi_tcl_e8_Meter_Language_Action;
class midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type;
class midw_ext_fi_tcl_e8_Meter_Language_Status;
class midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult;
class midw_ext_fi_tcl_e8_Meter_DistanceUnit;
class midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit;
class midw_ext_fi_tcl_e8_Meter_TemperatureUnit;
class midw_ext_fi_tcl_e8_Meter_PressureUnit;
class midw_ext_fi_tcl_Meter_Audio_NoData;
class midw_ext_fi_tcl_e8_Meter_Audio_RadioSource;
class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate;
class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName;
class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource;
class midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType;
class midw_ext_fi_tcl_Meter_Audio_RadioLabel;
class midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit;
class midw_ext_fi_tcl_Meter_Audio_RadioFrequency;
class midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType;
class midw_ext_fi_tcl_Meter_Audio_RadioCategory;
class midw_ext_fi_tcl_Meter_Audio_RadioData;
class midw_ext_fi_tcl_Meter_Audio_HDRadioData;
class midw_ext_fi_tcl_e8_Meter_Audio_MediaType;
class midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType;
class midw_ext_fi_tcl_Meter_Audio_TrackInfo;
class midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType;
class midw_ext_fi_tcl_Meter_Audio_GroupInfo;
class midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType;
class midw_ext_fi_tcl_Meter_Audio_ArtistInfo;
class midw_ext_fi_tcl_Meter_Audio_MediaData;
class midw_ext_fi_tcl_e8_Meter_Audio_AuxType;
class midw_ext_fi_tcl_Meter_Audio_AuxData;
class midw_ext_fi_tcl_Meter_Audio_ExternalSoundData;
class midw_ext_fi_tcl_Meter_Audio_InternetRadioData;
class midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType;
class midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion;
class midw_ext_fi_tcl_e8_Meter_Audio_WarningSource;
class midw_ext_fi_tcl_e8_Meter_Audio_WarningState;
class midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode;
class midw_ext_fi_tcl_e8_NavStatus;
class midw_ext_fi_tcl_e8_RoadClass;
class midw_ext_fi_tcl_e8_Unit;
class midw_ext_fi_tcl_e8_ManeuverSymbol;
class midw_ext_fi_tcl_e8_SpeedUnit;
class midw_ext_fi_tcl_e8_ManeuverRecommendationType;
class midw_ext_fi_tcl_e8_TimeType;
class midw_ext_fi_tcl_e8_TimeFormat;
class midw_ext_fi_tcl_e8_ManeuverView;
class midw_ext_fi_tcl_e8_DeformedImageRoad;
class midw_ext_fi_tcl_e8_DeformedImageArrow;
class midw_ext_fi_tcl_e8_LaneStatus;
class midw_ext_fi_tcl_LaneRecommendation;
class midw_ext_fi_tcl_ArrivalInformation;
class midw_ext_fi_tcl_ScreenCoordinate;
class midw_ext_fi_tcl_e8_AdminRoadClass;
class midw_ext_fi_tcl_IntersectionMapRoadLine;
class midw_ext_fi_tcl_e8_IntersectionMapCarsorState;
class midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState;
class midw_ext_fi_tcl_e8_SpiNavigation_TurnSide;
class midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent;
class midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode;
class midw_ext_fi_tcl_e8_Meter_Phone_SMS_State;
class midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu;
class midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType;
class midw_ext_fi_tcl_e8_Meter_VR_State;
class midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2;
class midw_ext_fi_tcl_e8_Meter_PowerState;
class midw_ext_fi_tcl_e8_Meter_TimeInfoType;
class midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action;
class midw_ext_fi_tcl_e8_Meter_PhoneCall_State;
class midw_ext_fi_tcl_e8_Language_InvalidParameter;
class midw_ext_fi_tcl_e8_TCU_ConfigurationStatus;
class midw_ext_fi_tcl_TCU_VersionInfo;
class midw_ext_fi_tcl_e8_TCU_CommunicationStatus;
class midw_ext_fi_tcl_e8_TCU_ServiceState;
class midw_ext_fi_tcl_e8_TCU_CurfewWarning;
class midw_ext_fi_tcl_e8_TCU_ModemStatus;
class midw_ext_fi_tcl_e8_TCU_TCUStatus;
class midw_ext_fi_tcl_e8_TCU_GSMStatus;
class midw_ext_fi_tcl_e8_TCU_WifiStatus;
class midw_ext_fi_tcl_e8_TCU_WifiMode;
class midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus;
class midw_ext_fi_tcl_e8_TCU_WifiClientStatus;
class midw_ext_fi_tcl_e8_TCU_GSMDataMode;
class midw_ext_fi_tcl_e8_TCU_Invalid_Parameter;
class midw_ext_fi_tcl_e8_TCU_RoamingStatus;
class midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus;
class midw_ext_fi_tcl_e8_TCU_InvalidParameter;
class midw_ext_fi_tcl_e8_TCU_PermitSetting;
class midw_ext_fi_tcl_e8_TCU_APP_Context;
class midw_ext_fi_tcl_e8_TCU_ProbePermitSetting;
class midw_ext_fi_tcl_e8_TCU_PopUpFlag;
class midw_ext_fi_tcl_e8_TCU_OperationRequest;
class midw_ext_fi_tcl_TCU_Date_Time;
class midw_ext_fi_tcl_e8_TCU_LocationType;
class midw_ext_fi_tcl_TCU_Score_Info;
class midw_ext_fi_tcl_TCU_Navi_Road_classification;
class midw_ext_fi_tcl_TCU_Distance_Value;
class midw_ext_fi_tcl_e8_TCU_Distance_Unit;
class midw_ext_fi_tcl_TCU_Provision_List;
class midw_ext_fi_tcl_e8_TCU_EcallStateDisplay;
class midw_ext_fi_tcl_TCU_Maintenance_Info;
class midw_ext_fi_tcl_e8_TCU_LatitudeMode;
class midw_ext_fi_tcl_e8_TCU_LongitudeMode;
class midw_ext_fi_tcl_e8_TCU_Sign;
class midw_ext_fi_tcl_e8_TCU_Home;
class midw_ext_fi_tcl_TCU_Altitude;
class midw_ext_fi_tcl_TCU_LocationInfo;
class midw_ext_fi_tcl_TCU_Navi_Info;
class midw_ext_fi_tcl_TCU_Probe_Vehicle_Info;
class midw_ext_fi_tcl_e8_TCU_Opcode;
class midw_ext_fi_tcl_e8_TCU_Mode;
class midw_ext_fi_tcl_TCU_ReminderInfo;
class midw_ext_fi_tcl_e8_TCU_Service_Type;
class midw_ext_fi_tcl_e8_TCU_ePOI_Type;
class midw_ext_fi_tcl_e8_TCU_Finder_Status;
class midw_ext_fi_tcl_TCU_GPS_Position;
class midw_ext_fi_tcl_TCU_Time_Stamp;
class midw_ext_fi_tcl_TCU_Opening_Hour_Day;
class midw_ext_fi_tcl_TCU_Opening_Hour;
class midw_ext_fi_tcl_TCU_Charge_Station_Accessibility;
class midw_ext_fi_tcl_TCU_Payment_Method_Type;
class midw_ext_fi_tcl_TCU_Full_Address;
class midw_ext_fi_tcl_e8_TCU_Bookable_Information;
class midw_ext_fi_tcl_e8_TCU_Spot_Availability;
class midw_ext_fi_tcl_TCU_Bookable_Free_Text;
class midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type;
class midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility;
class midw_ext_fi_tcl_TCU_Receptacle;
class midw_ext_fi_tcl_TCU_Spot_List;
class midw_ext_fi_tcl_TCU_Charge_Spot_List;
class midw_ext_fi_tcl_TCU_Time;
class midw_ext_fi_tcl_e8_Language_Family_Type;
class midw_ext_fi_tcl_e8_Language_Type;
class midw_ext_fi_tcl_TCU_Navigation_Language;
class midw_ext_fi_tcl_e8_TCU_Booking_Status;
class midw_ext_fi_tcl_e8_TCU_Unbooking_Status;
class midw_ext_fi_tcl_e8_TCU_Update_Status;
class midw_ext_fi_tcl_e8_TCU_Sch_Activation_State;
class midw_ext_fi_tcl_TCU_Charge_Days;
class midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status;
class midw_ext_fi_tcl_TCU_Spot_Receptacle_Type;
class midw_ext_fi_tclIN_Data;
class midw_ext_fi_tcl_TCU_PIN;
class midw_ext_fi_tcl_TCU_Wifi_SSID_Name;
class midw_ext_fi_tcl_TCU_Wifi_PassKey;
class midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode;
class midw_ext_fi_tcl_e8_TCU_Wifi_Visibility;
class midw_ext_fi_tcl_e8_TCU_Wifi_Status;
class midw_ext_fi_tcl_e8_TCU_Wifi_Mode;
class midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status;
class midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security;
class midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status;
class midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity;
class midw_ext_fi_tcl_e8_TCU_Cycle;
class midw_ext_fi_tcl_TCU_Time_Slot;
class midw_ext_fi_tcl_TCU_Coordinates;
class midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type;
class midw_ext_fi_tcl_e8_TCU_Area_Form;
class midw_ext_fi_tcl_TCU_Area_Coordinate;
class midw_ext_fi_tcl_TCU_Area_Limit_Coordinates;
class midw_ext_fi_tcl_e8_TCU_Restrictions_State;
class midw_ext_fi_tcl_TCU_Time_Limit_Restriction;
class midw_ext_fi_tcl_e8_TCU_Time_Slot_State;
class midw_ext_fi_tcl_TCU_Speed_Limit_Restriction;
class midw_ext_fi_tcl_TCU_Area_Limit_Restriction;
class midw_ext_fi_tcl_e8_TCU_ConnectionType;
class midw_ext_fi_tcl_e8_TCU_XCALL_Type;
class midw_ext_fi_tcl_e8_TCU_XCALL_Language;
class midw_ext_fi_tcl_e8_TCU_Response_Time_Out;
class midw_ext_fi_tcl_TCU_Response_Time_Out;
class midw_ext_fi_tcl_e8_TCU_Availability;
class midw_ext_fi_tcl_e8_TCU_CallType;
class midw_ext_fi_tcl_e8_TCU_PrivacyModes;
class midw_ext_fi_tcl_usb_tcu_Data_Header_Part;
class midw_ext_fi_tcl_usb_tcu_Location;
class midw_ext_fi_tcl_usb_tcu_Data_Record;
class midw_ext_fi_tcl_usb_tcu_connected_search_result;
class midw_ext_fi_tcl_usb_tcu_channel_master_data_header;
class midw_ext_fi_tcl_usb_tcu_Folder_definition_information;
class midw_ext_fi_tcl_usb_tcu_Channel_definition_information;
class midw_ext_fi_tcl_usb_tcu_channel_master_data;
class midw_ext_fi_tcl_e8_tcu_AudioActivity;
class midw_ext_fi_tcl_usb_tcu_Channel_Info;
class midw_ext_fi_tcl_usb_tcu_Channel_Info_List;
class midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info;
class midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info;
class midw_ext_fi_tcl_usb_tcu_GroupA_Info;
class midw_ext_fi_tcl_e8_ConnectedSearchServiceType;
class midw_ext_fi_tcl_e8_tcu_ExecType;
class midw_ext_fi_tcl_e8_DatabaseStatus;
class midw_ext_fi_tcl_e8_DatabaseServiceType;
class midw_ext_fi_tcl_e8_CancelRequestType;
class midw_ext_fi_tcl_usb_tcu_Server_Info;
class midw_ext_fi_tcl_usb_tcu_Server_Info_List;
class midw_ext_fi_tcl_e8_DataConnectionStatus;
class midw_ext_fi_tcl_e8_DataDownloadStatus;
class midw_ext_fi_tcl_e16_DataConnectionError;
class midw_ext_fi_tcl_e8_ModemType;
class midw_ext_fi_tcl_usb_tcu_TCUDevice_Info;
class midw_ext_fi_tcl_e8_tcu_LogLevel;
class midw_ext_fi_tcl_e8_SxmPredefinedListIds;
class midw_ext_fi_tcl_e8_SxmListType;
class midw_ext_fi_tcl_e8_SxmListStatus;
class midw_ext_fi_tcl_e8_SxmListMode;
class midw_ext_fi_tcl_SxmListMode;
class midw_ext_fi_tcl_e8_SxmListOperation;
class midw_ext_fi_tcl_SxmLocation;
class midw_ext_fi_tcl_SxmListInfo;
class midw_ext_fi_tcl_SxmListsConfig;
class midw_ext_fi_tcl_SxmListInfos;
class midw_ext_fi_tcl_e8_SxmDataServiceStatus;
class midw_ext_fi_tcl_SxmDataSrvState;
class midw_ext_fi_tcl_e8_SxmDataServiceType;
class midw_ext_fi_tcl_SxmListElemDataSrvState;
class midw_ext_fi_tcl_RGBAcolor;
class midw_ext_fi_tcl_e8_Graphics;
class midw_ext_fi_tcl_e8_ChannelSkipType;
class midw_ext_fi_tcl_ChannelListEntry;
class midw_ext_fi_tcl_e8_MethodStatus;
class midw_ext_fi_tcl_e8_ErrorTypes;
class midw_ext_fi_tcl_ChannelList;
class midw_ext_fi_tcl_PresetListEntry;
class midw_ext_fi_tcl_CategoryListEntry;
class midw_ext_fi_tcl_e8_SelectChannelMode;
class midw_ext_fi_tcl_PresetChannelList;
class midw_ext_fi_tcl_ChannelInformation;
class midw_ext_fi_tcl_e8_SportsFlash_Sport;
class midw_ext_fi_tcl_e8_SportsFlash_League;
class midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus;
class midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus;
class midw_ext_fi_tcl_e8_SystemMessage;
class midw_ext_fi_tcl_e8_Sxm_AntennaState;
class midw_ext_fi_tcl_e8_Sxm_SignalQuality;
class midw_ext_fi_tcl_SxmSignalQuality;
class midw_ext_fi_tcl_SxmDetSignalQuality;
class midw_ext_fi_tcl_SxmDetOvrlSignalQuality;
class midw_ext_fi_tcl_SxmVersionInfo;
class midw_ext_fi_tcl_SxmDataSubStatus;
class midw_ext_fi_tcl_SxmDiagTestModeData;
class midw_ext_fi_tcl_SxmSmsDbInfo;
class midw_ext_fi_tcl_SxmAudioSubInfo;
class midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult;
class midw_ext_fi_tcl_e8_SxmExtDiagMode;
class midw_ext_fi_tcl_SmartFavoritePreset;
class midw_ext_fi_tcl_SFListElement;
class midw_ext_fi_tcl_e8_SFOperation;
class midw_ext_fi_tcl_e8_IRPlaybackMode;
class midw_ext_fi_tcl_e8_IRPlaybackStatus;
class midw_ext_fi_tcl_InstantReplayStatus;
class midw_ext_fi_tcl_e8_TuneScanMode;
class midw_ext_fi_tcl_e8_FavoriteType;
class midw_ext_fi_tcl_e8_FavoriteStatus;
class midw_ext_fi_tcl_e8_Action;
class midw_ext_fi_tcl_RegisteredFavorite;
class midw_ext_fi_tcl_b8_ChannelStatus;
class midw_ext_fi_tcl_AlertInfo;
class midw_ext_fi_tcl_e8_FlashServiceStatus;
class midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction;
class midw_ext_fi_tcl_e8_TWNow_Bulletin_Status;
class midw_ext_fi_tcl_MarketListEntry;
class midw_ext_fi_tcl_MarketList;
class midw_ext_fi_tcl_SportsFlash_FavoriteTeam;
class midw_ext_fi_tcl_SportsFlash_Game;
class midw_ext_fi_tcl_SportsFlash_FlashEvent;
class midw_ext_fi_tcl_SportsFlash_League;
class midw_ext_fi_tcl_SportsFlash_Team;
class midw_ext_fi_tcl_e8_TuneScanStatus;
class midw_ext_fi_tcl_SportsFlash_MonitorTeam;
class midw_ext_fi_tcl_e8_FlashEventPlaybackStatus;
class midw_ext_fi_tcl_e8_BrowseDirection;
class midw_ext_fi_tcl_BrowseRateConfiguration;
class midw_ext_fi_tcl_e8_BrowseChannelLoop;
class midw_ext_fi_tcl_e8_BrowseChannelType;
class midw_ext_fi_tcl_BrowseChannelConfig;
class midw_ext_fi_tcl_b16_CHANNEL_EVENT;
class midw_ext_fi_tcl_LocalTimeDate;
class midw_ext_fi_tcl_PresetEntry;
class midw_ext_fi_tcl_Status;
class midw_ext_fi_tcl_ProfileStatus;
class midw_ext_fi_tcl_ProfileAction;
class midw_ext_fi_tcl_ProfileResponse;
class midw_ext_fi_tcl_PresetsConfiguration;
class midw_ext_fi_tcl_e8ChannelArtErrorTypes;
class midw_ext_fi_tcl_e8_ChnGraphicsTypes;
class midw_ext_fi_tcl_ImageData;
class midw_ext_fi_tcl_e8_FuelTypeEnum;
class midw_ext_fi_tcl_e8_FuelStationAmenity;
class midw_ext_fi_tcl_e8_SortType;
class midw_ext_fi_tcl_FuelInfo;
class midw_ext_fi_tcl_FuelTypeInfo;
class midw_ext_fi_tcl_e8FuelErrorTypes;
class midw_ext_fi_tcl_FuelTypeInfolist;
class midw_ext_fi_tcl_FuelStationInfo;
class midw_ext_fi_tcl_FuelInfoList;
class midw_ext_fi_tcl_BrandNameList;
class midw_ext_fi_tcl_FuelTypeList;
class midw_ext_fi_tcl_e8_TheatreAmenities;
class midw_ext_fi_tcl_TheatreInfo;
class midw_ext_fi_tcl_MovieInfo;
class midw_ext_fi_tcl_TheatreDetails;
class midw_ext_fi_tcl_ShowDate;
class midw_ext_fi_tcl_TheatreInfoList;
class midw_ext_fi_tcl_MoviesList;
class midw_ext_fi_tcl_ShowTimes;
class midw_ext_fi_tcl_MovieTimes;
class midw_ext_fi_tcl_MovieTimesList;
class midw_ext_fi_tcl_MovieDetails;
class midw_ext_fi_tcl_e8MovieErrorTypes;
class midw_ext_fi_tcl_SportInfo;
class midw_ext_fi_tcl_SportList;
class midw_ext_fi_tcl_e8_Game_Status;
class midw_ext_fi_tcl_AffiliateInfo;
class midw_ext_fi_tcl_RootAffiliateList;
class midw_ext_fi_tcl_AffiliateCategories;
class midw_ext_fi_tcl_SubLeagues;
class midw_ext_fi_tcl_e8CategoryAvailability;
class midw_ext_fi_tcl_TimeInfo;
class midw_ext_fi_tcl_XMChannelType;
class midw_ext_fi_tcl_XMChannel;
class midw_ext_fi_tcl_Details;
class midw_ext_fi_tcl_TeamInfo;
class midw_ext_fi_tcl_GameType;
class midw_ext_fi_tcl_GameInfo;
class midw_ext_fi_tcl_AvailableGames;
class midw_ext_fi_tcl_TeamList;
class midw_ext_fi_tcl_AllTeams;
class midw_ext_fi_tcl_GameList;
class midw_ext_fi_tcl_FavoriteInfo;
class midw_ext_fi_tcl_FavoriteList;
class midw_ext_fi_tcl_AffiliateDetailInfo;
class midw_ext_fi_tcl_SportsUpdateType;
class midw_ext_fi_tcl_AffiliateDetails;
class midw_ext_fi_tcl_e8SportsErrorTypes;
class midw_ext_fi_tcl_EventSchedule;
class midw_ext_fi_tcl_EventSchedule_List;
class midw_ext_fi_tcl_EventRank;
class midw_ext_fi_tcl_EventRankList;
class midw_ext_fi_tcl_NewsInfo;
class midw_ext_fi_tcl_NewsList;
class midw_ext_fi_tcl_e8SportsServiceDataStatus;
class midw_ext_fi_tcl_e8_ForecastType;
class midw_ext_fi_tcl_e8_PollenLevelType;
class midw_ext_fi_tcl_e8_AirQualityType;
class midw_ext_fi_tcl_e8_CloudCoverType;
class midw_ext_fi_tcl_WeatherInfo;
class midw_ext_fi_tcl_WeatherInfoList;
class midw_ext_fi_tcl_e8_TabWeather_ErrorTypes;
class midw_ext_fi_tcl_e8_SXMTileType;
class midw_ext_fi_tcl_e8_SXMShapeType;
class midw_ext_fi_tcl_e8_SXMTileDataType;
class midw_ext_fi_tcl_SXMSharedMemoryDescription;
class midw_ext_fi_tcl_SXMSharedMemoryTile;
class midw_ext_fi_tcl_SXMShape;
class midw_ext_fi_tcl_e8_FrontType;
class midw_ext_fi_tcl_e8_PressureType;
class midw_ext_fi_tcl_SXMShapeTypeIsobar;
class midw_ext_fi_tcl_SXMShapeTypeWindRadius;
class midw_ext_fi_tcl_e8_StormPositionType;
class midw_ext_fi_tcl_e8_StormType;
class midw_ext_fi_tcl_b8_StormType;
class midw_ext_fi_tcl_SXMShapeTypeStormAttributes;
class midw_ext_fi_tcl_SXMShapeTypeFront;
class midw_ext_fi_tcl_SXMShapeTypePressureCenter;
class midw_ext_fi_tcl_SXMShapeTypeStormPosition;
class midw_ext_fi_tcl_SXMShapeTypeStormTrack;
class midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION;
class midw_ext_fi_tcl_e8_Stock_ErrorTypes;
class midw_ext_fi_tcl_StockQuote;
class midw_ext_fi_tcl_StockQuoteList;
class midw_ext_fi_tcl_StockFilterList;
class midw_ext_fi_tcl_SXMSafeviewSubLocationInfo;
class midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo;
class midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList;
class midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes;
class midw_ext_fi_tclDCLK_TEN_DST_Setting;
class midw_ext_fi_tclDCLK_TEN_GPS_EPOCH;
class midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE;
class midw_ext_fi_tclDCLK_TEN_TimeDateStatus;
class midw_ext_fi_tclDCLK_TEN_FormatSourceStatus;
class midw_ext_fi_tclDCLK_TEN_ClockSourceStatus;
class midw_ext_fi_tclDCLK_TEN_TimeFormat;
class midw_ext_fi_tclDCLK_TEN_DateFormat;
class midw_ext_fi_tclDCLK_TEN_SyncMode;
class midw_ext_fi_tcl_WSAlertLocation;
class midw_ext_fi_tcl_e8_WSAlertAnnounceStatus;
class midw_ext_fi_tcl_e8_WSAlertAnnounceAction;
class midw_ext_fi_tcl_e8_WSAlertListStatus;
class midw_ext_fi_tcl_e8_WSAlertTypes;
class midw_ext_fi_tcl_WSAlertInfo;
class midw_ext_fi_tcl_WSAlertConfig;
class midw_ext_fi_tcl_e8_Language;
class midw_ext_fi_tcl_WSAlertMsg;
class midw_ext_fi_tcl_e8_WSAlertActionType;
class midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes;
class midw_ext_fi_tcl_e8FullType;
class midw_ext_fi_tcl_Fullness;
class midw_ext_fi_tcl_e8Open24Hours;
class midw_ext_fi_tcl_e8CashOrCard;
class midw_ext_fi_tcl_e8ParkingType;
class midw_ext_fi_tcl_e8MetroLocation;
class midw_ext_fi_tcl_e8AirPort;
class midw_ext_fi_tcl_e8OvernightParking;
class midw_ext_fi_tcl_e8Reservations;
class midw_ext_fi_tcl_e8SelfParking;
class midw_ext_fi_tcl_e8Security;
class midw_ext_fi_tcl_e8TollTag;
class midw_ext_fi_tcl_e8SUVCharges;
class midw_ext_fi_tcl_e8RV;
class midw_ext_fi_tcl_e8OpenStatus;
class midw_ext_fi_tcl_AmenityInfo;
class midw_ext_fi_tcl_PriceInfo;
class midw_ext_fi_tcl_Time;
class midw_ext_fi_tcl_PerDayOpeningTimes;
class midw_ext_fi_tcl_e8DayType;
class midw_ext_fi_tcl_OpeningTime;
class midw_ext_fi_tcl_ParkingInfo;
class midw_ext_fi_tcl_FilterConfig;
class midw_ext_fi_tcl_AmenityConfig;
class midw_ext_fi_tcl_FilterConfiguration;
class midw_ext_fi_tcl_e8ParkingErrorTypes;
class midw_ext_fi_tcl_e8_CanFuelTypeEnum;
class midw_ext_fi_tcl_e8_CanFuelStationAmenity;
class midw_ext_fi_tcl_e8_CanFuelSortType;
class midw_ext_fi_tcl_CanFuelInfo;
class midw_ext_fi_tcl_CanFuelTypeInfo;
class midw_ext_fi_tcl_e8CanFuelErrorTypes;
class midw_ext_fi_tcl_CanFuelTypeInfolist;
class midw_ext_fi_tcl_CanFuelStationInfo;
class midw_ext_fi_tcl_CanFuelInfoList;
class midw_ext_fi_tcl_CanBrandNameList;
class midw_ext_fi_tcl_CanFuelTypeList;
class midw_ext_fi_tcl_ChannelPhoneticsInfo;
class midw_ext_fi_tcl_CategoryPhoneticsInfo;
class midw_ext_fi_tcl_LeaguePhoneticsInfo;
class midw_ext_fi_tcl_MarketPhoneticsInfo;
class midw_ext_fi_tcl_TeamPhoneticsInfo;
class midw_ext_fi_tcl_e8PhoneticsErrorTypes;
class midw_ext_fi_tcl_e8PhoneticsType;
class midw_ext_fi_tcl_e8LanguageType;
class midw_ext_fi_tcl_BinContainer : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_BinContainer& operator=(const midw_ext_fi_tcl_BinContainer& coRef);
   midw_ext_fi_tcl_BinContainer(const midw_ext_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~midw_ext_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Reserved : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Reserved();

   virtual ~midw_ext_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u8_Percent : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_ext_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_PerThousand : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u16_IndexInReferenceList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u16_ErrorCode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u16_RPM : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Kilogram : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Pound : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_Meter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Meter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Yards : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Foot : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Centimeter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Inch : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Millimeter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Microliter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Second : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u16_MilliSecond : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_MilliSecond : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_POSIXTime : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_POSIXTime& operator=(const midw_ext_fi_tcl_POSIXTime& coRef);
   midw_ext_fi_tcl_POSIXTime(const midw_ext_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~midw_ext_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DST_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DST_State(midw_ext_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TimeZoneElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TimeZoneElement& operator=(const midw_ext_fi_tcl_TimeZoneElement& coRef);
   midw_ext_fi_tcl_TimeZoneElement(const midw_ext_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclMultiLanguageString Abbreviation_StandardTime;
   midw_ext_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   midw_ext_fi_tcl_s32_Second TimeZoneDifference;
   midw_ext_fi_tcl_e8_DST_State DST_State;
   midw_ext_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~midw_ext_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_KmPerHour : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_MilesPerHour : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_Knot : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_CentimeterSecond : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_Kelvin : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_Fahrenheit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Pascal : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Watt : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FIVersion : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FIVersion& operator=(const midw_ext_fi_tcl_FIVersion& coRef);
   midw_ext_fi_tcl_FIVersion(const midw_ext_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~midw_ext_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Longitude : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s32_Latitude : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~midw_ext_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PositionWGS84 : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PositionWGS84& operator=(const midw_ext_fi_tcl_PositionWGS84& coRef);
   midw_ext_fi_tcl_PositionWGS84(const midw_ext_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_s32_Longitude Longitude;
   midw_ext_fi_tcl_s32_Latitude Latitude;
   virtual ~midw_ext_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_RectangleWGS84 : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_RectangleWGS84& operator=(const midw_ext_fi_tcl_RectangleWGS84& coRef);
   midw_ext_fi_tcl_RectangleWGS84(const midw_ext_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_s32_Longitude LongitudeMin;
   midw_ext_fi_tcl_s32_Latitude LatitudeMin;
   midw_ext_fi_tcl_s32_Longitude LongitudeMax;
   midw_ext_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~midw_ext_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e16_ISOCountryCode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   midw_ext_fi_tcl_e16_ISOCountryCode(midw_ext_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e16_ISOLanguageCode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   midw_ext_fi_tcl_e16_ISOLanguageCode(midw_ext_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_LanguageID : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_LanguageID& operator=(const midw_ext_fi_tcl_LanguageID& coRef);
   midw_ext_fi_tcl_LanguageID(const midw_ext_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   midw_ext_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~midw_ext_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u8_DirectionAbsolute : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_ext_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u8_DirectionRelative : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~midw_ext_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_CentiDegree : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_Degree : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FuelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FuelType(midw_ext_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DistTimeFuel : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DistTimeFuel& operator=(const midw_ext_fi_tcl_DistTimeFuel& coRef);
   midw_ext_fi_tcl_DistTimeFuel(const midw_ext_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_s32_Meter Distance;
   midw_ext_fi_tcl_s32_Second Time;
   midw_ext_fi_tcl_s32_Microliter Fuel;
   virtual ~midw_ext_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_Response : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_Response();
   enum tenType {
      FI_EN_DAB_RES_OK = 0UL,
      FI_EN_DAB_RES_FAILED = 1UL,
      FI_EN_DAB_RES_NOT_AVAILABLE = 2UL,
      FI_EN_DAB_RES_INPROCESS = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_Response(midw_ext_fi_tcl_e8_DAB_Response::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_Response();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_Response& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_UserProfileAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_UserProfileAction();
   enum tenType {
      FI_EN_DAB_PROFILE_CHANGE = 0UL,
      FI_EN_DAB_PROFILE_DELETE = 1UL,
      FI_EN_DAB_PROFILE_COPY = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_UserProfileAction(midw_ext_fi_tcl_e8_DAB_UserProfileAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_UserProfileAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_UserProfileAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_SourceState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_SourceState();
   enum tenType {
      FI_EN_DAB_BACKGROUND = 0UL,
      FI_EN_DAB_FOREGROUND = 1UL,
      FI_EN_DAB_SERVICE_FOLLOWING = 2UL,
      FI_EN_DAB_FOREGROUND_TA = 3UL,
      FI_EN_DAB_FOREGROUND_ALARM = 4UL,
      FI_EN_DAB_BACKGROUND_ANNO_SURVEILLANCE = 5UL,
      FI_EN_DAB_FOREGROUND_ANNO_SURVEILLANCE = 6UL,
      FI_EN_DAB_LEARN_FOREVER = 7UL,
      FI_EN_DAB_BG_LEARN_FOREVER = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_SourceState(midw_ext_fi_tcl_e8_DAB_SourceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_SourceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_SourceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_Label : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_Label();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_Label& operator=(const midw_ext_fi_tcl_DAB_Label& coRef);
   midw_ext_fi_tcl_DAB_Label(const midw_ext_fi_tcl_DAB_Label& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sLabel;
   midw_ext_fi_tclString sLabelShort;
   tU16 u16LabelMask;
   virtual ~midw_ext_fi_tcl_DAB_Label();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_Label& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ServiceType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ServiceType();
   enum tenType {
      FI_EN_DAB_SERVICETYPE_UNKNOWN = 0UL,
      FI_EN_DAB_SERVICETYPE_AUDIO = 1UL,
      FI_EN_DAB_SERVICETYPE_DATA = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ServiceType(midw_ext_fi_tcl_e8_DAB_ServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ServiceListSortingType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ServiceListSortingType();
   enum tenType {
      FI_EN_DAB_SERVICELIST_SORTINGTYPE_LABEL = 0UL,
      FI_EN_DAB_SERVICELIST_SORTINGTYPE_SID = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ServiceListSortingType(midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ServiceListSortingType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ServiceListSortingType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType();
   enum tenType {
      FI_EN_DAB_ENSEMBLELIST_SORTINGTYPE_LABEL = 0UL,
      FI_EN_DAB_ENSEMBLELIST_SORTINGTYPE_FREQ = 1UL,
      FI_EN_DAB_ENSEMBLELIST_SORTINGTYPE_EID = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType(midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AST_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AST_Type();
   enum tenType {
      FI_EN_DAB_AST_NORMAL = 0UL,
      FI_EN_DAB_AST_INITIAL = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AST_Type(midw_ext_fi_tcl_e8_DAB_AST_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AST_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AST_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode();
   enum tenType {
      FI_EN_DAB_SERVICELINKING_OFF = 0UL,
      FI_EN_DAB_SERVICELINKING_DAB = 1UL,
      FI_EN_DAB_SERVICELINKING_DAB_FM = 2UL,
      FI_EN_DAB_SERVICELINKING_FM = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode(midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_MTC_SetMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_MTC_SetMode();

   enum {
      FI_C_U8_BIT_DAB_SERVICELINKING_FM = 0x1UL,
      FI_C_U8_BIT_FM_SERVICELINKING_DAB = 0x2UL
   };
   tBool bDAB_SERVICELINKING_FM() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICELINKING_FM) != 0; }
   tVoid vSetDAB_SERVICELINKING_FM(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICELINKING_FM):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICELINKING_FM)); }
   tBool bFM_SERVICELINKING_DAB() const {return (u8Value & FI_C_U8_BIT_FM_SERVICELINKING_DAB) != 0; }
   tVoid vSetFM_SERVICELINKING_DAB(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_FM_SERVICELINKING_DAB):(u8Value & ~(tU8)FI_C_U8_BIT_FM_SERVICELINKING_DAB)); }
   struct rBitValues {
      tBool DAB_SERVICELINKING_FM:1;
      tBool FM_SERVICELINKING_DAB:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_MTC_SetMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_MTC_SetMode& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_MTC_Request : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_MTC_Request();
   enum tenType {
      FI_EN_DAB_SERVICELINKING_FM = 0UL,
      FI_EN_FM_SERVICELINKING_DAB = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_MTC_Request(midw_ext_fi_tcl_e8_MTC_Request::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_MTC_Request();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_MTC_Request& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_MTC_Tuner_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_MTC_Tuner_Status();
   enum tenType {
      FI_EN_MAIN_DAB_TUNER = 0UL,
      FI_EN_MAIN_FM_TUNER = 1UL,
      FI_EN_MAIN_TUNER_UNKNOWN = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_MTC_Tuner_Status(midw_ext_fi_tcl_e8_MTC_Tuner_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_MTC_Tuner_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_MTC_Tuner_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState();
   enum tenType {
      FI_EN_STOPPED = 0UL,
      FI_EN_START_FM_ANNOUNCEMENT = 1UL,
      FI_EN_START_DAB_ANNOUNCEMENT = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState(midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_StationType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_StationType();
   enum tenType {
      FI_EN_DAB = 0UL,
      FI_EN_FM = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_StationType(midw_ext_fi_tcl_e8_StationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_StationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_StationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TPState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TPState();
   enum tenType {
      FI_EN_NO_TP = 0UL,
      FI_EN_TP = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TPState(midw_ext_fi_tcl_e8_TPState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TPState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TPState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_SampleRate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_SampleRate();
   enum tenType {
      FI_EN_DAB_SAMPLERATE_48KHZ = 0UL,
      FI_EN_DAB_SAMPLERATE_24KHZ = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_SampleRate(midw_ext_fi_tcl_e8_DAB_SampleRate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_SampleRate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_SampleRate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AudioMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AudioMode();
   enum tenType {
      FI_EN_DAB_AUDIOMODE_STEREO = 0UL,
      FI_EN_DAB_AUDIOMODE_JOINT_STEREO = 1UL,
      FI_EN_DAB_AUDIOMODE_DUAL_CHANNEL = 2UL,
      FI_EN_DAB_AUDIOMODE_MONO = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AudioMode(midw_ext_fi_tcl_e8_DAB_AudioMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AudioMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AudioMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AudioCodec : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AudioCodec();
   enum tenType {
      FI_EN_DAB_AUDIOCODEC_NOT_RECOGNIZED = 0UL,
      FI_EN_DAB_AUDIOCODEC_MUSICAM = 1UL,
      FI_EN_DAB_AUDIOCODEC_DABPLUS = 2UL,
      FI_EN_DAB_AUDIOCODEC_DMB_AUDIO = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AudioCodec(midw_ext_fi_tcl_e8_DAB_AudioCodec::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AudioCodec();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AudioCodec& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_Encoding : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_Encoding();
   enum tenType {
      FI_EN_DAB_ENCODING_MPEG1 = 0UL,
      FI_EN_DAB_ENCODING_MPEG2 = 1UL,
      FI_EN_DAB_ENCODING_HEAAC = 2UL,
      FI_EN_DAB_ENCODING_BSAC = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_Encoding(midw_ext_fi_tcl_e8_DAB_Encoding::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_Encoding();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_Encoding& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ComponentType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ComponentType();
   enum tenType {
      FI_EN_DAB_COMPONENTTYPE_PRIMARY = 0UL,
      FI_EN_DAB_COMPONENTTYPE_SECONDARY = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ComponentType(midw_ext_fi_tcl_e8_DAB_ComponentType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ComponentType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ComponentType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TMIdType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TMIdType();
   enum tenType {
      FI_EN_DAB_TMIDTYPE_MSC_AUDIO_STREAM = 0UL,
      FI_EN_DAB_TMIDTYPE_MSC_DATA_STREAM = 1UL,
      FI_EN_DAB_TMIDTYPE_FIDC = 2UL,
      FI_EN_DAB_TMIDTYPE_MSC_DATA_PACKET = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TMIdType(midw_ext_fi_tcl_e8_DAB_TMIdType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TMIdType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TMIdType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType();
   enum tenType {
      FI_EN_DAB_ASCTY_FG_SOUND = 0UL,
      FI_EN_DAB_ASCTY_BG_SOUND = 1UL,
      FI_EN_DAB_ASCTY_MULTI_CHANNEL = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType(midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AudioServiceComponentType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_DataServiceComponentType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_DataServiceComponentType();
   enum tenType {
      FI_EN_DAB_DSCTY_NOT_SPECIFIED = 0UL,
      FI_EN_DAB_DSCTY_TMC = 1UL,
      FI_EN_DAB_DSCTY_EWS = 2UL,
      FI_EN_DAB_DSCTY_ITTS = 3UL,
      FI_EN_DAB_DSCTY_PAGING = 4UL,
      FI_EN_DAB_DSCTY_MOT = 60UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_DataServiceComponentType(midw_ext_fi_tcl_e8_DAB_DataServiceComponentType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_DataServiceComponentType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_DataServiceComponentType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b16_DAB_AnnouncementType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b16_DAB_AnnouncementType();

   enum {
      FI_C_U16_BIT_DAB_ANNOTYPE_ALARM = 0x1UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_TA = 0x2UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_TRANSPORT = 0x4UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_WARNING = 0x8UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_NEWS = 0x10UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_WEATHER = 0x20UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_EVENT = 0x40UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_SPECIALEVENT = 0x80UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_PROGRAMME = 0x100UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_SPORTS = 0x200UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_FINANCE = 0x400UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_B11_RESERVED = 0x800UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_B12_RESERVED = 0x1000UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_B13_RESERVED = 0x2000UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_B14_RESERVED = 0x4000UL,
      FI_C_U16_BIT_DAB_ANNOTYPE_B15_RESERVED = 0x8000UL
   };
   tBool bDAB_ANNOTYPE_ALARM() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_ALARM) != 0; }
   tVoid vSetDAB_ANNOTYPE_ALARM(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_ALARM):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_ALARM)); }
   tBool bDAB_ANNOTYPE_TA() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_TA) != 0; }
   tVoid vSetDAB_ANNOTYPE_TA(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_TA):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_TA)); }
   tBool bDAB_ANNOTYPE_TRANSPORT() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_TRANSPORT) != 0; }
   tVoid vSetDAB_ANNOTYPE_TRANSPORT(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_TRANSPORT):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_TRANSPORT)); }
   tBool bDAB_ANNOTYPE_WARNING() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_WARNING) != 0; }
   tVoid vSetDAB_ANNOTYPE_WARNING(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_WARNING):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_WARNING)); }
   tBool bDAB_ANNOTYPE_NEWS() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_NEWS) != 0; }
   tVoid vSetDAB_ANNOTYPE_NEWS(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_NEWS):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_NEWS)); }
   tBool bDAB_ANNOTYPE_WEATHER() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_WEATHER) != 0; }
   tVoid vSetDAB_ANNOTYPE_WEATHER(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_WEATHER):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_WEATHER)); }
   tBool bDAB_ANNOTYPE_EVENT() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_EVENT) != 0; }
   tVoid vSetDAB_ANNOTYPE_EVENT(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_EVENT):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_EVENT)); }
   tBool bDAB_ANNOTYPE_SPECIALEVENT() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_SPECIALEVENT) != 0; }
   tVoid vSetDAB_ANNOTYPE_SPECIALEVENT(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_SPECIALEVENT):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_SPECIALEVENT)); }
   tBool bDAB_ANNOTYPE_PROGRAMME() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_PROGRAMME) != 0; }
   tVoid vSetDAB_ANNOTYPE_PROGRAMME(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_PROGRAMME):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_PROGRAMME)); }
   tBool bDAB_ANNOTYPE_SPORTS() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_SPORTS) != 0; }
   tVoid vSetDAB_ANNOTYPE_SPORTS(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_SPORTS):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_SPORTS)); }
   tBool bDAB_ANNOTYPE_FINANCE() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_FINANCE) != 0; }
   tVoid vSetDAB_ANNOTYPE_FINANCE(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_FINANCE):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_FINANCE)); }
   tBool bDAB_ANNOTYPE_b11_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_B11_RESERVED) != 0; }
   tVoid vSetDAB_ANNOTYPE_b11_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_B11_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_B11_RESERVED)); }
   tBool bDAB_ANNOTYPE_b12_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_B12_RESERVED) != 0; }
   tVoid vSetDAB_ANNOTYPE_b12_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_B12_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_B12_RESERVED)); }
   tBool bDAB_ANNOTYPE_b13_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_B13_RESERVED) != 0; }
   tVoid vSetDAB_ANNOTYPE_b13_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_B13_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_B13_RESERVED)); }
   tBool bDAB_ANNOTYPE_b14_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_B14_RESERVED) != 0; }
   tVoid vSetDAB_ANNOTYPE_b14_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_B14_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_B14_RESERVED)); }
   tBool bDAB_ANNOTYPE_b15_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_ANNOTYPE_B15_RESERVED) != 0; }
   tVoid vSetDAB_ANNOTYPE_b15_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_ANNOTYPE_B15_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_ANNOTYPE_B15_RESERVED)); }
   struct rBitValues {
      tBool DAB_ANNOTYPE_ALARM:1;
      tBool DAB_ANNOTYPE_TA:1;
      tBool DAB_ANNOTYPE_TRANSPORT:1;
      tBool DAB_ANNOTYPE_WARNING:1;
      tBool DAB_ANNOTYPE_NEWS:1;
      tBool DAB_ANNOTYPE_WEATHER:1;
      tBool DAB_ANNOTYPE_EVENT:1;
      tBool DAB_ANNOTYPE_SPECIALEVENT:1;
      tBool DAB_ANNOTYPE_PROGRAMME:1;
      tBool DAB_ANNOTYPE_SPORTS:1;
      tBool DAB_ANNOTYPE_FINANCE:1;
      tBool DAB_ANNOTYPE_b11_reserved:1;
      tBool DAB_ANNOTYPE_b12_reserved:1;
      tBool DAB_ANNOTYPE_b13_reserved:1;
      tBool DAB_ANNOTYPE_b14_reserved:1;
      tBool DAB_ANNOTYPE_b15_reserved:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b16_DAB_AnnouncementType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b16_DAB_AnnouncementType& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_PENDING = 1UL,
      FI_EN_SELECTING = 2UL,
      FI_EN_SELECTED = 3UL,
      FI_EN_DESELECTING = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState(midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AnnouncementStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AnnouncementStatus();
   enum tenType {
      FI_EN_START = 1UL,
      FI_EN_END = 2UL,
      FI_EN_ESCAPED = 3UL,
      FI_EN_SWITCHED = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AnnouncementStatus(midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AnnouncementStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AnnouncementStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_AnnouncementSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_AnnouncementSource();
   enum tenType {
      FI_EN_DAB_ANNOSOURCE_NONE = 0UL,
      FI_EN_DAB_ANNOSOURCE_CURRENT_SUBCHANNEL = 1UL,
      FI_EN_DAB_ANNOSOURCE_CURRENT_SERVICE = 2UL,
      FI_EN_DAB_ANNOSOURCE_CURRENT_ENSEMBLE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_AnnouncementSource(midw_ext_fi_tcl_e8_DAB_AnnouncementSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_AnnouncementSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_AnnouncementSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ChnSelectMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ChnSelectMode();
   enum tenType {
      FI_EN_DAB_CHNSELECTMODE_PSDI = 0UL,
      FI_EN_DAB_CHNSELECTMODE_LISTID = 1UL,
      FI_EN_DAB_CHNSELECTMODE_RELATIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ChnSelectMode(midw_ext_fi_tcl_e8_DAB_ChnSelectMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ChnSelectMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ChnSelectMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_EnsSelectMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_EnsSelectMode();
   enum tenType {
      FI_EN_DAB_ENSSELECTMODE_ENSID = 0UL,
      FI_EN_DAB_ENSSELECTMODE_LISTID = 1UL,
      FI_EN_DAB_ENSSELECTMODE_RELATIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_EnsSelectMode(midw_ext_fi_tcl_e8_DAB_EnsSelectMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_EnsSelectMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_EnsSelectMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_CompSelectMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_CompSelectMode();
   enum tenType {
      FI_EN_DAB_CHNSELECTMODE_SCID = 0UL,
      FI_EN_DAB_CHNSELECTMODE_LISTID = 1UL,
      FI_EN_DAB_CHNSELECTMODE_RELATIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_CompSelectMode(midw_ext_fi_tcl_e8_DAB_CompSelectMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_CompSelectMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_CompSelectMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_UriSelectState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_UriSelectState();
   enum tenType {
      FI_EN_DAB_URI_SELECT_STATE_OK = 0UL,
      FI_EN_DAB_URI_SELECT_STATE_NOT_VALID = 1UL,
      FI_EN_DAB_URI_SELECT_STATE_NO_RESOURCES = 4UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_NOT_VALID = 5UL,
      FI_EN_DAB_URI_SELECT_STATE_ALREADY_SELECTED = 17UL,
      FI_EN_DAB_URI_SELECT_STATE_NOT_SELECTED = 18UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_PROCESSING = 32UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_ACTIVATED = 33UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER = 34UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION = 35UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER = 36UL,
      FI_EN_DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS = 37UL,
      FI_EN_DAB_URI_SELECT_STATE_ERROR = 65535UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_UriSelectState(midw_ext_fi_tcl_e8_DAB_UriSelectState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_UriSelectState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_UriSelectState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TunerActivityType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TunerActivityType();
   enum tenType {
      FI_EN_DAB_ACTIVITYTYPE_NORMAL = 0UL,
      FI_EN_DAB_ACTIVITYTYPE_LEARN = 1UL,
      FI_EN_DAB_ACTIVITYTYPE_SEEK = 2UL,
      FI_EN_DAB_ACTIVITYTYPE_SCAN = 3UL,
      FI_EN_DAB_ACTIVITYTYPE_SERVICESEEK = 4UL,
      FI_EN_DAB_ACTIVITYTYPE_TAFOLLOWING = 5UL,
      FI_EN_DAB_ACTIVITYTYPE_SERVICEFOLLOWING = 6UL,
      FI_EN_DAB_ACTIVITYTYPE_TPMONITOR = 7UL,
      FI_EN_DAB_ACTIVITYTYPE_INVALID = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TunerActivityType(midw_ext_fi_tcl_e8_DAB_TunerActivityType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TunerActivityType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TunerActivityType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_Frequency : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_Frequency();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_Frequency& operator=(const midw_ext_fi_tcl_DAB_Frequency& coRef);
   midw_ext_fi_tcl_DAB_Frequency(const midw_ext_fi_tcl_DAB_Frequency& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   midw_ext_fi_tclString sFreqLabel;
   virtual ~midw_ext_fi_tcl_DAB_Frequency();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_Frequency& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_FrequencyTable : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_FrequencyTable();
   enum tenType {
      FI_EN_DAB_FREQTABLE_AUTO = 0UL,
      FI_EN_DAB_FREQTABLE_EU_BOTH = 1UL,
      FI_EN_DAB_FREQTABLE_EU_L_BAND = 2UL,
      FI_EN_DAB_FREQTABLE_EU_BAND_3 = 3UL,
      FI_EN_DAB_FREQTABLE_CANADA = 4UL,
      FI_EN_DAB_FREQTABLE_EU_BOTH_NEW = 5UL,
      FI_EN_DAB_FREQTABLE_EU_BAND_3_NEW = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_FrequencyTable(midw_ext_fi_tcl_e8_DAB_FrequencyTable::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_FrequencyTable();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_FrequencyTable& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b16_DAB_TunerStatusFlags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b16_DAB_TunerStatusFlags();

   enum {
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SYNC = 0x1UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_ENS_VALID = 0x2UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID = 0x4UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID = 0x8UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_MUTE = 0x10UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_TUNING = 0x20UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B6_RESERVED = 0x40UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B7_RESERVED = 0x80UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_LEARN = 0x100UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B9_RESERVED = 0x200UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B10_RESERVED = 0x400UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B11_RESERVED = 0x800UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B12_RESERVED = 0x1000UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B13_RESERVED = 0x2000UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B14_RESERVED = 0x4000UL,
      FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B15_RESERVED = 0x8000UL
   };
   tBool bDAB_TUNERSTATUSFLAGS_SYNC() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SYNC) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_SYNC(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SYNC):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SYNC)); }
   tBool bDAB_TUNERSTATUSFLAGS_ENS_VALID() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_ENS_VALID) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_ENS_VALID(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_ENS_VALID):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_ENS_VALID)); }
   tBool bDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID)); }
   tBool bDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID)); }
   tBool bDAB_TUNERSTATUSFLAGS_MUTE() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_MUTE) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_MUTE(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_MUTE):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_MUTE)); }
   tBool bDAB_TUNERSTATUSFLAGS_TUNING() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_TUNING) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_TUNING(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_TUNING):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_TUNING)); }
   tBool bDAB_TUNERSTATUSFLAGS_b6_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B6_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b6_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B6_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B6_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b7_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B7_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b7_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B7_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B7_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_LEARN() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_LEARN) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_LEARN(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_LEARN):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_LEARN)); }
   tBool bDAB_TUNERSTATUSFLAGS_b9_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B9_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b9_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B9_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B9_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b10_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B10_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b10_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B10_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B10_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b11_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B11_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b11_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B11_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B11_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b12_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B12_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b12_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B12_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B12_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b13_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B13_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b13_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B13_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B13_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b14_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B14_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b14_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B14_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B14_RESERVED)); }
   tBool bDAB_TUNERSTATUSFLAGS_b15_reserved() const {return (u16Value & FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B15_RESERVED) != 0; }
   tVoid vSetDAB_TUNERSTATUSFLAGS_b15_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B15_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_DAB_TUNERSTATUSFLAGS_B15_RESERVED)); }
   struct rBitValues {
      tBool DAB_TUNERSTATUSFLAGS_SYNC:1;
      tBool DAB_TUNERSTATUSFLAGS_ENS_VALID:1;
      tBool DAB_TUNERSTATUSFLAGS_AUDIO_SERVICE_VALID:1;
      tBool DAB_TUNERSTATUSFLAGS_SERVICE_COMP_VALID:1;
      tBool DAB_TUNERSTATUSFLAGS_MUTE:1;
      tBool DAB_TUNERSTATUSFLAGS_TUNING:1;
      tBool DAB_TUNERSTATUSFLAGS_b6_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b7_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_LEARN:1;
      tBool DAB_TUNERSTATUSFLAGS_b9_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b10_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b11_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b12_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b13_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b14_reserved:1;
      tBool DAB_TUNERSTATUSFLAGS_b15_reserved:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b16_DAB_TunerStatusFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b16_DAB_TunerStatusFlags& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TunerStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TunerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TunerStatus& operator=(const midw_ext_fi_tcl_DAB_TunerStatus& coRef);
   midw_ext_fi_tcl_DAB_TunerStatus(const midw_ext_fi_tcl_DAB_TunerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TunerActivityType e8TunerActivityType;
   midw_ext_fi_tcl_DAB_Frequency FreqTuned;
   midw_ext_fi_tclString sFrequencyTable;
   midw_ext_fi_tcl_b16_DAB_TunerStatusFlags b16Flags;
   tU8 u8SignalQuality;
   tU8 u8AudioQuality;
   tU32 u32CurrentEnsembleId;
   tU32 u32CurrentServiceId;
   tU16 u16CurrentSCIDI;
   virtual ~midw_ext_fi_tcl_DAB_TunerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TunerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_RadioText : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_RadioText();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_RadioText& operator=(const midw_ext_fi_tcl_DAB_RadioText& coRef);
   midw_ext_fi_tcl_DAB_RadioText(const midw_ext_fi_tcl_DAB_RadioText& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sRadioTextData;
   tBool bValid;
   tU8 u8CharSet;
   virtual ~midw_ext_fi_tcl_DAB_RadioText();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_RadioText& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_RadioTextPlus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_RadioTextPlus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_RadioTextPlus& operator=(const midw_ext_fi_tcl_DAB_RadioTextPlus& coRef);
   midw_ext_fi_tcl_DAB_RadioTextPlus(const midw_ext_fi_tcl_DAB_RadioTextPlus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ContentType;
   midw_ext_fi_tcl_DAB_RadioText Content;
   virtual ~midw_ext_fi_tcl_DAB_RadioTextPlus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_RadioTextPlus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_EnsembleInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_EnsembleInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_EnsembleInfo& operator=(const midw_ext_fi_tcl_DAB_EnsembleInfo& coRef);
   midw_ext_fi_tcl_DAB_EnsembleInfo(const midw_ext_fi_tcl_DAB_EnsembleInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32EnsembleId;
   midw_ext_fi_tcl_DAB_Label EnsembleLabel;
   tU32 u32Frequency;
   tU8 u8NumberOfAudioServices;
   tU8 u8NumberOfDataServices;
   tU8 u8NumberOfAudioServiceComponents;
   tU8 u8NumberOfDataServiceComponents;
   tU8 u8ReceptionQuality;
   tU8 u8NumberOfEnsembles;
   tU8 u8ListElementId;
   tBool bReception;
   virtual ~midw_ext_fi_tcl_DAB_EnsembleInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_EnsembleInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags();

   enum {
      FI_C_U8_BIT_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT = 0x1UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_TMC_COMPONENT = 0x2UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_DRC = 0x4UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_B3_RESERVED = 0x8UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_B4_RESERVED = 0x10UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_B5_RESERVED = 0x20UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_B6_RESERVED = 0x40UL,
      FI_C_U8_BIT_DAB_SERVICEINFO_B7_RESERVED = 0x80UL
   };
   tBool bDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT) != 0; }
   tVoid vSetDAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT)); }
   tBool bDAB_SERVICEINFO_TMC_COMPONENT() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_TMC_COMPONENT) != 0; }
   tVoid vSetDAB_SERVICEINFO_TMC_COMPONENT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_TMC_COMPONENT):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_TMC_COMPONENT)); }
   tBool bDAB_SERVICEINFO_DRC() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_DRC) != 0; }
   tVoid vSetDAB_SERVICEINFO_DRC(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_DRC):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_DRC)); }
   tBool bDAB_SERVICEINFO_b3_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_B3_RESERVED) != 0; }
   tVoid vSetDAB_SERVICEINFO_b3_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_B3_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_B3_RESERVED)); }
   tBool bDAB_SERVICEINFO_b4_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_B4_RESERVED) != 0; }
   tVoid vSetDAB_SERVICEINFO_b4_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_B4_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_B4_RESERVED)); }
   tBool bDAB_SERVICEINFO_b5_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_B5_RESERVED) != 0; }
   tVoid vSetDAB_SERVICEINFO_b5_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_B5_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_B5_RESERVED)); }
   tBool bDAB_SERVICEINFO_b6_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_B6_RESERVED) != 0; }
   tVoid vSetDAB_SERVICEINFO_b6_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_B6_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_B6_RESERVED)); }
   tBool bDAB_SERVICEINFO_b7_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_SERVICEINFO_B7_RESERVED) != 0; }
   tVoid vSetDAB_SERVICEINFO_b7_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SERVICEINFO_B7_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SERVICEINFO_B7_RESERVED)); }
   struct rBitValues {
      tBool DAB_SERVICEINFO_SECONDARY_AUDIO_COMPONENT:1;
      tBool DAB_SERVICEINFO_TMC_COMPONENT:1;
      tBool DAB_SERVICEINFO_DRC:1;
      tBool DAB_SERVICEINFO_b3_reserved:1;
      tBool DAB_SERVICEINFO_b4_reserved:1;
      tBool DAB_SERVICEINFO_b5_reserved:1;
      tBool DAB_SERVICEINFO_b6_reserved:1;
      tBool DAB_SERVICEINFO_b7_reserved:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ServiceInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ServiceInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ServiceInfo& operator=(const midw_ext_fi_tcl_DAB_ServiceInfo& coRef);
   midw_ext_fi_tcl_DAB_ServiceInfo(const midw_ext_fi_tcl_DAB_ServiceInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ServId;
   midw_ext_fi_tcl_DAB_Label ServiceLabel;
   midw_ext_fi_tcl_e8_DAB_ServiceType e8ServiceType;
   tU8 u8NumberOfAudioComponents;
   tU8 u8NumberOfDataComponents;
   midw_ext_fi_tcl_b16_DAB_AnnouncementType b16AvailableAnnoTypesMask;
   tU8 u8SampleRate;
   tU16 u16BitRate;
   midw_ext_fi_tclString sAudioMode;
   midw_ext_fi_tclString sAdvancedAudioCodec;
   midw_ext_fi_tclString sAudioCodec;
   midw_ext_fi_tcl_b8_DAB_ServiceInfoFlags b8Flags;
   tU8 u8PresetListElementID;
   tU16 u16ServiceIndex;
   tU8 u8PTYCode;
   midw_ext_fi_tcl_e8_DAB_Encoding e8EncodingType;
   virtual ~midw_ext_fi_tcl_DAB_ServiceInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ServiceInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ChannelInfoState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ChannelInfoState();
   enum tenType {
      FI_EN_DAB_STABLE = 0UL,
      FI_EN_DAB_SELECTING = 1UL,
      FI_EN_DAB_SELECTING_WAIT = 2UL,
      FI_EN_DAB_SELECTING_SEARCH = 3UL,
      FI_EN_DAB_UNAVAIL = 4UL,
      FI_EN_DAB_INVALID = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ChannelInfoState(midw_ext_fi_tcl_e8_DAB_ChannelInfoState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ChannelInfoState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ChannelInfoState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ChannelInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ChannelInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ChannelInfo& operator=(const midw_ext_fi_tcl_DAB_ChannelInfo& coRef);
   midw_ext_fi_tcl_DAB_ChannelInfo(const midw_ext_fi_tcl_DAB_ChannelInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ServId;
   midw_ext_fi_tcl_e8_DAB_ChannelInfoState enState;
   midw_ext_fi_tcl_DAB_Label ServiceLabel;
   tU8 u8NumberOfAudioComponents;
   midw_ext_fi_tcl_b16_DAB_AnnouncementType b16AvailableAnnoTypesMask;
   tU8 u8PresetListElementID;
   tBool bComponentMode;
   tBool bFmServiceFollowActive;
   tU16 u16FrozenListElementID;
   midw_ext_fi_tcl_DAB_RadioText rRadioText;
   tU8 u8NumberOfDLPElements;
   std::vector<midw_ext_fi_tcl_DAB_RadioTextPlus, std::allocator<midw_ext_fi_tcl_DAB_RadioTextPlus> > DLPlusList;
   tBool bMuted;
   tBool bAFAvailable;
   midw_ext_fi_tclString sLogoLink;
   tU8 u8ScidsValue;
   virtual ~midw_ext_fi_tcl_DAB_ChannelInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ChannelInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ComponentInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ComponentInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ComponentInfo& operator=(const midw_ext_fi_tcl_DAB_ComponentInfo& coRef);
   midw_ext_fi_tcl_DAB_ComponentInfo(const midw_ext_fi_tcl_DAB_ComponentInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ComponentId;
   midw_ext_fi_tcl_DAB_Label ComponentLabel;
   tU16 u16SCIDI;
   tU8 u8Subchannel;
   tU8 u8SCIDS;
   midw_ext_fi_tcl_e8_DAB_ComponentType e8ComponentType;
   midw_ext_fi_tcl_e8_DAB_ServiceType e8ServiceType;
   midw_ext_fi_tcl_e8_DAB_TMIdType e8TMIdType;
   tU8 u8AudioDataServiceComponentType;
   tU16 u16ComponentIndex;
   virtual ~midw_ext_fi_tcl_DAB_ComponentInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ComponentInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_AnnoConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_AnnoConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_AnnoConfig& operator=(const midw_ext_fi_tcl_DAB_AnnoConfig& coRef);
   midw_ext_fi_tcl_DAB_AnnoConfig(const midw_ext_fi_tcl_DAB_AnnoConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b16_DAB_AnnouncementType AnnoConfigTypes;
   tBool bEnable;
   midw_ext_fi_tcl_e8_DAB_AnnouncementSource AnnoConfigSource;
   virtual ~midw_ext_fi_tcl_DAB_AnnoConfig();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_AnnoConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_AnnoElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_AnnoElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_AnnoElement& operator=(const midw_ext_fi_tcl_DAB_AnnoElement& coRef);
   midw_ext_fi_tcl_DAB_AnnoElement(const midw_ext_fi_tcl_DAB_AnnoElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AnnoType;
   midw_ext_fi_tcl_e8_DAB_AnnouncementStatus AnnoState;
   virtual ~midw_ext_fi_tcl_DAB_AnnoElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_AnnoElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_AnnoStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_AnnoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_AnnoStatus& operator=(const midw_ext_fi_tcl_DAB_AnnoStatus& coRef);
   midw_ext_fi_tcl_DAB_AnnoStatus(const midw_ext_fi_tcl_DAB_AnnoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b16_DAB_AnnouncementType AnnoConfigTypes;
   midw_ext_fi_tcl_e8_DAB_AnnouncementSource AnnoConfigSource;
   midw_ext_fi_tcl_b16_DAB_AnnouncementType AnnoSupportedTypes;
   midw_ext_fi_tcl_b16_DAB_AnnouncementType AnnoActiveTypes;
   midw_ext_fi_tcl_e8_DAB_AnnouncementSource AnnoActiveSource;
   midw_ext_fi_tcl_e8_DAB_AnnouncementStatus AnnoActiveState;
   midw_ext_fi_tcl_e8_DAB_AnnouncementSelectState AnnoSelectState;
   midw_ext_fi_tcl_b16_DAB_AnnouncementType AnnoSelectedTypes;
   midw_ext_fi_tcl_DAB_Label AnnoServiceLabel;
   std::vector<midw_ext_fi_tcl_DAB_AnnoElement, std::allocator<midw_ext_fi_tcl_DAB_AnnoElement> > AnnouncementList;
   virtual ~midw_ext_fi_tcl_DAB_AnnoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_AnnoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ADRMsg : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ADRMsg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ADRMsg& operator=(const midw_ext_fi_tcl_DAB_ADRMsg& coRef);
   midw_ext_fi_tcl_DAB_ADRMsg(const midw_ext_fi_tcl_DAB_ADRMsg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FktID;
   std::vector<tU8, std::allocator<tU8> > MsgData;
   virtual ~midw_ext_fi_tcl_DAB_ADRMsg();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ADRMsg& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_LogoElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_LogoElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_LogoElement& operator=(const midw_ext_fi_tcl_DAB_LogoElement& coRef);
   midw_ext_fi_tcl_DAB_LogoElement(const midw_ext_fi_tcl_DAB_LogoElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ServiceID;
   midw_ext_fi_tclString sLogoLink;
   virtual ~midw_ext_fi_tcl_DAB_LogoElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_LogoElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ContentID : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ContentID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ContentID& operator=(const midw_ext_fi_tcl_DAB_ContentID& coRef);
   midw_ext_fi_tcl_DAB_ContentID(const midw_ext_fi_tcl_DAB_ContentID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ServiceID;
   tU8 u8Scid;
   virtual ~midw_ext_fi_tcl_DAB_ContentID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ContentID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TuneType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TuneType();
   enum tenType {
      FI_EN_DAB_TUNETYPE_OFF = 0UL,
      FI_EN_DAB_TUNETYPE_SELECT_PSID = 1UL,
      FI_EN_DAB_TUNETYPE_SELECT_COMPONENT = 2UL,
      FI_EN_DAB_TUNETYPE_SELECT_FREQ = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TuneType(midw_ext_fi_tcl_e8_DAB_TuneType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TuneType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TuneType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TuneParam : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TuneParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TuneParam& operator=(const midw_ext_fi_tcl_DAB_TuneParam& coRef);
   midw_ext_fi_tcl_DAB_TuneParam(const midw_ext_fi_tcl_DAB_TuneParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TuneType e8TuneType;
   tU32 u32Value;
   virtual ~midw_ext_fi_tcl_DAB_TuneParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TuneParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_LearnType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_LearnType();
   enum tenType {
      FI_EN_DAB_LEARNTYPE_OFF = 0UL,
      FI_EN_DAB_LEARNTYPE_UPDATE = 1UL,
      FI_EN_DAB_LEARNTYPE_VIRGIN = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_LearnType(midw_ext_fi_tcl_e8_DAB_LearnType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_LearnType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_LearnType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_LearnParam : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_LearnParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_LearnParam& operator=(const midw_ext_fi_tcl_DAB_LearnParam& coRef);
   midw_ext_fi_tcl_DAB_LearnParam(const midw_ext_fi_tcl_DAB_LearnParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_LearnType e8LearnType;
   tBool bRollback;
   virtual ~midw_ext_fi_tcl_DAB_LearnParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_LearnParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b32_DAB_SetupMask : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b32_DAB_SetupMask();

   enum {
      FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B0_RESERVED = 0x1UL,
      FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B1_RESERVED = 0x2UL
   };
   tBool bDAB_SETUPOPERATIONMASK_b0_reserved() const {return (u32Value & FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B0_RESERVED) != 0; }
   tVoid vSetDAB_SETUPOPERATIONMASK_b0_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B0_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B0_RESERVED)); }
   tBool bDAB_SETUPOPERATIONMASK_b1_reserved() const {return (u32Value & FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B1_RESERVED) != 0; }
   tVoid vSetDAB_SETUPOPERATIONMASK_b1_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B1_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_DAB_SETUPOPERATIONMASK_B1_RESERVED)); }
   struct rBitValues {
      tBool DAB_SETUPOPERATIONMASK_b0_reserved:1;
      tBool DAB_SETUPOPERATIONMASK_b1_reserved:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b32_DAB_SetupMask();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b32_DAB_SetupMask& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b32_DAB_SetupFlags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b32_DAB_SetupFlags();

   enum {
      FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B0_RESERVED = 0x1UL,
      FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B1_RESERVED = 0x2UL
   };
   tBool bDAB_SETUPOPERATION_SWITCHON_b0_reserved() const {return (u32Value & FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B0_RESERVED) != 0; }
   tVoid vSetDAB_SETUPOPERATION_SWITCHON_b0_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B0_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B0_RESERVED)); }
   tBool bDAB_SETUPOPERATION_SWITCHON_b1_reserved() const {return (u32Value & FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B1_RESERVED) != 0; }
   tVoid vSetDAB_SETUPOPERATION_SWITCHON_b1_reserved(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B1_RESERVED):(u32Value & ~(tU32)FI_C_U32_BIT_DAB_SETUPOPERATION_SWITCHON_B1_RESERVED)); }
   struct rBitValues {
      tBool DAB_SETUPOPERATION_SWITCHON_b0_reserved:1;
      tBool DAB_SETUPOPERATION_SWITCHON_b1_reserved:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b32_DAB_SetupFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b32_DAB_SetupFlags& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_LinkingSetupMask : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_LinkingSetupMask();

   enum {
      FI_C_U8_BIT_DAB_SETUPLINKING_TH_NONE = 0x1UL,
      FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH = 0x2UL,
      FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH = 0x4UL,
      FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME = 0x8UL,
      FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY = 0x10UL
   };
   tBool bDAB_SETUPLINKING_TH_NONE() const {return (u8Value & FI_C_U8_BIT_DAB_SETUPLINKING_TH_NONE) != 0; }
   tVoid vSetDAB_SETUPLINKING_TH_NONE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SETUPLINKING_TH_NONE):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SETUPLINKING_TH_NONE)); }
   tBool bDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH() const {return (u8Value & FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH) != 0; }
   tVoid vSetDAB_SETUPLINKING_TH_DAB_FM_LINKING_TH(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH)); }
   tBool bDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH() const {return (u8Value & FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH) != 0; }
   tVoid vSetDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH)); }
   tBool bDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME() const {return (u8Value & FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME) != 0; }
   tVoid vSetDAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME)); }
   tBool bDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY() const {return (u8Value & FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY) != 0; }
   tVoid vSetDAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY)); }
   struct rBitValues {
      tBool DAB_SETUPLINKING_TH_NONE:1;
      tBool DAB_SETUPLINKING_TH_DAB_FM_LINKING_TH:1;
      tBool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_TH:1;
      tBool DAB_SETUPLINKING_TH_DAB_FM_LINKING_BACK_VALIDATION_TIME:1;
      tBool DAB_SETUPLINKING_TH_DAB_FM_LINK_BACK_DELAY:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_LinkingSetupMask();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_LinkingSetupMask& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_SwitchTuner : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_SwitchTuner();
   enum tenType {
      FI_EN_DAB_SWITCH_TO_DAB = 0UL,
      FI_EN_DAB_SWITCH_TO_FM = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_SwitchTuner(midw_ext_fi_tcl_e8_DAB_SwitchTuner::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_SwitchTuner();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_SwitchTuner& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner();
   enum tenType {
      FI_EN_MAIN_DAB_TUNER = 0UL,
      FI_EN_MAIN_FM_TUNER = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner(midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_MuteStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_MuteStatus();
   enum tenType {
      FI_EN_MUTE = 0UL,
      FI_EN_DEMUTE = 1UL,
      FI_EN_DEMUTE_RUNNING = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_MuteStatus(midw_ext_fi_tcl_e8_DAB_MuteStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_MuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_MuteStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_Source : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_Source();
   enum tenType {
      FI_EN_DAB = 0UL,
      FI_EN_DAB_TA = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_Source(midw_ext_fi_tcl_e8_DAB_Source::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_Source();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_Source& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags();

   enum {
      FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION = 0x1UL,
      FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_DONE = 0x2UL,
      FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_REJECTED = 0x4UL
   };
   tBool bDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION() const {return (u8Value & FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION) != 0; }
   tVoid vSetDAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION)); }
   tBool bDAB_EXTSERVFOLLOWING_SWITCH_DONE() const {return (u8Value & FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_DONE) != 0; }
   tVoid vSetDAB_EXTSERVFOLLOWING_SWITCH_DONE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_DONE):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_DONE)); }
   tBool bDAB_EXTSERVFOLLOWING_SWITCH_REJECTED() const {return (u8Value & FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_REJECTED) != 0; }
   tVoid vSetDAB_EXTSERVFOLLOWING_SWITCH_REJECTED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_REJECTED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_EXTSERVFOLLOWING_SWITCH_REJECTED)); }
   struct rBitValues {
      tBool DAB_EXTSERVFOLLOWING_SWITCH_RECOMMENDATION:1;
      tBool DAB_EXTSERVFOLLOWING_SWITCH_DONE:1;
      tBool DAB_EXTSERVFOLLOWING_SWITCH_REJECTED:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_ExtServFollowingFlags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_DeleteAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_DeleteAction();
   enum tenType {
      FI_EN_PRESETLIST_DELACTION_ONE_ELEMENT = 0UL,
      FI_EN_PRESETLIST_DELACTION_ALL_ELEMENTS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_DeleteAction(midw_ext_fi_tcl_e8_DAB_DeleteAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_DeleteAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_DeleteAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_PresetListElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_PresetListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_PresetListElement& operator=(const midw_ext_fi_tcl_DAB_PresetListElement& coRef);
   midw_ext_fi_tcl_DAB_PresetListElement(const midw_ext_fi_tcl_DAB_PresetListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8PresetElementID;
   tU32 u32ServiceID;
   midw_ext_fi_tcl_DAB_Label ServiceLabel;
   tU32 u32Frequency;
   tU8 u8Scid;
   midw_ext_fi_tcl_DAB_Label ComponentLabel;
   tU32 u32EnsembleId;
   midw_ext_fi_tcl_DAB_Label EnsembleLabel;
   midw_ext_fi_tclString sLogoLink;
   virtual ~midw_ext_fi_tcl_DAB_PresetListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_PresetListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ListOperation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ListOperation();
   enum tenType {
      FI_EN_OPEN = 0UL,
      FI_EN_CLOSE = 1UL,
      FI_EN_GET = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ListOperation(midw_ext_fi_tcl_e8_DAB_ListOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ListOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ListOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ServiceListType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ServiceListType();
   enum tenType {
      FI_EN_GLOBALLIST = 0UL,
      FI_EN_CURRENTENSEMBLELIST = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ServiceListType(midw_ext_fi_tcl_e8_DAB_ServiceListType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ServiceListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ServiceListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ChnListElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ChnListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ChnListElement& operator=(const midw_ext_fi_tcl_DAB_ChnListElement& coRef);
   midw_ext_fi_tcl_DAB_ChnListElement(const midw_ext_fi_tcl_DAB_ChnListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListElementID;
   tU32 u32DABId;
   tU8 u8CompScids;
   midw_ext_fi_tcl_DAB_Label Label;
   midw_ext_fi_tcl_DAB_Label EnsembleLabel;
   midw_ext_fi_tclString sFreqLabel;
   tU8 u8PresetListElemId;
   tU8 u8PTY;
   tU16 u16ASU;
   tBool bReception;
   tU8 u8NumberOfComponents;
   tU8 u8ServiceLinkMode;
   midw_ext_fi_tclString sLogoLink;
   tU8 bEPGSupport;
   virtual ~midw_ext_fi_tcl_DAB_ChnListElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ChnListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_ListElementAvailInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_ListElementAvailInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_ListElementAvailInfo& operator=(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& coRef);
   midw_ext_fi_tcl_DAB_ListElementAvailInfo(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListElementID;
   tBool bAvailable;
   virtual ~midw_ext_fi_tcl_DAB_ListElementAvailInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_ListElementAvailInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TIIListElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TIIListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TIIListElement& operator=(const midw_ext_fi_tcl_DAB_TIIListElement& coRef);
   midw_ext_fi_tcl_DAB_TIIListElement(const midw_ext_fi_tcl_DAB_TIIListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8MainId;
   tU8 u8SubId;
   tU32 u32Latitude;
   tU32 u32Longitude;
   virtual ~midw_ext_fi_tcl_DAB_TIIListElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TIIListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_BankList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_BankList();
   enum tenType {
      FI_EN_BANK_DAB1 = 13UL,
      FI_EN_BANK_DAB2 = 14UL,
      FI_EN_BANK_DAB3 = 15UL,
      FI_EN_BANK_DABAST = 16UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_BankList(midw_ext_fi_tcl_e8_DAB_BankList::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_BankList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_BankList& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TestOperation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TestOperation();
   enum tenType {
      FI_EN_TUNE_ENSEMBLE = 1UL,
      FI_EN_TUNE_SERVICE = 2UL,
      FI_EN_TUNE_FREQUENCY = 3UL,
      FI_EN_PLAY_ASID = 4UL,
      FI_EN_VERIFY_FREQ_ASID_AUDIO = 5UL,
      FI_EN_REMOTE_CTRL_ENTER = 6UL,
      FI_EN_REMOTE_CTRL_LEAVE = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TestOperation(midw_ext_fi_tcl_e8_DAB_TestOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TestOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TestOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation();
   enum tenType {
      FI_EN_TUNE_ENSEMBLE = 1UL,
      FI_EN_TUNE_SERVICE = 2UL,
      FI_EN_TUNE_FREQUENCY = 3UL,
      FI_EN_PLAY_ASID = 4UL,
      FI_EN_VERIFY_FREQ_ASID_AUDIO = 5UL,
      FI_EN_REMOTE_CTRL_ENTER = 6UL,
      FI_EN_REMOTE_CTRL_LEAVE = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation(midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_ManualMode_TuneOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_TestMode_Flags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_TestMode_Flags();

   enum {
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_AUDIOSOURCE = 0x1UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_SFINT = 0x2UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B2_RESERVED = 0x4UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED = 0x8UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED = 0x10UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED = 0x20UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED = 0x40UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED = 0x80UL
   };
   tBool bDAB_TESTMODE_FLAGS_AUDIOSOURCE() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_AUDIOSOURCE) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_AUDIOSOURCE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_AUDIOSOURCE):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_AUDIOSOURCE)); }
   tBool bDAB_TESTMODE_FLAGS_SFINT() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_SFINT) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_SFINT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_SFINT):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_SFINT)); }
   tBool bDAB_TESTMODE_FLAGS_b2_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B2_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b2_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B2_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B2_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b3_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b3_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b4_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b4_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b5_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b5_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b6_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b6_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b7_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b7_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED)); }
   struct rBitValues {
      tBool DAB_TESTMODE_FLAGS_AUDIOSOURCE:1;
      tBool DAB_TESTMODE_FLAGS_SFINT:1;
      tBool DAB_TESTMODE_FLAGS_b2_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b3_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b4_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b5_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b6_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b7_reserved:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_TestMode_Flags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_TestMode_Flags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags();

   enum {
      FI_C_U8_BIT_DAB_FM_ALT_FM_PI_VALID_FLAG = 0x1UL,
      FI_C_U8_BIT_DAB_FM_ALT_FM_FREQ_VALID_FLAG = 0x2UL,
      FI_C_U8_BIT_DAB_FM_ALT_FM_QUALITY_VALID_FLAG = 0x4UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED = 0x8UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED = 0x10UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED = 0x20UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED = 0x40UL,
      FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED = 0x80UL
   };
   tBool bDAB_FM_ALT_FM_PI_VALID_FLAG() const {return (u8Value & FI_C_U8_BIT_DAB_FM_ALT_FM_PI_VALID_FLAG) != 0; }
   tVoid vSetDAB_FM_ALT_FM_PI_VALID_FLAG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_FM_ALT_FM_PI_VALID_FLAG):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_FM_ALT_FM_PI_VALID_FLAG)); }
   tBool bDAB_FM_ALT_FM_FREQ_VALID_FLAG() const {return (u8Value & FI_C_U8_BIT_DAB_FM_ALT_FM_FREQ_VALID_FLAG) != 0; }
   tVoid vSetDAB_FM_ALT_FM_FREQ_VALID_FLAG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_FM_ALT_FM_FREQ_VALID_FLAG):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_FM_ALT_FM_FREQ_VALID_FLAG)); }
   tBool bDAB_FM_ALT_FM_QUALITY_VALID_FLAG() const {return (u8Value & FI_C_U8_BIT_DAB_FM_ALT_FM_QUALITY_VALID_FLAG) != 0; }
   tVoid vSetDAB_FM_ALT_FM_QUALITY_VALID_FLAG(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_FM_ALT_FM_QUALITY_VALID_FLAG):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_FM_ALT_FM_QUALITY_VALID_FLAG)); }
   tBool bDAB_TESTMODE_FLAGS_b3_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b3_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B3_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b4_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b4_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B4_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b5_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b5_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B5_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b6_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b6_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B6_RESERVED)); }
   tBool bDAB_TESTMODE_FLAGS_b7_reserved() const {return (u8Value & FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED) != 0; }
   tVoid vSetDAB_TESTMODE_FLAGS_b7_reserved(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED):(u8Value & ~(tU8)FI_C_U8_BIT_DAB_TESTMODE_FLAGS_B7_RESERVED)); }
   struct rBitValues {
      tBool DAB_FM_ALT_FM_PI_VALID_FLAG:1;
      tBool DAB_FM_ALT_FM_FREQ_VALID_FLAG:1;
      tBool DAB_FM_ALT_FM_QUALITY_VALID_FLAG:1;
      tBool DAB_TESTMODE_FLAGS_b3_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b4_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b5_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b6_reserved:1;
      tBool DAB_TESTMODE_FLAGS_b7_reserved:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_LinkType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_LinkType();
   enum tenType {
      FI_EN_LINKTYPE_DAB_HARDLINK = 0UL,
      FI_EN_LINKTYPE_DAB_SOFTLINK = 1UL,
      FI_EN_LINKTYPE_DAB_NOLINK = 2UL,
      FI_EN_LINKTYPE_FM_HARDLINK = 3UL,
      FI_EN_LINKTYPE_FM_SOFTLINK = 4UL,
      FI_EN_LINKTYPE_FM_NOLINK = 5UL,
      FI_EN_LINKTYPE_DAB_DBLINK = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_LinkType(midw_ext_fi_tcl_e8_DAB_LinkType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_LinkType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_LinkType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_BG_TestModeData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_BG_TestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_BG_TestModeData& operator=(const midw_ext_fi_tcl_DAB_BG_TestModeData& coRef);
   midw_ext_fi_tcl_DAB_BG_TestModeData(const midw_ext_fi_tcl_DAB_BG_TestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32BgFrequency;
   tU32 u32BgCurrentEnsID;
   tU32 u32BgFICBER;
   midw_ext_fi_tcl_b16_DAB_TunerStatusFlags b16BgFlags;
   midw_ext_fi_tclString sBgDabMode;
   virtual ~midw_ext_fi_tcl_DAB_BG_TestModeData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_BG_TestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_Time : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_Time();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_Time& operator=(const midw_ext_fi_tcl_DAB_Time& coRef);
   midw_ext_fi_tcl_DAB_Time(const midw_ext_fi_tcl_DAB_Time& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DabSec;
   tU32 u32DabMin;
   tU32 u32DabHour;
   tU32 u32DabMday;
   tU32 u32DabMon;
   tU32 u32DabYear;
   tU32 u32DabWday;
   tU32 u32DabYday;
   tU32 u32DabUtcOff;
   virtual ~midw_ext_fi_tcl_DAB_Time();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_Time& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& operator=(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& coRef);
   midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumTmcServices;
   tU32 u32NumTpegServices;
   tU32 u32RcvTmcMsgs;
   tU32 u32RcvTpegMsgs;
   midw_ext_fi_tcl_DAB_Time DabTime;
   virtual ~midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_LinkListElem : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_LinkListElem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_LinkListElem& operator=(const midw_ext_fi_tcl_DAB_LinkListElem& coRef);
   midw_ext_fi_tcl_DAB_LinkListElem(const midw_ext_fi_tcl_DAB_LinkListElem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_LinkType e8LinkType;
   midw_ext_fi_tclString sFreqLabel;
   tU32 u32ID;
   tU32 u32EnsembleId;
   tU8 u8Quality;
   virtual ~midw_ext_fi_tcl_DAB_LinkListElem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_LinkListElem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_AltFreqInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_AltFreqInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_AltFreqInfo& operator=(const midw_ext_fi_tcl_DAB_AltFreqInfo& coRef);
   midw_ext_fi_tcl_DAB_AltFreqInfo(const midw_ext_fi_tcl_DAB_AltFreqInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   tS8 s8FieldStrength;
   tU8 u8Quality;
   virtual ~midw_ext_fi_tcl_DAB_AltFreqInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_AltFreqInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TestModeData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TestModeData& operator=(const midw_ext_fi_tcl_DAB_TestModeData& coRef);
   midw_ext_fi_tcl_DAB_TestModeData(const midw_ext_fi_tcl_DAB_TestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32CurrentServID;
   tU32 u32MSCBER;
   tU32 u32FICBER;
   tU32 u32NETBER;
   tU8 u8RSFEC;
   tU8 u8DABMode;
   tU8 u8ProtectionLevel;
   tU8 u8ConcealmentLevel;
   midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode;
   midw_ext_fi_tcl_b8_DAB_ALT_FM_Valid_Flags b8ValidFMValues;
   tU16 u16AltFMPI;
   tU32 u32AltFMFrequency;
   tU8 u8AltFMQuality;
   midw_ext_fi_tcl_b8_DAB_TestMode_Flags b8Flags;
   tS8 s8FieldStrength;
   tU16 u16TotalNumberLinks;
   tU8 u8ECC;
   tU16 u16CountryLabel;
   tU16 u16ActivatedLink;
   std::vector<midw_ext_fi_tcl_DAB_LinkListElem, std::allocator<midw_ext_fi_tcl_DAB_LinkListElem> > LinkList;
   std::vector<midw_ext_fi_tcl_DAB_AltFreqInfo, std::allocator<midw_ext_fi_tcl_DAB_AltFreqInfo> > DAB_DMB_AltFreqInfo;
   tBool bSync;
   virtual ~midw_ext_fi_tcl_DAB_TestModeData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_RdbId : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_RdbId();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_RdbId& operator=(const midw_ext_fi_tcl_DAB_RdbId& coRef);
   midw_ext_fi_tcl_DAB_RdbId(const midw_ext_fi_tcl_DAB_RdbId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Cc;
   tU8 u8Ltn;
   tU8 u8Bsa;
   tU16 u16Bsa;
   tU8 u8Sid;
   tBool bEncrypted;
   virtual ~midw_ext_fi_tcl_DAB_RdbId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_RdbId& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TmcData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TmcData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TmcData& operator=(const midw_ext_fi_tcl_DAB_TmcData& coRef);
   midw_ext_fi_tcl_DAB_TmcData(const midw_ext_fi_tcl_DAB_TmcData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8TmcData1;
   tU8 u8TmcData2;
   tU8 u8TmcData3;
   tU8 u8TmcData4;
   tU8 u8TmcData5;
   virtual ~midw_ext_fi_tcl_DAB_TmcData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TmcData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_Encryption : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_Encryption();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_Encryption& operator=(const midw_ext_fi_tcl_DAB_Encryption& coRef);
   midw_ext_fi_tcl_DAB_Encryption(const midw_ext_fi_tcl_DAB_Encryption& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEncrypted;
   tU8 u8EncId;
   tU8 u8TestBits;
   virtual ~midw_ext_fi_tcl_DAB_Encryption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_Encryption& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TmcMediumType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TmcMediumType();
   enum tenType {
      FI_EN_DAB_MEDIUMTYPE_RESERVED = 0UL,
      FI_EN_DAB_MEDIUMTYPE_FM = 1UL,
      FI_EN_DAB_MEDIUMTYPE_DAB = 2UL,
      FI_EN_DAB_MEDIUMTYPE_SAT = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TmcMediumType(midw_ext_fi_tcl_e8_DAB_TmcMediumType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TmcMediumType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TmcMediumType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DAB_TuneCmd : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DAB_TuneCmd();
   enum tenType {
      FI_EN_DAB_TUNE_NEXT = 0UL,
      FI_EN_DAB_TUNE_PREV = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DAB_TuneCmd(midw_ext_fi_tcl_e8_DAB_TuneCmd::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DAB_TuneCmd();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DAB_TuneCmd& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_MsgSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_MsgSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_MsgSource& operator=(const midw_ext_fi_tcl_DAB_MsgSource& coRef);
   midw_ext_fi_tcl_DAB_MsgSource(const midw_ext_fi_tcl_DAB_MsgSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TmcMediumType DabMediumTypeId;
   tU8 u8Number;
   virtual ~midw_ext_fi_tcl_DAB_MsgSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_MsgSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TmcInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TmcInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TmcInfo& operator=(const midw_ext_fi_tcl_DAB_TmcInfo& coRef);
   midw_ext_fi_tcl_DAB_TmcInfo(const midw_ext_fi_tcl_DAB_TmcInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_RdbId RdbId;
   tS16 s16Ecc;
   tU16 u16Aid;
   std::vector<tU8, std::allocator<tU8> > TmcData;
   tU16 u16ProgramId;
   midw_ext_fi_tcl_DAB_Encryption DabEncryption;
   midw_ext_fi_tcl_DAB_MsgSource DabMsgSource;
   midw_ext_fi_tclString sProgramServiceName;
   midw_ext_fi_tclString sServiceProviderName;
   virtual ~midw_ext_fi_tcl_DAB_TmcInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TmcInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_EnsembleTmcInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_EnsembleTmcInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_EnsembleTmcInfo& operator=(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& coRef);
   midw_ext_fi_tcl_DAB_EnsembleTmcInfo(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32EnsembleId;
   tU8 u8Quality;
   tU8 u8NumberOfRdbIds;
   std::vector<midw_ext_fi_tcl_DAB_RdbId, std::allocator<midw_ext_fi_tcl_DAB_RdbId> > RdbIdList;
   virtual ~midw_ext_fi_tcl_DAB_EnsembleTmcInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_EnsembleTmcInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TpegInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TpegInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TpegInfo& operator=(const midw_ext_fi_tcl_DAB_TpegInfo& coRef);
   midw_ext_fi_tcl_DAB_TpegInfo(const midw_ext_fi_tcl_DAB_TpegInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > TpegData;
   virtual ~midw_ext_fi_tcl_DAB_TpegInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TpegInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_DAB_TpegUriChannel : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_DAB_TpegUriChannel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_DAB_TpegUriChannel& operator=(const midw_ext_fi_tcl_DAB_TpegUriChannel& coRef);
   midw_ext_fi_tcl_DAB_TpegUriChannel(const midw_ext_fi_tcl_DAB_TpegUriChannel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sTpegUriChn;
   midw_ext_fi_tcl_e8_DAB_UriSelectState DabUriSelectState;
   tBool bActive;
   virtual ~midw_ext_fi_tcl_DAB_TpegUriChannel();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_DAB_TpegUriChannel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DefSetMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DefSetMode();
   enum tenType {
      FI_EN_DEFSET_SRC_NOT_DEF = 255UL,
      FI_EN_DEFSET_SRC_SET_USER = 0UL,
      FI_EN_DEFSET_SRC_SET_TEF = 1UL,
      FI_EN_DEFSET_SRC_UPREG = 2UL,
      FI_EN_DEFSET_SRC_RELUPREG = 3UL,
      FI_EN_DEFSET_SRC_GET = 4UL,
      FI_EN_DEFSET_SRC_CODING = 5UL,
      FI_EN_DEFSET_SRC_CALIBRATION = 6UL,
      FI_EN_DEFSET_START = 7UL,
      FI_EN_DEFSET_COMPLETE = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DefSetMode(midw_ext_fi_tcl_e8_DefSetMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DefSetMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DefSetMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DefSetServiceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DefSetServiceStatus();
   enum tenType {
      FI_EN_DEFSET_STATE_UNDEFINED = 255UL,
      FI_EN_DEFSET_STATE_CONFIRMED = 0UL,
      FI_EN_DEFSET_STATE_FAILED = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DefSetServiceStatus(midw_ext_fi_tcl_e8_DefSetServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DefSetServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DefSetServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DefSetGroups : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DefSetGroups();
   enum tenType {
      FI_EN_DEFSET_GROUP_UNDEFIEND = 255UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__DESTINATION_MEMORY = 0UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALCULATION = 1UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_AND_TRAFFIC_MESSAGE_INFORMATION = 2UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_GUIDANCE = 3UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY = 4UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__PRESENTATION_FUNCTION = 5UL,
      FI_EN_DEFSET_GROUP__RADIO = 6UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__LAST_SOURCE = 7UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__SOURCE_HANDLING__AUX = 8UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO = 9UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__AUDIO_CD = 10UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__MP3 = 11UL,
      FI_EN_DEFSET_GROUP__INFOTAINMENT__CDC = 12UL,
      FI_EN_DEFSET_GROUP__MAINTENANCE = 13UL,
      FI_EN_DEFSET_GROUP__OFFICE__CLOCK = 14UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__USER_OPERATION_SERVICE = 15UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__LANGUAGE = 16UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__TTS = 17UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__VOICE_RECOGNITION = 18UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DISPLAY_ADJUSTMENT = 19UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__DIMMING = 20UL,
      FI_EN_DEFSET_GROUP__SYSTEM_AND_POWER_MANAGEMENT = 21UL,
      FI_EN_DEFSET_GROUP__DEVELOPMENT_AND_TEST_MODE__MAUS = 22UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_CRITRERIA = 23UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__ROUTE_CALUCULATION__ROUTE_OPTIONS = 24UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE = 25UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__TURN_BY_TURN_GUIDANCE__GRAPHIC_DRIVING_REC = 26UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__ORIENTATION_AND_CLIPPING = 27UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_DISPLAY_MANIPULATION = 28UL,
      FI_EN_DEFSET_GROUP__NAVIGATION__MAP_DISPLAY__MAP_INFORMATION = 29UL,
      FI_EN_DEFSET_GROUP__HMI_OUTLINE__COLOR = 30UL,
      FI_EN_DEFSET_GROUP_ALL = 31UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DefSetGroups(midw_ext_fi_tcl_e8_DefSetGroups::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DefSetGroups();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DefSetGroups& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_RCtrlSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_RCtrlSource();
   enum tenType {
      FI_EN_RCTRL_SRC_UNKNOWN = 255UL,
      FI_EN_RCTRL_SRC_HMI = 0UL,
      FI_EN_RCTRL_SRC_TEF = 1UL,
      FI_EN_RCTRL_SRC_CUSTOMER = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_RCtrlSource(midw_ext_fi_tcl_e8_RCtrlSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_RCtrlSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_RCtrlSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_RCtrlCommand : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_RCtrlCommand();
   enum tenType {
      FI_EN_RCTRL_CMD_DEACTIVATE = 0UL,
      FI_EN_RCTRL_CMD_ACTIVATE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_RCtrlCommand(midw_ext_fi_tcl_e8_RCtrlCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_RCtrlCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_RCtrlCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_RCtrlSignal : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_RCtrlSignal();
   enum tenType {
      FI_EN_RCTRL_SIG_ALL = 255UL,
      FI_EN_RCTRL_SIG_FM_FREQUENCY = 0UL,
      FI_EN_RCTRL_SIG_AM_FREQUENCY = 1UL,
      FI_EN_RCTRL_SIG_AUDIO_SOURCE = 2UL,
      FI_EN_RCTRL_SIG_AUDIO_VOLUME = 3UL,
      FI_EN_RCTRL_SIG_AUDIO_FADER_AND_BALANCE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_RCtrlSignal(midw_ext_fi_tcl_e8_RCtrlSignal::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_RCtrlSignal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_RCtrlSignal& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_CCAError : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_CCAError();
   enum tenType {
      FI_EN_PHN_VAG_CCA_UNSPECIFIED = 0UL,
      FI_EN_PHN_VAG_CCA_UNKNWON_SVC_ID = 1UL,
      FI_EN_PHN_VAG_CCA_UNKNOWN_FCT_ID = 2UL,
      FI_EN_PHN_VAG_CCA_INVALID_OPCODE = 3UL,
      FI_EN_PHN_VAG_CCA_INVALID_CCA_TYPE = 4UL,
      FI_EN_PHN_VAG_CCA_PARAMETER_OUT_OF_RANGE = 5UL,
      FI_EN_PHN_VAG_CCA_UNKNOWN_REG_ID = 6UL,
      FI_EN_PHN_VAG_CCA_VERSION_NOT_SUPPORTED = 7UL,
      FI_EN_PHN_VAG_CCA_PARAMETER_MISSING = 8UL,
      FI_EN_PHN_VAG_CCA_PARAMETER_TOO_MANY = 9UL,
      FI_EN_PHN_VAG_CCA_BUSY = 10UL,
      FI_EN_PHN_VAG_CCA_TEMPORARILY_NOT_AVAILABLE = 11UL,
      FI_EN_PHN_VAG_CCA_OP_CODE_NOT_SUPPORTED = 12UL,
      FI_EN_PHN_VAG_CCA_INTERNAL_FAILURE = 13UL,
      FI_EN_PHN_VAG_CCA_UPREG_FAILURE = 14UL,
      FI_EN_PHN_VAG_CCA_REL_UPREG_FAILURE = 15UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_CCAError(midw_ext_fi_tcl_e8_PHN_VAG_CCAError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_CCAError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_CCAError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_PhoneError : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_PhoneError();
   enum tenType {
      FI_EN_PHN_VAG_NO_ERROR = 0UL,
      FI_EN_PHN_VAG_METHOD_REJECT_QUEUE_FULL = 1UL,
      FI_EN_PHN_VAG_METHOD_REJECT_FUNCTION_NOT_SUPPORTED = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_PhoneError(midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_PhoneError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_PhoneError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus();
   enum tenType {
      FI_EN_PHN_VAG_AUDIO_MUTE_ACK_NOK = 0UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_ACK_OK = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus(midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_AudioMuteRequestAckStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState();
   enum tenType {
      FI_EN_PHN_VAG_BT_INVISIBLE = 0UL,
      FI_EN_PHN_VAG_BT_VISIBLE_PHN = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState(midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BTVisibleState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BTDeviceName : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BTDeviceName();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BTDeviceName& operator=(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& coRef);
   midw_ext_fi_tcl_PHN_VAG_BTDeviceName(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sBTDeviceName;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BTDeviceName();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BTDeviceName& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& operator=(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& coRef);
   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sBTDeviceAddress;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_PairedBTDevice : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_PairedBTDevice();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& operator=(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& coRef);
   midw_ext_fi_tcl_PHN_VAG_PairedBTDevice(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bHfpSupported;
   tBool bAvpSupported;
   tBool bSmsSupported;
   tBool bPimSupported;
   tBool bDunSupported;
   tBool bPanSupported;
   tBool bSppSupported;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceName BTDeviceName;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddess;
   tU8 u8DeviceId;
   virtual ~midw_ext_fi_tcl_PHN_VAG_PairedBTDevice();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_PairedBTDevice& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_U8_Handle : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_U8_Handle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_U8_Handle& operator=(const midw_ext_fi_tcl_PHN_U8_Handle& coRef);
   midw_ext_fi_tcl_PHN_U8_Handle(const midw_ext_fi_tcl_PHN_U8_Handle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > handle;
   virtual ~midw_ext_fi_tcl_PHN_U8_Handle();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_U8_Handle& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService();
   enum tenType {
      FI_EN_PHN_BT_DEV_SERVICE_DUN = 0UL,
      FI_EN_PHN_BT_DEV_SERVICE_PAN = 1UL,
      FI_EN_PHN_BT_DEV_SERVICE_SPP = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService(midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& operator=(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& coRef);
   midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ServiceHandle;
   midw_ext_fi_tclString sServiceName;
   std::vector<midw_ext_fi_tcl_PHN_U8_Handle, std::allocator<midw_ext_fi_tcl_PHN_U8_Handle> > oUuidList;
   virtual ~midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_BTVirtualDeviceData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_BTVirtualDeviceData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_BTVirtualDeviceData& operator=(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& coRef);
   midw_ext_fi_tcl_PHN_BTVirtualDeviceData(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_BTVirtualDeviceService e8VirtualDeviceService;
   midw_ext_fi_tclString sDeviceName;
   midw_ext_fi_tcl_PHN_BT_SPP_ServiceInformation oServiceInfo;
   virtual ~midw_ext_fi_tcl_PHN_BTVirtualDeviceData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_BTVirtualDeviceData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BTDevice : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BTDevice();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BTDevice& operator=(const midw_ext_fi_tcl_PHN_VAG_BTDevice& coRef);
   midw_ext_fi_tcl_PHN_VAG_BTDevice(const midw_ext_fi_tcl_PHN_VAG_BTDevice& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bHfpFeatureEnabled;
   tBool bHfpConnectionEstablished;
   tBool bAvpFeatureEnabled;
   tBool bAvpConnectionEstablished;
   tBool bSmsFeatureEnabled;
   tBool bSmsConnectionEstablished;
   tBool bPimFeatureEnabled;
   tBool bPimConnectionEstablished;
   tBool bDunFeatureEnabled;
   tBool bDunConnectionEstablished;
   tBool bPanFeatureEnabled;
   tBool bPanConnectionEstablished;
   tBool bSppFeatureEnabled;
   tBool bSppConnectionEstablished;
   std::vector<midw_ext_fi_tcl_PHN_BTVirtualDeviceData, std::allocator<midw_ext_fi_tcl_PHN_BTVirtualDeviceData> > oVirtualDevices;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceName BTDeviceName;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddess;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BTDevice();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BTDevice& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_PINString : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_PINString();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_PINString& operator=(const midw_ext_fi_tcl_PHN_VAG_PINString& coRef);
   midw_ext_fi_tcl_PHN_VAG_PINString(const midw_ext_fi_tcl_PHN_VAG_PINString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sPINString;
   virtual ~midw_ext_fi_tcl_PHN_VAG_PINString();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_PINString& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability();
   enum tenType {
      FI_EN_PHN_VAG_NW_PROVIDER_NAME_NO_PRESENTATION = 0UL,
      FI_EN_PHN_VAG_NW_PROVIDER_NAME_AVAILABLE = 1UL,
      FI_EN_PHN_VAG_NW_PROVIDER_NAME_NO_NETWORK = 2UL,
      FI_EN_PHN_VAG_NW_PROVIDER_NAME_DENIED = 3UL,
      FI_EN_PHN_VAG_NW_PROVIDER_NAME_PROVIDER_ROAMING = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability(midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_ProviderInfoAvailability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_ProviderName : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_ProviderName();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_ProviderName& operator=(const midw_ext_fi_tcl_PHN_VAG_ProviderName& coRef);
   midw_ext_fi_tcl_PHN_VAG_ProviderName(const midw_ext_fi_tcl_PHN_VAG_ProviderName& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sProviderName;
   virtual ~midw_ext_fi_tcl_PHN_VAG_ProviderName();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_ProviderName& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off();
   enum tenType {
      FI_EN_PHN_VAG_BTM_STATUS_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_BTM_STATUS_ON = 1UL,
      FI_EN_PHN_VAG_BTM_STATUS_OFF = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off(midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BTM_On_Off& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_DeviceType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_DeviceType();
   enum tenType {
      FI_EN_PHN_VAG_UHV_NOT_AVAILABLE = 0UL,
      FI_EN_PHN_VAG_UHV_LOW_NO_BAP = 1UL,
      FI_EN_PHN_VAG_UHV_WITH_BAP_FOUND = 2UL,
      FI_EN_PHN_VAG_INTERNAL_BT_MODULE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_DeviceType(midw_ext_fi_tcl_e8_PHN_VAG_DeviceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_DeviceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_DeviceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bFunctionList;
   tBool bFSGSetup;
   tBool bFSGOperationState;
   tBool bMobileServiceSupport;
   tBool bUserList;
   tBool bActiveUser;
   tBool bRegisterState;
   tBool bLockState;
   tBool bPhoneEnable;
   tBool bNetworkProvider;
   tBool bSignalQuality;
   tBool bNetInfo;
   tBool bCallLineInfo;
   tBool bDialNumber;
   tBool bHangupCall;
   tBool bAcceptCall;
   tBool bCallHold;
   tBool bResumeCall;
   tBool bHandsFreeOnOff;
   tBool bMicroMuteOnOff;
   tBool bRingToneMuteOnOff;
   tBool bSendDTMF;
   tBool bMPReleaseActiveCallAcceptHeldCall;
   tBool bMPReleaseActiveCallAcceptWaitingCall;
   tBool bMPSwap;
   tBool bMPCallHoldAcceptWaitingCall;
   tBool bMPReleaseAllCallsAcceptWaitingCall;
   tBool bMPExplicitCallTransfer;
   tBool bCCJoin;
   tBool bCCSplit;
   tBool bKeypad;
   tBool bPhoneOnOff;
   tBool bSupplementaryServices;
   tBool bRestoreFactorySettings;
   tBool bSetCurrentProfileName;
   tBool bSetBTTestMode;
   tBool bExStartConnection;
   tBool bExBTMTestAction;
   tBool bVoicerecognition;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFctList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics();

   enum {
      FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_INTERNALSIMCARDREADER = 0x1UL,
      FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_CABLECONNECTIONTOMOBILEPOSSIBLE = 0x2UL,
      FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_HFPCONNECTIONTOMOBILEPOSSIBLE = 0x4UL,
      FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_RSAPCONNECTIONTOMOBILEPOSSIBLE = 0x8UL
   };
   tBool bPHN_VAG_PhoneCharacteristics_InternalSIMCardReader() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_INTERNALSIMCARDREADER) != 0; }
   tVoid vSetPHN_VAG_PhoneCharacteristics_InternalSIMCardReader(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_INTERNALSIMCARDREADER):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_INTERNALSIMCARDREADER)); }
   tBool bPHN_VAG_PhoneCharacteristics_CableConnectionToMobilePossible() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_CABLECONNECTIONTOMOBILEPOSSIBLE) != 0; }
   tVoid vSetPHN_VAG_PhoneCharacteristics_CableConnectionToMobilePossible(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_CABLECONNECTIONTOMOBILEPOSSIBLE):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_CABLECONNECTIONTOMOBILEPOSSIBLE)); }
   tBool bPHN_VAG_PhoneCharacteristics_HFPConnectionToMobilePossible() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_HFPCONNECTIONTOMOBILEPOSSIBLE) != 0; }
   tVoid vSetPHN_VAG_PhoneCharacteristics_HFPConnectionToMobilePossible(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_HFPCONNECTIONTOMOBILEPOSSIBLE):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_HFPCONNECTIONTOMOBILEPOSSIBLE)); }
   tBool bPHN_VAG_PhoneCharacteristics_RSAPConnectionToMobilePossible() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_RSAPCONNECTIONTOMOBILEPOSSIBLE) != 0; }
   tVoid vSetPHN_VAG_PhoneCharacteristics_RSAPConnectionToMobilePossible(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_RSAPCONNECTIONTOMOBILEPOSSIBLE):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PHONECHARACTERISTICS_RSAPCONNECTIONTOMOBILEPOSSIBLE)); }
   struct rBitValues {
      tBool PHN_VAG_PhoneCharacteristics_InternalSIMCardReader:1;
      tBool PHN_VAG_PhoneCharacteristics_CableConnectionToMobilePossible:1;
      tBool PHN_VAG_PhoneCharacteristics_HFPConnectionToMobilePossible:1;
      tBool PHN_VAG_PhoneCharacteristics_RSAPConnectionToMobilePossible:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType();
   enum tenType {
      FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_NOCONNECTION = 0UL,
      FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_INTERNALSIMCARDREADER = 1UL,
      FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_CABLECONNECTION = 2UL,
      FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_HANDSFREEPROFILE = 3UL,
      FI_EN_PHN_VAG_MOBILECONNECTIONTYPE_REMOTESIMACCESSPROFILE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType();
   enum tenType {
      FI_EN_PHN_VAG_PHONETYPE_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_PHONETYPE_UHV_PREMIUM = 1UL,
      FI_EN_PHN_VAG_PHONETYPE_UHV_HIGH = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b8_PHN_VAG_BAP_TelFsgSetup_PhoneCharacteristics oPhoneCharacteristics;
   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_MobileConnectionType eMobileConnectionType;
   tU8 u8NumberOfProfiles;
   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgSetup_PhoneType ePhoneType;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgSetup& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus();
   enum tenType {
      FI_EN_PHN_VAG_OPSTATUS_PHONEINITILISATION = 0UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEDEFECT = 1UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEMODULEOFF = 2UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEMODULESWITCHINGON = 3UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEMODULEON = 4UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEMODULESWITCHINGOFF = 5UL,
      FI_EN_PHN_VAG_OPSTATUS_PHONEMODULEOFFHIGHTEMP = 6UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILEOFF = 7UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILESWITCHINGON = 8UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILEON = 9UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILESWITCHINGOFF = 10UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILEOFFNOSWITCHON = 11UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILENOTATTACHED = 12UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILEATTACHEDNOTREADY = 13UL,
      FI_EN_PHN_VAG_OPSTATUS_MOBILEATTACHEDNOTFUNCTIONAL = 14UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelFsgOperationState_OPStatus eOPStatus;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelFsgOperationState& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sSIMSerial;
   midw_ext_fi_tclString sSerialNumber;
   midw_ext_fi_tclString sUserName;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isListValid;
   tU8 u8NbrOfItems;
   std::vector<midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item, std::allocator<midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList_Item> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelUserList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sSIMSerial;
   midw_ext_fi_tclString sSerialNumber;
   midw_ext_fi_tclString sUserName;
   tU8 u8ProfileHandle;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddress;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelActiveUser& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState();
   enum tenType {
      FI_EN_PHN_VAG_BAP_REG_STATE_NOT_REGISTERED_AND_NOT_SEARCHING = 0UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_REGISTERED = 1UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_NOT_REGISTERED_AND_SEARCHING = 2UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_REGISTRATION_DENIED = 3UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_REGISTERED_AND_ROAMING = 4UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_REGISTERED_AND_ROAMING_ALTERNATIVE = 5UL,
      FI_EN_PHN_VAG_BAP_REG_STATE_FUNCTION_NOT_SUPPORTED_BY_ME = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState(midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelRegisterState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState();
   enum tenType {
      FI_EN_PHN_VAG_BAP_LOCK_STATE_NO_LOCK = 0UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_REQUIRE_PIN = 1UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_REQUIRE_PIN2 = 2UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PIN_BLOCKED_REQUIRE_PUK = 3UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PIN2_BLOCKED_REQUIRE_PUK2 = 4UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PUK_BLOCKED = 5UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PUK2_BLOCKED = 6UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_KEYPAD_BLOCKED = 7UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_SIM_NOT_AVAILABLE = 8UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PIN_INVALID = 9UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_PIN2_INVALUD = 10UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_SIM_NOT_FUNCTIONAL = 11UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_SIM_NOT_READY = 12UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_REQUIRE_LOCK_CODE = 13UL,
      FI_EN_PHN_VAG_BAP_LOCK_STATE_UNKNOWN = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState(midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelLockState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bFunctionList;
   tBool bFSGSetup;
   tBool bFSGOperationState;
   tBool bMobileServiceSupport;
   tBool bMissedCallIndication;
   tBool bMissedCalls;
   tBool bReceivedCalls;
   tBool bDialedNumbers;
   tBool bCallStackDeleteAll;
   tBool bPbState;
   tBool bPhonebook;
   tBool bPbSpeller;
   tBool bVoiceMailboxNumber;
   tBool bPbStartDownload;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFctList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure();
   enum tenType {
      FI_EN_PHN_VAG_PHONEBOOKSTRUCTURE_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_PHONEBOOKSTRUCTURE_ONE_NUMBER = 1UL,
      FI_EN_PHN_VAG_PHONEBOOKSTRUCTURE_UP_TO_5_NUMBERS = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgSetup_PhoneBookStructure ePhoneBookStructure;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgSetup& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus();
   enum tenType {
      FI_EN_PHN_VAG_OPSTATUS_PB_NORMALOPERATION = 0UL,
      FI_EN_PHN_VAG_OPSTATUS_PB_TEMPNOTAVAILABLE = 5UL,
      FI_EN_PHN_VAG_OPSTATUS_PB_DEFECT = 15UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBFsgOperationState_OPStatus eOPStatus;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBFsgOperationState& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16MissedCalls;
   tU16 u16MissedNumbers;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBMissedCallIndication& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType();
   enum tenType {
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_GENERAL = 1UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_MOBILE = 2UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_OFFICE = 3UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_HOME = 4UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_FAX = 5UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_PAGER = 6UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_CAR = 7UL,
      FI_EN_PHN_VAG_PBCALLLIST_NUMBERTYPE_SIM = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sPbName;
   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBCallList_Item_NumberType eNumberType;
   midw_ext_fi_tclString sTelNumber;
   tU8 u8Day;
   tU8 u8Month;
   tU8 u8Year;
   tU16 u16Year;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isListValid;
   tU16 u16NbrOfItems;
   std::vector<midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item, std::allocator<midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList_Item> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState();
   enum tenType {
      FI_EN_PHN_VAG_PBDOWNLOADSTATE_NOPHONEBOOKAVAILABLE = 0UL,
      FI_EN_PHN_VAG_PBDOWNLOADSTATE_CURRENTLYLOADING = 1UL,
      FI_EN_PHN_VAG_PBDOWNLOADSTATE_COMPLETELYLOADED = 2UL,
      FI_EN_PHN_VAG_PBDOWNLOADSTATE_INCOMPLETELYLOADED = 3UL,
      FI_EN_PHN_VAG_PBDOWNLOADSTATE_DOWNLOADABORTED = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_HASH_Value : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_HASH_Value();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_HASH_Value& operator=(const midw_ext_fi_tcl_PHN_HASH_Value& coRef);
   midw_ext_fi_tcl_PHN_HASH_Value(const midw_ext_fi_tcl_PHN_HASH_Value& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > handle;
   virtual ~midw_ext_fi_tcl_PHN_HASH_Value();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_HASH_Value& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBState();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PBState& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PBState(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PBDownloadState eDownloadState;
   tU16 u16PbEntriesUHV;
   tBool bIsNewPhonebook;
   tU8 u8ProfileHandle;
   tBool bIsInitialDownload;
   midw_ext_fi_tcl_PHN_HASH_Value hHashValue;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBState();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBState& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState();
   enum tenType {
      FI_EN_PHN_VAG_CALLSTATE_IDLE = 0UL,
      FI_EN_PHN_VAG_CALLSTATE_INCOMING = 1UL,
      FI_EN_PHN_VAG_CALLSTATE_CONNECTED = 2UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING = 3UL,
      FI_EN_PHN_VAG_CALLSTATE_DISCONNECTING = 4UL,
      FI_EN_PHN_VAG_CALLSTATE_CALLONHOLD = 5UL,
      FI_EN_PHN_VAG_CALLSTATE_WAITING = 6UL,
      FI_EN_PHN_VAG_CALLSTATE_BUSY = 7UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_SYSTEM_BUSY = 8UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_NUMBER_INVALID = 9UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_NETWORK_FAILURE = 10UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_CALL_REJECTED = 11UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_ERROR = 12UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_NO_CARRIER = 13UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_NO_ANSWER = 14UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_DELAYED = 15UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_BLACKLISTED = 16UL,
      FI_EN_PHN_VAG_CALLSTATE_DIALING_NO_DIALTONE = 17UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType();
   enum tenType {
      FI_EN_PHN_VAG_CALLTYPE_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_CALLTYPE_VOICECALL = 1UL,
      FI_EN_PHN_VAG_CALLTYPE_DATACALL = 2UL,
      FI_EN_PHN_VAG_CALLTYPE_FAXCALL = 3UL,
      FI_EN_PHN_VAG_CALLTYPE_EMERGENCYCALL = 4UL,
      FI_EN_PHN_VAG_CALLTYPE_CONFERENCE = 5UL,
      FI_EN_PHN_VAG_CALLTYPE_INFOCALL = 6UL,
      FI_EN_PHN_VAG_CALLTYPE_SERVICECALL = 7UL,
      FI_EN_PHN_VAG_CALLTYPE_DIAL_VIA_SDS = 8UL,
      FI_EN_PHN_VAG_CALLTYPE_DIAL_POI_NUMBER = 9UL,
      FI_EN_PHN_VAG_CALLTYPE_DIAL_VIA_KOMBI = 10UL,
      FI_EN_PHN_VAG_CALLTYPE_DIAL_AIRBIQUITY_NUMBER = 11UL,
      FI_EN_PHN_VAG_CALLTYPE_REDIAL = 12UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState();
   enum tenType {
      FI_EN_PHN_VAG_DIVERTSTATE_NOTDIVERTED = 0UL,
      FI_EN_PHN_VAG_DIVERTSTATE_DIVERTEDINCOMING = 1UL,
      FI_EN_PHN_VAG_DIVERTSTATE_DIVERTEDOUTGOING = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState(midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallState BAPTelCallState;
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallType BAPTelCallType;
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_DivertState BAPTelCallDiverted;
   midw_ext_fi_tclString BAPTelPbName;
   midw_ext_fi_tclString BAPTelTelNumber;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine BAPTelActiveCall;
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine BAPTelHeldCall;
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation_CallLine BAPTelWaitingCall;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isListValid;
   tU32 u32BAPTelDurationActiveCall;
   tU32 u32BAPTelDurationHeldCall;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelCallDuration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BTM_PIN : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BTM_PIN();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BTM_PIN& operator=(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& coRef);
   midw_ext_fi_tcl_PHN_VAG_BTM_PIN(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sPIN;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BTM_PIN();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BTM_PIN& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE();
   enum tenType {
      FI_EN_PHN_BTTESTMODE_NORMAL_MODE = 0UL,
      FI_EN_PHN_BTTESTMODE_DUT_MODE = 1UL,
      FI_EN_PHN_BTTESTMODE_PRODUCTION_MODE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE(midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_BTTestAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_BTTestAction();
   enum tenType {
      FI_EN_PHN_BTTESTACTION_STOP_I2S_TESTTONE = 0UL,
      FI_EN_PHN_BTTESTACTION_START_I2S_TESTTONE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_BTTestAction(midw_ext_fi_tcl_e8_PHN_BTTestAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_BTTestAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_BTTestAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_SetGetShortcutNumber : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_SetGetShortcutNumber();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_SetGetShortcutNumber& operator=(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& coRef);
   midw_ext_fi_tcl_PHN_SetGetShortcutNumber(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ShortcutNumberEntry;
   midw_ext_fi_tclString sShortcutNumber;
   midw_ext_fi_tclString sShortcutName;
   virtual ~midw_ext_fi_tcl_PHN_SetGetShortcutNumber();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_SetGetShortcutNumber& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& operator=(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& coRef);
   midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_PHN_SetGetShortcutNumber, std::allocator<midw_ext_fi_tcl_PHN_SetGetShortcutNumber> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_SetGetShortcutNumberRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL();

   enum {
      FI_C_U8_BIT_PHN_DISPLAY_IN_HEAD_UNIT = 0x1UL,
      FI_C_U8_BIT_PHN_DISPLAY_IN_CLUSTER_DISPLAY = 0x2UL
   };
   tBool bPHN_DISPLAY_IN_HEAD_UNIT() const {return (u8Value & FI_C_U8_BIT_PHN_DISPLAY_IN_HEAD_UNIT) != 0; }
   tVoid vSetPHN_DISPLAY_IN_HEAD_UNIT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_DISPLAY_IN_HEAD_UNIT):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_DISPLAY_IN_HEAD_UNIT)); }
   tBool bPHN_DISPLAY_IN_CLUSTER_DISPLAY() const {return (u8Value & FI_C_U8_BIT_PHN_DISPLAY_IN_CLUSTER_DISPLAY) != 0; }
   tVoid vSetPHN_DISPLAY_IN_CLUSTER_DISPLAY(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_DISPLAY_IN_CLUSTER_DISPLAY):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_DISPLAY_IN_CLUSTER_DISPLAY)); }
   struct rBitValues {
      tBool PHN_DISPLAY_IN_HEAD_UNIT:1;
      tBool PHN_DISPLAY_IN_CLUSTER_DISPLAY:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_PHN_DISPLAY_CONTROL& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_SMS_Handle : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_SMS_Handle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_SMS_Handle& operator=(const midw_ext_fi_tcl_PHN_SMS_Handle& coRef);
   midw_ext_fi_tcl_PHN_SMS_Handle(const midw_ext_fi_tcl_PHN_SMS_Handle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > handle;
   virtual ~midw_ext_fi_tcl_PHN_SMS_Handle();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_SMS_Handle& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_SMS_Message_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_SMS_Message_Status();
   enum tenType {
      FI_EN_PHN_SMS_UNREAD = 0UL,
      FI_EN_PHN_SMS_READ = 1UL,
      FI_EN_PHN_SMS_UNSENT = 2UL,
      FI_EN_PHN_SMS_SENT = 3UL,
      FI_EN_PHN_SMS_DELETED = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_SMS_Message_Status(midw_ext_fi_tcl_e8_PHN_SMS_Message_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_SMS_Message_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_SMS_Message_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status();
   enum tenType {
      FI_EN_PHN_SMS_UPDATE_INITIAL = 0UL,
      FI_EN_PHN_SMS_UPDATE_LISTING_DONE = 1UL,
      FI_EN_PHN_SMS_UPDATE_FOLDER_NOT_FOUND = 2UL,
      FI_EN_PHN_SMS_UPDATE_CHANGE_FOLDER_FAILED = 3UL,
      FI_EN_PHN_SMS_UPDATE_LIST_FOLDER_FAILED = 4UL,
      FI_EN_PHN_SMS_UPDATE_NOT_SUPPORTED = 5UL,
      FI_EN_PHN_SMS_UPDATE_LISTING_DONE_ONLY_MSG_STATUS_UPDATE = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status(midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_SMS_INBOX_Update_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status();
   enum tenType {
      FI_EN_PHN_SMS_SENDING_STATUS_NOT_SUPPORTED = 0UL,
      FI_EN_PHN_SMS_SENDING_STATUS_SENDING_SUCCESS = 1UL,
      FI_EN_PHN_SMS_SENDING_STATUS_SENDING_FAILURE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status(midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_SMS_Sending_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_NumberType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_NumberType();
   enum tenType {
      FI_EN_PHN_VAG_NUMBER_TYPE_UNKNOWN = 0UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_GENERAL = 1UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_MOBILE = 2UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_OFFICE = 3UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_HOME = 4UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_FAX = 5UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_PAGER = 6UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_CAR = 7UL,
      FI_EN_PHN_VAG_NUMBER_TYPE_SIM = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_NumberType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_NumberType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_NumberType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& operator=(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& coRef);
   midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SmsParagraphEntry;
   midw_ext_fi_tclString sMessage;
   virtual ~midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_SMS_PREDEFINED_MESSAGE& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_StartPairingRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_StartPairingRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_StartPairingRequest(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddress;
   tBool isPairingStartRequest;
   virtual ~midw_ext_fi_tcl_PHN_VAG_StartPairingRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_StartPairingRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddress;
   virtual ~midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_DeletePairedDeviceRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddress;
   virtual ~midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDeviceRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool BluetoothStatus;
   virtual ~midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_SetBTMOnOffRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_BT_Profile : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_BT_Profile();
   enum tenType {
      FI_EN_PHN_BT_HFP = 0UL,
      FI_EN_PHN_BT_AVP = 1UL,
      FI_EN_PHN_BT_SMS = 2UL,
      FI_EN_PHN_BT_PIM = 3UL,
      FI_EN_PHN_BT_DUN = 4UL,
      FI_EN_PHN_BT_SPP = 5UL,
      FI_EN_PHN_BT_PAN = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_BT_Profile(midw_ext_fi_tcl_e8_PHN_BT_Profile::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_BT_Profile();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_BT_Profile& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType();
   enum tenType {
      FI_EN_PHN_VAG_BAP_CODE_TYPE_UNDEFINED = 0UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_PIN = 1UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_PIN2 = 2UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_PUK = 3UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_PUK2 = 4UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_LOCK_CODE = 5UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_KEYPAD_LOCK_CODE = 6UL,
      FI_EN_PHN_VAG_BAP_CODE_TYPE_BARRING_PASSWORD = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable_CodeType eCodeType;
   midw_ext_fi_tclString sCode;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartPhoneEnable& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType();
   enum tenType {
      FI_EN_PHN_VAG_BAP_DIAL_NUMBER = 0UL,
      FI_EN_PHN_VAG_BAP_DIAL_INFO_RUF = 1UL,
      FI_EN_PHN_VAG_BAP_DIAL_PANNEN_RUF = 2UL,
      FI_EN_PHN_VAG_BAP_DIAL_VOICE_BOX_NUMBER = 3UL,
      FI_EN_PHN_VAG_BAP_DIAL_EMERGENCY_NUMBER = 4UL,
      FI_EN_PHN_VAG_BAP_DIAL_NUMBER_BY_PB_ID = 5UL,
      FI_EN_PHN_VAG_BAP_DIAL_SHORTCUT_NUMBER = 6UL,
      FI_EN_PHN_VAG_BAP_DIAL_AIRBIQUITY_NUMBER = 7UL,
      FI_EN_PHN_VAG_BAP_DIAL_VIA_SDS = 8UL,
      FI_EN_PHN_VAG_BAP_DIAL_POI_NUMBER = 9UL,
      FI_EN_PHN_VAG_BAP_DIAL_VIA_KOMBI = 10UL,
      FI_EN_PHN_VAG_BAP_DIAL_NUMBER_BY_PB_FLI_ID = 11UL,
      FI_EN_PHN_VAG_BAP_DIAL_REDIAL = 12UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType(midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_TelStartDialNumber_NumberType eNumberType;
   midw_ext_fi_tclString sTelNumber;
   midw_ext_fi_tclString sName;
   tU32 u32PhonebookEntryId;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartDialNumber& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall();
   enum tenType {
      FI_EN_PHN_VAG_BAP_HANG_UP_AIRBIQUITY_CALL = 249UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_DIALING_CALL = 250UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_INCOMING_CALL = 251UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_ALL_ACTIVE_CALLS = 252UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_ALL_HELD_CALLS = 253UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_ALL_ACTIVE_AND_HELD_CALLS = 254UL,
      FI_EN_PHN_VAG_BAP_HANG_UP_ALL_CALLS = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall(midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelStartHangupCall& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff();
   enum tenType {
      FI_EN_PHN_VAG_BAP_SHUT_DOWN_PHONE = 0UL,
      FI_EN_PHN_VAG_BAP_START_UP_PHONE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff(midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelPhoneOnOff& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode();
   enum tenType {
      FI_EN_PHN_VAG_BAP_RESTORE_FACTORY_SETTINGS_MODE_RESERVED = 0UL,
      FI_EN_PHN_VAG_BAP_RESTORE_FACTORY_SETTINGS_MODE_RESTORE_ALL = 1UL,
      FI_EN_PHN_VAG_BAP_RESTORE_FACTORY_SETTINGS_MODE_RESTORE_WITHIN_CURRENT_PROFILE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode(midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_TelRestoreFactorySettings_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage();

   enum {
      FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEMISSEDCALLS = 0x1UL,
      FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETERECEIVEDCALLS = 0x2UL,
      FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEDIALEDNUMBERS = 0x4UL
   };
   tBool bPHN_VAG_PBCallStackDeleteAll_DeleteMissedCalls() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEMISSEDCALLS) != 0; }
   tVoid vSetPHN_VAG_PBCallStackDeleteAll_DeleteMissedCalls(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEMISSEDCALLS):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEMISSEDCALLS)); }
   tBool bPHN_VAG_PBCallStackDeleteAll_DeleteReceivedCalls() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETERECEIVEDCALLS) != 0; }
   tVoid vSetPHN_VAG_PBCallStackDeleteAll_DeleteReceivedCalls(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETERECEIVEDCALLS):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETERECEIVEDCALLS)); }
   tBool bPHN_VAG_PBCallStackDeleteAll_DeleteDialedNumbers() const {return (u8Value & FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEDIALEDNUMBERS) != 0; }
   tVoid vSetPHN_VAG_PBCallStackDeleteAll_DeleteDialedNumbers(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEDIALEDNUMBERS):(u8Value & ~(tU8)FI_C_U8_BIT_PHN_VAG_PBCALLSTACKDELETEALL_DELETEDIALEDNUMBERS)); }
   struct rBitValues {
      tBool PHN_VAG_PBCallStackDeleteAll_DeleteMissedCalls:1;
      tBool PHN_VAG_PBCallStackDeleteAll_DeleteReceivedCalls:1;
      tBool PHN_VAG_PBCallStackDeleteAll_DeleteDialedNumbers:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PBCallStackDeleteAll_Storage& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection();
   enum tenType {
      FI_EN_T_E8_PHN_VAG_BAP_PB_SEARCHDIRECTION_UP = 0UL,
      FI_EN_T_E8_PHN_VAG_BAP_PB_SEARCHDIRECTION_DOWN = 1UL,
      FI_EN_T_E8_PHN_VAG_BAP_PB_SEARCHDIRECTION_EXACT = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection(midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32StartingPosition;
   midw_ext_fi_tcl_e8_PHN_VAG_BAP_PB_SearchDirection eDirection;
   tS32 s32Offset;
   tU8 u8NumberOfEntries;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sSearchString;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_SpellerRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& operator=(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& coRef);
   midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isVoiceRecognitionEnable;
   virtual ~midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_VOICE_RECOGNITION_REQUEST& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult();
   enum tenType {
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_UNKNOWN = 255UL,
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_ERROR_TIMEOUT = 240UL,
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_INTERMEDIATE = 241UL,
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_DENIED = 242UL,
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_OK = 0UL,
      FI_EN_PHN_VAG_SET_BT_VISIBILITY_RESULT_ERROR = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult(midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_SetBTVisibilityResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult();
   enum tenType {
      FI_EN_PHN_VAG_START_PAIRING_RESULT_UNKNOWN = 255UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_ERROR_TIMEOUT = 240UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_INTERMEDIATE = 241UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_DENIED = 242UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_PROGRESS = 1UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_SUCCEEDED = 3UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_FAILED_FULL_LIST = 4UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_FAILED_TIMEOUT = 5UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_FAILED = 6UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_CONNECTING = 7UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_FAILED_WRONG_PIN = 8UL,
      FI_EN_PHN_VAG_START_PAIRING_RESULT_PAIRING_CANCELED = 9UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult(midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_StartPairingResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_StartPairingResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_StartPairingResult& operator=(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_StartPairingResult(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_StartPairingResult e8Result;
   midw_ext_fi_tcl_PHN_VAG_BTDeviceName BTDeviceName;
   virtual ~midw_ext_fi_tcl_PHN_VAG_StartPairingResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_StartPairingResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& operator=(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& coRef);
   midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isListValid;
   tU8 u8NbrOfItems;
   std::vector<midw_ext_fi_tcl_PHN_VAG_PairedBTDevice, std::allocator<midw_ext_fi_tcl_PHN_VAG_PairedBTDevice> > oPairedItemList;
   virtual ~midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_PairedBTDeviceList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult();
   enum tenType {
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_UNKNOWN = 255UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_ERROR_TIMEOUT = 240UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_INTERMEDIATE = 241UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_DENIED = 242UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_OK = 0UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_ERROR = 1UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_ERROR_INVALID_PARAM = 2UL,
      FI_EN_PHN_VAG_DEL_PAIRED_BT_DEV_RESULT_ERROR_UNABLE_DISCONNECT = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult(midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& operator=(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_DeletePairedBTDevResult e8Result;
   virtual ~midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_DeletePairedBTDevResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult();
   enum tenType {
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_OK = 0UL,
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_ERROR_DELETE_FAILED = 1UL,
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_ERROR_INVALID_DATA = 2UL,
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_ERROR_PAIRING_FAILED = 3UL,
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_ERROR_UNKNOWN = 4UL,
      FI_EN_PHN_REPLACE_PAIRED_BT_DEV_RESULT_DENIED = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult(midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_ReplacePairedBTDevResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult();
   enum tenType {
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_UNKNOWN = 255UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_ERROR_TIMEOUT = 240UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_INTERMEDIATE = 241UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_DENIED = 242UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_CONNECT_OK = 0UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_ERROR = 1UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_ERROR_INVALID_PARAM = 2UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_ERROR_UNABLE_DISCONNECT = 3UL,
      FI_EN_PHN_VAG_CONNECT_BT_DEV_RESULT_CONNECTING = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult(midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& operator=(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BTDeviceAddress BTDeviceAddess;
   midw_ext_fi_tcl_e8_PHN_VAG_ConnectBTDevResult e8Result;
   virtual ~midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_ConnectBTDevResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result();
   enum tenType {
      FI_EN_PHN_VAG_BAP_METHOD_OK = 0UL,
      FI_EN_PHN_VAG_BAP_METHOD_RESULT_UNKNOWN = 255UL,
      FI_EN_PHN_VAG_BAP_METHOD_RESULT_ERROR_TIMEOUT = 240UL,
      FI_EN_PHN_VAG_BAP_METHOD_RESULT_INTERMEDIATE = 241UL,
      FI_EN_PHN_VAG_BAP_METHOD_RESULT_DENIED = 242UL,
      FI_EN_PHN_VAG_BAP_METHOD_OR_PROPERTY_REJECT_NOT_SUPPORTED = 16UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_BAP_ERROR = 17UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_RESERVED = 64UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_OUT_OF_RANGE = 65UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NOT_IMPLEMENTED = 66UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_UNIT_MISMATCH = 68UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_ABORTED = 80UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_UNKNOWN = 128UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NOT_SUCCESSFUL = 129UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_OUT_OF_MEMORY = 130UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_DATA_INVALID = 131UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_USER_ACTIVE = 136UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_NETWORK = 137UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NOT_SUPPORTED_BY_NETWORK = 138UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NOT_REGISTERED_EMERGENCY_CALL_ONLY = 139UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_CODE_REQUIRED = 142UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_REDIAL_NUMBER = 143UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_ACTIVE_CALL_PRESENT_DIALING = 144UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_HELD_CALL_PRESENT = 145UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_CALL = 147UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_CALL_RELATED = 148UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_ACTIVE_CALL = 149UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_HOLD_CALL = 150UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_INCOMING_WAITING_CALL = 151UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_CONFERENCE = 154UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_MEMBER_OF_CONFERENCE = 155UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_MAX_NUM_FOR_MEMBERS_OF_CONFERENCE_REACHED = 156UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_FUNCTION_NOT_SUPPORTED_FOR_CONFERENCE_CALLS = 157UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_ERR_PHONEBOOK_DOWNLOAD_IN_PROGRESS = 158UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NOT_SUPPORTED_BY_MOBILE_PHONE_HFP = 160UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_HEADSET_CONNECTED = 161UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_NO_PAIRED_HEADSET = 162UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_AG_FAILURE = 180UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NO_CONNECTION_TO_PHONE = 181UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_OPERATION_NOT_ALLOWED = 183UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_OPERATION_NOT_SUPPORTED = 184UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_PH_SIM_PIN_REQUIRED = 185UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_NOT_INSERTED = 190UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_PIN_REQUIRED = 191UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_PUK_REQUIRED = 192UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_FAILURE = 193UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_BUSY = 194UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_INCORRECT_PASSWORD = 196UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_PIN2_REQUIRED = 197UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_SIM_PUK2_REQUIRED = 198UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_MEMORY_FULL = 200UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_INVALID_INDEX = 201UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_MEMORY_FAILURE = 203UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_TEXT_STRING_TOO_LONG = 204UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_INVALID_CHAR_IN_TEST_STRING = 205UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_DIAL_STRING_TOO_LONG = 206UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_INVALID_CHAR_IN_DIAL_STRING = 207UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NO_NETWORK_SERVICE = 210UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NETWORK_TIMEOUT = 211UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NETWORK_NOT_ALLOWED = 212UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NO_CARRIER = 213UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_BUSY = 214UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NO_ANSWER = 215UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_DELAYED = 216UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_BLACKLISTED = 217UL,
      FI_EN_PHN_VAG_BAP_METHOD_REJECT_APP_ERR_AG_NO_DIALTONE = 218UL,
      FI_EN_PHN_VAG_BAP_METHOD_SPP_MIP_NOT_EXPOSED = 230UL,
      FI_EN_PHN_VAG_BAP_METHOD_SPP_CAPABLITIES_SEARCH_STARTED = 231UL,
      FI_EN_PHN_VAG_BAP_METHOD_SPP_CAPABLITIES_SEARCH_ENDED = 232UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result(midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   midw_ext_fi_tclString sPbName;
   tU8 u8TelNmbQuantity;
   midw_ext_fi_tcl_e8_PHN_VAG_NumberType eNumberType;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool isListValid;
   tU16 u16NbrOfItems;
   std::vector<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name, std::allocator<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result eBAPMethodResult;
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Window ResultContent;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_NumberType eNumberType;
   midw_ext_fi_tclString sTelNumber;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name NameAndPosition;
   tU8 u8NbrOfItems;
   std::vector<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem, std::allocator<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result eBAPMethodResult;
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Item ResultContent;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PhonebookDetailsResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& operator=(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& coRef);
   midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PHN_SMS_Handle hSmsHandle;
   midw_ext_fi_tcl_e8_PHN_SMS_Message_Status e8MessageStatus;
   tU16 u16Year;
   tU8 u8Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   midw_ext_fi_tclString sTelNumber;
   midw_ext_fi_tclString sName;
   midw_ext_fi_tclString sSubject;
   midw_ext_fi_tcl_e8_PHN_VAG_NumberType eNumberType;
   virtual ~midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_SMS_LIST_MESSAGE& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& coRef);
   midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   midw_ext_fi_tclString sPbName;
   midw_ext_fi_tclString sFliName;
   tU8 u8TelNmbQuantity;
   midw_ext_fi_tcl_e8_PHN_VAG_NumberType eNumberType;
   virtual ~midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_PB_FLI_Result : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_PB_FLI_Result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_PB_FLI_Result& operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Result& coRef);
   midw_ext_fi_tcl_PHN_PB_FLI_Result(const midw_ext_fi_tcl_PHN_PB_FLI_Result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name, std::allocator<midw_ext_fi_tcl_PHN_PB_FLI_Phonebook_Name> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_PB_FLI_Result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_PB_FLI_Details_Result : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_PB_FLI_Details_Result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& operator=(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& coRef);
   midw_ext_fi_tcl_PHN_PB_FLI_Details_Result(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   midw_ext_fi_tclString sPbName;
   midw_ext_fi_tclString sFliName;
   tU8 u8TelNmbQuantity;
   std::vector<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem, std::allocator<midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_NumberItem> > oItemList;
   virtual ~midw_ext_fi_tcl_PHN_PB_FLI_Details_Result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_PB_FLI_Details_Result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& operator=(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& coRef);
   midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sPbName;
   midw_ext_fi_tclString sPbNumber;
   tBool bEntryExists;
   virtual ~midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_PB_ENTRIES_CHECK_ITEM& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& operator=(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& coRef);
   midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32PbNameId;
   midw_ext_fi_tclString sPbName;
   tU32 u32PbNumberId;
   midw_ext_fi_tclString sPbNumber;
   virtual ~midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_PB_TELEPHONE_NUMBER_ITEM& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result eBAPMethodResult;
   tBool bMatchFound;
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_Phonebook_Name SearchSpellerResult;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_PBSpellerResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_SearchDir : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_SearchDir();
   enum tenType {
      FI_EN_ENUNDEFINED = 0UL,
      FI_EN_ENSEARCHUP = 1UL,
      FI_EN_ENSEARCHEVEN = 2UL,
      FI_EN_ENSEARCHDOWN = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_SearchDir(midw_ext_fi_tcl_e8_PHN_VAG_SearchDir::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_SearchDir();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_SearchDir& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult();
   enum tenType {
      FI_EN_PHN_VAG_QUICKSEARCH_NOTHING_FOUND = 0UL,
      FI_EN_PHN_VAG_QUICKSEARCH_ENTRY_BEHIND = 1UL,
      FI_EN_PHN_VAG_QUICKSEARCH_MATCH_FOUND = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult(midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& operator=(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& coRef);
   midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result eBAPMethodResult;
   tU32 u32ListID;
   midw_ext_fi_tcl_e8_PHN_VAG_QuickSearchResult eSearchResult;
   tU32 u32ListIndex;
   virtual ~midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_BAP_PB_QuicksearchResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State();
   enum tenType {
      FI_EN_PHN_VAG_DIAG_MUTE_STATE_NOT_DETECTED = 0UL,
      FI_EN_PHN_VAG_DIAG_MUTE_STATE_ACTIVE = 1UL,
      FI_EN_PHN_VAG_DIAG_MUTE_STATE_INACTIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State(midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason();
   enum tenType {
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_PHONE_CALL = 0UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_VOICE_PROMPTS = 1UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_EMERGENCY_CALL = 2UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_NAVIGATION = 3UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_OPERATOR_CALL = 4UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_RINGING = 5UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_BROADBAND_PHONE_CALL = 6UL,
      FI_EN_PHN_VAG_DIAG_CAN_MUTE_REASON_AUDIO = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason(midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& operator=(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& coRef);
   midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State e8MutePinMuteState;
   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State e8CANMuteState;
   midw_ext_fi_tcl_e8_PHN_VAG_DIAG_CAN_Mute_Reason e8CANMuteReason;
   virtual ~midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PHN_VAG_AudioMuteIndication& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS();
   enum tenType {
      FI_EN_PHN_VAG_DIAG_MIC_CONN_OPEN = 0UL,
      FI_EN_PHN_VAG_DIAG_MIC_CONN_SHORT = 1UL,
      FI_EN_PHN_VAG_DIAG_MIC_CONN_OK = 2UL,
      FI_EN_PHN_VAG_DIAG_MIC_CONN_UNDEF = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS(midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_MIC_CONN_STATUS& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS();
   enum tenType {
      FI_EN_PHN_VAG_BT_SETUP_STATUS_ACTIVE = 0UL,
      FI_EN_PHN_VAG_BT_SETUP_STATUS_INACTIVE = 1UL,
      FI_EN_PHN_VAG_BT_SETUP_STATUS_BT_LIB_COM_ERROR = 4UL,
      FI_EN_PHN_VAG_BT_SETUP_STATUS_BT_DISABLED_BY_DIAGNOSIS = 6UL,
      FI_EN_PHN_VAG_BT_SETUP_STATUS_BT_DISABLED_BY_USER = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS(midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_BT_SETUP_STATUS& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason();
   enum tenType {
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_PHONE_CALL = 0UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_VOICE_PROMPTS = 1UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_EMERGENCY_CALL = 2UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_NAVIGATION = 3UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_OPERATOR_CALL = 4UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_RINGING = 5UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_BROADBAND_PHONE_CALL = 6UL,
      FI_EN_PHN_VAG_HMI_AUDIO_CAN_MUTE_REASON_INVALID = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason(midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_HMI_AUDIO_CAN_Mute_Reason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action();
   enum tenType {
      FI_EN_PHN_VAG_HMI_AUDIO_MUTE_STOP = 0UL,
      FI_EN_PHN_VAG_HMI_AUDIO_MUTE_PLAY = 1UL,
      FI_EN_PHN_VAG_HMI_AUDIO_MUTE_PAUSE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action(midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_HMI_Audio_Mute_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource();
   enum tenType {
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_AUX_UHV = 0UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_PHN_1 = 1UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_PHN_2 = 2UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_PHN_3 = 3UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_PHN_4 = 4UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_RINGTONE = 5UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_BTM_PHN_5 = 6UL,
      FI_EN_PHN_VAG_AUDIO_MUTE_TEL_SOURCE_INVALID = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource(midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_AudioMute_TelephoneSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_GAIN_SETTING : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_GAIN_SETTING();
   enum tenType {
      FI_EN_PHN_GAIN_SETTING_LOW = 0UL,
      FI_EN_PHN_GAIN_SETTING_MEDIUM = 1UL,
      FI_EN_PHN_GAIN_SETTING_HIGH = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_GAIN_SETTING(midw_ext_fi_tcl_e8_PHN_GAIN_SETTING::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_GAIN_SETTING();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_GAIN_SETTING& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER();
   enum tenType {
      FI_EN_PHN_VAG_PB_SORTING_FIRST_NAME = 0UL,
      FI_EN_PHN_VAG_PB_SORTING_LAST_NAME = 1UL,
      FI_EN_PHN_VAG_PB_SORTING_UNDEFINED = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER(midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_PB_SORTING_ORDER& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER();
   enum tenType {
      FI_EN_PHN_VAG_PB_SOURCE_SIM_AND_ME = 0UL,
      FI_EN_PHN_VAG_PB_SOURCE_SIM_ONLY = 1UL,
      FI_EN_PHN_VAG_PB_SOURCE_ME_ONLY = 2UL,
      FI_EN_PHN_VAG_PB_SOURCE_UNDEFINED = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER(midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_VAG_PB_SOURCE_FILTER& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS();
   enum tenType {
      FI_EN_PHN_BATTERY_RANGE_0 = 0UL,
      FI_EN_PHN_BATTERY_RANGE_1 = 1UL,
      FI_EN_PHN_BATTERY_RANGE_2 = 2UL,
      FI_EN_PHN_BATTERY_RANGE_3 = 3UL,
      FI_EN_PHN_BATTERY_RANGE_4 = 4UL,
      FI_EN_PHN_BATTERY_RANGE_5 = 5UL,
      FI_EN_PHN_BATTERY_RANGE_UNKNOWN = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS(midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_BATTERY_STATUS& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_TX_MODE_SET : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_TX_MODE_SET();
   enum tenType {
      FI_EN_PHN_TX_MODE_1 = 19UL,
      FI_EN_PHN_TX_MODE_2 = 20UL,
      FI_EN_PHN_TX_MODE_3 = 21UL,
      FI_EN_PHN_TX_MODE_4 = 23UL,
      FI_EN_PHN_TX_MODE_5 = 51UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_TX_MODE_SET(midw_ext_fi_tcl_e8_PHN_TX_MODE_SET::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_TX_MODE_SET();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_TX_MODE_SET& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH();
   enum tenType {
      FI_EN_PHN_TX_SLOT_LENGTH_DH5 = 5UL,
      FI_EN_PHN_TX_SLOT_LENGTH_DH3 = 3UL,
      FI_EN_PHN_TX_SLOT_LENGTH_DH1 = 1UL,
      FI_EN_PHN_TX_SLOT_LENGTH_2_DH5 = 37UL,
      FI_EN_PHN_TX_SLOT_LENGTH_2_DH3 = 35UL,
      FI_EN_PHN_TX_SLOT_LENGTH_2_DH1 = 33UL,
      FI_EN_PHN_TX_SLOT_LENGTH_3_DH5 = 53UL,
      FI_EN_PHN_TX_SLOT_LENGTH_3_DH3 = 51UL,
      FI_EN_PHN_TX_SLOT_LENGTH_3_DH1 = 49UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH(midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_TX_SLOT_LENGTH& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE();
   enum tenType {
      FI_EN_PHN_LOCAL_BT_DEVICE_UNKNOWN_MODE = 0UL,
      FI_EN_PHN_LOCAL_BT_DEVICE_APL_MODE = 1UL,
      FI_EN_PHN_LOCAL_BT_DEVICE_HCI_MODE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE(midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PHN_LOCAL_BT_DEVICE_MODE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_UnitType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_UnitType();
   enum tenType {
      FI_EN_AUDIO = 0UL,
      FI_EN_NAVI = 1UL,
      FI_EN_SWSC = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_UnitType(midw_ext_fi_tcl_e8_Meter_UnitType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_UnitType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_UnitType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_ConfigurationStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_ConfigurationStatus();
   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_VALID = 1UL,
      FI_EN_INVALID = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_ConfigurationStatus(midw_ext_fi_tcl_e8_Meter_ConfigurationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_ConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_ConfigurationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_VersionInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_VersionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_VersionInfo& operator=(const midw_ext_fi_tcl_Meter_VersionInfo& coRef);
   midw_ext_fi_tcl_Meter_VersionInfo(const midw_ext_fi_tcl_Meter_VersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Upper;
   tU8 u8Mid;
   tU8 u8Lower;
   virtual ~midw_ext_fi_tcl_Meter_VersionInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_VersionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_UnitConnectionStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_UnitConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_UnitConnectionStatus& operator=(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& coRef);
   midw_ext_fi_tcl_Meter_UnitConnectionStatus(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_UnitType e8UnitType;
   tBool bConnected;
   tU8 u8AbsenceState;
   tU8 u8MuteState;
   virtual ~midw_ext_fi_tcl_Meter_UnitConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_UnitConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_UnitConfiguration : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_UnitConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_UnitConfiguration& operator=(const midw_ext_fi_tcl_Meter_UnitConfiguration& coRef);
   midw_ext_fi_tcl_Meter_UnitConfiguration(const midw_ext_fi_tcl_Meter_UnitConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_UnitType e8UnitType;
   midw_ext_fi_tcl_e8_Meter_ConfigurationStatus e8ConfigurationStatus;
   tU8 u8UnitId;
   midw_ext_fi_tcl_Meter_VersionInfo rMessageVersion;
   virtual ~midw_ext_fi_tcl_Meter_UnitConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_UnitConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_UnitVersion : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_UnitVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_UnitVersion& operator=(const midw_ext_fi_tcl_Meter_UnitVersion& coRef);
   midw_ext_fi_tcl_Meter_UnitVersion(const midw_ext_fi_tcl_Meter_UnitVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_UnitType e8UnitType;
   midw_ext_fi_tcl_Meter_VersionInfo rVersion;
   virtual ~midw_ext_fi_tcl_Meter_UnitVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_UnitVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& operator=(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& coRef);
   midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_UnitType e8UnitType;
   tU8 u8MPDTMuteState;
   virtual ~midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_UnitDataTransmissionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Language : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Language();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_US_ENGLISH = 1UL,
      FI_EN_CANADIAN_FRENCH = 2UL,
      FI_EN_MEXICAN_SPANISH = 3UL,
      FI_EN_JAPANESE = 4UL,
      FI_EN_MANDARIN_CHINESE = 5UL,
      FI_EN_TRADITIONAL_CHINESE = 6UL,
      FI_EN_KOREAN = 7UL,
      FI_EN_ARABIC = 8UL,
      FI_EN_THAI = 9UL,
      FI_EN_ENGLISH = 10UL,
      FI_EN_FRENCH = 11UL,
      FI_EN_SPANISH = 12UL,
      FI_EN_GERMAN = 13UL,
      FI_EN_ITALIAN = 14UL,
      FI_EN_PORTUGUESE = 15UL,
      FI_EN_BRAZILIAN_PORTUGUESE = 16UL,
      FI_EN_DUTCH = 17UL,
      FI_EN_TURKISH = 18UL,
      FI_EN_RUSSIAN = 19UL,
      FI_EN_DANISH = 20UL,
      FI_EN_SWEDISH = 21UL,
      FI_EN_FINNISH = 22UL,
      FI_EN_NORWEGIAN = 23UL,
      FI_EN_GREEK = 24UL,
      FI_EN_POLISH = 25UL,
      FI_EN_CZECH = 26UL,
      FI_EN_SLOVAKIAN = 27UL,
      FI_EN_HUNGARIAN = 28UL,
      FI_EN_AUSTRALIAN_ENGLISH = 29UL,
      FI_EN_INDONESIAN = 30UL,
      FI_EN_UNUSED = 254UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Language(midw_ext_fi_tcl_e8_Meter_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Language_Action : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Language_Action();
   enum tenType {
      FI_EN_INVALID_ACTION = 0UL,
      FI_EN_GETREQUESTEDLANGUAGEAVAILABILITY = 1UL,
      FI_EN_SETREQUESTEDLANGUAGEONMETERONEWAY = 2UL,
      FI_EN_SETREQUESTEDLANGUAGEONMETERTWOWAY = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Language_Action(midw_ext_fi_tcl_e8_Meter_Language_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Language_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Language_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type();
   enum tenType {
      FI_EN_NOT_AVAILABLE = 0UL,
      FI_EN_ONEWAYSYNC = 1UL,
      FI_EN_TWOWAYSYNC = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type(midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Lang_Sync_Mode_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Language_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Language_Status();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_AVAILABLE_UNSET = 1UL,
      FI_EN_AVAILABLE_SET = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Language_Status(midw_ext_fi_tcl_e8_Meter_Language_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Language_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Language_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult();
   enum tenType {
      FI_EN_INVALID_PARAMETER = 0UL,
      FI_EN_UNCHANGEDNOTAUTO = 1UL,
      FI_EN_UNCHANGEDAUTO = 2UL,
      FI_EN_CHANGED = 3UL,
      FI_EN_AVAILABLE_UNSET = 4UL,
      FI_EN_AVAILABLE_SET = 5UL,
      FI_EN_UNAVAILABLE = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult(midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_RequestedLanguageResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_DistanceUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_DistanceUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_M = 1UL,
      FI_EN_MI = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_DistanceUnit(midw_ext_fi_tcl_e8_Meter_DistanceUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_DistanceUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_DistanceUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_KM_PER_L = 1UL,
      FI_EN_L_PER_100KM = 2UL,
      FI_EN_US_MPG = 3UL,
      FI_EN_UK_MPG = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit(midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_FuelConsumptionUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_TemperatureUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_TemperatureUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DEG_C = 1UL,
      FI_EN_DEG_F = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_TemperatureUnit(midw_ext_fi_tcl_e8_Meter_TemperatureUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_TemperatureUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_TemperatureUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_PressureUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_PressureUnit();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_KPA = 1UL,
      FI_EN_PSI = 2UL,
      FI_EN_BAR = 3UL,
      FI_EN_KGF_CM2 = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_PressureUnit(midw_ext_fi_tcl_e8_Meter_PressureUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_PressureUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_PressureUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_NoData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_NoData();

   virtual ~midw_ext_fi_tcl_Meter_Audio_NoData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_Meter_Audio_NoData& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_RadioSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_RadioSource();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM1 = 2UL,
      FI_EN_FM2 = 3UL,
      FI_EN_FM_AP = 4UL,
      FI_EN_AM = 16UL,
      FI_EN_AM_AP = 17UL,
      FI_EN_XM1 = 32UL,
      FI_EN_XM2 = 33UL,
      FI_EN_XM3 = 34UL,
      FI_EN_SXM = 35UL,
      FI_EN_SXM1 = 36UL,
      FI_EN_SXM2 = 37UL,
      FI_EN_SXM3 = 38UL,
      FI_EN_TA_JPN = 48UL,
      FI_EN_TA_RDS = 49UL,
      FI_EN_FM_PTY = 50UL,
      FI_EN_ALARM_RDS = 64UL,
      FI_EN_DAB = 80UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_RadioSource(midw_ext_fi_tcl_e8_Meter_Audio_RadioSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_RadioSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_RadioSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate();
   enum tenType {
      FI_EN_NOT_UPDATED = 0UL,
      FI_EN_UPDATED = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName();
   enum tenType {
      FI_EN_FM_HD = 1UL,
      FI_EN_AM_HD = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName(midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& operator=(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef);
   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoUpdate e8Update;
   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSourceInfoName e8Name;
   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_PRESET = 1UL,
      FI_EN_CHANNEL = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType(midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_RadioLabel : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_RadioLabel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_RadioLabel& operator=(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& coRef);
   midw_ext_fi_tcl_Meter_Audio_RadioLabel(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_RadioLabelType e8Type;
   tU8 u8Id;
   virtual ~midw_ext_fi_tcl_Meter_Audio_RadioLabel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_RadioLabel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_AM = 2UL,
      FI_EN_XM = 3UL,
      FI_EN_KHZ = 4UL,
      FI_EN_MHZ = 5UL,
      FI_EN_CH = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit(midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_RadioFrequency : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_RadioFrequency();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_RadioFrequency& operator=(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& coRef);
   midw_ext_fi_tcl_Meter_Audio_RadioFrequency(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Thousands;
   tU8 u8Hundreds;
   tU8 u8Tens;
   tU8 u8Ones;
   tBool bShowDecimalPoint;
   tU8 u8Tenths;
   tU8 u8Hundredths;
   midw_ext_fi_tcl_e8_Meter_Audio_RadioFrequencyUnit e8Unit;
   virtual ~midw_ext_fi_tcl_Meter_Audio_RadioFrequency();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_RadioFrequency& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_CATEGORY = 1UL,
      FI_EN_PTY = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType(midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_RadioCategory : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_RadioCategory();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_RadioCategory& operator=(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& coRef);
   midw_ext_fi_tcl_Meter_Audio_RadioCategory(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_RadioCategoryType e8Type;
   midw_ext_fi_tclString strCategoryName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_RadioCategory();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_RadioCategory& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_RadioData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_RadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_RadioData& operator=(const midw_ext_fi_tcl_Meter_Audio_RadioData& coRef);
   midw_ext_fi_tcl_Meter_Audio_RadioData(const midw_ext_fi_tcl_Meter_Audio_RadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_RadioSource e8RadioSource;
   midw_ext_fi_tcl_Meter_Audio_RadioLabel rLabel;
   midw_ext_fi_tcl_Meter_Audio_RadioFrequency rFrequency;
   midw_ext_fi_tcl_Meter_Audio_RadioCategory rCategory;
   midw_ext_fi_tclString strStationName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_RadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_RadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_HDRadioData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_HDRadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_HDRadioData& operator=(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& coRef);
   midw_ext_fi_tcl_Meter_Audio_HDRadioData(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_HDRadioSource e8RadioSource;
   midw_ext_fi_tcl_Meter_Audio_RadioLabel rLabel;
   midw_ext_fi_tcl_Meter_Audio_RadioFrequency rFrequency;
   midw_ext_fi_tcl_Meter_Audio_RadioCategory rCategory;
   midw_ext_fi_tclString strStationName;
   tU8 u8MulticastChannel;
   midw_ext_fi_tclString strArtistName;
   midw_ext_fi_tclString strSongName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_HDRadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_HDRadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_MediaType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_MediaType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_CD = 1UL,
      FI_EN_MUSIC_BOX = 2UL,
      FI_EN_IPOD = 3UL,
      FI_EN_USB = 4UL,
      FI_EN_BT_AUDIO = 5UL,
      FI_EN_DVD = 6UL,
      FI_EN_PANDORA = 7UL,
      FI_EN_DISC = 8UL,
      FI_EN_IPOD1 = 9UL,
      FI_EN_IPOD2 = 10UL,
      FI_EN_USB1 = 11UL,
      FI_EN_USB2 = 12UL,
      FI_EN_BLU_RAY = 13UL,
      FI_EN_SD = 14UL,
      FI_EN_CAR_PLAY = 15UL,
      FI_EN_ANDROID_AUTO = 16UL,
      FI_EN_MYSPIN = 17UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_MediaType(midw_ext_fi_tcl_e8_Meter_Audio_MediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_MediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_MediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_TRACK = 1UL,
      FI_EN_CHAPTER = 2UL,
      FI_EN_FILE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType(midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_TrackInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_TrackInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_TrackInfo& operator=(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& coRef);
   midw_ext_fi_tcl_Meter_Audio_TrackInfo(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_TrackLabelType e8LabelType;
   tU32 u32TrackNumber;
   midw_ext_fi_tclString strTrackName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_TrackInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_TrackInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_DISC = 1UL,
      FI_EN_ALBUM = 2UL,
      FI_EN_GROUP = 3UL,
      FI_EN_FOLDER = 4UL,
      FI_EN_TITLE = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType(midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_GroupInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_GroupInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_GroupInfo& operator=(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& coRef);
   midw_ext_fi_tcl_Meter_Audio_GroupInfo(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_GroupLabelType e8LabelType;
   tU16 u16GroupNumber;
   midw_ext_fi_tclString strGroupName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_GroupInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_GroupInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_ARTIST = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType(midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_ArtistInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_ArtistInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_ArtistInfo& operator=(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& coRef);
   midw_ext_fi_tcl_Meter_Audio_ArtistInfo(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_ArtistLabelType e8LabelType;
   midw_ext_fi_tclString strArtistName;
   virtual ~midw_ext_fi_tcl_Meter_Audio_ArtistInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_ArtistInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_MediaData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_MediaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_MediaData& operator=(const midw_ext_fi_tcl_Meter_Audio_MediaData& coRef);
   midw_ext_fi_tcl_Meter_Audio_MediaData(const midw_ext_fi_tcl_Meter_Audio_MediaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_MediaType e8MediaType;
   midw_ext_fi_tcl_Meter_Audio_TrackInfo rTrackInfo;
   midw_ext_fi_tcl_Meter_Audio_GroupInfo rGroupInfo;
   midw_ext_fi_tcl_Meter_Audio_ArtistInfo rArtistInfo;
   virtual ~midw_ext_fi_tcl_Meter_Audio_MediaData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_MediaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_AuxType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_AuxType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_VTR_JACK = 1UL,
      FI_EN_PIN_AUX = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_AuxType(midw_ext_fi_tcl_e8_Meter_Audio_AuxType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_AuxType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_AuxType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_AuxData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_AuxData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_AuxData& operator=(const midw_ext_fi_tcl_Meter_Audio_AuxData& coRef);
   midw_ext_fi_tcl_Meter_Audio_AuxData(const midw_ext_fi_tcl_Meter_Audio_AuxData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_AuxType e8AuxType;
   virtual ~midw_ext_fi_tcl_Meter_Audio_AuxData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_AuxData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_ExternalSoundData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_ExternalSoundData();

   virtual ~midw_ext_fi_tcl_Meter_Audio_ExternalSoundData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_Meter_Audio_ExternalSoundData& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_InternetRadioData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_InternetRadioData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_InternetRadioData& operator=(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& coRef);
   midw_ext_fi_tcl_Meter_Audio_InternetRadioData(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strSourceName;
   midw_ext_fi_tcl_Meter_Audio_TrackInfo rTrackInfo;
   midw_ext_fi_tcl_Meter_Audio_GroupInfo rGroupInfo;
   midw_ext_fi_tcl_Meter_Audio_ArtistInfo rArtistInfo;
   virtual ~midw_ext_fi_tcl_Meter_Audio_InternetRadioData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_InternetRadioData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType();
   enum tenType {
      FI_EN_T_METER_AUDIO_NODATA = 0UL,
      FI_EN_T_METER_AUDIO_RADIODATA = 1UL,
      FI_EN_T_METER_AUDIO_MEDIADATA = 2UL,
      FI_EN_T_METER_AUDIO_AUXDATA = 3UL,
      FI_EN_T_METER_AUDIO_EXTERNALSOUNDDATA = 4UL,
      FI_EN_T_METER_AUDIO_INTERNETRADIODATA = 5UL,
      FI_EN_T_METER_AUDIO_HDRADIODATA = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType(midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& operator=(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& coRef);
   midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Meter_Audio_SourceInfoType SourceInfoType;
   fi_tclTypeBase* poSourceInfoData;
   virtual ~midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Meter_Audio_SourceInfoUnion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_WarningSource : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_WarningSource();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM1 = 2UL,
      FI_EN_FM2 = 3UL,
      FI_EN_FM_AP = 4UL,
      FI_EN_AM = 5UL,
      FI_EN_AM_AP = 6UL,
      FI_EN_XM1 = 7UL,
      FI_EN_XM2 = 8UL,
      FI_EN_XM3 = 9UL,
      FI_EN_TA_JPN = 10UL,
      FI_EN_TA_RDS = 11UL,
      FI_EN_ALARM_RDS = 12UL,
      FI_EN_FM_PTY = 13UL,
      FI_EN_CD = 16UL,
      FI_EN_MUSIC_BOX = 17UL,
      FI_EN_IPOD = 18UL,
      FI_EN_USB = 19UL,
      FI_EN_BT_AUDIO = 20UL,
      FI_EN_DVD = 21UL,
      FI_EN_PANDORA = 22UL,
      FI_EN_DISC = 23UL,
      FI_EN_TV = 32UL,
      FI_EN_TV1 = 33UL,
      FI_EN_TV2 = 34UL,
      FI_EN_VTR_JACK = 48UL,
      FI_EN_PIN_AUX = 49UL,
      FI_EN_DAB = 64UL,
      FI_EN_SXM = 65UL,
      FI_EN_SXM1 = 66UL,
      FI_EN_SXM2 = 67UL,
      FI_EN_SXM3 = 68UL,
      FI_EN_FM_HD = 69UL,
      FI_EN_AM_HD = 70UL,
      FI_EN_RSE = 80UL,
      FI_EN_BLU_RAY = 81UL,
      FI_EN_DRM = 82UL,
      FI_EN_SD = 83UL,
      FI_EN_CAR_PLAY = 84UL,
      FI_EN_ANDROID_AUTO = 85UL,
      FI_EN_MYSPIN = 86UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_WarningSource(midw_ext_fi_tcl_e8_Meter_Audio_WarningSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_WarningSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_WarningSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_WarningState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_WarningState();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_AUDIO_OFF = 1UL,
      FI_EN_EXTERNAL_SOUND = 2UL,
      FI_EN_AUTO_PRESETTING = 16UL,
      FI_EN_LIST_UPDATING = 17UL,
      FI_EN_CHECK_ANTENNA = 18UL,
      FI_EN_NO_SIGNAL = 19UL,
      FI_EN_CH_UNAUTHORIZED = 20UL,
      FI_EN_OFF_AIR = 21UL,
      FI_EN_LOADING = 22UL,
      FI_EN_NO_DISC = 32UL,
      FI_EN_LOADING_DISC = 33UL,
      FI_EN_EJECTING_DISC = 34UL,
      FI_EN_READING_DISC = 35UL,
      FI_EN_READING_USB_MEMORY = 36UL,
      FI_EN_READING_IPOD = 37UL,
      FI_EN_UNPLAYABLE_FILE = 38UL,
      FI_EN_DISC_READ_ERROR = 39UL,
      FI_EN_REGION_INVALID = 40UL,
      FI_EN_NO_AUDIO_FILE = 41UL,
      FI_EN_NO_SONG = 42UL,
      FI_EN_IPOD_NOT_CONNECTED = 43UL,
      FI_EN_NO_USB = 44UL,
      FI_EN_CHECK_DEVICE = 45UL,
      FI_EN_OTHER_ERROR = 46UL,
      FI_EN_PLEASE_WAIT = 47UL,
      FI_EN_PLEASE_EJECT_DISC = 48UL,
      FI_EN_CH_UNAVAILABLE = 49UL,
      FI_EN_NO_SERVICE = 50UL,
      FI_EN_NO_STATION = 51UL,
      FI_EN_NO_MORE_SKIPS = 52UL,
      FI_EN_CHECK_DEVICE_FOR_PANDORA = 53UL,
      FI_EN_SERVICE_UNAVAILABLE = 54UL,
      FI_EN_LOADING_AUDIO_FILE_LIST = 55UL,
      FI_EN_NO_MUSIC_FOUND = 56UL,
      FI_EN_CHECK_CONNECTED_DEVICE = 57UL,
      FI_EN_NO_DEVICES_CONNECTED = 58UL,
      FI_EN_EXTERNAL_TEXT = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_WarningState(midw_ext_fi_tcl_e8_Meter_Audio_WarningState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_WarningState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_WarningState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_SCAN = 1UL,
      FI_EN_SEARCH = 2UL,
      FI_EN_FASTFORWARD = 3UL,
      FI_EN_REWIND = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode(midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Audio_SpecialMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_NavStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_NavStatus();
   enum tenType {
      FI_EN_NAVSTATUS_UNKNOWN = 0UL,
      FI_EN_NAVSTATUS_BUSY = 1UL,
      FI_EN_NAVSTATUS_IDLE = 2UL,
      FI_EN_NAVSTATUS_GUIDANCE_ACTIVE = 3UL,
      FI_EN_NAVSTATUS_CALCULATING_ROUTE = 4UL,
      FI_EN_NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_NavStatus(midw_ext_fi_tcl_e8_NavStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_NavStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_NavStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_RoadClass : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_RoadClass();
   enum tenType {
      FI_EN_ROAD_CLASS_NONE = 0UL,
      FI_EN_ROAD_CLASS_MOTORWAY = 1UL,
      FI_EN_ROAD_CLASS_FREEWAY = 2UL,
      FI_EN_ROAD_CLASS_HIGHWAY = 3UL,
      FI_EN_ROAD_CLASS_ARTERIAL = 4UL,
      FI_EN_ROAD_CLASS_COLLECTOR = 5UL,
      FI_EN_ROAD_CLASS_LOCAL = 6UL,
      FI_EN_ROAD_CLASS_ADRESSABLESTREET = 7UL,
      FI_EN_ROAD_CLASS_TRAIL = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_RoadClass(midw_ext_fi_tcl_e8_RoadClass::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_RoadClass();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_RoadClass& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Unit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Unit();
   enum tenType {
      FI_EN_UNIT_METER = 0UL,
      FI_EN_UNIT_KMS = 1UL,
      FI_EN_UNIT_MILES = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Unit(midw_ext_fi_tcl_e8_Unit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Unit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Unit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ManeuverSymbol : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ManeuverSymbol();
   enum tenType {
      FI_EN_MANEUVER_SYMBOL_NO_SYMBOL = 0UL,
      FI_EN_MANEUVER_SYMBOL_NO_INFO = 1UL,
      FI_EN_MANEUVER_SYMBOL_FOLLOW = 2UL,
      FI_EN_MANEUVER_SYMBOL_RECALC = 3UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED = 4UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED_LEFT = 5UL,
      FI_EN_MANEUVER_SYMBOL_DEST_REACHED_RIGHT = 6UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED = 7UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT = 8UL,
      FI_EN_MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT = 9UL,
      FI_EN_MANEUVER_SYMBOL_EXIT_LEFT = 10UL,
      FI_EN_MANEUVER_SYMBOL_EXIT_RIGHT = 11UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT = 12UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT = 13UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT = 14UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT = 15UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE = 16UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT = 17UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT = 18UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT = 19UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT = 20UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT = 21UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT = 22UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT = 23UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE = 24UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT = 25UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT = 26UL,
      FI_EN_MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT = 27UL,
      FI_EN_MANEUVER_SYMBOL_STRAIGHT = 28UL,
      FI_EN_MANEUVER_SYMBOL_TURN_HALFRIGHT = 29UL,
      FI_EN_MANEUVER_SYMBOL_TURN_RIGHT = 30UL,
      FI_EN_MANEUVER_SYMBOL_TURN_SHARPRIGHT = 31UL,
      FI_EN_MANEUVER_SYMBOL_TURN_SHARPLEFT = 32UL,
      FI_EN_MANEUVER_SYMBOL_TURN_LEFT = 33UL,
      FI_EN_MANEUVER_SYMBOL_TURN_HALFLEFT = 34UL,
      FI_EN_MANEUVER_SYMBOL_UTURN_LEFT = 35UL,
      FI_EN_MANEUVER_SYMBOL_UTURN_RIGHT = 36UL,
      FI_EN_MANEUVER_SYMBOL_KEEP_LEFT = 37UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_001 = 38UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_009 = 39UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_025 = 40UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_041 = 41UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_057 = 42UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_073 = 43UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_089 = 44UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_105 = 45UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_121 = 46UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_137 = 47UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_153 = 48UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_169 = 49UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_185 = 50UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_201 = 51UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_217 = 52UL,
      FI_EN_MANEUVER_SYMBOL_DEST_DIRECTION_233 = 53UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ManeuverSymbol(midw_ext_fi_tcl_e8_ManeuverSymbol::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ManeuverSymbol();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ManeuverSymbol& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SpeedUnit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SpeedUnit();
   enum tenType {
      FI_EN_SPEEDUNIT_KM_PER_HOUR = 0UL,
      FI_EN_SPEEDUNIT_MI_PER_HOUR = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SpeedUnit(midw_ext_fi_tcl_e8_SpeedUnit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SpeedUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SpeedUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ManeuverRecommendationType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ManeuverRecommendationType();
   enum tenType {
      FI_EN_PREVIEW = 0UL,
      FI_EN_PRELIMINARY = 1UL,
      FI_EN_REGULAR = 2UL,
      FI_EN_REPEATED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ManeuverRecommendationType(midw_ext_fi_tcl_e8_ManeuverRecommendationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ManeuverRecommendationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ManeuverRecommendationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TimeType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TimeType();
   enum tenType {
      FI_EN_REMAININGTIME = 0UL,
      FI_EN_ETA = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TimeType(midw_ext_fi_tcl_e8_TimeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TimeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TimeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TimeFormat : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TimeFormat();
   enum tenType {
      FI_EN_TWELVEHOURS = 0UL,
      FI_EN_TWENTYFOURHOURS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TimeFormat(midw_ext_fi_tcl_e8_TimeFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TimeFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TimeFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ManeuverView : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ManeuverView();
   enum tenType {
      FI_EN_MANEUVER_VIEW_NONE = 0UL,
      FI_EN_MANEUVER_VIEW_DEFORMED_IMAGE = 1UL,
      FI_EN_MANEUVER_VIEW_INTERSECTION_MAP = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ManeuverView(midw_ext_fi_tcl_e8_ManeuverView::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ManeuverView();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ManeuverView& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DeformedImageRoad : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DeformedImageRoad();
   enum tenType {
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_NONE = 0UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_FORK = 1UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_EXIT_LEFT = 2UL,
      FI_EN_DEFORMED_IMAGE_ROAD_TYPE_EXIT_RIGHT = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DeformedImageRoad(midw_ext_fi_tcl_e8_DeformedImageRoad::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DeformedImageRoad();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DeformedImageRoad& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DeformedImageArrow : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DeformedImageArrow();
   enum tenType {
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_NONE = 0UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_STRAIGHT = 1UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_LEFT = 2UL,
      FI_EN_DEFORMED_IMAGE_ARROW_TYPE_RIGHT = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DeformedImageArrow(midw_ext_fi_tcl_e8_DeformedImageArrow::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DeformedImageArrow();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DeformedImageArrow& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_LaneStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_LaneStatus();
   enum tenType {
      FI_EN_LANE_STATUS_UNKNOWN = 0UL,
      FI_EN_LANE_STATUS_FORBIDDEN = 1UL,
      FI_EN_LANE_STATUS_NOT_RECOMMENDED = 2UL,
      FI_EN_LANE_STATUS_RECOMMENDED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_LaneStatus(midw_ext_fi_tcl_e8_LaneStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_LaneStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_LaneStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_LaneRecommendation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_LaneRecommendation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_LaneRecommendation& operator=(const midw_ext_fi_tcl_LaneRecommendation& coRef);
   midw_ext_fi_tcl_LaneRecommendation(const midw_ext_fi_tcl_LaneRecommendation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_LaneStatus e8LaneRecommendationListLaneStatus;
   tS32 s32LaneRecommendationListCombinedFollowingLaneDirection;
   tS32 s32LaneRecommendationListGuidedFollowingLaneDirection;
   virtual ~midw_ext_fi_tcl_LaneRecommendation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_LaneRecommendation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ArrivalInformation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ArrivalInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ArrivalInformation& operator=(const midw_ext_fi_tcl_ArrivalInformation& coRef);
   midw_ext_fi_tcl_ArrivalInformation(const midw_ext_fi_tcl_ArrivalInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strArrivalInformationListDistanceToDestinationDistanceToDestinationAsString;
   tU32 u32ArrivalInformationListDistanceToDestinationDistanceToDestination;
   midw_ext_fi_tcl_e8_Unit e8ArrivalInformationListDistanceToDestinationUnit;
   midw_ext_fi_tclString strArrivalInformationListDistanceToDestinationTimeToDestinationAsString;
   tS32 s32ArrivalInformationListTimeToDestination;
   midw_ext_fi_tclString strArrivalInformationListEstimatedTimeOfArrivalAsString;
   tS32 s32ArrivalInformationListEstimatedTimeOfArrivalHour;
   tS32 s32ArrivalInformationListEstimatedTimeOfArrivalMinute;
   midw_ext_fi_tcl_e8_TimeType e8ArrivalInformationListDisplayTimeType;
   midw_ext_fi_tcl_e8_TimeFormat e8ArrivalInformationListDisplayTimeFormat;
   tS32 s32ArrivalInformationListDestinationIndex;
   virtual ~midw_ext_fi_tcl_ArrivalInformation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ArrivalInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ScreenCoordinate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ScreenCoordinate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ScreenCoordinate& operator=(const midw_ext_fi_tcl_ScreenCoordinate& coRef);
   midw_ext_fi_tcl_ScreenCoordinate(const midw_ext_fi_tcl_ScreenCoordinate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ScreenCoordinateXPos;
   tU32 u32ScreenCoordinateYPos;
   virtual ~midw_ext_fi_tcl_ScreenCoordinate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ScreenCoordinate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_AdminRoadClass : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_AdminRoadClass();
   enum tenType {
      FI_EN_ADMIN_ROAD_CLASS_UNKNOWN = 0UL,
      FI_EN_ADMIN_ROAD_CLASS_MOST_IMPORTANT = 1UL,
      FI_EN_ADMIN_ROAD_CLASS_SECOND_IMPORTANT = 2UL,
      FI_EN_ADMIN_ROAD_CLASS_THIRD_IMPORTANT = 3UL,
      FI_EN_ADMIN_ROAD_CLASS_FOURTH_IMPORTANT = 4UL,
      FI_EN_ADMIN_ROAD_CLASS_FIFTH_IMPORTANT = 5UL,
      FI_EN_ADMIN_ROAD_CLASS_SIXTH_IMPORTANT = 6UL,
      FI_EN_ADMIN_ROAD_CLASS_LEAST_IMPORTANT = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_AdminRoadClass(midw_ext_fi_tcl_e8_AdminRoadClass::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_AdminRoadClass();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_AdminRoadClass& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_IntersectionMapRoadLine : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_IntersectionMapRoadLine();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_IntersectionMapRoadLine& operator=(const midw_ext_fi_tcl_IntersectionMapRoadLine& coRef);
   midw_ext_fi_tcl_IntersectionMapRoadLine(const midw_ext_fi_tcl_IntersectionMapRoadLine& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_ScreenCoordinate, std::allocator<midw_ext_fi_tcl_ScreenCoordinate> > tIntersectionMapRoadLineCoordinates;
   midw_ext_fi_tcl_e8_AdminRoadClass e8IntersectionMapRoadLineRoadClass;
   virtual ~midw_ext_fi_tcl_IntersectionMapRoadLine();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_IntersectionMapRoadLine& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_IntersectionMapCarsorState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_IntersectionMapCarsorState();
   enum tenType {
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_OFF = 0UL,
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_ON = 1UL,
      FI_EN_INTERSECTION_MAP_CARSOR_STATE_STANDBY = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_IntersectionMapCarsorState(midw_ext_fi_tcl_e8_IntersectionMapCarsorState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_IntersectionMapCarsorState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_IntersectionMapCarsorState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState();
   enum tenType {
      FI_EN_SPI_APP_STATE_NAV_UNKNOWN = 0UL,
      FI_EN_SPI_APP_STATE_NAV_ACTIVE = 1UL,
      FI_EN_SPI_APP_STATE_NAV_NOTACTIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState(midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SpiNavigation_NavigationAppState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SpiNavigation_TurnSide : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SpiNavigation_TurnSide();
   enum tenType {
      FI_EN_TURN_SIDE_LEFT = 1UL,
      FI_EN_TURN_SIDE_RIGHT = 2UL,
      FI_EN_TURN_SIDE_UNSPECIFIED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SpiNavigation_TurnSide(midw_ext_fi_tcl_e8_SpiNavigation_TurnSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SpiNavigation_TurnSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SpiNavigation_TurnSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent();
   enum tenType {
      FI_EN_NEXT_TURN_UNKNOWN = 0UL,
      FI_EN_NEXT_TURN_DEPART = 1UL,
      FI_EN_NEXT_TURN_NAME_CHANGE = 2UL,
      FI_EN_NEXT_TURN_SLIGHT_TURN = 3UL,
      FI_EN_NEXT_TURN_TURN = 4UL,
      FI_EN_NEXT_TURN_SHARP_TURN = 5UL,
      FI_EN_NEXT_TURN_U_TURN = 6UL,
      FI_EN_NEXT_TURN_ON_RAMP = 7UL,
      FI_EN_NEXT_TURN_OFF_RAMP = 8UL,
      FI_EN_NEXT_TURN_FORK = 9UL,
      FI_EN_NEXT_TURN_MERGE = 10UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER = 11UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_EXIT = 12UL,
      FI_EN_NEXT_TURN_ROUNDABOUT_ENTER_AND_EXIT = 13UL,
      FI_EN_NEXT_TURN_STRAIGHT = 14UL,
      FI_EN_NEXT_TURN_FERRY_BOAT = 16UL,
      FI_EN_NEXT_TURN_FERRY_TRAIN = 17UL,
      FI_EN_NEXT_TURN_DESTINATION = 19UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent(midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SpiNavigation_NextTurnEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_SOURCE = 1UL,
      FI_EN_ENTER = 2UL,
      FI_EN_BACK = 3UL,
      FI_EN_VR = 4UL,
      FI_EN_TEL = 5UL,
      FI_EN_TELON = 6UL,
      FI_EN_TELOFF = 7UL,
      FI_EN_VR_TELON = 8UL,
      FI_EN_SOURCE_TELOFF = 9UL,
      FI_EN_VOLUP = 10UL,
      FI_EN_VOLDOWN = 11UL,
      FI_EN_UP = 12UL,
      FI_EN_DOWN = 13UL,
      FI_EN_RIGHT = 14UL,
      FI_EN_LEFT = 15UL,
      FI_EN_MUTE = 16UL,
      FI_EN_MENU_UP = 17UL,
      FI_EN_MENU_DOWN = 18UL,
      FI_EN_MENU_OK = 19UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode(midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_SWSC_KeyCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Phone_SMS_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_State();
   enum tenType {
      FI_EN_NO_ACTION = 0UL,
      FI_EN_SHOW_POPUP = 1UL,
      FI_EN_UPDATE_MSG_NUMBER = 2UL,
      FI_EN_RECEIVING = 3UL,
      FI_EN_READING = 4UL,
      FI_EN_REPLY_MENU = 5UL,
      FI_EN_END_SMS = 6UL,
      FI_EN_SMS_SENT_SUCCESSFULLY = 7UL,
      FI_EN_SMS_SENT_FAILUERE = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_State(midw_ext_fi_tcl_e8_Meter_Phone_SMS_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Phone_SMS_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Phone_SMS_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu();
   enum tenType {
      FI_EN_NO_ACTION = 0UL,
      FI_EN_READ = 1UL,
      FI_EN_IGNORE = 2UL,
      FI_EN_REPLY = 3UL,
      FI_EN_EXIT = 4UL,
      FI_EN_CALL_BACK = 5UL,
      FI_EN_OUT_OF_SMS = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu(midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Phone_SMS_Selected_Menu& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_INCOMING = 1UL,
      FI_EN_READING = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType(midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_Phone_SMS_PopupType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_VR_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_VR_State();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_LISTENING = 1UL,
      FI_EN_PROCESSING = 2UL,
      FI_EN_SMS_SENDING = 3UL,
      FI_EN_MANUAL_MODE = 4UL,
      FI_EN_SMART_PHONE_VR_ON = 5UL,
      FI_EN_SMART_PHONE_VR_OFF = 6UL,
      FI_EN_HF_MODE = 7UL,
      FI_EN_DIGIT_OFF = 8UL,
      FI_EN_DIGIT_ON = 9UL,
      FI_EN_SMS_SENDING_FAILURE = 10UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_VR_State(midw_ext_fi_tcl_e8_Meter_VR_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_VR_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_VR_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2 : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2();
   enum tenType {
      FI_EN_0 = 0UL,
      FI_EN_1 = 1UL,
      FI_EN_2 = 2UL,
      FI_EN_3 = 3UL,
      FI_EN_4 = 4UL,
      FI_EN_5 = 5UL,
      FI_EN_6 = 6UL,
      FI_EN_7 = 7UL,
      FI_EN_8 = 8UL,
      FI_EN_9 = 9UL,
      FI_EN_MINUS = 10UL,
      FI_EN_PLUS = 11UL,
      FI_EN_STAR = 12UL,
      FI_EN_HASH = 13UL,
      FI_EN_NONDISPLAY = 15UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2(midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_VR_Digit_Type2& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_PowerState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_PowerState();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SHUTDOWN = 1UL,
      FI_EN_PREPARETOSHUTDOWN = 2UL,
      FI_EN_USINGACCESSORY = 3UL,
      FI_EN_IGNITIONON = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_PowerState(midw_ext_fi_tcl_e8_Meter_PowerState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_PowerState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_PowerState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_TimeInfoType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_TimeInfoType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_24H = 1UL,
      FI_EN_AM = 2UL,
      FI_EN_PM = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_TimeInfoType(midw_ext_fi_tcl_e8_Meter_TimeInfoType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_TimeInfoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_TimeInfoType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ANSWER = 1UL,
      FI_EN_DECLINE = 2UL,
      FI_EN_END = 3UL,
      FI_EN_USEHANDSET = 4UL,
      FI_EN_ENTERDIGITS = 5UL,
      FI_EN_MUTEONOFF = 6UL,
      FI_EN_SWITCHCALL = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action(midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_PhoneCall_Menu_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Meter_PhoneCall_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Meter_PhoneCall_State();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_INCOMING = 1UL,
      FI_EN_DURINGCALL = 2UL,
      FI_EN_ENDCALL = 3UL,
      FI_EN_OUTGOING = 4UL,
      FI_EN_OUTGOINGFAILURE = 5UL,
      FI_EN_CALLWAITING = 6UL,
      FI_EN_DURINGCALLCARPLAY = 7UL,
      FI_EN_CALLWAITINGCARPLAY = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Meter_PhoneCall_State(midw_ext_fi_tcl_e8_Meter_PhoneCall_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Meter_PhoneCall_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Meter_PhoneCall_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Language_InvalidParameter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Language_InvalidParameter();
   enum tenType {
      FI_EN_NORMAL = 0UL,
      FI_EN_OUTOFRANGE = 1UL,
      FI_EN_INVALEDPARAMETER = 2UL,
      FI_EN_INTERNALERROR = 3UL,
      FI_EN_OTHER = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Language_InvalidParameter(midw_ext_fi_tcl_e8_Language_InvalidParameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Language_InvalidParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Language_InvalidParameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ConfigurationStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ConfigurationStatus();
   enum tenType {
      FI_EN_UNDEFINED = 0UL,
      FI_EN_VALID = 1UL,
      FI_EN_INVALID = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ConfigurationStatus(midw_ext_fi_tcl_e8_TCU_ConfigurationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ConfigurationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_VersionInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_VersionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_VersionInfo& operator=(const midw_ext_fi_tcl_TCU_VersionInfo& coRef);
   midw_ext_fi_tcl_TCU_VersionInfo(const midw_ext_fi_tcl_TCU_VersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Upper;
   tU8 u8Mid;
   tU8 u8Lower;
   virtual ~midw_ext_fi_tcl_TCU_VersionInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_VersionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_CommunicationStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_CommunicationStatus();
   enum tenType {
      FI_EN_COMM_STATUS_OFF = 0UL,
      FI_EN_COMM_STATUS_NOT_CONNECTED = 1UL,
      FI_EN_COMM_STATUS_CONNECTION_WAIT = 2UL,
      FI_EN_COMM_STATUS_CONNECTED = 3UL,
      FI_EN_COMM_STATUS_CONNECTION_ERROR = 4UL,
      FI_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_CommunicationStatus(midw_ext_fi_tcl_e8_TCU_CommunicationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_CommunicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_CommunicationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ServiceState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ServiceState();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_VOICECALL = 16UL,
      FI_EN_VOICECALLCONNECTED = 17UL,
      FI_EN_VOICECALLSETUPFAILED = 18UL,
      FI_EN_VOICECALLDISCONNECTED = 19UL,
      FI_EN_VOICECALLABNORMALDISCONNECTED = 20UL,
      FI_EN_VOICECALLRETRY = 21UL,
      FI_EN_VOICECALLSTOP = 22UL,
      FI_EN_GOTOVOICE = 23UL,
      FI_EN_OUTOFSERVICE = 24UL,
      FI_EN_DTMF_CLI_START = 48UL,
      FI_EN_DTMF_CLI_STOP = 49UL,
      FI_EN_DTMF_POSITION_START = 50UL,
      FI_EN_DTMF_POSITION_END = 51UL,
      FI_EN_GOTODATA = 52UL,
      FI_EN_POIDOWNLOADREQUEST = 53UL,
      FI_EN_POIDOWNLOADEND = 54UL,
      FI_EN_STARTVEHICLEDIAGNOSIS = 64UL,
      FI_EN_FINISHVEHICLEDIAGNOSIS = 65UL,
      FI_EN_FINISHUPLOADINGTHEDTC = 66UL,
      FI_EN_MSDNOTSENT  = 67UL,
      FI_EN_ENDINFOSENDING = 68UL,
      FI_EN_INITIATEINFOSENDING = 69UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ServiceState(midw_ext_fi_tcl_e8_TCU_ServiceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ServiceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ServiceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_CurfewWarning : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_CurfewWarning();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_APPROACHTOSETTIME = 1UL,
      FI_EN_SETTIMEUP = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_CurfewWarning(midw_ext_fi_tcl_e8_TCU_CurfewWarning::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_CurfewWarning();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_CurfewWarning& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ModemStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ModemStatus();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_MODEMREADY = 1UL,
      FI_EN_MODEMNOTREADY = 2UL,
      FI_EN_MODEMFAILURE = 3UL,
      FI_EN_NOTAVAILABLE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ModemStatus(midw_ext_fi_tcl_e8_TCU_ModemStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ModemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ModemStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_TCUStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_TCUStatus();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_TCUACTIVATED = 1UL,
      FI_EN_TCUNOTACTIVATED = 2UL,
      FI_EN_NOTAVAILABLE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_TCUStatus(midw_ext_fi_tcl_e8_TCU_TCUStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_TCUStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_TCUStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_GSMStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_GSMStatus();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_GSM_WCDMACONNECTIONOK = 1UL,
      FI_EN_GSM_WCDMACONNECTIONNOTOK = 2UL,
      FI_EN_NOTAVAILABLE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_GSMStatus(midw_ext_fi_tcl_e8_TCU_GSMStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_GSMStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_GSMStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_WifiStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_WifiStatus();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_WifiStatus(midw_ext_fi_tcl_e8_TCU_WifiStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_WifiStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_WifiStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_WifiMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_WifiMode();
   enum tenType {
      FI_EN_WIFIUNAVAILABLE = 0UL,
      FI_EN_WIFICLIENT = 1UL,
      FI_EN_WIFIHOTSPOTVIAUSBKEY  = 2UL,
      FI_EN_WIFIHOTSPOTVIABLUETOOTH = 3UL,
      FI_EN_WIFIHOTSPOTVIATCU = 4UL,
      FI_EN_UNKONOW = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_WifiMode(midw_ext_fi_tcl_e8_TCU_WifiMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_WifiMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_WifiMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus();
   enum tenType {
      FI_EN_WIFINOTACTIVATED = 0UL,
      FI_EN_WIFIACTIVATEDAVAILABLE = 1UL,
      FI_EN_WIFIACTIVATEDNOTAVAILABLE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus(midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_WifiHotSpotStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_WifiClientStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_WifiClientStatus();
   enum tenType {
      FI_EN_NOTCONNECTED = 0UL,
      FI_EN_CONNECTED = 1UL,
      FI_EN_SCANINPROGRESS = 2UL,
      FI_EN_CONNECTIONINPROGRESS = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_WifiClientStatus(midw_ext_fi_tcl_e8_TCU_WifiClientStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_WifiClientStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_WifiClientStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_GSMDataMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_GSMDataMode();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_GPRS = 1UL,
      FI_EN_EDGE = 2UL,
      FI_EN_3G = 3UL,
      FI_EN_HSPA = 4UL,
      FI_EN_2G = 5UL,
      FI_EN__4G = 6UL,
      FI_EN__4G_WITH_VOLTE = 7UL,
      FI_EN__4G_PLUS = 8UL,
      FI_EN__4G_PLUS_WITH_VOLTE = 9UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_GSMDataMode(midw_ext_fi_tcl_e8_TCU_GSMDataMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_GSMDataMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_GSMDataMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Invalid_Parameter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter();
   enum tenType {
      FI_EN_NORMAL = 0UL,
      FI_EN_OUTOFRANGE = 1UL,
      FI_EN_INVALIDPARAMETER = 2UL,
      FI_EN_INTERNALERROR = 3UL,
      FI_EN_OTHER = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Invalid_Parameter(midw_ext_fi_tcl_e8_TCU_Invalid_Parameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Invalid_Parameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Invalid_Parameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_RoamingStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_RoamingStatus();
   enum tenType {
      FI_EN_UNAVAILABLE = 255UL,
      FI_EN_UNREGISTERED = 0UL,
      FI_EN_REGISTEREDHOME = 1UL,
      FI_EN_REGISTEREDROAMING = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_RoamingStatus(midw_ext_fi_tcl_e8_TCU_RoamingStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_RoamingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_RoamingStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus();
   enum tenType {
      FI_EN_UNAVAILABLE = 255UL,
      FI_EN_DISCONNECTED = 0UL,
      FI_EN_DISCONNECTING = 1UL,
      FI_EN_CONNECTING = 2UL,
      FI_EN_CONNECTED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus(midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_PPPConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_InvalidParameter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_InvalidParameter();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_OUTOFRANGE = 1UL,
      FI_EN_INVALEDPARAMETER = 2UL,
      FI_EN_INTERNALERROR = 3UL,
      FI_EN_OTHER = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_InvalidParameter(midw_ext_fi_tcl_e8_TCU_InvalidParameter::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_InvalidParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_InvalidParameter& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_PermitSetting : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_PermitSetting();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL,
      FI_EN_DISCLAIMER = 2UL,
      FI_EN_NOACTION = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_PermitSetting(midw_ext_fi_tcl_e8_TCU_PermitSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_PermitSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_PermitSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_APP_Context : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_APP_Context();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_TELEMA = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_APP_Context(midw_ext_fi_tcl_e8_TCU_APP_Context::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_APP_Context();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_APP_Context& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ProbePermitSetting : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ProbePermitSetting();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ProbePermitSetting(midw_ext_fi_tcl_e8_TCU_ProbePermitSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ProbePermitSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ProbePermitSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_PopUpFlag : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_PopUpFlag();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_PopUpFlag(midw_ext_fi_tcl_e8_TCU_PopUpFlag::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_PopUpFlag();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_PopUpFlag& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_OperationRequest : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_OperationRequest();
   enum tenType {
      FI_EN_CANCEL = 0UL,
      FI_EN_CONNECT = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_OperationRequest(midw_ext_fi_tcl_e8_TCU_OperationRequest::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_OperationRequest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_OperationRequest& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Date_Time : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Date_Time();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Date_Time& operator=(const midw_ext_fi_tcl_TCU_Date_Time& coRef);
   midw_ext_fi_tcl_TCU_Date_Time(const midw_ext_fi_tcl_TCU_Date_Time& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   tU8 u8Reserve;
   virtual ~midw_ext_fi_tcl_TCU_Date_Time();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Date_Time& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_LocationType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_LocationType();
   enum tenType {
      FI_EN_TOKYO = 0UL,
      FI_EN_WGS84 = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_LocationType(midw_ext_fi_tcl_e8_TCU_LocationType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_LocationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_LocationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Score_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Score_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Score_Info& operator=(const midw_ext_fi_tcl_TCU_Score_Info& coRef);
   midw_ext_fi_tcl_TCU_Score_Info(const midw_ext_fi_tcl_TCU_Score_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ECOScore;
   tU8 u8StartScore;
   tU8 u8CruiseScore;
   tU8 u8SlowdownScore;
   virtual ~midw_ext_fi_tcl_TCU_Score_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Score_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Navi_Road_classification : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Navi_Road_classification();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Navi_Road_classification& operator=(const midw_ext_fi_tcl_TCU_Navi_Road_classification& coRef);
   midw_ext_fi_tcl_TCU_Navi_Road_classification(const midw_ext_fi_tcl_TCU_Navi_Road_classification& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8TableType;
   tU8 u8RoadType;
   virtual ~midw_ext_fi_tcl_TCU_Navi_Road_classification();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Navi_Road_classification& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Distance_Value : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Distance_Value();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Distance_Value& operator=(const midw_ext_fi_tcl_TCU_Distance_Value& coRef);
   midw_ext_fi_tcl_TCU_Distance_Value(const midw_ext_fi_tcl_TCU_Distance_Value& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16OilFilter;
   tU16 u16Oil;
   tU16 u16Tire;
   tU16 u16User;
   tU16 u16Battery;
   tU16 u16ACFilter;
   tU16 u16Reserve;
   virtual ~midw_ext_fi_tcl_TCU_Distance_Value();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Distance_Value& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Distance_Unit : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Distance_Unit();
   enum tenType {
      FI_EN_MILE = 2UL,
      FI_EN_KM = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Distance_Unit(midw_ext_fi_tcl_e8_TCU_Distance_Unit::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Distance_Unit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Distance_Unit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Provision_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Provision_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Provision_List& operator=(const midw_ext_fi_tcl_TCU_Provision_List& coRef);
   midw_ext_fi_tcl_TCU_Provision_List(const midw_ext_fi_tcl_TCU_Provision_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bOperatorService;
   tBool bConnectedSearch;
   tBool bMobileInformation;
   tU16 u16ReserveNissan;
   tBool bInternetWidget;
   tBool bFuelPrice;
   tBool bLocalSearch;
   tBool bWebPreTrip;
   tBool bHDTraffic;
   tBool bSpeedTrap;
   tBool bPreventNav;
   tBool bWeather;
   tBool bLiveServices;
   tBool bChargingSpotFinder;
   tBool bChargingSchedule;
   tU16 u16ReserveRenault;
   virtual ~midw_ext_fi_tcl_TCU_Provision_List();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Provision_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_EcallStateDisplay : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_EcallStateDisplay();
   enum tenType {
      FI_EN_NOTHINGTODISPLAY = 0UL,
      FI_EN_NOTUSED = 1UL,
      FI_EN_DETECTECALLDEACTIVATIONBYDIAGTOOL = 2UL,
      FI_EN_DETECTECALLACTIVATIONBYDIAGTOOL = 3UL,
      FI_EN_DETECTMANUALECALLLAUNCH = 4UL,
      FI_EN_DETECTAUTOMATICECALLLAUNCH = 5UL,
      FI_EN_DETECTMANUALECALLLAUNCHFAILURE = 6UL,
      FI_EN_DETECTMANUALECALLCANCELLATION = 7UL,
      FI_EN_RECEPTIONOFPSAPMSGSEND = 8UL,
      FI_EN_VOICECONNECTIONANDMSDNOTSUCCESSFULLYTRANSMITTED = 9UL,
      FI_EN_VOICECONNECTIONANDMSDSUCCESSFULLYTRANSMITTED = 10UL,
      FI_EN_DETECTFAILUREOFCOMMUNICATION = 11UL,
      FI_EN_DETECTNORMALENDOFCOMMUNICATION = 12UL,
      FI_EN_DETECTINCOMINGCALL = 13UL,
      FI_EN_NOUSE = 14UL,
      FI_EN_ECALLSYSTEMMALFUNCTION = 15UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_EcallStateDisplay(midw_ext_fi_tcl_e8_TCU_EcallStateDisplay::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_EcallStateDisplay();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_EcallStateDisplay& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Maintenance_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Maintenance_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Maintenance_Info& operator=(const midw_ext_fi_tcl_TCU_Maintenance_Info& coRef);
   midw_ext_fi_tcl_TCU_Maintenance_Info(const midw_ext_fi_tcl_TCU_Maintenance_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Distance_Unit e8DistanceUnit;
   midw_ext_fi_tcl_TCU_Distance_Value rDistanceValue;
   virtual ~midw_ext_fi_tcl_TCU_Maintenance_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Maintenance_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_LatitudeMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_LatitudeMode();
   enum tenType {
      FI_EN_NORTH = 0UL,
      FI_EN_SOUTH = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_LatitudeMode(midw_ext_fi_tcl_e8_TCU_LatitudeMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_LatitudeMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_LatitudeMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_LongitudeMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_LongitudeMode();
   enum tenType {
      FI_EN_EAST = 0UL,
      FI_EN_WEST = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_LongitudeMode(midw_ext_fi_tcl_e8_TCU_LongitudeMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_LongitudeMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_LongitudeMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Sign : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Sign();
   enum tenType {
      FI_EN_MINUS = 0UL,
      FI_EN_PLUS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Sign(midw_ext_fi_tcl_e8_TCU_Sign::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Sign();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Sign& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Home : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Home();
   enum tenType {
      FI_EN_INSIDE = 0UL,
      FI_EN_OUTSIDE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Home(midw_ext_fi_tcl_e8_TCU_Home::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Home();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Home& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Altitude : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Altitude();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Altitude& operator=(const midw_ext_fi_tcl_TCU_Altitude& coRef);
   midw_ext_fi_tcl_TCU_Altitude(const midw_ext_fi_tcl_TCU_Altitude& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Sign e8Sign;
   tU16 u16Value;
   virtual ~midw_ext_fi_tcl_TCU_Altitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Altitude& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_LocationInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_LocationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_LocationInfo& operator=(const midw_ext_fi_tcl_TCU_LocationInfo& coRef);
   midw_ext_fi_tcl_TCU_LocationInfo(const midw_ext_fi_tcl_TCU_LocationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_LocationType e8LocationType;
   midw_ext_fi_tcl_e8_TCU_LatitudeMode e8Latitudemode;
   midw_ext_fi_tcl_e8_TCU_LongitudeMode e8LongitudeMode;
   tU8 u8LatitudeDEG;
   tU8 u8LatitudeMIN;
   tU16 u16LatitudeSEC;
   tU8 u8LongitudeDEG;
   tU8 u8LongitudeMIN;
   tU16 u16LongitudeSEC;
   midw_ext_fi_tcl_TCU_Altitude Altitude;
   tU8 u8SatelliteNumber;
   midw_ext_fi_tcl_e8_TCU_Home e8Home;
   tU8 u8Reserve;
   virtual ~midw_ext_fi_tcl_TCU_LocationInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_LocationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Navi_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Navi_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Navi_Info& operator=(const midw_ext_fi_tcl_TCU_Navi_Info& coRef);
   midw_ext_fi_tcl_TCU_Navi_Info(const midw_ext_fi_tcl_TCU_Navi_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_LocationInfo LocationInfo;
   midw_ext_fi_tcl_TCU_Date_Time rDateTime;
   tU16 u16VehicleHeading;
   tU8 u8TimeZone;
   virtual ~midw_ext_fi_tcl_TCU_Navi_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Navi_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Probe_Vehicle_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Probe_Vehicle_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& operator=(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& coRef);
   midw_ext_fi_tcl_TCU_Probe_Vehicle_Info(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NaviVehicleSpeed;
   tU32 u32NaviDrivingDistance;
   midw_ext_fi_tcl_TCU_Navi_Road_classification NaviRoadClassification;
   virtual ~midw_ext_fi_tcl_TCU_Probe_Vehicle_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Probe_Vehicle_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Opcode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Opcode();
   enum tenType {
      FI_EN_INDICATION = 0UL,
      FI_EN_STATUS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Opcode(midw_ext_fi_tcl_e8_TCU_Opcode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Opcode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Opcode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Mode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Mode();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Mode(midw_ext_fi_tcl_e8_TCU_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_ReminderInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_ReminderInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_ReminderInfo& operator=(const midw_ext_fi_tcl_TCU_ReminderInfo& coRef);
   midw_ext_fi_tcl_TCU_ReminderInfo(const midw_ext_fi_tcl_TCU_ReminderInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Mode e8Plugin_Mode;
   midw_ext_fi_tcl_e8_TCU_Mode e8Stop_Mode;
   tU16 u16RemainTime;
   virtual ~midw_ext_fi_tcl_TCU_ReminderInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_ReminderInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Service_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Service_Type();
   enum tenType {
      FI_EN_COMPATIBLESTATIONFINDER = 0UL,
      FI_EN_EMERGENCYSTATIONFINDER = 1UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Service_Type(midw_ext_fi_tcl_e8_TCU_Service_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Service_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Service_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ePOI_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ePOI_Type();
   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_SPOT = 1UL,
      FI_EN_QUICKDROP = 2UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ePOI_Type(midw_ext_fi_tcl_e8_TCU_ePOI_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ePOI_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ePOI_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Finder_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Finder_Status();
   enum tenType {
      FI_EN_NO_SEARCH = 1UL,
      FI_EN_SEARCH_ONG_OING = 2UL,
      FI_EN_STATION_FOUND = 3UL,
      FI_EN_ALL_STATION_FOUND = 4UL,
      FI_EN_GSM_NOTAVAILABLE = 5UL,
      FI_EN_FUNCTION_NOT_ACTIVATED = 6UL,
      FI_EN_NO_STATIONS_FOUND = 7UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Finder_Status(midw_ext_fi_tcl_e8_TCU_Finder_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Finder_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Finder_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_GPS_Position : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_GPS_Position();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_GPS_Position& operator=(const midw_ext_fi_tcl_TCU_GPS_Position& coRef);
   midw_ext_fi_tcl_TCU_GPS_Position(const midw_ext_fi_tcl_TCU_GPS_Position& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Reserved;
   midw_ext_fi_tcl_e8_TCU_LocationType e8LocationType;
   midw_ext_fi_tcl_e8_TCU_LatitudeMode e8Latitudemode;
   midw_ext_fi_tcl_e8_TCU_LongitudeMode e8LongitudeMode;
   tU8 u8LatitudeDEG;
   tU8 u8LatitudeMIN;
   tU16 u16LatitudeSEC;
   tU8 u8LongitudeDEG;
   tU8 u8LongitudeMIN;
   tU16 u16LongitudeSEC;
   virtual ~midw_ext_fi_tcl_TCU_GPS_Position();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_GPS_Position& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Time_Stamp : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Time_Stamp();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Time_Stamp& operator=(const midw_ext_fi_tcl_TCU_Time_Stamp& coRef);
   midw_ext_fi_tcl_TCU_Time_Stamp(const midw_ext_fi_tcl_TCU_Time_Stamp& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   virtual ~midw_ext_fi_tcl_TCU_Time_Stamp();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Time_Stamp& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Opening_Hour_Day : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Opening_Hour_Day();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Opening_Hour_Day& operator=(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& coRef);
   midw_ext_fi_tcl_TCU_Opening_Hour_Day(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8StartTime_1;
   tU8 u8StartTime_2;
   tU8 u8EndTime_1;
   tU8 u8EndTime_2;
   virtual ~midw_ext_fi_tcl_TCU_Opening_Hour_Day();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Opening_Hour_Day& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Opening_Hour : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Opening_Hour();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Opening_Hour& operator=(const midw_ext_fi_tcl_TCU_Opening_Hour& coRef);
   midw_ext_fi_tcl_TCU_Opening_Hour(const midw_ext_fi_tcl_TCU_Opening_Hour& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Opening_Hour_Day rSunday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rMonday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rTuesday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rWednesday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rThursday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rFriday;
   midw_ext_fi_tcl_TCU_Opening_Hour_Day rSaturday;
   virtual ~midw_ext_fi_tcl_TCU_Opening_Hour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Opening_Hour& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Charge_Station_Accessibility : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Charge_Station_Accessibility();
   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_FREE_PUBLICLY_ACCESSIBLE = 1UL,
      FI_EN_RESTRICTED_ACCESS = 2UL,
      FI_EN_PAYING_PUBLICLY_ACCESSIBLE = 3UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_TCU_Charge_Station_Accessibility(midw_ext_fi_tcl_TCU_Charge_Station_Accessibility::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_TCU_Charge_Station_Accessibility();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_TCU_Charge_Station_Accessibility& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Payment_Method_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Payment_Method_Type();
   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_NO_PAYMENT = 1UL,
      FI_EN_PAYING_CASH = 2UL,
      FI_EN_PAYING_CREDIT_CARD = 3UL,
      FI_EN_PAYING_BANK_OR_DEBIT_CARD = 4UL,
      FI_EN_PAYING_RECHARGING_PAYMENT_CARD_OR_PRE_PAYING_CARD = 5UL,
      FI_EN_PAYING_ELECTRONIC_TOLL_COLLECTION = 6UL,
      FI_EN_PAYING_COINS = 7UL,
      FI_EN_PAYING_FLAT_FREE = 8UL,
      FI_EN_VARIABLE = 9UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_TCU_Payment_Method_Type(midw_ext_fi_tcl_TCU_Payment_Method_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_TCU_Payment_Method_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_TCU_Payment_Method_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Full_Address : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Full_Address();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Full_Address& operator=(const midw_ext_fi_tcl_TCU_Full_Address& coRef);
   midw_ext_fi_tcl_TCU_Full_Address(const midw_ext_fi_tcl_TCU_Full_Address& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Length_of_Text;
   midw_ext_fi_tclString sText_Info;
   virtual ~midw_ext_fi_tcl_TCU_Full_Address();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Full_Address& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Bookable_Information : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Bookable_Information();
   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_FACILITY_NOT_BOOKABLE = 1UL,
      FI_EN_FACILITY_BOOKABLE = 2UL,
      FI_EN_INVALID = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Bookable_Information(midw_ext_fi_tcl_e8_TCU_Bookable_Information::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Bookable_Information();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Bookable_Information& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Spot_Availability : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Spot_Availability();
   enum tenType {
      FI_EN_UNSPECIFIED = 0UL,
      FI_EN_SPOT_NOT_AVAILABLE  = 1UL,
      FI_EN_SPOT_AVAILABLE  = 2UL,
      FI_EN_INVALID = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Spot_Availability(midw_ext_fi_tcl_e8_TCU_Spot_Availability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Spot_Availability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Spot_Availability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Bookable_Free_Text : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Bookable_Free_Text();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Bookable_Free_Text& operator=(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& coRef);
   midw_ext_fi_tcl_TCU_Bookable_Free_Text(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Length_of_Text;
   midw_ext_fi_tclString sText_Info;
   virtual ~midw_ext_fi_tcl_TCU_Bookable_Free_Text();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Bookable_Free_Text& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type();
   enum tenType {
      FI_EN_SMALL_PADDLE = 2UL,
      FI_EN_LARGE_PADDLE_INDUCTIVE = 3UL,
      FI_EN_AVCON_CONNECTOR = 4UL,
      FI_EN_TESLA_CONNECTOR = 5UL,
      FI_EN_NEMA_5_20 = 7UL,
      FI_EN_IEC_62196_2_TYPE_2_OUTLETS = 8UL,
      FI_EN_IEC_62196_2_TYPE_3_OUTLET_16A_MONO = 9UL,
      FI_EN_IEC_62196_2_TYPE_3_OUTLET_32A_TRIPHAS  = 10UL,
      FI_EN_CABLE_ATTACHED_WITH_JARI_LEVEL_3 = 11UL,
      FI_EN_309_SINGLE_PHASE_INDUSTRIAL = 13UL,
      FI_EN_CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_1_CONNECTOR = 14UL,
      FI_EN_CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_2_CONNECTOR = 15UL,
      FI_EN_CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_CONNECTOR_16A_MONO = 16UL,
      FI_EN_IEC_62196_2_TYPE_3_OUTLET_32A_MONO = 17UL,
      FI_EN_STANDARD_HOUSEHOLD_ITALY = 18UL,
      FI_EN_STANDARD_HOUSEHOLD_GB = 19UL,
      FI_EN_STANDARD_HOUSEHOLD_SWIZTERLAND = 20UL,
      FI_EN_STANDARD_HOUSEHOLD_EUROPE = 21UL,
      FI_EN_STANDARD_HOUSEHOLD_DENMARK  = 22UL,
      FI_EN_CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_INLET_CONNECTOR_32_A_MONO = 23UL,
      FI_EN_CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_INLET_CONNECTOR_32_A_TRIPHASE = 24UL,
      FI_EN_SAE_J1772 = 25UL,
      FI_EN_STANDARD_HOUSEHOLD_COLOMBIA = 26UL,
      FI_EN_CHADEMO_QUICK_CHARGE   = 27UL,
      FI_EN_UNAVAILABLE  = 31UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type(midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility();
   enum tenType {
      FI_EN_200_240V_1_PHASE_10A = 0UL,
      FI_EN_200_240V_1_PHASE_12A = 1UL,
      FI_EN_200_240V_1_PHASE_16A = 2UL,
      FI_EN_200_240V_1_PHASE_32A = 3UL,
      FI_EN_380_480V_3_PHASE_16A = 4UL,
      FI_EN_380_480V_TRI_PHASE_32A = 5UL,
      FI_EN_380_480V_TRI_PHASE_63A = 6UL,
      FI_EN_BATTERY_EXCHANGE = 7UL,
      FI_EN_RESERVED_1_ULTRA_FAST = 8UL,
      FI_EN_RESERVED_2_ULTRA_FAST = 9UL,
      FI_EN_100_120V_1_PHASE_8A = 10UL,
      FI_EN_100_120V_1_PHASE_10A = 11UL,
      FI_EN_100_120V_1_PHASE_12A = 12UL,
      FI_EN_100_120V_1_PHASE_16A = 13UL,
      FI_EN_200_240V_1_PHASE_8A = 14UL,
      FI_EN_200_240V_3_PHASE_16A = 15UL,
      FI_EN_200_240V_3_PHASE_32A = 16UL,
      FI_EN_DC = 17UL,
      FI_EN_UNSPECIFIED = 62UL,
      FI_EN_UNAVAILABLE  = 63UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility(midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Receptacle : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Receptacle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Receptacle& operator=(const midw_ext_fi_tcl_TCU_Receptacle& coRef);
   midw_ext_fi_tcl_TCU_Receptacle(const midw_ext_fi_tcl_TCU_Receptacle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type;
   tU16 u16Available_Power;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility;
   virtual ~midw_ext_fi_tcl_TCU_Receptacle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Receptacle& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Spot_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Spot_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Spot_List& operator=(const midw_ext_fi_tcl_TCU_Spot_List& coRef);
   midw_ext_fi_tcl_TCU_Spot_List(const midw_ext_fi_tcl_TCU_Spot_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString sCharge_Spot_ID;
   midw_ext_fi_tcl_e8_TCU_Bookable_Information e8Bookable_Information;
   midw_ext_fi_tcl_e8_TCU_Spot_Availability e8Spot_Availability;
   midw_ext_fi_tcl_TCU_Bookable_Free_Text rBookable_Free_Text;
   tU8 u8Total_Number_Receptacles;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle1;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle2;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle3;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle4;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle5;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle6;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle7;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle8;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle9;
   midw_ext_fi_tcl_TCU_Receptacle rReceptacle10;
   virtual ~midw_ext_fi_tcl_TCU_Spot_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Spot_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Charge_Spot_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Charge_Spot_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Charge_Spot_List& operator=(const midw_ext_fi_tcl_TCU_Charge_Spot_List& coRef);
   midw_ext_fi_tcl_TCU_Charge_Spot_List(const midw_ext_fi_tcl_TCU_Charge_Spot_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Total_pages_of_lists;
   tU8 u8Pages_of_list;
   tU8 u8Station_List_Number;
   midw_ext_fi_tcl_TCU_Spot_List rSpot_List1;
   midw_ext_fi_tcl_TCU_Spot_List rSpot_List2;
   midw_ext_fi_tcl_TCU_Spot_List rSpot_List3;
   midw_ext_fi_tcl_TCU_Spot_List rSpot_List4;
   virtual ~midw_ext_fi_tcl_TCU_Charge_Spot_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Charge_Spot_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Time : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Time();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Time& operator=(const midw_ext_fi_tcl_TCU_Time& coRef);
   midw_ext_fi_tcl_TCU_Time(const midw_ext_fi_tcl_TCU_Time& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Seconds;
   virtual ~midw_ext_fi_tcl_TCU_Time();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Time& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Language_Family_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Language_Family_Type();
   enum tenType {
      FI_EN_FAMILY_TYPE_1 = 0UL,
      FI_EN_FAMILY_TYPE_2 = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Language_Family_Type(midw_ext_fi_tcl_e8_Language_Family_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Language_Family_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Language_Family_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Language_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Language_Type();
   enum tenType {
      FI_EN_DEFAULT = 0UL,
      FI_EN_FRENCH_OR_SWEDE = 1UL,
      FI_EN_ENGLISH_OR_FINN = 2UL,
      FI_EN_GERMAN_OR_BULGARIAN = 3UL,
      FI_EN_SPANISH_OR_SLOVENE = 4UL,
      FI_EN_PORTUGUESE_OR_GREEK = 5UL,
      FI_EN_ITALIAN_OR_HUNGARIAN = 6UL,
      FI_EN_POLISH_OR_SLOVAK = 7UL,
      FI_EN_TURKISH_OR_TCHEQUE = 8UL,
      FI_EN_DUTCH_OR_DANE = 9UL,
      FI_EN_KOREAN_OR_ESTONIAN = 10UL,
      FI_EN_LETTONIE_OR_LITHUANIAN = 11UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Language_Type(midw_ext_fi_tcl_e8_Language_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Language_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Language_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Navigation_Language : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Navigation_Language();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Navigation_Language& operator=(const midw_ext_fi_tcl_TCU_Navigation_Language& coRef);
   midw_ext_fi_tcl_TCU_Navigation_Language(const midw_ext_fi_tcl_TCU_Navigation_Language& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Reserved;
   midw_ext_fi_tcl_e8_Language_Family_Type e8Language_Family_Type;
   midw_ext_fi_tcl_e8_Language_Type e8Language_Type;
   virtual ~midw_ext_fi_tcl_TCU_Navigation_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Navigation_Language& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Booking_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Booking_Status();
   enum tenType {
      FI_EN_BOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER = 1UL,
      FI_EN_BOOKING_REQUEST_ABORT = 2UL,
      FI_EN_BOOKING_FAILED_UNDEFINED_REASON = 3UL,
      FI_EN_BOOKING_SUCCESS = 4UL,
      FI_EN_BOOKING_IN_PROGRESS = 5UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Booking_Status(midw_ext_fi_tcl_e8_TCU_Booking_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Booking_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Booking_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Unbooking_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Unbooking_Status();
   enum tenType {
      FI_EN_UNBOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER = 1UL,
      FI_EN_UNBOOKING_REQUEST_ABORT = 2UL,
      FI_EN_UNBOOKING_FAILED_UNDEFINED_REASON = 3UL,
      FI_EN_UNBOOKING_SUCCESS = 4UL,
      FI_EN_UNBOOKING_PROGRESS = 5UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Unbooking_Status(midw_ext_fi_tcl_e8_TCU_Unbooking_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Unbooking_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Unbooking_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Update_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Update_Status();
   enum tenType {
      FI_EN_UPDATE_FAILED = 1UL,
      FI_EN_UPDATE_REQUEST_ABORT = 2UL,
      FI_EN_UPDATE_SUCCESS = 4UL,
      FI_EN_UPDATE_IN_PROGRESS = 5UL,
      FI_EN_UNAVAILABLE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Update_Status(midw_ext_fi_tcl_e8_TCU_Update_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Update_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Update_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Sch_Activation_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State();
   enum tenType {
      FI_EN_SCHEDULER_ACTIVATED = 0UL,
      FI_EN_SCHEDULER_DEACTIVATED = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Sch_Activation_State(midw_ext_fi_tcl_e8_TCU_Sch_Activation_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Sch_Activation_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Sch_Activation_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Charge_Days : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Charge_Days();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Charge_Days& operator=(const midw_ext_fi_tcl_TCU_Charge_Days& coRef);
   midw_ext_fi_tcl_TCU_Charge_Days(const midw_ext_fi_tcl_TCU_Charge_Days& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Day1;
   tU8 Day2;
   tU8 Day3;
   tU8 Day4;
   tU8 Day5;
   tU8 Day6;
   tU8 Day7;
   virtual ~midw_ext_fi_tcl_TCU_Charge_Days();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Charge_Days& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_CHARGE_AVAILABLE = 1UL,
      FI_EN_CHARGE_BLOCKED = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status(midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Charge_Blocked_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Spot_Receptacle_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Spot_Receptacle_Type();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& operator=(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& coRef);
   midw_ext_fi_tcl_TCU_Spot_Receptacle_Type(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type rDefault_receptacle_type;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_1;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_2;
   midw_ext_fi_tcl_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_3;
   tU8 u8Reserved1;
   tU8 u8Reserved2;
   tU8 u8Reserved3;
   tU8 u8Reserved4;
   virtual ~midw_ext_fi_tcl_TCU_Spot_Receptacle_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Spot_Receptacle_Type& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclIN_Data : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclIN_Data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tclIN_Data& operator=(const midw_ext_fi_tclIN_Data& coRef);
   midw_ext_fi_tclIN_Data(const midw_ext_fi_tclIN_Data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Length;
   midw_ext_fi_tclString sText;
   virtual ~midw_ext_fi_tclIN_Data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tclIN_Data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_PIN : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_PIN();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_PIN& operator=(const midw_ext_fi_tcl_TCU_PIN& coRef);
   midw_ext_fi_tcl_TCU_PIN(const midw_ext_fi_tcl_TCU_PIN& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclIN_Data rPIN_ID;
   midw_ext_fi_tclIN_Data rPIN_Password;
   virtual ~midw_ext_fi_tcl_TCU_PIN();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_PIN& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Wifi_SSID_Name : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Wifi_SSID_Name();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name& operator=(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& coRef);
   midw_ext_fi_tcl_TCU_Wifi_SSID_Name(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CharcterSet;
   tU8 u8LentghOfText;
   midw_ext_fi_tclString sText;
   virtual ~midw_ext_fi_tcl_TCU_Wifi_SSID_Name();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Wifi_SSID_Name& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Wifi_PassKey : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Wifi_PassKey();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Wifi_PassKey& operator=(const midw_ext_fi_tcl_TCU_Wifi_PassKey& coRef);
   midw_ext_fi_tcl_TCU_Wifi_PassKey(const midw_ext_fi_tcl_TCU_Wifi_PassKey& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CharcterSet;
   tU8 u8LentghOfText;
   midw_ext_fi_tclString sText;
   virtual ~midw_ext_fi_tcl_TCU_Wifi_PassKey();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Wifi_PassKey& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode();
   enum tenType {
      FI_EN_WEP = 0UL,
      FI_EN_PUBLIC = 1UL,
      FI_EN_WPA = 2UL,
      FI_EN_WPA2 = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode(midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Security_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Visibility : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility();
   enum tenType {
      FI_EN_WIFI_VISIBLE = 0UL,
      FI_EN_WIFI_NOT_VISIBLE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Visibility(midw_ext_fi_tcl_e8_TCU_Wifi_Visibility::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Visibility();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Visibility& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Status();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Mode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Mode();
   enum tenType {
      FI_EN_WIFI_UNAVAILABLE = 0UL,
      FI_EN_WIFI_CLIENT = 1UL,
      FI_EN_WIFI_HOT_SPOT_VIA_USB_KEY = 2UL,
      FI_EN_WIFI_HOT_SPOT_VIA_BLUETOOTH = 3UL,
      FI_EN_WIFI_HOT_SPOT_VIA_TCU = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Mode(midw_ext_fi_tcl_e8_TCU_Wifi_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_CONNECTED = 1UL,
      FI_EN_REJECTED = 2UL,
      FI_EN_TIME_OUT = 3UL,
      FI_EN_CONNECTION_IN_PROGRESS = 4UL,
      FI_EN_CONNECTION_LOST = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Connection_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security();
   enum tenType {
      FI_EN_OPEN = 0UL,
      FI_EN_WEP = 1UL,
      FI_EN_WPA_OR_WPA2 = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security(midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Scan_Security& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status();
   enum tenType {
      FI_EN_NOT_CONNECTED = 0UL,
      FI_EN_CONNECTED = 1UL,
      FI_EN_SCAN_IN_PROGRESS = 2UL,
      FI_EN_CONNECTION_IN_PROGRESS = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status(midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Wifi_Wifi_Client_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity();
   enum tenType {
      FI_EN_END = 0UL,
      FI_EN_START = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity(midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Audio_SourceActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Cycle : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Cycle();
   enum tenType {
      FI_EN_EVERY_DAY = 0UL,
      FI_EN_EVERY_MONDAY  = 1UL,
      FI_EN_EVERY_TUESDAY  = 2UL,
      FI_EN_EVERY_WEDNESDAY = 3UL,
      FI_EN_EVERY_THURSDAY  = 4UL,
      FI_EN_EVERY_FRIDAY = 5UL,
      FI_EN_EVERY_SATURDAY = 6UL,
      FI_EN_EVERY_SUNDAY = 7UL,
      FI_EN_FROM_START_TIME_TO_STOP_TIME  = 8UL,
      FI_EN_ALL_TIME   = 9UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Cycle(midw_ext_fi_tcl_e8_TCU_Cycle::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Cycle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Cycle& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Time_Slot : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Time_Slot();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Time_Slot& operator=(const midw_ext_fi_tcl_TCU_Time_Slot& coRef);
   midw_ext_fi_tcl_TCU_Time_Slot(const midw_ext_fi_tcl_TCU_Time_Slot& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Date_Time rStart_timeStamp;
   midw_ext_fi_tcl_TCU_Date_Time rStop_timeStamp;
   midw_ext_fi_tcl_e8_TCU_Cycle e8Cycle;
   virtual ~midw_ext_fi_tcl_TCU_Time_Slot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Time_Slot& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Coordinates : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Coordinates();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Coordinates& operator=(const midw_ext_fi_tcl_TCU_Coordinates& coRef);
   midw_ext_fi_tcl_TCU_Coordinates(const midw_ext_fi_tcl_TCU_Coordinates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_LatitudeMode e8Latitudemode;
   midw_ext_fi_tcl_e8_TCU_LongitudeMode e8LongitudeMode;
   tU8 u8LatitudeDEG;
   tU8 u8LatitudeMIN;
   tU16 u16LatitudeSEC;
   tU8 u8LongitudeDEG;
   tU8 u8LongitudeMIN;
   tU16 u16LongitudeSEC;
   tU8 u8Reserve;
   virtual ~midw_ext_fi_tcl_TCU_Coordinates();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Coordinates& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type();
   enum tenType {
      FI_EN_INCLUSION = 2UL,
      FI_EN_EXCLUSION = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type(midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Area_Form : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Area_Form();
   enum tenType {
      FI_EN_SQUARE_AREA = 2UL,
      FI_EN_CIRCLE_AREA = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Area_Form(midw_ext_fi_tcl_e8_TCU_Area_Form::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Area_Form();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Area_Form& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Area_Coordinate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Area_Coordinate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Area_Coordinate& operator=(const midw_ext_fi_tcl_TCU_Area_Coordinate& coRef);
   midw_ext_fi_tcl_TCU_Area_Coordinate(const midw_ext_fi_tcl_TCU_Area_Coordinate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TCU_Coordinates rCoordinates1;
   midw_ext_fi_tcl_TCU_Coordinates rCoordinates2;
   virtual ~midw_ext_fi_tcl_TCU_Area_Coordinate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Area_Coordinate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Area_Limit_Coordinates : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Area_Limit_Coordinates();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& operator=(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& coRef);
   midw_ext_fi_tcl_TCU_Area_Limit_Coordinates(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TCU_Restriction_Area_Type e8Restriction_Area_Type;
   midw_ext_fi_tcl_e8_TCU_Area_Form e8Area_Form;
   midw_ext_fi_tcl_e8_TCU_LocationType e8LocationType;
   midw_ext_fi_tcl_TCU_Area_Coordinate rArea_Coordinates;
   tU16 u16Radius;
   virtual ~midw_ext_fi_tcl_TCU_Area_Limit_Coordinates();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Area_Limit_Coordinates& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Restrictions_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Restrictions_State();
   enum tenType {
      FI_EN_NO_RESTRICTION = 0UL,
      FI_EN_RESTRICTIONS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Restrictions_State(midw_ext_fi_tcl_e8_TCU_Restrictions_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Restrictions_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Restrictions_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Time_Limit_Restriction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Time_Limit_Restriction();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Time_Limit_Restriction& operator=(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& coRef);
   midw_ext_fi_tcl_TCU_Time_Limit_Restriction(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_TCU_Time_Slot, std::allocator<midw_ext_fi_tcl_TCU_Time_Slot> > rTime_Slot;
   virtual ~midw_ext_fi_tcl_TCU_Time_Limit_Restriction();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Time_Limit_Restriction& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Time_Slot_State : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Time_Slot_State();
   enum tenType {
      FI_EN_ALL_TIME = 0UL,
      FI_EN_TIME_SLOT_SET = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Time_Slot_State(midw_ext_fi_tcl_e8_TCU_Time_Slot_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Time_Slot_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Time_Slot_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Speed_Limit_Restriction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Speed_Limit_Restriction();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& operator=(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& coRef);
   midw_ext_fi_tcl_TCU_Speed_Limit_Restriction(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > rLimited_Vehicle_Speed;
   std::vector<midw_ext_fi_tcl_TCU_Time_Slot, std::allocator<midw_ext_fi_tcl_TCU_Time_Slot> > rTime_Slot;
   virtual ~midw_ext_fi_tcl_TCU_Speed_Limit_Restriction();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Speed_Limit_Restriction& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Area_Limit_Restriction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Area_Limit_Restriction();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Area_Limit_Restriction& operator=(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& coRef);
   midw_ext_fi_tcl_TCU_Area_Limit_Restriction(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_TCU_Area_Limit_Coordinates, std::allocator<midw_ext_fi_tcl_TCU_Area_Limit_Coordinates> > rArea_Limit_Coordinates;
   std::vector<midw_ext_fi_tcl_TCU_Time_Slot, std::allocator<midw_ext_fi_tcl_TCU_Time_Slot> > rTime_Slot;
   virtual ~midw_ext_fi_tcl_TCU_Area_Limit_Restriction();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Area_Limit_Restriction& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_ConnectionType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_ConnectionType();
   enum tenType {
      FI_EN_INVALID_CONNECTION = 0UL,
      FI_EN_MQTT_CONNECT = 1UL,
      FI_EN_MQTT_SUBSCRIBE_ALL = 2UL,
      FI_EN_OMA_DM_LOW_PRIORITY = 3UL,
      FI_EN_OMA_DM_LOW_HIGH_PRIORITY = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_ConnectionType(midw_ext_fi_tcl_e8_TCU_ConnectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_ConnectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_ConnectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_XCALL_Type : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_XCALL_Type();
   enum tenType {
      FI_EN_BREAKDOWN_CALL = 0UL,
      FI_EN_BREAKDOWN_WITH_DIAGNOSTIC_CALL  = 1UL,
      FI_EN_CONCIERGE_CALL  = 2UL,
      FI_EN_HELP_CALL = 3UL,
      FI_EN_PANIC_CALL  = 4UL,
      FI_EN_RESERVED = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_XCALL_Type(midw_ext_fi_tcl_e8_TCU_XCALL_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_XCALL_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_XCALL_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_XCALL_Language : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_XCALL_Language();
   enum tenType {
      FI_EN_UNSUPPORTED = 255UL,
      FI_EN_VIETNAMESE = 54UL,
      FI_EN_UKRAINIAN  = 53UL,
      FI_EN_TURKISH = 52UL,
      FI_EN_THAI = 51UL,
      FI_EN_TAIWANESE = 50UL,
      FI_EN_SWEDISH = 49UL,
      FI_EN_SPANISH_MEXICAN  = 48UL,
      FI_EN_SPANISH_LATIN_AMERICAN = 47UL,
      FI_EN_SPANISH = 46UL,
      FI_EN_SLOVENIAN  = 45UL,
      FI_EN_SLOVAKIAN = 44UL,
      FI_EN_SERBIAN = 43UL,
      FI_EN_RUSSIAN = 42UL,
      FI_EN_ROMANIAN = 41UL,
      FI_EN_PORTUGUESE_BRAZILIAN = 40UL,
      FI_EN_PORTUGUESE = 39UL,
      FI_EN_POLISH = 38UL,
      FI_EN_PHILIPPINES = 37UL,
      FI_EN_PERSIAN_FARSI_IRANIAN = 36UL,
      FI_EN_NORWEGIAN = 35UL,
      FI_EN_MALAY = 34UL,
      FI_EN_LITHUANIAN = 33UL,
      FI_EN_LATVIAN = 32UL,
      FI_EN_KOREAN = 31UL,
      FI_EN_JAPANESE = 30UL,
      FI_EN_ITALIAN = 29UL,
      FI_EN_INDONESIAN = 28UL,
      FI_EN_HUNGARIAN = 27UL,
      FI_EN_HINDI = 26UL,
      FI_EN_HEBREW = 25UL,
      FI_EN_GREEK = 24UL,
      FI_EN_GERMAN = 23UL,
      FI_EN_FRENCH_CANADIAN = 22UL,
      FI_EN_FRENCH = 21UL,
      FI_EN_FLEMISH = 20UL,
      FI_EN_FINNISH = 19UL,
      FI_EN_ESTONIAN = 18UL,
      FI_EN_ENGLISH_INDIA = 17UL,
      FI_EN_ENGLISH_CANADIAN = 16UL,
      FI_EN_ENGLISH_US_FOR_PRC = 15UL,
      FI_EN_ENGLISH_US_FOR_JPN = 14UL,
      FI_EN_ENGLISH_US = 13UL,
      FI_EN_ENGLISH_UK = 12UL,
      FI_EN_ENGLISH_AUSTRALIAN = 11UL,
      FI_EN_DUTCH = 10UL,
      FI_EN_DANISH = 9UL,
      FI_EN_CZECH = 8UL,
      FI_EN_CROATIAN = 7UL,
      FI_EN_CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER = 6UL,
      FI_EN_CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER = 5UL,
      FI_EN_CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER = 4UL,
      FI_EN_BULGARIAN = 3UL,
      FI_EN_ARABIC = 2UL,
      FI_EN_ALBANESE = 1UL,
      FI_EN_UNKNOWN = 0UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_XCALL_Language(midw_ext_fi_tcl_e8_TCU_XCALL_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_XCALL_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_XCALL_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Response_Time_Out : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Response_Time_Out();
   enum tenType {
      FI_EN_SOFTWARE_VERSION = 0UL,
      FI_EN_HARDWARE_VERSION = 1UL,
      FI_EN_TCU_STATE = 2UL,
      FI_EN_PROVISION_SERVICE = 3UL,
      FI_EN_SERVICE_CALL_OPERATION = 4UL,
      FI_EN_ID_INFO = 5UL,
      FI_EN_DRIVER_INFO_UPLOAD_PERMIT_SET = 6UL,
      FI_EN_PROBE_UPLOAD_PERMIT_GET = 7UL,
      FI_EN_PROBE_UPLOAD_PERMIT_SET = 8UL,
      FI_EN_PROBE_INFO_DELETE = 9UL,
      FI_EN_PIN_SETTING = 10UL,
      FI_EN_CHARGE_REMINDER_GET = 11UL,
      FI_EN_CHARGE_REMINDER_SET = 12UL,
      FI_EN_TCU_RESET = 13UL,
      FI_EN_STATION_FINDER = 14UL,
      FI_EN_CHARGE_STATION = 15UL,
      FI_EN_CHARGE_SPOT_LIST = 16UL,
      FI_EN_SHORT_BOOKING = 17UL,
      FI_EN_SHORT_UNBOOKING = 18UL,
      FI_EN_UPDATE_ENERGY_POINT = 19UL,
      FI_EN_SCH_ACTIVATION = 20UL,
      FI_EN_SCH_ONBOARD = 21UL,
      FI_EN_SCH_STATE = 22UL,
      FI_EN_TCU_EXTENDED_STATE = 23UL,
      FI_EN_RESTRICTION_SETTING = 24UL,
      FI_EN_WIFI_HOTSPOT_REQUEST = 25UL,
      FI_EN_WIFI_ACTIVATION_REQUEST = 26UL,
      FI_EN_WIFI_DATA_RESET = 27UL,
      FI_EN_WIFI_CLIENT_SCAN_SET = 28UL,
      FI_EN_WIFI_CLIENT_CONNECTION_SET = 29UL,
      FI_EN_WIFI_CLIENT_DISCONNECTION = 30UL,
      FI_EN_XCALL = 31UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Response_Time_Out(midw_ext_fi_tcl_e8_TCU_Response_Time_Out::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Response_Time_Out();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Response_Time_Out& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TCU_Response_Time_Out : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TCU_Response_Time_Out();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TCU_Response_Time_Out& operator=(const midw_ext_fi_tcl_TCU_Response_Time_Out& coRef);
   midw_ext_fi_tcl_TCU_Response_Time_Out(const midw_ext_fi_tcl_TCU_Response_Time_Out& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_e8_TCU_Response_Time_Out, std::allocator<midw_ext_fi_tcl_e8_TCU_Response_Time_Out> > eTime_Out_Type;
   virtual ~midw_ext_fi_tcl_TCU_Response_Time_Out();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TCU_Response_Time_Out& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_Availability : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_Availability();
   enum tenType {
      FI_EN_WITHOUT_TCU = 0UL,
      FI_EN_WITH_ECALL = 1UL,
      FI_EN_WITHOUT_TCU_OR_ECALL_ONLY = 2UL,
      FI_EN_WITH_TCU = 5UL,
      FI_EN_WITHOUTTCU_OR_WITHTCU = 6UL,
      FI_EN_INVALID_VALUE = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_Availability(midw_ext_fi_tcl_e8_TCU_Availability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_Availability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_Availability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_CallType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_CallType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ACN_CALL = 1UL,
      FI_EN_ECALL = 2UL,
      FI_EN_XCALL = 3UL,
      FI_EN_INVALID = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_CallType(midw_ext_fi_tcl_e8_TCU_CallType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_CallType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_CallType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TCU_PrivacyModes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TCU_PrivacyModes();
   enum tenType {
      FI_EN_PRIVACY_MANAGER_ACTIVATED = 0UL,
      FI_EN_PRIVACY_MANAGER_DEACTIVATED = 1UL,
      FI_EN_UNKNOWN = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TCU_PrivacyModes(midw_ext_fi_tcl_e8_TCU_PrivacyModes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TCU_PrivacyModes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TCU_PrivacyModes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Data_Header_Part : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Data_Header_Part();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Data_Header_Part& operator=(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& coRef);
   midw_ext_fi_tcl_usb_tcu_Data_Header_Part(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfPOI;
   virtual ~midw_ext_fi_tcl_usb_tcu_Data_Header_Part();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Data_Header_Part& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Location : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Location();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Location& operator=(const midw_ext_fi_tcl_usb_tcu_Location& coRef);
   midw_ext_fi_tcl_usb_tcu_Location(const midw_ext_fi_tcl_usb_tcu_Location& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Direction;
   tU8 u8Reserved;
   tU8 u8Longitude_Degree;
   tU8 u8Longitude_minute;
   tU16 u16Longitude_second;
   tU8 u8Latitude_degree;
   tU8 u8Latitude_minute;
   tU16 u16Latitude_second;
   virtual ~midw_ext_fi_tcl_usb_tcu_Location();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Location& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Data_Record : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Data_Record();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Data_Record& operator=(const midw_ext_fi_tcl_usb_tcu_Data_Record& coRef);
   midw_ext_fi_tcl_usb_tcu_Data_Record(const midw_ext_fi_tcl_usb_tcu_Data_Record& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SizeOfPOIName;
   midw_ext_fi_tclString strPOIName;
   midw_ext_fi_tcl_usb_tcu_Location Location;
   tU8 u8SizeOfAddress;
   midw_ext_fi_tclString strAddress;
   tU8 u8SizeOfPhoneNumber;
   midw_ext_fi_tclString strPhoneNumber;
   tU8 u8SizeOfPhoneNumberForDisp;
   midw_ext_fi_tclString strPhoneNumberForDisp;
   tU8 u8SizeOfCategory;
   midw_ext_fi_tclString strCategory;
   virtual ~midw_ext_fi_tcl_usb_tcu_Data_Record();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Data_Record& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_connected_search_result : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_connected_search_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_connected_search_result& operator=(const midw_ext_fi_tcl_usb_tcu_connected_search_result& coRef);
   midw_ext_fi_tcl_usb_tcu_connected_search_result(const midw_ext_fi_tcl_usb_tcu_connected_search_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfPOI;
   std::vector<midw_ext_fi_tcl_usb_tcu_Data_Record, std::allocator<midw_ext_fi_tcl_usb_tcu_Data_Record> > DataRecord;
   virtual ~midw_ext_fi_tcl_usb_tcu_connected_search_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_connected_search_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_channel_master_data_header : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_channel_master_data_header();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_channel_master_data_header& operator=(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& coRef);
   midw_ext_fi_tcl_usb_tcu_channel_master_data_header(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfFolderDefInfo;
   tU16 u16NumOfChannelDefInfo;
   virtual ~midw_ext_fi_tcl_usb_tcu_channel_master_data_header();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_channel_master_data_header& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Folder_definition_information : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Folder_definition_information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Folder_definition_information& operator=(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& coRef);
   midw_ext_fi_tcl_usb_tcu_Folder_definition_information(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FolderID;
   tU16 u16SizeOfFolderDefInfo;
   tU8 u8SizeOfFolderName;
   midw_ext_fi_tclString strFolderName;
   tU8 u8FixedData1;
   tU16 u16FolderIconID;
   tU8 u8FixedData2;
   virtual ~midw_ext_fi_tcl_usb_tcu_Folder_definition_information();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Folder_definition_information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Channel_definition_information : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Channel_definition_information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Channel_definition_information& operator=(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& coRef);
   midw_ext_fi_tcl_usb_tcu_Channel_definition_information(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   tU16 u16SizeOfChannelDefInfo;
   tU8 u8SizeOfChannelName;
   midw_ext_fi_tclString strChannelName;
   tU8 u8FixedData1;
   tU16 u16FolderID;
   tU16 u16ChannelIconID;
   tU8 u8FixedData2;
   tU8 u8FixedData3;
   std::vector<tU8, std::allocator<tU8> > FixedData4;
   std::vector<tU8, std::allocator<tU8> > FixedData5;
   tU8 u8FlagOfChannelInfo;
   tU8 u8FixedData6;
   tU8 u8FixedData7;
   tU8 u8FixedData8;
   tU8 u8FixedData9;
   virtual ~midw_ext_fi_tcl_usb_tcu_Channel_definition_information();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Channel_definition_information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_channel_master_data : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_channel_master_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_channel_master_data& operator=(const midw_ext_fi_tcl_usb_tcu_channel_master_data& coRef);
   midw_ext_fi_tcl_usb_tcu_channel_master_data(const midw_ext_fi_tcl_usb_tcu_channel_master_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_usb_tcu_channel_master_data_header ChannelMasterDataHeader;
   std::vector<midw_ext_fi_tcl_usb_tcu_Folder_definition_information, std::allocator<midw_ext_fi_tcl_usb_tcu_Folder_definition_information> > FolderDefinitionInformation;
   std::vector<midw_ext_fi_tcl_usb_tcu_Channel_definition_information, std::allocator<midw_ext_fi_tcl_usb_tcu_Channel_definition_information> > ChannelDefinitionInformation;
   virtual ~midw_ext_fi_tcl_usb_tcu_channel_master_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_channel_master_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_tcu_AudioActivity : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_tcu_AudioActivity();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_PLAY = 1UL,
      FI_EN_PAUSE = 2UL,
      FI_EN_STOP = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_tcu_AudioActivity(midw_ext_fi_tcl_e8_tcu_AudioActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_tcu_AudioActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_tcu_AudioActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Channel_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Channel_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Channel_Info& operator=(const midw_ext_fi_tcl_usb_tcu_Channel_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_Channel_Info(const midw_ext_fi_tcl_usb_tcu_Channel_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   tU8 u8ChannelContentID;
   tBool u8ResumeDownload;
   virtual ~midw_ext_fi_tcl_usb_tcu_Channel_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Channel_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Channel_Info_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Channel_Info_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Channel_Info_List& operator=(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& coRef);
   midw_ext_fi_tcl_usb_tcu_Channel_Info_List(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_usb_tcu_Channel_Info, std::allocator<midw_ext_fi_tcl_usb_tcu_Channel_Info> > ChannelInfoList;
   virtual ~midw_ext_fi_tcl_usb_tcu_Channel_Info_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Channel_Info_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strNaviID;
   midw_ext_fi_tclString strSimID;
   midw_ext_fi_tclString strVinID;
   virtual ~midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString strNaviSWVersion;
   midw_ext_fi_tclString strMapVersion;
   midw_ext_fi_tclString strDcmVersion;
   midw_ext_fi_tclString strDatum;
   midw_ext_fi_tclString strLatitude;
   midw_ext_fi_tclString strLongitude;
   midw_ext_fi_tclString strLanguage;
   virtual ~midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_GroupA_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_GroupA_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_GroupA_Info& operator=(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_GroupA_Info(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_usb_tcu_GroupA_Authorization_Info GroupA_Authorization_Info;
   midw_ext_fi_tcl_usb_tcu_GroupA_BasicServices_Info GroupA_BasicServices_Info;
   virtual ~midw_ext_fi_tcl_usb_tcu_GroupA_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_GroupA_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ConnectedSearchServiceType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ConnectedSearchServiceType();
   enum tenType {
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_NONE = 0UL,
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_CONNECTED_SEARCH = 1UL,
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_ASSISTED_SEARCH_VIA_IVR = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ConnectedSearchServiceType(midw_ext_fi_tcl_e8_ConnectedSearchServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ConnectedSearchServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ConnectedSearchServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_tcu_ExecType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_tcu_ExecType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_ROUTE_CALC = 2UL,
      FI_EN_DISP_LIST = 4UL,
      FI_EN_AUTO_PLAY = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_tcu_ExecType(midw_ext_fi_tcl_e8_tcu_ExecType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_tcu_ExecType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_tcu_ExecType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DatabaseStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DatabaseStatus();
   enum tenType {
      FI_EN_DATABASE_STATUS_UNKNOWN = 0UL,
      FI_EN_DATABASE_STATUS_VERIFYING = 1UL,
      FI_EN_DATABASE_STATUS_UPDATING = 2UL,
      FI_EN_DATABASE_STATUS_READY = 3UL,
      FI_EN_DATABASE_STATUS_DISABLED = 4UL,
      FI_EN_DATABASE_STATUS_DELETING = 5UL,
      FI_EN_DATABASE_STATUS_DELETING_MSB = 6UL,
      FI_EN_DATABASE_STATUS_DELETING_IFL = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DatabaseStatus(midw_ext_fi_tcl_e8_DatabaseStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DatabaseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DatabaseStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DatabaseServiceType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DatabaseServiceType();
   enum tenType {
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_UNKNOWN = 0UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_CHANNEL_MASTER_DATA = 1UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_CHANNEL_DATA = 2UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_IN_VEHICLE_MESSAGE = 3UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_DELETE_DB = 4UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_MOBILE_INFO_SERVICE = 5UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_MY_SCHEDULE = 6UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_DELETE_MESSAGE_BOX = 7UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_INITIALIZE_FEED_LIST = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DatabaseServiceType(midw_ext_fi_tcl_e8_DatabaseServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DatabaseServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DatabaseServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_CancelRequestType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_CancelRequestType();
   enum tenType {
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_NONE = 0UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_CONNECTED_SEARCH = 1UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_VOICE_MENU = 2UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_GOOGLE_SEND_TO_CAR = 3UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_DESTINATION_SEND_TO_CAR = 4UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_JOURNEY_PLANNER = 5UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_IN_VEHICLE_MESSAGE = 6UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_SYNC_ALL_FEEDS = 7UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_MOBILE_INFO_SERVICE = 8UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_MY_SCHEDULE = 9UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_CancelRequestType(midw_ext_fi_tcl_e8_CancelRequestType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_CancelRequestType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_CancelRequestType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Server_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Server_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Server_Info& operator=(const midw_ext_fi_tcl_usb_tcu_Server_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_Server_Info(const midw_ext_fi_tcl_usb_tcu_Server_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ServerId;
   midw_ext_fi_tclString strServerName;
   midw_ext_fi_tclString strServerAddress;
   virtual ~midw_ext_fi_tcl_usb_tcu_Server_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Server_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_Server_Info_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_Server_Info_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_Server_Info_List& operator=(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& coRef);
   midw_ext_fi_tcl_usb_tcu_Server_Info_List(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_usb_tcu_Server_Info, std::allocator<midw_ext_fi_tcl_usb_tcu_Server_Info> > ServerInfoList;
   virtual ~midw_ext_fi_tcl_usb_tcu_Server_Info_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_Server_Info_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DataConnectionStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DataConnectionStatus();
   enum tenType {
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_DISCONNECTED = 0UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTING = 1UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTED_IDLE = 2UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTED_DOWNLOADING = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DataConnectionStatus(midw_ext_fi_tcl_e8_DataConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DataConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DataConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_DataDownloadStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_DataDownloadStatus();
   enum tenType {
      FI_EN_USB_TCU_DATA_DOWNLOAD_STATUS_NONE = 0UL,
      FI_EN_USB_TCU_DATA_DOWNLOAD_STATUS_ACTIVE = 1UL,
      FI_EN_USB_TCU_DATA_DOWNLOAD_STATUS_INACTIVE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_DataDownloadStatus(midw_ext_fi_tcl_e8_DataDownloadStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_DataDownloadStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_DataDownloadStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e16_DataConnectionError : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e16_DataConnectionError();
   enum tenType {
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_IDLE_OR_NOERROR = 0UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_UNKNOWN = 1UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_APN_NOSPACE = 2UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_CRC32_CHECK_FAILED = 3UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_UNPACK_FAILED = 4UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PARSING_BINARYDATA_FAILED = 5UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTP_CONNECTION_REFUSED = 6UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PPP_DISCONNECTED_ABRUPTLY = 7UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PPP_DIALING_FAILED = 8UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_NO_SERVICE = 9UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_DCM_NOT_CONNECTED = 10UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_APN_SETTING_FAILED = 11UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_CANNOT_USE_SERVICE = 12UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_ILLEGAL_REQUEST = 13UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_INVALID_DATA = 14UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_ADDITIONAL_DOWNLOAD_FAILED = 15UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_SOCKET_DISCONNECTED = 16UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PARSING_JSONDATA_FAILED = 17UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CONTINUE = 100UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SWITCHING_PROTOCOLS = 101UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PROCESSING = 102UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_OK = 200UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CREATED = 201UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_ACCEPTED = 202UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NON_AUTHORITATIVE_INFORMATION = 203UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NO_CONTENT = 204UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_RESET_CONTENT = 205UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PARTIAL_CONTENT = 206UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MULTI_STATUS = 207UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_ALREADY_REPORTED = 208UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_IM_USED = 226UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MULTIPLE_CHOICES = 300UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MOVED_PERMANENTLY = 301UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FOUND = 302UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SEE_OTHER = 303UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_MODIFIED = 304UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_USE_PROXY = 305UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_RESERVED = 306UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_TEMPORARY_REDIRECT = 307UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PERMANENT_REDIRECT = 308UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_BAD_REQUEST = 400UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNAUTHORIZED = 401UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PAYMENT_REQUIRED = 402UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FORBIDDEN = 403UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_FOUND = 404UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_METHOD_NOT_ALLOWED = 405UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_ACCEPTABLE = 406UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PROXY_AUTHENTICATION_REQUIRED = 407UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_TIMEOUT = 408UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CONFLICT = 409UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_GONE = 410UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LENGTH_REQUIRED = 411UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PRECONDITION_FAILED = 412UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_ENTITY_TOO_LARGE = 413UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_URI_TOO_LONG = 414UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNSUPPORTED_MEDIA_TYPE = 415UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUESTED_RANGE_NOT_SATISFIABLE = 416UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_EXPECTATION_FAILED = 417UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNPROCESSABLE_ENTITY = 422UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LOCKED = 423UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FAILED_DEPENDENCY = 424UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UPGRADE_REQUIRED = 426UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PRECONDITION_REQUIRED = 428UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_TOO_MANY_REQUESTS = 429UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_HEADER_FIELDS_TOO_LARGE = 431UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_INTERNAL_SERVER_ERROR = 500UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_IMPLEMENTED = 501UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_BAD_GATEWAY = 502UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SERVICE_UNAVAILABLE = 503UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_GATEWAY_TIMEOUT = 504UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_HTTP_VERSION_NOT_SUPPORTED = 505UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_VARIANT_ALSO_NEGOTIATES = 506UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_INSUFFICIENT_STORAGE = 507UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LOOP_DETECTED = 508UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_EXTENDED = 510UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NETWORK_AUTHENTICATION_REQUIRED = 511UL
   };
   tenType enType;

   midw_ext_fi_tcl_e16_DataConnectionError(midw_ext_fi_tcl_e16_DataConnectionError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e16_DataConnectionError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e16_DataConnectionError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ModemType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ModemType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_2G = 1UL,
      FI_EN_3G = 2UL,
      FI_EN_2_9G = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ModemType(midw_ext_fi_tcl_e8_ModemType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ModemType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ModemType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_usb_tcu_TCUDevice_Info : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_usb_tcu_TCUDevice_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& operator=(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& coRef);
   midw_ext_fi_tcl_usb_tcu_TCUDevice_Info(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bUSBConnectionStatus;
   midw_ext_fi_tcl_e8_ModemType eModemType;
   virtual ~midw_ext_fi_tcl_usb_tcu_TCUDevice_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_usb_tcu_TCUDevice_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_tcu_LogLevel : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_tcu_LogLevel();
   enum tenType {
      FI_EN_USB_TCU_LOG_LEVEL_DEBUG = 0UL,
      FI_EN_USB_TCU_LOG_LEVEL_FILE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_tcu_LogLevel(midw_ext_fi_tcl_e8_tcu_LogLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_tcu_LogLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_tcu_LogLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmPredefinedListIds : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmPredefinedListIds();
   enum tenType {
      FI_EN_NEAR_BY = 1UL,
      FI_EN_NEAR_DEST = 2UL,
      FI_EN_FAVORITES = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmPredefinedListIds(midw_ext_fi_tcl_e8_SxmPredefinedListIds::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmPredefinedListIds();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmPredefinedListIds& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmListType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmListType();
   enum tenType {
      FI_EN_NEAR_BY = 1UL,
      FI_EN_NEAR_DESTINATION = 2UL,
      FI_EN_FAVORITE = 3UL,
      FI_EN_LOCATION = 4UL,
      FI_EN_CUSTOM = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmListType(midw_ext_fi_tcl_e8_SxmListType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmListStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmListStatus();
   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_READY = 1UL,
      FI_EN_CHANGED = 2UL,
      FI_EN_UPDATING = 3UL,
      FI_EN_ACTIVATED = 4UL,
      FI_EN_FROZEN = 5UL,
      FI_EN_ERROR = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmListStatus(midw_ext_fi_tcl_e8_SxmListStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmListStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmListMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmListMode();
   enum tenType {
      FI_EN_RELEASE = 1UL,
      FI_EN_ACTIVATE = 2UL,
      FI_EN_PENDING_ACTIVATE = 3UL,
      FI_EN_FREEZE = 4UL,
      FI_EN_PENDING_FREEZE = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmListMode(midw_ext_fi_tcl_e8_SxmListMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmListMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmListMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmListMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmListMode();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmListMode& operator=(const midw_ext_fi_tcl_SxmListMode& coRef);
   midw_ext_fi_tcl_SxmListMode(const midw_ext_fi_tcl_SxmListMode& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListMode Mode;
   virtual ~midw_ext_fi_tcl_SxmListMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmListMode& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmListOperation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmListOperation();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_NOTIFY = 1UL,
      FI_EN_FREEZE = 2UL,
      FI_EN_PENDING_FREEZE = 3UL,
      FI_EN_FREEZE_OPT = 4UL,
      FI_EN_CONFIGURE = 5UL,
      FI_EN_GET_UPDATE = 6UL,
      FI_EN_GET = 7UL,
      FI_EN_RELEASE = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmListOperation(midw_ext_fi_tcl_e8_SxmListOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmListOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmListOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmLocation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmLocation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmLocation& operator=(const midw_ext_fi_tcl_SxmLocation& coRef);
   midw_ext_fi_tcl_SxmLocation(const midw_ext_fi_tcl_SxmLocation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Lat;
   tS32 Lon;
   tU32 Radius;
   virtual ~midw_ext_fi_tcl_SxmLocation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmLocation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmListInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmListInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmListInfo& operator=(const midw_ext_fi_tcl_SxmListInfo& coRef);
   midw_ext_fi_tcl_SxmListInfo(const midw_ext_fi_tcl_SxmListInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListType ListType;
   midw_ext_fi_tcl_e8_SxmListStatus Status;
   midw_ext_fi_tcl_e8_SxmListStatus State;
   midw_ext_fi_tcl_e8_SxmListMode Mode;
   tBool bEmpty;
   tU32 Size;
   virtual ~midw_ext_fi_tcl_SxmListInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmListInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmListsConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmListsConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmListsConfig& operator=(const midw_ext_fi_tcl_SxmListsConfig& coRef);
   midw_ext_fi_tcl_SxmListsConfig(const midw_ext_fi_tcl_SxmListsConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Capacity;
   virtual ~midw_ext_fi_tcl_SxmListsConfig();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmListsConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmListInfos : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmListInfos();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmListInfos& operator=(const midw_ext_fi_tcl_SxmListInfos& coRef);
   midw_ext_fi_tcl_SxmListInfos(const midw_ext_fi_tcl_SxmListInfos& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig GenericConfig;
   std::vector<midw_ext_fi_tcl_SxmListInfo, std::allocator<midw_ext_fi_tcl_SxmListInfo> > ListInfo;
   virtual ~midw_ext_fi_tcl_SxmListInfos();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmListInfos& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmDataServiceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmDataServiceStatus();
   enum tenType {
      FI_EN_UNKNOWN = 1UL,
      FI_EN_SUBSCRIBED = 2UL,
      FI_EN_NOT_SUBSCRIBED = 3UL,
      FI_EN_NOT_AVAILABLE = 4UL,
      FI_EN_NO_ANTENNA = 5UL,
      FI_EN_NO_SIGNAL = 6UL,
      FI_EN_SIGNAL_LOST = 7UL,
      FI_EN_HARDWARE_ERROR = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmDataServiceStatus(midw_ext_fi_tcl_e8_SxmDataServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmDataServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmDataServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmDataSrvState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmDataSrvState();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmDataSrvState& operator=(const midw_ext_fi_tcl_SxmDataSrvState& coRef);
   midw_ext_fi_tcl_SxmDataSrvState(const midw_ext_fi_tcl_SxmDataSrvState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SxmDataServiceStatus Status;
   virtual ~midw_ext_fi_tcl_SxmDataSrvState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmDataSrvState& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmDataServiceType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmDataServiceType();
   enum tenType {
      FI_EN_CHANNELART = 2UL,
      FI_EN_TRAFFIC = 3UL,
      FI_EN_MOVIES = 4UL,
      FI_EN_AGW = 5UL,
      FI_EN_TABWEATHER = 6UL,
      FI_EN_FUEL = 7UL,
      FI_EN_STOCKS = 8UL,
      FI_EN_SPORTS = 9UL,
      FI_EN_CANADIAN_FUEL = 10UL,
      FI_EN_WSALERTS = 11UL,
      FI_EN_PARKING = 12UL,
      FI_EN_PHONETICS = 13UL,
      FI_EN_SAFEVIEW = 14UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmDataServiceType(midw_ext_fi_tcl_e8_SxmDataServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmDataServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmDataServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmListElemDataSrvState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmListElemDataSrvState();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmListElemDataSrvState& operator=(const midw_ext_fi_tcl_SxmListElemDataSrvState& coRef);
   midw_ext_fi_tcl_SxmListElemDataSrvState(const midw_ext_fi_tcl_SxmListElemDataSrvState& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SxmDataServiceType Type;
   midw_ext_fi_tcl_SxmDataSrvState Status;
   virtual ~midw_ext_fi_tcl_SxmListElemDataSrvState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmListElemDataSrvState& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_RGBAcolor : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_RGBAcolor();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_RGBAcolor& operator=(const midw_ext_fi_tcl_RGBAcolor& coRef);
   midw_ext_fi_tcl_RGBAcolor(const midw_ext_fi_tcl_RGBAcolor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Red;
   tU8 Green;
   tU8 Blue;
   tU8 Alpha;
   virtual ~midw_ext_fi_tcl_RGBAcolor();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_RGBAcolor& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Graphics : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Graphics();
   enum tenType {
      FI_EN_GRAPHICS_NEEDS_NOREFRESH = 0UL,
      FI_EN_GRAPHICS_NEEDS_REFRESH = 1UL,
      FI_EN_GRAPHICS_NEEDS_DEFAULT = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Graphics(midw_ext_fi_tcl_e8_Graphics::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Graphics();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Graphics& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ChannelSkipType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ChannelSkipType();
   enum tenType {
      FI_EN_SKIP_ALL = 0UL,
      FI_EN_UNSKIP_ALL = 1UL,
      FI_EN_SKIP_SELECTION = 2UL,
      FI_EN_UNSKIP_SELECTION = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ChannelSkipType(midw_ext_fi_tcl_e8_ChannelSkipType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ChannelSkipType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ChannelSkipType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ChannelListEntry : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ChannelListEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ChannelListEntry& operator=(const midw_ext_fi_tcl_ChannelListEntry& coRef);
   midw_ext_fi_tcl_ChannelListEntry(const midw_ext_fi_tcl_ChannelListEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServiceID;
   tU16 ChannelID;
   tBool ChannelNameAvail;
   midw_ext_fi_tclString ChannelName;
   midw_ext_fi_tclString ChannelArtistName;
   midw_ext_fi_tclString ChannelSongName;
   tU8 PresetNumber;
   tBool IsLocked;
   tBool IsAvailable;
   tBool IsMature;
   tBool IsSkipped;
   midw_ext_fi_tcl_e8_Graphics ChannelGraphicAvail;
   virtual ~midw_ext_fi_tcl_ChannelListEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ChannelListEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_MethodStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_MethodStatus();
   enum tenType {
      FI_EN_XMTUN_MS_FAILURE = 0UL,
      FI_EN_XMTUN_MS_REQUEST_REJECTED = 1UL,
      FI_EN_XMTUN_MS_REQUEST_ACCEPTED = 2UL,
      FI_EN_XMTUN_MS_REQUEST_PROCESSING = 3UL,
      FI_EN_XMTUN_MS_SUCCESS = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_MethodStatus(midw_ext_fi_tcl_e8_MethodStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_MethodStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_MethodStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ErrorTypes();
   enum tenType {
      FI_EN_XMTUN_INVALID_OPCODE = 0UL,
      FI_EN_XMTUN_OPCODE_NOT_SUPPORTED = 1UL,
      FI_EN_XMTUN_UPREG_FAILURE = 2UL,
      FI_EN_XMTUN_RELUPREG_FAILURE = 3UL,
      FI_EN_XMTUN_ERROR_INVALID_PARAMETER = 4UL,
      FI_EN_XMTUN_ERROR_INTERNAL_ERROR = 5UL,
      FI_EN_XMTUN_ERROR_APPLICATION_BUSY = 6UL,
      FI_EN_XMTUN_ERROR_MODULE_NOT_POWERED_UP = 8UL,
      FI_EN_XMTUN_UNKOWN_ERROR = 254UL,
      FI_EN_XMTUN_ERROR_XM_DISABLED = 255UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ErrorTypes(midw_ext_fi_tcl_e8_ErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ChannelList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ChannelList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ChannelList& operator=(const midw_ext_fi_tcl_ChannelList& coRef);
   midw_ext_fi_tcl_ChannelList(const midw_ext_fi_tcl_ChannelList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_ChannelListEntry, std::allocator<midw_ext_fi_tcl_ChannelListEntry> > ChannelList;
   virtual ~midw_ext_fi_tcl_ChannelList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ChannelList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PresetListEntry : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PresetListEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PresetListEntry& operator=(const midw_ext_fi_tcl_PresetListEntry& coRef);
   midw_ext_fi_tcl_PresetListEntry(const midw_ext_fi_tcl_PresetListEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServiceID;
   tU16 ChannelID;
   tBool ChannelNameAvail;
   midw_ext_fi_tclString ChannelName;
   tBool ChannelActive;
   midw_ext_fi_tcl_e8_Graphics ChnGraphicAvail;
   tBool IsSmartFavorite;
   tBool IsLocked;
   tBool IsAvailable;
   tBool IsMature;
   tBool IsSkipped;
   virtual ~midw_ext_fi_tcl_PresetListEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PresetListEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CategoryListEntry : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CategoryListEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CategoryListEntry& operator=(const midw_ext_fi_tcl_CategoryListEntry& coRef);
   midw_ext_fi_tcl_CategoryListEntry(const midw_ext_fi_tcl_CategoryListEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CategoryType;
   tBool CategoryNameAvail;
   midw_ext_fi_tclString CategoryName;
   midw_ext_fi_tcl_ChannelList ChannelList;
   virtual ~midw_ext_fi_tcl_CategoryListEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CategoryListEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SelectChannelMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SelectChannelMode();
   enum tenType {
      FI_EN_XMTUN_SELECT_SID = 1UL,
      FI_EN_XMTUN_SELECT_CID = 2UL,
      FI_EN_XMTUN_SELECT_CHANNEL = 3UL,
      FI_EN_XMTUN_SELECT_CHANNEL_UP = 4UL,
      FI_EN_XMTUN_SELECT_CHANNEL_DOWN = 5UL,
      FI_EN_XMTUN_SELECT_PROGRAM_UP = 6UL,
      FI_EN_XMTUN_SELECT_PROGRAM_DOWN = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SelectChannelMode(midw_ext_fi_tcl_e8_SelectChannelMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SelectChannelMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SelectChannelMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PresetChannelList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PresetChannelList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PresetChannelList& operator=(const midw_ext_fi_tcl_PresetChannelList& coRef);
   midw_ext_fi_tcl_PresetChannelList(const midw_ext_fi_tcl_PresetChannelList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_PresetListEntry, std::allocator<midw_ext_fi_tcl_PresetListEntry> > ChannelList;
   virtual ~midw_ext_fi_tcl_PresetChannelList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PresetChannelList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ChannelInformation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ChannelInformation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ChannelInformation& operator=(const midw_ext_fi_tcl_ChannelInformation& coRef);
   midw_ext_fi_tcl_ChannelInformation(const midw_ext_fi_tcl_ChannelInformation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ChannelNumber;
   tU16 SID;
   tBool ChannelNameAvail;
   midw_ext_fi_tclString ChannelName;
   tU16 CategoryType;
   tU16 PrimaryCategoryType;
   tBool CategoryNameAvail;
   midw_ext_fi_tclString CategoryName;
   tBool ArtistSongnameAvail;
   tBool ArtistNameAvail;
   midw_ext_fi_tclString ArtistName;
   tBool SongNameAvail;
   midw_ext_fi_tclString SongName;
   tBool ExtSongNameAvail;
   midw_ext_fi_tclString ExtSongName;
   tBool ExtArtistNameAvail;
   midw_ext_fi_tclString ExtArtistName;
   tBool ChnGraphicAvail;
   midw_ext_fi_tcl_e8_Graphics ChnArtAvail;
   midw_ext_fi_tcl_e8_Graphics AlbumArtAvail;
   tBool IsLocked;
   tBool IsAvailable;
   tBool IsMature;
   tBool IsSkipped;
   tBool ArtistAlertStatus;
   tBool SongAlertStatus;
   virtual ~midw_ext_fi_tcl_ChannelInformation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ChannelInformation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SportsFlash_Sport : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SportsFlash_Sport();
   enum tenType {
      FI_EN_SPORTS_UNKNOWN = 0UL,
      FI_EN_SPORTS_FOOTBALL = 1UL,
      FI_EN_SPORTS_HOCKEY = 2UL,
      FI_EN_SPORTS_BASKETBALL = 3UL,
      FI_EN_SPORTS_BASEBALL = 4UL,
      FI_EN_SPORTS_SOCCER = 5UL,
      FI_EN_SPORTS_AUTO_RACING = 6UL,
      FI_EN_SPORTS_OTHER = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SportsFlash_Sport(midw_ext_fi_tcl_e8_SportsFlash_Sport::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SportsFlash_Sport();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SportsFlash_Sport& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SportsFlash_League : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SportsFlash_League();
   enum tenType {
      FI_EN_LEAGUE_NFL = 70UL,
      FI_EN_LEAGUE_MLB = 77UL,
      FI_EN_LEAGUE_NBA = 66UL,
      FI_EN_LEAGUE_NHL = 72UL,
      FI_EN_LEAGUE_COLLEGE_FOOTBALL = 102UL,
      FI_EN_LEAGUE_COLLEGE_BASKETBALL = 98UL,
      FI_EN_LEAGUE_WOMENS_COLLEGE_BASKETBALL = 119UL,
      FI_EN_LEAGUE_COLLEGE_OTHER = 99UL,
      FI_EN_LEAGUE_AUTORACING = 65UL,
      FI_EN_LEAGUE_SOCCER = 83UL,
      FI_EN_LEAGUE_UNKNOWN = 32UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SportsFlash_League(midw_ext_fi_tcl_e8_SportsFlash_League::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SportsFlash_League();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SportsFlash_League& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus();
   enum tenType {
      FI_EN_PROGRAM_AVAILABLE = 0UL,
      FI_EN_PROGRAM_ENDED = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus(midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus();
   enum tenType {
      FI_EN_SPORTS_FLASH_EVENT_OCCURED = 0UL,
      FI_EN_SPORTS_FLASH_EVENT_EXPIRED = 1UL,
      FI_EN_SPORTS_FLASH_EVENT_PLAYED = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus(midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SystemMessage : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SystemMessage();
   enum tenType {
      FI_EN_XMTUN_SYSTEM_MSG_NO_ERROR = 0UL,
      FI_EN_XMTUN_SYSTEM_MSG_LOADING_XM = 1UL,
      FI_EN_XMTUN_SYSTEM_MSG_CATEGORY_NOT_FOUND = 2UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_OFFAIR = 3UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_UNAVAILABLE = 4UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_UNAUTHORIZED = 5UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_MATURE = 6UL,
      FI_EN_XMTUN_SYSTEM_MSG_CHANNEL_LOCKED = 7UL,
      FI_EN_XMTUN_SYSTEM_MSG_SUBSCRIPTION_UPDATED = 8UL,
      FI_EN_XMTUN_SYSTEM_MSG_ANTENNA_DISCONNECTED = 9UL,
      FI_EN_XMTUN_SYSTEM_MSG_NO_SIGNAL = 10UL,
      FI_EN_XMTUN_SYSTEM_MSG_HARDWARE_ERROR = 11UL,
      FI_EN_XMTUN_SYSTEM_MSG_SXM_INITIALIZING = 12UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SystemMessage(midw_ext_fi_tcl_e8_SystemMessage::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SystemMessage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SystemMessage& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Sxm_AntennaState : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Sxm_AntennaState();
   enum tenType {
      FI_EN_FC_SXM_DIAG_ANT_UNSUPPORTED = 0UL,
      FI_EN_FC_SXM_DIAG_ANT_DETECTED = 1UL,
      FI_EN_FC_SXM_DIAG_ANT_NOT_DETECTED = 2UL,
      FI_EN_FC_SXM_DIAG_ANT_SHORTED = 3UL,
      FI_EN_FC_SXM_DIAG_ANT_UNKNOWN = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Sxm_AntennaState(midw_ext_fi_tcl_e8_Sxm_AntennaState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Sxm_AntennaState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Sxm_AntennaState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Sxm_SignalQuality : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Sxm_SignalQuality();
   enum tenType {
      FI_EN_FC_SXM_DIAG_SQ_NO_SIGNAL = 0UL,
      FI_EN_FC_SXM_DIAG_SQ_WEAK_SIGNAL = 1UL,
      FI_EN_FC_SXM_DIAG_SQ_GOOD_SIGNAL = 2UL,
      FI_EN_FC_SXM_DIAG_SQ_EXCELLENT_SIGNAL = 3UL,
      FI_EN_FC_SXM_DIAG_SQ_INVALID_SIGNAL = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Sxm_SignalQuality(midw_ext_fi_tcl_e8_Sxm_SignalQuality::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Sxm_SignalQuality();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Sxm_SignalQuality& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmSignalQuality : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmSignalQuality();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmSignalQuality& operator=(const midw_ext_fi_tcl_SxmSignalQuality& coRef);
   midw_ext_fi_tcl_SxmSignalQuality(const midw_ext_fi_tcl_SxmSignalQuality& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Sxm_AntennaState AntennaStatus;
   midw_ext_fi_tcl_e8_Sxm_SignalQuality SignalQualityStatus;
   virtual ~midw_ext_fi_tcl_SxmSignalQuality();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmSignalQuality& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmDetSignalQuality : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmDetSignalQuality();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmDetSignalQuality& operator=(const midw_ext_fi_tcl_SxmDetSignalQuality& coRef);
   midw_ext_fi_tcl_SxmDetSignalQuality(const midw_ext_fi_tcl_SxmDetSignalQuality& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString SigQuality;
   midw_ext_fi_tclString TunerStatus;
   midw_ext_fi_tclString ENSALockStatus;
   midw_ext_fi_tclString ENSBLockStatus;
   midw_ext_fi_tclString BerS1;
   midw_ext_fi_tclString BerS2;
   midw_ext_fi_tclString BerT;
   midw_ext_fi_tclString CtoNS1A;
   midw_ext_fi_tclString CtoNS1B;
   midw_ext_fi_tclString CtoNS2A;
   midw_ext_fi_tclString CtoNS2B;
   midw_ext_fi_tclString RSErrsWords;
   midw_ext_fi_tclString RSErrSatSymb;
   midw_ext_fi_tclString RSErrTerrSymb;
   midw_ext_fi_tclString TunerCarrFreqOfset;
   midw_ext_fi_tclString RSSI;
   virtual ~midw_ext_fi_tcl_SxmDetSignalQuality();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmDetSignalQuality& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmDetOvrlSignalQuality : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmDetOvrlSignalQuality();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmDetOvrlSignalQuality& operator=(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& coRef);
   midw_ext_fi_tcl_SxmDetOvrlSignalQuality(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString ReceiverState;
   midw_ext_fi_tclString OBerS1A;
   midw_ext_fi_tclString OBerS2A;
   midw_ext_fi_tclString OBerTA;
   midw_ext_fi_tclString OBerS1B;
   midw_ext_fi_tclString OBerS2B;
   midw_ext_fi_tclString OBerTB;
   midw_ext_fi_tclString OBERTrbWrdErRt0A;
   midw_ext_fi_tclString OBERTrbWrdErRt0B;
   midw_ext_fi_tclString OBERTrbWrdErRt1A;
   midw_ext_fi_tclString OBERTrbWrdErRt1B;
   midw_ext_fi_tclString OBERTrbWrdErRt2A;
   midw_ext_fi_tclString OBERTrbWrdErRt2B;
   virtual ~midw_ext_fi_tcl_SxmDetOvrlSignalQuality();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmDetOvrlSignalQuality& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmVersionInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmVersionInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmVersionInfo& operator=(const midw_ext_fi_tcl_SxmVersionInfo& coRef);
   midw_ext_fi_tcl_SxmVersionInfo(const midw_ext_fi_tcl_SxmVersionInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString ModuleId;
   midw_ext_fi_tclString HwRev;
   midw_ext_fi_tclString SwRev;
   midw_ext_fi_tclString SxiRev;
   midw_ext_fi_tclString BbRev;
   midw_ext_fi_tclString HDecRev;
   midw_ext_fi_tclString RFRev;
   midw_ext_fi_tclString Capability;
   midw_ext_fi_tclString SPLRev;
   virtual ~midw_ext_fi_tcl_SxmVersionInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmVersionInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmDataSubStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmDataSubStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmDataSubStatus& operator=(const midw_ext_fi_tcl_SxmDataSubStatus& coRef);
   midw_ext_fi_tcl_SxmDataSubStatus(const midw_ext_fi_tcl_SxmDataSubStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SubStatus;
   tU8 ReasonCode;
   tU32 SuspendedDate;
   virtual ~midw_ext_fi_tcl_SxmDataSubStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmDataSubStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmDiagTestModeData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmDiagTestModeData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmDiagTestModeData& operator=(const midw_ext_fi_tcl_SxmDiagTestModeData& coRef);
   midw_ext_fi_tcl_SxmDiagTestModeData(const midw_ext_fi_tcl_SxmDiagTestModeData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDetSignalQuality DetSignalQuality;
   midw_ext_fi_tcl_SxmDetOvrlSignalQuality DetOvrlSignalQuality;
   midw_ext_fi_tcl_SxmVersionInfo SxmVersionInfo;
   midw_ext_fi_tcl_SxmDataSubStatus SxmSubscriptionState;
   virtual ~midw_ext_fi_tcl_SxmDiagTestModeData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmDiagTestModeData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmSmsDbInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmSmsDbInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmSmsDbInfo& operator=(const midw_ext_fi_tcl_SxmSmsDbInfo& coRef);
   midw_ext_fi_tcl_SxmSmsDbInfo(const midw_ext_fi_tcl_SxmSmsDbInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString CgsDb;
   midw_ext_fi_tclString FuelDb;
   midw_ext_fi_tclString MovieDb;
   midw_ext_fi_tclString TabWeatherDb;
   midw_ext_fi_tclString StockDb;
   midw_ext_fi_tclString WsAlertsDb;
   midw_ext_fi_tclString SportsDB;
   midw_ext_fi_tclString ParkingDB;
   midw_ext_fi_tclString PhoneticsDB;
   midw_ext_fi_tclString FuelCanadaDB;
   midw_ext_fi_tclString SafeViewdb;
   midw_ext_fi_tclString SmsVersion;
   virtual ~midw_ext_fi_tcl_SxmSmsDbInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmSmsDbInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SxmAudioSubInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SxmAudioSubInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SxmAudioSubInfo& operator=(const midw_ext_fi_tcl_SxmAudioSubInfo& coRef);
   midw_ext_fi_tcl_SxmAudioSubInfo(const midw_ext_fi_tcl_SxmAudioSubInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SubStatus;
   virtual ~midw_ext_fi_tcl_SxmAudioSubInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SxmAudioSubInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult();
   enum tenType {
      FI_EN_NOERROR = 0UL,
      FI_EN_FILENOTFOUND = 2UL,
      FI_EN_INVALIDVERSION = 3UL,
      FI_EN_ABORTED = 4UL,
      FI_EN_BUSY = 5UL,
      FI_EN_UNKNOWNERROR = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult(midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SxmExtDiagMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SxmExtDiagMode();
   enum tenType {
      FI_EN_FC_SXM_EXTERNAL_DIAG_MODE_START = 1UL,
      FI_EN_FC_SXM_EXTERNAL_DIAG_MODE_EXIT = 0UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SxmExtDiagMode(midw_ext_fi_tcl_e8_SxmExtDiagMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SxmExtDiagMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SxmExtDiagMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SmartFavoritePreset : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SmartFavoritePreset();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SmartFavoritePreset& operator=(const midw_ext_fi_tcl_SmartFavoritePreset& coRef);
   midw_ext_fi_tcl_SmartFavoritePreset(const midw_ext_fi_tcl_SmartFavoritePreset& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetIndex;
   tBool IsSmartFavorite;
   virtual ~midw_ext_fi_tcl_SmartFavoritePreset();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SmartFavoritePreset& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SFListElement : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SFListElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SFListElement& operator=(const midw_ext_fi_tcl_SFListElement& coRef);
   midw_ext_fi_tcl_SFListElement(const midw_ext_fi_tcl_SFListElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetIndex;
   tBool IsRepeated;
   virtual ~midw_ext_fi_tcl_SFListElement();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SFListElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SFOperation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SFOperation();
   enum tenType {
      FI_EN_SXM_AUDIO_GET_SF_LIST = 0UL,
      FI_EN_SXM_AUDIO_GET_NON_SF_LIST = 1UL,
      FI_EN_SXM_AUDIO_ADD_TO_SF_LIST = 2UL,
      FI_EN_SXM_AUDIO_REMOVE_FROM_SF_LIST = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SFOperation(midw_ext_fi_tcl_e8_SFOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SFOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SFOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_IRPlaybackMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_IRPlaybackMode();
   enum tenType {
      FI_EN_SXM_AUDIO_IR_PLAY_MODE = 0UL,
      FI_EN_SXM_AUDIO_IR_PAUSE_MODE = 1UL,
      FI_EN_SXM_AUDIO_IR_SEEK_FORWARD_MODE = 2UL,
      FI_EN_SXM_AUDIO_IR_SEEK_BACKWARD_MODE = 3UL,
      FI_EN_SXM_AUDIO_IR_SKIP_FORWARD_MODE = 4UL,
      FI_EN_SXM_AUDIO_IR_SKIP_BACKWARD_MODE = 5UL,
      FI_EN_SXM_AUDIO_IR_JUMP_TO_LIVE_MODE = 6UL,
      FI_EN_SXM_AUDIO_IR_JUMP_TO_BUFFER_START = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_IRPlaybackMode(midw_ext_fi_tcl_e8_IRPlaybackMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_IRPlaybackMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_IRPlaybackMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_IRPlaybackStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_IRPlaybackStatus();
   enum tenType {
      FI_EN_SXM_AUDIO_IR_PLAY_STATE = 0UL,
      FI_EN_SXM_AUDIO_IR_PAUSE_STATE = 1UL,
      FI_EN_SXM_AUDIO_IR_SEEK_STATE = 2UL,
      FI_EN_SXM_AUDIO_IR_SKIP_STATE = 3UL,
      FI_EN_SXM_AUDIO_IR_SEEK_NA_STATE = 4UL,
      FI_EN_SXM_AUDIO_IR_SKIP_NA_STATE = 5UL,
      FI_EN_SXM_AUDIO_IR_INVALID_STATE = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_IRPlaybackStatus(midw_ext_fi_tcl_e8_IRPlaybackStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_IRPlaybackStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_IRPlaybackStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_InstantReplayStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_InstantReplayStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_InstantReplayStatus& operator=(const midw_ext_fi_tcl_InstantReplayStatus& coRef);
   midw_ext_fi_tcl_InstantReplayStatus(const midw_ext_fi_tcl_InstantReplayStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 RecordDuration;
   tU32 TimeToLive;
   tU8 PlayPercentage;
   tU8 FillPercentage;
   tU32 ElapsedTime;
   midw_ext_fi_tcl_e8_IRPlaybackStatus PlaybackStatus;
   virtual ~midw_ext_fi_tcl_InstantReplayStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_InstantReplayStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TuneScanMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TuneScanMode();
   enum tenType {
      FI_EN_SXM_AUDIO_TUNE_SCAN_START_MODE = 0UL,
      FI_EN_SXM_AUDIO_TUNE_SCAN_STOP_MODE = 1UL,
      FI_EN_SXM_AUDIO_TUNE_SCAN_SKIP_FORWARD_MODE = 2UL,
      FI_EN_SXM_AUDIO_TUNE_SCAN_SKIP_BACKWARD_MODE = 3UL,
      FI_EN_SXM_AUDIO_TUNE_SCAN_ABORT_MODE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TuneScanMode(midw_ext_fi_tcl_e8_TuneScanMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TuneScanMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TuneScanMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FavoriteType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FavoriteType();
   enum tenType {
      FI_EN_FAVORITE_ARTIST = 0UL,
      FI_EN_FAVORITE_SONG = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FavoriteType(midw_ext_fi_tcl_e8_FavoriteType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FavoriteType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FavoriteType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FavoriteStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FavoriteStatus();
   enum tenType {
      FI_EN_CONTENT_REGISTERED = 0UL,
      FI_EN_CONTENT_ALREADY_REGISTERED = 1UL,
      FI_EN_CONTENT_MAX_FAVORITES_REACHED = 2UL,
      FI_EN_CONTENT_NO_ARTIST_INFO = 3UL,
      FI_EN_CONTENT_NO_SONG_INFO = 4UL,
      FI_EN_CONTENT_NO_ARTIST_SONG_INFO = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FavoriteStatus(midw_ext_fi_tcl_e8_FavoriteStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FavoriteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FavoriteStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Action : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Action();
   enum tenType {
      FI_EN_ENABLE = 0UL,
      FI_EN_DISABLE = 1UL,
      FI_EN_DELETE = 2UL,
      FI_EN_BLOCK = 3UL,
      FI_EN_UNBLOCK = 4UL,
      FI_EN_ENABLE_ALL = 5UL,
      FI_EN_DISABLE_ALL = 6UL,
      FI_EN_DELETE_ALL = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Action(midw_ext_fi_tcl_e8_Action::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_RegisteredFavorite : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_RegisteredFavorite();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_RegisteredFavorite& operator=(const midw_ext_fi_tcl_RegisteredFavorite& coRef);
   midw_ext_fi_tcl_RegisteredFavorite(const midw_ext_fi_tcl_RegisteredFavorite& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString ContentName;
   tBool IsEnabled;
   virtual ~midw_ext_fi_tcl_RegisteredFavorite();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_RegisteredFavorite& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_ChannelStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_ChannelStatus();

   enum {
      FI_C_U8_BIT_CHANNEL_STATUS_MATURED = 0x1UL,
      FI_C_U8_BIT_CHANNEL_STATUS_LOCKED = 0x2UL,
      FI_C_U8_BIT_CHANNEL_STATUS_SKIPPED = 0x4UL,
      FI_C_U8_BIT_CHANNEL_STATUS_TUNABLE = 0x8UL,
      FI_C_U8_BIT_CHANNEL_STATUS_B4_RFU = 0x10UL,
      FI_C_U8_BIT_CHANNEL_STATUS_B5_RFU = 0x20UL,
      FI_C_U8_BIT_CHANNEL_STATUS_B6_RFU = 0x40UL,
      FI_C_U8_BIT_CHANNEL_STATUS_B7_RFU = 0x80UL
   };
   tBool bCHANNEL_STATUS_MATURED() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_MATURED) != 0; }
   tVoid vSetCHANNEL_STATUS_MATURED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_MATURED):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_MATURED)); }
   tBool bCHANNEL_STATUS_LOCKED() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_LOCKED) != 0; }
   tVoid vSetCHANNEL_STATUS_LOCKED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_LOCKED):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_LOCKED)); }
   tBool bCHANNEL_STATUS_SKIPPED() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_SKIPPED) != 0; }
   tVoid vSetCHANNEL_STATUS_SKIPPED(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_SKIPPED):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_SKIPPED)); }
   tBool bCHANNEL_STATUS_TUNABLE() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_TUNABLE) != 0; }
   tVoid vSetCHANNEL_STATUS_TUNABLE(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_TUNABLE):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_TUNABLE)); }
   tBool bCHANNEL_STATUS_B4_RFU() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_B4_RFU) != 0; }
   tVoid vSetCHANNEL_STATUS_B4_RFU(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_B4_RFU):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_B4_RFU)); }
   tBool bCHANNEL_STATUS_B5_RFU() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_B5_RFU) != 0; }
   tVoid vSetCHANNEL_STATUS_B5_RFU(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_B5_RFU):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_B5_RFU)); }
   tBool bCHANNEL_STATUS_B6_RFU() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_B6_RFU) != 0; }
   tVoid vSetCHANNEL_STATUS_B6_RFU(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_B6_RFU):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_B6_RFU)); }
   tBool bCHANNEL_STATUS_B7_RFU() const {return (u8Value & FI_C_U8_BIT_CHANNEL_STATUS_B7_RFU) != 0; }
   tVoid vSetCHANNEL_STATUS_B7_RFU(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_STATUS_B7_RFU):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_STATUS_B7_RFU)); }
   struct rBitValues {
      tBool CHANNEL_STATUS_MATURED:1;
      tBool CHANNEL_STATUS_LOCKED:1;
      tBool CHANNEL_STATUS_SKIPPED:1;
      tBool CHANNEL_STATUS_TUNABLE:1;
      tBool CHANNEL_STATUS_B4_RFU:1;
      tBool CHANNEL_STATUS_B5_RFU:1;
      tBool CHANNEL_STATUS_B6_RFU:1;
      tBool CHANNEL_STATUS_B7_RFU:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_ChannelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_ChannelStatus& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AlertInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AlertInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AlertInfo& operator=(const midw_ext_fi_tcl_AlertInfo& coRef);
   midw_ext_fi_tcl_AlertInfo(const midw_ext_fi_tcl_AlertInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServiceID;
   tU16 ChannelID;
   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   midw_ext_fi_tclString ChannelName;
   midw_ext_fi_tclString ArtistName;
   midw_ext_fi_tclString SongName;
   midw_ext_fi_tcl_e8_Graphics ChnGraphicsAvailable;
   midw_ext_fi_tcl_b8_ChannelStatus ChannelStatus;
   tBool IsExpired;
   virtual ~midw_ext_fi_tcl_AlertInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AlertInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FlashServiceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FlashServiceStatus();
   enum tenType {
      FI_EN_FLASH_SERVICE_STARTED = 0UL,
      FI_EN_FLASH_SERVICE_ALREADY_STARTED = 1UL,
      FI_EN_FLASH_SERVICE_STOPPED = 2UL,
      FI_EN_FLASH_SERVICE_ERROR = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FlashServiceStatus(midw_ext_fi_tcl_e8_FlashServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FlashServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FlashServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction();
   enum tenType {
      FI_EN_TWNOW_BULLETIN_ACTION_PLAY = 0UL,
      FI_EN_TWNOW_BULLETIN_ACTION_ABORT = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction(midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TWNow_Bulletin_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TWNow_Bulletin_Status();
   enum tenType {
      FI_EN_TWNOW_NO_BULLETIN_AVAILABLE = 0UL,
      FI_EN_TWNOW_NEW_BULLETIN_AVAILABLE = 1UL,
      FI_EN_TWNOW_PLAYED_BULLETIN_AVAILABLE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TWNow_Bulletin_Status(midw_ext_fi_tcl_e8_TWNow_Bulletin_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TWNow_Bulletin_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TWNow_Bulletin_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MarketListEntry : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MarketListEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MarketListEntry& operator=(const midw_ext_fi_tcl_MarketListEntry& coRef);
   midw_ext_fi_tcl_MarketListEntry(const midw_ext_fi_tcl_MarketListEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString AbbrMarketName;
   midw_ext_fi_tclString FullMarketName;
   tBool bIsActiveMarket;
   virtual ~midw_ext_fi_tcl_MarketListEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MarketListEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MarketList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MarketList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MarketList& operator=(const midw_ext_fi_tcl_MarketList& coRef);
   midw_ext_fi_tcl_MarketList(const midw_ext_fi_tcl_MarketList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_MarketListEntry, std::allocator<midw_ext_fi_tcl_MarketListEntry> > Market;
   virtual ~midw_ext_fi_tcl_MarketList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MarketList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_FavoriteTeam : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_FavoriteTeam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_FavoriteTeam& operator=(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& coRef);
   midw_ext_fi_tcl_SportsFlash_FavoriteTeam(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_Sport SportType;
   tU8 LeagueID;
   midw_ext_fi_tcl_e8_SportsFlash_League LeagueType;
   midw_ext_fi_tclString LeagueAbbrName;
   midw_ext_fi_tclString LeagueFullName;
   tU16 TeamID;
   midw_ext_fi_tclString TeamName;
   midw_ext_fi_tclString TeamNickName;
   midw_ext_fi_tclString TeamAbbrName;
   midw_ext_fi_tclString TeamFullName;
   tBool IsFavorite;
   tBool IsMonitored;
   virtual ~midw_ext_fi_tcl_SportsFlash_FavoriteTeam();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_FavoriteTeam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_Game : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_Game();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_Game& operator=(const midw_ext_fi_tcl_SportsFlash_Game& coRef);
   midw_ext_fi_tcl_SportsFlash_Game(const midw_ext_fi_tcl_SportsFlash_Game& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ChannelID;
   tU16 ServiceID;
   tBool IsLocked;
   tBool IsMature;
   tBool IsSkipped;
   tU16 Bias;
   midw_ext_fi_tcl_SportsFlash_FavoriteTeam HomeTeam;
   midw_ext_fi_tcl_SportsFlash_FavoriteTeam AwayTeam;
   midw_ext_fi_tcl_e8_Graphics ChnGraphicsAvailable;
   virtual ~midw_ext_fi_tcl_SportsFlash_Game();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_Game& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_FlashEvent : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_FlashEvent();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_FlashEvent& operator=(const midw_ext_fi_tcl_SportsFlash_FlashEvent& coRef);
   midw_ext_fi_tcl_SportsFlash_FlashEvent(const midw_ext_fi_tcl_SportsFlash_FlashEvent& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SportsFlash_Game GameInfo;
   tU32 FlashEventID;
   virtual ~midw_ext_fi_tcl_SportsFlash_FlashEvent();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_FlashEvent& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_League : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_League();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_League& operator=(const midw_ext_fi_tcl_SportsFlash_League& coRef);
   midw_ext_fi_tcl_SportsFlash_League(const midw_ext_fi_tcl_SportsFlash_League& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_Sport SportType;
   tU8 LeagueID;
   midw_ext_fi_tcl_e8_SportsFlash_League LeagueType;
   midw_ext_fi_tclString LeagueAbbrName;
   midw_ext_fi_tclString LeagueFullName;
   virtual ~midw_ext_fi_tcl_SportsFlash_League();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_League& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_Team : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_Team();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_Team& operator=(const midw_ext_fi_tcl_SportsFlash_Team& coRef);
   midw_ext_fi_tcl_SportsFlash_Team(const midw_ext_fi_tcl_SportsFlash_Team& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TeamID;
   midw_ext_fi_tclString TeamName;
   midw_ext_fi_tclString TeamNickName;
   midw_ext_fi_tclString TeamAbbrName;
   midw_ext_fi_tclString TeamFullName;
   tBool IsFavorite;
   virtual ~midw_ext_fi_tcl_SportsFlash_Team();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_Team& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TuneScanStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TuneScanStatus();
   enum tenType {
      FI_EN_TUNE_SCAN_NA = 0UL,
      FI_EN_TUNE_SCAN_AVAILABLE = 1UL,
      FI_EN_TUNE_SCAN_ABORTED = 2UL,
      FI_EN_TUNE_SCAN_STOPPED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TuneScanStatus(midw_ext_fi_tcl_e8_TuneScanStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TuneScanStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TuneScanStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsFlash_MonitorTeam : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsFlash_MonitorTeam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportsFlash_MonitorTeam& operator=(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& coRef);
   midw_ext_fi_tcl_SportsFlash_MonitorTeam(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LeagueID;
   tU16 TeamID;
   tBool Status;
   virtual ~midw_ext_fi_tcl_SportsFlash_MonitorTeam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportsFlash_MonitorTeam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FlashEventPlaybackStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FlashEventPlaybackStatus();
   enum tenType {
      FI_EN_FLASHEVENT_PLAYING = 0UL,
      FI_EN_FLASHEVENT_STOPPED = 1UL,
      FI_EN_FLASHEVENT_UNKNOWN = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FlashEventPlaybackStatus(midw_ext_fi_tcl_e8_FlashEventPlaybackStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FlashEventPlaybackStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FlashEventPlaybackStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_BrowseDirection : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_BrowseDirection();
   enum tenType {
      FI_EN_BROWSE_UP = 0UL,
      FI_EN_BROWSE_DOWN = 1UL,
      FI_EN_BROWSE_INVALID = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_BrowseDirection(midw_ext_fi_tcl_e8_BrowseDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_BrowseDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_BrowseDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_BrowseRateConfiguration : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_BrowseRateConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_BrowseRateConfiguration& operator=(const midw_ext_fi_tcl_BrowseRateConfiguration& coRef);
   midw_ext_fi_tcl_BrowseRateConfiguration(const midw_ext_fi_tcl_BrowseRateConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 duration;
   tU16 rate;
   virtual ~midw_ext_fi_tcl_BrowseRateConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_BrowseRateConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_BrowseChannelLoop : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_BrowseChannelLoop();
   enum tenType {
      FI_EN_LOOP_AROUND = 0UL,
      FI_EN_NO_LOOP_AROUND = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_BrowseChannelLoop(midw_ext_fi_tcl_e8_BrowseChannelLoop::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_BrowseChannelLoop();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_BrowseChannelLoop& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_BrowseChannelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_BrowseChannelType();
   enum tenType {
      FI_EN_BROWSETYPE_ALL_CHANNELS = 0UL,
      FI_EN_BROWSETYPE_CATEGORY_CHANNELS = 1UL,
      FI_EN_BROWSETYPE_INVALID = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_BrowseChannelType(midw_ext_fi_tcl_e8_BrowseChannelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_BrowseChannelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_BrowseChannelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_BrowseChannelConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_BrowseChannelConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_BrowseChannelConfig& operator=(const midw_ext_fi_tcl_BrowseChannelConfig& coRef);
   midw_ext_fi_tcl_BrowseChannelConfig(const midw_ext_fi_tcl_BrowseChannelConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_BrowseRateConfiguration, std::allocator<midw_ext_fi_tcl_BrowseRateConfiguration> > Configuration;
   midw_ext_fi_tcl_e8_BrowseChannelLoop Loop;
   midw_ext_fi_tcl_e8_BrowseChannelType Type;
   virtual ~midw_ext_fi_tcl_BrowseChannelConfig();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_BrowseChannelConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b16_CHANNEL_EVENT : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b16_CHANNEL_EVENT();

   enum {
      FI_C_U16_BIT_CHANNEL_EVENT_SERVICE_ID = 0x1UL,
      FI_C_U16_BIT_CHANNEL_EVENT_CHANNEL_ID = 0x2UL,
      FI_C_U16_BIT_CHANNEL_EVENT_ATTRIBUTES = 0x4UL,
      FI_C_U16_BIT_CHANNEL_EVENT_NAME = 0x8UL,
      FI_C_U16_BIT_CHANNEL_EVENT_CATEGORY = 0x10UL,
      FI_C_U16_BIT_CHANNEL_EVENT_TITLE = 0x20UL,
      FI_C_U16_BIT_CHANNEL_EVENT_ARTIST = 0x40UL,
      FI_C_U16_BIT_CHANNEL_EVENT_ALBUM = 0x80UL,
      FI_C_U16_BIT_CHANNEL_EVENT_ART = 0x100UL,
      FI_C_U16_BIT_CHANNEL_EVENT_REMOVED = 0x200UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B10_RESERVED = 0x400UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B11_RESERVED = 0x800UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B12_RESERVED = 0x1000UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B13_RESERVED = 0x2000UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B14_RESERVED = 0x4000UL,
      FI_C_U16_BIT_CHANNEL_EVENT_B15_RESERVED = 0x8000UL
   };
   tBool bCHANNEL_EVENT_SERVICE_ID() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_SERVICE_ID) != 0; }
   tVoid vSetCHANNEL_EVENT_SERVICE_ID(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_SERVICE_ID):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_SERVICE_ID)); }
   tBool bCHANNEL_EVENT_CHANNEL_ID() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_CHANNEL_ID) != 0; }
   tVoid vSetCHANNEL_EVENT_CHANNEL_ID(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_CHANNEL_ID):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_CHANNEL_ID)); }
   tBool bCHANNEL_EVENT_ATTRIBUTES() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_ATTRIBUTES) != 0; }
   tVoid vSetCHANNEL_EVENT_ATTRIBUTES(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_ATTRIBUTES):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_ATTRIBUTES)); }
   tBool bCHANNEL_EVENT_NAME() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_NAME) != 0; }
   tVoid vSetCHANNEL_EVENT_NAME(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_NAME):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_NAME)); }
   tBool bCHANNEL_EVENT_CATEGORY() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_CATEGORY) != 0; }
   tVoid vSetCHANNEL_EVENT_CATEGORY(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_CATEGORY):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_CATEGORY)); }
   tBool bCHANNEL_EVENT_TITLE() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_TITLE) != 0; }
   tVoid vSetCHANNEL_EVENT_TITLE(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_TITLE):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_TITLE)); }
   tBool bCHANNEL_EVENT_ARTIST() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_ARTIST) != 0; }
   tVoid vSetCHANNEL_EVENT_ARTIST(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_ARTIST):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_ARTIST)); }
   tBool bCHANNEL_EVENT_ALBUM() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_ALBUM) != 0; }
   tVoid vSetCHANNEL_EVENT_ALBUM(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_ALBUM):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_ALBUM)); }
   tBool bCHANNEL_EVENT_ART() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_ART) != 0; }
   tVoid vSetCHANNEL_EVENT_ART(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_ART):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_ART)); }
   tBool bCHANNEL_EVENT_REMOVED() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_REMOVED) != 0; }
   tVoid vSetCHANNEL_EVENT_REMOVED(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_REMOVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_REMOVED)); }
   tBool bCHANNEL_EVENT_b10_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B10_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b10_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B10_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B10_RESERVED)); }
   tBool bCHANNEL_EVENT_b11_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B11_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b11_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B11_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B11_RESERVED)); }
   tBool bCHANNEL_EVENT_b12_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B12_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b12_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B12_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B12_RESERVED)); }
   tBool bCHANNEL_EVENT_b13_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B13_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b13_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B13_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B13_RESERVED)); }
   tBool bCHANNEL_EVENT_b14_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B14_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b14_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B14_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B14_RESERVED)); }
   tBool bCHANNEL_EVENT_b15_reserved() const {return (u16Value & FI_C_U16_BIT_CHANNEL_EVENT_B15_RESERVED) != 0; }
   tVoid vSetCHANNEL_EVENT_b15_reserved(tBool bSetBit) { u16Value = (tU16)((bSetBit)?(u16Value | FI_C_U16_BIT_CHANNEL_EVENT_B15_RESERVED):(u16Value & ~(tU16)FI_C_U16_BIT_CHANNEL_EVENT_B15_RESERVED)); }
   struct rBitValues {
      tBool CHANNEL_EVENT_SERVICE_ID:1;
      tBool CHANNEL_EVENT_CHANNEL_ID:1;
      tBool CHANNEL_EVENT_ATTRIBUTES:1;
      tBool CHANNEL_EVENT_NAME:1;
      tBool CHANNEL_EVENT_CATEGORY:1;
      tBool CHANNEL_EVENT_TITLE:1;
      tBool CHANNEL_EVENT_ARTIST:1;
      tBool CHANNEL_EVENT_ALBUM:1;
      tBool CHANNEL_EVENT_ART:1;
      tBool CHANNEL_EVENT_REMOVED:1;
      tBool CHANNEL_EVENT_b10_reserved:1;
      tBool CHANNEL_EVENT_b11_reserved:1;
      tBool CHANNEL_EVENT_b12_reserved:1;
      tBool CHANNEL_EVENT_b13_reserved:1;
      tBool CHANNEL_EVENT_b14_reserved:1;
      tBool CHANNEL_EVENT_b15_reserved:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b16_CHANNEL_EVENT();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b16_CHANNEL_EVENT& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_LocalTimeDate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_LocalTimeDate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_LocalTimeDate& operator=(const midw_ext_fi_tcl_LocalTimeDate& coRef);
   midw_ext_fi_tcl_LocalTimeDate(const midw_ext_fi_tcl_LocalTimeDate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hours;
   tU8 u8Minutes;
   tU8 u8Seconds;
   tU8 u8Weekday;
   virtual ~midw_ext_fi_tcl_LocalTimeDate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_LocalTimeDate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PresetEntry : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PresetEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PresetEntry& operator=(const midw_ext_fi_tcl_PresetEntry& coRef);
   midw_ext_fi_tcl_PresetEntry(const midw_ext_fi_tcl_PresetEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Index;
   tU16 SID;
   virtual ~midw_ext_fi_tcl_PresetEntry();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PresetEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Status();
   enum tenType {
      FI_EN_FAILED = 0UL,
      FI_EN_SUCCESS = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_Status(midw_ext_fi_tcl_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ProfileStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ProfileStatus();
   enum tenType {
      FI_EN_IDLE = 0UL,
      FI_EN_PREPARE = 1UL,
      FI_EN_CHANGED = 2UL,
      FI_EN_RESET = 3UL,
      FI_EN_DOWNLOAD = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_ProfileStatus(midw_ext_fi_tcl_ProfileStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_ProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_ProfileStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ProfileAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ProfileAction();
   enum tenType {
      FI_EN_ACTIVEPROFILE = 0UL,
      FI_EN_DATACHANGE = 1UL,
      FI_EN_COPYPROFILE = 2UL,
      FI_EN_DELETEPROFILE = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_ProfileAction(midw_ext_fi_tcl_ProfileAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_ProfileAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_ProfileAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ProfileResponse : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ProfileResponse();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ProfileResponse& operator=(const midw_ext_fi_tcl_ProfileResponse& coRef);
   midw_ext_fi_tcl_ProfileResponse(const midw_ext_fi_tcl_ProfileResponse& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_Status Status;
   midw_ext_fi_tcl_ProfileAction ProfileAction;
   midw_ext_fi_tcl_ProfileStatus ProfileStatus;
   virtual ~midw_ext_fi_tcl_ProfileResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ProfileResponse& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PresetsConfiguration : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PresetsConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PresetsConfiguration& operator=(const midw_ext_fi_tcl_PresetsConfiguration& coRef);
   midw_ext_fi_tcl_PresetsConfiguration(const midw_ext_fi_tcl_PresetsConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BandCount;
   tU8 BandCapacity;
   virtual ~midw_ext_fi_tcl_PresetsConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PresetsConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8ChannelArtErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8ChannelArtErrorTypes();
   enum tenType {
      FI_EN_CHANNELART_SERVICE_ERROR = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8ChannelArtErrorTypes(midw_ext_fi_tcl_e8ChannelArtErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8ChannelArtErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8ChannelArtErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ChnGraphicsTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ChnGraphicsTypes();
   enum tenType {
      FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_NONE = 0UL,
      FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_LOGO = 1UL,
      FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_SECONDARY_LOGO = 2UL,
      FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_BACKGROUND = 4UL,
      FI_EN_CHANNEL_ART_AVAILABLE_IMAGE_ALBUM = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ChnGraphicsTypes(midw_ext_fi_tcl_e8_ChnGraphicsTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ChnGraphicsTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ChnGraphicsTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ImageData : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ImageData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ImageData& operator=(const midw_ext_fi_tcl_ImageData& coRef);
   midw_ext_fi_tcl_ImageData(const midw_ext_fi_tcl_ImageData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SID;
   std::vector<tU8, std::allocator<tU8> > ImageData;
   tU32 ImageDataSize;
   virtual ~midw_ext_fi_tcl_ImageData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ImageData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FuelTypeEnum : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FuelTypeEnum();
   enum tenType {
      FI_EN_FUEL_TYPE_REGULAR = 0UL,
      FI_EN_FUEL_TYPE_MIDRANGE = 1UL,
      FI_EN_FUEL_TYPE_PREMIUM = 2UL,
      FI_EN_FUEL_TYPE_DIESEL = 3UL,
      FI_EN_FUEL_TYPE_ELECTRIC_L1_120V = 4UL,
      FI_EN_FUEL_TYPE_ELECTRIC_L2_240V = 5UL,
      FI_EN_FUEL_TYPE_ELECTRIC_DC = 6UL,
      FI_EN_FUEL_TYPE_UNKNOWN = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FuelTypeEnum(midw_ext_fi_tcl_e8_FuelTypeEnum::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FuelTypeEnum();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FuelTypeEnum& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FuelStationAmenity : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FuelStationAmenity();
   enum tenType {
      FI_EN_FUEL_STATION_AMENITY_OPEN_24HR = 0UL,
      FI_EN_FUEL_STATION_AMENITY_EMERGENCY_ROAD_SERVICE = 1UL,
      FI_EN_FUEL_STATION_AMENITY_FULL_SERVICE = 2UL,
      FI_EN_FUEL_STATION_AMENITY_OIL_CHANGE = 3UL,
      FI_EN_FUEL_STATION_AMENITY_INTERSTATE_ACCESS_UNDER_HALF_MILE = 4UL,
      FI_EN_FUEL_STATION_AMENITY_INTERSTATE_ACCESS_OVER_HALF_MILE = 5UL,
      FI_EN_FUEL_STATION_AMENITY_CASH_DISCOUNT = 6UL,
      FI_EN_FUEL_STATION_AMENITY_COVENIENCE_STORE = 7UL,
      FI_EN_FUEL_STATION_AMENITY_SUPERMARKET = 8UL,
      FI_EN_FUEL_STATION_AMENITY_SNACKS_FAST_FOOD = 9UL,
      FI_EN_FUEL_STATION_AMENITY_RESTAURANT = 10UL,
      FI_EN_FUEL_STATION_AMENITY_TRUCK_STOP = 11UL,
      FI_EN_FUEL_STATION_AMENITY_TRUCK_STOP_WITH_HOTEL = 12UL,
      FI_EN_FUEL_STATION_AMENITY_AFFILIATED_NETWORK_CARDS_ACCEPTED = 13UL,
      FI_EN_FUEL_STATION_AMENITY_ALL_NETWORK_CARDS_ACCEPTED = 14UL,
      FI_EN_FUEL_STATION_AMENITY_CREDIT_DEBIT = 15UL,
      FI_EN_FUEL_STATION_AMENITY_PUBLIC_ACCESS = 16UL,
      FI_EN_FUEL_STATION_AMENITY_PATRONS_ONLY = 17UL,
      FI_EN_FUEL_STATION_AMENITY_CASH_ACCEPTED = 18UL,
      FI_EN_FUEL_STATION_AMENITY_RESERVATIONS = 19UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FuelStationAmenity(midw_ext_fi_tcl_e8_FuelStationAmenity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FuelStationAmenity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FuelStationAmenity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SortType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SortType();
   enum tenType {
      FI_EN_FUEL_SORT_BY_NONE = 1UL,
      FI_EN_FUEL_SORT_BY_PRICE = 2UL,
      FI_EN_FUEL_SORT_BY_DISTANCE = 3UL,
      FI_EN_FUEL_SORT_BY_BRANDNAME = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SortType(midw_ext_fi_tcl_e8_SortType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SortType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SortType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelInfo& operator=(const midw_ext_fi_tcl_FuelInfo& coRef);
   midw_ext_fi_tcl_FuelInfo(const midw_ext_fi_tcl_FuelInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StationName;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tcl_e8_FuelTypeEnum FuelType;
   tU32 Fuel_LOCID;
   midw_ext_fi_tclString FuelName;
   midw_ext_fi_tclString FuelPrice;
   tU8 FuelAge;
   midw_ext_fi_tcl_SxmLocation FuelLoc;
   tF32 FuelDistKm;
   tF32 FuelDistMile;
   tU32 NumPrices;
   virtual ~midw_ext_fi_tcl_FuelInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelTypeInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelTypeInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelTypeInfo& operator=(const midw_ext_fi_tcl_FuelTypeInfo& coRef);
   midw_ext_fi_tcl_FuelTypeInfo(const midw_ext_fi_tcl_FuelTypeInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FuelTypeEnum FuelType;
   midw_ext_fi_tclString FuelName;
   virtual ~midw_ext_fi_tcl_FuelTypeInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelTypeInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8FuelErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8FuelErrorTypes();
   enum tenType {
      FI_EN_FUEL_INFOLIST_EMPTY = 1UL,
      FI_EN_FUEL_STATION_UNAVAILABLE = 2UL,
      FI_EN_FUEL_FAVLIST_EMPTY = 3UL,
      FI_EN_FUEL_BRAND_UNAVAILABLE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8FuelErrorTypes(midw_ext_fi_tcl_e8FuelErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8FuelErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8FuelErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelTypeInfolist : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelTypeInfolist();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelTypeInfolist& operator=(const midw_ext_fi_tcl_FuelTypeInfolist& coRef);
   midw_ext_fi_tcl_FuelTypeInfolist(const midw_ext_fi_tcl_FuelTypeInfolist& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString FuelName;
   midw_ext_fi_tclString FuelPrice;
   tU8 FuelAge;
   tBool FuelAvail;
   midw_ext_fi_tcl_e8_FuelTypeEnum FuelType;
   virtual ~midw_ext_fi_tcl_FuelTypeInfolist();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelTypeInfolist& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelStationInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelStationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelStationInfo& operator=(const midw_ext_fi_tcl_FuelStationInfo& coRef);
   midw_ext_fi_tcl_FuelStationInfo(const midw_ext_fi_tcl_FuelStationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StationName;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tclString StreetName;
   midw_ext_fi_tclString City;
   midw_ext_fi_tclString State;
   midw_ext_fi_tclString ZipCode;
   midw_ext_fi_tclString Phone;
   tU32 Fuel_LOCID;
   midw_ext_fi_tclString Amenity;
   tBool FuelFavInfo;
   midw_ext_fi_tcl_SxmLocation FuelLocation;
   std::vector<midw_ext_fi_tcl_FuelTypeInfolist, std::allocator<midw_ext_fi_tcl_FuelTypeInfolist> > FuelTypelist;
   std::vector<midw_ext_fi_tcl_e8_FuelStationAmenity, std::allocator<midw_ext_fi_tcl_e8_FuelStationAmenity> > StationAmenitylist;
   tU32 NumPrices;
   virtual ~midw_ext_fi_tcl_FuelStationInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelStationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelInfoList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelInfoList& operator=(const midw_ext_fi_tcl_FuelInfoList& coRef);
   midw_ext_fi_tcl_FuelInfoList(const midw_ext_fi_tcl_FuelInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_FuelInfo, std::allocator<midw_ext_fi_tcl_FuelInfo> > FuelInfolist;
   virtual ~midw_ext_fi_tcl_FuelInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_BrandNameList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_BrandNameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_BrandNameList& operator=(const midw_ext_fi_tcl_BrandNameList& coRef);
   midw_ext_fi_tcl_BrandNameList(const midw_ext_fi_tcl_BrandNameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > BrandNameList;
   virtual ~midw_ext_fi_tcl_BrandNameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_BrandNameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FuelTypeList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FuelTypeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FuelTypeList& operator=(const midw_ext_fi_tcl_FuelTypeList& coRef);
   midw_ext_fi_tcl_FuelTypeList(const midw_ext_fi_tcl_FuelTypeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_FuelTypeInfo, std::allocator<midw_ext_fi_tcl_FuelTypeInfo> > TypeNameList;
   virtual ~midw_ext_fi_tcl_FuelTypeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FuelTypeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TheatreAmenities : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TheatreAmenities();
   enum tenType {
      FI_EN_THEATRE_AMENITIES_STADIUM_SEATING = 0UL,
      FI_EN_THEATRE_AMENITIES_STADIUM_ROCKER_SEATING = 1UL,
      FI_EN_THEATRE_AMENITIES_NUM_AMENITIES = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TheatreAmenities(midw_ext_fi_tcl_e8_TheatreAmenities::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TheatreAmenities();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TheatreAmenities& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TheatreInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TheatreInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TheatreInfo& operator=(const midw_ext_fi_tcl_TheatreInfo& coRef);
   midw_ext_fi_tcl_TheatreInfo(const midw_ext_fi_tcl_TheatreInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Theater_LOCID;
   midw_ext_fi_tclString TheatreName;
   midw_ext_fi_tclString TheaterCity;
   tF32 Distance;
   midw_ext_fi_tcl_SxmLocation TheaterLocation;
   virtual ~midw_ext_fi_tcl_TheatreInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TheatreInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MovieInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MovieInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MovieInfo& operator=(const midw_ext_fi_tcl_MovieInfo& coRef);
   midw_ext_fi_tcl_MovieInfo(const midw_ext_fi_tcl_MovieInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MOVIE_ID;
   midw_ext_fi_tclString MovieName;
   midw_ext_fi_tclString MovieRating;
   virtual ~midw_ext_fi_tcl_MovieInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MovieInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TheatreDetails : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TheatreDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TheatreDetails& operator=(const midw_ext_fi_tcl_TheatreDetails& coRef);
   midw_ext_fi_tcl_TheatreDetails(const midw_ext_fi_tcl_TheatreDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Theater_LOCID;
   midw_ext_fi_tclString TheatreName;
   midw_ext_fi_tclString TheatreStreetNum;
   midw_ext_fi_tclString TheatreStreetName;
   midw_ext_fi_tclString TheatreCity;
   midw_ext_fi_tclString TheatreState;
   midw_ext_fi_tclString TheatreZip;
   midw_ext_fi_tclString TheatrePhone;
   tBool isTheaterFavorite;
   midw_ext_fi_tcl_SxmLocation TheaterLocation;
   std::vector<midw_ext_fi_tcl_e8_TheatreAmenities, std::allocator<midw_ext_fi_tcl_e8_TheatreAmenities> > TheaterAmenities;
   virtual ~midw_ext_fi_tcl_TheatreDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TheatreDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ShowDate : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ShowDate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ShowDate& operator=(const midw_ext_fi_tcl_ShowDate& coRef);
   midw_ext_fi_tcl_ShowDate(const midw_ext_fi_tcl_ShowDate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Date;
   tU16 Month;
   tU32 Year;
   virtual ~midw_ext_fi_tcl_ShowDate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ShowDate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TheatreInfoList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TheatreInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TheatreInfoList& operator=(const midw_ext_fi_tcl_TheatreInfoList& coRef);
   midw_ext_fi_tcl_TheatreInfoList(const midw_ext_fi_tcl_TheatreInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_TheatreInfo, std::allocator<midw_ext_fi_tcl_TheatreInfo> > TheatreInfolist;
   virtual ~midw_ext_fi_tcl_TheatreInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TheatreInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MoviesList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MoviesList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MoviesList& operator=(const midw_ext_fi_tcl_MoviesList& coRef);
   midw_ext_fi_tcl_MoviesList(const midw_ext_fi_tcl_MoviesList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_MovieInfo, std::allocator<midw_ext_fi_tcl_MovieInfo> > MoviesList;
   virtual ~midw_ext_fi_tcl_MoviesList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MoviesList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ShowTimes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ShowTimes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ShowTimes& operator=(const midw_ext_fi_tcl_ShowTimes& coRef);
   midw_ext_fi_tcl_ShowTimes(const midw_ext_fi_tcl_ShowTimes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Hour;
   tU16 Minutes;
   virtual ~midw_ext_fi_tcl_ShowTimes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ShowTimes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MovieTimes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MovieTimes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MovieTimes& operator=(const midw_ext_fi_tcl_MovieTimes& coRef);
   midw_ext_fi_tcl_MovieTimes(const midw_ext_fi_tcl_MovieTimes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ShowDate ShowDate;
   std::vector<midw_ext_fi_tcl_ShowTimes, std::allocator<midw_ext_fi_tcl_ShowTimes> > ShowTimes;
   virtual ~midw_ext_fi_tcl_MovieTimes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MovieTimes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MovieTimesList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MovieTimesList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MovieTimesList& operator=(const midw_ext_fi_tcl_MovieTimesList& coRef);
   midw_ext_fi_tcl_MovieTimesList(const midw_ext_fi_tcl_MovieTimesList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_MovieTimes, std::allocator<midw_ext_fi_tcl_MovieTimes> > MovieTimes;
   virtual ~midw_ext_fi_tcl_MovieTimesList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MovieTimesList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MovieDetails : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MovieDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MovieDetails& operator=(const midw_ext_fi_tcl_MovieDetails& coRef);
   midw_ext_fi_tcl_MovieDetails(const midw_ext_fi_tcl_MovieDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MOVIE_ID;
   midw_ext_fi_tclString MovieName;
   midw_ext_fi_tclString MovieRating;
   midw_ext_fi_tclString sMovieLength;
   midw_ext_fi_tclString MovieActors;
   midw_ext_fi_tclString MovieSummury;
   midw_ext_fi_tcl_MovieTimesList MovieTimesList;
   virtual ~midw_ext_fi_tcl_MovieDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MovieDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8MovieErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8MovieErrorTypes();
   enum tenType {
      FI_EN_UNAVAILABLE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8MovieErrorTypes(midw_ext_fi_tcl_e8MovieErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8MovieErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8MovieErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportInfo& operator=(const midw_ext_fi_tcl_SportInfo& coRef);
   midw_ext_fi_tcl_SportInfo(const midw_ext_fi_tcl_SportInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   midw_ext_fi_tclString SportName;
   virtual ~midw_ext_fi_tcl_SportInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SportList& operator=(const midw_ext_fi_tcl_SportList& coRef);
   midw_ext_fi_tcl_SportList(const midw_ext_fi_tcl_SportList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportInfo, std::allocator<midw_ext_fi_tcl_SportInfo> > SportList;
   virtual ~midw_ext_fi_tcl_SportList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SportList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Game_Status : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Game_Status();
   enum tenType {
      FI_EN_GAME_STATUS_SCHEDULED = 0UL,
      FI_EN_GAME_STATUS_PRE_GAME = 1UL,
      FI_EN_GAME_STATUS_IN_PROGRESS = 2UL,
      FI_EN_GAME_STATUS_FINAL = 3UL,
      FI_EN_GAME_STATUS_DELAYED = 4UL,
      FI_EN_GAME_STATUS_SUSPENDED = 5UL,
      FI_EN_GAME_STATUS_ABANDONED = 6UL,
      FI_EN_GAME_STATUS_CANCELLED = 7UL,
      FI_EN_GAME_STATUS_UNKNOWN = 8UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Game_Status(midw_ext_fi_tcl_e8_Game_Status::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Game_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Game_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AffiliateInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AffiliateInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AffiliateInfo& operator=(const midw_ext_fi_tcl_AffiliateInfo& coRef);
   midw_ext_fi_tcl_AffiliateInfo(const midw_ext_fi_tcl_AffiliateInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 AFFILIATE_ID;
   midw_ext_fi_tclString AffiliateName;
   tBool InSeason;
   virtual ~midw_ext_fi_tcl_AffiliateInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AffiliateInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_RootAffiliateList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_RootAffiliateList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_RootAffiliateList& operator=(const midw_ext_fi_tcl_RootAffiliateList& coRef);
   midw_ext_fi_tcl_RootAffiliateList(const midw_ext_fi_tcl_RootAffiliateList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   std::vector<midw_ext_fi_tcl_AffiliateInfo, std::allocator<midw_ext_fi_tcl_AffiliateInfo> > RootAffiliateList;
   virtual ~midw_ext_fi_tcl_RootAffiliateList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_RootAffiliateList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AffiliateCategories : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AffiliateCategories();
   enum tenType {
      FI_EN_NEWS = 0UL,
      FI_EN_ALLTEAMS = 1UL,
      FI_EN_RECENT = 2UL,
      FI_EN_TODAY = 3UL,
      FI_EN_FUTURE = 4UL,
      FI_EN_TOPTEAMS = 5UL,
      FI_EN_SUBLEAGUES = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_AffiliateCategories(midw_ext_fi_tcl_AffiliateCategories::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_AffiliateCategories();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_AffiliateCategories& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SubLeagues : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SubLeagues();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SubLeagues& operator=(const midw_ext_fi_tcl_SubLeagues& coRef);
   midw_ext_fi_tcl_SubLeagues(const midw_ext_fi_tcl_SubLeagues& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SUB_LEAGUE_ID;
   midw_ext_fi_tclString SUB_LEAGUE_NAME;
   virtual ~midw_ext_fi_tcl_SubLeagues();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SubLeagues& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8CategoryAvailability : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8CategoryAvailability();
   enum tenType {
      FI_EN_NOT_AVAILABLE = 0UL,
      FI_EN_AVAILABLE = 1UL,
      FI_EN_NOT_APPLICABLE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8CategoryAvailability(midw_ext_fi_tcl_e8CategoryAvailability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8CategoryAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8CategoryAvailability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TimeInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TimeInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TimeInfo& operator=(const midw_ext_fi_tcl_TimeInfo& coRef);
   midw_ext_fi_tcl_TimeInfo(const midw_ext_fi_tcl_TimeInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Date;
   midw_ext_fi_tclString Time;
   virtual ~midw_ext_fi_tcl_TimeInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TimeInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_XMChannelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_XMChannelType();
   enum tenType {
      FI_EN_HOME = 0UL,
      FI_EN_AWAY = 1UL,
      FI_EN_NATIONAL = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_XMChannelType(midw_ext_fi_tcl_XMChannelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_XMChannelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_XMChannelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_XMChannel : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_XMChannel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_XMChannel& operator=(const midw_ext_fi_tcl_XMChannel& coRef);
   midw_ext_fi_tcl_XMChannel(const midw_ext_fi_tcl_XMChannel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ChannelNumber;
   midw_ext_fi_tcl_XMChannelType ChannelType;
   virtual ~midw_ext_fi_tcl_XMChannel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_XMChannel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Details : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Details();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Details& operator=(const midw_ext_fi_tcl_Details& coRef);
   midw_ext_fi_tcl_Details(const midw_ext_fi_tcl_Details& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Label;
   midw_ext_fi_tclString Value;
   virtual ~midw_ext_fi_tcl_Details();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Details& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TeamInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TeamInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TeamInfo& operator=(const midw_ext_fi_tcl_TeamInfo& coRef);
   midw_ext_fi_tcl_TeamInfo(const midw_ext_fi_tcl_TeamInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Team_ID;
   midw_ext_fi_tclString Team_Name;
   tU32 Team_Score;
   midw_ext_fi_tclString Team_Abbr_Name;
   midw_ext_fi_tclString Team_Known_Name;
   midw_ext_fi_tclString Team_Nick_Name;
   tBool bIsFavorite;
   virtual ~midw_ext_fi_tcl_TeamInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TeamInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_GameType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_GameType();
   enum tenType {
      FI_EN_CURRENT = 0UL,
      FI_EN_RECENT = 1UL,
      FI_EN_FUTURE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_GameType(midw_ext_fi_tcl_GameType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_GameType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_GameType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_GameInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_GameInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_GameInfo& operator=(const midw_ext_fi_tcl_GameInfo& coRef);
   midw_ext_fi_tcl_GameInfo(const midw_ext_fi_tcl_GameInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TeamInfo Home_Team_Info;
   midw_ext_fi_tcl_TeamInfo Visiting_Team_Info;
   midw_ext_fi_tcl_TimeInfo Game_Time;
   midw_ext_fi_tclString Game_Status;
   tU32 Game_Clock;
   tU32 Winning_Team_ID;
   midw_ext_fi_tcl_e8_Game_Status EventState;
   std::vector<midw_ext_fi_tcl_XMChannel, std::allocator<midw_ext_fi_tcl_XMChannel> > XMChannelList;
   tU32 Game_ID;
   virtual ~midw_ext_fi_tcl_GameInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_GameInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AvailableGames : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AvailableGames();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AvailableGames& operator=(const midw_ext_fi_tcl_AvailableGames& coRef);
   midw_ext_fi_tcl_AvailableGames(const midw_ext_fi_tcl_AvailableGames& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_GameType GameType;
   tBool IsAvailable;
   virtual ~midw_ext_fi_tcl_AvailableGames();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AvailableGames& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TeamList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TeamList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TeamList& operator=(const midw_ext_fi_tcl_TeamList& coRef);
   midw_ext_fi_tcl_TeamList(const midw_ext_fi_tcl_TeamList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   tU32 AFFILIATE_ID;
   std::vector<midw_ext_fi_tcl_TeamInfo, std::allocator<midw_ext_fi_tcl_TeamInfo> > TeamDetails;
   virtual ~midw_ext_fi_tcl_TeamList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TeamList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AllTeams : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AllTeams();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AllTeams& operator=(const midw_ext_fi_tcl_AllTeams& coRef);
   midw_ext_fi_tcl_AllTeams(const midw_ext_fi_tcl_AllTeams& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   tU32 AFFILIATE_ID;
   std::vector<midw_ext_fi_tcl_TeamInfo, std::allocator<midw_ext_fi_tcl_TeamInfo> > TeamDetails;
   virtual ~midw_ext_fi_tcl_AllTeams();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AllTeams& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_GameList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_GameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_GameList& operator=(const midw_ext_fi_tcl_GameList& coRef);
   midw_ext_fi_tcl_GameList(const midw_ext_fi_tcl_GameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   midw_ext_fi_tcl_AffiliateInfo AFFILIATE_INFO;
   tBool bIsRecentGamesAvl;
   tBool bIsCurrentGamesAvl;
   tBool bIsFutureGamesAvl;
   tBool bIsFavorite;
   midw_ext_fi_tcl_GameType GameType;
   tU32 ListIndex;
   std::vector<midw_ext_fi_tcl_GameInfo, std::allocator<midw_ext_fi_tcl_GameInfo> > GameInfo;
   virtual ~midw_ext_fi_tcl_GameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_GameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FavoriteInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FavoriteInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FavoriteInfo& operator=(const midw_ext_fi_tcl_FavoriteInfo& coRef);
   midw_ext_fi_tcl_FavoriteInfo(const midw_ext_fi_tcl_FavoriteInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   tU32 AFFILIATE_ID;
   tU32 Team_ID;
   midw_ext_fi_tclString Team_Name;
   midw_ext_fi_tclString Team_Abbr_Name;
   midw_ext_fi_tclString Team_Known_Name;
   midw_ext_fi_tclString Team_Nick_Name;
   midw_ext_fi_tclString Sport_Name;
   virtual ~midw_ext_fi_tcl_FavoriteInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FavoriteInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FavoriteList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FavoriteList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FavoriteList& operator=(const midw_ext_fi_tcl_FavoriteList& coRef);
   midw_ext_fi_tcl_FavoriteList(const midw_ext_fi_tcl_FavoriteList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_FavoriteInfo, std::allocator<midw_ext_fi_tcl_FavoriteInfo> > FavoriteInfo;
   virtual ~midw_ext_fi_tcl_FavoriteList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FavoriteList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AffiliateDetailInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AffiliateDetailInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AffiliateDetailInfo& operator=(const midw_ext_fi_tcl_AffiliateDetailInfo& coRef);
   midw_ext_fi_tcl_AffiliateDetailInfo(const midw_ext_fi_tcl_AffiliateDetailInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_AffiliateCategories Category_ID;
   midw_ext_fi_tcl_e8CategoryAvailability isDataAvailable;
   midw_ext_fi_tcl_AffiliateInfo SUB_LEAGUE_INFO;
   virtual ~midw_ext_fi_tcl_AffiliateDetailInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AffiliateDetailInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SportsUpdateType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SportsUpdateType();
   enum tenType {
      FI_EN_TODAY = 0UL,
      FI_EN_RECENT = 1UL,
      FI_EN_FUTURE = 2UL,
      FI_EN_NEWS = 3UL,
      FI_EN_UNKNOWN = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_SportsUpdateType(midw_ext_fi_tcl_SportsUpdateType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_SportsUpdateType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_SportsUpdateType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AffiliateDetails : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AffiliateDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AffiliateDetails& operator=(const midw_ext_fi_tcl_AffiliateDetails& coRef);
   midw_ext_fi_tcl_AffiliateDetails(const midw_ext_fi_tcl_AffiliateDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   tU32 AFFILIATE_ID;
   std::vector<midw_ext_fi_tcl_AffiliateDetailInfo, std::allocator<midw_ext_fi_tcl_AffiliateDetailInfo> > AffiliateDetails;
   virtual ~midw_ext_fi_tcl_AffiliateDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AffiliateDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8SportsErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8SportsErrorTypes();
   enum tenType {
      FI_EN_UNAVAILABLE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8SportsErrorTypes(midw_ext_fi_tcl_e8SportsErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8SportsErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8SportsErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_EventSchedule : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_EventSchedule();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_EventSchedule& operator=(const midw_ext_fi_tcl_EventSchedule& coRef);
   midw_ext_fi_tcl_EventSchedule(const midw_ext_fi_tcl_EventSchedule& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Tourney_Race;
   midw_ext_fi_tcl_e8_Game_Status EventState;
   midw_ext_fi_tclString Course_Track;
   midw_ext_fi_tcl_TimeInfo Game_Time;
   std::vector<midw_ext_fi_tcl_XMChannel, std::allocator<midw_ext_fi_tcl_XMChannel> > XMChannelList;
   tU32 Purse_Laps;
   midw_ext_fi_tclString Winner;
   midw_ext_fi_tclString CarNumber;
   midw_ext_fi_tclString CarMake;
   tU32 Yardage_Lap;
   tBool IsRankListAvl;
   tS32 TableParam;
   tS32 TableRef;
   tU32 Event_ID;
   virtual ~midw_ext_fi_tcl_EventSchedule();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_EventSchedule& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_EventSchedule_List : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_EventSchedule_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_EventSchedule_List& operator=(const midw_ext_fi_tcl_EventSchedule_List& coRef);
   midw_ext_fi_tcl_EventSchedule_List(const midw_ext_fi_tcl_EventSchedule_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   midw_ext_fi_tcl_AffiliateInfo AFFILIATE_INFO;
   tBool bIsRecentEventsAvl;
   tBool bIsCurrentEventsAvl;
   tBool bIsFutureEventsAvl;
   tU32 ListIndex;
   midw_ext_fi_tcl_GameType EventType;
   std::vector<midw_ext_fi_tcl_EventSchedule, std::allocator<midw_ext_fi_tcl_EventSchedule> > Eventlist;
   virtual ~midw_ext_fi_tcl_EventSchedule_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_EventSchedule_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_EventRank : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_EventRank();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_EventRank& operator=(const midw_ext_fi_tcl_EventRank& coRef);
   midw_ext_fi_tcl_EventRank(const midw_ext_fi_tcl_EventRank& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Rank;
   midw_ext_fi_tclString Name;
   tU32 Laps;
   midw_ext_fi_tclString Score_Make;
   midw_ext_fi_tclString Number;
   virtual ~midw_ext_fi_tcl_EventRank();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_EventRank& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_EventRankList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_EventRankList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_EventRankList& operator=(const midw_ext_fi_tcl_EventRankList& coRef);
   midw_ext_fi_tcl_EventRankList(const midw_ext_fi_tcl_EventRankList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SPORT_ID;
   tU32 AFFILIATE_ID;
   std::vector<midw_ext_fi_tcl_EventRank, std::allocator<midw_ext_fi_tcl_EventRank> > RankList;
   virtual ~midw_ext_fi_tcl_EventRankList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_EventRankList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_NewsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_NewsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_NewsInfo& operator=(const midw_ext_fi_tcl_NewsInfo& coRef);
   midw_ext_fi_tcl_NewsInfo(const midw_ext_fi_tcl_NewsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString NewsInDetail;
   virtual ~midw_ext_fi_tcl_NewsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_NewsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_NewsList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_NewsList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_NewsList& operator=(const midw_ext_fi_tcl_NewsList& coRef);
   midw_ext_fi_tcl_NewsList(const midw_ext_fi_tcl_NewsList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_NewsInfo, std::allocator<midw_ext_fi_tcl_NewsInfo> > NewsList;
   virtual ~midw_ext_fi_tcl_NewsList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_NewsList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8SportsServiceDataStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8SportsServiceDataStatus();
   enum tenType {
      FI_EN_SPORTS_SERVICE_DATA_INITIAL = 0UL,
      FI_EN_SPORTS_SERVICE_DATA_UPDATING = 1UL,
      FI_EN_SPORTS_SERVICE_DATA_UPDATED = 2UL,
      FI_EN_SPORTS_SERVICE_DATA_RELOAD = 3UL,
      FI_EN_SPORTS_SERVICE_DATA_STOPPED = 4UL,
      FI_EN_SPORTS_SERVICE_DATA_ERROR = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8SportsServiceDataStatus(midw_ext_fi_tcl_e8SportsServiceDataStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8SportsServiceDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8SportsServiceDataStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_ForecastType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_ForecastType();
   enum tenType {
      FI_EN_WEATHER_FORECAST_TYPE_CURRENT = 0UL,
      FI_EN_WEATHER_FORECAST_TYPE_0_3_HOUR = 1UL,
      FI_EN_WEATHER_FORECAST_TYPE_3_6_HOUR = 2UL,
      FI_EN_WEATHER_FORECAST_TYPE_SUNDAY = 3UL,
      FI_EN_WEATHER_FORECAST_TYPE_MONDAY = 4UL,
      FI_EN_WEATHER_FORECAST_TYPE_TUESDAY = 5UL,
      FI_EN_WEATHER_FORECAST_TYPE_WEDNESDAY = 6UL,
      FI_EN_WEATHER_FORECAST_TYPE_THURSDAY = 7UL,
      FI_EN_WEATHER_FORECAST_TYPE_FRIDAY = 8UL,
      FI_EN_WEATHER_FORECAST_TYPE_SATURDAY = 9UL,
      FI_EN_WEATHER_FORECAST_TYPE_MAX = 10UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_ForecastType(midw_ext_fi_tcl_e8_ForecastType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_ForecastType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_ForecastType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PollenLevelType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PollenLevelType();
   enum tenType {
      FI_EN_WEATHER_AIR_POLLEN_LEVEL_LOW = 0UL,
      FI_EN_WEATHER_AIR_POLLEN_LEVEL_MODERATE = 1UL,
      FI_EN_WEATHER_AIR_POLLEN_LEVEL_HIGH = 2UL,
      FI_EN_WEATHER_AIR_POLLEN_LEVEL_INVALID = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PollenLevelType(midw_ext_fi_tcl_e8_PollenLevelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PollenLevelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PollenLevelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_AirQualityType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_AirQualityType();
   enum tenType {
      FI_EN_WEATHER_AIR_QUALITY_GOOD = 0UL,
      FI_EN_WEATHER_AIR_QUALITY_MODERATE = 1UL,
      FI_EN_WEATHER_AIR_QUALITY_UNHEALTHYFORSENS = 2UL,
      FI_EN_WEATHER_AIR_QUALITY_UNHEALTHY = 3UL,
      FI_EN_WEATHER_AIR_QUALITY_VERYUNHEALTHY = 4UL,
      FI_EN_WEATHER_AIR_QUALITY_DANGEROUS = 5UL,
      FI_EN_WEATHER_AIR_QUALITY_NO_DATA = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_AirQualityType(midw_ext_fi_tcl_e8_AirQualityType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_AirQualityType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_AirQualityType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_CloudCoverType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_CloudCoverType();
   enum tenType {
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_CLEAR = 0UL,
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_FEW = 1UL,
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_SCATTERED = 2UL,
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_BROKEN = 3UL,
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_OVERCAST = 4UL,
      FI_EN_WEATHER_FORECAST_CLOUD_COVER_NO_DATA = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_CloudCoverType(midw_ext_fi_tcl_e8_CloudCoverType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_CloudCoverType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_CloudCoverType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WeatherInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WeatherInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WeatherInfo& operator=(const midw_ext_fi_tcl_WeatherInfo& coRef);
   midw_ext_fi_tcl_WeatherInfo(const midw_ext_fi_tcl_WeatherInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_ForecastType WeatherForecastType;
   tU8 EventCode;
   midw_ext_fi_tclString EventDescription;
   tU32 TabWeather_LOCID;
   midw_ext_fi_tclString WeatherStationName;
   midw_ext_fi_tclString WeatherStateName;
   tS16 CurrentTemperature;
   tS16 TemperatureHigh;
   tS16 TemperatureLow;
   tU8 PrecipitationChance;
   tF32 PrecipitationAmountRangeLow;
   tF32 PrecipitationAmountRangeHigh;
   tU8 WindSpeed;
   tU16 WindDirection;
   tU8 HumidityRangeLow;
   tU8 HumidityRangeHigh;
   tU8 UV_InfoRangeLow;
   tU8 UV_InfoRangeHigh;
   midw_ext_fi_tcl_e8_PollenLevelType PollenLevel;
   midw_ext_fi_tcl_e8_AirQualityType AirQuality;
   midw_ext_fi_tcl_e8_CloudCoverType CloudCover;
   tU32 ForecastTimeStamp;
   virtual ~midw_ext_fi_tcl_WeatherInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WeatherInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WeatherInfoList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WeatherInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WeatherInfoList& operator=(const midw_ext_fi_tcl_WeatherInfoList& coRef);
   midw_ext_fi_tcl_WeatherInfoList(const midw_ext_fi_tcl_WeatherInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_WeatherInfo, std::allocator<midw_ext_fi_tcl_WeatherInfo> > WeatherInfolist;
   virtual ~midw_ext_fi_tcl_WeatherInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WeatherInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_TabWeather_ErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_TabWeather_ErrorTypes();
   enum tenType {
      FI_EN_WEATHER_OBJECT_INVALID = 0UL,
      FI_EN_DEVICE_POSITION_WITHIN_LIMIT = 1UL,
      FI_EN_WEATHER_INFO_UNAVAILABLE = 2UL,
      FI_EN_FAVORITES_SETTING_FAILED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_TabWeather_ErrorTypes(midw_ext_fi_tcl_e8_TabWeather_ErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_TabWeather_ErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_TabWeather_ErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SXMTileType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SXMTileType();
   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_SXMTILETYPENOWRAD = 1UL,
      FI_EN_SXMTILETYPEWINDMAGNITUDE = 2UL,
      FI_EN_SXMTILETYPEWINDDIRECTION = 3UL,
      FI_EN_SXMTILETYPEWIND = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SXMTileType(midw_ext_fi_tcl_e8_SXMTileType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SXMTileType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SXMTileType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SXMShapeType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SXMShapeType();
   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_SXMSHAPETYPEFRONT = 1UL,
      FI_EN_T_SXMSHAPETYPEPRESSURECENTER = 2UL,
      FI_EN_T_SXMSHAPETYPEISOBAR = 3UL,
      FI_EN_T_SXMSHAPETYPESTORMPOSITION = 4UL,
      FI_EN_T_SXMSHAPETYPEWINDRADIUS = 5UL,
      FI_EN_T_SXMSHAPETYPESTORMATTRIBUTES = 6UL,
      FI_EN_T_SXMSHAPETYPESTORMTRACK = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SXMShapeType(midw_ext_fi_tcl_e8_SXMShapeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SXMShapeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SXMShapeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SXMTileDataType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SXMTileDataType();
   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_IMAGEPNG = 1UL,
      FI_EN_RAWDATA = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SXMTileDataType(midw_ext_fi_tcl_e8_SXMTileDataType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SXMTileDataType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SXMTileDataType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMSharedMemoryDescription : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMSharedMemoryDescription();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMSharedMemoryDescription& operator=(const midw_ext_fi_tcl_SXMSharedMemoryDescription& coRef);
   midw_ext_fi_tcl_SXMSharedMemoryDescription(const midw_ext_fi_tcl_SXMSharedMemoryDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SXMTileType TileType;
   midw_ext_fi_tcl_e8_SXMTileDataType TileDataType;
   midw_ext_fi_tclString SharedMemoryName;
   tU32 SharedMemorySize;
   midw_ext_fi_tcl_s32_MilliSecond Timeout;
   virtual ~midw_ext_fi_tcl_SXMSharedMemoryDescription();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMSharedMemoryDescription& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMSharedMemoryTile : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMSharedMemoryTile();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMSharedMemoryTile& operator=(const midw_ext_fi_tcl_SXMSharedMemoryTile& coRef);
   midw_ext_fi_tcl_SXMSharedMemoryTile(const midw_ext_fi_tcl_SXMSharedMemoryTile& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tcl_PositionWGS84 UpperLeftCorner;
   midw_ext_fi_tcl_PositionWGS84 LowerRightCorner;
   tU32 Width;
   tU32 Height;
   tS32 PixelValueOffset;
   tS32 PixelValuePrecision;
   tU32 AddressOffset;
   tU32 TileSize;
   virtual ~midw_ext_fi_tcl_SXMSharedMemoryTile();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMSharedMemoryTile& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShape : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShape();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShape& operator=(const midw_ext_fi_tcl_SXMShape& coRef);
   midw_ext_fi_tcl_SXMShape(const midw_ext_fi_tcl_SXMShape& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SXMShapeType ShapeTypeType;
   fi_tclTypeBase* poShapeTypeData;
   virtual ~midw_ext_fi_tcl_SXMShape();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShape& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_FrontType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_FrontType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_COLDFRONT = 1UL,
      FI_EN_WARMFRONT = 2UL,
      FI_EN_STATIONARYFRONT = 3UL,
      FI_EN_OCCLUDEDFRONT = 4UL,
      FI_EN_TROUGH = 5UL,
      FI_EN_SQUALLLINE = 6UL,
      FI_EN_DRYLINE = 7UL,
      FI_EN_DISSIPATINGCOLDFRONT = 8UL,
      FI_EN_DISSIPATINGWARMFRONT = 9UL,
      FI_EN_DISSIPATINGSTATIONARYFRONT = 10UL,
      FI_EN_DISSIPATINGOCCLUDEDFRONT = 11UL,
      FI_EN_FORMINGCOLDFRONT = 12UL,
      FI_EN_FORMINGWARMFRONT = 13UL,
      FI_EN_FORMINGSTATIONARYFRONT = 14UL,
      FI_EN_FORMINGOCCLUDEDFRONT = 15UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_FrontType(midw_ext_fi_tcl_e8_FrontType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_FrontType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_FrontType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_PressureType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_PressureType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HIGHPRESSURE = 1UL,
      FI_EN_LOWPRESSURE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_PressureType(midw_ext_fi_tcl_e8_PressureType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_PressureType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_PressureType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeIsobar : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeIsobar();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeIsobar& operator=(const midw_ext_fi_tcl_SXMShapeTypeIsobar& coRef);
   midw_ext_fi_tcl_SXMShapeTypeIsobar(const midw_ext_fi_tcl_SXMShapeTypeIsobar& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tcl_s32_Pascal Pressure;
   std::vector<midw_ext_fi_tcl_PositionWGS84, std::allocator<midw_ext_fi_tcl_PositionWGS84> > GeoPoints;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeIsobar();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeIsobar& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeWindRadius : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeWindRadius();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeWindRadius& operator=(const midw_ext_fi_tcl_SXMShapeTypeWindRadius& coRef);
   midw_ext_fi_tcl_SXMShapeTypeWindRadius(const midw_ext_fi_tcl_SXMShapeTypeWindRadius& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tclString StormUniqueId;
   tU16 SequenceId;
   midw_ext_fi_tcl_s16_Knot WindSpeed;
   std::vector<midw_ext_fi_tcl_PositionWGS84, std::allocator<midw_ext_fi_tcl_PositionWGS84> > GeoPoints;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeWindRadius();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeWindRadius& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_StormPositionType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_StormPositionType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HISTORIC = 1UL,
      FI_EN_CURRENT = 2UL,
      FI_EN_FORECAST = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_StormPositionType(midw_ext_fi_tcl_e8_StormPositionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_StormPositionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_StormPositionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_StormType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_StormType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_TROPICALDISTURBANCE = 1UL,
      FI_EN_HURRICANECAT1 = 2UL,
      FI_EN_HURRICANECAT2 = 3UL,
      FI_EN_HURRICANECAT3 = 4UL,
      FI_EN_HURRICANECAT4 = 5UL,
      FI_EN_HURRICANECAT5 = 6UL,
      FI_EN_TROPICALSTORM = 7UL,
      FI_EN_TROPICALDEPRESSION = 8UL,
      FI_EN_TYPHOON = 9UL,
      FI_EN_SUPERTYPHOON = 10UL,
      FI_EN_TROPICALCYCLONE = 11UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_StormType(midw_ext_fi_tcl_e8_StormType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_StormType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_StormType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_b8_StormType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_b8_StormType();

   enum {
      FI_C_U8_BIT_HAILPROBABLE = 0x1UL,
      FI_C_U8_BIT_HAILPOSITIVE = 0x2UL,
      FI_C_U8_BIT_MESOCYCLONIC = 0x4UL,
      FI_C_U8_BIT_TORNADIC = 0x8UL
   };
   tBool bHailProbable() const {return (u8Value & FI_C_U8_BIT_HAILPROBABLE) != 0; }
   tVoid vSetHailProbable(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HAILPROBABLE):(u8Value & ~(tU8)FI_C_U8_BIT_HAILPROBABLE)); }
   tBool bHailPositive() const {return (u8Value & FI_C_U8_BIT_HAILPOSITIVE) != 0; }
   tVoid vSetHailPositive(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HAILPOSITIVE):(u8Value & ~(tU8)FI_C_U8_BIT_HAILPOSITIVE)); }
   tBool bMesocyclonic() const {return (u8Value & FI_C_U8_BIT_MESOCYCLONIC) != 0; }
   tVoid vSetMesocyclonic(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MESOCYCLONIC):(u8Value & ~(tU8)FI_C_U8_BIT_MESOCYCLONIC)); }
   tBool bTornadic() const {return (u8Value & FI_C_U8_BIT_TORNADIC) != 0; }
   tVoid vSetTornadic(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_TORNADIC):(u8Value & ~(tU8)FI_C_U8_BIT_TORNADIC)); }
   struct rBitValues {
      tBool HailProbable:1;
      tBool HailPositive:1;
      tBool Mesocyclonic:1;
      tBool Tornadic:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~midw_ext_fi_tcl_b8_StormType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_b8_StormType& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeStormAttributes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeStormAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeStormAttributes& operator=(const midw_ext_fi_tcl_SXMShapeTypeStormAttributes& coRef);
   midw_ext_fi_tcl_SXMShapeTypeStormAttributes(const midw_ext_fi_tcl_SXMShapeTypeStormAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tclString StormUniqueId;
   midw_ext_fi_tcl_POSIXTime ObservationTime;
   midw_ext_fi_tcl_s32_Foot EchoTopHeight;
   midw_ext_fi_tcl_s16_Degree MovementDirection;
   midw_ext_fi_tcl_s16_Knot MovementSpeed;
   midw_ext_fi_tcl_b8_StormType StormType;
   midw_ext_fi_tcl_PositionWGS84 GeoPoint;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeStormAttributes();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeStormAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeFront : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeFront();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeFront& operator=(const midw_ext_fi_tcl_SXMShapeTypeFront& coRef);
   midw_ext_fi_tcl_SXMShapeTypeFront(const midw_ext_fi_tcl_SXMShapeTypeFront& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tcl_e8_FrontType FrontType;
   std::vector<midw_ext_fi_tcl_PositionWGS84, std::allocator<midw_ext_fi_tcl_PositionWGS84> > GeoPoints;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeFront();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeFront& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypePressureCenter : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypePressureCenter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypePressureCenter& operator=(const midw_ext_fi_tcl_SXMShapeTypePressureCenter& coRef);
   midw_ext_fi_tcl_SXMShapeTypePressureCenter(const midw_ext_fi_tcl_SXMShapeTypePressureCenter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tcl_e8_PressureType PressureType;
   midw_ext_fi_tcl_s32_Pascal Pressure;
   midw_ext_fi_tcl_PositionWGS84 GeoPoint;
   virtual ~midw_ext_fi_tcl_SXMShapeTypePressureCenter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypePressureCenter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeStormPosition : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeStormPosition();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeStormPosition& operator=(const midw_ext_fi_tcl_SXMShapeTypeStormPosition& coRef);
   midw_ext_fi_tcl_SXMShapeTypeStormPosition(const midw_ext_fi_tcl_SXMShapeTypeStormPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_POSIXTime IssueTime;
   midw_ext_fi_tclString StormUniqueId;
   midw_ext_fi_tclString StormName;
   tU16 SequenceId;
   midw_ext_fi_tcl_e8_StormPositionType PositionType;
   midw_ext_fi_tcl_s16_Degree Direction;
   midw_ext_fi_tcl_s16_Knot Speed;
   midw_ext_fi_tcl_s16_Knot MaxSustainedWinds;
   midw_ext_fi_tcl_s16_Knot Gusts;
   midw_ext_fi_tcl_s32_Pascal Pressure;
   midw_ext_fi_tcl_POSIXTime Timestamp;
   midw_ext_fi_tcl_e8_StormType StormType;
   midw_ext_fi_tcl_PositionWGS84 GeoPoint;
   std::vector<midw_ext_fi_tcl_SXMShapeTypeWindRadius, std::allocator<midw_ext_fi_tcl_SXMShapeTypeWindRadius> > WindRadii;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeStormPosition();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeStormPosition& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMShapeTypeStormTrack : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMShapeTypeStormTrack();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMShapeTypeStormTrack& operator=(const midw_ext_fi_tcl_SXMShapeTypeStormTrack& coRef);
   midw_ext_fi_tcl_SXMShapeTypeStormTrack(const midw_ext_fi_tcl_SXMShapeTypeStormTrack& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StormUniqueId;
   midw_ext_fi_tclString StormName;
   std::vector<midw_ext_fi_tcl_SXMShapeTypeStormPosition, std::allocator<midw_ext_fi_tcl_SXMShapeTypeStormPosition> > StormPositions;
   virtual ~midw_ext_fi_tcl_SXMShapeTypeStormTrack();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMShapeTypeStormTrack& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION();
   enum tenType {
      FI_EN_STOCK_PRICE_DIRECTION_INVALID = 0UL,
      FI_EN_STOCK_PRICE_DIRECTION_UP = 1UL,
      FI_EN_STOCK_PRICE_DIRECTION_UNCHANGED = 2UL,
      FI_EN_STOCK_PRICE_DIRECTION_DOWN = 3UL,
      FI_EN_STOCK_PRICE_DIRECTION_UNKNOWN = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION(midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Stock_ErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Stock_ErrorTypes();
   enum tenType {
      FI_EN_STOCK_ERRORTYPE_NONE = 0UL,
      FI_EN_STOCK_ERRORTYPE_NOOBJECTS = 1UL,
      FI_EN_STOCK_ERRORTYPE_OBJECT_ALREADY_IN_LIST = 2UL,
      FI_EN_STOCK_ERRORTYPE_OBJECT_NOT_IN_LIST = 3UL,
      FI_EN_STOCK_ERRORTYPE_ERROR = 4UL,
      FI_EN_STOCK_ERRORTYPE_INVALID_OBJECT = 5UL,
      FI_EN_STOCK_ERRORTYPE_MEMORY_FULL = 6UL,
      FI_EN_STOCK_ERRORTYPE_ADDFAVORITE_ERROR = 7UL,
      FI_EN_STOCK_ERRORTYPE_REMOVEFAVORITE_ERROR = 8UL,
      FI_EN_STOCK_ERRORTYPE_GETSTOCKSYMBOL_ERROR = 9UL,
      FI_EN_STOCK_ERRORTYPE_GETDATAPROVIDERINFO_ERROR = 10UL,
      FI_EN_STOCK_ERRORTYPE_CLEARDELTA_SYMBOLTABLE_ERROR = 11UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Stock_ErrorTypes(midw_ext_fi_tcl_e8_Stock_ErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Stock_ErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Stock_ErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_StockQuote : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_StockQuote();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_StockQuote& operator=(const midw_ext_fi_tcl_StockQuote& coRef);
   midw_ext_fi_tcl_StockQuote(const midw_ext_fi_tcl_StockQuote& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Symbol;
   tF32 MarketPrice;
   tF32 Delta;
   midw_ext_fi_tcl_e8_STOCK_PRICE_DIRECTION Direction;
   virtual ~midw_ext_fi_tcl_StockQuote();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_StockQuote& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_StockQuoteList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_StockQuoteList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_StockQuoteList& operator=(const midw_ext_fi_tcl_StockQuoteList& coRef);
   midw_ext_fi_tcl_StockQuoteList(const midw_ext_fi_tcl_StockQuoteList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_StockQuote, std::allocator<midw_ext_fi_tcl_StockQuote> > StockQuoteList;
   virtual ~midw_ext_fi_tcl_StockQuoteList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_StockQuoteList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_StockFilterList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_StockFilterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_StockFilterList& operator=(const midw_ext_fi_tcl_StockFilterList& coRef);
   midw_ext_fi_tcl_StockFilterList(const midw_ext_fi_tcl_StockFilterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > StockFilterList;
   virtual ~midw_ext_fi_tcl_StockFilterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_StockFilterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMSafeviewSubLocationInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMSafeviewSubLocationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMSafeviewSubLocationInfo& operator=(const midw_ext_fi_tcl_SXMSafeviewSubLocationInfo& coRef);
   midw_ext_fi_tcl_SXMSafeviewSubLocationInfo(const midw_ext_fi_tcl_SXMSafeviewSubLocationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 SublocationLatitude;
   tS32 SublocationLongitude;
   tU16 SublocationHighSpeedLimit;
   tU16 SublocationLowSpeedLimit;
   tU16 SublocationDirection;
   tU8 SublocationAlertType;
   virtual ~midw_ext_fi_tcl_SXMSafeviewSubLocationInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMSafeviewSubLocationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo& operator=(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo& coRef);
   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString SafeviewDescription;
   tS32 SafeviewLatitude;
   tS32 SafeviewLongitude;
   std::vector<midw_ext_fi_tcl_SXMSafeviewSubLocationInfo, std::allocator<midw_ext_fi_tcl_SXMSafeviewSubLocationInfo> > SafeviewSubLocationInfolist;
   virtual ~midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList& operator=(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList& coRef);
   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo, std::allocator<midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfo> > SafeviewLocationAndSubLocationInfolist;
   virtual ~midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes();
   enum tenType {
      FI_EN_SAFEVIEW_DSRL_INFOLIST_EMPTY = 0UL,
      FI_EN_SAFEVIEW_LOCATIONINFO_STATUS_UNAVAILABLE = 1UL,
      FI_EN_SAFEVIEW_SUBLOCATIONINFO_UNAVAILABLE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes(midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_SXMSafeview_ErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_DST_Setting : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_DST_Setting();
   enum tenType {
      FI_EN_VDCLK_EN_DST_OFF = 0UL,
      FI_EN_VDCLK_EN_DST_ON = 1UL,
      FI_EN_VDCLK_EN_DST_AUTO = 2UL,
      FI_EN_VDCLK_EN_DST_AUTO_OFF = 3UL,
      FI_EN_VDCLK_EN_DST_NONE = 4UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_DST_Setting(midw_ext_fi_tclDCLK_TEN_DST_Setting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_DST_Setting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_DST_Setting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_GPS_EPOCH : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_GPS_EPOCH();
   enum tenType {
      FI_EN_VDCLK_EN_GPS_EPOCH_1 = 1UL,
      FI_EN_VDCLK_EN_GPS_EPOCH_2 = 2UL,
      FI_EN_VDCLK_EN_GPS_EPOCH_3 = 3UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_GPS_EPOCH(midw_ext_fi_tclDCLK_TEN_GPS_EPOCH::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_GPS_EPOCH();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_GPS_EPOCH& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE();
   enum tenType {
      FI_EN_VDCLK_EN_RTCTIMESTATE_INVALID  = 1UL,
      FI_EN_VDCLK_EN_RTCTIMESTATE_EVER_SYNC = 2UL,
      FI_EN_VDCLK_EN_RTCTIMESTATE_VALID = 3UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE(midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_TimeDateStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_TimeDateStatus();
   enum tenType {
      FI_EN_VDCLK_EN_SECONDCHANGE = 1UL,
      FI_EN_VDCLK_EN_MINUTECHANGE = 2UL,
      FI_EN_VDCLK_EN_HOURCHANGE = 4UL,
      FI_EN_VDCLK_EN_HMITIMECHANGE = 6UL,
      FI_EN_VDCLK_EN_TIMECHANGE = 7UL,
      FI_EN_VDCLK_EN_TIMEVALID = 8UL,
      FI_EN_VDCLK_EN_DAYCHANGE = 16UL,
      FI_EN_VDCLK_EN_MONTHCHANGE = 32UL,
      FI_EN_VDCLK_EN_YEARCHANGE = 64UL,
      FI_EN_VDCLK_EN_DATECHANGE = 112UL,
      FI_EN_VDCLK_EN_ALLCHANGE = 119UL,
      FI_EN_VDCLK_EN_DATEVALID = 128UL,
      FI_EN_VDCLK_EN_ALLVALID = 136UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_TimeDateStatus(midw_ext_fi_tclDCLK_TEN_TimeDateStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_TimeDateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_TimeDateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_FormatSourceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_FormatSourceStatus();
   enum tenType {
      FI_EN_VDCLK_EN_FSS_SYSTEM = 1UL,
      FI_EN_VDCLK_EN_FSS_MASTER = 2UL,
      FI_EN_VDCLK_EN_FSS_MASTERTIMEONLY = 3UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_FormatSourceStatus(midw_ext_fi_tclDCLK_TEN_FormatSourceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_FormatSourceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_FormatSourceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_ClockSourceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_ClockSourceStatus();
   enum tenType {
      FI_EN_VDCLK_EN_CSS_SYSTEM = 1UL,
      FI_EN_VDCLK_EN_CSS_MASTER = 2UL,
      FI_EN_VDCLK_EN_CSS_MASTERTIMEONLY = 3UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_ClockSourceStatus(midw_ext_fi_tclDCLK_TEN_ClockSourceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_ClockSourceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_ClockSourceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_TimeFormat : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_TimeFormat();
   enum tenType {
      FI_EN_VDCLK_EN_TF_MODE12 = 1UL,
      FI_EN_VDCLK_EN_TF_MODE24 = 2UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_TimeFormat(midw_ext_fi_tclDCLK_TEN_TimeFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_TimeFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_TimeFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_DateFormat : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_DateFormat();
   enum tenType {
      FI_EN_VDCLK_EN_DF_DD_MM_YYYY = 1UL,
      FI_EN_VDCLK_EN_DF_MM_DD_YYYY = 2UL,
      FI_EN_VDCLK_EN_DF_YYYY_MM_DD = 3UL,
      FI_EN_VDCLK_EN_DF_DD_MM_YYYY_DASH = 4UL,
      FI_EN_VDCLK_EN_DF_DD_MM_YYYY_LINE = 5UL,
      FI_EN_VDCLK_EN_DF_YYYY_DD_MM = 6UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_DateFormat(midw_ext_fi_tclDCLK_TEN_DateFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_DateFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_DateFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tclDCLK_TEN_SyncMode : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tclDCLK_TEN_SyncMode();
   enum tenType {
      FI_EN_VDCLK_EN_SYNC_GPS = 0UL,
      FI_EN_VDCLK_EN_SYNC_CAN = 1UL,
      FI_EN_VDCLK_EN_SYNC_MANUAL = 2UL,
      FI_EN_VDCLK_EN_SYNC_CANORMANUAL = 3UL
   };
   tenType enType;

   midw_ext_fi_tclDCLK_TEN_SyncMode(midw_ext_fi_tclDCLK_TEN_SyncMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tclDCLK_TEN_SyncMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tclDCLK_TEN_SyncMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WSAlertLocation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WSAlertLocation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WSAlertLocation& operator=(const midw_ext_fi_tcl_WSAlertLocation& coRef);
   midw_ext_fi_tcl_WSAlertLocation(const midw_ext_fi_tcl_WSAlertLocation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString Description;
   std::vector<midw_ext_fi_tcl_PositionWGS84, std::allocator<midw_ext_fi_tcl_PositionWGS84> > ShapeGeoPoints;
   virtual ~midw_ext_fi_tcl_WSAlertLocation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WSAlertLocation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlertAnnounceStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlertAnnounceStatus();
   enum tenType {
      FI_EN_STATUS_INVALID = 0UL,
      FI_EN_STATUS_STARTED = 1UL,
      FI_EN_STATUS_STOPPED = 2UL,
      FI_EN_STATUS_PAUSED = 3UL,
      FI_EN_STATUS_RESUMED = 4UL,
      FI_EN_STATUS_ABORTED = 5UL,
      FI_EN_STATUS_ERROR = 6UL,
      FI_EN_STATUS_AVAILABLE = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlertAnnounceStatus(midw_ext_fi_tcl_e8_WSAlertAnnounceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlertAnnounceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlertAnnounceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlertAnnounceAction : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlertAnnounceAction();
   enum tenType {
      FI_EN_ACTION_INVALID = 0UL,
      FI_EN_ACTION_START = 1UL,
      FI_EN_ACTION_STOP = 2UL,
      FI_EN_ACTION_PAUSE = 3UL,
      FI_EN_ACTION_RESUME = 4UL,
      FI_EN_ACTION_ABORT = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlertAnnounceAction(midw_ext_fi_tcl_e8_WSAlertAnnounceAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlertAnnounceAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlertAnnounceAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlertListStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlertListStatus();
   enum tenType {
      FI_EN_INVALID = 0UL,
      FI_EN_READY = 1UL,
      FI_EN_CHANGED = 2UL,
      FI_EN_ERROR = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlertListStatus(midw_ext_fi_tcl_e8_WSAlertListStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlertListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlertListStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlertTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlertTypes();
   enum tenType {
      FI_EN_INVALID_ALERT_TYPE = 0UL,
      FI_EN_VOLCANIC_ASHFALL_WARNING = 1UL,
      FI_EN_VOLCANIC_ASHFALL_WATCH = 2UL,
      FI_EN_VOLCANIC_ASHFALL_ADVISORY = 3UL,
      FI_EN_AIR_STAGNATION_WARNING = 4UL,
      FI_EN_AIR_STAGNATION_WATCH = 5UL,
      FI_EN_AIR_STAGNATION_ADVISORY = 6UL,
      FI_EN_AVALANCHE_WARNING = 7UL,
      FI_EN_AVALANCHE_WATCH = 8UL,
      FI_EN_AVALANCHE_ADVISORY = 9UL,
      FI_EN_BLOWING_DRIFTING_SNOW_WARNING = 10UL,
      FI_EN_BLOWING_DRIFTING_SNOW_WATCH = 11UL,
      FI_EN_BLOWING_DRIFTING_SNOW_ADVISORY = 12UL,
      FI_EN_BRISK_WIND_WARNING = 13UL,
      FI_EN_BRISK_WIND_WATCH = 14UL,
      FI_EN_BRISK_WIND_ADVISORY = 15UL,
      FI_EN_BLIZZARD_WARNING = 16UL,
      FI_EN_BLIZZARD_WATCH = 17UL,
      FI_EN_BLIZZARD_ADVISORY = 18UL,
      FI_EN_COASTAL_FLOOD_WARNING = 19UL,
      FI_EN_COASTAL_FLOOD_WATCH = 20UL,
      FI_EN_COASTAL_FLOOD_ADVISORY = 21UL,
      FI_EN_DEBRIS_FLOW_WARNING = 22UL,
      FI_EN_DEBRIS_FLOW_WATCH = 23UL,
      FI_EN_DEBRIS_FLOW_ADVISORY = 24UL,
      FI_EN_DUST_STORM_WARNING = 25UL,
      FI_EN_DUST_STORM_WATCH = 26UL,
      FI_EN_DUST_STORM_ADVISORY = 27UL,
      FI_EN_BLOWING_DUST_WARNING = 28UL,
      FI_EN_BLOWING_DUST_WATCH = 29UL,
      FI_EN_BLOWING_DUST_ADVISORY = 30UL,
      FI_EN_EXTREME_COLD_WARNING = 31UL,
      FI_EN_EXTREME_COLD_WATCH = 32UL,
      FI_EN_EXTREME_COLD_ADVISORY = 33UL,
      FI_EN_EXCESSIVE_HEAT_WARNING = 34UL,
      FI_EN_EXCESSIVE_HEAT_WATCH = 35UL,
      FI_EN_EXCESSIVE_HEAT_ADVISORY = 36UL,
      FI_EN_AREAL_FLOOD_WARNING = 37UL,
      FI_EN_AREAL_FLOOD_WATCH = 38UL,
      FI_EN_AREAL_FLOOD_ADVISORY = 39UL,
      FI_EN_FLASH_FLOOD_WARNING = 40UL,
      FI_EN_FLASH_FLOOD_WATCH = 41UL,
      FI_EN_FLASH_FLOOD_ADVISORY = 42UL,
      FI_EN_DENSE_FOG_WARNING = 43UL,
      FI_EN_DENSE_FOG_WATCH = 44UL,
      FI_EN_DENSE_FOG_ADVISORY = 45UL,
      FI_EN_FLOOD_WARNING = 46UL,
      FI_EN_FLOOD_WATCH = 47UL,
      FI_EN_FLOOD_ADVISORY = 48UL,
      FI_EN_FROST_WARNING = 49UL,
      FI_EN_FROST_WATCH = 50UL,
      FI_EN_FROST_ADVISORY = 51UL,
      FI_EN_FIRE_WEATHER_WARNING = 52UL,
      FI_EN_FIRE_WEATHER_WATCH = 53UL,
      FI_EN_FIRE_WEATHER_ADVISORY = 54UL,
      FI_EN_FREEZE_WARNING = 55UL,
      FI_EN_FREEZE_WATCH = 56UL,
      FI_EN_FREEZE_ADVISORY = 57UL,
      FI_EN_GALE_WARNING = 58UL,
      FI_EN_GALE_WATCH = 59UL,
      FI_EN_GALE_ADVISORY = 60UL,
      FI_EN_HURRICANE_FORCE_WIND_WARNING = 61UL,
      FI_EN_HURRICANE_FORCE_WIND_WATCH = 62UL,
      FI_EN_HURRICANE_FORCE_WIND_ADVISORY = 63UL,
      FI_EN_INLAND_HURRICANE_WARNING = 64UL,
      FI_EN_INLAND_HURRICANE_WATCH = 65UL,
      FI_EN_INLAND_HURRICANE_ADVISORY = 66UL,
      FI_EN_HEAVY_SLEET_WARNING = 67UL,
      FI_EN_HEAVY_SLEET_WATCH = 68UL,
      FI_EN_HEAVY_SLEET_ADVISORY = 69UL,
      FI_EN_HEAVY_SNOW_WARNING = 70UL,
      FI_EN_HEAVY_SNOW_WATCH = 71UL,
      FI_EN_HEAVY_SNOW_ADVISORY = 72UL,
      FI_EN_HEAT_WARNING = 73UL,
      FI_EN_HEAT_WATCH = 74UL,
      FI_EN_HEAT_ADVISORY = 75UL,
      FI_EN_HURRICANE_WARNING = 76UL,
      FI_EN_HURRICANE_WATCH = 77UL,
      FI_EN_HURRICANE_ADVISORY = 78UL,
      FI_EN_HIGH_WIND_WARNING = 79UL,
      FI_EN_HIGH_WIND_WATCH = 80UL,
      FI_EN_HIGH_WIND_ADVISORY = 81UL,
      FI_EN_HYDROLOGIC_WARNING = 82UL,
      FI_EN_HYDROLOGIC_WATCH = 83UL,
      FI_EN_HYDROLOGIC_ADVISORY = 84UL,
      FI_EN_HARD_FREEZE_WARNING = 85UL,
      FI_EN_HARD_FREEZE_WATCH = 86UL,
      FI_EN_HARD_FREEZE_ADVISORY = 87UL,
      FI_EN_SLEET_WARNING = 88UL,
      FI_EN_SLEET_WATCH = 89UL,
      FI_EN_SLEET_ADVISORY = 90UL,
      FI_EN_ICE_STORM_WARNING = 91UL,
      FI_EN_ICE_STORM_WATCH = 92UL,
      FI_EN_ICE_STORM_ADVISORY = 93UL,
      FI_EN_LAKE_EFFECT_SNOW_AND_BLOWING_SNOW_WARNING = 94UL,
      FI_EN_LAKE_EFFECT_SNOW_AND_BLOWING_SNOW_WATCH = 95UL,
      FI_EN_LAKE_EFFECT_SNOW_AND_BLOWING_SNOW_ADVISORY = 96UL,
      FI_EN_LAKE_EFFECT_SNOW_WARNING = 97UL,
      FI_EN_LAKE_EFFECT_SNOW_WATCH = 98UL,
      FI_EN_LAKE_EFFECT_SNOW_ADVISORY = 99UL,
      FI_EN_LOW_WATER_WARNING = 100UL,
      FI_EN_LOW_WATER_WATCH = 101UL,
      FI_EN_LOW_WATER_ADVISORY = 102UL,
      FI_EN_LAKESHORE_FLOOD_WARNING = 103UL,
      FI_EN_LAKESHORE_FLOOD_WATCH = 104UL,
      FI_EN_LAKESHORE_FLOOD_ADVISORY = 105UL,
      FI_EN_LAKE_WIND_WARNING = 106UL,
      FI_EN_LAKE_WIND_WATCH = 107UL,
      FI_EN_LAKE_WIND_ADVISORY = 108UL,
      FI_EN_MARINE_WARNING = 109UL,
      FI_EN_MARINE_WATCH = 110UL,
      FI_EN_MARINE_ADVISORY = 111UL,
      FI_EN_MARINE_DENSE_FOG_WARNING = 112UL,
      FI_EN_MARINE_DENSE_FOG_WATCH = 113UL,
      FI_EN_MARINE_DENSE_FOG_ADVISORY = 114UL,
      FI_EN_MARINE_ASHFALL_WARNING = 115UL,
      FI_EN_MARINE_ASHFALL_WATCH = 116UL,
      FI_EN_MARINE_ASHFALL_ADVISORY = 117UL,
      FI_EN_MARINE_DENSE_SMOKE_WARNING = 118UL,
      FI_EN_MARINE_DENSE_SMOKE_WATCH = 119UL,
      FI_EN_MARINE_DENSE_SMOKE_ADVISORY = 120UL,
      FI_EN_SMALL_CRAFT_FOR_ROUGH_BAR_WARNING = 121UL,
      FI_EN_SMALL_CRAFT_FOR_ROUGH_BAR_WATCH = 122UL,
      FI_EN_SMALL_CRAFT_FOR_ROUGH_BAR_ADVISORY = 123UL,
      FI_EN_RADIOLOGICAL_HAZARD_WARNING = 124UL,
      FI_EN_RADIOLOGICAL_HAZARD_WATCH = 125UL,
      FI_EN_RADIOLOGICAL_HAZARD_ADVISORY = 126UL,
      FI_EN_SNOW_AND_BLOWING_SNOW_WARNING = 127UL,
      FI_EN_SNOW_AND_BLOWING_SNOW_WATCH = 128UL,
      FI_EN_SNOW_AND_BLOWING_SNOW_ADVISORY = 129UL,
      FI_EN_SMALL_CRAFT_WARNING = 130UL,
      FI_EN_SMALL_CRAFT_WATCH = 131UL,
      FI_EN_SMALL_CRAFT_ADVISORY = 132UL,
      FI_EN_HAZARDOUS_SEAS_WARNING = 133UL,
      FI_EN_HAZARDOUS_SEAS_WATCH = 134UL,
      FI_EN_HAZARDOUS_SEAS_ADVISORY = 135UL,
      FI_EN_SMALL_CRAFT_FOR_WINDS_WARNING = 136UL,
      FI_EN_SMALL_CRAFT_FOR_WINDS_WATCH = 137UL,
      FI_EN_SMALL_CRAFT_FOR_WINDS_ADVISORY = 138UL,
      FI_EN_DENSE_SMOKE_WARNING = 139UL,
      FI_EN_DENSE_SMOKE_WATCH = 140UL,
      FI_EN_DENSE_SMOKE_ADVISORY = 141UL,
      FI_EN_SNOW_WARNING = 142UL,
      FI_EN_SNOW_WATCH = 143UL,
      FI_EN_SNOW_ADVISORY = 144UL,
      FI_EN_STORM_WARNING = 145UL,
      FI_EN_STORM_WATCH = 146UL,
      FI_EN_STORM_ADVISORY = 147UL,
      FI_EN_HIGH_SURF_WARNING = 148UL,
      FI_EN_HIGH_SURF_WATCH = 149UL,
      FI_EN_HIGH_SURF_ADVISORY = 150UL,
      FI_EN_SEVERE_THUNDERSTORM_WARNING = 151UL,
      FI_EN_SEVERE_THUNDERSTORM_WATCH = 152UL,
      FI_EN_SEVERE_THUNDERSTORM_ADVISORY = 153UL,
      FI_EN_SMALL_CRAFT_FOR_HAZARDOUS_SEAS_WARNING = 154UL,
      FI_EN_SMALL_CRAFT_FOR_HAZARDOUS_SEAS_WATCH = 155UL,
      FI_EN_SMALL_CRAFT_FOR_HAZARDOUS_SEAS_ADVISORY = 156UL,
      FI_EN_INLAND_TROPICAL_STORM_WARNING = 157UL,
      FI_EN_INLAND_TROPICAL_STORM_WATCH = 158UL,
      FI_EN_INLAND_TROPICAL_STORM_ADVISORY = 159UL,
      FI_EN_TORNADO_WARNING = 160UL,
      FI_EN_TORNADO_WATCH = 161UL,
      FI_EN_TORNADO_ADVISORY = 162UL,
      FI_EN_TROPICAL_STORM_WARNING = 163UL,
      FI_EN_TROPICAL_STORM_WATCH = 164UL,
      FI_EN_TROPICAL_STORM_ADVISORY = 165UL,
      FI_EN_TSUNAMI_WARNING = 166UL,
      FI_EN_TSUNAMI_WATCH = 167UL,
      FI_EN_TSUNAMI_ADVISORY = 168UL,
      FI_EN_TYPHOON_WARNING = 169UL,
      FI_EN_TYPHOON_WATCH = 170UL,
      FI_EN_TYPHOON_ADVISORY = 171UL,
      FI_EN_HEAVY_FREEZING_SPRAY_WARNING = 172UL,
      FI_EN_HEAVY_FREEZING_SPRAY_WATCH = 173UL,
      FI_EN_HEAVY_FREEZING_SPRAY_ADVISORY = 174UL,
      FI_EN_VOLCANO_WARNING = 175UL,
      FI_EN_VOLCANO_WATCH = 176UL,
      FI_EN_VOLCANO_ADVISORY = 177UL,
      FI_EN_WIND_CHILL_WARNING = 178UL,
      FI_EN_WIND_CHILL_WATCH = 179UL,
      FI_EN_WIND_CHILL_ADVISORY = 180UL,
      FI_EN_WIND_WARNING = 181UL,
      FI_EN_WIND_WATCH = 182UL,
      FI_EN_WIND_ADVISORY = 183UL,
      FI_EN_WINTER_STORM_WARNING = 184UL,
      FI_EN_WINTER_STORM_WATCH = 185UL,
      FI_EN_WINTER_STORM_ADVISORY = 186UL,
      FI_EN_WINTER_WEATHER_WARNING = 187UL,
      FI_EN_WINTER_WEATHER_WATCH = 188UL,
      FI_EN_WINTER_WEATHER_ADVISORY = 189UL,
      FI_EN_FREEZING_FOG_WARNING = 190UL,
      FI_EN_FREEZING_FOG_WATCH = 191UL,
      FI_EN_FREEZING_FOG_ADVISORY = 192UL,
      FI_EN_FREEZING_RAIN_WARNING = 193UL,
      FI_EN_FREEZING_RAIN_SNOW_WATCH = 194UL,
      FI_EN_FREEZING_RAIN_ADVISORY = 195UL,
      FI_EN_FREEZING_SPRAY_WARNING = 196UL,
      FI_EN_FREEZING_SPRAY_WATCH = 197UL,
      FI_EN_FREEZING_SPRAY_ADVISORY = 198UL,
      FI_EN_CHILD_ABDUCTION_EMERGENCY = 199UL,
      FI_EN_AIR_QUALITY_WARNING = 200UL,
      FI_EN_AVIATION_WEATHER = 201UL,
      FI_EN_CIVIL_EMERGENCY_OR_DANGER_STATEMENT = 202UL,
      FI_EN_EARTHQUAKE_WARNING = 203UL,
      FI_EN_IMMEDIATE_EVACUATION_WARNING = 204UL,
      FI_EN_FIRE_WARNING = 205UL,
      FI_EN_HAZARDOUS_MATERIALS_WARNING = 206UL,
      FI_EN_LAW_ENFORCEMENT_WARNING = 207UL,
      FI_EN_NUCLEAR_POWER_PLANT_WARNING = 208UL,
      FI_EN_SHELTER_IN_PLACE_WARNING = 209UL,
      FI_EN_TELEPHONE_OUTAGE_EMERGENCY = 210UL,
      FI_EN_SPECIAL_WEATHER_WARNING = 211UL,
      FI_EN_SEVERE_WEATHER_WARNING = 212UL,
      FI_EN_SEVERE_LOCAL_STORM_WARNING = 213UL,
      FI_EN_HAIL_WARNING = 214UL,
      FI_EN_GENERAL_THUNDERSTORM_WARNING = 215UL,
      FI_EN_SEVERE_CONVECTIVE_ACTIVITY_WARNING = 216UL,
      FI_EN_SIGNIFICANT_SEVERE_CONVECTIVE_ACTIVITY_WARNING = 217UL,
      FI_EN_SIGNIFICANT_SEVERE_TORNADO_WARNING = 218UL,
      FI_EN_SIGNIFICANT_SEVERE_HAIL_WARNING = 219UL,
      FI_EN_ARCTIC_OUTFLOW_WARNING = 220UL,
      FI_EN_COLD_WAVE_WARNING = 221UL,
      FI_EN_COLD_CORE_FUNNEL_WARNING = 222UL,
      FI_EN_FLASH_FREEZE_WARNING = 223UL,
      FI_EN_FOG_SMOKE_WARNING = 224UL,
      FI_EN_FREEZING_DRIZZLE_WARNING = 225UL,
      FI_EN_FUNNEL_CLOUD_WARNING = 226UL,
      FI_EN_HEAVY_RAIN_WARNING = 227UL,
      FI_EN_HIGH_HEAT_AND_HUMIDITY_WARNING = 228UL,
      FI_EN_COMBINED_HEAT_AND_HUMIDITY_WARNING = 229UL,
      FI_EN_LANDSPOUT_WARNING = 230UL,
      FI_EN_LES_SUETES_WIND_WARNING = 231UL,
      FI_EN_MARINE_WIND_WARNING = 232UL,
      FI_EN_RAINFALL_WARNING = 233UL,
      FI_EN_SEVERE_WIND_WARNING = 234UL,
      FI_EN_SNOW_SQUALL_WARNING = 235UL,
      FI_EN_STORM_SURGE_WARNING = 236UL,
      FI_EN_ULTRA_VIOLET_WARNING = 237UL,
      FI_EN_WATERSPOUT_WARNING = 238UL,
      FI_EN_GENERAL_WEATHER_WARNING = 239UL,
      FI_EN_WRECKHOUSE_WIND_WARNING = 240UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlertTypes(midw_ext_fi_tcl_e8_WSAlertTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlertTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlertTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WSAlertInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WSAlertInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WSAlertInfo& operator=(const midw_ext_fi_tcl_WSAlertInfo& coRef);
   midw_ext_fi_tcl_WSAlertInfo(const midw_ext_fi_tcl_WSAlertInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_WSAlertTypes AlertTypeID;
   midw_ext_fi_tclString AlertExtRefCode;
   tU32 AlertNameID;
   tU32 AlertGroupId;
   tU32 AlertPrio;
   midw_ext_fi_tcl_RGBAcolor AlertColor;
   virtual ~midw_ext_fi_tcl_WSAlertInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WSAlertInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WSAlertConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WSAlertConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WSAlertConfig& operator=(const midw_ext_fi_tcl_WSAlertConfig& coRef);
   midw_ext_fi_tcl_WSAlertConfig(const midw_ext_fi_tcl_WSAlertConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_WSAlertTypes AlertTypeID;
   midw_ext_fi_tclString AlertExtRefCode;
   tU32 AlertNameID;
   tU32 AlertGroupId;
   tU32 AlertPrio;
   midw_ext_fi_tcl_RGBAcolor AlertColor;
   tBool IsEnabledInHMI;
   tBool IsEnabledInMap;
   virtual ~midw_ext_fi_tcl_WSAlertConfig();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WSAlertConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_Language : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_Language();
   enum tenType {
      FI_EN_ENGLISH = 0UL,
      FI_EN_SPANISH = 1UL,
      FI_EN_FRENCH = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_Language(midw_ext_fi_tcl_e8_Language::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_Language();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_Language& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_WSAlertMsg : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_WSAlertMsg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_WSAlertMsg& operator=(const midw_ext_fi_tcl_WSAlertMsg& coRef);
   midw_ext_fi_tcl_WSAlertMsg(const midw_ext_fi_tcl_WSAlertMsg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   midw_ext_fi_tclString Text;
   midw_ext_fi_tcl_POSIXTime StartTime;
   midw_ext_fi_tcl_POSIXTime EndTime;
   midw_ext_fi_tcl_e8_Language Language;
   tU16 Priority;
   tBool bIsMarineZone;
   std::vector<midw_ext_fi_tcl_WSAlertInfo, std::allocator<midw_ext_fi_tcl_WSAlertInfo> > AlertTypes;
   std::vector<midw_ext_fi_tcl_WSAlertLocation, std::allocator<midw_ext_fi_tcl_WSAlertLocation> > AlertLocations;
   tF32 Distance;
   virtual ~midw_ext_fi_tcl_WSAlertMsg();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_WSAlertMsg& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlertActionType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlertActionType();
   enum tenType {
      FI_EN_ENABLE = 0UL,
      FI_EN_DISABLE = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlertActionType(midw_ext_fi_tcl_e8_WSAlertActionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlertActionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlertActionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes();
   enum tenType {
      FI_EN_OPERATION_FAILED = 0UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes(midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_WSAlerts_ErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8FullType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8FullType();
   enum tenType {
      FI_EN_PARKING_FULLNESS_UNKNOWN = 0UL,
      FI_EN_PARKING_FULLNESS_NOW = 1UL,
      FI_EN_PARKING_FULLNESS_15MIN = 2UL,
      FI_EN_PARKING_FULLNESS_30MIN = 3UL,
      FI_EN_PARKING_FULLNESS_45MIN = 4UL,
      FI_EN_PARKING_FULLNESS_60MIN = 5UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8FullType(midw_ext_fi_tcl_e8FullType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8FullType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8FullType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Fullness : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Fullness();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Fullness& operator=(const midw_ext_fi_tcl_Fullness& coRef);
   midw_ext_fi_tcl_Fullness(const midw_ext_fi_tcl_Fullness& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8FullType Type;
   tU16 Value;
   virtual ~midw_ext_fi_tcl_Fullness();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Fullness& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8Open24Hours : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8Open24Hours();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OPEN_24_HOURS = 1UL,
      FI_EN_NOT_OPEN_24_HOURS = 2UL,
      FI_EN_RESERVED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8Open24Hours(midw_ext_fi_tcl_e8Open24Hours::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8Open24Hours();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8Open24Hours& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8CashOrCard : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8CashOrCard();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ACCEPTS = 1UL,
      FI_EN_NOT_ACCEPTS = 2UL,
      FI_EN_RESERVED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8CashOrCard(midw_ext_fi_tcl_e8CashOrCard::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8CashOrCard();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8CashOrCard& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8ParkingType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8ParkingType();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_PARKING_STRUCTURE = 1UL,
      FI_EN_PARKING_LOT = 2UL,
      FI_EN_STREET_PARKING = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8ParkingType(midw_ext_fi_tcl_e8ParkingType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8ParkingType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8ParkingType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8MetroLocation : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8MetroLocation();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NEAR_METRO = 1UL,
      FI_EN_NOT_NEAR_METRO = 2UL,
      FI_EN_RESERVED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8MetroLocation(midw_ext_fi_tcl_e8MetroLocation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8MetroLocation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8MetroLocation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8AirPort : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8AirPort();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_AIRPORT = 1UL,
      FI_EN_NOT_AIRPORT = 2UL,
      FI_EN_RESERVED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8AirPort(midw_ext_fi_tcl_e8AirPort::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8AirPort();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8AirPort& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8OvernightParking : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8OvernightParking();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ALLOWED = 1UL,
      FI_EN_NOT_ALLOWED = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8OvernightParking(midw_ext_fi_tcl_e8OvernightParking::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8OvernightParking();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8OvernightParking& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8Reservations : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8Reservations();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ACCEPTED = 1UL,
      FI_EN_NOT_ACCEPTED = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8Reservations(midw_ext_fi_tcl_e8Reservations::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8Reservations();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8Reservations& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8SelfParking : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8SelfParking();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SELF_PARKING = 1UL,
      FI_EN_VALET_PARKING = 2UL,
      FI_EN_BOTH = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8SelfParking(midw_ext_fi_tcl_e8SelfParking::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8SelfParking();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8SelfParking& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8Security : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8Security();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SECURED = 1UL,
      FI_EN_UNATTENDED = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8Security(midw_ext_fi_tcl_e8Security::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8Security();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8Security& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8TollTag : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8TollTag();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ACCEPTED = 1UL,
      FI_EN_NOT_ACCEPTED = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8TollTag(midw_ext_fi_tcl_e8TollTag::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8TollTag();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8TollTag& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8SUVCharges : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8SUVCharges();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HIGHER_RATES = 1UL,
      FI_EN_NO_HIGHER_RATES = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8SUVCharges(midw_ext_fi_tcl_e8SUVCharges::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8SUVCharges();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8SUVCharges& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8RV : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8RV();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ALLOWED = 1UL,
      FI_EN_NOT_ALLOWED = 2UL,
      FI_EN_UNDEFINED = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8RV(midw_ext_fi_tcl_e8RV::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8RV();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8RV& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8OpenStatus : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8OpenStatus();
   enum tenType {
      FI_EN_PARKING_STATUS_OPEN = 0UL,
      FI_EN_PARKING_STATUS_CLOSED = 1UL,
      FI_EN_PARKING_STATUS_UNKNOWN = 2UL,
      FI_EN_PARKING_STATUS_SPECIALRATES = 3UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8OpenStatus(midw_ext_fi_tcl_e8OpenStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8OpenStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8OpenStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AmenityInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AmenityInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AmenityInfo& operator=(const midw_ext_fi_tcl_AmenityInfo& coRef);
   midw_ext_fi_tcl_AmenityInfo(const midw_ext_fi_tcl_AmenityInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8Open24Hours Open24Hours;
   midw_ext_fi_tcl_e8CashOrCard Cash;
   midw_ext_fi_tcl_e8CashOrCard Card;
   midw_ext_fi_tcl_e8ParkingType ParkingType;
   midw_ext_fi_tcl_e8MetroLocation MetroLocation;
   midw_ext_fi_tcl_e8AirPort AirPort;
   midw_ext_fi_tcl_e8OvernightParking OvernightParking;
   midw_ext_fi_tcl_e8Reservations Reservations;
   midw_ext_fi_tcl_e8SelfParking SelfParking;
   midw_ext_fi_tcl_e8Security Security;
   midw_ext_fi_tcl_e8TollTag TollTag;
   midw_ext_fi_tcl_e8SUVCharges SUVCharges;
   midw_ext_fi_tcl_e8RV RV;
   virtual ~midw_ext_fi_tcl_AmenityInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AmenityInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PriceInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PriceInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PriceInfo& operator=(const midw_ext_fi_tcl_PriceInfo& coRef);
   midw_ext_fi_tcl_PriceInfo(const midw_ext_fi_tcl_PriceInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tF32, std::allocator<tF32> > WeekdayHourly;
   std::vector<tF32, std::allocator<tF32> > SaturdayHourly;
   std::vector<tF32, std::allocator<tF32> > SundayHourly;
   tF32 WeekdayDaily;
   tF32 SaturdayDaily;
   tF32 SundayDaily;
   tF32 EarlyBird;
   tF32 Event;
   tF32 Other;
   virtual ~midw_ext_fi_tcl_PriceInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PriceInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_Time : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_Time();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_Time& operator=(const midw_ext_fi_tcl_Time& coRef);
   midw_ext_fi_tcl_Time(const midw_ext_fi_tcl_Time& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Hours;
   tU32 Minutes;
   virtual ~midw_ext_fi_tcl_Time();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_Time& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_PerDayOpeningTimes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_PerDayOpeningTimes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_PerDayOpeningTimes& operator=(const midw_ext_fi_tcl_PerDayOpeningTimes& coRef);
   midw_ext_fi_tcl_PerDayOpeningTimes(const midw_ext_fi_tcl_PerDayOpeningTimes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_Time StartTime;
   midw_ext_fi_tcl_Time EndTime;
   virtual ~midw_ext_fi_tcl_PerDayOpeningTimes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_PerDayOpeningTimes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8DayType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8DayType();
   enum tenType {
      FI_EN_MONDAY = 0UL,
      FI_EN_TUESDAY = 1UL,
      FI_EN_WEDNESDAY = 2UL,
      FI_EN_THURSDAY = 3UL,
      FI_EN_FRIDAY = 4UL,
      FI_EN_SATURDAY = 5UL,
      FI_EN_SUNDAY = 6UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8DayType(midw_ext_fi_tcl_e8DayType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8DayType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8DayType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_OpeningTime : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_OpeningTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_OpeningTime& operator=(const midw_ext_fi_tcl_OpeningTime& coRef);
   midw_ext_fi_tcl_OpeningTime(const midw_ext_fi_tcl_OpeningTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8DayType DayType;
   std::vector<midw_ext_fi_tcl_PerDayOpeningTimes, std::allocator<midw_ext_fi_tcl_PerDayOpeningTimes> > PerDayOpeningTimes;
   virtual ~midw_ext_fi_tcl_OpeningTime();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_OpeningTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ParkingInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ParkingInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ParkingInfo& operator=(const midw_ext_fi_tcl_ParkingInfo& coRef);
   midw_ext_fi_tcl_ParkingInfo(const midw_ext_fi_tcl_ParkingInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   midw_ext_fi_tclString Name;
   midw_ext_fi_tclString Address;
   midw_ext_fi_tclString SecondaryAddress;
   midw_ext_fi_tclString City;
   midw_ext_fi_tclString Zip;
   midw_ext_fi_tclString State;
   midw_ext_fi_tclString Phone;
   tU32 Capacity;
   tF32 Distance;
   midw_ext_fi_tcl_PositionWGS84 PrimaryLocation;
   midw_ext_fi_tcl_PositionWGS84 SecondaryLocation;
   tU32 PrimaryHeight;
   tU32 SecondaryHeight;
   tU32 AvailableTime;
   tU8 RelativePricingHourly;
   tU8 RelativePricingDaily;
   midw_ext_fi_tcl_e8OpenStatus OpenStatus;
   std::vector<midw_ext_fi_tcl_OpeningTime, std::allocator<midw_ext_fi_tcl_OpeningTime> > OpeningTimes;
   std::vector<midw_ext_fi_tcl_Fullness, std::allocator<midw_ext_fi_tcl_Fullness> > Fullness;
   midw_ext_fi_tcl_AmenityInfo Amenities;
   midw_ext_fi_tcl_PriceInfo PricingInfo;
   tBool IsFavorite;
   virtual ~midw_ext_fi_tcl_ParkingInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ParkingInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FilterConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FilterConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FilterConfig& operator=(const midw_ext_fi_tcl_FilterConfig& coRef);
   midw_ext_fi_tcl_FilterConfig(const midw_ext_fi_tcl_FilterConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_AmenityInfo Amenities;
   midw_ext_fi_tcl_e8OpenStatus ClosedLocations;
   tU32 EntranceHeight;
   virtual ~midw_ext_fi_tcl_FilterConfig();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FilterConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_AmenityConfig : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_AmenityConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_AmenityConfig& operator=(const midw_ext_fi_tcl_AmenityConfig& coRef);
   midw_ext_fi_tcl_AmenityConfig(const midw_ext_fi_tcl_AmenityConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_e8Open24Hours, std::allocator<midw_ext_fi_tcl_e8Open24Hours> > Open24Hours;
   std::vector<midw_ext_fi_tcl_e8CashOrCard, std::allocator<midw_ext_fi_tcl_e8CashOrCard> > Cash;
   std::vector<midw_ext_fi_tcl_e8CashOrCard, std::allocator<midw_ext_fi_tcl_e8CashOrCard> > Card;
   std::vector<midw_ext_fi_tcl_e8ParkingType, std::allocator<midw_ext_fi_tcl_e8ParkingType> > ParkingType;
   std::vector<midw_ext_fi_tcl_e8MetroLocation, std::allocator<midw_ext_fi_tcl_e8MetroLocation> > MetroLocation;
   std::vector<midw_ext_fi_tcl_e8AirPort, std::allocator<midw_ext_fi_tcl_e8AirPort> > AirPort;
   std::vector<midw_ext_fi_tcl_e8OvernightParking, std::allocator<midw_ext_fi_tcl_e8OvernightParking> > OvernightParking;
   std::vector<midw_ext_fi_tcl_e8Reservations, std::allocator<midw_ext_fi_tcl_e8Reservations> > Reservations;
   std::vector<midw_ext_fi_tcl_e8SelfParking, std::allocator<midw_ext_fi_tcl_e8SelfParking> > SelfParking;
   std::vector<midw_ext_fi_tcl_e8Security, std::allocator<midw_ext_fi_tcl_e8Security> > Security;
   std::vector<midw_ext_fi_tcl_e8TollTag, std::allocator<midw_ext_fi_tcl_e8TollTag> > TollTag;
   std::vector<midw_ext_fi_tcl_e8SUVCharges, std::allocator<midw_ext_fi_tcl_e8SUVCharges> > SUVCharges;
   std::vector<midw_ext_fi_tcl_e8RV, std::allocator<midw_ext_fi_tcl_e8RV> > RV;
   virtual ~midw_ext_fi_tcl_AmenityConfig();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_AmenityConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_FilterConfiguration : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_FilterConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_FilterConfiguration& operator=(const midw_ext_fi_tcl_FilterConfiguration& coRef);
   midw_ext_fi_tcl_FilterConfiguration(const midw_ext_fi_tcl_FilterConfiguration& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_AmenityConfig Amenities;
   std::vector<midw_ext_fi_tcl_e8OpenStatus, std::allocator<midw_ext_fi_tcl_e8OpenStatus> > ClosedLocations;
   tU32 EntranceHeight;
   virtual ~midw_ext_fi_tcl_FilterConfiguration();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_FilterConfiguration& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8ParkingErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8ParkingErrorTypes();
   enum tenType {
      FI_EN_PARKING_INFOLIST_EMPTY = 1UL,
      FI_EN_PARKING_STATION_UNAVAILABLE = 2UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8ParkingErrorTypes(midw_ext_fi_tcl_e8ParkingErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8ParkingErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8ParkingErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_CanFuelTypeEnum : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_CanFuelTypeEnum();
   enum tenType {
      FI_EN_CAN_FUEL_TYPE_REGULAR = 0UL,
      FI_EN_CAN_FUEL_TYPE_MIDRANGE = 1UL,
      FI_EN_CAN_FUEL_TYPE_PREMIUM = 2UL,
      FI_EN_CAN_FUEL_TYPE_DIESEL = 3UL,
      FI_EN_CAN_FUEL_TYPE_ELECTRIC_L1_120V = 4UL,
      FI_EN_CAN_FUEL_TYPE_ELECTRIC_L2_240V = 5UL,
      FI_EN_CAN_FUEL_TYPE_ELECTRIC_DC = 6UL,
      FI_EN_CAN_FUEL_TYPE_UNKNOWN = 7UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_CanFuelTypeEnum(midw_ext_fi_tcl_e8_CanFuelTypeEnum::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_CanFuelTypeEnum();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_CanFuelTypeEnum& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_CanFuelStationAmenity : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_CanFuelStationAmenity();
   enum tenType {
      FI_EN_CAN_FUEL_STATION_AMENITY_OPEN_24HR = 0UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_EMERGENCY_ROAD_SERVICE = 1UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_FULL_SERVICE = 2UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_OIL_CHANGE = 3UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_INTERSTATE_ACCESS_UNDER_HALF_MILE = 4UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_INTERSTATE_ACCESS_OVER_HALF_MILE = 5UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_CASH_DISCOUNT = 6UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_COVENIENCE_STORE = 7UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_SUPERMARKET = 8UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_SNACKS_FAST_FOOD = 9UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_RESTAURANT = 10UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_TRUCK_STOP = 11UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_TRUCK_STOP_WITH_HOTEL = 12UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_AFFILIATED_NETWORK_CARDS_ACCEPTED = 13UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_ALL_NETWORK_CARDS_ACCEPTED = 14UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_CREDIT_DEBIT = 15UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_PUBLIC_ACCESS = 16UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_PATRONS_ONLY = 17UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_CASH_ACCEPTED = 18UL,
      FI_EN_CAN_FUEL_STATION_AMENITY_RESERVATIONS = 19UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_CanFuelStationAmenity(midw_ext_fi_tcl_e8_CanFuelStationAmenity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_CanFuelStationAmenity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_CanFuelStationAmenity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8_CanFuelSortType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8_CanFuelSortType();
   enum tenType {
      FI_EN_CAN_FUEL_SORT_BY_NONE = 1UL,
      FI_EN_CAN_FUEL_SORT_BY_PRICE = 2UL,
      FI_EN_CAN_FUEL_SORT_BY_DISTANCE = 3UL,
      FI_EN_CAN_FUEL_SORT_BY_BRANDNAME = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8_CanFuelSortType(midw_ext_fi_tcl_e8_CanFuelSortType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8_CanFuelSortType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8_CanFuelSortType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelInfo& operator=(const midw_ext_fi_tcl_CanFuelInfo& coRef);
   midw_ext_fi_tcl_CanFuelInfo(const midw_ext_fi_tcl_CanFuelInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StationName;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tcl_e8_CanFuelTypeEnum CanFuelType;
   tU32 CanFuel_LOCID;
   midw_ext_fi_tclString CanFuelName;
   midw_ext_fi_tclString CanFuelPrice;
   tU8 CanFuelAge;
   midw_ext_fi_tcl_SxmLocation CanFuelLoc;
   tF32 CanFuelDistKm;
   tF32 CanFuelDistMile;
   tU32 NumPrices;
   virtual ~midw_ext_fi_tcl_CanFuelInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelTypeInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelTypeInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelTypeInfo& operator=(const midw_ext_fi_tcl_CanFuelTypeInfo& coRef);
   midw_ext_fi_tcl_CanFuelTypeInfo(const midw_ext_fi_tcl_CanFuelTypeInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_CanFuelTypeEnum CanFuelType;
   midw_ext_fi_tclString CanFuelName;
   virtual ~midw_ext_fi_tcl_CanFuelTypeInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelTypeInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8CanFuelErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8CanFuelErrorTypes();
   enum tenType {
      FI_EN_CAN_FUEL_INFOLIST_EMPTY = 1UL,
      FI_EN_CAN_FUEL_STATION_UNAVAILABLE = 2UL,
      FI_EN_CAN_FUEL_FAVLIST_EMPTY = 3UL,
      FI_EN_CAN_FUEL_BRAND_UNAVAILABLE = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8CanFuelErrorTypes(midw_ext_fi_tcl_e8CanFuelErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8CanFuelErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8CanFuelErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelTypeInfolist : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelTypeInfolist();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelTypeInfolist& operator=(const midw_ext_fi_tcl_CanFuelTypeInfolist& coRef);
   midw_ext_fi_tcl_CanFuelTypeInfolist(const midw_ext_fi_tcl_CanFuelTypeInfolist& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString FuelName;
   midw_ext_fi_tclString FuelPrice;
   tU8 FuelAge;
   tBool FuelAvail;
   midw_ext_fi_tcl_e8_CanFuelTypeEnum FuelType;
   virtual ~midw_ext_fi_tcl_CanFuelTypeInfolist();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelTypeInfolist& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelStationInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelStationInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelStationInfo& operator=(const midw_ext_fi_tcl_CanFuelStationInfo& coRef);
   midw_ext_fi_tcl_CanFuelStationInfo(const midw_ext_fi_tcl_CanFuelStationInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StationName;
   midw_ext_fi_tclString Brand;
   midw_ext_fi_tclString StreetName;
   midw_ext_fi_tclString City;
   midw_ext_fi_tclString State;
   midw_ext_fi_tclString ZipCode;
   midw_ext_fi_tclString Phone;
   tU32 Fuel_LOCID;
   midw_ext_fi_tclString Amenity;
   tBool CanFuelFavInfo;
   midw_ext_fi_tcl_SxmLocation CanFuelLocation;
   std::vector<midw_ext_fi_tcl_CanFuelTypeInfolist, std::allocator<midw_ext_fi_tcl_CanFuelTypeInfolist> > CanFuelTypelist;
   std::vector<midw_ext_fi_tcl_e8_CanFuelStationAmenity, std::allocator<midw_ext_fi_tcl_e8_CanFuelStationAmenity> > StationAmenitylist;
   tU32 NumPrices;
   virtual ~midw_ext_fi_tcl_CanFuelStationInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelStationInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelInfoList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelInfoList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelInfoList& operator=(const midw_ext_fi_tcl_CanFuelInfoList& coRef);
   midw_ext_fi_tcl_CanFuelInfoList(const midw_ext_fi_tcl_CanFuelInfoList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_CanFuelInfo, std::allocator<midw_ext_fi_tcl_CanFuelInfo> > CanFuelInfolist;
   virtual ~midw_ext_fi_tcl_CanFuelInfoList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelInfoList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanBrandNameList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanBrandNameList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanBrandNameList& operator=(const midw_ext_fi_tcl_CanBrandNameList& coRef);
   midw_ext_fi_tcl_CanBrandNameList(const midw_ext_fi_tcl_CanBrandNameList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > BrandNameList;
   virtual ~midw_ext_fi_tcl_CanBrandNameList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanBrandNameList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CanFuelTypeList : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CanFuelTypeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CanFuelTypeList& operator=(const midw_ext_fi_tcl_CanFuelTypeList& coRef);
   midw_ext_fi_tcl_CanFuelTypeList(const midw_ext_fi_tcl_CanFuelTypeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_CanFuelTypeInfo, std::allocator<midw_ext_fi_tcl_CanFuelTypeInfo> > TypeNameList;
   virtual ~midw_ext_fi_tcl_CanFuelTypeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CanFuelTypeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_ChannelPhoneticsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_ChannelPhoneticsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_ChannelPhoneticsInfo& operator=(const midw_ext_fi_tcl_ChannelPhoneticsInfo& coRef);
   midw_ext_fi_tcl_ChannelPhoneticsInfo(const midw_ext_fi_tcl_ChannelPhoneticsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > PhoneticsData;
   virtual ~midw_ext_fi_tcl_ChannelPhoneticsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_ChannelPhoneticsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_CategoryPhoneticsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_CategoryPhoneticsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_CategoryPhoneticsInfo& operator=(const midw_ext_fi_tcl_CategoryPhoneticsInfo& coRef);
   midw_ext_fi_tcl_CategoryPhoneticsInfo(const midw_ext_fi_tcl_CategoryPhoneticsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > PhoneticsData;
   virtual ~midw_ext_fi_tcl_CategoryPhoneticsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_CategoryPhoneticsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_LeaguePhoneticsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_LeaguePhoneticsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_LeaguePhoneticsInfo& operator=(const midw_ext_fi_tcl_LeaguePhoneticsInfo& coRef);
   midw_ext_fi_tcl_LeaguePhoneticsInfo(const midw_ext_fi_tcl_LeaguePhoneticsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > PhoneticsData;
   virtual ~midw_ext_fi_tcl_LeaguePhoneticsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_LeaguePhoneticsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_MarketPhoneticsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_MarketPhoneticsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_MarketPhoneticsInfo& operator=(const midw_ext_fi_tcl_MarketPhoneticsInfo& coRef);
   midw_ext_fi_tcl_MarketPhoneticsInfo(const midw_ext_fi_tcl_MarketPhoneticsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString ID;
   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > PhoneticsData;
   virtual ~midw_ext_fi_tcl_MarketPhoneticsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_MarketPhoneticsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_TeamPhoneticsInfo : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_TeamPhoneticsInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_fi_tcl_TeamPhoneticsInfo& operator=(const midw_ext_fi_tcl_TeamPhoneticsInfo& coRef);
   midw_ext_fi_tcl_TeamPhoneticsInfo(const midw_ext_fi_tcl_TeamPhoneticsInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   std::vector<tU8, std::allocator<tU8> > LeagueID;
   std::vector<midw_ext_fi_tclString, std::allocator<midw_ext_fi_tclString> > PhoneticsData;
   virtual ~midw_ext_fi_tcl_TeamPhoneticsInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_fi_tcl_TeamPhoneticsInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8PhoneticsErrorTypes : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8PhoneticsErrorTypes();
   enum tenType {
      FI_EN_PHONETICS_INFOLIST_EMPTY = 1UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8PhoneticsErrorTypes(midw_ext_fi_tcl_e8PhoneticsErrorTypes::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8PhoneticsErrorTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8PhoneticsErrorTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8PhoneticsType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8PhoneticsType();
   enum tenType {
      FI_EN_PHONETIC_TYPE_UNKNOWN = 0UL,
      FI_EN_PHONETIC_TYPE_CHANNELS = 1UL,
      FI_EN_PHONETIC_TYPE_CATEGORIES = 2UL,
      FI_EN_PHONETIC_TYPE_MARKETS = 4UL,
      FI_EN_PHONETIC_TYPE_TEAMS = 8UL,
      FI_EN_PHONETIC_TYPE_LEAGUES = 16UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8PhoneticsType(midw_ext_fi_tcl_e8PhoneticsType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8PhoneticsType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8PhoneticsType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

class midw_ext_fi_tcl_e8LanguageType : public midw_ext_fi_tclVisitableTypeBase
{
public:

   midw_ext_fi_tcl_e8LanguageType();
   enum tenType {
      FI_EN_PHONETIC_LANG_TYPE_UNKNOWN = 0UL,
      FI_EN_PHONETIC_LANG_TYPE_ENGLISH = 1UL,
      FI_EN_PHONETIC_LANG_TYPE_SPANISH = 2UL,
      FI_EN_PHONETIC_LANG_TYPE_FRENCH = 4UL
   };
   tenType enType;

   midw_ext_fi_tcl_e8LanguageType(midw_ext_fi_tcl_e8LanguageType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~midw_ext_fi_tcl_e8LanguageType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const midw_ext_fi_tcl_e8LanguageType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(midw_ext_fi_tclVisitorBase& rfoVisitor);
};

#endif
