#ifndef MIDW_EXT_TCUFITOKEN_HEADER
#define MIDW_EXT_TCUFITOKEN_HEADER

class midw_ext_tcufi_tclToken  {
 public:
  
  enum tenType {
    EN_UNKNOWN                =  0,
    EN_END_OF_STRUCT,
    EN_U8,
    EN_U16,
    EN_U24,
    EN_U32,
    EN_U64,
    EN_S8,
    EN_S16,
    EN_S24,
    EN_S32,
    EN_S64,
    EN_F32,
    EN_F64,
    EN_BOOL,
    EN_STRING,
    EN_MULTILANGUAGESTRING,
    EN_LIST,
//    EN_BINCONTAINER,
      EN_BINCONTAINER,
      EN_E8_TCU_CONFIGURATIONSTATUS,
      EN_TCU_VERSIONINFO,
      EN_E8_TCU_COMMUNICATIONSTATUS,
      EN_E8_TCU_SERVICESTATE,
      EN_E8_TCU_CURFEWWARNING,
      EN_E8_TCU_MODEMSTATUS,
      EN_E8_TCU_TCUSTATUS,
      EN_E8_TCU_GSMSTATUS,
      EN_E8_TCU_WIFISTATUS,
      EN_E8_TCU_WIFIMODE,
      EN_E8_TCU_WIFIHOTSPOTSTATUS,
      EN_E8_TCU_WIFICLIENTSTATUS,
      EN_E8_TCU_GSMDATAMODE,
      EN_E8_TCU_INVALID_PARAMETER,
      EN_E8_TCU_ROAMINGSTATUS,
      EN_E8_TCU_PPPCONNECTIONSTATUS,
      EN_E8_TCU_INVALIDPARAMETER,
      EN_E8_TCU_PERMITSETTING,
      EN_E8_TCU_APP_CONTEXT,
      EN_E8_TCU_PROBEPERMITSETTING,
      EN_E8_TCU_POPUPFLAG,
      EN_E8_TCU_OPERATIONREQUEST,
      EN_TCU_DATE_TIME,
      EN_E8_TCU_LOCATIONTYPE,
      EN_TCU_SCORE_INFO,
      EN_TCU_NAVI_ROAD_CLASSIFICATION,
      EN_TCU_DISTANCE_VALUE,
      EN_E8_TCU_DISTANCE_UNIT,
      EN_TCU_PROVISION_LIST,
      EN_E8_TCU_ECALLSTATEDISPLAY,
      EN_TCU_MAINTENANCE_INFO,
      EN_E8_TCU_LATITUDEMODE,
      EN_E8_TCU_LONGITUDEMODE,
      EN_E8_TCU_SIGN,
      EN_E8_TCU_HOME,
      EN_TCU_ALTITUDE,
      EN_TCU_LOCATIONINFO,
      EN_TCU_NAVI_INFO,
      EN_TCU_PROBE_VEHICLE_INFO,
      EN_E8_TCU_OPCODE,
      EN_E8_TCU_MODE,
      EN_TCU_REMINDERINFO,
      EN_E8_TCU_SERVICE_TYPE,
      EN_E8_TCU_EPOI_TYPE,
      EN_E8_TCU_FINDER_STATUS,
      EN_TCU_GPS_POSITION,
      EN_TCU_TIME_STAMP,
      EN_TCU_OPENING_HOUR_DAY,
      EN_TCU_OPENING_HOUR,
      EN_TCU_CHARGE_STATION_ACCESSIBILITY,
      EN_TCU_PAYMENT_METHOD_TYPE,
      EN_TCU_FULL_ADDRESS,
      EN_E8_TCU_BOOKABLE_INFORMATION,
      EN_E8_TCU_SPOT_AVAILABILITY,
      EN_TCU_BOOKABLE_FREE_TEXT,
      EN_E8_TCU_CHARGE_RECEPTACLE_TYPE,
      EN_E8_TCU_CHARGE_RECEPTACLE_FACILITY,
      EN_TCU_RECEPTACLE,
      EN_TCU_SPOT_LIST,
      EN_TCU_CHARGE_SPOT_LIST,
      EN_TCU_TIME,
      EN_E8_LANGUAGE_FAMILY_TYPE,
      EN_E8_LANGUAGE_TYPE,
      EN_TCU_NAVIGATION_LANGUAGE,
      EN_E8_TCU_BOOKING_STATUS,
      EN_E8_TCU_UNBOOKING_STATUS,
      EN_E8_TCU_UPDATE_STATUS,
      EN_E8_TCU_SCH_ACTIVATION_STATE,
      EN_TCU_CHARGE_DAYS,
      EN_E8_TCU_CHARGE_BLOCKED_STATUS,
      EN_TCU_SPOT_RECEPTACLE_TYPE,
      EN_N_DATA,
      EN_TCU_PIN,
      EN_TCU_WIFI_SSID_NAME,
      EN_TCU_WIFI_PASSKEY,
      EN_E8_TCU_WIFI_SECURITY_MODE,
      EN_E8_TCU_WIFI_VISIBILITY,
      EN_E8_TCU_WIFI_STATUS,
      EN_E8_TCU_WIFI_MODE,
      EN_E8_TCU_WIFI_CONNECTION_STATUS,
      EN_E8_TCU_WIFI_WIFI_SCAN_SECURITY,
      EN_E8_TCU_WIFI_WIFI_CLIENT_STATUS,
      EN_E8_TCU_AUDIO_SOURCEACTIVITY,
      EN_E8_TCU_CYCLE,
      EN_TCU_TIME_SLOT,
      EN_TCU_COORDINATES,
      EN_E8_TCU_RESTRICTION_AREA_TYPE,
      EN_E8_TCU_AREA_FORM,
      EN_TCU_AREA_COORDINATE,
      EN_TCU_AREA_LIMIT_COORDINATES,
      EN_TCU_TIME_LIMIT_RESTRICTION,
      EN_TCU_SPEED_LIMIT_RESTRICTION,
      EN_TCU_AREA_LIMIT_RESTRICTION,
      EN_E8_TCU_CONNECTIONTYPE,
      EN_E8_TCU_XCALL_TYPE,
      EN_E8_TCU_XCALL_LANGUAGE,
      EN_E8_TCU_RESPONSE_TIME_OUT,
      EN_TCU_RESPONSE_TIME_OUT,
      EN_E8_TCU_AVAILABILITY,
      EN_E8_TCU_CALLTYPE,
      EN_E8_TCU_PRIVACYMODES,
   EN_MSG_ACCEPTECALLREQUESTMETHODSTART = 0x20010200,
   EN_MSG_ACCEPTECALLREQUESTMETHODRESULT = 0x20010700,
   EN_MSG_ECALLCANCELLATIONORDERMETHODSTART = 0x20350200,
   EN_MSG_ECALLCANCELLATIONORDERMETHODRESULT = 0x20350700,
   EN_MSG_GETTCUSTATEMETHODSTART = 0x20020200,
   EN_MSG_GETTCUSTATEMETHODRESULT = 0x20020700,
   EN_MSG_GETIDINFOMETHODSTART = 0x20030200,
   EN_MSG_GETIDINFOMETHODRESULT = 0x20030700,
   EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODSTART = 0x20040200,
   EN_MSG_SETDRIVERINFOUPLOADPERMITMETHODRESULT = 0x20040700,
   EN_MSG_GETPROBEUPLOADPERMITMETHODSTART = 0x20050200,
   EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT = 0x20050700,
   EN_MSG_SETPROBEUPLOADPERMITMETHODSTART = 0x20060200,
   EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT = 0x20060700,
   EN_MSG_SETPROBEINFODELETEMETHODSTART = 0x20070200,
   EN_MSG_SETPROBEINFODELETEMETHODRESULT = 0x20070700,
   EN_MSG_SETSERVICECALLOPERATIONMETHODSTART = 0x20080200,
   EN_MSG_SETSERVICECALLOPERATIONMETHODRESULT = 0x20080700,
   EN_MSG_SETNAVIINFOMETHODSTART = 0x20110200,
   EN_MSG_SETNAVIINFOMETHODRESULT = 0x20110700,
   EN_MSG_SETTRIPSCOREINFOMETHODSTART = 0x20120200,
   EN_MSG_SETTRIPSCOREINFOMETHODRESULT = 0x20120700,
   EN_MSG_SETPROBEVEHICLEINFOMETHODSTART = 0x20130200,
   EN_MSG_SETPROBEVEHICLEINFOMETHODRESULT = 0x20130700,
   EN_MSG_MAINTENANCEINFOMETHODSTART = 0x20140200,
   EN_MSG_MAINTENANCEINFOMETHODRESULT = 0x20140700,
   EN_MSG_COMECALLSTARTSTATUSMETHODSTART = 0x20150200,
   EN_MSG_COMECALLSTARTSTATUSMETHODRESULT = 0x20150700,
   EN_MSG_SETTCURESETMETHODSTART = 0x20160200,
   EN_MSG_SETTCURESETMETHODRESULT = 0x20160700,
   EN_MSG_GETTCUEXTENDEDSTATEMETHODSTART = 0x20170200,
   EN_MSG_GETTCUEXTENDEDSTATEMETHODRESULT = 0x20170700,
   EN_MSG_SETPINSETTINGMETHODSTART = 0x20180200,
   EN_MSG_SETPINSETTINGMETHODRESULT = 0x20180700,
   EN_MSG_GETCHARGEREMINDERMETHODSTART = 0x20190200,
   EN_MSG_GETCHARGEREMINDERMETHODRESULT = 0x20190700,
   EN_MSG_SETCHARGEREMINDERMETHODSTART = 0x201a0200,
   EN_MSG_SETCHARGEREMINDERMETHODRESULT = 0x201a0700,
   EN_MSG_GETSTATIONFINDERMETHODSTART = 0x201b0200,
   EN_MSG_GETSTATIONFINDERMETHODRESULT = 0x201b0700,
   EN_MSG_GETCHARGESTATIONMETHODSTART = 0x201c0200,
   EN_MSG_GETCHARGESTATIONMETHODRESULT = 0x201c0700,
   EN_MSG_GETCHARGESPOTLISTMETHODSTART = 0x201d0200,
   EN_MSG_GETCHARGESPOTLISTMETHODRESULT = 0x201d0700,
   EN_MSG_GETSHORTBOOKINGMETHODSTART = 0x201e0200,
   EN_MSG_GETSHORTBOOKINGMETHODRESULT = 0x201e0700,
   EN_MSG_GETSHORTUNBOOKINGMETHODSTART = 0x201f0200,
   EN_MSG_GETSHORTUNBOOKINGMETHODRESULT = 0x201f0700,
   EN_MSG_GETUPDATEENERGYPOINTMETHODSTART = 0x20200200,
   EN_MSG_GETUPDATEENERGYPOINTMETHODRESULT = 0x20200700,
   EN_MSG_SETSCH_ACTIVATIONMETHODSTART = 0x20210200,
   EN_MSG_SETSCH_ACTIVATIONMETHODRESULT = 0x20210700,
   EN_MSG_SETSCH_UPDATE_ONBOARDMETHODSTART = 0x20220200,
   EN_MSG_SETSCH_UPDATE_ONBOARDMETHODRESULT = 0x20220700,
   EN_MSG_GETSCH_STATEMETHODSTART = 0x20230200,
   EN_MSG_GETSCH_STATEMETHODRESULT = 0x20230700,
   EN_MSG_SETWIFIHOTSPOTREQUESTMETHODSTART = 0x20240200,
   EN_MSG_SETWIFIHOTSPOTREQUESTMETHODRESULT = 0x20240700,
   EN_MSG_SETWIFIACTIVATIONREQUESTMETHODSTART = 0x20250200,
   EN_MSG_SETWIFIACTIVATIONREQUESTMETHODRESULT = 0x20250700,
   EN_MSG_SETWIFIDATARESETMETHODSTART = 0x20260200,
   EN_MSG_SETWIFIDATARESETMETHODRESULT = 0x20260700,
   EN_MSG_SETWIFICLIENTSCANMETHODSTART = 0x20270200,
   EN_MSG_SETWIFICLIENTSCANMETHODRESULT = 0x20270700,
   EN_MSG_SETWIFICLIENTCONNECTIONMETHODSTART = 0x20280200,
   EN_MSG_SETWIFICLIENTCONNECTIONMETHODRESULT = 0x20280700,
   EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODSTART = 0x20290200,
   EN_MSG_SETWIFICLIENTDISCONNECTIONMETHODRESULT = 0x20290700,
   EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODSTART = 0x202a0200,
   EN_MSG_GETWIFICONNECTEDDEVICESREQUESTMETHODRESULT = 0x202a0700,
   EN_MSG_GETWIFICLIENTSTATEMETHODSTART = 0x202b0200,
   EN_MSG_GETWIFICLIENTSTATEMETHODRESULT = 0x202b0700,
   EN_MSG_DTMECALLMETHODSTART = 0x202c0200,
   EN_MSG_DTMECALLMETHODRESULT = 0x202c0700,
   EN_MSG_RESETHISTORYMETHODSTART = 0x202d0200,
   EN_MSG_RESETHISTORYMETHODRESULT = 0x202d0700,
   EN_MSG_GETHARDWAREVERSIONMETHODSTART = 0x20320200,
   EN_MSG_GETHARDWAREVERSIONMETHODRESULT = 0x20320700,
   EN_MSG_GETSOFTWAREVERSIONMETHODSTART = 0x20330200,
   EN_MSG_GETSOFTWAREVERSIONMETHODRESULT = 0x20330700,
   EN_MSG_SETPUSH_POISTATUSMETHODSTART = 0x202e0200,
   EN_MSG_SETPUSH_POISTATUSMETHODRESULT = 0x202e0700,
   EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODSTART = 0x202f0200,
   EN_MSG_SETGEOFENCING_ACTIVATIONSTATUSMETHODRESULT = 0x202f0700,
   EN_MSG_GETRESTRICTION_SETTINGSMETHODSTART = 0x20300200,
   EN_MSG_GETRESTRICTION_SETTINGSMETHODRESULT = 0x20300700,
   EN_MSG_XCALLSTARTMETHODSTART = 0x20360200,
   EN_MSG_XCALLSTARTMETHODRESULT = 0x20360700,
   EN_MSG_SETPRIVICYMODEMETHODSTART = 0x20340200,
   EN_MSG_SETPRIVICYMODEMETHODRESULT = 0x20340700,
   EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODSTART = 0x20310200,
   EN_MSG_GETTCUCONFIGURATIONSTATUSMETHODRESULT = 0x20310700,
   EN_MSG_CONNECTIONUPREG = 0x10300,
   EN_MSG_CONNECTIONRELUPREG = 0x10400,
   EN_MSG_CONNECTIONGET = 0x10100,
   EN_MSG_CONNECTIONSTATUS = 0x10600,
   EN_MSG_CONFIGURATIONUPREG = 0x20300,
   EN_MSG_CONFIGURATIONRELUPREG = 0x20400,
   EN_MSG_CONFIGURATIONGET = 0x20100,
   EN_MSG_CONFIGURATIONSTATUS = 0x20600,
   EN_MSG_DATATRANSMISSIONUPREG = 0x50300,
   EN_MSG_DATATRANSMISSIONRELUPREG = 0x50400,
   EN_MSG_DATATRANSMISSIONGET = 0x50100,
   EN_MSG_DATATRANSMISSIONSTATUS = 0x50600,
   EN_MSG_ECALLREQUESTUPREG = 0x60300,
   EN_MSG_ECALLREQUESTRELUPREG = 0x60400,
   EN_MSG_ECALLREQUESTGET = 0x60100,
   EN_MSG_ECALLREQUESTSTATUS = 0x60600,
   EN_MSG_ECALLSERVICESTATEUPREG = 0x70300,
   EN_MSG_ECALLSERVICESTATERELUPREG = 0x70400,
   EN_MSG_ECALLSERVICESTATEGET = 0x70100,
   EN_MSG_ECALLSERVICESTATESTATUS = 0x70600,
   EN_MSG_ACNREQUESTUPREG = 0x80300,
   EN_MSG_ACNREQUESTRELUPREG = 0x80400,
   EN_MSG_ACNREQUESTGET = 0x80100,
   EN_MSG_ACNREQUESTSTATUS = 0x80600,
   EN_MSG_ACNSERVICESTATEUPREG = 0x90300,
   EN_MSG_ACNSERVICESTATERELUPREG = 0x90400,
   EN_MSG_ACNSERVICESTATEGET = 0x90100,
   EN_MSG_ACNSERVICESTATESTATUS = 0x90600,
   EN_MSG_CURFEWALERTUPREG = 0xa0300,
   EN_MSG_CURFEWALERTRELUPREG = 0xa0400,
   EN_MSG_CURFEWALERTGET = 0xa0100,
   EN_MSG_CURFEWALERTSTATUS = 0xa0600,
   EN_MSG_GEOFENCEUPREG = 0xb0300,
   EN_MSG_GEOFENCERELUPREG = 0xb0400,
   EN_MSG_GEOFENCEGET = 0xb0100,
   EN_MSG_GEOFENCESTATUS = 0xb0600,
   EN_MSG_SPEEDALERTUPREG = 0xc0300,
   EN_MSG_SPEEDALERTRELUPREG = 0xc0400,
   EN_MSG_SPEEDALERTGET = 0xc0100,
   EN_MSG_SPEEDALERTSTATUS = 0xc0600,
   EN_MSG_TCUSTATEUPREG = 0xd0300,
   EN_MSG_TCUSTATERELUPREG = 0xd0400,
   EN_MSG_TCUSTATEGET = 0xd0100,
   EN_MSG_TCUSTATESTATUS = 0xd0600,
   EN_MSG_IDINFOSTATUSUPREG = 0xe0300,
   EN_MSG_IDINFOSTATUSRELUPREG = 0xe0400,
   EN_MSG_IDINFOSTATUSGET = 0xe0100,
   EN_MSG_IDINFOSTATUSSTATUS = 0xe0600,
   EN_MSG_DRIVERINFOUPLOADPERMITSTATUSUPREG = 0xf0300,
   EN_MSG_DRIVERINFOUPLOADPERMITSTATUSRELUPREG = 0xf0400,
   EN_MSG_DRIVERINFOUPLOADPERMITSTATUSGET = 0xf0100,
   EN_MSG_DRIVERINFOUPLOADPERMITSTATUSSTATUS = 0xf0600,
   EN_MSG_SMSNOTIFICATIONSTATUSUPREG = 0x1a0300,
   EN_MSG_SMSNOTIFICATIONSTATUSRELUPREG = 0x1a0400,
   EN_MSG_SMSNOTIFICATIONSTATUSGET = 0x1a0100,
   EN_MSG_SMSNOTIFICATIONSTATUSSTATUS = 0x1a0600,
   EN_MSG_PROBEUPLOADPERMITSTATUSUPREG = 0x1b0300,
   EN_MSG_PROBEUPLOADPERMITSTATUSRELUPREG = 0x1b0400,
   EN_MSG_PROBEUPLOADPERMITSTATUSGET = 0x1b0100,
   EN_MSG_PROBEUPLOADPERMITSTATUSSTATUS = 0x1b0600,
   EN_MSG_PROBEINFODELETESTATUSUPREG = 0x1c0300,
   EN_MSG_PROBEINFODELETESTATUSRELUPREG = 0x1c0400,
   EN_MSG_PROBEINFODELETESTATUSGET = 0x1c0100,
   EN_MSG_PROBEINFODELETESTATUSSTATUS = 0x1c0600,
   EN_MSG_SERVICECALLSTATEUPREG = 0x1d0300,
   EN_MSG_SERVICECALLSTATERELUPREG = 0x1d0400,
   EN_MSG_SERVICECALLSTATEGET = 0x1d0100,
   EN_MSG_SERVICECALLSTATESTATUS = 0x1d0600,
   EN_MSG_SERVICECALLREQUESTUPREG = 0x1e0300,
   EN_MSG_SERVICECALLREQUESTRELUPREG = 0x1e0400,
   EN_MSG_SERVICECALLREQUESTGET = 0x1e0100,
   EN_MSG_SERVICECALLREQUESTSTATUS = 0x1e0600,
   EN_MSG_SERVICECALLOPERATIONSTATUSUPREG = 0x1f0300,
   EN_MSG_SERVICECALLOPERATIONSTATUSRELUPREG = 0x1f0400,
   EN_MSG_SERVICECALLOPERATIONSTATUSGET = 0x1f0100,
   EN_MSG_SERVICECALLOPERATIONSTATUSSTATUS = 0x1f0600,
   EN_MSG_TCUCALLSERVICESTATEUPREG = 0x2e0300,
   EN_MSG_TCUCALLSERVICESTATERELUPREG = 0x2e0400,
   EN_MSG_TCUCALLSERVICESTATEGET = 0x2e0100,
   EN_MSG_TCUCALLSERVICESTATESTATUS = 0x2e0600,
   EN_MSG_PROVISIONSERVICEUPREG = 0x2a0300,
   EN_MSG_PROVISIONSERVICERELUPREG = 0x2a0400,
   EN_MSG_PROVISIONSERVICEGET = 0x2a0100,
   EN_MSG_PROVISIONSERVICESTATUS = 0x2a0600,
   EN_MSG_COMECALLSTATEUPREG = 0x2b0300,
   EN_MSG_COMECALLSTATERELUPREG = 0x2b0400,
   EN_MSG_COMECALLSTATEGET = 0x2b0100,
   EN_MSG_COMECALLSTATESTATUS = 0x2b0600,
   EN_MSG_COMECALLSTARTUPREG = 0x2c0300,
   EN_MSG_COMECALLSTARTRELUPREG = 0x2c0400,
   EN_MSG_COMECALLSTARTGET = 0x2c0100,
   EN_MSG_COMECALLSTARTSTATUS = 0x2c0600,
   EN_MSG_COMECALLENDUPREG = 0x2d0300,
   EN_MSG_COMECALLENDRELUPREG = 0x2d0400,
   EN_MSG_COMECALLENDGET = 0x2d0100,
   EN_MSG_COMECALLENDSTATUS = 0x2d0600,
   EN_MSG_TCURESETSTATUSUPREG = 0x2f0300,
   EN_MSG_TCURESETSTATUSRELUPREG = 0x2f0400,
   EN_MSG_TCURESETSTATUSGET = 0x2f0100,
   EN_MSG_TCURESETSTATUSSTATUS = 0x2f0600,
   EN_MSG_EMERGENCYSTATEUPREG = 0x300300,
   EN_MSG_EMERGENCYSTATERELUPREG = 0x300400,
   EN_MSG_EMERGENCYSTATEGET = 0x300100,
   EN_MSG_EMERGENCYSTATESTATUS = 0x300600,
   EN_MSG_TCURESPONSETIMEOUTUPREG = 0x310300,
   EN_MSG_TCURESPONSETIMEOUTRELUPREG = 0x310400,
   EN_MSG_TCURESPONSETIMEOUTGET = 0x310100,
   EN_MSG_TCURESPONSETIMEOUTSTATUS = 0x310600,
   EN_MSG_TCUEXTENDEDSTATEUPREG = 0x320300,
   EN_MSG_TCUEXTENDEDSTATERELUPREG = 0x320400,
   EN_MSG_TCUEXTENDEDSTATEGET = 0x320100,
   EN_MSG_TCUEXTENDEDSTATESTATUS = 0x320600,
   EN_MSG_PINSETTINGSTATUSUPREG = 0x330300,
   EN_MSG_PINSETTINGSTATUSRELUPREG = 0x330400,
   EN_MSG_PINSETTINGSTATUSGET = 0x330100,
   EN_MSG_PINSETTINGSTATUSSTATUS = 0x330600,
   EN_MSG_CHARGEREMINDERSTATUSUPREG = 0x340300,
   EN_MSG_CHARGEREMINDERSTATUSRELUPREG = 0x340400,
   EN_MSG_CHARGEREMINDERSTATUSGET = 0x340100,
   EN_MSG_CHARGEREMINDERSTATUSSTATUS = 0x340600,
   EN_MSG_CHARGERECORDDELETEUPREG = 0x350300,
   EN_MSG_CHARGERECORDDELETERELUPREG = 0x350400,
   EN_MSG_CHARGERECORDDELETEGET = 0x350100,
   EN_MSG_CHARGERECORDDELETESTATUS = 0x350600,
   EN_MSG_STATIONFINDERSTATUSUPREG = 0x360300,
   EN_MSG_STATIONFINDERSTATUSRELUPREG = 0x360400,
   EN_MSG_STATIONFINDERSTATUSGET = 0x360100,
   EN_MSG_STATIONFINDERSTATUSSTATUS = 0x360600,
   EN_MSG_CHARGESTATIONSTATUSUPREG = 0x370300,
   EN_MSG_CHARGESTATIONSTATUSRELUPREG = 0x370400,
   EN_MSG_CHARGESTATIONSTATUSGET = 0x370100,
   EN_MSG_CHARGESTATIONSTATUSSTATUS = 0x370600,
   EN_MSG_SHORT_BOOKINGSTATUSUPREG = 0x380300,
   EN_MSG_SHORT_BOOKINGSTATUSRELUPREG = 0x380400,
   EN_MSG_SHORT_BOOKINGSTATUSGET = 0x380100,
   EN_MSG_SHORT_BOOKINGSTATUSSTATUS = 0x380600,
   EN_MSG_SHORT_BOOKINGINDICATIONUPREG = 0x390300,
   EN_MSG_SHORT_BOOKINGINDICATIONRELUPREG = 0x390400,
   EN_MSG_SHORT_BOOKINGINDICATIONGET = 0x390100,
   EN_MSG_SHORT_BOOKINGINDICATIONSTATUS = 0x390600,
   EN_MSG_SHORT_UNBOOKINGSTATUSUPREG = 0x3a0300,
   EN_MSG_SHORT_UNBOOKINGSTATUSRELUPREG = 0x3a0400,
   EN_MSG_SHORT_UNBOOKINGSTATUSGET = 0x3a0100,
   EN_MSG_SHORT_UNBOOKINGSTATUSSTATUS = 0x3a0600,
   EN_MSG_SHORT_UNBOOKINGINDICATIONUPREG = 0x3b0300,
   EN_MSG_SHORT_UNBOOKINGINDICATIONRELUPREG = 0x3b0400,
   EN_MSG_SHORT_UNBOOKINGINDICATIONGET = 0x3b0100,
   EN_MSG_SHORT_UNBOOKINGINDICATIONSTATUS = 0x3b0600,
   EN_MSG_UPDATEENERGYPOINTSTATUSUPREG = 0x3c0300,
   EN_MSG_UPDATEENERGYPOINTSTATUSRELUPREG = 0x3c0400,
   EN_MSG_UPDATEENERGYPOINTSTATUSGET = 0x3c0100,
   EN_MSG_UPDATEENERGYPOINTSTATUSSTATUS = 0x3c0600,
   EN_MSG_UPDATEENERGYPOINTINDICATIONUPREG = 0x3d0300,
   EN_MSG_UPDATEENERGYPOINTINDICATIONRELUPREG = 0x3d0400,
   EN_MSG_UPDATEENERGYPOINTINDICATIONGET = 0x3d0100,
   EN_MSG_UPDATEENERGYPOINTINDICATIONSTATUS = 0x3d0600,
   EN_MSG_SCH_ACTIVATIONSTATUSUPREG = 0x3e0300,
   EN_MSG_SCH_ACTIVATIONSTATUSRELUPREG = 0x3e0400,
   EN_MSG_SCH_ACTIVATIONSTATUSGET = 0x3e0100,
   EN_MSG_SCH_ACTIVATIONSTATUSSTATUS = 0x3e0600,
   EN_MSG_SCH_UPDATE_ONBOARDSTATUSUPREG = 0x3f0300,
   EN_MSG_SCH_UPDATE_ONBOARDSTATUSRELUPREG = 0x3f0400,
   EN_MSG_SCH_UPDATE_ONBOARDSTATUSGET = 0x3f0100,
   EN_MSG_SCH_UPDATE_ONBOARDSTATUSSTATUS = 0x3f0600,
   EN_MSG_CHARGE_BLOCKEDINDICATIONUPREG = 0x400300,
   EN_MSG_CHARGE_BLOCKEDINDICATIONRELUPREG = 0x400400,
   EN_MSG_CHARGE_BLOCKEDINDICATIONGET = 0x400100,
   EN_MSG_CHARGE_BLOCKEDINDICATIONSTATUS = 0x400600,
   EN_MSG_SCH_STATESTATUSUPREG = 0x410300,
   EN_MSG_SCH_STATESTATUSRELUPREG = 0x410400,
   EN_MSG_SCH_STATESTATUSGET = 0x410100,
   EN_MSG_SCH_STATESTATUSSTATUS = 0x410600,
   EN_MSG_SCH_STATEINDICATIONUPREG = 0x420300,
   EN_MSG_SCH_STATEINDICATIONRELUPREG = 0x420400,
   EN_MSG_SCH_STATEINDICATIONGET = 0x420100,
   EN_MSG_SCH_STATEINDICATIONSTATUS = 0x420600,
   EN_MSG_STATIONFINDERINDICATIONUPREG = 0x430300,
   EN_MSG_STATIONFINDERINDICATIONRELUPREG = 0x430400,
   EN_MSG_STATIONFINDERINDICATIONGET = 0x430100,
   EN_MSG_STATIONFINDERINDICATIONSTATUS = 0x430600,
   EN_MSG_CHARGESPOTLISTSTATUSUPREG = 0x440300,
   EN_MSG_CHARGESPOTLISTSTATUSRELUPREG = 0x440400,
   EN_MSG_CHARGESPOTLISTSTATUSGET = 0x440100,
   EN_MSG_CHARGESPOTLISTSTATUSSTATUS = 0x440600,
   EN_MSG_WIFIHOTSPOTREQUESTINDICATIONUPREG = 0x460300,
   EN_MSG_WIFIHOTSPOTREQUESTINDICATIONRELUPREG = 0x460400,
   EN_MSG_WIFIHOTSPOTREQUESTINDICATIONGET = 0x460100,
   EN_MSG_WIFIHOTSPOTREQUESTINDICATIONSTATUS = 0x460600,
   EN_MSG_WIFIHOTSPOTREQUESTUPREG = 0x470300,
   EN_MSG_WIFIHOTSPOTREQUESTRELUPREG = 0x470400,
   EN_MSG_WIFIHOTSPOTREQUESTGET = 0x470100,
   EN_MSG_WIFIHOTSPOTREQUESTSTATUS = 0x470600,
   EN_MSG_WIFIACTIVATIONREQUESTUPREG = 0x480300,
   EN_MSG_WIFIACTIVATIONREQUESTRELUPREG = 0x480400,
   EN_MSG_WIFIACTIVATIONREQUESTGET = 0x480100,
   EN_MSG_WIFIACTIVATIONREQUESTSTATUS = 0x480600,
   EN_MSG_WIFIDATARESETUPREG = 0x490300,
   EN_MSG_WIFIDATARESETRELUPREG = 0x490400,
   EN_MSG_WIFIDATARESETGET = 0x490100,
   EN_MSG_WIFIDATARESETSTATUS = 0x490600,
   EN_MSG_WIFICLIENTSCANUPREG = 0x4a0300,
   EN_MSG_WIFICLIENTSCANRELUPREG = 0x4a0400,
   EN_MSG_WIFICLIENTSCANGET = 0x4a0100,
   EN_MSG_WIFICLIENTSCANSTATUS = 0x4a0600,
   EN_MSG_WIFICLIENTSCANINDICATIONUPREG = 0x4b0300,
   EN_MSG_WIFICLIENTSCANINDICATIONRELUPREG = 0x4b0400,
   EN_MSG_WIFICLIENTSCANINDICATIONGET = 0x4b0100,
   EN_MSG_WIFICLIENTSCANINDICATIONSTATUS = 0x4b0600,
   EN_MSG_WIFICLIENTCONNECTIONUPREG = 0x4c0300,
   EN_MSG_WIFICLIENTCONNECTIONRELUPREG = 0x4c0400,
   EN_MSG_WIFICLIENTCONNECTIONGET = 0x4c0100,
   EN_MSG_WIFICLIENTCONNECTIONSTATUS = 0x4c0600,
   EN_MSG_WIFICLIENTCONNECTIONINDICATIONUPREG = 0x4d0300,
   EN_MSG_WIFICLIENTCONNECTIONINDICATIONRELUPREG = 0x4d0400,
   EN_MSG_WIFICLIENTCONNECTIONINDICATIONGET = 0x4d0100,
   EN_MSG_WIFICLIENTCONNECTIONINDICATIONSTATUS = 0x4d0600,
   EN_MSG_WIFICLIENTDISCONNECTIONUPREG = 0x4e0300,
   EN_MSG_WIFICLIENTDISCONNECTIONRELUPREG = 0x4e0400,
   EN_MSG_WIFICLIENTDISCONNECTIONGET = 0x4e0100,
   EN_MSG_WIFICLIENTDISCONNECTIONSTATUS = 0x4e0600,
   EN_MSG_WIFICLIENTSCANRESULTINDICATIONUPREG = 0x4f0300,
   EN_MSG_WIFICLIENTSCANRESULTINDICATIONRELUPREG = 0x4f0400,
   EN_MSG_WIFICLIENTSCANRESULTINDICATIONGET = 0x4f0100,
   EN_MSG_WIFICLIENTSCANRESULTINDICATIONSTATUS = 0x4f0600,
   EN_MSG_WIFICONNECTEDDEVICESREQUESTUPREG = 0x500300,
   EN_MSG_WIFICONNECTEDDEVICESREQUESTRELUPREG = 0x500400,
   EN_MSG_WIFICONNECTEDDEVICESREQUESTGET = 0x500100,
   EN_MSG_WIFICONNECTEDDEVICESREQUESTSTATUS = 0x500600,
   EN_MSG_WIFICLIENTSTATEUPREG = 0x510300,
   EN_MSG_WIFICLIENTSTATERELUPREG = 0x510400,
   EN_MSG_WIFICLIENTSTATEGET = 0x510100,
   EN_MSG_WIFICLIENTSTATESTATUS = 0x510600,
   EN_MSG_WIFICLIENTSTATEINDICATIONUPREG = 0x520300,
   EN_MSG_WIFICLIENTSTATEINDICATIONRELUPREG = 0x520400,
   EN_MSG_WIFICLIENTSTATEINDICATIONGET = 0x520100,
   EN_MSG_WIFICLIENTSTATEINDICATIONSTATUS = 0x520600,
   EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONUPREG = 0x530300,
   EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONRELUPREG = 0x530400,
   EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONGET = 0x530100,
   EN_MSG_WIFICONNECTIONDEVICEREJECTEDINDICATIONSTATUS = 0x530600,
   EN_MSG_HARDWAREVERSIONUPREG = 0x30300,
   EN_MSG_HARDWAREVERSIONRELUPREG = 0x30400,
   EN_MSG_HARDWAREVERSIONGET = 0x30100,
   EN_MSG_HARDWAREVERSIONSTATUS = 0x30600,
   EN_MSG_SOFTWAREVERSIONUPREG = 0x40300,
   EN_MSG_SOFTWAREVERSIONRELUPREG = 0x40400,
   EN_MSG_SOFTWAREVERSIONGET = 0x40100,
   EN_MSG_SOFTWAREVERSIONSTATUS = 0x40600,
   EN_MSG_PUSH_POIUPREG = 0x540300,
   EN_MSG_PUSH_POIRELUPREG = 0x540400,
   EN_MSG_PUSH_POIGET = 0x540100,
   EN_MSG_PUSH_POISTATUS = 0x540600,
   EN_MSG_TIME_LIMITUPREG = 0x550300,
   EN_MSG_TIME_LIMITRELUPREG = 0x550400,
   EN_MSG_TIME_LIMITGET = 0x550100,
   EN_MSG_TIME_LIMITSTATUS = 0x550600,
   EN_MSG_SPEED_LIMITUPREG = 0x560300,
   EN_MSG_SPEED_LIMITRELUPREG = 0x560400,
   EN_MSG_SPEED_LIMITGET = 0x560100,
   EN_MSG_SPEED_LIMITSTATUS = 0x560600,
   EN_MSG_AREA_LIMITUPREG = 0x570300,
   EN_MSG_AREA_LIMITRELUPREG = 0x570400,
   EN_MSG_AREA_LIMITGET = 0x570100,
   EN_MSG_AREA_LIMITSTATUS = 0x570600,
   EN_MSG_GEOFENCING_ACTIVATIONUPREG = 0x580300,
   EN_MSG_GEOFENCING_ACTIVATIONRELUPREG = 0x580400,
   EN_MSG_GEOFENCING_ACTIVATIONGET = 0x580100,
   EN_MSG_GEOFENCING_ACTIVATIONSTATUS = 0x580600,
   EN_MSG_RESTRICTION_SETTINGSUPREG = 0x590300,
   EN_MSG_RESTRICTION_SETTINGSRELUPREG = 0x590400,
   EN_MSG_RESTRICTION_SETTINGSGET = 0x590100,
   EN_MSG_RESTRICTION_SETTINGSSTATUS = 0x590600,
   EN_MSG_CONNECTION_SETUP_STATUSUPREG = 0x610300,
   EN_MSG_CONNECTION_SETUP_STATUSRELUPREG = 0x610400,
   EN_MSG_CONNECTION_SETUP_STATUSGET = 0x610100,
   EN_MSG_CONNECTION_SETUP_STATUSSTATUS = 0x610600,
   EN_MSG_XCALLSTATUSUPREG = 0x5a0300,
   EN_MSG_XCALLSTATUSRELUPREG = 0x5a0400,
   EN_MSG_XCALLSTATUSGET = 0x5a0100,
   EN_MSG_XCALLSTATUSSTATUS = 0x5a0600,
   EN_MSG_XCALLSTATEUPREG = 0x5b0300,
   EN_MSG_XCALLSTATERELUPREG = 0x5b0400,
   EN_MSG_XCALLSTATEGET = 0x5b0100,
   EN_MSG_XCALLSTATESTATUS = 0x5b0600,
   EN_MSG_XCALLENDUPREG = 0x5c0300,
   EN_MSG_XCALLENDRELUPREG = 0x5c0400,
   EN_MSG_XCALLENDGET = 0x5c0100,
   EN_MSG_XCALLENDSTATUS = 0x5c0600,
   EN_MSG_CALLDUARTIONUPREG = 0x5d0300,
   EN_MSG_CALLDUARTIONRELUPREG = 0x5d0400,
   EN_MSG_CALLDUARTIONGET = 0x5d0100,
   EN_MSG_CALLDUARTIONSTATUS = 0x5d0600,
   EN_MSG_PRIVACYMODEACTIVATIONUPREG = 0x5e0300,
   EN_MSG_PRIVACYMODEACTIVATIONRELUPREG = 0x5e0400,
   EN_MSG_PRIVACYMODEACTIVATIONGET = 0x5e0100,
   EN_MSG_PRIVACYMODEACTIVATIONSTATUS = 0x5e0600,
   EN_MSG_TCUCONFIGURATIONSTATUSUPREG = 0x600300,
   EN_MSG_TCUCONFIGURATIONSTATUSRELUPREG = 0x600400,
   EN_MSG_TCUCONFIGURATIONSTATUSGET = 0x600100,
   EN_MSG_TCUCONFIGURATIONSTATUSSTATUS = 0x600600,
    EN_LAST_TOKEN
  };
  
};

// --Semantische Beschreibung 
class midw_ext_tcufi_tclSemanticDomain  {
 public:
  
  enum tenType {
    EN_UNKNOWN,
    EN_LIST_ELEMENT,
    EN_DATA_TYPE,
    EN_DATA_MASK,
    EN_BINCONTAINER,
//    EN_CONTAINER_DATA
      EN_ALTITUDE,
      EN_CONTAINERDATALIST,
      EN_DAY1,
      EN_DAY2,
      EN_DAY3,
      EN_DAY4,
      EN_DAY5,
      EN_DAY6,
      EN_DAY7,
      EN_LOCATIONINFO,
      EN_NAVIROADCLASSIFICATION,
      EN_BCHARGINGSCHEDULE,
      EN_BCHARGINGSPOTFINDER,
      EN_BCONNECTEDSEARCH,
      EN_BFUELPRICE,
      EN_BHDTRAFFIC,
      EN_BINTERNETWIDGET,
      EN_BLIVESERVICES,
      EN_BLOCALSEARCH,
      EN_BMOBILEINFORMATION,
      EN_BOPERATORSERVICE,
      EN_BPREVENTNAV,
      EN_BSPEEDTRAP,
      EN_BWEATHER,
      EN_BWEBPRETRIP,
      EN_E8AREA_FORM,
      EN_E8BOOKABLE_INFORMATION,
      EN_E8CHARGE_RECEPTACLE_FACILITY,
      EN_E8CHARGE_RECEPTACLE_TYPE,
      EN_E8CYCLE,
      EN_E8DISTANCEUNIT,
      EN_E8HOME,
      EN_E8LANGUAGE_FAMILY_TYPE,
      EN_E8LANGUAGE_TYPE,
      EN_E8LATITUDEMODE,
      EN_E8LOCATIONTYPE,
      EN_E8LONGITUDEMODE,
      EN_E8PLUGIN_MODE,
      EN_E8RESTRICTION_AREA_TYPE,
      EN_E8SIGN,
      EN_E8SPOT_AVAILABILITY,
      EN_E8STOP_MODE,
      EN_ETIME_OUT_TYPE,
      EN_RAREA_COORDINATES,
      EN_RAREA_LIMIT_COORDINATES,
      EN_RBOOKABLE_FREE_TEXT,
      EN_RCOORDINATES1,
      EN_RCOORDINATES2,
      EN_RDATETIME,
      EN_RDEFAULT_RECEPTACLE_TYPE,
      EN_RDISTANCEVALUE,
      EN_RFRIDAY,
      EN_RLIMITED_VEHICLE_SPEED,
      EN_RMONDAY,
      EN_RPIN_ID,
      EN_RPIN_PASSWORD,
      EN_RRECEPTACLE1,
      EN_RRECEPTACLE10,
      EN_RRECEPTACLE2,
      EN_RRECEPTACLE3,
      EN_RRECEPTACLE4,
      EN_RRECEPTACLE5,
      EN_RRECEPTACLE6,
      EN_RRECEPTACLE7,
      EN_RRECEPTACLE8,
      EN_RRECEPTACLE9,
      EN_RSATURDAY,
      EN_RSPOT_LIST1,
      EN_RSPOT_LIST2,
      EN_RSPOT_LIST3,
      EN_RSPOT_LIST4,
      EN_RSTART_TIMESTAMP,
      EN_RSTOP_TIMESTAMP,
      EN_RSUNDAY,
      EN_RTHURSDAY,
      EN_RTIME_SLOT,
      EN_RTUESDAY,
      EN_RUSER_RECEPTACLE_TYPE_1,
      EN_RUSER_RECEPTACLE_TYPE_2,
      EN_RUSER_RECEPTACLE_TYPE_3,
      EN_RWEDNESDAY,
      EN_SCHARGE_SPOT_ID,
      EN_STEXT,
      EN_STEXT_INFO,
      EN_U16ACFILTER,
      EN_U16AVAILABLE_POWER,
      EN_U16BATTERY,
      EN_U16LATITUDESEC,
      EN_U16LONGITUDESEC,
      EN_U16NAVIVEHICLESPEED,
      EN_U16OIL,
      EN_U16OILFILTER,
      EN_U16RADIUS,
      EN_U16REMAINTIME,
      EN_U16RESERVE,
      EN_U16RESERVENISSAN,
      EN_U16RESERVERENAULT,
      EN_U16TIRE,
      EN_U16USER,
      EN_U16VALUE,
      EN_U16VEHICLEHEADING,
      EN_U16YEAR,
      EN_U32NAVIDRIVINGDISTANCE,
      EN_U8CHARCTERSET,
      EN_U8CRUISESCORE,
      EN_U8DAY,
      EN_U8ECOSCORE,
      EN_U8ENDTIME_1,
      EN_U8ENDTIME_2,
      EN_U8HOUR,
      EN_U8LATITUDEDEG,
      EN_U8LATITUDEMIN,
      EN_U8LENGTH,
      EN_U8LENGTH_OF_TEXT,
      EN_U8LENTGHOFTEXT,
      EN_U8LONGITUDEDEG,
      EN_U8LONGITUDEMIN,
      EN_U8LOWER,
      EN_U8MID,
      EN_U8MINUTE,
      EN_U8MONTH,
      EN_U8PAGES_OF_LIST,
      EN_U8RESERVE,
      EN_U8RESERVED,
      EN_U8RESERVED1,
      EN_U8RESERVED2,
      EN_U8RESERVED3,
      EN_U8RESERVED4,
      EN_U8ROADTYPE,
      EN_U8SATELLITENUMBER,
      EN_U8SECOND,
      EN_U8SECONDS,
      EN_U8SLOWDOWNSCORE,
      EN_U8STARTSCORE,
      EN_U8STARTTIME_1,
      EN_U8STARTTIME_2,
      EN_U8STATION_LIST_NUMBER,
      EN_U8TABLETYPE,
      EN_U8TIMEZONE,
      EN_U8TOTAL_NUMBER_RECEPTACLES,
      EN_U8TOTAL_PAGES_OF_LISTS,
      EN_U8UPPER,
      EN_U8YEAR,
   EN_MSG_MAINTENANCEINFO,
   EN_MSG_MAPVERSION,
   EN_MSG_NAVIID,
   EN_MSG_PROVISIONSERVICE,
   EN_MSG_TCURESPONSETIMEOUT,
   EN_MSG_BACNACTIVE,
   EN_MSG_BAUTOCONFIGURED,
   EN_MSG_BCONNECTED,
   EN_MSG_BECALLACCEPTED,
   EN_MSG_BECALLACTIVE,
   EN_MSG_BEMERGENCYSTATEFROMTCU,
   EN_MSG_BISECALLCALLBACKREQUEST,
   EN_MSG_BISVALID,
   EN_MSG_BSERVICECALLACTIVE,
   EN_MSG_BSTATUSFROMTCU,
   EN_MSG_BTCUSERVICECALLOPERATIONSETTIMEOUT,
   EN_MSG_BVALID,
   EN_MSG_E8ACNCALLSERVICESTATE,
   EN_MSG_E8ACNSERVICESTATE,
   EN_MSG_E8APPCONTEXT,
   EN_MSG_E8BOOKING_STATUS,
   EN_MSG_E8CHARGE_BLOCKED_STATUS,
   EN_MSG_E8CHARGE_RECEPTACLE_FACILITY_BYTE,
   EN_MSG_E8CHARGE_RECEPTACLE_TYPE,
   EN_MSG_E8CHARGE_STATION_ACCESSIBILITY,
   EN_MSG_E8COMMUNICATIONSTATUS,
   EN_MSG_E8CONFIGURATIONSTATUS,
   EN_MSG_E8CONNECTIONTYPE,
   EN_MSG_E8CURFEWALERTWARNING,
   EN_MSG_E8ECALLSERVICESTATE,
   EN_MSG_E8ECALLSTATEDISPLAY,
   EN_MSG_E8EMERGENCYCALLSERVICESTATE,
   EN_MSG_E8FINDERSTATUS,
   EN_MSG_E8GSMDATAMODE,
   EN_MSG_E8GSMSTATUS,
   EN_MSG_E8INVALIDPARAMETER,
   EN_MSG_E8INVALIDPARMETER,
   EN_MSG_E8INVALID_PARAMETER,
   EN_MSG_E8MODEMSTATUS,
   EN_MSG_E8OPCODE,
   EN_MSG_E8OPERATIONREQUEST,
   EN_MSG_E8PPP_CONNECTION_STATUS,
   EN_MSG_E8PAYMENT_METHOD_TYPE,
   EN_MSG_E8PERMITSETTING,
   EN_MSG_E8POPUPFLAG,
   EN_MSG_E8PRIVACYMODE,
   EN_MSG_E8PROBEPERMITSETTING,
   EN_MSG_E8ROAMINGSTATUS,
   EN_MSG_E8SCH_ACTIVATION_STATE,
   EN_MSG_E8SERVICESTATE,
   EN_MSG_E8SERVICETYPE,
   EN_MSG_E8SOURCEACTIVITY,
   EN_MSG_E8TCUSTATUS,
   EN_MSG_E8UNBOOKING_STATUS,
   EN_MSG_E8UPDATE_STATUS,
   EN_MSG_E8WIFICLIENTSTATUS,
   EN_MSG_E8WIFIHOTSPOTSTATUS,
   EN_MSG_E8WIFIMODE,
   EN_MSG_E8WIFISTATUS,
   EN_MSG_E8WIFI_CLIENT_STATUS,
   EN_MSG_E8WIFI_CONNECTION_STATUS,
   EN_MSG_E8WIFI_MODE,
   EN_MSG_E8WIFI_SCAN_SECURITY,
   EN_MSG_E8WIFI_SECURITY_MODE,
   EN_MSG_E8WIFI_STATUS,
   EN_MSG_E8WIFI_VISIBILITY,
   EN_MSG_E8XCALLLANGUAGE,
   EN_MSG_E8XCALLSTATE,
   EN_MSG_E8XCALLTYPE,
   EN_MSG_E8EPOI_TYPE,
   EN_MSG_RAREA_LIMIT_COORDINATES,
   EN_MSG_RAREA_LIMIT_RESTRICTION,
   EN_MSG_RBOOKABLE_FREE_TEXT,
   EN_MSG_RCALLDUARTION,
   EN_MSG_RCALLTYPE,
   EN_MSG_RCHARGESPOTLIST,
   EN_MSG_RCHARGE_DAY1_7_END,
   EN_MSG_RCHARGE_DAY1_7_START,
   EN_MSG_REPOI_GPS_POSITION,
   EN_MSG_RFULL_ADDRESS,
   EN_MSG_RHARDWAREVERSION,
   EN_MSG_RMAX_TIME_TO_ARRIVE,
   EN_MSG_RMAX_TIME_TO_UNBOOK,
   EN_MSG_RMESSAGEVERSION,
   EN_MSG_RNAVIDATA,
   EN_MSG_RNAVIGATION_LANGUAGE,
   EN_MSG_ROPENING_HOUR,
   EN_MSG_RPIN,
   EN_MSG_RPOI_GPS_POSITION,
   EN_MSG_RPROBEVEHICLEINFO,
   EN_MSG_RREMINDERINFO,
   EN_MSG_RSEARCH_GPS_POSITION,
   EN_MSG_RSERVICE_TIME_REQUEST,
   EN_MSG_RSOFTWAREVERSION,
   EN_MSG_RSPEED_LIMIT_RESTRICTION,
   EN_MSG_RSPOT_RECEPTACLE_TYPE,
   EN_MSG_RTCU_CURRENTAVAILABILITYCONFIGURATION,
   EN_MSG_RTIME_LIMIT_RESTRICTION,
   EN_MSG_RTIME_SLOT,
   EN_MSG_RTIME_STAMP,
   EN_MSG_RTRIPECOSCOREINFO,
   EN_MSG_RWIFI_PASSKEY,
   EN_MSG_RWIFI_SSID,
   EN_MSG_RWIFI_SSID_NAME,
   EN_MSG_RWIFI_SCAN_SSID_NAME,
   EN_MSG_SBOOKING_ID,
   EN_MSG_SCHARGE_SPOT_ID,
   EN_MSG_SCHARGE_STATION_ID,
   EN_MSG_SCURRENTCOUNTRY,
   EN_MSG_SCURRENT_COUNTRY,
   EN_MSG_SCUSTOMER_CONTRACT_ID,
   EN_MSG_SENERGY_PROVIDER_NAME,
   EN_MSG_SICCID,
   EN_MSG_SICC_ID,
   EN_MSG_SIMEINUMBER,
   EN_MSG_SMOBILE_NETWORK_NAME,
   EN_MSG_SPOI_NAME,
   EN_MSG_SPHONE_NUMBER,
   EN_MSG_STCUID,
   EN_MSG_SUTILITY_AGGREGATOR_ID,
   EN_MSG_SVIN,
   EN_MSG_U16INFORMATIONCHANNEL,
   EN_MSG_U16LIMITED_VEHICLE_SPEED,
   EN_MSG_U16MCC,
   EN_MSG_U16VEHICLE_AUTONOMY,
   EN_MSG_U32BATTERYIDENTIFICATIONNUMBER,
   EN_MSG_U32BATTERY_IDENTIFICATION_NUMBER,
   EN_MSG_U32POI_ID,
   EN_MSG_U8ABSENCESTATE,
   EN_MSG_U8CHARGE_STAION_RANKING,
   EN_MSG_U8CONNECTINGPOINT,
   EN_MSG_U8GSMRSSILEVEL,
   EN_MSG_U8GEOFENCING_ACTIVATION_STATE ,
   EN_MSG_U8MNC,
   EN_MSG_U8MPDTMUTESTATE,
   EN_MSG_U8MUTESTATE,
   EN_MSG_U8NUMBER_AVAILABLE_BATTERIES,
   EN_MSG_U8PAGES_OF_LIST,
   EN_MSG_U8SPOT_TOTAL_NUMBER,
   EN_MSG_U8STATION_LIST_NUMBER,
   EN_MSG_U8TCURESPONSETIMEOUT,
   EN_MSG_U8TOTAL_STATION_NUMBER,
   EN_MSG_U8UNITID,
   EN_MSG_U8WIFICLIENTPOWER,
   EN_MSG_U8WIFICLIENTSSID,
   EN_MSG_U8WIFI_CHANNEL_NUMBER,
   EN_MSG_U8WIFI_CLIENT_POWER,
   EN_MSG_U8WIFI_CONNECTED_DEVICES,
   EN_MSG_U8WIFI_SCAN_POWER,
    EN_LAST_SEMANTICDOMAIN
  };
  
};

#endif
