/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_WSALERTSFITYPES_HEADER
#define MIDW_EXT_SXM_WSALERTSFITYPES_HEADER


class midw_ext_sxm_wsalertsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_WSALERTS_FI message types

fi_tclMessageBase* midw_ext_sxm_wsalertsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_wsalertsfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_wsalertsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListId;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListId;
   std::vector<midw_ext_fi_tcl_WSAlertMsg, std::allocator<midw_ext_fi_tcl_WSAlertMsg> > WSAlertMsglist;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   std::vector<midw_ext_fi_tcl_WSAlertMsg, std::allocator<midw_ext_fi_tcl_WSAlertMsg> > Alerts;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_e8_WSAlertTypes, std::allocator<midw_ext_fi_tcl_e8_WSAlertTypes> > AlertTypeIDs;
   midw_ext_fi_tcl_e8_WSAlertActionType WSAlertAction;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_WSAlertMsg WSAlertMsgInfo;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   midw_ext_fi_tcl_e8_WSAlertAnnounceAction Action;
   midw_ext_fi_tclString Text;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_WSAlertConfig, std::allocator<midw_ext_fi_tcl_WSAlertConfig> > AlertConfig;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& operator=(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& operator=(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   tBool Status;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos WSAlertsListStatus;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UpdateCounter;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_WSAlertMsg, std::allocator<midw_ext_fi_tcl_WSAlertMsg> > WSAlertList;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& operator=(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& coRef);
   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MessageID;
   midw_ext_fi_tcl_e8_WSAlertAnnounceStatus WSAlertAnnounceStatus;
   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg : public midw_ext_sxm_wsalertsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg();

   virtual ~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
