/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_WSALERTSFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_WSALERTSFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_WSALERTSFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_WSALERTS_FI message types

fi_tclMessageBase* midw_ext_sxm_wsalertsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGDETAILSMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGDETAILSMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_ANNOUNCEWSALERTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_ANNOUNCEWSALERTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSPROJECTCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSPROJECTCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_VALIDATEWSALERTMESSAGEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_VALIDATEWSALERTMESSAGEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSGET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODEUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODERELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATAGET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATAUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATARELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSGET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSSTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSRELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSGET:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg;

      case midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_wsalertsfifi messages

// common functions

tU16 midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_WSALERTSFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   ListId = coRef.ListId;
}
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListId = coRef.ListId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart()
:ListId(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGLISTMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListId);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListId);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListId == roRef.ListId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   ListId = coRef.ListId;
   WSAlertMsglist = coRef.WSAlertMsglist;
}
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListId = coRef.ListId;
   WSAlertMsglist = coRef.WSAlertMsglist;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WSAlertMsglist.size(); ++u32Idx)
         WSAlertMsglist[u32Idx].vDestroy();
   WSAlertMsglist.clear();
   }
}

midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult()
:ListId(0)

 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGLISTMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WSAlertMsglist.size(); ++u32ListIdx)
      u32DynamicSize += WSAlertMsglist[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WSAlertMsglist.size(); ++u32Idx)
      {
         WSAlertMsglist[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WSAlertMsglist.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WSAlertMsglist[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListId);
   (tVoid) (oOut << (tU32)WSAlertMsglist.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WSAlertMsglist.size(); ++u32Idx)
         (tVoid) (oOut << WSAlertMsglist[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListId == roRef.ListId);
      bResult = bResult && (WSAlertMsglist.size() == roRef.WSAlertMsglist.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WSAlertMsglist.size()); ++u32Idx)
            bResult = bResult && (WSAlertMsglist[u32Idx] == roRef.WSAlertMsglist[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart::midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Alerts = coRef.Alerts;
}
midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Alerts = coRef.Alerts;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Alerts.size(); ++u32Idx)
         Alerts[u32Idx].vDestroy();
   Alerts.clear();
   }
}

midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult()
:UpdateCounter(0)

 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWEATHERALERTDATAMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Alerts.size(); ++u32ListIdx)
      u32DynamicSize += Alerts[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Alerts.size(); ++u32Idx)
      {
         Alerts[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Alerts.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Alerts[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   (tVoid) (oOut << (tU32)Alerts.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Alerts.size(); ++u32Idx)
         (tVoid) (oOut << Alerts[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
      bResult = bResult && (Alerts.size() == roRef.Alerts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Alerts.size()); ++u32Idx)
            bResult = bResult && (Alerts[u32Idx] == roRef.Alerts[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   AlertTypeIDs = coRef.AlertTypeIDs;
   WSAlertAction = coRef.WSAlertAction;
}
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AlertTypeIDs = coRef.AlertTypeIDs;
   WSAlertAction = coRef.WSAlertAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::vDestroy()
{
   {
   AlertTypeIDs.clear();
   }
}

midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart()

:WSAlertAction()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSCONFIGMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(AlertTypeIDs.size()*1);
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      AlertTypeIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AlertTypeIDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> WSAlertAction);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AlertTypeIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AlertTypeIDs.size(); ++u32Idx)
         (tVoid) (oOut << AlertTypeIDs[u32Idx]);
   }
   (tVoid) (oOut << WSAlertAction);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AlertTypeIDs.size() == roRef.AlertTypeIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlertTypeIDs.size()); ++u32Idx)
            bResult = bResult && (AlertTypeIDs[u32Idx] == roRef.AlertTypeIDs[u32Idx]);
      }
   bResult = bResult && (WSAlertAction == roRef.WSAlertAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSCONFIGMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   MessageID = coRef.MessageID;
}
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MessageID = coRef.MessageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart()
:MessageID(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGDETAILSMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MessageID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MessageID);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MessageID == roRef.MessageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   WSAlertMsgInfo = coRef.WSAlertMsgInfo;
}
midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WSAlertMsgInfo = coRef.WSAlertMsgInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::vDestroy()
{
   WSAlertMsgInfo.vDestroy(); 
}

midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult()
:WSAlertMsgInfo()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_GETWSALERTMSGDETAILSMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+WSAlertMsgInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WSAlertMsgInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WSAlertMsgInfo);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WSAlertMsgInfo == roRef.WSAlertMsgInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   MessageID = coRef.MessageID;
   Action = coRef.Action;
   Text = coRef.Text;
}
midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MessageID = coRef.MessageID;
   Action = coRef.Action;
   Text = coRef.Text;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::vDestroy()
{
   Text.vDestroy();
}

midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart()
:MessageID(0)
,Action()
,Text()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_ANNOUNCEWSALERTMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Text.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MessageID);
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> Text);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MessageID);
   (tVoid) (oOut << Action);
   (tVoid) (oOut << Text);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MessageID == roRef.MessageID);
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (Text == roRef.Text);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_ANNOUNCEWSALERTMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   AlertConfig = coRef.AlertConfig;
}
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AlertConfig = coRef.AlertConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AlertConfig.size(); ++u32Idx)
         AlertConfig[u32Idx].vDestroy();
   AlertConfig.clear();
   }
}

midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart()

 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSPROJECTCONFIGMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AlertConfig.size(); ++u32ListIdx)
      u32DynamicSize += AlertConfig[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlertConfig.size(); ++u32Idx)
      {
         AlertConfig[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AlertConfig.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AlertConfig[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AlertConfig.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AlertConfig.size(); ++u32Idx)
         (tVoid) (oOut << AlertConfig[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AlertConfig.size() == roRef.AlertConfig.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlertConfig.size()); ++u32Idx)
            bResult = bResult && (AlertConfig[u32Idx] == roRef.AlertConfig[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SETWSALERTSPROJECTCONFIGMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   MessageID = coRef.MessageID;
}
midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::operator=(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MessageID = coRef.MessageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart()
:MessageID(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_VALIDATEWSALERTMESSAGEMETHODSTART;
}


midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::~midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MessageID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MessageID);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart::operator==(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MessageID == roRef.MessageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   MessageID = coRef.MessageID;
   Status = coRef.Status;
}
midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::operator=(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MessageID = coRef.MessageID;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult()
:MessageID(0)
,Status(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_VALIDATEWSALERTMESSAGEMETHODRESULT;
}


midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::~midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MessageID);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MessageID);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult::operator==(const midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MessageID == roRef.MessageID);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet::midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSGET;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   WSAlertsListStatus = coRef.WSAlertsListStatus;
}
midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   WSAlertsListStatus = coRef.WSAlertsListStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::vDestroy()
{
   WSAlertsListStatus.vDestroy(); 
}

midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus()
:WSAlertsListStatus()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSSTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+WSAlertsListStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WSAlertsListStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WSAlertsListStatus);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WSAlertsListStatus == roRef.WSAlertsListStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg::midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTSINFOLISTSTATUSRELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertsInfoListStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODEUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg::~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_SXMLISTMODERELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgSxmListModeRelUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet::midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATAGET;
}


midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet::~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}
midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus()
:UpdateCounter(0)
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATASTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateCounter);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateCounter);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateCounter == roRef.UpdateCounter);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg::midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATAUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WEATHERALERTDATARELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWeatherAlertDataRelUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet::midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSGET;
}


midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet::~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   WSAlertList = coRef.WSAlertList;
}
midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& coRef)
{
   if (this == &coRef) return *this;
   WSAlertList = coRef.WSAlertList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WSAlertList.size(); ++u32Idx)
         WSAlertList[u32Idx].vDestroy();
   WSAlertList.clear();
   }
}

midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus()

 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSSTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WSAlertList.size(); ++u32ListIdx)
      u32DynamicSize += WSAlertList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WSAlertList.size(); ++u32Idx)
      {
         WSAlertList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WSAlertList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WSAlertList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)WSAlertList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WSAlertList.size(); ++u32Idx)
         (tVoid) (oOut << WSAlertList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (WSAlertList.size() == roRef.WSAlertList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WSAlertList.size()); ++u32Idx)
            bResult = bResult && (WSAlertList[u32Idx] == roRef.WSAlertList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg::midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg::~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_CURRENTWSALERTSRELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgCurrentWSAlertsRelUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet::midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSGET;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& coRef)
   : midw_ext_sxm_wsalertsfi_tclMsgBaseMessage(coRef)
{
   MessageID = coRef.MessageID;
   WSAlertAnnounceStatus = coRef.WSAlertAnnounceStatus;
}
midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::operator=(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   MessageID = coRef.MessageID;
   WSAlertAnnounceStatus = coRef.WSAlertAnnounceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus()
:MessageID(0)
,WSAlertAnnounceStatus()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSSTATUS;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus()
{}

tU32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MessageID);
   (tVoid) (oIn >> WSAlertAnnounceStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MessageID);
   (tVoid) (oOut << WSAlertAnnounceStatus);
   return oOut;
}

tBool midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus::operator==(const midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MessageID == roRef.MessageID);
   bResult = bResult && (WSAlertAnnounceStatus == roRef.WSAlertAnnounceStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg::midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg::midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_wsalertsfi_tclToken::EN_MSG_WSALERTANNOUNCESTATUSRELUPREG;
}


midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg::~midw_ext_sxm_wsalertsfi_tclMsgWSAlertAnnounceStatusRelUpReg()
{}

