/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_STOCKSFITYPES_HEADER
#define MIDW_EXT_SXM_STOCKSFITYPES_HEADER


class midw_ext_sxm_stocksfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_STOCKS_FI message types

fi_tclMessageBase* midw_ext_sxm_stocksfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_stocksfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_stocksfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmListInfo ListInfo;
   midw_ext_fi_tcl_StockQuoteList StocksQuoteList;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StockSymbol;
   virtual ~midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StockSymbol;
   virtual ~midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StockFilter;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_StockFilterList StockFilterList;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart();

   virtual ~midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString DataProviderInfo;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString StockFilter;
   tBool IsBackSpace;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& operator=(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& coRef);
   midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_StockFilterList StockFilterList;
   midw_ext_fi_tclString AllCharsToEnable;
   midw_ext_fi_tclString DisplayString;
   tU32 Count;
   virtual ~midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart();

   virtual ~midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult();

   virtual ~midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgStockStatusGet : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgStockStatusGet();

   virtual ~midw_ext_sxm_stocksfi_tclMsgStockStatusGet();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgStockStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgStockStatusStatus : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgStockStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& operator=(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& coRef);
   midw_ext_sxm_stocksfi_tclMsgStockStatusStatus(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos StockStatus;
   virtual ~midw_ext_sxm_stocksfi_tclMsgStockStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgStockStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgStockStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgStockStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmListModeSet : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_stocksfi_tclMsgSxmListModeSet(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& operator=(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& coRef);
   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DataProviderInfoStatus;
   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg : public midw_ext_sxm_stocksfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg();

   virtual ~midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_stocksfi_tclMsgSxmStocksDataProviderInfoStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
