/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_SPORTSFITYPES_HEADER
#define MIDW_EXT_SXM_SPORTSFITYPES_HEADER


class midw_ext_sxm_sportsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_SPORTS_FI message types

fi_tclMessageBase* midw_ext_sxm_sportsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_sportsfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_sportsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart();

   virtual ~midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SportList SportList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetSportListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_RootAffiliateList RootAffiliateList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 AFFILIATE_ID;
   tU8 SportID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_AffiliateDetails AffiliateDetails;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   tU32 AFFILIATE_ID;
   tU32 TEAM_ID;
   midw_ext_fi_tcl_GameType GameType;
   tU32 Game_ID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_GameList GameList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 AFFILIATE_ID;
   tU8 SportID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_NewsList News;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 AFFILIATE_ID;
   tU8 SportID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TeamList TeamList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetTopTeamsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 AFFILIATE_ID;
   tU8 SportID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TeamList AllTeamList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart();

   virtual ~midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_FavoriteList FavoriteList;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   tU32 AFFILIATE_ID;
   tU32 TEAM_ID;
   tBool FavoriteControl;
   virtual ~midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   tBool FavoriteControl;
   virtual ~midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   tU32 AFFILIATE_ID;
   midw_ext_fi_tcl_GameType EventType;
   tU32 Event_ID;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_EventSchedule_List ScheduledEvents;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& operator=(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   tU32 AFFILIATE_ID;
   midw_ext_fi_tcl_GameType EventType;
   tS32 TableParam;
   tS32 TableRef;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& operator=(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& coRef);
   midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_EventRankList EventInfo;
   virtual ~midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& operator=(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& coRef);
   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8SportsServiceDataStatus SportsStatus;
   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsServiceDataStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& operator=(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& coRef);
   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SportID;
   tU32 LeagueID;
   midw_ext_fi_tcl_SportsUpdateType UpdateType;
   midw_ext_fi_tcl_e8CategoryAvailability UpdateStatus;
   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg : public midw_ext_sxm_sportsfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg();

   virtual ~midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_sportsfi_tclMsgSportsDataUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
