#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SPORTSFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_sxm_sportsfi_tclDescription::bInitMessage(midw_ext_sxm_sportsfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_sxm_sportsfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_sxm_sportsfi_tclToken::EN_LIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_sxm_sportsfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_SPORTLIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTLIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_ROOTAFFILIATELIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_ROOTAFFILIATELIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILS,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATEDETAILS)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_GAME_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_GAMETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_TEAM_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMELIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_GAMELIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_NEWSLIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_NEWS)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TEAMLIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_TEAMLIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TEAMLIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_ALLTEAMLIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_FAVORITELIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_FAVORITELIST)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_FAVORITECONTROL)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_TEAM_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_FAVORITECONTROL)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_EVENT_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_EVENTTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SCHEDULEDEVENTS)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_S32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_TABLEREF)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_S32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_TABLEPARAM)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_EVENTTYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_AFFILIATE_ID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANKLIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_EVENTINFO)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_E8SPORTSSERVICEDATASTATUS,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTSSTATUS)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_E8CATEGORYAVAILABILITY,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_UPDATESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_SPORTSUPDATETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_UPDATETYPE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_LEAGUEID)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_MSG_SPORTID)) && bResult;
   } break;
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODSTART:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODSTART:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSGET:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSUPREG:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSRELUPREG:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEGET:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEUPREG:
   case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATERELUPREG:
   case midw_ext_sxm_sportsfi_tclToken::EN_BINCONTAINER:
   case midw_ext_sxm_sportsfi_tclToken::EN_SPORTINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_SPORTLIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_E8_GAME_STATUS:
   case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_ROOTAFFILIATELIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATECATEGORIES:
   case midw_ext_sxm_sportsfi_tclToken::EN_E8CATEGORYAVAILABILITY:
   case midw_ext_sxm_sportsfi_tclToken::EN_TIMEINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNELTYPE:
   case midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNEL:
   case midw_ext_sxm_sportsfi_tclToken::EN_TEAMINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE:
   case midw_ext_sxm_sportsfi_tclToken::EN_GAMEINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_TEAMLIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_GAMELIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_FAVORITEINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_FAVORITELIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_SPORTSUPDATETYPE:
   case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILS:
   case midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE:
   case midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE_LIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANK:
   case midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANKLIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_NEWSINFO:
   case midw_ext_sxm_sportsfi_tclToken::EN_NEWSLIST:
   case midw_ext_sxm_sportsfi_tclToken::EN_E8SPORTSSERVICEDATASTATUS:
   case midw_ext_sxm_sportsfi_tclToken::EN_U8:   
   case midw_ext_sxm_sportsfi_tclToken::EN_S8:   
   case midw_ext_sxm_sportsfi_tclToken::EN_U16:   
   case midw_ext_sxm_sportsfi_tclToken::EN_S16:   
   case midw_ext_sxm_sportsfi_tclToken::EN_U24:   
   case midw_ext_sxm_sportsfi_tclToken::EN_S24:   
   case midw_ext_sxm_sportsfi_tclToken::EN_U32:   
   case midw_ext_sxm_sportsfi_tclToken::EN_S32:   
   case midw_ext_sxm_sportsfi_tclToken::EN_U64:   
   case midw_ext_sxm_sportsfi_tclToken::EN_S64:   
   case midw_ext_sxm_sportsfi_tclToken::EN_F32:   
   case midw_ext_sxm_sportsfi_tclToken::EN_F64:   
   case midw_ext_sxm_sportsfi_tclToken::EN_BOOL:   
   case midw_ext_sxm_sportsfi_tclToken::EN_STRING:   
   case midw_ext_sxm_sportsfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enMsgToken,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_sxm_sportsfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_sxm_sportsfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_sxm_sportsfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_sxm_sportsfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_sxm_sportsfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_sportsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_sportsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSPORTLISTMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETROOTAFFILIATELISTMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETAFFILIATEDETAILSMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETGAMELISTMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETNEWSDETAILSMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETTOPTEAMSMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETALLTEAMSMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETFAVORITESMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SETASFAVORITEMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETSCHEDULEDEVENTSMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODSTART:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_GETEVENTRANKLISTMETHODRESULT:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSGET:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSSTATUS:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSUPREG:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSSERVICEDATASTATUSRELUPREG:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEGET:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATESTATUS:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATEUPREG:
      case midw_ext_sxm_sportsfi_tclToken::EN_MSG_SPORTSDATAUPDATERELUPREG:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_sxm_sportsfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_SPORTINFO:
      {
      if (poVisitor->bDoExpand_SportInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORTNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_SportInfo o_SportInfo;
         if (!bDoIt(o_SportInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SportInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SportInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_SPORTLIST:
      {
      if (poVisitor->bDoExpand_SportList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_SPORTINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORTLIST));
      }
      else
      {
         midw_ext_fi_tcl_SportList o_SportList;
         if (!bDoIt(o_SportList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SportList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SportList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_E8_GAME_STATUS:
      {
         midw_ext_fi_tcl_e8_Game_Status o_e8_Game_Status;
         if (!bDoIt(o_e8_Game_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO:
      {
      if (poVisitor->bDoExpand_AffiliateInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_INSEASON));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATENAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_ID));
      }
      else
      {
         midw_ext_fi_tcl_AffiliateInfo o_AffiliateInfo;
         if (!bDoIt(o_AffiliateInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_ROOTAFFILIATELIST:
      {
      if (poVisitor->bDoExpand_RootAffiliateList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_ROOTAFFILIATELIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_RootAffiliateList o_RootAffiliateList;
         if (!bDoIt(o_RootAffiliateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RootAffiliateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RootAffiliateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATECATEGORIES:
      {
         midw_ext_fi_tcl_AffiliateCategories o_AffiliateCategories;
         if (!bDoIt(o_AffiliateCategories))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_E8CATEGORYAVAILABILITY:
      {
         midw_ext_fi_tcl_e8CategoryAvailability o_e8CategoryAvailability;
         if (!bDoIt(o_e8CategoryAvailability))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_TIMEINFO:
      {
      if (poVisitor->bDoExpand_TimeInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TIME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_DATE));
      }
      else
      {
         midw_ext_fi_tcl_TimeInfo o_TimeInfo;
         if (!bDoIt(o_TimeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNELTYPE:
      {
         midw_ext_fi_tcl_XMChannelType o_XMChannelType;
         if (!bDoIt(o_XMChannelType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNEL:
      {
      if (poVisitor->bDoExpand_XMChannel(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNELTYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CHANNELTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CHANNELNUMBER));
      }
      else
      {
         midw_ext_fi_tcl_XMChannel o_XMChannel;
         if (!bDoIt(o_XMChannel))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_XMChannel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_XMChannel.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_TEAMINFO:
      {
      if (poVisitor->bDoExpand_TeamInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISFAVORITE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_NICK_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_KNOWN_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_ABBR_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_SCORE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_ID));
      }
      else
      {
         midw_ext_fi_tcl_TeamInfo o_TeamInfo;
         if (!bDoIt(o_TeamInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE:
      {
         midw_ext_fi_tcl_GameType o_GameType;
         if (!bDoIt(o_GameType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_GAMEINFO:
      {
      if (poVisitor->bDoExpand_GameInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAME_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNEL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_XMCHANNELLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_E8_GAME_STATUS,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_EVENTSTATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_WINNING_TEAM_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAME_CLOCK));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAME_STATUS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TIMEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAME_TIME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TEAMINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_VISITING_TEAM_INFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TEAMINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_HOME_TEAM_INFO));
      }
      else
      {
         midw_ext_fi_tcl_GameInfo o_GameInfo;
         if (!bDoIt(o_GameInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GameInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GameInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_TEAMLIST:
      {
      if (poVisitor->bDoExpand_TeamList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TEAMINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAMDETAILS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_TeamList o_TeamList;
         if (!bDoIt(o_TeamList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TeamList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_GAMELIST:
      {
      if (poVisitor->bDoExpand_GameList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAMEINFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LISTINDEX));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAMETYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISFAVORITE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISFUTUREGAMESAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISCURRENTGAMESAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISRECENTGAMESAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_INFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_GameList o_GameList;
         if (!bDoIt(o_GameList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GameList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_FAVORITEINFO:
      {
      if (poVisitor->bDoExpand_FavoriteInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_NICK_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_KNOWN_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_ABBR_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TEAM_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_FavoriteInfo o_FavoriteInfo;
         if (!bDoIt(o_FavoriteInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FavoriteInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FavoriteInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_FAVORITELIST:
      {
      if (poVisitor->bDoExpand_FavoriteList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_FAVORITEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_FAVORITEINFO));
      }
      else
      {
         midw_ext_fi_tcl_FavoriteList o_FavoriteList;
         if (!bDoIt(o_FavoriteList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FavoriteList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FavoriteList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILINFO:
      {
      if (poVisitor->bDoExpand_AffiliateDetailInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SUB_LEAGUE_INFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_E8CATEGORYAVAILABILITY,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_ISDATAAVAILABLE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATECATEGORIES,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CATEGORY_ID));
      }
      else
      {
         midw_ext_fi_tcl_AffiliateDetailInfo o_AffiliateDetailInfo;
         if (!bDoIt(o_AffiliateDetailInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateDetailInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateDetailInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_SPORTSUPDATETYPE:
      {
         midw_ext_fi_tcl_SportsUpdateType o_SportsUpdateType;
         if (!bDoIt(o_SportsUpdateType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILS:
      {
      if (poVisitor->bDoExpand_AffiliateDetails(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEDETAILINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATEDETAILS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_AffiliateDetails o_AffiliateDetails;
         if (!bDoIt(o_AffiliateDetails))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateDetails.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AffiliateDetails.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE:
      {
      if (poVisitor->bDoExpand_EventSchedule(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_EVENT_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_S32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TABLEREF));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_S32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TABLEPARAM));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_ISRANKLISTAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_YARDAGE_LAP));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CARMAKE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_CARNUMBER));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_WINNER));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_PURSE_LAPS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_XMCHANNEL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_XMCHANNELLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_TIMEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_GAME_TIME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_COURSE_TRACK));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_E8_GAME_STATUS,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_EVENTSTATE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_TOURNEY_RACE));
      }
      else
      {
         midw_ext_fi_tcl_EventSchedule o_EventSchedule;
         if (!bDoIt(o_EventSchedule))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventSchedule.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventSchedule.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE_LIST:
      {
      if (poVisitor->bDoExpand_EventSchedule_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_EVENTSCHEDULE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_EVENTLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_GAMETYPE,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_EVENTTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LISTINDEX));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISFUTUREEVENTSAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISCURRENTEVENTSAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_BOOL,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_BISRECENTEVENTSAVL));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_AFFILIATEINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_INFO));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_EventSchedule_List o_EventSchedule_List;
         if (!bDoIt(o_EventSchedule_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventSchedule_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventSchedule_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANK:
      {
      if (poVisitor->bDoExpand_EventRank(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_NUMBER));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SCORE_MAKE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LAPS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_NAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_RANK));
      }
      else
      {
         midw_ext_fi_tcl_EventRank o_EventRank;
         if (!bDoIt(o_EventRank))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventRank.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventRank.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANKLIST:
      {
      if (poVisitor->bDoExpand_EventRankList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_EVENTRANK,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_RANKLIST));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U32,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_AFFILIATE_ID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_U8,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_SPORT_ID));
      }
      else
      {
         midw_ext_fi_tcl_EventRankList o_EventRankList;
         if (!bDoIt(o_EventRankList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventRankList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EventRankList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_NEWSINFO:
      {
      if (poVisitor->bDoExpand_NewsInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_STRING,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_NEWSINDETAIL));
      }
      else
      {
         midw_ext_fi_tcl_NewsInfo o_NewsInfo;
         if (!bDoIt(o_NewsInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NewsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NewsInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_NEWSLIST:
      {
      if (poVisitor->bDoExpand_NewsList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_NEWSINFO,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_sportsfi_tclKnot(midw_ext_sxm_sportsfi_tclToken::EN_LIST,midw_ext_sxm_sportsfi_tclSemanticDomain::EN_NEWSLIST));
      }
      else
      {
         midw_ext_fi_tcl_NewsList o_NewsList;
         if (!bDoIt(o_NewsList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NewsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NewsList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_E8SPORTSSERVICEDATASTATUS:
      {
         midw_ext_fi_tcl_e8SportsServiceDataStatus o_e8SportsServiceDataStatus;
         if (!bDoIt(o_e8SportsServiceDataStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_sportsfi_tclToken::EN_UNKNOWN:
      case midw_ext_sxm_sportsfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

