/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_SAFEVIEWFITYPES_HEADER
#define MIDW_EXT_SXM_SAFEVIEWFITYPES_HEADER


class midw_ext_sxm_safeviewfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_SAFEVIEW_FI message types

fi_tclMessageBase* midw_ext_sxm_safeviewfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_safeviewfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_safeviewfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart : public midw_ext_sxm_safeviewfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& operator=(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& coRef);
   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   tU32 Safeview_LOCID;
   virtual ~midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult : public midw_ext_sxm_safeviewfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& operator=(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& coRef);
   midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_SXMSafeviewLocationAndSubLocationInfoList Safeview_Info_List;
   virtual ~midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_safeviewfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_safeviewfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
