/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SAFEVIEWFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SAFEVIEWFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_SAFEVIEWFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_SAFEVIEW_FI message types

fi_tclMessageBase* midw_ext_sxm_safeviewfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_safeviewfi_tclToken::EN_MSG_GETSAFEVIEWLOCATIONANDSUBLOCATIONINFOLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart;

      case midw_ext_sxm_safeviewfi_tclToken::EN_MSG_GETSAFEVIEWLOCATIONANDSUBLOCATIONINFOLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult;

      case midw_ext_sxm_safeviewfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_safeviewfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_safeviewfifi messages

// common functions

tU16 midw_ext_sxm_safeviewfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_SAFEVIEWFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_safeviewfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_safeviewfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_safeviewfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_safeviewfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_safeviewfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_safeviewfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_safeviewfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& coRef)
   : midw_ext_sxm_safeviewfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Safeview_LOCID = coRef.Safeview_LOCID;
}
midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::operator=(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Safeview_LOCID = coRef.Safeview_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart()
:ListID(0)
,Safeview_LOCID(0)
 {}

tS32 midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_safeviewfi_tclToken::EN_MSG_GETSAFEVIEWLOCATIONANDSUBLOCATIONINFOLISTMETHODSTART;
}


midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::~midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart()
{}

tU32 midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Safeview_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Safeview_LOCID);
   return oOut;
}

tBool midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart::operator==(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Safeview_LOCID == roRef.Safeview_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& coRef)
   : midw_ext_sxm_safeviewfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Safeview_Info_List = coRef.Safeview_Info_List;
}
midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::operator=(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Safeview_Info_List = coRef.Safeview_Info_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::vDestroy()
{
   Safeview_Info_List.vDestroy(); 
}

midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult()
:ListID(0)
,Safeview_Info_List()
 {}

tS32 midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_safeviewfi_tclToken::EN_MSG_GETSAFEVIEWLOCATIONANDSUBLOCATIONINFOLISTMETHODRESULT;
}


midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::~midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Safeview_Info_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Safeview_Info_List);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Safeview_Info_List);
   return oOut;
}

tBool midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult::operator==(const midw_ext_sxm_safeviewfi_tclMsgGetSafeviewLocationandSublocationInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Safeview_Info_List == roRef.Safeview_Info_List);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_safeviewfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_safeviewfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_safeviewfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_safeviewfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_safeviewfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

