/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_PARKINGFITYPES_HEADER
#define MIDW_EXT_SXM_PARKINGFITYPES_HEADER


class midw_ext_sxm_parkingfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_PARKING_FI message types

fi_tclMessageBase* midw_ext_sxm_parkingfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_parkingfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_parkingfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   virtual ~midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   std::vector<midw_ext_fi_tcl_ParkingInfo, std::allocator<midw_ext_fi_tcl_ParkingInfo> > ParkingInfoList;
   virtual ~midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ParkingID;
   tU32 ListID;
   virtual ~midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ParkingInfo ParkingStationInfo;
   tU32 ListID;
   virtual ~midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ParkingID;
   virtual ~midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ParkingID;
   virtual ~midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_FilterConfig FilterConfig;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > FavoriteList;
   virtual ~midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& coRef);
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_FilterConfiguration FilterConfig;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& coRef);
   midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet();

   virtual ~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& operator=(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& coRef);
   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos InfoList;
   virtual ~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg();

   virtual ~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg();

   virtual ~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmListModeSet : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_parkingfi_tclMsgSxmListModeSet(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   tBool DummyData;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus : public midw_ext_sxm_parkingfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   tBool DummyData;
   virtual ~midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
