/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PARKINGFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PARKINGFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_PARKINGFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_PARKING_FI message types

fi_tclMessageBase* midw_ext_sxm_parkingfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGINFOLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGINFOLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGSTATIONINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGSTATIONINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_RESTOREFAVORITESMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_RESTOREFAVORITESMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGURATIONMETHODSTART:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGURATIONMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSGET:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_parkingfifi messages

// common functions

tU16 midw_ext_sxm_parkingfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_PARKINGFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_parkingfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_parkingfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_parkingfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_parkingfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_parkingfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
}
midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart()
:ListID(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGINFOLISTMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::~midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   ParkingInfoList = coRef.ParkingInfoList;
}
midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   ParkingInfoList = coRef.ParkingInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ParkingInfoList.size(); ++u32Idx)
         ParkingInfoList[u32Idx].vDestroy();
   ParkingInfoList.clear();
   }
}

midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult()
:ListID(0)

 {}

tS32 midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGINFOLISTMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::~midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ParkingInfoList.size(); ++u32ListIdx)
      u32DynamicSize += ParkingInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ParkingInfoList.size(); ++u32Idx)
      {
         ParkingInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ParkingInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ParkingInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << (tU32)ParkingInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ParkingInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ParkingInfoList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
      bResult = bResult && (ParkingInfoList.size() == roRef.ParkingInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ParkingInfoList.size()); ++u32Idx)
            bResult = bResult && (ParkingInfoList[u32Idx] == roRef.ParkingInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ParkingID = coRef.ParkingID;
   ListID = coRef.ListID;
}
midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ParkingID = coRef.ParkingID;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart()
:ParkingID(0)
,ListID(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGSTATIONINFOMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::~midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkingID);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkingID);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkingID == roRef.ParkingID);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ParkingStationInfo = coRef.ParkingStationInfo;
   ListID = coRef.ListID;
}
midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ParkingStationInfo = coRef.ParkingStationInfo;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::vDestroy()
{
   ParkingStationInfo.vDestroy(); 
}

midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult()
:ParkingStationInfo()
,ListID(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_GETPARKINGSTATIONINFOMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::~midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+ParkingStationInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkingStationInfo);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkingStationInfo);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkingStationInfo == roRef.ParkingStationInfo);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ParkingID = coRef.ParkingID;
}
midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ParkingID = coRef.ParkingID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart()
:ParkingID(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkingID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkingID);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkingID == roRef.ParkingID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ParkingID = coRef.ParkingID;
}
midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ParkingID = coRef.ParkingID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart()
:ParkingID(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkingID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkingID);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkingID == roRef.ParkingID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   FilterConfig = coRef.FilterConfig;
}
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FilterConfig = coRef.FilterConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart()
:FilterConfig()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FilterConfig);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FilterConfig);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FilterConfig == roRef.FilterConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   FavoriteList = coRef.FavoriteList;
}
midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FavoriteList = coRef.FavoriteList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::vDestroy()
{
   {
   FavoriteList.clear();
   }
}

midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart()

 {}

tS32 midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_RESTOREFAVORITESMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::~midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(FavoriteList.size()*4);
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FavoriteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FavoriteList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FavoriteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FavoriteList.size(); ++u32Idx)
         (tVoid) (oOut << FavoriteList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FavoriteList.size() == roRef.FavoriteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FavoriteList.size()); ++u32Idx)
            bResult = bResult && (FavoriteList[u32Idx] == roRef.FavoriteList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_RESTOREFAVORITESMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::~midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   FilterConfig = coRef.FilterConfig;
}
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FilterConfig = coRef.FilterConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::vDestroy()
{
   FilterConfig.vDestroy(); 
}

midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart()
:FilterConfig()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGURATIONMETHODSTART;
}


midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FilterConfig.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FilterConfig);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FilterConfig);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart::operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FilterConfig == roRef.FilterConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::operator=(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SETFILTERCONFIGURATIONMETHODRESULT;
}


midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::~midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult::operator==(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet::midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSGET;
}


midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet::~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   InfoList = coRef.InfoList;
}
midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::operator=(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   InfoList = coRef.InfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::vDestroy()
{
   InfoList.vDestroy(); 
}

midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus()
:InfoList()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSSTATUS;
}


midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+InfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InfoList);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus::operator==(const midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InfoList == roRef.InfoList);
   return bResult;
}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg::midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSUPREG;
}


midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg::~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg::midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_PARKINGINFOLISTSSTATUSRELUPREG;
}


midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg::~midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::midw_ext_sxm_parkingfi_tclMsgSxmListModeSet(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
   DummyData = coRef.DummyData;
}
midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   DummyData = coRef.DummyData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::midw_ext_sxm_parkingfi_tclMsgSxmListModeSet()
:ListMode()
,DummyData(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::~midw_ext_sxm_parkingfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   (tVoid) (oIn >> DummyData);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   (tVoid) (oOut << DummyData);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_parkingfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   bResult = bResult && (DummyData == roRef.DummyData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_parkingfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
   DummyData = coRef.DummyData;
}
midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   DummyData = coRef.DummyData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus()
:ListMode()
,DummyData(0)
 {}

tS32 midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_parkingfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::~midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   (tVoid) (oIn >> DummyData);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   (tVoid) (oOut << DummyData);
   return oOut;
}

tBool midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   bResult = bResult && (DummyData == roRef.DummyData);
   return bResult;
}

