/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_MOVIESFITYPES_HEADER
#define MIDW_EXT_SXM_MOVIESFITYPES_HEADER


class midw_ext_sxm_moviesfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_MOVIES_FI message types

fi_tclMessageBase* midw_ext_sxm_moviesfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_moviesfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_moviesfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   tU32 MovieID;
   midw_ext_fi_tclString SearchString;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_e8_SxmListOperation Operation;
   midw_ext_fi_tcl_SxmListInfo ListInfo;
   midw_ext_fi_tcl_TheatreInfoList TheatreInfoList;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 THEATRE_LOCID;
   tU32 ListID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_TheatreDetails TheatreInfo;
   tU32 ListID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   tU32 Theater_LOCID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ListID;
   midw_ext_fi_tcl_MoviesList MoviesInfoList;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 MOVIE_ID;
   tU32 ListID;
   tU32 Theater_LOCID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_MovieDetails MovieInfo;
   tU32 ListID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Theater_LOCID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Theater_LOCID;
   virtual ~midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString MovieName;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_MoviesList MoviesList;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& operator=(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& coRef);
   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListsConfig Config;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& operator=(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& coRef);
   midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet();

   virtual ~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& operator=(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& coRef);
   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListInfos TheatreListsStatus;
   virtual ~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg();

   virtual ~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg();

   virtual ~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSrvState DataServiceState;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmListModeSet : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmListModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& operator=(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& coRef);
   midw_ext_sxm_moviesfi_tclMsgSxmListModeSet(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmListModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus : public midw_ext_sxm_moviesfi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& operator=(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& coRef);
   midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmListMode ListMode;
   virtual ~midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
