/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_MOVIESFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_MOVIESFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_MOVIESFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_MOVIES_FI message types

fi_tclMessageBase* midw_ext_sxm_moviesfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATRELISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATRELISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATREINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATREINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIESLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIESLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIEINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SEARCHMOVIEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SEARCHMOVIEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSGET:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_moviesfifi messages

// common functions

tU16 midw_ext_sxm_moviesfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_MOVIESFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_moviesfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_moviesfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_moviesfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_moviesfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_moviesfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   MovieID = coRef.MovieID;
   SearchString = coRef.SearchString;
}
midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   MovieID = coRef.MovieID;
   SearchString = coRef.SearchString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::vDestroy()
{
   SearchString.vDestroy();
}

midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart()
:ListID(0)
,Operation()
,MovieID(0)
,SearchString()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATRELISTMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::~midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+SearchString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> MovieID);
   (tVoid) (oIn >> SearchString);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << MovieID);
   (tVoid) (oOut << SearchString);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (MovieID == roRef.MovieID);
   bResult = bResult && (SearchString == roRef.SearchString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   TheatreInfoList = coRef.TheatreInfoList;
}
midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   TheatreInfoList = coRef.TheatreInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::vDestroy()
{
   ListInfo.vDestroy(); 
   TheatreInfoList.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult()
:ListID(0)
,Operation()
,ListInfo()
,TheatreInfoList()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATRELISTMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::~midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+TheatreInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListInfo);
   (tVoid) (oIn >> TheatreInfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListInfo);
   (tVoid) (oOut << TheatreInfoList);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListInfo == roRef.ListInfo);
   bResult = bResult && (TheatreInfoList == roRef.TheatreInfoList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   THEATRE_LOCID = coRef.THEATRE_LOCID;
   ListID = coRef.ListID;
}
midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   THEATRE_LOCID = coRef.THEATRE_LOCID;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart()
:THEATRE_LOCID(0)
,ListID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATREINFOMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::~midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> THEATRE_LOCID);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << THEATRE_LOCID);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (THEATRE_LOCID == roRef.THEATRE_LOCID);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   TheatreInfo = coRef.TheatreInfo;
   ListID = coRef.ListID;
}
midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TheatreInfo = coRef.TheatreInfo;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::vDestroy()
{
   TheatreInfo.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult()
:TheatreInfo()
,ListID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETTHEATREINFOMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::~midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+TheatreInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TheatreInfo);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TheatreInfo);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgGetTheatreInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TheatreInfo == roRef.TheatreInfo);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Theater_LOCID = coRef.Theater_LOCID;
}
midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Theater_LOCID = coRef.Theater_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart()
:ListID(0)
,Theater_LOCID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIESLISTMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::~midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Theater_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Theater_LOCID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   MoviesInfoList = coRef.MoviesInfoList;
}
midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   MoviesInfoList = coRef.MoviesInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::vDestroy()
{
   MoviesInfoList.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult()
:ListID(0)
,MoviesInfoList()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIESLISTMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::~midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MoviesInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> MoviesInfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << MoviesInfoList);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgGetMoviesListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (MoviesInfoList == roRef.MoviesInfoList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   MOVIE_ID = coRef.MOVIE_ID;
   ListID = coRef.ListID;
   Theater_LOCID = coRef.Theater_LOCID;
}
midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MOVIE_ID = coRef.MOVIE_ID;
   ListID = coRef.ListID;
   Theater_LOCID = coRef.Theater_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart()
:MOVIE_ID(0)
,ListID(0)
,Theater_LOCID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIEINFOMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::~midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MOVIE_ID);
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Theater_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MOVIE_ID);
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Theater_LOCID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MOVIE_ID == roRef.MOVIE_ID);
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   MovieInfo = coRef.MovieInfo;
   ListID = coRef.ListID;
}
midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MovieInfo = coRef.MovieInfo;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::vDestroy()
{
   MovieInfo.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult()
:MovieInfo()
,ListID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_GETMOVIEINFOMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::~midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MovieInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MovieInfo);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MovieInfo);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgGetMovieInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MovieInfo == roRef.MovieInfo);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Theater_LOCID = coRef.Theater_LOCID;
}
midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Theater_LOCID = coRef.Theater_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart()
:Theater_LOCID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Theater_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Theater_LOCID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Theater_LOCID = coRef.Theater_LOCID;
}
midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Theater_LOCID = coRef.Theater_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart()
:Theater_LOCID(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Theater_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Theater_LOCID);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Theater_LOCID == roRef.Theater_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   MovieName = coRef.MovieName;
}
midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MovieName = coRef.MovieName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::vDestroy()
{
   MovieName.vDestroy();
}

midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart()
:MovieName()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SEARCHMOVIEMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::~midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MovieName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MovieName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MovieName);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MovieName == roRef.MovieName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   MoviesList = coRef.MoviesList;
}
midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MoviesList = coRef.MoviesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::vDestroy()
{
   MoviesList.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult()
:MoviesList()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SEARCHMOVIEMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::~midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MoviesList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MoviesList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MoviesList);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgSearchMovieMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MoviesList == roRef.MoviesList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_moviesfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet::midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSGET;
}


midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet::~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   TheatreListsStatus = coRef.TheatreListsStatus;
}
midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::operator=(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TheatreListsStatus = coRef.TheatreListsStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::vDestroy()
{
   TheatreListsStatus.vDestroy(); 
}

midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus()
:TheatreListsStatus()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSSTATUS;
}


midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TheatreListsStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TheatreListsStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TheatreListsStatus);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus::operator==(const midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TheatreListsStatus == roRef.TheatreListsStatus);
   return bResult;
}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg::midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSUPREG;
}


midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg::~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg::midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_THEATRELISTSSTATUSRELUPREG;
}


midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg::~midw_ext_sxm_moviesfi_tclMsgTheatreListsStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_moviesfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::midw_ext_sxm_moviesfi_tclMsgSxmListModeSet(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::midw_ext_sxm_moviesfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::~midw_ext_sxm_moviesfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_moviesfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_moviesfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_moviesfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::~midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_moviesfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

