/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CANADIAN_FUELFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CANADIAN_FUELFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CANADIAN_FUELFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_EXT_SXM_CANADIAN_FUEL_FI message types

fi_tclMessageBase* midw_ext_sxm_canadian_fuelfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODSTART:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODSTART:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSGET:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTGET:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTSTATUS:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTRELUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTGET:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTSTATUS:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTRELUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESET:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet;

      case midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS:
         return OSAL_NEW midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_sxm_canadian_fuelfifi messages

// common functions

tU16 midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   Brand = coRef.Brand;
   CanadianFuelType = coRef.CanadianFuelType;
   SortType = coRef.SortType;
}
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   Brand = coRef.Brand;
   CanadianFuelType = coRef.CanadianFuelType;
   SortType = coRef.SortType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::vDestroy()
{
   Brand.vDestroy();
   CanadianFuelType.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart()
:ListID(0)
,Operation()
,Brand()
,CanadianFuelType()
,SortType()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODSTART;
}


midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Brand.u32GetSize(u16MajorVersion)+CanadianFuelType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> Brand);
   (tVoid) (oIn >> CanadianFuelType);
   (tVoid) (oIn >> SortType);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << Brand);
   (tVoid) (oOut << CanadianFuelType);
   (tVoid) (oOut << SortType);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (Brand == roRef.Brand);
   bResult = bResult && (CanadianFuelType == roRef.CanadianFuelType);
   bResult = bResult && (SortType == roRef.SortType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   CanadianFuelInfoList = coRef.CanadianFuelInfoList;
}
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListID = coRef.ListID;
   Operation = coRef.Operation;
   ListInfo = coRef.ListInfo;
   CanadianFuelInfoList = coRef.CanadianFuelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::vDestroy()
{
   ListInfo.vDestroy(); 
   CanadianFuelInfoList.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult()
:ListID(0)
,Operation()
,ListInfo()
,CanadianFuelInfoList()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELINFOLISTMETHODRESULT;
}


midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 18+CanadianFuelInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListID);
   (tVoid) (oIn >> Operation);
   (tVoid) (oIn >> ListInfo);
   (tVoid) (oIn >> CanadianFuelInfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListID);
   (tVoid) (oOut << Operation);
   (tVoid) (oOut << ListInfo);
   (tVoid) (oOut << CanadianFuelInfoList);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListID == roRef.ListID);
   bResult = bResult && (Operation == roRef.Operation);
   bResult = bResult && (ListInfo == roRef.ListInfo);
   bResult = bResult && (CanadianFuelInfoList == roRef.CanadianFuelInfoList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
   ListID = coRef.ListID;
}
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart()
:CANADIAN_FUEL_LOCID(0)
,ListID(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODSTART;
}


midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CANADIAN_FUEL_LOCID);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CANADIAN_FUEL_LOCID);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CANADIAN_FUEL_LOCID == roRef.CANADIAN_FUEL_LOCID);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   CanadianFuelStationInfo = coRef.CanadianFuelStationInfo;
   ListID = coRef.ListID;
}
midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CanadianFuelStationInfo = coRef.CanadianFuelStationInfo;
   ListID = coRef.ListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::vDestroy()
{
   CanadianFuelStationInfo.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult()
:CanadianFuelStationInfo()
,ListID(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_GETCANADIANFUELSTATIONINFOMETHODRESULT;
}


midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::~midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+CanadianFuelStationInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CanadianFuelStationInfo);
   (tVoid) (oIn >> ListID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CanadianFuelStationInfo);
   (tVoid) (oOut << ListID);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CanadianFuelStationInfo == roRef.CanadianFuelStationInfo);
   bResult = bResult && (ListID == roRef.ListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
}
midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart()
:CANADIAN_FUEL_LOCID(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODSTART;
}


midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::~midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CANADIAN_FUEL_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CANADIAN_FUEL_LOCID);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CANADIAN_FUEL_LOCID == roRef.CANADIAN_FUEL_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_ADDFAVORITEMETHODRESULT;
}


midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::~midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
}
midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CANADIAN_FUEL_LOCID = coRef.CANADIAN_FUEL_LOCID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart()
:CANADIAN_FUEL_LOCID(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODSTART;
}


midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::~midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CANADIAN_FUEL_LOCID);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CANADIAN_FUEL_LOCID);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CANADIAN_FUEL_LOCID == roRef.CANADIAN_FUEL_LOCID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_REMOVEFAVORITEMETHODRESULT;
}


midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::~midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   Config = coRef.Config;
}
midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Config = coRef.Config;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart()
:Config()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODSTART;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::~midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Config);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Config);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Config == roRef.Config);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult()
:Status(0)
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SETLISTSCONFIGMETHODRESULT;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::~midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSGET;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   InfoList = coRef.InfoList;
}
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   InfoList = coRef.InfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::vDestroy()
{
   InfoList.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus()
:InfoList()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSSTATUS;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+InfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InfoList);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InfoList);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InfoList == roRef.InfoList);
   return bResult;
}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELINFOLISTSSTATUSRELUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusRelUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTGET;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   BrandName = coRef.BrandName;
}
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& coRef)
{
   if (this == &coRef) return *this;
   BrandName = coRef.BrandName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::vDestroy()
{
   BrandName.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus()
:BrandName()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTSTATUS;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+BrandName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BrandName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BrandName);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BrandName == roRef.BrandName);
   return bResult;
}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELBRANDNAMELISTRELUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListRelUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTGET;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   TypeName = coRef.TypeName;
}
midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& coRef)
{
   if (this == &coRef) return *this;
   TypeName = coRef.TypeName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::vDestroy()
{
   TypeName.vDestroy(); 
}

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus()
:TypeName()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTSTATUS;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TypeName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TypeName);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TypeName);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TypeName == roRef.TypeName);
   return bResult;
}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_CANADIANFUELTYPELISTRELUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListRelUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet::midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSGET;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   DataServiceState = coRef.DataServiceState;
}
midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataServiceState = coRef.DataServiceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus()
:DataServiceState()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSSTATUS;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataServiceState);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataServiceState);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataServiceState == roRef.DataServiceState);
   return bResult;
}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusUpReg()
{}

//=============================================================================

midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMDATASERVICESTATUSRELUPREG;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet()
:ListMode()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESET;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& coRef)
   : midw_ext_sxm_canadian_fuelfi_tclMsgBaseMessage(coRef)
{
   ListMode = coRef.ListMode;
}
midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::operator=(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& coRef)
{
   if (this == &coRef) return *this;
   ListMode = coRef.ListMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus()
:ListMode()
 {}

tS32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_sxm_canadian_fuelfi_tclToken::EN_MSG_SXMLISTMODESTATUS;
}


midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::~midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus()
{}

tU32 midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListMode);
   return oIn;
}

fi_tclOutContext& midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListMode);
   return oOut;
}

tBool midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus::operator==(const midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListMode == roRef.ListMode);
   return bResult;
}

