/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_SXM_AUDIOFITYPES_HEADER
#define MIDW_EXT_SXM_AUDIOFITYPES_HEADER


class midw_ext_sxm_audiofi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_SXM_AUDIO_FI message types

fi_tclMessageBase* midw_ext_sxm_audiofi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_sxm_audiofi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_sxm_audiofi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Index;
   tU16 Range;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_ChannelListEntry, std::allocator<midw_ext_fi_tcl_ChannelListEntry> > ChannelList;
   tU16 NextIndex;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CategoryType;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_CategoryListEntry, std::allocator<midw_ext_fi_tcl_CategoryListEntry> > CategoryList;
   tU16 CategoryType;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SelectChannelMode SelectionMode;
   tU16 CidOrSid;
   tU16 CategoryType;
   tU8 Steps;
   virtual ~midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SelectChannelMode SelectionMode;
   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SelectChannelMode SelectionMode;
   tU16 CidOrSid;
   tU16 CategoryType;
   tU8 Steps;
   tU16 DwellTime;
   virtual ~midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetElement;
   virtual ~midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetElement;
   std::vector<midw_ext_fi_tcl_SmartFavoritePreset, std::allocator<midw_ext_fi_tcl_SmartFavoritePreset> > SmartFavoriteList;
   tBool Status;
   midw_ext_fi_tcl_PresetListEntry PresetListElement;
   virtual ~midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetElement;
   virtual ~midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetElement;
   tBool Status;
   midw_ext_fi_tcl_PresetListEntry PresetListElement;
   virtual ~midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FirstElement;
   tU8 u8LastElement;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32Latitude;
   tS32 s32Longitude;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnable;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GetVal;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString UpcLid0;
   midw_ext_fi_tclString UpcLid1;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   midw_ext_fi_tclString Market;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_MarketListEntry Market;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 BulletinID;
   midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction Action;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   midw_ext_fi_tcl_e8_TWNow_Bulletin_PlayBackAction Action;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 BulletinID;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_MarketList Markets;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 tU8Request;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString File;
   midw_ext_fi_tclString Version;
   tBool bForced;
   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SxmFirmwareDownloadResult enResult;
   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SxmExtDiagMode Mode;
   virtual ~midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult();

   virtual ~midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_IRPlaybackMode u8IRPlaybackMode;
   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_IRPlaybackMode u8IRPlaybackMode;
   midw_ext_fi_tcl_e8_IRPlaybackStatus u8IRPlaybackState;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnableTuneStart;
   virtual ~midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_MethodStatus Status;
   tBool bEnableTuneStart;
   virtual ~midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SFOperation Operation;
   tU8 ListIndex;
   virtual ~midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SFOperation Operation;
   std::vector<midw_ext_fi_tcl_SFListElement, std::allocator<midw_ext_fi_tcl_SFListElement> > SmartFavoriteList;
   tBool EnableAddPreset;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsMuteActive;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsMuteActive;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TuneScanMode TuneScanMode;
   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PresetBand;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PresetChannelList PresetChannels;
   midw_ext_fi_tcl_e8_MethodStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool LockStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_ChannelSkipType SkipChannelType;
   tU16 ServiceID;
   tU16 ChannelID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSkipChannelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServiceID;
   tU16 ChannelID;
   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   tU8 MaxFavoriteCount;
   virtual ~midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString ContentName;
   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   tU8 FavoriteCount;
   midw_ext_fi_tcl_e8_FavoriteStatus Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_RegisteredFavorite, std::allocator<midw_ext_fi_tcl_RegisteredFavorite> > RegisteredFavoriteList;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   midw_ext_fi_tcl_e8_Action Action;
   midw_ext_fi_tclString ContentName;
   virtual ~midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   midw_ext_fi_tcl_e8_Action Action;
   midw_ext_fi_tclString ContentName;
   virtual ~midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_AlertInfo, std::allocator<midw_ext_fi_tcl_AlertInfo> > AlertInfoList;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Enable;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_Sport SportType;
   tU8 LeagueID;
   tU16 TeamID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_Sport SportType;
   tU8 LeagueID;
   tU16 TeamID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_FavoriteTeam, std::allocator<midw_ext_fi_tcl_SportsFlash_FavoriteTeam> > FavouritesList;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_Game, std::allocator<midw_ext_fi_tcl_SportsFlash_Game> > Games;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > ChannelIDs;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_FlashEvent, std::allocator<midw_ext_fi_tcl_SportsFlash_FlashEvent> > FlashEvents;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FlashEventID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FlashEventID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_League, std::allocator<midw_ext_fi_tcl_SportsFlash_League> > Leagues;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_Sport SportType;
   tU8 LeagueID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_Team, std::allocator<midw_ext_fi_tcl_SportsFlash_Team> > Teams;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SportsFlash_MonitorTeam, std::allocator<midw_ext_fi_tcl_SportsFlash_MonitorTeam> > FavoriteTeams;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > SIDList;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_ChannelInformation, std::allocator<midw_ext_fi_tcl_ChannelInformation> > ChannelInfoList;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Latitude;
   tS32 Longitude;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CategoryID;
   midw_ext_fi_tcl_b16_CHANNEL_EVENT ChannelEvents;
   tBool MonitorBrowsableChannels;
   tBool EnableMonitoring;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_BrowseDirection Direction;
   midw_ext_fi_tcl_BrowseChannelConfig Config;
   tU16 CategoryID;
   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ChannelID;
   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ProfileAction ProfileAction;
   midw_ext_fi_tcl_ProfileStatus ProfileStatus;
   tU8 SourceID;
   tU8 DestinationID;
   virtual ~midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ProfileResponse ProfileResponse;
   virtual ~midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart();

   virtual ~midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_PresetsConfiguration PresetsConfiguration;
   virtual ~midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& operator=(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& coRef);
   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_PresetEntry, std::allocator<midw_ext_fi_tcl_PresetEntry> > PresetEntry;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& operator=(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& coRef);
   midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelInformationGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelInformationGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelInformationGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelInformationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelInformationStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelInformationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& operator=(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgChannelInformationStatus(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ChannelInformation ChannelInformation;
   virtual ~midw_ext_sxm_audiofi_tclMsgChannelInformationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelInformationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelInformationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelInformationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAutoCompareGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAutoCompareGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgAutoCompareGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAutoCompareGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAutoCompareStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAutoCompareStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& operator=(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgAutoCompareStatus(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CurrentTunerElemNr;
   tU8 TunerElemNr;
   std::vector<midw_ext_fi_tcl_SmartFavoritePreset, std::allocator<midw_ext_fi_tcl_SmartFavoritePreset> > SmartFavoriteList;
   virtual ~midw_ext_sxm_audiofi_tclMsgAutoCompareStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgAutoCompareStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAutoCompareUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAutoCompareRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSystemMessageGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSystemMessageGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSystemMessageGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSystemMessageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSystemMessageStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSystemMessageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSystemMessageStatus(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SystemMessage SystemErrorType;
   tU16 CID;
   virtual ~midw_ext_sxm_audiofi_tclMsgSystemMessageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSystemMessageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSystemMessageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSystemMessageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelListStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelListStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelListStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelListStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Availability;
   virtual ~midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelListStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgChannelListStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& operator=(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SID;
   tBool Avail;
   tU32 RgbDataLen;
   std::vector<tU8, std::allocator<tU8> > RgbData;
   virtual ~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCurrentChannelGraphicRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Availability;
   tBool CategoryListContentUpdate;
   virtual ~midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgCategoryListStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_InstantReplayStatus InstantReplayStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& operator=(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsIRModeActive;
   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgInstantReplayModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TuneScanStatus TuneScanStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& operator=(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PresetIndex;
   tU32 PresetBand;
   midw_ext_fi_tcl_PresetListEntry ChannelInfo;
   tU32 LinearPresetIndex;
   virtual ~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_SxmListElemDataSrvState, std::allocator<midw_ext_fi_tcl_SxmListElemDataSrvState> > List;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsAntennaConnected;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& operator=(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ListUpdate;
   virtual ~midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgPresetListUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& operator=(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDiagTestModeData Data;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagTestModeDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& operator=(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmVersionInfo Data;
   virtual ~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgDiagSxmVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Sxm_SignalQuality SignalQualityStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_Sxm_AntennaState AntennaStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString RadioId;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmRadioIdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmSmsDbInfo Data;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmAudioSubInfo Data;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_SxmDataSubStatus Data;
   virtual ~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& operator=(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActive;
   tU8 Progress;
   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& operator=(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_AlertInfo AlertInfo;
   virtual ~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& operator=(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FavoriteType FavoriteType;
   tBool UpdateAvailable;
   virtual ~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FlashServiceStatus ServiceStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_TWNow_Bulletin_Status BulletinStatus;
   tU32 BulletinID;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetClockParamsSet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetClockParamsSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& operator=(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& coRef);
   midw_ext_sxm_audiofi_tclMsgSetClockParamsSet(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString TimeZone;
   tBool DST;
   midw_ext_fi_tcl_LocalTimeDate LocalTimeDate;
   tBool Result;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetClockParamsSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString TimeZone;
   tBool DST;
   midw_ext_fi_tcl_LocalTimeDate LocalTimeDate;
   tBool Result;
   virtual ~midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSetClockParamsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FlashServiceStatus ServiceStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_SportsFlash_ProgramStatus ProgramStatus;
   midw_ext_fi_tcl_SportsFlash_Game GameInfo;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FlashEventID;
   midw_ext_fi_tcl_SportsFlash_Game GameInfo;
   midw_ext_fi_tcl_e8_SportsFlash_FlashEventStatus FlashEventStatus;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FlashEventPlaybackStatus FlashEventPlayState;
   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& operator=(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_FlashEventPlaybackStatus FlashEventPlayState;
   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet();

   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& operator=(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& coRef);
   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_ChannelInformation ChannelInfo;
   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg : public midw_ext_sxm_audiofi_tclMsgBaseMessage
{
public:

   midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg();

   virtual ~midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg();

   inline tBool operator==(const midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
