#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AGWFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_sxm_agwfi_tclDescription::bInitMessage(midw_ext_sxm_agwfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_sxm_agwfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_sxm_agwfi_tclToken::EN_LIST:
   case midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_sxm_agwfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORIES)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_SHAREDMEMORIES)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_SHAPES)) && bResult;
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
      }
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_SHAPES)) && bResult;
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
      }
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_SHAPES)) && bResult;
      if (1 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
      }
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_TILETYPE)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYTILE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_TILELIST)) && bResult;
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
      }
      if (2 <= poOutContext->u16GetMajorVersion())
      {
         bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_BOOL,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_ACCESSGRANTED)) && bResult;
      }
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_TILETYPE)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_TILETYPE)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATASTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MSG_UPDATECOUNTER)) && bResult;
   } break;
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATARELUPREG:
   case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAGET:
   case midw_ext_sxm_agwfi_tclToken::EN_RESERVED:
   case midw_ext_sxm_agwfi_tclToken::EN_S32_FOOT:
   case midw_ext_sxm_agwfi_tclToken::EN_S32_MILLISECOND:
   case midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME:
   case midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT:
   case midw_ext_sxm_agwfi_tclToken::EN_S32_PASCAL:
   case midw_ext_sxm_agwfi_tclToken::EN_S32_LONGITUDE:
   case midw_ext_sxm_agwfi_tclToken::EN_S32_LATITUDE:
   case midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84:
   case midw_ext_sxm_agwfi_tclToken::EN_S16_DEGREE:
   case midw_ext_sxm_agwfi_tclToken::EN_BINCONTAINER:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMSHAPETYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILEDATATYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYTILE:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPE:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPEUNION0:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_FRONTTYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_PRESSURETYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEISOBAR:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_STORMPOSITIONTYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_E8_STORMTYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_B8_STORMTYPE:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEFRONT:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION:
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMTRACK:
   case midw_ext_sxm_agwfi_tclToken::EN_U8:   
   case midw_ext_sxm_agwfi_tclToken::EN_S8:   
   case midw_ext_sxm_agwfi_tclToken::EN_U16:   
   case midw_ext_sxm_agwfi_tclToken::EN_S16:   
   case midw_ext_sxm_agwfi_tclToken::EN_U24:   
   case midw_ext_sxm_agwfi_tclToken::EN_S24:   
   case midw_ext_sxm_agwfi_tclToken::EN_U32:   
   case midw_ext_sxm_agwfi_tclToken::EN_S32:   
   case midw_ext_sxm_agwfi_tclToken::EN_U64:   
   case midw_ext_sxm_agwfi_tclToken::EN_S64:   
   case midw_ext_sxm_agwfi_tclToken::EN_F32:   
   case midw_ext_sxm_agwfi_tclToken::EN_F64:   
   case midw_ext_sxm_agwfi_tclToken::EN_BOOL:   
   case midw_ext_sxm_agwfi_tclToken::EN_STRING:   
   case midw_ext_sxm_agwfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(enMsgToken,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_sxm_agwfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_sxm_agwfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_sxm_agwfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_sxm_agwfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_sxm_agwfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_sxm_agwfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_sxm_agwfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_agwfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_sxm_agwfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSURFACEDATAMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMATTRIBUTESDATAMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_GETSTORMTRACKDATAMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_ACQUIREACCESSTOSHAREDMEMORYMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODSTART:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_RELEASEACCESSFROMSHAREDMEMORYMETHODRESULT:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_NOWRADDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDMAGNITUDEDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDIRECTIONDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_SURFACEDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMATTRIBUTESDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_STORMTRACKDATASTATUS:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATARELUPREG:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATAGET:
      case midw_ext_sxm_agwfi_tclToken::EN_MSG_WINDDATASTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_sxm_agwfi_tclToken::EN_RESERVED:
      {
      (tVoid) oCallStack.bGoUp();
      (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32_FOOT:
      {
         midw_ext_fi_tcl_s32_Foot o_s32_Foot;
         if (!bDoIt(o_s32_Foot))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32_MILLISECOND:
      {
         midw_ext_fi_tcl_s32_MilliSecond o_s32_MilliSecond;
         if (!bDoIt(o_s32_MilliSecond))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME:
      {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         midw_ext_fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT:
      {
         midw_ext_fi_tcl_s16_Knot o_s16_Knot;
         if (!bDoIt(o_s16_Knot))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32_PASCAL:
      {
         midw_ext_fi_tcl_s32_Pascal o_s32_Pascal;
         if (!bDoIt(o_s32_Pascal))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32_LONGITUDE:
      {
         midw_ext_fi_tcl_s32_Longitude o_s32_Longitude;
         if (!bDoIt(o_s32_Longitude))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S32_LATITUDE:
      {
         midw_ext_fi_tcl_s32_Latitude o_s32_Latitude;
         if (!bDoIt(o_s32_Latitude))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84:
      {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_LATITUDE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LATITUDE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_LONGITUDE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         midw_ext_fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_S16_DEGREE:
      {
         midw_ext_fi_tcl_s16_Degree o_s16_Degree;
         if (!bDoIt(o_s16_Degree))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U8,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE:
      {
         midw_ext_fi_tcl_e8_SXMTileType o_e8_SXMTileType;
         if (!bDoIt(o_e8_SXMTileType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMSHAPETYPE:
      {
         midw_ext_fi_tcl_e8_SXMShapeType o_e8_SXMShapeType;
         if (!bDoIt(o_e8_SXMShapeType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILEDATATYPE:
      {
         midw_ext_fi_tcl_e8_SXMTileDataType o_e8_SXMTileDataType;
         if (!bDoIt(o_e8_SXMTileDataType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYDESCRIPTION:
      {
      if (poVisitor->bDoExpand_SXMSharedMemoryDescription(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_MILLISECOND,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TIMEOUT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAREDMEMORYSIZE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAREDMEMORYNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILEDATATYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TILEDATATYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMTILETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TILETYPE));
      }
      else
      {
         midw_ext_fi_tcl_SXMSharedMemoryDescription o_SXMSharedMemoryDescription;
         if (!bDoIt(o_SXMSharedMemoryDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAREDMEMORYTILE:
      {
      if (poVisitor->bDoExpand_SXMSharedMemoryTile(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TILESIZE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ADDRESSOFFSET));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PIXELVALUEPRECISION));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PIXELVALUEOFFSET));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_HEIGHT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U32,midw_ext_sxm_agwfi_tclSemanticDomain::EN_WIDTH));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LOWERRIGHTCORNER));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UPPERLEFTCORNER));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMSharedMemoryTile o_SXMSharedMemoryTile;
         if (!bDoIt(o_SXMSharedMemoryTile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMSharedMemoryTile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
   case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPEUNION0:
   {
      (tVoid) oPath.bGoUp();
      (tVoid) oCallStack.bGoUp();
      midw_ext_fi_tcl_e8_SXMShapeType oDataType;
      oCallStack.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_SXMSHAPETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      (tVoid) bDoIt(oDataType);
      (tVoid) oCallStack.bGoUp();
      if ((oDataType.enType == midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMTRACK) &&
          !(2 <= u16MajorVersion))
      {
         oDataType.enType = midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEWINDRADIUS) &&
          !(u16MajorVersion <= 1))
      {
         oDataType.enType = midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMPOSITION) &&
          !(u16MajorVersion <= 1))
      {
         oDataType.enType = midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_RESERVED:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_RESERVED,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEFRONT:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEFRONT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEPRESSURECENTER:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEISOBAR:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEISOBAR,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMPOSITION:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPEWINDRADIUS:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMATTRIBUTES:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      case midw_ext_fi_tcl_e8_SXMShapeType::FI_EN_T_SXMSHAPETYPESTORMTRACK:
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMTRACK,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
         break;
      }
   } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPE:
      {
      if (poVisitor->bDoExpand_SXMShape(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPEUNION0,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SHAPETYPE));
      }
      else
      {
         midw_ext_fi_tcl_SXMShape o_SXMShape;
         if (!bDoIt(o_SXMShape))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShape.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_FRONTTYPE:
      {
         midw_ext_fi_tcl_e8_FrontType o_e8_FrontType;
         if (!bDoIt(o_e8_FrontType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_PRESSURETYPE:
      {
         midw_ext_fi_tcl_e8_PressureType o_e8_PressureType;
         if (!bDoIt(o_e8_PressureType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEISOBAR:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeIsobar(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINTS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_PASCAL,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PRESSURE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeIsobar o_SXMShapeTypeIsobar;
         if (!bDoIt(o_SXMShapeTypeIsobar))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeIsobar.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeWindRadius(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINTS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_WINDSPEED));
         if (u16MajorVersion <= 1)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U16,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SEQUENCEID));
         }
         if (u16MajorVersion <= 1)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMUNIQUEID));
         }
         if (u16MajorVersion <= 1)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
         }
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeWindRadius o_SXMShapeTypeWindRadius;
         if (!bDoIt(o_SXMShapeTypeWindRadius))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeWindRadius.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_STORMPOSITIONTYPE:
      {
         midw_ext_fi_tcl_e8_StormPositionType o_e8_StormPositionType;
         if (!bDoIt(o_e8_StormPositionType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_E8_STORMTYPE:
      {
         midw_ext_fi_tcl_e8_StormType o_e8_StormType;
         if (!bDoIt(o_e8_StormType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_B8_STORMTYPE:
      {
         midw_ext_fi_tcl_b8_StormType o_b8_StormType;
         if (!bDoIt(o_b8_StormType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMATTRIBUTES:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeStormAttributes(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_B8_STORMTYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MOVEMENTSPEED));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_DEGREE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MOVEMENTDIRECTION));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_FOOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ECHOTOPHEIGHT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_OBSERVATIONTIME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMUNIQUEID));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeStormAttributes o_SXMShapeTypeStormAttributes;
         if (!bDoIt(o_SXMShapeTypeStormAttributes))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormAttributes.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEFRONT:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeFront(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINTS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_FRONTTYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_FRONTTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeFront o_SXMShapeTypeFront;
         if (!bDoIt(o_SXMShapeTypeFront))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeFront.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEPRESSURECENTER:
      {
      if (poVisitor->bDoExpand_SXMShapeTypePressureCenter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_PASCAL,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PRESSURE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_PRESSURETYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PRESSURETYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypePressureCenter o_SXMShapeTypePressureCenter;
         if (!bDoIt(o_SXMShapeTypePressureCenter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypePressureCenter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeStormPosition(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         if (2 <= u16MajorVersion)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPEWINDRADIUS,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_WINDRADII));
         }
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSITIONWGS84,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GEOPOINT));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_STORMTYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_TIMESTAMP));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S32_PASCAL,midw_ext_sxm_agwfi_tclSemanticDomain::EN_PRESSURE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_GUSTS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_MAXSUSTAINEDWINDS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_KNOT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SPEED));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_S16_DEGREE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_DIRECTION));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_E8_STORMPOSITIONTYPE,midw_ext_sxm_agwfi_tclSemanticDomain::EN_POSITIONTYPE));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_U16,midw_ext_sxm_agwfi_tclSemanticDomain::EN_SEQUENCEID));
         if (u16MajorVersion <= 1)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMNAME));
         }
         if (u16MajorVersion <= 1)
         {
            (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMUNIQUEID));
         }
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_POSIXTIME,midw_ext_sxm_agwfi_tclSemanticDomain::EN_ISSUETIME));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeStormPosition o_SXMShapeTypeStormPosition;
         if (!bDoIt(o_SXMShapeTypeStormPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMTRACK:
      {
      if (poVisitor->bDoExpand_SXMShapeTypeStormTrack(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_END_OF_STRUCT,midw_ext_sxm_agwfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_SXMSHAPETYPESTORMPOSITION,midw_ext_sxm_agwfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_LIST,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMPOSITIONS));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMNAME));
         (tVoid) oPath.bGoDown(midw_ext_sxm_agwfi_tclKnot(midw_ext_sxm_agwfi_tclToken::EN_STRING,midw_ext_sxm_agwfi_tclSemanticDomain::EN_STORMUNIQUEID));
      }
      else
      {
         midw_ext_fi_tcl_SXMShapeTypeStormTrack o_SXMShapeTypeStormTrack;
         if (!bDoIt(o_SXMShapeTypeStormTrack))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SXMShapeTypeStormTrack.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_sxm_agwfi_tclToken::EN_UNKNOWN:
      case midw_ext_sxm_agwfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

